/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.tool;

import com.bokesoft.yes.parser.Item;
import com.bokesoft.yes.parser.Rule;
import com.bokesoft.yes.parser.SyntaxTree;
import com.bokesoft.yes.tool.FormulaFormat;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;

public class FormulaDeparserWithFormat {
    public static final FormulaDeparserWithFormat instance = new FormulaDeparserWithFormat();

    public static String deParse(SyntaxTree syntaxTree, String orgFormulaString) {
        FormulaFormat format = FormulaFormat.parse(orgFormulaString, syntaxTree);
        StringBuilder sb = new StringBuilder(128);
        return instance.deParse(syntaxTree.getRoot(), sb, format).append(format.getLastFormat()).toString();
    }

    public static String deParse(Item item, FormulaFormat format) {
        StringBuilder sb = new StringBuilder(128);
        return instance.deParse(item, sb, format).toString();
    }

    public StringBuilder deParse(Item item, StringBuilder sb, FormulaFormat format) {
        Rule rule = item.getRule();
        if (rule != null) {
            int ruleIndex = rule.getIndex();
            switch (ruleIndex) {
                case 0: {
                    return this.deParse0Statement(item, sb, format);
                }
                case 1: {
                    return this.deParse1Statements(item, sb, format);
                }
                case 2: {
                    return this.deParse2Addition(item, sb, format);
                }
                case 3: {
                    return this.deparse3Subtraction(item, sb, format);
                }
                case 4: {
                    return this.deParse4Multiplication(item, sb, format);
                }
                case 5: {
                    return this.deParse5Division(item, sb, format);
                }
                case 6: {
                    return this.deParse6Concat(item, sb, format);
                }
                case 7: {
                    return this.deParse7Parenthesis(item, sb, format);
                }
                case 8: {
                    return this.deParse8Not(item, sb, format);
                }
                case 9: {
                    return this.deParse9Or(item, sb, format);
                }
                case 10: {
                    return this.deParse10And(item, sb, format);
                }
                case 11: {
                    return this.deParse11EqualsTo(item, sb, format);
                }
                case 12: {
                    return this.deParse12NotEqualsTo(item, sb, format);
                }
                case 13: {
                    return this.deParse13GreaterThan(item, sb, format);
                }
                case 14: {
                    return this.deParse14GreaterThanEquals(item, sb, format);
                }
                case 15: {
                    return this.deParse15MinorThan(item, sb, format);
                }
                case 16: {
                    return this.deParse16MinorThanEquals(item, sb, format);
                }
                case 17: {
                    return this.deParse17Const(item, sb, format);
                }
                case 18: {
                    return this.deParse18ID(item, sb, format);
                }
                case 19: {
                    return this.deParse19Function(item, sb, format);
                }
                case 20: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 21: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 22: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 23: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 24: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 25: {
                    return this.deParse25Var(item, sb, format);
                }
                case 26: {
                    return this.deParse26IfHead(item, sb, format);
                }
                case 27: {
                    return this.deParse27IfElse(item, sb, format);
                }
                case 28: {
                    return this.deParse26IfHead(item, sb, format);
                }
                case 29: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 30: {
                    return this.deParse30While(item, sb, format);
                }
                case 31: {
                    return this.deParse31SetValue(item, sb, format);
                }
                case 32: {
                    return this.deParse32Return(item, sb, format);
                }
                case 33: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 34: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 35: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 36: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 37: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 38: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 39: {
                    throw new NotImplementedException("Code is not implemented");
                }
            }
        }
        throw new NotImplementedException("Code is not implemented");
    }

    protected StringBuilder deParse0Statement(Item factor, StringBuilder sb, FormulaFormat format) {
        return this.deParse(factor.getFactor(0), sb, format);
    }

    protected StringBuilder deParse1Statements(Item factor, StringBuilder sb, FormulaFormat format) {
        this.deParse(factor.getFactor(0), sb, format);
        int i = 2;
        int size = factor.getChildCount();
        while (i < size) {
            Item semicolon = factor.getFactor(i - 1);
            String fullLexValue = semicolon.getFullLexValue();
            if (StringUtils.isBlank((CharSequence)fullLexValue)) {
                sb.append(format.getPreFormat(semicolon)).append(";");
            }
            this.deParse(factor.getFactor(i), sb, format);
            i += 2;
        }
        return sb;
    }

    protected StringBuilder deParse2Addition(Item factor, StringBuilder sb, FormulaFormat format) {
        this.deParse(factor.getFactor(0), sb, format).append(format.getPreFormat(factor.getFactor(1))).append("+");
        return this.deParse(factor.getFactor(2), sb, format);
    }

    protected StringBuilder deparse3Subtraction(Item factor, StringBuilder sb, FormulaFormat format) {
        this.deParse(factor.getFactor(0), sb, format).append(format.getPreFormat(factor.getFactor(1))).append("-");
        return this.deParse(factor.getFactor(2), sb, format);
    }

    protected StringBuilder deParse4Multiplication(Item factor, StringBuilder sb, FormulaFormat format) {
        this.deParse(factor.getFactor(0), sb, format).append(format.getPreFormat(factor.getFactor(1))).append("*");
        return this.deParse(factor.getFactor(2), sb, format);
    }

    protected StringBuilder deParse5Division(Item factor, StringBuilder sb, FormulaFormat format) {
        this.deParse(factor.getFactor(0), sb, format).append(format.getPreFormat(factor.getFactor(1))).append("/");
        return this.deParse(factor.getFactor(2), sb, format);
    }

    protected StringBuilder deParse6Concat(Item factor, StringBuilder sb, FormulaFormat format) {
        this.deParse(factor.getFactor(0), sb, format).append(format.getPreFormat(factor.getFactor(1))).append("&");
        return this.deParse(factor.getFactor(2), sb, format);
    }

    protected StringBuilder deParse7Parenthesis(Item factor, StringBuilder sb, FormulaFormat format) {
        sb.append(format.getPreFormat(factor.getFactor(0))).append("(");
        this.deParse(factor.getFactor(1), sb, format);
        return sb.append(format.getPreFormat(factor.getFactor(2))).append(")");
    }

    protected StringBuilder deParse8Not(Item factor, StringBuilder sb, FormulaFormat format) {
        sb.append(format.getPreFormat(factor.getFactor(0))).append("!");
        return this.deParse(factor.getFactor(1), sb, format);
    }

    protected StringBuilder deParse9Or(Item factor, StringBuilder sb, FormulaFormat format) {
        this.deParse(factor.getFactor(0), sb, format).append(format.getPreFormat(factor.getFactor(1))).append("||");
        return this.deParse(factor.getFactor(2), sb, format);
    }

    protected StringBuilder deParse10And(Item factor, StringBuilder sb, FormulaFormat format) {
        this.deParse(factor.getFactor(0), sb, format).append(format.getPreFormat(factor.getFactor(1))).append("&&");
        return this.deParse(factor.getFactor(2), sb, format);
    }

    protected StringBuilder deParse11EqualsTo(Item factor, StringBuilder sb, FormulaFormat format) {
        this.deParse(factor.getFactor(0), sb, format).append(format.getPreFormat(factor.getFactor(1))).append("==");
        return this.deParse(factor.getFactor(2), sb, format);
    }

    protected StringBuilder deParse12NotEqualsTo(Item factor, StringBuilder sb, FormulaFormat format) {
        this.deParse(factor.getFactor(0), sb, format).append(format.getPreFormat(factor.getFactor(1))).append(format.getOrgText(factor.getFactor(1)));
        return this.deParse(factor.getFactor(2), sb, format);
    }

    protected StringBuilder deParse13GreaterThan(Item factor, StringBuilder sb, FormulaFormat format) {
        this.deParse(factor.getFactor(0), sb, format).append(format.getPreFormat(factor.getFactor(1))).append(">");
        return this.deParse(factor.getFactor(2), sb, format);
    }

    protected StringBuilder deParse14GreaterThanEquals(Item factor, StringBuilder sb, FormulaFormat format) {
        this.deParse(factor.getFactor(0), sb, format).append(format.getPreFormat(factor.getFactor(1))).append(">=");
        return this.deParse(factor.getFactor(2), sb, format);
    }

    protected StringBuilder deParse15MinorThan(Item factor, StringBuilder sb, FormulaFormat format) {
        this.deParse(factor.getFactor(0), sb, format).append(format.getPreFormat(factor.getFactor(1))).append("<");
        return this.deParse(factor.getFactor(2), sb, format);
    }

    protected StringBuilder deParse16MinorThanEquals(Item factor, StringBuilder sb, FormulaFormat format) {
        this.deParse(factor.getFactor(0), sb, format).append(format.getPreFormat(factor.getFactor(1))).append("<=");
        return this.deParse(factor.getFactor(2), sb, format);
    }

    protected StringBuilder deParse17Const(Item factor, StringBuilder sb, FormulaFormat format) {
        return sb.append(format.getPreFormat(factor.getFactor(0))).append(format.getOrgText(factor.getFactor(0)));
    }

    protected StringBuilder deParse18ID(Item factor, StringBuilder sb, FormulaFormat format) {
        return sb.append(format.getPreFormat(factor.getFactor(0))).append(factor.getFactor(0).getFullLexValue());
    }

    protected StringBuilder deParse19Function(Item factor, StringBuilder sb, FormulaFormat format) {
        sb.append(format.getPreFormat(factor.getFactor(0))).append(factor.getFactor(0).getFullLexValue()).append(format.getPreFormat(factor.getFactor(1))).append("(");
        int size = factor.getChildCount();
        if (size >= 4) {
            this.deParse(factor.getFactor(2), sb, format);
        }
        int i = 4;
        while (i < size) {
            sb.append(format.getPreFormat(factor.getFactor(i - 1))).append(",");
            this.deParse(factor.getFactor(i), sb, format);
            i += 2;
        }
        return sb.append(format.getPreFormat(factor.getFactor(size - 1))).append(")");
    }

    protected StringBuilder deParse25Var(Item factor, StringBuilder sb, FormulaFormat format) {
        sb.append(format.getPreFormat(factor.getFactor(0))).append(factor.getFactor(0).getFullLexValue());
        sb.append(format.getPreFormat(factor.getFactor(1))).append(factor.getFactor(1).getFullLexValue()).append(format.getPreFormat(factor.getFactor(2))).append("=");
        return this.deParse(factor.getFactor(3), sb, format);
    }

    protected StringBuilder deParse26IfHead(Item factor, StringBuilder sb, FormulaFormat format) {
        sb.append(format.getPreFormat(factor.getFactor(0))).append(factor.getFactor(0).getFullLexValue()).append(format.getPreFormat(factor.getFactor(1))).append("(");
        this.deParse(factor.getFactor(2), sb, format).append(format.getPreFormat(factor.getFactor(3))).append(")").append(format.getPreFormat(factor.getFactor(4))).append("{");
        return this.deParse(factor.getFactor(5), sb, format).append(format.getPreFormat(factor.getFactor(6))).append("}");
    }

    protected StringBuilder deParse27IfElse(Item factor, StringBuilder sb, FormulaFormat format) {
        sb.append(format.getPreFormat(factor.getFactor(0))).append(factor.getFactor(0).getFullLexValue()).append(format.getPreFormat(factor.getFactor(1))).append("(");
        this.deParse(factor.getFactor(2), sb, format).append(format.getPreFormat(factor.getFactor(3))).append(")").append(format.getPreFormat(factor.getFactor(4))).append("{");
        this.deParse(factor.getFactor(5), sb, format).append(format.getPreFormat(factor.getFactor(6))).append("}");
        sb.append(format.getPreFormat(factor.getFactor(7))).append(factor.getFactor(7).getFullLexValue()).append(format.getPreFormat(factor.getFactor(8))).append("{");
        return this.deParse(factor.getFactor(9), sb, format).append(format.getPreFormat(factor.getFactor(10))).append("}");
    }

    protected StringBuilder deParse30While(Item factor, StringBuilder sb, FormulaFormat format) {
        sb.append(format.getPreFormat(factor.getFactor(0))).append(factor.getFactor(0).getFullLexValue()).append(format.getPreFormat(factor.getFactor(1))).append("(");
        this.deParse(factor.getFactor(2), sb, format).append(format.getPreFormat(factor.getFactor(3))).append(")").append(format.getPreFormat(factor.getFactor(4))).append("{");
        return this.deParse(factor.getFactor(5), sb, format).append(format.getPreFormat(factor.getFactor(6))).append("}");
    }

    protected StringBuilder deParse31SetValue(Item factor, StringBuilder sb, FormulaFormat format) {
        Item factor_0_0 = factor.getFactor(0).getFactor(0);
        sb.append(format.getPreFormat(factor_0_0)).append(factor_0_0.getFullLexValue()).append(format.getPreFormat(factor.getFactor(1))).append("=");
        return this.deParse(factor.getFactor(2), sb, format);
    }

    protected StringBuilder deParse32Return(Item factor, StringBuilder sb, FormulaFormat format) {
        sb.append(format.getPreFormat(factor.getFactor(0))).append(factor.getFactor(0).getFullLexValue());
        return this.deParse(factor.getFactor(1), sb, format);
    }
}

