/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.xml.node;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.design.utils.XmlNodeDefaultValue;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.CDataNode;
import com.bokesoft.yes.design.xml.parse.Element;
import com.bokesoft.yes.meta.persist.dom.xml.defaultnode.DefaultNodeDefine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class TagNode
extends AbstractNode {
    private String tagName = null;
    private Map<String, String> attributes = new LinkedHashMap<String, String>();
    private final List<AbstractNode> nodes = new ArrayList<AbstractNode>();

    public TagNode(String tagName, Element element) {
        super("", element);
        this.tagName = tagName;
    }

    public TagNode(Element element) {
        super("", element);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        if (attributes != null) {
            this.attributes = attributes;
        }
    }

    public boolean hasAttribute(String attrName) {
        return this.attributes.containsKey(attrName);
    }

    public List<AbstractNode> getChildren() {
        return this.nodes;
    }

    public boolean hasChildren() {
        return this.nodes.size() != 0;
    }

    public boolean hasChildrenByTagName(String name) {
        for (AbstractNode node : this.nodes) {
            if (!(node instanceof TagNode) || !((TagNode)node).getTagName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public List<AbstractNode> getChildrenByTagName(String name) {
        ArrayList<AbstractNode> list = new ArrayList<AbstractNode>();
        List<AbstractNode> ch = this.getChildren();
        int i = 0;
        while (i < ch.size()) {
            if (ch.get(i) instanceof TagNode && ((TagNode)ch.get(i)).getTagName().equals(name)) {
                list.add(ch.get(i));
            }
            ++i;
        }
        return list;
    }

    public List<TagNode> getTagNodeChildrenByTagName(String name) {
        ArrayList<TagNode> list = new ArrayList<TagNode>();
        List<AbstractNode> ch = this.getChildren();
        int i = 0;
        while (i < ch.size()) {
            if (ch.get(i) instanceof TagNode && ((TagNode)ch.get(i)).getTagName().equals(name)) {
                list.add((TagNode)ch.get(i));
            }
            ++i;
        }
        return list;
    }

    public TagNode getOrCreateChildByTagName(String name) {
        TagNode tageNode = this.getChildByTagName(name);
        if (Objects.isNull(tageNode)) {
            tageNode = new TagNode(name, null);
            this.addNode(tageNode);
        }
        return tageNode;
    }

    public TagNode getOrCreateChildByKey(String tagName, String key) {
        if (key.isEmpty()) {
            return this.getOrCreateChildByTagName(tagName);
        }
        TagNode tageNode = this.getChildByTagNameAndKey(tagName, key);
        if (Objects.isNull(tageNode)) {
            tageNode = new TagNode(tagName, null);
            tageNode.setAttribute("Key", key);
            this.addNode(tageNode);
        }
        return tageNode;
    }

    public TagNode getOrCreateChildByTagName(String name, int i) {
        TagNode tageNode = this.getChildByTagName(name);
        if (Objects.isNull(tageNode)) {
            tageNode = new TagNode(name, null);
            int size = this.getChildren().size();
            i = Math.min(i, size - 1);
            this.addNode(tageNode, i);
        }
        return tageNode;
    }

    public TagNode getChildByTagName(String tagName) {
        Predicate<AbstractNode> predicate = childNode -> {
            if (!(childNode instanceof TagNode)) {
                return false;
            }
            TagNode childTagNode = (TagNode)childNode;
            return StringUtils.equals((CharSequence)childTagNode.getTagName(), (CharSequence)tagName);
        };
        List<AbstractNode> childNodeList = this.getChildren();
        Optional<AbstractNode> optional = childNodeList.stream().filter(predicate).findFirst();
        return optional.map(node -> (TagNode)node).orElse(null);
    }

    public TagNode getChildByTagNameAndKey(String tagName, String key) {
        Predicate<AbstractNode> predicate = childNode -> {
            if (!(childNode instanceof TagNode)) {
                return false;
            }
            TagNode childTagNode = (TagNode)childNode;
            return StringUtils.equals((CharSequence)childTagNode.getTagName(), (CharSequence)tagName) && childTagNode.getPrimaryKey().equals(String.valueOf(tagName) + "@" + key);
        };
        List<AbstractNode> childNodeList = this.getChildren();
        Optional<AbstractNode> optional = childNodeList.stream().filter(predicate).findFirst();
        return optional.map(node -> (TagNode)node).orElse(null);
    }

    public TagNode getChildByKey(String key) {
        List<AbstractNode> ch = this.getChildren();
        int i = 0;
        while (i < ch.size()) {
            Map<String, String> attributes;
            AbstractNode tmp = ch.get(i);
            if (tmp instanceof TagNode && (attributes = ((TagNode)tmp).getAttributes()) != null && key.equals(attributes.get("Key"))) {
                return (TagNode)tmp;
            }
            ++i;
        }
        return null;
    }

    public void deleteChildByTagName(String name) {
        Iterator<AbstractNode> iterator = this.getChildren().iterator();
        while (iterator.hasNext()) {
            AbstractNode tmp = iterator.next();
            if (!(tmp instanceof TagNode) || !((TagNode)tmp).getTagName().equals(name)) continue;
            iterator.remove();
        }
    }

    public void deleteChildByTagKey(String Key2) {
        int i = 0;
        while (i < this.getChildren().size()) {
            if (this.getChildren().get(i) instanceof TagNode && Key2.equals(((TagNode)this.getChildren().get(i)).getAttributes().get("Key"))) {
                this.getChildren().remove(i);
            }
            ++i;
        }
    }

    public void deleteChildByAttributes(String attrName, String ... attrValue) {
        List<String> values = Arrays.asList(attrValue);
        int i = 0;
        while (i < this.getChildren().size()) {
            if (this.getChildren().get(i) instanceof TagNode && values.contains(((TagNode)this.getChildren().get(i)).getAttributes().get(attrName))) {
                this.getChildren().remove(i);
            }
            ++i;
        }
    }

    public void setCDataValue(String newValue) {
        for (AbstractNode cdata : this.getChildren()) {
            if (!(cdata instanceof CDataNode)) continue;
            ((CDataNode)cdata).setText(newValue);
            return;
        }
        CDataNode cNode = new CDataNode(newValue, null);
        this.addNode(cNode);
    }

    public void deleteCDataValue() {
        Iterator<AbstractNode> iterator = this.getChildren().iterator();
        while (iterator.hasNext()) {
            AbstractNode cdata = iterator.next();
            if (!(cdata instanceof CDataNode)) continue;
            iterator.remove();
        }
    }

    public TagNode findChildByTagNode(TagNode tagNode) {
        for (AbstractNode ch : this.nodes) {
            String findPrimaryKey;
            String curPrimaryKey;
            if (!(ch instanceof TagNode) || !(curPrimaryKey = ((TagNode)ch).getPrimaryKey()).equalsIgnoreCase(findPrimaryKey = tagNode.getPrimaryKey())) continue;
            return (TagNode)ch;
        }
        return null;
    }

    public TagNode findFirstTagNodeByTagName(String tagName) {
        List<TagNode> list = this.findNodesByTagName(tagName);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    public List<TagNode> findNodesByTagName(String tagName) {
        if (StringUtils.isBlank((CharSequence)tagName)) {
            return null;
        }
        ArrayList<TagNode> list = new ArrayList<TagNode>();
        this.loadNodesByTagName(tagName, list);
        return list;
    }

    public List<TagNode> findNodesByTagName2(String tagName) {
        if (StringUtils.isBlank((CharSequence)tagName)) {
            return null;
        }
        ArrayList<TagNode> list = new ArrayList<TagNode>();
        this.loadNodesByTagName2(tagName, list);
        return list;
    }

    public List<CDataNode> findCDataNodesByTagName(List<CDataNode> list) {
        for (AbstractNode ch : this.nodes) {
            if (ch instanceof TagNode) {
                ((TagNode)ch).findCDataNodesByTagName(list);
                continue;
            }
            if (!(ch instanceof CDataNode)) continue;
            list.add((CDataNode)ch);
        }
        return list;
    }

    public String getCDataValue() {
        String cdataValue = "";
        for (AbstractNode ch : this.nodes) {
            if (!(ch instanceof CDataNode)) continue;
            cdataValue = ((CDataNode)ch).getText();
        }
        return cdataValue;
    }

    public List<TagNode> findMyselfNodesByTagName(String tagName) {
        if (StringUtils.isBlank((CharSequence)tagName)) {
            return null;
        }
        ArrayList<TagNode> list = new ArrayList<TagNode>();
        for (AbstractNode ch : this.nodes) {
            if (!(ch instanceof TagNode) || !tagName.equals(((TagNode)ch).getTagName())) continue;
            list.add((TagNode)ch);
        }
        return list;
    }

    public void loadNodesByTagName(String tagName, List<TagNode> list) {
        if (StringUtils.isBlank((CharSequence)tagName)) {
            return;
        }
        if (tagName.equals(this.getTagName())) {
            list.add(this);
            return;
        }
        for (AbstractNode ch : this.nodes) {
            if (!(ch instanceof TagNode)) continue;
            ((TagNode)ch).loadNodesByTagName(tagName, list);
        }
    }

    public void loadNodesByTagName2(String tagName, List<TagNode> list) {
        if (StringUtils.isBlank((CharSequence)tagName)) {
            return;
        }
        if (tagName.equals(this.getTagName())) {
            list.add(this);
        }
        for (AbstractNode ch : this.nodes) {
            if (!(ch instanceof TagNode)) continue;
            ((TagNode)ch).loadNodesByTagName2(tagName, list);
        }
    }

    public TagNode getFirst(String tag) {
        List<AbstractNode> tem = this.getChildrenByTagName(tag);
        if (tem.size() == 0) {
            return null;
        }
        return (TagNode)tem.get(0);
    }

    public TagNode getLast(String tag) {
        List<AbstractNode> tem = this.getChildrenByTagName(tag);
        if (tem.size() == 0) {
            return null;
        }
        return (TagNode)tem.get(tem.size() - 1);
    }

    public AbstractNode getFirst() {
        List<AbstractNode> list = this.getChildren();
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public AbstractNode getLast() {
        List<AbstractNode> list = this.getChildren();
        if (list.size() == 0) {
            return this;
        }
        return list.get(list.size() - 1);
    }

    public TagNode appendNode(AbstractNode node) {
        if (Objects.isNull(node)) {
            throw new IllegalArgumentException("addNode:node cant null");
        }
        this.nodes.add(node);
        node.setParent(this);
        return this;
    }

    public void deleteChildX(AbstractNode node, int i) throws Throwable {
        if (Objects.isNull(node)) {
            throw new IllegalArgumentException("addNode:node cant null");
        }
        if (this.nodes.size() <= 4) {
            throw new Throwable("\u884c\u6570\u5df2\u7ecf\u8fbe\u5230\u6700\u5c0f\u503c,\u4e0d\u80fd\u518d\u5220\u9664\u4e86");
        }
        if (this.nodes.size() > 0 && this.getChildren().get(i) instanceof TagNode) {
            this.nodes.remove(this.getChildren().get(i));
        }
        node.setParent(this);
    }

    public void deleteChidY(AbstractNode node, int i) throws Throwable {
        if (Objects.isNull(node)) {
            throw new IllegalArgumentException("addNode:node cant null");
        }
        if (this.nodes.size() <= 4) {
            throw new Throwable("\u5217\u6570\u5df2\u7ecf\u8fbe\u5230\u6700\u5c0f\u503c,\u4e0d\u80fd\u518d\u5220\u9664\u4e86");
        }
        if (this.nodes.size() > 0 && this.getChildren().get(i) instanceof TagNode) {
            this.nodes.remove(this.getChildren().get(i));
        }
        node.setParent(this);
    }

    public TagNode addNode(AbstractNode node) {
        return this.addNode(node, this.nodes.size() - 1);
    }

    public TagNode addNode(AbstractNode node, int i) {
        if (Objects.isNull(node)) {
            throw new IllegalArgumentException("addNode:node cant null");
        }
        int size = this.nodes.size();
        i = Math.min(i, size - 1);
        if (size > 0) {
            AbstractNode lastNode = this.nodes.get(size - 1);
            Element element = lastNode.getElement();
            if (element != null) {
                if (lastNode instanceof TagNode && element.getTagType() == 2 && ((TagNode)lastNode).getTagName().equals(this.tagName)) {
                    this.nodes.add(i, node);
                }
            } else {
                this.nodes.add(node);
            }
        } else {
            this.nodes.add(node);
        }
        node.setParent(this);
        return this;
    }

    public TagNode deleteAttribute(String name) {
        this.attributes.remove(name);
        return this;
    }

    public TagNode setAttribute(String name, String value) {
        XmlNodeDefaultValue defaultValue = XmlNodeDefaultValue.getDefaultValue(name);
        if (Objects.isNull(defaultValue)) {
            if (StringUtils.isEmpty((CharSequence)value)) {
                this.attributes.remove(name);
            } else {
                this.attributes.put(name, value);
            }
        } else if (StringUtils.isEmpty((CharSequence)value) || defaultValue.defaultNodeValue.equalsIgnoreCase(value) || defaultValue.defaultNodeValues != null && defaultValue.defaultNodeValues.get(this.tagName) != null && defaultValue.defaultNodeValues.get(this.tagName).equalsIgnoreCase(value)) {
            if (!StringUtils.equals((CharSequence)this.tagName, (CharSequence)"DefaultValue")) {
                this.attributes.remove(name);
            }
        } else if (StringUtils.equals((CharSequence)this.tagName, (CharSequence)"GridCell") && defaultValue.defaultNodeValues != null && StringUtils.equalsIgnoreCase((CharSequence)defaultValue.defaultNodeValues.get(this.getAttributes().get("CellType")), (CharSequence)value)) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, value);
        }
        return this;
    }

    public TagNode setAttribute(String name, String value, Object defaultValue) {
        if (ObjectUtils.notEqual((Object)value, (Object)defaultValue)) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
        return this;
    }

    public TagNode setAttributeNotRemove(String name, String value) {
        this.attributes.put(name, value);
        return this;
    }

    public String getTagName() {
        return this.tagName;
    }

    public TagNode setTagName(String tagName) {
        this.tagName = tagName;
        return this;
    }

    public String getPrimaryKey() {
        if (Objects.isNull(this.tagName)) {
            return null;
        }
        Element element = this.getElement();
        if (Objects.nonNull(element) && element.getTagType() == 2) {
            return null;
        }
        String attrKey = DefaultNodeDefine.getInstance().getPrimaryKey(this.tagName);
        String primaryValue = this.attributes.get(attrKey);
        if (StringUtils.isBlank((CharSequence)primaryValue)) {
            return null;
        }
        return this.tagName.concat("@").concat(primaryValue);
    }

    @Override
    public String toXml(int level) {
        return this.toXml(level, true);
    }

    @Override
    public String toXml(int level, boolean escape) {
        StringBuilder strBuilder = new StringBuilder();
        if (level == 0) {
            strBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n");
            this.appendPreComment(strBuilder, this, level);
        }
        this.appendLevelBlank(strBuilder, level);
        String sAttrs = this.getAttrsString(escape);
        strBuilder.append("<").append(this.tagName);
        if (!StringUtil.isEmptyStr((String)sAttrs)) {
            strBuilder.append(" ");
        }
        strBuilder.append(sAttrs);
        int childrenSize = this.nodes.size();
        if (childrenSize == 0 || childrenSize == 1 && this.nodes.get(0) instanceof TagNode && ((TagNode)this.nodes.get(0)).getTagName().equals(this.tagName) && ((TagNode)this.nodes.get(0)).getChildren().size() == 0) {
            strBuilder.append("/>");
        } else {
            strBuilder.append(">").append("\r\n");
            int i = 0;
            while (i < childrenSize) {
                AbstractNode node = this.nodes.get(i);
                if (node != null) {
                    String nodeTagName;
                    String string = nodeTagName = node instanceof TagNode ? ((TagNode)node).getTagName() : null;
                    if (i == childrenSize - 1 && this.tagName.equals(nodeTagName) && node instanceof TagNode && ((TagNode)node).getChildren().size() == 0) {
                        this.appendLevelBlank(strBuilder, level);
                        strBuilder.append("</").append(this.tagName).append(">");
                        break;
                    }
                    if (i == childrenSize - 1) {
                        this.appendPreComment(strBuilder, node, level + 1);
                        strBuilder.append(node.toXml(level + 1, escape)).append("\r\n");
                        this.appendLastComment(strBuilder, node, level + 1);
                        this.appendLevelBlank(strBuilder, level);
                        strBuilder.append("</").append(this.tagName).append(">");
                        break;
                    }
                    strBuilder.append(node.toXml(level + 1, escape)).append("\r\n");
                    this.appendLastComment(strBuilder, node, level + 1);
                }
                ++i;
            }
        }
        if (level == 0) {
            strBuilder.append("\r\n");
            this.appendLastComment(strBuilder, this, level);
        }
        return strBuilder.toString();
    }

    private void appendPreComment(StringBuilder strBuilder, AbstractNode node, int level) {
        List<AbstractNode> listPreComment = node.getPreComment();
        if (CollectionUtils.isEmpty(listPreComment)) {
            return;
        }
        for (AbstractNode comment : listPreComment) {
            strBuilder.append(comment.toXml(level)).append("\r\n");
        }
    }

    private void appendLastComment(StringBuilder strBuilder, AbstractNode node, int level) {
        List<AbstractNode> listLastComment = node.getLastComment();
        if (CollectionUtils.isEmpty(listLastComment)) {
            return;
        }
        for (AbstractNode comment : listLastComment) {
            strBuilder.append(comment.toXml(level)).append("\r\n");
        }
    }

    private String getAttrsString(boolean escape) {
        String sAttrs = "";
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            sAttrs = sAttrs.length() == 0 ? String.valueOf(entry.getKey()) + "=\"" + this.convertSpecialChars(entry.getValue(), escape) + "\"" : String.valueOf(sAttrs) + " " + entry.getKey() + "=\"" + this.convertSpecialChars(entry.getValue(), escape) + "\"";
        }
        return sAttrs;
    }

    @Override
    public AbstractNode clone() {
        TagNode node = new TagNode(this.getTagName(), null);
        for (Map.Entry<String, String> entry : this.getAttributes().entrySet()) {
            node.setAttribute(entry.getKey(), entry.getValue());
        }
        for (AbstractNode tmpNode : this.nodes) {
            node.getChildren().add(tmpNode.clone());
        }
        return node;
    }

    @Override
    public boolean hasPrimaryAttribute() {
        String primaryAttrKey = DefaultNodeDefine.getInstance().getPrimaryKey(this.getTagName());
        return !StringUtil.isBlankOrNull((String)this.attributes.get(primaryAttrKey));
    }

    public String getPrimaryAttrName() {
        return DefaultNodeDefine.getInstance().getPrimaryKey(this.getTagName());
    }
}

