/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.xml;

import com.bokesoft.yes.design.Property;
import com.bokesoft.yes.meta.persist.dom.xml.defaultnode.DefaultNode;
import com.bokesoft.yes.meta.persist.dom.xml.defaultnode.DefaultNodeDefine;
import com.bokesoft.yes.meta.persist.dom.xml.defaultnode.LinkedData;
import com.bokesoft.yes.meta.persist.dom.xml.node.AbstractNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.CDataNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.TagNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.TextNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.XmlTree;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlCreator {
    private final Document doc;
    private final XmlTree orgTree;
    private final LinkedHashMap<String, TagNode> mapNode = new LinkedHashMap();
    private final DefaultNodeDefine defaultDefine = DefaultNodeDefine.getInstance();

    public XmlCreator(Document doc, XmlTree orgTree) {
        this.doc = doc;
        this.orgTree = orgTree;
    }

    public XmlTree createXmlTree() {
        TagNode newRoot;
        this.mapNode.clear();
        Element elem = this.doc.getDocumentElement();
        if (Objects.nonNull(this.orgTree)) {
            String key = this.getKey(elem);
            TagNode node = this.orgTree.getTagNode(key);
            newRoot = this.createNewNodeByBaseNode(elem, node);
        } else {
            newRoot = this.createNewNodeByDefault(elem);
        }
        this.createTagNode(elem, newRoot, true);
        if (Objects.nonNull(this.orgTree)) {
            TagNode root = this.orgTree.getRoot();
            newRoot.addPreComment(root.getPreComment());
            newRoot.addLastComment(root.getLastComment());
        }
        XmlTree newTree = new XmlTree();
        newTree.setRoot(newRoot);
        return newTree;
    }

    public String createXml() {
        XmlTree xmlTree = this.createXmlTree();
        this.createComments(xmlTree);
        return xmlTree.getRoot().toXml(0);
    }

    public HashMap<String, TagNode> getTagNodeMap() {
        return this.mapNode;
    }

    private void createComments(XmlTree xmlTree) {
        if (Objects.isNull(this.orgTree)) {
            return;
        }
        TagNode root = xmlTree.getRoot();
        TagNode virtual = new TagNode();
        virtual.addNode((AbstractNode)root);
        List listNode = this.orgTree.getNodesWithComment();
        for (AbstractNode nodeWithComment : listNode) {
            Stack<AbstractNode> stackPath = this.getCommentPath(nodeWithComment);
            TagNode levelNode = virtual;
            boolean bFind = false;
            AbstractNode pathNode = null;
            while (!stackPath.isEmpty() && levelNode != null) {
                pathNode = stackPath.pop();
                if (pathNode instanceof TagNode) {
                    TagNode tagNode = (TagNode)pathNode;
                    bFind = (levelNode = levelNode.findChildByTagNode(tagNode)) != null;
                    continue;
                }
                bFind = false;
                break;
            }
            if (!bFind) continue;
            levelNode.addPreComment(pathNode.getPreComment());
            levelNode.addLastComment(pathNode.getLastComment());
        }
    }

    private Stack<AbstractNode> getCommentPath(AbstractNode nodeWithComment) {
        Stack<AbstractNode> stack = new Stack<AbstractNode>();
        AbstractNode parent = nodeWithComment;
        while (parent != null) {
            stack.push(parent);
            parent = parent.getParent();
        }
        return stack;
    }

    private void createTagNode(Element elem, TagNode parentTagNode, boolean isRoot) {
        TagNode newTagNode;
        if (isRoot) {
            newTagNode = parentTagNode;
        } else {
            if (Objects.nonNull(this.orgTree)) {
                String key = this.getKey(elem);
                TagNode node = this.orgTree.getTagNode(key);
                newTagNode = this.createNewNodeByBaseNode(elem, node);
            } else {
                newTagNode = this.createNewNodeByDefault(elem);
            }
            parentTagNode.addNode((AbstractNode)newTagNode);
            String par = "";
            if (newTagNode.getParent() != null) {
                par = newTagNode.getParent().getPrimaryKey();
            }
            this.mapNode.put(String.valueOf(par) + "->" + newTagNode.getPrimaryKey(), newTagNode);
        }
        NodeList nodeList = elem.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            String sContent;
            Node child = nodeList.item(n);
            if (child.getNodeType() == 1) {
                this.createTagNode((Element)child, newTagNode, false);
            }
            if (child.getNodeType() == 4) {
                newTagNode.addNode((AbstractNode)new CDataNode(child.getNodeValue()));
            }
            if (child.getNodeType() == 3 && (sContent = child.getTextContent()) != null && sContent.trim().length() > 0) {
                newTagNode.addNode((AbstractNode)new TextNode(sContent));
            }
            ++n;
        }
    }

    private TagNode createNewNodeByBaseNode(Element curElem, TagNode baseTagNode) {
        if (curElem.hasAttribute(Property.CssClass.name)) {
            curElem.removeAttribute("Class");
        }
        if (Objects.isNull(baseTagNode)) {
            return this.createNewNodeByDefault(curElem);
        }
        String curNodeName = curElem.getNodeName();
        DefaultNode newElementAttrs = new DefaultNode(curNodeName);
        Set keySet = baseTagNode.getAttributes().keySet();
        for (String attrName : keySet) {
            if (!curElem.hasAttribute(attrName)) continue;
            newElementAttrs.addNode(new LinkedData(attrName));
        }
        DefaultNode defaultNode = this.defaultDefine.getDefaultNode(curNodeName);
        NamedNodeMap curAttrs = curElem.getAttributes();
        int i = 0;
        while (i < curAttrs.getLength()) {
            String attrName = curAttrs.item(i).getNodeName();
            if (!newElementAttrs.hasAttribute(attrName)) {
                if (defaultNode != null && defaultNode.hasAttribute(attrName)) {
                    LinkedData lastDefinedAttr = this.findLastDefinedAttr(newElementAttrs, defaultNode);
                    newElementAttrs.addNode(new LinkedData(attrName), lastDefinedAttr);
                } else {
                    newElementAttrs.addNode(new LinkedData(attrName));
                }
            }
            ++i;
        }
        LinkedData tmp = newElementAttrs.first();
        TagNode newTagNode = new TagNode(curNodeName);
        while (tmp != null) {
            String attrName = tmp.getValue();
            newTagNode.setAttribute(attrName, curElem.getAttribute(attrName));
            tmp = tmp.next;
        }
        return newTagNode;
    }

    public TagNode createNewNodeByBaseNode(TagNode curElem, TagNode baseTagNode) {
        if (Objects.isNull(baseTagNode)) {
            return this.createNewNodeByDefault(curElem);
        }
        String curNodeName = curElem.getTagName();
        DefaultNode newElementAttrs = new DefaultNode(curNodeName);
        Set keySet = baseTagNode.getAttributes().keySet();
        for (String attrName : keySet) {
            if (!curElem.hasAttribute(attrName)) continue;
            newElementAttrs.addNode(new LinkedData(attrName));
        }
        DefaultNode defaultNode = this.defaultDefine.getDefaultNode(curNodeName);
        Map attributes = curElem.getAttributes();
        attributes.forEach((key, abs) -> {
            if (!newElementAttrs.hasAttribute(key)) {
                if (defaultNode != null && defaultNode.hasAttribute(key)) {
                    LinkedData lastDefinedAttr = this.findLastDefinedAttr(newElementAttrs, defaultNode);
                    newElementAttrs.addNode(new LinkedData(key), lastDefinedAttr);
                } else {
                    newElementAttrs.addNode(new LinkedData(key));
                }
            }
        });
        LinkedData tmp = newElementAttrs.first();
        TagNode newTagNode = new TagNode(curNodeName);
        while (tmp != null) {
            String attrName = tmp.getValue();
            newTagNode.setAttribute(attrName, (String)curElem.getAttributes().get(attrName));
            tmp = tmp.next;
        }
        return newTagNode;
    }

    private TagNode createNewNodeByDefault(Element curElem) {
        String attrName;
        String nodeName = curElem.getNodeName();
        TagNode newTagNode = new TagNode(nodeName);
        DefaultNode defaultNode = this.defaultDefine.getDefaultNode(nodeName);
        if (defaultNode != null) {
            for (LinkedData attrData : defaultNode.values()) {
                attrName = attrData.getValue();
                if (!curElem.hasAttribute(attrName)) continue;
                newTagNode.setAttribute(attrName, curElem.getAttribute(attrName));
            }
        }
        NamedNodeMap curAttrs = curElem.getAttributes();
        int i = 0;
        while (i < curAttrs.getLength()) {
            attrName = curAttrs.item(i).getNodeName();
            if (!newTagNode.hasAttribute(attrName)) {
                newTagNode.setAttribute(attrName, curElem.getAttribute(attrName));
            }
            ++i;
        }
        return newTagNode;
    }

    private TagNode createNewNodeByDefault(TagNode curElem) {
        String nodeName = curElem.getTagName();
        TagNode newTagNode = new TagNode(nodeName);
        DefaultNode defaultNode = this.defaultDefine.getDefaultNode(nodeName);
        if (defaultNode != null) {
            for (LinkedData attrData : defaultNode.values()) {
                String attrName = attrData.getValue();
                if (!curElem.hasAttribute(attrName)) continue;
                newTagNode.setAttribute(attrName, (String)curElem.getAttributes().get(attrName));
            }
        }
        Map attributes = curElem.getAttributes();
        attributes.forEach((key, abs) -> {
            if (!newTagNode.hasAttribute(key)) {
                newTagNode.setAttribute(key, abs);
            }
        });
        return newTagNode;
    }

    private LinkedData findLastDefinedAttr(DefaultNode linkAttrs, DefaultNode defaultAttrs) {
        LinkedData tmpData = linkAttrs.last();
        while (tmpData != null) {
            if (defaultAttrs.hasAttribute(tmpData.getValue())) {
                return tmpData;
            }
            tmpData = tmpData.previous;
        }
        return null;
    }

    private String getKey(Element elem) {
        String tagName = elem.getTagName();
        String primaryKey = this.defaultDefine.getPrimaryKey(tagName);
        String attrKey = elem.getAttribute(primaryKey);
        Node parentNode = elem.getParentNode();
        String parentPrimaryKey = "";
        parentPrimaryKey = this.getParentPrimaryKey(parentNode, parentPrimaryKey);
        return parentPrimaryKey.concat("->").concat(tagName).concat("@").concat(attrKey);
    }

    private String getParentPrimaryKey(Node parentNode, String parentPrimaryKey) {
        if (parentNode instanceof Element) {
            Element parentNode1 = (Element)parentNode;
            String tagName1 = parentNode1.getTagName();
            String key = parentNode1.getAttribute("Key");
            parentPrimaryKey = StringUtils.isEmpty((CharSequence)key) ? parentPrimaryKey.concat(this.getParentPrimaryKey(parentNode1.getParentNode(), parentPrimaryKey)) : tagName1.concat("@").concat(key);
        }
        return parentPrimaryKey;
    }
}

