/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.utils;

import com.bokesoft.yes.design.utils.XSDErrorHandler;
import com.bokesoft.yes.design.vo.CheckXSDResult;
import com.bokesoft.yes.erpdatamap.ERPMetaMap;
import com.bokesoft.yes.meta.persist.dom.xml.defaultnode.DefaultNode;
import com.bokesoft.yes.meta.persist.dom.xml.defaultnode.DefaultNodeDefine;
import com.bokesoft.yes.meta.persist.dom.xml.node.AbstractNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.TagNode;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.entry.MetaEntry;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;

public class CheckXSDUtils {
    private static final DefaultNodeDefine defaultNodeDefine = DefaultNodeDefine.getInstance();
    public static final String W3C_XML_SCHEMA11_NS_URI = "http://www.w3.org/XML/XMLSchema/v1.1".intern();
    private static final List<String> extList = Arrays.asList("webconfig");
    public static final Set<String> skipMsgSet = new HashSet<String>();
    public static HashMap<String, HashSet<String>> EXCLUDE;

    static {
        skipMsgSet.add("");
        EXCLUDE = new HashMap<String, HashSet<String>>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("GS_DataTable_Rpt", new HashSet<String>(){
                    {
                        this.add("cvc-complex-type.2.4.b: The content of element 'Table' is not complete. One of '{Column}' is expected.");
                        this.add("cvc-complex-type.2.4.b: The content of element 'GridColumnCollection' is not complete. One of '{GridColumn}' is expected.");
                        this.add("cvc-complex-type.2.4.b: The content of element 'GridRow' is not complete. One of '{GridCell}' is expected.");
                    }
                });
                this.put("GS_DataQuery_Rpt", new HashSet<String>(){
                    {
                        this.add("cvc-complex-type.2.4.b: The content of element 'Table' is not complete. One of '{Column}' is expected.");
                        this.add("cvc-complex-type.2.4.b: The content of element 'GridColumnCollection' is not complete. One of '{GridColumn}' is expected.");
                        this.add("cvc-complex-type.2.4.b: The content of element 'GridRow' is not complete. One of '{GridCell}' is expected.");
                    }
                });
                this.put("Report_30", new HashSet<String>(){});
                this.put("Report_20", new HashSet<String>(){});
                this.put("Report_10", new HashSet<String>(){});
                this.put("HR_Roster_Module", new HashSet<String>(){
                    {
                        this.add("cvc-complex-type.2.4.b: The content of element 'GridColumnCollection' is not complete. One of '{GridColumn}' is expected.");
                        this.add("cvc-complex-type.2.4.b: The content of element 'GridRow' is not complete. One of '{GridCell}' is expected.");
                    }
                });
                this.put("GridSettingVariantDialog", new HashSet<String>(){
                    {
                        this.add("cvc-pattern-valid: Value 'columnkey' is not facet-valid with respect to pattern '[A-Z][a-zA-Z0-9_]*' for type 'yigo-Key-Restriction30'.");
                        this.add("cvc-attribute.3: The value 'columnkey' of attribute 'Key' on element 'Column' is not valid with respect to its type, 'yigo-Key-Restriction30'.");
                        this.add("cvc-pattern-valid: Value 'name' is not facet-valid with respect to pattern '[A-Z][a-zA-Z0-9_]*' for type 'yigo-Key-Restriction30'.");
                        this.add("cvc-attribute.3: The value 'name' of attribute 'Key' on element 'Column' is not valid with respect to its type, 'yigo-Key-Restriction30'.");
                        this.add("cvc-identity-constraint.4.1: Duplicate unique value [null] found for identity constraint \"uniqueColumnKey\" of element \"Table\".");
                    }
                });
                this.put("HR_CHNEmployeInfo", new HashSet<String>(){
                    {
                        this.add("cvc-complex-type.2.4.b: The content of element 'TabPanel' is not complete. One of '{Format, Dict, DynamicDict, TextEditor, TextArea, CheckBox, ComboBox, CheckListBox, DatePicker, UTCDatePicker, MonthPicker, TimePicker, Button, NumberEditor, Label, TextButton, RadioButton, PasswordEditor, Image, WebBrowser, RichEditor, HyperLink, Separator, DropdownButton, Activate, Icon, Custom, BPMGraph, Dynamic, Carousel, EditView, GridLayoutPanel, FlexFlowLayoutPanel, FlexGridLayoutPanel, FlowLayoutPanel, BorderLayoutPanel, Embed, TabPanel, SplitPanel, Container, Grid, SubDetail, DictView, LinearLayoutPanel, PopView, HoverButton, TableView, TabGroup, TableRow}' is expected.");
                        this.add("cvc-complex-type.2.4.a: Invalid content was found starting with element 'ItemChanged'. One of '{Format, Dict, DynamicDict, TextEditor, TextArea, CheckBox, ComboBox, CheckListBox, DatePicker, UTCDatePicker, MonthPicker, TimePicker, Button, NumberEditor, Label, TextButton, RadioButton, PasswordEditor, Image, WebBrowser, RichEditor, HyperLink, Separator, DropdownButton, Activate, Icon, Custom, BPMGraph, Dynamic, Carousel, EditView, GridLayoutPanel, FlexFlowLayoutPanel, FlexGridLayoutPanel, FlowLayoutPanel, BorderLayoutPanel, Embed, TabPanel, SplitPanel, Container, Grid, SubDetail, DictView, LinearLayoutPanel, PopView, HoverButton, TableView, TabGroup, TableRow}' is expected.");
                    }
                });
                this.put("HR_PersonnelAction_", new HashSet<String>(){
                    {
                        this.add("cvc-complex-type.2.4.b: The content of element 'TabPanel' is not complete. One of '{Format, Dict, DynamicDict, TextEditor, TextArea, CheckBox, ComboBox, CheckListBox, DatePicker, UTCDatePicker, MonthPicker, TimePicker, Button, NumberEditor, Label, TextButton, RadioButton, PasswordEditor, Image, WebBrowser, RichEditor, HyperLink, Separator, DropdownButton, Activate, Icon, Custom, BPMGraph, Dynamic, Carousel, EditView, GridLayoutPanel, FlexFlowLayoutPanel, FlexGridLayoutPanel, FlowLayoutPanel, BorderLayoutPanel, Embed, TabPanel, SplitPanel, Container, Grid, SubDetail, DictView, LinearLayoutPanel, PopView, HoverButton, TableView, TabGroup, TableRow}' is expected.");
                    }
                });
                this.put("HR_LogTreeEmb", new HashSet<String>(){
                    {
                        this.add("cvc-complex-type.2.4.b: The content of element 'TabPanel' is not complete. One of '{Format, Dict, DynamicDict, TextEditor, TextArea, CheckBox, ComboBox, CheckListBox, DatePicker, UTCDatePicker, MonthPicker, TimePicker, Button, NumberEditor, Label, TextButton, RadioButton, PasswordEditor, Image, WebBrowser, RichEditor, HyperLink, Separator, DropdownButton, Activate, Icon, Custom, BPMGraph, Dynamic, Carousel, EditView, GridLayoutPanel, FlexFlowLayoutPanel, FlexGridLayoutPanel, FlowLayoutPanel, BorderLayoutPanel, Embed, TabPanel, SplitPanel, Container, Grid, SubDetail, DictView, LinearLayoutPanel, PopView, HoverButton, TableView, TabGroup, TableRow}' is expected.");
                    }
                });
                this.put("Workspace", new HashSet<String>(){
                    {
                        this.add("cvc-complex-type.3.2.2: Attribute 'Provider' is not allowed to appear in element 'Body'.");
                    }
                });
            }
        };
    }

    public static void resortAttrPosition(TagNode tagNode, String filePath) {
        Map<String, String> newSortedMap;
        String tagName = tagNode.getTagName();
        Map attributes = tagNode.getAttributes();
        DefaultNode defaultNode = defaultNodeDefine.getDefaultNode(tagName);
        if (defaultNode != null && !defaultNode.values().isEmpty()) {
            List defaultNodeAttrList = defaultNode.getAttrList();
            newSortedMap = CheckXSDUtils.customSort(defaultNodeAttrList, new LinkedHashMap<String, String>(attributes));
        } else {
            newSortedMap = CheckXSDUtils.customSort(null, new LinkedHashMap<String, String>(attributes));
        }
        attributes.clear();
        attributes.putAll(newSortedMap);
        for (AbstractNode child : tagNode.getChildren()) {
            if (!(child instanceof TagNode)) continue;
            CheckXSDUtils.resortAttrPosition((TagNode)child, filePath);
        }
    }

    public static Map<String, String> customSort(List<String> defaultNodeAttrList, Map<String, String> attributes) {
        String caption;
        LinkedHashMap<String, String> sortedMap = new LinkedHashMap<String, String>();
        String key = "Key";
        if (attributes.containsKey(key)) {
            sortedMap.put(key, attributes.get(key));
            attributes.remove(key);
        }
        if (attributes.containsKey(caption = "Caption")) {
            sortedMap.put(caption, attributes.get(caption));
            attributes.remove(caption);
        }
        if (defaultNodeAttrList != null) {
            for (String elem : defaultNodeAttrList) {
                if (!attributes.containsKey(elem)) continue;
                sortedMap.put(elem, attributes.get(elem));
                attributes.remove(elem);
            }
        }
        sortedMap.putAll(attributes);
        return sortedMap;
    }

    public static HashMap<String, Source> loadSchemaSourceMap(IMetaFactory metaFactory) {
        HashMap<String, Source> schemaSourceMap = new HashMap<String, Source>();
        HashMap<String, String> elementKey_XSDMap = new HashMap<String, String>(){
            {
                this.put("DataObject", "DataObject.xsd");
                this.put("Form", "Form.xsd");
                this.put("Map", "Map.xsd");
                this.put("CommonDef", "CommonDef.xsd");
                this.put("DataMigration", "DataMigration.xsd");
                this.put("DataElementDef", "DataElementDef.xsd");
                this.put("DomainDef", "DomainDef.xsd");
                this.put("Entry", "Entry.xsd");
            }
        };
        for (Map.Entry entry : elementKey_XSDMap.entrySet()) {
            String elementKey = (String)entry.getKey();
            String xsdName = (String)entry.getValue();
            String xsdFilePath = String.valueOf(metaFactory.getSolutionPath()) + File.separator + "Resource" + File.separator + "xsd" + File.separator + xsdName;
            File schemaFile = new File(xsdFilePath);
            StreamSource schemaSource = new StreamSource(schemaFile);
            schemaSourceMap.put(elementKey, schemaSource);
        }
        return schemaSourceMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CheckXSDResult checkXSD(IMetaFactory metaFactory, String tagName, String key, String fileName, String newXml, String projectKey, MetaCommonDef metaCommonDef, MetaEntry metaEntry) throws Throwable {
        CheckXSDResult checkXSDResult = new CheckXSDResult();
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance(W3C_XML_SCHEMA11_NS_URI);
            HashMap<String, Source> schemaSourceMap = CheckXSDUtils.loadSchemaSourceMap(metaFactory);
            Source source = schemaSourceMap.get(tagName);
            Schema schema = schemaFactory.newSchema(source);
            Validator validator = schema.newValidator();
            switch (tagName) {
                case "DataObject": {
                    MetaDataObjectProfile metaDataObjectProfile = (MetaDataObjectProfile)metaFactory.getDataObjectList().get(key);
                    if (!EXCLUDE.containsKey(metaDataObjectProfile.getKey())) return CheckXSDUtils.validateXML(validator, fileName, newXml);
                    if (!EXCLUDE.get(metaDataObjectProfile.getKey()).isEmpty()) return CheckXSDUtils.validateXML(validator, fileName, newXml);
                    checkXSDResult.setPass(true);
                    return checkXSDResult;
                }
                case "Form": {
                    MetaFormProfile metaFormProfile = (MetaFormProfile)metaFactory.getMetaFormList().get(key);
                    projectKey = metaFormProfile.getProject().getKey();
                    if (EXCLUDE.containsKey(key) && EXCLUDE.get(key).isEmpty()) {
                        checkXSDResult.setPass(true);
                        return checkXSDResult;
                    } else if (key.startsWith("ReportCell_")) {
                        checkXSDResult.setPass(true);
                        return checkXSDResult;
                    } else {
                        if (!extList.contains(projectKey)) return CheckXSDUtils.validateXML(validator, fileName, newXml);
                        checkXSDResult.setPass(true);
                    }
                    return checkXSDResult;
                }
                case "Map": {
                    ERPMetaMap erpMetaMap = (ERPMetaMap)metaFactory.getMetaCustomObject(ERPMetaMap.class, key);
                    if (!EXCLUDE.containsKey(erpMetaMap.getKey())) return CheckXSDUtils.validateXML(validator, fileName, newXml);
                    if (!EXCLUDE.get(erpMetaMap.getKey()).isEmpty()) return CheckXSDUtils.validateXML(validator, fileName, newXml);
                    checkXSDResult.setPass(true);
                    return checkXSDResult;
                }
                case "CommonDef": {
                    if (metaCommonDef != null) return CheckXSDUtils.validateXML(validator, fileName, newXml);
                    checkXSDResult.setPass(true);
                    return checkXSDResult;
                }
                case "DataMigration": {
                    return CheckXSDUtils.validateXML(validator, fileName, newXml);
                }
                case "Entry": {
                    if (metaEntry == null) {
                        checkXSDResult.setPass(true);
                        return checkXSDResult;
                    }
                    String filePath_Entry = String.valueOf(((IMetaResolver)metaFactory.getProjectResolverMap().get(projectKey)).getPath("")) + "Entry.xml";
                    checkXSDResult = CheckXSDUtils.validateXML(validator, filePath_Entry, newXml);
                    if (!checkXSDResult.isPass()) return checkXSDResult;
                    String filePath_ERPEntry = String.valueOf(((IMetaResolver)metaFactory.getProjectResolverMap().get(projectKey)).getPath("")) + "ERPEntry.xml";
                    checkXSDResult = CheckXSDUtils.validateXML(validator, filePath_ERPEntry, newXml);
                }
                default: {
                    return checkXSDResult;
                }
                case "DomainDef": 
                case "DataElementDef": {
                    return checkXSDResult;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("XML is not valid according to the XSD schema.");
        }
        return checkXSDResult;
    }

    private static CheckXSDResult validateXML(Validator validator, String fileName, String newXml) throws IOException, SAXException {
        CheckXSDResult checkXSDResult = new CheckXSDResult();
        ArrayList<String> resultList = new ArrayList<String>();
        XSDErrorHandler simpleErrorHandler = new XSDErrorHandler();
        validator.setErrorHandler(simpleErrorHandler);
        validator.validate(new StreamSource(new StringReader(newXml)));
        if (simpleErrorHandler.infoMap.containsKey("Error")) {
            HashSet errorInfoSet = simpleErrorHandler.infoMap.get("Error");
            for (String errorInfo : errorInfoSet) {
                boolean skip = false;
                if (EXCLUDE.containsKey(fileName)) {
                    for (String error : EXCLUDE.get(fileName)) {
                        if (!errorInfo.contains(error)) continue;
                        skip = true;
                        break;
                    }
                }
                if (skip) continue;
                resultList.add("\u8868\u5355" + fileName + "\u914d\u7f6eXSD\u89c4\u8303\u68c0\u67e5\uff0c\u7b2c" + errorInfo);
            }
        }
        if (resultList.size() > 0) {
            checkXSDResult.setPass(false);
            checkXSDResult.setMsg(resultList.toString());
        } else {
            checkXSDResult.setPass(true);
        }
        return checkXSDResult;
    }
}

