/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.setting.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.resolver.DesignSettingMetaResolver;
import com.bokesoft.yes.design.setting.impl.HandleSettingImpl;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.meta.persist.dom.solution.MetaSolutionLoad;
import com.bokesoft.yes.meta.persist.dom.solution.MetaSolutionSave;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;

public class SolutionOperUtil
extends HandleSettingImpl {
    @Override
    public void saveXml(XmlTreeWithPath xmlTree, TagNode rootNode, Diff diff, JSONObject jsonObject) throws Throwable {
        String xml = this.genFinalXML(xmlTree, rootNode, diff, jsonObject);
        String filePath = diff.getFilePath();
        org.w3c.dom.Document document = DomHelper.createDocument((String)xml);
        MetaSolutionLoad solutionLoad = new MetaSolutionLoad(1);
        solutionLoad.load(document);
        MetaSolution metaSolution = (MetaSolution)solutionLoad.getRootMetaObject();
        DesignSettingMetaResolver designSettingMetaResolver = new DesignSettingMetaResolver();
        new MetaSolutionSave((AbstractMetaObject)metaSolution).save((IMetaResolver)designSettingMetaResolver, filePath);
    }

    @Override
    public void reload(String filePath) {
    }

    @Override
    public void dealData(Document document, Diff diff, JSONObject jsonObject) throws Throwable {
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        TagNode rootNode = xmlTree.xmlTree.getRoot();
        this.dealHeadData(document, rootNode);
        this.dealProjectCollection(document, rootNode);
        this.dealInplaceToolbarCollection(document, rootNode);
        this.dealPreLoadItemCollection(document, rootNode);
        this.dealLangConfig(document, rootNode);
        this.dealStartItemCollection(document, rootNode);
    }

    private void dealHeadData(Document document, TagNode rootNode) throws Throwable {
        DataTable solutionHead = document.get("ED_SolutionHead");
        solutionHead.setShowDeleted(true);
        if (this.isTableChange(solutionHead)) {
            boolean isEnableDiff;
            String appKey = solutionHead.getString(0, "AppKey");
            String caption = solutionHead.getString(0, "Caption");
            String dataPath = solutionHead.getString(0, "DataPath");
            String startForm = solutionHead.getString(0, "StartForm");
            int securityLevel = solutionHead.getInt(0, "SecurityLevel");
            boolean isEnableMultiLang = solutionHead.getInt(0, "IsEnableMultiLang") == 1;
            String defaultLang = solutionHead.getString(0, "DefaultLang");
            String testLang = solutionHead.getString(0, "TestLang");
            String designEditorFactory = solutionHead.getString(0, "DesignEditorFactory");
            boolean bl = isEnableDiff = solutionHead.getInt(0, "IsEnableDiff") == 1;
            if (StringUtils.isNotEmpty((CharSequence)caption)) {
                rootNode.setAttribute("Caption", caption);
            } else {
                rootNode.deleteAttribute("Caption");
            }
            if (StringUtils.isNotEmpty((CharSequence)appKey)) {
                rootNode.setAttribute("Key", appKey);
            } else {
                rootNode.deleteAttribute("Key");
            }
            if (StringUtils.isNotEmpty((CharSequence)dataPath)) {
                rootNode.setAttribute("DataPath", dataPath);
            } else {
                rootNode.deleteAttribute("DataPath");
            }
            if (StringUtils.isNotEmpty((CharSequence)startForm)) {
                rootNode.setAttribute("StartForm", startForm);
            } else {
                rootNode.deleteAttribute("StartForm");
            }
            if (securityLevel > 0) {
                rootNode.setAttribute("SecurityLevel", "" + securityLevel);
            } else {
                rootNode.deleteAttribute("SecurityLevel");
            }
            if (isEnableMultiLang) {
                rootNode.setAttribute("EnableMultiLang", "true");
            } else {
                rootNode.deleteAttribute("EnableMultiLang");
            }
            if (StringUtils.isNotEmpty((CharSequence)defaultLang) && !"zh-CN".equals(defaultLang)) {
                rootNode.setAttribute("DefaultLang", defaultLang);
            } else {
                rootNode.deleteAttribute("DefaultLang");
            }
            if (isEnableMultiLang) {
                rootNode.setAttribute("EnableMultiLang", "true");
            } else {
                rootNode.deleteAttribute("EnableMultiLang");
            }
            if (StringUtils.isNotEmpty((CharSequence)testLang)) {
                rootNode.setAttribute("TestLang", testLang);
            } else {
                rootNode.deleteAttribute("TestLang");
            }
            if (StringUtils.isNotEmpty((CharSequence)designEditorFactory)) {
                rootNode.setAttribute("DesignEditorFactory", designEditorFactory);
            } else {
                rootNode.deleteAttribute("DesignEditorFactory");
            }
            if (isEnableDiff) {
                rootNode.setAttribute("EnableDiff", "true");
            } else {
                rootNode.deleteAttribute("EnableDiff");
            }
        }
    }

    private void dealProjectCollection(Document document, TagNode rootNode) throws Throwable {
        DataTable project = document.get("ED_Project");
        project.setShowDeleted(true);
        if (!this.isTableChange(project)) {
            return;
        }
        project.setShowDeleted(false);
        rootNode.deleteChildByTagName("ProjectCollection");
        if (project.size() == 0) {
            return;
        }
        TagNode projectCollectionTag = rootNode.getOrCreateChildByTagName("ProjectCollection", 1);
        int i = 0;
        while (i < project.size()) {
            String projectKey = project.getString(i, "ProjectKey");
            String projectCaption = project.getString(i, "ProjectCaption");
            String refPath = project.getString(i, "RefPath");
            TagNode ProjectNode = new TagNode("Project", null);
            ProjectNode.setAttribute("Caption", projectCaption);
            ProjectNode.setAttribute("Key", projectKey);
            if (StringUtils.isNotEmpty((CharSequence)refPath)) {
                ProjectNode.setAttribute("RefPath", refPath);
            }
            projectCollectionTag.addNode(ProjectNode);
            ++i;
        }
    }

    private void dealInplaceToolbarCollection(Document document, TagNode rootNode) throws Throwable {
        DataTable inplaceToolbar = document.get("ED_InplaceToolbar");
        inplaceToolbar.setShowDeleted(true);
        if (!this.isTableChange(inplaceToolbar)) {
            return;
        }
        inplaceToolbar.setShowDeleted(false);
        rootNode.deleteChildByTagName("InplaceToolbarCollection");
        if (inplaceToolbar.size() == 0) {
            return;
        }
        TagNode inplaceToolbarCollectionTag = rootNode.getOrCreateChildByTagName("InplaceToolbarCollection", 3);
        int i = 0;
        while (i < inplaceToolbar.size()) {
            String tag = inplaceToolbar.getString(i, "Tag");
            String handler = inplaceToolbar.getString(i, "Handler");
            String description = inplaceToolbar.getString(i, "Description");
            TagNode inplaceToolbarNode = new TagNode("InplaceToolbar", null);
            if (StringUtils.isNotEmpty((CharSequence)description)) {
                inplaceToolbarNode.setAttribute("Description", description);
            }
            inplaceToolbarNode.setAttribute("Handler", handler);
            inplaceToolbarNode.setAttribute("Tag", tag);
            inplaceToolbarCollectionTag.addNode(inplaceToolbarNode);
            ++i;
        }
    }

    private void dealStartItemCollection(Document document, TagNode rootNode) throws Throwable {
        DataTable startItem = document.get("ED_StartItem");
        startItem.setShowDeleted(true);
        if (!this.isTableChange(startItem)) {
            return;
        }
        startItem.setShowDeleted(false);
        rootNode.deleteChildByTagName("StartItemCollection");
        if (startItem.size() == 0) {
            return;
        }
        TagNode StartItemCollectionTag = rootNode.getOrCreateChildByTagName("StartItemCollection");
        int i = 0;
        while (i < startItem.size()) {
            String platformKey = startItem.getString(i, "PlatformKey");
            String startFormKey = startItem.getString(i, "StartFormKey");
            String loginFormKey = startItem.getString(i, "LoginFormKey");
            String applicationKey = startItem.getString(i, "ApplicationKey");
            TagNode startItemNode = new TagNode("StartItem", null);
            startItemNode.setAttribute("LoginForm", loginFormKey);
            startItemNode.setAttribute("StartForm", startFormKey);
            startItemNode.setAttribute("Platform", platformKey);
            if (StringUtils.isNotEmpty((CharSequence)applicationKey)) {
                startItemNode.setAttribute("AppKey", applicationKey);
            }
            StartItemCollectionTag.addNode(startItemNode);
            ++i;
        }
    }

    private void dealPreLoadItemCollection(Document document, TagNode rootNode) throws Throwable {
        DataTable preLoadItem = document.get("ED_PreLoadItem");
        preLoadItem.setShowDeleted(true);
        if (!this.isTableChange(preLoadItem)) {
            return;
        }
        preLoadItem.setShowDeleted(false);
        rootNode.deleteChildByTagName("PreLoadItemCollection");
        if (preLoadItem.size() == 0) {
            return;
        }
        TagNode preLoadItemCollectionTag = rootNode.getOrCreateChildByTagName("PreLoadItemCollection", 5);
        int i = 0;
        while (i < preLoadItem.size()) {
            String preLoadItemKey = preLoadItem.getString(i, "PreLoadItemKey");
            String entryPath = preLoadItem.getString(i, "EntryPath");
            String condition = preLoadItem.getString(i, "Condition");
            boolean isClose = preLoadItem.getInt(i, "IsClose") == 1;
            String target = preLoadItem.getString(i, "Target");
            TagNode preLoadItemNode = new TagNode("PreLoadItem", null);
            preLoadItemNode.setAttribute("Key", preLoadItemKey);
            preLoadItemNode.setAttribute("EntryPath", entryPath);
            if (!"newtab".equals(target)) {
                preLoadItemNode.setAttribute("Target", target);
            }
            preLoadItemNode.setAttribute("Condition", condition);
            if (!isClose) {
                preLoadItemNode.setAttribute("Close", "false");
            }
            preLoadItemCollectionTag.addNode(preLoadItemNode);
            ++i;
        }
    }

    private void dealLangConfig(Document document, TagNode rootNode) throws Throwable {
        DataTable langConfig = document.get("ED_LangConfig");
        langConfig.setShowDeleted(true);
        if (!this.isTableChange(langConfig)) {
            return;
        }
        langConfig.setShowDeleted(false);
        rootNode.deleteChildByTagName("LangConfig");
        if (langConfig.size() == 0) {
            return;
        }
        TagNode preLoadItemCollectionTag = rootNode.getOrCreateChildByTagName("LangConfig", 7);
        int i = 0;
        while (i < langConfig.size()) {
            String langKey = langConfig.getString(i, "LangKey");
            String langDescription = langConfig.getString(i, "LangDescription");
            String langSuffix = langConfig.getString(i, "LangSuffix");
            BigDecimal widthMultiple = langConfig.getNumeric(i, "WidthMultiple");
            TagNode LangNode = new TagNode("Lang", null);
            LangNode.setAttribute("Description", langDescription);
            LangNode.setAttribute("Key", langKey);
            LangNode.setAttributeNotRemove("Suffix", langSuffix);
            LangNode.setAttribute("WidthMultiple", widthMultiple.toString());
            preLoadItemCollectionTag.addNode(LangNode);
            ++i;
        }
    }
}

