/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.mergesingle.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.XmlDiffProcessor;
import com.bokesoft.yes.design.io.IOMetaObject;
import com.bokesoft.yes.design.mergesingle.impl.SingleSettingImpl;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGridLayoutPanel;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class LayoutOperUtil
extends SingleSettingImpl {
    @Override
    public void dealData(Document document, Diff diff, JSONObject jsonObject) throws Throwable {
        TagNode curNode;
        String key;
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        String ownerFormKey = diff.formKey;
        MetaForm ownerMetaForm = StringUtils.isBlank((CharSequence)ownerFormKey) ? null : MetaFactory.getGlobalInstance().getMetaForm(ownerFormKey);
        MetaComponent comp = IOMetaObject.getComponentByKey(ownerMetaForm, key = diff.getKey());
        if (comp != null && comp.getControlType() == 305) {
            String xmlTreeKey = "GridLayout@" + diff.getReserveOne();
            curNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
        } else {
            MetaGridLayoutPanel metaGridLayoutPanel = (MetaGridLayoutPanel)IOMetaObject.getComponentByKey(ownerMetaForm, key);
            if (Objects.isNull(metaGridLayoutPanel) && diff.getContainerKey() != null) {
                ownerMetaForm = StringUtils.isBlank((CharSequence)ownerFormKey) ? null : MetaFactory.getGlobalInstance().getMetaForm(diff.getContainerKey());
                metaGridLayoutPanel = (MetaGridLayoutPanel)IOMetaObject.getComponentByKey(ownerMetaForm, key);
            }
            String tagName = metaGridLayoutPanel.getTagName();
            String xmlTreeKey = XmlDiffProcessor.getXmlTreeKey(diff, tagName, key);
            curNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
        }
        this.dealLayoutRow(document, diff, curNode);
        this.dealLayoutColumn(document, diff, curNode);
        this.setTagNode(curNode);
    }

    private void dealLayoutRow(Document document, Diff diff, TagNode curNode) throws Throwable {
        int row;
        DataTable RheadTable = document.get("ED_RowHead");
        DataTable RDetailTable = document.get("ED_RowDetail");
        if (RheadTable.isEmpty()) {
            row = RheadTable.append();
            RheadTable.setObject(row, "RowGap", (Object)"1");
            RheadTable.setObject(row, "RowDefHeight", (Object)0);
            RheadTable.setObject(row, "RowNum", (Object)1);
            RheadTable.setState(2);
        }
        if (RDetailTable.isEmpty()) {
            row = RDetailTable.append();
            RheadTable.setObject(row, "RowGap", (Object)"1");
            RDetailTable.setObject(row, "Type", (Object)0);
            RDetailTable.setObject(row, "RowDefHeight", (Object)30);
            RDetailTable.setObject(row, "RowNum", (Object)1);
            RDetailTable.setState(2);
        }
        int rowNum = RheadTable.getInt(0, "RowNum");
        TagNode rowNode = curNode.getOrCreateChildByKey("RowDefCollection", "");
        rowNode.setAttribute("RowGap", String.valueOf(RheadTable.getInt(0, "RowGap")));
        String rowDefHeight = String.valueOf(RheadTable.getInt(0, "RowDefHeight"));
        if (!"0".equals(rowDefHeight)) {
            rowNode.setAttribute("RowHeight", rowDefHeight);
        }
        this.dealGridLayoutRowDetail(rowNode, RDetailTable, diff, rowNum, curNode);
    }

    private void dealGridLayoutRowDetail(TagNode rowNode, DataTable RDetailTable, Diff diff, int rowNum, TagNode gridNode) throws Throwable {
        List<AbstractNode> childrenNode = rowNode.getChildren();
        int RDsize = RDetailTable.size();
        childrenNode.clear();
        RDetailTable.setShowDeleted(false);
        int i = 0;
        while (i < rowNum) {
            String height;
            DefSize defSize;
            TagNode node;
            if (i >= RDsize) {
                node = new TagNode("RowDef", null);
                defSize = new DefSize(0, 32);
                height = defSize.toString();
                node.setAttribute("Height", height);
                childrenNode.add(node);
            } else {
                node = new TagNode("RowDef", null);
                defSize = new DefSize(Integer.parseInt(RDetailTable.getString(i, "Type")), RDetailTable.getInt(i, "RowDefHeight").intValue());
                height = defSize.toString();
                node.setAttribute("Height", height);
                childrenNode.add(node);
            }
            ++i;
        }
    }

    private void dealLayoutColumn(Document document, Diff diff, TagNode curNode) throws Throwable {
        int row;
        DataTable CheadTable = document.get("ED_ColumnHead");
        DataTable CDetailTable = document.get("ED_ColumnDetail");
        if (CheadTable.isEmpty()) {
            row = CheadTable.append();
            CheadTable.setObject(row, "ColumnGap", (Object)"1");
            CheadTable.setObject(row, "ColumnNum", (Object)1);
            CheadTable.setState(2);
        }
        if (CDetailTable.isEmpty()) {
            row = CDetailTable.append();
            CheadTable.setObject(row, "ColumnGap", (Object)"1");
            CDetailTable.setObject(row, "Width", (Object)100);
            CDetailTable.setObject(row, "Type", (Object)0);
            CDetailTable.setObject(row, "RowNum", (Object)1);
            CDetailTable.setState(2);
        }
        int columnNum = CheadTable.getInt(0, "ColumnNum");
        TagNode columnNode = curNode.getOrCreateChildByKey("ColumnDefCollection", "");
        columnNode.setAttribute("ColumnGap", String.valueOf(CheadTable.getInt(0, "ColumnGap")));
        this.dealGridLayoutColumnDetail(columnNode, CDetailTable, diff, columnNum, curNode);
    }

    private void dealGridLayoutColumnDetail(TagNode ColumnNode, DataTable CDetailTable, Diff diff, int columnNum, TagNode gridNode) throws Throwable {
        List<AbstractNode> childrenNode = ColumnNode.getChildren();
        childrenNode.clear();
        int CDsize = CDetailTable.size();
        int i = 0;
        while (i < columnNum) {
            TagNode node;
            if (i >= CDsize) {
                node = new TagNode("ColumnDef", null);
                childrenNode.add(node);
            } else {
                node = new TagNode("ColumnDef", null);
                DefSize defSize = new DefSize(Integer.parseInt(CDetailTable.getString(i, "Type")), CDetailTable.getInt(i, "Width").intValue());
                if (CDetailTable.getString(i, "MinType") != null && CDetailTable.getString(i, "MinWidth") != null && !"".equals(CDetailTable.getString(i, "MinType")) && !"".equals(CDetailTable.getString(i, "MinWidth"))) {
                    DefSize mindefSize = new DefSize(Integer.parseInt(CDetailTable.getString(i, "MinType")), Integer.parseInt(CDetailTable.getString(i, "MinWidth")));
                    String MinWidth = mindefSize.toString();
                    node.setAttribute("MinWidth", MinWidth);
                }
                String height = defSize.toString();
                node.setAttribute("Width", height);
                childrenNode.add(node);
            }
            ++i;
        }
    }
}

