/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.dataObject.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.IndexFacade;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.IndexFileWrapper;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.MetaObjectType;
import com.bokesoft.yes.design.Property;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.CommitDiffCmd;
import com.bokesoft.yes.design.cmd.XmlDiffProcessor;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.datamap.util.DataMapOperJsonUtil;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.DesignReloadMetaObject;
import com.bokesoft.yes.design.vo.DataObjectVO;
import com.bokesoft.yes.design.vo.ResponseResult;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.node.Xml4jUtil;
import com.bokesoft.yes.design.xml.node.XmlTree;
import com.bokesoft.yes.design.xml.parse.Element;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.helper.MetaFormHelper;
import com.bokesoft.yigo.common.def.ColumnRightsType;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DataSplitType;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.SortType;
import com.bokesoft.yigo.meta.datamigration.DMPeriodGranularityType;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectList;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaEmbed;
import com.bokesoft.yigo.meta.form.component.container.MetaSubDetail;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONArray;

public class DataObjectOperJsonUtil {
    private static final Logger logger = Logger.getLogger(DataMapOperJsonUtil.class.getName());
    private static final List<String> systemFields = Arrays.asList("ClientID", "Notes", "ResetPattern", "SequenceValue", "StatusItem");

    public ResponseResult<JSONObject> handleDataObject(String formkey, Document document, List<Diff> diffs) throws Throwable {
        JSONObject jsonObject = new JSONObject();
        for (Diff diff : diffs) {
            String tempPath;
            DataTable fieldTable;
            String formPath = this.handleDataObjectByOidFilter(diff, diffs, document);
            if (StringUtils.isNotBlank((CharSequence)formPath)) {
                jsonObject.put("xmlPath_form", (Object)formPath);
                continue;
            }
            if (!diff.isPropertyDiff()) continue;
            DataTable headTable = document.get("ED_DataObjectFormHead");
            if (Objects.isNull(headTable)) {
                headTable = document.get("ED_DataObjectHead");
            }
            if (Objects.isNull(fieldTable = document.get("ED_DataObjectField"))) {
                fieldTable = document.get("ED_TableFields");
            }
            if (Objects.equals(headTable.getObject("AuxiliaryType"), "Migration")) {
                boolean isSetGroupField = false;
                int i = 0;
                while (i < fieldTable.size()) {
                    String groupType = fieldTable.getString(i, "GroupType");
                    boolean bl = isSetGroupField = !StringUtils.equals((CharSequence)groupType, (CharSequence)"-1");
                    if (isSetGroupField) break;
                    ++i;
                }
                if (!isSetGroupField) {
                    ResponseResult<JSONObject> result = new ResponseResult<JSONObject>();
                    jsonObject.put("code", (Object)-1);
                    jsonObject.put("msg", (Object)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8bbe\u7f6e\u5206\u7ec4\u5b57\u6bb5");
                    result.setData(jsonObject);
                    return result;
                }
            }
            CommitDiffCmd.loadXmlTrees(diffs, "", "DataObject");
            XmlTreeWithPath xmlTree = diff.getXmlTree();
            if (Objects.isNull(xmlTree)) {
                throw new RuntimeException("warning: \u4fee\u6539\u6570\u636e\u6e90\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u5185\u5bb9\u662f\u5426\u6b63\u786e\u3002");
            }
            String mainTableNodeKey = headTable.getString("MainTable");
            diff.setReserveTwo(mainTableNodeKey);
            DataTable collecTable = document.get("ED_DataObjectCollection");
            if (Objects.isNull(collecTable)) {
                collecTable = document.get("ED_TableCollection");
            }
            DataTable ed_parameterCollection = document.get("ED_ParameterCollection");
            DataTable ed_indexCollection = document.get("ED_IndexCollection");
            XmlDiffProcessor.dealHeadTable(xmlTree, headTable, collecTable, fieldTable, ed_parameterCollection, ed_indexCollection, diff);
            XmlDiffProcessor.dealEmbedTable(xmlTree, document, diff);
            XmlDiffProcessor.dealEventTable(xmlTree, document, diff);
            XmlFileProcessor.instance.processDiff(diffs, false);
            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
            MetaDataObjectProfile metaDataObjectProfile = (MetaDataObjectProfile)dataObjectList.get(formkey);
            String mergeToSourceMapKey = "";
            if (Objects.nonNull(metaDataObjectProfile)) {
                if (StringUtils.isNotBlank((CharSequence)metaDataObjectProfile.getExtend())) {
                    String extendPath = LoadFileTree.loadFilePathByDataObjectFieldKey(metaDataObjectProfile.getExtend());
                    tempPath = XmlFileProcessor.instance.getTmpFile(extendPath);
                    extendPath = StringUtils.isNotBlank((CharSequence)tempPath) ? tempPath : extendPath;
                    DataObjectHelper.reload(null, metaDataObjectProfile.getExtend(), extendPath, null);
                } else {
                    MetaDataObject metaDataObject = metaDataObjectProfile.getDataObject();
                    if (Objects.nonNull(metaDataObject)) {
                        mergeToSourceMapKey = metaDataObject.getMergeToSourceMapKey();
                    }
                }
            }
            String path = diff.getFilePath();
            tempPath = XmlFileProcessor.instance.getTmpFile(path);
            DataObjectHelper.reload(null, formkey, tempPath, null);
            if (StringUtils.isNotBlank((CharSequence)mergeToSourceMapKey)) {
                String vestPath = LoadFileTree.loadFilePathByDataObjectFieldKey(mergeToSourceMapKey);
                String tempVestPath = XmlFileProcessor.instance.getTmpFile(vestPath);
                vestPath = StringUtils.isNotBlank((CharSequence)tempVestPath) ? tempVestPath : vestPath;
                DataObjectHelper.reload(null, mergeToSourceMapKey, vestPath, null);
            }
            String newContent = FileUtils.readFileToString((File)new File(tempPath), (String)"UTF-8");
            jsonObject.put("xmlPath", (Object)(StringUtils.isBlank((CharSequence)path) ? path : FilePathHelper.toFrontFilePath(path)));
            jsonObject.put("newXml", (Object)newContent);
            if (!StringUtils.isNotBlank((CharSequence)path)) continue;
            String tempFilePath = XmlFileProcessor.instance.getTmpFile(path);
            IndexFileWrapper file = IndexFileWrapper.newInstance((String)path, (String)tempFilePath);
            IndexFacade.reload((IndexFileWrapper)file);
        }
        ResponseResult<JSONObject> result = new ResponseResult<JSONObject>();
        jsonObject.put("code", (Object)0);
        jsonObject.put("msg", (Object)"\u64cd\u4f5c\u6570\u636e\u5bf9\u8c61\u6210\u529f");
        result.setData(jsonObject);
        return result;
    }

    public ResponseResult<JSONObject> FieldinforOrBasicAttribute(DataObjectVO dataObjectVO) throws Throwable {
        ResponseResult<JSONObject> result = new ResponseResult<JSONObject>();
        JSONObject jsonObject = new JSONObject();
        try {
            String diffJsonString = dataObjectVO.getDiff();
            JSONArray array = new JSONArray(diffJsonString);
            int len = array.length();
            ArrayList<Diff> diffs = new ArrayList<Diff>(len);
            int i = 0;
            while (i < len) {
                diffs.add(Diff.fromJson(array.getJSONObject(i)));
                ++i;
            }
            for (Diff diff : diffs) {
                if (!diff.isPropertyDiff()) continue;
                CommitDiffCmd.loadXmlTrees(diffs, "", "DataObject");
                XmlTreeWithPath xmlTree = diff.getXmlTree();
                if (diff.getMetaObjectType() == MetaObjectType.Fieldinformation) {
                    XmlDiffProcessor.handleFieldinformation(diff, xmlTree);
                }
                String path = diff.getFilePath();
                diff.setFilePath(path);
                XmlFileProcessor.instance.processDiff(diffs, false);
                String tempPath = XmlFileProcessor.instance.getTmpFile(path);
                String newContent = FileUtils.readFileToString((File)new File(tempPath), (String)"UTF-8");
                jsonObject.put("xmlPath", (Object)path);
                jsonObject.put("newXml", (Object)newContent);
            }
            result.setCode(0);
            result.setMsg("\u64cd\u4f5c\u6570\u636e\u5bf9\u8c61\u6210\u529f");
            result.setData(jsonObject);
        }
        catch (Exception e) {
            logger.warning("\u64cd\u4f5c\u6570\u636e\u5bf9\u8c61\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            result.setCode(999);
            result.setMsg("\u64cd\u4f5c\u6570\u636e\u5bf9\u8c61\u5931\u8d25\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        return result;
    }

    private static boolean exist(TagNode tagNode, String primary) {
        boolean equals = false;
        List<AbstractNode> children = tagNode.getChildren();
        for (AbstractNode child : children) {
            String primaryKey;
            if (!(child instanceof TagNode) || !primary.equals(primaryKey = ((TagNode)child).getPrimaryKey())) continue;
            equals = true;
            break;
        }
        return equals;
    }

    public ResponseResult<JSONObject> getKey(DataObjectVO dataObjectVO) {
        String key = dataObjectVO.getKey();
        String formkey = dataObjectVO.getFormkey();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", (Object)999);
        try {
            MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(formkey);
            List allComponents = metaForm.getAllComponents();
            for (MetaComponent allComponent : allComponents) {
                String allComponentKey = allComponent.getKey();
                if (!(allComponent instanceof MetaSubDetail) || !((MetaSubDetail)allComponent).getRoot().getKey().equalsIgnoreCase(key)) continue;
                jsonObject.put("subKey", (Object)allComponentKey);
                jsonObject.put("code", (Object)0);
                jsonObject.put("msg", (Object)"\u64cd\u4f5c\u6570\u636e\u6210\u529f");
            }
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        ResponseResult<JSONObject> result = new ResponseResult<JSONObject>();
        result.setData(jsonObject);
        return result;
    }

    public String getEmbedKey(DataObjectVO dataObjectVO) {
        String formkey = dataObjectVO.getFormkey();
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        try {
            MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(formkey);
            for (MetaEmbed embed : metaForm.getEmbeds()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("Key", (Object)embed.getKey());
                jsonObjects.add(jsonObject);
            }
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
        return ((Object)jsonObjects).toString();
    }

    public static void dealHeadTable(XmlTreeWithPath xmlTree, String controlerType, String primaryKey, DataTable headTable, DataTable collecTable, DataTable fieldTable, DataTable ed_parameterCollection, Diff diff, String formKey) throws Throwable {
        TagNode parentNode;
        controlerType = MetaObjectType.DataObject.name;
        MetaDataObject curDataObject = null;
        if (diff.getDataObject() != null) {
            curDataObject = DataObjectHelper.loadByKey(diff.getDataObject().getKey());
        }
        if (xmlTree.xmlTree.getRoot().findNodesByTagName(MetaObjectType.DataObject.name).size() == 0) {
            List<TagNode> dataSource = xmlTree.xmlTree.getRoot().findNodesByTagName("DataSource");
            if (dataSource.size() <= 0) {
                DataObjectOperJsonUtil.genXmlDiff(xmlTree, xmlTree.xmlTree.getRoot(), diff, true);
                return;
            }
            MetaDataObject metaDataObject = MetaFactory.getGlobalInstance().getDataObject(dataSource.get(0).getAttributes().get("RefObjectKey"));
            String filePath = LoadFileTree.loadFilePathByDataObjectFieldKey(metaDataObject.getKey());
            XmlTreeWithPath dataObjectXmlTree = XmlTreeWithPath.parseFilePath(filePath);
            parentNode = dataObjectXmlTree.xmlTree.getRoot().findNodesByTagName(MetaObjectType.DataObject.name).get(0);
        } else {
            parentNode = xmlTree.xmlTree.getRoot().findNodesByTagName(MetaObjectType.DataObject.name).get(0);
        }
        int i = 0;
        while (i < headTable.size()) {
            primaryKey = (String)headTable.getOriginalObject(i, "Mark");
            String mark = headTable.getString(i, "Mark");
            String caption = headTable.getString(i, "Caption");
            String mainTable = headTable.getString(i, "MainTable");
            String mainType = headTable.getString(i, "MainType");
            if ("Virtual".equals(mainType)) {
                parentNode.getAttributes().remove("PrimaryType");
                parentNode.getAttributes().remove("SecondaryType");
                parentNode.getAttributes().remove("QueryFields");
                parentNode.getAttributes().remove("DisplayFields");
            } else {
                parentNode.setAttribute("PrimaryType", mainType);
            }
            String displayFields = headTable.getString(i, "DisplayFields");
            String queryFields = headTable.getString(i, "QueryFields");
            String loadRightsType = headTable.getString(i, "LoadRightsType");
            String checkAfterLoad = headTable.getString(i, "CheckAfterLoad");
            parentNode.setAttribute("Key", mark);
            parentNode.setAttribute("Caption", caption);
            boolean hasPrimaryTable = false;
            int j = 0;
            while (j < collecTable.size()) {
                boolean bl = hasPrimaryTable = collecTable.getBoolean(j, "IsPrimaryTable") != false || "1".equals(collecTable.getString(j, "IsPrimaryTable"));
                if (hasPrimaryTable) break;
                ++j;
            }
            if (!hasPrimaryTable) {
                mainTable = "";
            }
            parentNode.setAttribute("PrimaryTableKey", mainTable);
            if (loadRightsType != null) {
                parentNode.setAttribute("LoadRightsType", loadRightsType);
            }
            parentNode.setAttribute("CheckAfterLoad", checkAfterLoad);
            String maintainDict = headTable.getString(i, "MaintainDict");
            parentNode.setAttribute("MaintainDict", maintainDict);
            String auxiliaryType = headTable.getString("AuxiliaryType");
            DataObjectOperJsonUtil.dealCollecTable(xmlTree, controlerType, primaryKey, collecTable, fieldTable, diff, formKey, ed_parameterCollection, curDataObject);
            parentNode.setAttribute("SecondaryType", auxiliaryType);
            if ("Dict".equalsIgnoreCase(auxiliaryType) || "ChainDict".equalsIgnoreCase(auxiliaryType)) {
                parentNode.setAttribute("DisplayFields", displayFields);
                parentNode.setAttribute("QueryFields", queryFields);
            } else {
                parentNode.getAttributes().remove("DisplayFields");
                parentNode.getAttributes().remove("QueryFields");
            }
            if (auxiliaryType.equalsIgnoreCase("Normal") || auxiliaryType.equalsIgnoreCase("Migration")) {
                if (auxiliaryType.equalsIgnoreCase("Migration") && !hasPrimaryTable) {
                    throw new Throwable("\u8fc1\u79fb\u8868\u5fc5\u987b\u5b58\u5728\u4e3b\u8868");
                }
                TagNode detailnode = xmlTree.xmlTree.getTagNode("Table@" + mainTable);
                if (Objects.isNull(detailnode)) {
                    DataObjectOperJsonUtil.genXmlDiff(xmlTree, parentNode, diff, true);
                    return;
                }
            } else if (auxiliaryType.equalsIgnoreCase("ChainDict") || auxiliaryType.equalsIgnoreCase("Dict")) {
                TagNode tagNode = xmlTree.xmlTree.getTagNode("Table@" + mainTable);
                if (Objects.isNull(tagNode)) {
                    DataObjectOperJsonUtil.genXmlDiff(xmlTree, parentNode, diff, true);
                    return;
                }
                if (!DataObjectOperJsonUtil.exist(tagNode, "Column@Code")) {
                    TagNode column = new TagNode("Column", null);
                    column.setAttribute("Key", "Code");
                    column.setAttribute("Caption", "\u4ee3\u7801");
                    column.setAttribute("DataType", "Varchar");
                    column.setAttribute("Length", "50");
                    tagNode.addNode(column);
                }
                if (!DataObjectOperJsonUtil.exist(tagNode, "Column@Name")) {
                    TagNode column1 = new TagNode("Column", null);
                    column1.setAttribute("Key", "Name");
                    column1.setAttribute("Caption", "\u540d\u79f0");
                    column1.setAttribute("DataType", "Varchar");
                    column1.setAttribute("Length", "100");
                    tagNode.addNode(column1);
                }
                if (!DataObjectOperJsonUtil.exist(tagNode, "Column@Enable")) {
                    TagNode column2 = new TagNode("Column", null);
                    column2.setAttribute("Key", "Enable");
                    column2.setAttribute("Caption", "\u542f\u7528\u6807\u8bb0");
                    column2.setAttribute("DataType", "Integer");
                    tagNode.addNode(column2);
                }
                if (!DataObjectOperJsonUtil.exist(tagNode, "Column@ParentID")) {
                    TagNode column3 = new TagNode("Column", null);
                    column3.setAttribute("Key", "ParentID");
                    column3.setAttribute("Caption", "\u7236\u8282\u70b9");
                    column3.setAttribute("DataType", "Long");
                    tagNode.addNode(column3);
                }
                if (!DataObjectOperJsonUtil.exist(tagNode, "Column@NodeType")) {
                    TagNode column4 = new TagNode("Column", null);
                    column4.setAttribute("Key", "NodeType");
                    column4.setAttribute("Caption", "\u8282\u70b9\u7c7b\u578b");
                    column4.setAttribute("DataType", "Integer");
                    tagNode.addNode(column4);
                }
                if (!DataObjectOperJsonUtil.exist(tagNode, "Column@TLeft")) {
                    TagNode column5 = new TagNode("Column", null);
                    column5.setAttribute("Key", "TLeft");
                    column5.setAttribute("Caption", "TLeft");
                    column5.setAttribute("DataType", "Integer");
                    tagNode.addNode(column5);
                }
                if (!DataObjectOperJsonUtil.exist(tagNode, "Column@TRight")) {
                    TagNode column6 = new TagNode("Column", null);
                    column6.setAttribute("Key", "TRight");
                    column6.setAttribute("Caption", "TRight");
                    column6.setAttribute("DataType", "Integer");
                    tagNode.addNode(column6);
                }
                if (!DataObjectOperJsonUtil.exist(tagNode, "Column@ForeignName")) {
                    TagNode column7 = new TagNode("Column", null);
                    column7.setAttribute("Key", "ForeignName");
                    column7.setAttribute("Caption", "\u540d\u79f0(\u5916\u6587)");
                    column7.setAttribute("DataType", "Varchar");
                    column7.setAttribute("Length", "255");
                    tagNode.addNode(column7);
                }
            }
            ++i;
        }
        DataObjectOperJsonUtil.genXmlDiff(xmlTree, diff.getXmlTree().xmlTree.getRoot(), diff, true);
    }

    public static void genXmlDiff(XmlTreeWithPath xmlTree, TagNode node, Diff diff, boolean isFirst) {
        Element element = node.getElement();
        int startLine = xmlTree.xmlTree.getLineByIndex(element.getBgIndex());
        String orgXmlFragment = xmlTree.xmlTree.getNodeString(startLine);
        String newXmlFragment = DesignIOMetaUtil.getXml(node);
        if (isFirst) {
            diff.setXmlDiff(xmlTree, startLine, orgXmlFragment, newXmlFragment);
        } else {
            diff.setXmlDiff2(xmlTree, startLine, orgXmlFragment, newXmlFragment);
        }
    }

    private static void dealCollecTable(XmlTreeWithPath xmlTree, String controlerType, String primaryKey, DataTable collecTable, DataTable fieldTable, Diff diff, String formKey, DataTable ed_parameterCollection, MetaDataObject curDataObject) throws Throwable {
        controlerType = MetaObjectType.table.name;
        collecTable.setShowDeleted(true);
        int i = 0;
        while (i < collecTable.size()) {
            int rowState = collecTable.getState(i);
            TagNode parentNode = null;
            TagNode dataObjectNoed = null;
            if (xmlTree.xmlTree.getRoot().findNodesByTagName(MetaObjectType.DataObject.name).size() == 0) {
                MetaDataObject metaDataObject = MetaFactory.getGlobalInstance().getDataObject(xmlTree.xmlTree.getRoot().findNodesByTagName("DataSource").get(0).getAttributes().get("RefObjectKey"));
                String filePath = LoadFileTree.loadFilePathByDataObjectFieldKey(metaDataObject.getKey());
                XmlTreeWithPath dataObjectxmlTree = XmlTreeWithPath.parseFilePath(filePath);
                parentNode = dataObjectxmlTree.xmlTree.getRoot().findNodesByTagName(MetaObjectType.tableCollection.name).get(0);
                dataObjectNoed = dataObjectxmlTree.xmlTree.getRoot().findNodesByTagName(MetaObjectType.tableCollection.name).get(0).getParent();
            } else {
                parentNode = xmlTree.xmlTree.getRoot().findNodesByTagName(MetaObjectType.tableCollection.name).get(0);
                dataObjectNoed = xmlTree.xmlTree.getRoot().findNodesByTagName(MetaObjectType.tableCollection.name).get(0).getParent();
            }
            Long parentOID = null;
            String xmlTreeKey = null;
            TagNode curNode = null;
            String tableMode = null;
            String isPrimariy = null;
            primaryKey = (String)collecTable.getOriginalObject(i, "TableMark");
            String TableMark = collecTable.getString(i, "TableMark");
            String AssociationTable = collecTable.getString(i, "AssociationTable");
            if (StringUtils.isBlank((CharSequence)primaryKey)) {
                primaryKey = TableMark;
            }
            String TableName = collecTable.getString(i, "TableName");
            String parentTableKey = collecTable.getString(i, "ParentTableKey");
            Integer DataTableMode = collecTable.getInt(i, "TableMode");
            if (DataTableMode == 0) {
                tableMode = "Head";
            } else if (1 == DataTableMode) {
                tableMode = "Detail";
            }
            xmlTreeKey = DataObjectOperJsonUtil.getXmlTreeKey(diff, controlerType, primaryKey);
            curNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
            String tagName = xmlTree.xmlTree.getRoot().getTagName();
            if (MetaObjectType.DataObject.name.equals(tagName)) {
                String key = xmlTree.xmlTree.getRoot().getAttributes().get("Key");
                key.equals(formKey);
            }
            if (Objects.isNull(curNode)) {
                xmlTreeKey = DataObjectOperJsonUtil.getXmlTreeKey(diff, controlerType, TableMark);
                curNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
            }
            if (2 == rowState || rowState == 0) {
                String newValue;
                parentOID = collecTable.getLong(i, "OID");
                String dataType = dataObjectNoed.getAttributes().get("SecondaryType");
                if (StringUtils.isBlank((CharSequence)dataType)) {
                    dataType = "Normal";
                }
                DataObjectOperJsonUtil.dealFieldTable(xmlTree, controlerType, fieldTable, diff, curNode, parentOID, curDataObject);
                isPrimariy = String.valueOf(collecTable.getString(i, "IsPrimaryTable"));
                DataObjectOperJsonUtil.dealPrimariyTable(xmlTree, isPrimariy, diff, curNode, dataType);
                if (!curNode.getAttributes().get("Key").equalsIgnoreCase(TableMark) && !"DataObject".equalsIgnoreCase(diff.getReserveOne())) {
                    String orgKey = curNode.getAttributes().get("Key");
                    TagNode bodyNode = xmlTree.xmlTree.getRoot().getOrCreateChildByTagName("Body");
                    List<TagNode> nodeList = bodyNode.findNodesByTagName("DataBinding");
                    for (TagNode tagNode : nodeList) {
                        if (tagNode.getAttributes().get("TableKey") == null || !tagNode.getAttributes().get("TableKey").equalsIgnoreCase(orgKey)) continue;
                        tagNode.setAttribute("TableKey", TableMark);
                    }
                    List<TagNode> rowNodeList = bodyNode.findNodesByTagName("GridRow");
                    Iterator iterator = rowNodeList.iterator();
                    while (iterator.hasNext()) {
                        TagNode tagNode = (TagNode)iterator.next();
                        if (tagNode.getAttributes().get("TableKey") == null || !tagNode.getAttributes().get("TableKey").equalsIgnoreCase(orgKey)) continue;
                        tagNode.setAttribute("TableKey", TableMark);
                    }
                }
                if (curNode.getAttributes().get("Key").equalsIgnoreCase(curNode.getParent().getParent().getAttributes().get("PrimaryTableKey"))) {
                    curNode.getParent().getParent().setAttribute("PrimaryTableKey", TableMark);
                }
                curNode.setAttribute("Key", TableMark);
                curNode.setAttribute("Caption", TableName);
                if (StringUtils.isNotEmpty((CharSequence)AssociationTable)) {
                    curNode.setAttribute("DBTableName", AssociationTable);
                }
                curNode.setAttribute("ParentKey", "\u65e0\u6570\u636e\u8868".equalsIgnoreCase(parentTableKey) ? "" : parentTableKey);
                if ("0".equalsIgnoreCase(parentTableKey)) {
                    curNode.getAttributes().remove("ParentKey");
                }
                curNode.setAttribute("TableMode", tableMode);
                curNode.setAttribute("Persist", collecTable.getInt(i, "Persist") == 1 ? "true" : "false");
                if ("true".equalsIgnoreCase(curNode.getAttributes().get("Persist"))) {
                    curNode.getAttributes().remove("Persist");
                }
                curNode.setAttribute("GroupBy", collecTable.getString(i, "GroupBy"));
                if (collecTable.getString(i, "GroupBy").isEmpty()) {
                    curNode.getAttributes().remove("GroupBy");
                }
                curNode.setAttribute("Formula", collecTable.getString(i, "Formula"));
                if (StringUtils.isBlank((CharSequence)collecTable.getString(i, "Formula"))) {
                    curNode.getAttributes().remove("Formula");
                }
                curNode.setAttribute("IndexPrefix", collecTable.getString(i, "IndexPrefix"));
                if (StringUtils.isBlank((CharSequence)collecTable.getString(i, "IndexPrefix"))) {
                    curNode.getAttributes().remove("IndexPrefix");
                }
                curNode.setAttribute("Impl", collecTable.getString(i, "Impl"));
                if (StringUtils.isBlank((CharSequence)collecTable.getString(i, "Impl"))) {
                    curNode.getAttributes().remove("Impl");
                }
                curNode.setAttribute("OrderBy", collecTable.getString(i, "OrderBy"));
                if (collecTable.getString(i, "OrderBy").isEmpty()) {
                    curNode.getAttributes().remove("OrderBy");
                }
                TagNode childByTagNameOne = curNode.getOrCreateChildByTagName("Statement");
                childByTagNameOne.setCDataValue(collecTable.getString(i, "Statement"));
                if (StringUtils.isBlank((CharSequence)collecTable.getString(i, "Statement"))) {
                    curNode.deleteChildByTagName("Statement");
                }
                curNode.getOrCreateChildByTagName("Statement").setAttribute("Type", collecTable.getString(i, "QueryType"));
                if (StringUtils.isEmpty((CharSequence)collecTable.getString(i, "QueryType"))) {
                    curNode.getOrCreateChildByTagName("Statement").getAttributes().remove("Type");
                }
                if (MetaObjectType.DataObject.name.equalsIgnoreCase(newValue = collecTable.getString(i, "Type"))) {
                    curNode.getAttributes().remove("SourceType");
                    curNode.deleteChildByTagName("Statement");
                } else {
                    curNode.setAttribute("SourceType", newValue);
                    if (!"Query".equals(newValue)) {
                        curNode.deleteChildByTagName("Statement");
                    }
                }
                TagNode childByTagName = curNode.getOrCreateChildByTagName("TableFilter");
                childByTagName.setAttribute("Type", collecTable.getString(i, "TableFilterType"));
                if (StringUtils.isNotEmpty((CharSequence)collecTable.getString(i, "TableFilter"))) {
                    childByTagName.setCDataValue(collecTable.getString(i, "TableFilter"));
                    childByTagName.setAttribute("Type", collecTable.getString(i, "TableFilterType"));
                } else if (StringUtils.isNotEmpty((CharSequence)collecTable.getString(i, "TableFilterTwo"))) {
                    childByTagName.setCDataValue(collecTable.getString(i, "TableFilterTwo"));
                } else {
                    curNode.getChildren().remove(childByTagName);
                }
                if (!primaryKey.equalsIgnoreCase(TableMark)) {
                    DataObjectOperJsonUtil.replaceTableKey(diff, primaryKey, TableMark);
                }
            } else if (1 == rowState) {
                boolean ishas = false;
                TagNode node = new TagNode(controlerType, null);
                List<TagNode> table = parentNode.findNodesByTagName("Table");
                for (TagNode tagNode : table) {
                    if (!tagNode.getAttributes().get("Key").equals(TableMark)) continue;
                    ishas = true;
                }
                if (!ishas) {
                    String newValue;
                    node.setAttribute("Key", TableMark);
                    node.setAttribute("Caption", TableName);
                    node.setAttribute("DBTableName", AssociationTable);
                    node.setAttribute("IndexPrefix", TableMark);
                    node.setAttribute("ParentKey", "\u65e0\u6570\u636e\u8868".equalsIgnoreCase(parentTableKey) ? "" : parentTableKey);
                    if ("0".equalsIgnoreCase(parentTableKey)) {
                        node.getAttributes().remove("ParentKey");
                    }
                    node.setAttribute("TableMode", tableMode);
                    node.setAttribute("Persist", collecTable.getInt(i, "Persist") == 1 ? "true" : "false");
                    if (collecTable.getInt(i, "Persist") == 1) {
                        node.getAttributes().remove("Persist");
                    }
                    node.setAttribute("GroupBy", collecTable.getString(i, "GroupBy"));
                    if (collecTable.getString(i, "GroupBy").isEmpty()) {
                        node.getAttributes().remove("GroupBy");
                    }
                    node.setAttribute("Formula", collecTable.getString(i, "Formula"));
                    if (collecTable.getString(i, "Formula").isEmpty()) {
                        node.getAttributes().remove("Formula");
                    }
                    node.setAttribute("Impl", collecTable.getString(i, "Impl"));
                    if (collecTable.getString(i, "Impl").isEmpty()) {
                        node.getAttributes().remove("Impl");
                    }
                    node.setAttribute("OrderBy", collecTable.getString(i, "OrderBy"));
                    if (collecTable.getString(i, "OrderBy").isEmpty()) {
                        node.getAttributes().remove("OrderBy");
                    }
                    node.setAttribute("IndexPrefix", collecTable.getString(i, "IndexPrefix"));
                    if (collecTable.getString(i, "IndexPrefix").isEmpty()) {
                        node.getAttributes().remove("IndexPrefix");
                    }
                    node.getOrCreateChildByTagName("Statement").setAttribute("Type", collecTable.getString(i, "QueryType"));
                    if (collecTable.getString(i, "QueryType").isEmpty()) {
                        node.getOrCreateChildByTagName("Statement").getAttributes().remove("QueryType");
                    }
                    if (MetaObjectType.DataObject.name.equalsIgnoreCase(newValue = collecTable.getString(i, "Type"))) {
                        node.getAttributes().remove("SourceType");
                    } else {
                        if (!newValue.isEmpty()) {
                            node.setAttribute("SourceType", newValue);
                        }
                        if (!"Query".equals(newValue)) {
                            node.deleteChildByTagName("Statement");
                        }
                    }
                    parentNode.addNode(node);
                    xmlTree.xmlTree.updateMap(true);
                    parentOID = collecTable.getLong(i, "OID");
                    String dataType = dataObjectNoed.getAttributes().get("SecondaryType");
                    if (StringUtils.isBlank((CharSequence)dataType)) {
                        dataType = "Normal";
                    }
                    isPrimariy = String.valueOf(collecTable.getString(i, "IsPrimaryTable"));
                    DataObjectOperJsonUtil.dealFieldTable(xmlTree, controlerType, fieldTable, diff, node, parentOID, curDataObject);
                    DataObjectOperJsonUtil.dealPrimariyTable(xmlTree, isPrimariy, diff, node, dataType);
                    TagNode childByTagName = node.getOrCreateChildByTagName("TableFilter");
                    childByTagName.setAttribute("Type", collecTable.getString(i, "TableFilterType"));
                    if (StringUtils.isNotEmpty((CharSequence)collecTable.getString(i, "TableFilter"))) {
                        childByTagName.setCDataValue(collecTable.getString(i, "TableFilter"));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)collecTable.getString(i, "TableFilterTwo"))) {
                        childByTagName.setCDataValue(collecTable.getString(i, "TableFilterTwo"));
                    }
                    if (collecTable.getString(i, "TableFilter").isEmpty() && collecTable.getString(i, "TableFilterTwo").isEmpty()) {
                        node.deleteChildByTagName("TableFilter");
                    }
                    TagNode childByTagNameOne = node.getOrCreateChildByTagName("Statement");
                    childByTagNameOne.setCDataValue(collecTable.getString(i, "Statement"));
                    if (collecTable.getString(i, "Statement").isEmpty()) {
                        node.deleteChildByTagName("Statement");
                    }
                }
            } else if (3 == rowState) {
                List<AbstractNode> children = parentNode.getChildren();
                children.remove(curNode);
            }
            DataObjectOperJsonUtil.dealParameterCollection(ed_parameterCollection, curNode, parentOID);
            ++i;
        }
    }

    private static void dealParameterCollection(DataTable ed_parameterCollection, TagNode parentNode, Long parentOID) throws Throwable {
        Long rowPOID;
        if (Objects.isNull(parentNode) || Objects.isNull(parentOID)) {
            return;
        }
        List<TagNode> parameterCollection = parentNode.findNodesByTagName("ParameterCollection");
        ed_parameterCollection.setShowDeleted(true);
        int i = 0;
        while (i < ed_parameterCollection.size()) {
            rowPOID = ed_parameterCollection.getLong(i, "POID");
            if (parameterCollection.size() > 0 && parentOID.equals(rowPOID)) {
                TagNode tagNode = parameterCollection.get(0);
                tagNode.getChildren().clear();
            } else if (parentOID.equals(rowPOID)) {
                TagNode parameterCollections = new TagNode("ParameterCollection", null);
                parentNode.addNode(parameterCollections);
            }
            ++i;
        }
        i = 0;
        while (i < ed_parameterCollection.size()) {
            rowPOID = ed_parameterCollection.getLong(i, "POID");
            if (parentOID.equals(rowPOID)) {
                String sourceType = ed_parameterCollection.getString(i, "SourceType");
                String value = ed_parameterCollection.getString(i, "Value");
                String description1 = ed_parameterCollection.getString(i, "Description");
                String dataType = ed_parameterCollection.getString(i, "DataType");
                int rowState = ed_parameterCollection.getState(i);
                if (parentOID.equals(rowPOID) && 3 != rowState) {
                    TagNode parameter = new TagNode("Parameter", null);
                    if ("Const".equalsIgnoreCase(sourceType)) {
                        parameter.setAttribute("Value", value);
                        parameter.setAttribute("SourceType", sourceType);
                    } else {
                        parameter.setAttribute("Formula", value);
                    }
                    parameter.setAttribute("DataType", dataType);
                    parameter.setAttribute("Description", description1);
                    TagNode tagNode = parentNode.findNodesByTagName("ParameterCollection").get(0);
                    tagNode.addNode(parameter);
                }
            }
            ++i;
        }
    }

    public static String getXmlTreeKey(Diff diff, String controlerType, String primaryKey) throws Throwable {
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        MetaObjectType metaObjectType = diff.getMetaObjectType();
        if (metaObjectType == MetaObjectType.field || metaObjectType == MetaObjectType.panel || metaObjectType == MetaObjectType.subDetail || metaObjectType == MetaObjectType.grid || metaObjectType == MetaObjectType.D_DictView || metaObjectType == MetaObjectType.listView) {
            String buddyKey = "";
            String name = diff.properties.get((int)0).property.name;
            String controlType = ControlType.toString((Integer)diff.getControlType());
            TagNode fieldNode = xmlTree.xmlTree.getTagNode(String.valueOf(controlType) + "@" + diff.getKey());
            if (fieldNode != null) {
                buddyKey = fieldNode.getAttributes().get("BuddyKey");
            }
            if ("Label".equals(controlType)) {
                if (Property.key.name.equalsIgnoreCase(name)) {
                    String orgVal = diff.properties.get((int)0).orgValue;
                    return controlType + "@" + orgVal;
                }
                String key = diff.getKey();
                return controlType + "@" + key;
            }
            if (Property.key.name.equalsIgnoreCase(name)) {
                String orgVal = diff.properties.get((int)0).orgValue;
                StringBuilder fieldString = new StringBuilder().append(controlType).append("@").append(orgVal);
                TagNode coluNode = xmlTree.xmlTree.getTagNode(fieldString.toString());
                if (Objects.isNull(coluNode)) {
                    throw new Throwable("warning: \u4e0d\u80fd\u4fee\u6539!");
                }
                String key = coluNode.getAttributes().get("BuddyKey");
                if (StringUtils.isBlank((CharSequence)key)) {
                    return fieldString.toString();
                }
                StringBuilder labString = new StringBuilder().append("Label").append("@").append(key);
                return labString.append(",").append((CharSequence)fieldString).toString();
            }
            if (Property.BuddyKey.name.equalsIgnoreCase(name)) {
                StringBuilder fieldString = new StringBuilder().append(controlType).append("@").append(diff.getKey());
                TagNode coluNode = xmlTree.xmlTree.getTagNode(fieldString.toString());
                if (Objects.isNull(coluNode)) {
                    throw new Throwable("\u4e0d\u80fd\u4fee\u6539!");
                }
                StringBuilder labString = new StringBuilder().append("Label").append("@").append(buddyKey);
                return labString.append(",").append((CharSequence)fieldString).toString();
            }
            if (Property.buddyCaption.name.equalsIgnoreCase(name) || Property.buddyX.name.equalsIgnoreCase(name) || Property.buddyY.name.equalsIgnoreCase(name)) {
                return "Label" + "@" + buddyKey;
            }
            String key = diff.getKey();
            return controlType + "@" + key;
        }
        if (metaObjectType == MetaObjectType.gridField && diff.properties.size() > 0 || metaObjectType == MetaObjectType.GridCellType) {
            String name = diff.properties.get((int)0).property.name;
            if (Property.key.name.equalsIgnoreCase(name)) {
                String orgVal = diff.properties.get((int)0).orgValue;
                StringBuilder CellPrimary = new StringBuilder().append("GridCell").append("@").append(orgVal);
                StringBuilder ColumnPrimary = new StringBuilder().append("GridColumn").append("@").append(orgVal);
                return CellPrimary.append(",").append((CharSequence)ColumnPrimary).toString();
            }
            String key = diff.getKey();
            if (Property.visible.name.equalsIgnoreCase(name)) {
                return "GridColumn" + "@" + key;
            }
            if (Property.caption.name.equalsIgnoreCase(name)) {
                StringBuilder CellPrimary = new StringBuilder().append("GridCell").append("@").append(key);
                StringBuilder ColumnPrimary = new StringBuilder().append("GridColumn").append("@").append(key);
                return CellPrimary.append(",").append((CharSequence)ColumnPrimary).toString();
            }
            return "GridCell" + "@" + key;
        }
        if (metaObjectType == MetaObjectType.listViewField) {
            String name = diff.properties.get((int)0).property.name;
            if (Property.key.name.equalsIgnoreCase(name)) {
                String orgVal = diff.properties.get((int)0).orgValue;
                return "ListViewColumn" + "@" + orgVal;
            }
            String key = diff.getKey();
            if (Property.visible.name.equalsIgnoreCase(name)) {
                return "ListViewColumn" + "@" + key;
            }
            if (Property.caption.name.equalsIgnoreCase(name)) {
                return "ListViewColumn" + "@" + key;
            }
            return "ListViewColumn" + "@" + key;
        }
        if (metaObjectType == MetaObjectType.operationCollection || metaObjectType == MetaObjectType.operation) {
            String key = !"Key".equals(diff.properties.get((int)0).property.name) ? diff.getKey() : primaryKey;
            StringBuilder optPrimary = new StringBuilder().append(MetaObjectType.operation.name).append("@").append(key);
            StringBuilder colPrimary = new StringBuilder().append(MetaObjectType.operationCollection.name).append("@").append(key);
            return optPrimary.append(",").append((CharSequence)colPrimary).toString();
        }
        if (metaObjectType == MetaObjectType.toolbar) {
            String orgVal = diff.properties.get((int)0).orgValue;
            if ("Caption".equals(diff.properties.get((int)0).property.name)) {
                return "ToolBar" + "@" + diff.getKey();
            }
            return "ToolBar" + "@" + orgVal;
        }
        if (metaObjectType == MetaObjectType.ToolBar) {
            return "ToolBar" + "@";
        }
        if (MetaObjectType.GridHeadColumn.equals(metaObjectType)) {
            if (diff.properties.get((int)0).property.name.equals("Key")) {
                return "GridColumn@" + diff.properties.get((int)0).orgValue;
            }
            return "GridColumn@" + diff.getKey();
        }
        return controlerType + "@" + primaryKey;
    }

    private static void dealFieldTable(XmlTreeWithPath xmlTree, String controlerType, DataTable fieldTable, Diff diff, TagNode parentNode, long parentOID, MetaDataObject curDataObject) throws Throwable {
        controlerType = MetaObjectType.column.name;
        fieldTable.setShowDeleted(true);
        parentNode.deleteChildByTagName("Column");
        String tableKey = parentNode.getAttributes().get("Key");
        List<AbstractNode> children = parentNode.getChildren();
        children.clear();
        int index = 0;
        int i = 0;
        while (i < fieldTable.size()) {
            int rowState = fieldTable.getState(i);
            String orgColKey = (String)fieldTable.getOriginalObject(i, "ColumnKey");
            Long rowPOID = fieldTable.getLong(i, "POID");
            String ColumnKey = fieldTable.getString(i, "ColumnKey").trim();
            String ColumnName = fieldTable.getString(i, "ColumnName").replaceAll("\r", "");
            Integer ColumnType2 = fieldTable.getInt(i, "ColumnType");
            if (parentOID == rowPOID && 3 != rowState) {
                boolean isDictCol = false;
                if (!orgColKey.equalsIgnoreCase(ColumnKey)) {
                    if (!"DataObject".equalsIgnoreCase(diff.getReserveOne())) {
                        MetaFormHelper.updateColumnKey(diff, orgColKey, ColumnKey);
                    }
                    isDictCol = DataObjectOperJsonUtil.changeDictBinding(diff, fieldTable, orgColKey, ColumnKey, ColumnName);
                }
                boolean contains = false;
                List<TagNode> column = parentNode.findNodesByTagName("Column");
                for (TagNode tagNode : column) {
                    if (!tagNode.getAttributes().get("Key").equals(ColumnKey)) continue;
                    contains = true;
                    break;
                }
                if (!contains) {
                    TagNode node = new TagNode(controlerType, null);
                    node.setAttribute("Key", ColumnKey);
                    node.setAttribute("Caption", ColumnName);
                    node.setAttribute("DataType", DataType.toString((Integer)ColumnType2));
                    node.setAttribute("DBColumnName", fieldTable.getString(i, "DBColumnName"));
                    MetaForm metaForm = diff.getMetaForm();
                    MetaTable table = Objects.isNull(metaForm) ? curDataObject.getTable(tableKey) : metaForm.getDataSource().getDataObject().getTable(tableKey);
                    if (table != null) {
                        MetaColumn metaColumn = (MetaColumn)table.get(orgColKey);
                        String defaultValue = null;
                        if (metaColumn != null) {
                            defaultValue = metaColumn.getDefaultValue();
                        }
                        if (StringUtils.isBlank(defaultValue)) {
                            node.setAttribute("DefaultValue", fieldTable.getString(i, "DefaultValue"));
                        } else {
                            node.setAttributeNotRemove("DefaultValue", fieldTable.getString(i, "DefaultValue"));
                        }
                    } else {
                        node.setAttribute("DefaultValue", fieldTable.getString(i, "DefaultValue"));
                    }
                    node.setAttribute("Description", fieldTable.getString(i, "Description"));
                    node.setAttribute("Length", fieldTable.getString(i, "Length"));
                    if ("0".equalsIgnoreCase(node.getAttributes().get("Length")) || !StringUtils.isNotEmpty((CharSequence)node.getAttributes().get("Length"))) {
                        node.getAttributes().remove("Length");
                    }
                    node.setAttribute("Description", fieldTable.getString(i, "Description"));
                    if (!StringUtils.isNotEmpty((CharSequence)node.getAttributes().get("Description"))) {
                        node.getAttributes().remove("Description");
                    }
                    node.setAttribute("Precision", fieldTable.getString(i, "Precision"));
                    if ("0".equalsIgnoreCase(node.getAttributes().get("Precision")) || !StringUtils.isNotEmpty((CharSequence)node.getAttributes().get("Precision"))) {
                        node.getAttributes().remove("Precision");
                    }
                    node.setAttribute("Scale", fieldTable.getString(i, "Scale"));
                    if ("0".equalsIgnoreCase(node.getAttributes().get("Scale")) || !StringUtils.isNotEmpty((CharSequence)node.getAttributes().get("Scale"))) {
                        node.getAttributes().remove("Scale");
                    }
                    if (1 != rowState) {
                        node.setAttribute("Persist", fieldTable.getInt(i, "Persist") == 0 ? "false" : "true");
                    }
                    node.setAttribute("IsPrimary", fieldTable.getInt(i, "IsPrimary") == 0 ? "false" : "true");
                    node.setAttribute("Expand", fieldTable.getInt(i, "Expand") == 0 ? "false" : "true");
                    node.setAttribute("AccessControl", fieldTable.getInt(i, "AccessControl") == 0 ? "false" : "true");
                    node.setAttribute("IgnoreQuery", fieldTable.getInt(i, "IgnoreQuery") == 0 ? "false" : "true");
                    if ("false".equalsIgnoreCase(node.getAttributes().get("IgnoreQuery")) || !StringUtils.isNotEmpty((CharSequence)node.getAttributes().get("IgnoreQuery"))) {
                        node.getAttributes().remove("IgnoreQuery");
                    }
                    node.setAttribute("IgnoreSave", fieldTable.getInt(i, "IgnoreSave") == 0 ? "false" : "true");
                    node.setAttribute("Cache", fieldTable.getInt(i, "Cache") == 0 ? "false" : "true");
                    if ("false".equalsIgnoreCase(node.getAttributes().get("Cache")) || !StringUtils.isNotEmpty((CharSequence)node.getAttributes().get("Cache"))) {
                        node.getAttributes().remove("Cache");
                    }
                    node.setAttribute("Hidden", fieldTable.getInt(i, "Hidden") == 0 ? "false" : "true");
                    node.setAttribute("SortType", StringUtils.isNotEmpty((CharSequence)fieldTable.getString(i, "SortType")) ? SortType.toString((Integer)Integer.valueOf(fieldTable.getString(i, "SortType"))) : "");
                    node.setAttribute("PeriodGranularity", StringUtils.isNotEmpty((CharSequence)fieldTable.getString(i, "PeriodGranularity")) ? DMPeriodGranularityType.toString((Integer)Integer.valueOf(fieldTable.getString(i, "PeriodGranularity"))) : "");
                    String needRightsType = fieldTable.getString(i, "NeedRights");
                    if (StringUtils.isNotEmpty((CharSequence)needRightsType)) {
                        String needRights = ColumnRightsType.toString((Integer)Integer.parseInt(needRightsType));
                        if ("True".equalsIgnoreCase(needRights)) {
                            List collect = diff.getXmlTree().xmlTree.getMapNodes().values().stream().filter(n -> ((TagNode)n).getChildrenByTagName("DataBinding").size() > 0 && ((TagNode)n).getOrCreateChildByTagName("DataBinding").getAttributes().get("ColumnKey").equalsIgnoreCase(ColumnKey)).collect(Collectors.toList());
                            for (TagNode tagNode : collect) {
                                if (!"true".equalsIgnoreCase(tagNode.getAttributes().get(Property.IgnoreRights.name))) continue;
                                throw new Throwable("\u5df2\u5728\u63a7\u4ef6\u4e2d\u8bbe\u7f6e\u5ffd\u7565\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u4e3a\u68c0\u67e5\u6743\u9650\uff01\u5df2\u64a4\u9500");
                            }
                            node.setAttribute("ItemKey", fieldTable.getString(i, "ItemKey"));
                        } else {
                            node.deleteAttribute("NeedRights");
                            node.deleteAttribute("ItemKey");
                        }
                        node.setAttribute("NeedRights", needRights);
                    } else {
                        node.deleteAttribute("NeedRights");
                        node.deleteAttribute("ItemKey");
                    }
                    String supportI18n = fieldTable.getString(i, "SupportI18n");
                    supportI18n = StringUtils.isBlank((CharSequence)supportI18n) ? "false" : supportI18n;
                    node.setAttribute("SupportI18n", supportI18n);
                    node.setAttribute("SplitType", StringUtils.isBlank((CharSequence)fieldTable.getString(i, "SplitType")) ? "" : DataSplitType.toString((Integer)Integer.valueOf(fieldTable.getString(i, "SplitType"))));
                    node.setAttribute("GroupType", StringUtils.isBlank((CharSequence)fieldTable.getString(i, "GroupType")) ? "" : fieldTable.getString(i, "GroupType"));
                    if (isDictCol) {
                        String dictKey = ColumnKey.substring(0, ColumnKey.length() - 2);
                        node.setAttribute("CodeColumnKey", String.valueOf(dictKey) + "Code");
                    } else {
                        node.setAttribute("CodeColumnKey", !StringUtils.isNotEmpty((CharSequence)fieldTable.getString(i, "CodeColumnKey")) ? "" : fieldTable.getString(i, "CodeColumnKey"));
                    }
                    if ("-1".equalsIgnoreCase(node.getAttributes().get("GroupType"))) {
                        node.getAttributes().remove("GroupType");
                    }
                    try {
                        children.add(index, node);
                        ++index;
                    }
                    catch (Exception e) {
                        children.add(node);
                    }
                }
            }
            ++i;
        }
    }

    private static void dealPrimariyTable(XmlTreeWithPath xmlTree, String isPrimariy, Diff diff, TagNode curNode, String dataType) throws Throwable {
        if ("1".equals(isPrimariy) || "true".equals(isPrimariy)) {
            if (dataType.equalsIgnoreCase("ChainDict") || dataType.equalsIgnoreCase("Dict")) {
                if (!DataObjectOperJsonUtil.exist(curNode, "Column@Code")) {
                    TagNode column = new TagNode("Column", null);
                    column.setAttribute("Key", "Code");
                    column.setAttribute("Caption", "\u4ee3\u7801");
                    column.setAttribute("DataType", "Varchar");
                    column.setAttribute("Length", "50");
                    curNode.addNode(column);
                }
                if (!DataObjectOperJsonUtil.exist(curNode, "Column@Name")) {
                    TagNode column1 = new TagNode("Column", null);
                    column1.setAttribute("Key", "Name");
                    column1.setAttribute("Caption", "\u540d\u79f0");
                    column1.setAttribute("DataType", "Varchar");
                    column1.setAttribute("Length", "100");
                    curNode.addNode(column1);
                }
                if (!DataObjectOperJsonUtil.exist(curNode, "Column@Enable")) {
                    TagNode column2 = new TagNode("Column", null);
                    column2.setAttribute("Key", "Enable");
                    column2.setAttribute("Caption", "\u542f\u7528\u6807\u8bb0");
                    column2.setAttribute("DataType", "Integer");
                    curNode.addNode(column2);
                }
                if (!DataObjectOperJsonUtil.exist(curNode, "Column@ParentID")) {
                    TagNode column3 = new TagNode("Column", null);
                    column3.setAttribute("Key", "ParentID");
                    column3.setAttribute("Caption", "\u7236\u8282\u70b9");
                    column3.setAttribute("DataType", "Long");
                    curNode.addNode(column3);
                }
                if (!DataObjectOperJsonUtil.exist(curNode, "Column@NodeType")) {
                    TagNode column4 = new TagNode("Column", null);
                    column4.setAttribute("Key", "NodeType");
                    column4.setAttribute("Caption", "\u8282\u70b9\u7c7b\u578b");
                    column4.setAttribute("DataType", "Integer");
                    curNode.addNode(column4);
                }
                if (!DataObjectOperJsonUtil.exist(curNode, "Column@TLeft")) {
                    TagNode column5 = new TagNode("Column", null);
                    column5.setAttribute("Key", "TLeft");
                    column5.setAttribute("Caption", "TLeft");
                    column5.setAttribute("DataType", "Integer");
                    curNode.addNode(column5);
                }
                if (!DataObjectOperJsonUtil.exist(curNode, "Column@TRight")) {
                    TagNode column6 = new TagNode("Column", null);
                    column6.setAttribute("Key", "TRight");
                    column6.setAttribute("Caption", "TRight");
                    column6.setAttribute("DataType", "Integer");
                    curNode.addNode(column6);
                }
                if (!DataObjectOperJsonUtil.exist(curNode, "Column@ForeignName")) {
                    TagNode column7 = new TagNode("Column", null);
                    column7.setAttribute("Key", "ForeignName");
                    column7.setAttribute("Caption", "\u540d\u79f0(\u5916\u6587)");
                    column7.setAttribute("DataType", "Varchar");
                    column7.setAttribute("Length", "255");
                    curNode.addNode(column7);
                }
                MetaDataObject dataObject = Objects.isNull(diff.getMetaForm()) ? MetaFactory.getGlobalInstance().getDataObject(diff.formKey) : diff.getMetaForm().getDataSource().getDataObject();
                for (MetaTable metaColumns : dataObject.getTableCollection()) {
                    String tableKey = metaColumns.getKey();
                    TagNode tableNode = xmlTree.xmlTree.getTagNode("Table@" + tableKey);
                    if (tableNode == null) continue;
                    curNode.getAttributes().get("Key").equals(tableKey);
                }
            } else {
                TagNode node;
                HashSet<String> contains = new HashSet<String>();
                ArrayList<TagNode> tmpNodeList = new ArrayList<TagNode>();
                String controlerType = "Column";
                List<TagNode> column = curNode.findNodesByTagName("Column");
                for (TagNode tagNode : column) {
                    if (!ConstantUtil.PRIMARY_TABLE_FIELDS.contains(tagNode.getAttributes().get("Key"))) continue;
                    contains.add(tagNode.getAttributes().get("Key"));
                }
                if (!contains.contains("DocumentNumber")) {
                    node = new TagNode(controlerType, null);
                    node.setAttribute("Key", "DocumentNumber");
                    node.setAttribute("Caption", "\u5355\u636e\u7f16\u53f7");
                    node.setAttribute("DataType", DataType.toString((Integer)1002));
                    node.setAttribute("Length", "50");
                    tmpNodeList.add(node);
                }
                if (!contains.contains("Status")) {
                    node = new TagNode(controlerType, null);
                    node.setAttribute("Key", "Status");
                    node.setAttribute("Caption", "\u5355\u636e\u72b6\u6001");
                    node.setAttribute("DataType", DataType.toString((Integer)1001));
                    tmpNodeList.add(node);
                }
                if (!contains.contains("Creator")) {
                    node = new TagNode(controlerType, null);
                    node.setAttribute("Key", "Creator");
                    node.setAttribute("Caption", "\u5236\u5355\u4eba");
                    node.setAttribute("DataType", DataType.toString((Integer)1010));
                    tmpNodeList.add(node);
                }
                if (!contains.contains("CreateTime")) {
                    node = new TagNode(controlerType, null);
                    node.setAttribute("Key", "CreateTime");
                    node.setAttribute("Caption", "\u5236\u5355\u65e5\u671f");
                    node.setAttribute("DataType", DataType.toString((Integer)1004));
                    tmpNodeList.add(node);
                }
                if (!contains.contains("Modifier")) {
                    node = new TagNode(controlerType, null);
                    node.setAttribute("Key", "Modifier");
                    node.setAttribute("Caption", "\u4fee\u6539\u4eba");
                    node.setAttribute("DataType", DataType.toString((Integer)1010));
                    tmpNodeList.add(node);
                }
                if (!contains.contains("ModifyTime")) {
                    node = new TagNode(controlerType, null);
                    node.setAttribute("Key", "ModifyTime");
                    node.setAttribute("Caption", "\u4fee\u6539\u65f6\u95f4");
                    node.setAttribute("DataType", DataType.toString((Integer)1004));
                    tmpNodeList.add(node);
                }
                if (!contains.contains("ClientID")) {
                    node = new TagNode(controlerType, null);
                    node.setAttribute("Key", "ClientID");
                    node.setAttribute("Caption", "\u96c6\u56e2");
                    node.setAttribute("DataType", DataType.toString((Integer)1010));
                    tmpNodeList.add(node);
                }
                List<AbstractNode> children = curNode.getChildren();
                children.addAll(tmpNodeList);
            }
            curNode.getParent().getParent().getAttributes().put("PrimaryTableKey", curNode.getAttributes().get("Key"));
        } else {
            MetaDataObject dataObject = null;
            dataObject = "DataObject".equalsIgnoreCase(diff.getReserveOne()) ? diff.getDataObject() : diff.getMetaForm().getDataSource().getDataObject();
            String key = dataObject.getKey();
            if (!dataType.equalsIgnoreCase("ChainDict") && !dataType.equalsIgnoreCase("Dict") && curNode != null) {
                if (XmlDiffProcessor.fieldHastRely("DocumentNumber", key, curNode.getAttributes().get("Key"))) {
                    curNode.deleteChildByTagKey("DocumentNumber");
                }
                if (XmlDiffProcessor.fieldHastRely("Status", key, curNode.getAttributes().get("Key"))) {
                    curNode.deleteChildByTagKey("Status");
                }
                if (XmlDiffProcessor.fieldHastRely("DocumentDate", key, curNode.getAttributes().get("Key"))) {
                    curNode.deleteChildByTagKey("DocumentDate");
                }
                if (XmlDiffProcessor.fieldHastRely("Creator", key, curNode.getAttributes().get("Key"))) {
                    curNode.deleteChildByTagKey("Creator");
                }
                if (XmlDiffProcessor.fieldHastRely("CreateTime", key, curNode.getAttributes().get("Key"))) {
                    curNode.deleteChildByTagKey("CreateTime");
                }
                if (XmlDiffProcessor.fieldHastRely("Modifier", key, curNode.getAttributes().get("Key"))) {
                    curNode.deleteChildByTagKey("Modifier");
                }
                if (XmlDiffProcessor.fieldHastRely("ModifyTime", key, curNode.getAttributes().get("Key"))) {
                    curNode.deleteChildByTagKey("ModifyTime");
                }
                if (XmlDiffProcessor.fieldHastRely("ClientID", key, curNode.getAttributes().get("Key"))) {
                    curNode.deleteChildByTagKey("ClientID");
                }
                if (XmlDiffProcessor.fieldHastRely("Notes", key, curNode.getAttributes().get("Key"))) {
                    curNode.deleteChildByTagKey("Notes");
                }
            }
        }
    }

    private static void replaceTableKey(Diff diff, String orgTableKey, String tableKey) throws Throwable {
        MetaFormHelper.updateTableKey(diff, orgTableKey, tableKey);
        XmlTree xmlTree = diff.getXmlTree().xmlTree;
        TagNode dataNode = xmlTree.getRoot().getChildByTagName("DataSource");
        TagNode dataObjectNode = null;
        dataObjectNode = MetaObjectType.DataObject.name.equalsIgnoreCase(diff.getMetaObjectType().name) ? xmlTree.getRoot() : dataNode.findFirstTagNodeByTagName("DataObject");
        if (dataObjectNode.getAttributes().get("PrimaryTableKey") != null && dataObjectNode.getAttributes().get("PrimaryTableKey").equalsIgnoreCase(orgTableKey)) {
            dataObjectNode.setAttribute("PrimaryTableKey", tableKey);
        }
        List<TagNode> tableList = dataObjectNode.findNodesByTagName("Table");
        for (TagNode tagNode : tableList) {
            if (tagNode.getAttributes().get("ParentKey") != null && tagNode.getAttributes().get("ParentKey").equalsIgnoreCase(orgTableKey)) {
                tagNode.setAttribute("ParentKey", tableKey);
            }
            if (tagNode.getAttributes().get("IndexPrefix") == null || !tagNode.getAttributes().get("IndexPrefix").equalsIgnoreCase(orgTableKey)) continue;
            tagNode.setAttribute("IndexPrefix", tableKey);
        }
    }

    private static Boolean changeDictBinding(Diff diff, DataTable fieldTable, String orgDictColKey, String dictColKey, String columnName) throws Throwable {
        XmlTree xmlTree = diff.getXmlTree().xmlTree;
        List<TagNode> columnNodeList = xmlTree.getRoot().findNodesByTagName("Column");
        String orgDictKey = orgDictColKey;
        String dictKey = dictColKey;
        if (orgDictColKey.toLowerCase().endsWith("id")) {
            orgDictKey = orgDictColKey.substring(0, orgDictColKey.length() - 2);
        }
        if (dictColKey.toLowerCase().endsWith("id")) {
            dictKey = dictColKey.substring(0, dictColKey.length() - 2);
        }
        boolean hasCodeColumn = false;
        for (TagNode columnNode : columnNodeList) {
            if (columnNode.getAttributes().get("Key").equalsIgnoreCase(String.valueOf(orgDictKey) + "Code")) {
                columnNode.setAttribute("Key", String.valueOf(dictKey) + "Code");
                columnNode.setAttribute("Caption", columnName);
                hasCodeColumn = true;
            }
            if (!hasCodeColumn || !columnNode.getAttributes().get("Key").equalsIgnoreCase(dictColKey)) continue;
            columnNode.setAttribute("CodeColumnKey", String.valueOf(dictKey) + "Code");
        }
        if (!hasCodeColumn) {
            int i = 0;
            while (i < fieldTable.size()) {
                if (fieldTable.getString(i, "ColumnKey").trim().equalsIgnoreCase(String.valueOf(orgDictKey) + "Code")) {
                    fieldTable.setString(i, "ColumnKey", String.valueOf(dictKey) + "Code");
                    fieldTable.setString(i, "ColumnName", columnName);
                    hasCodeColumn = true;
                }
                ++i;
            }
        }
        return hasCodeColumn;
    }

    private String handleDataObjectByOidFilter(Diff diff, List<Diff> diffs, Document document) throws Throwable {
        if (!StringUtils.equals((CharSequence)"OIDFilter", (CharSequence)diff.getReserveOne())) {
            return null;
        }
        String path = LoadFileTree.getPathByFormKey(diff.formKey);
        diff.setFilePath(path);
        String tmpPath = XmlFileProcessor.instance.getTmpFile(path);
        String filePath = StringUtils.isNotBlank((CharSequence)tmpPath) ? tmpPath : path;
        XmlTree xmlTree = Xml4jUtil.parseTree(filePath);
        if (Objects.isNull(xmlTree)) {
            String dataObjectPath = LoadFileTree.getPathByDataObject(path);
            xmlTree = Xml4jUtil.parseTree(dataObjectPath);
        }
        XmlDiffProcessor.dealEventTable(new XmlTreeWithPath(path, tmpPath, xmlTree), document, diff);
        XmlFileProcessor.instance.processDiff(diffs, false);
        DesignReloadMetaObject.reloadMetaFormRollbackError(null, diff.formKey);
        return path;
    }
}

