/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.CheckXMLChanged;
import com.bokesoft.yes.design.cmd.ReplaceStringEntry;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.cmd.WebBpmDesignCmd;
import com.bokesoft.yes.design.cmd.WebDataMapDesign;
import com.bokesoft.yes.design.cmd.WebDataMigration;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.DesignReloadMetaObject;
import com.bokesoft.yes.design.utils.ReloadForm;
import com.bokesoft.yes.design.utils.XmlFormat;
import com.bokesoft.yes.design.vo.RecycleForm;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yes.meta.persist.dom.xml.XmlCreator;
import com.bokesoft.yes.meta.persist.dom.xml.XmlParser;
import com.bokesoft.yes.meta.persist.dom.xml.node.XmlTree;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.common.util.FileUtil;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class XmlFileProcessor {
    public static final XmlFileProcessor instance = new XmlFileProcessor();
    public static Map<String, Stack<String>> filePathToTmpFileMap = new HashMap<String, Stack<String>>();
    public static Map<String, Stack<String>> reFilePathToTmpFileMap = new HashMap<String, Stack<String>>();
    public static Map<String, RecycleForm> recycleToTmpFormAndFileMap = new HashMap<String, RecycleForm>();
    public static Map<String, Stack<String>> filePathToSnapshotMap = new HashMap<String, Stack<String>>();
    public static final String STR_TmpPath = "tmp";

    public Map<String, String> processDiff(List<Diff> diffs, boolean isCompositeComponent) throws Throwable {
        if ("DataObjectCheckRule".equals(diffs.get(0).getKey())) {
            return null;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (isCompositeComponent) {
            this.processDiff(diffs.get(diffs.size() - 1), result);
        } else {
            for (Diff diff : diffs) {
                this.processDiff(diff, result);
            }
        }
        return result;
    }

    public Map<String, String> processDiff(Diff diff, Map<String, String> result) throws Throwable {
        String xmlFilePath;
        XmlTreeWithPath xmlTree;
        String xmlFilePath2;
        LinkedHashMap<String, String> orgXmls = new LinkedHashMap<String, String>();
        XmlTreeWithPath xmlTree2 = diff.getXmlTree2();
        if (xmlTree2 != null && !orgXmls.containsKey(xmlFilePath2 = xmlTree2.orgFilePath)) {
            orgXmls.put(xmlFilePath2, xmlTree2.xmlTree.getOrgXml());
        }
        if ((xmlTree = diff.getXmlTree()) != null && (xmlFilePath = xmlTree.orgFilePath) != null && !orgXmls.containsKey(xmlFilePath)) {
            orgXmls.put(xmlFilePath, xmlTree.xmlTree.getOrgXml());
        }
        XmlFileProcessor.genXML(orgXmls, diff);
        for (Map.Entry entry : orgXmls.entrySet()) {
            String filePath = (String)entry.getKey();
            String newContent = (String)entry.getValue();
            boolean isPropertyDiff = true;
            String key = StringUtils.isNotBlank((CharSequence)filePath) ? LoadFileTree.getProjectKey(filePath) : ((MetaFormProfile)MetaFactory.getGlobalInstance().getMetaFormList().get(diff.formKey)).getProject().getKey();
            String tmpFilePath = !isPropertyDiff ? this.saveTempFile(filePath, newContent, key) : this.saveSortedTempFile(diff, filePath, newContent, key);
            result.put(tmpFilePath, newContent);
        }
        return result;
    }

    public String saveTempFile(String filePath, String fileContent, String projectKey) throws Throwable {
        return this.saveTempFile(filePath, fileContent, false, projectKey);
    }

    public String saveTempFile(String filePath, String fileContent, boolean isPropertyDiff, String projectKey) throws Throwable {
        try {
            String xmlFile1 = XmlFormat.formatXML_str(fileContent);
            com.bokesoft.yes.design.xml.XmlParser.parse(xmlFile1);
        }
        catch (Exception e) {
            throw new RuntimeException("xml\u7ed3\u6784\u9519\u8bef\u4fee\u6539\u5931\u8d25!", e);
        }
        String newFilePath = FilePathHelper.toBackFilePath(String.valueOf(WebDesignerConfiguration.getDesignerSolutionTmpDataPath(projectKey)) + File.separator + new File(filePath).getName() + "." + System.currentTimeMillis());
        File file = new File(newFilePath);
        if (isPropertyDiff) {
            FileUtils.writeStringToFile((File)file, (String)this.getFormatXml(filePath, fileContent), (String)"UTF-8");
        } else {
            FileUtils.writeStringToFile((File)file, (String)fileContent, (String)"UTF-8");
        }
        XmlFileProcessor.stackput(filePath, newFilePath);
        return newFilePath;
    }

    public String saveSortedTempFile(Diff diff, String filePath, String fileContent, String projectKey) throws Throwable {
        try {
            String xmlFile1 = XmlFormat.formatXML_str(fileContent);
            com.bokesoft.yes.design.xml.XmlParser.parse(xmlFile1);
        }
        catch (Exception e) {
            throw new RuntimeException("xml\u7ed3\u6784\u9519\u8bef\u4fee\u6539\u5931\u8d25!", e);
        }
        String newFilePath = FilePathHelper.toBackFilePath(String.valueOf(WebDesignerConfiguration.getDesignerSolutionTmpDataPath(projectKey)) + File.separator + new File(filePath).getName() + "." + System.currentTimeMillis());
        File file = new File(newFilePath);
        String oldXml = this.getFormatXml(filePath, fileContent);
        FileUtils.writeStringToFile((File)file, (String)oldXml, (String)"UTF-8");
        CheckXMLChanged.mergerSortedXml(diff, newFilePath, projectKey, oldXml);
        XmlFileProcessor.stackput(filePath, newFilePath);
        return newFilePath;
    }

    private String getFormatXml(String filePath, String fileContent) throws Exception {
        String tmpFile = instance.getTmpFile(filePath);
        if (StringUtils.isBlank((CharSequence)tmpFile)) {
            tmpFile = filePath;
        }
        String orgxml = FileUtil.File2String((File)new File(tmpFile), (String)"UTF-8");
        XmlTree orgXmlTree = XmlParser.parse((String)orgxml);
        byte[] bytes = fileContent.getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        XmlCreator creator = new XmlCreator(DomHelper.createDocument((InputStream)byteArrayInputStream), orgXmlTree);
        String xml = creator.createXml();
        return xml;
    }

    public void saveTempRecycleFile(String key, RecycleForm recycleForm) throws Throwable {
        recycleToTmpFormAndFileMap.put(key, recycleForm);
    }

    public RecycleForm getTempRecycleFile(String key) throws Throwable {
        return recycleToTmpFormAndFileMap.get(key);
    }

    public static void stackput(String filePath, String newFilePath) {
        Stack<String> tmpFileMapStack = filePathToTmpFileMap.get(filePath);
        if (Objects.isNull(tmpFileMapStack)) {
            Stack<String> tmpStack = new Stack<String>();
            tmpStack.push(newFilePath);
            filePathToTmpFileMap.put(filePath, tmpStack);
        } else {
            tmpFileMapStack.push(newFilePath);
        }
        Stack<String> SnapshotMapStack = filePathToSnapshotMap.get(filePath);
        if (Objects.isNull(SnapshotMapStack)) {
            Stack<String> tmpStack = new Stack<String>();
            tmpStack.push(newFilePath);
            filePathToSnapshotMap.put(filePath, tmpStack);
        } else {
            SnapshotMapStack.push(newFilePath);
        }
    }

    private static void genXML(Map<String, String> orgXmls, Diff diff) throws Throwable {
        XmlTreeWithPath xmlTree2;
        String filePath2;
        XmlTreeWithPath xmlTree1 = diff.getXmlTree();
        if (Objects.isNull(xmlTree1)) {
            return;
        }
        String filePath = diff.getXmlTree().orgFilePath;
        String result = diff.getXmlTree().xmlTree.getOrgXml();
        if (StringUtils.isNotEmpty((CharSequence)diff.getNewXml())) {
            result = diff.getNewXml();
            xmlTree1.xmlTree.getOrgXml();
            XmlTreeWithPath orgTree = XmlTreeWithPath.parseFilePath(filePath);
            if (orgTree.xmlTree.getOrgXml().equals(result)) {
                throw new RuntimeException("\u9884\u89c8\u5931\u8d25,XML\u672a\u4ea7\u751f\u53d8\u5316!");
            }
        } else {
            result = XmlFileProcessor.mergeDiff(result, diff, orgXmls);
        }
        String string = filePath2 = Objects.isNull(xmlTree2 = diff.getXmlTree2()) ? null : xmlTree2.orgFilePath;
        if (filePath2 != null && !filePath2.equals(filePath)) {
            String[] fenges = result.split("fenge");
            orgXmls.put(filePath, fenges[0]);
            orgXmls.put(filePath2, fenges[1]);
        } else {
            orgXmls.put(filePath, result);
        }
    }

    public static String mergeDiff(String xml, Diff diff, Map<String, String> orgXmls) throws Throwable {
        String result = xml;
        ReplaceStringEntry entry = diff.isPropertyDiff() ? new ReplaceStringEntry() : null;
        int startLine = diff.getStartLine();
        String orgXmlFragment = diff.getOrgXmlFragment();
        String newXmlFragment = diff.getNewXmlFragment();
        boolean insertIndent = diff.isPropertyDiff() && !diff.isGridColumnDrag();
        result = CheckXMLChanged.mergeXML(result, startLine, orgXmlFragment, newXmlFragment, entry, insertIndent);
        int startLine2 = diff.getStartLine2();
        if (startLine2 != -1) {
            ReplaceStringEntry entry2 = diff.isPropertyDiff() ? new ReplaceStringEntry() : null;
            String xmlFilePath2 = diff.getXmlTree2().orgFilePath;
            result = !xmlFilePath2.equals(diff.getXmlTree().orgFilePath) ? String.valueOf(result) + "fenge" + CheckXMLChanged.mergeXML(orgXmls.get(xmlFilePath2), startLine2, diff.getOrgXmlFragment2(), diff.getNewXmlFragment2(), entry2, insertIndent) : CheckXMLChanged.mergeXML(result, startLine2, diff.getOrgXmlFragment2(), diff.getNewXmlFragment2(), entry2, insertIndent);
        }
        return result;
    }

    public static String mergePreDiff(Diff preDiff, Diff diff) throws Throwable {
        String content = preDiff.getXmlTree().xmlTree.getOrgXml();
        String newXmlFragment = preDiff.getNewXmlFragment();
        String orgXmlFragment = preDiff.getOrgXmlFragment();
        int startLine = preDiff.getStartLine();
        boolean insertIndent = preDiff.isPropertyDiff() && !preDiff.isGridColumnDrag();
        ReplaceStringEntry replaceStringEntry = new ReplaceStringEntry();
        content = CheckXMLChanged.mergeXML(content, startLine, orgXmlFragment, newXmlFragment, replaceStringEntry, insertIndent);
        int startLine2 = preDiff.getStartLine2();
        if (startLine2 != -1) {
            ReplaceStringEntry entry2 = diff.isPropertyDiff() ? new ReplaceStringEntry() : null;
            content = CheckXMLChanged.mergeXML(content, startLine2, preDiff.getOrgXmlFragment2(), preDiff.getNewXmlFragment2(), entry2, insertIndent);
        }
        String key = ((MetaFormProfile)MetaFactory.getGlobalInstance().getMetaFormList().get(preDiff.formKey)).getProject().getKey();
        String filepath = Paths.get(WebDesignerConfiguration.getDesignerSolutionTmpDataPath(key), STR_TmpPath, String.valueOf(diff.formKey) + "_midfile.xml").toString();
        File file = new File(filepath);
        FileUtils.writeStringToFile((File)file, (String)content, (String)"UTF-8");
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        ReloadForm.reloadFormKey(metaFactory, diff.formKey, LoadFileTree.getResource(filepath, ((MetaFormProfile)metaFactory.getMetaFormList().get(diff.formKey)).getProject().getKey()));
        return filepath;
    }

    public String getTmpFile(String filePath) {
        if (filePathToTmpFileMap.containsKey(filePath)) {
            try {
                String result = filePathToTmpFileMap.get(filePath).peek();
                if (new File(result).exists()) {
                    return result;
                }
                LogSvr.getInstance().info("\u4e34\u65f6\u6587\u4ef6\u5373\u5c06\u88ab\u6e05\u9664\uff01filePath: " + filePath);
                filePathToTmpFileMap.remove(filePath);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public String getUndoContent(List<UICommand> result, String type, String filePath, String formKey) {
        if (filePathToTmpFileMap.containsKey(filePath)) {
            try {
                String pop = filePathToTmpFileMap.get(filePath).pop();
                Stack<String> tmpFileMapStack = reFilePathToTmpFileMap.get(filePath);
                if (Objects.isNull(tmpFileMapStack)) {
                    Stack<String> tmpStack = new Stack<String>();
                    tmpStack.push(pop);
                    reFilePathToTmpFileMap.put(filePath, tmpStack);
                } else {
                    tmpFileMapStack.push(pop);
                }
                XmlFileProcessor.dealWithObject(result, type, filePath, formKey, pop);
                return pop;
            }
            catch (Throwable e) {
                return null;
            }
        }
        return null;
    }

    public static void dealWithObject(List<UICommand> result, String type, String filePath, String formKey, String pop) throws Throwable {
        result.add(UICommand.reloadXmlSource(filePath));
        if ("Form".equalsIgnoreCase(type)) {
            DesignReloadMetaObject.reloadMetaFormRollbackError(null, formKey);
            result.add(UICommand.reloadFormKey(formKey));
            result.add(UICommand.refreshMenuTree(formKey));
        } else if ("DataObject".equalsIgnoreCase(type)) {
            DataObjectHelper.reload(null, formKey, pop, null);
        } else if ("DataMigration".equalsIgnoreCase(type)) {
            IMetaFactory iMetaFactory = MetaFactory.getGlobalInstance();
            ReloadForm.reloadDataMigrationKey(iMetaFactory, formKey, pop);
            JSONObject jsonFileContent = WebDataMigration.getJsonFileContent(filePath);
            result.add(UICommand.uadataWebJson(JSONObject.toJSONString((Object)jsonFileContent, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.DisableCircularReferenceDetect})));
        } else if ("DataMap".equalsIgnoreCase(type)) {
            String projectKey = LoadFileTree.getProjectKey(filePath);
            ReloadForm.reloadCustom(projectKey, formKey);
            JSONObject jsonFileContent = WebDataMapDesign.getJsonFileContent(filePath);
            result.add(UICommand.uadataWebJson(JSONObject.toJSONString((Object)jsonFileContent, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.DisableCircularReferenceDetect})));
        } else if ("BPM".equalsIgnoreCase(type)) {
            String version;
            String newContent = FileUtils.readFileToString((File)new File(pop), (String)"UTF-8");
            String newSecondLine = DesignIOMetaUtil.getSecondLine(newContent);
            try {
                version = DesignIOMetaUtil.getSubString(newSecondLine, "Version=\"([A-Za-z_]\\w*)\"");
            }
            catch (Exception e) {
                version = "1";
            }
            IMetaFactory iMetaFactory = MetaFactory.getGlobalInstance();
            iMetaFactory.updateProcessDefination(formKey, Integer.parseInt(version));
            iMetaFactory.updateProcessDefinationByDeployKey(formKey);
            JSONObject jsonFileContent = WebBpmDesignCmd.getJsonFileContent(filePath);
            result.add(UICommand.uadataWebJson(jsonFileContent));
        }
    }

    public String getRedoContent(List<UICommand> result, String type, String filePath, String formKey) {
        if (reFilePathToTmpFileMap.containsKey(filePath)) {
            try {
                String pop = reFilePathToTmpFileMap.get(filePath).pop();
                Stack<String> tmpFileMapStack = filePathToTmpFileMap.get(filePath);
                if (Objects.isNull(tmpFileMapStack)) {
                    Stack<String> tmpStack = new Stack<String>();
                    tmpStack.push(pop);
                    filePathToTmpFileMap.put(filePath, tmpStack);
                } else {
                    tmpFileMapStack.push(pop);
                }
                XmlFileProcessor.dealWithObject(result, type, filePath, formKey, pop);
                return pop;
            }
            catch (Throwable e) {
                return null;
            }
        }
        return null;
    }

    public void clearTmpFile(String filePath) {
        filePathToTmpFileMap.remove(filePath);
        reFilePathToTmpFileMap.remove(filePath);
    }
}

