/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.DiffProperty;
import com.bokesoft.yes.design.MetaObjectType;
import com.bokesoft.yes.design.Property;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.io.IOMetaObject;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.mergesingle.util.QuoteGridFiledOperUtil;
import com.bokesoft.yes.design.metaobjecttype.MetaObjectTypeDefine;
import com.bokesoft.yes.design.process.MetaItemFilterProcess;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.CDataNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.node.Xml4jUtil;
import com.bokesoft.yes.design.xml.node.XmlTree;
import com.bokesoft.yes.design.xml.parse.Element;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.helper.MetaFormHelper;
import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yigo.common.def.ColumnExpandType;
import com.bokesoft.yigo.common.def.ColumnRightsType;
import com.bokesoft.yigo.common.def.ComboBoxSourceType;
import com.bokesoft.yigo.common.def.CondSign;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DataGroupGranularity;
import com.bokesoft.yigo.common.def.DataSplitType;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.ExpandSourceType;
import com.bokesoft.yigo.common.def.GridTreeType;
import com.bokesoft.yigo.common.def.Media;
import com.bokesoft.yigo.common.def.RowType;
import com.bokesoft.yigo.common.def.SortType;
import com.bokesoft.yigo.common.def.TableMode;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.dataelement.MetaDataElement;
import com.bokesoft.yigo.meta.datamigration.DMPeriodGranularityType;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectList;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.dataobject.MetaEmbedTable;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.domain.MetaDomain;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaEmbed;
import com.bokesoft.yigo.meta.form.component.bar.MetaToolBar;
import com.bokesoft.yigo.meta.form.component.container.MetaSubDetail;
import com.bokesoft.yigo.meta.form.component.control.MetaDefaultItem;
import com.bokesoft.yigo.meta.form.component.control.MetaRadioButton;
import com.bokesoft.yigo.meta.form.component.control.MetaTabGroup;
import com.bokesoft.yigo.meta.form.component.control.MetaTabItem;
import com.bokesoft.yigo.meta.form.component.control.MetaTabItemCollection;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumn;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaListBoxItemCollection;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableView;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumn;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumnCollection;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRowCollection;
import com.bokesoft.yigo.meta.form.component.panel.MetaFlexFlowLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaLinearLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaSplitPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaSplitSizeCollection;
import com.bokesoft.yigo.meta.form.component.panel.MetaTabPanel;
import com.bokesoft.yigo.meta.form.component.panel.flexgridpanel.MetaFlexGridLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGridLayoutPanel;
import com.bokesoft.yigo.meta.form.component.view.MetaView;
import com.bokesoft.yigo.meta.form.component.view.MetaViewCollection;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class XmlDiffProcessor {
    public static final XmlDiffProcessor instance = new XmlDiffProcessor();
    public static String subDetailBind = "";
    private static final List<Map<String, String>> DICT_HEAD_TABLE_COLUMN_LIST = new ArrayList<Map<String, String>>();
    public static final List<Map<String, String>> PRIMARY_TABLE_COLUMN_LIST = new ArrayList<Map<String, String>>();
    private static Pattern p;

    static {
        XmlDiffProcessor.initDictHeadTableColumnList();
        XmlDiffProcessor.initPrimaryTableColumnList();
        p = Pattern.compile("[a-zA-Z\\d_.,\\-/;\\[\\]\u2018\\\\${}^|~\\n\\r\\t ]{1,35}");
    }

    private static void initDictHeadTableColumnList() {
        HashMap<String, String> codeColumnMap = new HashMap<String, String>();
        DICT_HEAD_TABLE_COLUMN_LIST.add(codeColumnMap);
        codeColumnMap.put("Key", "Code");
        codeColumnMap.put("Caption", "\u4ee3\u7801");
        codeColumnMap.put("DataType", "Varchar");
        codeColumnMap.put("Length", "50");
        HashMap<String, String> nameColumnMap = new HashMap<String, String>();
        DICT_HEAD_TABLE_COLUMN_LIST.add(nameColumnMap);
        nameColumnMap.put("Key", "Name");
        nameColumnMap.put("Caption", "\u540d\u79f0");
        nameColumnMap.put("DataType", "Varchar");
        nameColumnMap.put("Length", "100");
        HashMap<String, String> enableColumnMap = new HashMap<String, String>();
        DICT_HEAD_TABLE_COLUMN_LIST.add(enableColumnMap);
        enableColumnMap.put("Key", "Enable");
        enableColumnMap.put("Caption", "\u542f\u7528\u6807\u8bb0");
        enableColumnMap.put("DataType", "Integer");
        HashMap<String, String> parentIDColumnMap = new HashMap<String, String>();
        DICT_HEAD_TABLE_COLUMN_LIST.add(parentIDColumnMap);
        parentIDColumnMap.put("Key", "ParentID");
        parentIDColumnMap.put("Caption", "\u7236\u8282\u70b9");
        parentIDColumnMap.put("DataType", "Long");
        HashMap<String, String> nodeTypeColumnMap = new HashMap<String, String>();
        DICT_HEAD_TABLE_COLUMN_LIST.add(nodeTypeColumnMap);
        nodeTypeColumnMap.put("Key", "NodeType");
        nodeTypeColumnMap.put("Caption", "\u8282\u70b9\u7c7b\u578b");
        nodeTypeColumnMap.put("DataType", "Integer");
        HashMap<String, String> tLeftColumnMap = new HashMap<String, String>();
        DICT_HEAD_TABLE_COLUMN_LIST.add(tLeftColumnMap);
        tLeftColumnMap.put("Key", "TLeft");
        tLeftColumnMap.put("Caption", "TLeft");
        tLeftColumnMap.put("DataType", "Integer");
        HashMap<String, String> tRightColumnMap = new HashMap<String, String>();
        DICT_HEAD_TABLE_COLUMN_LIST.add(tRightColumnMap);
        tRightColumnMap.put("Key", "TRight");
        tRightColumnMap.put("Caption", "TRight");
        tRightColumnMap.put("DataType", "Integer");
    }

    private static void initPrimaryTableColumnList() {
        HashMap<String, String> documentNumberColumnMap = new HashMap<String, String>();
        PRIMARY_TABLE_COLUMN_LIST.add(documentNumberColumnMap);
        documentNumberColumnMap.put("Key", "DocumentNumber");
        documentNumberColumnMap.put("Caption", "\u5355\u636e\u7f16\u53f7");
        documentNumberColumnMap.put("DataElementKey", "DocumentNumber");
        HashMap<String, String> statusColumnMap = new HashMap<String, String>();
        PRIMARY_TABLE_COLUMN_LIST.add(statusColumnMap);
        statusColumnMap.put("Key", "Status");
        statusColumnMap.put("Caption", "\u5355\u636e\u72b6\u6001");
        statusColumnMap.put("DataElementKey", "Status");
        statusColumnMap.put("DefaultValue", "-1");
        HashMap<String, String> documentDateColumnMap = new HashMap<String, String>();
        PRIMARY_TABLE_COLUMN_LIST.add(documentDateColumnMap);
        documentDateColumnMap.put("Key", "DocumentDate");
        documentDateColumnMap.put("Caption", "\u5355\u636e\u65e5\u671f");
        documentDateColumnMap.put("DataElementKey", "DocumentDate");
        HashMap<String, String> creatorColumnMap = new HashMap<String, String>();
        PRIMARY_TABLE_COLUMN_LIST.add(creatorColumnMap);
        creatorColumnMap.put("Key", "Creator");
        creatorColumnMap.put("Caption", "\u5236\u5355\u4eba");
        creatorColumnMap.put("DataElementKey", "Creator");
        HashMap<String, String> createTimeColumnMap = new HashMap<String, String>();
        PRIMARY_TABLE_COLUMN_LIST.add(createTimeColumnMap);
        createTimeColumnMap.put("Key", "CreateTime");
        createTimeColumnMap.put("Caption", "\u5236\u5355\u65e5\u671f");
        createTimeColumnMap.put("DataElementKey", "CreateTime");
        HashMap<String, String> modifierColumnMap = new HashMap<String, String>();
        PRIMARY_TABLE_COLUMN_LIST.add(modifierColumnMap);
        modifierColumnMap.put("Key", "Modifier");
        modifierColumnMap.put("Caption", "\u4fee\u6539\u4eba");
        modifierColumnMap.put("DataElementKey", "Modifier");
        HashMap<String, String> modifyTimeColumnMap = new HashMap<String, String>();
        PRIMARY_TABLE_COLUMN_LIST.add(modifyTimeColumnMap);
        modifyTimeColumnMap.put("Key", "ModifyTime");
        modifyTimeColumnMap.put("Caption", "\u4fee\u6539\u65f6\u95f4");
        modifyTimeColumnMap.put("DataElementKey", "ModifyTime");
        HashMap<String, String> foreignNameColumnMap = new HashMap<String, String>();
        PRIMARY_TABLE_COLUMN_LIST.add(foreignNameColumnMap);
        foreignNameColumnMap.put("Key", "ClientID");
        foreignNameColumnMap.put("Caption", "\u96c6\u56e2");
        foreignNameColumnMap.put("DataElementKey", "ClientID");
        HashMap<String, String> notesColumnMap = new HashMap<String, String>();
        PRIMARY_TABLE_COLUMN_LIST.add(notesColumnMap);
        notesColumnMap.put("Key", "Notes");
        notesColumnMap.put("Caption", "\u5907\u6ce8");
        notesColumnMap.put("DataElementKey", "Notes");
    }

    public int processDiff(List<Diff> diffs, Document document) throws Throwable {
        int anInt = 1;
        Diff preDiff = null;
        for (Diff diff : diffs) {
            XmlTreeWithPath xmlTreeWithPath;
            String midFilePath;
            if (!diff.isPropertyDiff()) continue;
            if (diff.isMultyMove) {
                if (preDiff != null) {
                    midFilePath = XmlFileProcessor.mergePreDiff(preDiff, diff);
                    xmlTreeWithPath = new XmlTreeWithPath(diff.getXmlTree().orgFilePath, diff.getXmlTree().tmpFilePath, XmlTreeWithPath.parseFilePath((String)midFilePath).xmlTree);
                    diff.setXmlTree(xmlTreeWithPath);
                }
                if (diff.isGridColumnDrag()) {
                    XmlDiffProcessor.mergeColumnDragDiff(diff);
                } else {
                    XmlDiffProcessor.mergeDiff(diff.getMetaForm(), diff, document);
                }
                preDiff = diff;
                continue;
            }
            if (diff.isGridColumnDrag()) {
                XmlDiffProcessor.mergeColumnDragDiff(diff);
                continue;
            }
            if (diff.isMultyDelete) {
                if (preDiff != null) {
                    midFilePath = XmlFileProcessor.mergePreDiff(preDiff, diff);
                    xmlTreeWithPath = new XmlTreeWithPath(diff.getXmlTree().orgFilePath, diff.getXmlTree().tmpFilePath, XmlTreeWithPath.parseFilePath((String)midFilePath).xmlTree);
                    diff.setXmlTree(xmlTreeWithPath);
                }
                XmlDiffProcessor.mergeDeleteDiff(diff);
                preDiff = diff;
                continue;
            }
            if (diff.isDelete) {
                XmlDiffProcessor.mergeDeleteDiff(diff);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)diff.caption) || diff.isButtonQuote.booleanValue()) {
                Object parentNode;
                String parentXmlTreeKey;
                MetaForm metaForm = diff.getMetaForm();
                AbstractMetaObject parentComponent = (AbstractMetaObject)metaForm.getAllUIComponents().get(diff.parentKey);
                if (diff.getControlType() == 0 || StringUtils.equalsIgnoreCase((CharSequence)diff.getMetaObjectType().name, (CharSequence)"GridFieldRow")) {
                    if (parentComponent instanceof MetaGrid) {
                        parentXmlTreeKey = "Grid@" + diff.parentKey;
                        parentNode = diff.getXmlTree().xmlTree.getTagNode(parentXmlTreeKey);
                        XmlDiffProcessor.mergeGridRowNewDiff((MetaGrid)parentComponent, (TagNode)parentNode, diff);
                        continue;
                    }
                    anInt = XmlDiffProcessor.mergeNewDiff(null, null, document, diff, diffs.indexOf(diff));
                    continue;
                }
                if (Objects.isNull(parentComponent)) {
                    for (MetaComponent metaComponent : metaForm.getAllComponents()) {
                        if (!metaComponent.getKey().equals(diff.parentKey)) continue;
                        parentComponent = metaComponent;
                        break;
                    }
                }
                if (Objects.isNull(parentComponent)) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)diff.getReserveOne(), (CharSequence)"AddSonRow")) continue;
                    parentXmlTreeKey = "GridColumn@" + diff.parentKey;
                    parentNode = diff.getXmlTree().xmlTree.getTagNode(parentXmlTreeKey);
                    XmlDiffProcessor.mergeSonGridNewDiff((TagNode)parentNode, diff);
                    continue;
                }
                if (parentComponent instanceof MetaComponent) {
                    MetaComponent parentComp = (MetaComponent)parentComponent;
                    String parentXmlTreeKey2 = String.valueOf(ControlType.toString((Integer)parentComp.getControlType())) + "@" + diff.parentKey;
                    if (preDiff != null) {
                        String midFilePath2 = XmlFileProcessor.mergePreDiff(preDiff, diff);
                        XmlTreeWithPath xmlTreeWithPath2 = new XmlTreeWithPath(diff.getXmlTree().orgFilePath, diff.getXmlTree().tmpFilePath, XmlTreeWithPath.parseFilePath((String)midFilePath2).xmlTree);
                        diff.setXmlTree(xmlTreeWithPath2);
                    }
                    TagNode parentNode2 = diff.getXmlTree().xmlTree.getTagNode(parentXmlTreeKey2);
                    anInt = XmlDiffProcessor.mergeNewDiff(parentComp, parentNode2, document, diff, diffs.indexOf(diff));
                    preDiff = diff;
                    continue;
                }
                if (!(parentComponent instanceof MetaGridCell)) continue;
                parentXmlTreeKey = "GridColumn@" + diff.parentKey;
                parentNode = diff.getXmlTree().xmlTree.getTagNode(parentXmlTreeKey);
                XmlDiffProcessor.mergeSonGridNewDiff((TagNode)parentNode, diff);
                continue;
            }
            XmlDiffProcessor.mergeDiff(diff.getMetaForm(), diff, document);
        }
        return anInt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void mergeDeleteDiff(Diff diff) throws Throwable {
        String parentXmlTreeKey;
        String parentTagName;
        MetaForm metaForm = diff.getMetaForm();
        MetaObjectType objectType = diff.getMetaObjectType();
        String key = diff.getKey();
        TagNode parentNode = null;
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        IDLookup idLookup1 = IDLookup.getIDLookup(metaForm);
        if (objectType != MetaObjectType.operationCollection && objectType != MetaObjectType.operation) {
            try {
                parentNode = XmlDiffProcessor.examinationTagNode(metaForm, diff, key, xmlTree.xmlTree, idLookup1).getParent();
            }
            catch (Exception e) {
                parentTagName = IDLookup.getIDLookup(metaForm).getTagNameByKey(diff.parentKey);
                parentXmlTreeKey = String.valueOf(parentTagName) + "@" + diff.parentKey;
                parentNode = diff.getXmlTree().xmlTree.getTagNode(parentXmlTreeKey);
            }
        }
        if (objectType == MetaObjectType.gridField || objectType == MetaObjectType.field || objectType == MetaObjectType.panel || objectType == MetaObjectType.grid) {
            TagNode curNode;
            IDLookup idLookup = IDLookup.getIDLookup(metaForm);
            if (metaForm.getFormType() != 8) {
                parentTagName = idLookup.getTagNameByKey(diff.parentKey);
                parentXmlTreeKey = String.valueOf(parentTagName) + "@" + diff.parentKey;
                parentNode = diff.getXmlTree().xmlTree.getTagNode(parentXmlTreeKey);
                if (parentTagName != null && parentTagName.equals("TableRow")) {
                    throw new Throwable("\u8868\u683c\u89c6\u56fe\u884c\u6839\u7ec4\u4ef6\u4e0d\u5141\u8bb8\u5220\u9664");
                }
            }
            List<TagNode> subDetail = diff.getXmlTree().xmlTree.getRoot().findNodesByTagName("SubDetail");
            if (objectType == MetaObjectType.grid) {
                for (TagNode tagNode : subDetail) {
                    String bindingGridKey = tagNode.getAttributes().get("BindingGridKey");
                    String subDetailCom = tagNode.getAttributes().get("Key");
                    if (!key.equals(bindingGridKey)) continue;
                    throw new Throwable("\u8be5\u8868\u683c\u88ab" + (String)subDetailCom + "\u7ed1\u5b9a\u4e86\u8bf7\u5148\u89e3\u9664\u7ed1\u5b9a\u624d\u80fd\u5220\u9664");
                }
            }
            List<AbstractNode> children = parentNode.getChildren();
            try {
                curNode = XmlDiffProcessor.examinationTagNode(metaForm, diff, key, xmlTree.xmlTree, idLookup);
            }
            catch (Exception e) {
                curNode = diff.getXmlTree().xmlTree.getTagNode("GridColumn@" + key);
            }
            if (Objects.isNull(curNode)) {
                if (!StringUtils.equals((CharSequence)parentNode.getTagName(), (CharSequence)"Grid")) throw new Throwable("\u539f\u8868\u5355\u63a7\u4ef6\u4e0d\u652f\u6301\u5220\u9664!");
                for (AbstractNode child : children) {
                    if (!(child instanceof TagNode)) continue;
                    if ("ListView".equalsIgnoreCase(((TagNode)child).getTagName())) {
                        curNode = (TagNode)child;
                        continue;
                    }
                    if (!"DictView".equalsIgnoreCase(((TagNode)child).getTagName())) continue;
                    curNode = (TagNode)child;
                }
            }
            if ("SplitPanel".equalsIgnoreCase(parentNode.getTagName())) {
                List<AbstractNode> c = parentNode.getChildren();
                int number = 0;
                int deletenumber = 0;
                for (AbstractNode abstractNode : c) {
                    List<AbstractNode> nodes;
                    if (!(abstractNode instanceof TagNode) || "SplitSize".equalsIgnoreCase(((TagNode)abstractNode).getTagName())) continue;
                    if (key.equalsIgnoreCase(((TagNode)abstractNode).getAttributes().get("Key")) || (nodes = ((TagNode)abstractNode).getChildren()).size() > 1 && key.equalsIgnoreCase(((TagNode)nodes.get(1)).getAttributes().get("Key"))) break;
                    ++number;
                }
                int i = 0;
                while (i < c.size()) {
                    if (c.get(i) instanceof TagNode && "SplitSize".equalsIgnoreCase(((TagNode)c.get(i)).getTagName())) {
                        if (number == deletenumber) {
                            c.remove(i);
                        }
                        ++deletenumber;
                    }
                    ++i;
                }
            }
            if (Objects.isNull(curNode)) {
                throw new Throwable("\u5f53\u524d\u9009\u4e2d\u5b57\u6bb5\u5728xml\u4e2d\u4e0d\u5b58\u5728,\u64cd\u4f5c\u65e0\u6548");
            }
            boolean isMoreThanOne = true;
            if (objectType == MetaObjectType.gridField) {
                String extend;
                StringHashMap<MetaGridColumn> columnInfo_oldKey;
                MetaGridColumn metaGridColumn;
                String cellTreeKey;
                TagNode cellNode;
                String coluTreeKey = "GridColumn@" + key;
                TagNode coluNode = xmlTree.xmlTree.getTagNode(coluTreeKey);
                if (Objects.isNull(coluNode)) {
                    MetaGridColumn gridMetaColumnByKey = IDLookup.reloadIDLookup(metaForm).getGridMetaColumnByKey(diff.getKey());
                    String oldKey = Objects.isNull(gridMetaColumnByKey) ? diff.getKey() : gridMetaColumnByKey.getMetaKey();
                    String s = "GridColumn@" + oldKey;
                    coluNode = xmlTree.xmlTree.getTagNode(s);
                }
                if (!"Grid".equalsIgnoreCase(parentNode.getTagName())) {
                    parentNode = xmlTree.xmlTree.getTagNode("Grid@" + diff.parentKey);
                    children = parentNode.getChildren();
                }
                if (Objects.isNull(cellNode = xmlTree.xmlTree.getTagNode(cellTreeKey = "GridCell@" + key)) && (metaGridColumn = (MetaGridColumn)(columnInfo_oldKey = idLookup.getAllFieldKey2MetaGridColumnInfo_oldKey()).get((Object)key)) != null) {
                    String cellKey = metaGridColumn.getKey();
                    cellTreeKey = "GridCell@" + cellKey;
                    cellNode = xmlTree.xmlTree.getTagNode(cellTreeKey);
                }
                if (Objects.isNull(cellNode) && StringUtils.isNotEmpty((CharSequence)(extend = diff.getMetaForm().getExtend()))) {
                    throw new Throwable("\u9a6c\u7532\u4e2d\u7684\u6269\u5c55\u5b57\u6bb5\u4e0d\u5141\u8bb8\u5220\u9664");
                }
                MetaGrid metaGrid = (MetaGrid)metaForm.componentByKey(diff.parentKey);
                if (diff.getVestXmlTree() != null) {
                    Map leafIndexMap = metaGrid.getLeafIndexMap();
                    XmlDiffProcessor.deleteGridCell(leafIndexMap, key, coluNode, metaGrid, parentNode);
                } else {
                    if (metaGrid.getKey().equals(diff.parentKey)) {
                        if (StringUtils.isEmpty((CharSequence)metaForm.getExtend())) {
                            isMoreThanOne = metaGrid.getColumnCollection().size() > 1;
                        } else {
                            int count = 0;
                            for (MetaGridColumn metaGridColumn2 : metaGrid.getColumnCollection()) {
                                if (metaGridColumn2.isVestDeleted().booleanValue()) continue;
                                ++count;
                            }
                            boolean bl = isMoreThanOne = count > 1;
                        }
                    }
                    if (!isMoreThanOne) throw new Throwable("\u8868\u683c\u5217\u6700\u540e\u4e00\u5217\u4e0d\u5141\u8bb8\u5220\u9664");
                    coluTreeKey = "GridColumn@" + key;
                    TagNode columnNode = xmlTree.xmlTree.getTagNode("Column@" + key);
                    if (!"Grid".equalsIgnoreCase(parentNode.getTagName())) {
                        parentNode = xmlTree.xmlTree.getTagNode("Grid@" + diff.parentKey);
                        children = parentNode.getChildren();
                    }
                    boolean isOnly = false;
                    boolean hasSon = false;
                    int startIndex = 0;
                    int endIndex = 0;
                    int index = 0;
                    TagNode columnCollection = parentNode.findFirstTagNodeByTagName("GridColumnCollection");
                    TagNode nodeByTagName = coluNode.findFirstTagNodeByTagName("GridColumnCollection");
                    if (nodeByTagName != null) {
                        endIndex = XmlDiffProcessor.statisticsRowIndex(columnCollection, diff.getKey(), coluNode) - 1;
                        startIndex = endIndex - XmlDiffProcessor.statisticsLength(nodeByTagName) + 1;
                        hasSon = true;
                    } else {
                        index = XmlDiffProcessor.statisticsRowIndex(columnCollection, diff.getKey(), coluNode) - 1;
                    }
                    for (AbstractNode abstractNode : children) {
                        boolean hasConfigure;
                        if (!(abstractNode instanceof TagNode)) continue;
                        String tagName = ((TagNode)abstractNode).getTagName();
                        if ("GridColumnCollection".equals(tagName)) {
                            hasConfigure = XmlDiffProcessor.checkPublicConfigure(diff, coluTreeKey);
                            if (!hasConfigure) {
                                throw new Exception("\u8868\u683c\u5217" + coluTreeKey + "\u88ab\u5176\u4ed6\u914d\u7f6e\u5f15\u7528\uff0c\u8bf7\u5148\u6e05\u9664\u914d\u7f6e\u5728\u8fdb\u884c\u5220\u9664");
                            }
                            List<AbstractNode> columns = coluNode.getParent().getChildren();
                            if (coluNode.getParent().getChildrenByTagName("GridColumn").size() == 1) {
                                if (StringUtils.isNotEmpty((CharSequence)metaForm.getExtend())) {
                                    columnCollection.getChildren().remove(coluNode.getParent().getParent());
                                    continue;
                                }
                                coluNode.getParent().getParent().deleteChildByTagName("GridColumnCollection");
                                isOnly = true;
                                continue;
                            }
                            columns.remove(coluNode);
                            continue;
                        }
                        if (!"GridRowCollection".equals(tagName)) continue;
                        List<TagNode> gridRows = ((TagNode)abstractNode).findNodesByTagName("GridRow");
                        for (TagNode gridRow : gridRows) {
                            if (gridRow == null) continue;
                            List<AbstractNode> rows = gridRow.getChildren();
                            ArrayList<AbstractNode> nodeList = new ArrayList<AbstractNode>();
                            if (isOnly) continue;
                            if (hasSon) {
                                int i = startIndex;
                                while (i <= endIndex) {
                                    AbstractNode node = rows.get(i * 2 + 1);
                                    nodeList.add(node);
                                    ++i;
                                }
                                for (AbstractNode node : nodeList) {
                                    hasConfigure = XmlDiffProcessor.checkPublicConfigure(diff, ((TagNode)node).getAttributes().get("Key"));
                                    if (!hasConfigure) {
                                        throw new Exception("\u5355\u5143\u683c" + ((TagNode)node).getAttributes().get("Key") + "\u88ab\u5176\u4ed6\u914d\u7f6e\u5f15\u7528\uff0c\u8bf7\u5148\u6e05\u9664\u914d\u7f6e\u5728\u8fdb\u884c\u5220\u9664");
                                    }
                                    rows.remove(node);
                                }
                                continue;
                            }
                            TagNode node = (TagNode)rows.get(index * 2 + 1);
                            hasConfigure = XmlDiffProcessor.checkPublicConfigure(diff, node.getAttributes().get("Key"));
                            if (!hasConfigure) {
                                throw new Exception("\u5355\u5143\u683c" + node.getAttributes().get("Key") + "\u88ab\u5176\u4ed6\u914d\u7f6e\u5f15\u7528\uff0c\u8bf7\u5148\u6e05\u9664\u914d\u7f6e\u5728\u8fdb\u884c\u5220\u9664");
                            }
                            rows.remove(node);
                        }
                    }
                    if (cellNode != null) {
                        String tableKey = cellNode.getParent().getAttributes().get("TableKey");
                        if (columnNode != null && !StringUtils.isNotEmpty((CharSequence)metaForm.getDataSource().getRefObjectKey())) {
                            TagNode parent = columnNode.getParent();
                            int haveRelyOn = XmlDiffProcessor.isHaveRelyOn(key, xmlTree.xmlTree, tableKey);
                            if (haveRelyOn == 1 && !isOnly) {
                                parent.getChildren().remove(columnNode);
                                XmlDiffProcessor.genXmlDiff(xmlTree, parent, diff, false);
                            }
                        }
                    }
                }
            } else if (objectType == MetaObjectType.field) {
                TagNode parent;
                TagNode columnNode;
                String compViewKey;
                TagNode compViewNode;
                if (curNode.getTagName().equalsIgnoreCase("RadioButton") && "True".equalsIgnoreCase(curNode.getAttributes().get("IsGroupHead"))) {
                    String groupKey = curNode.getAttributes().get("GroupKey");
                    String isGroupHead = curNode.getAttributes().get("IsGroupHead");
                    List<MetaComponent> allComponent = idLookup.getAllComponent();
                    if ("true".equalsIgnoreCase(isGroupHead)) {
                        for (MetaComponent component : allComponent) {
                            if (!(component instanceof MetaRadioButton) || !((MetaRadioButton)component).getGroupKey().equalsIgnoreCase(groupKey) || ((MetaRadioButton)component).isGroupHead().booleanValue()) continue;
                            throw new Throwable("\u7ec4\u5934\u63a7\u4ef6\u6240\u5c5e\u7ec4\u6709\u5176\u4ed6\u5355\u9009\u6309\u94ae\u4f7f\u7528\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
                        }
                    }
                }
                children.remove(curNode);
                if ("EditView".equalsIgnoreCase(curNode.getTagName()) && (compViewNode = xmlTree.xmlTree.getTagNode(compViewKey = "ComponentView@" + diff.getKey())) != null) {
                    TagNode bodyNode = xmlTree.xmlTree.getRoot().getChildByTagName("Body");
                    TagNode parentViewNode = compViewNode.getParent();
                    if (parentViewNode != null) {
                        parentViewNode.getChildren().remove(compViewNode);
                    }
                    XmlDiffProcessor.genXmlDiff(xmlTree, bodyNode, diff, true);
                    return;
                }
                String columnValue = curNode.getOrCreateChildByTagName("DataBinding").getAttributes().get("ColumnKey");
                String tableKey = curNode.getOrCreateChildByTagName("DataBinding").getAttributes().get("TableKey");
                if (StringUtils.isBlank((CharSequence)diff.getMetaForm().getExtend()) && columnValue != null) {
                    int haveRelyOn = XmlDiffProcessor.isHaveRelyOn(columnValue, xmlTree.xmlTree, tableKey);
                    if (haveRelyOn == 0 && !StringUtils.isNotEmpty((CharSequence)metaForm.getDataSource().getRefObjectKey())) {
                        columnNode = xmlTree.xmlTree.getTagNode("Column@" + columnValue);
                        if (Objects.isNull(columnNode)) {
                            columnNode = diff.getDataObjectXmlTree().xmlTree.getTagNode("Column@" + columnValue);
                            if (columnNode != null) {
                                parent = columnNode.getParent();
                                parent.getChildren().remove(columnNode);
                                XmlDiffProcessor.genXmlDiff(diff.getDataObjectXmlTree(), parent, diff, false);
                            }
                        } else {
                            parent = columnNode.getParent();
                            if ("Dict".equalsIgnoreCase(curNode.getTagName()) || "DynamicDict".equalsIgnoreCase(curNode.getTagName())) {
                                TagNode nameNode;
                                TagNode codeNode = xmlTree.xmlTree.getTagNode("Column@" + columnValue + "Code");
                                if (codeNode != null) {
                                    parent.getChildren().remove(codeNode);
                                }
                                if ((nameNode = xmlTree.xmlTree.getTagNode("Column@" + columnValue + "Name")) != null) {
                                    parent.getChildren().remove(nameNode);
                                }
                            }
                            parent.getChildren().remove(columnNode);
                            XmlDiffProcessor.genXmlDiff(xmlTree, parent, diff, false);
                        }
                    }
                } else {
                    int haveRelyOn = XmlDiffProcessor.isHaveRelyOn(columnValue, xmlTree.xmlTree, tableKey);
                    if (haveRelyOn == 0 && Objects.nonNull(columnNode = xmlTree.xmlTree.getTagNode("Column@" + columnValue))) {
                        parent = columnNode.getParent();
                        parent.getChildren().remove(columnNode);
                        XmlDiffProcessor.genXmlDiff(xmlTree, parent, diff, false);
                    }
                }
            } else if (objectType == MetaObjectType.panel) {
                String tagName = parentNode.getTagName();
                if ("Block".equalsIgnoreCase(tagName)) {
                    throw new Throwable("\u6839\u9762\u677f\u4e0d\u5141\u8bb8\u5220\u9664");
                }
                XmlDiffProcessor.isInSubdetail(children, curNode, parentNode);
            } else if (objectType == MetaObjectType.grid) {
                XmlDiffProcessor.isInSubdetail(children, curNode, parentNode);
            }
        } else {
            TagNode curNode;
            String operatTreeKey;
            List<AbstractNode> children;
            TagNode curNode2;
            if (objectType == MetaObjectType.EditViewChildLayout) {
                String editViewKey = "EditView@" + diff.parentKey;
                TagNode colsNode = (TagNode)xmlTree.xmlTree.getTagNode(editViewKey).getChildrenByTagName("EditViewColumnCollection").get(0);
                String compViewKey = "ComponentView@" + diff.parentKey;
                TagNode compViewNode = xmlTree.xmlTree.getTagNode(compViewKey);
                XmlDiffProcessor.dealEditViewChildLayout(compViewNode, colsNode, diff.getKey());
                TagNode bodyNode = xmlTree.xmlTree.getRoot().getChildByTagName("Body");
                XmlDiffProcessor.genXmlDiff(xmlTree, bodyNode, diff, true);
                return;
            }
            if (objectType == MetaObjectType.EditViewColumn) {
                String editViewKey = "EditView@" + diff.parentKey;
                parentNode = (TagNode)xmlTree.xmlTree.getTagNode(editViewKey).getChildrenByTagName("EditViewColumnCollection").get(0);
                curNode2 = parentNode.getChildByKey(key);
                if (curNode2 == null) return;
                children = parentNode.getChildren();
                children.remove(curNode2);
                String compViewKey = "ComponentView@" + diff.parentKey;
                TagNode compViewNode = xmlTree.xmlTree.getTagNode(compViewKey);
                if (compViewNode != null) {
                    List<AbstractNode> childLayoutNodes = compViewNode.getChildren();
                    TagNode bodyNode = xmlTree.xmlTree.getRoot().getChildByTagName("Body");
                    int j = 0;
                    while (j < childLayoutNodes.size()) {
                        TagNode spanChildNode;
                        AbstractNode child = childLayoutNodes.get(j);
                        if (child instanceof TagNode && (spanChildNode = ((TagNode)child).getChildByKey(key)) != null) {
                            ((TagNode)child).getChildren().remove(spanChildNode);
                            break;
                        }
                        ++j;
                    }
                    XmlDiffProcessor.genXmlDiff(xmlTree, bodyNode, diff, true);
                    return;
                }
                XmlDiffProcessor.genXmlDiff(xmlTree, parentNode, diff, true);
                return;
            }
            if (objectType == MetaObjectType.TabItem) {
                String tabGrupKey = "TabGroup@" + diff.parentKey;
                parentNode = xmlTree.xmlTree.getTagNode(tabGrupKey);
                curNode2 = parentNode.getChildByKey(key);
                if (curNode2 == null) return;
                children = parentNode.getChildren();
                children.remove(curNode2);
                XmlDiffProcessor.genXmlDiff(xmlTree, parentNode, diff, true);
                return;
            }
            if (objectType == MetaObjectType.operationCollection || objectType == MetaObjectType.operation) {
                parentNode = diff.getXmlTree().xmlTree.getRoot().findFirstTagNodeByTagName("OperationCollection");
                List<AbstractNode> children2 = parentNode.getChildren();
                operatTreeKey = "Operation@" + key;
                curNode = xmlTree.xmlTree.getTagNode(operatTreeKey);
                String operatTreeKey1 = "OperationCollection@" + key;
                if (Objects.isNull(curNode)) {
                    curNode = xmlTree.xmlTree.getTagNode(operatTreeKey1);
                }
                children2.remove(curNode);
            } else if (objectType == MetaObjectType.toolbar || objectType == MetaObjectType.ToolBar) {
                parentNode = diff.getXmlTree().xmlTree.getRoot().findFirstTagNodeByTagName("ToolBar").getParent();
                List<AbstractNode> children3 = parentNode.getChildren();
                operatTreeKey = "ToolBar@" + key;
                curNode = xmlTree.xmlTree.getTagNode(operatTreeKey);
                children3.remove(curNode);
            } else {
                if (objectType == MetaObjectType.Embed) {
                    String operatTreeKey2 = "Embed@" + key;
                    curNode2 = xmlTree.xmlTree.getTagNode(operatTreeKey2);
                    if (curNode2 == null) return;
                    parentNode = curNode2.getParent();
                    children = parentNode.getChildren();
                    children.remove(curNode2);
                    XmlDiffProcessor.genXmlDiff(xmlTree, parentNode, diff, true);
                    return;
                }
                if (objectType == MetaObjectType.DeleteTableViewRow) {
                    MetaComponent metaComp = IOMetaObject.getComponentByKey(metaForm, diff.parentKey);
                    String rowTagName = metaComp.getControlType() == 306 ? "CollectionViewRow" : "TableRow";
                    String tableViewRowKey = String.valueOf(rowTagName) + "@" + key;
                    TagNode curNode3 = xmlTree.xmlTree.getTagNode(tableViewRowKey);
                    if (curNode3 == null) return;
                    parentNode = curNode3.getParent();
                    if (parentNode.findNodesByTagName(rowTagName).size() == 1) {
                        throw new Throwable("\u8be5\u884c\u89c6\u56fe\u4e3a\u8868\u683c\u89c6\u56fe\u7ec4\u4ef6\u552f\u4e00\u884c\u89c6\u56fe\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
                    }
                    if (curNode3.getAttributes().get("RowType") != null && curNode3.getAttributes().get("RowType").equals("Detail")) {
                        TagNode nextNode;
                        TagNode preNode;
                        int index = parentNode.getChildren().indexOf(curNode3);
                        if (index > 1 && (preNode = (TagNode)parentNode.getChildren().get(index - 2)) != null && preNode.getAttributes().get("RowType") != null && preNode.getAttributes().get("RowType").equals("Group")) {
                            parentNode.getChildren().remove(preNode);
                        }
                        if ((index = parentNode.getChildren().indexOf(curNode3)) >= 0 && index < parentNode.getChildren().size() - 1 && (nextNode = (TagNode)parentNode.getChildren().get(index + 2)) != null && nextNode.getAttributes().get("RowType") != null && nextNode.getAttributes().get("RowType").equals("GroupTail")) {
                            parentNode.getChildren().remove(nextNode);
                        }
                    } else if (curNode3.getAttributes().get("RowType") != null && curNode3.getAttributes().get("RowType").equals("Group")) {
                        List<TagNode> tableRowNodes = parentNode.findNodesByTagName(rowTagName);
                        for (TagNode tableRowNode : tableRowNodes) {
                            if (!tableRowNode.getAttributes().containsKey("RowType") || !tableRowNode.getAttributes().get("RowType").equals("GroupTail")) continue;
                            parentNode.getChildren().remove(tableRowNode);
                        }
                    }
                    parentNode.getChildren().remove(curNode3);
                    XmlDiffProcessor.genXmlDiff(xmlTree, parentNode, diff, true);
                    return;
                }
                if (objectType == MetaObjectType.GridFieldRow) {
                    IDLookup idLookup = IDLookup.getIDLookup(metaForm);
                    if (!StringUtils.isNotEmpty((CharSequence)diff.parentKey)) {
                        TagNode rows = xmlTree.xmlTree.getTagNode("GridRow@" + key);
                        List<TagNode> cells = rows.findMyselfNodesByTagName("GridCell");
                        key = cells.get(0).getAttributes().get("Key");
                        diff.parentKey = rows.getParent().getParent().getAttributes().get("Key");
                    }
                    parentTagName = idLookup.getTagNameByKey(diff.parentKey);
                    parentXmlTreeKey = String.valueOf(parentTagName) + "@" + diff.parentKey;
                    parentNode = diff.getXmlTree().xmlTree.getTagNode(parentXmlTreeKey);
                    String XmlTreeKey = "GridRow@" + key;
                    TagNode rowNode = null;
                    TagNode curNode4 = xmlTree.xmlTree.getTagNode(XmlTreeKey);
                    if (Objects.isNull(curNode4)) {
                        MetaGridRowCollection rowCollection = idLookup.getMetaGridByGridKey(diff.parentKey).getRowCollection();
                        for (MetaGridRow metaGridRow : rowCollection) {
                            if (metaGridRow.findCellByKey(key) == null) continue;
                            rowNode = xmlTree.xmlTree.getTagNode("GridRow@" + metaGridRow.getKey());
                            break;
                        }
                    } else {
                        rowNode = curNode4;
                    }
                    if (rowNode == null) {
                        throw new Throwable("\u5f53\u524d\u9009\u4e2d\u5b57\u6bb5\u5728xml\u4e2d\u4e0d\u5b58\u5728,\u64cd\u4f5c\u65e0\u6548");
                    }
                    String rowKey = rowNode.getAttributes().get("Key");
                    MetaGridRowCollection metaGridRows = idLookup.getMetaGridByGridKey(diff.parentKey).getRowCollection();
                    String groupKey = null;
                    for (MetaGridRow metaGridRow : metaGridRows) {
                        if (metaGridRow.getRowType() != 1) continue;
                        groupKey = metaGridRow.getGroupKey();
                    }
                    for (MetaGridRow row : metaGridRows) {
                        MetaGridCell metaGridCell;
                        if (!row.getKey().equalsIgnoreCase(rowKey) || (metaGridCell = row.findCellByKey(groupKey)) == null) continue;
                        throw new Throwable("\u8be5\u884c\u5728\u5176\u4ed6\u884c\u4e2d\u6709\u4f9d\u8d56\u5173\u7cfb\u4e0d\u5141\u8bb8\u5220\u9664");
                    }
                    TagNode rowColls = rowNode.getParent();
                    List<AbstractNode> rowList = rowColls.getChildren();
                    String rowType = rowColls.getChildByKey(rowKey).getAttributes().get("RowType");
                    if (rowColls.getChildrenByTagName("GridRow").size() == 1) {
                        throw new Throwable("\u8868\u683c\u6700\u540e\u4e00\u884c\u4e0d\u5141\u8bb8\u5220\u9664!");
                    }
                    if ("Detail".equalsIgnoreCase(rowType)) {
                        throw new Throwable("\u660e\u7ec6\u884c\u4e0d\u5141\u8bb8\u5220\u9664!");
                    }
                    if (StringUtils.isEmpty((CharSequence)rowType)) {
                        TagNode extendParentNode;
                        String extendRowType;
                        MetaForm extendMetaForm = MetaFormHelper.getExtendMetaForm(metaForm);
                        if (extendMetaForm == metaForm) {
                            throw new Throwable("\u660e\u7ec6\u884c\u4e0d\u5141\u8bb8\u5220\u9664!");
                        }
                        String pathByFormKey = LoadFileTree.getPathByFormKey(extendMetaForm.getKey());
                        XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(pathByFormKey);
                        TagNode extendCurNode = xmlTreeWithPath.xmlTree.getTagNode(XmlTreeKey);
                        if (Objects.nonNull(extendCurNode) && StringUtils.equalsIgnoreCase((CharSequence)"Detail", (CharSequence)(extendRowType = (extendParentNode = extendCurNode.getParent()).getAttributes().get("RowType")))) {
                            throw new Throwable("\u660e\u7ec6\u884c\u4e0d\u5141\u8bb8\u5220\u9664!");
                        }
                    }
                    rowList.remove(rowNode);
                } else if (objectType == MetaObjectType.ListViewColumn) {
                    String parentXmlTreeKey2 = "ListView@" + diff.parentKey;
                    parentNode = diff.getXmlTree().xmlTree.getTagNode(parentXmlTreeKey2);
                    TagNode columnNode = xmlTree.xmlTree.getTagNode("Column@" + key);
                    if (columnNode != null) {
                        TagNode parent = columnNode.getParent();
                        parent.getChildren().remove(columnNode);
                        XmlDiffProcessor.genXmlDiff(xmlTree, parent, diff, false);
                    }
                    children = parentNode.getChildren();
                    for (AbstractNode abstractNode : children) {
                        if (!(abstractNode instanceof TagNode) || !"ListViewColumnCollection".equalsIgnoreCase(((TagNode)abstractNode).getTagName())) continue;
                        ((TagNode)abstractNode).deleteChildByTagKey(diff.getKey());
                        break;
                    }
                } else if (objectType == MetaObjectType.subDetail) {
                    if (StringUtils.equals((CharSequence)parentNode.getTagName(), (CharSequence)"SplitPanel")) {
                        List<AbstractNode> children4 = parentNode.getChildren();
                        int curIdx = 0;
                        curNode = null;
                        for (AbstractNode child : children4) {
                            TagNode tagNode;
                            boolean flag = child instanceof TagNode;
                            if (!flag || Objects.equals((tagNode = (TagNode)child).getTagName(), "SplitSize")) continue;
                            Map<String, String> attributes = tagNode.getAttributes();
                            if (Objects.nonNull(attributes) && Objects.equals(attributes.get("Key"), diff.getKey())) {
                                curNode = tagNode;
                                break;
                            }
                            ++curIdx;
                        }
                        int curSplitIdx = 0;
                        TagNode curSplitNode = null;
                        int i = 0;
                        while (i < children4.size() && Objects.nonNull(curNode)) {
                            TagNode tagNode;
                            AbstractNode child = children4.get(i);
                            boolean flag = child instanceof TagNode;
                            if (flag && Objects.equals((tagNode = (TagNode)child).getTagName(), "SplitSize")) {
                                if (curSplitIdx == curIdx) {
                                    curSplitNode = tagNode;
                                    break;
                                }
                                ++curSplitIdx;
                            }
                            ++i;
                        }
                        if (Objects.nonNull(curNode) && Objects.nonNull(curSplitNode)) {
                            children4.remove(curNode);
                            children4.remove(curSplitNode);
                        }
                    } else {
                        List<AbstractNode> children5 = parentNode.getChildren();
                        Predicate<AbstractNode> predicate = absNode -> {
                            boolean flag = absNode instanceof TagNode;
                            if (!flag) {
                                return false;
                            }
                            TagNode tagNode = (TagNode)absNode;
                            Map<String, String> attributes = tagNode.getAttributes();
                            return Objects.nonNull(attributes) && Objects.equals(attributes.get("Key"), diff.getKey());
                        };
                        Optional<AbstractNode> optional = children5.stream().filter(predicate).findFirst();
                        optional.ifPresent(children5::remove);
                    }
                } else if (objectType == MetaObjectType.Block) {
                    TagNode formNode = diff.getXmlTree().xmlTree.getTagNode("Form@" + diff.getMetaForm().getKey());
                    parentNode = formNode.getChildByTagName("Body");
                    for (TagNode node : parentNode.findNodesByTagName("Block")) {
                        String blockKey = node.getAttributes().get("Key");
                        if (blockKey == null || !blockKey.equals(diff.getKey())) continue;
                        parentNode.getChildren().remove(node);
                        break;
                    }
                }
            }
        }
        XmlDiffProcessor.genXmlDiff(xmlTree, parentNode, diff, true);
    }

    private static void deleteGridCell(Map<String, Integer> leafIndexMap, String key, TagNode coluNode, MetaGrid grid, TagNode parentNode) {
        if (leafIndexMap.containsKey(key)) {
            Integer i = leafIndexMap.get(key);
            coluNode.getParent().deleteChildByTagKey(key);
            for (MetaGridRow metaGridRow : grid.getRowCollection()) {
                MetaGridCell gridCell = (MetaGridCell)metaGridRow.get(i.intValue());
                if (parentNode.getChildByTagName("GridRowCollection") == null || parentNode.getChildByTagName("GridRowCollection").getChildByKey(metaGridRow.getKey()) == null) continue;
                parentNode.getChildByTagName("GridRowCollection").getChildByKey(metaGridRow.getKey()).deleteChildByTagKey(gridCell.getKey());
            }
        } else {
            MetaGridColumn gridColumn = grid.findColumnByKey(key);
            for (MetaGridColumn metaGridColumn : gridColumn.getColumnCollection()) {
                XmlDiffProcessor.deleteGridCell(leafIndexMap, metaGridColumn.getKey(), coluNode, grid, parentNode);
            }
        }
    }

    public static TagNode examinationTagNode(MetaForm metaForm, Diff diff, String key, XmlTree xmlTree, IDLookup idLookup) throws Throwable {
        Boolean mergeToSource;
        TagNode column;
        String nodeTagName;
        String trueName = "";
        boolean flag = false;
        if (metaForm.getFormType() == 8) {
            nodeTagName = idLookup.getTagNameByKey(key);
            if (StringUtils.isBlank((CharSequence)nodeTagName) && diff.getMetaObjectType() == MetaObjectType.Embed) {
                nodeTagName = MetaObjectType.Embed.name;
            }
        } else if (MetaObjectType.operation.toString().equalsIgnoreCase(diff.getMetaObjectType().name)) {
            nodeTagName = metaForm.getOperationCollection().get(key).getTagName();
        } else if (MetaObjectType.ListViewColumn.toString().equalsIgnoreCase(diff.getMetaObjectType().name)) {
            nodeTagName = ((MetaListViewColumn)metaForm.getListViewColumnMap().get((Object)key)).getTagName();
        } else if (MetaObjectType.DeleteTableViewRow.toString().equalsIgnoreCase(diff.getMetaObjectType().name)) {
            nodeTagName = "TableRow";
            MetaComponent metaComp = IOMetaObject.getComponentByKey(metaForm, diff.parentKey);
            if (metaComp.getControlType() == 306) {
                nodeTagName = "CollectionViewRow";
            }
        } else if (MetaObjectType.GridFieldRow.toString().equalsIgnoreCase(diff.getMetaObjectType().name)) {
            if (Objects.isNull(metaForm.metaGridCellByKey(key))) {
                column = xmlTree.getTagNode("GridRow@" + key);
                List<TagNode> cells = column.findMyselfNodesByTagName("GridCell");
                trueName = cells.get(0).getAttributes().get("Key");
                nodeTagName = metaForm.metaGridCellByKey(trueName).getTagName();
                flag = true;
            } else {
                nodeTagName = metaForm.metaGridCellByKey(key).getTagName();
            }
        } else if (MetaObjectType.gridField.toString().equalsIgnoreCase(diff.getMetaObjectType().name)) {
            IDLookup.reloadIDLookup(metaForm);
            if (metaForm.getAllUIComponents().get(key) != null) {
                nodeTagName = ((AbstractMetaObject)metaForm.getAllUIComponents().get(key)).getTagName();
            } else {
                column = xmlTree.getTagNode("GridColumn@" + key);
                trueName = column.getParent().getParent().getAttributes().get("Key");
                nodeTagName = ((AbstractMetaObject)metaForm.getAllUIComponents().get(trueName)).getTagName();
                flag = true;
            }
        } else {
            if (MetaObjectType.TabItem.toString().equalsIgnoreCase(diff.getMetaObjectType().name)) {
                String tabGrupKey = "TabGroup@" + diff.parentKey;
                TagNode parentNode = xmlTree.getTagNode(tabGrupKey);
                return parentNode.getChildByKey(key);
            }
            AbstractMetaObject abstractMetaObject = (AbstractMetaObject)metaForm.getAllUIComponents().get(key);
            if (abstractMetaObject == null) {
                for (MetaComponent metaComponent : metaForm.getAllComponents()) {
                    if (!metaComponent.getKey().equals(key)) continue;
                    abstractMetaObject = metaComponent;
                    break;
                }
            }
            if (abstractMetaObject != null) {
                nodeTagName = abstractMetaObject.getTagName();
            } else {
                MetaEmbed metaEmbed = metaForm.embedByKey(key);
                nodeTagName = metaEmbed.getTagName();
            }
        }
        String XmlTreeKey = flag ? String.valueOf(nodeTagName) + "@" + trueName : String.valueOf(nodeTagName) + "@" + key;
        TagNode curNode = xmlTree.getTagNode(XmlTreeKey);
        MetaFormProfile metaFormProfile = (MetaFormProfile)MetaFactory.getGlobalInstance().getMetaFormList().get(metaForm.getKey());
        if (metaFormProfile == null) {
            metaFormProfile = (MetaFormProfile)MetaFactory.getGlobalInstance().getExtFormList().get(metaForm.getKey());
        }
        if ((mergeToSource = metaFormProfile.getMergeToSource()).booleanValue() && MetaObjectType.GridFieldRow.toString().equalsIgnoreCase(diff.getMetaObjectType().name)) {
            if (curNode != null) {
                TagNode tagNode = diff.getVestXmlTree().xmlTree.getTagNode("GridRow@" + curNode.getParent().getAttributes().get("Key"));
                if (tagNode != null) {
                    throw new Throwable("\u539f\u8868\u5355\u63a7\u4ef6\u4e0d\u652f\u6301\u5220\u9664!");
                }
            } else {
                throw new Throwable("\u8be5\u7ec4\u4ef6\u4e3a\u9a6c\u7532\u5220\u9664\u7ec4\u4ef6\u4ec5\u5728\u8bbe\u8ba1\u754c\u9762\u4e0a\u663e\u793a\u4e0e\u539f\u8868\u5355\u4f5c\u5bf9\u6bd4\uff0c\u5e76\u4e0d\u652f\u6301\u5176\u4ed6\u64cd\u4f5c!");
            }
        }
        return curNode;
    }

    private static void isInSubdetail(List<AbstractNode> children, TagNode curNode, TagNode parentNode) {
        if ("ToolBar".equalsIgnoreCase(parentNode.getTagName())) {
            children.remove(curNode);
        } else {
            TagNode curNodeParent = curNode;
            while (!Objects.isNull(curNodeParent = curNodeParent.getParent()) && !"SubDetail".equals(curNodeParent.getTagName())) {
            }
            if (curNodeParent != null && "SubDetail".equals(curNodeParent.getTagName())) {
                if (!children.contains(curNodeParent)) {
                    children.remove(curNode);
                } else {
                    children.remove(curNodeParent);
                }
            } else {
                children.remove(curNode);
            }
        }
    }

    private static Integer compIndex(List<AbstractNode> absNodes, String sideKey) {
        for (AbstractNode col : absNodes) {
            if (!(col instanceof TagNode) || ((TagNode)col).getAttributes() == null || !sideKey.equals(((TagNode)col).getAttributes().get("Key"))) continue;
            return absNodes.indexOf(col);
        }
        return 0;
    }

    private static void addSubCompToSubDetail(TagNode subDetailNode, Diff diff) throws Throwable {
        String sourceFormKey = diff.getParamsformKey();
        MetaForm metaSourceForm = MetaFactory.getGlobalInstance().getMetaForm(sourceFormKey);
        MetaSubDetail metaSourceSubDetail = null;
        for (MetaComponent metaSubDetail : metaSourceForm.getSubDetails()) {
            if (!metaSubDetail.getKey().equals(diff.getKey())) continue;
            metaSourceSubDetail = (MetaSubDetail)metaSubDetail;
            break;
        }
        if (metaSourceSubDetail != null) {
            MetaComponent metaRootComp = metaSourceSubDetail.getRoot();
            if (metaRootComp.getTagName().endsWith("Panel")) {
                TagNode rootPanelNode = new TagNode("TabPanel", null);
                rootPanelNode.setAttribute("Key", String.valueOf(diff.getKey()) + "_RootPanel");
                rootPanelNode.setAttribute("Caption", "\u6839\u9762\u677f");
                XmlDiffProcessor.addFieldsToSubDetailRootPanel(rootPanelNode, metaRootComp);
                TagNode baseInfoPanelNode = rootPanelNode.findFirstTagNodeByTagName("FlexFlowLayoutPanel");
                if (baseInfoPanelNode != null && baseInfoPanelNode.getChildren().isEmpty()) {
                    rootPanelNode.getChildren().remove(baseInfoPanelNode);
                }
                subDetailNode.addNode(rootPanelNode);
            } else if (metaRootComp.getTagName().equals("Grid")) {
                TagNode tableViewNode = XmlDiffProcessor.getTableViewNodeByGrid((MetaGrid)metaRootComp);
                subDetailNode.addNode(tableViewNode);
            }
            subDetailNode.setAttribute("BindingGridKey", metaSourceSubDetail.getBindingGridKey());
        }
    }

    private static void addFieldsToSubDetailRootPanel(TagNode rootTabPanelNode, MetaComponent metaRootComp) {
        TagNode baseInfoPanelNode = rootTabPanelNode.findFirstTagNodeByTagName("FlexFlowLayoutPanel");
        if (baseInfoPanelNode == null) {
            baseInfoPanelNode = new TagNode("FlexFlowLayoutPanel", null);
            baseInfoPanelNode.setAttribute("Key", "BaseInfoPanel");
            baseInfoPanelNode.setAttribute("Caption", "\u57fa\u672c\u4fe1\u606f");
            baseInfoPanelNode.setAttribute("Padding", "10px");
            rootTabPanelNode.addNode(baseInfoPanelNode);
        }
        int i = 0;
        while (i < metaRootComp.getComponentCount()) {
            MetaComponent metaSubComp = metaRootComp.getComponent(i);
            if (metaSubComp.getTagName().equals("Grid")) {
                TagNode tableViewNode = XmlDiffProcessor.getTableViewNodeByGrid((MetaGrid)metaSubComp);
                rootTabPanelNode.addNode(tableViewNode);
            } else if (!metaSubComp.getTagName().endsWith("Panel") && metaSubComp.isRequired().booleanValue()) {
                TagNode subCompNode = new TagNode(ControlType.toString((Integer)metaSubComp.getControlType()), null);
                subCompNode.setAttribute("Key", metaSubComp.getKey());
                subCompNode.setAttribute("Height", "32px");
                subCompNode.setAttribute("TopMargin", "5px");
                baseInfoPanelNode.addNode(subCompNode);
            }
            if (metaSubComp.getComponentCount() > 0) {
                XmlDiffProcessor.addFieldsToSubDetailRootPanel(rootTabPanelNode, metaSubComp);
            }
            ++i;
        }
    }

    private static TagNode getTableViewNodeByGrid(MetaGrid metaGrid) {
        TagNode tableViewNode = new TagNode("TableView", null);
        tableViewNode.setAttribute("Key", String.valueOf(metaGrid.getKey()) + "_TableView");
        tableViewNode.setAttribute("Caption", metaGrid.getCaption());
        TagNode tableRowCollectionNode = new TagNode("TableRowCollection", null);
        tableViewNode.addNode(tableRowCollectionNode);
        TagNode tableRowNode = new TagNode("TableRow", null);
        tableRowNode.setAttribute("Key", metaGrid.getKey());
        tableViewNode.setAttribute("Caption", metaGrid.getCaption());
        TagNode rootPanelNode = XmlDiffProcessor.getTableRowDefaultPanelNode("GridLayoutPanel", metaGrid.getKey());
        tableRowNode.addNode(rootPanelNode);
        tableRowCollectionNode.addNode(tableRowNode);
        int cellCount = 0;
        int j = 0;
        while (j < metaGrid.getDetailMetaRow().size()) {
            MetaGridCell metaGridCell = (MetaGridCell)metaGrid.getDetailMetaRow().get(j);
            if (metaGridCell.isRequired().booleanValue()) {
                TagNode subCompNode = new TagNode(ControlType.toString((Integer)metaGridCell.getCellType()), null);
                subCompNode.setAttribute("Key", metaGridCell.getKey());
                subCompNode.setAttribute("Caption", metaGridCell.getCaption());
                subCompNode.setAttribute("X", "1");
                subCompNode.setAttribute("XSpan", "2");
                subCompNode.setAttribute("Y", "" + cellCount);
                subCompNode.setAttribute("Class", "innerLabel-show");
                if (cellCount > 1) {
                    TagNode rowDefCollectionNode = rootPanelNode.findFirstTagNodeByTagName("RowDefCollection");
                    TagNode rowDefNode = new TagNode("RowDef", null);
                    rowDefCollectionNode.addNode(rowDefNode);
                }
                rootPanelNode.addNode(subCompNode);
                ++cellCount;
            }
            ++j;
        }
        return tableViewNode;
    }

    private static void addSplitSize(TagNode parentNode) {
        if ("SplitPanel".equals(parentNode.getTagName())) {
            TagNode splitSizeNode = new TagNode("SplitSize", null);
            splitSizeNode.setAttribute("Size", "150px");
            parentNode.addNode(splitSizeNode);
        }
    }

    private static void addNodeToSplitPanel(TagNode parentNode, TagNode childNode) {
        if (childNode.getParent() != null && childNode.getParent().getChildren().contains(childNode)) {
            int index = childNode.getParent().getChildren().indexOf(childNode);
            parentNode.addNode(childNode, index);
        } else {
            List<AbstractNode> children = parentNode.getChildren();
            if ("SplitPanel".equals(parentNode.getTagName())) {
                int indexOfSizeNode = children.indexOf(XmlDiffProcessor.firstSplitSize(children));
                if (indexOfSizeNode == -1) {
                    parentNode.addNode(childNode);
                } else {
                    children.add(indexOfSizeNode, childNode);
                }
            } else {
                parentNode.addNode(childNode);
            }
        }
    }

    private static TagNode firstSplitSize(List<AbstractNode> children) {
        for (AbstractNode abstractNode : children) {
            String tagName;
            if (!(abstractNode instanceof TagNode) || !"SplitSize".equals(tagName = ((TagNode)abstractNode).getTagName())) continue;
            return (TagNode)abstractNode;
        }
        return null;
    }

    public static void codeAndNameWithDictComponent(Diff diff, String key, String tableKey, TagNode newColumn) throws Throwable {
        MetaTableCollection metaTables;
        MetaDataObject metaDataObject;
        TagNode tableNode = null;
        tableNode = StringUtils.isNotEmpty((CharSequence)diff.getMetaForm().getDataSource().getRefObjectKey()) ? diff.getDataObjectXmlTree().xmlTree.getTagNode("Table@" + tableKey) : diff.getTagNode("Table@" + tableKey);
        if (key.toLowerCase().endsWith("id")) {
            key = key.substring(0, key.length() - 2);
        }
        String codeColumnKey = String.valueOf(key) + "Code";
        TagNode code = new TagNode("Column", null);
        code.setAttribute("Key", codeColumnKey);
        code.setAttribute("Caption", diff.caption);
        code.setAttribute("DataType", "Varchar");
        int length = 30;
        if (diff.getItemKey() != null && (metaDataObject = MetaFactory.getGlobalInstance().getDataObject(diff.getItemKey())) != null && (metaTables = metaDataObject.getTableCollection()) != null) {
            for (MetaTable metaTable : metaTables) {
                if (metaTable.get("Code") == null) continue;
                length = ((MetaColumn)metaTable.get("Code")).getLength();
                break;
            }
        }
        code.setAttribute("Length", String.valueOf(length));
        tableNode.deleteChildByTagKey(codeColumnKey);
        tableNode.addNode(code);
        newColumn.setAttribute("CodeColumnKey", codeColumnKey);
    }

    /*
     * WARNING - void declaration
     */
    private static int mergeNewDiff(MetaComponent selectComp, TagNode selectNode, Document document, Diff diff, int diffSize) throws Throwable {
        TagNode gridLayoutNode;
        TagNode flexNode;
        TagNode tabNode;
        IDLookup idLookup;
        TagNode tabNode2;
        Integer rowDefIndex;
        TagNode tagbPanelNode;
        List<AbstractNode> children;
        List<AbstractNode> children2;
        TagNode endOpeColl;
        TagNode opecoll;
        TagNode formNode;
        Object parentXmlTreeKey;
        List<TagNode> operation;
        String action;
        TagNode opecolls;
        TagNode operat;
        List<TagNode> operationCollectionNodeList;
        int anInt;
        MetaFormList metaFormList;
        IMetaFactory metaFactory;
        String controlType;
        MetaForm metaForm;
        block551: {
            TagNode newWrapNode;
            MetaForm originalMetaForm;
            AbstractMetaObject abstractMetaObject;
            metaForm = diff.getMetaForm();
            controlType = ControlType.toString((Integer)diff.getControlType());
            metaFactory = MetaFactory.getGlobalInstance();
            metaFormList = metaFactory.getMetaFormList();
            anInt = 1;
            if (diff.getMetaObjectType() != MetaObjectType.EmbedPanel) break block551;
            MetaFormProfile metaFormProfile = (MetaFormProfile)metaFormList.get(metaForm.getKey());
            if (metaFormProfile == null) {
                metaFormProfile = (MetaFormProfile)metaFactory.getExtFormList().get(metaForm.getKey());
            }
            if (metaFormProfile.getMergeToSource().booleanValue() && (abstractMetaObject = (AbstractMetaObject)(originalMetaForm = metaFactory.getMetaForm(metaForm.getExtend())).getAllUIComponents().get(diff.parentKey)) != null) {
                throw new Throwable("\u539f\u5355\u63a7\u4ef6\u4e0d\u652f\u6301\u5916\u5d4c\u7ec4\u4ef6");
            }
            TagNode oldParentNode = selectNode.getParent();
            Map<String, String> attributes = selectNode.getAttributes();
            if (StringUtils.isBlank((CharSequence)attributes.get("Caption"))) {
                selectNode.setAttribute("Caption", attributes.get("Key"));
            }
            switch (controlType) {
                case "TabPanel": {
                    newWrapNode = new TagNode(controlType, null);
                    newWrapNode.setAttribute("Key", diff.getKey());
                    newWrapNode.setAttribute("Caption", diff.caption);
                    newWrapNode.addNode(selectNode);
                    break;
                }
                case "GridLayoutPanel": {
                    IDLookup idLookup2 = IDLookup.getIDLookup(metaForm);
                    while (idLookup2.containFieldKey("tempGridLayoutPanel" + anInt)) {
                        ++anInt;
                    }
                    newWrapNode = XmlDiffProcessor.SetGridLayoutPanel(diff, metaForm, anInt);
                    newWrapNode.setAttribute("Height", "100%");
                    newWrapNode.setAttribute("Width", "100%");
                    newWrapNode.getAttributes().remove("Padding");
                    selectNode.setAttribute("X", "0");
                    selectNode.setAttribute("Y", "0");
                    selectNode.setAttribute("XSpan", "1");
                    selectNode.setAttribute("YSpan", "1");
                    selectNode.setAttribute("Height", "100%");
                    selectNode.setAttribute("Width", "100%");
                    newWrapNode.addNode(selectNode);
                    break;
                }
                case "SplitPanel": {
                    newWrapNode = new TagNode(controlType, null);
                    newWrapNode.setAttribute("Key", diff.getKey());
                    newWrapNode.setAttribute("Caption", diff.caption);
                    newWrapNode.setAttribute("Orientation", "Vertical");
                    TagNode size = new TagNode("SplitSize", null);
                    size.setAttribute("Size", "100px");
                    newWrapNode.addNode(selectNode, 0);
                    newWrapNode.getChildren().add(size);
                    break;
                }
                case "FlowLayoutPanel": 
                case "LinearLayoutPanel": 
                case "FlexFlowLayoutPanel": {
                    newWrapNode = new TagNode(controlType, null);
                    newWrapNode.setAttribute("Key", diff.getKey());
                    newWrapNode.setAttribute("Caption", diff.caption);
                    newWrapNode.setAttribute("Height", "100%");
                    newWrapNode.setAttribute("Width", "pref");
                    newWrapNode.addNode(selectNode);
                    break;
                }
                case "ColumnLayoutPanel": {
                    newWrapNode = new TagNode(controlType, null);
                    newWrapNode.setAttribute("Key", diff.getKey());
                    newWrapNode.setAttribute("Caption", diff.caption);
                    newWrapNode.setAttribute("Height", "100%");
                    newWrapNode.setAttribute("Width", "pref");
                    selectNode.setAttribute("X", "0");
                    selectNode.setAttribute("Y", "0");
                    selectNode.setAttribute("XSpan", "1");
                    selectNode.setAttribute("YSpan", "1");
                    selectNode.setAttribute("Height", "100%");
                    selectNode.setAttribute("Width", "100%");
                    newWrapNode.addNode(selectNode);
                }
                default: {
                    if (diff.getReserveOne().equalsIgnoreCase(attributes.get("Key"))) {
                        throw new Throwable("\u5b50\u660e\u7ec6\u5173\u8054\u8868\u6807\u8bc6\u4e0d\u80fd\u5173\u8054\u81ea\u5df1");
                    }
                    newWrapNode = new TagNode(controlType, null);
                    newWrapNode.setAttribute("Key", diff.getKey());
                    newWrapNode.setAttribute("Caption", diff.caption);
                    newWrapNode.setAttribute("BindingGridKey", diff.getReserveOne());
                    newWrapNode.addNode(selectNode);
                }
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)oldParentNode.getTagName(), (CharSequence)"GridLayoutPanel")) {
                newWrapNode.setAttribute("X", attributes.get("X"));
                newWrapNode.setAttribute("Y", attributes.get("Y"));
            }
            int location = XmlDiffProcessor.location(diff, oldParentNode);
            oldParentNode.deleteChildByTagKey(diff.parentKey);
            oldParentNode.addNode(newWrapNode, location);
            XmlTreeWithPath xmlTree = diff.getXmlTree();
            int n = xmlTree.xmlTree.getLineByIndex(oldParentNode.getElement().getBgIndex());
            String orgXmlFragment = xmlTree.xmlTree.getNodeString(n);
            String newXmlFragment = DesignIOMetaUtil.getXml(oldParentNode);
            if (diff.getOrgXmlFragment() != null && diff.getNewXmlFragment() != null) {
                diff.setXmlDiff2(xmlTree, n, orgXmlFragment, newXmlFragment);
            } else {
                diff.setXmlDiff(xmlTree, n, orgXmlFragment, newXmlFragment);
            }
            return anInt;
        }
        if (diff.getMetaObjectType() == MetaObjectType.operation) {
            operationCollectionNodeList = diff.getXmlTree().xmlTree.getRoot().findNodesByTagName("OperationCollection");
            if (operationCollectionNodeList.size() <= 0) {
                TagNode operation2 = new TagNode("Operation", null);
                operation2.setAttribute("Key", diff.getKey());
                operation2.setAttribute("Caption", diff.caption);
                TagNode operationCollection = new TagNode("OperationCollection", null);
                operationCollection.addNode(operation2);
                XmlTreeWithPath xmlTree = diff.getXmlTree();
                TagNode root = xmlTree.xmlTree.getRoot();
                root.deleteChildByTagName("ToolBar");
                root.addNode(operationCollection);
                XmlDiffProcessor.genXmlDiff(xmlTree, root, diff, true);
                diff.setMetaObjectType(MetaObjectType.ToolBar);
                return 1;
            }
            operat = new TagNode("Operation", null);
            opecolls = operationCollectionNodeList.get(0);
            if (StringUtils.equals((CharSequence)diff.getReserveOne(), (CharSequence)"NewCollection")) {
                operat.setAttribute("Key", diff.getKey());
                operat.setAttribute("Caption", diff.caption);
                action = diff.getReserveTwo();
                if (StringUtils.isNotBlank((CharSequence)action)) {
                    TagNode actionTagNode = new TagNode("Action", null);
                    actionTagNode.setCDataValue(action);
                    operat.addNode(actionTagNode);
                }
            } else {
                operation = opecolls.findNodesByTagName("Operation");
                long count = operation.stream().filter(tagNode -> StringUtils.contains((CharSequence)tagNode.getAttributes().get("Key"), (CharSequence)"HeadOperation")).count();
                anInt = (int)count + 1;
                operat.setAttribute("Key", "HeadOperation" + anInt);
                operat.setAttribute("Caption", "HeadOperation" + anInt);
            }
            parentXmlTreeKey = "Form@" + metaForm.getKey();
            formNode = diff.getXmlTree().xmlTree.getTagNode((String)parentXmlTreeKey);
            if (StringUtils.isNotBlank((CharSequence)diff.sideKey)) {
                if (StringUtils.containsIgnoreCase((CharSequence)diff.sideKey, (CharSequence)"ToolBar")) {
                    List<AbstractNode> children3 = opecolls.getChildren();
                    if (children3.size() > 0) {
                        children3.add(children3.size() - 1, operat);
                    } else {
                        children3.add(operat);
                    }
                    selectNode = opecolls;
                } else if (Objects.isNull(metaForm.getOperationCollection())) {
                    opecoll = new TagNode("OperationCollection", null);
                    endOpeColl = new TagNode("OperationCollection", null);
                    opecoll.addNode(operat);
                    opecoll.addNode(endOpeColl);
                    formNode.addNode(opecoll);
                    selectNode = formNode;
                } else {
                    opecoll = operationCollectionNodeList.get(0);
                    List<AbstractNode> operationCollection1 = opecoll.getChildrenByTagName("OperationCollection");
                    for (AbstractNode abstractNode : operationCollection1) {
                        TagNode tagNode2;
                        Map<String, String> tagNodeAttributes;
                        if (!(abstractNode instanceof TagNode) || !StringUtils.equals((CharSequence)(tagNodeAttributes = (tagNode2 = (TagNode)abstractNode).getAttributes()).get("Key"), (CharSequence)diff.sideKey)) continue;
                        tagNode2.addNode(operat);
                        selectNode = opecoll;
                    }
                    if (Objects.isNull(selectNode)) {
                        selectNode = diff.getXmlTree().xmlTree.getTagNode("Operation@" + diff.sideKey).getParent();
                    }
                }
            }
        }
        if (diff.getMetaObjectType() == MetaObjectType.operationCollection) {
            operationCollectionNodeList = diff.getXmlTree().xmlTree.getRoot().findNodesByTagName("OperationCollection");
            if (operationCollectionNodeList.size() <= 0) {
                TagNode operation3 = new TagNode("OperationCollection", null);
                operation3.setAttribute("Key", diff.getKey());
                operation3.setAttribute("Caption", diff.caption);
                TagNode operationCollection = new TagNode("OperationCollection", null);
                operationCollection.addNode(operation3);
                XmlTreeWithPath xmlTree = diff.getXmlTree();
                TagNode root = xmlTree.xmlTree.getRoot();
                root.deleteChildByTagName("ToolBar");
                root.addNode(operationCollection);
                XmlDiffProcessor.genXmlDiff(xmlTree, root, diff, true);
                diff.setMetaObjectType(MetaObjectType.ToolBar);
                return anInt;
            }
            operat = new TagNode("OperationCollection", null);
            opecolls = operationCollectionNodeList.get(0);
            if (StringUtils.equals((CharSequence)diff.getReserveOne(), (CharSequence)"NewCollection")) {
                operat.setAttribute("Key", diff.getKey());
                operat.setAttribute("Caption", diff.caption);
                action = diff.getReserveTwo();
                if (StringUtils.isNotBlank((CharSequence)action)) {
                    TagNode actionTagNode = new TagNode("Action", null);
                    actionTagNode.setCDataValue(action);
                    operat.addNode(actionTagNode);
                }
            } else {
                operation = opecolls.findNodesByTagName("OperationCollection");
                long count = operation.stream().flatMap(opt -> {
                    List<AbstractNode> children = opt.getChildren();
                    return children.stream().filter(child -> {
                        boolean b = child instanceof TagNode;
                        if (!b) {
                            return false;
                        }
                        Map<String, String> attributes = ((TagNode)child).getAttributes();
                        return StringUtils.contains((CharSequence)attributes.get("Key"), (CharSequence)"HeadOperationCollection");
                    });
                }).count();
                anInt = (int)count + 1;
                operat.setAttribute("Key", "HeadOperationCollection" + anInt);
                operat.setAttribute("Caption", "HeadOperationCollection" + anInt);
            }
            parentXmlTreeKey = "Form@" + metaForm.getKey();
            formNode = diff.getXmlTree().xmlTree.getTagNode((String)parentXmlTreeKey);
            if (StringUtils.isNotBlank((CharSequence)diff.sideKey)) {
                List<AbstractNode> children3 = opecolls.getChildren();
                if (children3.size() > 0) {
                    children3.add(children3.size() - 1, operat);
                } else {
                    children3.add(0, operat);
                }
                selectNode = opecolls;
            } else if (Objects.isNull(metaForm.getOperationCollection())) {
                opecoll = new TagNode("OperationCollection", null);
                endOpeColl = new TagNode("OperationCollection", null);
                opecoll.addNode(operat);
                opecoll.addNode(endOpeColl);
                formNode.addNode(opecoll);
                selectNode = formNode;
            } else {
                opecoll = operationCollectionNodeList.get(0);
                opecoll.addNode(operat);
                selectNode = opecoll;
            }
        }
        if (diff.getMetaObjectType() == MetaObjectType.field) {
            TagNode newDataBindingnode;
            Boolean mergeToSource;
            Object metaFormProfile;
            String extendKey;
            TagNode tagNode2;
            List<TagNode> column;
            TagNode itemNode2;
            TagNode itemNode1;
            TagNode tabItemNode;
            String filePath;
            MetaForm form;
            TagNode node;
            HashMap<String, String> newAttributes;
            TagNode labelNode;
            if (selectComp instanceof MetaGridLayoutPanel) {
                List<AbstractNode> children22 = selectNode.getChildren();
                if (diff.isButtonQuote.booleanValue() && !StringUtils.equals((CharSequence)diff.getReserveOne(), (CharSequence)"extension")) {
                    if (StringUtils.equals((CharSequence)controlType, (CharSequence)"Label")) {
                        labelNode = diff.getVestXmlTree().xmlTree.getTagNode(String.valueOf(controlType) + "@" + diff.getKey());
                        newAttributes = new HashMap();
                        newAttributes.put("Key", diff.getKey());
                        newAttributes.put("X", diff.x.toString());
                        newAttributes.put("Y", diff.y.toString());
                        labelNode.setAttributes(newAttributes);
                        children22.add(children22.size() - 6, labelNode);
                    } else {
                        node = diff.getVestXmlTree().xmlTree.getTagNode(String.valueOf(controlType) + "@" + diff.getKey());
                        if (Objects.isNull(node)) {
                            for (MetaFormProfile metaFormProfile2 : metaFormList) {
                                Boolean mergeToSource2;
                                if (metaFormProfile2 == null || !(mergeToSource2 = metaFormProfile2.getMergeToSource()).booleanValue() || !metaForm.getExtend().equals(metaFormProfile2.getExtend())) continue;
                                form = metaFormProfile2.getForm();
                                filePath = LoadFileTree.getPathByFormKey(form.getKey());
                                XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(filePath);
                                diff.setVestXmlTree(xmlTreeWithPath);
                                node = xmlTreeWithPath.xmlTree.getTagNode(String.valueOf(controlType) + "@" + diff.getKey());
                            }
                        }
                        newAttributes = new HashMap();
                        newAttributes.put("Key", diff.getKey());
                        newAttributes.put("X", diff.x.toString());
                        newAttributes.put("Y", diff.y.toString());
                        node.setAttributes(newAttributes);
                        node.getChildren().clear();
                        children22.add(children22.size() - 6, node);
                    }
                } else {
                    node = new TagNode(controlType, null);
                    if ("Button".equalsIgnoreCase(controlType)) {
                        XmlDiffProcessor.setBasicProperty(node, diff);
                        children22.add(children22.size() - 6, node);
                    } else if ("Separator".equalsIgnoreCase(controlType)) {
                        XmlDiffProcessor.setBasicProperty(node, diff);
                        children22.add(children22.size() - 6, node);
                    } else if ("Chart".equalsIgnoreCase(controlType)) {
                        XmlDiffProcessor.setBasicProperty(node, diff);
                        children22.add(children22.size() - 6, node);
                    } else if ("TabGroup".equalsIgnoreCase(controlType)) {
                        tabItemNode = new TagNode("TabItem", null);
                        tabItemNode.setAttribute("Key", String.valueOf(diff.getKey()) + "_TabItem1");
                        tabItemNode.setAttribute("Text", "\u83dc\u53551");
                        tabItemNode.setAttribute("Icon", "App/Default/TabGroup/Icon1.png");
                        tabItemNode.setAttribute("SelectedIcon", "App/Default/TabGroup/Select1.png");
                        node.addNode(tabItemNode);
                        XmlDiffProcessor.setBasicProperty(node, diff);
                        children22.add(children22.size() - 6, node);
                    } else if ("Carousel".equals(controlType)) {
                        itemNode1 = new TagNode("Item", null);
                        itemNode1.setAttribute("Key", "Item1");
                        itemNode1.setAttribute("Caption", "Item1");
                        itemNode1.setAttribute("Value", "App/Default/Rotator/rotator1.jpg");
                        itemNode2 = new TagNode("Item", null);
                        itemNode2.setAttribute("Key", "Item2");
                        itemNode2.setAttribute("Caption", "Item2");
                        itemNode2.setAttribute("Value", "App/Default/Rotator/rotator2.jpg");
                        node.addNode(itemNode1);
                        node.addNode(itemNode2);
                        XmlDiffProcessor.setBasicProperty(node, diff);
                        children22.add(children22.size() - 6, node);
                    } else {
                        if (Objects.isNull(diff.x)) {
                            diff.x = 0;
                        }
                        if (Objects.isNull(diff.y)) {
                            diff.y = 0;
                        }
                        XmlDiffProcessor.setBasicProperty(node, diff);
                        boolean isMultiDict = false;
                        if ("Dict".equalsIgnoreCase(controlType)) {
                            if (StringUtils.isNotEmpty((CharSequence)diff.getItemKey())) {
                                node.setAttribute("ItemKey", diff.getItemKey());
                                if (diff.getItemKey().endsWith("__Dic")) {
                                    node.setAttribute(Property.StateMask.name, "Enable|Disable|Discard");
                                }
                            } else if (metaForm.getFormType() != 9) {
                                throw new Throwable("ItemKey\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
                            }
                            if (diff.properties.size() > 0 && Property.AllowMultiSelection.name.equals(diff.properties.get((int)0).property.name)) {
                                node.setAttribute(Property.AllowMultiSelection.name, diff.properties.get((int)0).newValue);
                                isMultiDict = true;
                            }
                        } else if ("DynamicDict".equalsIgnoreCase(controlType)) {
                            node.setAttribute("RefKey", diff.getReserveOne());
                        } else if ("ComboBox".equalsIgnoreCase(controlType) || "CheckListBox".equalsIgnoreCase(controlType)) {
                            node.setAttribute("Cache", "false");
                        } else if ("RadioButton".equalsIgnoreCase(controlType)) {
                            node.setAttribute("IsGroupHead", "true");
                        }
                        XmlDiffProcessor.addDomainPropertyToNode(node, controlType, diff.getDataElementKey());
                        List<TagNode> dataObject = diff.getXmlTree().xmlTree.getRoot().findNodesByTagName(MetaObjectType.DataObject.name);
                        column = diff.getXmlTree().xmlTree.getRoot().findNodesByTagName("Column");
                        if (diff.getMetaForm().getDataSource() != null && !"".equals(diff.getMetaForm().getDataSource().getRefObjectKey())) {
                            dataObject = diff.getDataObjectXmlTree().xmlTree.getRoot().findNodesByTagName(MetaObjectType.DataObject.name);
                            TagNode tagNode3 = diff.getDataObjectXmlTree().xmlTree.getTagNode("Table@" + diff.getReserveTwo());
                            if (Objects.nonNull(tagNode3)) {
                                column.addAll(tagNode3.findNodesByTagName("Column"));
                            }
                            if (Objects.nonNull(diff.getOtherDataObjectOrgTree()) && Objects.nonNull(tagNode2 = diff.getOtherDataObjectOrgTree().xmlTree.getTagNode("Table@" + diff.getReserveTwo()))) {
                                column.addAll(tagNode2.findNodesByTagName("Column"));
                            }
                        }
                        boolean exist = false;
                        if (dataObject.size() != 0 && "".equalsIgnoreCase(selectComp.getParentGridKey())) {
                            TagNode tableNode;
                            TagNode newColumn;
                            int controlTypeE = diff.getControlType();
                            String string = metaForm.getDataSource().getDataObject().getKey();
                            extendKey = metaForm.getExtend();
                            metaFormProfile = (MetaFormProfile)metaFormList.get(metaForm.getKey());
                            if (metaFormProfile == null) {
                                metaFormProfile = (MetaFormProfile)metaFactory.getExtFormList().get(metaForm.getKey());
                            }
                            mergeToSource = metaFormProfile.getMergeToSource();
                            if (!StringUtils.equals((CharSequence)string, (CharSequence)extendKey)) {
                                if ("true".equalsIgnoreCase(diff.getReserveFour())) {
                                    for (TagNode tagNode4 : column) {
                                        if (!diff.getReserveThree().equalsIgnoreCase(tagNode4.getAttributes().get("Key"))) continue;
                                        exist = true;
                                    }
                                    if (!exist) {
                                        String key = diff.getReserveThree();
                                        if (!"\u65e0\u5b57\u6bb5".equals(key) && StringUtils.isNotEmpty((CharSequence)key)) {
                                            key = String.valueOf(diff.getReserveThree().substring(0, 1).toUpperCase()) + diff.getReserveThree().substring(1);
                                            TagNode newDataBindingnode2 = new TagNode("DataBinding", null);
                                            newDataBindingnode2.setAttribute("TableKey", diff.getReserveTwo());
                                            newColumn = new TagNode("Column", null);
                                            newColumn.setAttribute("Key", key);
                                            newColumn.setAttribute("Caption", diff.caption);
                                            if (StringUtils.isEmpty((CharSequence)diff.getDataElementKey())) {
                                                newColumn.setAttribute("DataType", XmlDiffProcessor.getDatatypeContainerMultiDict(controlTypeE, isMultiDict));
                                            } else {
                                                newColumn.setAttribute("DataElementKey", diff.getDataElementKey());
                                            }
                                            if ("Dict".equalsIgnoreCase(controlType) || "DynamicDict".equalsIgnoreCase(controlType)) {
                                                XmlDiffProcessor.codeAndNameWithDictComponent(diff, key, diff.getReserveTwo(), newColumn);
                                            }
                                            if ("Varchar".equalsIgnoreCase(XmlDiffProcessor.getDatatypeContainerMultiDict(controlTypeE, isMultiDict))) {
                                                newColumn.setAttribute("Length", "255");
                                            }
                                            if (StringUtils.isNotEmpty((CharSequence)diff.getMetaForm().getDataSource().getRefObjectKey())) {
                                                tableNode = diff.getDataObjectXmlTree().xmlTree.getTagNode("Table@" + diff.getReserveTwo());
                                                tableNode.addNode(newColumn);
                                                XmlDiffProcessor.genXmlDiff(diff.getDataObjectXmlTree(), tableNode, diff, false);
                                            } else {
                                                tableNode = diff.getXmlTree().xmlTree.getTagNode("Table@" + diff.getReserveTwo());
                                                tableNode.addNode(newColumn);
                                                XmlDiffProcessor.genXmlDiff(diff.getXmlTree(), tableNode, diff, false);
                                            }
                                            newDataBindingnode2.setAttribute("ColumnKey", key);
                                            node.addNode(newDataBindingnode2);
                                        }
                                    } else {
                                        TagNode newDataBindingnode3 = new TagNode("DataBinding", null);
                                        newDataBindingnode3.setAttribute("TableKey", diff.getReserveTwo());
                                        newDataBindingnode3.setAttribute("ColumnKey", diff.getReserveThree());
                                        node.addNode(newDataBindingnode3);
                                    }
                                }
                            } else if (mergeToSource.booleanValue() && "true".equalsIgnoreCase(diff.getReserveFour())) {
                                for (TagNode tagNode3 : column) {
                                    if (!StringUtils.equalsIgnoreCase((CharSequence)tagNode3.getAttributes().get("Key"), (CharSequence)diff.getReserveThree())) continue;
                                    exist = true;
                                }
                                TagNode newDataBindingNode = new TagNode("DataBinding", null);
                                newDataBindingNode.setAttribute("TableKey", diff.getReserveTwo());
                                String key = diff.getReserveThree();
                                if (StringUtils.isNotEmpty((CharSequence)diff.getReserveThree())) {
                                    key = String.valueOf(diff.getReserveThree().substring(0, 1).toUpperCase()) + diff.getReserveThree().substring(1);
                                }
                                if (!exist) {
                                    newColumn = new TagNode("Column", null);
                                    newColumn.setAttribute("Key", key);
                                    newColumn.setAttribute("Caption", diff.caption);
                                    if (StringUtils.isEmpty((CharSequence)diff.getDataElementKey())) {
                                        newColumn.setAttribute("DataType", XmlDiffProcessor.getDatatypeContainerMultiDict(controlTypeE, isMultiDict));
                                    } else {
                                        newColumn.setAttribute("DataElementKey", diff.getDataElementKey());
                                    }
                                    if ("Dict".equalsIgnoreCase(controlType) || "DynamicDict".equalsIgnoreCase(controlType)) {
                                        XmlDiffProcessor.codeAndNameWithDictComponent(diff, key, diff.getReserveTwo(), newColumn);
                                    }
                                    if ("Varchar".equalsIgnoreCase(XmlDiffProcessor.getDatatypeContainerMultiDict(controlTypeE, isMultiDict))) {
                                        newColumn.setAttribute("Length", "255");
                                    }
                                    tableNode = diff.getTagNode("Table@" + diff.getReserveTwo());
                                    tableNode.addNode(newColumn);
                                    XmlDiffProcessor.genXmlDiff(diff.getXmlTree(), tableNode, diff, false);
                                }
                                if (!"\u65e0\u5b57\u6bb5".equals(key) && StringUtils.isNotEmpty((CharSequence)key)) {
                                    newDataBindingNode.setAttribute("ColumnKey", key);
                                    node.addNode(newDataBindingNode);
                                }
                            }
                        } else {
                            newDataBindingnode = new TagNode("DataBinding", null);
                            node.addNode(newDataBindingnode);
                        }
                        if ("NumberEditor".equalsIgnoreCase(controlType)) {
                            TagNode formatNode = new TagNode("Format", null);
                            formatNode.setAttribute("HAlign", "Right");
                            node.addNode(formatNode);
                            MetaTable metaTable = metaForm.getMetaTable(diff.getReserveTwo());
                            if (metaTable != null) {
                                for (MetaColumn metaColumn : metaTable) {
                                    if (!metaColumn.getKey().equals(diff.getReserveThree()) || metaColumn.getDataType() != 1001) continue;
                                    node.setAttribute("Precision", "9");
                                    break;
                                }
                            }
                        }
                        if (controlType.equals("Label")) {
                            children22.add(children22.size() - 3, node);
                        } else {
                            if (selectNode.getParent().getTagName().equals("TableRow")) {
                                node.setAttribute("Class", "innerLabel-show");
                            }
                            children22.add(children22.size() - 6, node);
                        }
                    }
                }
            } else if (selectComp instanceof MetaFlexGridLayoutPanel) {
                if (diff.isButtonQuote.booleanValue()) {
                    children2 = selectNode.getChildren();
                    if (StringUtils.equals((CharSequence)controlType, (CharSequence)"Label")) {
                        labelNode = diff.getVestXmlTree().xmlTree.getTagNode(String.valueOf(controlType) + "@" + diff.getKey());
                        newAttributes = new HashMap<String, String>();
                        newAttributes.put("Key", diff.getKey());
                        newAttributes.put("X", diff.x.toString());
                        newAttributes.put("Y", diff.y.toString());
                        labelNode.setAttributes(newAttributes);
                        children2.add(children2.size() - 6, labelNode);
                    } else {
                        node = diff.getVestXmlTree().xmlTree.getTagNode(String.valueOf(controlType) + "@" + diff.getKey());
                        if (Objects.isNull(node)) {
                            for (MetaFormProfile metaFormProfile2 : metaFormList) {
                                Boolean mergeToSource2;
                                if (metaFormProfile2 == null || !(mergeToSource2 = metaFormProfile2.getMergeToSource()).booleanValue() || !metaForm.getExtend().equals(metaFormProfile2.getExtend())) continue;
                                form = metaFormProfile2.getForm();
                                filePath = LoadFileTree.getPathByFormKey(form.getKey());
                                XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(filePath);
                                diff.setVestXmlTree(xmlTreeWithPath);
                                node = xmlTreeWithPath.xmlTree.getTagNode(String.valueOf(controlType) + "@" + diff.getKey());
                            }
                        }
                        newAttributes = new HashMap();
                        newAttributes.put("Key", diff.getKey());
                        newAttributes.put("X", diff.x.toString());
                        newAttributes.put("Y", diff.y.toString());
                        node.setAttributes(newAttributes);
                        node.getChildren().clear();
                        children2.add(children2.size() - 6, node);
                    }
                } else {
                    TagNode node2 = new TagNode(controlType, null);
                    if (Objects.isNull(diff.x)) {
                        diff.x = 0;
                    }
                    if (Objects.isNull(diff.y)) {
                        diff.y = 0;
                    }
                    XmlDiffProcessor.setBasicProperty(node2, diff);
                    children = selectNode.getChildren();
                    if (StringUtils.isNotBlank((CharSequence)diff.sideKey)) {
                        AbstractNode sideNode = children.stream().filter(item -> {
                            boolean b = item instanceof TagNode;
                            if (!b) {
                                return false;
                            }
                            TagNode tagNode = (TagNode)item;
                            String tagNodeKey = tagNode.getAttributes().get("Key");
                            return StringUtils.equalsIgnoreCase((CharSequence)tagNodeKey, (CharSequence)diff.sideKey);
                        }).findFirst().orElse(null);
                        if (Objects.isNull(sideNode)) {
                            children.add(node2);
                        } else {
                            int i = children.indexOf(sideNode);
                            if (diff.insertAfter) {
                                children.add(i + 1, node2);
                            } else {
                                children.add(i, node2);
                            }
                        }
                    } else if (CollectionUtils.isNotEmpty(children)) {
                        children.add(children.size() - 1, node2);
                    } else {
                        children.add(node2);
                    }
                    if (!StringUtils.equalsAnyIgnoreCase((CharSequence)controlType, (CharSequence[])new CharSequence[]{"Button", "Separator"})) {
                        boolean isMultiDict = false;
                        if ("Dict".equalsIgnoreCase(controlType)) {
                            if (!StringUtils.isNotEmpty((CharSequence)diff.getItemKey())) {
                                throw new Throwable("ItemKey\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
                            }
                            node2.setAttribute("ItemKey", diff.getItemKey());
                            if (diff.properties.size() > 0 && Property.AllowMultiSelection.name.equals(diff.properties.get((int)0).property.name)) {
                                node2.setAttribute(Property.AllowMultiSelection.name, diff.properties.get((int)0).newValue);
                                isMultiDict = true;
                            }
                        } else if ("DynamicDict".equalsIgnoreCase(controlType)) {
                            node2.setAttribute("RefKey", diff.getReserveOne());
                        } else if ("ComboBox".equalsIgnoreCase(controlType) || "CheckListBox".equalsIgnoreCase(controlType)) {
                            node2.setAttribute("Cache", "false");
                        } else if ("RadioButton".equalsIgnoreCase(controlType)) {
                            node2.setAttribute("IsGroupHead", "true");
                        }
                        List<TagNode> dataObject = diff.getXmlTree().xmlTree.getRoot().findNodesByTagName(MetaObjectType.DataObject.name);
                        column = diff.getXmlTree().xmlTree.getRoot().findNodesByTagName("Column");
                        if (diff.getMetaForm().getDataSource() != null && !"".equals(diff.getMetaForm().getDataSource().getRefObjectKey())) {
                            dataObject = diff.getDataObjectXmlTree().xmlTree.getRoot().findNodesByTagName(MetaObjectType.DataObject.name);
                            TagNode tagNode4 = diff.getDataObjectXmlTree().xmlTree.getTagNode("Table@" + diff.getReserveTwo());
                            if (Objects.nonNull(tagNode4)) {
                                column.addAll(tagNode4.findNodesByTagName("Column"));
                            }
                            if (Objects.nonNull(diff.getOtherDataObjectOrgTree()) && Objects.nonNull(tagNode2 = diff.getOtherDataObjectOrgTree().xmlTree.getTagNode("Table@" + diff.getReserveTwo()))) {
                                column.addAll(tagNode2.findNodesByTagName("Column"));
                            }
                        }
                        boolean exist = false;
                        if (dataObject.size() < 1 || StringUtils.isNotBlank((CharSequence)selectComp.getParentGridKey())) {
                            newDataBindingnode = new TagNode("DataBinding", null);
                            node2.addNode(newDataBindingnode);
                        } else {
                            TagNode tableNode;
                            TagNode newColumn;
                            int controlTypeE = diff.getControlType();
                            String string = metaForm.getDataSource().getDataObject().getKey();
                            extendKey = metaForm.getExtend();
                            metaFormProfile = (MetaFormProfile)metaFormList.get(metaForm.getKey());
                            if (metaFormProfile == null) {
                                metaFormProfile = (MetaFormProfile)metaFactory.getExtFormList().get(metaForm.getKey());
                            }
                            mergeToSource = metaFormProfile.getMergeToSource();
                            if (!StringUtils.equals((CharSequence)string, (CharSequence)extendKey)) {
                                if ("true".equalsIgnoreCase(diff.getReserveFour())) {
                                    for (TagNode tagNode5 : column) {
                                        if (!diff.getReserveThree().equalsIgnoreCase(tagNode5.getAttributes().get("Key"))) continue;
                                        exist = true;
                                    }
                                    if (!exist) {
                                        String key = diff.getReserveThree();
                                        if (!"\u65e0\u5b57\u6bb5".equals(key) && StringUtils.isNotEmpty((CharSequence)key)) {
                                            key = String.valueOf(diff.getReserveThree().substring(0, 1).toUpperCase()) + diff.getReserveThree().substring(1);
                                            TagNode newDataBindingnode4 = new TagNode("DataBinding", null);
                                            newDataBindingnode4.setAttribute("TableKey", diff.getReserveTwo());
                                            newColumn = new TagNode("Column", null);
                                            newColumn.setAttribute("Key", key);
                                            newColumn.setAttribute("Caption", diff.caption);
                                            newColumn.setAttribute("DataType", XmlDiffProcessor.getDatatypeContainerMultiDict(controlTypeE, isMultiDict));
                                            if ("Dict".equalsIgnoreCase(controlType) || "DynamicDict".equalsIgnoreCase(controlType)) {
                                                XmlDiffProcessor.codeAndNameWithDictComponent(diff, key, diff.getReserveTwo(), newColumn);
                                            }
                                            if ("Varchar".equalsIgnoreCase(XmlDiffProcessor.getDatatypeContainerMultiDict(controlTypeE, isMultiDict))) {
                                                newColumn.setAttribute("Length", "255");
                                            }
                                            if (StringUtils.isNotEmpty((CharSequence)diff.getMetaForm().getDataSource().getRefObjectKey())) {
                                                tableNode = diff.getDataObjectXmlTree().xmlTree.getTagNode("Table@" + diff.getReserveTwo());
                                                tableNode.addNode(newColumn);
                                                XmlDiffProcessor.genXmlDiff(diff.getDataObjectXmlTree(), tableNode, diff, false);
                                            } else {
                                                tableNode = diff.getXmlTree().xmlTree.getTagNode("Table@" + diff.getReserveTwo());
                                                tableNode.addNode(newColumn);
                                                XmlDiffProcessor.genXmlDiff(diff.getXmlTree(), tableNode, diff, false);
                                            }
                                            newDataBindingnode4.setAttribute("ColumnKey", key);
                                            node2.addNode(newDataBindingnode4);
                                        }
                                    } else {
                                        TagNode newDataBindingnode5 = new TagNode("DataBinding", null);
                                        newDataBindingnode5.setAttribute("TableKey", diff.getReserveTwo());
                                        newDataBindingnode5.setAttribute("ColumnKey", diff.getReserveThree());
                                        node2.addNode(newDataBindingnode5);
                                    }
                                }
                            } else if (mergeToSource.booleanValue() && "true".equalsIgnoreCase(diff.getReserveFour())) {
                                for (TagNode tagNode5 : column) {
                                    if (!StringUtils.equalsIgnoreCase((CharSequence)tagNode5.getAttributes().get("Key"), (CharSequence)diff.getReserveThree())) continue;
                                    exist = true;
                                }
                                TagNode newDataBindingNode = new TagNode("DataBinding", null);
                                newDataBindingNode.setAttribute("TableKey", diff.getReserveTwo());
                                Object key = diff.getReserveThree();
                                if (StringUtils.isNotEmpty((CharSequence)diff.getReserveThree())) {
                                    key = String.valueOf(diff.getReserveThree().substring(0, 1).toUpperCase()) + diff.getReserveThree().substring(1);
                                }
                                if (!exist) {
                                    newColumn = new TagNode("Column", null);
                                    newColumn.setAttribute("Key", (String)key);
                                    newColumn.setAttribute("Caption", diff.caption);
                                    newColumn.setAttribute("DataType", XmlDiffProcessor.getDatatypeContainerMultiDict(controlTypeE, isMultiDict));
                                    if ("Dict".equalsIgnoreCase(controlType) || "DynamicDict".equalsIgnoreCase(controlType)) {
                                        XmlDiffProcessor.codeAndNameWithDictComponent(diff, (String)key, diff.getReserveTwo(), newColumn);
                                    }
                                    if ("Varchar".equalsIgnoreCase(XmlDiffProcessor.getDatatypeContainerMultiDict(controlTypeE, isMultiDict))) {
                                        newColumn.setAttribute("Length", "255");
                                    }
                                    tableNode = diff.getXmlTree().xmlTree.getTagNode("Table@" + diff.getReserveTwo());
                                    tableNode.addNode(newColumn);
                                    XmlDiffProcessor.genXmlDiff(diff.getXmlTree(), tableNode, diff, false);
                                }
                                if (!"\u65e0\u5b57\u6bb5".equals(key) && StringUtils.isNotEmpty((CharSequence)key)) {
                                    newDataBindingNode.setAttribute("ColumnKey", (String)key);
                                    node2.addNode(newDataBindingNode);
                                }
                            }
                        }
                        if ("NumberEditor".equalsIgnoreCase(controlType)) {
                            TagNode formatNode = new TagNode("Format", null);
                            formatNode.setAttribute("HAlign", "Right");
                            node2.addNode(formatNode);
                            MetaTable metaTable = metaForm.getMetaTable(diff.getReserveTwo());
                            if (metaTable != null) {
                                for (MetaColumn metaColumn : metaTable) {
                                    if (!metaColumn.getKey().equals(diff.getReserveThree()) || metaColumn.getDataType() != 1001) continue;
                                    node2.setAttribute("Precision", "9");
                                    break;
                                }
                            }
                        }
                    }
                }
            } else if (selectComp instanceof MetaTabPanel || selectComp instanceof MetaFlexFlowLayoutPanel || selectComp instanceof MetaLinearLayoutPanel) {
                children2 = selectNode.getChildren();
                node = new TagNode(controlType, null);
                node.setAttribute("Key", diff.getKey());
                node.setAttribute("Caption", diff.caption);
                if (selectNode.getParent().getTagName().equals("TableRow")) {
                    node.setAttribute("Class", "innerLabel-show");
                }
                if (controlType.equals("Label")) {
                    if (children2.size() >= 2) {
                        children2.add(children2.size() - 2, node);
                    } else {
                        children2.add(node);
                    }
                } else if (StringUtils.equalsIgnoreCase((CharSequence)controlType, (CharSequence)"RadioButton")) {
                    node.setAttribute("IsGroupHead", "true");
                    if (children2.size() >= 6) {
                        children2.add(children2.size() - 6, node);
                    } else {
                        children2.add(node);
                    }
                } else if (StringUtils.equalsIgnoreCase((CharSequence)controlType, (CharSequence)"TabGroup")) {
                    tabItemNode = new TagNode("TabItem", null);
                    tabItemNode.setAttribute("Key", String.valueOf(diff.getKey()) + "_TabItem1");
                    tabItemNode.setAttribute("Text", "\u83dc\u53551");
                    tabItemNode.setAttribute("Icon", "App/Default/TabGroup/Icon1.png");
                    tabItemNode.setAttribute("SelectedIcon", "App/Default/TabGroup/Select1.png");
                    node.addNode(tabItemNode);
                    if (children2.size() >= 2) {
                        children2.add(children2.size() - 2, node);
                    } else {
                        children2.add(node);
                    }
                } else if (StringUtils.equalsIgnoreCase((CharSequence)controlType, (CharSequence)"Carousel")) {
                    itemNode1 = new TagNode("Item", null);
                    itemNode1.setAttribute("Key", "Item1");
                    itemNode1.setAttribute("Caption", "Item1");
                    itemNode1.setAttribute("Value", "App/Default/Rotator/rotator1.jpg");
                    itemNode2 = new TagNode("Item", null);
                    itemNode2.setAttribute("Key", "Item2");
                    itemNode2.setAttribute("Caption", "Item2");
                    itemNode2.setAttribute("Value", "App/Default/Rotator/rotator2.jpg");
                    node.addNode(itemNode1);
                    node.addNode(itemNode2);
                    if (children2.size() >= 2) {
                        children2.add(children2.size() - 2, node);
                    } else {
                        children2.add(node);
                    }
                } else if (StringUtils.equalsIgnoreCase((CharSequence)controlType, (CharSequence)"RefreshControl")) {
                    TagNode rootCompNode = new TagNode("FlexFlowLayoutPanel", null);
                    rootCompNode.setAttribute("Key", String.valueOf(diff.getKey()) + "MainComp");
                    rootCompNode.setAttribute("Caption", String.valueOf(diff.getKey()) + "MainComp");
                    rootCompNode.setAttribute("OverflowY", "Scroll");
                    node.addNode(rootCompNode);
                    children2.add(node);
                } else {
                    if (StringUtils.equalsIgnoreCase((CharSequence)controlType, (CharSequence)"EditView")) {
                        node.setAttribute("RowHeight", "130");
                        node.setAttribute("Width", "100%");
                        TagNode rowNode = new TagNode("EditViewRow", null);
                        rowNode.setAttribute("TopMargin", "10px");
                        TagNode bodyNode = diff.getXmlTree().xmlTree.getRoot().getChildByTagName("Body");
                        TagNode viewCollectionNode = bodyNode.getOrCreateChildByTagName("ViewCollection");
                        TagNode viewNode = viewCollectionNode.getChildByKey("Android");
                        if (viewNode == null) {
                            viewNode = new TagNode("View", null);
                            viewNode.setAttribute("Caption", "Caption");
                            viewNode.setAttribute("Key", "Android");
                            viewNode.setAttribute("Media", "WEB|PC|IOS|ANDROID|");
                            viewCollectionNode.addNode(viewNode);
                        }
                        viewNode.addNode(XmlDiffProcessor.getDefaultComponentView(diff.getKey()));
                        if (children2.size() >= 2) {
                            children2.add(children2.size() - 2, node);
                        } else {
                            children2.add(node);
                        }
                        XmlDiffProcessor.genXmlDiff(diff.getXmlTree(), bodyNode, diff, true);
                        return anInt;
                    }
                    if (StringUtils.equalsAnyIgnoreCase((CharSequence)controlType, (CharSequence[])new CharSequence[]{"Button", "Separator", "Chart", "Container", "Switch", "HoverButton"})) {
                        if (children2.size() >= 2) {
                            children2.add(children2.size() - 2, node);
                        } else {
                            children2.add(node);
                        }
                    } else {
                        if (!Objects.equals(diff.getIsButtonQuote(), Boolean.TRUE)) {
                            if ("Dict".equalsIgnoreCase(controlType)) {
                                if (!diff.getIsButtonQuote().booleanValue()) {
                                    node.setAttribute("ItemKey", diff.getItemKey());
                                }
                            } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)controlType, (CharSequence[])new CharSequence[]{"ComboBox", "CheckListBox"})) {
                                node.setAttribute("Cache", "false");
                            } else if ("DynamicDict".equalsIgnoreCase(controlType)) {
                                node.setAttribute("DynamicItemKey", "root");
                            }
                        }
                        List<TagNode> dataObject = diff.getXmlTree().xmlTree.getRoot().findNodesByTagName(MetaObjectType.DataObject.name);
                        List<TagNode> column2 = diff.getXmlTree().xmlTree.getRoot().findNodesByTagName("Column");
                        MetaFormProfile metaFormProfile3 = (MetaFormProfile)metaFormList.get(metaForm.getKey());
                        if (metaFormProfile3 == null) {
                            metaFormProfile3 = (MetaFormProfile)metaFactory.getExtFormList().get(metaForm.getKey());
                        }
                        Boolean mergeToSource1 = metaFormProfile3.getMergeToSource();
                        if (diff.getMetaForm().getDataSource() != null && !"".equals(diff.getMetaForm().getDataSource().getRefObjectKey()) && !mergeToSource1.booleanValue()) {
                            dataObject = diff.getDataObjectXmlTree().xmlTree.getRoot().findNodesByTagName(MetaObjectType.DataObject.name);
                            column2 = diff.getDataObjectXmlTree().xmlTree.getRoot().findNodesByTagName("Column");
                        }
                        boolean exist = false;
                        String string = "";
                        for (TagNode tagNode6 : column2) {
                            if (!diff.getKey().equalsIgnoreCase(tagNode6.getAttributes().get("Key"))) continue;
                            String string2 = tagNode6.getAttributes().get("Key");
                            exist = true;
                        }
                        if (dataObject.size() != 0 && "".equalsIgnoreCase(selectComp.getParentGridKey())) {
                            String mainTableKey = metaForm.getDataSource().getDataObject().getMainTableKey();
                            if (mainTableKey != null && mainTableKey.length() > 0 && !mainTableKey.equalsIgnoreCase(null)) {
                                int controlTypeE = diff.getControlType();
                                String objectKey2 = metaForm.getDataSource().getDataObject().getKey();
                                String extendKey2 = metaForm.getExtend();
                                Boolean mergeToSource3 = metaFormProfile3.getMergeToSource();
                                if (objectKey2.equals(extendKey2) && !mergeToSource3.booleanValue()) {
                                    TagNode newDataBindingnode6 = new TagNode("DataBinding", null);
                                    if (!Objects.equals(diff.getIsButtonQuote(), Boolean.TRUE)) {
                                        node.addNode(newDataBindingnode6);
                                    }
                                } else if (objectKey2.equals(extendKey2) && mergeToSource3.booleanValue()) {
                                    if (!Objects.equals(diff.getIsButtonQuote(), Boolean.TRUE)) {
                                        String key = String.valueOf(diff.getKey().substring(0, 1).toUpperCase()) + diff.getKey().substring(1);
                                        TagNode newDataBindingnode7 = new TagNode("DataBinding", null);
                                        newDataBindingnode7.setAttribute("TableKey", mainTableKey);
                                        TagNode newColumn = new TagNode("Column", null);
                                        newColumn.setAttribute("Key", key);
                                        newColumn.setAttribute("Caption", diff.caption);
                                        newColumn.setAttribute("DataType", XmlDiffProcessor.getDatatype(controlTypeE));
                                        if ("Varchar".equalsIgnoreCase(XmlDiffProcessor.getDatatype(controlTypeE))) {
                                            newColumn.setAttribute("Length", "255");
                                        }
                                        TagNode tableNode = diff.getXmlTree().xmlTree.getTagNode("Table@" + mainTableKey);
                                        tableNode.addNode(newColumn);
                                        XmlDiffProcessor.genXmlDiff(diff.getXmlTree(), tableNode, diff, false);
                                        newDataBindingnode7.setAttribute("ColumnKey", key);
                                        node.addNode(newDataBindingnode7);
                                    }
                                } else if (!exist) {
                                    String key = String.valueOf(diff.getKey().substring(0, 1).toUpperCase()) + diff.getKey().substring(1);
                                    TagNode newDataBindingnode8 = new TagNode("DataBinding", null);
                                    newDataBindingnode8.setAttribute("TableKey", mainTableKey);
                                    TagNode newColumn = new TagNode("Column", null);
                                    newColumn.setAttribute("Key", key);
                                    newColumn.setAttribute("Caption", diff.caption);
                                    newColumn.setAttribute("DataType", XmlDiffProcessor.getDatatype(controlTypeE));
                                    if ("Varchar".equalsIgnoreCase(XmlDiffProcessor.getDatatype(controlTypeE))) {
                                        newColumn.setAttribute("Length", "255");
                                    }
                                    if (!"".equals(diff.getMetaForm().getDataSource().getRefObjectKey()) && diff.getMetaForm().getDataSource().getRefObjectKey() != null) {
                                        TagNode tableNode = diff.getDataObjectXmlTree().xmlTree.getTagNode("Table@" + mainTableKey);
                                        tableNode.addNode(newColumn);
                                        XmlDiffProcessor.genXmlDiff(diff.getDataObjectXmlTree(), tableNode, diff, false);
                                    } else {
                                        TagNode tableNode = diff.getXmlTree().xmlTree.getTagNode("Table@" + mainTableKey);
                                        tableNode.addNode(newColumn);
                                        XmlDiffProcessor.genXmlDiff(diff.getXmlTree(), tableNode, diff, false);
                                    }
                                    newDataBindingnode8.setAttribute("ColumnKey", key);
                                    node.addNode(newDataBindingnode8);
                                } else {
                                    void var17_65;
                                    TagNode newDataBindingnode9 = new TagNode("DataBinding", null);
                                    newDataBindingnode9.setAttribute("TableKey", mainTableKey);
                                    newDataBindingnode9.setAttribute("ColumnKey", (String)var17_65);
                                    node.addNode(newDataBindingnode9);
                                }
                            }
                        } else {
                            TagNode newDataBindingnode10 = new TagNode("DataBinding", null);
                            node.addNode(newDataBindingnode10);
                        }
                        if (children2.size() < 2) {
                            children2.add(node);
                        } else {
                            children2.add(children2.size() - 2, node);
                        }
                    }
                }
            } else if (selectComp instanceof MetaSplitPanel) {
                tagbPanelNode = new TagNode(controlType, null);
                tagbPanelNode.setAttribute("Key", diff.getKey());
                tagbPanelNode.setAttribute("Caption", diff.caption);
                XmlDiffProcessor.addSplitSize(selectNode);
                XmlDiffProcessor.addNodeToSplitPanel(selectNode, tagbPanelNode);
            }
        } else if (diff.getMetaObjectType() == MetaObjectType.gridField) {
            children2 = selectNode.getChildren();
            boolean exist = false;
            String kkey = "";
            int rowIndex = 0;
            int rowDataIndex = -1;
            String sideKey = diff.sideKey;
            for (AbstractNode abstractNode : children2) {
                Object NewdtbNode;
                String extendKey;
                String key;
                Boolean mergeToSource;
                MetaFormProfile metaFormProfile;
                String tableKey;
                Object name;
                if (!(abstractNode instanceof TagNode)) continue;
                String tagName = ((TagNode)abstractNode).getTagName();
                if ("GridColumnCollection".equals(tagName)) {
                    Integer index;
                    List<AbstractNode> columns;
                    if (!diff.isButtonQuote.booleanValue()) {
                        TagNode childByTagName;
                        Optional<MetaEmbedTable> optional;
                        Iterator collect;
                        columns = ((TagNode)abstractNode).getChildren();
                        TagNode node = new TagNode("GridColumn", null);
                        node.setAttribute("Key", diff.getKey());
                        node.setAttribute("Caption", diff.caption);
                        node.setAttribute("Width", "80px");
                        node.setParent((TagNode)abstractNode);
                        String tableKey2 = selectComp.getTableKey();
                        TagNode tableNode = diff.getXmlTree().xmlTree.getTagNode("Table@" + tableKey2);
                        boolean isRefObjectKey = false;
                        if (metaForm.getDataSource() != null && StringUtils.isNotEmpty((CharSequence)metaForm.getDataSource().getRefObjectKey())) {
                            tableNode = diff.getDataObjectXmlTree().xmlTree.getTagNode("Table@" + tableKey2);
                            isRefObjectKey = true;
                        }
                        if (Objects.isNull(tableNode) && metaForm.getDataSource() != null && metaForm.getDataSource().getDataObject().getEmbedTables() != null && (collect = (MetaEmbedTable)(optional = metaForm.getDataSource().getDataObject().getEmbedTables().getList().stream().filter(metaEmbedTable -> metaEmbedTable.getTableKeys().equals(tableKey2)).findFirst()).orElse(null)) != null) {
                            String dataObjectfilePath = LoadFileTree.loadFilePathByDataObjectFieldKey(collect.getObjectKey());
                            XmlTreeWithPath dataObjectorgTree = XmlTreeWithPath.parseFilePath(dataObjectfilePath);
                            isRefObjectKey = true;
                            diff.setDataObjectfilePath(dataObjectfilePath);
                            diff.setDataObjectXmlTree(dataObjectorgTree);
                            tableNode = diff.getDataObjectXmlTree().xmlTree.getTagNode("Table@" + tableKey2);
                        }
                        if (tableKey2 != null && !"".equals(tableKey2)) {
                            collect = metaForm.getDataSource().getDataObject().getTable(tableKey2).iterator();
                            while (collect.hasNext()) {
                                MetaColumn metaColumn = (MetaColumn)collect.next();
                                if (!metaColumn.getKey().equalsIgnoreCase(diff.getKey()) || tableKey2.contains("_NODB")) continue;
                                kkey = metaColumn.getKey();
                                exist = true;
                            }
                        }
                        if (tableKey2 != null && tableKey2.length() != 0 && !tableKey2.contains("_NODB") && tableNode != null && !"Button".equals(controlType) && "true".equalsIgnoreCase(diff.getReserveTwo()) && !exist) {
                            TagNode newColumnNode = new TagNode("Column", null);
                            newColumnNode.setAttribute("Key", diff.getReserveOne());
                            newColumnNode.setAttribute("Caption", diff.caption);
                            String datatype = XmlDiffProcessor.getDatatype(diff.getControlType());
                            if (diff.properties.size() > 0 && Property.AllowMultiSelection.name.equals(diff.properties.get((int)0).property.name)) {
                                datatype = XmlDiffProcessor.getDatatypeContainerMultiDict(diff.getControlType(), true);
                            }
                            if (StringUtils.isEmpty((CharSequence)diff.getDataElementKey())) {
                                newColumnNode.setAttribute("DataType", datatype);
                            } else {
                                newColumnNode.setAttribute("DataElementKey", diff.getDataElementKey());
                            }
                            if ("Varchar".equalsIgnoreCase(datatype)) {
                                newColumnNode.setAttribute("Length", "255");
                            }
                            if ("Dict".equalsIgnoreCase(controlType) || "DynamicDict".equalsIgnoreCase(controlType)) {
                                XmlDiffProcessor.codeAndNameWithDictComponent(diff, diff.getReserveOne(), tableKey2, newColumnNode);
                            }
                            tableNode.addNode(newColumnNode);
                            if (isRefObjectKey) {
                                XmlDiffProcessor.genXmlDiff(diff.getDataObjectXmlTree(), tableNode, diff, false);
                            } else {
                                XmlDiffProcessor.genXmlDiff(diff.getXmlTree(), tableNode, diff, false);
                            }
                        }
                        if ("".equals(sideKey)) {
                            columns.add(columns.size() - 1, node);
                            continue;
                        }
                        index = Objects.isNull(XmlDiffProcessor.compIndex(columns, sideKey)) ? columns.size() / 2 : XmlDiffProcessor.compIndex(columns, sideKey);
                        TagNode columnCollection = selectNode.findFirstTagNodeByTagName("GridColumnCollection");
                        Object treeTagNode = diff.getXmlTree().xmlTree.getTagNode("GridColumn@" + sideKey);
                        if (Objects.isNull(treeTagNode)) {
                            sideKey = StringUtils.substringBeforeLast((String)sideKey, (String)"_");
                            treeTagNode = diff.getXmlTree().xmlTree.getTagNode("GridColumn@" + sideKey);
                        }
                        rowIndex = XmlDiffProcessor.statisticsRowIndex(columnCollection, sideKey, (TagNode)treeTagNode);
                        if (!diff.insertAfter && (childByTagName = ((TagNode)treeTagNode).getChildByTagName("GridColumnCollection")) != null) {
                            rowIndex -= XmlDiffProcessor.statisticsLength(childByTagName) - 1;
                        }
                        if (selectNode.getOrCreateChildByTagName("GridColumnCollection").getChildren().size() != selectNode.getOrCreateChildByTagName("GridRowCollection").getOrCreateChildByTagName("GridRow").getChildren().size() || "GridColumn".equalsIgnoreCase(diff.getXmlTree().xmlTree.getTagNode("GridColumn@" + sideKey).getParent().getParent().getTagName())) {
                            TagNode trueNode = diff.getXmlTree().xmlTree.getTagNode("GridColumn@" + sideKey).getOrCreateChildByTagName("GridColumnCollection");
                            if (trueNode.getChildren().size() == 0) {
                                trueNode.getParent().deleteChildByTagName("GridColumnCollection");
                                columns = trueNode.getParent().getParent().getChildren();
                                index = Objects.isNull(XmlDiffProcessor.compIndex(columns, sideKey)) ? columns.size() / 2 : XmlDiffProcessor.compIndex(columns, sideKey);
                                if (Objects.isNull(diff.getXmlTree().xmlTree.getTagNode("GridCell@" + sideKey))) {
                                    sideKey = diff.getXmlTree().xmlTree.getTagNode("GridColumn@" + sideKey).getParent().getParent().getAttributes().get("Key");
                                }
                            } else if (diff.getXmlTree().xmlTree.getTagNode("GridColumn@" + sideKey).getChildren().size() > 1) {
                                if (trueNode.getChildren().size() > 3) {
                                    columns = trueNode.getParent().getParent().getChildren();
                                    index = Objects.isNull(XmlDiffProcessor.compIndex(columns, sideKey)) ? columns.size() / 2 : XmlDiffProcessor.compIndex(columns, sideKey);
                                }
                            } else {
                                diff.getXmlTree().xmlTree.getTagNode("GridColumn@" + sideKey).deleteChildByTagName("GridColumnCollection");
                            }
                        }
                        if (diff.insertAfter) {
                            columns.add(index + 2 * diffSize + 1, node);
                            continue;
                        }
                        columns.add(index - 1, node);
                        continue;
                    }
                    columns = ((TagNode)abstractNode).getChildren();
                    TagNode node = null;
                    MetaGridColumn gridMetaColumnByKey = IDLookup.reloadIDLookup(metaForm).getGridMetaColumnByKey(diff.getKey());
                    String oldKey = Objects.isNull(gridMetaColumnByKey) ? diff.getKey() : gridMetaColumnByKey.getMetaKey();
                    List<TagNode> gridColumn = diff.getVestXmlTree().xmlTree.getRoot().findNodesByTagName("GridColumn");
                    for (TagNode tagNode7 : gridColumn) {
                        String s = tagNode7.getAttributes().get("Key");
                        if (!s.equalsIgnoreCase(oldKey)) continue;
                        node = tagNode7;
                    }
                    TagNode parent = abstractNode.getParent();
                    TagNode gridNode = diff.getVestXmlTree().xmlTree.getTagNode(String.valueOf(selectNode.getTagName()) + "@" + selectNode.getAttributes().get("Key"));
                    TagNode xmlTreeTagNode = diff.getVestXmlTree().xmlTree.getTagNode(String.valueOf(parent.getTagName()) + "@" + parent.getAttributes().get("Key"));
                    List<AbstractNode> vestcolumns = xmlTreeTagNode.findFirstTagNodeByTagName("GridColumnCollection").getChildren();
                    TagNode columnCollection = gridNode.findFirstTagNodeByTagName("GridColumnCollection");
                    TagNode treeTagNode = diff.getXmlTree().xmlTree.getTagNode("GridColumn@" + sideKey);
                    if (treeTagNode != null) {
                        String s = treeTagNode.getParent().getParent().getAttributes().get("Key");
                        String tagName1 = treeTagNode.getParent().getParent().getParent().getTagName();
                        if ("GridColumn".equalsIgnoreCase(tagName1)) {
                            sideKey = s;
                            treeTagNode = treeTagNode.getParent().getParent();
                        }
                        rowIndex = XmlDiffProcessor.statisticsRowIndex((TagNode)abstractNode, sideKey, treeTagNode);
                    }
                    if (Objects.isNull(node)) {
                        TagNode orgNode = diff.getVestXmlTree().xmlTree.getTagNode("GridColumn@" + oldKey);
                        node = orgNode.getParent().getParent();
                        String parentColumnKey = orgNode.getParent().getParent().getAttributes().get("Key");
                        TagNode currcolumnNode = diff.getXmlTree().xmlTree.getTagNode("GridColumn@" + parentColumnKey);
                        TagNode sonNode = null;
                        List<TagNode> nodesByTagName = node.findFirstTagNodeByTagName("GridColumnCollection").findNodesByTagName("GridColumn");
                        for (TagNode tagNode8 : nodesByTagName) {
                            String s = tagNode8.getAttributes().get("Key");
                            if (!s.equalsIgnoreCase(oldKey)) continue;
                            tagNode8.getAttributes().clear();
                            tagNode8.setAttribute("Key", s);
                            sonNode = tagNode8;
                            break;
                        }
                        List<AbstractNode> gridColumnCollection = null;
                        if (Objects.isNull(currcolumnNode)) {
                            TagNode tagNode9 = diff.getVestXmlTree().xmlTree.getTagNode("GridColumn@" + parentColumnKey);
                            TagNode collList = tagNode9.findFirstTagNodeByTagName("GridColumnCollection");
                            collList.getChildren().clear();
                            collList.addNode(sonNode);
                            Integer n = index = XmlDiffProcessor.compIndex(columns, sideKey) == 0 ? XmlDiffProcessor.compIndex(vestcolumns, tagNode9.getAttributes().get("Key")) : XmlDiffProcessor.compIndex(columns, sideKey);
                            if (!tagNode9.getParent().getParent().getTagName().equalsIgnoreCase("Grid")) {
                                columns = currcolumnNode.getParent().findFirstTagNodeByTagName("GridColumnCollection").getChildren();
                            }
                            if (diff.insertAfter) {
                                if (index >= columns.size() - 1) {
                                    columns.add(columns.size() - 2, node);
                                    continue;
                                }
                                columns.add(index + 1, node);
                                continue;
                            }
                            if (index >= columns.size()) {
                                columns.add(index == 0 ? 0 : columns.size() - 2, node);
                                continue;
                            }
                            columns.add(index == 0 ? 0 : index - 1, node);
                            continue;
                        }
                        TagNode firstTagNodeByTagName = currcolumnNode.findFirstTagNodeByTagName("GridColumnCollection");
                        if (firstTagNodeByTagName != null) {
                            gridColumnCollection = firstTagNodeByTagName.getChildren();
                        }
                        gridColumnCollection.add(gridColumnCollection.size() - 1, sonNode);
                        rowIndex = XmlDiffProcessor.statisticsRowIndex((TagNode)abstractNode, parentColumnKey, currcolumnNode) - 1;
                        rowDataIndex = XmlDiffProcessor.statisticsRowIndex(columnCollection, oldKey, sonNode);
                        continue;
                    }
                    Integer n = index = XmlDiffProcessor.compIndex(columns, sideKey) == 0 ? XmlDiffProcessor.compIndex(vestcolumns, diff.getKey()) : XmlDiffProcessor.compIndex(columns, sideKey);
                    if (diff.insertAfter) {
                        if (index >= columns.size() - 1) {
                            columns.add(columns.size() - 2, node);
                        } else {
                            columns.add(index + 1, node);
                        }
                    } else if (index >= columns.size()) {
                        columns.add(index == 0 ? 0 : columns.size() - 2, node);
                    } else {
                        columns.add(index == 0 ? 0 : index - 1, node);
                    }
                    rowIndex = XmlDiffProcessor.statisticsRowIndex((TagNode)abstractNode, diff.getKey(), node) - 1;
                    TagNode vestNode = diff.getVestXmlTree().xmlTree.getTagNode("GridColumn@" + oldKey);
                    String key2 = vestNode.getAttributes().get("Key");
                    vestNode.getAttributes().clear();
                    vestNode.setAttribute("Key", key2);
                    if (rowIndex < 0) {
                        rowIndex = XmlDiffProcessor.statisticsRowIndex((TagNode)abstractNode, oldKey, node) - 1;
                    }
                    rowDataIndex = XmlDiffProcessor.statisticsRowIndex(columnCollection, diff.getKey(), vestNode);
                    continue;
                }
                if (!"GridRowCollection".equals(tagName)) continue;
                List<AbstractNode> gridRows = ((TagNode)abstractNode).getChildren();
                if (gridRows.size() / 3 < 2) {
                    for (AbstractNode gridRow : gridRows) {
                        if (!(gridRow instanceof TagNode) || !"GridRow".equals(name = ((TagNode)gridRow).getTagName())) continue;
                        List<AbstractNode> rows = ((TagNode)gridRow).getChildren();
                        List<TagNode> cellList = ((TagNode)gridRow).findMyselfNodesByTagName("GridCell");
                        TagNode node = new TagNode("GridCell", null);
                        node.setAttribute("Key", diff.getKey());
                        node.setAttribute("CellType", controlType);
                        node.setAttribute("Caption", diff.caption);
                        if ("Dict".equals(controlType)) {
                            if (StringUtils.isNotEmpty((CharSequence)diff.getItemKey())) {
                                node.setAttribute("ItemKey", diff.getItemKey());
                                if (diff.getItemKey().endsWith("__Dic")) {
                                    node.setAttribute(Property.StateMask.name, "Enable|Disable|Discard");
                                }
                            } else if (!Objects.equals(diff.getIsButtonQuote(), Boolean.TRUE)) {
                                throw new Throwable("ItemKey\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
                            }
                            if (diff.properties.size() > 0 && Property.AllowMultiSelection.name.equals(diff.properties.get((int)0).property.name)) {
                                node.setAttribute(Property.AllowMultiSelection.name, diff.properties.get((int)0).newValue);
                            }
                        }
                        if ("DynamicDict".equals(controlType)) {
                            if (StringUtils.isNotEmpty((CharSequence)diff.getReserveThree())) {
                                node.setAttribute("RefKey", diff.getReserveThree());
                            } else {
                                node.setAttribute("RefKey", "true");
                            }
                        }
                        tableKey = ((TagNode)gridRow).getAttributes().get("TableKey");
                        metaFormProfile = (MetaFormProfile)metaFormList.get(metaForm.getKey());
                        if (metaFormProfile == null) {
                            metaFormProfile = (MetaFormProfile)metaFactory.getExtFormList().get(metaForm.getKey());
                        }
                        mergeToSource = metaFormProfile.getMergeToSource();
                        if ((tableKey != null && tableKey.length() != 0 && !tableKey.contains("_NODB") && !"Button".equals(controlType) || mergeToSource.booleanValue()) && "true".equalsIgnoreCase(diff.getReserveTwo())) {
                            key = metaForm.getDataSource().getDataObject().getKey();
                            if (key.equals(extendKey = metaForm.getExtend())) {
                                if (mergeToSource.booleanValue()) {
                                    if (StringUtils.isBlank((CharSequence)tableKey)) {
                                        String tagNodeKey = String.valueOf(((TagNode)gridRow).getTagName()) + "@" + ((TagNode)gridRow).getAttributes().get("Key");
                                        TagNode tagNode10 = diff.getVestXmlTree().xmlTree.getTagNode(tagNodeKey);
                                        tableKey = tagNode10.getAttributes().get("TableKey");
                                    }
                                    NewdtbNode = new TagNode("DataBinding", null);
                                    if (!exist && StringUtils.isNotEmpty((CharSequence)tableKey)) {
                                        ((TagNode)NewdtbNode).setAttribute("ColumnKey", diff.getReserveOne());
                                    }
                                    node.addNode((AbstractNode)NewdtbNode);
                                }
                            } else {
                                NewdtbNode = new TagNode("DataBinding", null);
                                if (!exist) {
                                    ((TagNode)NewdtbNode).setAttribute("ColumnKey", diff.getReserveOne());
                                } else {
                                    ((TagNode)NewdtbNode).setAttribute("ColumnKey", kkey);
                                }
                                node.addNode((AbstractNode)NewdtbNode);
                            }
                        }
                        if ("NumberEditor".equals(controlType)) {
                            TagNode formatNode = new TagNode("CellFormat", null);
                            formatNode.setAttribute("HAlign", "Right");
                            node.addNode(formatNode);
                        }
                        node.setParent((TagNode)gridRow);
                        if (diff.isButtonQuote.booleanValue()) {
                            List<TagNode> gridColumn = diff.getVestXmlTree().xmlTree.getRoot().findNodesByTagName("GridCell");
                            for (TagNode tagNode11 : gridColumn) {
                                String s = tagNode11.getAttributes().get("Key");
                                String cellType = tagNode11.getAttributes().get("CellType");
                                if (!s.equalsIgnoreCase(diff.getKey())) continue;
                                tagNode11.getAttributes().clear();
                                tagNode11.getChildren().clear();
                                tagNode11.setAttribute("Key", s);
                                tagNode11.setAttribute("CellType", cellType);
                                node = tagNode11;
                            }
                        }
                        if (diff.isButtonQuote.booleanValue()) {
                            if ("".equals(sideKey)) {
                                rows.add(rows.size() - 1, node);
                            } else if (rowIndex > cellList.size()) {
                                rows.add(rows.size() - 2, node);
                            } else if (rowIndex > cellList.size()) {
                                rows.add(rowIndex * 2 - 1, node);
                            } else {
                                rows.add(rowIndex * 2, node);
                            }
                        } else if ("".equals(sideKey)) {
                            rows.add(rows.size() - 1, node);
                        } else if (diff.insertAfter) {
                            rows.add(rowIndex * 2, node);
                        } else {
                            rows.add(rowIndex * 2 == 0 ? 0 : rowIndex * 2 - 1, node);
                        }
                        XmlDiffProcessor.addDomainPropertyToNode(node, controlType, diff.getDataElementKey());
                    }
                    continue;
                }
                int addSize = 0;
                name = gridRows.iterator();
                while (name.hasNext()) {
                    List<AbstractNode> rows;
                    String name2;
                    AbstractNode gridRow = name.next();
                    if (!(gridRow instanceof TagNode) || !"GridRow".equals(name2 = ((TagNode)gridRow).getTagName())) continue;
                    TagNode node = new TagNode("GridCell", null);
                    if (++addSize == 1) {
                        rows = ((TagNode)gridRow).getChildren();
                        node.setAttribute("Key", diff.getKey());
                        node.setAttribute("CellType", controlType);
                        node.setAttribute("Caption", diff.caption);
                        if ("Dict".equals(controlType)) {
                            if (StringUtils.isNotEmpty((CharSequence)diff.getItemKey())) {
                                node.setAttribute("ItemKey", diff.getItemKey());
                            } else {
                                throw new Throwable("ItemKey\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
                            }
                        }
                        if ("DynamicDict".equals(controlType)) {
                            if (StringUtils.isNotEmpty((CharSequence)diff.getReserveThree())) {
                                node.setAttribute("RefKey", diff.getReserveThree());
                            } else {
                                node.setAttribute("RefKey", "true");
                            }
                        }
                        tableKey = ((TagNode)gridRow).getAttributes().get("TableKey");
                        metaFormProfile = (MetaFormProfile)metaFormList.get(metaForm.getKey());
                        if (metaFormProfile == null) {
                            metaFormProfile = (MetaFormProfile)metaFactory.getExtFormList().get(metaForm.getKey());
                        }
                        mergeToSource = metaFormProfile.getMergeToSource();
                        if ((tableKey != null && tableKey.length() != 0 && !tableKey.contains("_NODB") && !"Button".equals(controlType) || mergeToSource.booleanValue()) && "true".equalsIgnoreCase(diff.getReserveTwo())) {
                            key = metaForm.getDataSource().getDataObject().getKey();
                            if (key.equals(extendKey = metaForm.getExtend())) {
                                if (key.equals(extendKey) && mergeToSource.booleanValue()) {
                                    NewdtbNode = new TagNode("DataBinding", null);
                                    if (!exist) {
                                        ((TagNode)NewdtbNode).setAttribute("ColumnKey", diff.getKey());
                                    } else {
                                        ((TagNode)NewdtbNode).setAttribute("ColumnKey", kkey);
                                    }
                                    node.addNode((AbstractNode)NewdtbNode);
                                }
                            } else {
                                NewdtbNode = new TagNode("DataBinding", null);
                                if (!exist && StringUtils.isNotEmpty((CharSequence)tableKey)) {
                                    ((TagNode)NewdtbNode).setAttribute("ColumnKey", diff.getKey());
                                }
                                node.addNode((AbstractNode)NewdtbNode);
                            }
                        }
                        node.setParent((TagNode)gridRow);
                        if (diff.isButtonQuote.booleanValue()) {
                            if ("".equals(sideKey)) {
                                rows.add(rows.size() - 1, node);
                            } else if ((rowIndex - 1) * 2 > rows.size()) {
                                rows.add(rows.size() - 2, node);
                            } else {
                                rows.add(rowIndex * 2, node);
                            }
                        } else if ("".equals(sideKey)) {
                            rows.add(rows.size() - 1, node);
                        } else if (diff.insertAfter) {
                            rows.add(rowIndex * 2, node);
                        } else {
                            rows.add(rowIndex * 2 == 0 ? 0 : rowIndex * 2 - 1, node);
                        }
                    } else {
                        rows = ((TagNode)gridRow).getChildren();
                        if (diff.isButtonQuote.booleanValue()) {
                            TagNode tagNode6;
                            XmlTreeWithPath vestXmlTree = diff.getVestXmlTree();
                            TagNode vestRow = vestXmlTree.xmlTree.getTagNode("GridRow@" + ((TagNode)gridRow).getAttributes().get("Key"));
                            List<TagNode> nodesByTagName = vestRow.findNodesByTagName("GridCell");
                            if (rowDataIndex == -1) {
                                TagNode tagNode12 = nodesByTagName.get(rowIndex);
                            } else {
                                tagNode6 = nodesByTagName.get(rowDataIndex - 1);
                            }
                            node.setAttribute("Key", tagNode6.getAttributes().get("Key"));
                        } else {
                            node.setAttribute("Key", String.valueOf(diff.getKey()) + addSize);
                            node.setAttribute("Caption", String.valueOf(diff.caption) + addSize);
                            if ("Dict".equals(controlType)) {
                                if (StringUtils.isNotEmpty((CharSequence)diff.getItemKey())) {
                                    node.setAttribute("ItemKey", diff.getItemKey());
                                } else {
                                    throw new Throwable("ItemKey\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
                                }
                            }
                        }
                        node.setParent((TagNode)gridRow);
                        if (diff.isButtonQuote.booleanValue()) {
                            if ("".equals(sideKey)) {
                                rows.add(rows.size() - 1, node);
                            } else if ((rowIndex - 1) * 2 > rows.size()) {
                                rows.add(rows.size() - 2, node);
                            } else {
                                rows.add(rowIndex * 2, node);
                            }
                        } else if ("".equals(sideKey)) {
                            rows.add(rows.size() - 1, node);
                        } else if (diff.insertAfter) {
                            rows.add(rowIndex * 2, node);
                        } else {
                            rows.add(rowIndex * 2 == 0 ? 0 : rowIndex * 2 - 1, node);
                        }
                    }
                    XmlDiffProcessor.addDomainPropertyToNode(node, controlType, diff.getDataElementKey());
                }
                diff.setMetaObjectType(MetaObjectType.getMetaObjectType("GridFieldMultiRowTable"));
            }
        } else if (diff.getMetaObjectType() == MetaObjectType.ListViewColumn) {
            List<AbstractNode> childrens = selectNode.getChildren();
            boolean exist = false;
            String tableKey = selectComp.getTableKey();
            TagNode tableNode = diff.getXmlTree().xmlTree.getTagNode("Table@" + tableKey);
            boolean isRefObjectKey = false;
            if (!"".equals(metaForm.getDataSource().getRefObjectKey()) && metaForm.getDataSource().getRefObjectKey() != null) {
                tableNode = diff.getDataObjectXmlTree().xmlTree.getTagNode("Table@" + tableKey);
                isRefObjectKey = true;
            }
            if (tableKey != null && !"".equals(tableKey)) {
                for (MetaColumn metaColumn : metaForm.getDataSource().getDataObject().getTable(tableKey)) {
                    if (!metaColumn.getKey().equalsIgnoreCase(diff.getKey()) || tableKey.contains("_NODB")) continue;
                    exist = true;
                }
            }
            if (tableKey != null && tableKey.length() != 0 && !tableKey.contains("_NODB") && tableNode != null && !"Button".equals(controlType) && "true".equalsIgnoreCase(diff.getReserveTwo()) && !exist) {
                TagNode newColumnNode = new TagNode("Column", null);
                newColumnNode.setAttribute("Key", diff.getReserveOne());
                newColumnNode.setAttribute("Caption", diff.caption);
                newColumnNode.setAttribute("DataType", XmlDiffProcessor.getDatatype(diff.getControlType()));
                if ("Varchar".equalsIgnoreCase(XmlDiffProcessor.getDatatype(diff.getControlType()))) {
                    newColumnNode.setAttribute("Length", "255");
                }
                tableNode.addNode(newColumnNode);
                if (isRefObjectKey) {
                    XmlDiffProcessor.genXmlDiff(diff.getDataObjectXmlTree(), tableNode, diff, false);
                } else {
                    XmlDiffProcessor.genXmlDiff(diff.getXmlTree(), tableNode, diff, false);
                }
            }
            for (AbstractNode abstractNode : childrens) {
                if (!(abstractNode instanceof TagNode) || !"ListViewColumnCollection".equalsIgnoreCase(((TagNode)abstractNode).getTagName())) continue;
                TagNode node = new TagNode("ListViewColumn", null);
                node.setAttribute("Key", diff.getKey());
                node.setAttribute("ColumnType", controlType);
                node.setAttribute("Caption", diff.caption);
                node.setAttribute("TableKey", tableKey);
                if (exist || "true".equalsIgnoreCase(diff.getReserveTwo())) {
                    node.setAttribute("DataColumnKey", diff.getReserveOne());
                }
                node.setParent((TagNode)abstractNode);
                List<AbstractNode> rows = ((TagNode)abstractNode).getChildren();
                if ("".equals(diff.sideKey)) {
                    rows.add(rows.size() - 1, node);
                    continue;
                }
                Integer index = XmlDiffProcessor.compIndex(rows, diff.sideKey);
                if (diff.insertAfter) {
                    rows.add(index + 1, node);
                    continue;
                }
                rows.add(index - 1, node);
            }
        } else if (diff.getMetaObjectType() == MetaObjectType.grid) {
            if (!diff.isButtonQuote.booleanValue()) {
                TagNode tabNode22 = XmlDiffProcessor.setGrid(metaForm, selectNode, diff);
                if ("GridLayoutPanel".equals(selectNode.getTagName())) {
                    children = selectNode.getChildren();
                    rowDefIndex = XmlDiffProcessor.getRowDefIndex(children);
                    children.add(rowDefIndex - 1, tabNode22);
                } else {
                    XmlDiffProcessor.addSplitSize(selectNode);
                    XmlDiffProcessor.addNodeToSplitPanel(selectNode, tabNode22);
                }
            } else {
                TagNode tabNode_Vest = diff.getVestXmlTree().xmlTree.getTagNode(diff.getMetaObjectType() + "@" + diff.getKey());
                String key = tabNode_Vest.getAttributes().get("Key");
                tabNode2 = new TagNode(diff.getMetaObjectType().name, null);
                tabNode2.setAttribute("Key", key);
                String parentTagName = selectNode.getTagName();
                if ("GridLayoutPanel".equals(parentTagName) && diff.getMetaObjectType() != MetaObjectType.subDetail) {
                    if (diff.x != null && diff.y != null) {
                        tabNode2.setAttribute("X", diff.x.toString());
                        tabNode2.setAttribute("Y", diff.y.toString());
                    } else {
                        tabNode2.setAttribute("X", "0");
                        tabNode2.setAttribute("Y", "0");
                    }
                }
                if (diff.getMetaObjectType() == MetaObjectType.grid) {
                    tabNode2.setAttribute("Key", diff.getKey());
                } else if (diff.getMetaObjectType() == MetaObjectType.subDetail) {
                    anInt = 1;
                    IDLookup idLookup3 = IDLookup.getIDLookup(metaForm);
                    while (idLookup3.containFieldKey("SubGrid" + anInt)) {
                        ++anInt;
                    }
                    tabNode2.setAttribute("Key", "SubGrid" + anInt);
                }
                if ("GridLayoutPanel".equals(selectNode.getTagName())) {
                    List<AbstractNode> children4 = selectNode.getChildren();
                    Integer rowDefIndex2 = XmlDiffProcessor.getRowDefIndex(children4);
                    children4.add(rowDefIndex2 - 1, tabNode2);
                } else {
                    if (!tabNode_Vest.getParent().getAttributes().get("Key").equalsIgnoreCase(selectNode.getAttributes().get("Key"))) {
                        XmlDiffProcessor.addSplitSize(selectNode);
                    }
                    XmlDiffProcessor.addNodeToSplitPanel(selectNode, tabNode2);
                }
            }
        } else if (diff.getMetaObjectType() == MetaObjectType.listView) {
            if (!diff.isButtonQuote.booleanValue()) {
                idLookup = IDLookup.getIDLookup(metaForm);
                while (idLookup.getListViewColumnByKey("column" + anInt) != null) {
                    ++anInt;
                }
                TagNode tabNode3 = XmlDiffProcessor.setListView(metaForm, selectNode, diff, anInt);
                if ("GridLayoutPanel".equals(selectNode.getTagName())) {
                    List<AbstractNode> children5 = selectNode.getChildren();
                    Integer rowDefIndex3 = XmlDiffProcessor.getRowDefIndex(children5);
                    children5.add(rowDefIndex3 - 1, tabNode3);
                } else {
                    XmlDiffProcessor.addSplitSize(selectNode);
                    XmlDiffProcessor.addNodeToSplitPanel(selectNode, tabNode3);
                }
            }
        } else if (diff.getMetaObjectType() == MetaObjectType.EditView) {
            if (!diff.isButtonQuote.booleanValue()) {
                tabNode = XmlDiffProcessor.setEditView(metaForm, selectNode, diff);
                if ("GridLayoutPanel".equals(selectNode.getTagName())) {
                    children = selectNode.getChildren();
                    rowDefIndex = XmlDiffProcessor.getRowDefIndex(children);
                    children.add(rowDefIndex - 1, tabNode);
                } else {
                    XmlDiffProcessor.addSplitSize(selectNode);
                    XmlDiffProcessor.addNodeToSplitPanel(selectNode, tabNode);
                }
                TagNode bodyNode = diff.getXmlTree().xmlTree.getRoot().getChildByTagName("Body");
                XmlDiffProcessor.genXmlDiff(diff.getXmlTree(), bodyNode, diff, true);
                return anInt;
            }
        } else if (diff.getMetaObjectType() == MetaObjectType.TableView) {
            if (!diff.isButtonQuote.booleanValue()) {
                tabNode = XmlDiffProcessor.setTableView(metaForm, selectNode, diff, 1);
                if ("GridLayoutPanel".equals(selectNode.getTagName())) {
                    children = selectNode.getChildren();
                    rowDefIndex = XmlDiffProcessor.getRowDefIndex(children);
                    children.add(rowDefIndex - 1, tabNode);
                } else {
                    XmlDiffProcessor.addSplitSize(selectNode);
                    XmlDiffProcessor.addNodeToSplitPanel(selectNode, tabNode);
                }
            }
        } else if (diff.getMetaObjectType() == MetaObjectType.CollectionView) {
            if (!diff.isButtonQuote.booleanValue()) {
                tabNode = XmlDiffProcessor.setCollectionView(metaForm, selectNode, diff, 1);
                if ("GridLayoutPanel".equals(selectNode.getTagName())) {
                    children = selectNode.getChildren();
                    rowDefIndex = XmlDiffProcessor.getRowDefIndex(children);
                    children.add(rowDefIndex - 1, tabNode);
                } else {
                    XmlDiffProcessor.addSplitSize(selectNode);
                    XmlDiffProcessor.addNodeToSplitPanel(selectNode, tabNode);
                }
            }
        } else if (diff.getMetaObjectType() == MetaObjectType.panel) {
            if (!diff.isButtonQuote.booleanValue()) {
                TagNode layoutItemNode;
                TagNode layoutSpanNode;
                String type;
                TagNode childLayoutNode;
                String childLayout;
                TagNode compViewNode;
                String compViewKey;
                if (controlType.equals("TabPanel")) {
                    tagbPanelNode = new TagNode(controlType, null);
                    tagbPanelNode.setAttribute("Key", diff.getKey());
                    tagbPanelNode.setAttribute("Caption", diff.caption);
                    XmlDiffProcessor.addSplitSize(selectNode);
                    XmlDiffProcessor.addNodeToSplitPanel(selectNode, tagbPanelNode);
                } else if (controlType.equals("GridLayoutPanel")) {
                    if ("EditView".equalsIgnoreCase(selectNode.getTagName())) {
                        compViewKey = "ComponentView@" + diff.parentKey;
                        compViewNode = diff.getXmlTree().xmlTree.getTagNode(compViewKey);
                        if (compViewNode != null && (childLayout = diff.getReserveOne()) != null && childLayout.length() > 0 && (childLayoutNode = compViewNode.getChildByKey(childLayout)) != null) {
                            type = childLayoutNode.getTagName();
                            if (type.equalsIgnoreCase("GridLayout")) {
                                layoutSpanNode = new TagNode("LayoutSpan", null);
                                layoutSpanNode.setAttribute("Key", diff.getKey());
                                layoutSpanNode.setAttribute("X", diff.x.toString());
                                layoutSpanNode.setAttribute("Y", diff.y.toString());
                                childLayoutNode.addNode(layoutSpanNode);
                            } else if (type.equalsIgnoreCase("LinearLayout")) {
                                layoutItemNode = new TagNode("LinearItem", null);
                                layoutItemNode.setAttribute("Key", diff.getKey());
                                childLayoutNode.addNode(layoutItemNode);
                            } else if (type.equalsIgnoreCase("FlexFlowLayout")) {
                                layoutItemNode = new TagNode("LayoutFlowIndex", null);
                                layoutItemNode.setAttribute("Key", diff.getKey());
                                childLayoutNode.addNode(layoutItemNode);
                            } else if (type.equalsIgnoreCase("ColumnLayout")) {
                                layoutSpanNode = new TagNode("LayoutSpan", null);
                                layoutSpanNode.setAttribute("Key", diff.getKey());
                                layoutSpanNode.setAttribute("X", diff.x.toString());
                                layoutSpanNode.setAttribute("Y", diff.y.toString());
                                childLayoutNode.addNode(layoutSpanNode);
                            } else if (type.equalsIgnoreCase("SplitLayout")) {
                                layoutItemNode = new TagNode("LayoutSplitItem", null);
                                layoutItemNode.setAttribute("Key", diff.getKey());
                                childLayoutNode.addNode(layoutItemNode);
                            } else if (type.equalsIgnoreCase("TabLayout")) {
                                layoutItemNode = new TagNode("LayoutTabItem", null);
                                layoutItemNode.setAttribute("Key", diff.getKey());
                                childLayoutNode.addNode(layoutItemNode);
                            } else if (type.equalsIgnoreCase("FlowLayout")) {
                                layoutItemNode = new TagNode("LayoutFlowIndex", null);
                                layoutItemNode.setAttribute("Key", diff.getKey());
                                childLayoutNode.addNode(layoutItemNode);
                            } else if (type.equalsIgnoreCase("FlexGridLayout")) {
                                layoutItemNode = new TagNode("LayoutRowIndex", null);
                                layoutItemNode.setAttribute("Key", diff.getKey());
                                childLayoutNode.addNode(layoutItemNode);
                            }
                            TagNode gridLayoutNode2 = XmlDiffProcessor.getDefaultGridLayout(diff.getKey());
                            compViewNode.addNode(gridLayoutNode2);
                            XmlDiffProcessor.genXmlDiff(diff.getXmlTree(), compViewNode, diff, true);
                            return anInt;
                        }
                    } else {
                        idLookup = IDLookup.getIDLookup(metaForm);
                        anInt = 1;
                        while (idLookup.containFieldKey("tempGridLayoutPanel" + anInt)) {
                            ++anInt;
                        }
                        TagNode gridLayoutNode3 = XmlDiffProcessor.SetGridLayoutPanel(diff, metaForm, anInt);
                        XmlDiffProcessor.addSplitSize(selectNode);
                        XmlDiffProcessor.addNodeToSplitPanel(selectNode, gridLayoutNode3);
                    }
                } else if (controlType.equals("SplitPanel")) {
                    anInt = 1;
                    idLookup = IDLookup.getIDLookup(metaForm);
                    while (idLookup.containFieldKey("TempTabPanel" + anInt)) {
                        ++anInt;
                    }
                    TagNode splitNode = new TagNode(controlType, null);
                    splitNode.setAttribute("Key", diff.getKey());
                    splitNode.setAttribute("Caption", diff.caption);
                    splitNode.setAttribute("Orientation", "Vertical");
                    tabNode2 = new TagNode("TabPanel", null);
                    tabNode2.setAttribute("Key", "TempTabPanel" + anInt);
                    tabNode2.setAttribute("Caption", "TempTabPanel" + anInt);
                    TagNode size = new TagNode("SplitSize", null);
                    size.setAttribute("Size", "100px");
                    TagNode endSplit = new TagNode("SplitPanel", null);
                    splitNode.addNode(tabNode2);
                    splitNode.addNode(size);
                    splitNode.addNode(endSplit);
                    XmlDiffProcessor.addNodeToSplitPanel(selectNode, splitNode);
                } else if (controlType.equals("FlexFlowLayoutPanel")) {
                    if ("EditView".equalsIgnoreCase(selectNode.getTagName())) {
                        compViewKey = "ComponentView@" + diff.parentKey;
                        compViewNode = diff.getXmlTree().xmlTree.getTagNode(compViewKey);
                        if (compViewNode != null && (childLayout = diff.getReserveOne()) != null && childLayout.length() > 0 && (childLayoutNode = compViewNode.getChildByKey(childLayout)) != null) {
                            type = childLayoutNode.getTagName();
                            if (type.equalsIgnoreCase("GridLayout")) {
                                layoutSpanNode = new TagNode("LayoutSpan", null);
                                layoutSpanNode.setAttribute("Key", diff.getKey());
                                layoutSpanNode.setAttribute("X", diff.x.toString());
                                layoutSpanNode.setAttribute("Y", diff.y.toString());
                                childLayoutNode.addNode(layoutSpanNode);
                            } else if (type.equalsIgnoreCase("LinearLayout")) {
                                layoutItemNode = new TagNode("LinearItem", null);
                                layoutItemNode.setAttribute("Key", diff.getKey());
                                childLayoutNode.addNode(layoutItemNode);
                            } else if (type.equalsIgnoreCase("FlexFlowLayout")) {
                                layoutItemNode = new TagNode("LayoutFlowIndex", null);
                                layoutItemNode.setAttribute("Key", diff.getKey());
                                childLayoutNode.addNode(layoutItemNode);
                            } else if (type.equalsIgnoreCase("ColumnLayout")) {
                                layoutSpanNode = new TagNode("LayoutSpan", null);
                                layoutSpanNode.setAttribute("Key", diff.getKey());
                                layoutSpanNode.setAttribute("X", diff.x.toString());
                                layoutSpanNode.setAttribute("Y", diff.y.toString());
                                childLayoutNode.addNode(layoutSpanNode);
                            } else if (type.equalsIgnoreCase("SplitLayout")) {
                                layoutItemNode = new TagNode("LayoutSplitItem", null);
                                layoutItemNode.setAttribute("Key", diff.getKey());
                                childLayoutNode.addNode(layoutItemNode);
                            } else if (type.equalsIgnoreCase("TabLayout")) {
                                layoutItemNode = new TagNode("LayoutTabItem", null);
                                layoutItemNode.setAttribute("Key", diff.getKey());
                                childLayoutNode.addNode(layoutItemNode);
                            } else if (type.equalsIgnoreCase("FlowLayout")) {
                                layoutItemNode = new TagNode("LayoutFlowIndex", null);
                                layoutItemNode.setAttribute("Key", diff.getKey());
                                childLayoutNode.addNode(layoutItemNode);
                            } else if (type.equalsIgnoreCase("FlexGridLayout")) {
                                layoutItemNode = new TagNode("LayoutRowIndex", null);
                                layoutItemNode.setAttribute("Key", diff.getKey());
                                childLayoutNode.addNode(layoutItemNode);
                            }
                            TagNode flexFlowLayoutNode = new TagNode("FlexFlowLayout", null);
                            flexFlowLayoutNode.setAttribute("Key", diff.getKey());
                            compViewNode.addNode(flexFlowLayoutNode);
                            XmlDiffProcessor.genXmlDiff(diff.getXmlTree(), compViewNode, diff, true);
                            return anInt;
                        }
                    } else {
                        flexNode = new TagNode(controlType, null);
                        flexNode.setAttribute("Key", diff.getKey());
                        flexNode.setAttribute("Caption", diff.caption);
                        if (diff.x != null && diff.y != null) {
                            flexNode.setAttribute("X", diff.x.toString());
                            flexNode.setAttribute("Y", diff.y.toString());
                        }
                        XmlDiffProcessor.addSplitSize(selectNode);
                        XmlDiffProcessor.addNodeToSplitPanel(selectNode, flexNode);
                    }
                } else if (controlType.equalsIgnoreCase("FlowLayoutPanel")) {
                    flexNode = new TagNode(controlType, null);
                    flexNode.setAttribute("Key", diff.getKey());
                    flexNode.setAttribute("Caption", diff.caption);
                    XmlDiffProcessor.addSplitSize(selectNode);
                    XmlDiffProcessor.addNodeToSplitPanel(selectNode, flexNode);
                } else if (controlType.equalsIgnoreCase("ColumnLayoutPanel")) {
                    flexNode = new TagNode(controlType, null);
                    flexNode.setAttribute("Key", diff.getKey());
                    flexNode.setAttribute("Caption", diff.caption);
                    XmlDiffProcessor.addSplitSize(selectNode);
                    XmlDiffProcessor.addNodeToSplitPanel(selectNode, flexNode);
                } else if (controlType.equalsIgnoreCase("SlidingLayoutPanel")) {
                    TagNode slidingNode = new TagNode(controlType, null);
                    slidingNode.setAttribute("Key", diff.getKey());
                    slidingNode.setAttribute("Caption", diff.caption);
                    TagNode mainPanelNode = new TagNode("FlexFlowLayoutPanel", null);
                    mainPanelNode.setAttribute("Key", String.valueOf(diff.getKey()) + "Main");
                    mainPanelNode.setAttribute("Caption", "\u4e3b\u663e\u793a");
                    mainPanelNode.setAttribute("Padding", "5px");
                    TagNode firstPanelNode = new TagNode("FlexFlowLayoutPanel", null);
                    firstPanelNode.setAttribute("Key", String.valueOf(diff.getKey()) + "Fist");
                    firstPanelNode.setAttribute("Caption", "\u4e3b\u4fa7\u6ed1");
                    TagNode secondPanelNode = new TagNode("FlexFlowLayoutPanel", null);
                    secondPanelNode.setAttribute("Key", String.valueOf(diff.getKey()) + "Second");
                    secondPanelNode.setAttribute("Caption", "\u6b21\u4fa7\u6ed1");
                    slidingNode.addNode(mainPanelNode);
                    slidingNode.addNode(firstPanelNode);
                    slidingNode.addNode(secondPanelNode);
                    XmlDiffProcessor.addSplitSize(selectNode);
                    XmlDiffProcessor.addNodeToSplitPanel(selectNode, slidingNode);
                } else if (controlType.equalsIgnoreCase("CollapsePanel")) {
                    TagNode collapseNode = new TagNode(controlType, null);
                    collapseNode.setAttribute("Key", diff.getKey());
                    collapseNode.setAttribute("Caption", diff.caption);
                    TagNode collapseItemNode = new TagNode("CollapseItem", null);
                    collapseItemNode.setAttribute("Key", "CollapseItem1");
                    collapseItemNode.setAttribute("Caption", "CollapseItem1");
                    collapseItemNode.setAttribute("IsExpand", "true");
                    collapseItemNode.setAttribute("TextOff", "\u6298\u53e0");
                    collapseItemNode.setAttribute("TextOn", "\u5c55\u5f00");
                    TagNode linearLayoutNode = new TagNode("LinearLayoutPanel", null);
                    linearLayoutNode.setAttribute("Key", String.valueOf(diff.getKey()) + "LinearPanel");
                    linearLayoutNode.setAttribute("Caption", String.valueOf(diff.getKey()) + "LinearPanel");
                    collapseItemNode.addNode(linearLayoutNode);
                    collapseNode.addNode(collapseItemNode);
                    XmlDiffProcessor.addSplitSize(selectNode);
                    XmlDiffProcessor.addNodeToSplitPanel(selectNode, collapseNode);
                } else if (controlType.equalsIgnoreCase("FlexGridLayoutPanel")) {
                    flexNode = new TagNode(controlType, null);
                    Map<String, String> attributes = flexNode.getAttributes();
                    attributes.put("Key", diff.getKey());
                    attributes.put("Caption", diff.caption);
                    attributes.put("ColumnCount", "6");
                    attributes.put("RowGap", "24");
                    attributes.put("ColumnGap", "16");
                    attributes.put("RowHeight", "32");
                    attributes.put("Height", "pref");
                    XmlDiffProcessor.addSplitSize(selectNode);
                    XmlDiffProcessor.addNodeToSplitPanel(selectNode, flexNode);
                } else if (controlType.equalsIgnoreCase("LinearLayoutPanel")) {
                    if ("EditView".equalsIgnoreCase(selectNode.getTagName())) {
                        compViewKey = "ComponentView@" + diff.parentKey;
                        compViewNode = diff.getXmlTree().xmlTree.getTagNode(compViewKey);
                        if (compViewNode != null && (childLayout = diff.getReserveOne()) != null && childLayout.length() > 0 && (childLayoutNode = compViewNode.getChildByKey(childLayout)) != null) {
                            type = childLayoutNode.getTagName();
                            if (type.equalsIgnoreCase("GridLayout")) {
                                layoutSpanNode = new TagNode("LayoutSpan", null);
                                layoutSpanNode.setAttribute("Key", diff.getKey());
                                layoutSpanNode.setAttribute("X", diff.x.toString());
                                layoutSpanNode.setAttribute("Y", diff.y.toString());
                                childLayoutNode.addNode(layoutSpanNode);
                            } else if (type.equalsIgnoreCase("LinearLayout")) {
                                layoutItemNode = new TagNode("LinearItem", null);
                                layoutItemNode.setAttribute("Key", diff.getKey());
                                childLayoutNode.addNode(layoutItemNode);
                            }
                            TagNode linearLayoutNode = new TagNode("LinearLayout", null);
                            linearLayoutNode.setAttribute("Key", diff.getKey());
                            compViewNode.addNode(linearLayoutNode);
                            XmlDiffProcessor.genXmlDiff(diff.getXmlTree(), compViewNode, diff, true);
                            return anInt;
                        }
                    } else {
                        flexNode = new TagNode(controlType, null);
                        flexNode.setAttribute("Key", diff.getKey());
                        flexNode.setAttribute("Caption", diff.caption);
                        XmlDiffProcessor.addSplitSize(selectNode);
                        XmlDiffProcessor.addNodeToSplitPanel(selectNode, flexNode);
                    }
                } else if (controlType.equalsIgnoreCase("Embed")) {
                    TagNode flexFlowLayoutPanel = new TagNode("FlexFlowLayoutPanel", null);
                    String parentTagName = selectNode.getTagName();
                    if ("GridLayoutPanel".equals(parentTagName) || "columnlayoutpanel".equals(parentTagName)) {
                        if (diff.x != null && diff.y != null) {
                            flexFlowLayoutPanel.setAttribute("X", diff.x.toString());
                            flexFlowLayoutPanel.setAttribute("Y", diff.y.toString());
                        } else {
                            flexFlowLayoutPanel.setAttribute("X", "0");
                            flexFlowLayoutPanel.setAttribute("Y", "0");
                        }
                    }
                    flexFlowLayoutPanel.setAttribute("Key", String.valueOf(diff.getKey()) + "Embed");
                    flexFlowLayoutPanel.setAttribute("Caption", String.valueOf(diff.getKey()) + "Embed");
                    flexFlowLayoutPanel.setAttribute("Visible", "true");
                    TagNode flexNode2 = new TagNode(controlType, null);
                    flexNode2.setAttribute("Key", diff.getKey());
                    flexNode2.setAttribute("Caption", diff.caption);
                    flexNode2.setAttribute("Height", "100%");
                    TagNode var = new TagNode("Var", null);
                    var.setAttribute("Key", "ParentKey");
                    var.setAttribute("Value", diff.getReserveOne());
                    flexNode2.addNode(var);
                    flexNode2.setAttribute("FormKey", diff.getReserveTwo());
                    flexNode2.setAttribute("RootKey", diff.getReserveThree());
                    flexFlowLayoutPanel.addNode(flexNode2);
                    XmlDiffProcessor.addSplitSize(selectNode);
                    XmlDiffProcessor.addNodeToSplitPanel(selectNode, flexFlowLayoutPanel);
                }
            } else {
                gridLayoutNode = diff.getVestXmlTree().xmlTree.getTagNode(String.valueOf(controlType) + "@" + diff.getKey());
                XmlDiffProcessor.addSplitSize(selectNode);
                XmlDiffProcessor.addNodeToSplitPanel(selectNode, gridLayoutNode);
            }
        } else if (diff.getMetaObjectType() == MetaObjectType.subDetail) {
            if (!diff.isButtonQuote.booleanValue()) {
                DataTable dataTable = document.get("ED_NewPanel");
                if (dataTable != null) {
                    subDetailBind = dataTable.getString("SubDetailBind");
                } else {
                    try {
                        subDetailBind = document.get("D_NewSubDetailHead").getString("SubDetailBind");
                    }
                    catch (Exception e) {
                        subDetailBind = document.get("ED_NewComponent").getString("SubDetailBind");
                    }
                }
                TagNode subDetailNode = new TagNode("SubDetail", null);
                TagNode endSubDetail = new TagNode("SubDetail", null);
                subDetailNode.setAttribute("Key", diff.getKey());
                subDetailNode.setAttribute("Caption", diff.caption);
                subDetailNode.setAttribute("BindingGridKey", diff.bindingGridKey);
                if (diff.y != null && diff.x != null) {
                    subDetailNode.setAttribute("X", diff.x.toString());
                    subDetailNode.setAttribute("Y", diff.y.toString());
                }
                if ("Grid".equalsIgnoreCase(subDetailBind)) {
                    TagNode tabNode4 = XmlDiffProcessor.setGrid(metaForm, selectNode, diff);
                    subDetailNode.addNode(tabNode4);
                } else if ("GridLayoutPanel".equalsIgnoreCase(subDetailBind)) {
                    IDLookup idLookup4 = IDLookup.getIDLookup(metaForm);
                    anInt = 1;
                    while (idLookup4.containFieldKey("tempGridLayoutPanel" + anInt)) {
                        ++anInt;
                    }
                    TagNode gridLayoutNode4 = XmlDiffProcessor.SetGridLayoutPanel(diff, metaForm, anInt);
                    subDetailNode.addNode(gridLayoutNode4);
                }
                subDetailNode.addNode(endSubDetail);
                XmlDiffProcessor.addSplitSize(selectNode);
                XmlDiffProcessor.addNodeToSplitPanel(selectNode, subDetailNode);
            } else if (StringUtils.equals((CharSequence)diff.getReserveOne(), (CharSequence)"extension")) {
                TagNode subDetailNode = new TagNode("SubDetail", null);
                subDetailNode.setAttribute("Key", String.valueOf(diff.getKey()) + "_ext");
                subDetailNode.setAttribute("Caption", diff.caption);
                XmlDiffProcessor.addSubCompToSubDetail(subDetailNode, diff);
                selectNode.addNode(subDetailNode);
            } else {
                gridLayoutNode = diff.getVestXmlTree().xmlTree.getTagNode(String.valueOf(controlType) + "@" + diff.getKey());
                XmlDiffProcessor.addSplitSize(selectNode);
                XmlDiffProcessor.addNodeToSplitPanel(selectNode, gridLayoutNode);
            }
        } else if (diff.getMetaObjectType() == MetaObjectType.toolbar || diff.getMetaObjectType() == MetaObjectType.ToolBar) {
            flexNode = new TagNode(controlType, null);
            flexNode.setAttribute("Key", diff.getKey());
            flexNode.setAttribute("Caption", diff.caption);
            if (diff.x != null && diff.y != null) {
                flexNode.setAttribute("X", diff.x.toString());
                flexNode.setAttribute("Y", diff.y.toString());
            }
            XmlDiffProcessor.addSplitSize(selectNode);
            selectNode.addNode(flexNode, 0);
        } else if (diff.getMetaObjectType() == MetaObjectType.Chart) {
            flexNode = new TagNode(controlType, null);
            flexNode.setAttribute("Key", diff.getKey());
            flexNode.setAttribute("Caption", diff.caption);
            if (diff.x != null && diff.y != null) {
                flexNode.setAttribute("X", diff.x.toString());
                flexNode.setAttribute("Y", diff.y.toString());
            }
            XmlDiffProcessor.addSplitSize(selectNode);
            XmlDiffProcessor.addNodeToSplitPanel(selectNode, flexNode);
        } else if (diff.getMetaObjectType() == MetaObjectType.WebBrowser) {
            flexNode = new TagNode(controlType, null);
            flexNode.setAttribute("Key", diff.getKey());
            flexNode.setAttribute("Caption", diff.caption);
            if (diff.x != null && diff.y != null) {
                flexNode.setAttribute("X", diff.x.toString());
                flexNode.setAttribute("Y", diff.y.toString());
            }
            XmlDiffProcessor.addSplitSize(selectNode);
            XmlDiffProcessor.addNodeToSplitPanel(selectNode, flexNode);
        } else if (diff.getMetaObjectType() == MetaObjectType.EditViewColumn) {
            TagNode colCollectionNode = selectNode.getOrCreateChildByTagName("EditViewColumnCollection");
            if (!diff.isButtonQuote.booleanValue()) {
                TagNode rootLayout;
                TagNode colNode = new TagNode("EditViewColumn", null);
                colNode.setAttribute("Key", diff.getKey());
                colNode.setAttribute("Caption", diff.caption);
                colNode.setAttribute("ColumnType", controlType);
                colCollectionNode.addNode(colNode);
                String compViewKey = "ComponentView@" + diff.parentKey;
                TagNode compViewNode = diff.getXmlTree().xmlTree.getTagNode(compViewKey);
                if (compViewNode != null && (rootLayout = compViewNode.getChildByKey(diff.getReserveOne())) != null) {
                    TagNode layoutItemNode;
                    String tagName = rootLayout.getTagName();
                    if (tagName.equalsIgnoreCase("GridLayout")) {
                        TagNode spanNode = new TagNode("LayoutSpan", null);
                        spanNode.setAttribute("Key", diff.getKey());
                        spanNode.setAttribute("X", diff.x.toString());
                        spanNode.setAttribute("Y", diff.y.toString());
                        rootLayout.addNode(spanNode);
                    } else if (tagName.equalsIgnoreCase("LinearLayout")) {
                        TagNode linearItemNode = new TagNode("LinearItem", null);
                        linearItemNode.setAttribute("Key", diff.getKey());
                        linearItemNode.setAttribute("Height", "pref");
                        linearItemNode.setAttribute("Width", "100%");
                        rootLayout.addNode(linearItemNode);
                    } else if (tagName.equalsIgnoreCase("FlexFlowLayout")) {
                        layoutItemNode = new TagNode("LayoutFlowIndex", null);
                        layoutItemNode.setAttribute("Key", diff.getKey());
                        rootLayout.addNode(layoutItemNode);
                    } else if (tagName.equalsIgnoreCase("ColumnLayout")) {
                        TagNode layoutSpanNode = new TagNode("LayoutSpan", null);
                        layoutSpanNode.setAttribute("Key", diff.getKey());
                        layoutSpanNode.setAttribute("X", diff.x.toString());
                        layoutSpanNode.setAttribute("Y", diff.y.toString());
                        rootLayout.addNode(layoutSpanNode);
                    } else if (tagName.equalsIgnoreCase("SplitLayout")) {
                        layoutItemNode = new TagNode("LayoutSplitItem", null);
                        layoutItemNode.setAttribute("Key", diff.getKey());
                        rootLayout.addNode(layoutItemNode);
                    } else if (tagName.equalsIgnoreCase("TabLayout")) {
                        layoutItemNode = new TagNode("LayoutTabItem", null);
                        layoutItemNode.setAttribute("Key", diff.getKey());
                        rootLayout.addNode(layoutItemNode);
                    } else if (tagName.equalsIgnoreCase("FlowLayout")) {
                        layoutItemNode = new TagNode("LayoutFlowIndex", null);
                        layoutItemNode.setAttribute("Key", diff.getKey());
                        rootLayout.addNode(layoutItemNode);
                    } else if (tagName.equalsIgnoreCase("FlexGridLayout")) {
                        layoutItemNode = new TagNode("LayoutRowIndex", null);
                        layoutItemNode.setAttribute("Key", diff.getKey());
                        rootLayout.addNode(layoutItemNode);
                    }
                }
                if ("true".equalsIgnoreCase(diff.getReserveFour())) {
                    List<TagNode> dataObject = diff.getXmlTree().xmlTree.getRoot().findNodesByTagName(MetaObjectType.DataObject.name);
                    List<TagNode> column = diff.getXmlTree().xmlTree.getRoot().findNodesByTagName("Column");
                    MetaFormProfile metaFormProfile = (MetaFormProfile)metaFormList.get(metaForm.getKey());
                    if (metaFormProfile == null) {
                        metaFormProfile = (MetaFormProfile)metaFactory.getExtFormList().get(metaForm.getKey());
                    }
                    Boolean bl = metaFormProfile.getMergeToSource();
                    if (diff.getMetaForm().getDataSource() != null && !"".equals(diff.getMetaForm().getDataSource().getRefObjectKey()) && !bl.booleanValue()) {
                        dataObject = diff.getDataObjectXmlTree().xmlTree.getRoot().findNodesByTagName(MetaObjectType.DataObject.name);
                        column = diff.getDataObjectXmlTree().xmlTree.getRoot().findNodesByTagName("Column");
                    }
                    boolean exist = false;
                    String kkey = "";
                    for (TagNode tagNode13 : column) {
                        if (!diff.getKey().equalsIgnoreCase(tagNode13.getAttributes().get("Key"))) continue;
                        kkey = tagNode13.getAttributes().get("Key");
                        exist = true;
                    }
                    if (!dataObject.isEmpty() && "".equalsIgnoreCase(selectComp.getParentGridKey())) {
                        String tableKey = diff.getReserveTwo();
                        if (tableKey == null || tableKey.isEmpty()) {
                            tableKey = metaForm.getDataSource().getDataObject().getMainTableKey();
                        }
                        if (tableKey != null && tableKey.length() > 0 && !tableKey.equalsIgnoreCase(null)) {
                            int controlTypeE = diff.getControlType();
                            String objectKey = metaForm.getDataSource().getDataObject().getKey();
                            String extendKey = metaForm.getExtend();
                            Boolean mergeToSource = metaFormProfile.getMergeToSource();
                            if (objectKey.equals(extendKey) && !mergeToSource.booleanValue()) {
                                TagNode newDataBindingnode = new TagNode("DataBinding", null);
                                if (!Objects.equals(diff.getIsButtonQuote(), Boolean.TRUE)) {
                                    colNode.addNode(newDataBindingnode);
                                }
                            } else if (objectKey.equals(extendKey) && mergeToSource.booleanValue()) {
                                if (!Objects.equals(diff.getIsButtonQuote(), Boolean.TRUE)) {
                                    String key = diff.getReserveThree();
                                    if (key == null || key.isEmpty()) {
                                        key = String.valueOf(diff.getKey().substring(0, 1).toUpperCase()) + diff.getKey().substring(1);
                                    }
                                    TagNode newDataBindingnode = new TagNode("DataBinding", null);
                                    newDataBindingnode.setAttribute("TableKey", tableKey);
                                    TagNode newColumn = new TagNode("Column", null);
                                    newColumn.setAttribute("Key", key);
                                    newColumn.setAttribute("Caption", diff.caption);
                                    newColumn.setAttribute("DataType", XmlDiffProcessor.getDatatype(controlTypeE));
                                    if ("Varchar".equalsIgnoreCase(XmlDiffProcessor.getDatatype(controlTypeE))) {
                                        newColumn.setAttribute("Length", "255");
                                    }
                                    TagNode tableNode = diff.getXmlTree().xmlTree.getTagNode("Table@" + tableKey);
                                    tableNode.addNode(newColumn);
                                    XmlDiffProcessor.genXmlDiff(diff.getXmlTree(), tableNode, diff, false);
                                    newDataBindingnode.setAttribute("ColumnKey", key);
                                    colNode.addNode(newDataBindingnode);
                                }
                            } else if (!exist) {
                                String key = diff.getReserveThree();
                                if (key == null || key.isEmpty()) {
                                    key = String.valueOf(diff.getKey().substring(0, 1).toUpperCase()) + diff.getKey().substring(1);
                                }
                                TagNode newDataBindingnode = new TagNode("DataBinding", null);
                                newDataBindingnode.setAttribute("TableKey", tableKey);
                                TagNode newColumn = new TagNode("Column", null);
                                newColumn.setAttribute("Key", key);
                                newColumn.setAttribute("Caption", diff.caption);
                                newColumn.setAttribute("DataType", XmlDiffProcessor.getDatatype(controlTypeE));
                                if ("Varchar".equalsIgnoreCase(XmlDiffProcessor.getDatatype(controlTypeE))) {
                                    newColumn.setAttribute("Length", "255");
                                }
                                if (!"".equals(diff.getMetaForm().getDataSource().getRefObjectKey()) && diff.getMetaForm().getDataSource().getRefObjectKey() != null) {
                                    TagNode tableNode = diff.getDataObjectXmlTree().xmlTree.getTagNode("Table@" + tableKey);
                                    tableNode.addNode(newColumn);
                                } else {
                                    TagNode tableNode = diff.getXmlTree().xmlTree.getTagNode("Table@" + tableKey);
                                    tableNode.addNode(newColumn);
                                }
                                newDataBindingnode.setAttribute("ColumnKey", key);
                                colNode.addNode(newDataBindingnode);
                            } else {
                                TagNode newDataBindingnode = new TagNode("DataBinding", null);
                                newDataBindingnode.setAttribute("TableKey", tableKey);
                                newDataBindingnode.setAttribute("ColumnKey", kkey);
                                colNode.addNode(newDataBindingnode);
                            }
                        }
                    } else {
                        TagNode newDataBindingnode = new TagNode("DataBinding", null);
                        colNode.addNode(newDataBindingnode);
                    }
                }
                selectNode = diff.getXmlTree().xmlTree.getRoot();
            }
        }
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        int startLine = xmlTree.xmlTree.getLineByIndex(selectNode.getElement().getBgIndex());
        String orgXmlFragment = xmlTree.xmlTree.getNodeString(startLine);
        String newXmlFragment = "";
        newXmlFragment = diff.x != null && diff.y != null ? DesignIOMetaUtil.orderAndgetXml(diff.getKey(), selectNode) : DesignIOMetaUtil.getXml(selectNode);
        if (diff.getOrgXmlFragment() != null && diff.getNewXmlFragment() != null) {
            diff.setXmlDiff2(xmlTree, startLine, orgXmlFragment, newXmlFragment);
        } else {
            diff.setXmlDiff(xmlTree, startLine, orgXmlFragment, newXmlFragment);
        }
        return anInt;
    }

    private static TagNode getDefaultGridLayout(String layoutkey) {
        TagNode gridLayoutNode = new TagNode("GridLayout", null);
        gridLayoutNode.setAttribute("Key", layoutkey);
        TagNode rowDefs = new TagNode("RowDefCollection", null);
        rowDefs.setAttribute("RowGap", "5");
        TagNode rowDef1 = new TagNode("RowDef", null);
        rowDef1.setAttribute("Height", "40px");
        rowDefs.addNode(rowDef1);
        TagNode rowDef2 = new TagNode("RowDef", null);
        rowDef2.setAttribute("Height", "40px");
        rowDefs.addNode(rowDef2);
        TagNode rowDef3 = new TagNode("RowDef", null);
        rowDef3.setAttribute("Height", "40px");
        rowDefs.addNode(rowDef3);
        TagNode colDefs = new TagNode("ColumnDefCollection", null);
        colDefs.setAttribute("ColumnGap", "5");
        TagNode colDef1 = new TagNode("ColumnDef", null);
        colDef1.setAttribute("Width", "50%");
        colDefs.addNode(colDef1);
        TagNode colDef2 = new TagNode("ColumnDef", null);
        colDef2.setAttribute("Width", "50%");
        colDefs.addNode(colDef2);
        gridLayoutNode.addNode(rowDefs);
        gridLayoutNode.addNode(colDefs);
        return gridLayoutNode;
    }

    private static TagNode getDefaultComponentView(String componentKey) {
        TagNode compViewNode = new TagNode("ComponentView", null);
        compViewNode.setAttribute("Key", componentKey);
        TagNode gridLayoutNode = new TagNode("GridLayout", null);
        gridLayoutNode.setAttribute("Key", componentKey);
        TagNode rowDefs = new TagNode("RowDefCollection", null);
        rowDefs.setAttribute("RowGap", "5");
        TagNode rowDef1 = new TagNode("RowDef", null);
        rowDef1.setAttribute("Height", "30px");
        rowDefs.addNode(rowDef1);
        TagNode rowDef2 = new TagNode("RowDef", null);
        rowDef2.setAttribute("Height", "30px");
        rowDefs.addNode(rowDef2);
        TagNode colDefs = new TagNode("ColumnDefCollection", null);
        colDefs.setAttribute("ColumnGap", "5");
        TagNode colDef1 = new TagNode("ColumnDef", null);
        colDef1.setAttribute("Width", "100px");
        colDefs.addNode(colDef1);
        TagNode colDef2 = new TagNode("ColumnDef", null);
        colDef2.setAttribute("Width", "100%");
        colDefs.addNode(colDef2);
        gridLayoutNode.addNode(rowDefs);
        gridLayoutNode.addNode(colDefs);
        compViewNode.addNode(gridLayoutNode);
        return compViewNode;
    }

    private static TagNode setEditView(MetaForm metaForm, TagNode parentNode, Diff diff) throws Throwable {
        TagNode editViewNode = new TagNode("EditView", null);
        String parentTagName = parentNode.getTagName();
        if ("GridLayoutPanel".equals(parentTagName)) {
            if (diff.x != null && diff.y != null) {
                editViewNode.setAttribute("X", diff.x.toString());
                editViewNode.setAttribute("Y", diff.y.toString());
            } else {
                editViewNode.setAttribute("X", "0");
                editViewNode.setAttribute("Y", "0");
            }
        }
        editViewNode.setAttribute("Key", diff.getKey());
        editViewNode.setAttribute("Caption", diff.caption);
        editViewNode.setAttribute("RowHeight", "140");
        editViewNode.setAttribute("Width", "100%");
        editViewNode.setAttribute("Height", "240px");
        editViewNode.setAttribute("Padding", "10px");
        TagNode formatNode = new TagNode("Format", null);
        formatNode.setAttribute("BackColor", "#e5e4e480");
        editViewNode.addNode(formatNode);
        TagNode rowNode = new TagNode("EditViewRow", null);
        rowNode.setAttribute("TopMargin", "5px");
        editViewNode.addNode(rowNode);
        editViewNode.setAttribute("TableKey", diff.associatedTable);
        TagNode bodyNode = diff.getXmlTree().xmlTree.getRoot().getChildByTagName("Body");
        TagNode viewCollectionNode = bodyNode.getOrCreateChildByTagName("ViewCollection");
        TagNode viewNode = null;
        int i = 0;
        while (i < viewCollectionNode.getChildren().size()) {
            int mediaValue;
            AbstractNode subViewNode = viewCollectionNode.getChildren().get(i);
            if (subViewNode instanceof TagNode && (Media.isSupportMedia((int)16, (int)(mediaValue = Media.valueOf((String)((TagNode)subViewNode).getAttributes().get("Media").toString()))) || Media.isSupportMedia((int)8, (int)mediaValue))) {
                viewNode = (TagNode)subViewNode;
                break;
            }
            ++i;
        }
        if (viewNode == null) {
            viewNode = new TagNode("View", null);
            viewNode.setAttribute("Key", "MobileView");
            viewNode.setAttribute("Media", "IOS|ANDROID");
            viewCollectionNode.addNode(viewNode);
        }
        TagNode componentViewNode = XmlDiffProcessor.getDefaultComponentView(diff.getKey());
        if (viewNode.getChildByKey(diff.getKey()) != null) {
            viewNode.getChildren().remove(viewNode.getChildByKey(diff.getKey()));
        }
        viewNode.addNode(componentViewNode);
        return editViewNode;
    }

    private static TagNode setTableView(MetaForm metaForm, TagNode parentNode, Diff diff, int anInt) {
        TagNode tabNode = new TagNode(MetaObjectType.TableView.name, null);
        String parentTagName = parentNode.getTagName();
        if ("GridLayoutPanel".equals(parentTagName) && diff.getMetaObjectType() != MetaObjectType.subDetail) {
            if (diff.x != null && diff.y != null) {
                tabNode.setAttribute("X", diff.x.toString());
                tabNode.setAttribute("Y", diff.y.toString());
            } else {
                tabNode.setAttribute("X", "0");
                tabNode.setAttribute("Y", "0");
            }
        }
        tabNode.setAttribute("Key", diff.getKey());
        tabNode.setAttribute("Caption", diff.caption);
        tabNode.setAttribute("Padding", "10px");
        TagNode formatNode = new TagNode("Format", null);
        formatNode.setAttribute("BackColor", "#efefef");
        tabNode.addNode(formatNode);
        TagNode rowCollectionNode = new TagNode("TableRowCollection", null);
        TagNode rowNode = new TagNode("TableRow", null);
        rowNode.setAttribute("Key", String.valueOf(diff.getKey()) + "Row" + anInt);
        rowNode.setAttribute("Caption", String.valueOf(diff.getKey()) + "Row" + anInt);
        TagNode defaultPanelNode = new TagNode("LinearLayoutPanel", null);
        defaultPanelNode.setAttribute("Key", String.valueOf(diff.getKey()) + "DefaultPanel" + anInt);
        defaultPanelNode.setAttribute("Caption", String.valueOf(diff.getKey()) + "DefaultPanel" + anInt);
        defaultPanelNode.setAttribute("Height", "45px");
        rowNode.addNode(defaultPanelNode);
        rowCollectionNode.addNode(rowNode);
        tabNode.addNode(rowCollectionNode);
        return tabNode;
    }

    private static TagNode setCollectionView(MetaForm metaForm, TagNode parentNode, Diff diff, int anInt) {
        TagNode tabNode = new TagNode(MetaObjectType.CollectionView.name, null);
        String parentTagName = parentNode.getTagName();
        if ("GridLayoutPanel".equals(parentTagName) && diff.getMetaObjectType() != MetaObjectType.subDetail) {
            if (diff.x != null && diff.y != null) {
                tabNode.setAttribute("X", diff.x.toString());
                tabNode.setAttribute("Y", diff.y.toString());
            } else {
                tabNode.setAttribute("X", "0");
                tabNode.setAttribute("Y", "0");
            }
        }
        tabNode.setAttribute("Key", diff.getKey());
        tabNode.setAttribute("Caption", diff.caption);
        tabNode.setAttribute("Padding", "10px");
        TagNode formatNode = new TagNode("Format", null);
        formatNode.setAttribute("BackColor", "#efefef");
        tabNode.addNode(formatNode);
        TagNode rowCollectionNode = new TagNode("CollectionViewRowCollection", null);
        TagNode rowNode = new TagNode("CollectionViewRow", null);
        rowNode.setAttribute("Key", String.valueOf(diff.getKey()) + "Row" + anInt);
        rowNode.setAttribute("Caption", String.valueOf(diff.getKey()) + "Row" + anInt);
        TagNode defaultPanelNode = new TagNode("LinearLayoutPanel", null);
        defaultPanelNode.setAttribute("Key", String.valueOf(diff.getKey()) + "DefaultPanel" + anInt);
        defaultPanelNode.setAttribute("Caption", String.valueOf(diff.getKey()) + "DefaultPanel" + anInt);
        defaultPanelNode.setAttribute("Height", "45px");
        rowNode.addNode(defaultPanelNode);
        rowCollectionNode.addNode(rowNode);
        tabNode.addNode(rowCollectionNode);
        return tabNode;
    }

    private static TagNode setListView(MetaForm metaForm, TagNode parentNode, Diff diff, int anInt) {
        TagNode tabNode = new TagNode(MetaObjectType.listView.name, null);
        String parentTagName = parentNode.getTagName();
        if ("GridLayoutPanel".equals(parentTagName) && diff.getMetaObjectType() != MetaObjectType.subDetail) {
            if (diff.x != null && diff.y != null) {
                tabNode.setAttribute("X", diff.x.toString());
                tabNode.setAttribute("Y", diff.y.toString());
            } else {
                tabNode.setAttribute("X", "0");
                tabNode.setAttribute("Y", "0");
            }
        }
        tabNode.setAttribute("Key", diff.getKey());
        tabNode.setAttribute("Caption", diff.caption);
        String associatedTable = diff.associatedTable;
        if (StringUtils.isNotBlank((CharSequence)associatedTable)) {
            tabNode.setAttribute("TableKey", associatedTable);
        }
        TagNode collNode = new TagNode("ListViewColumnCollection", null);
        TagNode listnode = new TagNode("ListViewColumn", null);
        listnode.setAttribute("Key", "column" + anInt);
        listnode.setAttribute("Caption", "column" + anInt);
        TagNode endcols = new TagNode("ListViewColumnCollection", null);
        TagNode endListView = new TagNode("ListView", null);
        tabNode.addNode(collNode);
        tabNode.addNode(endListView);
        collNode.addNode(listnode);
        if (diff.getCreate() != null && "1".equals(diff.getCreate())) {
            MetaTable metaTable = metaForm.getMetaTable(associatedTable);
            for (MetaColumn metaColumn : metaTable) {
                String key = metaColumn.getKey();
                String caption = metaColumn.getCaption();
                if ("OID".equals(key) || "POID".equals(key) || "SOID".equals(key) || "VERID".equals(key) || "DVERID".equals(key) || "MapCount".equals(key) || "SelectField".equals(key) || key.contains("_NODB") || "Sequence".equals(key)) continue;
                try {
                    String resource = LoadFileTree.getPathByFormKey(metaForm.getKey());
                    XmlTreeWithPath parse = XmlTreeWithPath.parseFilePath(resource);
                    int haveRelyOn = XmlDiffProcessor.isHaveRelyOn(key, parse.xmlTree, associatedTable);
                    if (haveRelyOn != 0) {
                        continue;
                    }
                }
                catch (Throwable e) {
                    LogSvr.getInstance().error("", e);
                }
                TagNode colDeleteNode1 = new TagNode("ListViewColumn", null);
                colDeleteNode1.setAttribute("Key", key);
                if (Objects.equals(caption, "")) {
                    colDeleteNode1.setAttribute("Caption", key);
                } else {
                    colDeleteNode1.setAttribute("Caption", caption);
                }
                int dataType = metaColumn.getDataType();
                String cellType = DataType.toString((Integer)dataType);
                String type = XmlDiffProcessor.getGridCellType(cellType, key);
                colDeleteNode1.setAttribute("ColumnType", type);
                colDeleteNode1.setAttribute("Width", "80px");
                colDeleteNode1.setAttribute("DataColumnKey", key);
                collNode.addNode(colDeleteNode1);
            }
        }
        collNode.addNode(endcols);
        return tabNode;
    }

    private static int location(Diff diff, TagNode parent) {
        List<AbstractNode> children = parent.getChildren();
        int index = 0;
        int i = 0;
        while (i < children.size()) {
            AbstractNode abstractNode = children.get(i);
            if (abstractNode instanceof TagNode && diff.parentKey.equals(((TagNode)abstractNode).getAttributes().get("Key"))) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    private static void mergeGridRowNewDiff(MetaGrid parentGrid, TagNode parentNode, Diff diff) {
        MetaForm metaForm = diff.getMetaForm();
        String rowType = RowType.toString((Integer)diff.getControlType());
        if ("Group".equalsIgnoreCase(rowType)) {
            if (StringUtils.isBlank((CharSequence)diff.getReserveOne())) {
                throw new RuntimeException("warning: \u8bf7\u9009\u62e9\u5206\u7ec4\u884c\u5bf9\u5e94\u7684\u5206\u7ec4\u6807\u8bc6");
            }
            if (IDLookup.getIDLookup(metaForm).getGridCellByKey(diff.getReserveOne()).getCellGroupType() == 0 || 2 == IDLookup.getIDLookup(metaForm).getGridCellByKey(diff.getReserveOne()).getCellGroupType()) {
                throw new RuntimeException("warning: \u8bf7\u5c06\u5206\u7ec4\u6807\u8bc6\u5bf9\u5e94\u7684GridCell\u5b57\u6bb5\u8bbe\u7f6e\u4e3a\u884c\u5206\u7ec4\u7c7b\u578b");
            }
        } else if ("Detail".equalsIgnoreCase(rowType)) {
            MetaGridRowCollection rowCollection = parentGrid.getRowCollection();
            for (MetaGridRow metaGridRow : rowCollection) {
                int rowType1 = metaGridRow.getRowType();
                if (2 != rowType1) continue;
                throw new RuntimeException("warning: \u8868\u683c\u4e2d\u53ea\u80fd\u5b58\u5728\u4e00\u884c\u660e\u7ec6\u884c");
            }
        }
        IDLookup idLookup = IDLookup.getIDLookup(metaForm);
        MetaGridColumnCollection metaGridColumns = idLookup.getMetaGridByGridKey(diff.parentKey).getColumnCollection();
        for (MetaGridColumn metaGridColumn : metaGridColumns) {
            if (!metaGridColumn.isVestDeleted().booleanValue()) continue;
            throw new RuntimeException("warning: \u8be5\u8868\u683c\u5b58\u5728\u9a6c\u7532\u5220\u9664\u5b57\u6bb5\uff0c\u6682\u4e0d\u652f\u6301\u6dfb\u52a0\u884c");
        }
        List<AbstractNode> parentChildren = parentNode.getChildren();
        for (AbstractNode parentChild : parentChildren) {
            String sideRowKey;
            if (!(parentChild instanceof TagNode)) continue;
            TagNode collerction = (TagNode)parentChild;
            String tagName = ((TagNode)parentChild).getTagName();
            if (!"GridRowCollection".equalsIgnoreCase(tagName)) continue;
            TagNode collNode = new TagNode("GridRow", null);
            if ("Group".equalsIgnoreCase(rowType)) {
                collNode.setAttribute("GroupKey", diff.getReserveOne());
            }
            collNode.setAttribute("Key", diff.getKey());
            if (!"Detail".equalsIgnoreCase(rowType)) {
                collNode.setAttribute("RowType", rowType);
            }
            List<AbstractNode> gridRows = collerction.getChildren();
            int i = 0;
            for (AbstractNode gridRow : gridRows) {
                if (!(gridRow instanceof TagNode)) continue;
                List<AbstractNode> tagNodes = ((TagNode)gridRow).getChildren();
                for (AbstractNode tagNode : tagNodes) {
                    String name;
                    if (!(tagNode instanceof TagNode) || (name = ((TagNode)tagNode).getPrimaryKey()) == null) continue;
                    TagNode child = new TagNode("GridCell", null);
                    child.setAttribute("Key", String.valueOf(diff.getKey()) + i);
                    ++i;
                    collNode.addNode(child);
                }
            }
            XmlTreeWithPath xmlTree = diff.getXmlTree();
            TagNode tagNode = xmlTree.xmlTree.getTagNode("GridCell@" + diff.sideKey);
            if (tagNode != null) {
                sideRowKey = tagNode.getParent().getPrimaryKey().substring(tagNode.getParent().getPrimaryKey().indexOf("@") + 1);
            } else {
                tagNode = xmlTree.xmlTree.getTagNode("GridRow@" + diff.sideKey);
                sideRowKey = tagNode.getPrimaryKey().substring(tagNode.getPrimaryKey().indexOf("@") + 1);
            }
            int index = XmlDiffProcessor.compIndex(gridRows, sideRowKey);
            if (diff.insertAfter) {
                if (index == 0) {
                    gridRows.add(index, collNode);
                    continue;
                }
                gridRows.add(index + 1, collNode);
                continue;
            }
            gridRows.add(index - 1, collNode);
        }
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        int startLine = xmlTree.xmlTree.getLineByIndex(parentNode.getElement().getBgIndex());
        String orgXmlFragment = xmlTree.xmlTree.getNodeString(startLine);
        String newXmlFragment = DesignIOMetaUtil.getXml(parentNode);
        if (diff.getOrgXmlFragment() != null && diff.getNewXmlFragment() != null) {
            diff.setXmlDiff2(xmlTree, startLine, orgXmlFragment, newXmlFragment);
        } else {
            diff.setXmlDiff(xmlTree, startLine, orgXmlFragment, newXmlFragment);
        }
    }

    private static void mergeSonGridNewDiff(TagNode parentNode, Diff diff) throws Throwable {
        MetaForm metaForm = diff.getMetaForm();
        String sideKey = diff.sideKey;
        String controlType = ControlType.toString((Integer)diff.getControlType());
        TagNode parent = parentNode.getParent();
        TagNode per = parent.getParent();
        List<AbstractNode> parentChildren = per.getChildren();
        TagNode tempNode = parentNode;
        int statisticsRowIndex = 0;
        TagNode tableNode = null;
        String rowSideKey = "";
        boolean flag = false;
        boolean isNew = false;
        int order = 0;
        while (!"Grid".equalsIgnoreCase(tempNode.getParent().getTagName())) {
            tempNode = tempNode.getParent();
        }
        TagNode gridNode = tempNode.getParent();
        List<AbstractNode> nodeList = gridNode.getChildren();
        TagNode childByTagName = gridNode.getOrCreateChildByTagName("GridColumnCollection");
        TagNode rowNode = null;
        if (diff.getMetaObjectType() == MetaObjectType.gridField) {
            String tableKey;
            List<AbstractNode> children = parentNode.getChildren();
            TagNode collNode = null;
            if (children.size() == 0) {
                collNode = new TagNode("GridColumnCollection", null);
                children.add(collNode);
                isNew = true;
            }
            for (AbstractNode abstractNode : parentChildren) {
                List<AbstractNode> columns;
                String tagName;
                if (!(abstractNode instanceof TagNode) || !"GridColumnCollection".equals(tagName = ((TagNode)abstractNode).getTagName())) continue;
                if (collNode != null) {
                    columns = collNode.getChildren();
                } else {
                    collNode = parentNode;
                    columns = parentNode.getOrCreateChildByTagName("GridColumnCollection").getChildren();
                }
                TagNode node = new TagNode("GridColumn", null);
                node.setAttribute("Key", diff.getKey());
                node.setAttribute("Caption", diff.caption);
                node.setAttribute("Width", "80px");
                node.setParent(collNode);
                tableKey = gridNode.getOrCreateChildByTagName("GridRowCollection").getOrCreateChildByTagName("GridRow").getAttributes().get("TableKey");
                tableNode = diff.getDataObjectXmlTree() != null ? diff.getDataObjectXmlTree().xmlTree.getTagNode("Table@" + tableKey) : diff.getXmlTree().xmlTree.getTagNode("Table@" + tableKey);
                if (tableKey != null && tableKey.length() != 0 && !tableKey.contains("_NODB") && tableNode != null && !"Button".equals(controlType) && "true".equalsIgnoreCase(diff.getReserveTwo())) {
                    TagNode newColumnNode = new TagNode("Column", null);
                    newColumnNode.setAttribute("Key", diff.getReserveThree());
                    newColumnNode.setAttribute("Caption", diff.caption);
                    if (StringUtils.isEmpty((CharSequence)diff.getDataElementKey())) {
                        newColumnNode.setAttribute("DataType", XmlDiffProcessor.getDatatype(diff.getControlType()));
                    } else {
                        newColumnNode.setAttribute("DataElementKey", diff.getDataElementKey());
                    }
                    if ("Varchar".equalsIgnoreCase(XmlDiffProcessor.getDatatype(diff.getControlType()))) {
                        newColumnNode.setAttribute("Length", "255");
                    }
                    String key = metaForm.getDataSource().getDataObject().getKey();
                    String extendKey = metaForm.getExtend();
                    MetaFormProfile metaFormProfile = (MetaFormProfile)MetaFactory.getGlobalInstance().getMetaFormList().get(metaForm.getKey());
                    if (metaFormProfile == null) {
                        metaFormProfile = (MetaFormProfile)MetaFactory.getGlobalInstance().getExtFormList().get(metaForm.getKey());
                    }
                    Boolean mergeToSource = metaFormProfile.getMergeToSource();
                    if (!key.equals(extendKey) || mergeToSource.booleanValue()) {
                        tableNode.addNode(newColumnNode);
                    }
                    if (diff.getDataObjectXmlTree() != null) {
                        XmlDiffProcessor.genXmlDiff(diff.getDataObjectXmlTree(), tableNode, diff, false);
                    } else {
                        XmlDiffProcessor.genXmlDiff(diff.getXmlTree(), tableNode, diff, false);
                    }
                }
                if (!isNew) {
                    statisticsRowIndex = XmlDiffProcessor.statisticsRowIndex(childByTagName, sideKey, parentNode);
                }
                if (isNew) {
                    columns.add(node);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)sideKey)) {
                    columns.add(columns.size() - 1, node);
                    continue;
                }
                columns.add(columns.size() - 2, node);
            }
            for (AbstractNode node : nodeList) {
                if (!(node instanceof TagNode) || !"GridRowCollection".equalsIgnoreCase(((TagNode)node).getTagName())) continue;
                rowNode = (TagNode)node;
                break;
            }
            List<AbstractNode> gridRows = rowNode.getChildren();
            int index = 0;
            block3: for (AbstractNode gridRow : gridRows) {
                List<AbstractNode> rows;
                String name;
                if (!(gridRow instanceof TagNode) || !"GridRow".equals(name = ((TagNode)gridRow).getTagName())) continue;
                if (collNode.getChildren().size() > 1) {
                    if (!flag) {
                        tableKey = ((TagNode)gridRow).getAttributes().get("TableKey");
                        rows = ((TagNode)gridRow).getChildren();
                        TagNode node = new TagNode("GridCell", null);
                        node.setAttribute("Key", diff.getKey());
                        node.setAttribute("Caption", diff.caption);
                        node.setAttribute("CellType", controlType);
                        if ("Dict".equalsIgnoreCase(controlType) || "DynamicDict".equals(controlType)) {
                            if (!StringUtils.isNotEmpty((CharSequence)diff.getItemKey())) {
                                throw new Throwable("ItemKey\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
                            }
                            node.setAttribute("ItemKey", diff.getItemKey());
                            XmlDiffProcessor.codeAndNameWithDictComponent(diff, diff.getReserveThree(), tableKey, node);
                            if (diff.getDataObjectXmlTree() != null) {
                                XmlDiffProcessor.genXmlDiff(diff.getDataObjectXmlTree(), tableNode, diff, false);
                            } else {
                                XmlDiffProcessor.genXmlDiff(diff.getXmlTree(), tableNode, diff, false);
                            }
                        } else if ("ComboBox".equalsIgnoreCase(controlType)) {
                            node.setAttribute("Cache", "false");
                        }
                        if (tableKey != null && tableKey.length() != 0 && !tableKey.contains("_NODB") && !"Button".equals(controlType) && "true".equalsIgnoreCase(diff.getReserveTwo())) {
                            String key = metaForm.getDataSource().getDataObject().getKey();
                            String extendKey = metaForm.getExtend();
                            MetaFormProfile metaFormProfile = (MetaFormProfile)MetaFactory.getGlobalInstance().getMetaFormList().get(metaForm.getKey());
                            if (metaFormProfile == null) {
                                metaFormProfile = (MetaFormProfile)MetaFactory.getGlobalInstance().getExtFormList().get(metaForm.getKey());
                            }
                            Boolean mergeToSource = metaFormProfile.getMergeToSource();
                            if (!key.equals(extendKey) || mergeToSource.booleanValue()) {
                                TagNode NewdtbNode = new TagNode("DataBinding", null);
                                NewdtbNode.setAttribute("ColumnKey", diff.getReserveThree());
                                node.addNode(NewdtbNode);
                            }
                        }
                        node.setParent((TagNode)gridRow);
                        index = XmlDiffProcessor.compIndex(rows, rowSideKey);
                        if (isNew) {
                            rows.add(node);
                        } else if (diff.insertAfter) {
                            if (index == 0) {
                                rows.add(statisticsRowIndex * 2, node);
                            } else {
                                rows.add((statisticsRowIndex + 1) * 2, node);
                            }
                        } else {
                            rows.add((statisticsRowIndex - 1) * 2, node);
                        }
                        flag = true;
                        continue;
                    }
                    List<AbstractNode> rows2 = ((TagNode)gridRow).getChildren();
                    String nameId = ((TagNode)gridRow).getAttributes().get("RowType");
                    if (!StringUtils.isNotEmpty((CharSequence)nameId)) {
                        nameId = "Detail";
                    }
                    TagNode node = new TagNode("GridCell", null);
                    node.setAttribute("Key", String.valueOf(nameId) + diff.getKey() + order);
                    node.setParent((TagNode)gridRow);
                    if (isNew) {
                        rows2.add(node);
                    } else if (diff.insertAfter) {
                        if (index == 0) {
                            rows2.add(statisticsRowIndex * 2, node);
                        } else {
                            rows2.add((statisticsRowIndex + 1) * 2, node);
                        }
                    } else {
                        rows2.add((statisticsRowIndex - 1) * 2, node);
                    }
                    ++order;
                    continue;
                }
                tableKey = ((TagNode)gridRow).getAttributes().get("TableKey");
                rows = ((TagNode)gridRow).getChildren();
                int i = 0;
                while (i < rows.size()) {
                    if (rows.get(i) instanceof TagNode && ((TagNode)rows.get(i)).getAttributes().get("Key").equals(diff.parentKey)) {
                        TagNode node = (TagNode)rows.get(i);
                        node.setAttribute("Key", diff.getKey());
                        node.setAttribute("Caption", diff.caption);
                        node.setAttribute("CellType", controlType);
                        if (node.hasChildren()) {
                            node.getChildren().clear();
                        }
                        if ("Dict".equalsIgnoreCase(controlType) || "DynamicDict".equals(controlType)) {
                            if (!StringUtils.isNotEmpty((CharSequence)diff.getItemKey())) {
                                throw new Throwable("ItemKey\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
                            }
                            node.setAttribute("ItemKey", diff.getItemKey());
                            XmlDiffProcessor.codeAndNameWithDictComponent(diff, diff.getReserveThree(), tableKey, node);
                            if (diff.getDataObjectXmlTree() != null) {
                                XmlDiffProcessor.genXmlDiff(diff.getDataObjectXmlTree(), tableNode, diff, false);
                            } else {
                                XmlDiffProcessor.genXmlDiff(diff.getXmlTree(), tableNode, diff, false);
                            }
                        } else if ("ComboBox".equalsIgnoreCase(controlType)) {
                            node.setAttribute("Cache", "false");
                        }
                        if (tableKey == null || tableKey.length() == 0 || tableKey.contains("_NODB") || "Button".equals(controlType) || !"true".equalsIgnoreCase(diff.getReserveTwo())) continue block3;
                        String key = metaForm.getDataSource().getDataObject().getKey();
                        String extendKey = metaForm.getExtend();
                        MetaFormProfile metaFormProfile = (MetaFormProfile)MetaFactory.getGlobalInstance().getMetaFormList().get(metaForm.getKey());
                        if (metaFormProfile == null) {
                            metaFormProfile = (MetaFormProfile)MetaFactory.getGlobalInstance().getExtFormList().get(metaForm.getKey());
                        }
                        Boolean mergeToSource = metaFormProfile.getMergeToSource();
                        if (key.equals(extendKey) && !mergeToSource.booleanValue()) continue block3;
                        TagNode NewdtbNode = new TagNode("DataBinding", null);
                        NewdtbNode.setAttribute("ColumnKey", diff.getReserveThree());
                        node.addNode(NewdtbNode);
                        continue block3;
                    }
                    ++i;
                }
            }
        }
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        int startLine = xmlTree.xmlTree.getLineByIndex(gridNode.getElement().getBgIndex());
        String orgXmlFragment = xmlTree.xmlTree.getNodeString(startLine);
        String newXmlFragment = DesignIOMetaUtil.getXml(gridNode);
        if (diff.getOrgXmlFragment() != null && diff.getNewXmlFragment() != null) {
            diff.setXmlDiff2(xmlTree, startLine, orgXmlFragment, newXmlFragment);
        } else {
            diff.setXmlDiff(xmlTree, startLine, orgXmlFragment, newXmlFragment);
        }
    }

    private static void setBasicProperty(TagNode node, Diff diff) {
        node.setAttribute("Key", diff.getKey());
        node.setAttribute("Caption", diff.caption);
        node.setAttribute("X", diff.x != null ? diff.x.toString() : "0");
        node.setAttribute("Y", diff.y != null ? diff.y.toString() : "0");
    }

    private static Integer getRowDefIndex(List<AbstractNode> children) {
        for (AbstractNode abstractNode : children) {
            String tagName;
            if (!(abstractNode instanceof TagNode) || !"RowDefCollection".equals(tagName = ((TagNode)abstractNode).getTagName())) continue;
            return children.indexOf(abstractNode);
        }
        return null;
    }

    public static TagNode SetGridLayoutPanel(Diff diff, MetaForm metaForm, int anInt) throws Throwable {
        TagNode gridLayoutNode = new TagNode("GridLayoutPanel", null);
        if (diff.getMetaObjectType() == MetaObjectType.panel || diff.getMetaObjectType() == MetaObjectType.EmbedPanel) {
            gridLayoutNode.setAttribute("Key", diff.getKey());
            gridLayoutNode.setAttribute("Caption", diff.caption);
        } else if (diff.getMetaObjectType() == MetaObjectType.subDetail) {
            gridLayoutNode.setAttribute("Key", "tempGridLayoutPanel" + anInt);
            gridLayoutNode.setAttribute("Caption", "tempGridLayoutPanel" + anInt);
        }
        if (diff.x != null && diff.y != null) {
            gridLayoutNode.setAttribute("X", diff.x.toString());
            gridLayoutNode.setAttribute("Y", diff.y.toString());
        }
        gridLayoutNode.setAttribute("Padding", "16px");
        TagNode rows = new TagNode("RowDefCollection", null);
        rows.setAttribute("RowGap", "24");
        rows.setAttribute("RowHeight", "30");
        String cellList = diff.getCellList();
        JSONArray cellArrays = null;
        if (StringUtils.isNotEmpty((CharSequence)cellList)) {
            cellArrays = new JSONArray(cellList);
        }
        if (cellArrays != null) {
            int rowCount = (int)Math.ceil((double)cellArrays.length() / 3.0);
            if (rowCount < 4) {
                rowCount = 3;
            }
            int i = 0;
            while (i < rowCount) {
                TagNode rowDef = new TagNode("RowDef", null);
                rows.addNode(rowDef);
                ++i;
            }
        } else {
            int i = 0;
            while (i < 3) {
                TagNode rowDef = new TagNode("RowDef", null);
                rows.addNode(rowDef);
                ++i;
            }
        }
        TagNode cols = new TagNode("ColumnDefCollection", null);
        cols.setAttribute("ColumnGap", "16");
        int i = 1;
        while (i < 4) {
            TagNode col = new TagNode("ColumnDef", null);
            if (i == 3) {
                col.setAttribute("Width", "34%");
            } else {
                col.setAttribute("Width", "33%");
            }
            cols.addNode(col);
            ++i;
        }
        TagNode endCols = new TagNode("ColumnDefCollection", null);
        TagNode endRows = new TagNode("RowDefCollection", null);
        rows.addNode(endRows);
        cols.addNode(endCols);
        if (StringUtils.isNotEmpty((CharSequence)cellList)) {
            int rowIndex = 0;
            int i2 = 1;
            while (i2 <= cellArrays.length()) {
                JSONObject cell = cellArrays.getJSONObject(i2 - 1);
                String columnKey = cell.getString("ColumnKey");
                String fieldKey = cell.getString("Key");
                String caption = cell.getString("ColumnName");
                String controlType = cell.getString("ControlType");
                String dataElementKey = cell.getString("DataElementKey");
                TagNode control = new TagNode(controlType, null);
                control.setAttribute("Key", fieldKey);
                control.setAttribute("Caption", caption);
                control.setAttribute("Y", String.valueOf(rowIndex));
                control.setAttribute("X", String.valueOf((i2 - 1) % 3));
                if (StringUtils.isNotEmpty((CharSequence)dataElementKey)) {
                    XmlDiffProcessor.addDomainPropertyToNode(control, controlType, dataElementKey);
                }
                if (i2 % 3 == 0) {
                    ++rowIndex;
                }
                TagNode dataBinding = new TagNode("DataBinding", null);
                dataBinding.setAttribute("TableKey", diff.associatedTable);
                dataBinding.setAttribute("ColumnKey", columnKey);
                control.addNode(dataBinding);
                if ("NumberEditor".equalsIgnoreCase(controlType)) {
                    TagNode format = new TagNode("Format", null);
                    format.setAttribute("HAlign", "Right");
                    control.addNode(format);
                }
                gridLayoutNode.addNode(control);
                ++i2;
            }
        }
        gridLayoutNode.addNode(rows);
        gridLayoutNode.addNode(cols);
        return gridLayoutNode;
    }

    private static TagNode setGrid(MetaForm metaForm, TagNode parentNode, Diff diff) throws Throwable {
        AbstractMetaObject metaObjectColumnByKey;
        MetaGridCell metaGridCell;
        MetaComponent componentByKey;
        JSONObject column;
        int i;
        JSONArray cellArrays;
        int anInt = 1;
        IDLookup idLookup = IDLookup.reloadIDLookup(metaForm);
        StringHashMap<MetaGridColumn> allGridColumn = idLookup.getAllFieldKey2MetaGridColumnInfo();
        while (allGridColumn.containsKey((Object)("IsSelect" + anInt))) {
            ++anInt;
        }
        TagNode tabNode = new TagNode(MetaObjectType.grid.name, null);
        String parentTagName = parentNode.getTagName();
        if ("GridLayoutPanel".equals(parentTagName) && diff.getMetaObjectType() != MetaObjectType.subDetail) {
            if (diff.x != null && diff.y != null) {
                tabNode.setAttribute("X", diff.x.toString());
                tabNode.setAttribute("Y", diff.y.toString());
            } else {
                tabNode.setAttribute("X", "0");
                tabNode.setAttribute("Y", "0");
            }
        }
        if (diff.getMetaObjectType() == MetaObjectType.grid) {
            tabNode.setAttribute("Key", diff.getKey());
            tabNode.setAttribute("Caption", diff.caption);
        } else if (diff.getMetaObjectType() == MetaObjectType.subDetail) {
            tabNode.setAttribute("Key", "SubGrid" + anInt);
            tabNode.setAttribute("Caption", "SubGrid" + anInt);
        }
        String associatedTable = diff.associatedTable;
        tabNode.setAttribute("ShowRowHead", "true");
        tabNode.setAttribute("SerialSeq", "true");
        tabNode.setAttribute("Option", "insert,delete,shift,bestWidth");
        TagNode colsNode = new TagNode("GridColumnCollection", null);
        TagNode colSelectNode = new TagNode("GridColumn", null);
        colSelectNode.setAttribute("Key", "IsSelect" + anInt);
        colSelectNode.setAttribute("Caption", "\u9009\u62e9");
        colSelectNode.setAttribute("Width", "80px");
        TagNode rowsNode = new TagNode("GridRowCollection", null);
        TagNode gridRowNode = new TagNode("GridRow", null);
        gridRowNode.setAttribute("Key", "row" + anInt);
        if (associatedTable != null) {
            if (!associatedTable.isEmpty()) {
                gridRowNode.setAttribute("TableKey", associatedTable);
            }
        } else if (!StringUtils.isBlank((CharSequence)diff.subAssociatedTable)) {
            gridRowNode.setAttribute("TableKey", diff.subAssociatedTable);
        }
        TagNode selectGridCellNode = new TagNode("GridCell", null);
        selectGridCellNode.setAttribute("Key", "IsSelect" + anInt);
        selectGridCellNode.setAttribute("Caption", "\u9009\u62e9");
        selectGridCellNode.setAttribute("CellType", "CheckBox");
        selectGridCellNode.setAttribute("IsSelect", "true");
        TagNode endGridRow = new TagNode("GridRow", null);
        TagNode endRows = new TagNode("GridRowCollection", null);
        TagNode endcols = new TagNode("GridColumnCollection", null);
        TagNode endGrid = new TagNode("Grid", null);
        colsNode.addNode(colSelectNode);
        if (diff.getCreate() != null && "1".equals(diff.getCreate()) && StringUtils.isNotEmpty((CharSequence)diff.getCellList())) {
            cellArrays = new JSONArray(diff.getCellList());
            i = 0;
            while (i < cellArrays.length()) {
                block33: {
                    column = cellArrays.getJSONObject(i);
                    String fieldKey = column.getString("Key");
                    if (!("OID".equals(fieldKey) || "POID".equals(fieldKey) || "SOID".equals(fieldKey) || "VERID".equals(fieldKey) || "DVERID".equals(fieldKey) || "MapCount".equals(fieldKey) || "SelectField".equals(fieldKey) || fieldKey.contains("_NODB") || "Sequence".equals(fieldKey) || "EOID".equals(fieldKey) || "ESOID".equals(fieldKey) || "EPOID".equals(fieldKey))) {
                        String caption = column.getString("ColumnName");
                        componentByKey = null;
                        metaGridCell = null;
                        metaObjectColumnByKey = idLookup.getMetaObjectColumnByKey(fieldKey);
                        if (metaObjectColumnByKey instanceof MetaComponent) {
                            componentByKey = (MetaComponent)metaObjectColumnByKey;
                        }
                        if (Objects.isNull(componentByKey)) {
                            metaGridCell = idLookup.getGridCellByKey(fieldKey);
                        }
                        if (componentByKey == null && metaGridCell == null) {
                            block32: {
                                try {
                                    String resource = LoadFileTree.getPathByFormKey(metaForm.getKey());
                                    XmlTreeWithPath parse = XmlTreeWithPath.parseFilePath(resource);
                                    int haveRelyOn = associatedTable != null ? XmlDiffProcessor.isHaveRelyOn(fieldKey, parse.xmlTree, associatedTable) : XmlDiffProcessor.isHaveRelyOn(fieldKey, parse.xmlTree, diff.subAssociatedTable);
                                    if (haveRelyOn == 0) break block32;
                                    break block33;
                                }
                                catch (Throwable e) {
                                    LogSvr.getInstance().error("", e);
                                }
                            }
                            TagNode colDeleteNode1 = new TagNode("GridColumn", null);
                            colDeleteNode1.setAttribute("Key", fieldKey);
                            if (StringUtils.isNotEmpty((CharSequence)caption)) {
                                colDeleteNode1.setAttribute("Caption", caption);
                            } else {
                                colDeleteNode1.setAttribute("Caption", fieldKey);
                            }
                            colDeleteNode1.setAttribute("Width", "80px");
                            colsNode.addNode(colDeleteNode1);
                        }
                    }
                }
                ++i;
            }
        }
        colsNode.addNode(endcols);
        gridRowNode.addNode(selectGridCellNode);
        if (diff.getCreate() != null && "1".equals(diff.getCreate()) && StringUtils.isNotEmpty((CharSequence)diff.getCellList())) {
            cellArrays = new JSONArray(diff.getCellList());
            i = 0;
            while (i < cellArrays.length()) {
                block35: {
                    column = cellArrays.getJSONObject(i);
                    String columnKey = column.getString("Key");
                    String fieldKey = column.getString("Key");
                    if (!("OID".equals(fieldKey) || "POID".equals(fieldKey) || "SOID".equals(fieldKey) || "VERID".equals(fieldKey) || "DVERID".equals(fieldKey) || "MapCount".equals(fieldKey) || "SelectField".equals(fieldKey) || fieldKey.contains("_NODB") || "Sequence".equals(fieldKey) || "EOID".equals(fieldKey) || "ESOID".equals(fieldKey) || "EPOID".equals(fieldKey))) {
                        componentByKey = null;
                        metaGridCell = null;
                        metaObjectColumnByKey = idLookup.getMetaObjectColumnByKey(fieldKey);
                        if (metaObjectColumnByKey instanceof MetaComponent) {
                            componentByKey = (MetaComponent)metaObjectColumnByKey;
                        }
                        if (Objects.isNull(componentByKey)) {
                            metaGridCell = idLookup.getGridCellByKey(fieldKey);
                        }
                        if (componentByKey == null && metaGridCell == null) {
                            String caption;
                            block34: {
                                caption = column.getString("ColumnName");
                                try {
                                    String resource = LoadFileTree.getPathByFormKey(metaForm.getKey());
                                    XmlTreeWithPath parse = XmlTreeWithPath.parseFilePath(resource);
                                    int haveRelyOn = associatedTable != null ? XmlDiffProcessor.isHaveRelyOn(fieldKey, parse.xmlTree, associatedTable) : XmlDiffProcessor.isHaveRelyOn(fieldKey, parse.xmlTree, diff.subAssociatedTable);
                                    if (haveRelyOn == 0) break block34;
                                    break block35;
                                }
                                catch (Throwable e) {
                                    LogSvr.getInstance().error("", e);
                                }
                            }
                            TagNode deleteGridCellNode1 = new TagNode("GridCell", null);
                            deleteGridCellNode1.setAttribute("Key", fieldKey);
                            if (StringUtils.isNotEmpty((CharSequence)caption)) {
                                deleteGridCellNode1.setAttribute("Caption", caption);
                            } else {
                                deleteGridCellNode1.setAttribute("Caption", fieldKey);
                            }
                            String type = column.getString("ControlType");
                            String dataElementKey = column.getString("DataElementKey");
                            deleteGridCellNode1.setAttribute("CellType", type);
                            if (StringUtils.isNotEmpty((CharSequence)dataElementKey)) {
                                deleteGridCellNode1 = XmlDiffProcessor.addDomainPropertyToNode(deleteGridCellNode1, type, dataElementKey);
                            }
                            TagNode dataBindNode1 = new TagNode("DataBinding", null);
                            dataBindNode1.setAttribute("ColumnKey", columnKey);
                            deleteGridCellNode1.addNode(dataBindNode1);
                            gridRowNode.addNode(deleteGridCellNode1);
                        }
                    }
                }
                ++i;
            }
        }
        gridRowNode.addNode(endGridRow);
        rowsNode.addNode(gridRowNode);
        rowsNode.addNode(endRows);
        tabNode.addNode(colsNode);
        tabNode.addNode(rowsNode);
        tabNode.addNode(endGrid);
        return tabNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void mergeDiff(MetaForm metaForm, Diff diff, Document document) throws Throwable {
        MetaObjectType metaObjectType;
        XmlTreeWithPath xmlTree;
        block329: {
            MetaFormProfile metaFormProfile;
            block325: {
                TagNode bodyNode;
                block328: {
                    block326: {
                        xmlTree = diff.getXmlTree();
                        metaObjectType = diff.getMetaObjectType();
                        metaFormProfile = (MetaFormProfile)MetaFactory.getGlobalInstance().getMetaFormList().get(metaForm.getKey());
                        if (metaFormProfile == null) {
                            metaFormProfile = (MetaFormProfile)MetaFactory.getGlobalInstance().getExtFormList().get(metaForm.getKey());
                        }
                        if (metaObjectType == MetaObjectType.dataSource) {
                            if (StringUtils.isNotEmpty((CharSequence)diff.tableKey) || StringUtils.isNotEmpty((CharSequence)diff.subTableKey)) {
                                String key = metaForm.getDataSource().getDataObject().getKey();
                                String extendKey = metaForm.getExtend();
                                Boolean mergeToSource = metaFormProfile.getMergeToSource();
                                if (key.equals(extendKey) && !mergeToSource.booleanValue()) {
                                    throw new RuntimeException("warning: \u5f53\u524d\u8868\u5355\u4e3a\u9a6c\u7532\u4e0d\u652f\u6301\u521b\u5efa\u65b0\u7684\u8868!");
                                }
                                if (key.equals(extendKey) && mergeToSource.booleanValue()) {
                                    TagNode tagNode = diff.tableKey != null && !"".equals(diff.tableKey) ? XmlDiffProcessor.modifyDataSource(diff, diff.tableKey, diff.tableName) : XmlDiffProcessor.modifyDataSource(diff, diff.subTableKey, diff.subTableName);
                                    XmlDiffProcessor.genXmlDiff(xmlTree, tagNode, diff, true);
                                    return;
                                } else {
                                    TagNode tagNode = diff.tableKey != null && !"".equals(diff.tableKey) ? XmlDiffProcessor.modifyDataSource(diff, diff.tableKey, diff.tableName) : XmlDiffProcessor.modifyDataSource(diff, diff.subTableKey, diff.subTableName);
                                    XmlDiffProcessor.genXmlDiff(xmlTree, tagNode, diff, true);
                                }
                                return;
                            } else {
                                DataTable headTable = document.get("ED_DataObjectHead");
                                DataTable collecTable = document.get("ED_TableCollection");
                                DataTable fieldTable = document.get("ED_TableFields");
                                DataTable ed_parameterCollection = document.get("ED_ParameterCollection");
                                DataTable ed_indexCollection = document.get("ED_IndexCollection");
                                XmlDiffProcessor.dealHeadTable(xmlTree, headTable, collecTable, fieldTable, ed_parameterCollection, ed_indexCollection, diff);
                                XmlDiffProcessor.dealEmbedTable(xmlTree, document, diff);
                                XmlDiffProcessor.dealEventTable(xmlTree, document, diff);
                            }
                            return;
                        }
                        if (metaObjectType == MetaObjectType.DataObject) {
                            DataTable headTable = document.get("ED_DataObjectFormHead");
                            DataTable collecTable = document.get("ED_DataObjectCollection");
                            DataTable fieldTable = document.get("ED_DataObjectField");
                            DataTable ed_parameterCollection = document.get("ED_ParameterCollection");
                            DataTable ed_indexCollection = document.get("ED_IndexCollection");
                            XmlDiffProcessor.dealHeadTable(xmlTree, headTable, collecTable, fieldTable, ed_parameterCollection, ed_indexCollection, diff);
                            return;
                        }
                        if (metaObjectType == MetaObjectType.fieldCondition) {
                            DataTable headTable = document.get("ED_ConditionHead");
                            DataTable cuscollTable = document.get("ED_ConditionCollection");
                            DataTable tarCollTable = document.get("ED_ConditionTargetCollection");
                            DataTable customConditionPara = document.get("ED_CustomConditionPara");
                            String xmlTreeKey = String.valueOf(ControlType.toString((Integer)diff.getControlType())) + "@" + diff.getKey();
                            TagNode fieldNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
                            XmlDiffProcessor.dealHeadCondition(xmlTree, headTable, cuscollTable, tarCollTable, fieldNode, diff, fieldNode, customConditionPara);
                            return;
                        }
                        if (metaObjectType == MetaObjectType.ItemFilter) {
                            String controlerType = null;
                            String primaryKey = null;
                            DataTable headTable = document.get("ED_DictFilter");
                            DataTable detailTable = document.get("ED_DictFilterValue");
                            DataTable dictItem = document.get("ED_DictItem");
                            MetaItemFilterProcess.dealDictField(xmlTree, controlerType, primaryKey, headTable, detailTable, dictItem, diff);
                            return;
                        }
                        if (metaObjectType == MetaObjectType.ColumnExpand) {
                            TagNode tagNode = xmlTree.xmlTree.getTagNode("GridColumn@" + diff.getKey().substring(7));
                            if (Objects.isNull(tagNode)) {
                                tagNode = xmlTree.xmlTree.getTagNode("GridColumn@" + diff.properties.get((int)0).orgValue.substring(7));
                            }
                            DataTable headTable = document.get("ED_ColumnExpand");
                            XmlDiffProcessor.dealColumnExpand(headTable, xmlTree, diff, tagNode);
                            return;
                        }
                        if (metaObjectType == MetaObjectType.DropdownButton) {
                            DataTable detailTable = document.get("ED_DropdownButton");
                            String xmlTreeKey = "DropdownButton@" + diff.getKey();
                            TagNode fieldNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
                            XmlDiffProcessor.dealDropdownButton(xmlTree, fieldNode, detailTable, diff);
                            return;
                        }
                        if (metaObjectType == MetaObjectType.TraceCollection) {
                            DataTable table = document.get("ED_TraceCollection");
                            XmlDiffProcessor.dealTraceCollection(xmlTree, diff, table, metaForm);
                            return;
                        }
                        if (metaObjectType == MetaObjectTypeDefine.QueryDef) {
                            metaObjectType.mergeDiff(metaForm, diff, document);
                            return;
                        }
                        if (metaObjectType == MetaObjectTypeDefine.IndicatorSetting) {
                            DataTable propertyTable;
                            TagNode tableRowNode = xmlTree.xmlTree.getTagNode("TableRow@" + diff.getKey());
                            if (tableRowNode != null && (propertyTable = document.get("ED_IndicatorSetting")) != null && propertyTable.first()) {
                                String indicator = propertyTable.getString("Indicator");
                                String indicatorKey = propertyTable.getString("IndicatorKey");
                                tableRowNode.setAttribute("Indicator", indicator);
                                tableRowNode.setAttribute("IndicatorKey", indicatorKey);
                            }
                            XmlDiffProcessor.genXmlDiff(xmlTree, tableRowNode, diff, true);
                            return;
                        }
                        if (metaObjectType == MetaObjectTypeDefine.ComBoBoxSourceSetting) {
                            XmlDiffProcessor.dealComboBoxSourceSetting(xmlTree, diff, document, metaForm);
                            return;
                        }
                        if (metaObjectType == MetaObjectTypeDefine.CarouselSourceSetting) {
                            XmlDiffProcessor.dealCarouselSourceSetting(xmlTree, diff, document, metaForm);
                            return;
                        }
                        if (metaObjectType == MetaObjectTypeDefine.RefreshFooterSetting) {
                            XmlDiffProcessor.dealRefreshFooterSetting(xmlTree, diff, document, metaForm);
                            return;
                        }
                        if (metaObjectType == MetaObjectTypeDefine.RefreshHeaderSetting) {
                            XmlDiffProcessor.dealRefreshHeaderSetting(xmlTree, diff, document, metaForm);
                            return;
                        }
                        if (metaObjectType == MetaObjectTypeDefine.PriceLabelItemSetting) {
                            XmlDiffProcessor.dealPriceLabelItemSetting(xmlTree, diff, document, metaForm);
                            return;
                        }
                        if (metaObjectType == MetaObjectType.ExtOptCollection) {
                            DataTable table = document.get("ED_ExtOptCollection");
                            XmlDiffProcessor.dealExtOptCollection(xmlTree, diff, table, metaForm);
                            return;
                        }
                        if (metaObjectType == MetaObjectType.RowActionCollection) {
                            DataTable table = document.get("ED_RowActionCollection");
                            XmlDiffProcessor.dealRowActionCollection(xmlTree, diff, table, metaForm);
                            return;
                        }
                        if (metaObjectType == MetaObjectType.EditViewItemCollection) {
                            XmlDiffProcessor.dealEditViewItemCollectionSetting(xmlTree, diff, document, metaForm);
                            return;
                        }
                        if (metaObjectType == MetaObjectType.Fieldinformation) {
                            XmlDiffProcessor.handleFieldinformation(diff, xmlTree);
                            return;
                        }
                        if (metaObjectType == MetaObjectType.Separate) {
                            DataTable Table = document.get("ED_Separate");
                            XmlDiffProcessor.dealSeparate(xmlTree, Table, diff);
                            return;
                        }
                        if (metaObjectType == MetaObjectType.form) {
                            XmlDiffProcessor.dealForm(diff, xmlTree);
                            return;
                        }
                        if (metaObjectType == MetaObjectType.comboBoxType) {
                            DataTable comboBoxDetail = document.get("ED_ComboBoxDetail");
                            XmlDiffProcessor.dealComboBox(xmlTree, comboBoxDetail, diff);
                            return;
                        }
                        if (metaObjectType == MetaObjectType.GridRowTree) {
                            DataTable gridRowTree = document.get("ED_GridTreeProperties");
                            XmlDiffProcessor.dealGridRowTree(xmlTree, gridRowTree, diff);
                            return;
                        }
                        if (metaObjectType == MetaObjectType.UICheckRule) {
                            DataTable checkRuleCollection = document.get("ED_UICheckRuleCollection");
                            XmlDiffProcessor.dealCheckRuleCollection(xmlTree, checkRuleCollection, diff);
                            return;
                        }
                        if (metaObjectType == MetaObjectType.DictViewColumn) {
                            DataTable dictDetail = document.get("ED_DictViewColumn");
                            XmlDiffProcessor.dealDictColumn(xmlTree, dictDetail, diff);
                            return;
                        }
                        if (metaObjectType == MetaObjectType.Macro) {
                            DataTable MacroDetail = document.get("ED_MacroFormula");
                            XmlDiffProcessor.dealMacro(xmlTree, MacroDetail, diff);
                            return;
                        }
                        if (metaObjectType == MetaObjectType.Formula) {
                            TagNode tagNode = xmlTree.xmlTree.getTagNode("Macro@" + diff.getKey());
                            CDataNode cDataNode = (CDataNode)tagNode.getChildren().get(1);
                            cDataNode.setText(diff.properties.get((int)0).newValue);
                            XmlDiffProcessor.genXmlDiff(xmlTree, tagNode, diff, true);
                            return;
                        }
                        if (metaObjectType == MetaObjectType.ChartDataSource) {
                            DataTable ChartDataSource = document.get("ED_ChartDataSource");
                            DataTable CategoryDtl = document.get("ED_SeriesDtl");
                            XmlDiffProcessor.dealChartDataSource(xmlTree, ChartDataSource, CategoryDtl, diff);
                            return;
                        }
                        if (metaObjectType != MetaObjectType.Block) break block325;
                        TagNode formNode = xmlTree.xmlTree.getTagNode("Form@" + diff.getMetaForm().getKey());
                        bodyNode = formNode.findFirstTagNodeByTagName("Body");
                        if (!diff.getReserveOne().equals("AddNewBlock")) break block326;
                        TagNode newBlockNode = new TagNode("Block", null);
                        newBlockNode.setAttribute("Key", diff.getKey());
                        newBlockNode.setAttribute("IsRoot", diff.getReserveTwo());
                        bodyNode.addNode(newBlockNode);
                        String rootPanelType = diff.getReserveThree();
                        String popViewRootPanelType = diff.getReserveFour();
                        TagNode panelNode = null;
                        if ("false".equalsIgnoreCase(diff.getReserveTwo()) && "PopView".equalsIgnoreCase(rootPanelType)) {
                            Object popViewNode = new TagNode("PopView", null);
                            ((TagNode)popViewNode).setAttribute("Key", String.valueOf(diff.getKey()) + "_PopView");
                            newBlockNode.addNode((AbstractNode)popViewNode);
                            panelNode = new TagNode(popViewRootPanelType, null);
                            rootPanelType = popViewRootPanelType;
                            ((TagNode)popViewNode).addNode(panelNode);
                        } else {
                            panelNode = new TagNode(rootPanelType, null);
                            newBlockNode.addNode(panelNode);
                        }
                        panelNode.setAttribute("Key", String.valueOf(diff.getKey()) + "_RootPanel");
                        panelNode.setAttribute("Caption", "\u4e3b\u9762\u677f");
                        panelNode.setAttribute("Width", "100%");
                        panelNode.setAttribute("Height", "100%");
                        if (rootPanelType.equals("HoverButton")) {
                            panelNode.setAttribute("Key", String.valueOf(diff.getKey()) + "_hoverbutton");
                            panelNode.setAttribute("Caption", "\u6309\u94ae");
                            panelNode.setAttribute("Width", "40px");
                            panelNode.setAttribute("Height", "40px");
                            panelNode.setAttribute("BorderRadius", "20");
                        }
                        switch (rootPanelType) {
                            case "TabPanel": {
                                TagNode subPanel = new TagNode("FlexFlowLayoutPanel", null);
                                subPanel.setAttribute("Key", String.valueOf(panelNode.getAttributes().get("Key")) + "_SubPanel");
                                subPanel.setAttribute("Caption", "\u9875\u7b7e");
                                subPanel.setAttribute("Width", "100%");
                                subPanel.setAttribute("Height", "100%");
                                panelNode.addNode(subPanel);
                                break;
                            }
                            case "GridLayoutPanel": {
                                TagNode rowDefNodes = new TagNode("RowDefCollection", null);
                                rowDefNodes.setAttribute("RowGap", "5");
                                TagNode rowDef1 = new TagNode("RowDef", null);
                                rowDef1.setAttribute("Height", "30px");
                                rowDefNodes.getChildren().add(rowDef1);
                                TagNode rowDef2 = new TagNode("RowDef", null);
                                rowDef2.setAttribute("Height", "30px");
                                rowDefNodes.getChildren().add(rowDef2);
                                TagNode colDefNodes = new TagNode("ColumnDefCollection", null);
                                colDefNodes.setAttribute("ColumnGap", "5");
                                TagNode colDef1 = new TagNode("ColumnDef", null);
                                colDef1.setAttribute("Width", "10px");
                                colDefNodes.getChildren().add(colDef1);
                                TagNode colDef2 = new TagNode("ColumnDef", null);
                                colDef2.setAttribute("Width", "80px");
                                colDefNodes.getChildren().add(colDef2);
                                TagNode tagNode = new TagNode("ColumnDef", null);
                                tagNode.setAttribute("Width", "100%");
                                colDefNodes.getChildren().add(tagNode);
                                TagNode colDef4 = new TagNode("ColumnDef", null);
                                colDef4.setAttribute("Width", "10px");
                                colDefNodes.getChildren().add(colDef4);
                                panelNode.addNode(rowDefNodes);
                                panelNode.addNode(colDefNodes);
                                break;
                            }
                            case "SlidingLayoutPanel": {
                                TagNode mainPanelNode = new TagNode("FlexFlowLayoutPanel", null);
                                mainPanelNode.setAttribute("Key", String.valueOf(diff.getKey()) + "Main");
                                mainPanelNode.setAttribute("Caption", "\u4e3b\u663e\u793a");
                                mainPanelNode.setAttribute("Padding", "5px");
                                TagNode firstPanelNode = new TagNode("FlexFlowLayoutPanel", null);
                                firstPanelNode.setAttribute("Key", String.valueOf(diff.getKey()) + "Fist");
                                firstPanelNode.setAttribute("Caption", "\u4e3b\u4fa7\u6ed1");
                                TagNode secondPanelNode = new TagNode("FlexFlowLayoutPanel", null);
                                secondPanelNode.setAttribute("Key", String.valueOf(diff.getKey()) + "Second");
                                secondPanelNode.setAttribute("Caption", "\u6b21\u4fa7\u6ed1");
                                panelNode.addNode(mainPanelNode);
                                panelNode.addNode(firstPanelNode);
                                panelNode.addNode(secondPanelNode);
                            }
                        }
                        break block328;
                    }
                    TagNode blockNode = null;
                    for (TagNode tagNode : bodyNode.findNodesByTagName("Block")) {
                        String key = tagNode.getAttributes().get("Key");
                        if (key != null && key.equals(diff.getKey())) {
                            blockNode = tagNode;
                            break;
                        }
                        if (key != null || !diff.getKey().equals("RootBlock")) continue;
                        blockNode = tagNode;
                        break;
                    }
                    if (blockNode != null) {
                        for (DiffProperty property : diff.properties) {
                            String newValue = property.getNewValue();
                            String propertyName = property.property.name;
                            XmlDiffProcessor.setSonNodeProperties(diff, blockNode, propertyName, newValue);
                        }
                    }
                }
                XmlDiffProcessor.genXmlDiff(xmlTree, bodyNode, diff, true);
                return;
            }
            if (metaObjectType != MetaObjectType.field && metaObjectType != MetaObjectType.gridField && metaObjectType != MetaObjectType.GridCellType && metaObjectType != MetaObjectType.panel && metaObjectType != MetaObjectType.D_DictView && metaObjectType != MetaObjectType.subDetail && metaObjectType != MetaObjectType.GridHeadColumn && metaObjectType != MetaObjectType.grid && metaObjectType != MetaObjectType.listViewField && metaObjectType != MetaObjectType.listView && metaObjectType != MetaObjectType.GridRow && metaObjectType != MetaObjectType.toolbar && metaObjectType != MetaObjectType.EditViewColumn && metaObjectType != MetaObjectType.EditViewRootGridLayout && metaObjectType != MetaObjectType.EditViewRootLinearLayout && metaObjectType != MetaObjectType.EditViewChildGridLayout && metaObjectType != MetaObjectType.EditViewChildLinearLayout && metaObjectType != MetaObjectType.EditViewChildFlexFlowLayout && metaObjectType != MetaObjectType.EditViewChildColumnLayout && metaObjectType != MetaObjectType.EditViewChildSplitLayout && metaObjectType != MetaObjectType.EditViewChildTabLayout && metaObjectType != MetaObjectType.EditViewChildFlowLayout && metaObjectType != MetaObjectType.EditViewChildFlexGridLayout) break block329;
            String xmlTreeKey = XmlDiffProcessor.getXmlTreeKey(diff, null, null);
            if (xmlTreeKey.contains(",")) {
                String fPrimary = xmlTreeKey.substring(0, xmlTreeKey.indexOf(","));
                String sPrimary = xmlTreeKey.replace(String.valueOf(fPrimary) + ",", "");
                TagNode coluNode = diff.getTagNode(sPrimary);
                TagNode cellNode = diff.getTagNode(fPrimary);
                for (DiffProperty property : diff.properties) {
                    String orgValue = property.getOrgValue();
                    String newValue = property.getNewValue();
                    String propertyName = property.property.name;
                    Boolean mergeToSource = metaFormProfile.getMergeToSource();
                    String extend = metaFormProfile.getExtend();
                    if (!(Property.caption.name.equalsIgnoreCase(propertyName) || mergeToSource.booleanValue() || extend.isEmpty())) {
                        throw new Throwable("\u7ec4\u4ef6\u7684\u8be5\u5c5e\u6027\u4e0d\u5141\u8bb8\u4fee\u6539");
                    }
                    if (StringUtils.isBlank((CharSequence)orgValue) && StringUtils.isBlank((CharSequence)newValue)) continue;
                    if (metaFormProfile.getPlatform() == 6 && "BuddyKey".equalsIgnoreCase(propertyName)) {
                        coluNode.setAttribute("BuddyKey", newValue);
                        XmlDiffProcessor.genXmlDiff(xmlTree, coluNode, diff, true);
                        return;
                    }
                    if ("GridCell".equalsIgnoreCase(cellNode.getTagName())) {
                        XmlDiffProcessor.setSonNodeProperties(diff, cellNode, propertyName, newValue);
                    } else {
                        XmlDiffProcessor.setSonNodeProperties(diff, cellNode, propertyName, "Inner_" + newValue);
                        XmlDiffProcessor.setSonNodeProperties(diff, coluNode, "BuddyKey", "Inner_" + newValue);
                    }
                    XmlDiffProcessor.setSonNodeProperties(diff, coluNode, propertyName, newValue);
                    if (metaObjectType != MetaObjectType.grid || !"Key".equalsIgnoreCase(propertyName)) continue;
                    TagNode tagNode = XmlDiffProcessor.setNodeKey(newValue, diff);
                    XmlDiffProcessor.genXmlDiff(diff.getXmlTree(), tagNode, diff, true);
                    return;
                }
                TagNode node1 = cellNode != null ? cellNode : coluNode;
                XmlDiffProcessor.genXmlDiff(xmlTree, node1, diff, true);
                if (coluNode == null || cellNode == null || coluNode.getElement() == null || cellNode.getElement() == null) return;
                XmlDiffProcessor.genXmlDiff(xmlTree, coluNode, diff, false);
                return;
            }
            TagNode buddyNode = null;
            TagNode node = diff.getTagNode(xmlTreeKey);
            if (Objects.isNull(node)) {
                if (xmlTreeKey.contains("GridColumn")) {
                    xmlTreeKey = xmlTreeKey.replaceAll("GridColumn", "GridCell");
                    node = xmlTree.xmlTree.getTagNode(xmlTreeKey);
                    if ("Visible".equals(diff.properties.get((int)0).property.toString())) {
                        int index = node.getParent().getChildren().indexOf(node);
                        node = (TagNode)node.getParent().getParent().getParent().getOrCreateChildByTagName("GridColumnCollection").getChildren().get(index);
                    }
                }
                if (Objects.isNull(node)) {
                    throw new Throwable("warning: \u5f53\u524d\u8868\u5355\u7684Xml\u4e2d\u672a\u627e\u5230\u5f53\u524d\u8282\u70b9,\u4e0d\u80fd\u4fee\u6539!!!");
                }
            }
            TagNode tagNode = node.getParent();
            TagNode GridCellNode = null;
            if (xmlTreeKey.contains("GridColumn")) {
                xmlTreeKey = xmlTreeKey.replaceAll("GridColumn", "GridCell");
                GridCellNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
            }
            for (DiffProperty property : diff.properties) {
                block331: {
                    String propertyName;
                    String newValue;
                    String orgValue;
                    block342: {
                        block341: {
                            block340: {
                                String buddyPrimary;
                                String buddyKey;
                                block339: {
                                    block338: {
                                        block337: {
                                            block336: {
                                                TagNode rootLayout;
                                                String compViewKey;
                                                TagNode compViewNode;
                                                block335: {
                                                    block334: {
                                                        block333: {
                                                            block332: {
                                                                block330: {
                                                                    orgValue = property.getOrgValue();
                                                                    newValue = property.getNewValue();
                                                                    if (StringUtils.isBlank((CharSequence)orgValue) && StringUtils.isBlank((CharSequence)newValue) || property.property == Property.ownerPanelKey) continue;
                                                                    propertyName = property.property.name;
                                                                    if (!Property.key.name.equalsIgnoreCase(propertyName)) break block330;
                                                                    XmlDiffProcessor.setSonNodeProperties(diff, node, propertyName, newValue);
                                                                    XmlDiffProcessor.setSonNodeProperties(diff, GridCellNode, propertyName, newValue);
                                                                    break block331;
                                                                }
                                                                if (!Property.columnKey.name.equalsIgnoreCase(propertyName)) break block332;
                                                                newValue = StringUtils.substringBefore((String)newValue, (String)" ");
                                                                Boolean mergeToSource = metaFormProfile.getMergeToSource();
                                                                if (diff.getVestXmlTree() == null || diff.getVestXmlTree().xmlTree.getTagNode(xmlTreeKey) == null || xmlTree.xmlTree.getTagNode(xmlTreeKey) == null || mergeToSource.booleanValue()) {
                                                                    if (metaObjectType == MetaObjectType.gridField || metaObjectType == MetaObjectType.field || metaObjectType == MetaObjectType.EditViewColumn) {
                                                                        XmlDiffProcessor.setColumnKey(metaForm, diff, newValue, propertyName, xmlTree, node, orgValue);
                                                                    } else if (metaObjectType == MetaObjectType.listViewField) {
                                                                        XmlDiffProcessor.setListViewNodeProperty(diff, node, propertyName, newValue);
                                                                    }
                                                                }
                                                                break block331;
                                                            }
                                                            if (!"EditViewRowTopMargin".equalsIgnoreCase(propertyName)) break block333;
                                                            XmlDiffProcessor.setSonNodeProperties(diff, node, "TopMargin", newValue);
                                                            break block331;
                                                        }
                                                        if (!"EditViewRowBackColor".equalsIgnoreCase(propertyName)) break block334;
                                                        XmlDiffProcessor.setSonNodeProperties(diff, node, "BackColor", newValue);
                                                        break block331;
                                                    }
                                                    if (!"EditViewRowHighlightColor".equalsIgnoreCase(propertyName)) break block335;
                                                    XmlDiffProcessor.setSonNodeProperties(diff, node, "HighlightColor", newValue);
                                                    break block331;
                                                }
                                                if (!Property.LayoutType.name.equalsIgnoreCase(propertyName)) break block336;
                                                TagNode editViewNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
                                                if (editViewNode != null && (compViewNode = xmlTree.xmlTree.getTagNode(compViewKey = "ComponentView@" + diff.getKey())) != null && (rootLayout = compViewNode.getChildByKey(diff.getKey())) != null) {
                                                    String string = rootLayout.getTagName();
                                                    if (newValue.equalsIgnoreCase("GridLayout")) {
                                                        if (string.equalsIgnoreCase("LinearLayout")) {
                                                            TagNode gridLayoutNode = new TagNode("GridLayout", null);
                                                            gridLayoutNode.setAttribute("Key", diff.getKey());
                                                            TagNode rowDefNodes = new TagNode("RowDefCollection", null);
                                                            rowDefNodes.setAttribute("RowGap", "5");
                                                            TagNode rowDef1 = new TagNode("RowDef", null);
                                                            rowDef1.setAttribute("Height", "30px");
                                                            TagNode rowDef2 = new TagNode("RowDef", null);
                                                            rowDef2.setAttribute("Height", "30px");
                                                            rowDefNodes.getChildren().add(rowDef1);
                                                            TagNode colDefNodes = new TagNode("ColumnDefCollection", null);
                                                            colDefNodes.setAttribute("ColumnGap", "5");
                                                            TagNode colDef1 = new TagNode("ColumnDef", null);
                                                            colDef1.setAttribute("Width", "100px");
                                                            TagNode colDef2 = new TagNode("ColumnDef", null);
                                                            colDef2.setAttribute("Width", "100%");
                                                            colDefNodes.getChildren().add(colDef1);
                                                            colDefNodes.getChildren().add(colDef2);
                                                            List<AbstractNode> itemNodes = rootLayout.getChildrenByTagName("LinearItem");
                                                            int i = 0;
                                                            while (i < itemNodes.size()) {
                                                                int x = i % 2;
                                                                int y = i / 2;
                                                                if (x == 0) {
                                                                    TagNode rowDef3 = new TagNode("RowDef", null);
                                                                    rowDef3.setAttribute("Height", "30px");
                                                                    rowDefNodes.getChildren().add(rowDef3);
                                                                }
                                                                TagNode itemNode = (TagNode)itemNodes.get(i);
                                                                String itemKey = itemNode.getAttributes().get("Key");
                                                                TagNode spanNode = new TagNode("LayoutSpan", null);
                                                                spanNode.setAttribute("Key", itemKey);
                                                                spanNode.setAttribute("X", "" + x);
                                                                spanNode.setAttribute("Y", "" + y);
                                                                gridLayoutNode.getChildren().add(spanNode);
                                                                ++i;
                                                            }
                                                            rowDefNodes.getChildren().add(rowDef2);
                                                            gridLayoutNode.getChildren().add(rowDefNodes);
                                                            gridLayoutNode.getChildren().add(colDefNodes);
                                                            List<AbstractNode> layouts = compViewNode.getChildren();
                                                            int index = layouts.indexOf(rootLayout);
                                                            layouts.set(index, gridLayoutNode);
                                                            XmlDiffProcessor.genXmlDiff(xmlTree, compViewNode, diff, false);
                                                        }
                                                    } else if (newValue.equalsIgnoreCase("LinearLayout") && string.equalsIgnoreCase("GridLayout")) {
                                                        TagNode linearLayoutNode = new TagNode("LinearLayout", null);
                                                        linearLayoutNode.setAttribute("Key", diff.getKey());
                                                        linearLayoutNode.setAttribute("Orientation", "Vertical");
                                                        List<AbstractNode> spanNodes = rootLayout.getChildrenByTagName("LayoutSpan");
                                                        int i = 0;
                                                        while (i < spanNodes.size()) {
                                                            TagNode layoutSpanNode = (TagNode)spanNodes.get(i);
                                                            TagNode linearItemNode = new TagNode("LinearItem", null);
                                                            String key = layoutSpanNode.getAttributes().get("Key");
                                                            linearItemNode.setAttribute("Height", "30px");
                                                            linearItemNode.setAttribute("Key", key);
                                                            linearLayoutNode.addNode(linearItemNode);
                                                            ++i;
                                                        }
                                                        List<AbstractNode> layouts = compViewNode.getChildren();
                                                        int index = layouts.indexOf(rootLayout);
                                                        layouts.set(index, linearLayoutNode);
                                                        XmlDiffProcessor.genXmlDiff(xmlTree, compViewNode, diff, false);
                                                    }
                                                }
                                                break block331;
                                            }
                                            if (!Property.XSpan.name.equalsIgnoreCase(propertyName)) break block337;
                                            if (metaObjectType == MetaObjectType.EditViewColumn || metaObjectType == MetaObjectType.EditViewChildGridLayout || metaObjectType == MetaObjectType.EditViewChildLinearLayout || metaObjectType == MetaObjectType.EditViewChildFlexFlowLayout || metaObjectType == MetaObjectType.EditViewChildColumnLayout || metaObjectType == MetaObjectType.EditViewChildSplitLayout || metaObjectType == MetaObjectType.EditViewChildTabLayout || metaObjectType == MetaObjectType.EditViewChildFlowLayout || metaObjectType == MetaObjectType.EditViewChildFlexGridLayout) {
                                                XmlDiffProcessor.setEditViewColumnGridLayoutSpanProperty(xmlTree, diff, propertyName, newValue);
                                            } else {
                                                XmlDiffProcessor.setSonNodeProperties(diff, node, propertyName, newValue);
                                            }
                                            break block331;
                                        }
                                        if (!Property.YSpan.name.equalsIgnoreCase(propertyName)) break block338;
                                        if (metaObjectType == MetaObjectType.EditViewColumn || metaObjectType == MetaObjectType.EditViewChildGridLayout || metaObjectType == MetaObjectType.EditViewChildLinearLayout || metaObjectType == MetaObjectType.EditViewChildFlexFlowLayout || metaObjectType == MetaObjectType.EditViewChildColumnLayout || metaObjectType == MetaObjectType.EditViewChildSplitLayout || metaObjectType == MetaObjectType.EditViewChildTabLayout || metaObjectType == MetaObjectType.EditViewChildFlowLayout || metaObjectType == MetaObjectType.EditViewChildFlexGridLayout) {
                                            XmlDiffProcessor.setEditViewColumnGridLayoutSpanProperty(xmlTree, diff, propertyName, newValue);
                                        } else {
                                            XmlDiffProcessor.setSonNodeProperties(diff, node, propertyName, newValue);
                                        }
                                        break block331;
                                    }
                                    if (!Property.x.name.equalsIgnoreCase(propertyName)) break block339;
                                    if (metaObjectType == MetaObjectType.EditViewColumn || metaObjectType == MetaObjectType.EditViewChildGridLayout || metaObjectType == MetaObjectType.EditViewChildLinearLayout || metaObjectType == MetaObjectType.EditViewChildFlexFlowLayout || metaObjectType == MetaObjectType.EditViewChildColumnLayout || metaObjectType == MetaObjectType.EditViewChildSplitLayout || metaObjectType == MetaObjectType.EditViewChildTabLayout || metaObjectType == MetaObjectType.EditViewChildFlowLayout || metaObjectType == MetaObjectType.EditViewChildFlexGridLayout) {
                                        XmlDiffProcessor.setEditViewColumnGridLayoutSpanProperty(xmlTree, diff, propertyName, newValue);
                                    } else {
                                        XmlDiffProcessor.setSonNodeProperties(diff, node, Property.x.name, newValue);
                                    }
                                    if (!"Label".equals(node.getTagName())) {
                                        buddyKey = node.getAttributes().get("BuddyKey");
                                        if (StringUtils.isBlank((CharSequence)buddyKey)) {
                                            TagNode tagNode1;
                                            XmlTreeWithPath vestXmlTree = diff.getVestXmlTree();
                                            if (Objects.nonNull(vestXmlTree) && Objects.nonNull(tagNode1 = vestXmlTree.xmlTree.getTagNode(xmlTreeKey))) {
                                                buddyKey = tagNode1.getAttributes().get("BuddyKey");
                                                buddyPrimary = "Label@" + buddyKey;
                                                buddyNode = xmlTree.xmlTree.getTagNode(buddyPrimary);
                                            }
                                        } else {
                                            String buddyPrimary2 = "Label@" + buddyKey;
                                            buddyNode = xmlTree.xmlTree.getTagNode(buddyPrimary2);
                                        }
                                        if (buddyNode != null) {
                                            XmlDiffProcessor.setSonNodeProperties(diff, buddyNode, Property.x.name, String.valueOf(Integer.parseInt(newValue) - 1));
                                        }
                                    }
                                    break block331;
                                }
                                if (!Property.y.name.equalsIgnoreCase(propertyName)) break block340;
                                if (metaObjectType == MetaObjectType.EditViewColumn || metaObjectType == MetaObjectType.EditViewChildGridLayout || metaObjectType == MetaObjectType.EditViewChildLinearLayout || metaObjectType == MetaObjectType.EditViewChildFlexFlowLayout || metaObjectType == MetaObjectType.EditViewChildColumnLayout || metaObjectType == MetaObjectType.EditViewChildSplitLayout || metaObjectType == MetaObjectType.EditViewChildTabLayout || metaObjectType == MetaObjectType.EditViewChildFlowLayout || metaObjectType == MetaObjectType.EditViewChildFlexGridLayout) {
                                    XmlDiffProcessor.setEditViewColumnGridLayoutSpanProperty(xmlTree, diff, propertyName, newValue);
                                } else {
                                    XmlDiffProcessor.setSonNodeProperties(diff, node, Property.y.name, newValue);
                                }
                                if (!"Label".equals(node.getTagName())) {
                                    buddyKey = node.getAttributes().get("BuddyKey");
                                    if (StringUtils.isBlank((CharSequence)buddyKey)) {
                                        TagNode tagNode1;
                                        XmlTreeWithPath vestXmlTree = diff.getVestXmlTree();
                                        if (Objects.nonNull(vestXmlTree) && Objects.nonNull(tagNode1 = vestXmlTree.xmlTree.getTagNode(xmlTreeKey))) {
                                            buddyKey = tagNode1.getAttributes().get("BuddyKey");
                                            buddyPrimary = "Label@" + buddyKey;
                                            buddyNode = xmlTree.xmlTree.getTagNode(buddyPrimary);
                                        }
                                    } else {
                                        String buddyPrimary3 = "Label@" + buddyKey;
                                        buddyNode = xmlTree.xmlTree.getTagNode(buddyPrimary3);
                                    }
                                    if (buddyNode != null) {
                                        XmlDiffProcessor.setSonNodeProperties(diff, buddyNode, Property.y.name, String.valueOf(Integer.valueOf(newValue)));
                                    }
                                }
                                break block331;
                            }
                            if (!Property.CellType.name.equalsIgnoreCase(propertyName)) break block341;
                            Object map = node.getAttributes();
                            map.entrySet().removeIf(entry -> !"Key".equals(entry.getKey()));
                            XmlDiffProcessor.setSonNodeProperties(diff, node, Property.CellType.name, newValue);
                            break block331;
                        }
                        if (!Property.CellGroupType.name.equalsIgnoreCase(propertyName)) break block342;
                        switch (newValue) {
                            case "None": 
                            case "RowTreeGroup": {
                                for (AbstractNode tagNodeChild : tagNode.getParent().getChildren()) {
                                    if (!(tagNodeChild instanceof TagNode) || !node.getAttributes().get("Key").equalsIgnoreCase(((TagNode)tagNodeChild).getAttributes().get("GroupKey"))) continue;
                                    throw new Throwable("\u6b64\u5b57\u6bb5\u884c\u7c7b\u578b\u88ab\u5176\u4ed6\u884c\u4f9d\u8d56\uff0c\u4e0d\u652f\u6301\u4fee\u6539\u5206\u7ec4\u7c7b\u578b");
                                }
                                XmlDiffProcessor.setSonNodeProperties(diff, node, Property.CellGroupType.name, newValue);
                                break;
                            }
                            case "RowGroup": {
                                XmlDiffProcessor.setSonNodeProperties(diff, node, Property.CellGroupType.name, newValue);
                            }
                        }
                        break block331;
                    }
                    if (Property.RowKey.name.equalsIgnoreCase(propertyName) || Property.RowVisible.name.equalsIgnoreCase(propertyName) || Property.RowGroupKey.name.equalsIgnoreCase(propertyName) || Property.RowDefaultLayer.name.equalsIgnoreCase(propertyName) || Property.RowDetailKey.name.equalsIgnoreCase(propertyName) || Property.RowBackColor.name.equalsIgnoreCase(propertyName) || Property.RowRefKey.name.equalsIgnoreCase(propertyName)) {
                        XmlDiffProcessor.setSonNodeProperties(diff, node, propertyName.substring(3), newValue);
                    } else if (Property.LinkType.name.equalsIgnoreCase(propertyName)) {
                        XmlDiffProcessor.setSonNodeProperties(diff, tagNode, propertyName, newValue);
                    } else if (Property.RowHeight.name.equalsIgnoreCase(propertyName)) {
                        XmlDiffProcessor.setSonNodeProperties(diff, node, propertyName, newValue);
                    } else if (Property.ExpandType.name.equalsIgnoreCase(propertyName)) {
                        TagNode rowExpand = node.getOrCreateChildByTagName("RowExpand");
                        rowExpand.setAttribute(propertyName, newValue);
                        if (rowExpand.getAttributes().size() == 1 && "Dict".equalsIgnoreCase(newValue)) {
                            node.deleteChildByTagName("RowExpand");
                        }
                    } else if (Property.CellKey.name.equalsIgnoreCase(propertyName)) {
                        TagNode rowExpand = tagNode.getOrCreateChildByTagName("RowExpand");
                        rowExpand.setAttribute(propertyName, newValue);
                        if (rowExpand.getAttributes().size() == 0) {
                            tagNode.deleteChildByTagName("RowExpand");
                        }
                    } else if (Property.RowExpand.name.equalsIgnoreCase(propertyName)) {
                        XmlDiffProcessor.setSonNodeProperties(diff, tagNode, propertyName, newValue);
                    } else if (Property.FormulaItems.name.equalsIgnoreCase(propertyName)) {
                        XmlDiffProcessor.setSonNodeProperties(diff, node, propertyName, newValue);
                    } else if (Property.RowKeywords.name.equalsIgnoreCase(propertyName)) {
                        String[] stringArray;
                        String tagName = node.getTagName();
                        String tableKey2 = null;
                        if ("GridRow".equalsIgnoreCase(tagName)) {
                            tableKey2 = node.getAttributes().get("TableKey");
                        } else {
                            TagNode dataBinding = tagNode.findFirstTagNodeByTagName("DataBinding");
                            if (dataBinding != null) {
                                tableKey2 = dataBinding.getAttributes().get("TableKey");
                            }
                        }
                        if (!StringUtils.isNotEmpty((CharSequence)tableKey2)) throw new Exception("\u5f53\u524d\u9009\u4e2d\u7ec4\u4ef6\u672a\u7ed1\u5b9a\u5173\u8054\u8868\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u5173\u952e\u5b57");
                        MetaTable metaTable = metaForm.getMetaTable(tableKey2);
                        String[] stringArray2 = stringArray = newValue.split(";");
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String value = stringArray2[n2];
                            String str = value.trim();
                            if (str != null && !str.isEmpty()) {
                                String[] arr = str.split("=");
                                if (arr.length != 2) {
                                    throw new Exception("\u5173\u952e\u5b57\u8bbe\u7f6e\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4ee5\u5173\u8054\u8868\u4e2d\u7684\u5b57\u6bb5+\u201c=\u201d+\u5bf9\u5e94\u5b57\u6bb5\u6570\u636e\u7c7b\u578b\u7684\u503c\u4f5c\u4e3a\u5173\u952e\u5b57\uff0c\u7c7b\u4f3c\u4e8eA=10000");
                                }
                                MetaColumn metaColumn = (MetaColumn)metaTable.get(arr[0]);
                                if (Objects.isNull(metaColumn)) {
                                    throw new Exception("\u5173\u8054\u8868\u4e2d\u6ca1\u6709\u6b64\u5b57\u6bb5\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e");
                                }
                                int dataType = metaColumn.getDataType();
                                try {
                                    TypeConvertor.toDataType((int)dataType, (Object)arr[1]);
                                }
                                catch (NumberFormatException exception) {
                                    throw new Exception("\u5173\u952e\u5b57\u8bbe\u7f6e\u503c\u4e0e\u5b57\u6bb5\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u6309\u6570\u636e\u6e90\u4e2d\u5bf9\u5e94\u5b57\u6bb5\u6570\u636e\u7c7b\u578b\u586b\u5199");
                                }
                                node.setAttribute("Keywords", newValue);
                            }
                            ++n2;
                        }
                    } else if (Property.RowType.name.equalsIgnoreCase(propertyName)) {
                        String parentKey = node.getAttributes().get("Key");
                        if ("Group".equalsIgnoreCase(newValue)) {
                            boolean flag = false;
                            List metaGridCells = metaForm.getAllGridCells();
                            for (MetaGridCell metaGridCell : metaGridCells) {
                                TagNode tableNode;
                                TagNode cellNode;
                                if ("\u5220\u9664".equals(metaGridCell.getCaption()) || "\u9009\u62e9".equals(metaGridCell.getCaption()) || Objects.isNull(cellNode = xmlTree.xmlTree.getTagNode("GridCell@" + metaGridCell.getKey())) || cellNode.getParent().getAttributes().get("Key").equalsIgnoreCase(parentKey) || (tableNode = xmlTree.xmlTree.getTagNode("Table@" + cellNode.getParent().getAttributes().get("TableKey"))) == null) continue;
                                for (AbstractNode child : tableNode.getChildrenByTagName("Column")) {
                                    if (!(child instanceof TagNode) || !((TagNode)child).getAttributes().get("Key").equalsIgnoreCase(metaGridCell.getDataBinding().getColumnKey())) continue;
                                    ((TagNode)child).setAttribute("IsPrimary", "true");
                                    flag = true;
                                    XmlDiffProcessor.genXmlDiff(xmlTree, tableNode, diff, false);
                                }
                                node.setAttribute("GroupKey", metaGridCell.getKey());
                                cellNode.setAttribute("CellGroupType", "RowGroup");
                                node.setAttribute(propertyName, newValue);
                                if (flag) break;
                            }
                            if (!flag) {
                                throw new Throwable("\u8868\u683c\u672a\u6dfb\u52a0\u660e\u7ec6\u884c\uff0c\u6216\u6240\u5c5e\u5206\u7ec4\u6807\u8bc6\u6570\u636e\u5217\u672a\u6dfb\u52a0\u4e1a\u52a1\u5173\u952e\u5b57");
                            }
                            tagNode = xmlTree.xmlTree.getTagNode("Grid@" + diff.parentKey);
                            break;
                        }
                        if (!StringUtils.isNotEmpty((CharSequence)tagNode.getAttributes().get("RowType"))) {
                            List<AbstractNode> children = tagNode.getParent().getChildren();
                            Object groupKey = "";
                            for (AbstractNode abstractNode : children) {
                                if (!(abstractNode instanceof TagNode) || !"Group".equalsIgnoreCase(((TagNode)abstractNode).getAttributes().get("RowType"))) continue;
                                groupKey = ((TagNode)abstractNode).getAttributes().get("GroupKey");
                                break;
                            }
                            if (StringUtils.isNotEmpty((CharSequence)groupKey)) {
                                for (AbstractNode abstractNode : tagNode.getChildren()) {
                                    if (!(abstractNode instanceof TagNode) || !((String)groupKey).equalsIgnoreCase(((TagNode)abstractNode).getAttributes().get("Key"))) continue;
                                    throw new Throwable("\u6b64\u660e\u7ec6\u884c\u88ab\u5176\u4ed6\u884c\u4f9d\u8d56\uff0c\u4e0d\u652f\u6301\u4fee\u6539\u884c\u7c7b\u578b");
                                }
                            }
                            node.setAttribute(propertyName, newValue);
                        } else {
                            node.setAttribute(propertyName, newValue);
                        }
                    } else if (Property.RowTableKey.name.equalsIgnoreCase(propertyName)) {
                        if ("\u65e0\u6570\u636e\u8868".equalsIgnoreCase(newValue)) {
                            node.getAttributes().remove("TableKey");
                        } else {
                            node.setAttribute(propertyName.substring(3), newValue);
                        }
                        List<AbstractNode> nodeList = node.getChildren();
                        for (AbstractNode abstractNode : nodeList) {
                            if (!(abstractNode instanceof TagNode) || !"GridCell".equalsIgnoreCase(((TagNode)abstractNode).getTagName()) || ((TagNode)abstractNode).getOrCreateChildByTagName("DataBinding") == null) continue;
                            ((TagNode)abstractNode).getOrCreateChildByTagName("DataBinding").getAttributes().remove("ColumnKey");
                        }
                        List<TagNode> nodesByTagName = tagNode.findNodesByTagName("GridRow");
                        for (TagNode node1 : nodesByTagName) {
                            node1.deleteAttribute("Keywords");
                        }
                    } else if (Property.caption.name.equalsIgnoreCase(propertyName)) {
                        String buddyKey;
                        if (StringUtils.isNotEmpty((CharSequence)node.getAttributes().get("BuddyKey")) && !"Label".equals(node.getTagName()) && (buddyNode = xmlTree.xmlTree.getTagNode(buddyKey = "Label@" + node.getAttributes().get("BuddyKey"))) != null) {
                            buddyNode.setAttribute(propertyName, newValue);
                        }
                        if (GridCellNode != null) {
                            GridCellNode.setAttribute(propertyName, newValue);
                        }
                        node.setAttribute(propertyName, newValue);
                        if (diff.getMetaObjectType() == MetaObjectType.field) {
                            node.setAttribute(Property.FormulaCaption.name, "");
                            node.setAttribute("CaptionDependency", "");
                        }
                    } else if (Property.IsGroupHead.name.equalsIgnoreCase(propertyName)) {
                        int count = 0;
                        String groupKey = node.getAttributes().get("GroupKey");
                        String isGroupHead = node.getAttributes().get("IsGroupHead");
                        IDLookup iDLookup = IDLookup.getIDLookup(metaForm);
                        List<MetaComponent> allComponent = iDLookup.getAllComponent();
                        if ("true".equalsIgnoreCase(isGroupHead)) {
                            for (MetaComponent component : allComponent) {
                                if (!(component instanceof MetaRadioButton)) continue;
                                ++count;
                                if (!((MetaRadioButton)component).getGroupKey().equalsIgnoreCase(groupKey) || ((MetaRadioButton)component).isGroupHead().booleanValue()) continue;
                                throw new Throwable("\u8bf7\u5148\u5c06\u5176\u4f59\u6240\u5c5e\u7ec4\u4e3a" + groupKey + "\u7684\u5355\u9009\u6309\u94ae\u7684\u6240\u5c5e\u7ec4\u4fee\u6539\u4e3a\u5176\u4ed6\u7ec4\u6216\u5c06\u5176\u4ed6\u5355\u9009\u6309\u94ae\u8bbe\u7f6e\u4e3a\u7ec4\u5934\u63a7\u4ef6");
                            }
                        }
                        if (count <= 1 && "false".equalsIgnoreCase(newValue)) {
                            throw new Throwable("\u8be5\u7ec4\u4ef6\u4e3a\u552f\u4e00\u5355\u9009\u6309\u94ae\uff0c\u8bf7\u6dfb\u52a0\u5176\u4ed6\u5355\u9009\u6309\u94ae\u5e76\u8bbe\u7f6e\u4e3a\u7ec4\u5934\u63a7\u4ef6\u540e\u5728\u4fee\u6539\u6b64\u7ec4\u4ef6\u7ec4\u5934\u5c5e\u6027");
                        }
                        node.setAttribute(propertyName, newValue);
                    } else if (Property.GroupKey.name.equalsIgnoreCase(propertyName)) {
                        if (!StringUtils.isNotEmpty((CharSequence)newValue)) {
                            throw new Throwable("\u6240\u5c5e\u7ec4\u65e0\u6cd5\u8bbe\u7f6e\u4e3a\u7a7a");
                        }
                        String groupKey = node.getAttributes().get("GroupKey");
                        String isGroupHead = node.getAttributes().get("IsGroupHead");
                        IDLookup idLookup = IDLookup.getIDLookup(metaForm);
                        List<MetaComponent> list = idLookup.getAllComponent();
                        if ("true".equalsIgnoreCase(isGroupHead)) {
                            for (MetaComponent component : list) {
                                if (!(component instanceof MetaRadioButton) || !((MetaRadioButton)component).getGroupKey().equalsIgnoreCase(groupKey) || ((MetaRadioButton)component).isGroupHead().booleanValue()) continue;
                                throw new Throwable("\u8bf7\u5148\u5c06\u5176\u4f59\u6240\u5c5e\u7ec4\u4e3a" + groupKey + "\u7684\u5355\u9009\u6309\u94ae\u7684\u6240\u5c5e\u7ec4\u4fee\u6539\u4e3a\u5176\u4ed6\u7ec4\u6216\u5c06\u5176\u4ed6\u5355\u9009\u6309\u94ae\u8bbe\u7f6e\u4e3a\u7ec4\u5934\u63a7\u4ef6");
                            }
                        }
                        node.setAttribute(propertyName, newValue);
                    } else if (Property.StateMask.name.equalsIgnoreCase(propertyName)) {
                        newValue = newValue.replaceAll(",", "\\|");
                        XmlDiffProcessor.setSonNodeProperties(diff, node, propertyName, newValue);
                    } else if (Property.StateMaskFormula.name.equalsIgnoreCase(propertyName)) {
                        XmlDiffProcessor.setSonNodeProperties(diff, node, propertyName, newValue);
                    } else if (metaObjectType == MetaObjectType.listViewField) {
                        XmlDiffProcessor.setListViewNodeProperty(diff, node, propertyName, newValue);
                    } else if (Property.IgnoreRights.name.equalsIgnoreCase(propertyName)) {
                        TagNode dataBindingNode = (TagNode)xmlTree.xmlTree.getTagNode(String.valueOf(ControlType.toString((Integer)diff.getControlType())) + "@" + diff.getKey()).getChildrenByTagName("DataBinding").get(0);
                        TagNode columnNode = xmlTree.xmlTree.getTagNode("Column@" + dataBindingNode.getAttributes().get("ColumnKey"));
                        String needRights = columnNode.getAttributes().get("NeedRights");
                        if ("true".equals(newValue) && "True".equalsIgnoreCase(needRights)) {
                            throw new Throwable("\u8be5\u6570\u636e\u6e90\u6743\u9650\u7c7b\u578b\u4e3a\u68c0\u67e5\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u4e3a\u5ffd\u7565\u6743\u9650\uff01\u5df2\u64a4\u9500\uff01");
                        }
                        XmlDiffProcessor.setSonNodeProperties(diff, node, propertyName, newValue);
                    } else if (Property.AllowMultiSelection.name.equals(propertyName)) {
                        TagNode thisNode;
                        TagNode dataBindingNode = null;
                        if (metaObjectType == MetaObjectType.field) {
                            TagNode thisNode2 = xmlTree.xmlTree.getTagNode(String.valueOf(ControlType.toString((Integer)diff.getControlType())) + "@" + diff.getKey());
                            if (thisNode2.hasChildrenByTagName("DataBinding")) {
                                dataBindingNode = (TagNode)thisNode2.getChildrenByTagName("DataBinding").get(0);
                            }
                        } else if (metaObjectType == MetaObjectType.gridField && (thisNode = xmlTree.xmlTree.getTagNode("GridCell@" + diff.getKey())).hasChildrenByTagName("DataBinding")) {
                            dataBindingNode = (TagNode)thisNode.getChildrenByTagName("DataBinding").get(0);
                        }
                        if (dataBindingNode != null && dataBindingNode.hasAttribute("ColumnKey")) {
                            TagNode columnNode = xmlTree.xmlTree.getTagNode("Column@" + dataBindingNode.getAttributes().get("ColumnKey"));
                            String dataType = columnNode.getAttributes().get("DataType");
                            if (Boolean.parseBoolean(newValue)) {
                                if ("Long".equals(dataType)) {
                                    columnNode.setAttribute("DataType", "Varchar");
                                }
                            } else {
                                columnNode.setAttribute("DataType", "Long");
                            }
                            XmlDiffProcessor.genXmlDiff(xmlTree, columnNode, diff, false);
                        }
                        XmlDiffProcessor.setSonNodeProperties(diff, node, propertyName, newValue);
                    } else if (Property.SourceType.name.equals(propertyName)) {
                        if (204 == diff.getControlType() || diff.getControlType() == 202) {
                            if ("Items".equals(orgValue)) {
                                node.deleteChildByTagName("Item");
                            }
                            if ("Formula".equals(orgValue)) {
                                node.deleteChildByTagName("FormulaItems");
                            }
                            if ("ParaGroup".equals(orgValue)) {
                                node.deleteAttribute("GroupKey");
                            }
                            if ("Query".equals(orgValue)) {
                                node.deleteAttribute("ItemsDependency");
                                node.deleteChildByTagName("QueryDef");
                            }
                            if ("Formula".equals(newValue) && !node.hasChildrenByTagName("FormulaItems")) {
                                TagNode formulaItems = new TagNode("FormulaItems", null);
                                node.addNode(formulaItems);
                            }
                        }
                        XmlDiffProcessor.setSonNodeProperties(diff, node, propertyName, newValue);
                    } else if (Property.TextShowType.name.equals(propertyName)) {
                        node.setAttribute(Property.TextShowType.name, newValue);
                    } else if (Property.Type.name.equals(propertyName)) {
                        node.setAttribute(Property.Type.name, newValue);
                    } else if (Property.UploadType.name.equals(propertyName)) {
                        node.setAttribute(Property.UploadType.name, newValue);
                    } else if (Property.DateFormat.name.equals(propertyName)) {
                        XmlDiffProcessor.setSonNodeProperties(diff, node, Property.Format.name, newValue);
                    } else if (Property.CaseType.name.equals(propertyName)) {
                        node.setAttribute("Case", newValue);
                    } else if (Property.PageLoadType.name.equals(propertyName)) {
                        if (305 != diff.getControlType()) {
                            String finalNewValue = newValue;
                            node.findFirstTagNodeByTagName("GridRowCollection").findNodesByTagName("GridRow").stream().filter(row -> row.hasAttribute("TableKey")).map(row -> row.getAttributes().get("TableKey")).findFirst().ifPresent(tableKey -> {
                                MetaDataObject dataObject = metaForm.getDataSource().getDataObject();
                                if (Objects.equals(dataObject.getTable(tableKey).getSourceType(), 2) && StringUtils.equals((CharSequence)finalNewValue, (CharSequence)"DB")) {
                                    throw new RuntimeException("\u8868\u683c\u7ed1\u5b9a\u7684\u6570\u636e\u6e90\u8868\u6765\u6e90\u6570\u636e\u7c7b\u578b\u4e3a\u5b9a\u5236\u516c\u5f0f\uff0c\u4e0d\u53ef\u4fee\u6539\u6210\u6570\u636e\u5206\u9875");
                                }
                            });
                        }
                        XmlDiffProcessor.setSonNodeProperties(diff, node, propertyName, newValue);
                    } else if (Property.IsMergedHead.name.equals(propertyName)) {
                        node.setAttribute("IsMerged", newValue);
                        node.setAttribute(Property.IsMergedHead.name, newValue);
                        if (StringUtils.equals((CharSequence)newValue, (CharSequence)"false")) {
                            if (node.hasAttribute(Property.MergedRowSpan.name)) {
                                node.deleteAttribute(Property.MergedRowSpan.name);
                            }
                            if (node.hasAttribute(Property.MergedColumnSpan.name)) {
                                node.deleteAttribute(Property.MergedColumnSpan.name);
                            }
                        }
                    } else if (Property.MergedRowSpan.name.equals(propertyName)) {
                        int mergedRowSpan = Integer.parseInt(newValue);
                        node.getAttributes().get(Property.MergedColumnSpan.name);
                        int mergedColumnSpan = node.getAttributes().get(Property.MergedColumnSpan.name) != null ? Integer.parseInt(node.getAttributes().get(Property.MergedColumnSpan.name)) : 1;
                        XmlDiffProcessor.dealMergedSpan(xmlTree, mergedRowSpan, mergedColumnSpan, diff);
                    } else if (Property.MergedColumnSpan.name.equals(propertyName)) {
                        int mergedColumnSpan = Integer.parseInt(newValue);
                        int mergedRowSpan = node.getAttributes().get(Property.MergedRowSpan.name) != null ? Integer.parseInt(node.getAttributes().get(Property.MergedRowSpan.name)) : 1;
                        XmlDiffProcessor.dealMergedSpan(xmlTree, mergedRowSpan, mergedColumnSpan, diff);
                    } else if (Property.IsSelect.name.equals(propertyName)) {
                        XmlDiffProcessor.setSonNodeProperties(diff, node, propertyName, TypeConvertor.toBoolean((Object)newValue).toString());
                    } else if (metaObjectType == MetaObjectType.EditViewColumn || metaObjectType == MetaObjectType.EditViewChildGridLayout || metaObjectType == MetaObjectType.EditViewChildLinearLayout || metaObjectType == MetaObjectType.EditViewChildFlexFlowLayout || metaObjectType == MetaObjectType.EditViewChildColumnLayout || metaObjectType == MetaObjectType.EditViewChildSplitLayout || metaObjectType == MetaObjectType.EditViewChildTabLayout || metaObjectType == MetaObjectType.EditViewChildFlowLayout || metaObjectType == MetaObjectType.EditViewChildFlexGridLayout) {
                        if (Property.Width.name.equals(propertyName) || Property.Height.name.equals(propertyName) || Property.MinHeight.name.equals(propertyName) || Property.Weight.name.equals(propertyName)) {
                            XmlDiffProcessor.setEditViewColumnSizeInComponentView(xmlTree, diff, propertyName, newValue);
                        } else {
                            XmlDiffProcessor.setSonNodeProperties(diff, node, propertyName, newValue);
                        }
                    } else {
                        XmlDiffProcessor.setSonNodeProperties(diff, node, propertyName, newValue);
                    }
                }
                XmlDiffProcessor.dealExtendNode(diff, node);
            }
            boolean ownerPanelKeyChanged = false;
            for (DiffProperty property : diff.properties) {
                if (property.property != Property.ownerPanelKey) continue;
                TagNode newParentNode = xmlTree.xmlTree.getTagNode(String.valueOf(tagNode.getTagName()) + "@" + property.getNewValue());
                List<AbstractNode> newChildren = newParentNode.getChildren();
                ownerPanelKeyChanged = true;
                if (Objects.nonNull(buddyNode)) {
                    tagNode.deleteChildByTagKey(buddyNode.getAttributes().get("Key"));
                    newChildren.add(newChildren.size() - 6, buddyNode);
                }
                tagNode.deleteChildByTagKey(node.getAttributes().get("Key"));
                if (newChildren.isEmpty()) {
                    newChildren.add(node);
                    continue;
                }
                newChildren.add(newChildren.size() - 6 >= 0 ? newChildren.size() - 6 : newChildren.size() - 1, node);
            }
            if (diff.properties.get((int)0).property.name.startsWith("Row")) {
                XmlDiffProcessor.genXmlDiff(xmlTree, tagNode, diff, true);
                return;
            } else {
                if (metaObjectType == MetaObjectType.GridHeadColumn) {
                    XmlDiffProcessor.genXmlDiff(xmlTree, tagNode.getParent(), diff, true);
                } else if (StringUtils.isNotEmpty((CharSequence)diff.properties.get((int)0).propertyParent)) {
                    XmlDiffProcessor.genXmlDiff(xmlTree, tagNode, diff, true);
                } else if (ownerPanelKeyChanged) {
                    XmlDiffProcessor.genXmlDiff(xmlTree, tagNode.getParent(), diff, true);
                } else {
                    XmlDiffProcessor.genXmlDiff(xmlTree, node, diff, true);
                }
                if ("Label".equals(node.getTagName()) || ownerPanelKeyChanged || !Objects.nonNull(buddyNode)) return;
                XmlDiffProcessor.genXmlDiff(xmlTree, buddyNode, diff, false);
            }
            return;
        }
        if (metaObjectType == MetaObjectType.DataObjectCheckRule) {
            String columnKey = diff.properties.get(0).getOrgValue();
            XmlTreeWithPath xmlTree1 = diff.getXmlTree();
            if (Objects.isNull(diff.getXmlTree())) {
                xmlTree1 = diff.getDataObjectXmlTree();
            }
            int haveRelyOn = 0;
            if (MetaObjectType.DataObject.name.equals(diff.getReserveTwo())) {
                ArrayList<XmlTree> xmlTreeArrayList = new ArrayList<XmlTree>();
                MetaFormList metaFormList = MetaFactory.getGlobalInstance().getMetaFormList();
                for (MetaFormProfile metaFormProfile1 : metaFormList) {
                    try {
                        String key;
                        String resource;
                        XmlTreeWithPath parse;
                        String refObjectKey = metaFormProfile1.getForm().getDataSource().getRefObjectKey();
                        if (!refObjectKey.equals(diff.getReserveThree()) || (parse = XmlTreeWithPath.parseFilePath(resource = LoadFileTree.getPathByFormKey(key = metaFormProfile1.getForm().getKey()))) == null) continue;
                        xmlTreeArrayList.add(parse.xmlTree);
                    }
                    catch (Exception e) {
                        LogSvr.getInstance().error("", (Throwable)e);
                    }
                }
                for (XmlTree tree : xmlTreeArrayList) {
                    haveRelyOn = XmlDiffProcessor.isHaveRelyOn(diff.properties.get(0).getOrgValue(), tree, diff.getReserveThree());
                    if (haveRelyOn == 0) {
                        continue;
                    }
                    break;
                }
            } else {
                haveRelyOn = XmlDiffProcessor.isHaveRelyOn(diff.properties.get(0).getOrgValue(), xmlTree1.xmlTree, diff.getReserveTwo());
            }
            if (haveRelyOn == 0) return;
            String tip = "\u6807\u8bc6" + columnKey + " \u5df2\u88ab\u67d0\u7ec4\u4ef6\u7ed1\u5b9a\u6216\u5f15\u7528\uff0c\u8bf7\u5148\u89e3\u9664\u4f9d\u8d56\u5173\u7cfb\u518d\u5220\u9664";
            if ("OID".equals(columnKey) || "SOID".equals(columnKey) || "POID".equals(columnKey) || "VERID".equals(columnKey) || "DVERID".equals(columnKey)) {
                tip = "\u6807\u8bc6" + columnKey + "\u6807\u8bc6" + columnKey + " \u4e3a\u7cfb\u7edf\u5b57\u6bb5\u4e0d\u5141\u8bb8\u5220\u9664";
            }
            diff.properties.get(0).setNewValue(tip);
            return;
        }
        if (metaObjectType == MetaObjectType.operation || metaObjectType == MetaObjectType.operationCollection) {
            String xmlTreeKey = XmlDiffProcessor.getXmlTreeKey(diff, null, diff.properties.get((int)0).orgValue);
            if (!xmlTreeKey.contains(",")) return;
            String fPrimary = xmlTreeKey.substring(0, xmlTreeKey.indexOf(","));
            String sPrimary = xmlTreeKey.replace(String.valueOf(fPrimary) + ",", "");
            TagNode cellNode = xmlTree.xmlTree.getTagNode(fPrimary);
            TagNode coluNode = xmlTree.xmlTree.getTagNode(sPrimary);
            for (DiffProperty property : diff.properties) {
                String orgValue = property.getOrgValue();
                String newValue = property.getNewValue();
                if (StringUtils.isBlank((CharSequence)orgValue) && StringUtils.isBlank((CharSequence)newValue)) continue;
                String propertyName = property.property.name;
                if (cellNode != null && coluNode != null) {
                    if ("Label".equals(cellNode.getTagName()) && Property.key.name.equals(propertyName)) {
                        XmlDiffProcessor.setSonNodeProperties(diff, cellNode, propertyName, "Inner_" + newValue);
                        XmlDiffProcessor.setSonNodeProperties(diff, coluNode, propertyName, newValue);
                        XmlDiffProcessor.setSonNodeProperties(diff, coluNode, "BuddyKey", "Inner_" + newValue);
                        continue;
                    }
                    XmlDiffProcessor.setSonNodeProperties(diff, cellNode, propertyName, newValue);
                    XmlDiffProcessor.setSonNodeProperties(diff, coluNode, propertyName, newValue);
                    continue;
                }
                if (Objects.isNull(cellNode)) {
                    XmlDiffProcessor.setSonNodeProperties(diff, coluNode, propertyName, newValue);
                    continue;
                }
                XmlDiffProcessor.setSonNodeProperties(diff, cellNode, propertyName, newValue);
            }
            TagNode node1 = cellNode != null ? cellNode : coluNode;
            XmlDiffProcessor.genXmlDiff(xmlTree, node1, diff, true);
            if (coluNode == null || cellNode == null) return;
            XmlDiffProcessor.genXmlDiff(xmlTree, coluNode, diff, false);
            return;
        } else if (metaObjectType == MetaObjectType.ToolBar) {
            boolean exist = false;
            for (MetaComponent allComponent : metaForm.getAllComponents()) {
                if (!(allComponent instanceof MetaToolBar)) continue;
                exist = true;
                break;
            }
            if (exist) {
                TagNode root = xmlTree.xmlTree.getRoot();
                TagNode operationCollection = new TagNode("OperationCollection", null);
                root.deleteChildByTagName("ToolBar");
                TagNode operation = new TagNode("Operation", null);
                operation.setAttribute("Key", "BillNew");
                operation.setAttribute("Caption", "\u65b0\u589e");
                operation.setAttribute("RefKey", "BillNew");
                operationCollection.addNode(operation);
                root.addNode(operationCollection, 2);
                XmlDiffProcessor.genXmlDiff(xmlTree, root, diff, true);
                return;
            } else {
                TagNode root1 = xmlTree.xmlTree.getRoot();
                TagNode tagNode = (TagNode)root1.getOrCreateChildByTagName("Body").getOrCreateChildByTagName("Block").getChildren().get(1);
                TagNode toolBar = new TagNode("ToolBar", null);
                toolBar.setAttribute("Key", "ToolBar1");
                toolBar.setAttribute("Caption", "ToolBar1");
                toolBar.setAttribute("Height", "pref");
                TagNode toolBarItemCollection = new TagNode("ToolBarItemCollection", null);
                toolBar.addNode(toolBarItemCollection);
                tagNode.addNode(toolBar, 0);
                if (diff.getXmlTree().xmlTree.getRoot().findNodesByTagName("OperationCollection").size() <= 0) {
                    TagNode operationCollection = new TagNode("OperationCollection", null);
                    TagNode operation = new TagNode("Operation", null);
                    operation.setAttribute("Key", "BillNew");
                    operation.setAttribute("Caption", "\u65b0\u589e");
                    operation.setAttribute("RefKey", "BillNew");
                    operationCollection.addNode(operation);
                    root1.addNode(operationCollection, 2);
                    root1.deleteChildByTagName("ToolBar");
                    XmlDiffProcessor.genXmlDiff(xmlTree, root1, diff, true);
                    return;
                } else {
                    XmlDiffProcessor.genXmlDiff(xmlTree, tagNode, diff, true);
                }
            }
            return;
        } else if (metaObjectType.equals(MetaObjectType.buttonReplace)) {
            try {
                String xmlTreeKey = String.valueOf(ControlType.toString((Integer)diff.getControlType())) + "@" + diff.getKey();
                TagNode node = diff.getXmlTree().xmlTree.getTagNode(xmlTreeKey);
                TagNode parent = node.getParent();
                if ("Block".equalsIgnoreCase(parent.getTagName())) {
                    throw new Throwable("\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u66ff\u6362");
                }
                String parentkey = parent.getAttributes().get("Key");
                TagNode parentparent = parent.getParent();
                diff.parentKey = parentkey;
                int location = XmlDiffProcessor.location(diff, parentparent);
                parentparent.deleteChildByTagKey(parentkey);
                parentparent.addNode(node, location);
                XmlDiffProcessor.genXmlDiff(xmlTree, parentparent, diff, true);
                return;
            }
            catch (Exception e) {
                LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
            }
            return;
        } else if (metaObjectType.equals(MetaObjectType.EmbedVar)) {
            DataTable embedVarDetail = document.get("ED_EmbedVar");
            XmlDiffProcessor.dealEmbedVar(xmlTree, embedVarDetail, diff);
            return;
        } else if (MetaObjectType.AddRowPanel.equals(metaObjectType)) {
            XmlDiffProcessor.dealAddRowPanel(xmlTree, diff);
            return;
        } else if (MetaObjectType.AddRowLayout.equals(metaObjectType)) {
            XmlDiffProcessor.dealAddRowLayout(xmlTree, diff);
            return;
        } else if (MetaObjectType.Container.equals(metaObjectType)) {
            TagNode containerNode = xmlTree.xmlTree.getTagNode("Container@" + diff.getKey());
            for (DiffProperty property : diff.properties) {
                String orgValue = property.getOrgValue();
                String newValue = property.getNewValue();
                if (StringUtils.isBlank((CharSequence)orgValue) && StringUtils.isBlank((CharSequence)newValue)) continue;
                String propertyName = property.property.name;
                if (propertyName.equals("HasTabGroup")) {
                    containerNode.deleteChildByTagName("TabGroup");
                    if (newValue.equals("Contain")) {
                        TagNode tabGroupNode = new TagNode("TabGroup", null);
                        tabGroupNode.setAttribute("Key", String.valueOf(diff.getKey()) + "_TabGroup");
                        tabGroupNode.setAttribute("Caption", "\u9875\u7b7e\u7ec4");
                        TagNode tabItemNode = new TagNode("TabItem", null);
                        tabItemNode.setAttribute("Key", String.valueOf(diff.getKey()) + "_TabGroup_TabItem1");
                        tabItemNode.setAttribute("Text", "\u83dc\u53551");
                        tabItemNode.setAttribute("Icon", "App/Default/TabGroup/Icon1.png");
                        tabItemNode.setAttribute("SelectedIcon", "App/Default/TabGroup/Select1.png");
                        tabGroupNode.addNode(tabItemNode);
                        containerNode.addNode(tabGroupNode);
                    }
                } else {
                    XmlDiffProcessor.setSonNodeProperties(diff, containerNode, propertyName, newValue);
                }
                XmlDiffProcessor.genXmlDiff(xmlTree, containerNode, diff, true);
            }
            return;
        } else if (MetaObjectType.CollectionViewRow.equals(metaObjectType)) {
            TagNode tableViewRowNode = xmlTree.xmlTree.getTagNode("CollectionViewRow@" + diff.getKey());
            for (DiffProperty property : diff.properties) {
                String orgValue = property.getOrgValue();
                String newValue = property.getNewValue();
                if (StringUtils.isBlank((CharSequence)orgValue) && StringUtils.isBlank((CharSequence)newValue)) continue;
                String propertyName = property.property.name;
                XmlDiffProcessor.setSonNodeProperties(diff, tableViewRowNode, propertyName, newValue);
                XmlDiffProcessor.genXmlDiff(xmlTree, tableViewRowNode, diff, true);
            }
            return;
        } else if (MetaObjectType.TableViewRow.equals(metaObjectType)) {
            TagNode tableViewRowNode = xmlTree.xmlTree.getTagNode("TableRow@" + diff.getKey());
            for (DiffProperty property : diff.properties) {
                TagNode nextNode;
                int index;
                String orgValue = property.getOrgValue();
                String newValue = property.getNewValue();
                if (StringUtils.isBlank((CharSequence)orgValue) && StringUtils.isBlank((CharSequence)newValue)) continue;
                String propertyName = property.property.name;
                if (propertyName.equals(Property.HasGroupHead.name)) {
                    if (property.newValue.equals("None")) {
                        TagNode preNode;
                        index = tableViewRowNode.getParent().getChildren().indexOf(tableViewRowNode);
                        if (index > 0 && (preNode = (TagNode)tableViewRowNode.getParent().getChildren().get(index - 2)) != null && preNode.getAttributes().get("RowType") != null && preNode.getAttributes().get("RowType").equals("Group")) {
                            tableViewRowNode.getParent().getChildren().remove(preNode);
                        }
                        if ((index = tableViewRowNode.getParent().getChildren().indexOf(tableViewRowNode)) >= 0 && index < tableViewRowNode.getParent().getChildren().size() - 1 && (nextNode = (TagNode)tableViewRowNode.getParent().getChildren().get(index + 2)) != null && nextNode.getAttributes().get("RowType") != null && nextNode.getAttributes().get("RowType").equals("GroupTail")) {
                            tableViewRowNode.getParent().getChildren().remove(nextNode);
                        }
                    } else if (property.newValue.equals("Contain")) {
                        index = tableViewRowNode.getParent().getChildren().indexOf(tableViewRowNode);
                        TagNode groupHeadNode = new TagNode("TableRow", null);
                        String groupHeadKey = String.valueOf(tableViewRowNode.getAttributes().get("Key")) + "_Group";
                        groupHeadNode.setAttribute("RowType", "Group");
                        groupHeadNode.setAttribute("Key", groupHeadKey);
                        groupHeadNode.setAttribute("GroupColumnKeys", "OID");
                        groupHeadNode.addNode(XmlDiffProcessor.getTableRowDefaultPanelNode("LinearLayoutPanel", groupHeadKey));
                        tableViewRowNode.getParent().addNode(groupHeadNode, index);
                    }
                    XmlDiffProcessor.genXmlDiff(xmlTree, tableViewRowNode.getParent(), diff, true);
                    continue;
                }
                if (propertyName.equals(Property.HasGroupTail.name)) {
                    if (property.newValue.equals("None")) {
                        index = tableViewRowNode.getParent().getChildren().indexOf(tableViewRowNode);
                        if (index >= 0 && index < tableViewRowNode.getParent().getChildren().size() - 1 && (nextNode = (TagNode)tableViewRowNode.getParent().getChildren().get(index + 2)) != null && nextNode.getAttributes().get("RowType") != null && nextNode.getAttributes().get("RowType").equals("GroupTail")) {
                            tableViewRowNode.getParent().getChildren().remove(nextNode);
                        }
                    } else if (property.newValue.equals("Contain")) {
                        index = tableViewRowNode.getParent().getChildren().indexOf(tableViewRowNode);
                        TagNode groupTailNode = new TagNode("TableRow", null);
                        String groupTailKey = String.valueOf(tableViewRowNode.getAttributes().get("Key")) + "_GroupTail";
                        groupTailNode.setAttribute("RowType", "GroupTail");
                        groupTailNode.setAttribute("Key", groupTailKey);
                        groupTailNode.addNode(XmlDiffProcessor.getTableRowDefaultPanelNode("LinearLayoutPanel", groupTailKey));
                        if (index == tableViewRowNode.getParent().getChildren().size() - 1) {
                            tableViewRowNode.getParent().addNode(groupTailNode);
                        } else {
                            tableViewRowNode.getParent().addNode(groupTailNode, index + 1);
                        }
                    }
                    XmlDiffProcessor.genXmlDiff(xmlTree, tableViewRowNode.getParent(), diff, true);
                    continue;
                }
                XmlDiffProcessor.setSonNodeProperties(diff, tableViewRowNode, propertyName, newValue);
                XmlDiffProcessor.genXmlDiff(xmlTree, tableViewRowNode, diff, true);
            }
            return;
        } else if (MetaObjectType.AddTableViewRow.equals(metaObjectType)) {
            MetaComponent metaComp = IOMetaObject.getComponentByKey(metaForm, diff.parentKey);
            String controlType = metaComp instanceof MetaTableView ? "TableView" : "CollectionView";
            String tableViewKey = metaComp.getKey();
            TagNode tableViewNode = xmlTree.xmlTree.getTagNode(String.valueOf(controlType) + "@" + metaComp.getKey());
            TagNode tableRowCollectionNode = tableViewNode.findFirstTagNodeByTagName(controlType.equals("TableView") ? "TableRowCollection" : "CollectionViewRowCollection");
            DataTable rowInfoTable = document.get("ED_AddTableViewRow");
            List<TagNode> rowNodeList = tableRowCollectionNode.findNodesByTagName(controlType.equals("TableView") ? "TableRow" : "CollectionViewRow");
            String newRowKey = String.valueOf(tableViewKey) + "Row1";
            ArrayList<String> keySet = new ArrayList<String>();
            int i = 1;
            while (i <= rowNodeList.size()) {
                TagNode rowNode = rowNodeList.get(i - 1);
                keySet.add(rowNode.getAttributes().get("Key"));
                ++i;
            }
            int antI = 1;
            while (keySet.contains(newRowKey)) {
                newRowKey = String.valueOf(tableViewKey) + "Row" + ++antI;
            }
            if (rowInfoTable != null && rowInfoTable.first()) {
                String rowType = rowInfoTable.getString("RowType");
                String layoutType = rowInfoTable.getString("layoutType");
                String dataTableKey = rowInfoTable.getString("DataTableKey");
                TagNode rowNode = new TagNode(controlType.equals("TableView") ? "TableRow" : "CollectionViewRow", null);
                diff.setKey(newRowKey);
                rowNode.setAttribute("Key", newRowKey);
                rowNode.setAttribute("Caption", newRowKey);
                rowNode.setAttribute("RowType", rowType);
                rowNode.setAttribute("TableKey", dataTableKey);
                rowNode.addNode(XmlDiffProcessor.getTableRowDefaultPanelNode(layoutType, newRowKey));
                tableRowCollectionNode.addNode(rowNode);
            }
            XmlDiffProcessor.genXmlDiff(xmlTree, tableViewNode, diff, true);
            return;
        } else if (MetaObjectType.DeleteRowPanel.equals(metaObjectType)) {
            XmlDiffProcessor.dealDeleteRowPanel(xmlTree, diff);
            return;
        } else if (MetaObjectType.DeleteRowLayout.equals(metaObjectType)) {
            XmlDiffProcessor.dealDeleteRowLayout(xmlTree, diff);
            return;
        } else if (metaObjectType.equals(MetaObjectType.D_Embed)) {
            String paramsformKey = diff.getParamsformKey();
            if (!paramsformKey.equals(diff.formKey)) {
                String pathByFormKey = LoadFileTree.getPathByFormKey(paramsformKey);
                XmlTreeWithPath tree = XmlTreeWithPath.parseFilePath(pathByFormKey);
                diff.setXmlTree(tree);
            }
            TagNode tagNode = diff.getXmlTree().xmlTree.getTagNode("Embed@" + diff.getKey());
            List<DiffProperty> properties = diff.properties;
            for (DiffProperty property : properties) {
                String propertyName = property.property.name;
                if ("Key".equals(propertyName)) {
                    tagNode = diff.getXmlTree().xmlTree.getTagNode("Embed@" + property.getOrgValue());
                }
                if ("FormKey".equals(propertyName)) {
                    String key = "";
                    MetaForm embedMetaForm = MetaFactory.getGlobalInstance().getMetaForm(property.newValue);
                    String filePath = LoadFileTree.getPathByFormKey(embedMetaForm.getKey());
                    XmlTreeWithPath embedXmlTree = XmlTreeWithPath.parseFilePath(filePath);
                    List<AbstractNode> children = embedXmlTree.xmlTree.getRoot().getOrCreateChildByTagName("Body").getOrCreateChildByTagName("Block").getChildren();
                    for (AbstractNode child : children) {
                        if (!(child instanceof TagNode)) continue;
                        key = ((TagNode)child).getAttributes().get("Key");
                        break;
                    }
                    tagNode.setAttribute("RootKey", key);
                }
                if (Property.ForeColor.name.equals(propertyName) || Property.BackColor.name.equals(propertyName) || Property.HighlightColor.name.equals(propertyName) || Property.Font.name.equals(propertyName) || Property.Size.name.equals(propertyName) || Property.Bold.name.equals(propertyName) || Property.Italic.name.equals(propertyName) || Property.VAlign.name.equals(propertyName) || Property.HAlign.name.equals(propertyName)) {
                    XmlDiffProcessor.setSonNodeProperties(diff, tagNode, propertyName, property.newValue);
                    continue;
                }
                tagNode.setAttribute(propertyName, property.newValue);
            }
            XmlDiffProcessor.genXmlDiff(diff.getXmlTree(), tagNode, diff, true);
            return;
        } else {
            if (!MetaObjectType.TabItem.equals(metaObjectType)) return;
            if (diff.insertItemAfter) {
                MetaTabGroup tabGrop = (MetaTabGroup)IOMetaObject.getComponentByKey(metaForm, diff.parentKey);
                MetaTabItemCollection items = tabGrop.getItemCollection();
                int max = 0;
                String preKey = String.valueOf(diff.parentKey) + "_TabItem";
                int i = 0;
                while (i < items.size()) {
                    String key = ((MetaTabItem)items.get(i)).getKey();
                    if (key.startsWith(preKey)) {
                        String endStr = key.substring(preKey.length());
                        int value = 0;
                        if (endStr.matches("\\d+") && max < (value = Integer.parseInt(endStr))) {
                            max = value;
                        }
                    }
                    ++i;
                }
                String key = String.valueOf(preKey) + (max + 1);
                String caption = "\u83dc\u5355" + (max + 1);
                String tabGrupKey = "TabGroup@" + diff.parentKey;
                TagNode parentNode = xmlTree.xmlTree.getTagNode(tabGrupKey);
                TagNode curNode = parentNode.getChildByKey(diff.getKey());
                if (curNode == null) return;
                List<AbstractNode> children = parentNode.getChildren();
                TagNode itemNode = new TagNode("TabItem", null);
                itemNode.setAttribute("Key", key);
                itemNode.setAttribute("Text", caption);
                itemNode.setAttribute("Icon", "App/Default/TabGroup/Icon1.png");
                itemNode.setAttribute("SelectedIcon", "App/Default/TabGroup/Select1.png");
                int i2 = children.indexOf(curNode);
                parentNode.addNode(itemNode);
                XmlDiffProcessor.genXmlDiff(xmlTree, parentNode, diff, true);
                return;
            } else if (diff.moveItemAfter) {
                int afterIndex;
                String tabGrupKey = "TabGroup@" + diff.parentKey;
                TagNode parentNode = xmlTree.xmlTree.getTagNode(tabGrupKey);
                TagNode curNode = parentNode.getChildByKey(diff.getKey());
                if (curNode == null) return;
                List<AbstractNode> tabItems = parentNode.getChildrenByTagName("TabItem");
                if (tabItems.size() > 1 && (afterIndex = tabItems.indexOf(curNode) + 1) < tabItems.size()) {
                    TagNode afterNode = (TagNode)tabItems.get(afterIndex);
                    List<AbstractNode> childs = parentNode.getChildren();
                    int index1 = childs.indexOf(curNode);
                    int index2 = childs.indexOf(afterNode);
                    childs.set(index1, afterNode);
                    childs.set(index2, curNode);
                }
                XmlDiffProcessor.genXmlDiff(xmlTree, parentNode, diff, true);
                return;
            } else if (diff.moveItemFront) {
                int frontIndex;
                String tabGrupKey = "TabGroup@" + diff.parentKey;
                TagNode parentNode = xmlTree.xmlTree.getTagNode(tabGrupKey);
                TagNode curNode = parentNode.getChildByKey(diff.getKey());
                if (curNode == null) return;
                List<AbstractNode> tabItems = parentNode.getChildrenByTagName("TabItem");
                if (tabItems.size() > 1 && (frontIndex = tabItems.indexOf(curNode) - 1) >= 0) {
                    TagNode frontNode = (TagNode)tabItems.get(frontIndex);
                    List<AbstractNode> childs = parentNode.getChildren();
                    int index1 = childs.indexOf(curNode);
                    int index2 = childs.indexOf(frontNode);
                    childs.set(index1, frontNode);
                    childs.set(index2, curNode);
                }
                XmlDiffProcessor.genXmlDiff(xmlTree, parentNode, diff, true);
                return;
            } else {
                String tabGrupKey = "TabGroup@" + diff.parentKey;
                TagNode parentNode = xmlTree.xmlTree.getTagNode(tabGrupKey);
                TagNode curNode = parentNode.getChildByKey(diff.getKey());
                for (DiffProperty property : diff.properties) {
                    if (Property.Text.name.equals(property.property.name) || Property.Icon.name.equals(property.property.name) || Property.FormKey.name.equals(property.property.name) || Property.SelectedIcon.name.equals(property.property.name) || Property.ClickAnim.name.equals(property.property.name) || Property.key.name.equals(property.property.name) || Property.visible.name.equals(property.property.name) || Property.VisibleDependency.name.equals(property.property.name)) {
                        String orgValue = property.getOrgValue();
                        String newValue = property.getNewValue();
                        if (StringUtils.isBlank((CharSequence)orgValue) && StringUtils.isBlank((CharSequence)newValue)) continue;
                        String propertyName = property.property.name;
                        curNode.setAttribute(propertyName, newValue);
                        continue;
                    }
                    XmlDiffProcessor.setSonNodeProperties(diff, curNode, property.property.name, property.getNewValue());
                }
                XmlDiffProcessor.genXmlDiff(xmlTree, parentNode, diff, true);
            }
        }
    }

    private static TagNode getTableRowDefaultPanelNode(String layoutType, String newRowKey) {
        TagNode defaultPanelNode = null;
        if (layoutType.equals("LinearLayoutPanel")) {
            defaultPanelNode = new TagNode("LinearLayoutPanel", null);
            defaultPanelNode.setAttribute("Key", String.valueOf(newRowKey) + "DefaultPanel");
            defaultPanelNode.setAttribute("Caption", String.valueOf(newRowKey) + "DefaultPanel");
            defaultPanelNode.setAttribute("Height", "45px");
        } else if (layoutType.equals("GridLayoutPanel")) {
            defaultPanelNode = new TagNode("GridLayoutPanel", null);
            defaultPanelNode.setAttribute("Key", String.valueOf(newRowKey) + "DefaultPanel");
            defaultPanelNode.setAttribute("Caption", String.valueOf(newRowKey) + "DefaultPanel");
            defaultPanelNode.setAttribute("Height", "75px");
            TagNode gridRowDefCollNode = new TagNode("RowDefCollection", null);
            gridRowDefCollNode.setAttribute("RowGap", "5");
            gridRowDefCollNode.setAttribute("RowHeight", "30");
            TagNode rowDefNode1 = new TagNode("RowDef", null);
            gridRowDefCollNode.addNode(rowDefNode1);
            TagNode rowDefNode2 = new TagNode("RowDef", null);
            gridRowDefCollNode.addNode(rowDefNode2);
            TagNode gridColumnDefCollNode = new TagNode("ColumnDefCollection", null);
            gridColumnDefCollNode.setAttribute("ColumnGap", "5");
            TagNode columnDefNode1 = new TagNode("ColumnDef", null);
            columnDefNode1.setAttribute("Width", "10px");
            gridColumnDefCollNode.addNode(columnDefNode1);
            TagNode columnDefNode2 = new TagNode("ColumnDef", null);
            columnDefNode2.setAttribute("Width", "80px");
            gridColumnDefCollNode.addNode(columnDefNode2);
            TagNode columnDefNode3 = new TagNode("ColumnDef", null);
            columnDefNode3.setAttribute("Width", "100%");
            gridColumnDefCollNode.addNode(columnDefNode3);
            TagNode columnDefNode4 = new TagNode("ColumnDef", null);
            columnDefNode4.setAttribute("Width", "10px");
            gridColumnDefCollNode.addNode(columnDefNode4);
            defaultPanelNode.addNode(gridRowDefCollNode);
            defaultPanelNode.addNode(gridColumnDefCollNode);
        }
        return defaultPanelNode;
    }

    public static void dealEditViewChildLayout(TagNode compViewNode, TagNode colsNode, String childLayoutKey) throws Throwable {
        if (childLayoutKey == null) {
            return;
        }
        if (compViewNode == null) {
            return;
        }
        TagNode childLayoutNode = compViewNode.getChildByKey(childLayoutKey);
        List<AbstractNode> childLayoutNodes = compViewNode.getChildren();
        if (childLayoutNode != null) {
            AbstractNode child;
            List<AbstractNode> childrens = childLayoutNode.getChildren();
            int i = 0;
            while (i < childrens.size()) {
                TagNode itemNode;
                Map<String, String> attrs;
                child = childrens.get(i);
                if (child instanceof TagNode && (attrs = (itemNode = (TagNode)child).getAttributes()) != null && attrs.containsKey("Key")) {
                    String itemKey = attrs.get("Key");
                    if (colsNode != null) {
                        TagNode colNode = colsNode.getChildByKey(itemKey);
                        colsNode.getChildren().remove(colNode);
                    }
                    XmlDiffProcessor.dealEditViewChildLayout(compViewNode, colsNode, itemKey);
                }
                ++i;
            }
            int j = 0;
            while (j < childLayoutNodes.size()) {
                TagNode spanChildNode;
                child = childLayoutNodes.get(j);
                if (child instanceof TagNode && (spanChildNode = ((TagNode)child).getChildByKey(childLayoutKey)) != null) {
                    ((TagNode)child).getChildren().remove(spanChildNode);
                    break;
                }
                ++j;
            }
            compViewNode.getChildren().remove(childLayoutNode);
        }
    }

    public static void dealEmbedTable(XmlTreeWithPath xmlTree, Document document, Diff diff) throws Throwable {
        TagNode rootNode;
        TagNode checkRuleCollectionNode;
        String xmlFilePath;
        String tempXmlFilePath;
        String filePath;
        XmlTreeWithPath xmlTreeWithPath;
        DataTable embedDataTable = document.get("ED_EmbedTableCollection");
        TagNode embedTableCollection = xmlTree.xmlTree.getRoot().findFirstTagNodeByTagName("EmbedTableCollection");
        TagNode dataSource = xmlTree.xmlTree.getRoot().findFirstTagNodeByTagName("DataSource");
        TagNode dataObject = xmlTree.xmlTree.getRoot().findFirstTagNodeByTagName("DataObject");
        if (Objects.isNull(dataSource) && Objects.isNull(dataObject)) {
            return;
        }
        if (Objects.isNull(embedTableCollection) && embedDataTable.size() > 0) {
            embedTableCollection = dataObject.getOrCreateChildByTagName("EmbedTableCollection");
        }
        if (embedTableCollection != null) {
            embedTableCollection.deleteChildByTagName("EmbedTable");
        }
        String extend = null;
        String dataObjectKey = diff.formKey;
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
        MetaDataObjectProfile metaDataObjectProfile = (MetaDataObjectProfile)dataObjectList.get(dataObjectKey);
        if (Objects.nonNull(metaDataObjectProfile) && StringUtils.isBlank((CharSequence)(extend = metaDataObjectProfile.getExtend()))) {
            extend = metaDataObjectProfile.getDataObject().getMergeToSourceMapKey();
        }
        ArrayList<String> existKeyList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)extend) && Objects.nonNull(xmlTreeWithPath = XmlTreeWithPath.parseFilePath(filePath = StringUtils.isNotBlank((CharSequence)(tempXmlFilePath = XmlFileProcessor.instance.getTmpFile(xmlFilePath = LoadFileTree.getPathByDataObject(extend)))) ? tempXmlFilePath : xmlFilePath)) && Objects.nonNull(checkRuleCollectionNode = (rootNode = xmlTreeWithPath.xmlTree.getRoot()).getChildByTagName("EmbedTableCollection"))) {
            List<TagNode> checkRuleNodeList = checkRuleCollectionNode.findNodesByTagName("EmbedTable");
            for (TagNode tagNode : checkRuleNodeList) {
                Map<String, String> attributes = tagNode.getAttributes();
                String tableKey = attributes.get("TableKeys");
                existKeyList.add(tableKey);
            }
        }
        ArrayList<TagNode> embedTableNodeList = new ArrayList<TagNode>();
        if (embedDataTable.size() > 0) {
            ArrayList<String> keyList = new ArrayList<String>();
            int i = 0;
            while (i < embedDataTable.size()) {
                String objectKey = embedDataTable.getString(i, "ObjectKey");
                String tableKeys = embedDataTable.getString(i, "TableKey");
                if (embedDataTable.getState(i) == 1 && existKeyList.contains(tableKeys)) {
                    throw new RuntimeException("warning: \u5d4c\u5165\u6570\u636e\u6e90\u91cd\u590d!");
                }
                if (existKeyList.contains(tableKeys)) {
                    keyList.add(tableKeys);
                } else {
                    if (keyList.contains(tableKeys)) {
                        throw new RuntimeException("warning: \u5d4c\u5165\u6570\u636e\u6e90\u91cd\u590d!");
                    }
                    keyList.add(tableKeys);
                    TagNode newEmbed = new TagNode("EmbedTable", null);
                    embedTableNodeList.add(newEmbed);
                    newEmbed.setAttribute("ObjectKey", objectKey);
                    newEmbed.setAttribute("TableKeys", tableKeys);
                }
                ++i;
            }
        }
        if (CollectionUtils.isNotEmpty(embedTableNodeList)) {
            for (TagNode embedTableNode : embedTableNodeList) {
                embedTableCollection.addNode(embedTableNode);
            }
        } else {
            dataObject.deleteChildByTagName("EmbedTableCollection");
        }
    }

    private static void dealColumnExpand(DataTable headTable, XmlTreeWithPath xmlTree, Diff diff, TagNode tagNode) throws Throwable {
        String type = ColumnExpandType.toString((Integer)Integer.parseInt(headTable.getString(0, "ExpandType")));
        if (tagNode.getChildren().size() == 0 && "Title".equalsIgnoreCase(type)) {
            throw new Throwable("\u8be5\u8868\u683c\u5934\u672a\u6dfb\u52a0\u5b50\u5217\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u4e3a\u6807\u9898\u62d3\u5c55");
        }
        TagNode columnExpand = tagNode.findFirstTagNodeByTagName("ColumnExpand");
        if (columnExpand != null) {
            tagNode.deleteChildByTagName("ColumnExpand");
        }
        TagNode parentNode = tagNode.getParent().getParent();
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            String tableKey;
            String columnKey;
            String itemKey;
            String expandSourceType;
            TagNode parentColumnExpandNode;
            if (StringUtils.equalsIgnoreCase((CharSequence)parentNode.getTagName(), (CharSequence)"GridColumn") && Objects.isNull(parentColumnExpandNode = parentNode.findFirstTagNodeByTagName("ColumnExpand"))) {
                parentColumnExpandNode = new TagNode("ColumnExpand", null);
                parentColumnExpandNode.setAttribute("ExpandType", "Title");
                parentNode.addNode(parentColumnExpandNode);
            }
            TagNode expandNode = new TagNode("ColumnExpand", null);
            expandNode.setAttribute("ExpandType", type);
            String expandDependency = headTable.getString(0, "ExpandDependency");
            if (StringUtils.isNotEmpty((CharSequence)expandDependency)) {
                expandNode.setAttribute("ExpandDependency", expandDependency);
            }
            if (StringUtils.isNotEmpty((CharSequence)(expandSourceType = ExpandSourceType.toString((Integer)Integer.parseInt(headTable.getString(0, "ExpandSourceType"))))) && "Data".equalsIgnoreCase(type)) {
                expandNode.setAttribute("ExpandSourceType", expandSourceType);
            }
            if (StringUtils.isNotEmpty((CharSequence)(itemKey = headTable.getString(0, "ItemKey")))) {
                expandNode.setAttribute("ItemKey", itemKey);
            }
            if (StringUtils.isNotEmpty((CharSequence)(columnKey = headTable.getString(0, "ColumnKey"))) && !"\u65e0\u5b57\u6bb5".equalsIgnoreCase(columnKey)) {
                expandNode.setAttribute("ColumnKey", columnKey);
            }
            if (StringUtils.isNotEmpty((CharSequence)(tableKey = headTable.getString(0, "TableKey"))) && !"\u65e0\u6570\u636e\u8868".equalsIgnoreCase(tableKey)) {
                expandNode.setAttribute("TableKey", tableKey);
            }
            String columnExpandContext = headTable.getString(0, "ColumnExpand");
            CDataNode cDataNode = new CDataNode(columnExpandContext, null);
            expandNode.addNode(cDataNode);
            tagNode.addNode(expandNode);
        }
        XmlDiffProcessor.genXmlDiff(xmlTree, parentNode, diff, true);
    }

    private static void dealExtendNode(Diff diff, TagNode node) throws Throwable {
        if (StringUtils.isNotEmpty((CharSequence)diff.getMetaForm().getExtend())) {
            MetaForm extendForm = MetaFactory.getGlobalInstance().getMetaForm(diff.getMetaForm().getExtend());
            String filePath = LoadFileTree.getPathByFormKey(extendForm.getKey());
            XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(filePath);
            String xmlTreeKey = XmlDiffProcessor.getXmlTreeKey(diff, null, null);
            TagNode extendNode = xmlTreeWithPath.xmlTree.getTagNode(xmlTreeKey);
            if (Objects.isNull(extendNode)) {
                return;
            }
            String sourceValue = extendNode.getAttributes().get(diff.properties.get((int)0).property.name);
            if (StringUtils.isNotEmpty((CharSequence)sourceValue)) {
                if (sourceValue.equalsIgnoreCase(node.getAttributes().get(diff.properties.get((int)0).property.name))) {
                    node.getAttributes().remove(diff.properties.get((int)0).property.name);
                } else if (StringUtils.isNotEmpty((CharSequence)diff.properties.get((int)0).newValue)) {
                    node.getAttributes().put(diff.properties.get((int)0).property.name, diff.properties.get((int)0).newValue);
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)sourceValue) && !StringUtils.isNotEmpty((CharSequence)diff.properties.get((int)0).newValue)) {
                node.getAttributes().remove(diff.properties.get((int)0).property.name);
            }
        }
    }

    private static TagNode setNodeKey(String newValue, Diff diff) {
        TagNode gridNode = diff.getXmlTree().xmlTree.getTagNode("Grid@" + diff.properties.get((int)0).orgValue);
        gridNode.setAttribute("Key", newValue);
        List<TagNode> bodyTagNodes = diff.getXmlTree().xmlTree.getRoot().findNodesByTagName("Body");
        TagNode bodyTagNode = bodyTagNodes.get(0);
        List<TagNode> blockTagNodes = bodyTagNode.findNodesByTagName("Block");
        TagNode tagNode = blockTagNodes.get(0);
        if (tagNode != null) {
            XmlDiffProcessor.setNodeAppoint(newValue, tagNode, diff);
        }
        return bodyTagNode;
    }

    private static void setNodeAppoint(String newValue, TagNode tagNode, Diff diff) {
        List<AbstractNode> nodes = tagNode.getChildren();
        for (AbstractNode node : nodes) {
            if (!(node instanceof TagNode) || ((TagNode)node).getTagName().equalsIgnoreCase(tagNode.getTagName())) continue;
            List<TagNode> nodesByTagName = ((TagNode)node).findNodesByTagName(MetaObjectType.subDetail.name);
            if (nodesByTagName.size() != 0) {
                for (TagNode node1 : nodesByTagName) {
                    if (node1 == null || !node1.getAttributes().get("BindingGridKey").equalsIgnoreCase(diff.properties.get((int)0).orgValue)) continue;
                    node1.setAttribute("BindingGridKey", newValue);
                }
                continue;
            }
            XmlDiffProcessor.setNodeAppoint(newValue, (TagNode)node, diff);
        }
    }

    private static void dealAddRowLayout(XmlTreeWithPath xmlTree, Diff diff) {
        block31: {
            AbstractNode node2;
            MetaView metaView;
            String addDir = diff.getAddDirection();
            int x = diff.x;
            int y = diff.y;
            MetaForm metaForm = diff.getMetaForm();
            MetaViewCollection viewCollection = metaForm.getMetaBody().getViewCollection();
            if (viewCollection == null || (metaView = (MetaView)viewCollection.get("Android")) == null) break block31;
            TagNode viewNode = xmlTree.xmlTree.getTagNode("View@Android");
            if (viewNode == null) {
                return;
            }
            TagNode compView = viewNode.getChildByKey(diff.parentKey);
            TagNode layoutView = compView.getChildByKey(diff.getKey());
            List<AbstractNode> nodeList = layoutView.getChildren();
            TagNode rowNode = null;
            TagNode colNode = null;
            for (AbstractNode node2 : nodeList) {
                if (!(node2 instanceof TagNode)) continue;
                if ("RowDefCollection".equalsIgnoreCase(((TagNode)node2).getTagName())) {
                    rowNode = (TagNode)node2;
                    continue;
                }
                if (!"ColumnDefCollection".equalsIgnoreCase(((TagNode)node2).getTagName())) continue;
                colNode = (TagNode)node2;
            }
            for (AbstractNode node2 : nodeList) {
                if (!(node2 instanceof TagNode)) continue;
                String nodeX = ((TagNode)node2).getAttributes().get("X");
                String nodeY = ((TagNode)node2).getAttributes().get("Y");
                String key = ((TagNode)node2).getAttributes().get("Key");
                if (nodeX == null || nodeY == null) continue;
                switch (addDir) {
                    case "AddRowFront": {
                        if (Integer.parseInt(nodeY) < y) break;
                        ((TagNode)node2).setAttribute("Y", String.valueOf(Integer.parseInt(nodeY) + 1));
                        break;
                    }
                    case "AddRowBehind": {
                        if (Integer.parseInt(nodeY) < y + 1) break;
                        ((TagNode)node2).setAttribute("Y", String.valueOf(Integer.parseInt(nodeY) + 1));
                        break;
                    }
                    case "AddColumnBehind": {
                        if (Integer.parseInt(nodeX) < x + 1) break;
                        ((TagNode)node2).setAttribute("X", String.valueOf(Integer.parseInt(nodeX) + 1));
                        break;
                    }
                    case "AddColumnFront": {
                        if (Integer.parseInt(nodeX) < x) break;
                        ((TagNode)node2).setAttribute("X", String.valueOf(Integer.parseInt(nodeX) + 1));
                    }
                }
            }
            if ("AddRowFront".equalsIgnoreCase(addDir)) {
                node2 = new TagNode("RowDef", null);
                ((TagNode)node2).setAttribute("Height", "32px");
                if (y == 0) {
                    rowNode.addNode(node2, y);
                } else {
                    rowNode.addNode(node2, 2 * y);
                }
                XmlDiffProcessor.genXmlDiff(xmlTree, layoutView, diff, true);
            } else if ("AddRowBehind".equalsIgnoreCase(addDir)) {
                node2 = new TagNode("RowDef", null);
                ((TagNode)node2).setAttribute("Height", "32px");
                rowNode.addNode(node2, 2 * (y + 1));
                XmlDiffProcessor.genXmlDiff(xmlTree, layoutView, diff, true);
            } else if ("AddColumnFront".equalsIgnoreCase(addDir)) {
                node2 = new TagNode("ColumnDef", null);
                ((TagNode)node2).setAttribute("Width", "70px");
                if (x == 0) {
                    colNode.addNode(node2, x);
                } else {
                    colNode.addNode(node2, 2 * x);
                }
                XmlDiffProcessor.genXmlDiff(xmlTree, layoutView, diff, true);
            } else if ("AddColumnBehind".equalsIgnoreCase(addDir)) {
                node2 = new TagNode("ColumnDef", null);
                ((TagNode)node2).setAttribute("Width", "70px");
                colNode.addNode(node2, 2 * (x + 1));
                XmlDiffProcessor.genXmlDiff(xmlTree, layoutView, diff, true);
            }
        }
    }

    private static void dealAddRowPanel(XmlTreeWithPath xmlTree, Diff diff) {
        AbstractNode node2;
        String addDir = diff.getAddDirection();
        int x = diff.x;
        int y = diff.y;
        MetaForm metaForm = diff.getMetaForm();
        MetaGridLayoutPanel panel = (MetaGridLayoutPanel)IOMetaObject.getComponentByKey(metaForm, diff.parentKey);
        String gridkey = panel.getKey();
        TagNode gridNode = xmlTree.xmlTree.getTagNode("GridLayoutPanel@" + gridkey);
        List<AbstractNode> nodeList = gridNode.getChildren();
        TagNode rowNode = null;
        TagNode colNode = null;
        for (AbstractNode node2 : nodeList) {
            if (!(node2 instanceof TagNode)) continue;
            if ("RowDefCollection".equalsIgnoreCase(((TagNode)node2).getTagName())) {
                rowNode = (TagNode)node2;
                continue;
            }
            if (!"ColumnDefCollection".equalsIgnoreCase(((TagNode)node2).getTagName())) continue;
            colNode = (TagNode)node2;
        }
        for (AbstractNode node2 : nodeList) {
            if (!(node2 instanceof TagNode)) continue;
            String nodeX = ((TagNode)node2).getAttributes().get("X");
            String nodeY = ((TagNode)node2).getAttributes().get("Y");
            String key = ((TagNode)node2).getAttributes().get("Key");
            if (StringUtils.isNotEmpty((CharSequence)metaForm.getExtend()) && StringUtils.isNotEmpty((CharSequence)key)) {
                MetaComponent metaComponent = IOMetaObject.getComponentByKey(metaForm, key);
                nodeX = String.valueOf(metaComponent.getX());
                nodeY = String.valueOf(metaComponent.getY());
            }
            if (nodeX == null || nodeY == null) continue;
            switch (addDir) {
                case "AddRowFront": {
                    if (Integer.parseInt(nodeY) < y) break;
                    ((TagNode)node2).setAttribute("Y", String.valueOf(Integer.parseInt(nodeY) + 1));
                    break;
                }
                case "AddRowBehind": {
                    if (Integer.parseInt(nodeY) < y + 1) break;
                    ((TagNode)node2).setAttribute("Y", String.valueOf(Integer.parseInt(nodeY) + 1));
                    break;
                }
                case "AddColumnBehind": {
                    if (Integer.parseInt(nodeX) < x + 1) break;
                    ((TagNode)node2).setAttribute("X", String.valueOf(Integer.parseInt(nodeX) + 1));
                    break;
                }
                case "AddColumnFront": {
                    if (Integer.parseInt(nodeX) < x) break;
                    ((TagNode)node2).setAttribute("X", String.valueOf(Integer.parseInt(nodeX) + 1));
                }
            }
        }
        if ("AddRowFront".equalsIgnoreCase(addDir)) {
            node2 = new TagNode("RowDef", null);
            ((TagNode)node2).setAttribute("Height", "32px");
            if (y == 0) {
                rowNode.addNode(node2, y);
            } else {
                rowNode.addNode(node2, 2 * y - 1);
            }
            XmlDiffProcessor.handleExtraLayout(gridNode, y, true);
            XmlDiffProcessor.genXmlDiff(xmlTree, gridNode, diff, true);
        } else if ("AddRowBehind".equalsIgnoreCase(addDir)) {
            node2 = new TagNode("RowDef", null);
            ((TagNode)node2).setAttribute("Height", "32px");
            if (y == 0) {
                rowNode.addNode(node2, y);
            } else {
                rowNode.addNode(node2, 2 * (y + 1) - 1);
            }
            XmlDiffProcessor.handleExtraLayout(gridNode, y, true);
            XmlDiffProcessor.genXmlDiff(xmlTree, gridNode, diff, true);
        } else if ("AddColumnFront".equalsIgnoreCase(addDir)) {
            node2 = new TagNode("ColumnDef", null);
            ((TagNode)node2).setAttribute("Width", "70px");
            if (x == 0) {
                colNode.addNode(node2, x);
            } else {
                colNode.addNode(node2, 2 * x - 1);
            }
            XmlDiffProcessor.genXmlDiff(xmlTree, gridNode, diff, true);
        } else if ("AddColumnBehind".equalsIgnoreCase(addDir)) {
            node2 = new TagNode("ColumnDef", null);
            ((TagNode)node2).setAttribute("Width", "70px");
            if (x == 0) {
                colNode.addNode(node2, x);
            } else {
                colNode.addNode(node2, 2 * (x + 1) - 1);
            }
            XmlDiffProcessor.genXmlDiff(xmlTree, gridNode, diff, true);
        }
    }

    public static void dealDeleteRowLayout(XmlTreeWithPath xmlTree, Diff diff) throws Throwable {
        block18: {
            AbstractNode node2;
            MetaView metaView;
            String delDir = diff.getDeleteDirection();
            int x = diff.x;
            int y = diff.y;
            MetaForm metaForm = diff.getMetaForm();
            MetaViewCollection viewCollection = metaForm.getMetaBody().getViewCollection();
            if (viewCollection == null || (metaView = (MetaView)viewCollection.get("Android")) == null) break block18;
            TagNode viewNode = xmlTree.xmlTree.getTagNode("View@Android");
            if (viewNode == null) {
                return;
            }
            TagNode compView = viewNode.getChildByKey(diff.parentKey);
            TagNode layoutView = compView.getChildByKey(diff.getKey());
            List<AbstractNode> childrenNode = layoutView.getChildren();
            block8: for (AbstractNode node2 : childrenNode) {
                if (!(node2 instanceof TagNode)) continue;
                String nodeX = ((TagNode)node2).getAttributes().get("X");
                String nodeY = ((TagNode)node2).getAttributes().get("Y");
                String key = ((TagNode)node2).getAttributes().get("Key");
                if (StringUtils.isNotEmpty((CharSequence)metaForm.getExtend()) && StringUtils.isNotEmpty((CharSequence)key)) {
                    MetaComponent metaComponent = IOMetaObject.getComponentByKey(metaForm, key);
                    nodeX = String.valueOf(metaComponent.getX());
                    nodeY = String.valueOf(metaComponent.getY());
                }
                if (nodeX == null || nodeY == null) continue;
                switch (delDir) {
                    case "DeleteColumn": {
                        if (Integer.parseInt(nodeX) >= x && Integer.parseInt(nodeX) != 0) {
                            ((TagNode)node2).setAttribute("X", String.valueOf(Integer.parseInt(nodeX) - 1));
                            break;
                        }
                        if (Integer.parseInt(nodeX) != x || x != 0) continue block8;
                        ((TagNode)node2).setAttribute("X", "0");
                        break;
                    }
                    case "DeleteRow": {
                        if (Integer.parseInt(nodeY) >= y && Integer.parseInt(nodeY) != 0) {
                            ((TagNode)node2).setAttribute("Y", String.valueOf(Integer.parseInt(nodeY) - 1));
                            break;
                        }
                        if (Integer.parseInt(nodeY) != y || y != 0) continue block8;
                        ((TagNode)node2).setAttribute("Y", "0");
                    }
                }
            }
            if ("DeleteRow".equalsIgnoreCase(delDir)) {
                node2 = layoutView.getOrCreateChildByTagName("RowDefCollection");
                ((TagNode)node2).deleteChildX(node2, 2 * y + 1);
                XmlDiffProcessor.genXmlDiff(xmlTree, layoutView, diff, true);
            } else if ("DeleteColumn".equalsIgnoreCase(delDir)) {
                node2 = layoutView.getOrCreateChildByTagName("ColumnDefCollection");
                ((TagNode)node2).deleteChidY(node2, 2 * x + 1);
                XmlDiffProcessor.genXmlDiff(xmlTree, layoutView, diff, true);
            }
        }
    }

    public static void dealDeleteRowPanel(XmlTreeWithPath xmlTree, Diff diff) throws Throwable {
        AbstractNode node2;
        String delDir = diff.getDeleteDirection();
        int x = diff.x;
        int y = diff.y;
        MetaForm metaForm = diff.getMetaForm();
        MetaGridLayoutPanel metaGridLayoutPanel = (MetaGridLayoutPanel)IOMetaObject.getComponentByKey(metaForm, diff.parentKey);
        String gridkey = metaGridLayoutPanel.getKey();
        TagNode gridNode = xmlTree.xmlTree.getTagNode("GridLayoutPanel@" + gridkey);
        List<AbstractNode> childrenNode = gridNode.getChildren();
        block8: for (AbstractNode node2 : childrenNode) {
            if (!(node2 instanceof TagNode)) continue;
            String nodeX = ((TagNode)node2).getAttributes().get("X");
            String nodeY = ((TagNode)node2).getAttributes().get("Y");
            String key = ((TagNode)node2).getAttributes().get("Key");
            if (StringUtils.isNotEmpty((CharSequence)metaForm.getExtend()) && StringUtils.isNotEmpty((CharSequence)key)) {
                MetaComponent metaComponent = IOMetaObject.getComponentByKey(metaForm, key);
                nodeX = String.valueOf(metaComponent.getX());
                nodeY = String.valueOf(metaComponent.getY());
            }
            if (nodeX == null || nodeY == null) continue;
            switch (delDir) {
                case "DeleteColumn": {
                    if (Integer.parseInt(nodeX) >= x && Integer.parseInt(nodeX) != 0) {
                        ((TagNode)node2).setAttribute("X", String.valueOf(Integer.parseInt(nodeX) - 1));
                        break;
                    }
                    if (Integer.parseInt(nodeX) != x || x != 0) continue block8;
                    ((TagNode)node2).setAttribute("X", "0");
                    break;
                }
                case "DeleteRow": {
                    if (Integer.parseInt(nodeY) >= y && Integer.parseInt(nodeY) != 0) {
                        ((TagNode)node2).setAttribute("Y", String.valueOf(Integer.parseInt(nodeY) - 1));
                        break;
                    }
                    if (Integer.parseInt(nodeY) != y || y != 0) continue block8;
                    ((TagNode)node2).setAttribute("Y", "0");
                }
            }
        }
        if ("DeleteRow".equalsIgnoreCase(delDir)) {
            node2 = gridNode.getOrCreateChildByTagName("RowDefCollection");
            ((TagNode)node2).deleteChildX(node2, 2 * y + 1);
            XmlDiffProcessor.handleExtraLayout(gridNode, y, false);
            XmlDiffProcessor.genXmlDiff(xmlTree, gridNode, diff, true);
        } else if ("DeleteColumn".equalsIgnoreCase(delDir)) {
            node2 = gridNode.getOrCreateChildByTagName("ColumnDefCollection");
            ((TagNode)node2).deleteChidY(node2, 2 * x + 1);
            XmlDiffProcessor.genXmlDiff(xmlTree, gridNode, diff, true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean fieldHastRely(String key, String dataObjectKey, String tableKey) {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        try {
            IDLookup idLookup;
            MetaFormProfile metaFormProfile;
            Iterator iterator = metaFactory.getMetaFormList().iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while ((metaFormProfile = (MetaFormProfile)iterator.next()).getForm() == null || metaFormProfile.getForm().getDataSource() == null || metaFormProfile.getForm().getDataSource().getDataObject() == null || !dataObjectKey.equals(metaFormProfile.getForm().getDataSource().getDataObject().getKey()) || !Objects.nonNull((idLookup = IDLookup.getIDLookup(metaFormProfile.getForm())).getColumKeysAndFieldListKeys(tableKey)) || !idLookup.getColumKeysAndFieldListKeys(tableKey).containsKey(key));
            return false;
        }
        catch (Throwable throwable) {
            LogSvr.getInstance().error(throwable.getMessage(), throwable);
        }
        return true;
    }

    public static void handleFieldinformation(Diff diff, XmlTreeWithPath xmlTree) {
        for (DiffProperty property : diff.properties) {
            String orgValue = property.getOrgValue();
            String newValue = property.getNewValue();
            if (StringUtils.isBlank((CharSequence)orgValue) && StringUtils.isBlank((CharSequence)newValue)) continue;
            String reserTwo = diff.getReserveTwo();
            String table_Key = "Table@" + reserTwo;
            TagNode table_node = diff.getXmlTree().xmlTree.getTagNode(table_Key);
            String column_Key = "Column@" + diff.getReserveThree();
            TagNode column_node = diff.getXmlTree().xmlTree.getTagNode(column_Key);
            if (column_node == null || table_node == null) continue;
            TagNode node = XmlDiffProcessor.fieldinFormation(diff, newValue, column_node, table_node);
            XmlDiffProcessor.genXmlDiff(xmlTree, node, diff, true);
        }
    }

    public static TagNode fieldinFormation(Diff diff, String newValue, TagNode node, TagNode parentNode) {
        TagNode childByTagNode = parentNode.findChildByTagNode(node);
        String reserveOne = diff.getReserveOne();
        if ("DataType".equalsIgnoreCase(reserveOne)) {
            childByTagNode.setAttribute(reserveOne, DataType.toString((Integer)Integer.parseInt(newValue)));
        } else if ("SortType".equalsIgnoreCase(reserveOne)) {
            childByTagNode.setAttribute(reserveOne, SortType.toString((Integer)Integer.parseInt(newValue)));
        } else if ("PeriodGranularity".equalsIgnoreCase(reserveOne)) {
            childByTagNode.setAttribute(reserveOne, DMPeriodGranularityType.toString((Integer)Integer.parseInt(newValue)));
        } else if ("SplitType".equalsIgnoreCase(reserveOne)) {
            childByTagNode.setAttribute(reserveOne, DataSplitType.toString((Integer)Integer.parseInt(newValue)));
        } else if ("GroupType".equalsIgnoreCase(reserveOne)) {
            childByTagNode.setAttribute(reserveOne, DataGroupGranularity.toString((Integer)Integer.parseInt(newValue)));
        } else if ("NeedRights".equalsIgnoreCase(reserveOne)) {
            childByTagNode.setAttribute(reserveOne, ColumnRightsType.toString((Integer)Integer.parseInt(newValue)));
        } else if (diff.getTrueOrfalse().booleanValue()) {
            childByTagNode.setAttribute(reserveOne, newValue);
        } else {
            childByTagNode.getAttributes().remove(reserveOne);
        }
        return parentNode;
    }

    private static TagNode modifyDataSource(Diff diff, String key, String name) {
        if (diff.tableKey != null && !"".equals(diff.tableKey) || diff.subTableKey != null && !"".equals(diff.subTableKey)) {
            TagNode tableCollection = diff.getXmlTree().xmlTree.getRoot().findFirstTagNodeByTagName("TableCollection");
            TagNode table = new TagNode("Table", null);
            table.setAttribute("Key", key);
            table.setAttribute("Caption", name);
            table.setAttribute("DBTableName", key);
            table.setAttribute("ParentKey", "");
            table.setAttribute("TableMode", "Detail");
            if (diff.getMetaForm().getFormType() == 5) {
                table.setAttribute("Persist", "false");
            }
            TagNode column = new TagNode("Column", null);
            column.setAttribute("Key", "OID");
            column.setAttribute("Caption", "\u5bf9\u8c61\u6807\u8bc6");
            column.setAttribute("DataType", "Long");
            TagNode column1 = new TagNode("Column", null);
            column1.setAttribute("Key", "SOID");
            column1.setAttribute("Caption", "\u4e3b\u5bf9\u8c61\u6807\u8bc6");
            column1.setAttribute("DataType", "Long");
            TagNode column2 = new TagNode("Column", null);
            column2.setAttribute("Key", "POID");
            column2.setAttribute("Caption", "\u7236\u5bf9\u8c61\u6807\u8bc6");
            column2.setAttribute("DataType", "Long");
            TagNode column3 = new TagNode("Column", null);
            column3.setAttribute("Key", "VERID");
            column3.setAttribute("Caption", "\u5bf9\u8c61\u7248\u672c");
            column3.setAttribute("DataType", "Integer");
            TagNode column4 = new TagNode("Column", null);
            column4.setAttribute("Key", "DVERID");
            column4.setAttribute("Caption", "\u5bf9\u8c61\u660e\u7ec6\u7248\u672c");
            column4.setAttribute("DataType", "Integer");
            table.addNode(column);
            table.addNode(column1);
            table.addNode(column2);
            table.addNode(column3);
            table.addNode(column4);
            tableCollection.addNode(table);
            return tableCollection;
        }
        return null;
    }

    private static void dealForm(Diff diff, XmlTreeWithPath xmlTree) throws Throwable {
        TagNode formNode = xmlTree.xmlTree.getRoot();
        for (DiffProperty property : diff.properties) {
            String newValue = property.getNewValue();
            String propertyName = property.property.name;
            XmlDiffProcessor.setSonNodeProperties(diff, formNode, propertyName, newValue);
        }
        XmlDiffProcessor.genXmlDiff(xmlTree, formNode, diff, true);
    }

    public static void genXmlDiff(XmlTreeWithPath xmlTree, TagNode node, Diff diff, boolean isFirst) {
        while (node.getElement() == null) {
            node = node.getParent();
        }
        int startLine = xmlTree.xmlTree.getLineByIndex(node.getElement().getBgIndex());
        String orgXmlFragment = xmlTree.xmlTree.getNodeString(startLine);
        String newXmlFragment = DesignIOMetaUtil.getXml(node);
        if (isFirst) {
            diff.setXmlDiff(xmlTree, startLine, orgXmlFragment, newXmlFragment);
        } else {
            diff.setXmlDiff2(xmlTree, startLine, orgXmlFragment, newXmlFragment);
        }
    }

    public static void genSingleXmlDiff(XmlTreeWithPath xmlTree, TagNode node, Diff diff) {
        XmlDiffProcessor.genXmlDiff(xmlTree, node, diff, true);
    }

    private static void setColumnKey(MetaForm metaForm, Diff diff, String newValue, String propertyName, XmlTreeWithPath xmlTree, TagNode node, String orgValue) throws Throwable {
        TagNode childByTagName;
        boolean isNoField = "\u65e0\u5b57\u6bb5".equals(newValue);
        newValue = XmlDiffProcessor.checking(newValue);
        TagNode newTagNode = null;
        TagNode newTagNode2 = null;
        String refObjectKey = metaForm.getDataSource().getRefObjectKey();
        String tableKey = diff.getReserveTwo();
        TagNode tableTagNode2 = null;
        MetaFormProfile metaFormProfile = (MetaFormProfile)MetaFactory.getGlobalInstance().getMetaFormList().get(metaForm.getKey());
        if (metaFormProfile == null) {
            MetaFactory.getGlobalInstance().getExtFormList().get(metaForm.getKey());
        }
        Boolean mergeToSource1 = metaFormProfile.getMergeToSource();
        if (StringUtils.isBlank((CharSequence)metaForm.getExtend()) || mergeToSource1.booleanValue()) {
            Map<String, String> attributes;
            TagNode tableTagNode;
            if (StringUtils.isNotEmpty((CharSequence)refObjectKey)) {
                tableTagNode = diff.getDataObjectXmlTree().xmlTree.getTagNode("Table@" + tableKey);
                if (Objects.nonNull(diff.getOtherDataObjectOrgTree())) {
                    tableTagNode2 = diff.getOtherDataObjectOrgTree().xmlTree.getTagNode("Table@" + tableKey);
                }
            } else {
                tableTagNode = diff.getXmlTree().xmlTree.getTagNode("Table@" + tableKey);
            }
            if (tableTagNode != null) {
                for (AbstractNode child : tableTagNode.getChildren()) {
                    if (!(child instanceof TagNode) || (attributes = ((TagNode)child).getAttributes()) == null || attributes.get("Key") == null || !attributes.get("Key").equalsIgnoreCase(newValue)) continue;
                    newTagNode = (TagNode)child;
                    break;
                }
            }
            if (tableTagNode2 != null) {
                for (AbstractNode child : tableTagNode2.getChildren()) {
                    if (!(child instanceof TagNode) || (attributes = ((TagNode)child).getAttributes()) == null || attributes.get("Key") == null || !attributes.get("Key").equalsIgnoreCase(newValue)) continue;
                    newTagNode2 = (TagNode)child;
                    break;
                }
            }
            int controlType = diff.getControlType();
            String datatype = XmlDiffProcessor.getDatatype(controlType);
            if (Objects.isNull(newTagNode) && Objects.isNull(newTagNode2)) {
                boolean isReplace;
                int haveRelyOn = XmlDiffProcessor.isHaveRelyOn(orgValue, xmlTree.xmlTree, tableKey);
                boolean orgValueIsSystemField = "OID".equals(orgValue) || "SOID".equals(orgValue) || "POID".equals(orgValue) || "VERID".equals(orgValue) || "Sequence".equals(orgValue) || "DVERID".equals(orgValue);
                boolean bl = isReplace = haveRelyOn == 1 && !orgValueIsSystemField;
                if (isReplace && StringUtils.isNotEmpty((CharSequence)orgValue) && !isNoField) {
                    tableTagNode.deleteChildByTagKey(orgValue);
                    TagNode column = new TagNode("Column", null);
                    column.setAttribute("Key", newValue);
                    column.setAttribute("Caption", newValue);
                    column.setAttribute("DataType", datatype);
                    if ("Varchar".equalsIgnoreCase(datatype)) {
                        column.setAttribute("Length", "255");
                    }
                    if (controlType == 206) {
                        String orgKey = orgValue;
                        String newKey = newValue;
                        if (orgValue.toLowerCase().endsWith("id")) {
                            orgKey = orgValue.substring(0, orgValue.length() - 2);
                        }
                        if (newValue.toLowerCase().endsWith("id")) {
                            newKey = newValue.substring(0, newValue.length() - 2);
                        }
                        tableTagNode.deleteChildByTagKey(String.valueOf(orgKey) + "Code");
                        tableTagNode.deleteChildByTagKey(String.valueOf(orgKey) + "Name");
                        TagNode code = new TagNode("Column", null);
                        code.setAttribute("Key", String.valueOf(newKey) + "Code");
                        code.setAttribute("Caption", newValue);
                        code.setAttribute("DataType", "Varchar");
                        code.setAttribute("Length", "30");
                        tableTagNode.addNode(code);
                        column.setAttribute("CodeColumnKey", String.valueOf(newKey) + "Code");
                    }
                    tableTagNode.addNode(column);
                    if (StringUtils.isNotEmpty((CharSequence)refObjectKey)) {
                        XmlDiffProcessor.genXmlDiff(diff.getDataObjectXmlTree(), tableTagNode, diff, false);
                    } else {
                        XmlDiffProcessor.genXmlDiff(xmlTree, tableTagNode, diff, false);
                    }
                } else if (StringUtils.isNotEmpty((CharSequence)newValue)) {
                    TagNode column = new TagNode("Column", null);
                    column.setAttribute("Key", newValue);
                    column.setAttribute("Caption", newValue);
                    column.setAttribute("DataType", datatype);
                    if ("Varchar".equalsIgnoreCase(datatype)) {
                        column.setAttribute("Length", "255");
                    }
                    tableTagNode.addNode(column);
                    if (StringUtils.isNotEmpty((CharSequence)refObjectKey)) {
                        XmlDiffProcessor.genXmlDiff(diff.getDataObjectXmlTree(), tableTagNode, diff, false);
                    } else {
                        XmlDiffProcessor.genXmlDiff(xmlTree, tableTagNode, diff, false);
                    }
                }
            }
        }
        if (isNoField && Objects.nonNull(childByTagName = node.getChildByTagName("DataBinding"))) {
            childByTagName.deleteAttribute("TableKey");
        }
        XmlDiffProcessor.setSonNodeProperties(diff, node, propertyName, newValue);
        if (!"GridCell".equalsIgnoreCase(node.getTagName()) && !isNoField) {
            XmlDiffProcessor.setSonNodeProperties(diff, node, "TableKey", tableKey);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int isHaveRelyOn(String columnValue, XmlTree xmlTree, String tableKey) {
        String s = xmlTree.getRoot().getAttributes().get("MergeToSource");
        if ("true".equals(s)) {
            String extendKey = xmlTree.getRoot().getAttributes().get("Extend");
            MetaForm metaForm = null;
            try {
                metaForm = MetaFactory.getGlobalInstance().getMetaForm(extendKey);
            }
            catch (Throwable e) {
                LogSvr.getInstance().error(e.getMessage(), e);
            }
            IDLookup idLookup = IDLookup.getIDLookup(metaForm);
            Collection<String> fieldKeys = idLookup.getFieldKeys();
            for (String fieldKey : fieldKeys) {
                String columnKey;
                String columnKey2;
                MetaComponent componentByKey = null;
                try {
                    componentByKey = idLookup.getComponentByKey(fieldKey);
                }
                catch (Exception e) {
                    LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
                }
                if (componentByKey != null && componentByKey.getDataBinding() != null && !(columnKey2 = componentByKey.getDataBinding().getColumnKey()).isEmpty() && columnKey2.equalsIgnoreCase(columnValue)) {
                    return 1;
                }
                MetaGridCell gridCellByKey = idLookup.getGridCellByKey(fieldKey);
                if (gridCellByKey == null || gridCellByKey.getDataBinding() == null || (columnKey = gridCellByKey.getDataBinding().getColumnKey()).isEmpty() || !columnKey.equalsIgnoreCase(columnValue)) continue;
                return 1;
            }
        }
        if (StringUtils.isEmpty((CharSequence)columnValue) || "null".equals(columnValue)) {
            return 0;
        }
        if (StringUtils.isBlank((CharSequence)tableKey)) {
            return 1;
        }
        int anInt = 0;
        int anInt1 = 0;
        int anInt2 = 0;
        int anInt3 = 0;
        if ("OID".equals(columnValue) || "SOID".equals(columnValue) || "POID".equals(columnValue) || "VERID".equals(columnValue) || "DVERID".equals(columnValue)) {
            anInt3 = 1;
        }
        List<TagNode> dataBinding = xmlTree.getRoot().findNodesByTagName("DataBinding");
        List<TagNode> gridRow = xmlTree.getRoot().findNodesByTagName("GridRow");
        List<TagNode> dataSource = xmlTree.getRoot().findNodesByTagName("DataSource");
        if (dataSource.size() > 0 && columnValue.equals(dataSource.get(0).getAttributes().get("RefObjectKey"))) {
            return 1;
        }
        try {
            MetaFormList metaFormList = MetaFactory.getGlobalInstance().getMetaFormList();
            for (MetaFormProfile metaFormProfile : metaFormList) {
                if (metaFormProfile.getForm() == null || metaFormProfile.getForm().getDataSource() == null || !columnValue.equals(metaFormProfile.getForm().getDataSource().getRefObjectKey())) continue;
                return 1;
            }
        }
        catch (Throwable throwable) {
            LogSvr.getInstance().error(throwable.getMessage(), throwable);
        }
        for (TagNode col : dataBinding) {
            String columnKey = col.getAttributes().get("ColumnKey");
            String tableKey1 = col.getAttributes().get("TableKey");
            if (columnKey == null) continue;
            if (StringUtils.isEmpty((CharSequence)tableKey1) && columnKey.equals(columnValue)) {
                ++anInt;
            }
            if (tableKey.equals(tableKey1) && columnKey.equals(columnValue)) {
                ++anInt;
            }
            if (!tableKey.equals(tableKey1) || !tableKey.equals(columnValue)) continue;
            ++anInt;
        }
        for (TagNode col : gridRow) {
            String columnKey1 = col.getAttributes().get("TableKey");
            if (columnKey1 == null || !columnKey1.equals(columnValue)) continue;
            ++anInt2;
        }
        return anInt + anInt1 + anInt2 + anInt3;
    }

    private static String checking(String newValue) {
        Matcher m = p.matcher(newValue = newValue.split(" {2}")[0].replaceAll("\\s*", ""));
        if (!m.matches()) {
            newValue = "";
        }
        return newValue;
    }

    private static void setSonNodeCData(TagNode node, String propertyName, String newValue) {
        if (StringUtils.isEmpty((CharSequence)newValue)) {
            node.deleteChildByTagName(propertyName);
        } else {
            TagNode valueChangedNode = node.getOrCreateChildByTagName(propertyName);
            valueChangedNode.setCDataValue(newValue);
        }
    }

    private static void setThisNodeCData(TagNode node, String newValue) {
        if (StringUtils.isEmpty((CharSequence)newValue)) {
            node.deleteCDataValue();
        } else {
            node.setCDataValue(newValue);
        }
    }

    private static void setSonNodeProperties(Diff diff, TagNode node, String propertyName, String newValue) throws Throwable {
        boolean isNull;
        MetaFormProfile metaFormProfile = (MetaFormProfile)MetaFactory.getGlobalInstance().getMetaFormList().get(diff.getMetaForm().getKey());
        if (metaFormProfile == null) {
            metaFormProfile = (MetaFormProfile)MetaFactory.getGlobalInstance().getExtFormList().get(diff.getMetaForm().getKey());
        }
        Boolean mergeToSource1 = metaFormProfile.getMergeToSource();
        if (Objects.isNull(node)) {
            return;
        }
        boolean bl = isNull = StringUtils.isEmpty((CharSequence)newValue) || "\u65e0\u6570\u636e\u8868".equalsIgnoreCase(newValue) || "\u65e0\u5b57\u6bb5".equalsIgnoreCase(newValue);
        if (mergeToSource1.booleanValue()) {
            isNull = false;
        }
        if ("\u65e0\u6570\u636e\u8868".equalsIgnoreCase(newValue)) {
            newValue = "";
        }
        DiffProperty diffProperty = diff.properties.get(0);
        if (StringUtils.isEmpty((CharSequence)diffProperty.propertyValueByLocation)) {
            if (diffProperty.propertyIsCData.booleanValue()) {
                XmlDiffProcessor.setThisNodeCData(node, newValue);
            } else if (isNull) {
                if (StringUtils.isNotEmpty((CharSequence)diffProperty.propertyParent)) {
                    TagNode propertyParentNode = node.getOrCreateChildByTagName(diffProperty.propertyParent);
                    propertyParentNode.deleteAttribute(propertyName);
                    if (propertyParentNode.getAttributes().size() == 0) {
                        propertyParentNode.getParent().getChildren().remove(propertyParentNode);
                    }
                } else if (StringUtils.isNotEmpty((CharSequence)metaFormProfile.getForm().getExtend())) {
                    node.setAttributeNotRemove(propertyName, newValue);
                } else {
                    node.deleteAttribute(propertyName);
                }
            } else if (StringUtils.isNotEmpty((CharSequence)diffProperty.propertyParent)) {
                TagNode propertyParentNode = node.getOrCreateChildByTagName(diffProperty.propertyParent);
                propertyParentNode.setAttributeNotRemove(propertyName, newValue);
            } else if (mergeToSource1.booleanValue()) {
                node.setAttributeNotRemove(propertyName, newValue);
            } else {
                node.setAttribute(propertyName, newValue);
                if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"ItemKey") && StringUtils.isNotBlank((CharSequence)newValue)) {
                    node.deleteAttribute(Property.ItemKeySourceType.name);
                    node.deleteAttribute(Property.ItemKeySource.name);
                    if (newValue.endsWith("__Dic")) {
                        node.setAttribute(Property.StateMask.name, "Enable|Disable|Discard");
                    }
                }
                if (StringUtils.equals((CharSequence)propertyName, (CharSequence)Property.ItemKeySourceType.name) && StringUtils.isNotBlank((CharSequence)newValue)) {
                    node.deleteAttribute("ItemKey");
                    node.deleteChildByTagName("ItemFilter");
                }
                if (diff.getControlType() == 305) {
                    String compViewKey;
                    TagNode compViewNode;
                    if (propertyName.equalsIgnoreCase("Orientation")) {
                        node.setAttributeNotRemove(propertyName, newValue);
                    }
                    if (propertyName.equalsIgnoreCase("Key") && (compViewNode = diff.getXmlTree().xmlTree.getTagNode(compViewKey = "ComponentView@" + diff.getKey())) != null) {
                        compViewNode.setAttribute("Key", newValue);
                        TagNode rootLayout = compViewNode.getChildByKey(diff.getKey());
                        if (rootLayout != null) {
                            rootLayout.setAttribute("Key", newValue);
                        }
                        XmlDiffProcessor.genXmlDiff(diff.getXmlTree(), compViewNode, diff, false);
                    }
                }
                if (diff.getControlType() == 316 && propertyName.equalsIgnoreCase("ColumnCount")) {
                    node.setAttributeNotRemove(propertyName, newValue);
                }
                if (propertyName.equalsIgnoreCase("Visible") || propertyName.equalsIgnoreCase("Enable")) {
                    node.setAttribute(String.valueOf(propertyName) + "Dependency", diff.getReserveTwo());
                }
                if (StringUtils.equals((CharSequence)propertyName, (CharSequence)Property.FormulaCaption.name)) {
                    node.setAttribute("CaptionDependency", diff.getReserveTwo());
                    if (diff.getMetaObjectType() == MetaObjectType.field) {
                        node.setAttribute(Property.caption.name, "");
                    }
                }
                if (StringUtils.equals((CharSequence)propertyName, (CharSequence)Property.CellType.name) && StringUtils.equals((CharSequence)newValue, (CharSequence)ControlType.toString((Integer)208))) {
                    node.setAttribute("Caption", diff.getKey());
                }
                if (StringUtils.equals((CharSequence)propertyName, (CharSequence)Property.SourceType.name) && diff.getControlType() == 226 && node.getChildByTagName("ChartDataSource") != null) {
                    node.deleteChildByTagName("ChartDataSource");
                }
                if (StringUtils.equals((CharSequence)propertyName, (CharSequence)Property.SourceType.name) && diff.getControlType() == 233 && node.getAttributes().get(propertyName) != "Url") {
                    node.deleteAttribute("URLPrefix");
                }
            }
        } else {
            String sonNodeName = diffProperty.propertyValueByLocation;
            String parentNodeName = diffProperty.propertyParent;
            if (!"".equalsIgnoreCase(parentNodeName)) {
                node = node.getOrCreateChildByTagName(parentNodeName);
                if ("Font".equalsIgnoreCase(propertyName)) {
                    propertyName = "Name";
                }
            }
            TagNode childByTagName = node.getChildByTagName(sonNodeName);
            if (diffProperty.propertyIsCData.booleanValue()) {
                if (Objects.isNull(childByTagName)) {
                    if (!isNull) {
                        if (StringUtils.equalsAnyIgnoreCase((CharSequence)propertyName, (CharSequence[])new CharSequence[]{"ValueChanged", "CheckRule", "DefaultFormulaValue", "ValueChangeAction"})) {
                            childByTagName = new TagNode(sonNodeName, null);
                            XmlDiffProcessor.setSonNodeCData(childByTagName, propertyName, newValue);
                            node.addNode(childByTagName);
                        } else {
                            XmlDiffProcessor.setSonNodeCData(node, sonNodeName, newValue);
                        }
                    }
                } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)propertyName, (CharSequence[])new CharSequence[]{"ValueChanged", "CheckRule", "DefaultFormulaValue", "ValueChangeAction"})) {
                    if (propertyName.equalsIgnoreCase("DefaultFormulaValue")) {
                        childByTagName.setAttribute("ValueDependency", diff.getReserveTwo());
                        childByTagName.setAttribute("DefaultValue", "");
                    }
                    if (propertyName.equalsIgnoreCase("CheckRule")) {
                        childByTagName.setAttribute("CheckDependency", diff.getReserveTwo());
                    }
                    childByTagName.deleteAttribute(propertyName);
                    XmlDiffProcessor.setSonNodeCData(childByTagName, propertyName, newValue);
                } else {
                    XmlDiffProcessor.setSonNodeCData(node, sonNodeName, newValue);
                }
            } else if (Objects.isNull(childByTagName)) {
                if (!isNull) {
                    TagNode valueChangedNode = node.getOrCreateChildByTagName(sonNodeName);
                    TagNode dataBinding = node.getChildByTagName("DataBinding");
                    TagNode format = node.getChildByTagName("Format");
                    if (dataBinding != null && format != null) {
                        List<AbstractNode> children = node.getChildren();
                        int i = -1;
                        int j = -1;
                        int k = 0;
                        while (k < children.size()) {
                            AbstractNode abs = children.get(k);
                            if (abs instanceof TagNode) {
                                String tagName = ((TagNode)abs).getTagName();
                                if (StringUtils.equals((CharSequence)tagName, (CharSequence)"DataBinding")) {
                                    i = k;
                                }
                                if (StringUtils.equals((CharSequence)tagName, (CharSequence)"Format")) {
                                    j = k;
                                }
                            }
                            ++k;
                        }
                        if (i > j) {
                            Collections.swap(children, i, j);
                        }
                    }
                    valueChangedNode.setAttributeNotRemove(propertyName, newValue);
                }
            } else if (isNull) {
                if (childByTagName.getAttributes().size() <= 1 && childByTagName.getChildren().size() <= 2) {
                    node.deleteChildByTagName(sonNodeName);
                    if (StringUtils.equalsAnyIgnoreCase((CharSequence)propertyName, (CharSequence[])new CharSequence[]{"ValueChanged", "CheckRule", "DefaultFormulaValue"})) {
                        childByTagName.deleteAttribute(propertyName);
                    }
                } else {
                    childByTagName.deleteAttribute(propertyName);
                    if (StringUtils.equalsAnyIgnoreCase((CharSequence)propertyName, (CharSequence[])new CharSequence[]{"ValueChanged", "CheckRule", "DefaultFormulaValue"})) {
                        childByTagName.deleteChildByTagName(propertyName);
                    }
                }
                if ("DataBinding".equals(sonNodeName) && propertyName.equalsIgnoreCase("TableKey")) {
                    childByTagName.deleteAttribute("ColumnKey");
                }
                if (propertyName.equalsIgnoreCase("DefaultFormulaValue")) {
                    childByTagName.deleteAttribute("ValueDependency");
                }
                if (propertyName.equalsIgnoreCase("CheckRule")) {
                    childByTagName.deleteAttribute("CheckDependency");
                }
            } else {
                if (childByTagName.hasAttribute("ColumnKey") && propertyName.equalsIgnoreCase("TableKey")) {
                    childByTagName.setAttribute(propertyName, newValue);
                } else if (metaFormProfile.getPlatform() != 6 && propertyName.equalsIgnoreCase("TableKey") && !childByTagName.hasAttribute("ColumnKey")) {
                    XmlDiffProcessor.setSonNodeProperties(diff, node, "TableKey", "\u65e0\u6570\u636e\u8868");
                } else {
                    childByTagName.setAttribute(propertyName, newValue);
                }
                if ("DefaultValue".equalsIgnoreCase(propertyName)) {
                    childByTagName.setAttribute("DefaultFormulaValue", "");
                    node.deleteChildByTagName("DefaultFormulaValue");
                    childByTagName.setAttribute("ValueDependency", diff.getReserveTwo());
                }
                if ("DefaultFormulaValue".equalsIgnoreCase(propertyName)) {
                    childByTagName.setAttribute("DefaultValue", "");
                }
                if (StringUtils.equalsAnyIgnoreCase((CharSequence)propertyName, (CharSequence[])new CharSequence[]{"ValueChanged", "CheckRule", "DefaultFormulaValue"})) {
                    childByTagName.deleteChildByTagName(propertyName);
                }
                if (propertyName.equalsIgnoreCase("DefaultFormulaValue")) {
                    childByTagName.setAttribute("ValueDependency", diff.getReserveTwo());
                }
                if (propertyName.equalsIgnoreCase("CheckRule")) {
                    childByTagName.setAttribute("CheckDependency", diff.getReserveTwo());
                }
            }
        }
    }

    private static void setEditViewColumnGridLayoutSpanProperty(XmlTreeWithPath xmlTree, Diff diff, String propertyName, String newValue) {
        String compViewKey = "ComponentView@" + diff.parentKey;
        TagNode compViewNode = xmlTree.xmlTree.getTagNode(compViewKey);
        if (compViewNode != null) {
            List<AbstractNode> childLayouts = compViewNode.getChildren();
            for (AbstractNode childNode : childLayouts) {
                TagNode span;
                TagNode layout;
                if (!(childNode instanceof TagNode) || !"GridLayout".equalsIgnoreCase((layout = (TagNode)childNode).getTagName()) || (span = layout.getChildByKey(diff.getKey())) == null) continue;
                span.setAttribute(propertyName, newValue);
                XmlDiffProcessor.genXmlDiff(xmlTree, span, diff, false);
                return;
            }
        }
    }

    private static void setEditViewColumnSizeInComponentView(TagNode parentNode, String columnKey, String propertyName, String newValue) {
        String key = parentNode.getAttributes().get("Key");
        if (key != null && key.equals(columnKey)) {
            parentNode.setAttribute(propertyName, newValue);
        } else if (!parentNode.getChildren().isEmpty()) {
            int i = 0;
            while (i < parentNode.getChildren().size()) {
                AbstractNode subNode = parentNode.getChildren().get(i);
                if (subNode instanceof TagNode) {
                    XmlDiffProcessor.setEditViewColumnSizeInComponentView((TagNode)subNode, columnKey, propertyName, newValue);
                }
                ++i;
            }
        }
    }

    private static void setEditViewColumnSizeInComponentView(XmlTreeWithPath xmlTree, Diff diff, String propertyName, String newValue) {
        String compViewKey = "ComponentView@" + diff.parentKey;
        TagNode compViewNode = xmlTree.xmlTree.getTagNode(compViewKey);
        if (compViewNode != null) {
            List<AbstractNode> childLayouts = compViewNode.getChildren();
            for (AbstractNode childNode : childLayouts) {
                if (!(childNode instanceof TagNode)) continue;
                XmlDiffProcessor.setEditViewColumnSizeInComponentView((TagNode)childNode, diff.getKey(), propertyName, newValue);
            }
            XmlDiffProcessor.genXmlDiff(xmlTree, compViewNode, diff, false);
        }
    }

    private static void setListViewNodeProperty(Diff diff, TagNode node, String propertyName, String newValue) throws Throwable {
        if (Property.ColumnType.name.equalsIgnoreCase(propertyName)) {
            node.setAttribute(propertyName, newValue);
        } else if ("ColumnKey".equals(propertyName)) {
            node.setAttribute("Data" + propertyName, newValue);
            node.setAttribute(propertyName, newValue);
        } else {
            XmlDiffProcessor.setSonNodeProperties(diff, node, propertyName, newValue);
        }
    }

    private static void dealSeparate(XmlTreeWithPath xmlTree, DataTable Table, Diff diff) throws Throwable {
        String Key2;
        String ownerFormKey = diff.formKey;
        MetaForm ownerMetaForm = StringUtils.isBlank((CharSequence)ownerFormKey) ? null : MetaFactory.getGlobalInstance().getMetaForm(ownerFormKey);
        MetaSplitPanel metaSplitPanel = (MetaSplitPanel)IOMetaObject.getComponentByKey(ownerMetaForm, Key2 = diff.getKey());
        if (Objects.isNull(metaSplitPanel) && diff.getContainerKey() != null) {
            ownerMetaForm = StringUtils.isBlank((CharSequence)ownerFormKey) ? null : MetaFactory.getGlobalInstance().getMetaForm(diff.getContainerKey());
            metaSplitPanel = (MetaSplitPanel)IOMetaObject.getComponentByKey(ownerMetaForm, Key2);
        }
        MetaSplitSizeCollection metaSplitSizeCollection = metaSplitPanel.getSplitSize();
        int number = 0;
        if (metaSplitSizeCollection != null) {
            String TagName = metaSplitPanel.getTagName();
            TagNode BigtagNode = xmlTree.xmlTree.getTagNode(String.valueOf(TagName) + "@" + Key2);
            List<AbstractNode> sonNode = BigtagNode.getChildren();
            for (AbstractNode abstractNode : sonNode) {
                if (!(abstractNode instanceof TagNode) || !"SplitSize".equalsIgnoreCase(((TagNode)abstractNode).getTagName())) continue;
                TagNode smallNode = (TagNode)abstractNode;
                if ("1".equals(Table.getString(number, "Type"))) {
                    smallNode.setAttribute("Size", Table.getInt(number, "Size") + "%");
                } else {
                    smallNode.setAttribute("Size", Table.getInt(number, "Size") + "px");
                }
                smallNode.setAttribute("ForwardCollapased", Table.getString(number, "ForwardCollapased"));
                smallNode.setAttribute("ReverseCollapased", Table.getString(number, "ReverseCollapased"));
                smallNode.setAttribute("CollapaseType", Table.getString(number, "CollapaseType"));
                ++number;
            }
            XmlDiffProcessor.genXmlDiff(xmlTree, BigtagNode, diff, true);
        }
    }

    private static void dealComboBoxSourceSetting(XmlTreeWithPath xmlTree, Diff diff, Document document, MetaForm metaForm) throws Throwable {
        TagNode parentNode;
        block40: {
            int useComboFilter;
            DataTable filterPropertyTable;
            block38: {
                String sourceType;
                String componentKey = diff.getKey();
                MetaComponent metaComponent = IOMetaObject.getComponentByKey(metaForm, diff.getKey());
                String xmlTreeKey = null;
                if (metaComponent != null) {
                    xmlTreeKey = XmlDiffProcessor.getXmlTreeKey(diff, metaComponent.getTagName(), componentKey);
                } else {
                    AbstractMetaObject abstractMetaObject = (AbstractMetaObject)metaForm.getAllUIComponents().get(diff.getKey());
                    if (abstractMetaObject == null) {
                        return;
                    }
                    xmlTreeKey = String.valueOf(abstractMetaObject.getTagName()) + "@" + diff.getKey();
                }
                parentNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
                parentNode.deleteChildByTagName("Item");
                parentNode.deleteChildByTagName("FormulaItems");
                parentNode.deleteChildByTagName("QueryDef");
                parentNode.deleteChildByTagName("ComboFilter");
                parentNode.setAttribute("GroupKey", "");
                parentNode.setAttribute("ItemsDependency", "");
                DataTable propertyTable = document.get("ED_Properties");
                if (propertyTable == null || !propertyTable.first()) break block38;
                switch (sourceType = propertyTable.getString("GetSourceType")) {
                    case "Items": {
                        DataTable itemTable = document.get("ED_ComboBoxDetail");
                        if (itemTable == null || itemTable.isEmpty()) break;
                        itemTable.beforeFirst();
                        while (itemTable.next()) {
                            Boolean extendFlag = itemTable.getBoolean("ExtendFlag");
                            if (extendFlag.booleanValue()) continue;
                            TagNode itemNode = new TagNode("Item", null);
                            itemNode.setAttribute("Key", itemTable.getString("Key"));
                            itemNode.setAttribute("Value", itemTable.getString("Value"));
                            itemNode.setAttribute("Caption", itemTable.getString("Caption"));
                            parentNode.addNode(itemNode);
                        }
                        break;
                    }
                    case "Formula": {
                        TagNode formulaNode = new TagNode("FormulaItems", null);
                        String formulaContent = propertyTable.getString("GetFormulaItems");
                        formulaNode.setCDataValue(formulaContent);
                        parentNode.addNode(formulaNode);
                        parentNode.setAttribute("ItemsDependency", propertyTable.getString("ItemsDependency"));
                        break;
                    }
                    case "Query": {
                        DataTable quereDefHeadTable = document.get("D_ComboBoxQueryDefHead");
                        TagNode queryDefNode = new TagNode("QueryDef", null);
                        TagNode statement = new TagNode("Statement", null);
                        String statementContent = quereDefHeadTable.getString("Statement");
                        statement.setCDataValue(statementContent);
                        queryDefNode.addNode(statement);
                        DataTable paraTable = document.get("ED_ParameterCollection");
                        TagNode parameterCollection = new TagNode("ParameterCollection", null);
                        int i = 0;
                        while (i < paraTable.size()) {
                            String dataType = paraTable.getString(i, "DataType");
                            String p_sourceType = paraTable.getString(i, "SourceType");
                            String description = paraTable.getString(i, "Description");
                            String value = paraTable.getString(i, "Value");
                            TagNode parameter = new TagNode("Parameter", null);
                            parameter.setAttribute("DataType", dataType);
                            if (!"Formula".equals(p_sourceType)) {
                                parameter.setAttribute("SourceType", p_sourceType);
                            }
                            parameter.setAttribute("Description", description);
                            parameter.setAttribute("Value", value);
                            parameterCollection.addNode(parameter);
                            ++i;
                        }
                        queryDefNode.addNode(parameterCollection);
                        parentNode.addNode(queryDefNode);
                        parentNode.setAttribute("ItemsDependency", quereDefHeadTable.getString("ItemsDependency"));
                        break;
                    }
                    case "ParaGroup": {
                        String groupKey = propertyTable.getString("GetGroupKey");
                        parentNode.setAttribute("GroupKey", groupKey);
                    }
                }
                parentNode.setAttribute("SourceType", sourceType);
            }
            if ((filterPropertyTable = document.get("ED_FilterProperties")) == null || !filterPropertyTable.first() || (useComboFilter = filterPropertyTable.getInt("IsUseComboFilter").intValue()) != 1) break block40;
            TagNode comboFilterNode = new TagNode("ComboFilter", null);
            String filterSourceType = filterPropertyTable.getString("GetFilterSourceType");
            comboFilterNode.setAttribute("Type", filterPropertyTable.getString("GetFilterType"));
            comboFilterNode.setAttribute("SourceType", filterSourceType);
            comboFilterNode.setAttribute("ItemsDependency", "");
            switch (filterSourceType) {
                case "Items": {
                    DataTable itemTable = document.get("ED_ComboFilterDetail");
                    if (itemTable == null || itemTable.isEmpty()) break;
                    itemTable.beforeFirst();
                    while (itemTable.next()) {
                        Boolean extendFlag = itemTable.getBoolean("ExtendFlag");
                        if (extendFlag.booleanValue()) continue;
                        TagNode itemNode = new TagNode("Item", null);
                        itemNode.setAttribute("Key", itemTable.getString("Key"));
                        itemNode.setAttribute("Value", itemTable.getString("Value"));
                        itemNode.setAttribute("Caption", itemTable.getString("Caption"));
                        comboFilterNode.addNode(itemNode);
                    }
                    break;
                }
                case "Formula": {
                    TagNode formulaNode = new TagNode("FormulaItems", null);
                    String formulaContent = filterPropertyTable.getString("GetFilterFormulaItems");
                    formulaNode.setCDataValue(formulaContent);
                    comboFilterNode.addNode(formulaNode);
                    comboFilterNode.setAttribute("ItemsDependency", filterPropertyTable.getString("ItemsDependency"));
                    break;
                }
                case "Query": {
                    DataTable quereDefHeadTable = document.get("D_Filter_ComboBoxQueryDefHead");
                    TagNode queryDefNode = new TagNode("QueryDef", null);
                    TagNode statement = new TagNode("Statement", null);
                    String statementContent = quereDefHeadTable.getString("Statement");
                    statement.setCDataValue(statementContent);
                    queryDefNode.addNode(statement);
                    DataTable paraTable = document.get("ED_Filter_ParameterCollection");
                    TagNode parameterCollection = new TagNode("ParameterCollection", null);
                    int i = 0;
                    while (i < paraTable.size()) {
                        String dataType = paraTable.getString(i, "DataType");
                        String p_sourceType = paraTable.getString(i, "SourceType");
                        String description = paraTable.getString(i, "Description");
                        String value = paraTable.getString(i, "Value");
                        TagNode parameter = new TagNode("Parameter", null);
                        parameter.setAttribute("DataType", dataType);
                        if (!"Formula".equals(p_sourceType)) {
                            parameter.setAttribute("SourceType", p_sourceType);
                        }
                        parameter.setAttribute("Description", description);
                        parameter.setAttribute("Value", value);
                        parameterCollection.addNode(parameter);
                        ++i;
                    }
                    queryDefNode.addNode(parameterCollection);
                    comboFilterNode.addNode(queryDefNode);
                    comboFilterNode.setAttribute("ItemsDependency", quereDefHeadTable.getString("ItemsDependency"));
                }
            }
            parentNode.addNode(comboFilterNode);
        }
        XmlDiffProcessor.genXmlDiff(xmlTree, parentNode, diff, true);
    }

    private static void dealCarouselSourceSetting(XmlTreeWithPath xmlTree, Diff diff, Document document, MetaForm metaForm) throws Throwable {
        block11: {
            TagNode carouselNode;
            block12: {
                String sourceType;
                MetaComponent metaComponent = IOMetaObject.getComponentByKey(metaForm, diff.getKey());
                if (metaComponent == null) break block11;
                String xmlTreeKey = "Carousel@" + diff.getKey();
                carouselNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
                carouselNode.deleteChildByTagName("Item");
                carouselNode.deleteChildByTagName("FormulaItems");
                DataTable propertyTable = document.get("ED_CarouselProperties");
                if (propertyTable == null || !propertyTable.first()) break block12;
                switch (sourceType = propertyTable.getString("GetSourceType")) {
                    case "Items": {
                        DataTable itemTable = document.get("ED_CarouselDetail");
                        if (itemTable == null || itemTable.isEmpty()) break;
                        itemTable.beforeFirst();
                        while (itemTable.next()) {
                            TagNode itemNode = new TagNode("Item", null);
                            itemNode.setAttribute("Key", itemTable.getString("Key"));
                            itemNode.setAttribute("Value", itemTable.getString("Value"));
                            itemNode.setAttribute("Caption", itemTable.getString("Caption"));
                            itemNode.setAttribute("Icon", itemTable.getString("Icon"));
                            carouselNode.addNode(itemNode);
                        }
                        break;
                    }
                    case "Formula": {
                        TagNode formulaNode = new TagNode("FormulaItems", null);
                        String formulaContent = propertyTable.getString("GetFormulaItems");
                        formulaNode.setCDataValue(formulaContent);
                        carouselNode.addNode(formulaNode);
                    }
                }
                carouselNode.setAttribute("SourceType", sourceType);
            }
            XmlDiffProcessor.genXmlDiff(xmlTree, carouselNode, diff, true);
        }
    }

    private static void dealRefreshHeaderSetting(XmlTreeWithPath xmlTree, Diff diff, Document document, MetaForm metaForm) throws Throwable {
        MetaComponent metaComponent = IOMetaObject.getComponentByKey(metaForm, diff.getKey());
        if (metaComponent != null) {
            String xmlTreeKey = "RefreshControl@" + diff.getKey();
            TagNode refreshControlNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
            refreshControlNode.deleteChildByTagName("RefreshHeader");
            DataTable propertyTable = document.get("ED_RefreshHeaderProperties");
            if (propertyTable != null && propertyTable.first()) {
                TagNode headerNode = new TagNode("RefreshHeader", null);
                TagNode formatNode = new TagNode("Format", null);
                if (!propertyTable.getString("HAlign").isEmpty()) {
                    formatNode.setAttribute("HAlign", propertyTable.getString("HAlign"));
                }
                if (!propertyTable.getString("VAlign").isEmpty()) {
                    formatNode.setAttribute("VAlign", propertyTable.getString("VAlign"));
                }
                if (!propertyTable.getString("BackColor").isEmpty()) {
                    formatNode.setAttribute("BackColor", propertyTable.getString("BackColor"));
                }
                if (!propertyTable.getString("ForeColor").isEmpty()) {
                    formatNode.setAttribute("ForeColor", propertyTable.getString("ForeColor"));
                }
                if (!propertyTable.getString("HighlightBackColor").isEmpty()) {
                    formatNode.setAttribute("HighlightColor", propertyTable.getString("HighlightBackColor"));
                }
                TagNode fontNode = new TagNode("Font", null);
                if (!propertyTable.getString("Name").isEmpty()) {
                    fontNode.setAttribute("Name", propertyTable.getString("Name"));
                }
                if (!propertyTable.getNumeric("Size").toString().equals("-1")) {
                    fontNode.setAttribute("Size", propertyTable.getNumeric("Size").toString());
                }
                if (!propertyTable.getString("Bold").isEmpty()) {
                    fontNode.setAttribute("Bold", propertyTable.getString("Bold"));
                }
                if (!propertyTable.getString("Italic").isEmpty()) {
                    fontNode.setAttribute("Italic", propertyTable.getString("Italic"));
                }
                if (fontNode.getAttributes().size() > 0) {
                    formatNode.addNode(fontNode);
                    headerNode.addNode(formatNode);
                } else if (formatNode.getAttributes().size() > 0) {
                    headerNode.addNode(formatNode);
                }
                String formulaContent = propertyTable.getString("FormulaContent");
                if (formulaContent != null && !formulaContent.isEmpty()) {
                    headerNode.setCDataValue(formulaContent);
                }
                headerNode.setAttribute("Text", propertyTable.getString("Text"));
                headerNode.setAttribute("Icon", propertyTable.getString("Icon"));
                headerNode.setAttribute("IconLocation", propertyTable.getString("IconLocation"));
                DataTable itemTable = document.get("ED_RefreshHeaderDetail");
                if (itemTable != null && !itemTable.isEmpty()) {
                    itemTable.beforeFirst();
                    while (itemTable.next()) {
                        TagNode stateNode = new TagNode("State", null);
                        stateNode.setAttribute("Text", itemTable.getString("Text"));
                        stateNode.setAttribute("Icon", itemTable.getString("Icon"));
                        stateNode.setAttribute("IconLocation", itemTable.getString("IconLocation"));
                        stateNode.setAttribute("Type", itemTable.getString("Type"));
                        TagNode formatNode2 = new TagNode("Format", null);
                        if (!propertyTable.getString("HAlign").isEmpty()) {
                            formatNode2.setAttribute("HAlign", propertyTable.getString("HAlign"));
                        }
                        if (!propertyTable.getString("VAlign").isEmpty()) {
                            formatNode2.setAttribute("VAlign", propertyTable.getString("VAlign"));
                        }
                        if (!propertyTable.getString("BackColor").isEmpty()) {
                            formatNode2.setAttribute("BackColor", propertyTable.getString("BackColor"));
                        }
                        if (!propertyTable.getString("ForeColor").isEmpty()) {
                            formatNode2.setAttribute("ForeColor", propertyTable.getString("ForeColor"));
                        }
                        if (!propertyTable.getString("HighlightBackColor").isEmpty()) {
                            formatNode2.setAttribute("HighlightColor", propertyTable.getString("HighlightBackColor"));
                        }
                        TagNode fontNode2 = new TagNode("Font", null);
                        if (!propertyTable.getString("Name").isEmpty()) {
                            fontNode2.setAttribute("Name", propertyTable.getString("Name"));
                        }
                        if (!propertyTable.getNumeric("Size").toString().equals("-1")) {
                            fontNode2.setAttribute("Size", propertyTable.getNumeric("Size").toString());
                        }
                        if (!propertyTable.getString("Bold").isEmpty()) {
                            fontNode2.setAttribute("Bold", propertyTable.getString("Bold"));
                        }
                        if (!propertyTable.getString("Italic").isEmpty()) {
                            fontNode2.setAttribute("Italic", propertyTable.getString("Italic"));
                        }
                        if (fontNode.getAttributes().size() > 0) {
                            formatNode2.addNode(fontNode2);
                            stateNode.addNode(formatNode2);
                        } else if (formatNode2.getAttributes().size() > 0) {
                            stateNode.addNode(formatNode2);
                        }
                        headerNode.addNode(stateNode);
                    }
                }
                refreshControlNode.addNode(headerNode);
            }
            XmlDiffProcessor.genXmlDiff(xmlTree, refreshControlNode, diff, true);
        }
    }

    private static void dealRefreshFooterSetting(XmlTreeWithPath xmlTree, Diff diff, Document document, MetaForm metaForm) throws Throwable {
        MetaComponent metaComponent = IOMetaObject.getComponentByKey(metaForm, diff.getKey());
        if (metaComponent != null) {
            String xmlTreeKey = "RefreshControl@" + diff.getKey();
            TagNode refreshControlNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
            refreshControlNode.deleteChildByTagName("RefreshFooter");
            DataTable propertyTable = document.get("ED_RefreshFooterProperties");
            if (propertyTable != null && propertyTable.first()) {
                TagNode footerNode = new TagNode("RefreshFooter", null);
                TagNode formatNode = new TagNode("Format", null);
                if (!propertyTable.getString("HAlign").isEmpty()) {
                    formatNode.setAttribute("HAlign", propertyTable.getString("HAlign"));
                }
                if (!propertyTable.getString("VAlign").isEmpty()) {
                    formatNode.setAttribute("VAlign", propertyTable.getString("VAlign"));
                }
                if (!propertyTable.getString("BackColor").isEmpty()) {
                    formatNode.setAttribute("BackColor", propertyTable.getString("BackColor"));
                }
                if (!propertyTable.getString("ForeColor").isEmpty()) {
                    formatNode.setAttribute("ForeColor", propertyTable.getString("ForeColor"));
                }
                if (!propertyTable.getString("HighlightBackColor").isEmpty()) {
                    formatNode.setAttribute("HighlightColor", propertyTable.getString("HighlightBackColor"));
                }
                TagNode fontNode = new TagNode("Font", null);
                if (!propertyTable.getString("Name").isEmpty()) {
                    fontNode.setAttribute("Name", propertyTable.getString("Name"));
                }
                if (!propertyTable.getNumeric("Size").toString().equals("-1")) {
                    fontNode.setAttribute("Size", propertyTable.getNumeric("Size").toString());
                }
                if (!propertyTable.getString("Bold").isEmpty()) {
                    fontNode.setAttribute("Bold", propertyTable.getString("Bold"));
                }
                if (!propertyTable.getString("Italic").isEmpty()) {
                    fontNode.setAttribute("Italic", propertyTable.getString("Italic"));
                }
                if (fontNode.getAttributes().size() > 0) {
                    formatNode.addNode(fontNode);
                    footerNode.addNode(formatNode);
                } else if (formatNode.getAttributes().size() > 0) {
                    footerNode.addNode(formatNode);
                }
                String formulaContent = propertyTable.getString("FormulaContent");
                if (formulaContent != null && !formulaContent.isEmpty()) {
                    footerNode.setCDataValue(formulaContent);
                }
                refreshControlNode.addNode(footerNode);
            }
            XmlDiffProcessor.genXmlDiff(xmlTree, refreshControlNode, diff, true);
        }
    }

    private static void dealPriceLabelItemSetting(XmlTreeWithPath xmlTree, Diff diff, Document document, MetaForm metaForm) throws Throwable {
        MetaComponent metaComponent = IOMetaObject.getComponentByKey(metaForm, diff.getKey());
        if (metaComponent != null) {
            String xmlTreeKey = "PriceLabel@" + diff.getKey();
            TagNode priceLabelNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
            priceLabelNode.deleteChildByTagName("PriceItem");
            DataTable detailTable = document.get("ED_PriceLabelItemDetail");
            if (detailTable != null && detailTable.first()) {
                detailTable.beforeFirst();
                while (detailTable.next()) {
                    TagNode itemNode = new TagNode("PriceItem", null);
                    if (!detailTable.getString("Type").isEmpty()) {
                        itemNode.setAttribute("Type", detailTable.getString("Type"));
                    }
                    TagNode formatNode = new TagNode("Format", null);
                    if (!detailTable.getString("HAlign").isEmpty()) {
                        formatNode.setAttribute("HAlign", detailTable.getString("HAlign"));
                    }
                    if (!detailTable.getString("VAlign").isEmpty()) {
                        formatNode.setAttribute("VAlign", detailTable.getString("VAlign"));
                    }
                    if (!detailTable.getString("BackColor").isEmpty()) {
                        formatNode.setAttribute("BackColor", detailTable.getString("BackColor"));
                    }
                    if (!detailTable.getString("ForeColor").isEmpty()) {
                        formatNode.setAttribute("ForeColor", detailTable.getString("ForeColor"));
                    }
                    if (!detailTable.getString("HighlightBackColor").isEmpty()) {
                        formatNode.setAttribute("HighlightColor", detailTable.getString("HighlightBackColor"));
                    }
                    TagNode fontNode = new TagNode("Font", null);
                    if (!detailTable.getString("Name").isEmpty()) {
                        fontNode.setAttribute("Name", detailTable.getString("Name"));
                    }
                    if (!detailTable.getNumeric("Size").toString().equals("-1")) {
                        fontNode.setAttribute("Size", detailTable.getNumeric("Size").toString());
                    }
                    if (!detailTable.getString("Bold").isEmpty()) {
                        fontNode.setAttribute("Bold", detailTable.getString("Bold"));
                    }
                    if (!detailTable.getString("Italic").isEmpty()) {
                        fontNode.setAttribute("Italic", detailTable.getString("Italic"));
                    }
                    if (fontNode.getAttributes().size() > 0) {
                        formatNode.addNode(fontNode);
                        itemNode.addNode(formatNode);
                    } else if (formatNode.getAttributes().size() > 0) {
                        itemNode.addNode(formatNode);
                    }
                    priceLabelNode.addNode(itemNode);
                }
            }
            XmlDiffProcessor.genXmlDiff(xmlTree, priceLabelNode, diff, true);
        }
    }

    private static void dealRowActionCollection(XmlTreeWithPath xmlTree, Diff diff, DataTable table, MetaForm metaForm) throws Throwable {
        String xmlTreeKey;
        MetaComponent metaComponent = null;
        TagNode rowNode = null;
        if (diff.getControlType() == 264) {
            xmlTreeKey = "TableRow@" + diff.getKey();
            rowNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
        } else {
            metaComponent = IOMetaObject.getComponentByKey(metaForm, diff.getKey());
            if (metaComponent != null && metaComponent.getControlType() == 305) {
                xmlTreeKey = "EditView@" + diff.getKey();
                TagNode editViewNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
                rowNode = editViewNode.getOrCreateChildByTagName("EditViewRow");
            }
        }
        if (rowNode != null) {
            rowNode.deleteChildByTagName("RowActionCollection");
            if (!table.isEmpty()) {
                TagNode actionsNode = new TagNode("RowActionCollection", null);
                int i = 0;
                while (i < table.size()) {
                    String key = table.getString(i, "Key");
                    String caption = table.getString(i, "Caption");
                    String expression = table.getString(i, "Expression");
                    TagNode trace = new TagNode("RowAction", null);
                    trace.setAttribute("Caption", caption);
                    trace.setAttribute("Key", key);
                    trace.setCDataValue(expression);
                    actionsNode.addNode(trace);
                    ++i;
                }
                rowNode.addNode(actionsNode);
            }
            XmlDiffProcessor.genXmlDiff(xmlTree, rowNode.getParent(), diff, true);
        }
    }

    private static void dealEditViewItemCollectionSetting(XmlTreeWithPath xmlTree, Diff diff, Document document, MetaForm metaForm) throws Throwable {
        MetaComponent metaComponent = IOMetaObject.getComponentByKey(metaForm, diff.getKey());
        if (metaComponent != null) {
            DataTable itemTable;
            String xmlTreeKey = "EditView@" + diff.getKey();
            TagNode editViewNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
            editViewNode.deleteChildByTagName("EditViewItem");
            editViewNode.deleteChildByTagName("FormulaItems");
            DataTable propertyTable = document.get("ED_EditViewItemCollectionProperties");
            if (propertyTable != null && propertyTable.first()) {
                TagNode formulaNode = new TagNode("FormulaItems", null);
                String formulaContent = propertyTable.getString("GetFormulaItems");
                formulaNode.setCDataValue(formulaContent);
                editViewNode.addNode(formulaNode);
            }
            if ((itemTable = document.get("ED_EditViewItemCollectionDetail")) != null && !itemTable.isEmpty()) {
                itemTable.beforeFirst();
                while (itemTable.next()) {
                    TagNode itemNode = new TagNode("EditViewItem", null);
                    itemNode.setAttribute("Key", itemTable.getString("Key"));
                    itemNode.setAttribute("Caption", itemTable.getString("Caption"));
                    itemNode.setAttribute("Image", itemTable.getString("Image"));
                    itemNode.setAttribute("ImageScaleType", itemTable.getString("ImageScaleType"));
                    editViewNode.addNode(itemNode);
                }
            }
            XmlDiffProcessor.genXmlDiff(xmlTree, editViewNode, diff, true);
        }
    }

    private static void dealExtOptCollection(XmlTreeWithPath xmlTree, Diff diff, DataTable table, MetaForm metaForm) throws Throwable {
        String componentKey = diff.getKey();
        MetaGrid metaComponent = (MetaGrid)IOMetaObject.getComponentByKey(metaForm, diff.getKey());
        String tagName = metaComponent.getTagName();
        String xmlTreeKey = XmlDiffProcessor.getXmlTreeKey(diff, tagName, componentKey);
        TagNode parentNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
        parentNode.deleteChildByTagName("ExtOptCollection");
        if (table.size() > 0) {
            TagNode operationSet = new TagNode("ExtOptCollection", null);
            int i = 0;
            while (i < table.size()) {
                String icon = table.getString(i, "Icon");
                String caption = table.getString(i, "Caption");
                String expression = table.getString(i, "Expression");
                TagNode trace = new TagNode("ExtOpt", null);
                trace.setAttribute("Caption", caption);
                trace.setAttribute("Icon", icon);
                trace.setCDataValue(expression);
                operationSet.addNode(trace);
                ++i;
            }
            parentNode.addNode(operationSet);
        }
        XmlDiffProcessor.genXmlDiff(xmlTree, parentNode, diff, true);
    }

    private static void dealTraceCollection(XmlTreeWithPath xmlTree, Diff diff, DataTable table, MetaForm metaForm) throws Throwable {
        String componentKey = diff.getKey();
        MetaGrid metaComponent = (MetaGrid)IOMetaObject.getComponentByKey(metaForm, diff.getKey());
        String tagName = metaComponent.getTagName();
        String xmlTreeKey = XmlDiffProcessor.getXmlTreeKey(diff, tagName, componentKey);
        TagNode parentNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
        parentNode.deleteChildByTagName("TraceCollection");
        if (table.size() > 0) {
            TagNode traceCollection = new TagNode("TraceCollection", null);
            int i = 0;
            while (i < table.size()) {
                String condition = table.getString(i, "Condition");
                String caption = table.getString(i, "Caption");
                String expression = table.getString(i, "Expression");
                TagNode trace = new TagNode("Trace", null);
                trace.setAttribute("Caption", caption);
                trace.setAttribute("Condition", condition);
                trace.setCDataValue(expression);
                traceCollection.addNode(trace);
                ++i;
            }
            parentNode.addNode(traceCollection);
        }
        XmlDiffProcessor.genXmlDiff(xmlTree, parentNode, diff, true);
    }

    private static void dealHeadCondition(XmlTreeWithPath xmlTree, DataTable headCondition, DataTable cuscollTable, DataTable tarCollTable, TagNode fieldNode, Diff diff, TagNode parentNode, DataTable cuscollTableSon) throws Throwable {
        if (headCondition.size() == 0) {
            return;
        }
        int state = headCondition.getState();
        TagNode condNode = fieldNode.getOrCreateChildByTagName("Condition");
        Integer condSign = headCondition.getInt("CondSign");
        if (condSign == -11) {
            fieldNode.deleteChildByTagName("Condition");
            XmlDiffProcessor.genXmlDiff(xmlTree, parentNode, diff, true);
            return;
        }
        String condTableKey = headCondition.getString("TableKey");
        String condColumnKey = headCondition.getString("ColumnKey");
        String group = headCondition.getString("Group");
        String groupHead = headCondition.getString("GroupHead");
        String groupTail = headCondition.getString("GroupTail");
        String limitToSource = headCondition.getString("LimitToSource");
        String target = headCondition.getString("Target");
        String tag = headCondition.getString("Tag");
        String impl = headCondition.getString("Impl");
        String needReset = headCondition.getString("NeedReset");
        String loadHistoryInput = headCondition.getString("LoadHistoryInput");
        String onlyFilter = headCondition.getString("OnlyFilter");
        if (2 == state) {
            if (Objects.isNull(condNode.getElement())) {
                condNode.setAttribute("CondSign", CondSign.toString((Integer)condSign));
                condNode.setAttribute("TableKey", StringUtils.isNotEmpty((CharSequence)condTableKey) ? condTableKey : "");
                condNode.setAttribute("ColumnKey", StringUtils.isNotEmpty((CharSequence)condColumnKey) ? condColumnKey : "");
                condNode.setAttribute("Group", StringUtils.isNotEmpty((CharSequence)group) ? group : "");
                condNode.setAttribute("GroupHead", StringUtils.isNotEmpty((CharSequence)groupHead) ? groupHead : "");
                condNode.setAttribute("GroupTail", StringUtils.isNotEmpty((CharSequence)groupTail) ? groupTail : "");
                condNode.setAttribute("LimitToSource", StringUtils.isNotEmpty((CharSequence)limitToSource) ? limitToSource : "");
                String useAdvancedQuery = headCondition.getString("UseAdvancedQuery");
                condNode.setAttribute("UseAdvancedQuery", StringUtils.isNotEmpty((CharSequence)useAdvancedQuery) ? useAdvancedQuery : "false");
                condNode.setAttribute("Target", StringUtils.isNotEmpty((CharSequence)target) ? target : "");
                condNode.setAttribute("Tag", StringUtils.isNotEmpty((CharSequence)tag) ? tag : "");
                condNode.setAttribute("Impl", StringUtils.isNotEmpty((CharSequence)impl) ? impl : "");
                condNode.setAttribute("NeedReset", StringUtils.isNotEmpty((CharSequence)needReset) ? needReset : "");
                condNode.setAttribute("LoadHistoryInput", StringUtils.isNotEmpty((CharSequence)loadHistoryInput) ? loadHistoryInput : "");
                condNode.setAttribute("OnlyFilter", StringUtils.isNotEmpty((CharSequence)onlyFilter) ? onlyFilter : "");
            } else {
                condNode.setAttribute("CondSign", CondSign.toString((Integer)condSign));
                condNode.setAttribute("TableKey", condTableKey);
                condNode.setAttribute("ColumnKey", condColumnKey);
                condNode.setAttribute("Group", group);
                condNode.setAttribute("GroupHead", groupHead);
                condNode.setAttribute("GroupTail", groupTail);
                condNode.setAttribute("LimitToSource", limitToSource);
                String useAdvancedQuery = headCondition.getString("UseAdvancedQuery");
                condNode.setAttribute("UseAdvancedQuery", StringUtils.isNotEmpty((CharSequence)useAdvancedQuery) ? useAdvancedQuery : "false");
                condNode.setAttribute("Target", target);
                condNode.setAttribute("Tag", tag);
                condNode.setAttribute("Impl", impl);
                condNode.setAttribute("NeedReset", needReset);
                if ("true".equalsIgnoreCase(condNode.getAttributes().get("NeedReset"))) {
                    condNode.getAttributes().remove("NeedReset");
                }
                condNode.setAttribute("LoadHistoryInput", loadHistoryInput);
                condNode.setAttribute("OnlyFilter", onlyFilter);
            }
        }
        XmlDiffProcessor.dealSonTable(fieldNode, cuscollTable, tarCollTable, condSign, cuscollTableSon);
        XmlDiffProcessor.genXmlDiff(xmlTree, parentNode, diff, true);
    }

    private static void dealSonTable(TagNode fieldNode, DataTable cuscollTable, DataTable tarCollTable, int condSign, DataTable cuscollTableSon) throws Throwable {
        int i;
        cuscollTable.setShowDeleted(false);
        TagNode condNode = fieldNode.getOrCreateChildByTagName("Condition");
        condNode.deleteChildByTagName("CustomCondition");
        condNode.deleteChildByTagName("ConditionTarget");
        condNode.deleteChildByTagName("CustomConditionPara");
        if (condSign == 8) {
            i = 0;
            while (i < cuscollTable.size()) {
                TagNode customNode = new TagNode("CustomCondition", null);
                customNode.setAttribute("Condition", cuscollTable.getString(i, "Condition"));
                customNode.setAttribute("Filter", cuscollTable.getString(i, "Filter"));
                customNode.setAttribute("MultiPara", String.valueOf(cuscollTable.getInt(i, "IsMultiPara")));
                customNode.setAttribute("Seperator", cuscollTable.getString(i, "Seperator"));
                String oid1 = String.valueOf(cuscollTable.getLong(i, "OID"));
                int j = 0;
                while (j < cuscollTableSon.size()) {
                    String poid = String.valueOf(cuscollTableSon.getLong(j, "POID"));
                    if (oid1.equalsIgnoreCase(poid)) {
                        TagNode customConditionPara = new TagNode("CustomConditionPara", null);
                        customConditionPara.setAttribute("Key", cuscollTableSon.getString(j, "ParaKey"));
                        if (cuscollTableSon.getString(j, "ParaFormula") != null && !cuscollTableSon.getString(j, "ParaFormula").isEmpty()) {
                            customConditionPara.setAttribute("Formula", cuscollTableSon.getString(j, "ParaFormula"));
                        }
                        customNode.addNode(customConditionPara);
                    }
                    ++j;
                }
                condNode.addNode(customNode);
                ++i;
            }
        }
        i = 0;
        while (i < tarCollTable.size()) {
            TagNode targetNode = new TagNode("ConditionTarget", null);
            targetNode.setAttribute("TableKey", tarCollTable.getString(i, "TargetTableKey"));
            targetNode.setAttribute("ColumnKey", tarCollTable.getString(i, "TargetColumnKey"));
            targetNode.setAttribute("Target", tarCollTable.getString(i, "TargetField"));
            condNode.addNode(targetNode);
            ++i;
        }
    }

    public static void dealEventTable(XmlTreeWithPath xmlTree, Document document, Diff diff) throws Throwable {
        DataTable preLoadTable = document.get("ED_PreLoadProcess");
        DataTable postLoadTable = document.get("ED_PostLoadProcess");
        DataTable preSaveTable = document.get("ED_PreSaveProcess");
        DataTable postSaveTable = document.get("ED_PostSaveProcess");
        DataTable preDeleteTable = document.get("ED_PreDeleteProcess");
        DataTable postDeleteTable = document.get("ED_PostDeleteProcess");
        DataTable statusCollectionTable = document.get("ED_StatusCollection");
        DataTable statusTriggerCollectionTable = document.get("ED_StatusTriggerCollection");
        DataTable extendCollectionTable = document.get("ED_ExtendCollection");
        DataTable checkRuleCollectionTable = document.get("ED_CheckRuleCollection");
        DataTable macroCollectionTable = document.get("ED_MacroCollection");
        List<TagNode> dataSource = xmlTree.xmlTree.getRoot().findNodesByTagName("DataSource");
        List<TagNode> dataObject = xmlTree.xmlTree.getRoot().findNodesByTagName("DataObject");
        if (dataSource.size() == 0 && dataObject.size() == 0) {
            return;
        }
        if (dataSource.size() < 1 || !dataSource.get(0).hasAttribute("RefObjectKey")) {
            TagNode rootNode;
            TagNode checkRuleCollectionNode;
            String xmlFilePath;
            String tempXmlFilePath;
            String filePath;
            XmlTreeWithPath xmlTreeWithPath;
            String extend;
            String dataObjectKey = diff.formKey;
            String reserveOne = diff.getReserveOne();
            TagNode parentNode = dataObject.get(0);
            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
            MetaDataObjectProfile metaDataObjectProfile = (MetaDataObjectProfile)dataObjectList.get(dataObjectKey);
            String string = extend = Objects.nonNull(metaDataObjectProfile) ? metaDataObjectProfile.getExtend() : "";
            if (!StringUtils.equals((CharSequence)reserveOne, (CharSequence)"DataObject") || !StringUtils.isNotBlank((CharSequence)extend)) {
                XmlDiffProcessor.dealEventNode(preLoadTable, "PreLoadProcess", parentNode, Collections.emptyList(), "Load");
                XmlDiffProcessor.dealEventNode(postLoadTable, "PostLoadProcess", parentNode, Collections.emptyList(), "Load");
                XmlDiffProcessor.dealEventNode(preSaveTable, "PreSaveProcess", parentNode, Collections.emptyList(), "Save");
                XmlDiffProcessor.dealEventNode(postSaveTable, "PostSaveProcess", parentNode, Collections.emptyList(), "Save");
                XmlDiffProcessor.dealEventNode(preDeleteTable, "PreDeleteProcess", parentNode, Collections.emptyList(), "Delete");
                XmlDiffProcessor.dealEventNode(postDeleteTable, "PostDeleteProcess", parentNode, Collections.emptyList(), "Delete");
                XmlDiffProcessor.dealEventNode(statusCollectionTable, "StatusCollection", parentNode, Collections.emptyList(), "");
                XmlDiffProcessor.dealEventNode(statusTriggerCollectionTable, "StatusTriggerCollection", parentNode, Collections.emptyList(), "");
                XmlDiffProcessor.dealEventNode(extendCollectionTable, "ExtendCollection", parentNode, Collections.emptyList(), "");
                XmlDiffProcessor.dealEventNode(macroCollectionTable, "MacroCollection", parentNode, Collections.emptyList(), "");
            }
            if (StringUtils.isBlank((CharSequence)extend) && Objects.nonNull(metaDataObjectProfile)) {
                extend = metaDataObjectProfile.getDataObject().getMergeToSourceMapKey();
            }
            ArrayList<String> extendCheckRuleKeyList = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)extend) && Objects.nonNull(xmlTreeWithPath = XmlTreeWithPath.parseFilePath(filePath = StringUtils.isNotBlank((CharSequence)(tempXmlFilePath = XmlFileProcessor.instance.getTmpFile(xmlFilePath = LoadFileTree.getPathByDataObject(extend)))) ? tempXmlFilePath : xmlFilePath)) && Objects.nonNull(checkRuleCollectionNode = (rootNode = xmlTreeWithPath.xmlTree.getRoot()).getChildByTagName("CheckRuleCollection"))) {
                List<TagNode> checkRuleNodeList = checkRuleCollectionNode.findNodesByTagName("CheckRule");
                for (TagNode tagNode : checkRuleNodeList) {
                    String errorInfo = tagNode.getAttributes().get("ErrorInfo");
                    extendCheckRuleKeyList.add(errorInfo);
                }
            }
            XmlDiffProcessor.dealEventNode(checkRuleCollectionTable, "CheckRuleCollection", parentNode, extendCheckRuleKeyList, "");
        }
        XmlDiffProcessor.dealOIDFilterNode(document, xmlTree);
        XmlDiffProcessor.genXmlDiff(xmlTree, xmlTree.xmlTree.getRoot(), diff, true);
    }

    private static void dealEventNode(DataTable dataTable, String nodeName, TagNode parentNode, List<String> existKeyList, String prefix) {
        parentNode.deleteChildByTagName(nodeName);
        if (dataTable.size() > 0) {
            if (nodeName.contains("Process")) {
                TagNode eventSet = new TagNode(nodeName, null);
                int i = 0;
                while (i < dataTable.size()) {
                    String description = dataTable.getString(i, String.valueOf(prefix) + "Description");
                    String content = dataTable.getString(i, String.valueOf(prefix) + "Script");
                    TagNode event = new TagNode("Process", null);
                    event.setAttribute("Description", description);
                    event.setCDataValue(content);
                    eventSet.addNode(event);
                    ++i;
                }
                parentNode.addNode(eventSet);
            } else if ("StatusCollection".equals(nodeName)) {
                TagNode eventSet = new TagNode(nodeName, null);
                int i = 0;
                while (i < dataTable.size()) {
                    String key = dataTable.getString(i, "Key");
                    String caption = dataTable.getString(i, "Caption");
                    Integer value = dataTable.getInt(i, "StatusValue");
                    Boolean isStandalone = dataTable.getBoolean(i, "IsStandalone");
                    TagNode event = new TagNode("Status", null);
                    event.setAttribute("Key", key);
                    event.setAttribute("Caption", caption);
                    if (value != -1) {
                        event.setAttribute("Value", value.toString());
                    }
                    event.setAttribute("IsStandalone", String.valueOf(isStandalone));
                    eventSet.addNode(event);
                    ++i;
                }
                parentNode.addNode(eventSet);
            } else if ("StatusTriggerCollection".equals(nodeName)) {
                TagNode eventSet = new TagNode(nodeName, null);
                int i = 0;
                while (i < dataTable.size()) {
                    String key = dataTable.getString(i, "Key");
                    String content = dataTable.getString(i, "Content");
                    TagNode event = new TagNode("StatusTrigger", null);
                    event.setAttribute("StatusKey", key);
                    event.setCDataValue(content);
                    eventSet.addNode(event);
                    ++i;
                }
                parentNode.addNode(eventSet);
            } else if ("ExtendCollection".equals(nodeName)) {
                TagNode eventSet = new TagNode(nodeName, null);
                int i = 0;
                while (i < dataTable.size()) {
                    String className = dataTable.getString(i, "ClassName");
                    String alias = dataTable.getString(i, "Alias");
                    TagNode event = new TagNode("Extend", null);
                    event.setAttribute("Alias", alias);
                    event.setAttribute("Class", className);
                    eventSet.addNode(event);
                    ++i;
                }
                parentNode.addNode(eventSet);
            } else if ("CheckRuleCollection".equals(nodeName)) {
                TagNode eventSet = new TagNode(nodeName, null);
                ArrayList<TagNode> eventNodeList = new ArrayList<TagNode>();
                ArrayList<Object> keyList = new ArrayList<Object>();
                int i = 0;
                while (i < dataTable.size()) {
                    String errorInfo = dataTable.getString(i, "ErrorInfo");
                    if (dataTable.getState(i) == 1 && existKeyList.contains(errorInfo)) {
                        throw new RuntimeException("warning: \u68c0\u67e5\u89c4\u5219\u91cd\u590d\u5b9a\u4e49!");
                    }
                    if (existKeyList.contains(errorInfo)) {
                        keyList.add(errorInfo);
                    } else {
                        if (keyList.contains(errorInfo)) {
                            throw new RuntimeException("warning: \u68c0\u67e5\u89c4\u5219\u91cd\u590d\u5b9a\u4e49!");
                        }
                        keyList.add(errorInfo);
                        String script = dataTable.getString(i, "CheckRuleScript");
                        TagNode event = new TagNode("CheckRule", null);
                        eventNodeList.add(event);
                        event.setAttribute("ErrorInfo", errorInfo);
                        event.setCDataValue(script);
                    }
                    ++i;
                }
                if (CollectionUtils.isNotEmpty(eventNodeList)) {
                    for (TagNode tagNode : eventNodeList) {
                        eventSet.addNode(tagNode);
                    }
                    parentNode.addNode(eventSet);
                }
            } else if ("MacroCollection".equals(nodeName)) {
                TagNode eventSet = new TagNode(nodeName, null);
                int i = 0;
                while (i < dataTable.size()) {
                    String key = dataTable.getString(i, "Key");
                    String args = dataTable.getString(i, "Args");
                    String content = dataTable.getString(i, "Content");
                    TagNode event = new TagNode("Macro", null);
                    event.setAttribute("Key", key);
                    event.setAttribute("Args", args);
                    event.setCDataValue(content);
                    eventSet.addNode(event);
                    ++i;
                }
                parentNode.addNode(eventSet);
            }
        }
    }

    private static void dealOIDFilterNode(Document document, XmlTreeWithPath xmlTree) {
        block15: {
            if (xmlTree.xmlTree.getRoot().findNodesByTagName("DataSource").size() == 0) {
                return;
            }
            TagNode dataSource = xmlTree.xmlTree.getRoot().findNodesByTagName("DataSource").get(0);
            dataSource.deleteChildByTagName("OIDFilter");
            DataTable oidFilter = document.get("ED_OIDFilter");
            if (oidFilter.size() <= 0) break block15;
            String filterType = oidFilter.getString(0, "Type");
            TagNode eventSet = new TagNode("OIDFilter", null);
            eventSet.setAttribute("Type", filterType);
            switch (filterType) {
                case "Formula": {
                    String filterFormula = oidFilter.getString(0, "Formula");
                    eventSet.setAttribute("Formula", filterFormula);
                    break;
                }
                case "Interface": {
                    String filterInterface = oidFilter.getString(0, "Interface");
                    eventSet.setAttribute("Impl", filterInterface);
                    break;
                }
                case "Query": {
                    DataTable parameterCollection = document.get("ED_ParameterCollection");
                    TagNode statement = new TagNode("Statement", null);
                    String sql = oidFilter.getString(0, "Sql");
                    sql = StringUtils.isBlank((CharSequence)sql) ? "" : sql;
                    statement.setCDataValue(sql);
                    eventSet.addNode(statement);
                    TagNode parameterCollectionNode = new TagNode("ParameterCollection", null);
                    int i = 0;
                    while (i < parameterCollection.size()) {
                        String ofDataType = parameterCollection.getString(i, "DataType");
                        String ofSourceType = parameterCollection.getString(i, "SourceType");
                        String ofValue = parameterCollection.getString(i, "Value");
                        String ofDescription = parameterCollection.getString(i, "Description");
                        TagNode parameterNode = new TagNode("Parameter", null);
                        parameterNode.setAttribute("DataType", ofDataType);
                        parameterNode.setAttribute("SourceType", ofSourceType);
                        parameterNode.setAttribute("Value", ofValue);
                        parameterNode.setAttribute("Description", ofDescription);
                        parameterCollectionNode.addNode(parameterNode);
                        ++i;
                    }
                    eventSet.addNode(parameterCollectionNode);
                }
            }
            dataSource.addNode(eventSet);
        }
    }

    public static void dealHeadTable(XmlTreeWithPath xmlTree, DataTable headTable, DataTable collecTable, DataTable fieldTable, DataTable ed_parameterCollection, DataTable ed_indexCollection, Diff diff) throws Throwable {
        TagNode dataObjectNode;
        TagNode rootNode = xmlTree.xmlTree.getRoot();
        List<TagNode> dataSourceNodeList = rootNode.findNodesByTagName("DataSource");
        List<TagNode> dataObjectNodeList = rootNode.findNodesByTagName("DataObject");
        if (CollectionUtils.isEmpty(dataSourceNodeList) && CollectionUtils.isEmpty(dataObjectNodeList)) {
            XmlDiffProcessor.genXmlDiff(xmlTree, rootNode, diff, true);
            return;
        }
        if (CollectionUtils.isNotEmpty(dataObjectNodeList)) {
            dataObjectNode = dataObjectNodeList.get(0);
        } else {
            String refObjectKey = dataSourceNodeList.get(0).getAttributes().get("RefObjectKey");
            String filePath = LoadFileTree.loadFilePathByDataObjectFieldKey(refObjectKey);
            XmlTreeWithPath dataObjectXmlTree = XmlTreeWithPath.parseFilePath(filePath);
            dataObjectNode = dataObjectXmlTree.xmlTree.getRoot().findNodesByTagName(MetaObjectType.DataObject.name).get(0);
        }
        MetaDataObject curDataObject = Objects.nonNull(diff.getDataObject()) ? DataObjectHelper.loadByKey(diff.getDataObject().getKey()) : null;
        String mainTableKey = XmlDiffProcessor.getMainTableKey(collecTable);
        int i = 0;
        while (i < headTable.size()) {
            TagNode tagNode;
            String auxiliaryType = headTable.getString("AuxiliaryType");
            if (auxiliaryType.equalsIgnoreCase("Migration") && StringUtils.isBlank((CharSequence)mainTableKey)) {
                throw new Throwable("\u8fc1\u79fb\u8868\u5fc5\u987b\u5b58\u5728\u4e3b\u8868");
            }
            String mainTable = headTable.getString(i, "MainTable");
            if (StringUtils.isBlank((CharSequence)mainTableKey)) {
                mainTable = "";
            }
            dataObjectNode.setAttribute("Key", headTable.getString(i, "Mark"));
            dataObjectNode.setAttribute("PrimaryTableKey", mainTable);
            String reserveOne = diff.getReserveOne();
            String extend = rootNode.getAttributes().get("Extend");
            if (!StringUtils.equals((CharSequence)reserveOne, (CharSequence)"DataObject") || StringUtils.isBlank((CharSequence)extend)) {
                String mainType = headTable.getString(i, "MainType");
                if ("Virtual".equals(mainType)) {
                    dataObjectNode.setAttribute("PrimaryType", null);
                    dataObjectNode.setAttribute("SecondaryType", null);
                    dataObjectNode.setAttribute("QueryFields", null);
                    dataObjectNode.setAttribute("DisplayFields", null);
                } else {
                    dataObjectNode.setAttribute("PrimaryType", mainType);
                }
                dataObjectNode.setAttribute("Caption", headTable.getString(i, "Caption"));
                dataObjectNode.setAttribute("LoadRightsType", headTable.getString(i, "LoadRightsType"));
                dataObjectNode.setAttribute("CheckAfterLoad", headTable.getString(i, "CheckAfterLoad"));
                dataObjectNode.setAttribute("MaintainDict", headTable.getString(i, "MaintainDict"));
                dataObjectNode.setAttribute("SecondaryType", auxiliaryType);
                if (auxiliaryType.equalsIgnoreCase("Migration")) {
                    String migrationUpdateStrategy = headTable.getString(i, "MigrationUpdateStrategy");
                    if (StringUtils.isBlank((CharSequence)migrationUpdateStrategy)) {
                        migrationUpdateStrategy = "InsertFast";
                    }
                    dataObjectNode.setAttribute("MigrationUpdateStrategy", migrationUpdateStrategy);
                }
                if ("Dict".equalsIgnoreCase(auxiliaryType) || "ChainDict".equalsIgnoreCase(auxiliaryType)) {
                    dataObjectNode.setAttribute("DisplayFields", headTable.getString(i, "DisplayFields"));
                    dataObjectNode.setAttribute("QueryFields", headTable.getString(i, "QueryFields"));
                } else {
                    dataObjectNode.setAttribute("DisplayFields", null);
                    dataObjectNode.setAttribute("QueryFields", null);
                }
            } else {
                dataObjectNode.setAttribute("LoadRightsType", headTable.getString(i, "LoadRightsType"));
                dataObjectNode.setAttribute("CheckAfterLoad", headTable.getString(i, "CheckAfterLoad"));
            }
            if (StringUtils.equals((CharSequence)reserveOne, (CharSequence)"DataObject") && StringUtils.isNotBlank((CharSequence)extend)) {
                if ("Dict".equalsIgnoreCase(auxiliaryType) || "ChainDict".equalsIgnoreCase(auxiliaryType)) {
                    String extendPath = LoadFileTree.getPathByDataObject(extend);
                    String extendTmpPath = XmlFileProcessor.instance.getTmpFile(extendPath);
                    String realExtendPath = StringUtils.isNotBlank((CharSequence)extendTmpPath) ? extendTmpPath : extendPath;
                    XmlTree extendXmlTree = Xml4jUtil.parseTree(realExtendPath);
                    TagNode extendNode = extendXmlTree.getTagNode("DataObject@" + extend);
                    Map<String, String> extendAttributes = extendNode.getAttributes();
                    String extendDisplayFields = extendAttributes.getOrDefault("DisplayFields", "");
                    String extendDisplayFields2 = RegExUtils.replaceAll((String)extendDisplayFields, (String)"\\s*", (String)"");
                    extendDisplayFields2 = RegExUtils.replaceAll((String)extendDisplayFields2, (String)";", (String)"");
                    String displayFields = headTable.getString(i, "DisplayFields");
                    displayFields = Objects.isNull(displayFields) ? "" : displayFields;
                    String displayFields2 = RegExUtils.replaceAll((String)displayFields, (String)"\\s*", (String)"");
                    if (!(StringUtils.equals((CharSequence)(displayFields2 = RegExUtils.replaceAll((String)displayFields2, (String)";", (String)"")), (CharSequence)extendDisplayFields2) || StringUtils.isBlank((CharSequence)extendDisplayFields) && StringUtils.equals((CharSequence)displayFields2, (CharSequence)"CodeName"))) {
                        Map<String, String> attributes = dataObjectNode.getAttributes();
                        attributes.put("DisplayFields", displayFields);
                    } else {
                        dataObjectNode.setAttribute("DisplayFields", null);
                    }
                    String extendQueryFields = extendAttributes.getOrDefault("QueryFields", "");
                    String extendQueryFields2 = RegExUtils.replaceAll((String)extendQueryFields, (String)"\\s*", (String)"");
                    extendQueryFields2 = RegExUtils.replaceAll((String)extendQueryFields2, (String)";", (String)"");
                    String queryFields = headTable.getString(i, "QueryFields");
                    queryFields = Objects.isNull(queryFields) ? "" : queryFields;
                    String queryFields2 = RegExUtils.replaceAll((String)queryFields, (String)"\\s*", (String)"");
                    queryFields2 = RegExUtils.replaceAll((String)queryFields2, (String)";", (String)"");
                    if (!StringUtils.equals((CharSequence)queryFields2, (CharSequence)extendQueryFields2) && !StringUtils.equals((CharSequence)queryFields2, (CharSequence)extendDisplayFields2)) {
                        Map<String, String> attributes = dataObjectNode.getAttributes();
                        attributes.put("QueryFields", queryFields);
                    } else {
                        dataObjectNode.setAttribute("QueryFields", null);
                    }
                } else {
                    dataObjectNode.setAttribute("DisplayFields", null);
                    dataObjectNode.setAttribute("QueryFields", null);
                }
            }
            XmlDiffProcessor.dealCollecTable(xmlTree, collecTable, fieldTable, diff, ed_parameterCollection, ed_indexCollection, curDataObject);
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)auxiliaryType, (CharSequence[])new CharSequence[]{"Normal", "Migration"})) {
                tagNode = xmlTree.xmlTree.getTagNode("Table@" + mainTable);
                if (Objects.isNull(tagNode)) {
                    XmlDiffProcessor.genXmlDiff(xmlTree, dataObjectNode, diff, true);
                    return;
                }
            } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)auxiliaryType, (CharSequence[])new CharSequence[]{"ChainDict", "Dict"})) {
                tagNode = xmlTree.xmlTree.getTagNode("Table@" + mainTable);
                if (Objects.isNull(tagNode)) {
                    XmlDiffProcessor.genXmlDiff(xmlTree, dataObjectNode, diff, true);
                    return;
                }
                if (!StringUtils.equals((CharSequence)reserveOne, (CharSequence)"DataObject") || StringUtils.isBlank((CharSequence)extend)) {
                    if (Objects.nonNull(diff.getMetaForm()) && StringUtils.isNotBlank((CharSequence)extend)) {
                        if (StringUtils.isNotBlank((CharSequence)diff.getMetaForm().getDataSource().getRefObjectKey())) {
                            DICT_HEAD_TABLE_COLUMN_LIST.forEach(columnMap -> XmlDiffProcessor.addColumnNode(tagNode, columnMap));
                        }
                    } else {
                        DICT_HEAD_TABLE_COLUMN_LIST.forEach(columnMap -> XmlDiffProcessor.addColumnNode(tagNode, columnMap));
                    }
                }
            }
            if (!StringUtils.equalsAnyIgnoreCase((CharSequence)auxiliaryType, (CharSequence[])new CharSequence[]{"ChainDict", "Dict"})) {
                tagNode = xmlTree.xmlTree.getTagNode("Table@" + mainTable);
                if (Objects.isNull(tagNode)) {
                    XmlDiffProcessor.genXmlDiff(xmlTree, dataObjectNode, diff, true);
                    return;
                }
                if (!StringUtils.equals((CharSequence)reserveOne, (CharSequence)"DataObject") || StringUtils.isBlank((CharSequence)extend)) {
                    if (Objects.nonNull(diff.getMetaForm()) && StringUtils.isNotBlank((CharSequence)extend)) {
                        if (StringUtils.isNotBlank((CharSequence)diff.getMetaForm().getDataSource().getRefObjectKey())) {
                            DICT_HEAD_TABLE_COLUMN_LIST.forEach(columnMap -> XmlDiffProcessor.removeColumnNode(tagNode, (String)columnMap.get("Key"), diff.getMetaForm().getDataSource().getRefObjectKey()));
                        }
                    } else {
                        String dataObjectKey = null;
                        if (diff.getMetaForm() != null) {
                            dataObjectKey = diff.getMetaForm().getDataSource().getDataObject().getKey();
                        } else if (diff.getDataObject() != null) {
                            dataObjectKey = diff.getDataObject().getKey();
                        }
                        if (StringUtils.isNotBlank(dataObjectKey)) {
                            String finalDataObjectKey = dataObjectKey;
                            DICT_HEAD_TABLE_COLUMN_LIST.forEach(columnMap -> XmlDiffProcessor.removeColumnNode(tagNode, (String)columnMap.get("Key"), finalDataObjectKey));
                        }
                    }
                }
            }
            ++i;
        }
        XmlDiffProcessor.genXmlDiff(xmlTree, diff.getXmlTree().xmlTree.getRoot(), diff, true);
    }

    private static void dealComboBox(XmlTreeWithPath xmlTree, DataTable ComboBoxDetail, Diff diff) throws Throwable {
        String componentkey;
        String owerFormKey = diff.formKey;
        MetaForm metaForm = StringUtils.isBlank((CharSequence)owerFormKey) ? null : MetaFactory.getGlobalInstance().getMetaForm(owerFormKey);
        AbstractMetaObject metaComponent1 = DesignIOMetaUtil.getMetaComponent(metaForm, componentkey = diff.getKey());
        if (Objects.isNull(metaComponent1) && diff.getContainerKey() != null) {
            metaForm = MetaFactory.getGlobalInstance().getMetaForm(diff.getContainerKey());
            metaComponent1 = DesignIOMetaUtil.getMetaComponent(metaForm, componentkey);
        }
        String tagName2 = metaComponent1.getTagName();
        String xmlTreekey = XmlDiffProcessor.getXmlTreeKey(diff, tagName2, componentkey);
        TagNode parentNode = xmlTree.xmlTree.getTagNode(xmlTreekey);
        parentNode.deleteChildByTagName("Item");
        int i = 0;
        while (i < ComboBoxDetail.size()) {
            Boolean extendFlag = ComboBoxDetail.getBoolean(i, "ExtendFlag");
            if (!extendFlag.booleanValue()) {
                String Key2 = ComboBoxDetail.getString(i, "Key");
                String caption = ComboBoxDetail.getString(i, "Caption");
                String value = ComboBoxDetail.getString(i, "Value");
                TagNode itemNode = new TagNode("Item", null);
                itemNode.setAttribute("Caption", caption);
                itemNode.setAttribute("Key", Key2);
                itemNode.setAttribute("Value", value);
                parentNode.addNode(itemNode);
            }
            ++i;
        }
        XmlDiffProcessor.genXmlDiff(xmlTree, parentNode, diff, true);
    }

    private static void dealCheckRuleCollection(XmlTreeWithPath xmlTree, DataTable ruleCollection, Diff diff) {
        TagNode gridRow = xmlTree.xmlTree.getTagNode("GridRow@" + diff.getKey());
        gridRow.deleteChildByTagName("UICheckRuleCollection");
        if (ruleCollection.size() != 0) {
            TagNode node = new TagNode("UICheckRuleCollection", null);
            gridRow.addNode(node);
            int i = 0;
            while (i < ruleCollection.size()) {
                TagNode checkRule = new TagNode("UICheckRule", null);
                checkRule.setAttribute("Description", ruleCollection.getString(i, "Description"));
                checkRule.setAttribute("ErrorInfo", ruleCollection.getString(i, "ErrorInfo"));
                CDataNode cNode = new CDataNode("", null);
                cNode.setText(ruleCollection.getString(i, "UICheckRule"));
                checkRule.addNode(cNode);
                node.addNode(checkRule);
                ++i;
            }
        }
        XmlDiffProcessor.genXmlDiff(xmlTree, gridRow, diff, true);
    }

    private static void dealGridRowTree(XmlTreeWithPath xmlTree, DataTable ComboBoxDetail, Diff diff) {
        TagNode gridRow = xmlTree.xmlTree.getTagNode("GridRow@" + diff.getKey());
        TagNode rowTree = gridRow.getOrCreateChildByTagName("RowTree");
        if (rowTree.getChildren().size() == 0) {
            CDataNode cNode = new CDataNode("", null);
            rowTree.addNode(cNode);
            String expand = ComboBoxDetail.getInt(0, "IsExpand") == 1 ? "true" : "false";
            String expandLevel = ComboBoxDetail.getInt(0, "ExpandLevel").toString();
            String treeType = GridTreeType.toString((Integer)ComboBoxDetail.getInt(0, "TreeType"));
            String type = ComboBoxDetail.getString(0, "Type");
            String cellKey = ComboBoxDetail.getString(0, "CellKey");
            String foreign = ComboBoxDetail.getString(0, "Foreign");
            String parent = ComboBoxDetail.getString(0, "Parent");
            String content = ComboBoxDetail.getString(0, "Content");
            if (!"false".equalsIgnoreCase(expand)) {
                rowTree.setAttribute("Expand", expand);
            } else {
                rowTree.getAttributes().remove("Expand");
            }
            if (!"-1".equalsIgnoreCase(expandLevel)) {
                rowTree.setAttribute("ExpandLevel", expandLevel);
            } else {
                rowTree.getAttributes().remove("ExpandLevel");
            }
            if ("None".equalsIgnoreCase(treeType)) {
                rowTree.getAttributes().remove("TreeType");
            } else {
                rowTree.setAttribute("TreeType", treeType);
            }
            if ("Formal".equalsIgnoreCase(type)) {
                rowTree.getAttributes().remove("Type");
            } else {
                rowTree.setAttribute("Type", type);
            }
            if (!StringUtils.isNotEmpty((CharSequence)cellKey)) {
                rowTree.getAttributes().remove("CellKey");
            } else {
                rowTree.setAttribute("CellKey", cellKey);
            }
            if (!StringUtils.isNotEmpty((CharSequence)parent)) {
                rowTree.getAttributes().remove("Parent");
            } else {
                rowTree.setAttribute("Parent", parent);
            }
            if (!StringUtils.isNotEmpty((CharSequence)foreign)) {
                rowTree.getAttributes().remove("Foreign");
            } else {
                rowTree.setAttribute("Foreign", foreign);
            }
            if (content != null) {
                rowTree.setCDataValue(content);
            }
        } else {
            String expand = ComboBoxDetail.getInt(0, "IsExpand") == 1 ? "true" : "false";
            String expandLevel = ComboBoxDetail.getInt(0, "ExpandLevel").toString();
            String treeType = GridTreeType.toString((Integer)ComboBoxDetail.getInt(0, "TreeType"));
            String type = ComboBoxDetail.getString(0, "Type");
            String foreign = ComboBoxDetail.getString(0, "Foreign");
            String parent = ComboBoxDetail.getString(0, "Parent");
            String cellKey = ComboBoxDetail.getString(0, "CellKey");
            String content = ComboBoxDetail.getString(0, "Content");
            if (!"false".equalsIgnoreCase(expand)) {
                rowTree.setAttribute("Expand", expand);
            } else {
                rowTree.getAttributes().remove("Expand");
            }
            if (!"-1".equalsIgnoreCase(expandLevel)) {
                rowTree.setAttribute("ExpandLevel", expandLevel);
            } else {
                rowTree.getAttributes().remove("ExpandLevel");
            }
            if ("None".equalsIgnoreCase(treeType)) {
                rowTree.getAttributes().remove("TreeType");
            } else {
                rowTree.setAttribute("TreeType", treeType);
            }
            if ("Formal".equalsIgnoreCase(type)) {
                rowTree.getAttributes().remove("Type");
            } else {
                rowTree.setAttribute("Type", type);
            }
            if (!StringUtils.isNotEmpty((CharSequence)cellKey)) {
                rowTree.getAttributes().remove("CellKey");
            } else {
                rowTree.setAttribute("CellKey", cellKey);
            }
            if (!StringUtils.isNotEmpty((CharSequence)parent)) {
                rowTree.getAttributes().remove("Parent");
            } else {
                rowTree.setAttribute("Parent", parent);
            }
            if (!StringUtils.isNotEmpty((CharSequence)foreign)) {
                rowTree.getAttributes().remove("Foreign");
            } else {
                rowTree.setAttribute("Foreign", foreign);
            }
            if (content != null) {
                rowTree.setCDataValue(content);
            }
        }
        if (rowTree.getAttributes().size() == 0) {
            rowTree.getParent().deleteChildByTagName("RowTree");
        }
        XmlDiffProcessor.genXmlDiff(xmlTree, gridRow, diff, true);
    }

    private static void dealDictColumn(XmlTreeWithPath xmlTree, DataTable dictDetail, Diff diff) throws Throwable {
        String componentkey;
        String owerFormKey = diff.formKey;
        MetaForm metaForm = StringUtils.isBlank((CharSequence)owerFormKey) ? null : MetaFactory.getGlobalInstance().getMetaForm(owerFormKey);
        AbstractMetaObject metaComponent1 = DesignIOMetaUtil.getMetaComponent(metaForm, componentkey = diff.getKey());
        if (Objects.isNull(metaComponent1) && diff.getContainerKey() != null) {
            metaForm = MetaFactory.getGlobalInstance().getMetaForm(diff.getContainerKey());
            metaComponent1 = DesignIOMetaUtil.getMetaComponent(metaForm, componentkey);
        }
        String tagName2 = metaComponent1.getTagName();
        String xmlTreekey = XmlDiffProcessor.getXmlTreeKey(diff, tagName2, componentkey);
        TagNode parentNode = xmlTree.xmlTree.getTagNode(xmlTreekey);
        TagNode columnNode = new TagNode("DictViewColumnCollection", null);
        parentNode.deleteChildByTagName("DictViewColumnCollection");
        int i = 0;
        while (i < dictDetail.size()) {
            String Key2 = dictDetail.getString(i, "Key");
            String caption = dictDetail.getString(i, "Caption");
            int width = dictDetail.getInt(i, "Width");
            String widthType = dictDetail.getString(i, "WidthUnit");
            TagNode itemNode = new TagNode("DictViewColumn", null);
            itemNode.setAttribute("Caption", caption);
            itemNode.setAttribute("Key", Key2);
            itemNode.setAttribute("Width", String.valueOf(width) + XmlDiffProcessor.defSizeToString(Integer.parseInt(widthType)));
            columnNode.addNode(itemNode);
            ++i;
        }
        parentNode.addNode(columnNode);
        XmlDiffProcessor.genXmlDiff(xmlTree, parentNode, diff, true);
    }

    public static String defSizeToString(int sizeType) {
        String s;
        switch (sizeType) {
            case 2: {
                s = "pref";
                break;
            }
            case 4: {
                s = "inherit";
                break;
            }
            case 3: {
                s = "unit";
                break;
            }
            case 1: {
                s = "%";
                break;
            }
            case 5: {
                s = "dp";
                break;
            }
            case 6: {
                s = "auto";
                break;
            }
            default: {
                s = "px";
            }
        }
        return s;
    }

    private static void dealEmbedVar(XmlTreeWithPath xmlTree, DataTable embedVarDetail, Diff diff) {
        String componentkey = diff.getKey();
        String xmlTreekey = "Embed@" + componentkey;
        TagNode parentNode = xmlTree.xmlTree.getTagNode(xmlTreekey);
        parentNode.deleteChildByTagName("Var");
        int i = 0;
        while (i < embedVarDetail.size()) {
            String Key2 = embedVarDetail.getString(i, "Key");
            String value = embedVarDetail.getString(i, "Value");
            TagNode itemNode = new TagNode("Var", null);
            itemNode.setAttribute("Key", Key2);
            itemNode.setAttribute("Value", value);
            parentNode.addNode(itemNode);
            ++i;
        }
        XmlDiffProcessor.genXmlDiff(xmlTree, parentNode, diff, true);
    }

    private static void dealMacro(XmlTreeWithPath xmlTree, DataTable MacroDetail, Diff diff) throws Throwable {
        TagNode parentNode = xmlTree.xmlTree.getRoot();
        TagNode macroCollection = xmlTree.xmlTree.getRoot().findFirstTagNodeByTagName("MacroCollection");
        MacroDetail.setShowDeleted(true);
        if (Objects.isNull(macroCollection)) {
            TagNode macroCollection1 = new TagNode("MacroCollection", null);
            parentNode.addNode(macroCollection1);
        }
        List<AbstractNode> children = parentNode.getChildren();
        int i = 0;
        while (i < MacroDetail.size()) {
            Object tagName;
            int state;
            String orgKeyDetail = (String)MacroDetail.getOriginalObject(i, "Key");
            String orgArgsDetail = (String)MacroDetail.getOriginalObject(i, "Args");
            String orgFormulaDetail = (String)MacroDetail.getOriginalObject(i, "Formula");
            String keyDetail = MacroDetail.getString(i, "Key");
            String argsDetail = MacroDetail.getString(i, "Args");
            String formulaDetail = MacroDetail.getString(i, "Formula");
            if (StringUtils.isBlank((CharSequence)orgKeyDetail)) {
                orgKeyDetail = keyDetail;
            }
            if (StringUtils.isBlank((CharSequence)orgFormulaDetail)) {
                orgFormulaDetail = argsDetail;
            }
            if (StringUtils.isBlank((CharSequence)orgArgsDetail)) {
                orgArgsDetail = formulaDetail;
            }
            if ((state = MacroDetail.getState(i)) == 1) {
                for (AbstractNode ch : children) {
                    if (!(ch instanceof TagNode) || !"MacroCollection".equalsIgnoreCase((String)(tagName = ((TagNode)ch).getTagName()))) continue;
                    TagNode macro = new TagNode("Macro", null);
                    macro.setAttribute("Key", keyDetail);
                    if (StringUtils.isNotEmpty((CharSequence)argsDetail)) {
                        macro.setAttribute("Args", argsDetail);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)formulaDetail)) {
                        CDataNode cNode = new CDataNode(formulaDetail, null);
                        macro.addNode(cNode);
                    }
                    ((TagNode)ch).addNode(macro);
                }
            } else if (state == 2) {
                List<AbstractNode> children1 = macroCollection.getChildren();
                tagName = children1.iterator();
                while (tagName.hasNext()) {
                    AbstractNode macro = tagName.next();
                    if (!(macro instanceof TagNode) || !"Macro".equalsIgnoreCase(((TagNode)macro).getTagName()) || !((TagNode)macro).getAttributes().get("Key").equalsIgnoreCase(orgKeyDetail) || !(keyDetail != null && keyDetail.equalsIgnoreCase(orgKeyDetail) && ((TagNode)macro).getAttributes().get("Key").equalsIgnoreCase(orgKeyDetail) || !"".equals(argsDetail) && !argsDetail.equalsIgnoreCase(orgArgsDetail) && ((TagNode)macro).getAttributes().get("Args").equalsIgnoreCase(orgArgsDetail)) && (formulaDetail == null || formulaDetail.equalsIgnoreCase(orgFormulaDetail) || !((TagNode)macro).getChildren().get(1).getText().equalsIgnoreCase(orgFormulaDetail))) continue;
                    ((TagNode)macro).setAttribute("Key", keyDetail);
                    if (StringUtils.isNotEmpty((CharSequence)argsDetail)) {
                        ((TagNode)macro).setAttribute("Args", argsDetail);
                    } else {
                        ((TagNode)macro).getAttributes().remove("Args");
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)formulaDetail)) {
                        if (((TagNode)macro).getChildren().size() <= 1) continue;
                        ((TagNode)macro).getChildren().remove(1);
                        continue;
                    }
                    ((TagNode)macro).setCDataValue(formulaDetail);
                }
            } else if (state == 3) {
                List<AbstractNode> childrenDelete = macroCollection.getChildren();
                Iterator<AbstractNode> iterator = childrenDelete.iterator();
                while (iterator.hasNext()) {
                    String chridrenName;
                    AbstractNode dren = iterator.next();
                    if (!(dren instanceof TagNode) || !"Macro".equalsIgnoreCase(chridrenName = ((TagNode)dren).getTagName()) || !((TagNode)dren).getAttributes().get("Key").equalsIgnoreCase(keyDetail)) continue;
                    iterator.remove();
                }
            }
            ++i;
        }
        XmlDiffProcessor.genXmlDiff(xmlTree, parentNode, diff, true);
    }

    private static void dealDropdownButton(XmlTreeWithPath xmlTree, TagNode node, DataTable detailTable, Diff diff) {
        node.deleteChildByTagName("DropdownItem");
        int i = 0;
        while (i < detailTable.size()) {
            TagNode dropdownItem = new TagNode("DropdownItem", null);
            dropdownItem.setAttribute("Key", detailTable.getString(i, "Key"));
            dropdownItem.setAttribute("Text", detailTable.getString(i, "TextContent"));
            dropdownItem.setAttribute("Separator", detailTable.getString(i, "Separator"));
            if (StringUtils.isNotEmpty((CharSequence)detailTable.getString(i, "OnClick"))) {
                TagNode action = new TagNode("OnClick", null);
                CDataNode cDataNode = new CDataNode(detailTable.getString(i, "OnClick"), null);
                action.addNode(cDataNode);
                dropdownItem.addNode(action);
            }
            node.addNode(dropdownItem);
            ++i;
        }
        XmlDiffProcessor.genXmlDiff(xmlTree, node, diff, true);
    }

    private static void dealCollecTable(XmlTreeWithPath xmlTree, DataTable collecTable, DataTable fieldTable, Diff diff, DataTable ed_parameterCollection, DataTable ed_indexCollection, MetaDataObject curDataObject) throws Throwable {
        collecTable.setShowDeleted(true);
        if (collecTable.size() < 1) {
            return;
        }
        TagNode tableCollectionNode = XmlDiffProcessor.getTableCollectionNode(xmlTree);
        TagNode dataObjectNode = tableCollectionNode.getParent();
        int i = 0;
        while (i < collecTable.size()) {
            block86: {
                boolean extendTableFlag;
                TagNode rootNode;
                String extend;
                String orderBy;
                int rowState;
                String orgTableKey;
                String tableMark;
                block87: {
                    boolean extendTableFlag2;
                    String tableFilterTwo;
                    String tableFilter;
                    TagNode statementNode;
                    boolean embedTableFlag = collecTable.getBoolean(i, "EmbedTableFlag");
                    if (embedTableFlag) break block86;
                    tableMark = collecTable.getString(i, "TableMark");
                    orgTableKey = (String)collecTable.getOriginalObject(i, "TableMark");
                    if (StringUtils.isBlank((CharSequence)orgTableKey)) {
                        orgTableKey = tableMark;
                    }
                    if (1 != (rowState = collecTable.getState(i))) break block87;
                    List<TagNode> tableNodeList = tableCollectionNode.findNodesByTagName("Table");
                    boolean existFlag = tableNodeList.stream().anyMatch(tagNode -> StringUtils.equals((CharSequence)tagNode.getAttributes().get("Key"), (CharSequence)tableMark));
                    if (existFlag) break block86;
                    TagNode tableNode = new TagNode("Table", null);
                    tableNode.setAttribute("Key", tableMark);
                    tableNode.setAttribute("Caption", collecTable.getString(i, "TableName"));
                    tableNode.setAttribute("DBTableName", collecTable.getString(i, "AssociationTable"));
                    String parentTableKey = collecTable.getString(i, "ParentTableKey");
                    if (StringUtils.isBlank((CharSequence)parentTableKey) || StringUtils.equalsAny((CharSequence)parentTableKey, (CharSequence[])new CharSequence[]{"0", "\u65e0\u6570\u636e\u8868"})) {
                        tableNode.getAttributes().remove("ParentKey");
                    } else {
                        tableNode.setAttribute("ParentKey", parentTableKey);
                    }
                    Integer mode = collecTable.getInt(i, "TableMode");
                    String tableMode = Objects.nonNull(mode) ? TableMode.toString((Integer)mode) : "";
                    tableNode.setAttribute("TableMode", tableMode);
                    Integer persist = collecTable.getInt(i, "Persist");
                    if (Objects.isNull(persist) || persist == 1) {
                        tableNode.getAttributes().remove("Persist");
                    } else {
                        tableNode.setAttribute("Persist", "false");
                    }
                    String groupBy = collecTable.getString(i, "GroupBy");
                    if (StringUtils.isNotBlank((CharSequence)groupBy)) {
                        tableNode.setAttribute("GroupBy", groupBy);
                    } else {
                        tableNode.getAttributes().remove("GroupBy");
                    }
                    String formula = collecTable.getString(i, "Formula");
                    if (StringUtils.isNotBlank((CharSequence)formula)) {
                        tableNode.setAttribute("Formula", formula);
                    } else {
                        tableNode.getAttributes().remove("Formula");
                    }
                    String impl = collecTable.getString(i, "Impl");
                    if (StringUtils.isNotBlank((CharSequence)impl)) {
                        tableNode.setAttribute("Impl", impl);
                    } else {
                        tableNode.getAttributes().remove("Impl");
                    }
                    orderBy = collecTable.getString(i, "OrderBy");
                    if (StringUtils.isNotBlank((CharSequence)orderBy)) {
                        tableNode.setAttribute("OrderBy", orderBy);
                    } else {
                        tableNode.getAttributes().remove("OrderBy");
                    }
                    String indexPrefix = collecTable.getString(i, "IndexPrefix");
                    if (StringUtils.isNotBlank((CharSequence)indexPrefix)) {
                        tableNode.setAttribute("IndexPrefix", indexPrefix);
                    } else {
                        tableNode.getAttributes().remove("IndexPrefix");
                    }
                    String statement = collecTable.getString(i, "Statement");
                    if (StringUtils.isNotBlank((CharSequence)statement)) {
                        TagNode statementNode2 = tableNode.getOrCreateChildByTagName("Statement");
                        statementNode2.setCDataValue(statement);
                    } else {
                        tableNode.deleteChildByTagName("Statement");
                    }
                    String queryType = collecTable.getString(i, "QueryType");
                    if (StringUtils.isNotBlank((CharSequence)queryType)) {
                        statementNode = tableNode.getOrCreateChildByTagName("Statement");
                        statementNode.setAttribute("Type", queryType);
                    } else {
                        statementNode = tableNode.getChildByTagName("Statement");
                        if (Objects.nonNull(statementNode)) {
                            statementNode.getAttributes().remove("Type");
                        }
                    }
                    String type = collecTable.getString(i, "Type");
                    if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"DataObject")) {
                        tableNode.getAttributes().remove("SourceType");
                    } else {
                        if (StringUtils.isNotBlank((CharSequence)type)) {
                            tableNode.setAttribute("SourceType", type);
                        }
                        if (!StringUtils.equals((CharSequence)type, (CharSequence)"Query")) {
                            tableNode.deleteChildByTagName("Statement");
                        }
                    }
                    tableCollectionNode.addNode(tableNode);
                    xmlTree.xmlTree.updateMap(true);
                    String dataType = dataObjectNode.getAttributes().get("SecondaryType");
                    if (StringUtils.isBlank((CharSequence)dataType)) {
                        dataType = "Normal";
                    }
                    Long parentOID = collecTable.getLong(i, "OID");
                    XmlDiffProcessor.dealFieldTable(fieldTable, diff, tableNode, parentOID, curDataObject);
                    String primary = String.valueOf(collecTable.getInt(i, "IsPrimaryTable"));
                    XmlDiffProcessor.dealPrimaryTable(primary, diff, tableNode, dataType);
                    String tableFilterType = collecTable.getString(i, "TableFilterType");
                    if (StringUtils.isNotBlank((CharSequence)tableFilterType)) {
                        TagNode tableFilterNode = tableNode.getOrCreateChildByTagName("TableFilter");
                        tableFilterNode.setAttribute("Type", tableFilterType);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)(tableFilter = collecTable.getString(i, "TableFilter"))) && !StringUtils.equals((CharSequence)type, (CharSequence)"Query")) {
                        TagNode tableFilterNode = tableNode.getOrCreateChildByTagName("TableFilter");
                        tableFilterNode.setAttribute("Type", tableFilterType);
                        tableFilterNode.setCDataValue(tableFilter);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)(tableFilterTwo = collecTable.getString(i, "TableFilterTwo")))) {
                        TagNode tableFilterNode = tableNode.getOrCreateChildByTagName("TableFilter");
                        tableFilterNode.setAttribute("Type", tableFilterType);
                        tableFilterNode.setCDataValue(tableFilterTwo);
                    }
                    if (StringUtils.isBlank((CharSequence)tableFilter) && StringUtils.isBlank((CharSequence)tableFilterTwo)) {
                        tableNode.deleteChildByTagName("TableFilter");
                    }
                    if (!(extendTableFlag2 = collecTable.getBoolean(i, "ExtendTableFlag").booleanValue())) {
                        XmlDiffProcessor.dealParameterCollection(ed_parameterCollection, tableNode, parentOID);
                    }
                }
                if (!StringUtils.isBlank((CharSequence)(extend = (rootNode = xmlTree.xmlTree.getRoot()).getAttributes().get("Extend"))) || !(extendTableFlag = collecTable.getBoolean(i, "ExtendTableFlag").booleanValue())) {
                    String xmlTreeKey = XmlDiffProcessor.getXmlTreeKey(diff, "Table", orgTableKey);
                    TagNode tableNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
                    if (Objects.isNull(tableNode)) {
                        xmlTreeKey = XmlDiffProcessor.getXmlTreeKey(diff, "Table", tableMark);
                        tableNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
                    }
                    if (Objects.isNull(tableNode)) {
                        tableNode = new TagNode("Table", null);
                        tableNode.setAttribute("Key", tableMark);
                        tableCollectionNode.addNode(tableNode);
                    }
                    if (3 == rowState) {
                        List<AbstractNode> children = tableCollectionNode.getChildren();
                        children.remove(tableNode);
                    } else {
                        if (2 == rowState || rowState == 0) {
                            String dataType = dataObjectNode.getAttributes().get("SecondaryType");
                            if (StringUtils.isBlank((CharSequence)dataType)) {
                                dataType = "Normal";
                            }
                            Long parentOID = collecTable.getLong(i, "OID");
                            XmlDiffProcessor.dealFieldTable(fieldTable, diff, tableNode, parentOID, curDataObject);
                            Integer primary = collecTable.getInt(i, "IsPrimaryTable");
                            XmlDiffProcessor.dealPrimaryTable(primary.toString(), diff, tableNode, dataType);
                            Map<String, String> attributes = tableNode.getAttributes();
                            String keyAttrValue = attributes.get("Key");
                            if (!StringUtils.equalsIgnoreCase((CharSequence)keyAttrValue, (CharSequence)tableMark) && !StringUtils.equalsIgnoreCase((CharSequence)diff.getReserveOne(), (CharSequence)"DataObject")) {
                                TagNode bodyNode = xmlTree.xmlTree.getRoot().getChildByTagName("Body");
                                List<TagNode> nodeList = bodyNode.findNodesByTagName("DataBinding");
                                for (TagNode tagNode2 : nodeList) {
                                    if (!StringUtils.equalsIgnoreCase((CharSequence)tagNode2.getAttributes().get("TableKey"), (CharSequence)keyAttrValue)) continue;
                                    tagNode2.setAttribute("TableKey", tableMark);
                                }
                                List<TagNode> rowNodeList = bodyNode.findNodesByTagName("GridRow");
                                for (TagNode tagNode3 : rowNodeList) {
                                    if (!StringUtils.equalsIgnoreCase((CharSequence)tagNode3.getAttributes().get("TableKey"), (CharSequence)keyAttrValue)) continue;
                                    tagNode3.setAttribute("TableKey", tableMark);
                                }
                            }
                            if (StringUtils.equalsIgnoreCase((CharSequence)tableNode.getParent().getParent().getAttributes().get("PrimaryTableKey"), (CharSequence)keyAttrValue)) {
                                tableNode.getParent().getParent().setAttribute("PrimaryTableKey", tableMark);
                            }
                            tableNode.setAttribute("Key", tableMark);
                            String reserveOne = diff.getReserveOne();
                            if (!StringUtils.equals((CharSequence)reserveOne, (CharSequence)"DataObject") || StringUtils.isBlank((CharSequence)extend)) {
                                boolean extendTableFlag3;
                                TagNode statementNode;
                                String parentTableKey;
                                tableNode.setAttribute("Caption", collecTable.getString(i, "TableName"));
                                String associationTable = collecTable.getString(i, "AssociationTable");
                                if (StringUtils.isNotEmpty((CharSequence)associationTable)) {
                                    tableNode.setAttribute("DBTableName", associationTable);
                                }
                                if (StringUtils.isBlank((CharSequence)(parentTableKey = collecTable.getString(i, "ParentTableKey"))) || StringUtils.equalsAny((CharSequence)parentTableKey, (CharSequence[])new CharSequence[]{"0", "\u65e0\u6570\u636e\u8868"})) {
                                    attributes.remove("ParentKey");
                                } else {
                                    tableNode.setAttribute("ParentKey", parentTableKey);
                                }
                                Integer mode = collecTable.getInt(i, "TableMode");
                                String tableMode = Objects.nonNull(mode) ? TableMode.toString((Integer)mode) : "";
                                tableNode.setAttribute("TableMode", tableMode);
                                Integer persist = collecTable.getInt(i, "Persist");
                                if (Objects.isNull(persist) || persist == 1) {
                                    attributes.remove("Persist");
                                } else {
                                    tableNode.setAttribute("Persist", "false");
                                }
                                String groupBy = collecTable.getString(i, "GroupBy");
                                if (StringUtils.isNotBlank((CharSequence)groupBy)) {
                                    tableNode.setAttribute("GroupBy", groupBy);
                                } else {
                                    attributes.remove("GroupBy");
                                }
                                String formula = collecTable.getString(i, "Formula");
                                if (StringUtils.isNotBlank((CharSequence)formula)) {
                                    tableNode.setAttribute("Formula", formula);
                                } else {
                                    attributes.remove("Formula");
                                }
                                String indexPrefix = collecTable.getString(i, "IndexPrefix");
                                if (StringUtils.isNotBlank((CharSequence)indexPrefix)) {
                                    tableNode.setAttribute("IndexPrefix", indexPrefix);
                                } else {
                                    attributes.remove("IndexPrefix");
                                }
                                String impl = collecTable.getString(i, "Impl");
                                if (StringUtils.isNotBlank((CharSequence)impl)) {
                                    tableNode.setAttribute("Impl", impl);
                                } else {
                                    attributes.remove("Impl");
                                }
                                String orderBy2 = collecTable.getString(i, "OrderBy");
                                if (StringUtils.isNotBlank((CharSequence)orderBy2)) {
                                    tableNode.setAttribute("OrderBy", orderBy2);
                                } else {
                                    attributes.remove("OrderBy");
                                }
                                String statement = collecTable.getString(i, "Statement");
                                if (StringUtils.isNotBlank((CharSequence)statement)) {
                                    TagNode statementNode3 = tableNode.getOrCreateChildByTagName("Statement");
                                    statementNode3.setCDataValue(statement);
                                } else {
                                    tableNode.deleteChildByTagName("Statement");
                                }
                                String queryType = collecTable.getString(i, "QueryType");
                                if (StringUtils.isNotBlank((CharSequence)queryType)) {
                                    statementNode = tableNode.getOrCreateChildByTagName("Statement");
                                    statementNode.setAttribute("Type", queryType);
                                } else {
                                    statementNode = tableNode.getChildByTagName("Statement");
                                    if (Objects.nonNull(statementNode)) {
                                        statementNode.getAttributes().remove("Type");
                                    }
                                }
                                String type = collecTable.getString(i, "Type");
                                if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"DataObject")) {
                                    attributes.remove("SourceType");
                                    tableNode.deleteChildByTagName("Statement");
                                } else {
                                    tableNode.setAttribute("SourceType", type);
                                    if (!StringUtils.equals((CharSequence)type, (CharSequence)"Query")) {
                                        tableNode.deleteChildByTagName("Statement");
                                    }
                                }
                                String tableFilter = collecTable.getString(i, "TableFilter");
                                String tableFilterType = collecTable.getString(i, "TableFilterType");
                                if (StringUtils.isNotBlank((CharSequence)tableFilter) && !StringUtils.equals((CharSequence)type, (CharSequence)"Query")) {
                                    TagNode tableFilterNode = tableNode.getOrCreateChildByTagName("TableFilter");
                                    tableFilterNode.setCDataValue(tableFilter);
                                    tableFilterNode.setAttribute("Type", tableFilterType);
                                    tableFilterNode.setAttribute("Type", tableFilterType);
                                } else {
                                    TagNode tableFilterNode;
                                    String tableFilterTwo = collecTable.getString(i, "TableFilterTwo");
                                    if (StringUtils.isNotBlank((CharSequence)tableFilterTwo)) {
                                        tableFilterNode = tableNode.getOrCreateChildByTagName("TableFilter");
                                        tableFilterNode.setAttribute("Type", tableFilterType);
                                        tableFilterNode.setCDataValue(tableFilterTwo);
                                    } else {
                                        tableFilterNode = tableNode.getChildByTagName("TableFilter");
                                        if (Objects.nonNull(tableFilterNode)) {
                                            tableNode.getChildren().remove(tableFilterNode);
                                        }
                                    }
                                }
                                if (!StringUtils.equalsIgnoreCase((CharSequence)tableMark, (CharSequence)orgTableKey)) {
                                    XmlDiffProcessor.replaceTableKey(diff, orgTableKey, tableMark);
                                }
                                if (!(extendTableFlag3 = collecTable.getBoolean(i, "ExtendTableFlag").booleanValue())) {
                                    XmlDiffProcessor.dealParameterCollection(ed_parameterCollection, tableNode, parentOID);
                                }
                            } else {
                                orderBy = collecTable.getString(i, "OrderBy");
                                if (StringUtils.isNotBlank((CharSequence)orderBy)) {
                                    tableNode.setAttribute("OrderBy", orderBy);
                                } else {
                                    attributes.remove("OrderBy");
                                }
                            }
                        }
                        if (Objects.nonNull(ed_indexCollection)) {
                            Long POID;
                            Long parentOID = collecTable.getLong(i, "OID");
                            boolean hasProcess = false;
                            int row = 0;
                            while (row < ed_indexCollection.size()) {
                                POID = ed_indexCollection.getLong(row, "POID");
                                if (parentOID.equals(POID)) {
                                    hasProcess = true;
                                    break;
                                }
                                ++row;
                            }
                            if (hasProcess) {
                                tableNode.deleteChildByTagName("IndexCollection");
                                TagNode indexCollectionNode = new TagNode("IndexCollection", null);
                                tableNode.addNode(indexCollectionNode);
                                int row2 = 0;
                                while (row2 < ed_indexCollection.size()) {
                                    POID = ed_indexCollection.getLong(row2, "POID");
                                    if (parentOID.equals(POID)) {
                                        String indexKey = ed_indexCollection.getString(row2, "IndexKey");
                                        String columns = ed_indexCollection.getString(row2, "Columns");
                                        Long isUnique = ed_indexCollection.getLong(row2, "IsUnique");
                                        TagNode index = new TagNode("Index", null);
                                        index.setAttribute("Key", indexKey);
                                        index.setAttribute("Columns", columns);
                                        index.setAttribute("IsUnique", isUnique == 1L ? "true" : "false");
                                        indexCollectionNode.addNode(index);
                                    }
                                    ++row2;
                                }
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    private static void dealChartDataSource(XmlTreeWithPath xmlTree, DataTable chartDataSource, DataTable seriesDtl, Diff diff) throws Throwable {
        String xmlTreeKey = "Chart@" + diff.getKey();
        TagNode chartNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
        chartNode.deleteChildByTagName("ChartDataSource");
        TagNode chartDataSourceNode = new TagNode("ChartDataSource", null);
        String bindingKey = chartDataSource.getString("BindingKey");
        chartDataSourceNode.setAttribute("BindingKey", bindingKey);
        String categoryDataKey = chartDataSource.getString("CategoryDataKey");
        TagNode categoryNode = new TagNode("Category", null);
        categoryNode.setAttribute("DataKey", categoryDataKey);
        chartDataSourceNode.addNode(categoryNode);
        int i = 0;
        while (i < seriesDtl.size()) {
            String seriesDataKey = seriesDtl.getString(i, "SeriesDataKey");
            String SplitDataKey = seriesDtl.getString(i, "SplitDataKey");
            String Title = seriesDtl.getString(i, "Title");
            TagNode seriesNode = new TagNode("Series", null);
            seriesNode.setAttribute("DataKey", seriesDataKey);
            seriesNode.setAttribute("SplitDataKey", SplitDataKey);
            seriesNode.setAttribute("Title", Title);
            chartDataSourceNode.addNode(seriesNode);
            ++i;
        }
        chartNode.addNode(chartDataSourceNode);
        XmlDiffProcessor.genXmlDiff(xmlTree, xmlTree.xmlTree.getRoot(), diff, true);
    }

    private static void dealMergedSpan(XmlTreeWithPath xmlTree, int mergedRowSpan, int mergedColumnSpan, Diff diff) throws Throwable {
        TagNode cellNode = xmlTree.xmlTree.getTagNode("GridCell@" + diff.getKey());
        TagNode rowNode = cellNode.getParent();
        cellNode.setAttribute(Property.MergedRowSpan.name, String.valueOf(mergedRowSpan));
        cellNode.setAttribute(Property.MergedColumnSpan.name, String.valueOf(mergedColumnSpan));
        List<AbstractNode> rows = rowNode.getParent().getChildrenByTagName("GridRow");
        int rowIndex = rows.indexOf(rowNode);
        int cellIndex = rowNode.getChildrenByTagName("GridCell").indexOf(cellNode);
        if (rowIndex + mergedRowSpan > rows.size()) {
            throw new Exception("\u64cd\u4f5c\u5931\u8d25\uff0c\u6b64\u5355\u5143\u683c\u540e\u5269\u4f59\u5408\u5e76\u884c\u6570\u4e0d\u8db3");
        }
        int i = rowIndex;
        while (i < rowIndex + mergedRowSpan) {
            TagNode row = (TagNode)rows.get(i);
            List<AbstractNode> cells = row.getChildrenByTagName("GridCell");
            if (cellIndex + mergedColumnSpan > cells.size()) {
                throw new Exception("\u64cd\u4f5c\u5931\u8d25\uff0c\u6b64\u5355\u5143\u683c\u540e\u5269\u4f59\u5408\u5e76\u5217\u6570\u4e0d\u8db3");
            }
            int j = cellIndex;
            while (j < cellIndex + mergedColumnSpan) {
                TagNode cell = (TagNode)cells.get(j);
                if (i == rowIndex && j == cellIndex) {
                    cell.setAttribute("IsMerged", "true");
                    cell.setAttribute(Property.MergedRowSpan.name, String.valueOf(mergedRowSpan));
                    cell.setAttribute(Property.MergedColumnSpan.name, String.valueOf(mergedColumnSpan));
                } else {
                    cell.setAttribute("IsMerged", "true");
                    cell.setAttribute(Property.MergedRowSpan.name, String.valueOf(i - rowIndex));
                    cell.setAttribute(Property.MergedColumnSpan.name, String.valueOf(j - cellIndex));
                }
                ++j;
            }
            ++i;
        }
        XmlDiffProcessor.genXmlDiff(xmlTree, xmlTree.xmlTree.getRoot(), diff, true);
    }

    public static boolean checkPublicConfigure(Diff diff, String fieldKey) {
        XmlTree xmlTree = diff.getXmlTree().xmlTree;
        TagNode bodyNode = xmlTree.getRoot().getOrCreateChildByTagName("Body");
        List<TagNode> nodeList = bodyNode.findNodesByTagName("GridRow");
        for (TagNode tagNode : nodeList) {
            String groupKey = tagNode.getAttributes().get("GroupKey");
            if (!StringUtils.isNotEmpty((CharSequence)groupKey) || !groupKey.equalsIgnoreCase(fieldKey)) continue;
            return false;
        }
        return true;
    }

    private static int statisticsLength(TagNode columnCollection) {
        int length = 0;
        List<TagNode> nodesByTagName = columnCollection.findNodesByTagName("GridColumn");
        for (TagNode node : nodesByTagName) {
            TagNode firstTagNodeByTagName = node.findFirstTagNodeByTagName("GridColumnCollection");
            if (firstTagNodeByTagName != null) {
                int statisticsLength = XmlDiffProcessor.statisticsLength(firstTagNodeByTagName);
                length += statisticsLength;
                continue;
            }
            ++length;
        }
        return length;
    }

    private static int statisticsRowIndex(TagNode columnCollection, String sideKey, TagNode sourceNode) {
        while (sourceNode.findFirstTagNodeByTagName("GridColumnCollection") != null) {
            List<TagNode> nodesByTagName = sourceNode.findFirstTagNodeByTagName("GridColumnCollection").findNodesByTagName("GridColumn");
            sourceNode = nodesByTagName.get(nodesByTagName.size() - 1);
            sideKey = sourceNode.getAttributes().get("Key");
        }
        List<TagNode> column = columnCollection.findNodesByTagName("GridColumn");
        int totalIndex = 0;
        for (TagNode tagNode : column) {
            if (tagNode.getAttributes().get("Key").equalsIgnoreCase(sideKey)) {
                return ++totalIndex;
            }
            TagNode gridColumnCollection = tagNode.findFirstTagNodeByTagName("GridColumnCollection");
            if (gridColumnCollection != null) {
                totalIndex = (Integer)XmlDiffProcessor.sonColumn(gridColumnCollection, sideKey).get(0) + totalIndex;
                boolean flag = (Boolean)XmlDiffProcessor.sonColumn(gridColumnCollection, sideKey).get(1);
                if (!flag) continue;
                return totalIndex;
            }
            ++totalIndex;
        }
        return 0;
    }

    private static List<Object> sonColumn(TagNode column, String sideKey) {
        List<TagNode> children = column.findNodesByTagName("GridColumn");
        ArrayList<Object> res = new ArrayList<Object>();
        int index = 0;
        for (TagNode child : children) {
            TagNode gridColumnCollection = child.findFirstTagNodeByTagName("GridColumnCollection");
            if (child.getAttributes().get("Key").equalsIgnoreCase(sideKey)) {
                res.add(0, ++index);
                res.add(1, true);
                return res;
            }
            if (gridColumnCollection != null) {
                List<Object> list = XmlDiffProcessor.sonColumn(gridColumnCollection, sideKey);
                index = (Integer)list.get(0) + index;
                boolean flag = (Boolean)list.get(1);
                if (!flag) continue;
                res.add(0, index);
                res.add(1, true);
                return res;
            }
            ++index;
        }
        res.add(0, index);
        res.add(1, false);
        return res;
    }

    public static String getDatatypeContainerMultiDict(int controlType, boolean isMultiDict) {
        if (204 == controlType || 209 == controlType || 246 == controlType || 202 == controlType || 215 == controlType || 214 == controlType || 218 == controlType || 234 == controlType || 211 == controlType || 213 == controlType || 208 == controlType || 237 == controlType || 206 == controlType && isMultiDict || 285 == controlType || 308 == controlType || 307 == controlType || 282 == controlType || 310 == controlType || 270 == controlType || 278 == controlType || 287 == controlType) {
            return "Varchar";
        }
        if (254 == controlType || 241 == controlType || 206 == controlType) {
            return "Long";
        }
        if (210 == controlType || 272 == controlType || 312 == controlType || 277 == controlType || 281 == controlType) {
            return "Numeric";
        }
        if (205 == controlType || 313 == controlType) {
            return "DateTime";
        }
        if (201 == controlType || 284 == controlType || 275 == controlType) {
            return "Integer";
        }
        if (225 == controlType) {
            return "Text";
        }
        return null;
    }

    private static String getDatatype(int controlType) {
        if (204 == controlType || 209 == controlType || 246 == controlType || 202 == controlType || 215 == controlType || 214 == controlType || 218 == controlType || 234 == controlType || 211 == controlType || 213 == controlType || 208 == controlType || 237 == controlType || 285 == controlType || 308 == controlType || 307 == controlType || 282 == controlType || 310 == controlType || 270 == controlType || 278 == controlType || 287 == controlType) {
            return "Varchar";
        }
        if (254 == controlType || 241 == controlType || 206 == controlType) {
            return "Long";
        }
        if (210 == controlType || 272 == controlType || 312 == controlType || 277 == controlType || 281 == controlType) {
            return "Numeric";
        }
        if (205 == controlType || 313 == controlType) {
            return "DateTime";
        }
        if (201 == controlType || 284 == controlType || 275 == controlType) {
            return "Integer";
        }
        if (225 == controlType) {
            return "Text";
        }
        return null;
    }

    private static LinkedList<String> sortMetaGridColumns(MetaGridColumnCollection columnCollection) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (MetaGridColumn gridColumn : columnCollection) {
            if (!gridColumn.getSideKey().isEmpty()) continue;
            linkedList.add(gridColumn.getMetaKey());
        }
        for (MetaGridColumn gridColumn : columnCollection) {
            if (gridColumn.getSideKey().isEmpty()) continue;
            if (gridColumn.getInsertAfter().booleanValue()) {
                linkedList.add(linkedList.indexOf(gridColumn.getSideKey()) + 1, gridColumn.getMetaKey());
                continue;
            }
            linkedList.add(linkedList.indexOf(gridColumn.getSideKey()), gridColumn.getMetaKey());
        }
        return linkedList;
    }

    private static LinkedList<String> sortMetaGridRow(MetaGridRow meta) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (MetaGridCell gridCell : meta) {
            if (!gridCell.getSideKey().isEmpty()) continue;
            linkedList.add(gridCell.getKey());
        }
        for (MetaGridCell gridCell : meta) {
            if (gridCell.getSideKey().isEmpty()) continue;
            if (gridCell.getInsertAfter().booleanValue()) {
                linkedList.add(linkedList.indexOf(gridCell.getSideKey()) + 1, gridCell.getKey());
                continue;
            }
            linkedList.add(linkedList.indexOf(gridCell.getSideKey()), gridCell.getKey());
        }
        return linkedList;
    }

    private static void mergeColumnDragDiff(Diff diff) throws Throwable {
        String newXmlFragment;
        IDLookup idLookup;
        MetaGrid metaGrid;
        LinkedList<String> strings1;
        int oldColumnIndex;
        String columnKey = diff.getKey();
        int newColumnIndex = diff.getNewColumnIndex();
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        String orgXml = xmlTree.xmlTree.getOrgXml();
        MetaForm metaForm = diff.getMetaForm();
        if (diff.isMultyMove) {
            metaForm = MetaFactory.getGlobalInstance().getMetaForm(diff.formKey);
        }
        if (newColumnIndex == (oldColumnIndex = (strings1 = XmlDiffProcessor.sortMetaGridColumns((metaGrid = (idLookup = IDLookup.getIDLookup(metaForm)).getMetaGridByGridKey(idLookup.getGridKeyByFieldKey(columnKey))).getColumnCollection())).indexOf(columnKey))) {
            return;
        }
        String startColumnKey = ((MetaGridColumn)metaGrid.getColumnCollection().get(Math.min(oldColumnIndex, newColumnIndex))).getKey();
        String endColumnKey = ((MetaGridColumn)metaGrid.getColumnCollection().get(Math.max(oldColumnIndex, newColumnIndex))).getKey();
        TagNode startNode = xmlTree.xmlTree.getTagNode("GridColumn@" + startColumnKey);
        TagNode endNode = xmlTree.xmlTree.getTagNode("GridColumn@" + endColumnKey);
        if (!diff.getMetaForm().getExtend().isEmpty()) {
            boolean sideKey;
            String xmlTreeKey = "Grid@" + metaGrid.getKey();
            XmlTreeWithPath vestXmlTree = diff.getVestXmlTree();
            TagNode tagNode3 = vestXmlTree.xmlTree.getTagNode("GridColumn@" + columnKey);
            ArrayList<String> strings = new ArrayList<String>();
            strings.add(tagNode3.getPrimaryKey());
            TagNode fieldNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
            TagNode fieldNode1 = xmlTree.xmlTree.getTagNode(xmlTreeKey);
            QuoteGridFiledOperUtil.getParent(tagNode3, fieldNode1, strings);
            int i = strings.size() - 2;
            while (i >= 0) {
                fieldNode1 = ((String)strings.get(i)).contains("@") ? fieldNode1.getOrCreateChildByKey(((String)strings.get(i)).split("@")[0], ((String)strings.get(i)).split("@")[1]) : fieldNode1.getOrCreateChildByKey((String)strings.get(i), "");
                --i;
            }
            fieldNode1.setAttribute("InsertAfter", String.valueOf(newColumnIndex > oldColumnIndex));
            startColumnKey = strings1.get(newColumnIndex);
            fieldNode1.setAttribute("SideKey", startColumnKey);
            TagNode tagNode4 = xmlTree.xmlTree.getTagNode("GridColumn@" + startColumnKey);
            if (tagNode4 != null && (sideKey = tagNode4.getAttributes().remove("SideKey", columnKey))) {
                tagNode4.getAttributes().remove("InsertAfter");
            }
            TagNode tagNode1 = vestXmlTree.xmlTree.getTagNode(xmlTreeKey).getOrCreateChildByTagName("GridColumnCollection").getChildByTagNameAndKey("GridColumn", columnKey);
            int i2 = -1;
            if (tagNode1 != null) {
                i2 = vestXmlTree.xmlTree.getTagNode(xmlTreeKey).getOrCreateChildByTagName("GridColumnCollection").getTagNodeChildrenByTagName("GridColumn").indexOf(tagNode1);
            }
            TagNode gridRowCollectionTagNode = fieldNode.getOrCreateChildByTagName("GridRowCollection");
            List<TagNode> tagNodeChildrenByTagName = vestXmlTree.xmlTree.getTagNode(xmlTreeKey).getOrCreateChildByTagName("GridRowCollection").getTagNodeChildrenByTagName("GridRow");
            for (TagNode tagNode : tagNodeChildrenByTagName) {
                boolean sideKey2;
                String rowKey = tagNode.getAttributes().get("Key");
                TagNode rowNode = gridRowCollectionTagNode.getOrCreateChildByKey(tagNode.getTagName(), rowKey);
                if (i2 <= 0) continue;
                TagNode tagNode2 = tagNode.getTagNodeChildrenByTagName("GridCell").get(i2);
                String cellKey = tagNode2.getAttributes().get("Key");
                TagNode orCreateChildByKey = rowNode.getOrCreateChildByKey(tagNode2.getTagName(), cellKey);
                orCreateChildByKey.setAttribute("InsertAfter", String.valueOf(newColumnIndex > oldColumnIndex));
                LinkedList<String> strings2 = XmlDiffProcessor.sortMetaGridRow(metaGrid.findRowByKey(rowKey));
                String cellNewKey = strings2.get(newColumnIndex);
                orCreateChildByKey.setAttribute("SideKey", cellNewKey);
                TagNode tagNode5 = xmlTree.xmlTree.getTagNode("GridCell@" + cellNewKey);
                if (tagNode5 == null || !(sideKey2 = tagNode5.getAttributes().remove("SideKey", cellKey))) continue;
                tagNode5.getAttributes().remove("InsertAfter");
            }
            XmlDiffProcessor.genXmlDiff(xmlTree, fieldNode, diff, true);
            return;
        }
        if (Objects.isNull(endNode) && Objects.isNull(startNode)) {
            throw new Exception("\u5d4c\u5165\u8868\u683c\u4e2d\u5217\u62d6\u52a8\u8bf7\u5230\u8bbe\u8ba1\u5668\u9875\u9762\u8fdb\u884c\u64cd\u4f5c");
        }
        Element element = startNode.getElement();
        int startLine = xmlTree.xmlTree.getLineByIndex(element.getBgIndex());
        String oldXmlFragment = orgXml.substring(xmlTree.xmlTree.getLineStartPos(startLine), endNode.getLast().getElement().getEndIndex() + 1);
        oldXmlFragment = oldXmlFragment.replaceAll("\r\n", "\n").replaceAll("\n", "\r\n");
        if (newColumnIndex < oldColumnIndex) {
            String lastNode = orgXml.substring(xmlTree.xmlTree.getLineStartPos(xmlTree.xmlTree.getLineByIndex(endNode.getElement().getBgIndex())), endNode.getLast().getElement().getEndIndex() + 1);
            newXmlFragment = String.valueOf(lastNode) + "\r\n" + oldXmlFragment.substring(0, oldXmlFragment.length() - lastNode.length() - 2);
        } else {
            String firstNode = orgXml.substring(xmlTree.xmlTree.getLineStartPos(xmlTree.xmlTree.getLineByIndex(element.getBgIndex())), element.getEndIndex() + 1);
            newXmlFragment = String.valueOf(oldXmlFragment.substring(firstNode.length() + 2)) + "\r\n" + firstNode;
        }
        diff.setXmlDiff(xmlTree, startLine, oldXmlFragment, newXmlFragment);
        TagNode gridNode = xmlTree.xmlTree.getTagNode("Grid@" + metaGrid.getKey());
        TagNode rowColl = gridNode.getOrCreateChildByTagName("GridRowCollection");
        List<AbstractNode> rowcollection = rowColl.getChildren();
        String oldXmlFragment2 = orgXml.substring(rowColl.getElement().getBgIndex(), rowColl.getLast().getElement().getEndIndex() + 1);
        int startLine2 = xmlTree.xmlTree.getLineByIndex(rowColl.getElement().getBgIndex());
        String newXmlFragment2 = oldXmlFragment2;
        for (AbstractNode node : rowcollection) {
            String newXmlFragmentTMP;
            if (!(node instanceof TagNode) || !"GridRow".equalsIgnoreCase(((TagNode)node).getTagName())) continue;
            TagNode startNode1 = (TagNode)((TagNode)node).getChildren().get(oldColumnIndex * 2 + 1);
            TagNode endNode1 = (TagNode)((TagNode)node).getChildren().get(newColumnIndex * 2 + 1);
            String oldxml = newColumnIndex < oldColumnIndex ? orgXml.substring(xmlTree.xmlTree.getLineStartPos(xmlTree.xmlTree.getLineByIndex(endNode1.getElement().getBgIndex())), startNode1.getLast().getElement().getEndIndex() + 1) : orgXml.substring(xmlTree.xmlTree.getLineStartPos(xmlTree.xmlTree.getLineByIndex(startNode1.getElement().getBgIndex())), endNode1.getLast().getElement().getEndIndex() + 1);
            if (newColumnIndex < oldColumnIndex) {
                String lastNode = orgXml.substring(xmlTree.xmlTree.getLineStartPos(xmlTree.xmlTree.getLineByIndex(startNode1.getElement().getBgIndex())), startNode1.getLast().getElement().getEndIndex() + 1);
                newXmlFragmentTMP = String.valueOf(lastNode) + "\r\n" + oldxml.substring(0, oldxml.length() - lastNode.length());
            } else {
                String firstNode = orgXml.substring(xmlTree.xmlTree.getLineStartPos(xmlTree.xmlTree.getLineByIndex(startNode1.getElement().getBgIndex())), startNode1.getLast().getElement().getEndIndex() + 1);
                newXmlFragmentTMP = String.valueOf(oldxml.substring(firstNode.length() + 2)) + "\r\n" + firstNode;
            }
            newXmlFragment2 = newXmlFragment2.replace(oldxml, newXmlFragmentTMP);
            newXmlFragment2 = newXmlFragment2.replaceAll("((\r\n)|\n)[\\s\t ]*(\\1)+", "$1");
        }
        diff.setXmlDiff2(xmlTree, startLine2, oldXmlFragment2, newXmlFragment2);
    }

    private static String getMainTableKey(DataTable dataTable) {
        int j = 0;
        while (j < dataTable.size()) {
            Object isPrimaryTable = dataTable.getObject(j, "IsPrimaryTable");
            if (TypeConvertor.toBoolean((Object)isPrimaryTable).booleanValue() || Objects.equals(isPrimaryTable, "1")) {
                return dataTable.getString(j, "TableMark");
            }
            ++j;
        }
        return "";
    }

    public static String getXmlTreeKey(Diff diff, String controlType, String primaryKey) throws Throwable {
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        MetaObjectType metaObjectType = diff.getMetaObjectType();
        if (metaObjectType == MetaObjectType.field || metaObjectType == MetaObjectType.panel || metaObjectType == MetaObjectType.subDetail || metaObjectType == MetaObjectType.grid || metaObjectType == MetaObjectType.D_DictView || metaObjectType == MetaObjectType.listView) {
            if (diff.getControlType() == 209) {
                if (StringUtils.equalsIgnoreCase((CharSequence)diff.properties.get((int)0).property.name, (CharSequence)"Key")) {
                    String orgVal = diff.properties.get((int)0).orgValue;
                    return "Label@" + orgVal;
                }
                return String.valueOf(ControlType.toString((Integer)diff.getControlType())) + "@" + diff.getKey();
            }
            String propertyName = diff.properties.get((int)0).property.name;
            if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"Key")) {
                String orgVal = diff.properties.get((int)0).orgValue;
                String propertyKey = String.valueOf(ControlType.toString((Integer)diff.getControlType())) + "@" + orgVal;
                TagNode componentNode = xmlTree.xmlTree.getTagNode(propertyKey);
                if (Objects.isNull(componentNode)) {
                    throw new Throwable("warning: \u4e0d\u80fd\u4fee\u6539!");
                }
                String buddyKey = componentNode.getAttributes().get("BuddyKey");
                if (StringUtils.isBlank((CharSequence)buddyKey)) {
                    return propertyKey;
                }
                return "Label@" + buddyKey + "," + propertyKey;
            }
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)propertyName, (CharSequence[])new CharSequence[]{"BuddyKey", "BuddyCaption", "BuddyX", "BuddyY"})) {
                String propertyKey = String.valueOf(ControlType.toString((Integer)diff.getControlType())) + "@" + diff.getKey();
                TagNode componentNode = xmlTree.xmlTree.getTagNode(propertyKey);
                if (Objects.isNull(componentNode)) {
                    throw new Throwable("warning: \u4e0d\u80fd\u4fee\u6539!");
                }
                String buddyKey = componentNode.getAttributes().get("BuddyKey");
                if (!StringUtils.equalsAnyIgnoreCase((CharSequence)propertyName, (CharSequence[])new CharSequence[]{"BuddyKey"})) {
                    return "Label@" + buddyKey;
                }
                return "Label@" + buddyKey + "," + propertyKey;
            }
            return String.valueOf(ControlType.toString((Integer)diff.getControlType())) + "@" + diff.getKey();
        }
        if (metaObjectType == MetaObjectType.gridField && CollectionUtils.isNotEmpty(diff.properties) || metaObjectType == MetaObjectType.GridCellType) {
            String propertyName = diff.properties.get((int)0).property.name;
            if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"Key")) {
                String orgVal = diff.properties.get((int)0).orgValue;
                return "GridCell@" + orgVal + "," + "GridColumn" + "@" + orgVal;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"Visible")) {
                return "GridColumn@" + diff.getKey();
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"Caption")) {
                return "GridCell@" + diff.getKey() + "," + "GridColumn" + "@" + diff.getKey();
            }
            return "GridCell@" + diff.getKey();
        }
        if (metaObjectType == MetaObjectType.listViewField) {
            String propertyName = diff.properties.get((int)0).property.name;
            if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"Key")) {
                String orgVal = diff.properties.get((int)0).orgValue;
                return "ListViewColumn@" + orgVal;
            }
            return "ListViewColumn@" + diff.getKey();
        }
        if (metaObjectType == MetaObjectType.EditViewColumn) {
            String propertyName = diff.properties.get((int)0).property.name;
            if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"Key")) {
                String orgVal = diff.properties.get((int)0).orgValue;
                return "EditViewColumn@" + orgVal;
            }
            return "EditViewColumn@" + diff.getKey();
        }
        if (metaObjectType == MetaObjectType.EditViewChildGridLayout || metaObjectType == MetaObjectType.EditViewRootGridLayout) {
            return "GridLayout@" + diff.getKey();
        }
        if (metaObjectType == MetaObjectType.EditViewChildLinearLayout || metaObjectType == MetaObjectType.EditViewRootLinearLayout) {
            return "LinearLayout@" + diff.getKey();
        }
        if (metaObjectType == MetaObjectType.EditViewChildFlexFlowLayout) {
            return "FlexFlowLayout@" + diff.getKey();
        }
        if (metaObjectType == MetaObjectType.EditViewChildColumnLayout) {
            return "ColumnLayout@" + diff.getKey();
        }
        if (metaObjectType == MetaObjectType.EditViewChildSplitLayout) {
            return "SplitLayout@" + diff.getKey();
        }
        if (metaObjectType == MetaObjectType.EditViewChildTabLayout) {
            return "TabLayout@" + diff.getKey();
        }
        if (metaObjectType == MetaObjectType.EditViewChildFlowLayout) {
            return "FlowLayout@" + diff.getKey();
        }
        if (metaObjectType == MetaObjectType.EditViewChildFlexGridLayout) {
            return "FlexGridLayout@" + diff.getKey();
        }
        if (metaObjectType == MetaObjectType.operationCollection || metaObjectType == MetaObjectType.operation) {
            String propertyName = diff.properties.get((int)0).property.name;
            if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"Key")) {
                return "Operation@" + primaryKey + "," + "OperationCollection" + "@" + primaryKey;
            }
            return "Operation@" + diff.getKey() + "," + "OperationCollection" + "@" + diff.getKey();
        }
        if (metaObjectType == MetaObjectType.toolbar) {
            String propertyName = diff.properties.get((int)0).property.name;
            if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"Caption")) {
                return "ToolBar@" + diff.getKey();
            }
            String orgVal = diff.properties.get((int)0).orgValue;
            return "ToolBar@" + orgVal;
        }
        if (metaObjectType == MetaObjectType.ToolBar) {
            return "ToolBar@";
        }
        if (MetaObjectType.GridHeadColumn.equals(metaObjectType)) {
            String propertyName = diff.properties.get((int)0).property.name;
            if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"Key")) {
                return "GridColumn@" + diff.properties.get((int)0).orgValue;
            }
            return "GridColumn@" + diff.getKey();
        }
        if (MetaObjectType.GridRow.equals(metaObjectType)) {
            String propertyName = diff.properties.get((int)0).property.name;
            if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"Key")) {
                String orgVal = diff.properties.get((int)0).orgValue;
                return MetaObjectType.GridRow + "@" + orgVal;
            }
            return MetaObjectType.GridRow + "@" + diff.getKey();
        }
        return String.valueOf(controlType) + "@" + primaryKey;
    }

    private static void dealFieldTable(DataTable fieldTable, Diff diff, TagNode parentNode, long parentOID, MetaDataObject curDataObject) throws Throwable {
        Collection<AbstractNode> nodeList = diff.getXmlTree().xmlTree.getMapNodes().values();
        String tableKey = parentNode.getAttributes().get("Key");
        HashSet<String> columnKeySet = new HashSet<String>();
        String sourceType = parentNode.getAttributes().get("SourceType");
        parentNode.deleteChildByTagName("Column");
        List<AbstractNode> children = parentNode.getChildren();
        children.clear();
        fieldTable.setShowDeleted(true);
        boolean isReMigraiton = false;
        TagNode root = diff.getXmlTree().xmlTree.getRoot();
        if (diff.getDataObject() != null && StringUtils.isBlank((CharSequence)diff.getDataObject().getExtend()) && StringUtils.equals((CharSequence)root.getAttributes().get("SecondaryType"), (CharSequence)"Migration") && StringUtils.equals((CharSequence)root.getAttributes().get("MigrationUpdateStrategy"), (CharSequence)"KeysTableFocusChange")) {
            isReMigraiton = true;
        }
        ArrayList<String> notMigraitonSysFields = new ArrayList<String>();
        int i = 0;
        while (i < fieldTable.size()) {
            block43: {
                block44: {
                    int extendColumnFlag;
                    if (!Objects.equals(parentOID, fieldTable.getLong(i, "POID")) || (extendColumnFlag = fieldTable.getInt(i, "ExtendColumnFlag").intValue()) > 0 || fieldTable.getState(i) == 3) break block43;
                    String key = fieldTable.getString(i, "ColumnKey");
                    if (!StringUtils.equalsAny((CharSequence)key, (CharSequence[])new CharSequence[]{"POID", "SOID", "DVERID", "ModifyTime", "CreateTime"})) break block44;
                    notMigraitonSysFields.add(key);
                    if (isReMigraiton) break block43;
                }
                String orgColKey = (String)fieldTable.getOriginalObject(i, "ColumnKey");
                String columnKey = fieldTable.getString(i, "ColumnKey").trim();
                if (!columnKeySet.contains(columnKey)) {
                    boolean isDictCol = false;
                    if (!StringUtils.equalsIgnoreCase((CharSequence)orgColKey, (CharSequence)columnKey)) {
                        if (!StringUtils.equalsIgnoreCase((CharSequence)diff.getReserveOne(), (CharSequence)"DataObject")) {
                            XmlDiffProcessor.replaceColumnKey(diff, orgColKey, columnKey);
                        }
                        String columnName = fieldTable.getString(i, "ColumnName").replaceAll("\r", "");
                        isDictCol = XmlDiffProcessor.changeDictBinding(diff, fieldTable, orgColKey, columnKey, columnName);
                    }
                    TagNode columnNode = new TagNode("Column", null);
                    children.add(columnNode);
                    columnKeySet.add(columnKey);
                    String needRightsType = fieldTable.getString(i, "NeedRights");
                    if (StringUtils.isNotBlank((CharSequence)needRightsType)) {
                        int needRights = Integer.parseInt(needRightsType);
                        columnNode.setAttribute("NeedRights", ColumnRightsType.toString((Integer)needRights));
                        if (1 == needRights || "Custom".equals(sourceType)) {
                            boolean ignoreRightsFlag = nodeList.stream().anyMatch(abstractNode -> {
                                if (!(abstractNode instanceof TagNode)) {
                                    return false;
                                }
                                TagNode tagNode = (TagNode)abstractNode;
                                TagNode dataBindingNode = tagNode.getChildByTagName("DataBinding");
                                if (Objects.isNull(dataBindingNode)) {
                                    return false;
                                }
                                Map<String, String> attributes = dataBindingNode.getAttributes();
                                if (!StringUtils.equalsIgnoreCase((CharSequence)attributes.get("ColumnKey"), (CharSequence)columnKey)) {
                                    return false;
                                }
                                String ignoreRights = attributes.get(Property.IgnoreRights.name);
                                return StringUtils.equalsIgnoreCase((CharSequence)ignoreRights, (CharSequence)"true");
                            });
                            if (ignoreRightsFlag) {
                                throw new Throwable("\u5df2\u5728\u63a7\u4ef6\u4e2d\u8bbe\u7f6e\u5ffd\u7565\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u4e3a\u68c0\u67e5\u6743\u9650\uff01\u5df2\u64a4\u9500");
                            }
                            columnNode.setAttribute("ItemKey", fieldTable.getString(i, "ItemKey"));
                        }
                    }
                    if (isDictCol) {
                        String dictKey = columnKey.substring(0, columnKey.length() - 2);
                        columnNode.setAttribute("CodeColumnKey", String.valueOf(dictKey) + "Code");
                    } else {
                        String codeColumnKey = fieldTable.getString(i, "CodeColumnKey");
                        if (StringUtils.isBlank((CharSequence)codeColumnKey)) {
                            columnNode.setAttribute("CodeColumnKey", "");
                        } else {
                            columnNode.setAttribute("CodeColumnKey", codeColumnKey);
                        }
                    }
                    columnNode.setAttribute("Key", columnKey);
                    columnNode.setAttribute("Caption", fieldTable.getString(i, "ColumnName").replaceAll("\r", ""));
                    columnNode.setAttribute("DBColumnName", fieldTable.getString(i, "DBColumnName"));
                    columnNode.setAttribute("RefItemKeyCol", fieldTable.getString(i, "RefItemKeyCol"));
                    columnNode.setAttribute("PrimaryKey", fieldTable.getBoolean(i, "IsPrimaryKey").toString(), "false");
                    columnNode.setAttribute("RefCol", fieldTable.getString(i, "RefCol"));
                    String dataElementKey = fieldTable.getString(i, "DataElementKey");
                    if (StringUtils.isEmpty((CharSequence)dataElementKey)) {
                        String length;
                        String scale;
                        columnNode.setAttribute("DataType", DataType.toString((Integer)fieldTable.getInt(i, "ColumnType")));
                        String precision = fieldTable.getString(i, "Precision");
                        if (StringUtils.isNotBlank((CharSequence)precision) && !StringUtils.equals((CharSequence)precision, (CharSequence)"0")) {
                            columnNode.setAttribute("Precision", precision);
                        }
                        if (StringUtils.isNotBlank((CharSequence)(scale = fieldTable.getString(i, "Scale"))) && !StringUtils.equals((CharSequence)scale, (CharSequence)"0")) {
                            columnNode.setAttribute("Scale", scale);
                        }
                        if (StringUtils.isNotBlank((CharSequence)(length = fieldTable.getString(i, "Length"))) && !StringUtils.equals((CharSequence)length, (CharSequence)"0")) {
                            columnNode.setAttribute("Length", length);
                        }
                    }
                    columnNode.setAttribute("DataElementKey", dataElementKey);
                    String description = fieldTable.getString(i, "Description");
                    if (StringUtils.isNotBlank((CharSequence)description)) {
                        columnNode.setAttribute("Description", description);
                    }
                    columnNode.setAttribute("IgnoreQuery", fieldTable.getInt(i, "IgnoreQuery") == 0 ? "false" : "true");
                    if ("false".equalsIgnoreCase(columnNode.getAttributes().get("IgnoreQuery")) || !StringUtils.isNotEmpty((CharSequence)columnNode.getAttributes().get("IgnoreQuery"))) {
                        columnNode.getAttributes().remove("IgnoreQuery");
                    }
                    columnNode.setAttribute("Cache", fieldTable.getInt(i, "Cache") == 0 ? "false" : "true");
                    if ("false".equalsIgnoreCase(columnNode.getAttributes().get("Cache")) || !StringUtils.isNotEmpty((CharSequence)columnNode.getAttributes().get("Cache"))) {
                        columnNode.getAttributes().remove("Cache");
                    }
                    if (1 != fieldTable.getState(i)) {
                        columnNode.setAttribute("Persist", fieldTable.getInt(i, "Persist") == 0 ? "false" : "true");
                    }
                    columnNode.setAttribute("IsPrimary", fieldTable.getInt(i, "IsPrimary") == 0 ? "false" : "true");
                    columnNode.setAttribute("Expand", fieldTable.getInt(i, "Expand") == 0 ? "false" : "true");
                    columnNode.setAttribute("AccessControl", fieldTable.getInt(i, "AccessControl") == 0 ? "false" : "true");
                    columnNode.setAttribute("IgnoreSave", fieldTable.getInt(i, "IgnoreSave") == 0 ? "false" : "true");
                    columnNode.setAttribute("Hidden", fieldTable.getInt(i, "Hidden") == 0 ? "false" : "true");
                    String sortType = fieldTable.getString(i, "SortType");
                    if (StringUtils.isBlank((CharSequence)sortType)) {
                        columnNode.setAttribute("SortType", "");
                    } else {
                        columnNode.setAttribute("SortType", SortType.toString((Integer)Integer.parseInt(sortType)));
                    }
                    String periodGranularity = fieldTable.getString(i, "PeriodGranularity");
                    if (StringUtils.isBlank((CharSequence)periodGranularity)) {
                        columnNode.setAttribute("PeriodGranularity", "");
                    } else {
                        columnNode.setAttribute("PeriodGranularity", DMPeriodGranularityType.toString((Integer)Integer.parseInt(periodGranularity)));
                    }
                    String supportI18n = fieldTable.getString(i, "SupportI18n");
                    supportI18n = StringUtils.isBlank((CharSequence)supportI18n) ? "false" : supportI18n;
                    columnNode.setAttribute("SupportI18n", supportI18n);
                    String splitType = fieldTable.getString(i, "SplitType");
                    if (StringUtils.isBlank((CharSequence)splitType)) {
                        columnNode.setAttribute("SplitType", "");
                    } else {
                        columnNode.setAttribute("SplitType", DataSplitType.toString((Integer)Integer.parseInt(splitType)));
                    }
                    String groupType = fieldTable.getString(i, "GroupType");
                    if (StringUtils.isBlank((CharSequence)groupType)) {
                        columnNode.setAttribute("GroupType", "");
                    } else if (!StringUtils.equals((CharSequence)groupType, (CharSequence)"-1")) {
                        columnNode.setAttribute("GroupType", groupType);
                    }
                    MetaForm metaForm = diff.getMetaForm();
                    MetaTable table = Objects.isNull(metaForm) ? curDataObject.getTable(tableKey) : metaForm.getDataSource().getDataObject().getTable(tableKey);
                    if (table != null) {
                        MetaColumn metaColumn = (MetaColumn)table.get(orgColKey);
                        String defaultValue = null;
                        if (metaColumn != null) {
                            defaultValue = metaColumn.getDefaultValue();
                        }
                        if (StringUtils.isBlank(defaultValue)) {
                            columnNode.setAttribute("DefaultValue", fieldTable.getString(i, "DefaultValue"));
                        } else {
                            columnNode.setAttributeNotRemove("DefaultValue", fieldTable.getString(i, "DefaultValue"));
                        }
                    } else {
                        columnNode.setAttribute("DefaultValue", fieldTable.getString(i, "DefaultValue"));
                    }
                }
            }
            ++i;
        }
        if (!isReMigraiton && diff.getDataObject() != null && StringUtils.isBlank((CharSequence)diff.getDataObject().getExtend())) {
            String notMigraitonSysField = ((Object)notMigraitonSysFields).toString();
            if (!StringUtils.contains((CharSequence)notMigraitonSysField, (CharSequence)"POID")) {
                TagNode column = new TagNode("Column", null);
                column.setAttribute("Key", "POID");
                column.setAttribute("Caption", "\u7236\u5bf9\u8c61\u6807\u8bc6");
                column.setAttribute("DataType", "Long");
                children.add(column);
            }
            if (!StringUtils.contains((CharSequence)notMigraitonSysField, (CharSequence)"SOID")) {
                TagNode column = new TagNode("Column", null);
                column.setAttribute("Key", "SOID");
                column.setAttribute("Caption", "\u4e3b\u5bf9\u8c61\u6807\u8bc6");
                column.setAttribute("DataType", "Long");
                children.add(column);
            }
            if (!StringUtils.contains((CharSequence)notMigraitonSysField, (CharSequence)"DVERID")) {
                TagNode column = new TagNode("Column", null);
                column.setAttribute("Key", "DVERID");
                column.setAttribute("Caption", "\u5bf9\u8c61\u660e\u7ec6\u7248\u672c");
                column.setAttribute("DataType", "Integer");
                children.add(column);
            }
            if (StringUtils.equals((CharSequence)root.getAttributes().get("SecondaryType"), (CharSequence)"Migration") && !StringUtils.contains((CharSequence)notMigraitonSysField, (CharSequence)"CreateTime")) {
                TagNode column = new TagNode("Column", null);
                column.setAttribute("Key", "CreateTime");
                column.setAttribute("Caption", "\u5236\u5355\u65e5\u671f");
                column.setAttribute("DataType", "DateTime");
                children.add(column);
            }
            if (StringUtils.equals((CharSequence)root.getAttributes().get("SecondaryType"), (CharSequence)"Migration") && !StringUtils.contains((CharSequence)notMigraitonSysField, (CharSequence)"ModifyTime")) {
                TagNode column = new TagNode("Column", null);
                column.setAttribute("Key", "ModifyTime");
                column.setAttribute("Caption", "\u4fee\u6539\u65f6\u95f4");
                column.setAttribute("DataType", "DateTime");
                children.add(column);
            }
        }
    }

    private static void dealPrimaryTable(String isPrimary, Diff diff, TagNode curNode, String dataType) {
        TagNode rootNode = diff.getXmlTree().xmlTree.getRoot();
        String tagName = rootNode.getTagName();
        String extend = rootNode.getAttributes().get("Extend");
        String formType = rootNode.getAttributes().get("FormType");
        Boolean isMigraiton = StringUtils.equals((CharSequence)rootNode.getAttributes().get("SecondaryType"), (CharSequence)"Migration");
        if (StringUtils.equals((CharSequence)tagName, (CharSequence)"DataObject") && StringUtils.isNotBlank((CharSequence)extend)) {
            return;
        }
        if (StringUtils.equals((CharSequence)tagName, (CharSequence)"Form") && Objects.isNull(diff.getDataObjectXmlTree()) && StringUtils.isNotBlank((CharSequence)extend)) {
            return;
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)isPrimary, (CharSequence[])new CharSequence[]{"1", "true"})) {
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)dataType, (CharSequence[])new CharSequence[]{"ChainDict", "Dict"})) {
                DICT_HEAD_TABLE_COLUMN_LIST.forEach(columnMap -> XmlDiffProcessor.addColumnNode(curNode, columnMap));
                curNode.getParent().getParent().getAttributes().put("PrimaryTableKey", curNode.getAttributes().get("Key"));
                return;
            }
            List<TagNode> columnNodeList = curNode.findNodesByTagName("Column");
            List existColumnKeyList = columnNodeList.stream().filter(tagNode -> {
                String columnKey = tagNode.getAttributes().get("Key");
                return ConstantUtil.PRIMARY_TABLE_FIELDS.contains(columnKey) || StringUtils.equalsIgnoreCase((CharSequence)columnKey, (CharSequence)"OID");
            }).map(tagNode -> tagNode.getAttributes().get("Key")).collect(Collectors.toList());
            if (!existColumnKeyList.contains("OID")) {
                return;
            }
            curNode.getParent().getParent().getAttributes().put("PrimaryTableKey", curNode.getAttributes().get("Key"));
            return;
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)dataType, (CharSequence[])new CharSequence[]{"ChainDict", "Dict"})) {
            return;
        }
        if (Objects.isNull(curNode)) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)diff.getReserveOne(), (CharSequence)"DataObject")) {
            MetaDataObject dataObject = diff.getDataObject();
            String dataObjectKey = dataObject.getKey();
        } else {
            MetaDataObject dataObject = diff.getMetaForm().getDataSource().getDataObject();
            String dataObjectKey = dataObject.getKey();
        }
    }

    private static void replaceTableKey(Diff diff, String orgTableKey, String tableKey) {
        TagNode dataObjectNode;
        if (StringUtils.equalsIgnoreCase((CharSequence)diff.getMetaObjectType().name, (CharSequence)"DataObject")) {
            dataObjectNode = diff.getXmlTree().xmlTree.getRoot();
        } else {
            TagNode dataNode = diff.getXmlTree().xmlTree.getRoot().getChildByTagName("DataSource");
            dataObjectNode = dataNode.findFirstTagNodeByTagName("DataObject");
        }
        String primaryTableKey = dataObjectNode.getAttributes().get("PrimaryTableKey");
        if (StringUtils.equalsIgnoreCase((CharSequence)primaryTableKey, (CharSequence)orgTableKey)) {
            dataObjectNode.setAttribute("PrimaryTableKey", tableKey);
        }
        List<TagNode> tableNodeList = dataObjectNode.findNodesByTagName("Table");
        for (TagNode tagNode : tableNodeList) {
            String indexPrefix;
            String parentTableKey = tagNode.getAttributes().get("ParentKey");
            if (StringUtils.equalsIgnoreCase((CharSequence)parentTableKey, (CharSequence)orgTableKey)) {
                tagNode.setAttribute("ParentKey", tableKey);
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)(indexPrefix = tagNode.getAttributes().get("IndexPrefix")), (CharSequence)orgTableKey)) continue;
            tagNode.setAttribute("IndexPrefix", tableKey);
        }
        if (Objects.isNull(diff.getMetaForm())) {
            return;
        }
        TagNode rootNode = diff.getXmlTree().xmlTree.getRoot();
        TagNode bodyNode = rootNode.getChildByTagName("Body");
        if (Objects.isNull(bodyNode)) {
            return;
        }
        List<AbstractNode> bodyChildNodeList = bodyNode.getChildren();
        if (CollectionUtils.isEmpty(bodyChildNodeList)) {
            return;
        }
        for (AbstractNode bodyChildNode : bodyChildNodeList) {
            Map<String, String> attributes;
            String tableAttrValue;
            if (!(bodyChildNode instanceof TagNode)) continue;
            TagNode tagNode = (TagNode)bodyChildNode;
            String tagName = tagNode.getTagName();
            if (!StringUtils.equalsAnyIgnoreCase((CharSequence)tagName, (CharSequence[])new CharSequence[]{"DataBinding", "Condition", "ConditionTarget", "GridRow", "ListView", "ColumnExpand"}) || !StringUtils.equalsIgnoreCase((CharSequence)(tableAttrValue = (attributes = tagNode.getAttributes()).get("TableKey")), (CharSequence)orgTableKey)) continue;
            tagNode.setAttribute("TableKey", tableKey);
        }
    }

    private static void dealParameterCollection(DataTable ed_parameterCollection, TagNode parentNode, Long parentOID) throws Throwable {
        if (Objects.isNull(parentNode) || Objects.isNull(parentOID)) {
            return;
        }
        List<TagNode> parameterCollection = parentNode.findNodesByTagName("ParameterCollection");
        TagNode parameterCollectionNode = CollectionUtils.isNotEmpty(parameterCollection) ? parameterCollection.get(0) : null;
        ed_parameterCollection.setShowDeleted(true);
        int i = 0;
        while (i < ed_parameterCollection.size()) {
            Long poid = ed_parameterCollection.getLong(i, "POID");
            if (Objects.equals(poid, parentOID)) {
                if (Objects.isNull(parameterCollectionNode)) {
                    parameterCollectionNode = new TagNode("ParameterCollection", null);
                    parentNode.addNode(parameterCollectionNode);
                } else {
                    parameterCollectionNode.getChildren().clear();
                }
            }
            ++i;
        }
        i = 0;
        while (i < ed_parameterCollection.size()) {
            Long rowPOID = ed_parameterCollection.getLong(i, "POID");
            if (Objects.equals(rowPOID, parentOID) && 3 != ed_parameterCollection.getState(i)) {
                TagNode parameterNode = new TagNode("Parameter", null);
                parameterCollectionNode.addNode(parameterNode);
                parameterNode.setAttribute("DataType", ed_parameterCollection.getString(i, "DataType"));
                parameterNode.setAttribute("Description", ed_parameterCollection.getString(i, "Description"));
                String sourceType = ed_parameterCollection.getString(i, "SourceType");
                String value = ed_parameterCollection.getString(i, "Value");
                if ("Const".equalsIgnoreCase(sourceType)) {
                    parameterNode.setAttribute("SourceType", sourceType);
                    parameterNode.setAttribute("Value", value);
                } else {
                    parameterNode.setAttribute("Formula", value);
                }
            }
            ++i;
        }
    }

    private static void replaceColumnKey(Diff diff, String orgColKey, String columnKey) {
        if (Objects.isNull(diff.getMetaForm())) {
            return;
        }
        XmlTree xmlTree = diff.getXmlTree().xmlTree;
        TagNode rootNode = xmlTree.getRoot();
        TagNode bodyNode = rootNode.getChildByTagName("Body");
        if (Objects.isNull(bodyNode)) {
            return;
        }
        List<AbstractNode> bodyChildNodeList = bodyNode.getChildren();
        if (CollectionUtils.isEmpty(bodyChildNodeList)) {
            return;
        }
        for (AbstractNode bodyChildNode : bodyChildNodeList) {
            Map<String, String> attributes;
            String columnAttrValue;
            if (!(bodyChildNode instanceof TagNode)) continue;
            TagNode tagNode = (TagNode)bodyChildNode;
            String tagName = tagNode.getTagName();
            if (!StringUtils.equalsAnyIgnoreCase((CharSequence)tagName, (CharSequence[])new CharSequence[]{"DataBinding", "Condition", "ConditionTarget", "GridCell", "ListViewColumn", "ColumnExpand"}) || !StringUtils.equalsIgnoreCase((CharSequence)(columnAttrValue = (attributes = tagNode.getAttributes()).get("ColumnKey")), (CharSequence)orgColKey)) continue;
            tagNode.setAttribute("ColumnKey", columnKey);
        }
    }

    private static Boolean changeDictBinding(Diff diff, DataTable fieldTable, String orgDictColKey, String dictColKey, String columnName) {
        BiFunction<List, String, TagNode> biFunction = (columnNodeList, expectedColumnKey) -> {
            Predicate<TagNode> predicate = columnNode -> {
                String columnKey = columnNode.getAttributes().get("Key");
                return StringUtils.equalsIgnoreCase((CharSequence)columnKey, (CharSequence)expectedColumnKey);
            };
            return columnNodeList.stream().filter(predicate).findFirst().orElse(null);
        };
        TagNode rootNode = diff.getXmlTree().xmlTree.getRoot();
        List<TagNode> columnNodeList2 = rootNode.findNodesByTagName("Column");
        String orgDictKey = XmlDiffProcessor.getDictKey(orgDictColKey);
        String orgDictCodeKey = String.valueOf(orgDictKey) + "Code";
        String dictKey = XmlDiffProcessor.getDictKey(dictColKey);
        String dictCodeKey = String.valueOf(dictKey) + "Code";
        TagNode dictCodeNode = biFunction.apply(columnNodeList2, orgDictCodeKey);
        if (Objects.nonNull(dictCodeNode)) {
            dictCodeNode.setAttribute("Key", dictCodeKey);
            dictCodeNode.setAttribute("Caption", columnName);
        }
        TagNode dictNode = biFunction.apply(columnNodeList2, dictColKey);
        if (Objects.nonNull(dictCodeNode) && Objects.nonNull(dictNode)) {
            dictNode.setAttribute("CodeColumnKey", dictCodeKey);
        }
        if (Objects.nonNull(dictCodeNode)) {
            return true;
        }
        boolean hasCodeColumn = false;
        int i = 0;
        while (i < fieldTable.size()) {
            String columnKey = fieldTable.getString(i, "ColumnKey").trim();
            if (StringUtils.equalsIgnoreCase((CharSequence)columnKey, (CharSequence)orgDictCodeKey)) {
                fieldTable.setString(i, "ColumnKey", dictCodeKey);
                hasCodeColumn = true;
            }
            ++i;
        }
        return hasCodeColumn;
    }

    private static String getDictKey(String key) {
        if (!StringUtils.endsWithIgnoreCase((CharSequence)key, (CharSequence)"id")) {
            return key;
        }
        return StringUtils.substring((String)key, (int)0, (int)(key.length() - 2));
    }

    private static void addColumnNode(TagNode tableNode, Map<String, String> columnMap) {
        String columnKey = columnMap.get("Key");
        String primaryKey = "Column@" + columnKey;
        Predicate<AbstractNode> predicate = childNode -> {
            if (!(childNode instanceof TagNode)) {
                return false;
            }
            TagNode childTagNode = (TagNode)childNode;
            return StringUtils.equals((CharSequence)childTagNode.getPrimaryKey(), (CharSequence)primaryKey);
        };
        boolean flag = tableNode.getChildren().stream().anyMatch(predicate);
        if (flag) {
            return;
        }
        TagNode columnNode = new TagNode("Column", null);
        columnNode.setAttribute("Key", columnKey);
        columnNode.setAttribute("Caption", columnMap.get("Caption"));
        columnNode.setAttribute("DataType", columnMap.get("DataType"));
        columnNode.setAttribute("Length", columnMap.get("Length"));
        tableNode.addNode(columnNode);
    }

    private static void removeColumnNode(TagNode tableNode, String columnKey, String dataObjectKey) {
        String tableKey = tableNode.getAttributes().get("Key");
        boolean flag = XmlDiffProcessor.fieldHastRely(columnKey, dataObjectKey, tableKey);
        if (flag) {
            tableNode.deleteChildByTagKey(columnKey);
        }
    }

    private static TagNode getTableCollectionNode(XmlTreeWithPath xmlTree) throws Throwable {
        TagNode rootNode = xmlTree.xmlTree.getRoot();
        if (rootNode.getTagName().equalsIgnoreCase("DataObject")) {
            return rootNode.getOrCreateChildByKey("TableCollection", "");
        }
        TagNode dataSourceNode = rootNode.getChildByTagName("DataSource");
        String refObjectKey = dataSourceNode.getAttributes().get("RefObjectKey");
        if (StringUtils.isNotEmpty((CharSequence)refObjectKey)) {
            MetaDataObject metaDataObject = MetaFactory.getGlobalInstance().getDataObject(refObjectKey);
            String filePath = LoadFileTree.loadFilePathByDataObjectFieldKey(metaDataObject.getKey());
            XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(filePath);
            return xmlTreeWithPath.xmlTree.getRoot().getChildByTagName("TableCollection");
        }
        return rootNode.getOrCreateChildByKey("DataSource", "").getOrCreateChildByKey("DataObject", "").getOrCreateChildByKey("TableCollection", "");
    }

    /*
     * Exception decompiling
     */
    public static String getGridCellType(String cellDataType, String columnKey) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[10] lbl84 : CaseStatement: default:\u000a, @NONE, blocks:[10] lbl84 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static TagNode addDomainPropertyToNode(TagNode node, String controlType, String dataElementKey) throws Throwable {
        Integer sourceType;
        MetaDataElement dataElement = MetaUtil.getDataElement((IMetaFactory)MetaFactory.getGlobalInstance(), (String)dataElementKey);
        if (dataElement == null) {
            return node;
        }
        MetaDomain domain = dataElement.getDomain();
        if (controlType.equals("Dict")) {
            String itemKey = domain.getItemKey();
            Boolean allowMultiSelection = domain.isAllowMultiSelection();
            node.setAttribute(Property.itemKey.name, itemKey);
            if (allowMultiSelection != null) {
                node.setAttribute(Property.AllowMultiSelection.name, String.valueOf(allowMultiSelection));
            }
        } else if (controlType.equals("NumberEditor")) {
            Integer precision = domain.getPrecision();
            Integer scale = domain.getScale();
            if (precision != null) {
                node.setAttribute(Property.Precision.name, String.valueOf(precision));
            }
            if (scale != null) {
                node.setAttribute(Property.Scale.name, String.valueOf(scale));
            }
        } else if (controlType.equals("ComboBox") && (sourceType = domain.getSourceType()) != null) {
            node.setAttribute(Property.SourceType.name, ComboBoxSourceType.format((Integer)sourceType));
            if (sourceType == 0) {
                MetaListBoxItemCollection items = domain.getItems();
                for (MetaDefaultItem item : items) {
                    TagNode itemNode = new TagNode(item.getTagName(), null);
                    itemNode.setAttribute(Property.caption.name, item.getCaption());
                    itemNode.setAttribute(Property.key.name, item.getKey());
                    itemNode.setAttribute(Property.Value.name, item.getValue());
                    node.addNode(itemNode);
                }
            } else if (sourceType == 4) {
                node.setAttribute(Property.GroupKey.name, String.valueOf(domain.getGroupKey()));
            }
        }
        if (domain.getLength() != null) {
            node.setAttribute(Property.maxLength.name, String.valueOf(domain.getLength()));
        }
        if (domain.getCase() != null) {
            node.setAttribute(Property.CaseType.name, String.valueOf(domain.getCase()));
        }
        return node;
    }

    private static void handleExtraLayout(TagNode panelNode, int selectedRow, boolean addFlag) {
        TagNode groupCollectionNode = panelNode.findFirstTagNodeByTagName("GroupCollection");
        if (Objects.isNull(groupCollectionNode)) {
            return;
        }
        List<TagNode> groupNodeList = groupCollectionNode.findNodesByTagName("Group");
        if (CollectionUtils.isEmpty(groupNodeList)) {
            return;
        }
        for (TagNode groupNode : groupNodeList) {
            Map<String, String> attributes = groupNode.getAttributes();
            String startRow = attributes.get("StartRow");
            String endRow = attributes.get("EndRow");
            int startRowIndex = Integer.parseInt(startRow);
            int endRowIndex = Integer.parseInt(endRow);
            if (startRowIndex <= selectedRow && endRowIndex >= selectedRow) {
                if (addFlag) {
                    attributes.put("EndRow", String.valueOf(endRowIndex + 1));
                } else {
                    attributes.put("EndRow", String.valueOf(endRowIndex - 1));
                }
            }
            if (startRowIndex <= selectedRow || endRowIndex <= selectedRow) continue;
            if (addFlag) {
                attributes.put("StartRow", String.valueOf(startRowIndex + 1));
                attributes.put("EndRow", String.valueOf(endRowIndex + 1));
            } else {
                attributes.put("StartRow", String.valueOf(startRowIndex - 1));
                attributes.put("EndRow", String.valueOf(endRowIndex - 1));
            }
            TagNode handleNode = groupNode.findFirstTagNodeByTagName("Handle");
            Map<String, String> handleAttrs = handleNode.getAttributes();
            String handleLabelRow = handleAttrs.get("Y");
            int handleLabelRowIndex = Integer.parseInt(handleLabelRow);
            if (addFlag) {
                handleAttrs.put("Y", String.valueOf(handleLabelRowIndex + 1));
                continue;
            }
            handleAttrs.put("Y", String.valueOf(handleLabelRowIndex - 1));
        }
    }
}

