/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.automap.print.template.ReportDomUtil;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.cmd.NewFormCmd;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.vo.ResponseResult;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.helper.MetaObjectHelper;
import com.bokesoft.yes.meta.persist.dom.report.MetaReportLoad;
import com.bokesoft.yes.meta.persist.dom.report.MetaReportSave;
import com.bokesoft.yes.meta.persist.dom.xml.XmlCreator;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.commondef.MetaStatusCollection;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.meta.report.MetaReport;
import com.bokesoft.yigo.meta.report.MetaReportDataField;
import com.bokesoft.yigo.meta.report.MetaReportDataSource;
import com.bokesoft.yigo.meta.report.MetaReportDataTable;
import com.bokesoft.yigo.meta.report.MetaReportList;
import com.bokesoft.yigo.meta.report.MetaReportProfile;
import com.bokesoft.yigo.meta.report.MetaReportSubList;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;

public class WebPrintDesign
extends DesignerServiceCmd {
    public static final String CMD = "WebPrintDesign";
    private static final String XML_EXTENSION = ".xml";
    private String projectKey;
    private String formKey;
    private String formCaption;
    private String associationForm;
    private boolean createDefaultTemplate = true;

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) {
        this.projectKey = (String)arguments.get((Object)"projectKey");
        this.formKey = (String)arguments.get((Object)"newFormKey");
        this.formCaption = (String)arguments.get((Object)"formCaption");
        this.associationForm = (String)arguments.get((Object)"associationForm");
        this.createDefaultTemplate = Integer.valueOf((String)arguments.get((Object)"createDefaultTemplate")) == 1;
    }

    public Map<String, String> createXml(String projectKey, String key, String caption) throws Throwable {
        HashMap<String, String> result = new HashMap<String, String>(10);
        String filePath = "";
        String newFileName = String.valueOf(key) + XML_EXTENSION;
        filePath = LoadFileTree.NewPrintfilePath(result, projectKey, newFileName, key, caption, this.associationForm);
        String fileContent = this.setMetaPrint(key, caption, newFileName, projectKey);
        FileUtils.writeStringToFile((File)new File(filePath), (String)fileContent, (String)"UTF-8");
        result.put("result", "true");
        result.put("filePath", filePath);
        result.put("fileName", newFileName.replaceAll(XML_EXTENSION, ""));
        return result;
    }

    public MetaStatusCollection getStatusCollection(String projectKey, MetaDataObject dataObject) throws Throwable {
        if (Objects.isNull(dataObject)) {
            return null;
        }
        MetaStatusCollection statusCollection = dataObject.getStatusCollection();
        if (Objects.isNull(statusCollection)) {
            IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
            MetaStatusCollection statuses = globalInstance.getCommonDef(projectKey).getStatusCollection();
            if (Objects.isNull(statuses)) {
                return globalInstance.getCommonDef(null).getStatusCollection();
            }
            return statuses;
        }
        return statusCollection;
    }

    private MetaReport createDefault(String key, String caption, String formKey) throws Throwable {
        MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(formKey);
        MetaDataSource dataSource = metaForm.getDataSource();
        MetaDataObject metaDataObject = null;
        if (dataSource != null) {
            metaDataObject = dataSource.getDataObject();
        }
        return ReportDomUtil.createDefaultReport((String)key, (String)caption, (MetaForm)metaForm, (MetaDataObject)metaDataObject, (MetaStatusCollection)this.getStatusCollection(this.projectKey, metaDataObject));
    }

    private String setMetaPrint(String key, String caption, String newFileName, String projectKey) throws Throwable {
        MetaReportList metaReportList = MetaFactory.getGlobalInstance().getMetaReportList();
        MetaReportSubList d_billModuleTem = (MetaReportSubList)metaReportList.get("D_BillModuleTem");
        MetaReportProfile d_printTem = (MetaReportProfile)d_billModuleTem.get("D_PrintTem");
        MetaReportProfile metaReportProfileClone = MetaObjectHelper.deptClone(d_printTem);
        if (this.createDefaultTemplate) {
            metaReportProfileClone.setReport(this.createDefault(key, caption, this.associationForm));
        }
        metaReportProfileClone.setCaption(caption);
        metaReportProfileClone.setKey(key);
        metaReportProfileClone.setFormKey(this.associationForm);
        if (Objects.isNull(metaReportProfileClone.getReport())) {
            MetaProject metaProject = (MetaProject)metaReportProfileClone.getProject();
            IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
            IMetaResolver projectResourceResolver = (IMetaResolver)globalInstance.getProjectResolverMap().get(metaProject.getKey());
            MetaReportLoad load = new MetaReportLoad(1);
            load.load(projectResourceResolver, metaReportProfileClone.getResource());
            MetaReport metaReport = (MetaReport)load.getRootMetaObject();
            metaReportProfileClone.setReport(metaReport);
        }
        metaReportProfileClone.getReport().setCaption(caption);
        metaReportProfileClone.getReport().setFormKey(this.associationForm);
        metaReportProfileClone.getReport().setKey(key);
        if (!this.createDefaultTemplate) {
            MetaReportDataSource metaReportDataTables = new MetaReportDataSource();
            MetaForm metaForm = NewFormCmd.loadMetaForm(this.associationForm);
            MetaDataSource dataSource = metaForm.getDataSource();
            if (dataSource == null && StringUtils.isNotEmpty((CharSequence)metaForm.getExtend())) {
                MetaForm extendMetaForm = NewFormCmd.loadMetaForm(metaForm.getExtend());
                dataSource = extendMetaForm.getDataSource();
            }
            if (dataSource != null) {
                MetaDataObject metaDataObject = null;
                if (StringUtils.isNotEmpty((CharSequence)dataSource.getRefObjectKey())) {
                    metaDataObject = DataObjectHelper.loadByKey(dataSource.getRefObjectKey());
                }
                MetaTableCollection tableCollection = null;
                tableCollection = metaDataObject != null ? metaDataObject.getTableCollection() : dataSource.getDataObject().getTableCollection();
                for (MetaTable metaTable : tableCollection) {
                    MetaReportDataTable metaReportDataFields = new MetaReportDataTable();
                    metaReportDataFields.setKey(metaTable.getKey());
                    metaReportDataFields.setCaption(metaTable.getCaption());
                    metaReportDataFields.setSourceType(metaTable.getSourceType());
                    metaReportDataTables.add((KeyPairMetaObject)metaReportDataFields);
                    for (MetaColumn metaColumn : metaTable) {
                        MetaReportDataField metaReportDataField = new MetaReportDataField();
                        metaReportDataField.setCaption(metaColumn.getCaption());
                        metaReportDataField.setKey(metaColumn.getKey());
                        metaReportDataField.setDescription(metaColumn.getDescription());
                        metaReportDataField.setDBFieldKey(metaColumn.getDBColumnName());
                        metaReportDataFields.add((KeyPairMetaObject)metaReportDataField);
                    }
                }
            }
            metaReportProfileClone.getReport().setDataSource(metaReportDataTables);
        }
        MetaReportProfile metaReport = this.setKeyAndCaption(metaReportProfileClone, key, caption, metaReportList, newFileName, projectKey);
        MetaReportSave metaReportSave = new MetaReportSave((AbstractMetaObject)metaReport.getReport());
        Document document = metaReportSave.getDocument();
        XmlCreator creator11 = new XmlCreator(document, null);
        return creator11.createXml();
    }

    public static ResponseResult<JSONArray> SavePrintXML(String filePaths, IMetaFactory metaFactory) {
        ResponseResult<JSONArray> result = new ResponseResult<JSONArray>();
        try {
            File file = new File(filePaths);
            String tmpFile = XmlFileProcessor.instance.getTmpFile(filePaths);
            if (StringUtils.isBlank((CharSequence)tmpFile)) {
                tmpFile = filePaths;
            }
            String newContent = FileUtils.readFileToString((File)new File(tmpFile), (String)"UTF-8");
            FileUtils.writeStringToFile((File)file, (String)newContent, (String)"UTF-8");
            XmlFileProcessor.instance.clearTmpFile(filePaths);
            result.setCode(0);
            result.setMsg("\u4fdd\u5b58\u6253\u5370\u6a21\u677f\u6210\u529f");
            String group = XmlTreeWithPath.parseFilePath((String)filePaths).xmlTree.getRoot().getAttributes().get("Group");
            String key = XmlTreeWithPath.parseFilePath((String)filePaths).xmlTree.getRoot().getAttributes().get("Key");
            String formKey1 = XmlTreeWithPath.parseFilePath((String)filePaths).xmlTree.getRoot().getAttributes().get("FormKey");
            MetaReportSubList reportSubList = metaFactory.getReportSubList(formKey1);
            ((MetaReportProfile)reportSubList.get(key)).setReport(null);
            metaFactory.getReport(group, key, formKey1);
        }
        catch (Throwable e) {
            result.setCode(999);
            result.setMsg("\u4fdd\u5b58\u51fa\u73b0\u5f02\u5e38\uff0c\u5931\u8d25\u6d88\u606f\u4e3a:" + e.getMessage());
        }
        return result;
    }

    public MetaReportProfile setKeyAndCaption(MetaReportProfile metaReportProfile, String Key, String Caption, MetaReportList metaReportList, String newFileName, String projectKey) throws Exception {
        metaReportProfile.setKey(Key);
        metaReportProfile.setCaption(Caption);
        metaReportProfile.setResource("Report/" + newFileName);
        try {
            MetaProject project = MetaFactory.getGlobalInstance().getMetaProject(projectKey);
            metaReportProfile.setProject((IMetaProject)project);
        }
        catch (Throwable throwable) {
            LogSvr.getInstance().error(throwable.getMessage(), throwable);
        }
        MetaReportSubList metaReportProfiles = (MetaReportSubList)metaReportList.get(this.associationForm);
        if (Objects.isNull(metaReportProfiles)) {
            MetaReportSubList metaReportSubList = new MetaReportSubList();
            metaReportSubList.setKey(this.associationForm);
            metaReportSubList.add((KeyPairMetaObject)metaReportProfile);
            metaReportList.add((KeyPairMetaObject)metaReportSubList);
        } else {
            metaReportProfiles.add((KeyPairMetaObject)metaReportProfile);
        }
        metaReportProfile.doPostProcess(0, null);
        return metaReportProfile;
    }

    @Override
    public Object innerDoCmd(DefaultContext defaultContext) throws Throwable {
        JSONObject result = new JSONObject();
        Map<String, String> xml = this.createXml(this.projectKey, this.formKey, this.formCaption);
        result.put("code", (Object)0);
        result.put("msg", (Object)"\u65b0\u589e\u6587\u4ef6\u6210\u529f");
        result.put("filePath", (Object)xml.get("filePath"));
        ArrayList<UICommand> uiCommands = new ArrayList<UICommand>();
        uiCommands.add(UICommand.reloadFileTree(xml.get("filePath")));
        uiCommands.add(UICommand.reloadMenuTree());
        result.put("uICommands", (Object)UICommand.toJson(uiCommands));
        return result;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new WebPrintDesign();
    }

    public String getCmd() {
        return CMD;
    }
}

