/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.design.vo.ResponseResult;
import com.bokesoft.yes.helper.MetaObjectHelper;
import com.bokesoft.yes.meta.persist.dom.xml.XmlCreator;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelCell;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelColumn;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelColumns;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelDisplay;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelFormat;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelListItem;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelRow;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelRows;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelSheet;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateList;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateProfile;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateSave;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateSubList;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelWorkbook;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.MetaCheckListBox;
import com.bokesoft.yigo.meta.form.component.control.MetaComboBox;
import com.bokesoft.yigo.meta.form.component.control.MetaDefaultItem;
import com.bokesoft.yigo.meta.form.component.control.MetaDict;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCheckListBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaComboBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaListBoxItemCollection;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;

public class WebExcelDesign
extends DesignerServiceCmd {
    public static final String CMD = "WebExcelDesign";
    private static final String XML_EXTENSION = ".xml";
    private String projectKey;
    private String formKey;
    private String formCaption;
    private String associationForm;

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) {
        this.projectKey = (String)arguments.get((Object)"projectKey");
        this.formKey = (String)arguments.get((Object)"newFormKey");
        this.formCaption = (String)arguments.get((Object)"formCaption");
        this.associationForm = (String)arguments.get((Object)"associationForm");
    }

    public Map<String, String> createXml(String projectKey, String key, String caption) throws Throwable {
        HashMap<String, String> result = new HashMap<String, String>(10);
        String filePath = "";
        String newFileName = String.valueOf(key) + XML_EXTENSION;
        filePath = LoadFileTree.NewExcelfilePath(result, projectKey, newFileName, key, caption);
        String fileContent = this.setMetaExcel(key, caption, newFileName, projectKey);
        FileUtils.writeStringToFile((File)new File(filePath), (String)fileContent, (String)"UTF-8");
        result.put("result", "true");
        result.put("filePath", filePath);
        result.put("fileName", newFileName.replaceAll(XML_EXTENSION, ""));
        return result;
    }

    public static ResponseResult<JSONArray> SaveExcelXML(String filePaths, IMetaFactory metaFactory) throws Throwable {
        ResponseResult<JSONArray> result = new ResponseResult<JSONArray>();
        File file = new File(filePaths);
        String tmpFile = XmlFileProcessor.instance.getTmpFile(filePaths);
        if (StringUtils.isBlank((CharSequence)tmpFile)) {
            tmpFile = filePaths;
        }
        String newContent = FileUtils.readFileToString((File)new File(tmpFile), (String)"UTF-8");
        FileUtils.writeStringToFile((File)file, (String)newContent, (String)"UTF-8");
        XmlFileProcessor.instance.clearTmpFile(filePaths);
        result.setCode(0);
        result.setMsg("\u4fdd\u5b58Excel\u6210\u529f");
        String key = XmlTreeWithPath.parseFilePath((String)filePaths).xmlTree.getRoot().getAttributes().get("Key");
        String projectKey = LoadFileTree.getProjectKey(filePaths);
        MetaExcelTemplateSubList excelTemplateSubList = (MetaExcelTemplateSubList)metaFactory.getMetaExcelTemplateList().get(projectKey);
        MetaExcelTemplateProfile excelTemplateProfile = (MetaExcelTemplateProfile)excelTemplateSubList.get(key);
        excelTemplateProfile.setWorkbook(null);
        MetaExcelWorkbook excelTemplateOld = metaFactory.getExcelTemplate(projectKey, key);
        WebExcelDesign.excelElementSorting(filePaths, metaFactory, key, projectKey, excelTemplateProfile, excelTemplateOld);
        return result;
    }

    private static void excelElementSorting(String filePaths, IMetaFactory metaFactory, String key, String projectKey, MetaExcelTemplateProfile excelTemplateProfile, MetaExcelWorkbook excelTemplateOld) throws Throwable {
        MetaExcelWorkbook newExcelTemplate = MetaObjectHelper.deptClone(excelTemplateOld);
        newExcelTemplate.clear();
        for (MetaExcelSheet metaExcelSheet : excelTemplateOld) {
            MetaExcelColumns oldColumns;
            MetaExcelSheet newMetaExcelSheet = MetaObjectHelper.deptClone(metaExcelSheet);
            newExcelTemplate.add((AbstractMetaObject)newMetaExcelSheet);
            newMetaExcelSheet.clear();
            MetaExcelRows oldRows = metaExcelSheet.getRows();
            if (oldRows != null) {
                MetaExcelRows newRows = MetaObjectHelper.deptClone(oldRows);
                newMetaExcelSheet.setRows(newRows);
                newRows.clear();
                ArrayList<MetaExcelRow> metaExcelRows = new ArrayList<MetaExcelRow>();
                for (MetaExcelRow oldRow : oldRows) {
                    metaExcelRows.add(oldRow);
                }
                List collect = metaExcelRows.stream().sorted(Comparator.comparing(e -> e.getRowIndex())).collect(Collectors.toList());
                for (MetaExcelRow object : collect) {
                    ArrayList<MetaExcelCell> metaExcelCells = new ArrayList<MetaExcelCell>();
                    for (MetaExcelCell metaExcelCell : object) {
                        metaExcelCells.add(metaExcelCell);
                    }
                    List collect1 = metaExcelCells.stream().sorted(Comparator.comparing(a -> a.getCellIndex())).collect(Collectors.toList());
                    object.clear();
                    for (MetaExcelCell metaExcelCell : collect1) {
                        object.add((AbstractMetaObject)metaExcelCell);
                    }
                    newRows.add((AbstractMetaObject)object);
                }
            }
            if ((oldColumns = metaExcelSheet.getColumns()) == null) continue;
            MetaExcelColumns newMetaExcelColumns = MetaObjectHelper.deptClone(oldColumns);
            newMetaExcelSheet.setColumns(newMetaExcelColumns);
            newMetaExcelColumns.clear();
            ArrayList<MetaExcelColumn> metaExcelColumns = new ArrayList<MetaExcelColumn>();
            for (MetaExcelColumn oldColumn : oldColumns) {
                metaExcelColumns.add(oldColumn);
            }
            List collect1 = metaExcelColumns.stream().sorted(Comparator.comparing(a -> a.getColumnIndex())).collect(Collectors.toList());
            for (MetaExcelColumn excelColumn : collect1) {
                newMetaExcelColumns.add((AbstractMetaObject)excelColumn);
            }
        }
        MetaExcelTemplateSave metaExcelTemplateSave = new MetaExcelTemplateSave((AbstractMetaObject)newExcelTemplate);
        Document document = metaExcelTemplateSave.getDocument();
        XmlCreator creator11 = new XmlCreator(document, null);
        FileUtils.writeStringToFile((File)new File(filePaths), (String)creator11.createXml(), (String)"UTF-8");
        excelTemplateProfile.setWorkbook(null);
        metaFactory.getExcelTemplate(projectKey, key);
    }

    private MetaExcelWorkbook createDefault(String key, String caption, String formKey) throws Throwable {
        MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(formKey);
        MetaDataObject metaDataObject = metaForm.getDataSource().getDataObject();
        MetaTableCollection tableCollection = metaDataObject.getTableCollection();
        Iterator itTables = tableCollection.iterator();
        if (tableCollection.size() == 0) {
            return null;
        }
        MetaTable metaTable = null;
        MetaExcelWorkbook metaExcelSheets = new MetaExcelWorkbook();
        metaExcelSheets.setKey(key);
        metaExcelSheets.setCaption(caption);
        metaExcelSheets.setFormKey(formKey);
        while (itTables.hasNext()) {
            metaTable = (MetaTable)itTables.next();
            String sheetKey = metaTable.getKey();
            String sheetName = metaTable.getCaption();
            if (sheetKey.endsWith("_NODB")) continue;
            MetaExcelSheet metaExcelSheet = new MetaExcelSheet();
            metaExcelSheet.setName(sheetName);
            metaExcelSheets.add((AbstractMetaObject)metaExcelSheet);
            MetaExcelRows metaExcelRows = new MetaExcelRows();
            metaExcelSheet.setRows(metaExcelRows);
            MetaExcelRow metaExcelCells = new MetaExcelRow();
            metaExcelCells.setRowIndex(Integer.valueOf(1));
            metaExcelRows.add((AbstractMetaObject)metaExcelCells);
            metaExcelRows.set(0, (AbstractMetaObject)metaExcelCells);
            MetaExcelRow metaExcelCells1 = new MetaExcelRow();
            metaExcelCells1.setRowIndex(Integer.valueOf(2));
            metaExcelRows.add((AbstractMetaObject)metaExcelCells1);
            metaExcelRows.set(1, (AbstractMetaObject)metaExcelCells1);
            String tableKey = metaTable.getKey();
            Iterator iterator = metaTable.iterator();
            int i = 1;
            while (iterator.hasNext()) {
                MetaExcelListItem e;
                String value;
                String caption1;
                ArrayList<MetaExcelListItem> metaExcelListItem;
                MetaListBoxItemCollection items;
                MetaComboBox component1;
                MetaComponent component;
                String componentFieldKey;
                IDLookup idLookup;
                String columnKey;
                MetaColumn metaColumn = (MetaColumn)iterator.next();
                if (metaColumn.getKey().endsWith("_NODB")) continue;
                if (metaTable.getTableMode() == 1) {
                    MetaExcelListItem e2;
                    String value2;
                    String caption12;
                    ArrayList<MetaExcelListItem> metaExcelListItem2;
                    MetaListBoxItemCollection items2;
                    MetaComboBoxProperties component12;
                    MetaGridCell gridCell;
                    columnKey = metaColumn.getKey();
                    if (metaForm == null || (gridCell = (idLookup = IDLookup.getIDLookup(metaForm)).getGridCellByKey(columnKey)) == null) continue;
                    String fieldCaption = gridCell.getCaption();
                    MetaExcelCell lab_metaExcelCell = new MetaExcelCell();
                    metaExcelCells.add((AbstractMetaObject)lab_metaExcelCell);
                    metaExcelCells.setType(Integer.valueOf(2));
                    lab_metaExcelCell.setCellIndex(Integer.valueOf(i));
                    lab_metaExcelCell.setDefinition(fieldCaption);
                    lab_metaExcelCell.setMergedRowSpan(Integer.valueOf(1));
                    lab_metaExcelCell.setMergedColumnSpan(Integer.valueOf(1));
                    lab_metaExcelCell.setSourceType(Integer.valueOf(2));
                    metaExcelCells.add((AbstractMetaObject)lab_metaExcelCell);
                    MetaExcelCell metaExcelCell = new MetaExcelCell();
                    metaExcelCells1.add((AbstractMetaObject)metaExcelCell);
                    metaExcelCells1.setType(Integer.valueOf(3));
                    metaExcelCells1.setTableKey(tableKey);
                    metaExcelCell.setCellIndex(Integer.valueOf(i));
                    metaExcelCell.setSourceType(Integer.valueOf(0));
                    metaExcelCell.setDefinition(metaColumn.getKey());
                    metaExcelCell.setMergedColumnSpan(Integer.valueOf(1));
                    metaExcelCell.setMergedRowSpan(Integer.valueOf(1));
                    int controlType = gridCell.getCellType();
                    MetaExcelDisplay metaExcelDisplay = new MetaExcelDisplay();
                    metaExcelCell.setDisplay(metaExcelDisplay);
                    MetaExcelFormat metaExcelFormat = new MetaExcelFormat();
                    metaExcelDisplay.setFormat(metaExcelFormat);
                    metaExcelFormat.setDataType(Integer.valueOf(0));
                    if (controlType == 206) {
                        metaExcelFormat.setDataType(Integer.valueOf(1));
                        component12 = (MetaDictProperties)gridCell.getProperties();
                        metaExcelFormat.setItemKey(component12.getItemKey());
                        metaExcelFormat.setFieldKeys("Name");
                    } else if (controlType == 204) {
                        component12 = (MetaComboBoxProperties)gridCell.getProperties();
                        if (component12.getSourceType() == 0) {
                            metaExcelFormat.setDataType(Integer.valueOf(3));
                            items2 = component12.getItems();
                            metaExcelListItem2 = new ArrayList<MetaExcelListItem>();
                            for (MetaDefaultItem item : items2) {
                                caption12 = item.getCaption();
                                value2 = item.getValue();
                                e2 = new MetaExcelListItem();
                                e2.setValue(value2);
                                e2.setText(caption12);
                                metaExcelListItem2.add(e2);
                            }
                            if (metaExcelListItem2.size() > 0) {
                                metaExcelFormat.setListItems(metaExcelListItem2);
                            }
                        }
                    } else if (controlType == 202) {
                        metaExcelFormat.setDataType(Integer.valueOf(4));
                        component12 = (MetaCheckListBoxProperties)gridCell.getProperties();
                        if (component12.getSourceType() == 0) {
                            items2 = component12.getItems();
                            metaExcelListItem2 = new ArrayList();
                            for (MetaDefaultItem item : items2) {
                                caption12 = item.getCaption();
                                value2 = item.getValue();
                                e2 = new MetaExcelListItem();
                                e2.setValue(value2);
                                e2.setText(caption12);
                                metaExcelListItem2.add(e2);
                            }
                            if (metaExcelListItem2.size() > 0) {
                                metaExcelFormat.setListItems(metaExcelListItem2);
                            }
                        }
                    }
                    ++i;
                    continue;
                }
                columnKey = metaColumn.getKey();
                if (metaForm == null || (componentFieldKey = (idLookup = IDLookup.getIDLookup(metaForm)).getFieldKeyByTableColumnKey(tableKey, columnKey)) == null || (component = idLookup.getComponentByKey(componentFieldKey)) == null) continue;
                String fieldCaption = component.getCaption();
                MetaExcelCell lab_metaExcelCell = new MetaExcelCell();
                lab_metaExcelCell.setCellIndex(Integer.valueOf(i));
                lab_metaExcelCell.setDefinition(fieldCaption);
                lab_metaExcelCell.setMergedRowSpan(Integer.valueOf(1));
                lab_metaExcelCell.setMergedColumnSpan(component.getXSpan());
                lab_metaExcelCell.setSourceType(Integer.valueOf(2));
                metaExcelCells.add((AbstractMetaObject)lab_metaExcelCell);
                MetaExcelCell metaExcelCell = new MetaExcelCell();
                metaExcelCells1.add((AbstractMetaObject)metaExcelCell);
                metaExcelCells1.setType(Integer.valueOf(1));
                metaExcelCell.setTableKey(tableKey);
                metaExcelCell.setCellIndex(Integer.valueOf(i));
                metaExcelCell.setSourceType(Integer.valueOf(0));
                metaExcelCell.setDefinition(metaColumn.getKey());
                metaExcelCell.setMergedColumnSpan(component.getXSpan());
                metaExcelCell.setMergedRowSpan(Integer.valueOf(1));
                if (component.getXSpan() > 1) {
                    i += component.getXSpan() - 1;
                }
                int controlType = component.getControlType();
                MetaExcelDisplay metaExcelDisplay = new MetaExcelDisplay();
                metaExcelCell.setDisplay(metaExcelDisplay);
                MetaExcelFormat metaExcelFormat = new MetaExcelFormat();
                metaExcelDisplay.setFormat(metaExcelFormat);
                metaExcelFormat.setDataType(Integer.valueOf(0));
                if (controlType == 206) {
                    metaExcelFormat.setDataType(Integer.valueOf(1));
                    component1 = (MetaDict)component;
                    metaExcelFormat.setItemKey(component1.getItemKey());
                    metaExcelFormat.setFieldKeys("Name");
                } else if (controlType == 204) {
                    component1 = (MetaComboBox)component;
                    if (component1.getSourceType() == 0) {
                        metaExcelFormat.setDataType(Integer.valueOf(3));
                        items = component1.getItems();
                        metaExcelListItem = new ArrayList<MetaExcelListItem>();
                        for (MetaDefaultItem item : items) {
                            caption1 = item.getCaption();
                            value = item.getValue();
                            e = new MetaExcelListItem();
                            e.setValue(value);
                            e.setText(caption1);
                            metaExcelListItem.add(e);
                        }
                        if (metaExcelListItem.size() > 0) {
                            metaExcelFormat.setListItems(metaExcelListItem);
                        }
                    }
                } else if (controlType == 202) {
                    metaExcelFormat.setDataType(Integer.valueOf(4));
                    component1 = (MetaCheckListBox)component;
                    if (component1.getSourceType() == 0) {
                        items = component1.getItems();
                        metaExcelListItem = new ArrayList();
                        for (MetaDefaultItem item : items) {
                            caption1 = item.getCaption();
                            value = item.getValue();
                            e = new MetaExcelListItem();
                            e.setValue(value);
                            e.setText(caption1);
                            metaExcelListItem.add(e);
                        }
                        if (metaExcelListItem.size() > 0) {
                            metaExcelFormat.setListItems(metaExcelListItem);
                        }
                    }
                }
                ++i;
            }
        }
        metaExcelSheets.setSheet((MetaExcelSheet)metaExcelSheets.get(0));
        return metaExcelSheets;
    }

    private String setMetaExcel(String key, String caption, String newFileName, String projectKey) throws Throwable {
        MetaExcelTemplateList excelTemplateList = MetaFactory.getGlobalInstance().getMetaExcelTemplateList();
        MetaExcelTemplateSubList metaExcelTemplateProfiles = (MetaExcelTemplateSubList)excelTemplateList.get("webconfig");
        MetaExcelTemplateProfile metaExcelTemplateProfile = (MetaExcelTemplateProfile)metaExcelTemplateProfiles.get("D_ExcelTem");
        MetaExcelTemplateProfile depthClone = MetaObjectHelper.deptClone(metaExcelTemplateProfile);
        depthClone.setProject(metaExcelTemplateProfile.getProject());
        if (Objects.isNull(depthClone.getWorkbook())) {
            MetaExcelWorkbook workbook = new MetaExcelWorkbook();
            MetaExcelSheet metaExcelSheet = new MetaExcelSheet();
            metaExcelSheet.setName("Sheet1");
            metaExcelSheet.setRows(new MetaExcelRows());
            workbook.add((AbstractMetaObject)metaExcelSheet);
            depthClone.setWorkbook(workbook);
        }
        depthClone.getWorkbook().setFormKey(this.associationForm);
        depthClone.getWorkbook().setCaption(caption);
        depthClone.getWorkbook().setKey(key);
        MetaExcelTemplateProfile excelTemplateProfile = this.setKeyAndCaption(depthClone, key, caption, excelTemplateList, newFileName, projectKey);
        MetaExcelTemplateSave metaExcelTemplateSave = new MetaExcelTemplateSave((AbstractMetaObject)excelTemplateProfile.getWorkbook());
        Document document = metaExcelTemplateSave.getDocument();
        XmlCreator creator11 = new XmlCreator(document, null);
        return creator11.createXml();
    }

    public MetaExcelTemplateProfile setKeyAndCaption(MetaExcelTemplateProfile dataObjectModule, String Key, String Caption, MetaExcelTemplateList metaExcelTemplateList, String newFileName, String projectKey) throws Exception {
        dataObjectModule.setKey(Key);
        dataObjectModule.setCaption(Caption);
        dataObjectModule.setResource("ExcelTemplate/" + newFileName);
        try {
            MetaProject project = MetaFactory.getGlobalInstance().getMetaProject(projectKey);
            dataObjectModule.setProject((IMetaProject)project);
        }
        catch (Throwable throwable) {
            LogSvr.getInstance().error(throwable.getMessage(), throwable);
        }
        MetaExcelTemplateSubList metaExcelTemplateProfiles = (MetaExcelTemplateSubList)metaExcelTemplateList.get(projectKey);
        if (Objects.isNull(metaExcelTemplateProfiles)) {
            MetaExcelTemplateSubList excelTemplateSubList = new MetaExcelTemplateSubList();
            excelTemplateSubList.setKey(projectKey);
            excelTemplateSubList.add((KeyPairMetaObject)dataObjectModule);
            metaExcelTemplateList.add((KeyPairMetaObject)excelTemplateSubList);
        } else {
            metaExcelTemplateProfiles.add((KeyPairMetaObject)dataObjectModule);
        }
        dataObjectModule.doPostProcess(0, null);
        return dataObjectModule;
    }

    @Override
    public Object innerDoCmd(DefaultContext defaultContext) throws Throwable {
        JSONObject result = new JSONObject();
        Map<String, String> xml = this.createXml(this.projectKey, this.formKey, this.formCaption);
        result.put("code", (Object)0);
        result.put("msg", (Object)"\u65b0\u589e\u6587\u4ef6\u6210\u529f");
        result.put("filePath", (Object)xml.get("filePath"));
        ArrayList<UICommand> uiCommands = new ArrayList<UICommand>();
        uiCommands.add(UICommand.reloadFileTree(xml.get("filePath")));
        uiCommands.add(UICommand.reloadMenuTree());
        result.put("uICommands", (Object)UICommand.toJson(uiCommands));
        return result;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new WebExcelDesign();
    }

    public String getCmd() {
        return CMD;
    }
}

