/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.erp.all.initiator.InitializingDesigner;
import com.bokesoft.erp.register.ErpConfig;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.cmd.EntryProcessor;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.solution.MetaProjectCollection;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Map;

public class ReviseProjectCmd
extends DesignerServiceCmd {
    public static final String CMD = "ReviseProject";
    private String ProjectKey;
    private String ProjectCaption;
    private String SolutionKey;
    private String Type;

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        this.ProjectKey = TypeConvertor.toString((Object)arguments.get((Object)"newProject")).trim();
        this.ProjectCaption = TypeConvertor.toString((Object)arguments.get((Object)"ProjectCaption")).trim();
        this.SolutionKey = TypeConvertor.toString((Object)arguments.get((Object)"SolutionKey")).trim();
        this.Type = TypeConvertor.toString((Object)arguments.get((Object)"Type")).trim();
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        ArrayList<UICommand> result = new ArrayList<UICommand>();
        if ("New".equalsIgnoreCase(this.Type)) {
            String filePath = LoadFileTree.newProjectFile(this.ProjectKey, this.ProjectCaption, this.SolutionKey);
            if (filePath != null) {
                result.add(UICommand.reloadFileTree(filePath));
                result.add(UICommand.reloadMenuTree());
                result.add(UICommand.showTip("\u5de5\u7a0b\u521b\u5efa\u6210\u529f"));
                return UICommand.toJson(result);
            }
            result.add(UICommand.showTip("\u5de5\u7a0b\u540d\u5b58\u5728,\u521b\u5efa\u5931\u8d25"));
        } else if ("Delete".equalsIgnoreCase(this.Type)) {
            IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
            MetaProjectCollection projectCollection = globalInstance.getSolution().getProjectCollection();
            projectCollection.remove(this.ProjectKey);
            Map projectResolverMap = globalInstance.getProjectResolverMap();
            projectResolverMap.remove(this.ProjectKey);
            EntryProcessor.deleteSolutionByProjectKey(this.ProjectKey, this.SolutionKey);
            LoadFileTree.deleteProjectNodeByProjectKey(this.ProjectKey);
            ErpConfig.initExtendConfig();
            File file = new File(String.valueOf(this.SolutionKey) + File.separator + this.ProjectKey);
            String newFilePath = Paths.get(WebDesignerConfiguration.getDesignerDataPath(), "tmp", this.ProjectKey).toString();
            ReviseProjectCmd.copy(file, newFilePath);
            InitializingDesigner.delFolder(file.getPath());
            result.add(UICommand.reloadFileTree(this.SolutionKey));
            result.add(UICommand.reloadMenuTree());
            result.add(UICommand.freshFileTree());
            result.add(UICommand.showTip("\u5de5\u7a0b\u5220\u9664\u6210\u529f"));
            return UICommand.toJson(result);
        }
        return UICommand.toJson(result);
    }

    public static void copy(File file, String b) throws IOException {
        ReviseProjectCmd.copy(file, new File(b));
    }

    public static void copy(File file, File file1) throws IOException {
        if (!file1.exists()) {
            file1.mkdirs();
        }
        if (file.isDirectory()) {
            File[] files;
            File[] fileArray = files = file.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray[n2];
                if (file2.isDirectory()) {
                    ReviseProjectCmd.copy(file2, new File(file1.getPath(), file2.getName()));
                } else {
                    Files.copy(file2.toPath(), Paths.get(String.valueOf(file1.getPath()) + File.separatorChar + file2.getName(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                }
                ++n2;
            }
        }
    }

    public String getCmd() {
        return CMD;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new ReviseProjectCmd();
    }
}

