/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.xml.XmlParser;
import com.bokesoft.yes.design.xml.node.CDataNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.node.XmlTree;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.parser.MidFunctionImplMap;
import com.bokesoft.yes.parser.IFuncImplMap;
import com.bokesoft.yes.parser.Parser;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ParseFormulaCmd
extends DesignerServiceCmd {
    public static final String CMD = "ParseFormula";
    private String formula;
    private String propertyKey;
    private String formKey;
    private String type;
    private String content;

    public void dealArguments(DefaultContext defaultContext, StringHashMap<Object> arguments) throws Throwable {
        this.formula = TypeConvertor.toString((Object)arguments.get((Object)"formula"));
        this.formKey = TypeConvertor.toString((Object)arguments.get((Object)"formKey"));
        this.propertyKey = TypeConvertor.toString((Object)arguments.get((Object)"fieldKey"));
        this.type = TypeConvertor.toString((Object)arguments.get((Object)"type"));
        this.content = TypeConvertor.toString((Object)arguments.get((Object)"content"));
    }

    @Override
    public Object innerDoCmd(DefaultContext defaultContext) throws Throwable {
        ArrayList<UICommand> result = new ArrayList<UICommand>();
        if (!(!"One".equalsIgnoreCase(this.type) || Objects.equals(this.propertyKey, "Visible") || Objects.equals(this.propertyKey, "Enable") || Objects.equals(this.propertyKey, "DefaultFormulaValue") || Objects.equals(this.propertyKey, "OnLoad") || Objects.equals(this.propertyKey, "RowInsert") || Objects.equals(this.propertyKey, "OnRowDelete") || Objects.equals(this.propertyKey, "RowDelete") || Objects.equals(this.propertyKey, "RowClick") || Objects.equals(this.propertyKey, "RowDblClick") || Objects.equals(this.propertyKey, "FocusRowChanged") || Objects.equals(this.propertyKey, "OnClick") || Objects.equals(this.propertyKey, "ValueChanged") || Objects.equals(this.propertyKey, "Formula") || Objects.equals(this.propertyKey, "Action") || Objects.equals(this.propertyKey, "FormulaItems") || Objects.equals(this.propertyKey, "CheckRule") || Objects.equals(this.propertyKey, "ItemChanged") || Objects.equals(this.propertyKey, "ValueDependency") || Objects.equals(this.propertyKey, "OnPostShow") || Objects.equals(this.propertyKey, "FormulaCaption") || Objects.equals(this.propertyKey, "FormulaAbbrCaption") || Objects.equals(this.propertyKey, "ErrorInfo"))) {
            return UICommand.toJson(result);
        }
        List<Object> evalFormula = this.parseFormula(this.formKey, this.formula);
        if ("all".equalsIgnoreCase(this.type)) {
            if (evalFormula.size() == 0) {
                evalFormula.add("\u8868\u5355\u5185\u5b8f\u516c\u5f0f\u683c\u5f0f\u90fd\u6b63\u786e");
            }
            result.add(UICommand.showTipByList(evalFormula));
        } else if ("xml".equalsIgnoreCase(this.type)) {
            if (evalFormula.size() > 0) {
                result.add(UICommand.showTipByList(evalFormula));
            }
        } else {
            "One".equalsIgnoreCase(this.type);
        }
        return UICommand.toJson(result);
    }

    public List<Object> parseFormula(String formKey, String formula) throws Throwable {
        ArrayList<Object> result = new ArrayList<Object>();
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        if (!metaFactory.getMetaFormList().containsKey(formKey)) {
            return result;
        }
        MetaForm metaForm = metaFactory.getMetaForm(formKey);
        if (metaForm.getProject().getKey().equalsIgnoreCase("webconfig")) {
            return result;
        }
        Parser parser = new Parser((IFuncImplMap)MidFunctionImplMap.getMidInstance());
        if (StringUtils.isEmpty((CharSequence)formula)) {
            Map<String, String> stringStringMap = this.putFormMacrosIntoList(metaForm);
            stringStringMap.forEach((formulaValue, key) -> {
                try {
                    parser.parse(formulaValue);
                }
                catch (Throwable e) {
                    result.add("\u516c\u5f0f:" + key + "\u5185\u5bb9\uff1a" + formulaValue + "\u8bed\u6cd5\u6709\u8bef!!");
                }
            });
        } else {
            try {
                parser.parse(formula);
            }
            catch (Throwable e) {
                throw new Throwable("\u8f93\u5165\u7684\u8868\u8fbe\u5f0f\u8bed\u6cd5\u6709\u8bef\uff1a" + formula);
            }
        }
        return result;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new ParseFormulaCmd();
    }

    public String getCmd() {
        return CMD;
    }

    private Map<String, String> putFormMacrosIntoList(MetaForm metaForm) throws Throwable {
        HashMap<String, String> macroMap = new HashMap<String, String>();
        XmlTree xmlTree = null;
        if (StringUtils.isEmpty((CharSequence)this.content)) {
            String key = metaForm.getKey();
            String filePath = LoadFileTree.getPathByFormKey(key);
            if (StringUtils.isBlank((CharSequence)filePath)) {
                return macroMap;
            }
            XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(filePath);
            xmlTree = xmlTreeWithPath.xmlTree;
        } else {
            xmlTree = XmlParser.parse(this.content);
        }
        List<CDataNode> cDataNodes = xmlTree.findCDataNodes();
        this.setMacroMap(macroMap, cDataNodes);
        return macroMap;
    }

    public void setMacroMap(Map<String, String> macroMap, List<CDataNode> cDataNodes) {
        if (cDataNodes.size() > 0) {
            String args = "";
            String key = "";
            String value = "";
            for (CDataNode cDataNode : cDataNodes) {
                TagNode parent = cDataNode.getParent();
                if (parent.getTagName().equalsIgnoreCase("ColumnExpand") || parent.getTagName().equalsIgnoreCase("TableFilter") || parent.getTagName().equalsIgnoreCase("Statement") && (StringUtils.isEmpty((CharSequence)parent.getAttributes().get("Type")) || "Sql".equalsIgnoreCase(parent.getAttributes().get("Type")))) continue;
                args = parent.getAttributes().get("Args");
                key = parent.getAttributes().get("Key");
                key = StringUtils.isEmpty((CharSequence)key) ? parent.getTagName() : (StringUtils.isNotEmpty((CharSequence)args) ? String.valueOf(key) + "(" + args + ")" : String.valueOf(key) + "()");
                value = cDataNode.getText();
                macroMap.put(value, key);
            }
        }
    }
}

