/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.erp.metaobjectchange.MetaObjectChange;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.cmd.CheckXMLChanged;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.cmd.EntryProcessor;
import com.bokesoft.yes.design.cmd.ReplaceStringEntry;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.DesignReloadMetaObject;
import com.bokesoft.yes.design.vest.DefaultVestCreator;
import com.bokesoft.yes.design.xml.XmlParser;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.node.XmlTree;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectList;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class NewExpandFormCmd
extends DesignerServiceCmd {
    public static final String CMD = "NewExpandForm";
    public static String projectKey;
    private String associationForm;
    private int formType;
    private String formKey;
    private String formCaption;
    private String directory;
    private String isdirectory;
    private String Source;
    private String MergeToSource;
    private String mergeToSourceMapKey;

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        projectKey = TypeConvertor.toString((Object)arguments.get((Object)"projectKey")).trim();
        this.associationForm = TypeConvertor.toString((Object)arguments.get((Object)"associationForm")).trim();
        this.formKey = TypeConvertor.toString((Object)arguments.get((Object)"newFormKey")).trim();
        this.formCaption = TypeConvertor.toString((Object)arguments.get((Object)"formCaption")).trim();
        this.formType = MetaFactory.getGlobalInstance().getMetaForm(this.associationForm).getFormType();
        this.directory = TypeConvertor.toString((Object)arguments.get((Object)"directory")).trim();
        this.isdirectory = TypeConvertor.toString((Object)arguments.get((Object)"IsDirectory")).trim();
        this.Source = TypeConvertor.toString((Object)arguments.get((Object)"Source")).trim();
        this.MergeToSource = TypeConvertor.toString((Object)arguments.get((Object)"MergeToSource")).trim();
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaFormList metaFormList = metaFactory.getMetaFormList();
        if (metaFormList.containsKey(this.formKey)) {
            return null;
        }
        MetaForm metaForm = metaFactory.getMetaForm(this.associationForm);
        MetaDataSource dataSource = metaForm.getDataSource();
        String refObjectKey1 = "";
        if (dataSource != null) {
            refObjectKey1 = dataSource.getRefObjectKey();
        }
        if (StringUtils.equals((CharSequence)this.MergeToSource, (CharSequence)"1")) {
            for (MetaFormProfile metaFormProfile : metaFormList) {
                if (!metaFormProfile.getMergeToSource().booleanValue() || !this.associationForm.equalsIgnoreCase(metaFormProfile.getExtend())) continue;
                this.MergeToSource = "0";
            }
        }
        if (StringUtils.isNotBlank((CharSequence)refObjectKey1) && StringUtils.equals((CharSequence)this.MergeToSource, (CharSequence)"1")) {
            MetaDataObject dataObject = metaFactory.getDataObject(refObjectKey1);
            this.mergeToSourceMapKey = dataObject.getMergeToSourceMapKey();
            if (StringUtils.isBlank((CharSequence)this.mergeToSourceMapKey)) {
                MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
                for (MetaDataObjectProfile metaDataObjectProfile : dataObjectList) {
                    if (!StringUtils.equals((CharSequence)metaDataObjectProfile.getExtend(), (CharSequence)refObjectKey1)) continue;
                    this.mergeToSourceMapKey = metaDataObjectProfile.getKey();
                    break;
                }
                if (StringUtils.isBlank((CharSequence)this.mergeToSourceMapKey)) {
                    this.mergeToSourceMapKey = String.valueOf(dataObject.getKey()) + "_Vest";
                    String caption = String.valueOf(dataObject.getCaption()) + "\u9a6c\u7532";
                    MetaDataObjectProfile profile = DataObjectHelper.createOutsideProfile(this.mergeToSourceMapKey, caption, projectKey, refObjectKey1);
                    String filePath = LoadFileTree.NewDataObjectFilePath(projectKey, this.mergeToSourceMapKey, caption);
                    String fileContent = DataObjectHelper.createXml(profile.getDataObject());
                    XmlFileProcessor.instance.saveTempFile(filePath, fileContent, projectKey);
                    FileUtils.writeStringToFile((File)new File(filePath), (String)fileContent, (String)"UTF-8");
                    dataObjectList.add((KeyPairMetaObject)profile);
                }
            }
        }
        String fileName = String.valueOf(this.formKey) + ".xml";
        String content = this.getNewFormContent(this.formKey, this.formCaption, this.associationForm);
        String filePath = LoadFileTree.newFile(projectKey, this.formType, fileName, this.formKey, this.formCaption, this.directory, this.isdirectory);
        String tmpFilePath = XmlFileProcessor.instance.saveTempFile(filePath, content, projectKey);
        File file = new File(filePath);
        String reloadParentKey = "";
        if (!file.getParentFile().exists()) {
            reloadParentKey = file.getParent();
        }
        FileUtils.writeStringToFile((File)file, (String)content, (String)"UTF-8");
        String resource = LoadFileTree.getResource(tmpFilePath, projectKey);
        ((MetaFormProfile)metaFormList.get(this.formKey)).setProject((IMetaProject)metaFactory.getMetaProject(projectKey));
        ((MetaFormProfile)metaFormList.get(this.formKey)).setResource(resource);
        ((MetaFormProfile)metaFormList.get(this.formKey)).setExtend(this.associationForm);
        ((MetaFormProfile)metaFormList.get(this.formKey)).setMergeToSource(Boolean.valueOf("1".equals(this.MergeToSource)));
        if (!"1".equals(this.MergeToSource) && StringUtils.isNotEmpty((CharSequence)this.associationForm)) {
            ((MetaFormProfile)metaFormList.get(this.formKey)).setFormType(-1);
        }
        metaFactory.reloadMetaForm(this.formKey);
        metaFactory.getMetaForm(this.formKey);
        EntryProcessor.instance.newForm(projectKey, this.formType, this.formKey, this.formCaption, this.Source, true);
        List<MetaFormProfile> reloadMetaFormProfiles = null;
        String refKey = "";
        if (metaFactory.getMetaForm(this.formKey).getDataSource() != null) {
            refKey = metaFactory.getMetaForm(this.formKey).getDataSource().getRefObjectKey();
        }
        if ("1".equals(this.MergeToSource)) {
            reloadMetaFormProfiles = DesignReloadMetaObject.reloadMetaFormRollbackError(this.formKey);
        } else if (StringUtils.isNotEmpty((CharSequence)refKey)) {
            MetaForm metaForm1 = metaFactory.getMetaForm(this.formKey);
            String refObjectKey = metaForm1.getDataSource().getRefObjectKey();
            String s = LoadFileTree.loadFilePathByDataObjectFieldKey(refObjectKey);
            reloadMetaFormProfiles = DataObjectHelper.reload(null, refObjectKey, s, null);
        } else {
            reloadMetaFormProfiles = DesignReloadMetaObject.reloadMetaFormRollbackError(this.formKey);
        }
        ArrayList<UICommand> result = new ArrayList<UICommand>();
        if (reloadMetaFormProfiles != null) {
            for (MetaFormProfile metaFormProfile : reloadMetaFormProfiles) {
                result.add(UICommand.reloadFormKey(metaFormProfile.getKey()));
            }
        }
        UICommand command = UICommand.reloadFileTree(filePath);
        result.add(command);
        if (!reloadParentKey.isEmpty()) {
            result.add(UICommand.reloadFileTree(reloadParentKey));
        }
        result.add(UICommand.runFormKey(this.formKey));
        result.add(UICommand.reloadMenuTree());
        return UICommand.toJson(result);
    }

    public String getCmd() {
        return CMD;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new NewExpandFormCmd();
    }

    private String getNewFormContent(String key, String caption, String oldFormKey) throws Throwable {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaFormList metaFormList = metaFactory.getMetaFormList();
        MetaForm module = this.getModule(oldFormKey);
        MetaForm newMetaForm = this.setKeyAndCaption(module, key, caption);
        String xml = this.saveMetaForm(module);
        MetaFormProfile newFormProfile = (MetaFormProfile)((MetaFormProfile)metaFormList.get(module.getKey())).clone();
        newFormProfile.setKey(key);
        newFormProfile.setCaption(caption);
        newFormProfile.setResource("");
        newFormProfile.setForm(newMetaForm);
        newFormProfile.setExtend(oldFormKey);
        metaFormList.add((KeyPairMetaObject)newFormProfile);
        MetaObjectChange.fireChangeDesignMetaForm((MetaForm)newMetaForm, (String[])new String[0]);
        MetaForm erpNewMetaForm = metaFactory.getMetaForm(key);
        metaFactory.replaceMetaForm(key, erpNewMetaForm);
        return xml;
    }

    private synchronized MetaForm getModule(String oldFormKey) throws Throwable {
        MetaForm result = MetaFactory.getGlobalInstance().getMetaForm(oldFormKey);
        return (MetaForm)result.clone();
    }

    private MetaForm setKeyAndCaption(MetaForm module, String key, String caption) {
        MetaForm newMetaForm = (MetaForm)module.clone();
        newMetaForm.setKey(key);
        newMetaForm.setCaption(caption);
        newMetaForm.setExtend(module.getKey());
        newMetaForm.doPostProcess(0, null);
        return newMetaForm;
    }

    private String saveMetaForm(MetaForm module) throws Throwable {
        String solutionPath = LoadFileTree.getPathByFormKey(this.associationForm);
        DefaultVestCreator defaultVestCreator = new DefaultVestCreator(this.formKey, this.formCaption, solutionPath);
        String vestXml = defaultVestCreator.createVestXml(this.associationForm, StringUtils.equals((CharSequence)this.MergeToSource, (CharSequence)"1"));
        if (!StringUtils.equals((CharSequence)this.MergeToSource, (CharSequence)"1")) {
            String refObjectKey = "";
            MetaFormList metaFormList = MetaFactory.getGlobalInstance().getMetaFormList();
            for (MetaFormProfile metaFormProfile : metaFormList) {
                Boolean mergeToSource;
                if (metaFormProfile == null || !(mergeToSource = metaFormProfile.getMergeToSource()).booleanValue() || !this.associationForm.equals(metaFormProfile.getExtend())) continue;
                MetaForm form = metaFormProfile.getForm();
                String filePath = LoadFileTree.getPathByFormKey(form.getKey());
                String tmpFilePath = XmlFileProcessor.instance.getTmpFile(filePath);
                if (tmpFilePath != null) {
                    filePath = tmpFilePath;
                }
                DefaultVestCreator defaultVestCreator1 = new DefaultVestCreator(this.formKey, this.formCaption, filePath);
                vestXml = defaultVestCreator1.createVestXml(this.associationForm, StringUtils.equals((CharSequence)this.MergeToSource, (CharSequence)"1"));
                refObjectKey = form.getDataSource().getDataObject().getKey();
                break;
            }
            String pathByDataObject = LoadFileTree.getPathByDataObject(refObjectKey);
            if (pathByDataObject != null && !pathByDataObject.isEmpty()) {
                XmlTree parse = XmlParser.parse(vestXml);
                TagNode dataSource = parse.getRoot().getOrCreateChildByTagName("DataSource");
                TagNode parentTagNode = dataSource.getParent();
                int lineByIndex = parse.getLineByIndex(parentTagNode.getElement().getBgIndex());
                String xml = DesignIOMetaUtil.getXml(parentTagNode);
                parse.getRoot().deleteChildByTagName("DataSource");
                String xml1 = DesignIOMetaUtil.getXml(parse.getRoot());
                ReplaceStringEntry replaceStringEntry = new ReplaceStringEntry();
                vestXml = CheckXMLChanged.mergeXML(vestXml, lineByIndex, xml, xml1, replaceStringEntry, false);
            }
            return vestXml;
        }
        String refObjectKey = "";
        if (module.getDataSource() != null) {
            refObjectKey = module.getDataSource().getRefObjectKey();
        }
        if (StringUtils.isBlank((CharSequence)refObjectKey)) {
            return vestXml;
        }
        XmlTree xmlTree = XmlParser.parse(vestXml);
        TagNode rootNode = xmlTree.getRoot();
        rootNode.setAttribute("MergeToSource", "true");
        TagNode dataSource1 = new TagNode("DataSource", null);
        dataSource1.setAttribute("RefObjectKey", this.mergeToSourceMapKey);
        List<AbstractNode> children1 = rootNode.getChildren();
        int index = 0;
        int i = 0;
        while (i < children1.size()) {
            AbstractNode abstractNode = children1.get(i);
            if (abstractNode instanceof TagNode && "DataSource".equals(((TagNode)abstractNode).getTagName())) {
                index = i;
            }
            ++i;
        }
        rootNode.addNode(dataSource1, index);
        String xml1 = DesignIOMetaUtil.getXml(rootNode);
        return "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n" + xml1 + "\n";
    }
}

