/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.cmd.EntryProcessor;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.XMLWriter;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.json.JSONArray;

public class NewEntryItemCmd
extends DesignerServiceCmd {
    public static final String CMD = "NewEntryItem";
    private String subKey;
    private String subCaption;
    private String subVisible;
    private String subEnable;
    private String subIcon;
    private String subOnClick;
    private String subParameters;
    private String subFormKey;
    private String subSingle;
    private String subTarget;
    private String parentKey;
    private String filePath;
    private String sideKey;

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        this.subKey = TypeConvertor.toString((Object)arguments.get((Object)"subKey")).trim();
        this.subCaption = TypeConvertor.toString((Object)arguments.get((Object)"subCaption")).trim();
        this.subVisible = TypeConvertor.toString((Object)arguments.get((Object)"subVisible")).trim();
        this.subEnable = TypeConvertor.toString((Object)arguments.get((Object)"subEnable")).trim();
        this.subIcon = TypeConvertor.toString((Object)arguments.get((Object)"subIcon")).trim();
        this.subOnClick = TypeConvertor.toString((Object)arguments.get((Object)"subOnClick")).trim();
        this.subParameters = TypeConvertor.toString((Object)arguments.get((Object)"subParameters")).trim();
        this.subFormKey = TypeConvertor.toString((Object)arguments.get((Object)"subFormKey")).trim();
        this.subSingle = TypeConvertor.toString((Object)arguments.get((Object)"subSingle")).trim();
        this.subTarget = TypeConvertor.toString((Object)arguments.get((Object)"subTarget")).trim();
        this.parentKey = TypeConvertor.toString((Object)arguments.get((Object)"parentKey")).trim();
        this.filePath = FilePathHelper.toBackFilePath(TypeConvertor.toString((Object)arguments.get((Object)"filePath")).trim());
        this.sideKey = TypeConvertor.toString((Object)arguments.get((Object)"sideKey")).trim();
        if (StringUtils.isEmpty((CharSequence)this.sideKey)) {
            this.sideKey = "last";
        }
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        boolean isInJar = LoadFileTree.getTreeNode((String)this.filePath).isInJar;
        if (isInJar) {
            throw new Exception("\u4e0d\u80fd\u5728jar\u4e2d\u521b\u5efa\u83dc\u5355");
        }
        FileOutputStream fileOutputStream = null;
        XMLWriter writer = null;
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(this.filePath);
            LinkedHashMap<String, String> xmlTreeMapKeys = new LinkedHashMap<String, String>();
            xmlTreeMapKeys.put("root", "/");
            this.getChildElement(document.getRootElement(), xmlTreeMapKeys);
            if (xmlTreeMapKeys.containsKey("EntryItem@" + this.subKey) || xmlTreeMapKeys.containsKey("Entry@" + this.subKey)) {
                return null;
            }
            String path = xmlTreeMapKeys.get("Entry@" + this.parentKey);
            Element node = (Element)document.selectSingleNode(path);
            List elements = node.elements();
            Element element = DocumentHelper.createElement((String)"EntryItem");
            if (StringUtils.isNotEmpty((CharSequence)this.subKey)) {
                element.addAttribute("Key", this.subKey);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.subCaption)) {
                element.addAttribute("Caption", this.subCaption);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.subVisible)) {
                element.addAttribute("Visible", this.subVisible);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.subEnable)) {
                element.addAttribute("Enable", this.subEnable);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.subIcon)) {
                element.addAttribute("Icon", this.subIcon);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.subParameters)) {
                element.addAttribute("Parameters", this.subParameters);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.subFormKey)) {
                element.addAttribute("FormKey", this.subFormKey);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.subSingle)) {
                if (this.subSingle.equals("true")) {
                    if (element.attribute(this.subSingle) != null) {
                        element.remove(element.attribute(this.subSingle));
                    }
                } else {
                    element.addAttribute("Single", this.subSingle);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)this.subTarget)) {
                if (this.subTarget.equals("new")) {
                    if (element.attribute(this.subTarget) != null) {
                        element.remove(element.attribute(this.subTarget));
                    }
                } else {
                    element.addAttribute("Target", this.subTarget);
                }
            }
            element.addAttribute("Type", "Form");
            StringUtils.isNotEmpty((CharSequence)this.subOnClick);
            if (this.sideKey.equals("first")) {
                elements.add(0, element);
            } else if (this.sideKey.equals("last")) {
                elements.add(element);
            } else {
                String side = xmlTreeMapKeys.get("Entry@" + this.sideKey);
                if (StringUtils.isEmpty((CharSequence)side)) {
                    side = xmlTreeMapKeys.get("EntryItem@" + this.sideKey);
                }
                int i = elements.indexOf((Element)document.selectSingleNode(side));
                elements.add(i + 1, element);
            }
            OutputFormat format = DataMapOperXmlUtil.getOutputFormat();
            fileOutputStream = new FileOutputStream(this.filePath);
            writer = new XMLWriter(fileOutputStream, format);
            writer.write(document);
            String[] paths = StringUtils.split((String)this.filePath, (String)File.separator);
            String projectKey = paths[paths.length - 2];
            EntryProcessor.instance.reloadEntry(projectKey);
            ArrayList<UICommand> result = new ArrayList<UICommand>();
            result.add(UICommand.reloadXmlSource(this.filePath));
            result.add(UICommand.reloadMenuTree());
            JSONArray jSONArray = UICommand.toJson(result);
            this.closeFileStream(fileOutputStream, writer);
            return jSONArray;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.closeFileStream(fileOutputStream, writer);
        }
    }

    public void getChildElement(Element element, LinkedHashMap<String, String> xmlTreeMapKeys) {
        String key = element.attributeValue("Key");
        xmlTreeMapKeys.put(String.valueOf(element.getName()) + "@" + key, element.getUniquePath());
        List elements = element.elements();
        if (element != null) {
            for (Element element2 : elements) {
                this.getChildElement(element2, xmlTreeMapKeys);
            }
        }
    }

    private void closeFileStream(FileOutputStream fileOutputStream, XMLWriter writer) {
        try {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        catch (Exception e) {
            LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
        }
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new NewEntryItemCmd();
    }

    public String getCmd() {
        return CMD;
    }
}

