/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class FormulaServiceCmd
extends DesignerServiceCmd {
    public static final String CMD = "FormulaServiceCmd";
    private String type;
    private String formulaFormKey;
    private String searchKey;

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        this.type = TypeConvertor.toString((Object)arguments.get((Object)"type"));
        this.formulaFormKey = arguments.get((Object)"formulaFormKey") != null ? TypeConvertor.toString((Object)arguments.get((Object)"formulaFormKey")) : "";
        this.searchKey = arguments.get((Object)"searchKey") != null ? TypeConvertor.toString((Object)arguments.get((Object)"searchKey")) : "";
    }

    @Override
    public Object innerDoCmd(DefaultContext context) {
        try {
            IMetaFactory metaFactory = context.getVE().getMetaFactory();
            MetaFormList metaFormList = metaFactory.getMetaFormList();
            if ("getFormList".equals(this.type)) {
                JSONArray array = new JSONArray();
                metaFormList.forEach(q -> {
                    JSONObject obj = new JSONObject();
                    obj.put("FormKey", (Object)q.getKey());
                    obj.put("FormCaption", (Object)q.getCaption());
                    array.add((Object)obj);
                });
                return array.toJSONString();
            }
            if ("getForm".equals(this.type)) {
                JSONArray array = new JSONArray();
                metaFormList.forEach(q -> {
                    IDLookup idLookup;
                    Collection<String> keys;
                    if (this.formulaFormKey.equals(q.getKey()) && (keys = (idLookup = IDLookup.getIDLookup(q.getForm())).getFieldKeys()) != null && !keys.isEmpty()) {
                        ArrayList<String> list = new ArrayList<String>(keys);
                        Collections.sort(list);
                        String caption = "";
                        for (String key : list) {
                            if (!StringUtils.isNotEmpty((CharSequence)key) || !StringUtils.isNotEmpty((CharSequence)key)) continue;
                            caption = idLookup.getFieldCaption(key);
                            if (StringUtils.isEmpty((CharSequence)caption)) {
                                if (idLookup.getGridCellByKey(key) != null) {
                                    caption = idLookup.getGridCellByKey(key).getCaption();
                                }
                                if (StringUtils.isEmpty((CharSequence)caption) && idLookup.getListViewColumnByKey(key) != null) {
                                    caption = idLookup.getListViewColumnByKey(key).getCaption();
                                }
                            }
                            JSONObject obj = new JSONObject();
                            obj.put("Key", (Object)key);
                            obj.put("Caption", (Object)caption);
                            array.add((Object)obj);
                        }
                    }
                });
                return array.toJSONString();
            }
            if ("searchFormCaptionByKey".equals(this.type)) {
                JSONArray array = new JSONArray();
                for (MetaFormProfile metaFormProfile : metaFormList) {
                    if (!metaFormProfile.getForm().getKey().equals(this.searchKey)) continue;
                    JSONObject obj = new JSONObject();
                    obj.put("FormKey", (Object)metaFormProfile.getForm().getKey());
                    obj.put("FormCaption", (Object)metaFormProfile.getForm().getCaption());
                    array.add((Object)obj);
                    break;
                }
                return array.toJSONString();
            }
        }
        catch (Throwable e) {
            ExceptionUtils.getStackTrace((Throwable)e);
        }
        return null;
    }

    public String getCmd() {
        return CMD;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new FormulaServiceCmd();
    }
}

