/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.alibaba.fastjson.JSON;
import com.bokesoft.erp.all.initiator.InitializingDesigner;
import com.bokesoft.erp.desigerfunction.datasource.GenerateFunctionsJsonFile;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.codemirror.GenerateFrontFunsFromXml;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.design.vo.Exp;
import com.bokesoft.yes.design.vo.Para;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.cache.CacheFactory;
import com.bokesoft.yigo.cache.ICache;
import com.bokesoft.yigo.meta.common.MetaMacro;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONObject;
import org.springframework.scheduling.annotation.Async;

public class ExpAutoCompleteCmd
extends DesignerServiceCmd {
    private static final Logger logger = Logger.getLogger(ExpAutoCompleteCmd.class.getName());
    public static final String CMD = "ExpAutoComplete";
    public static final String FRONT_JSON_FILE = "/json/frontFuns.json";
    public static final String SPACE = " ";
    public static final String DESIGNER = "designer";
    public static String formulaKeys = "designer";
    public String dataType;
    public String currentFormKey;
    private List<String> funcList;
    private List<String> funcDescList;
    private List<String> componentIdList;
    private List<String> componentDescList;
    private List<String> macroIdList;
    private List<String> macroDescList;
    private List<String> paramDescList;
    private List<String> returnValueDescList;
    private final StringBuffer keyWords = new StringBuffer();
    private static JSONObject funsDetailDtl;
    private static Map<String, String> map;
    private static ICache<Object> cache;
    public static final String cacheKey = "ERP_FormulaDataSource";
    private static Pattern INCLUCHINESE_PATTERN;

    static {
        INCLUCHINESE_PATTERN = Pattern.compile("[\u4e00-\u9fa5]");
    }

    public static void generateFunctionCache() {
        cache = CacheFactory.getInstance().createCache(cacheKey);
        map = null;
        try {
            formulaKeys = InitializingDesigner.isEnable() ? "designer," + StringUtils.join(InitializingDesigner.getFormulaKeys(), (String)",") : StringUtils.join(InitializingDesigner.getFormulaKeys(), (String)",");
            funsDetailDtl = ExpAutoCompleteCmd.readFunsFromJsonFile(formulaKeys);
        }
        catch (Throwable throwable) {
            logger.warning(throwable.getMessage());
        }
    }

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        this.dataType = (String)arguments.get((Object)"dataType");
        this.currentFormKey = (String)arguments.get((Object)"currentFormKey");
        String fk = (String)arguments.get((Object)"formulaKeys");
        formulaKeys = StringUtils.isNotEmpty((CharSequence)fk) ? fk : DESIGNER;
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        JSONObject jsonObject = new JSONObject();
        try {
            if (StringUtils.isEmpty((CharSequence)this.dataType)) {
                return jsonObject.toString();
            }
            this.asyncSetFormList(context);
            if (this.dataType.equals("initKeyWords")) {
                StringBuffer keyWordsBuffer = new StringBuffer((String)((List)((HashMap)cache.get(DESIGNER)).get("keyWords")).get(0));
                jsonObject.append("keyWords", (Object)keyWordsBuffer.toString());
                return jsonObject.toString();
            }
            switch (this.dataType) {
                case "function": {
                    funsDetailDtl = ExpAutoCompleteCmd.readFunsFromJsonFile(formulaKeys);
                    this.setFunctionList(jsonObject);
                    break;
                }
                case "macro": {
                    this.putMacrosIntoList(context);
                    if (StringUtils.isNotEmpty((CharSequence)this.currentFormKey)) {
                        this.putFormMacrosIntoList(this.currentFormKey);
                    }
                    this.setMacrosList(jsonObject);
                    break;
                }
                case "form": {
                    if (!StringUtils.isNotEmpty((CharSequence)this.currentFormKey)) break;
                    this.putPageFieldsToList(context, this.currentFormKey);
                    this.setComponentList(jsonObject);
                }
            }
            this.setKeyWords(jsonObject);
        }
        catch (Throwable throwable) {
            logger.warning(ExceptionUtils.getStackTrace((Throwable)throwable));
            throw new Throwable(throwable.getMessage());
        }
        return jsonObject.toString();
    }

    @Async
    void asyncSetFormList(DefaultContext context) throws Throwable {
        ArrayList formKeyList = new ArrayList();
        ArrayList formCaptionList = new ArrayList();
        IMetaFactory metaFactory = context.getVE().getMetaFactory();
        MetaFormList metaFormList = metaFactory.getMetaFormList();
        metaFormList.forEach(q -> {
            String FormKey = q.getKey();
            String FormCaption = q.getCaption();
            formKeyList.add(FormKey);
            formCaptionList.add(FormCaption);
        });
        cache.put("FormKeyList", formKeyList);
        cache.put("formCaptionList", formCaptionList);
    }

    private void setFunctionList(JSONObject jsonObject) {
        if (!funsDetailDtl.isEmpty()) {
            HashMap formulas = (HashMap)JSON.parseObject((String)funsDetailDtl.get("formulas").toString(), HashMap.class);
            for (Map.Entry entry : formulas.entrySet()) {
                HashMap m = (HashMap)JSON.parseObject((String)entry.getValue().toString(), HashMap.class);
                List funcList = JSON.parseArray((String)((String)JSON.parseArray((String)m.get("funcList").toString(), String.class).get(0)), String.class);
                List funcDescList = JSON.parseArray((String)((String)JSON.parseArray((String)m.get("funcDescList").toString(), String.class).get(0)), String.class);
                List paramDescList = JSON.parseArray((String)((String)JSON.parseArray((String)m.get("paramDescList").toString(), String.class).get(0)), String.class);
                List returnValueDescList = JSON.parseArray((String)((String)JSON.parseArray((String)m.get("returnValueDescList").toString(), String.class).get(0)), String.class);
                if (DESIGNER.equals(entry.getKey())) {
                    jsonObject.append("funcList", (Object)StringUtils.join((Object[])funcList.toArray(), (String)"@~@"));
                    jsonObject.append("funcDescList", (Object)StringUtils.join((Object[])funcDescList.toArray(), (String)"@~@"));
                    jsonObject.append("paramDescList", (Object)StringUtils.join((Object[])paramDescList.toArray(), (String)"@~@"));
                    jsonObject.append("returnValueDescList", (Object)StringUtils.join((Object[])returnValueDescList.toArray(), (String)"@~@"));
                    continue;
                }
                JSONObject jsonObject1 = new JSONObject();
                jsonObject.put((String)entry.getKey(), (Object)jsonObject1);
                jsonObject1.append("funcList", (Object)StringUtils.join((Object[])funcList.toArray(), (String)"@~@"));
                jsonObject1.append("funcDescList", (Object)StringUtils.join((Object[])funcDescList.toArray(), (String)"@~@"));
                jsonObject1.append("paramDescList", (Object)StringUtils.join((Object[])paramDescList.toArray(), (String)"@~@"));
                jsonObject1.append("returnValueDescList", (Object)StringUtils.join((Object[])returnValueDescList.toArray(), (String)"@~@"));
            }
        }
    }

    private void setMacrosList(JSONObject jsonObject) {
        jsonObject.append("macroIdList", (Object)StringUtils.join((Object[])this.macroIdList.toArray(), (String)"@~@"));
        jsonObject.append("macroDescList", (Object)StringUtils.join((Object[])this.macroDescList.toArray(), (String)"@~@"));
        cache.put("macroIdList", this.macroIdList);
        cache.put("macroDescList", this.macroDescList);
    }

    private void setComponentList(JSONObject jsonObject) {
        jsonObject.append("componentIdList", (Object)StringUtils.join((Object[])this.componentIdList.toArray(), (String)"@~@"));
        jsonObject.append("componentDescList", (Object)StringUtils.join((Object[])this.componentDescList.toArray(), (String)"@~@"));
        cache.put("componentIdList", this.componentIdList);
        cache.put("componentDescList", this.componentDescList);
    }

    private void setKeyWords(JSONObject jsonObject) {
        if (!funsDetailDtl.isEmpty()) {
            HashMap formulas = (HashMap)JSON.parseObject((String)funsDetailDtl.get("formulas").toString(), HashMap.class);
            for (Map.Entry entry : formulas.entrySet()) {
                HashMap m = (HashMap)JSON.parseObject((String)entry.getValue().toString(), HashMap.class);
                Object[] keyWordsArray = JSON.parseArray((String)m.get("keyWords").toString(), String.class).toArray(new String[0]);
                StringBuilder keyWords = new StringBuilder();
                keyWords.append(StringUtils.join((Object[])keyWordsArray, (String)SPACE));
                if (DESIGNER.equals(entry.getKey()) || "form".equals(this.dataType) || "macro".equals(this.dataType)) {
                    jsonObject.append("keyWords", (Object)keyWords.toString());
                    continue;
                }
                JSONObject o = (JSONObject)jsonObject.get((String)entry.getKey());
                o.append("keyWords", (Object)keyWords.toString());
            }
        }
    }

    private void putMacrosIntoList(DefaultContext context) {
        this.macroIdList = new ArrayList<String>();
        this.macroDescList = new ArrayList<String>();
        Map<String, String> macroMap = this.getCommonDefMacro(context);
        if (macroMap != null && !macroMap.isEmpty()) {
            Map resultMap = macroMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
            for (Map.Entry entry : resultMap.entrySet()) {
                if (this.macroIdList.contains(entry.getKey())) continue;
                this.macroIdList.add((String)entry.getKey());
                if (this.keyWords.indexOf((String)entry.getKey()) != -1) {
                    this.keyWords.append((String)entry.getKey()).append(SPACE);
                }
                this.macroDescList.add((String)entry.getValue());
            }
        }
    }

    private void putFormMacrosIntoList(String formKey) throws Throwable {
        HashMap<String, String> macroMap = new HashMap<String, String>();
        IMetaFactory iMetaFactory = MetaFactory.getGlobalInstance();
        MetaFormList metaFormList = iMetaFactory.getMetaFormList();
        if (metaFormList != null && !metaFormList.isEmpty()) {
            MetaFormProfile metaFormProfile = (MetaFormProfile)metaFormList.get(formKey);
            MetaProject metaProject = (MetaProject)metaFormProfile.getForm().getProject();
            MetaCommonDef metaCommonDef = iMetaFactory.getCommonDef(metaProject.getKey());
            if (metaCommonDef != null) {
                this.setMacroMap(macroMap, metaCommonDef.getMacroCollection());
            }
            MetaMacroCollection metaMacroCollection = metaFormProfile.getForm().getMacroCollection();
            this.setMacroMap(macroMap, metaMacroCollection);
        }
        if (macroMap != null && !macroMap.isEmpty()) {
            Map resultMap = macroMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
            for (Map.Entry entry : resultMap.entrySet()) {
                this.macroIdList.add((String)entry.getKey());
                if (this.keyWords.indexOf((String)entry.getKey()) != -1) {
                    this.keyWords.append((String)entry.getKey()).append(SPACE);
                }
                this.macroDescList.add((String)entry.getValue());
            }
        }
    }

    private void putPageFieldsToList(DefaultContext context, String currentFormKeys) {
        try {
            this.componentIdList = new ArrayList<String>();
            this.componentDescList = new ArrayList<String>();
            String[] stringArray = currentFormKeys.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String currentFormKey = stringArray[n2];
                IMetaFactory metaFactory = context.getVE().getMetaFactory();
                MetaForm metaForm = metaFactory.getMetaForm(currentFormKey);
                if (metaForm != null) {
                    IDLookup idLookup;
                    Collection<String> keys;
                    this.componentIdList.add(metaForm.getKey());
                    this.componentDescList.add(metaForm.getCaption());
                    if (this.keyWords.indexOf(metaForm.getKey()) != -1) {
                        this.keyWords.append(metaForm.getKey()).append(SPACE);
                    }
                    if ((keys = (idLookup = IDLookup.getIDLookup(metaForm)).getFieldKeys()) != null && !keys.isEmpty()) {
                        ArrayList<String> list = new ArrayList<String>(keys);
                        Collections.sort(list);
                        String caption = "";
                        for (String key : list) {
                            if (!StringUtils.isNotEmpty((CharSequence)key) || !StringUtils.isNotEmpty((CharSequence)key) || this.componentIdList.contains(key)) continue;
                            this.componentIdList.add(key);
                            if (this.keyWords.indexOf(key) != -1) {
                                this.keyWords.append(key).append(SPACE);
                            }
                            if (StringUtils.isEmpty((CharSequence)(caption = idLookup.getFieldCaption(key)))) {
                                if (idLookup.getGridCellByKey(key) != null) {
                                    caption = idLookup.getGridCellByKey(key).getCaption();
                                }
                                if (StringUtils.isEmpty((CharSequence)caption) && idLookup.getListViewColumnByKey(key) != null) {
                                    caption = idLookup.getListViewColumnByKey(key).getCaption();
                                }
                            }
                            this.componentDescList.add(caption);
                        }
                    }
                }
                ++n2;
            }
        }
        catch (Throwable e) {
            logger.warning("\u5c06\u5f53\u524d\u8868\u5355\u7684key\u548ccaption\u653e\u5230\u81ea\u52a8\u5b8c\u6210\u5217\u8868\u4e2d\u5931\u8d25,\u5f02\u5e38\u4e3a\uff1a" + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private Map<String, String> getCommonDefMacro(DefaultContext context) {
        HashMap<String, String> macroMap = new HashMap<String, String>(10000);
        try {
            IMetaFactory metaFactory = context.getVE().getMetaFactory();
            ThreadPoolExecutor executorService = new ThreadPoolExecutor(2, 2, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            CountDownLatch countDownLatch = new CountDownLatch(2);
            Future<Map> commonMacro = executorService.submit(() -> {
                HashMap<String, String> map = new HashMap<String, String>();
                try {
                    try {
                        MetaCommonDef metaCommonDef = metaFactory.getCommonDef("");
                        if (metaCommonDef != null) {
                            this.setMacroMap(map, metaCommonDef.getMacroCollection());
                        }
                    }
                    catch (Throwable throwable) {
                        logger.warning(ExceptionUtils.getStackTrace((Throwable)throwable));
                        countDownLatch.countDown();
                    }
                }
                finally {
                    countDownLatch.countDown();
                }
                return map;
            });
            Future<Map> formsMacro = executorService.submit(() -> {
                HashMap<String, String> map = new HashMap<String, String>();
                try {
                    try {
                        IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
                        MetaFormList metaFormList = globalInstance.getMetaFormList();
                        if (metaFormList != null && !metaFormList.isEmpty()) {
                            for (MetaFormProfile metaFormProfile : metaFormList) {
                                MetaForm form = globalInstance.getMetaForm(metaFormProfile.getKey());
                                MetaProject metaProject = (MetaProject)form.getProject();
                                MetaCommonDef metaCommonDef = metaFactory.getCommonDef(metaProject.getKey());
                                if (metaCommonDef != null) {
                                    this.setMacroMap(map, metaCommonDef.getMacroCollection());
                                }
                                MetaMacroCollection metaMacroCollection = form.getMacroCollection();
                                this.setMacroMap(map, metaMacroCollection);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        logger.warning(ExceptionUtils.getStackTrace((Throwable)throwable));
                        countDownLatch.countDown();
                    }
                }
                finally {
                    countDownLatch.countDown();
                }
                return map;
            });
            countDownLatch.await();
            macroMap.putAll(commonMacro.get());
            macroMap.putAll(formsMacro.get());
        }
        catch (Throwable e) {
            logger.warning("\u83b7\u53d6\u5b8f\u8868\u8fbe\u5f0f\u5217\u8868\u5931\u8d25,\u5f02\u5e38\u4e3a\uff1a" + ExceptionUtils.getStackTrace((Throwable)e));
        }
        return macroMap;
    }

    private void setMacroMap(Map<String, String> macroMap, MetaMacroCollection macroCollection) {
        if (macroCollection != null && !macroCollection.isEmpty()) {
            String args = "";
            String key = "";
            String value = "";
            for (MetaMacro metaMacro : macroCollection) {
                args = metaMacro.getArgs();
                key = StringUtils.isNotEmpty((CharSequence)args) ? String.valueOf(metaMacro.getKey()) + "(" + args + ")" : String.valueOf(metaMacro.getKey()) + "()";
                value = metaMacro.getContent();
                macroMap.put(key, value);
            }
        }
    }

    private static JSONObject readFunsFromJsonFile(String formulaKeys) throws Throwable {
        JSONObject jsonObject = new JSONObject();
        JSONObject objects = new JSONObject();
        jsonObject.put("formulas", (Object)objects);
        InputStream inputStream = null;
        Reader reader = null;
        BufferedReader bufferedReader = null;
        Set formulaKeyCollect = Arrays.stream(formulaKeys.split(",")).collect(Collectors.toSet());
        try {
            try {
                for (String s : formulaKeyCollect) {
                    HashMap dataSource;
                    if ("macro".equalsIgnoreCase(s) || "form".equalsIgnoreCase(s)) continue;
                    ArrayList<String> funcList = new ArrayList<String>();
                    ArrayList<String> funcDescList = new ArrayList<String>();
                    ArrayList<String> paramDescList = new ArrayList<String>();
                    ArrayList<String> returnValueDescList = new ArrayList<String>();
                    StringBuilder keyWords = new StringBuilder();
                    Map tempMap = Collections.emptyMap();
                    Object o = cache.get(s);
                    if (o != null) {
                        dataSource = (HashMap)o;
                    } else {
                        StringBuffer jsonFileContent;
                        dataSource = new HashMap();
                        if (!DESIGNER.equals(s)) {
                            jsonFileContent = new StringBuffer(GenerateFrontFunsFromXml.generateFrontFunsJson(s));
                            tempMap = (Map)JSON.parse((String)jsonFileContent.toString().trim());
                        } else if (InitializingDesigner.isEnable()) {
                            jsonFileContent = new StringBuffer();
                            inputStream = ExpAutoCompleteCmd.class.getResourceAsStream(FRONT_JSON_FILE);
                            reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                            bufferedReader = new BufferedReader(reader);
                            String read = "";
                            while ((read = bufferedReader.readLine()) != null) {
                                jsonFileContent.append(String.valueOf(read) + "\n");
                            }
                            tempMap = (Map)JSON.parse((String)jsonFileContent.toString().trim());
                            Map parse = (Map)JSON.parse((String)GenerateFunctionsJsonFile.getFunctionsJson().trim());
                            tempMap.putAll(parse);
                        }
                        if (tempMap != null) {
                            tempMap.isEmpty();
                        }
                        map = tempMap;
                        keyWords.append((String)tempMap.get("keyWords"));
                        ExpAutoCompleteCmd.getAutoCompletedListFromMap(funcList, funcDescList, paramDescList, returnValueDescList);
                        dataSource.put("funcList", funcList);
                        dataSource.put("funcDescList", funcDescList);
                        dataSource.put("paramDescList", paramDescList);
                        dataSource.put("returnValueDescList", returnValueDescList);
                        ArrayList<String> keyWordArr = new ArrayList<String>();
                        keyWordArr.add(keyWords.toString());
                        dataSource.put("keyWords", keyWordArr);
                        cache.put(s, dataSource);
                    }
                    JSONObject jsonObject1 = new JSONObject();
                    jsonObject1.append("funcList", dataSource.get("funcList"));
                    jsonObject1.append("funcDescList", dataSource.get("funcDescList"));
                    jsonObject1.append("paramDescList", dataSource.get("paramDescList"));
                    jsonObject1.append("returnValueDescList", dataSource.get("returnValueDescList"));
                    jsonObject1.append("keyWords", ((List)dataSource.get("keyWords")).get(0));
                    objects.put(s, (Object)jsonObject1);
                }
            }
            catch (Throwable e) {
                throw new Throwable(e.getMessage());
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    logger.warning("close bufferedReader exception:" + ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.warning("close reader exception:" + ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.warning("close inputStream exception:" + ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        return jsonObject;
    }

    private static void getAutoCompletedListFromMap(List<String> funcList, List<String> funcDescList, List<String> paramDescList, List<String> returnValueDescList) {
        if (map != null) {
            Map resultMap = map.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
            StringBuffer paraHintDesc = new StringBuffer();
            for (String key : resultMap.keySet()) {
                Matcher matcher;
                if ("keyWords".equals(key) || (matcher = INCLUCHINESE_PATTERN.matcher(key)).find()) continue;
                funcList.add(key);
                Exp exp = (Exp)JSON.parseObject((String)JSON.toJSONString(resultMap.get(key)), Exp.class);
                String detail = exp.getDescDetail();
                detail = StringUtils.isNotEmpty((CharSequence)detail) ? detail.replaceAll("aaaaaaaaaa", "{").replaceAll("bbbbbbbbbb", "}").replaceAll("null", "") : "";
                funcDescList.add(StringUtils.isNotEmpty((CharSequence)exp.getDesc()) ? String.valueOf(exp.getDesc()) + SPACE + detail : detail);
                List<Para> paraList = exp.getParas();
                paraHintDesc.setLength(0);
                if (paraList != null && !paraList.isEmpty()) {
                    int i = 0;
                    while (i < paraList.size()) {
                        if (i != paraList.size() - 1) {
                            paraHintDesc.append("\u53c2\u6570" + (i + 1) + SPACE + paraList.get(i).getKey() + ",");
                            paraHintDesc.append("\u53c2\u6570\u7c7b\u578b " + paraList.get(i).getType() + "<br/>");
                        } else {
                            paraHintDesc.append("\u53c2\u6570" + (i + 1) + SPACE + paraList.get(i).getKey() + ",");
                            paraHintDesc.append("\u53c2\u6570\u7c7b\u578b " + paraList.get(i).getType());
                        }
                        ++i;
                    }
                }
                paramDescList.add(paraHintDesc.toString());
                StringBuilder returnValueStringBuilder = new StringBuilder();
                returnValueStringBuilder.append(exp.getReturnValueType());
                returnValueStringBuilder.append(StringUtils.isNotEmpty((CharSequence)exp.getReturnValueType()) ? SPACE : "");
                returnValueStringBuilder.append(StringUtils.isNotEmpty((CharSequence)exp.getReturnValueDesc()) ? exp.getReturnValueDesc() : "");
                returnValueDescList.add(returnValueStringBuilder.toString());
            }
        }
    }

    public String getCmd() {
        return CMD;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new ExpAutoCompleteCmd();
    }
}

