/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.cmd.EntryProcessor;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil;
import com.bokesoft.yes.design.utils.XMLWriter;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.json.JSONArray;

public class DeleteEntryCmd
extends DesignerServiceCmd {
    public static final String CMD = "DeleteEntry";
    private String subKey;
    private String subType;
    private String parentKey;
    private String filePath;

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        this.subKey = TypeConvertor.toString((Object)arguments.get((Object)"subKey"));
        this.parentKey = TypeConvertor.toString((Object)arguments.get((Object)"parentKey"));
        this.filePath = FilePathHelper.toBackFilePath(TypeConvertor.toString((Object)arguments.get((Object)"filePath")));
        this.subType = TypeConvertor.toString((Object)arguments.get((Object)"subType"));
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        FileOutputStream fileOutputStream = null;
        XMLWriter writer = null;
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(this.filePath);
            LinkedHashMap<String, String> xmlTreeMapKeys = new LinkedHashMap<String, String>();
            this.getChildElement(document.getRootElement(), xmlTreeMapKeys);
            String path = xmlTreeMapKeys.get("Entry@" + (StringUtils.isNotBlank((CharSequence)this.parentKey) ? this.parentKey : "root"));
            Element node = (Element)document.selectSingleNode(path);
            List elements = node.elements();
            Element deleteNode = (Element)document.selectSingleNode(xmlTreeMapKeys.get(String.valueOf(this.subType) + "@" + this.subKey));
            elements.remove(deleteNode);
            OutputFormat format = DataMapOperXmlUtil.getOutputFormat();
            fileOutputStream = new FileOutputStream(this.filePath);
            writer = new XMLWriter(fileOutputStream, format);
            writer.write(document);
            String[] paths = StringUtils.split((String)this.filePath, (String)File.separator);
            String projectKey = paths[paths.length - 2];
            EntryProcessor.instance.reloadEntry(projectKey);
            ArrayList<UICommand> result = new ArrayList<UICommand>();
            result.add(UICommand.reloadXmlSource(this.filePath));
            result.add(UICommand.reloadMenuTree());
            JSONArray jSONArray = UICommand.toJson(result);
            this.closeFileStream(fileOutputStream, writer);
            return jSONArray;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                this.closeFileStream(fileOutputStream, writer);
                throw throwable;
            }
        }
    }

    private void closeFileStream(FileOutputStream fileOutputStream, XMLWriter writer) {
        try {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        catch (Exception e) {
            LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
        }
    }

    public void getChildElement(Element element, LinkedHashMap<String, String> xmlTreeMapKeys) {
        String key = element.attributeValue("Key");
        xmlTreeMapKeys.put(String.valueOf(element.getName()) + "@" + key, element.getUniquePath());
        List elements = element.elements();
        if (element != null) {
            for (Element element2 : elements) {
                this.getChildElement(element2, xmlTreeMapKeys);
            }
        }
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new DeleteEntryCmd();
    }

    public String getCmd() {
        return CMD;
    }
}

