/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.MetaObjectType;
import com.bokesoft.yes.design.cmd.Line;
import com.bokesoft.yes.design.cmd.NewFormCmd;
import com.bokesoft.yes.design.cmd.ReplaceStringEntry;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.utils.MetaUtils;
import com.bokesoft.yes.design.xml.XmlParser;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.node.XmlTree;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.form.MetaForm;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;

public class CheckXMLChanged {
    public static boolean checkXMLChanged(String content, int line, String orgFragment, String newFragment) {
        String result = CheckXMLChanged.mergeXML(content, line, orgFragment, newFragment, null, true);
        return true;
    }

    public static String mergeXML(String content, int lineIndex, String orgFragment, String newFragment, ReplaceStringEntry entry, boolean insertIndent) {
        content = content.replaceAll("\r\n", "\n").replaceAll("\n", "\r\n");
        Line line = CheckXMLChanged.getLine(content, lineIndex);
        if (StringUtils.isBlank((CharSequence)orgFragment)) {
            throw new RuntimeException("\u8fd9\u4e2a\u64cd\u4f5c\u76ee\u524d\u4e0d\u652f\u6301\u6216\u6ca1\u6709\u5f15\u8d77Xml\u6e90\u4ee3\u7801\u5b9e\u8d28\u53d8\u5316\uff0c\u53ef\u76f4\u63a5\u4fee\u6539Xml\u6e90\u4ee3\u7801\u3002");
        }
        String orgFragmentWithPrefix = orgFragment;
        String newFragmentWithPrefix = newFragment;
        if (entry != null) {
            orgFragment = orgFragment.trim();
            newFragment = newFragment.trim();
            orgFragment = orgFragment.replaceAll("\r\n", "\n").replaceAll("\n", "\r\n");
            newFragment = newFragment.replaceAll("\r\n", "\n").replaceAll("\n", "\r\n");
            if (!orgFragment.startsWith(line.content.trim())) {
                throw new RuntimeException("\u5185\u5bb9\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7248\u672c\u3002");
            }
            String indent = DesignIOMetaUtil.getSubString(line.content, "^(\\s*)<");
            orgFragmentWithPrefix = String.valueOf(indent) + orgFragment;
            newFragmentWithPrefix = String.valueOf(indent) + (insertIndent ? newFragment.replaceAll("\n", "\n" + indent) : newFragment);
        }
        StringBuilder sb = new StringBuilder(content.length() - orgFragment.length() + newFragmentWithPrefix.length());
        if (line.content.equals("<CommonDef>") || line.content.startsWith("<Setting") || line.content.startsWith("<ParaTable>") || line.content.startsWith("<Parameter>") || line.content.equals("<RightsDefinition>") || line.content.equals("<Enhance>") || line.content.equals("<DataElementDef>") || line.content.equals("<DomainDef>") || line.content.equals("<IOSetting>") || line.content.startsWith("<Solution")) {
            sb.append(content, 0, line.pos).append(newFragmentWithPrefix);
        } else {
            sb.append(content, 0, line.pos).append(newFragmentWithPrefix);
            int beginIndex = line.pos + orgFragmentWithPrefix.length();
            if (beginIndex < content.length()) {
                sb.append(content.substring(beginIndex));
            }
        }
        if (entry != null) {
            entry.orgString = orgFragmentWithPrefix;
            entry.newString = newFragmentWithPrefix;
        }
        return sb.toString();
    }

    public static void mergerSortedXml(Diff diff, String tempFilePath, String projectKey, String oldXml) throws Throwable {
        XmlTree xmlTree = XmlParser.parse(oldXml);
        TagNode root = XmlParser.parse(oldXml).getRoot();
        String tagName = root.getTagName();
        if (tagName.equals(MetaObjectType.DataObject.toString())) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)root.getAttributes().get("Extend"))) {
            return;
        }
        MetaForm metaForm1 = NewFormCmd.loadMetaFormByPath(tempFilePath, projectKey);
        String sortXml = MetaUtils.getNewXml(tempFilePath, metaForm1, null);
        XmlTree sortXmlTree = XmlParser.parse(sortXml);
        TagNode sortTagNode = (TagNode)sortXmlTree.getMapNodes().get(String.valueOf(ControlType.toString((Integer)diff.controlType)) + "@" + diff.getKey());
        if (sortTagNode == null) {
            return;
        }
        TagNode tagNode = (TagNode)xmlTree.getMapNodes().get(String.valueOf(ControlType.toString((Integer)diff.controlType)) + "@" + diff.getKey());
        TagNode parent = tagNode.getParent();
        if (parent != null) {
            int index = parent.getChildren().indexOf(tagNode);
            parent.getChildren().remove(index);
            parent.getChildren().add(index, sortTagNode);
        }
        String xml = xmlTree.getRoot().toXml(0, false);
        xml = RegExUtils.replaceAll((String)xml, (String)"[\r\n]+(\\s*[\r\n]+)*", (String)"\r\n");
        FileUtils.writeStringToFile((File)new File(tempFilePath), (String)xml, (String)"UTF-8");
    }

    private static Line getLine(String content, int line) {
        int pos = 0;
        int i = 0;
        while (i < line) {
            pos = content.indexOf("\n", pos + 1);
            ++i;
        }
        int pos2 = content.indexOf("\n", pos + 1);
        if (content.substring(pos2 - 1, pos2).equals("\r")) {
            --pos2;
        }
        String lineContent = content.substring(pos + 1, pos2);
        return new Line(pos + 1, lineContent);
    }
}

