/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.cmd.DesignerServiceCmd;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.util.ArrayList;
import java.util.Objects;

public class CheckNumPrecisionCmd
extends DesignerServiceCmd {
    public static final String CMD = "CheckNumPrecision";
    private String tableKey;
    private String columnKey;
    private String formKey;
    private int precision;
    private int columnType;

    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        this.tableKey = TypeConvertor.toString((Object)arguments.get((Object)"tableKey")).trim();
        this.columnKey = TypeConvertor.toString((Object)arguments.get((Object)"columnKey")).trim();
        this.formKey = TypeConvertor.toString((Object)arguments.get((Object)"formKey")).trim();
        this.precision = TypeConvertor.toInteger((Object)arguments.get((Object)"precision"));
        this.columnType = TypeConvertor.toInteger((Object)arguments.get((Object)"columnType"));
    }

    @Override
    public Object innerDoCmd(DefaultContext defaultContext) throws Throwable {
        MetaDataObject metaDataObject = MetaFactory.getGlobalInstance().getDataObject(this.formKey);
        if (metaDataObject == null && (metaDataObject = MetaFactory.getGlobalInstance().getMetaForm(this.formKey).getDataSource().getDataObject()) == null) {
            return null;
        }
        MetaTable metaTable = metaDataObject.getMetaTable(this.tableKey);
        ArrayList<UICommand> result = new ArrayList<UICommand>();
        if (metaTable != null) {
            for (MetaColumn metaColumn : metaTable) {
                if (!metaColumn.getKey().equals(this.columnKey)) continue;
                Integer metaPrecision = metaColumn.getPrecision();
                if (Objects.isNull(metaPrecision)) {
                    if (this.columnType == 1001) {
                        metaPrecision = 9;
                    }
                    if (this.columnType == 1010) {
                        metaPrecision = 16;
                    }
                }
                if (this.precision > (metaPrecision != null ? metaPrecision : 0)) {
                    result.add(UICommand.showError("\u6570\u503c\u63a7\u4ef6\u7684\u6570\u503c\u7cbe\u5ea6\u4e0d\u5141\u8bb8\u5927\u4e8e\u7ed1\u5b9a\u6570\u636e\u6e90\u7684\u6570\u503c\u7cbe\u5ea6"));
                    return UICommand.toJson(result);
                }
                switch (this.columnType) {
                    case 1005: {
                        if (this.precision == metaPrecision) break;
                        result.add(UICommand.showError("\u7ed1\u5b9a\u6570\u503c\u7c7b\u578b\u7684\u6570\u636e\u6e90\u65f6\uff0c\u6570\u503c\u63a7\u4ef6\u7684\u6570\u503c\u7cbe\u5ea6\u9700\u4e0e\u5176\u4e00\u81f4"));
                        return UICommand.toJson(result);
                    }
                    case 1010: {
                        if (this.precision <= 19) break;
                        result.add(UICommand.showError("\u7ed1\u5b9a\u957f\u6574\u578b\u7684\u6570\u636e\u6e90\u65f6\uff0c\u6570\u503c\u63a7\u4ef6\u7684\u6570\u503c\u7cbe\u5ea6\u9700\u5c0f\u4e8e19"));
                        return UICommand.toJson(result);
                    }
                    case 1001: {
                        if (this.precision <= 9) break;
                        result.add(UICommand.showError("\u7ed1\u5b9a\u6574\u578b\u7684\u6570\u636e\u6e90\u65f6\uff0c\u6570\u503c\u63a7\u4ef6\u7684\u6570\u503c\u7cbe\u5ea6\u9700\u5c0f\u4e8e9"));
                        return UICommand.toJson(result);
                    }
                }
            }
        }
        return null;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new CheckNumPrecisionCmd();
    }

    public String getCmd() {
        return CMD;
    }
}

