/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.bpm.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.bpm.util.ConvertSpecialStringUtil;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.enums.NodeKeyAndCaptionEnum;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.XMLWriter;
import com.bokesoft.yes.meta.persist.dom.bpm.MetaProcessSave;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;

public class BpmOperToJsonUtil {
    private static final Logger logger = Logger.getLogger(BpmOperToJsonUtil.class.getName());
    public static final BpmOperToJsonUtil instance = new BpmOperToJsonUtil();
    private static final String BPM_DIRECTORY = "BPM";
    private static final String XML_EXTENSION = ".xml";
    private static final Stack<String> bpmStack = new Stack();

    public Map<String, String> createXml(String projectKey, String key, String caption, String version) {
        HashMap<String, String> result = new HashMap<String, String>(10);
        result.put("result", "true");
        String filePath = "";
        try {
            if (this.validateForCreateXml(projectKey, key, caption, version, result)) {
                return result;
            }
            int verionNo = Integer.parseInt(version) + 1;
            if (key.contains("_V")) {
                key = String.valueOf(key.substring(0, key.indexOf("_V"))) + "_V" + verionNo;
            } else if (verionNo > 1) {
                key = String.valueOf(key) + "_V" + verionNo;
            }
            boolean a = true;
            while (a) {
                if (!LoadFileTree.isExistKey(key)) {
                    a = false;
                    break;
                }
                key = String.valueOf(key.split("_V")[0]) + "_V" + ++verionNo;
            }
            MetaProcess process = new MetaProcess();
            process.setKey(key);
            process.setCaption(caption);
            result.put("caption", caption);
            process.setVersion(Integer.valueOf(verionNo));
            result.put("version", String.valueOf(verionNo));
            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            IMetaResolver resolver = metaFactory.getProjectResolver(projectKey);
            String newFileName = String.valueOf(key) + XML_EXTENSION;
            MetaProcessSave metaProcessSave = new MetaProcessSave((AbstractMetaObject)process);
            metaProcessSave.save(resolver, String.valueOf(File.separator) + BPM_DIRECTORY + File.separator + newFileName);
            String versionStr = "0".equals(version) ? "" : " Version=\"" + verionNo + "\"";
            filePath = LoadFileTree.newBpmFile(projectKey, newFileName, key, caption);
            String fileContent = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<Process Caption=\"" + caption + "\" Key=\"" + key + "\"" + versionStr + ">\n" + "<Begin ID='1' Key='Begin' Caption='\u8d77\u59cb'>" + "<NodeGraphic X='303' Y='131'/>" + "<TransitionCollection>" + "<SequenceFlow ID='3' Key='SequenceFlow' Caption='\u987a\u5e8f\u6d41' TargetNodeKey='End'/>" + "</TransitionCollection>" + "</Begin>" + "<End ID='2' Key='End' Caption='\u7ed3\u675f'>" + "<NodeGraphic X='303' Y='597'/>" + "</End>" + "\n" + "</Process>";
            XmlFileProcessor.instance.saveTempFile(filePath, fileContent, projectKey);
            result.put("result", "true");
            result.put("filePath", filePath);
            result.put("version", String.valueOf(verionNo));
            result.put("fileName", newFileName.replaceAll(XML_EXTENSION, ""));
        }
        catch (Throwable e) {
            logger.warning("\u65b0\u589exml\u6587\u4ef6\u5f02\u5e38,\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            if (StringUtils.isNotEmpty((CharSequence)filePath)) {
                try {
                    LoadFileTree.removeFilePath(filePath);
                }
                catch (Throwable e1) {
                    logger.warning("\u5220\u9664\u6587\u4ef6\u5f02\u5e38,\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e1));
                }
            }
            result.put("result", "false");
            result.put("filePath", "");
            result.put("msg", e.getMessage());
        }
        return result;
    }

    private boolean validateForCreateXml(String projectKey, String key, String caption, String version, Map<String, String> result) {
        if (StringUtils.isEmpty((CharSequence)projectKey)) {
            result.put("result", "false");
            result.put("filePath", "");
            result.put("msg", "\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a");
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)key)) {
            result.put("result", "false");
            result.put("filePath", "");
            result.put("msg", "\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)caption)) {
            result.put("result", "false");
            result.put("filePath", "\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            result.put("msg", "");
            return true;
        }
        String pattern = "([A-Za-z_]\\w*)";
        boolean isMatch = Pattern.matches(pattern, key);
        if (!isMatch) {
            result.put("result", "false");
            result.put("filePath", "");
            result.put("msg", "\u6807\u8bc6\u4e0d\u6b63\u786e\uff0c\u4e0d\u662f\u5b57\u6bcd\u6216\u4e0b\u5212\u7ebf\u5f00\u59cb\u7684");
            return true;
        }
        if (LoadFileTree.isExistKey(key) && "0".equals(version)) {
            result.put("result", "false");
            result.put("filePath", "");
            result.put("msg", "\u6587\u4ef6'" + key + "'\u5df2\u5b58\u5728");
            return true;
        }
        return false;
    }

    public JSONObject convertXmlToJson(String filePath) throws Throwable {
        JSONObject workFlowJson = new JSONObject();
        String tmpFile = XmlFileProcessor.instance.getTmpFile(filePath);
        if (StringUtils.isBlank((CharSequence)tmpFile)) {
            tmpFile = filePath;
        }
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(tmpFile));
        Element root = document.getRootElement();
        String caption = root.attributeValue("Caption");
        try {
            JSONObject states = new JSONObject();
            JSONObject paths = new JSONObject();
            NodeKeyAndCaptionEnum[] nodeKeyAndCaptionEnumArray = NodeKeyAndCaptionEnum.values();
            int n = nodeKeyAndCaptionEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                NodeKeyAndCaptionEnum value = nodeKeyAndCaptionEnumArray[n2];
                if ("Swimline".equals(value.getKey())) {
                    Element swimlineCollection = root.element("SwimlineCollection");
                    if (swimlineCollection != null) {
                        this.setNodeXmlToJson(swimlineCollection, states, paths, value.getKey());
                    }
                } else {
                    this.setNodeXmlToJson(root, states, paths, value.getKey());
                }
                ++n2;
            }
            this.setOldXmlXAndWidth(states, paths, filePath, document);
            JSONObject workFlowDesc = this.setWorkFlowAttributes(root);
            workFlowJson.put("states", (Object)states);
            workFlowJson.put("paths", (Object)paths);
            workFlowJson.put("props", (Object)workFlowDesc);
            workFlowJson.put("Caption", (Object)caption);
        }
        catch (Throwable e) {
            logger.warning("\u8f6c\u6362xml\u6587\u4ef6\u4e3ajson\u6587\u4ef6\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
        }
        return workFlowJson;
    }

    private void setOldXmlXAndWidth(JSONObject states, JSONObject paths, String filePath, Document document) {
        int x;
        boolean isOldXml = false;
        for (String key : states.keySet()) {
            x = states.getJSONObject(key).getJSONObject("attr").getInteger("x");
            if (x >= 150) continue;
            isOldXml = true;
            break;
        }
        if (isOldXml) {
            int width = 40;
            List<String> nodeKeyList = Arrays.asList("Begin", "End", "BranchEnd");
            for (String key : states.keySet()) {
                String nodeType = states.getJSONObject(key).getJSONObject("props").getJSONObject("NodeType").getString("value");
                x = states.getJSONObject(key).getJSONObject("attr").getInteger("x");
                states.getJSONObject(key).getJSONObject("attr").put("x", (Object)(x + 150));
                boolean isAjustWidth = true;
                for (String k : nodeKeyList) {
                    if (!k.equals(nodeType)) continue;
                    isAjustWidth = false;
                    break;
                }
                if (!isAjustWidth) continue;
                boolean isTaskNode = false;
                List<String> taskKeys = Arrays.asList("UserTask", "ServiceTask", "ManualTask", "Audit", "DataMap", "SubProcess", "Inline", "StateAction", "Countersign", "Swimline", "MultiUserTask", "MultiAudit");
                for (String k : taskKeys) {
                    isTaskNode = k.equals(nodeType);
                    if (isTaskNode) break;
                }
                width = isTaskNode ? (NodeKeyAndCaptionEnum.MultiUserTask.getKey().equals(nodeType) && NodeKeyAndCaptionEnum.MultiAudit.getKey().equals(nodeType) ? Math.max(width, 130) : (NodeKeyAndCaptionEnum.Audit.getKey().equals(nodeType) ? Math.max(width, 100) : Math.max(width, 115))) : Math.max(width, 48);
                states.getJSONObject(key).getJSONObject("attr").put("width", (Object)width);
            }
            for (String key : paths.keySet()) {
                x = paths.getJSONObject(key).getJSONObject("textPos").getInteger("x");
                paths.getJSONObject(key).getJSONObject("textPos").put("x", (Object)(x + 150));
            }
            this.updateOldXmlXAndWidth(nodeKeyList, filePath, document);
        }
    }

    private void updateOldXmlXAndWidth(List<String> nodeKeyList, String filePath, Document document) {
        block10: {
            FileOutputStream fileOutputStream = null;
            XMLWriter writer = null;
            try {
                try {
                    Element root = document.getRootElement();
                    List elements = root.elements();
                    for (Element ele : elements) {
                        List swimlines;
                        boolean isAjustWidth = true;
                        if (ele.element("NodeGraphic") != null) {
                            String pX = ele.element("NodeGraphic").attributeValue("X");
                            ele.element("NodeGraphic").remove(ele.element("NodeGraphic").attribute("X"));
                            ele.element("NodeGraphic").addAttribute("X", String.valueOf(Integer.parseInt(pX) + 150));
                            for (String k : nodeKeyList) {
                                if (!k.equals(ele.getName())) continue;
                                isAjustWidth = false;
                                break;
                            }
                            if (!isAjustWidth) continue;
                            int width_ = ele.attributeValue("Caption").length() * 20;
                            if (ele.element("NodeGraphic").attribute("Width") != null) {
                                ele.element("NodeGraphic").remove(ele.element("NodeGraphic").attribute("Width"));
                            }
                            ele.element("NodeGraphic").addAttribute("Width", String.valueOf(width_));
                        }
                        if (!"SwimlineCollection".equals(ele.getName()) || CollectionUtils.isEmpty((Collection)(swimlines = ele.elements("Swimline")))) continue;
                        for (Element element : swimlines) {
                            StringBuilder postion = new StringBuilder();
                            String[] array1 = element.attributeValue("Position").split(",");
                            String[] array2 = array1[0].split(":");
                            int x_ = Integer.parseInt(array2[1]) + 150;
                            postion.append("X:").append(x_).append(",").append(array1[1]);
                            element.remove(element.attribute("Position"));
                            element.addAttribute("Position", postion.toString());
                        }
                    }
                    OutputFormat format = this.getOutputFormat();
                    fileOutputStream = new FileOutputStream(filePath);
                    writer = new XMLWriter(fileOutputStream, format);
                    writer.write(document);
                }
                catch (Exception e) {
                    ExceptionUtils.getStackTrace((Throwable)e);
                    logger.warning("\u66f4\u65b0xml\u6587\u4ef6\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
                    this.closeFileStream(fileOutputStream, writer);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                this.closeFileStream(fileOutputStream, writer);
                throw throwable;
            }
            this.closeFileStream(fileOutputStream, writer);
        }
    }

    private void closeFileStream(FileOutputStream fileOutputStream, XMLWriter writer) {
        try {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        catch (Exception e) {
            ExceptionUtils.getStackTrace((Throwable)e);
            logger.warning("\u5173\u95edwriter\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private OutputFormat getOutputFormat() {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setNewLineAfterDeclaration(false);
        format.setIndentSize(4);
        format.setExpandEmptyElements(false);
        format.setPadText(false);
        return format;
    }

    private void setNodeXmlToJson(Element root, JSONObject states, JSONObject paths, String nodeName) {
        List joinList = root.elements(nodeName);
        for (Element element : joinList) {
            states.put(element.attributeValue("Key"), (Object)this.getNodeJson(element, nodeName));
            if ("End".equals(nodeName)) continue;
            this.hendleLines(element, paths);
        }
    }

    private JSONObject setWorkFlowAttributes(Element root) {
        List<String> keyList = Arrays.asList("Key", "Caption", "Version", "DMTable", "FormKey", "PermCollection", "IgnoreFormState", "QueryRetreatWorkitem", "TemplateKey", "KillInstanceTrigger", "LockWorkitem", "BPMGraphInfoPath", "WorkFlowHookPath");
        JSONObject workFlowDescSub = new JSONObject();
        for (String key : keyList) {
            String value = root.attributeValue(key);
            boolean isEmpty = value == null || StringUtils.isEmpty((CharSequence)value);
            switch (key) {
                case "DMTable": {
                    value = this.setDMTableJsonFromXml(root, value, key);
                    break;
                }
                case "Version": {
                    if (!isEmpty) break;
                    value = "1";
                    break;
                }
                case "QueryRetreatWorkitem": {
                    if (!isEmpty) break;
                    value = "true";
                    break;
                }
                case "LockWorkitem": {
                    if (!isEmpty) break;
                    value = "false";
                    break;
                }
                case "BPMGraphInfoPath": {
                    value = Objects.isNull(root.element("Expand")) ? "" : root.element("Expand").attributeValue("BPMGraphInfoPath");
                    break;
                }
                case "WorkFlowHookPath": {
                    value = Objects.isNull(root.element("Expand")) ? "" : root.element("Expand").attributeValue("WorkFlowHookPath");
                    break;
                }
                case "PermCollection": {
                    if (root.element("PermCollection") != null) {
                        value = this.setPerm(root.element("PermCollection")).toJSONString();
                    }
                    value = "{}".equals(value) ? "" : value;
                    break;
                }
            }
            JSONObject temp = new JSONObject();
            temp.put("value", (Object)value);
            workFlowDescSub.put(key, (Object)temp);
        }
        JSONObject workFlowDesc = new JSONObject();
        workFlowDesc.put("props", (Object)workFlowDescSub);
        return workFlowDesc;
    }

    private String setDMTableJsonFromXml(Element root, String value, String key) {
        if (root.element(key) != null && root.element(key).elements("Field") != null) {
            List fields = root.element(key).elements("Field");
            JSONArray array = new JSONArray();
            int i = 0;
            while (i < fields.size()) {
                JSONObject jsonDetailObj;
                JSONObject jsonObj = new JSONObject();
                jsonObj.put("id", (Object)(i + 1));
                jsonObj.put("Key", (Object)((Element)fields.get(i)).attributeValue("Key"));
                if (StringUtils.isNotEmpty((CharSequence)((Element)fields.get(i)).attributeValue("Caption"))) {
                    jsonObj.put("Caption", (Object)((Element)fields.get(i)).attributeValue("Caption"));
                } else {
                    jsonObj.put("Caption", (Object)"");
                }
                String type = ((Element)fields.get(i)).attributeValue("Type");
                if (StringUtils.isNotEmpty((CharSequence)type)) {
                    jsonObj.put("Type", (Object)type);
                    jsonObj.put("Value", (Object)((Element)fields.get(i)).attributeValue("ConstValue"));
                } else {
                    jsonObj.put("Type", (Object)"Field");
                    jsonObj.put("Value", (Object)((Element)fields.get(i)).attributeValue("SourceFieldKey"));
                }
                String detail = ((Element)fields.get(i)).attributeValue("Detail");
                if (StringUtils.isNotEmpty((CharSequence)detail)) {
                    jsonDetailObj = JSON.parseObject((String)detail);
                } else {
                    jsonDetailObj = new JSONObject();
                    List<String> keys = Arrays.asList("Key", "Caption", "Type", "ColumnName", "DefaultVaue", "Length", "Precision", "Scale");
                    for (String ele : keys) {
                        if ("Key".equals(ele)) {
                            jsonDetailObj.put(ele, (Object)((Element)fields.get(i)).attributeValue(ele));
                            continue;
                        }
                        jsonDetailObj.put(ele, (Object)"");
                    }
                }
                jsonObj.put("Detail", (Object)jsonDetailObj);
                array.add((Object)jsonObj);
                ++i;
            }
            value = array.toJSONString();
        }
        return value;
    }

    private JSONObject getNodeJson(Element element, String nodeType) {
        JSONObject json = new JSONObject();
        try {
            this.setNodeText(element, json);
            this.setNodeCoordinate(element, nodeType, json);
            json.put("type", (Object)nodeType);
            JSONObject props = this.setCommonAttributes(element);
            if (!NodeKeyAndCaptionEnum.Swimline.getKey().equals(nodeType)) {
                this.setImageAndSoOnAttrbutesFromXml(props, element);
            }
            this.setSelfAttributesFromXml(element, nodeType, props);
            json.put("props", (Object)props);
        }
        catch (Throwable e) {
            logger.warning("\u83b7\u53d6\u8282\u70b9\u7684json\u65b9\u6cd5getNodeJson()\u64cd\u4f5c\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
        }
        return json;
    }

    private void setNodeCoordinate(Element element, String nodeType, JSONObject json) {
        Element nodeGraphic = element.element("NodeGraphic");
        int x = 150;
        int y = 150;
        int height = 48;
        int width = 40;
        if (nodeGraphic != null) {
            x = Integer.parseInt(nodeGraphic.attributeValue("X"));
            y = Integer.parseInt(nodeGraphic.attributeValue("Y"));
            height = StringUtils.isNotEmpty((CharSequence)nodeGraphic.attributeValue("Height")) ? Integer.parseInt(nodeGraphic.attributeValue("Height")) : 48;
            height = Math.max(height, 48);
            boolean isTaskNode = false;
            List<String> taskKeys = Arrays.asList("UserTask", "ServiceTask", "ManualTask", "Audit", "DataMap", "SubProcess", "Inline", "StateAction", "Countersign", "Swimline", "MultiUserTask", "MultiAudit");
            for (String key : taskKeys) {
                isTaskNode = key.equals(nodeType);
                if (isTaskNode) break;
            }
            if (isTaskNode) {
                if (StringUtils.isEmpty((CharSequence)nodeGraphic.attributeValue("Width"))) {
                    width = NodeKeyAndCaptionEnum.MultiUserTask.getKey().equals(nodeType) || NodeKeyAndCaptionEnum.MultiAudit.getKey().equals(nodeType) ? 130 : (NodeKeyAndCaptionEnum.Audit.getKey().equals(nodeType) ? 100 : 115);
                } else {
                    width = Integer.parseInt(nodeGraphic.attributeValue("Width"));
                    width = NodeKeyAndCaptionEnum.MultiUserTask.getKey().equals(nodeType) || NodeKeyAndCaptionEnum.MultiAudit.getKey().equals(nodeType) ? Math.max(width, 130) : (NodeKeyAndCaptionEnum.Audit.getKey().equals(nodeType) ? Math.max(width, 100) : Math.max(width, 115));
                }
            } else {
                width = StringUtils.isEmpty((CharSequence)nodeGraphic.attributeValue("Width")) ? 48 : Integer.parseInt(nodeGraphic.attributeValue("Width"));
            }
        }
        if (NodeKeyAndCaptionEnum.Swimline.getKey().equals(nodeType)) {
            Attribute position = element.attribute("Position");
            x = Integer.parseInt(position.getValue().split(",")[0].split(":")[1]);
            y = Integer.parseInt(position.getValue().split(",")[1].split(":")[1]);
            String size = element.attributeValue("Size");
            width = Integer.parseInt(size.split(",")[0].split(":")[1]);
            height = Integer.parseInt(size.split(",")[1].split(":")[1]);
        }
        JSONObject attr = new JSONObject();
        attr.put("x", (Object)x);
        attr.put("y", (Object)y);
        attr.put("width", (Object)width);
        attr.put("height", (Object)height);
        json.put("attr", (Object)attr);
    }

    private void setNodeText(Element element, JSONObject json) {
        String text = element.attributeValue("Caption");
        JSONObject textJson = new JSONObject();
        textJson.put("text", (Object)text);
        json.put("text", (Object)textJson);
    }

    private void setSelfAttributesFromXml(Element element, String nodeType, JSONObject props) {
        JSONObject value;
        if (NodeKeyAndCaptionEnum.Begin.getKey().equals(nodeType) || NodeKeyAndCaptionEnum.End.getKey().equals(nodeType)) {
            this.setAttributeToJson(element, props, "Status");
        }
        if (NodeKeyAndCaptionEnum.Inline.getKey().equals(nodeType)) {
            this.setAttributeToJson(element, props, "InlineProcessKey");
        }
        if (NodeKeyAndCaptionEnum.Swimline.getKey().equals(nodeType)) {
            this.setSwimline(props, element);
        }
        if (NodeKeyAndCaptionEnum.GateWay.getKey().equals(nodeType) || NodeKeyAndCaptionEnum.Decision.getKey().equals(nodeType)) {
            this.setAttributeToJson(element, props, "Condition");
        }
        if (NodeKeyAndCaptionEnum.ServiceTask.getKey().equals(nodeType)) {
            value = new JSONObject();
            if (element.element("Action") != null) {
                value.put("value", (Object)element.element("Action").getData().toString().trim());
            } else {
                value.put("value", (Object)"");
            }
            props.put("Action", (Object)value);
        }
        if (NodeKeyAndCaptionEnum.ComplexJoin.getKey().equals(nodeType)) {
            this.setAttributeToJson(element, props, "JoinCount");
            value = new JSONObject();
            if (element.element("JoinCondition") != null) {
                value.put("value", (Object)element.element("JoinCondition").getData().toString().trim());
            } else {
                value.put("value", (Object)"");
            }
            props.put("JoinCondition", (Object)value);
        }
        if (NodeKeyAndCaptionEnum.UserTask.getKey().equals(nodeType) || NodeKeyAndCaptionEnum.MultiUserTask.getKey().equals(nodeType) || NodeKeyAndCaptionEnum.Countersign.getKey().equals(nodeType) || NodeKeyAndCaptionEnum.DataMap.getKey().equals(nodeType)) {
            this.setUserTaskAttributesFromXml(props, element, nodeType);
        }
        if (NodeKeyAndCaptionEnum.Audit.getKey().equals(nodeType) || NodeKeyAndCaptionEnum.MultiAudit.getKey().equals(nodeType) || NodeKeyAndCaptionEnum.SubProcess.getKey().equals(nodeType)) {
            this.setAuditAttributesFromXml(props, element, nodeType);
        }
        if (NodeKeyAndCaptionEnum.StateAction.getKey().equals(nodeType)) {
            this.setStateActionAttributesFromXml(props, element);
        }
        if (NodeKeyAndCaptionEnum.State.getKey().equals(nodeType)) {
            this.setStateAttributesFromXml(props, element);
        }
    }

    private void setStateActionAttributesFromXml(JSONObject props, Element node) {
        List<String> keyList = Arrays.asList("Enable", "Visible", "Icon", "TemplateKey", "Action", "OperationKey", "OperationCaption", "RevokeCondition", "ParticipatorCollection");
        for (String k : keyList) {
            JSONObject value = new JSONObject();
            switch (k) {
                case "TemplateKey": 
                case "Icon": 
                case "RevokeCondition": 
                case "Action": 
                case "Enable": 
                case "Visible": {
                    if (node.attributeValue(k) == null || StringUtils.isEmpty((CharSequence)node.attributeValue(k))) {
                        value.put("value", (Object)"");
                        break;
                    }
                    value.put("value", (Object)node.attributeValue(k));
                    break;
                }
                case "Perm": {
                    value.put("value", (Object)JSON.toJSONString((Object)this.setPerm(node)));
                    break;
                }
                case "OperationKey": {
                    if (node.element("Operation") != null) {
                        value.put("value", (Object)node.element("Operation").attributeValue("Key"));
                        break;
                    }
                    value.put("value", (Object)"");
                    break;
                }
                case "OperationCaption": {
                    if (node.element("Operation") != null) {
                        value.put("value", (Object)node.element("Operation").attributeValue("Caption"));
                        break;
                    }
                    value.put("value", (Object)"");
                    break;
                }
                case "ParticipatorCollection": {
                    value.put("value", (Object)JSON.toJSONString((Object)this.setParticipatorCollection(node)));
                    break;
                }
            }
            props.put(k, (Object)value);
        }
    }

    private void setAttributeToJson(Element element, JSONObject props, String attributeName) {
        JSONObject value = new JSONObject();
        value.put("value", (Object)element.attributeValue(attributeName));
        props.put(attributeName, (Object)value);
    }

    private JSONObject setCommonAttributes(Element element) {
        JSONObject props = new JSONObject();
        List<String> keyList = Arrays.asList("NodeType", "ID", "Key", "Caption");
        for (String k : keyList) {
            JSONObject value;
            if ("NodeType".equals(k)) {
                value = new JSONObject();
                value.put("value", (Object)element.getName());
                props.put("NodeType", (Object)value);
                continue;
            }
            value = new JSONObject();
            value.put("value", (Object)element.attributeValue(k));
            props.put(k, (Object)value);
        }
        return props;
    }

    private void setImageAndSoOnAttrbutesFromXml(JSONObject props, Element node) {
        List<String> keyList = Arrays.asList("Image", "PastImage", "LastImage", "BPMState", "WorkitemRevoke", "RetreatCaption", "RevokeTrigger", "IsSync");
        Iterator<String> iterator = keyList.iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "LastImage": 
                case "Image": 
                case "PastImage": {
                    JSONObject value = new JSONObject();
                    value.put("value", (Object)node.element("NodeGraphic").attributeValue(key));
                    props.put(key, (Object)value);
                    break;
                }
                case "BPMState": 
                case "RevokeTrigger": 
                case "RetreatCaption": {
                    JSONObject value = new JSONObject();
                    value.put("value", (Object)node.attributeValue(key));
                    props.put(key, (Object)value);
                    break;
                }
                case "WorkitemRevoke": {
                    JSONObject value = new JSONObject();
                    if (node.attributeValue(key) == null || StringUtils.isEmpty((CharSequence)node.attributeValue(key))) {
                        value.put("value", (Object)"true");
                    } else {
                        value.put("value", (Object)node.attributeValue(key));
                    }
                    props.put(key, (Object)value);
                    break;
                }
                case "IsSync": {
                    JSONObject value = new JSONObject();
                    if (node.attributeValue(key) == null || StringUtils.isEmpty((CharSequence)node.attributeValue(key))) {
                        value.put("value", (Object)"false");
                    } else {
                        value.put("value", (Object)node.attributeValue(key));
                    }
                    props.put(key, (Object)value);
                    break;
                }
            }
        }
    }

    private void setUserTaskAttributesFromXml(JSONObject props, Element node, String tagName) {
        List<String> keyList = Arrays.asList("TimerItemCollection", "CreateTrigger", "FinishTrigger", "AutoIgnoreNoParticipator", "Perm", "OperationCollection", "AssistanceCollection", "ParticipatorCollection");
        if (NodeKeyAndCaptionEnum.MultiUserTask.getKey().equals(tagName)) {
            keyList = new ArrayList<String>(keyList);
            keyList.add("InOrder");
            keyList.add("RevokeCondition");
        } else if (NodeKeyAndCaptionEnum.Countersign.getKey().equals(tagName)) {
            keyList = new ArrayList<String>(keyList);
            keyList.add("PassCondition");
            keyList.add("PassType");
            keyList.add("ValidCondition");
            keyList.add("ValidType");
            keyList.add("FinishCondition");
            keyList.add("FinishType");
        } else if (NodeKeyAndCaptionEnum.DataMap.getKey().equals(tagName)) {
            keyList = new ArrayList<String>(keyList);
            keyList.add("MidDataMap");
            keyList.add("SyncTriggerType");
            keyList.add("DataMapCondition");
            keyList.add("BillDataMapInfoCollection");
            keyList.add("RevokeCondition");
        } else if (NodeKeyAndCaptionEnum.UserTask.getKey().equals(tagName)) {
            keyList = new ArrayList<String>(keyList);
            keyList.add("RevokeCondition");
        }
        for (String k : keyList) {
            JSONObject value = new JSONObject();
            switch (k) {
                case "TimerItemCollection": {
                    if (node.element(k) != null) {
                        value.put("value", (Object)JSON.toJSONString((Object)this.setTimerItemCollection(node)));
                        break;
                    }
                    value.put("value", (Object)"");
                    break;
                }
                case "DataMapCondition": 
                case "SyncTriggerType": 
                case "RevokeCondition": 
                case "CreateTrigger": 
                case "FinishTrigger": {
                    if (node.attributeValue(k) == null || StringUtils.isEmpty((CharSequence)node.attributeValue(k))) {
                        value.put("value", (Object)"");
                        break;
                    }
                    value.put("value", (Object)node.attributeValue(k));
                    break;
                }
                case "MidDataMap": 
                case "InOrder": 
                case "AutoIgnoreNoParticipator": {
                    if (node.attributeValue(k) == null || StringUtils.isEmpty((CharSequence)node.attributeValue(k))) {
                        value.put("value", (Object)"false");
                        break;
                    }
                    value.put("value", (Object)node.attributeValue(k));
                    break;
                }
                case "Perm": {
                    value.put("value", (Object)JSON.toJSONString((Object)this.setPerm(node)));
                    break;
                }
                case "OperationCollection": {
                    this.setOperationCollectionJsonFromXml(node, value, k);
                    break;
                }
                case "AssistanceCollection": {
                    this.setAssistanceCollection(node, value, k);
                    break;
                }
                case "ParticipatorCollection": {
                    value.put("value", (Object)JSON.toJSONString((Object)this.setParticipatorCollection(node)));
                    break;
                }
                case "FinishCondition": 
                case "ValidCondition": 
                case "PassCondition": {
                    value.put("value", (Object)node.attributeValue(k));
                    break;
                }
                case "FinishType": 
                case "ValidType": 
                case "PassType": {
                    if (Objects.isNull(node.attributeValue(k))) {
                        value.put("value", (Object)"false");
                        break;
                    }
                    value.put("value", (Object)node.attributeValue(k));
                    break;
                }
                case "BillDataMapInfoCollection": {
                    this.setBillDataMapInfoCollectionJsonFromXml(node, value, k);
                    break;
                }
            }
            props.put(k, (Object)value);
        }
    }

    private void setAuditAttributesFromXml(JSONObject props, Element node, String tagName) {
        List<String> keyList = Arrays.asList("TimerItemCollection", "CreateTrigger", "RevokeCondition", "FinishTrigger", "AutoIgnoreNoParticipator", "Perm", "OperationCollection", "AssistanceCollection", "ParticipatorCollection");
        if (NodeKeyAndCaptionEnum.SubProcess.getKey().equals(tagName)) {
            keyList = new ArrayList<String>(keyList);
            keyList.add("SyncMode");
            keyList.add("AutoStartAction");
            keyList.add("SubProcessKey");
        } else {
            keyList = new ArrayList<String>(keyList);
            keyList.add("DenyToLastNode");
            keyList.add("DenyNodeKey");
        }
        for (String k : keyList) {
            JSONObject value = new JSONObject();
            switch (k) {
                case "TimerItemCollection": {
                    if (node.element(k) != null) {
                        value.put("value", (Object)JSON.toJSONString((Object)this.setTimerItemCollection(node)));
                        break;
                    }
                    value.put("value", (Object)"");
                    break;
                }
                case "DenyNodeKey": 
                case "RevokeCondition": 
                case "FinishCondition": 
                case "ValidCondition": 
                case "AutoStartAction": 
                case "PassCondition": 
                case "SubProcessKey": 
                case "CreateTrigger": 
                case "FinishTrigger": {
                    if (node.attributeValue(k) == null || StringUtils.isEmpty((CharSequence)node.attributeValue(k))) {
                        value.put("value", (Object)"");
                        break;
                    }
                    value.put("value", (Object)node.attributeValue(k));
                    break;
                }
                case "FinishType": 
                case "DenyToLastNode": 
                case "ValidType": 
                case "AutoIgnoreNoParticipator": 
                case "PassType": {
                    if (node.attributeValue(k) == null || StringUtils.isEmpty((CharSequence)node.attributeValue(k))) {
                        value.put("value", (Object)"false");
                        break;
                    }
                    value.put("value", (Object)node.attributeValue(k));
                    break;
                }
                case "Perm": {
                    value.put("value", (Object)JSON.toJSONString((Object)this.setPerm(node)));
                    break;
                }
                case "OperationCollection": {
                    this.setOperationCollectionJsonFromXml(node, value, k);
                    break;
                }
                case "AssistanceCollection": {
                    this.setAssistanceCollection(node, value, k);
                    break;
                }
                case "ParticipatorCollection": {
                    value.put("value", (Object)JSON.toJSONString((Object)this.setParticipatorCollection(node)));
                    break;
                }
                case "SyncMode": {
                    if (node.attributeValue(k) == null || StringUtils.isEmpty((CharSequence)node.attributeValue(k))) {
                        value.put("value", (Object)"Synchronized");
                        break;
                    }
                    value.put("value", (Object)node.attributeValue(k));
                    break;
                }
            }
            props.put(k, (Object)value);
        }
    }

    private void setSwimline(JSONObject props, Element node) {
        List<String> keyList = Arrays.asList("Direction", "Position", "Size");
        for (String k : keyList) {
            JSONObject value = new JSONObject();
            switch (k) {
                case "Direction": {
                    if (node.attributeValue(k) == null || StringUtils.isEmpty((CharSequence)node.attributeValue(k))) {
                        value.put("value", (Object)"Vertical");
                    } else {
                        value.put("value", (Object)node.attributeValue(k));
                    }
                    props.put(k, (Object)value);
                    break;
                }
                case "Position": {
                    this.getSplitAttr(props, node, k, "X", 0);
                    this.getSplitAttr(props, node, k, "Y", 1);
                    break;
                }
                case "Size": {
                    this.getSplitAttr(props, node, k, "Width", 0);
                    this.getSplitAttr(props, node, k, "Height", 1);
                    break;
                }
            }
        }
    }

    private void getSplitAttr(JSONObject props, Element node, String k, String attr, int pos) {
        if (node.attributeValue(k) != null) {
            JSONObject value = new JSONObject();
            value.put("value", (Object)node.attributeValue(k).split(",")[pos].split(":")[1]);
            props.put(attr, (Object)value);
        }
    }

    private void setStateAttributesFromXml(JSONObject props, Element node) {
        List<String> keyList = Arrays.asList("Status", "CreateTrigger", "FinishTrigger", "Perm", "FieldKey", "FieldValue", "ParticipatorCollection", "RevokeCondition");
        for (String k : keyList) {
            JSONObject value = new JSONObject();
            switch (k) {
                case "Status": 
                case "FieldValue": 
                case "FieldKey": 
                case "RevokeCondition": 
                case "CreateTrigger": 
                case "FinishTrigger": {
                    if (node.attributeValue(k) == null || StringUtils.isEmpty((CharSequence)node.attributeValue(k))) {
                        value.put("value", (Object)"");
                        break;
                    }
                    value.put("value", (Object)node.attributeValue(k));
                    break;
                }
                case "Perm": {
                    value.put("value", (Object)JSON.toJSONString((Object)this.setPerm(node)));
                    break;
                }
                case "ParticipatorCollection": {
                    value.put("value", (Object)JSON.toJSONString((Object)this.setParticipatorCollection(node)));
                    break;
                }
            }
            props.put(k, (Object)value);
        }
    }

    private void setAssistanceCollection(Element node, JSONObject value, String k) {
        JSONArray jsonArray = new JSONArray();
        if (node.element(k) != null) {
            List userTasks = node.element(k).elements("UserTask");
            List countersigns = node.element(k).elements("Countersign");
            List audits = node.element(k).elements("Audit");
            List<String> keys = Arrays.asList("id", "NodeType", "Key", "Caption", "Perm", "OperationCollection", "ParticipatorCollection", "TimerItemCollection", "OtherSet");
            if (!CollectionUtils.isEmpty((Collection)userTasks)) {
                this.setAssistanceItem(jsonArray, userTasks, keys, "UserTask");
            }
            if (!CollectionUtils.isEmpty((Collection)countersigns)) {
                this.setAssistanceItem(jsonArray, countersigns, keys, "Countersign");
            }
            if (!CollectionUtils.isEmpty((Collection)audits)) {
                this.setAssistanceItem(jsonArray, audits, keys, "Audit");
            }
        }
        value.put("value", (Object)JSON.toJSONString((Object)jsonArray));
    }

    private void setAssistanceItem(JSONArray jsonArray, List<Element> tasks, List<String> keys, String nodeType) {
        int i = 0;
        while (i < tasks.size()) {
            JSONObject jsonObj = new JSONObject();
            Iterator<String> iterator = keys.iterator();
            while (iterator.hasNext()) {
                String key;
                switch (key = iterator.next()) {
                    case "id": {
                        jsonObj.put(key, (Object)(jsonArray.size() + i + 1));
                        break;
                    }
                    case "NodeType": {
                        jsonObj.put(key, (Object)nodeType);
                        break;
                    }
                    case "Caption": 
                    case "Key": {
                        jsonObj.put(key, (Object)tasks.get(i).attributeValue(key));
                        break;
                    }
                    case "Perm": {
                        jsonObj.put(key, (Object)JSON.toJSONString((Object)this.setPerm(tasks.get(i))));
                        break;
                    }
                    case "OperationCollection": {
                        this.setOperationCollectionJsonFromXml(tasks.get(i), jsonObj, key);
                        jsonObj.put(key, (Object)jsonObj.getString("value"));
                        break;
                    }
                    case "ParticipatorCollection": {
                        jsonObj.put(key, (Object)JSON.toJSONString((Object)this.setParticipatorCollection(tasks.get(i))));
                        break;
                    }
                    case "TimerItemCollection": {
                        jsonObj.put(key, (Object)JSON.toJSONString((Object)this.setTimerItemCollection(tasks.get(i))));
                        break;
                    }
                    case "OtherSet": {
                        List<String> otherSetKeys = Arrays.asList("ProcessKey", "TemplateKey", "CreateTrigger", "FinishTrigger", "PassCondition", "ValidCondition", "FinishCondition", "InUse", "AutoIgnoreNoParticipator", "PassType", "ValidType");
                        JSONObject otherSetJsonObj = new JSONObject();
                        for (String otherSetKey : otherSetKeys) {
                            String otherSetValue = tasks.get(i).attributeValue(otherSetKey);
                            if (StringUtils.isNotEmpty((CharSequence)otherSetValue)) {
                                otherSetJsonObj.put(otherSetKey, (Object)otherSetValue);
                                continue;
                            }
                            otherSetJsonObj.put(otherSetKey, (Object)"");
                        }
                        jsonObj.put(key, (Object)otherSetJsonObj);
                        break;
                    }
                }
            }
            jsonArray.add((Object)jsonObj);
            ++i;
        }
    }

    private void setOperationCollectionJsonFromXml(Element node, JSONObject value, String k) {
        block29: {
            block27: {
                if (node.element(k) == null || node.element(k).elements("Operation") == null) break block27;
                JSONArray jsonArray = new JSONArray();
                String actionValue = "";
                List operations = node.element(k).elements("Operation");
                List<String> keys = Arrays.asList("Action", "Key", "Caption", "Enable", "Visible", "Icon", "TemplateKey", "id");
                int count = 0;
                for (Element ele : operations) {
                    JSONObject jsonObj = new JSONObject();
                    Iterator<String> iterator = keys.iterator();
                    while (iterator.hasNext()) {
                        String key;
                        switch (key = iterator.next()) {
                            case "Action": {
                                if (ele.element(key) != null) {
                                    actionValue = ConvertSpecialStringUtil.convertSpecialString(ele.element(key).getData().toString().trim());
                                }
                                jsonObj.put(key, (Object)actionValue);
                                break;
                            }
                            case "Enable": {
                                jsonObj.put(key, (Object)(StringUtils.isNotEmpty((CharSequence)ele.attributeValue(key)) ? ele.attributeValue(key) : "ReadOnly()"));
                                break;
                            }
                            case "Caption": 
                            case "TemplateKey": 
                            case "Key": 
                            case "Icon": 
                            case "Visible": {
                                jsonObj.put(key, (Object)ele.attributeValue(key));
                                break;
                            }
                            case "id": {
                                jsonObj.put(key, (Object)(++count));
                                break;
                            }
                        }
                    }
                    jsonArray.add((Object)jsonObj);
                }
                value.put("value", (Object)JSON.toJSONString((Object)jsonArray));
                break block29;
            }
            value.put("value", (Object)"");
        }
    }

    private void setBillDataMapInfoCollectionJsonFromXml(Element node, JSONObject value, String k) {
        block21: {
            block19: {
                if (node.element(k) == null || node.element(k).elements("BillDataMapInfo") == null) break block19;
                JSONArray jsonArray = new JSONArray();
                List billDataMapInfos = node.element(k).elements("BillDataMapInfo");
                List<String> keys = Arrays.asList("DataMapKey", "Caption", "AutoStart", "FormKey");
                int count = 0;
                for (Element ele : billDataMapInfos) {
                    JSONObject jsonObj = new JSONObject();
                    Iterator<String> iterator = keys.iterator();
                    while (iterator.hasNext()) {
                        String key;
                        switch (key = iterator.next()) {
                            case "AutoStart": {
                                jsonObj.put(key, (Object)(ele.attributeValue(key) != null ? 1 : 0));
                                break;
                            }
                            case "Caption": 
                            case "DataMapKey": 
                            case "FormKey": {
                                jsonObj.put(key, (Object)ele.attributeValue(key));
                                break;
                            }
                            case "id": {
                                jsonObj.put(key, (Object)(++count));
                                break;
                            }
                        }
                    }
                    jsonArray.add((Object)jsonObj);
                }
                value.put("value", (Object)JSON.toJSONString((Object)jsonArray));
                break block21;
            }
            value.put("value", (Object)"");
        }
    }

    private JSONArray setTimerItemCollection(Element node) {
        List timerAutoPassItems = null;
        List timerAutoDenyItems = null;
        List timerItemItems = null;
        if (node.element("TimerItemCollection") != null && !CollectionUtils.isEmpty((Collection)node.element("TimerItemCollection").elements("TimerAutoPass"))) {
            timerAutoPassItems = node.element("TimerItemCollection").elements("TimerAutoPass");
        }
        if (node.element("TimerItemCollection") != null && !CollectionUtils.isEmpty((Collection)node.element("TimerItemCollection").elements("TimerAutoDeny"))) {
            timerAutoDenyItems = node.element("TimerItemCollection").elements("TimerAutoDeny");
        }
        if (node.element("TimerItemCollection") != null && !CollectionUtils.isEmpty((Collection)node.element("TimerItemCollection").elements("TimerItem"))) {
            timerItemItems = node.element("TimerItemCollection").elements("TimerItem");
        }
        List<String> keyList = Arrays.asList("TimerAutoPass", "TimerAutoDeny", "TimerItem");
        JSONArray array = new JSONArray();
        List elements = null;
        String type = "";
        Iterator<String> iterator = keyList.iterator();
        while (iterator.hasNext()) {
            String k;
            switch (k = iterator.next()) {
                case "TimerAutoPass": {
                    type = "\u81ea\u52a8\u901a\u8fc7";
                    elements = timerAutoPassItems;
                    break;
                }
                case "TimerAutoDeny": {
                    type = "\u81ea\u52a8\u9a73\u56de";
                    elements = timerAutoDenyItems;
                    break;
                }
                case "TimerItem": {
                    type = "";
                    elements = timerItemItems;
                    break;
                }
            }
            if (CollectionUtils.isEmpty(elements)) continue;
            for (Element ele : elements) {
                JSONObject jsonObj = new JSONObject();
                jsonObj.put("id", (Object)(array.size() + 1));
                jsonObj.put("Key", (Object)ele.attributeValue("Key"));
                jsonObj.put("Peroid", (Object)ele.attributeValue("Peroid"));
                if (StringUtils.isNotEmpty((CharSequence)type)) {
                    jsonObj.put("type", (Object)type);
                    if (ele.attribute("UserInfo") != null) {
                        jsonObj.put("Suggestion", (Object)ele.attributeValue("UserInfo"));
                    } else {
                        jsonObj.put("Suggestion", (Object)"");
                    }
                    jsonObj.put("CycleInterval", (Object)"");
                    jsonObj.put("Repeat", (Object)"");
                } else {
                    if (ele.attribute("Repeat") != null) {
                        jsonObj.put("type", (Object)"\u5faa\u73af\u81ea\u52a8\u4efb\u52a1");
                        if (ele.attribute("Repeat") != null) {
                            jsonObj.put("Repeat", (Object)ele.attributeValue("Repeat"));
                        } else {
                            jsonObj.put("Repeat", (Object)"");
                        }
                    } else {
                        jsonObj.put("type", (Object)"\u5355\u6b21\u81ea\u52a8\u4efb\u52a1");
                    }
                    if (ele.attribute("CycleInterval") != null) {
                        jsonObj.put("CycleInterval", (Object)ele.attributeValue("CycleInterval"));
                    } else {
                        jsonObj.put("CycleInterval", (Object)"");
                    }
                    if (ele.attribute("Trigger") != null) {
                        jsonObj.put("Suggestion", (Object)ele.attributeValue("Trigger"));
                    } else {
                        jsonObj.put("Suggestion", (Object)"");
                    }
                }
                array.add((Object)jsonObj);
            }
        }
        return array;
    }

    private JSONObject setPerm(Element node) {
        List optPermItems = null;
        List visiblePermItems = null;
        List enablePermItems = null;
        if (node.element("Perm") != null && node.element("Perm").element("OptPerm") != null) {
            optPermItems = node.element("Perm").element("OptPerm").elements("OptPermItem");
        }
        if (node.element("Perm") != null && node.element("Perm").element("VisiblePerm") != null) {
            visiblePermItems = node.element("Perm").element("VisiblePerm").elements("VisiblePermItem");
        }
        if (node.element("Perm") != null && node.element("Perm").element("EnablePerm") != null) {
            enablePermItems = node.element("Perm").element("EnablePerm").elements("EnablePermItem");
        }
        JSONObject value = new JSONObject();
        List<String> keyList = Arrays.asList("OptPerm", "VisiblePerm", "EnablePerm");
        List elements = null;
        Iterator<String> iterator = keyList.iterator();
        while (iterator.hasNext()) {
            String k;
            switch (k = iterator.next()) {
                case "OptPerm": {
                    elements = optPermItems;
                    break;
                }
                case "VisiblePerm": {
                    elements = visiblePermItems;
                    break;
                }
                case "EnablePerm": {
                    elements = enablePermItems;
                    break;
                }
            }
            if (CollectionUtils.isEmpty(elements)) continue;
            JSONArray array = new JSONArray();
            for (Element ele : elements) {
                JSONObject jsonObj = new JSONObject();
                jsonObj.put("Key", (Object)ele.attributeValue("Key"));
                array.add((Object)jsonObj);
            }
            value.put(k, (Object)array);
        }
        return value;
    }

    private JSONObject setParticipatorCollection(Element node) {
        List dictionaryItems = null;
        List queryItems = null;
        List midFormulaItems = null;
        if (node.element("ParticipatorCollection") != null && node.element("ParticipatorCollection").elements("Dictionary") != null) {
            dictionaryItems = node.element("ParticipatorCollection").elements("Dictionary");
        }
        if (node.element("ParticipatorCollection") != null && node.element("ParticipatorCollection").elements("Query") != null) {
            queryItems = node.element("ParticipatorCollection").elements("Query");
        }
        if (node.element("ParticipatorCollection") != null && node.element("ParticipatorCollection").elements("MidFormula") != null) {
            midFormulaItems = node.element("ParticipatorCollection").elements("MidFormula");
        }
        JSONObject value = new JSONObject();
        List<String> keyList = Arrays.asList("Dictionary", "Query", "MidFormula");
        for (String k : keyList) {
            JSONArray jsonArray = new JSONArray();
            switch (k) {
                case "Dictionary": {
                    if (CollectionUtils.isEmpty((Collection)dictionaryItems)) break;
                    for (Element ele : dictionaryItems) {
                        String[] codeArray;
                        String[] itemIdArray;
                        String itemKey = ele.attributeValue("ItemKey");
                        if (ele.attributeValue("ItemID") != null && (itemIdArray = ele.attributeValue("ItemID").split(":")).length > 0) {
                            this.setDictionaryJson(jsonArray, itemKey, itemIdArray, "ItemID");
                        }
                        if (ele.attributeValue("Code") == null || (codeArray = ele.attributeValue("Code").split(":")).length <= 0) continue;
                        this.setDictionaryJson(jsonArray, itemKey, codeArray, "Code");
                    }
                    break;
                }
                case "Query": {
                    JSONObject jsonObj;
                    if (CollectionUtils.isEmpty((Collection)queryItems)) break;
                    int outCount = 0;
                    for (Element ele : queryItems) {
                        jsonObj = new JSONObject();
                        jsonObj.put("id", (Object)(++outCount));
                        jsonObj.put("data", (Object)ConvertSpecialStringUtil.convertSpecialString(ele.getData().toString().trim()));
                        if (ele.element("QueryParameterCollection") != null) {
                            List queryParameterEles = ele.element("QueryParameterCollection").elements("QueryParameter");
                            JSONArray jsonArrayTemp = new JSONArray();
                            int count = 0;
                            for (Element e : queryParameterEles) {
                                JSONObject tempObj = new JSONObject();
                                tempObj.put("DataType", (Object)e.attributeValue("DataType"));
                                tempObj.put("Formula", (Object)e.attributeValue("Formula").replaceAll("<br>", "@br@"));
                                tempObj.put("id", (Object)(++count));
                                jsonArrayTemp.add((Object)tempObj);
                            }
                            jsonObj.put("QueryParameterCollection", (Object)jsonArrayTemp.toString());
                        }
                        jsonArray.add((Object)jsonObj);
                    }
                    break;
                }
                case "MidFormula": {
                    JSONObject jsonObj;
                    if (CollectionUtils.isEmpty((Collection)midFormulaItems)) break;
                    int count = 0;
                    for (Element ele : midFormulaItems) {
                        jsonObj = new JSONObject();
                        jsonObj.put("value", (Object)ConvertSpecialStringUtil.convertSpecialString(ele.getData().toString().trim()));
                        jsonObj.put("id", (Object)(++count));
                        jsonArray.add((Object)jsonObj);
                    }
                    break;
                }
            }
            value.put(k, (Object)jsonArray);
        }
        return value;
    }

    private void setDictionaryJson(JSONArray jsonArray, String itemKey, String[] itemIdArray, String itemID) {
        String[] stringArray = itemIdArray;
        int n = itemIdArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("id", (Object)(jsonArray.size() + 1));
            jsonObj.put("dictType", (Object)itemKey);
            jsonObj.put("codeType", (Object)itemID);
            jsonObj.put("codeValue", (Object)s);
            jsonArray.add((Object)jsonObj);
            ++n2;
        }
    }

    private void hendleLines(Element element, JSONObject paths) {
        Element transitionCollection = element.element("TransitionCollection");
        if (transitionCollection != null) {
            List<String> keys = Arrays.asList("SequenceFlow", "Association", "ExceptionFlow");
            for (String key : keys) {
                List pathList = transitionCollection.elements(key);
                for (Element path : pathList) {
                    if (path == null) continue;
                    this.setPathsJson(path, paths);
                }
            }
        }
    }

    private void setPathsJson(Element element, JSONObject paths) {
        JSONObject pathsInner = new JSONObject();
        String to = "";
        int x = 150;
        int y = 150;
        String from = element.getParent().getParent().attributeValue("Key");
        String toKey = element.attributeValue("TargetNodeKey");
        Element root = element.getParent().getParent().getParent();
        List elements = root.elements();
        String fromNodeKey = element.getParent().getParent().attributeValue("Key");
        for (Element elem : elements) {
            if (StringUtils.isNotEmpty((CharSequence)elem.attributeValue("Key")) && elem.attributeValue("Key").equals(fromNodeKey)) {
                x = Integer.parseInt(elem.element("NodeGraphic").attributeValue("X"));
                y = Integer.parseInt(elem.element("NodeGraphic").attributeValue("Y"));
            }
            if (!StringUtils.isNotEmpty((CharSequence)elem.attributeValue("Key")) || !elem.attributeValue("Key").equals(toKey)) continue;
            to = elem.attributeValue("Key");
        }
        pathsInner.put("from", (Object)from);
        pathsInner.put("to", (Object)to);
        pathsInner.put("dots", (Object)new JSONArray());
        JSONObject textJson = new JSONObject();
        textJson.put("text", (Object)"");
        pathsInner.put("text", (Object)textJson);
        JSONObject temp = new JSONObject();
        temp.put("x", (Object)x);
        temp.put("y", (Object)y);
        pathsInner.put("textPos", (Object)temp);
        JSONObject props = new JSONObject();
        List<String> keys = null;
        switch (element.getName()) {
            case "SequenceFlow": {
                if (this.isAuditOrMultiAudit(root, fromNodeKey)) {
                    keys = Arrays.asList("NodeType", "ID", "Key", "Caption", "TargetNodeKey", "State", "Condition");
                    break;
                }
                keys = Arrays.asList("NodeType", "ID", "Key", "Caption", "TargetNodeKey", "State");
                break;
            }
            case "ExceptionFlow": 
            case "Association": {
                keys = Arrays.asList("NodeType", "ID", "Key", "Caption", "TargetNodeKey");
                break;
            }
        }
        if (!CollectionUtils.isEmpty(keys)) {
            keys.forEach(key -> this.setPathsProps((String)key, element, props));
        }
        pathsInner.put("props", (Object)props);
        paths.put("path" + element.attributeValue("Key"), (Object)pathsInner);
    }

    private boolean isAuditOrMultiAudit(Element root, String fromKey) {
        AtomicBoolean result = new AtomicBoolean(false);
        root.elements().forEach(q -> {
            boolean isAuditOrMultiAudit;
            boolean bl = isAuditOrMultiAudit = fromKey.equals(q.attributeValue("Key")) && (NodeKeyAndCaptionEnum.Audit.getKey().equals(q.getName()) || NodeKeyAndCaptionEnum.MultiAudit.getKey().equals(q.getName()) || NodeKeyAndCaptionEnum.Decision.getKey().equals(q.getName()) || NodeKeyAndCaptionEnum.Countersign.getKey().equals(q.getName()));
            if (isAuditOrMultiAudit) {
                result.set(true);
            }
        });
        return result.get();
    }

    private void setPathsProps(String key, Element element, JSONObject props) {
        JSONObject value = new JSONObject();
        String v = element.attributeValue(key);
        switch (key) {
            case "NodeType": {
                value.put("value", (Object)element.getName());
                break;
            }
            case "Caption": 
            case "ID": 
            case "Key": 
            case "TargetNodeKey": {
                value.put("value", (Object)v);
                break;
            }
            case "State": 
            case "Condition": {
                if (StringUtils.isNotEmpty((CharSequence)v)) {
                    value.put("value", (Object)v);
                    break;
                }
                value.put("value", (Object)"true");
                break;
            }
        }
        props.put(key, (Object)value);
    }

    public Stack<String> resultStack() {
        return bpmStack;
    }
}

