/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.design.bpm.po;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.bpm.po.NodeGraphic;
import com.bokesoft.yes.design.bpm.util.ConvertSpecialStringUtil;
import com.bokesoft.yes.design.enums.NodeKeyAndCaptionEnum;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class Node {
    private static final Logger logger = Logger.getLogger(Node.class.getName());
    private String NodeType;
    private String ID;
    private String Key;
    private String Caption;
    private NodeGraphic NodeGraphic;
    private String Image;
    private String BPMState;
    private String WorkitemRevoke;
    private String IsSync;
    private static Pattern NUMBER_PATTERN = Pattern.compile("[^0-9]");

    public Element save(JSONObject operNodeJson, Element root, String nodeType, String nodeId) throws Throwable {
        Element node = null;
        try {
            node = this.saveCommonAttributesToXml(operNodeJson, root, nodeType, nodeId);
            this.saveImageAttrbutesToXml(operNodeJson, node);
        }
        catch (Throwable e) {
            logger.warning("\u4fdd\u5b58\u516c\u5171\u5c5e\u6027\u5230xml\u6587\u4ef6\u5f02\u5e38\uff0c\u5f02\u5e38\u4e3a:" + ExceptionUtils.getStackTrace((Throwable)e));
            throw e;
        }
        return node;
    }

    public void saveSelfAttributesToXml(JSONObject operNodeJson, Element node) throws Throwable {
    }

    public JSONObject setFrontDefaultValues() {
        return new JSONObject();
    }

    public Element saveCommonAttributesToXml(JSONObject operNodeJson, Element root, String nodeType, String nodeId) {
        String id = nodeId.replaceAll("rect", "").replaceAll("path", "");
        String key = operNodeJson.getJSONObject("props").getJSONObject("Key").getString("value");
        key = StringUtils.isEmpty((CharSequence)key) ? nodeId : key;
        String caption = operNodeJson.getJSONObject("props").getJSONObject("Caption").getString("value");
        id = NUMBER_PATTERN.matcher(id).replaceAll("").trim();
        if (StringUtils.isEmpty((CharSequence)caption)) {
            caption = NodeKeyAndCaptionEnum.valueOf(nodeType).getCaption();
        }
        Element node = null;
        List elements = root.elements(nodeType);
        if (!CollectionUtils.isEmpty((Collection)elements)) {
            for (Element ele : elements) {
                if (!key.equals(ele.attributeValue("Key"))) continue;
                node = ele;
                break;
            }
        }
        if (node == null) {
            node = root.addElement(nodeType);
        }
        node.addAttribute("ID", id).addAttribute("Caption", caption).addAttribute("Key", key);
        if (node.element("NodeGraphic") == null) {
            node.addElement("NodeGraphic");
        }
        NodeGraphic graphic = this.saveNodeGraphic(operNodeJson, node);
        this.setNodeType(nodeType);
        this.setID(id);
        this.setCaption(caption);
        this.setKey(key);
        this.setNodeGraphic(graphic);
        return node;
    }

    public void saveImageAttrbutesToXml(JSONObject operNodeJson, Element node) {
        JSONObject propsJsonObj = operNodeJson.getJSONObject("props");
        Set keys = propsJsonObj.keySet();
        for (String k : keys) {
            String v = propsJsonObj.getJSONObject(k).getString("value");
            if ("null".equals(v)) {
                v = "";
            }
            switch (k) {
                case "LastImage": 
                case "Image": 
                case "PastImage": {
                    boolean canSetAttrValue = false;
                    if (node.element("NodeGraphic").attribute(k) == null) {
                        if (StringUtils.isNotEmpty((CharSequence)v)) {
                            canSetAttrValue = true;
                        }
                    } else if (StringUtils.isNotEmpty((CharSequence)v)) {
                        canSetAttrValue = true;
                    } else {
                        this.deleteXmlElementAttribute(node.element("NodeGraphic"), node.element("NodeGraphic").attribute(k));
                    }
                    if (!canSetAttrValue) break;
                    node.element("NodeGraphic").addAttribute(k, v);
                    break;
                }
                case "BPMState": {
                    if (StringUtils.isNotEmpty((CharSequence)v) && !"-1".equals(v)) {
                        node.addAttribute(k, v);
                        break;
                    }
                    if (node.attribute(k) == null) break;
                    this.deleteXmlElementAttribute(node, node.attribute(k));
                    break;
                }
                case "RevokeTrigger": 
                case "RetreatCaption": {
                    if (StringUtils.isNotEmpty((CharSequence)v)) {
                        node.addAttribute(k, v);
                        break;
                    }
                    this.deleteXmlElementAttribute(node, node.attribute(k));
                    break;
                }
                case "WorkitemRevoke": {
                    if ("false".equals(v)) {
                        node.addAttribute(k, v);
                        break;
                    }
                    this.deleteXmlElementAttribute(node, node.attribute(k));
                    break;
                }
                case "IsSync": {
                    if ("true".equals(v)) {
                        node.addAttribute(k, v);
                        break;
                    }
                    this.deleteXmlElementAttribute(node, node.attribute(k));
                    break;
                }
            }
        }
    }

    public JSONObject getFrontDefaultValuesJson(Map<String, String> otherAttributesMap) {
        JSONObject nodeJson = new JSONObject();
        this.setFrontDefaultValue(this, otherAttributesMap, nodeJson);
        return nodeJson;
    }

    public void setTimerItemCollectionXmlValue(Element node, String v, String k) {
        block21: {
            JSONArray array;
            if ("\u5df2\u8bbe\u7f6e".equals(v)) {
                return;
            }
            if (node.element(k) != null) {
                node.remove(node.element(k));
            }
            node.addElement(k);
            if (!StringUtils.isNotEmpty((CharSequence)v) || "{}".equals(v) || CollectionUtils.isEmpty((Collection)(array = JSON.parseArray((String)v)))) break block21;
            int j = 0;
            while (j < array.size()) {
                JSONObject temp = array.getJSONObject(j);
                switch (temp.getString("type")) {
                    case "\u81ea\u52a8\u901a\u8fc7": 
                    case "\u81ea\u52a8\u9a73\u56de": {
                        String value;
                        String eleName = "\u81ea\u52a8\u901a\u8fc7".equals(temp.getString("type")) ? "TimerAutoPass" : "TimerAutoDeny";
                        Element timerAutoPass = node.element(k).addElement(eleName);
                        List<String> keys = Arrays.asList("Key", "Peroid", "UserInfo");
                        for (String key : keys) {
                            value = temp.getString(key);
                            if ("UserInfo".equals(key) && StringUtils.isNotEmpty((CharSequence)(value = temp.getString("Suggestion")))) {
                                value = value.replaceAll("@br@", "\n").replaceAll("&lt;br&gt;", "\n");
                            }
                            if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                            timerAutoPass.addAttribute(key, value);
                        }
                        break;
                    }
                    case "\u5faa\u73af\u81ea\u52a8\u4efb\u52a1": 
                    case "\u5355\u6b21\u81ea\u52a8\u4efb\u52a1": {
                        String value;
                        Element timerItem = node.element(k).addElement("TimerItem");
                        List<String> autoKeys = Arrays.asList("Key", "Peroid", "CycleInterval", "Repeat", "Trigger");
                        for (String key : autoKeys) {
                            if ("\u5355\u6b21\u81ea\u52a8\u4efb\u52a1".equals(temp.getString("type")) && "Repeat".equals(key)) continue;
                            value = temp.getString(key);
                            if ("Trigger".equals(key) && StringUtils.isNotEmpty((CharSequence)(value = temp.getString("Suggestion")))) {
                                value = value.replaceAll("@br@", "\n").replaceAll("&lt;br&gt;", "\n");
                            }
                            if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                            timerItem.addAttribute(key, value);
                        }
                        break;
                    }
                }
                ++j;
            }
        }
    }

    public void savePermToXml(Element node, String v, String k) {
        JSONObject permJson;
        if ("\u5df2\u8bbe\u7f6e".equals(v)) {
            return;
        }
        if (node.element(k) != null) {
            node.remove(node.element(k));
        }
        node.addElement(k);
        if (StringUtils.isNotEmpty((CharSequence)v) && (permJson = JSON.parseObject((String)(v = v.replaceAll("\"\"\\[", "\"[").replaceAll("]\"\"", "]").replaceAll("\"\\[", "[").replaceAll("]\"", "]").replaceAll("(\\\\r\\\\n)|\\\\n", "\\\n")))) != null) {
            this.setXmlPerm(permJson, node, k, "OptPerm", "OptPermItem");
            this.setXmlPerm(permJson, node, k, "VisiblePerm", "VisiblePermItem");
            this.setXmlPerm(permJson, node, k, "EnablePerm", "EnablePermItem");
        }
    }

    private void setXmlPerm(JSONObject permJson, Element node, String k, String firstElementName, String secondElementName) {
        JSONArray permArray = permJson.getJSONArray(firstElementName);
        if (!CollectionUtils.isEmpty((Collection)permArray)) {
            if (node.element(k).element(firstElementName) != null) {
                node.element(k).remove(node.element(k).element(firstElementName));
            }
            Element permElement = node.element(k).addElement(firstElementName);
            for (Object o : permArray) {
                JSONObject eachObj = (JSONObject)o;
                permElement.addElement(secondElementName).addAttribute("Key", eachObj.getString("Key"));
            }
        } else {
            node.element(k).remove(node.element(k).element(firstElementName));
        }
    }

    public void setOperationCollectionXmlValue(Element node, String v, String k) {
        if ("\u5df2\u8bbe\u7f6e".equals(v)) {
            return;
        }
        if (node.element(k) != null) {
            node.remove(node.element(k));
        }
        node.addElement(k);
        if (StringUtils.isNotEmpty((CharSequence)v)) {
            JSONArray valueJson = JSON.parseArray((String)(v = v.replaceAll("\"\"\\[", "[").replaceAll("]\"\"", "]").replaceAll("\"\\[", "[").replaceAll("]\"", "]").replaceAll("(\\\\r\\\\n)|\\\\n", "\\\n")));
            if (!CollectionUtils.isEmpty((Collection)valueJson)) {
                int j = 0;
                while (j < valueJson.size()) {
                    JSONObject temp = valueJson.getJSONObject(j);
                    Element operation = node.element(k).addElement("Operation");
                    List<String> keySet = Arrays.asList("Key", "Caption", "Enable", "Visible", "Icon", "TemplateKey", "Action");
                    for (String key : keySet) {
                        String value = temp.getString(key);
                        if (!StringUtils.isNotEmpty((CharSequence)value) || "Enable".equals(key) && "ReadOnly()".equals(value)) continue;
                        if ("Action".equals(key)) {
                            if (temp.get((Object)key) == null || !StringUtils.isNotEmpty((CharSequence)temp.get((Object)key).toString())) continue;
                            operation.addElement(key).addCDATA(temp.get((Object)key).toString().replaceAll("&quot;", "\"").replaceAll("&apos;", "'"));
                            continue;
                        }
                        operation.addAttribute(key, value);
                    }
                    ++j;
                }
            }
        } else {
            String operCollectionKey = String.valueOf(node.getParent().attributeValue("Key")) + "_op1";
            node.element(k).addElement("Operation").addAttribute("Key", operCollectionKey).addAttribute("Caption", "\u63d0\u4ea4").addElement("Action").addCDATA("CommitWorkitem(-1,1,\"\")");
        }
    }

    public void setAssistanceCollectionFromFrontJson(Element node, String v, String k) {
        block38: {
            JSONArray assistanceCollectionJson;
            if ("\u5df2\u8bbe\u7f6e".equals(v)) {
                return;
            }
            if (node.element(k) != null) {
                node.remove(node.element(k));
            }
            node.addElement(k);
            if (!StringUtils.isNotEmpty((CharSequence)v) || (assistanceCollectionJson = JSON.parseArray((String)(v = v.replaceAll("\"\"\\[", "\"[").replaceAll("]\"\"", "]").replaceAll("\"\\[", "[").replaceAll("]\"", "]").replaceAll("\"\\{", "{").replaceAll("}\"", "}").replaceAll("(\\\\r\\\\n)|\\\\n", "@n@").replaceAll("\\\\", "")))) == null) break block38;
            int i = 0;
            while (i < assistanceCollectionJson.size()) {
                JSONArray timeJson;
                JSONObject obj = (JSONObject)assistanceCollectionJson.get(i);
                String nodeType = obj.getString("NodeType");
                String key_ = obj.getString("Key");
                String caption_ = obj.getString("Caption");
                Element taskNode = node.element(k).addElement(nodeType);
                taskNode.addElement("NodeGraphic").addAttribute("Height", "0").addAttribute("Width", "0");
                taskNode.addElement("NodeAttachment");
                taskNode.addAttribute("Key", key_);
                taskNode.addAttribute("Caption", caption_);
                taskNode.addAttribute("ID", String.valueOf(node.attributeValue("ID")) + "00" + (i + 1));
                JSONObject otherSetJson = obj.getJSONObject("OtherSet");
                block19: for (String kk : otherSetJson.keySet()) {
                    String vv = otherSetJson.getString(kk);
                    switch (kk) {
                        case "ProcessKey": 
                        case "TemplateKey": 
                        case "ValidType": 
                        case "FinishCondition": 
                        case "ValidCondition": 
                        case "PassType": 
                        case "PassCondition": 
                        case "CreateTrigger": 
                        case "FinishTrigger": {
                            if ("null".equals(vv) || !StringUtils.isNotEmpty((CharSequence)vv)) continue block19;
                            taskNode.addAttribute(kk, vv);
                            break;
                        }
                        case "InUse": {
                            if (!"false".equals(vv)) break;
                            taskNode.addAttribute(kk, vv);
                            break;
                        }
                        case "AutoIgnoreNoParticipator": {
                            if (!"true".equals(vv)) break;
                            taskNode.addAttribute(kk, vv);
                            break;
                        }
                    }
                }
                JSONObject permJson = obj.getJSONObject("Perm");
                if (permJson != null) {
                    if (taskNode.element("Perm") != null) {
                        taskNode.remove(taskNode.element("Perm"));
                    }
                    taskNode.addElement("Perm");
                    this.setXmlPerm(permJson, taskNode, "Perm", "OptPerm", "OptPermItem");
                    this.setXmlPerm(permJson, taskNode, "Perm", "VisiblePerm", "VisiblePermItem");
                    this.setXmlPerm(permJson, taskNode, "Perm", "EnablePerm", "EnablePermItem");
                }
                JSONArray operationCollectionJson = obj.getJSONArray("OperationCollection");
                this.setOperationCollectionXmlValue(taskNode, operationCollectionJson.toJSONString(), "OperationCollection");
                JSONObject participatorCollectionJson = obj.getJSONObject("ParticipatorCollection");
                if (participatorCollectionJson != null) {
                    if (taskNode.element("ParticipatorCollection") != null) {
                        taskNode.remove(taskNode.element("ParticipatorCollection"));
                    }
                    taskNode.addElement("ParticipatorCollection");
                    this.setXmlParticipatorCollection(participatorCollectionJson, taskNode, "ParticipatorCollection", "Dictionary");
                    this.setXmlParticipatorCollection(participatorCollectionJson, taskNode, "ParticipatorCollection", "Query");
                    this.setXmlParticipatorCollection(participatorCollectionJson, taskNode, "ParticipatorCollection", "MidFormula");
                }
                if ((timeJson = obj.getJSONArray("TimerItemCollection")) != null) {
                    this.setTimerItemCollectionXmlValue(taskNode, timeJson.toJSONString(), "TimerItemCollection");
                }
                ++i;
            }
        }
    }

    public void saveParticipatorCollectionToXml(Element node, String v, String k) {
        JSONObject valueJson;
        if ("\u5df2\u8bbe\u7f6e".equals(v)) {
            return;
        }
        if (node.element(k) != null) {
            node.remove(node.element(k));
        }
        node.addElement(k);
        if (StringUtils.isNotEmpty((CharSequence)v) && (valueJson = JSON.parseObject((String)(v = v.replaceAll("\"\"\\[", "\"[").replaceAll("]\"\"", "]").replaceAll("\"\\[", "[").replaceAll("]\"", "]").replaceAll("(\\\\r\\\\n)|\\\\n", "\\\n")))) != null) {
            this.setXmlParticipatorCollection(valueJson, node, k, "Dictionary");
            this.setXmlParticipatorCollection(valueJson, node, k, "Query");
            this.setXmlParticipatorCollection(valueJson, node, k, "MidFormula");
        }
    }

    public void setDataMapCollectionXmlValue(Element node, String v, String k) {
        JSONArray valueJson;
        if (node.element(k) != null) {
            node.remove(node.element(k));
        }
        node.addElement(k);
        if (StringUtils.isNotEmpty((CharSequence)v) && !CollectionUtils.isEmpty((Collection)(valueJson = JSON.parseArray((String)(v = v.replaceAll("\"\"\\[", "[").replaceAll("]\"\"", "]").replaceAll("\"\\[", "[").replaceAll("]\"", "]").replaceAll("(\\\\r\\\\n)|\\\\n", "\\\n")))))) {
            int j = 0;
            while (j < valueJson.size()) {
                JSONObject temp = valueJson.getJSONObject(j);
                Element billDataMapInfo = node.element(k).addElement("BillDataMapInfo");
                List<String> keySet = Arrays.asList("DataMapKey", "Caption", "AutoStart", "FormKey");
                for (String key : keySet) {
                    String value = temp.getString(key);
                    if (!StringUtils.isNotEmpty((CharSequence)value) || "AutoStart".equals(key) && "false".equals(value)) continue;
                    billDataMapInfo.addAttribute(key, value);
                }
                ++j;
            }
        }
    }

    private void setXmlParticipatorCollection(JSONObject participatorCollectionJson, Element node, String k, String elementName) {
        block27: {
            block25: {
                JSONArray jsonArray = participatorCollectionJson.getJSONArray(elementName);
                if (jsonArray == null || jsonArray.isEmpty()) break block25;
                if (node.element(k).elements(elementName) != null) {
                    List elements = node.element(k).elements(elementName);
                    elements.forEach(q -> {
                        boolean bl = node.element(k).remove(q);
                    });
                }
                HashMap<String, Map<String, String>> operatorMap = new HashMap<String, Map<String, String>>();
                operatorMap.put("Operator_ItemID", null);
                operatorMap.put("Operator_Code", null);
                HashMap<String, Map<String, String>> roleMap = new HashMap<String, Map<String, String>>();
                roleMap.put("Role_ItemID", null);
                roleMap.put("Role_Code", null);
                block10: for (String key : participatorCollectionJson.keySet()) {
                    JSONArray eachArray = participatorCollectionJson.getJSONArray(key);
                    switch (key) {
                        case "Dictionary": {
                            JSONObject jsonObject;
                            if (CollectionUtils.isEmpty((Collection)eachArray)) break;
                            int i = 0;
                            while (i < eachArray.size()) {
                                jsonObject = eachArray.getJSONObject(i);
                                if ("Operator".equals(jsonObject.getString("dictType"))) {
                                    this.getDictionaryMap(jsonObject, jsonObject.getString("dictType"), jsonObject.getString("codeType"), operatorMap);
                                } else {
                                    this.getDictionaryMap(jsonObject, jsonObject.getString("dictType"), jsonObject.getString("codeType"), roleMap);
                                }
                                ++i;
                            }
                            continue block10;
                        }
                        case "Query": {
                            JSONObject jsonObject;
                            if (node.element(k).elements(key) != null) {
                                node.element(k).elements(key).forEach(q -> {
                                    boolean bl = node.element(k).remove(q);
                                });
                            }
                            if (CollectionUtils.isEmpty((Collection)eachArray)) break;
                            int i = 0;
                            while (i < eachArray.size()) {
                                JSONArray array;
                                jsonObject = eachArray.getJSONObject(i);
                                Element queryEle = node.element(k).addElement(key).addCDATA(ConvertSpecialStringUtil.replaceSpecialString(jsonObject.getString("data")));
                                if (!(jsonObject.get((Object)"QueryParameterCollection") instanceof String) && !CollectionUtils.isEmpty((Collection)(array = jsonObject.getJSONArray("QueryParameterCollection")))) {
                                    Element queryParameterCollectionEle = queryEle.addElement("QueryParameterCollection");
                                    for (Object o : array) {
                                        JSONObject each = (JSONObject)o;
                                        queryParameterCollectionEle.addElement("QueryParameter").addAttribute("DataType", each.getString("DataType")).addAttribute("Formula", ConvertSpecialStringUtil.replaceSpecialString(each.getString("Formula")));
                                    }
                                }
                                ++i;
                            }
                            continue block10;
                        }
                        case "MidFormula": {
                            JSONObject jsonObject;
                            if (node.element(k).elements(key) != null) {
                                node.element(k).elements(key).forEach(q -> {
                                    boolean bl = node.element(k).remove(q);
                                });
                            }
                            if (CollectionUtils.isEmpty((Collection)eachArray)) break;
                            int i = 0;
                            while (i < eachArray.size()) {
                                jsonObject = eachArray.getJSONObject(i);
                                node.element(k).addElement(key).addCDATA(ConvertSpecialStringUtil.replaceSpecialString(jsonObject.getString("value")));
                                ++i;
                            }
                            continue block10;
                        }
                    }
                }
                if ("Dictionary".equals(elementName)) {
                    this.setDictionaryXmlValue(node, k, elementName, operatorMap, "Operator");
                    this.setDictionaryXmlValue(node, k, elementName, roleMap, "Role");
                }
                break block27;
            }
            node.element(k).remove(node.element(k).element(elementName));
        }
    }

    private void getDictionaryMap(JSONObject json, String dictType, String codeType, Map<String, Map<String, String>> dictMap) {
        HashMap<String, String> map = new HashMap<String, String>(10);
        String codeValue = json.getString("codeValue");
        if (dictMap.get(String.valueOf(dictType) + "_" + codeType) != null && StringUtils.isNotEmpty((CharSequence)dictMap.get(String.valueOf(dictType) + "_" + codeType).get(codeType))) {
            map.put(codeType, String.valueOf(dictMap.get(String.valueOf(dictType) + "_" + codeType).get(codeType)) + ":" + codeValue);
        } else {
            map.put(codeType, codeValue);
        }
        dictMap.put(String.valueOf(dictType) + "_" + codeType, map);
    }

    private void setDictionaryXmlValue(Element node, String k, String elementName, Map<String, Map<String, String>> map, String dictType) {
        String code;
        String itemId = map.get(String.valueOf(dictType) + "_ItemID") != null ? map.get(String.valueOf(dictType) + "_ItemID").get("ItemID") : "";
        String string = code = map.get(String.valueOf(dictType) + "_Code") != null ? map.get(String.valueOf(dictType) + "_Code").get("Code") : "";
        if (StringUtils.isNotEmpty((CharSequence)itemId) || StringUtils.isNotEmpty((CharSequence)code)) {
            Element dictionaryEle = node.element(k).addElement(elementName).addAttribute("ItemKey", dictType);
            if (StringUtils.isNotEmpty((CharSequence)itemId)) {
                dictionaryEle.addAttribute("ItemID", itemId);
            }
            if (StringUtils.isNotEmpty((CharSequence)code)) {
                dictionaryEle.addAttribute("Code", code);
            }
        }
    }

    private void setFrontDefaultValue(Node node, Map<String, String> otherAttributesMap, JSONObject nodeJson) {
        int length = 4;
        if (otherAttributesMap != null && otherAttributesMap.size() > 0) {
            length += otherAttributesMap.size();
        }
        Map<String, String> commonAttributesMap = this.setCommonAttributesToJson(node, length);
        if (otherAttributesMap != null && otherAttributesMap.size() > 0) {
            commonAttributesMap.putAll(otherAttributesMap);
        }
        this.setProps(commonAttributesMap, nodeJson);
    }

    public void saveAttributeToXml(Element node, JSONObject propsJsonObj, String attribute) {
        String v = propsJsonObj.getJSONObject(attribute).getString("value");
        if ("null".equals(v) || "undefined".equals(v)) {
            v = "";
        }
        if (StringUtils.isNotEmpty((CharSequence)v)) {
            node.addAttribute(attribute, v);
        } else {
            this.deleteXmlElementAttribute(node, node.attribute(attribute));
        }
    }

    public void saveAttributeCdataToXml(Element node, JSONObject propsJsonObj, String attribute) {
        String v;
        if (node.element(attribute) != null) {
            node.remove(node.element(attribute));
        }
        if ("null".equals(v = propsJsonObj.getJSONObject(attribute).getString("value"))) {
            v = "";
        }
        if (StringUtils.isNotEmpty((CharSequence)v)) {
            node.addElement(attribute).addText("<![CDATA[" + v + "]]>");
        }
    }

    private NodeGraphic saveNodeGraphic(JSONObject operNodeJson, Element node) {
        NodeGraphic graphic = new NodeGraphic();
        JSONObject attr = operNodeJson.getJSONObject("attr");
        Integer height = attr.getInteger("height");
        Integer width = attr.getInteger("width");
        Integer x = attr.getInteger("x");
        Integer y = attr.getInteger("y");
        graphic.setHeight(height);
        graphic.setWidth(width);
        graphic.setX(x);
        graphic.setY(y);
        if (node.element("NodeGraphic") != null) {
            node.remove(node.element("NodeGraphic"));
        }
        node.addElement("NodeGraphic").addAttribute("Height", graphic.getHeight() < 48 ? "48" : String.valueOf(height)).addAttribute("Width", graphic.getWidth() < 48 ? "48" : String.valueOf(width)).addAttribute("X", graphic.getX() < 150 ? "150" : String.valueOf(x)).addAttribute("Y", String.valueOf(y));
        return graphic;
    }

    private Map<String, String> setCommonAttributesToJson(Node node, int length) {
        HashMap<String, String> commonAttributesMap = new HashMap<String, String>(length);
        commonAttributesMap.put("NodeType", node.getNodeType());
        commonAttributesMap.put("ID", node.getID());
        commonAttributesMap.put("Key", node.getKey());
        commonAttributesMap.put("Caption", node.getCaption());
        return commonAttributesMap;
    }

    private void setProps(Map<String, String> commonAttributesMap, JSONObject nodeJson) {
        for (Map.Entry<String, String> map : commonAttributesMap.entrySet()) {
            String key = map.getKey();
            JSONObject v = new JSONObject();
            v.put("value", (Object)map.getValue());
            nodeJson.put(key, (Object)v);
        }
    }

    public boolean deleteXmlElementAttribute(Element element, Attribute attribute) {
        if (attribute != null) {
            return element.remove(attribute);
        }
        return false;
    }

    public static Logger getLogger() {
        return logger;
    }

    public String getNodeType() {
        return this.NodeType;
    }

    public void setNodeType(String nodeType) {
        this.NodeType = nodeType;
    }

    public String getID() {
        return this.ID;
    }

    public void setID(String ID) {
        this.ID = ID;
    }

    public String getKey() {
        return this.Key;
    }

    public void setKey(String key) {
        this.Key = key;
    }

    public String getCaption() {
        return this.Caption;
    }

    public void setCaption(String caption) {
        this.Caption = caption;
    }

    public NodeGraphic getNodeGraphic() {
        return this.NodeGraphic;
    }

    public void setNodeGraphic(NodeGraphic nodeGraphic) {
        this.NodeGraphic = nodeGraphic;
    }

    public String getImage() {
        return this.Image;
    }

    public void setImage(String image) {
        this.Image = image;
    }

    public String getBPMState() {
        return this.BPMState;
    }

    public void setBPMState(String BPMState) {
        this.BPMState = BPMState;
    }

    public String getWorkitemRevoke() {
        return this.WorkitemRevoke;
    }

    public void setWorkitemRevoke(String workitemRevoke) {
        this.WorkitemRevoke = workitemRevoke;
    }

    public String getIsSync() {
        return this.IsSync;
    }

    public void setIsSync(String isSync) {
        this.IsSync = isSync;
    }
}

