/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.desigerfunction.datasource;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bokesoft.entity.BaseContextAction;
import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.design.vo.Exp;
import com.bokesoft.yes.design.vo.Para;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.javadoc.Javadoc;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class GenerateFunctionsJsonFile {
    private static final Logger logger = Logger.getLogger(GenerateFunctionsJsonFile.class.getName());
    private static final Integer POOL_SIZE = 5;
    private static ThreadPoolExecutor executor;
    public static final String END_JSON_FILE = "/json/endFuns.json";
    public static String FunctionsJson;

    public static String getFunctionsJson() throws IOException {
        if (StringUtils.isBlank((CharSequence)FunctionsJson)) {
            String jsonContent = GenerateFunctionsJsonFile.readFromFile();
            if (StringUtils.isNotEmpty((CharSequence)jsonContent)) {
                FunctionsJson = jsonContent;
            } else {
                GenerateFunctionsJsonFile.generateFunctionsJsonFile();
                GenerateFunctionsJsonFile.writeToFile(FunctionsJson);
            }
        }
        return FunctionsJson;
    }

    private static String readFromFile() throws IOException {
        StringBuilder jsonFileContent;
        block3: {
            block2: {
                jsonFileContent = new StringBuilder();
                String designerJsonFilePath = WebDesignerConfiguration.getDesignerJsonFilePath();
                File file = new File(designerJsonFilePath);
                if (!file.exists()) break block2;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String read = "";
                while ((read = bufferedReader.readLine()) != null) {
                    jsonFileContent.append(read).append("\n");
                }
                break block3;
            }
            InputStream inputStream = GenerateFunctionsJsonFile.class.getResourceAsStream(END_JSON_FILE);
            if (!Objects.nonNull(inputStream)) break block3;
            InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            BufferedReader bufferedReader = new BufferedReader(reader);
            String read = "";
            while ((read = bufferedReader.readLine()) != null) {
                jsonFileContent.append(read).append("\n");
            }
        }
        return jsonFileContent.toString();
    }

    public static void writeToFile(String functionsJson) {
        try {
            if (GenerateFunctionsJsonFile.isJar(WebDesignerConfiguration.class).booleanValue()) {
                return;
            }
            String resourcePath = WebDesignerConfiguration.getDesignerJsonFilePath();
            FileWriter fileWriter = new FileWriter(resourcePath);
            fileWriter.write(functionsJson);
            fileWriter.close();
            logger.info("JSON \u5199\u5165\u6587\u4ef6\u6210\u529f\u3002");
        }
        catch (IOException e) {
            LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
        }
    }

    private static String getJsonFilePath() {
        String classPath = GenerateFunctionsJsonFile.getAbsolutePath(WebDesignerConfiguration.class);
        String resourcePath = classPath.substring(0, classPath.indexOf("java"));
        return String.valueOf(resourcePath) + "resources" + File.separator + END_JSON_FILE;
    }

    public static void generateFunctionsJsonFile() {
        final HashMap<String, String> map = new HashMap<String, String>();
        StringBuilder buf = new StringBuilder();
        try {
            Reflections reflections = new Reflections("com.bokesoft", new Scanner[0]);
            Set classes = reflections.getSubTypesOf(BaseContextAction.class);
            ArrayList<Set> sets = GenerateFunctionsJsonFile.splitClasses(classes, POOL_SIZE);
            final CountDownLatch latch = new CountDownLatch(sets.size());
            ArrayList<Future<String>> futures = new ArrayList<Future<String>>();
            executor = new ThreadPoolExecutor((int)POOL_SIZE, (int)POOL_SIZE, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), new ThreadPoolExecutor.AbortPolicy());
            for (final Set set : sets) {
                Future<String> future = executor.submit(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        StringBuilder keywords = new StringBuilder();
                        GenerateFunctionsJsonFile.generateFunctionMap(set, keywords, map);
                        latch.countDown();
                        return keywords.toString();
                    }
                });
                futures.add(future);
            }
            latch.await();
            for (Future future : futures) {
                buf.append(future.get());
            }
            map.put("keyWords", buf.toString());
            executor.shutdown();
            FunctionsJson = JSON.toJSONString(map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.PrettyFormat});
        }
        catch (Throwable e) {
            logger.warning(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private static ArrayList<Set> splitClasses(Set<Class<? extends BaseContextAction>> classes, Integer subNum) {
        ArrayList<Set> classesArr = new ArrayList<Set>();
        int size = classes.size();
        int perSize = size / subNum;
        int start = 0;
        int end = 0;
        int i = 0;
        while (i < subNum) {
            start = i * perSize;
            end = (i + 1) * perSize;
            if (i == subNum - 1) {
                end = size;
            }
            HashSet<Class<? extends BaseContextAction>> subClasses = new HashSet<Class<? extends BaseContextAction>>();
            Iterator<Class<? extends BaseContextAction>> iterator = classes.iterator();
            int j = 0;
            while (iterator.hasNext()) {
                Class<? extends BaseContextAction> next = iterator.next();
                if (j >= start && j < end) {
                    subClasses.add(next);
                }
                ++j;
            }
            classesArr.add(subClasses);
            ++i;
        }
        return classesArr;
    }

    private static void generateFunctionMap(Set<Class<? extends BaseContextAction>> classes, StringBuilder buf, Map<String, Object> map) throws FileNotFoundException {
        for (Class<? extends BaseContextAction> clazz : classes) {
            Method[] methods = clazz.getDeclaredMethods();
            if (methods.length <= 0) continue;
            Exp exp = null;
            Para para = null;
            ArrayList<Para> paras = null;
            Map<String, String> methodExpMap = GenerateFunctionsJsonFile.extSetDescDetail(clazz);
            Method[] methodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.toString().startsWith("public ")) {
                    String descDetail;
                    exp = new Exp();
                    if ("com.bokesoft.erp.ShortNameFunction".equals(clazz.getName())) {
                        exp.setKey(method.getName());
                    } else {
                        exp.setKey(String.valueOf(clazz.getName()) + "." + method.getName());
                    }
                    exp.setDesc("");
                    buf.append(exp.getKey());
                    buf.append(" ");
                    paras = new ArrayList<Para>();
                    StringBuilder paraSBuilder = new StringBuilder();
                    Class<?>[] getTypeParameters = method.getParameterTypes();
                    if (getTypeParameters.length == 0) {
                        exp.setDescDetail("\u6b64\u65b9\u6cd5\u65e0\u53c2\u6570");
                    }
                    StringBuilder params = new StringBuilder();
                    Parameter[] getParameters = method.getParameters();
                    if (getParameters != null && getParameters.length > 0) {
                        String parameterTypeName = "";
                        int i = 0;
                        while (i < getParameters.length) {
                            para = new Para();
                            if (getTypeParameters.length > 0) {
                                parameterTypeName = getTypeParameters[i].getName();
                            }
                            para.setKey(getParameters[i].getName());
                            para.setOptional("true");
                            if (StringUtils.isNotEmpty((CharSequence)parameterTypeName)) {
                                para.setType(parameterTypeName.replaceAll("\\[L", "").replaceAll("\\;", ""));
                                para.setDesc("\u53c2\u6570" + (i + 1) + "\uff1a" + getParameters[i].getName() + ", \u53c2\u6570\u7c7b\u578b:" + para.getType() + "; ");
                                paraSBuilder.append(para.getDesc());
                                params.append(getParameters[i].getName()).append(",");
                            } else {
                                para.setType("");
                                para.setDesc("");
                            }
                            paras.add(para);
                            ++i;
                        }
                    }
                    Type t = method.getAnnotatedReturnType().getType();
                    exp.setReturnValueType(t.getTypeName());
                    exp.setPlatform("All");
                    if (methodExpMap.containsKey(exp.getKey()) && StringUtils.isNotEmpty((CharSequence)(descDetail = methodExpMap.get(exp.getKey())))) {
                        exp.setDescDetail(descDetail);
                    } else {
                        exp.setDescDetail(paraSBuilder + "\u8fd4\u56de\u7c7b\u578b\uff1a" + t.getTypeName());
                    }
                    exp.setParas(paras);
                    String functionName = "";
                    functionName = "com.bokesoft.erp.ShortNameFunction".equals(clazz.getName()) ? method.getName() : String.valueOf(clazz.getName()) + "." + method.getName();
                    if (params.length() > 0) {
                        map.put(String.valueOf(functionName) + "(" + params.substring(0, params.toString().lastIndexOf(",")) + ")", exp);
                    } else {
                        map.put(String.valueOf(functionName) + "()", exp);
                    }
                }
                ++n2;
            }
        }
    }

    public static Map<String, String> extSetDescDetail(Class<?> cls) throws FileNotFoundException {
        File file;
        String absolutePath = GenerateFunctionsJsonFile.getAbsolutePath(cls);
        String name = cls.getName();
        HashMap<String, String> methodMap = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)absolutePath) && (file = new File(absolutePath)).exists()) {
            CompilationUnit cu = StaticJavaParser.parse((File)file);
            cu.findAll(MethodDeclaration.class).forEach(method -> {
                String methodName = String.valueOf(name) + "." + method.getName().asString();
                Javadoc javadoc = method.getJavadoc().orElse(null);
                String comment = "";
                if (javadoc != null) {
                    comment = javadoc.getDescription().toText().replaceAll("[\\n\\r\\t/*]", "").trim();
                }
                methodMap.put(methodName, comment);
                methodMap.put(method.getName().asString(), comment);
            });
        }
        return methodMap;
    }

    public static String getAbsolutePath(Class<?> cls) {
        String classFileParentPath;
        block5: {
            classFileParentPath = new File(Objects.requireNonNull(cls.getResource(String.valueOf(cls.getSimpleName()) + ".class")).getFile()).getParent();
            String sourceFileParentPath = classFileParentPath.replace("target\\classes", "src\\main\\java");
            File dir = new File(sourceFileParentPath);
            if (dir.exists()) {
                return String.valueOf(sourceFileParentPath) + File.separator + cls.getSimpleName() + ".java";
            }
            if (!GenerateFunctionsJsonFile.isJar(cls).booleanValue() && classFileParentPath.contains("target")) break block5;
            return "";
        }
        try {
            String modulePath = classFileParentPath.substring(0, classFileParentPath.indexOf("target"));
            List<String> parentPaths = GenerateFunctionsJsonFile.findFilePaths(modulePath, "com.bokesoft");
            for (String parentPath : parentPaths) {
                String sourcePath = String.valueOf(parentPath) + File.separator + cls.getName().replace(".", File.separator) + ".java";
                File sourceFile = new File(sourcePath);
                if (!sourceFile.exists()) continue;
                return sourcePath;
            }
        }
        catch (Exception e) {
            LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
        }
        return "";
    }

    public static Boolean isJar(Class<?> cls) {
        String classFileParentPath = new File(Objects.requireNonNull(cls.getResource(String.valueOf(cls.getSimpleName()) + ".class")).getFile()).getParent();
        return classFileParentPath.contains(".jar");
    }

    public static List<String> findFilePaths(String modulePath, String packageName) {
        ArrayList<String> filePaths = new ArrayList<String>();
        File[] modulePaths = new File(String.valueOf(modulePath) + "src\\main").listFiles();
        if (Objects.isNull(modulePaths)) {
            return filePaths;
        }
        File[] fileArray = modulePaths;
        int n = modulePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String packagePath;
            File packageDir;
            File module = fileArray[n2];
            if (module.isDirectory() && !StringUtils.equals((CharSequence)module.getName(), (CharSequence)"resources") && (packageDir = new File(packagePath = module + File.separator + packageName.replace(".", File.separator))).exists() && packageDir.isDirectory()) {
                filePaths.add(module.getAbsolutePath());
            }
            ++n2;
        }
        return filePaths;
    }
}

