/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.all.controller;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.common.util.Base64;
import com.bokesoft.yes.design.utils.TwoTuple;
import com.bokesoft.yes.design.utils.XmlFormat;
import com.bokesoft.yes.design.utils.publicMethodUtil;
import com.bokesoft.yes.design.vo.JsonDesignerVo;
import com.bokesoft.yes.design.vo.ResponseResult;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.tools.zip.GZIPTools;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/DesignerController"})
public class DesignerController {
    @PostMapping(value={"/checkColumn"})
    @ResponseBody
    public ResponseResult<String> checkColumn(@RequestBody JsonDesignerVo jsonDesignerVo) throws Throwable {
        String columnInfo;
        MetaDataObject dataObject;
        String formkey = jsonDesignerVo.getFormKey();
        String columnKey = jsonDesignerVo.getColumnKey();
        MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(formkey);
        if (!"".equals(metaForm.getDataSource().getRefObjectKey())) {
            dataObject = MetaFactory.getGlobalInstance().getDataObject(metaForm.getDataSource().getRefObjectKey());
            columnInfo = this.getColumnInfo(columnKey, dataObject);
        } else {
            dataObject = metaForm.getDataSource().getDataObject();
            columnInfo = this.getColumnInfo(columnKey, dataObject);
        }
        ResponseResult<String> response = new ResponseResult<String>();
        response.setData(columnInfo);
        return response;
    }

    @PostMapping(value={"/formatXML"})
    @ResponseBody
    public ResponseResult<JSONObject> formatXML(@RequestBody JsonDesignerVo jsonDesignerVo) throws Throwable {
        ResponseResult<JSONObject> response = new ResponseResult<JSONObject>();
        JSONObject jsonObject = new JSONObject();
        String yigoData = jsonDesignerVo.getYigoData();
        if (yigoData != null) {
            byte[] bytes = Base64.decode((byte[])yigoData.getBytes());
            String resultDate = GZIPTools.decompress((InputStream)new ByteArrayInputStream(bytes), (String)"UTF-8");
            JSONObject jsonObject1 = JSONObject.parseObject((String)resultDate);
            jsonDesignerVo.setFormKey(jsonObject1.getString("formKey"));
            jsonDesignerVo.setColumnKey(jsonObject1.getString("columnKey"));
            jsonDesignerVo.setTableKey(jsonObject1.getString("tableKey"));
            jsonDesignerVo.setType(jsonObject1.getString("type"));
        }
        String formkey = jsonDesignerVo.getFormKey();
        try {
            String result = XmlFormat.formatXML_str(formkey);
            jsonObject.put("msg", (Object)result);
            response.setData(jsonObject);
            return response;
        }
        catch (Exception e) {
            jsonObject.put("msg", (Object)("false_" + e.getMessage()));
            response.setData(jsonObject);
            return response;
        }
    }

    @PostMapping(value={"/openFileLocation"})
    @ResponseBody
    public ResponseResult<JSONObject> openFileLocation(@RequestBody JsonDesignerVo jsonDesignerVo) {
        ResponseResult<JSONObject> response = new ResponseResult<JSONObject>();
        JSONObject jsonObject = new JSONObject();
        try {
            String filePath = jsonDesignerVo.getFormKey();
            File file = new File(filePath);
            boolean windows = System.getProperty("os.name").toLowerCase().contains("windows");
            boolean linux = System.getProperty("os.name").toLowerCase().contains("linux");
            if (windows) {
                if ("1".equals(jsonDesignerVo.getType())) {
                    Runtime.getRuntime().exec("rundll32 SHELL32.DLL,ShellExec_RunDLL Explorer.exe /select," + file.getAbsolutePath());
                } else {
                    Runtime.getRuntime().exec("rundll32 shell32,OpenAs_RunDLL " + filePath);
                }
            } else if (linux) {
                String folderPath = FilePathHelper.toBackFilePath(filePath);
                String command = "gnome".equalsIgnoreCase(System.getProperty("sun.desktop")) ? "nautilus" : ("kde".equalsIgnoreCase(System.getProperty("sun.desktop")) ? "dolphin" : "xdg-open");
                try {
                    String[] envp = new String[]{command, folderPath};
                    Runtime.getRuntime().exec(envp);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if ("1".equals(jsonDesignerVo.getType())) {
                String[] envp = new String[]{"/usr/bin/open", file.getParent()};
                Runtime.getRuntime().exec(envp);
            } else {
                String[] envp = new String[]{"/usr/bin/open", filePath};
                Runtime.getRuntime().exec(envp);
            }
            jsonObject.put("msg", (Object)"\u64cd\u4f5c\u6210\u529f!");
            response.setCode(0);
            response.setMsg("\u8fd4\u56de\u6210\u529f");
            response.setData(jsonObject);
            return response;
        }
        catch (IOException e) {
            jsonObject.put("msg", (Object)("\u64cd\u4f5c\u5931\u8d25,\u5931\u8d25\u539f\u56e0\u4e3a: " + e.getMessage()));
            response.setCode(-99);
            response.setMsg("\u8fd4\u56de\u6210\u529f");
            response.setData(jsonObject);
            return response;
        }
    }

    @PostMapping(value={"/checkComponent"})
    @ResponseBody
    public ResponseResult<JSONObject> checkComponent(@RequestBody JsonDesignerVo jsonDesignerVo) throws Throwable {
        ResponseResult<JSONObject> response = new ResponseResult<JSONObject>();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("msg", (Object)"false");
        response.setData(jsonObject);
        MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(jsonDesignerVo.getFormKey());
        metaForm.getAllUIComponents().keySet().forEach(key -> {
            if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)jsonDesignerVo.getColumnKey())) {
                jsonObject.put("msg", (Object)"true");
                response.setData(jsonObject);
            }
        });
        return response;
    }

    @PostMapping(value={"/isHasColumnAndTableKey"})
    @ResponseBody
    public ResponseResult<JSONObject> isHasColumnAndTableKey(@RequestBody JsonDesignerVo jsonDesignerVo) throws Throwable {
        String str = "success";
        String type = jsonDesignerVo.getType();
        String formKey = jsonDesignerVo.getFormKey();
        String columnKey = jsonDesignerVo.getColumnKey();
        String tableKey = jsonDesignerVo.getTableKey();
        TwoTuple<MetaForm, MetaDataObject> twoTuple = publicMethodUtil.MetaFormOrMetaDataObject(formKey);
        boolean metaFormNotNull = twoTuple.metaForm != null;
        boolean metaDataObjectNotNull = twoTuple.metaDataObject != null;
        MetaForm metaForm = (MetaForm)twoTuple.metaForm;
        MetaDataObject metaDataObject = (MetaDataObject)twoTuple.metaDataObject;
        if ("TableKey".equals(type)) {
            MetaTable table;
            if (metaFormNotNull) {
                table = metaForm.getDataSource().getDataObject().getTable(tableKey);
                if (table != null) {
                    str = "\u5f53\u524d\u6dfb\u52a0\u7684\u8868\u6807\u8bc6 <span style = 'color:red;font-size:14px'>" + tableKey + "</span>" + " \u5df2\u7ecf\u5b58\u5728,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0";
                }
            } else if (metaDataObjectNotNull && (table = metaDataObject.getTable(tableKey)) != null) {
                str = "\u5f53\u524d\u6dfb\u52a0\u7684\u8868\u6807\u8bc6 <span style = 'color:red;font-size:14px'>" + tableKey + "</span>" + " \u5df2\u7ecf\u5b58\u5728,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0";
            }
        } else if ("ColumnKey".equals(type)) {
            MetaColumn metaColumn;
            if (metaFormNotNull) {
                metaColumn = metaForm.getDataSource().getDataObject().findColumn(tableKey, columnKey);
                if (metaColumn != null) {
                    str = "\u5f53\u524d\u6dfb\u52a0\u7684\u5217\u6807\u8bc6 <span style = 'color:red;font-size:14px'>" + columnKey + "</span>" + " \u5df2\u7ecf\u5b58\u5728,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0";
                }
            } else if (metaDataObjectNotNull && (metaColumn = metaDataObject.findColumn(tableKey, columnKey)) != null) {
                str = "\u5f53\u524d\u6dfb\u52a0\u7684\u5217\u6807\u8bc6 <span style = 'color:red;font-size:14px'>" + columnKey + "</span>" + " \u5df2\u7ecf\u5b58\u5728,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0";
            }
        }
        ResponseResult<JSONObject> response = new ResponseResult<JSONObject>();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("msg", (Object)str);
        response.setData(jsonObject);
        return response;
    }

    private String getColumnInfo(String columnKey, MetaDataObject dataObject) {
        for (MetaTable Table : dataObject.getTableCollection()) {
            if (dataObject.findColumn(Table.getKey(), columnKey) == null) continue;
            MetaColumn column = dataObject.findColumn(Table.getKey(), columnKey);
            return String.valueOf(column.getKey()) + " " + column.getCaption();
        }
        return "";
    }
}

