/***表达式数据源 2021-09-28*/
let functions = [];
let funcList = [];
let funcDescList = [];
let paramDescList = [];
let returnValueDescList = [];
let componentIdList = [];
let componentDescList = [];
let macroIdList = [];
let macroDescList = [];
let yigoFnKw= [];
let editor;
let db;

/***
 * 打开
 * @returns {Promise<unknown>}
 */
function openDB(dbName) {
    return new Promise((resolve, reject) => {
        // 判断是否已经打开数据库
        if (this.db) {
            resolve(this.db);
        } else {
            const request = window.indexedDB.open(dbName || 'formuladb');
            // 首次创建数据库
            request.onupgradeneeded = function(event) {
                const db = event.target.result;
                let objectStore;
                if (!db.objectStoreNames.contains('formulaRecords')) {
                    objectStore = db.createObjectStore('formulaRecords', { keyPath: 'name' });
                    objectStore.createIndex('name', 'name', { unique: false });
                }
            }
            request.onsuccess = function(event) {
                this.db = request.result;
                resolve(request.result);
            }
            request.onerror = function(error) {
                reject(error);
            }
        }
    })
}

async function getDB() {
    db = await openDB('formuladb');
}

getDB().then(()=>{
    console.log("数据库创建成功");
});

// 装载后台数据源
async function loadDataSource() {
    let requests = [];
    let requestMacro = getBackendData("macro", "");
    let requestForm = getBackendData("form", parent.YIUI.FormStack.getTargetFormKey());
    requests.push(requestMacro);
    requests.push(requestForm);
    if ((!funcList || funcList.length == 0) && !localStorage.getItem("isInitLoadingFuncList")) {
        localStorage.setItem("isInitLoadingFuncList", "true");
        let requestFunction = getBackendData("function", "");
        requests.push(requestFunction);
        await Promise.all(requests)
            .then(res => {
                console.log(res);
            })
            .catch (err => {
                console.log(err);
            });
    } else {
        if (funcList && funcList.length > 0) {
            await Promise.all(requests)
                .then(res => {
                    console.log(res);
                })
                .catch (err => {
                    console.log(err);
                });
        }
    }
}

// 更新
async function update(jsonObj) {
    if (!db) {
        db = await openDB();
    }
    return new Promise((resolve, reject)=>{
        let request = db.transaction(['formulaRecords'], 'readwrite')
            .objectStore('formulaRecords')
            .put(jsonObj);

        request.onsuccess = function (event) {
            resolve('数据更新成功');
        };

        request.onerror = function (event) {
            reject('数据更新失败');
        }
    });
}

/***
 * 获取所有数据
 * @param name
 * @returns {Promise<unknown>}
 */
async function getAllData() {
    if (!db) {
        db = await openDB();
    }
    return new Promise((resolve, reject) => {
        let tx = db.transaction("formulaRecords");
        tx.objectStore("formulaRecords").openCursor().onsuccess = function (event) {
            let cursor = event.target.result;
            if (cursor) {
                let name = cursor.value.name;
                let value = cursor.value.value;
                switch (name) {
                    case "funcList":funcList = value ? value.split("@~@") : null;break;
                    case "funcDescList":funcDescList = value ? value.split("@~@") : null;break;
                    case "paramDescList":paramDescList = value ? value.split("@~@") : null;break;
                    case "returnValueDescList":returnValueDescList = value ? value.split("@~@") : null;break;
                    case "macroIdList":macroIdList = value ? value.split("@~@") : null;break;
                    case "macroDescList":macroDescList = value ? value.split("@~@") : null;break;
                    case "componentIdList":componentIdList = value ? value.split("@~@") : null;break;
                    case "componentDescList":componentDescList = value ? value.split("@~@") : null;break;
                    case "yigoFnKw":yigoFnKw = value ? value.split("@~@") : null;break;
                }
                cursor.continue();
            }
        };
        tx.oncomplete = function(event) {
            resolve("获取全部数据成功");
        }
        tx.onerror = function(event) {
            reject(e);
        }
    });
}

// 根据formKey获取form
parent.YIUI.FormStack.getFormByKey = function(formKey) {
    for (let i = 0; i < this.formList.length; i++) {
        if (formKey == this.formList[i].formKey) {
            return this.formList[i];
        }
    }
}

// 获取目标表单key
parent.YIUI.FormStack.getTargetFormKey = function() {
    for (let i = 0; i < this.formList.length; i++) {
        if (1 == this.formList[i].operationState) {
            return this.formList[i].formKey;
        }
    }
}

// 获取操作系统类型
function getOperationSysemType() {
    if (navigator.userAgent.indexOf("Window")>0) {
        return "Windows";
    } else if(navigator.userAgent.indexOf("Mac OS X")>0) {
        return "Mac";
    } else if(navigator.userAgent.indexOf("Linux")>0) {
        return "Linux";
    } else {
        return "NUll";
    }
}

// 异步获取后台表达式数据
function getBackendData(dataType,currentFormKey) {
    return new Promise((resolve, reject)=>{
        // 异步调用
        let getAsyncRequest = function(params, successCallBack) {
            let url = parent.Svr.SvrMgr.ServletURL;
            new parent.Svr.Request().getAsyncData(url, params, successCallBack);
        }

        let params = {
            cmd: "ExpAutoComplete",
            service: "DesignService",
            dataType: dataType,
            currentFormKey : currentFormKey
        };

        getAsyncRequest(params,function(data) {
            localStorage.removeItem("isInitLoadingFuncList");
            if (!data) {
                console.log("请求后台函数提醒功能失败");
                reject(false);
            }
            let rs = $.parseJSON(data);
            if (rs) {
                if (rs.errors) {
                    DESIGNER.UI.showTip(rs.errors, 50, 8);
                    reject(false);
                }

                //添加后刷新函数表格
                if (rs.funcList && rs.funcList.length > 0) {
                    update({name:'funcList', value:rs.funcList[0]})
                        .then((res)=>{});
                }
                if (rs.funcDescList && rs.funcDescList.length > 0) {
                    update({name:'funcDescList', value:rs.funcDescList[0]})
                        .then((res)=>{});
                }
                if (rs.paramDescList && rs.paramDescList.length > 0) {
                    update({name:'paramDescList', value:rs.paramDescList[0]})
                        .then((res)=>{});
                }
                if (rs.returnValueDescList && rs.returnValueDescList.length > 0) {
                    update({name:'returnValueDescList', value:rs.returnValueDescList[0]})
                        .then((res)=>{});
                }
                if (rs.macroIdList && rs.macroIdList.length > 0) {
                    update({name:'macroIdList', value:rs.macroIdList[0]})
                        .then((res)=>{});
                }
                if (rs.macroDescList && rs.macroDescList.length > 0) {
                    update({name:'macroDescList', value:rs.macroDescList[0]})
                        .then((res)=>{});
                }
                if (rs.componentIdList && rs.componentIdList.length > 0) {
                    update({name:'componentIdList', value:rs.componentIdList[0]})
                        .then((res)=>{});
                }
                if (rs.componentDescList && rs.componentDescList.length > 0) {
                    update({name:'componentDescList', value:rs.componentDescList[0]})
                        .then((res)=>{});
                }
                if (rs.keyWords && rs.keyWords.length > 0) {
                    update({name:'yigoFnKw', value:rs.keyWords[0]})
                        .then((res)=>{});
                }
                resolve(true);
            }
        });
    });
}

function createCodemirror() {
    // 获取表达式编辑的表单
    let form = parent.YIUI.FormStack.getFormByKey("D_FormulaPopWin");
    let cxt = new parent.View.Context(form);
    let args = [];
    args[0] = "ForumlaContent";
    // 设置修改前的值到codeMirror编辑器中
    let oldValue = parent.BaseFuns.GetValue(null, "ForumlaContent", cxt, args);
    if (oldValue && oldValue.toString().indexOf("@br@") != -1) {
        let replaceStr = "\r\n";
        if (getOperationSysemType() == "Windows") {
            replaceStr = "\r\n";
        } else if (getOperationSysemType() == "Mac") {
            replaceStr = "\r";
        } else if (getOperationSysemType() == "Linux") {
            replaceStr = "\n";
        }
        oldValue = oldValue.replace(/@br@/g, replaceStr);
    }
    // 获取textarea组件
    let formulaContent = document.getElementById("formulaContent");
    editor = CodeMirror.fromTextArea(formulaContent, {
        // theme: "dracula",
        indentWithTabs: true,
        smartIndent: true,
        styleActiveLine: true,
        lineNumbers: true,
        lineWrapping: true,
        matchBrackets: true,
        textWrapping: true,
        autoCloseTags: true,//自动关闭tag
        autoCloseBrackets: true,//自动括号
        foldGutter: true,
        gutters: ["CodeMirror-linenumbers", "CodeMirror-foldgutter", "CodeMirror-lint-markers"],
        mode: "text/x-yigo",
        // mode: {name: "javascript", globalVars: true},
        extraKeys: {
            "Tab": "autocomplete",
            "F11": function (cm) {
                cm.setOption("fullScreen", !cm.getOption("fullScreen"));
            },
            "Esc": function (cm) {
                if (cm.getOption("fullScreen")) cm.setOption("fullScreen", false);
            }
        },
        textHover: true
    });

    // 编辑器设置
    // editor.setOption("readOnly", false);
    editor.setSize('auto', '485px');//宽度自动，高度485px
    editor.refresh();
    editor.setOption("readOnly", false);
    editor.setValue(String(oldValue));

    editor.on('focus', function (cm, event) {
        isValueDependencyHtmlFocus = false;
    });

    editor.on('change', function (cm, event) {
        fillParentTextArea(cm, event, cxt);
    });

    editor.on('blur', function (cm, event) {
        fillParentTextArea(cm, event, cxt);
    });

    // keyup将中文标点符号变成英文的
    editor.on('keyup', function (cm, event) {
        isValueDependencyHtmlFocus = false;
        if (event.keyCode == 229) {
            let currentContent = editor.getValue();
            if (!currentContent) {
                return editor.getValue();
            }

            // 要替换的字符所在位置
            let charPos = 1;
            if (currentContent.indexOf("；") != -1) {
                charPos = currentContent.indexOf("；") + 1;
                editor.setValue(editor.getValue().replace(/\；/ig, ';'));
            } else if (currentContent.indexOf("，") != -1) {
                charPos = currentContent.indexOf("，") + 1;
                editor.setValue(editor.getValue().replace(/\，/ig, ','));
            } else if (currentContent.indexOf("（") != -1) {
                charPos = currentContent.indexOf("（") + 1;
                editor.setValue(editor.getValue().replace(/\（/ig, '('));
            } else if (currentContent.indexOf("）") != -1) {
                charPos = currentContent.indexOf("）") + 1;
                editor.setValue(editor.getValue().replace(/\）/ig, ')'));
            }

            // 如果不是第一个位置，就移动光标到charPos位置
            if (charPos > 1) {
                for (let i = 1; i <= charPos; i++) {
                    editor.execCommand("goCharRight");
                }
            }
        }
    });
}

// 填充到父窗体的textarea中
function fillParentTextArea(cm, event, cxt) {
    try {
        if (editor.getOption("readOnly")) return;
        let afterValue = codeMirrorAutoComplete(isShow, event, cm, editor);
        let args = [];
        args[0] = "ForumlaContent";
        args[1] = afterValue;
        parent.BaseFuns.SetValue(null, "ForumlaContent", cxt, args);
    } catch (e) {
        console.error(e);
    }
}

// getData函数
function getData(params, successCallBack) {
    let url = parent.Svr.SvrMgr.ServletURL;
    new parent.Svr.Request().getSyncData(url, params, successCallBack);
}

// init表格
function initTable() {
    // 依赖字段文本域是否点击
    let isValueDependencyHtmlFocus = false;
    $("#ValueDependencyHtml").click(function () {
        isValueDependencyHtmlFocus = true;
    });

    //搜索事件
    $('.search').keyup(function () {
        let keyword = this.value;
        let type = $(this).attr('type');
        switch (type) {
            case 'macro':
                getFunctionList(this, keyword);
                break;
            case 'form':
                getFormList(this, keyword);
                break;
            case 'fieldKey':
                getFieldList(this, keyword);
                break;
        }
    });

    //右侧导航条点击
    $('.spanButton').click(function () {
        if ($(this).hasClass('active')) {
            $(this).removeClass('active');
            $(this).css("font-weight", "");
            $(this).css("color", "black");
            $(this).parent().parent().children().not(".message").hide();
        } else {
            let active = $('.spanButton.active');
            active.parent().parent().children().not(".message").hide();
            active.css("font-weight", "");
            active.css("color", "black");
            active.removeClass('active');
            $(this).addClass('active');
            $(this).css("font-weight", "bold");
            $(this).css("color", "#0c8eff");
            $(this).parent().parent().children().show();
        }
        // 如果是表单导航条点击，那么现实表单内容
        if ($(this).hasClass('active') && $(this).attr("type") == "metaForm") {
            getFormList($('.spanButton[type=metaForm]').parent().next().find('.search'), '');
        }
    });

    getFunctionList($('.spanButton[type=macro]').parent().next().find('.search'), '');
}

function match(str1, str2) {
    str1 = str1 ? str1 : '';
    str2 = str2 ? str2 : '';
    if (str1 == str2 || str1.toLowerCase().startsWith(str2.toLowerCase())
        || str1.toLowerCase().indexOf(str2.toLowerCase()) != -1) {
        return true;
    }
    return false;
}

//取表达式列表
function getFunctionList(obj, keyword) {
    getAllData().then(()=>{
        let rows = [];
        functions = [];
        if (funcList && funcList.length > 0) {
            for (let i = 0;i<funcList.length;i++) {
                let funObj = {"Macro":"",
                    "MacroValue":"",
                    "MacroReturnValueDesc": "Macro",
                    "MacroDesc":"",
                    "MacroName":"",
                    "MacroParam":""};
                funObj.Macro = funcList[i];
                funObj.MacroValue = funcList[i] + ";";
                funObj.MacroReturnValueDesc = returnValueDescList[i];
                funObj.MacroDesc = funcDescList[i];
                funObj.MacroName = funcList[i];
                funObj.MacroParam = paramDescList[i];
                functions.push(funObj);
            }
        }

        if (macroIdList && macroIdList.length > 0) {
            for (let i = 0;i<macroIdList.length;i++) {
                let funObj = {"Macro":"",
                    "MacroValue":"",
                    "MacroReturnValueDesc": "Macro",
                    "MacroDesc":"",
                    "MacroName":"",
                    "MacroParam":""};
                funObj.Macro = macroIdList[i];
                funObj.MacroValue = macroIdList[i] + ";";
                funObj.MacroReturnValueDesc = "";
                funObj.MacroDesc = macroDescList[i];
                funObj.MacroName = macroIdList[i];
                funObj.MacroParam = "";
                functions.push(funObj);
            }
        }

        functions.forEach(function (macro) {
            if (match(macro.MacroName, keyword) ||
                (!keyword.toLowerCase().startsWith("macro") && !keyword.toLowerCase().startsWith("com.")
                    && !keyword.toLowerCase().startsWith("com.bokesoft")
                    && !keyword.toLowerCase().startsWith("com.bokesoft.erp")
                    && !keyword.toLowerCase().startsWith("com.bokesoft.yes")
                    && !keyword.toLowerCase().startsWith("com.bokesoft.yigo")
                    && !keyword.toLowerCase().startsWith("com.bokesoft.yigo2")
                    && match(macro.MacroDesc, keyword))) {
                let rowObj = {"MacroName": "", "MacroDesc": "", "MacroParam": "", "MacroReturnValueDesc": ""};
                rowObj.MacroName = macro.MacroName;
                rowObj.MacroDesc = macro.MacroDesc;
                rowObj.MacroParam = macro.MacroParam;
                rowObj.MacroReturnValueDesc = macro.MacroReturnValueDesc;
                rows.push(rowObj);
            }
        });

        layui.use('table', function () {
            var table = layui.table;
            //展示已知数据
            table.render({
                elem: '#funcTable'
                , cols: [[ //标题栏
                    {field: 'MacroName', title: '名称', width: '50%', sort: true},
                    {field: 'MacroDesc', title: '描述'},
                    {field: 'MacroParam', title: '参数说明', hide: true},
                    {field: 'MacroReturnValueDesc', title: '返回值描述', hide: true}
                ]]
                , data: rows
                //,skin: 'line' //表格风格
                //,even: true
                , page: { //支持传入 laypage 组件的所有参数（某些参数除外，如：jump/elem） - 详见文档
                    layout: ['limit', 'count', 'prev', 'page', 'next', 'skip'] //自定义分页布局
                    //,curr: 5 //设定初始在第 5 页
                    , groups: 1 //只显示 1 个连续页码
                    , first: false //不显示首页
                    , last: false //不显示尾页
                },
                done: function () {
                    $(".layui-table-box").find("[data-field='MacroParam']").css('display', 'none');
                    $(".layui-table-box").find("[data-field='MacroReturnValueDesc']").css('display', 'none');
                }
            });

            // 设置表格和搜索框的间距为1px
            $(".layui-table-view").css("marginTop", "1px");

            // 行单击事件
            table.on('row(funcTable)', function (obj) {
                //删除选中双击样式
                obj.tr.removeClass('layui-bg-blue').siblings().removeClass('layui-bg-blue');
            });

            // 行双击事件
            table.on('rowDouble(funcTable)', function (obj) {
                let data = obj.data;
                if (editor.getValue() && editor.getValue().length > 0) {
                    editor.setValue(editor.getValue() + "," + data.MacroName);
                } else {
                    editor.setValue(data.MacroName);
                }

                // 设置提示
                $('#macro_name').text(data.MacroName);
                $('#macro_description').text(data.MacroDesc);
                $('#macro_params').text(data.MacroParam);
                $('#macro_return').text(data.MacroReturnValueDesc);

                editor.setSize('auto', '485px');//宽度自动，高度485px
                $("#descriptionFunction").show();
                $("#descriptionFormAndField").hide();

                //标注选中样式
                obj.tr.addClass('layui-bg-blue').siblings().removeClass('layui-bg-blue');
            });
        });
    });
}

//取表单列表
function getFormList(obj, keyword) {
    // 表单数组
    let metaFormList = [];
    // 字段数组
    let fieldList = [];
    getData({
        cmd: "FormulaServiceCmd",
        service: "DesignService",
        type: "getFormList"
    }, function (data) {
        metaFormList = JSON.parse(data);
    });

    // 设置表单表格所在div高度清除
    $("#formTop").css("height", "500px");
    // 字段搜索框隐藏
    $("#fieldSearch").hide();
    // 字段表格也隐藏
    $("#fieldTable").hide();
    $("#fieldTable").next().hide();
    let rows = [];
    metaFormList.forEach(function (metaForm) {
        if (match(metaForm.FormKey, keyword) || match(metaForm.FormCaption, keyword)) {
            let rowObj = {"FormKey": "", "FormCaption": ""};
            rowObj.FormKey = metaForm.FormKey;
            rowObj.FormCaption = metaForm.FormCaption;
            rows.push(rowObj);
        }
    });
    layui.use('table', function () {
        var table = layui.table;
        //展示已知数据
        table.render({
            elem: '#formTable'
            , cols: [[ //标题栏
                {field: 'FormKey', title: '名称', minWidth: 200, sort: true},
                {field: 'FormCaption', title: '描述'}
            ]]
            , data: rows
            //,skin: 'line' //表格风格
            //,even: true
            , page: { //支持传入 laypage 组件的所有参数（某些参数除外，如：jump/elem） - 详见文档
                layout: ['limit', 'count', 'prev', 'page', 'next', 'skip'] //自定义分页布局
                //,curr: 5 //设定初始在第 5 页
                , groups: 1 //只显示 1 个连续页码
                , first: false //不显示首页
                , last: false //不显示尾页
            }
        });

        // 行单击事件
        table.on('row(formTable)', function (obj) {
            //删除选中双击样式
            obj.tr.removeClass('layui-bg-blue').siblings().removeClass('layui-bg-blue');
            let data = obj.data;
            // 设置表单表格所在div高度
            $("#formTop").css("height", "240px");
            // 字段搜索框显示
            $("#fieldSearch").show();
            // 字段表格显示
            $("#fieldTable").show();

            // 根据表单去获取表单下的字段
            getData({
                cmd: "FormulaServiceCmd",
                service: "DesignService",
                type: "getForm",
                formKey: "",
                formulaFormKey: data.FormKey
            }, function (data) {
                fieldList = JSON.parse(data);
                getFieldList(fieldList,'', '');
            });
        });

        // 行双击事件
        table.on('rowDouble(formTable)', function (obj) {
            //标注选中样式
            obj.tr.addClass('layui-bg-blue').siblings().removeClass('layui-bg-blue');
            let data = obj.data;
            if (editor.getValue() && editor.getValue().length > 0) {
                editor.setValue(editor.getValue() + "," + data.FormKey);
            } else {
                editor.setValue(data.FormKey);
            }

            // 设置提示
            $('#Key').text(data.FormKey);
            $('#Caption').text(data.FormCaption);

            editor.setSize('auto', '505px');//宽度自动，高度505px
            $("#descriptionFunction").hide();
            $("#descriptionFormAndField").show();

        });
    });

    // 设置表格和搜索框的间距为1px
    $(".layui-table-view").css("marginTop", "1px");
}

// 获取字段列表
function getFieldList(fieldList, obj, keyword) {
    let rows = [];
    fieldList.forEach(function (fieldKey) {
        if (match(fieldKey.Key, keyword) || match(fieldKey.Caption, keyword)) {
            rows.push(fieldKey);
        }
    });
    layui.use('table', function () {
        var table = layui.table;
        //展示已知数据
        table.render({
            elem: '#fieldTable'
            , cols: [[ //标题栏
                {field: 'Key', title: '名称', minWidth: 150, sort: true},
                {field: 'Caption', title: '描述'}
            ]]
            , data: rows
            //,skin: 'line' //表格风格
            //,even: true
            , page: { //支持传入 laypage 组件的所有参数（某些参数除外，如：jump/elem） - 详见文档
                layout: ['limit', 'count', 'prev', 'page', 'next', 'skip'] //自定义分页布局
                //,curr: 5 //设定初始在第 5 页
                , groups: 1 //只显示 1 个连续页码
                , first: false //不显示首页
                , last: false //不显示尾页
            }
        });

        // 行单击事件
        table.on('row(fieldTable)', function (obj) {
            //删除选中双击样式
            obj.tr.removeClass('layui-bg-blue').siblings().removeClass('layui-bg-blue');
        });

        // 行双击事件
        table.on('rowDouble(fieldTable)', function (obj) {
            //标注选中样式
            obj.tr.addClass('layui-bg-blue').siblings().removeClass('layui-bg-blue');
            let data = obj.data;
            if (editor.getValue() && editor.getValue().length > 0) {
                editor.setValue(editor.getValue() + "," + data.Key);
            } else {
                editor.setValue(data.Key);
            }

            // 设置提示
            $('#Key').text(data.Key);
            $('#Caption').text(data.Caption);

            editor.setSize('auto', '505px');//宽度自动，高度505px
            $("#descriptionFunction").hide();
            $("#descriptionFormAndField").show();
        });

    });

    // 设置表格和搜索框的间距为1px
    $(".layui-table-view").css("marginTop", "1px");
}

/***
 * codeMirror自动完成
 * @param isShow
 * @param name
 * @param cm
 * @param editor
 * @returns {string}
 */
let inputChar = "";//当前输入的字符
function codeMirrorAutoComplete(isShow, name, cm) {
    if (!funcList || funcList.length == 0) {
        return editor.getValue();
    }
    //定义按哪些键时弹出提示框
    if ((name.keyCode && isShow(name.keyCode))
        || name.keyCode === 229 || name.origin === '+input'
        || name.origin === '+delete' || name.origin === 'paste'
        || name.origin === 'cut' || name.origin === '*compose') {
        // 退格键直接返回内容
        if (name.origin === '+delete' || name.origin === 'cut' || name.keyCode === 8) {
            return editor.getValue();
        }
        let datas = {};
        let cur = cm.getCursor();//当前行游标
        let ch = cur.ch;//当前输入的字符位置
        let line = cur.line;//当前行号
        let lineStr = cm.getLine(line);//当前行字符串
        let functionStr = lineStr.substring(ch - 1, ch).toLowerCase();//当前输入或删除的内容
        inputChar = functionStr;
        if (functionStr == "") {
            return editor.getValue();
        }
        //转换格式和去掉最后面的空格
        let content = editor.getValue().replace(/\r\n/ig, ' ').replace(/\n/ig, ' ').replace(/\r/ig, ' ')
            .replace(/\；/ig, '; ').replace(/\，/ig, ', ').replace(/\s/ig, ' ');
        //前面内容总长度
        let preContentTotalLen = 0;
        for (let i = 0; i < line; i++) {
            let lineLen = cm.getLine(i).length + 1;
            preContentTotalLen += lineLen;
        }

        //当前输入字符在编辑器中的索引，从0开始
        let index = preContentTotalLen + ch - 1;
        //编辑器内容为空就返回
        if (!content) return editor.getValue();

        //要匹配的字符串
        let matchStr = "";
        let funcsArray = [], funcDescArray = [];
        funcsArray = funcList.concat(macroIdList).concat(componentIdList);
        funcDescArray = funcDescList.concat(macroDescList).concat(componentDescList);

        //若是下面的输入符号时，直接return;
        let inputStr = content.substring(index, index + 1);
        if (inputStr == " " || inputStr == ";" || inputStr == "；" || inputStr == "&"
            || inputStr == "|" || inputStr == "!" || inputStr == "!" || inputStr == "+"
            || inputStr == "-" || inputStr == "*" || inputStr == "/" || inputStr == "%"
            || inputStr == "=" || inputStr == ">" || inputStr == "<" || inputStr == "("
            || inputStr == ")" || inputStr == "[" || inputStr == "]" || inputStr == "{"
            || inputStr == "}" || inputStr == "@" || inputStr == "#" || inputStr == "%"
            || inputStr == "^" || inputStr == "`" || inputStr == "~" || inputStr == "?"
            || inputStr == "\\" || inputStr == "。" || inputStr == "——"
            || inputStr == "《" || inputStr == "》") {
            return content;
        }

        // 获取待匹配的字符串
        if (index == 0) {
            //获取当前输入的字符或汉字
            matchStr = content.substring(0, 1).toLowerCase();
        } else if (index > 0) {
            //当前字符
            let currentChar = "";
            for (let j = index; j >= 0; j--) {
                currentChar = content.substring(j, j + 1);
                //是否中断查找";空格"等结束字符
                let isBreakSearch = " " === currentChar || ";" === currentChar
                    || "(" === currentChar || "\"" === currentChar
                    || "\'" === currentChar || "," === currentChar
                    || "=" === currentChar || "%" === currentChar
                    || ">" === currentChar || "<" === currentChar
                    || "+" === currentChar || "-" === currentChar
                    || "*" === currentChar || "/" === currentChar
                    || "&" === currentChar || "|" === currentChar
                    || "[" === currentChar || "{" === currentChar;
                if (isBreakSearch) {
                    break;
                }
                matchStr += currentChar.trim();
            }
            //反转字符串
            matchStr = matchStr.split("").reverse().join("");
        }

        if (!matchStr) {
            return content;
        }

        // 执行匹配查找
        let matchResult = getAutoCompleteResult(funcsArray, funcDescArray, matchStr);
        setTimeout(function() {
            if (matchResult && matchResult.matchFuncs && matchResult.matchFuncs.length > 0) {
                let showList = matchResult.matchFuncs;
                let showList2 = matchResult.matchFuncIndexes;
                let yigoFrontFnsExplainData = funcDescArray;

                datas.list = showList;
                datas.showList = showList2;
                datas.key = showList[0];
                datas.from = {};
                datas.from.line = line;
                //计算匹配开始位置
                let matchPos = 0;
                if (matchStr) {
                    let pos = 0;
                    //匹配的字符长度
                    const matchStrLen = String(matchStr).replace(/[\u0391-\uFFE5]/g, "aa").length;
                    while (pos < ch - matchStrLen && pos != -1) {
                        pos = lineStr.indexOf(matchStr, pos + 1);
                        matchPos = pos;
                        if (pos == ch - matchStrLen - 1) {
                            break;
                        }
                    }
                }

                datas.currentInputChar = functionStr;
                datas.from.ch = matchPos < ch ? matchPos : ch - 1;
                datas.to = {};
                datas.to.line = line;
                datas.to.ch = ch;//开始字符位置，比如“L”的位置
                datas.yigoFrontFnsExplainData = yigoFrontFnsExplainData;
                try {
                    editor.showHint1({completeSingle: false}, datas);
                } catch (e) {
                    console.log(e);
                }
            } else {
                console.log("请求后台result为空");
                return editor.getValue();
            }
        },100);
    }
    //codeMirror编辑器中的内容
    let afterValue = "";
    if (editor && editor.getValue()) {
        afterValue = editor.getValue();//关闭转换格式
    }
    return afterValue;
}

/***
 * 获取自动完成的结果
 * @param funcs 全部函数数组
 * @param funcDescs 全部函数功能描述数组
 * @param matchStr 待匹配的字符串
 */
function getAutoCompleteResult(funcs, funcDescs, matchStr) {
    //matchFuncs 匹配的函数数组；matchFuncIndexes 匹配函数的索引数组
    let matchFuncs = [], matchFuncDesc=[], matchFuncIndexes = [];
    let result = {"matchFuncs":"","matchFuncDesc":"","matchFuncIndexes":""};
    let func = "";
    let funcCn = "";
    for (let i = 0; i < funcs.length; i++) {
        if (funcs[i].indexOf("(") != -1) {
            func = funcs[i].substring(0, funcs[i].indexOf("("));
        } else {
            func = funcs[i];
        }
        funcCn = funcDescs[i];
        // 匹配判断
        let isMatch = false;
        // 先匹配英文的函数名，若不匹配再匹配中文的函数名
        if (matchStr.toLowerCase().startsWith("com") || matchStr.toLowerCase().startsWith("com.bokesoft")
            || matchStr.toLowerCase().startsWith("com.bokesoft.erp")
            || matchStr.toLowerCase().startsWith("com.bokesoft.yes")
            || matchStr.toLowerCase().startsWith("com.bokesoft.yigo")
            || matchStr.toLowerCase().startsWith("com.bokesoft.yigo2")
            || matchStr.toLowerCase().startsWith("macro_")) {
            isMatch = func.toLowerCase().startsWith(matchStr.toLowerCase());
        } else {
            // 判断输入的字符串是是否有汉字，有汉字执行下面的匹配，没有就不执行下面的匹配
            // true:无汉字  false:有汉字
            let hasChinese = false;
            let reg = new RegExp("[\\u4E00-\\u9FFF]+","g");
            if (reg.test(matchStr)) {
                hasChinese = true;
            }
            // 执行汉字匹配
            if (hasChinese) {
                isMatch = funcCn && funcCn.toLowerCase().startsWith(matchStr.toLowerCase());
            } else {
                isMatch = func.toLowerCase().startsWith(matchStr.toLowerCase());
            }
        }

        //若匹配就加入匹配列表中
        if (isMatch) {
            if (!matchFuncs.some(item=>item === funcs[i])) {
                matchFuncs.push(funcs[i]);
                matchFuncDesc.push(funcDescs[i]);
                matchFuncIndexes.push(i);
            }
        }
    }
    result.matchFuncs = matchFuncs;
    result.matchFuncDesc = matchFuncDesc;
    result.matchFuncIndexes = matchFuncIndexes;
    return result;
}

/***
 * codeMirror的键盘key判断
 * @param keyCode 键盘keyCode值
 * @returns {boolean|boolean}
 */
function isShow(keyCode) {
    return keyCode === 8 || keyCode === 108 || keyCode === 110 || keyCode === 189 || keyCode === 190
        || (keyCode >= 65 && keyCode <= 90);
}

// 装载codeMirror
$(document).ready(function() {
    // 装载后端表达式数据源
    loadDataSource().then(()=>{
        // 刷新函数表格
        getFunctionList($('.spanButton[type=macro]').parent().next().find('.search'), '');
    });

    // 增加弹框的高度
    if ($("#dependencyContent").is(":visible")) {
        $("body").css("height", $("#main").css("height").replace("px", "") + 38);
    }

    // 创建codemirror
    createCodemirror();

    // 初始化表格
    initTable();

});
