package com.bokesoft.yes.tool;

import com.bokesoft.yes.parser.Item;
import com.bokesoft.yes.parser.Rule;
import com.bokesoft.yes.parser.SyntaxTree;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;

/**
 * 表达式反向解析，由对象生成字段符
 */
public class FormulaDeparserWithFormat {
	public static final FormulaDeparserWithFormat instance = new FormulaDeparserWithFormat();
	
	public static String deParse(SyntaxTree syntaxTree, String orgFormulaString) {
		FormulaFormat format = FormulaFormat.parse(orgFormulaString, syntaxTree);
		StringBuilder sb = new StringBuilder(128);
		return instance.deParse(syntaxTree.getRoot(), sb, format).append(format.getLastFormat()).toString();
	}

	public static String deParse(Item item, FormulaFormat format) {
		StringBuilder sb = new StringBuilder(128);
		return instance.deParse(item, sb, format).toString();
	}

	public StringBuilder deParse(Item item, StringBuilder sb, FormulaFormat format) {
		Rule rule = item.getRule();
		if (rule != null) {
			int ruleIndex = rule.getIndex();
			switch (ruleIndex) {
			case FormulaDeparser.RuleIndex_0_Statement:
				// SL -> E
				return deParse0Statement(item, sb, format);
			case FormulaDeparser.RuleIndex_1_Statements:
				// SL -> E ; SL
				return deParse1Statements(item, sb, format);
			case FormulaDeparser.RuleIndex_2_Addition:
				// E -> E + E
				return deParse2Addition(item, sb, format);
			case FormulaDeparser.RuleIndex_3_Subtraction:
				// E -> E - E
				return deparse3Subtraction(item, sb, format);
			case FormulaDeparser.RuleIndex_4_Multiplication:
				// E -> E * E
				return deParse4Multiplication(item, sb, format);
			case FormulaDeparser.RuleIndex_5_Division:
				// E -> E / E
				return deParse5Division(item, sb, format);
			case FormulaDeparser.RuleIndex_6_Concat:
				// E -> E & E
				return deParse6Concat(item, sb, format);
			case FormulaDeparser.RuleIndex_7_Parenthesis:
				// E -> ( E )
				return deParse7Parenthesis(item, sb, format);
			case FormulaDeparser.RuleIndex_8_Not:
				// E -> ! E
				return deParse8Not(item, sb, format);
			case FormulaDeparser.RuleIndex_9_Or:
				// E -> E || E
				return deParse9Or(item, sb, format);
			case FormulaDeparser.RuleIndex_10_And:
				// E -> E && E
				return deParse10And(item, sb, format);
			case FormulaDeparser.RuleIndex_11_EqualsTo:
				// E -> E == E
				return deParse11EqualsTo(item, sb, format);
			case FormulaDeparser.RuleIndex_12_NotEqualsTo:
				// E -> E <> E
				return deParse12NotEqualsTo(item, sb, format);
			case FormulaDeparser.RuleIndex_13_GreaterThan:
				// E -> E > E
				return deParse13GreaterThan(item, sb, format);
			case FormulaDeparser.RuleIndex_14_GreaterThanEquals:
				// E -> E >= E
				return deParse14GreaterThanEquals(item, sb, format);
			case FormulaDeparser.RuleIndex_15_MinorThan:
				// E -> E < E
				return deParse15MinorThan(item, sb, format);
			case FormulaDeparser.RuleIndex_16_MinorThanEquals:
				// E -> E <= E
				return deParse16MinorThanEquals(item, sb, format);
			case FormulaDeparser.RuleIndex_17_Const:
				// E -> const
				return deParse17Const(item, sb, format);
			case FormulaDeparser.RuleIndex_18_ID:
				// E -> id
				return deParse18ID(item, sb, format);
			case FormulaDeparser.RuleIndex_19_Function:
				// E -> FUNC_HEAD FUNC_TAIL
				return deParse19Function(item, sb, format);
			case FormulaDeparser.RuleIndex_20_:
				// FUNC_HEAD -> function (
				throw new NotImplementedException("Code is not implemented");
			case FormulaDeparser.RuleIndex_21_:
				// FUNC_TAIL -> )
				throw new NotImplementedException("Code is not implemented");
			case FormulaDeparser.RuleIndex_22_:
				// FUNC_TAIL -> PL )
				throw new NotImplementedException("Code is not implemented");
			case FormulaDeparser.RuleIndex_23_:
				// PL -> E
				throw new NotImplementedException("Code is not implemented");
			case FormulaDeparser.RuleIndex_24_:
				// PL -> E , PL
				throw new NotImplementedException("Code is not implemented");
			case FormulaDeparser.RuleIndex_25_Var:
				// E -> var id = E
				return deParse25Var(item, sb, format);
			case FormulaDeparser.RuleIndex_26_IfHead:
				// E -> IF_HEAD
				return deParse26IfHead(item, sb, format);
			case FormulaDeparser.RuleIndex_27_IfElse:
				// E -> IF_HEAD IF_TAIL
				return deParse27IfElse(item, sb, format);
			case FormulaDeparser.RuleIndex_28_IfHead:
				// IF_HEAD -> if ( E ) { SL }
				return deParse26IfHead(item, sb, format);
			case FormulaDeparser.RuleIndex_29_:
				// IF_TAIL -> else { SL }
				throw new NotImplementedException("Code is not implemented");
			case FormulaDeparser.RuleIndex_30_While:
				// E -> while ( E ) { SL }
				return deParse30While(item, sb, format);
			case FormulaDeparser.RuleIndex_31_SetValue:
				// E -> E = E
				return deParse31SetValue(item, sb, format);
			case FormulaDeparser.RuleIndex_32_Return:
				// E -> return E
				return deParse32Return(item, sb, format);
			case FormulaDeparser.RuleIndex_33_:
				// E -> break
				throw new NotImplementedException("Code is not implemented");
			case FormulaDeparser.RuleIndex_34_:
				// E -> loop E ( E ) { SL }
				throw new NotImplementedException("Code is not implemented");
			case FormulaDeparser.RuleIndex_35_:
				// E -> RANGE
				throw new NotImplementedException("Code is not implemented");
			case FormulaDeparser.RuleIndex_36_:
				// E -> switch ( E ) { CASE_SL }
				throw new NotImplementedException("Code is not implemented");
			case FormulaDeparser.RuleIndex_37_:
				// CASE_SL -> CASE_S
				throw new NotImplementedException("Code is not implemented");
			case FormulaDeparser.RuleIndex_38_:
				// CASE_SL -> CASE_S ; CASE_SL
				throw new NotImplementedException("Code is not implemented");
			case FormulaDeparser.RuleIndex_39_:
				// CASE_S -> casprivate StringBuilder  E : { SL }
				throw new NotImplementedException("Code is not implemented");
			}
		}
		throw new NotImplementedException("Code is not implemented");
	}


	// SL -> E
	protected StringBuilder deParse0Statement(Item factor, StringBuilder sb, FormulaFormat format) {
		return deParse(factor.getFactor(0), sb, format);
	}

	// SL -> E ; SL
	protected StringBuilder deParse1Statements(Item factor, StringBuilder sb, FormulaFormat format) {
		deParse(factor.getFactor(0), sb, format);
		for (int i = 2, size = factor.getChildCount(); i < size; i += 2) {
			Item semicolon = factor.getFactor(i - 1);
			// if(1){return 0;}return 2; 如前例，return 2前解析时会增加一个;号
			String fullLexValue = semicolon.getFullLexValue();
			if (StringUtils.isBlank(fullLexValue)) {
				sb.append(format.getPreFormat(semicolon)).append(";");
			}
			deParse(factor.getFactor(i), sb, format);
		}
		return sb;
	}

	// E -> E + E
	protected StringBuilder deParse2Addition(Item factor, StringBuilder sb, FormulaFormat format) {
		deParse(factor.getFactor(0), sb, format).append(format.getPreFormat(factor.getFactor(1))).append("+");
		return deParse(factor.getFactor(2), sb, format);
	}

	// E -> E - E
	protected StringBuilder deparse3Subtraction(Item factor, StringBuilder sb, FormulaFormat format) {
		deParse(factor.getFactor(0), sb, format).append(format.getPreFormat(factor.getFactor(1))).append("-");
		return deParse(factor.getFactor(2), sb, format);
	}

	// E -> E * E
	protected StringBuilder deParse4Multiplication(Item factor, StringBuilder sb, FormulaFormat format) {
		deParse(factor.getFactor(0), sb, format).append(format.getPreFormat(factor.getFactor(1))).append("*");
		return deParse(factor.getFactor(2), sb, format);
	}

	// E -> E / E
	protected StringBuilder deParse5Division(Item factor, StringBuilder sb, FormulaFormat format) {
		deParse(factor.getFactor(0), sb, format).append(format.getPreFormat(factor.getFactor(1))).append("/");
		return deParse(factor.getFactor(2), sb, format);
	}

	// E -> E & E
	protected StringBuilder deParse6Concat(Item factor, StringBuilder sb, FormulaFormat format) {
		deParse(factor.getFactor(0), sb, format).append(format.getPreFormat(factor.getFactor(1))).append("&");
		return deParse(factor.getFactor(2), sb, format);
	}
	
	// E -> ( E )
	protected StringBuilder deParse7Parenthesis(Item factor, StringBuilder sb, FormulaFormat format) {
		sb.append(format.getPreFormat(factor.getFactor(0))).append("(");
		deParse(factor.getFactor(1), sb, format);
		return sb.append(format.getPreFormat(factor.getFactor(2))).append(")");
	}

	// E -> ! E
	protected StringBuilder deParse8Not(Item factor, StringBuilder sb, FormulaFormat format) {
		sb.append(format.getPreFormat(factor.getFactor(0))).append("!");
		return deParse(factor.getFactor(1), sb, format);
	}

	// E -> E || E
	protected StringBuilder deParse9Or(Item factor, StringBuilder sb, FormulaFormat format) {
		deParse(factor.getFactor(0), sb, format).append(format.getPreFormat(factor.getFactor(1))).append("||");
		return deParse(factor.getFactor(2), sb, format);
	}

	// E -> E && E
	protected StringBuilder deParse10And(Item factor, StringBuilder sb, FormulaFormat format) {
		deParse(factor.getFactor(0), sb, format).append(format.getPreFormat(factor.getFactor(1))).append("&&");
		return deParse(factor.getFactor(2), sb, format);
	}

	// E -> E == E
	protected StringBuilder deParse11EqualsTo(Item factor, StringBuilder sb, FormulaFormat format) {
		deParse(factor.getFactor(0), sb, format).append(format.getPreFormat(factor.getFactor(1))).append("==");
		return deParse(factor.getFactor(2), sb, format);
	}

	// E -> E <> E
	protected StringBuilder deParse12NotEqualsTo(Item factor, StringBuilder sb, FormulaFormat format) {
		deParse(factor.getFactor(0), sb, format).append(format.getPreFormat(factor.getFactor(1)))
				.append(format.getOrgText(factor.getFactor(1)));
		return deParse(factor.getFactor(2), sb, format);
	}

	// E -> E > E
	protected StringBuilder deParse13GreaterThan(Item factor, StringBuilder sb, FormulaFormat format) {
		deParse(factor.getFactor(0), sb, format).append(format.getPreFormat(factor.getFactor(1))).append(">");
		return deParse(factor.getFactor(2), sb, format);
	}

	// E -> E >= E
	protected StringBuilder deParse14GreaterThanEquals(Item factor, StringBuilder sb, FormulaFormat format) {
		deParse(factor.getFactor(0), sb, format).append(format.getPreFormat(factor.getFactor(1))).append(">=");
		return deParse(factor.getFactor(2), sb, format);
	}

	// E -> E < E
	protected StringBuilder deParse15MinorThan(Item factor, StringBuilder sb, FormulaFormat format) {
		deParse(factor.getFactor(0), sb, format).append(format.getPreFormat(factor.getFactor(1))).append("<");
		return deParse(factor.getFactor(2), sb, format);
	}

	// E -> E <= E
	protected StringBuilder deParse16MinorThanEquals(Item factor, StringBuilder sb, FormulaFormat format) {
		deParse(factor.getFactor(0), sb, format).append(format.getPreFormat(factor.getFactor(1))).append("<=");
		return deParse(factor.getFactor(2), sb, format);
	}

	// E -> const
	protected StringBuilder deParse17Const(Item factor, StringBuilder sb, FormulaFormat format) {
		return sb.append(format.getPreFormat(factor.getFactor(0))).append(format.getOrgText(factor.getFactor(0)));
	}

	// E -> id
	protected StringBuilder deParse18ID(Item factor, StringBuilder sb, FormulaFormat format) {
		return sb.append(format.getPreFormat(factor.getFactor(0))).append(factor.getFactor(0).getFullLexValue());
	}

	// E -> FUNC_HEAD FUNC_TAIL
	protected StringBuilder deParse19Function(Item factor, StringBuilder sb, FormulaFormat format) {
		sb.append(format.getPreFormat(factor.getFactor(0))).append(factor.getFactor(0).getFullLexValue())
				.append(format.getPreFormat(factor.getFactor(1))).append("(");
		int size = factor.getChildCount();
		if (size >=4 ) {
			deParse(factor.getFactor(2), sb, format);
		}
		for (int i = 4; i < size; i += 2) {
			sb.append(format.getPreFormat(factor.getFactor(i - 1))).append(",");
			deParse(factor.getFactor(i), sb, format);
		}
		return sb.append(format.getPreFormat(factor.getFactor(size - 1))).append(")");
	}

	// E -> var id = E
	protected StringBuilder deParse25Var(Item factor, StringBuilder sb, FormulaFormat format) {
		sb.append(format.getPreFormat(factor.getFactor(0))).append(factor.getFactor(0).getFullLexValue());
		sb.append(format.getPreFormat(factor.getFactor(1))).append(factor.getFactor(1).getFullLexValue())
				.append(format.getPreFormat(factor.getFactor(2))).append("=");
		return deParse(factor.getFactor(3), sb, format);
	}

	// E -> IF_HEAD
	protected StringBuilder deParse26IfHead(Item factor, StringBuilder sb, FormulaFormat format) {
		sb.append(format.getPreFormat(factor.getFactor(0))).append(factor.getFactor(0).getFullLexValue())
				.append(format.getPreFormat(factor.getFactor(1))).append("(");
		deParse(factor.getFactor(2), sb, format).append(format.getPreFormat(factor.getFactor(3))).append(")")
				.append(format.getPreFormat(factor.getFactor(4))).append("{");
		return deParse(factor.getFactor(5), sb, format).append(format.getPreFormat(factor.getFactor(6))).append("}");
	}

	// E -> IF_HEAD IF_TAIL
	protected StringBuilder deParse27IfElse(Item factor, StringBuilder sb, FormulaFormat format) {
		sb.append(format.getPreFormat(factor.getFactor(0))).append(factor.getFactor(0).getFullLexValue())
				.append(format.getPreFormat(factor.getFactor(1))).append("(");
		deParse(factor.getFactor(2), sb, format).append(format.getPreFormat(factor.getFactor(3))).append(")")
				.append(format.getPreFormat(factor.getFactor(4))).append("{");
		deParse(factor.getFactor(5), sb, format).append(format.getPreFormat(factor.getFactor(6))).append("}");
		sb.append(format.getPreFormat(factor.getFactor(7))).append(factor.getFactor(7).getFullLexValue())
				.append(format.getPreFormat(factor.getFactor(8))).append("{");
		return deParse(factor.getFactor(9), sb, format).append(format.getPreFormat(factor.getFactor(10))).append("}");
	}

	// E -> while ( E ) { SL }
	protected StringBuilder deParse30While(Item factor, StringBuilder sb, FormulaFormat format) {
		sb.append(format.getPreFormat(factor.getFactor(0))).append(factor.getFactor(0).getFullLexValue())
				.append(format.getPreFormat(factor.getFactor(1))).append("(");
		deParse(factor.getFactor(2), sb, format).append(format.getPreFormat(factor.getFactor(3))).append(")")
				.append(format.getPreFormat(factor.getFactor(4))).append("{");
		return deParse(factor.getFactor(5), sb, format).append(format.getPreFormat(factor.getFactor(6))).append("}");
	}

	// E -> E = E
	protected StringBuilder deParse31SetValue(Item factor, StringBuilder sb, FormulaFormat format) {
		Item factor_0_0 = factor.getFactor(0).getFactor(0);
		sb.append(format.getPreFormat(factor_0_0)).append(factor_0_0.getFullLexValue())
				.append(format.getPreFormat(factor.getFactor(1))).append("=");
		return deParse(factor.getFactor(2), sb, format);
	}

	// E -> return E
	protected StringBuilder deParse32Return(Item factor, StringBuilder sb, FormulaFormat format) {
		sb.append(format.getPreFormat(factor.getFactor(0))).append(factor.getFactor(0).getFullLexValue());
		return deParse(factor.getFactor(1), sb, format);
	}
}
