package com.bokesoft.yes.tool;

import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.mid.base.CoreSetting;
import com.bokesoft.yes.tool.FormulaDeparserWithFormat;
import com.bokesoft.yes.tool.FormulaFormat;
import com.bokesoft.yes.tool.FormulaUtil;
import com.bokesoft.yes.parser.Item;
import com.bokesoft.yes.parser.Parser;
import com.bokesoft.yes.parser.SyntaxTree;
import com.bokesoft.yigo.meta.common.MetaMacro;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.factory.DefaultMetaFactory;
import com.bokesoft.yigo.meta.factory.DefaultMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.parser.IEvalContext;
import org.apache.commons.lang3.StringUtils;

import java.nio.file.Paths;
import java.util.*;

/**
 * 为了设计器解析带宏公式的表达式
 */
public class FillMacro4Designer {

	public static void main(String[] args) throws Throwable {
		String solutionPath = getSolutionPath(args);
		IMetaFactory metaFactory = loadSolution(solutionPath);
		MetaForm po = metaFactory.getMetaForm("MM_PurchaseOrder");
		System.out.println(parseFormula(metaFactory, po, "UICheck()"));
	}

	private static String getSolutionPath(String[] args) {
		// 下面的路径是http://ccserver:8080/svn/MyERP_Core_Main/MyERP_Core/trunk/trunk_2_0/erp在你本机所对应的目录
		// 如果取得不对，你可以改成自己机器上的相关目录，或者将path通过参数传进来
		String solutionPath = FilePathHelper.toBackFilePath(CoreSetting.getInstance().getSolutionPath());
		// String solutionPath = "D:\\SVN\\yes\\yes-webapp\\";
		if (args != null && args.length > 0) {
			solutionPath = args[0];
		}
		return Paths.get(solutionPath).toAbsolutePath().toString();
	}

	private static IMetaFactory loadSolution(String solutionPath) throws Throwable {
		IMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(solutionPath);
		IMetaFactory metaFactory = new DefaultMetaFactory(metaResolverFactory);
		metaFactory.getSolution();
		metaFactory.preLoadEntity();
		return metaFactory;
	}

	public static String parseFormula(IMetaFactory metaFactory, MetaForm metaForm, String formula) {
		StringBuilder result = new StringBuilder(1024);
		parseFormula(metaFactory, metaForm, formula, result, 0);
		return result.toString();
	}

	public static String parseFormula(IMetaFactory metaFactory, MetaForm metaForm, String formula, StringBuilder result, int level) {
		List<String> statements = splitStatements(metaFactory, metaForm, formula);
		for (int i = 0, size = statements.size(); i < size; i++) {
			String statement = statements.get(i).trim();
			for (int k = 0; k < level; k++) {
				result.append("\t");
			}
			result.append(statement).append("\n");
			List<String> foundMacroPaths = new ArrayList<String>();
			String statementFillMacro = fillMacro(metaFactory, metaForm, statement, foundMacroPaths);
			if (!statementFillMacro.equals(statement)) {
				for (String foundMacroPath : foundMacroPaths) {
					for (int k = 0; k <= level; k++) {
						result.append("\t");
					}
					result.append(foundMacroPath).append("\n");
				}
				parseFormula(metaFactory, metaForm, statementFillMacro, result, level + 1);
			}
		}
		return null;
	}
	
	private static List<String> splitStatements(IMetaFactory metaFactory, MetaForm metaForm, String formula) {
		List<String> result = new ArrayList<String>();
		Parser<IEvalContext> parser = new Parser<IEvalContext>(null);
		try {
			SyntaxTree syntaxTree = parser.parse(formula);
			if (syntaxTree != null) {
				StringBuilder sb = new StringBuilder(512);
				sb.append(formula).append(":\t");
				FormulaFormat format = FormulaFormat.parse(formula, syntaxTree);
				Item item = syntaxTree.getRoot();
				List<Item> statements = FormulaUtil.getStatements(item);
				int size = statements.size();
				if (size > 1) {
					for (int i = 0; i < size; i++) {
						result.add(FormulaDeparserWithFormat.deParse(statements.get(i), format));
					}
					return result;
				}
			}
			result.add(formula);
		}catch (Exception e){

		}
		return result;
	}
	
	/**
	 * 填充一层宏公式，并返回宏公式
	 * @param metaFactory
	 * @param metaForm
	 * @param formula
	 * @param foundMacroPaths
	 * @return
	 */
	private static String fillMacro(IMetaFactory metaFactory, MetaForm metaForm, String formula, List<String> foundMacroPaths) {
		Parser<IEvalContext> parser = new Parser<IEvalContext>(null);
		SyntaxTree syntaxTree = parser.parse(formula);
		if (syntaxTree != null) {
			StringBuilder sb = new StringBuilder(512);
			FormulaFormat format = FormulaFormat.parse(formula, syntaxTree);
			FormulaDeparserWithFormat deparser = new FormulaDeparserWithFormat() {
				Map<String, String> macroArgs = null;
				
				@Override
				protected StringBuilder deParse19Function(Item factor, StringBuilder sb, FormulaFormat format) {
					if (macroArgs != null) { // 不进行嵌套处理，只展开一层
						return super.deParse19Function(factor, sb, format);
					}
					String functionName = factor.getFactor(0).getFullLexValue();
					int argumentCount = (factor.getChildCount() - 2) / 2;
					MetaMacro macro = null;
					try {
						macro = findMacro(metaFactory, metaForm, functionName, foundMacroPaths);
					} catch (Throwable e) {
						throw new RuntimeException("取宏公式错误", e);
					}
					if (macro != null) {
						String[] argsList = macro.getArgsList();
						if ((Objects.isNull(argsList) ? 0 : argsList.length) != argumentCount) {
							System.err.println("表单" + metaForm.getKey() + "表达式" + formula + "中宏公式" + functionName
									+ "的参数个数应为" + (Objects.isNull(argsList) ? 0 : argsList.length) + "，而表达式中为" + argumentCount
									+ "，表达式错误，请修正。");
							return super.deParse19Function(factor, sb, format);
						}
						String macroContent = macro.getContent();
						if (StringUtils.isBlank(macroContent)) {
							System.err.println("表单" + metaForm.getKey() + "表达式" + formula + "中宏公式" + functionName
									+ "的内容为空，表达式错误，请修正。");
							return super.deParse19Function(factor, sb, format);
						}
						macroArgs = new HashMap<String, String>();
						for (int i = 0; i < argumentCount; i++) {
							StringBuilder argSB = new StringBuilder(128);
							super.deParse(factor.getFactor(2 + i * 2), argSB, format);
							macroArgs.put(argsList[i], argSB.toString());
						}
						SyntaxTree macroSyntaxTree = parser.parse(macroContent);
						FormulaFormat macroFormat = FormulaFormat.parse(macroContent, macroSyntaxTree);
						super.deParse(macroSyntaxTree.getRoot(), sb, macroFormat);
						macroArgs = null;
						return sb;
					} else {
						return super.deParse19Function(factor, sb, format);
					}
				}

				@Override
				protected StringBuilder deParse18ID(Item factor, StringBuilder sb, FormulaFormat format) {
					String id = factor.getFactor(0).getFullLexValue();
					if (macroArgs != null && macroArgs.containsKey(id)) {
						return sb.append(format.getPreFormat(factor.getFactor(0))).append(macroArgs.get(id));
					}
					return super.deParse18ID(factor, sb, format);
				}
				
				
			};
			Item item = syntaxTree.getRoot();
			deparser.deParse(item, sb, format).append(format.getLastFormat());
			return sb.toString();
		}
		return formula;
	}
	
	private static MetaMacro findMacro(IMetaFactory metaFactory, MetaForm metaForm, String name, List<String> macros) throws Throwable {
		MetaMacroCollection macroCollection = metaForm.getMacroCollection();
		MetaMacro metaMacro = null;
		if (macroCollection != null) {
			metaMacro = macroCollection.get(name);
			if (metaMacro != null) {
				macros.add("// " + name + "()@" + metaForm.getProject().getKey() + "\\" + metaFactory.getMetaFormList().get(metaForm.getKey()).getResource());
			}
		}
		if (Objects.isNull(metaMacro)) {
			MetaProject metaProject = (MetaProject) metaForm.getProject();
			MetaCommonDef metaCommonDef = metaFactory.getCommonDef(metaProject.getKey());
			if (metaCommonDef != null) {
				macroCollection = metaCommonDef.getMacroCollection();
				if (macroCollection != null) {
					metaMacro = macroCollection.get(name);
					if (metaMacro != null) {
						macros.add("// " + name + "()@" + metaForm.getProject().getKey() + "\\CommonDef.xml");
					}
				}
			}
		}
		if (Objects.isNull(metaMacro)) {
			MetaCommonDef metaCommonDef = metaFactory.getCommonDef("");
			if (metaCommonDef != null) {
				macroCollection = metaCommonDef.getMacroCollection();
				if (macroCollection != null) {
					metaMacro = macroCollection.get(name);
					if (metaMacro != null) {
						macros.add("// " + name + "()@CommonDef.xml");
					}
				}
			}
		}

		return metaMacro;
	}
	public static final FillMacro4Designer instance = new FillMacro4Designer();
}
