package com.bokesoft.yes.helper;

import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.node.XmlTree;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

import java.util.*;
import java.util.function.Consumer;

public final class MetaFormHelper {
    private static final List<String> TABLE_KEY_REF_LIST = Arrays.asList(
            ConstantUtil.TBL_DATA_BINDING,
            ConstantUtil.CONDITION,
            ConstantUtil.CONDITION_TARGET,
            ConstantUtil.GRID_ROW,
            ConstantUtil.LIST_VIEW,
            ConstantUtil.COLUMN_EXPAND);
    private static final List<String> COLUMN_KEY_REF_LIST = Arrays.asList(
            MetaDataBinding.TAG_NAME,
            ConstantUtil.CONDITION,
            ConstantUtil.CONDITION_TARGET,
            ConstantUtil.GRID_CELL,
            ConstantUtil.LIST_VIEW_COLUMN,
            ConstantUtil.COLUMN_EXPAND);

    public static boolean isBeExtended(MetaForm metaForm) throws Throwable {
        String extend = metaForm.getExtend();
        if (StringUtils.isNotBlank(extend)) {
            return false;
        }

        String formKey = metaForm.getKey();
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaFormList metaFormList = metaFactory.getMetaFormList();
        for (MetaFormProfile metaFormProfile : metaFormList) {
            if (StringUtils.equals(metaFormProfile.getExtend(), formKey)) {
                return true;
            }
        }
        return false;
    }

    public static Pair<List<MetaFormProfile>, MetaFormProfile> listVestMetaFormByOriginal(MetaForm metaForm) throws Throwable {
        String extend = metaForm.getExtend();
        if (StringUtils.isNotBlank(extend)) {
            return Pair.of(Collections.emptyList(), null);
        }

        List<MetaFormProfile> vestList = new ArrayList<>();
        MetaFormProfile specVest = null;

        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaFormList metaFormList = metaFactory.getMetaFormList();
        for (MetaFormProfile metaFormProfile : metaFormList) {
            if (!StringUtils.equals(metaFormProfile.getExtend(), metaForm.getKey())) {
                continue;
            }
            if (Objects.equals(metaFormProfile.getMergeToSource(), Boolean.TRUE)) {
                specVest = metaFormProfile;
            } else {
                vestList.add(metaFormProfile);
            }
        }
        return Pair.of(vestList, specVest);
    }

    public static Pair<List<MetaFormProfile>, MetaFormProfile> listVestMetaFormBySpecVest(MetaForm metaForm) throws Throwable {
        if (StringUtils.isBlank(metaForm.getExtend()) || !Objects.equals(metaForm.getMergeToSource(), Boolean.TRUE)) {
            return Pair.of(Collections.emptyList(), null);
        }

        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        List<MetaFormProfile> vestList = new ArrayList<>();
        MetaFormProfile originalForm = metaFactory.getMetaFormList().get(metaForm.getExtend());

        MetaFormList metaFormList = metaFactory.getMetaFormList();
        for (MetaFormProfile metaFormProfile : metaFormList) {
            if (!StringUtils.equals(metaFormProfile.getExtend(), originalForm.getKey())) {
                continue;
            }
            if (StringUtils.equals(metaFormProfile.getKey(), metaForm.getKey())) {
                continue;
            }
            vestList.add(metaFormProfile);
        }
        return Pair.of(vestList, originalForm);
    }


    public static MetaForm getExtendMetaForm(MetaForm metaForm) throws Throwable {
        String extend = metaForm.getExtend();
        if (StringUtils.isBlank(extend)) {
            return metaForm;
        }
        return MetaFactory.getGlobalInstance().getMetaForm(extend);
    }

    public static void updateColumnKey(Diff diff, String oldColumnKey, String newColumnKey) {
        if (Objects.isNull(diff.getMetaForm()) || Objects.isNull(diff.getXmlTree())) {
            return;
        }

        final XmlTree xmlTree = diff.getXmlTree().xmlTree;
        final TagNode rootNode = xmlTree.getRoot();
        final TagNode bodyNode = rootNode.getOrCreateChildByTagName("Body");

        Consumer<TagNode> tagNodeConsumer = tagNode -> {
            Map<String, String> attributes = tagNode.getAttributes();
            String attrVal = attributes.get(ConstantUtil.COLUMN_KEY);
            if (StringUtils.equalsIgnoreCase(attrVal, oldColumnKey)) {
                tagNode.setAttribute(ConstantUtil.COLUMN_KEY, newColumnKey);
            }
        };

        COLUMN_KEY_REF_LIST.forEach(tagName -> bodyNode.findNodesByTagName(tagName).forEach(tagNodeConsumer));
    }

    public static void updateTableKey(Diff diff, String oldTableKey, String newTableKey) {
        if (Objects.isNull(diff.getMetaForm()) || Objects.isNull(diff.getXmlTree())) {
            return;
        }

        final XmlTree xmlTree = diff.getXmlTree().xmlTree;
        final TagNode rootNode = xmlTree.getRoot();
        final TagNode bodyNode = rootNode.getOrCreateChildByTagName("Body");

        Consumer<TagNode> tagNodeConsumer = tagNode -> {
            Map<String, String> attributes = tagNode.getAttributes();
            String attrVal = attributes.get(ConstantUtil.TABLE_KEY);
            if (StringUtils.equalsIgnoreCase(attrVal, oldTableKey)) {
                tagNode.setAttribute(ConstantUtil.TABLE_KEY, newTableKey);
            }
        };

        TABLE_KEY_REF_LIST.forEach(tagName -> bodyNode.findNodesByTagName(tagName).forEach(tagNodeConsumer));
    }


}
