package com.bokesoft.yes.design.xml.node;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.utils.XmlNodeDefaultValue;
import com.bokesoft.yes.design.xml.parse.Element;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.xml.defaultnode.DefaultNodeDefine;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.*;
import java.util.function.Predicate;

public class TagNode extends AbstractNode {
    private String tagName = null;

    private Map<String, String> attributes = new LinkedHashMap<String, String>();
    private final List<AbstractNode> nodes = new ArrayList<AbstractNode>();

    public TagNode(String tagName, Element element) {
        super("", element);
        this.tagName = tagName;
    }

    public TagNode(Element element) {
        super("", element);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        if (attributes != null) {
            this.attributes = attributes;
        }
    }

    public boolean hasAttribute(String attrName) {
        return attributes.containsKey(attrName);
    }

    public List<AbstractNode> getChildren() {
        return this.nodes;
    }

    public boolean hasChildren() {
        return this.nodes.size() != 0;
    }

    public boolean hasChildrenByTagName(String name) {
        for (AbstractNode node : this.nodes) {
            if (node instanceof TagNode && ((TagNode) node).getTagName().equals(name)) {
                return true;
            }
        }
        return false;
    }

    public List<AbstractNode> getChildrenByTagName(String name) {
        List<AbstractNode> list = new ArrayList<>();
        List<AbstractNode> ch = getChildren();
        for (int i = 0; i < ch.size(); i++) {
            if ((ch.get(i) instanceof TagNode) && (((TagNode) ch.get(i)).getTagName().equals(name))) {
                list.add(ch.get(i));
            }
        }
        return list;
    }
    public List<TagNode> getTagNodeChildrenByTagName(String name) {
        List<TagNode> list = new ArrayList<>();
        List<AbstractNode> ch = getChildren();
        for (int i = 0; i < ch.size(); i++) {
            if ((ch.get(i) instanceof TagNode) && (((TagNode) ch.get(i)).getTagName().equals(name))) {
                list.add((TagNode) ch.get(i));
            }
        }
        return list;
    }

    /**
     * 根据TagName取一个儿子，若取不到，就创建一下
     *
     * @param name
     * @return
     */
    public TagNode getOrCreateChildByTagName(String name) {
        TagNode tageNode = this.getChildByTagName(name);
        if (Objects.isNull(tageNode)) {
            tageNode = new TagNode(name, null);
            this.addNode(tageNode);
        }
        return tageNode;
    }
    /**
     * 根据Key取一个儿子，若取不到，就创建一下
     *
     * @param tagName
     * @param Key
     * @return
     */
    public TagNode getOrCreateChildByKey(String tagName, String key) {
        if (key.isEmpty()) {
            return getOrCreateChildByTagName(tagName);
        } else {
            TagNode tageNode = this.getChildByTagNameAndKey(tagName, key);
            if (Objects.isNull(tageNode)) {
                tageNode = new TagNode(tagName, null);
                tageNode.setAttribute(ConstantUtil.KEY, key);
                this.addNode(tageNode);
            }
            return tageNode;
        }

    }
    public TagNode getOrCreateChildByTagName(String name, int i) {
        TagNode tageNode = this.getChildByTagName(name);
        if (Objects.isNull(tageNode)) {
            tageNode = new TagNode(name, null);
            int size = this.getChildren().size();
            i = Math.min(i, size-1);
            this.addNode(tageNode, i);
        }
        return tageNode;
    }

    public TagNode getChildByTagName(String tagName) {
        Predicate<AbstractNode> predicate = childNode -> {
            if (!(childNode instanceof TagNode)) {
                return false;
            }
            TagNode childTagNode = (TagNode) childNode;
            return StringUtils.equals(childTagNode.getTagName(), tagName);
        };
        List<AbstractNode> childNodeList = this.getChildren();
        Optional<AbstractNode> optional = childNodeList.stream().filter(predicate).findFirst();
        return optional.map(node -> (TagNode) node).orElse(null);
    }
  public TagNode getChildByTagNameAndKey(String tagName,String key) {
        Predicate<AbstractNode> predicate = childNode -> {
            if (!(childNode instanceof TagNode)) {
                return false;
            }
            TagNode childTagNode = (TagNode) childNode;
            return StringUtils.equals(childTagNode.getTagName(), tagName) && childTagNode.getPrimaryKey().equals(tagName+"@"+key);
        };
        List<AbstractNode> childNodeList = this.getChildren();
        Optional<AbstractNode> optional = childNodeList.stream().filter(predicate).findFirst();
        return optional.map(node -> (TagNode) node).orElse(null);
    }

    /**
     * 根据key取一个儿子
     *
     * @param key
     * @return
     */
    public TagNode getChildByKey(String key) {
        List<AbstractNode> ch = getChildren();
        for (int i = 0; i < ch.size(); i++) {
            AbstractNode tmp = ch.get(i);
            if ((tmp instanceof TagNode)) {
                Map<String, String> attributes = ((TagNode) tmp).getAttributes();
                if (attributes != null && key.equals(attributes.get(ConstantUtil.KEY))) {
                    return (TagNode) tmp;
                }
            }
        }
        return null;


    }

    /**
     * 根据TagName删除节点
     *
     * @param name
     * @return
     */
    public void deleteChildByTagName(String name) {
        for (Iterator<AbstractNode> iterator = this.getChildren().iterator(); iterator.hasNext(); ) {
            AbstractNode tmp = iterator.next();
            if ((tmp instanceof TagNode) && ((TagNode) tmp).getTagName().equals(name)) {
                iterator.remove();
            }
        }
    }

    /**
     * 根据Key删除节点
     *
     * @param Key
     * @return
     */
    public void deleteChildByTagKey(String Key) {
        for (int i = 0; i < this.getChildren().size(); i++) {
            if ((this.getChildren().get(i) instanceof TagNode) && Key.equals(((TagNode) this.getChildren().get(i)).getAttributes().get("Key"))) {
                this.getChildren().remove(i);
                //this.getChildren().get(i) != null && ((TagNode) this.getChildren().get(i)).getAttributes() != null &&((TagNode) this.getChildren().get(i)).getAttributes().get("Key") != null  &&
            }
        }
    }

    /**
     * 根据一个属性等于一个或者多个值删除节点
     * @param attrName 属性名
     * @param attrValue 属性值
     */
    public void deleteChildByAttributes(String attrName, String... attrValue){
        List<String> values = Arrays.asList(attrValue);
        for (int i = 0; i < this.getChildren().size(); i++) {
            if ((this.getChildren().get(i) instanceof TagNode) && values.contains(((TagNode) this.getChildren().get(i)).getAttributes().get(attrName))) {
                this.getChildren().remove(i);
            }
        }
    }

    /**
     * 设置节点的CData值
     *
     * @param newValue
     */
    public void setCDataValue(String newValue) {
        for (Iterator<AbstractNode> iterator = this.getChildren().iterator(); iterator.hasNext(); ) {
            AbstractNode cdata = iterator.next();
            if (cdata instanceof CDataNode) {
                ((CDataNode) cdata).setText(newValue);
                return;
            }
        }
        CDataNode cNode = new CDataNode(newValue, null);
        this.addNode(cNode);
    }

    /**
     * 删除节点的CData值
     */
    public void deleteCDataValue() {
        for (Iterator<AbstractNode> iterator = this.getChildren().iterator(); iterator.hasNext(); ) {
            AbstractNode cdata = iterator.next();
            if (cdata instanceof CDataNode) {
                iterator.remove();
            }
        }
    }

    public TagNode findChildByTagNode(TagNode tagNode) {
        for (AbstractNode ch : nodes) {
            if (ch instanceof TagNode) {
                String curPrimaryKey = ((TagNode) ch).getPrimaryKey();
                String findPrimaryKey = tagNode.getPrimaryKey();
                if (curPrimaryKey.equalsIgnoreCase(findPrimaryKey)) {
                    return (TagNode) ch;
                }
            }
        }
        return null;
    }

    public TagNode findFirstTagNodeByTagName(String tagName) {
        List<TagNode> list = findNodesByTagName(tagName);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    public List<TagNode> findNodesByTagName(String tagName) {
        if (StringUtils.isBlank(tagName)) {
            return null;
        }
        List<TagNode> list = new ArrayList<TagNode>();
        loadNodesByTagName(tagName, list);
        return list;
    }

    public List<TagNode> findNodesByTagName2(String tagName) {
        if (StringUtils.isBlank(tagName)) {
            return null;
        }
        List<TagNode> list = new ArrayList<TagNode>();
        loadNodesByTagName2(tagName, list);
        return list;
    }

    public List<CDataNode> findCDataNodesByTagName(List<CDataNode> list) {
        for (AbstractNode ch : nodes) {
            if (ch instanceof TagNode) {
                ((TagNode) ch).findCDataNodesByTagName(list);
            } else if (ch instanceof CDataNode) {
                list.add((CDataNode) ch);
            }
        }
        return list;
    }
    public String getCDataValue() {
        String cdataValue = "";
        for (AbstractNode ch : nodes) {
           if (ch instanceof CDataNode) {
               cdataValue = ((CDataNode) ch).getText();
            }
        }
        return cdataValue;
    }

    //只寻找并返回当前节点下tagName满足要求的节点，与findNodesByTagName方法区别在与不会返回选中节点子节点中满足要求的节点
    public List<TagNode> findMyselfNodesByTagName(String tagName) {
        if (StringUtils.isBlank(tagName)) {
            return null;
        }
        List<TagNode> list = new ArrayList<TagNode>();
        for (AbstractNode ch : nodes) {
            if (ch instanceof TagNode) {
                if (tagName.equals(((TagNode) ch).getTagName())) {
                    list.add((TagNode) ch);
                }
            }
        }
        return list;
    }

    public void loadNodesByTagName(String tagName, List<TagNode> list) {
        if (StringUtils.isBlank(tagName)) {
            return;
        }
        if (tagName.equals(this.getTagName())) {
            list.add(this);
            return;
        }

        for (AbstractNode ch : nodes) {
            if (ch instanceof TagNode) {
                ((TagNode) ch).loadNodesByTagName(tagName, list);
            }
        }
    }

    public void loadNodesByTagName2(String tagName, List<TagNode> list) {
        if (StringUtils.isBlank(tagName)) {
            return;
        }
        if (tagName.equals(this.getTagName())) {
            list.add(this);
        }

        for (AbstractNode ch : nodes) {
            if (ch instanceof TagNode) {
                ((TagNode) ch).loadNodesByTagName2(tagName, list);
            }
        }
    }

    public TagNode getFirst(String tag) {
        List<AbstractNode> tem = getChildrenByTagName(tag);
        if (tem.size() == 0) {
            return null;
        }
        return (TagNode) tem.get(0);
    }

    public TagNode getLast(String tag) {
        List<AbstractNode> tem = getChildrenByTagName(tag);
        if (tem.size() == 0) {
            return null;
        }
        return (TagNode) tem.get(tem.size() - 1);
    }

    public AbstractNode getFirst() {
        List<AbstractNode> list = getChildren();
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public AbstractNode getLast() {
        List<AbstractNode> list = getChildren();
        if (list.size() == 0) {
            return this;
        }
        return list.get(list.size() - 1);
    }

    /**
     * 追加节点，加在儿子的最后
     *
     * @param node
     * @return
     */
    public TagNode appendNode(AbstractNode node) {
/*		if (node instanceof TagNode) {
			if ("TextArea@memo".equalsIgnoreCase(((TagNode) node).getPrimaryKey()) ) {
			    //System.out.println();
			}
		}*/
        if (Objects.isNull(node)) {
            throw new IllegalArgumentException("addNode:node cant null");
        }
        this.nodes.add(node);
        node.setParent(this);
        return this;
    }

    //删除行
    public void deleteChildX(AbstractNode node, int i) throws Throwable {
        if (Objects.isNull(node)) {
            throw new IllegalArgumentException("addNode:node cant null");
        }
        if (this.nodes.size() <= 4) {
            throw new Throwable("行数已经达到最小值,不能再删除了");
        }
        if (nodes.size() > 0) {
            if ((this.getChildren().get(i) instanceof TagNode)) {
                this.nodes.remove(this.getChildren().get(i));
            }
        }
        node.setParent(this);
    }

    public void deleteChidY(AbstractNode node, int i) throws Throwable {
        if (Objects.isNull(node)) {
            throw new IllegalArgumentException("addNode:node cant null");
        }
        if (this.nodes.size() <= 4) {
            throw new Throwable("列数已经达到最小值,不能再删除了");
        }
        if (nodes.size() > 0) {
            if ((this.getChildren().get(i) instanceof TagNode)) {
                this.nodes.remove(this.getChildren().get(i));
            }
        }
        node.setParent(this);
    }

    /**
     * 加入节点，可以会插入最后一个关闭节点前
     *
     * @param node
     * @return
     */
    public TagNode addNode(AbstractNode node) {
        return this.addNode(node, nodes.size() - 1);
    }

    /**
     * 加入节点，可以会插入指定位置关闭节点前
     *
     * @param node
     * @return
     */
    public TagNode addNode(AbstractNode node, int i) {
        if (Objects.isNull(node)) {
            throw new IllegalArgumentException("addNode:node cant null");
        }
        int size = nodes.size();
        i = Math.min(i, size-1);
        if (size > 0) {
            AbstractNode lastNode = nodes.get(size - 1);
            Element element = lastNode.getElement();
            if (element != null) {
                if (lastNode instanceof TagNode && element.getTagType() == Element.T_END && ((TagNode) lastNode).getTagName().equals(tagName)) {
                    this.nodes.add(i, node);
                }
            } else {
                this.nodes.add(node);
            }
        } else {
            this.nodes.add(node);
        }
        node.setParent(this);
        return this;
    }

    /**
     * 删除属性
     *
     * @param name
     * @return
     */
    public TagNode deleteAttribute(String name) {
        this.attributes.remove(name);
        return this;
    }

    /**
     * 设置属性的值
     *
     * @param name
     * @param value
     * @return
     */
    public TagNode setAttribute(String name, String value) {
        XmlNodeDefaultValue defaultValue = XmlNodeDefaultValue.getDefaultValue(name);
        if (Objects.isNull(defaultValue)) {
            if (StringUtils.isEmpty(value)) {
                this.attributes.remove(name);
            } else {
                this.attributes.put(name, value);
            }
        } else {
            if (StringUtils.isEmpty(value)
                    || defaultValue.defaultNodeValue.equalsIgnoreCase(value)
                    || (defaultValue.defaultNodeValues != null
                    && defaultValue.defaultNodeValues.get(this.tagName) != null
                    && defaultValue.defaultNodeValues.get(this.tagName).equalsIgnoreCase(value))) {
                if (!StringUtils.equals(this.tagName, "DefaultValue")){//如果不是默认值的话移除
                    this.attributes.remove(name);
                }
            } else if (StringUtils.equals(this.tagName, ConstantUtil.GRID_CELL)
                    && defaultValue.defaultNodeValues != null
                    && StringUtils.equalsIgnoreCase(defaultValue.defaultNodeValues.get(this.getAttributes().get(ConstantUtil.CELL_TYPE)), value)) {
                this.attributes.remove(name);
            } else {
                this.attributes.put(name, value);
            }
        }
        return this;
    }
    /**
     * 设置属性的值
     *
     * @param name
     * @param value
     * @return
     */
    public TagNode setAttribute(String name, String value,Object defaultValue) {
        if (ObjectUtils.notEqual(value,defaultValue)){
            this.attributes.put(name, value);
        } else {
           this.attributes.remove(name);
        }
        return this;
    }

    /**
     * 设置属性的值,不清除空属性
     *
     * @param name
     * @param value
     * @return
     */
    public TagNode setAttributeNotRemove(String name, String value) {
        this.attributes.put(name, value);
        return this;
    }

    public String getTagName() {
        return this.tagName;
    }

    public TagNode setTagName(String tagName) {
        this.tagName = tagName;
        return this;
    }

    public String getPrimaryKey() {
        if (Objects.isNull(tagName)) {
            return null;
        }
        Element element = getElement();
        if (Objects.nonNull(element) && element.getTagType() == Element.T_END) {
            return null;
        }

        String attrKey = DefaultNodeDefine.getInstance().getPrimaryKey(tagName);
        String primaryValue = attributes.get(attrKey);
        if (StringUtils.isBlank(primaryValue)) {
            return null;
        }
        return tagName.concat("@").concat(primaryValue);
    }

    @Override
    public String toXml(int level) {
        return this.toXml(level, true);
    }

    public String toXml(int level, boolean escape) {
        StringBuilder strBuilder = new StringBuilder();
        if (level == 0) {
            strBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n");
            appendPreComment(strBuilder, this, level);
        }
        appendLevelBlank(strBuilder, level);
        String sAttrs = getAttrsString(escape);
        strBuilder.append("<").append(tagName);
        if (!StringUtil.isEmptyStr(sAttrs)) {
            strBuilder.append(" ");
        }
        strBuilder.append(sAttrs);

        int childrenSize = nodes.size();
        if (childrenSize == 0 || (childrenSize == 1 && (nodes.get(0) instanceof TagNode)
                && ((TagNode) nodes.get(0)).getTagName().equals(tagName))
                && ((TagNode) nodes.get(0)).getChildren().size() == 0) {
            strBuilder.append("/>");
        } else {
            strBuilder.append(">").append("\r\n");
            for (int i = 0; i < childrenSize; i++) {
                AbstractNode node = nodes.get(i);
                if(node == null) continue;
                String nodeTagName = (node instanceof TagNode) ? ((TagNode) node).getTagName() : null;
                if (i == childrenSize - 1 && tagName.equals(nodeTagName)
                        && node instanceof TagNode
                        && ((TagNode) node).getChildren().size() == 0) { // 最后一个关闭Tag
                    appendLevelBlank(strBuilder, level);
                    strBuilder.append("</").append(tagName).append(">");
                    break;
                } else if (i == childrenSize - 1) {
                    appendPreComment(strBuilder, node, level + 1);
                    strBuilder.append(node.toXml(level + 1, escape)).append("\r\n");
                    appendLastComment(strBuilder, node, level + 1);
                    appendLevelBlank(strBuilder, level);
                    strBuilder.append("</").append(tagName).append(">");
                    break;
                }
                //appendPreComment(strBuilder, node, level + 1);
	/*			if (node instanceof TextNode && StringUtils.isBlank(node.getText())) {
					continue;
				}*/
                strBuilder.append(node.toXml(level + 1, escape)).append("\r\n");
                appendLastComment(strBuilder, node, level + 1);
            }
            // appendLevelBlank(strBuilder, level);
            // strBuilder.append("</").append(tagName).append(">");
        }

        if (level == 0) {
            strBuilder.append("\r\n");
            appendLastComment(strBuilder, this, level);
        }
        return strBuilder.toString();
    }

    private void appendPreComment(StringBuilder strBuilder, AbstractNode node, int level) {
        List<AbstractNode> listPreComment = node.getPreComment();
        if (CollectionUtils.isEmpty(listPreComment)) {
            return;
        }
        for (AbstractNode comment : listPreComment) {
            strBuilder.append(comment.toXml(level)).append("\r\n");
        }
    }

    private void appendLastComment(StringBuilder strBuilder, AbstractNode node, int level) {
        List<AbstractNode> listLastComment = node.getLastComment();
        if (CollectionUtils.isEmpty(listLastComment)) {
            return;
        }
        for (AbstractNode comment : listLastComment) {
            strBuilder.append(comment.toXml(level)).append("\r\n");
        }
    }

    private String getAttrsString(boolean escape) {
        String sAttrs = "";
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (sAttrs.length() == 0) {
                sAttrs = entry.getKey() + "=\"" + convertSpecialChars(entry.getValue(), escape) + "\"";
            } else {
                sAttrs += " " + entry.getKey() + "=\"" + convertSpecialChars(entry.getValue(), escape) + "\"";
            }
        }
        return sAttrs;
    }

    @Override
    public AbstractNode clone() {
        TagNode node = new TagNode(this.getTagName(), null);
        for (Map.Entry<String, String> entry : getAttributes().entrySet()) {
            node.setAttribute(entry.getKey(), entry.getValue());
        }

        for (AbstractNode tmpNode : nodes) {
            node.getChildren().add(tmpNode.clone());
        }
        return node;
    }

    @Override
    public boolean hasPrimaryAttribute() {
        String primaryAttrKey = DefaultNodeDefine.getInstance().getPrimaryKey(this.getTagName());
        return !StringUtil.isBlankOrNull(attributes.get(primaryAttrKey));
    }

    public String getPrimaryAttrName() {
        return DefaultNodeDefine.getInstance().getPrimaryKey(this.getTagName());
    }

}
