package com.bokesoft.yes.design.xml.dom;

import java.io.Externalizable;
import java.util.Objects;

import com.bokesoft.yes.common.util.StringUtil;

/**
 * NOTICE 混淆器没法追踪模板超类
 */
public abstract class KeyPairBaseObject extends XMLPropertyBagObject implements IKeyPairObject, Comparable<IKeyPairObject>, Externalizable {

	@Override
	public int compareTo(IKeyPairObject o) {
		return this.getKey().compareTo(o.getKey());
	}

	@Override
	public boolean equals(Object o) {
		// 目前只是判断了key是否相同,而且key区分大小写
		// 为什么要区分大小写,因为上面的compareTo也是区分大小写的.
		if (!StringUtil.isBlankOrNull(o) && o instanceof KeyPairBaseObject) {
			return this.getKey().equals(((KeyPairBaseObject) o).getKey());
		}
		return false;
	}
	
	@Override
    public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + (Objects.isNull(this.getKey()) ? 0 : this.getKey().hashCode());
		return result;
	}
}