package com.bokesoft.yes.design.utils;


import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ChartType;

import java.util.HashMap;

/**
 * 记录所有节点默认值
 */
public class XmlNodeDefaultValue {


	public final String name;
	public final String defaultNodeValue;
	public final HashMap<String, String> defaultNodeValues = new HashMap<>();


	//表格分页相关
	public static final XmlNodeDefaultValue PAGE_ROW_COUNT = new XmlNodeDefaultValue("PageRowCount", "50", null);
	public static final XmlNodeDefaultValue PAGE_INDICATOR_COUNT = new XmlNodeDefaultValue("PageIndicatorCount", "5", null);

	//MetaCondition
	public static final XmlNodeDefaultValue GROUP_HEAD = new XmlNodeDefaultValue("GroupHead", "false", null);
	public static final XmlNodeDefaultValue GROUP_TAIL = new XmlNodeDefaultValue("GroupTail", "false", null);
	public static final XmlNodeDefaultValue LIMIT_TO_SOURCE = new XmlNodeDefaultValue("LimitToSource", "false", null);
	public static final XmlNodeDefaultValue LOAD_HISTORY_INPUT = new XmlNodeDefaultValue("loadHistoryInput", "false", null);
	public static final XmlNodeDefaultValue FORM_LOAD_HISTORY_INPUT = new XmlNodeDefaultValue("LoadHistoryInput", "false", null);
	public static final XmlNodeDefaultValue ONLY_FILTER = new XmlNodeDefaultValue("OnlyFilter", "false", null);
	public static final XmlNodeDefaultValue NEED_RESET = new XmlNodeDefaultValue("NeedReset", "true", null);
	//MetaComponent
	public static final XmlNodeDefaultValue X = new XmlNodeDefaultValue("X", "-1", null);
	public static final XmlNodeDefaultValue Y = new XmlNodeDefaultValue("Y", "-1", null);
	public static final XmlNodeDefaultValue X_SPAN = new XmlNodeDefaultValue("XSpan", "1", null);
	public static final XmlNodeDefaultValue Y_SPAN = new XmlNodeDefaultValue("YSpan", "1", null);
	public static final XmlNodeDefaultValue POSITION = new XmlNodeDefaultValue("Position", "Static", null);
	public static final XmlNodeDefaultValue LEFT = new XmlNodeDefaultValue("Left", "-1", null);
	public static final XmlNodeDefaultValue TOP = new XmlNodeDefaultValue("Top", "-1", null);
	public static final XmlNodeDefaultValue RIGHT = new XmlNodeDefaultValue("Right", "-1", null);
	public static final XmlNodeDefaultValue BOTTOM = new XmlNodeDefaultValue("Bottom", "-1", null);
	public static final XmlNodeDefaultValue TAB_ORDER = new XmlNodeDefaultValue("TabOrder", "-1", null);
	public static final XmlNodeDefaultValue AS_QUERY = new XmlNodeDefaultValue("AsQuery", "false", null);
	public static final XmlNodeDefaultValue ONLY_SHOW = new XmlNodeDefaultValue("OnlyShow", "false", null);
	public static final XmlNodeDefaultValue CLEARABLE = new XmlNodeDefaultValue("Clearable", "true", null);
	public static final XmlNodeDefaultValue COPY_NEW = new XmlNodeDefaultValue("CopyNew", "true", null);
	//MetaListViewColumn
	public static final XmlNodeDefaultValue COLUMN_TYPE;
	public static final XmlNodeDefaultValue IS_SELECT = new XmlNodeDefaultValue("IsSelect", "false", null);
	public static final XmlNodeDefaultValue SINGLE_SELECT = new XmlNodeDefaultValue("SingleSelect", "false", null);
	public static final XmlNodeDefaultValue WRAP_TEXT = new XmlNodeDefaultValue("WrapText", "false", null);
	public static final XmlNodeDefaultValue SORTABLE = new XmlNodeDefaultValue("Sortable", "false", null);

	//MetaGridCell
	public static final XmlNodeDefaultValue CELL_TYPE = new XmlNodeDefaultValue("CellType", "Label", null);
	public static final XmlNodeDefaultValue IS_MERGED = new XmlNodeDefaultValue("IsMerged", "false", null);
	public static final XmlNodeDefaultValue IS_MERGED_HEAD = new XmlNodeDefaultValue("IsMergedHead", "false", null);
	public static final XmlNodeDefaultValue MERGED_ROW_SPAN = new XmlNodeDefaultValue("MergedRowSpan", "1", null);
	public static final XmlNodeDefaultValue MERGED_COLUMN_SPAN = new XmlNodeDefaultValue("MergedColumnSpan", "1", null);
	public static final XmlNodeDefaultValue MERGE = new XmlNodeDefaultValue("Merge", "false", null);
	public static final XmlNodeDefaultValue MERGE_GROUP = new XmlNodeDefaultValue("MergeGroup", "false", null);
	public static final XmlNodeDefaultValue CELL_SORT_TYPE = new XmlNodeDefaultValue("CellSortType", "Asc", null);

	//MetaForm
	public static final XmlNodeDefaultValue FORM_TYPE = new XmlNodeDefaultValue("FormType", "Normal", null);
	public static final XmlNodeDefaultValue AUTHENTICATE = new XmlNodeDefaultValue("Authenticate", "true", null);
	public static final XmlNodeDefaultValue FORM_DISPLAY = new XmlNodeDefaultValue("FormDisplay", "false", null);
	public static final XmlNodeDefaultValue INIT_STATE = new XmlNodeDefaultValue("InitState", "Edit", null);
	public static final XmlNodeDefaultValue PLATFORM = new XmlNodeDefaultValue("Platform", "All", null);
	public static final XmlNodeDefaultValue SCREEN_ORIENTATION = new XmlNodeDefaultValue("ScreenOrientation", "unspecified", null);
	public static final XmlNodeDefaultValue CONFIRM_CLOSE = new XmlNodeDefaultValue("ConfirmClose", "true", null);
	public static final XmlNodeDefaultValue VERSION = new XmlNodeDefaultValue("Version", "0", null);
	public static final XmlNodeDefaultValue USE_VARIANT = new XmlNodeDefaultValue("UseVariant", "false", null);
	public static final XmlNodeDefaultValue MERGE_TO_SOURCE = new XmlNodeDefaultValue("MergeToSource", "false", null);

	//MetaBody
	public static final XmlNodeDefaultValue OVERFLOW_X = new XmlNodeDefaultValue("OverflowX", "Visible", null);
	public static final XmlNodeDefaultValue OVERFLOW_Y = new XmlNodeDefaultValue("OverflowY", "Visible", null);
	public static final XmlNodeDefaultValue RESIZABLE = new XmlNodeDefaultValue("Resizable", "true", null);
	public static final XmlNodeDefaultValue SHARE_TO_MID = new XmlNodeDefaultValue("ShareToMid", "true", null);
	public static final XmlNodeDefaultValue SIZE = new XmlNodeDefaultValue("Size", "-1", null);
	public static final XmlNodeDefaultValue BOLD = new XmlNodeDefaultValue("Bold", "false", null);
	public static final XmlNodeDefaultValue ITALIC = new XmlNodeDefaultValue("Italic", "false", null);
	public static final XmlNodeDefaultValue REQUIRED = new XmlNodeDefaultValue("Required", "false", null);
	public static final XmlNodeDefaultValue SEPARATOR = new XmlNodeDefaultValue("Separator", "false", null);
	public static final XmlNodeDefaultValue LEFT_BORDER = new XmlNodeDefaultValue("LeftBorder", "false", null);
	public static final XmlNodeDefaultValue TOP_BORDER = new XmlNodeDefaultValue("TopBorder", "false", null);
	public static final XmlNodeDefaultValue RIGHT_BORDER = new XmlNodeDefaultValue("RightBorder", "false", null);
	public static final XmlNodeDefaultValue BOTTOM_BORDER = new XmlNodeDefaultValue("BottomBorder", "false", null);
	public static final XmlNodeDefaultValue AUTO_CAPTION = new XmlNodeDefaultValue("AutoCaption", "false", null);
	public static final XmlNodeDefaultValue FREEZE = new XmlNodeDefaultValue("Freeze", "false", null);
	public static final XmlNodeDefaultValue OP = new XmlNodeDefaultValue("Op", "AND", null);
	public static final XmlNodeDefaultValue ROW_HEIGHT = new XmlNodeDefaultValue("RowHeight", "0", null);
	public static final XmlNodeDefaultValue DEFAULT_LAYER = new XmlNodeDefaultValue("DefaultLayer", "-1", null);
	public static final XmlNodeDefaultValue LINK_TYPE = new XmlNodeDefaultValue("LinkType", "Parent", null);
	//DataObject
	public static final XmlNodeDefaultValue PERSIST = new XmlNodeDefaultValue(ConstantUtil.PERSIST, "true", null);
	public static final XmlNodeDefaultValue LOAD_RIGHTS_TYPE = new XmlNodeDefaultValue(ConstantUtil.LOAD_RIGHTS_TYPE, "Filter", null);
	public static final XmlNodeDefaultValue CHECK_AFTER_LOAD = new XmlNodeDefaultValue(ConstantUtil.CHECK_AFTER_LOAD, "false", null);
	public static final XmlNodeDefaultValue SECONDARY_TYPE = new XmlNodeDefaultValue(ConstantUtil.SECONDARY_TYPE, "Normal", null);
	public static final XmlNodeDefaultValue QUERY_FIELDS = new XmlNodeDefaultValue("QueryFields", "Code;Name", null);
	public static final XmlNodeDefaultValue DISPLAY_FIELDS = new XmlNodeDefaultValue("DisplayFields", "Code;Name", null);
	public static final XmlNodeDefaultValue PRIMARY_TYPE = new XmlNodeDefaultValue("PrimaryType", "Virtual", null);
	public static final XmlNodeDefaultValue MIGRATION_UPDATE_STRATEGY = new XmlNodeDefaultValue("MigrationUpdateStrategy", "InsertFast", null);
	public static final XmlNodeDefaultValue MAINTAIN_DICT = new XmlNodeDefaultValue("MaintainDict", "true", null);
	public static final XmlNodeDefaultValue ZERO_PREFIX = new XmlNodeDefaultValue("ZeroPrefix", "6", null);
	public static final XmlNodeDefaultValue FORBIDDEN_LOAD = new XmlNodeDefaultValue("ForbiddenLoad", "false", null);
	public static final XmlNodeDefaultValue FORBIDDEN_SAVE = new XmlNodeDefaultValue("ForbiddenSave", "false", null);
	public static final XmlNodeDefaultValue FORBIDDEN_DELETE = new XmlNodeDefaultValue("ForbiddenDelete", "false", null);
	public static final XmlNodeDefaultValue ROLL_DATA_STRATEGY = new XmlNodeDefaultValue("RollDataStrategy", "Normal", null);


	//MetaTable
	public static final XmlNodeDefaultValue TABLE_MODE = new XmlNodeDefaultValue("TableMode", "Head", null);
	public static final XmlNodeDefaultValue HIDDEN = new XmlNodeDefaultValue("Hidden", "false", null);
	public static final XmlNodeDefaultValue UNIQUE_PRIMARY = new XmlNodeDefaultValue("UniquePrimary", "false", null);
	public static final XmlNodeDefaultValue LAZY_LOAD = new XmlNodeDefaultValue("LazyLoad", "false", null);
	public static final XmlNodeDefaultValue USE_CURSOR = new XmlNodeDefaultValue("UseCursor", "false", null);
	public static final XmlNodeDefaultValue REFRESH_FILTER = new XmlNodeDefaultValue("RefreshFilter", "false", null);
	public static final XmlNodeDefaultValue LOAD_IN_MID_USE = new XmlNodeDefaultValue("LoadInMidUse", "true", null);

	//TextEditor
	public static final XmlNodeDefaultValue CASE = new XmlNodeDefaultValue("Case", "None", null);
	public static final XmlNodeDefaultValue TRIM = new XmlNodeDefaultValue("Trim", "false", null);
	public static final XmlNodeDefaultValue HOLD_FOCUS = new XmlNodeDefaultValue("HoldFocus", "false", null);
	public static final XmlNodeDefaultValue SELECT_ON_FOCUS = new XmlNodeDefaultValue("SelectOnFocus", "true", null);
	public static final XmlNodeDefaultValue MAX_LENGTH = new XmlNodeDefaultValue("MaxLength", "255", null);
	public static final XmlNodeDefaultValue EMBED_TEXT_SIZE = new XmlNodeDefaultValue("EmbedTextSize", "-1", null);
	//MetaLabel
	public static final XmlNodeDefaultValue SINGLE_LINE = new XmlNodeDefaultValue("SingleLine", "true", null);
	public static final XmlNodeDefaultValue LINE_BREAK_MODE = new XmlNodeDefaultValue("LineBreakMode", "EndHide", null);
	public static final XmlNodeDefaultValue MAX_LINES = new XmlNodeDefaultValue("MaxLines", "-1", null);
	//MetaCheckBox
	public static final XmlNodeDefaultValue ICON_LOCATION = new XmlNodeDefaultValue("IconLocation", "Left", null);
	//MetaButton
	public static final XmlNodeDefaultValue ONLY_ICON = new XmlNodeDefaultValue("OnlyIcon", "false", null);
	public static final XmlNodeDefaultValue NEED_ACCESS_LOG = new XmlNodeDefaultValue("NeedAccessLog", "false", null);
	//MetaAttachment
	public static final XmlNodeDefaultValue MAX_SIZE = new XmlNodeDefaultValue("MaxSize", "-1", null);
	public static final XmlNodeDefaultValue PREVIEW = new XmlNodeDefaultValue("Preview", "false", null);
	//MetaCheckListBox
	public static final XmlNodeDefaultValue COLUMN_COUNT = new XmlNodeDefaultValue("ColumnCount", "3", null);

	//MetaComboBox
	public static final XmlNodeDefaultValue INTEGER_VALUE = new XmlNodeDefaultValue("IntegerValue", "false", null);
	//MetaDict
	public static final XmlNodeDefaultValue IS_DYNAMIC = new XmlNodeDefaultValue("IsDynamic", "false", null);
	public static final XmlNodeDefaultValue IS_COMP_DICT = new XmlNodeDefaultValue("IsCompDict", "false", null);
	public static final XmlNodeDefaultValue ALLOW_MULTI_SELECTION = new XmlNodeDefaultValue("AllowMultiSelection", "false", null);
	public static final XmlNodeDefaultValue INDEPENDENT = new XmlNodeDefaultValue("Independent", "false", null);
	public static final XmlNodeDefaultValue IGNORE_RIGHTS = new XmlNodeDefaultValue("IgnoreRights", "false", null);
	public static final XmlNodeDefaultValue PROMPT_DATA = new XmlNodeDefaultValue("PromptData", "false", null);
	public static final XmlNodeDefaultValue STATE_MASK = new XmlNodeDefaultValue("StateMask", "Enable", null);
	public static final XmlNodeDefaultValue StateMaskFormula = new XmlNodeDefaultValue("StateMaskFormula", "", null);
	public static final XmlNodeDefaultValue ITEM_KEY_SOURCE_TYPE = new XmlNodeDefaultValue("ItemKeySourceType", "DataObject", null);
	public static final XmlNodeDefaultValue LOAD_TYPE = new XmlNodeDefaultValue("LoadType", "R2L", null);

	//MetaImage
	public static final XmlNodeDefaultValue STRETCH = new XmlNodeDefaultValue("Stretch", "false", null);
	public static final XmlNodeDefaultValue IMAGE_CUT = new XmlNodeDefaultValue("ImageCut", "false", null);
	public static final XmlNodeDefaultValue IMAGE_SCALE_TYPE = new XmlNodeDefaultValue("ImageScaleType", "", null);
	public static final XmlNodeDefaultValue RADIUS = new XmlNodeDefaultValue("Radius", "-1", null);
	public static final XmlNodeDefaultValue VIEW_MODE = new XmlNodeDefaultValue("ViewMode", "Self", null);
	public static final XmlNodeDefaultValue VIEW_OPT = new XmlNodeDefaultValue("ViewOpt", "false", null);
	public static final XmlNodeDefaultValue SHOW_THUMBNAIL = new XmlNodeDefaultValue("ShowThumbnail", "true", null);
	public static final XmlNodeDefaultValue UPLOAD_PROGRESS = new XmlNodeDefaultValue("UploadProgress", "None", null);
	//MetaNumberEditor
	public static final XmlNodeDefaultValue USE_GROUPING_SEPARATOR = new XmlNodeDefaultValue("UseGroupingSeparator", "true", null);
	public static final XmlNodeDefaultValue ROUNDING_MODE = new XmlNodeDefaultValue("RoundingMode", "HALF_UP", null);
	public static final XmlNodeDefaultValue SHOW_ZERO = new XmlNodeDefaultValue("ShowZero", "false", null);
	public static final XmlNodeDefaultValue STRIP_TRAILING_ZEROS = new XmlNodeDefaultValue("StripTrailingZeros", "false", null);

	//MetaPlant
	public static final XmlNodeDefaultValue ORIENTATION = new XmlNodeDefaultValue("Orientation", "Horizontal", null);
	//MetaTabPanel
	public static final XmlNodeDefaultValue TAB_POSITION = new XmlNodeDefaultValue("TabPosition", "top", null);
	public static final XmlNodeDefaultValue TAB_MODE = new XmlNodeDefaultValue("TabMode", "Fixed", null);

	public static final XmlNodeDefaultValue BACK_IMAGE_POSITION = new XmlNodeDefaultValue("BackImagePosition", "center", null);
	public static final XmlNodeDefaultValue BACK_IMAGE_REPEAT_X = new XmlNodeDefaultValue("BackImageRepeatX", "false", null);
	public static final XmlNodeDefaultValue BACK_IMAGE_REPEAT_Y = new XmlNodeDefaultValue("BackImageRepeatY", "false", null);
	public static final XmlNodeDefaultValue FORCE_LAYOUT = new XmlNodeDefaultValue("ForceLayout", "true", null);
	public static final XmlNodeDefaultValue INCLUDE_DATA_TABLE = new XmlNodeDefaultValue("IncludeDataTable", "true", null);
	public static final XmlNodeDefaultValue SAFE_INPUT = new XmlNodeDefaultValue("SafeInput", "false", null);
	public static final XmlNodeDefaultValue SHOW_SWITCH_ICON = new XmlNodeDefaultValue("ShowSwitchIcon", "true", null);
	//Grid
	public static final XmlNodeDefaultValue NEW_EMPTY_ROW = new XmlNodeDefaultValue("NewEmptyRow", "true", null);
	public static final XmlNodeDefaultValue DEFAULT_FIT_WIDTH = new XmlNodeDefaultValue("DefaultFitWidth", "false", null);
	public static final XmlNodeDefaultValue SHOW_ROW_HEAD = new XmlNodeDefaultValue("ShowRowHead", "true", null);
	public static final XmlNodeDefaultValue HIDE_GROUP_4_EDITING = new XmlNodeDefaultValue("HideGroup4Editing", "false", null);
	public static final XmlNodeDefaultValue PAGE_LOAD_TYPE = new XmlNodeDefaultValue("PageLoadType", "NONE", null);
	public static final XmlNodeDefaultValue CAN_INSERT = new XmlNodeDefaultValue("CanInsert", "true", null);
	public static final XmlNodeDefaultValue CAN_DELETE = new XmlNodeDefaultValue("CanDelete", "true", null);
	public static final XmlNodeDefaultValue CAN_SHIFT = new XmlNodeDefaultValue("CanShift", "true", null);
	public static final XmlNodeDefaultValue FROZEN_ROW = new XmlNodeDefaultValue("FrozenRow", "false", null);
	public static final XmlNodeDefaultValue FROZEN_COLUMN = new XmlNodeDefaultValue("FrozenColumn", "false", null);
	public static final XmlNodeDefaultValue BEST_WIDTH = new XmlNodeDefaultValue("BestWidth", "true", null);
	public static final XmlNodeDefaultValue SELECTION_MODE = new XmlNodeDefaultValue("SelectionMode", "Range", null);
	public static final XmlNodeDefaultValue SERIAL_SEQ = new XmlNodeDefaultValue("SerialSeq", "false", null);
	public static final XmlNodeDefaultValue SERIAL_ROW_NUM = new XmlNodeDefaultValue("SerialRowNum", "false", null);
	public static final XmlNodeDefaultValue END_EDIT_BY_NAV = new XmlNodeDefaultValue("EndEditByNav", "false", null);
	public static final XmlNodeDefaultValue IS_DEFAULT = new XmlNodeDefaultValue("IsDefault", "false", null);
	public static final XmlNodeDefaultValue MERGE_OPERATION = new XmlNodeDefaultValue("MergeOperation", "false", null);
	public static final XmlNodeDefaultValue MANAGED = new XmlNodeDefaultValue("Managed", "false", null);
	public static final XmlNodeDefaultValue SELF_DISABLE = new XmlNodeDefaultValue("SelfDisable", "false", null);
	//MetaColumn
	public static final XmlNodeDefaultValue LENGTH = new XmlNodeDefaultValue("Length", "255", null);
	public static final XmlNodeDefaultValue NEED_RIGHTS = new XmlNodeDefaultValue("NeedRights", "Default", null);
	public static final XmlNodeDefaultValue IS_PRIMARY = new XmlNodeDefaultValue("IsPrimary", "false", null);
	public static final XmlNodeDefaultValue EXPAND = new XmlNodeDefaultValue("Expand", "false", null);
	public static final XmlNodeDefaultValue ACCESS_CONTROL = new XmlNodeDefaultValue("AccessControl", "false", null);
	public static final XmlNodeDefaultValue SORT_TYPE = new XmlNodeDefaultValue("SortType", "None", null);
	public static final XmlNodeDefaultValue IGNORE_SAVE = new XmlNodeDefaultValue("IgnoreSave", "false", null);
	public static final XmlNodeDefaultValue SUPPORT_I_18_N = new XmlNodeDefaultValue("SupportI18n", "false", null);
	public static final XmlNodeDefaultValue ExpandType = new XmlNodeDefaultValue("ExpandType", "Dict",null);
	public static final XmlNodeDefaultValue Standalone = new XmlNodeDefaultValue("IsStandalone", "false",null);

	//MetaColumnExpand
	public static final XmlNodeDefaultValue Expand_Type = new XmlNodeDefaultValue("ExpandType", "Data", null);
	public static final XmlNodeDefaultValue Expand_SourceType = new XmlNodeDefaultValue("ExpandSourceType", "Custom", null);
	public static final XmlNodeDefaultValue CHART_TYPE = new XmlNodeDefaultValue(MetaConstants.CHART_CHART_TYPE, ChartType.STR_Line, null);
	//V_ALIGN

	public static final XmlNodeDefaultValue IsTransfer = new XmlNodeDefaultValue("IsTransfer", "",null);
	public static final XmlNodeDefaultValue ShowTotalRowCount = new XmlNodeDefaultValue("ShowTotalRowCount", "false",null);

	public static final XmlNodeDefaultValue V_ALIGN;
	public static final XmlNodeDefaultValue H_Align;
	public static final XmlNodeDefaultValue ONLY_DATE;
	public static final XmlNodeDefaultValue Height;
	public static final XmlNodeDefaultValue Cache;
	public static final XmlNodeDefaultValue IS_GROUP_HEAD;
	public static final XmlNodeDefaultValue SOURCE_TYPE;
	public static final XmlNodeDefaultValue WIDTH;
	public static final XmlNodeDefaultValue TYPE;
	public static final XmlNodeDefaultValue ROW_TYPE;

	static {
		HashMap<String, String> hashMap = new HashMap<>();
		hashMap.put("Format","Center");
		hashMap.put("GridCellFormat","Center");
		hashMap.put("Body","Center");
		V_ALIGN = new XmlNodeDefaultValue("VAlign", "", hashMap);
		hashMap.clear();
		hashMap.put("Format","");
		hashMap.put("GridCellFormat","Left");
		hashMap.put("Body","Left");
		H_Align = new XmlNodeDefaultValue("HAlign", "", hashMap);
		hashMap.clear();
		hashMap.put("DatePicker","false");
		hashMap.put("UTCDatePicker","true");
		ONLY_DATE = new XmlNodeDefaultValue("OnlyDate", "", hashMap);
		hashMap.clear();
		hashMap.put("Body","");
		hashMap.put("RowDef","");
		hashMap.put("LayoutFlowIndex","");
		hashMap.put("LayoutRow","pref");
		hashMap.put("LinearItem","");
		Height = new XmlNodeDefaultValue("Height", "", hashMap);
		hashMap.clear();
		hashMap.put("Column","false");
		hashMap.put("CheckListBox","true");
		hashMap.put("ComboBox","true");
		Cache = new XmlNodeDefaultValue("Cache", "", hashMap);
		hashMap.clear();
		hashMap.put("RadioButton","false");
		IS_GROUP_HEAD = new XmlNodeDefaultValue("IsGroupHead", "", hashMap);
		hashMap.clear();
		hashMap.put("Table","DataObject");
		hashMap.put("TableSource","Table");
		hashMap.put("Parameter","Formula");
		hashMap.put("CheckListBox","Items");
		hashMap.put("ComboBox","Items");
		hashMap.put("SegmentedControl","Items");
		SOURCE_TYPE = new XmlNodeDefaultValue("SourceType", "", hashMap);
		hashMap.clear();
		hashMap.put("ListViewColumn","75px");
		hashMap.put("DictView","");
		hashMap.put("ColumnDef","auto");
		WIDTH = new XmlNodeDefaultValue("Width", "", hashMap);
		hashMap.clear();
		hashMap.put("MigrationCheckScript","Formula");
		hashMap.put("BatchPersist","DataSplit");
		hashMap.put("FilterValue","Formula");
		hashMap.put("CellCustomData","Expand");
		hashMap.put("Statement","Sql");
		TYPE = new XmlNodeDefaultValue("Type", "", hashMap);
		hashMap.clear();
		hashMap.put("GridRow","Detail");
		hashMap.put("TableRow","Fix");
		ROW_TYPE = new XmlNodeDefaultValue("RowType", "", hashMap);
		hashMap.clear();
		hashMap.put("ListViewColumn","Label");
		hashMap.put("GridColumn","Fix");
		COLUMN_TYPE = new XmlNodeDefaultValue("ColumnType", "", hashMap);
	}


	public XmlNodeDefaultValue(String name, String defaultNodeValue, HashMap<String, String> defaultNodeValues) {
		this.name = name;
		this.defaultNodeValue = defaultNodeValue;
		if (defaultNodeValues != null) {
			this.defaultNodeValues.putAll(defaultNodeValues);
		}
	}

	public static XmlNodeDefaultValue getDefaultValue(String name) {

		if (PERSIST.name.equalsIgnoreCase(name)) {
			return PERSIST;
		} else if (LOAD_RIGHTS_TYPE.name.equalsIgnoreCase(name)) {
			return LOAD_RIGHTS_TYPE;
		} else if (FORM_LOAD_HISTORY_INPUT.name.equalsIgnoreCase(name)) {
			return FORM_LOAD_HISTORY_INPUT;
		} else if (CHECK_AFTER_LOAD.name.equalsIgnoreCase(name)) {
			return CHECK_AFTER_LOAD;
		} else if (SECONDARY_TYPE.name.equalsIgnoreCase(name)) {
			return SECONDARY_TYPE;
		} else if (PAGE_ROW_COUNT.name.equalsIgnoreCase(name)) {
			return PAGE_ROW_COUNT;
		} else if (PAGE_INDICATOR_COUNT.name.equalsIgnoreCase(name)) {
			return PAGE_INDICATOR_COUNT;
		} else if (GROUP_HEAD.name.equalsIgnoreCase(name)) {
			return GROUP_HEAD;
		} else if (GROUP_TAIL.name.equalsIgnoreCase(name)) {
			return GROUP_TAIL;
		} else if (LIMIT_TO_SOURCE.name.equalsIgnoreCase(name)) {
			return LIMIT_TO_SOURCE;
		} else if (LOAD_HISTORY_INPUT.name.equalsIgnoreCase(name)) {
			return LOAD_HISTORY_INPUT;
		} else if (ONLY_FILTER.name.equalsIgnoreCase(name)) {
			return ONLY_FILTER;
		} else if (NEED_RESET.name.equalsIgnoreCase(name)) {
			return NEED_RESET;
		} else if (X.name.equalsIgnoreCase(name)) {
			return X;
		} else if (Y.name.equalsIgnoreCase(name)) {
			return Y;
		} else if (X_SPAN.name.equalsIgnoreCase(name)) {
			return X_SPAN;
		} else if (Y_SPAN.name.equalsIgnoreCase(name)) {
			return Y_SPAN;
		} else if (POSITION.name.equalsIgnoreCase(name)) {
			return POSITION;
		} else if (LEFT.name.equalsIgnoreCase(name)) {
			return LEFT;
		} else if (TOP.name.equalsIgnoreCase(name)) {
			return TOP;
		} else if (RIGHT.name.equalsIgnoreCase(name)) {
			return RIGHT;
		} else if (BOTTOM.name.equalsIgnoreCase(name)) {
			return BOTTOM;
		} else if (TAB_ORDER.name.equalsIgnoreCase(name)) {
			return TAB_ORDER;
		} else if (AS_QUERY.name.equalsIgnoreCase(name)) {
			return AS_QUERY;
		} else if (ONLY_SHOW.name.equalsIgnoreCase(name)) {
			return ONLY_SHOW;
		} else if (CLEARABLE.name.equalsIgnoreCase(name)) {
			return CLEARABLE;
		} else if (COPY_NEW.name.equalsIgnoreCase(name)) {
			return COPY_NEW;
		} else if (COLUMN_TYPE.name.equalsIgnoreCase(name)) {
			return COLUMN_TYPE;
		} else if (IS_SELECT.name.equalsIgnoreCase(name)) {
			return IS_SELECT;
		} else if (SINGLE_SELECT.name.equalsIgnoreCase(name)) {
			return SINGLE_SELECT;
		} else if (WRAP_TEXT.name.equalsIgnoreCase(name)) {
			return WRAP_TEXT;
		} else if (SORTABLE.name.equalsIgnoreCase(name)) {
			return SORTABLE;
		} else if (CELL_TYPE.name.equalsIgnoreCase(name)) {
			return CELL_TYPE;
		} else if (IS_MERGED.name.equalsIgnoreCase(name)) {
			return IS_MERGED;
		} else if (IS_MERGED_HEAD.name.equalsIgnoreCase(name)) {
			return IS_MERGED_HEAD;
		} else if (MERGED_ROW_SPAN.name.equalsIgnoreCase(name)) {
			return MERGED_ROW_SPAN;
		} else if (MERGED_COLUMN_SPAN.name.equalsIgnoreCase(name)) {
			return MERGED_COLUMN_SPAN;
		} else if (MERGE.name.equalsIgnoreCase(name)) {
			return MERGE;
		} else if (MERGE_GROUP.name.equalsIgnoreCase(name)) {
			return MERGE_GROUP;
		} else if (CELL_SORT_TYPE.name.equalsIgnoreCase(name)) {
			return CELL_SORT_TYPE;
		} else if (FORM_TYPE.name.equalsIgnoreCase(name)) {
			return FORM_TYPE;
		} else if (AUTHENTICATE.name.equalsIgnoreCase(name)) {
			return AUTHENTICATE;
		} else if (FORM_DISPLAY.name.equalsIgnoreCase(name)) {
			return FORM_DISPLAY;
		} else if (INIT_STATE.name.equalsIgnoreCase(name)) {
			return INIT_STATE;
		} else if (PLATFORM.name.equalsIgnoreCase(name)) {
			return PLATFORM;
		} else if (SCREEN_ORIENTATION.name.equalsIgnoreCase(name)) {
			return SCREEN_ORIENTATION;
		} else if (CONFIRM_CLOSE.name.equalsIgnoreCase(name)) {
			return CONFIRM_CLOSE;
		} else if (VERSION.name.equalsIgnoreCase(name)) {
			return VERSION;
		} else if (USE_VARIANT.name.equalsIgnoreCase(name)) {
			return USE_VARIANT;
		} else if (MERGE_TO_SOURCE.name.equalsIgnoreCase(name)) {
			return MERGE_TO_SOURCE;
		} else if (OVERFLOW_X.name.equalsIgnoreCase(name)) {
			return OVERFLOW_X;
		} else if (OVERFLOW_Y.name.equalsIgnoreCase(name)) {
			return OVERFLOW_Y;
		} else if (RESIZABLE.name.equalsIgnoreCase(name)) {
			return RESIZABLE;
		} else if (SHARE_TO_MID.name.equalsIgnoreCase(name)) {
			return SHARE_TO_MID;
		} else if (SIZE.name.equalsIgnoreCase(name)) {
			return SIZE;
		} else if (BOLD.name.equalsIgnoreCase(name)) {
			return BOLD;
		} else if (ITALIC.name.equalsIgnoreCase(name)) {
			return ITALIC;
		} else if (REQUIRED.name.equalsIgnoreCase(name)) {
			return REQUIRED;
		} else if (SEPARATOR.name.equalsIgnoreCase(name)) {
			return SEPARATOR;
		} else if (TYPE.name.equalsIgnoreCase(name)) {
			return TYPE;
		} else if (LEFT_BORDER.name.equalsIgnoreCase(name)) {
			return LEFT_BORDER;
		} else if (TOP_BORDER.name.equalsIgnoreCase(name)) {
			return TOP_BORDER;
		} else if (RIGHT_BORDER.name.equalsIgnoreCase(name)) {
			return RIGHT_BORDER;
		} else if (BOTTOM_BORDER.name.equalsIgnoreCase(name)) {
			return BOTTOM_BORDER;
		} else if (AUTO_CAPTION.name.equalsIgnoreCase(name)) {
			return AUTO_CAPTION;
		} else if (FREEZE.name.equalsIgnoreCase(name)) {
			return FREEZE;
		} else if (OP.name.equalsIgnoreCase(name)) {
			return OP;
		} else if (ROW_TYPE.name.equalsIgnoreCase(name)) {
			return ROW_TYPE;
		} else if (ROW_HEIGHT.name.equalsIgnoreCase(name)) {
			return ROW_HEIGHT;
		} else if (DEFAULT_LAYER.name.equalsIgnoreCase(name)) {
			return DEFAULT_LAYER;
		} else if (LINK_TYPE.name.equalsIgnoreCase(name)) {
			return LINK_TYPE;
		} else if (QUERY_FIELDS.name.equalsIgnoreCase(name)) {
			return QUERY_FIELDS;
		} else if (DISPLAY_FIELDS.name.equalsIgnoreCase(name)) {
			return DISPLAY_FIELDS;
		} else if (PRIMARY_TYPE.name.equalsIgnoreCase(name)) {
			return PRIMARY_TYPE;
		} else if (MIGRATION_UPDATE_STRATEGY.name.equalsIgnoreCase(name)) {
			return MIGRATION_UPDATE_STRATEGY;
		} else if (MAINTAIN_DICT.name.equalsIgnoreCase(name)) {
			return MAINTAIN_DICT;
		} else if (ZERO_PREFIX.name.equalsIgnoreCase(name)) {
			return ZERO_PREFIX;
		} else if (FORBIDDEN_LOAD.name.equalsIgnoreCase(name)) {
			return FORBIDDEN_LOAD;
		} else if (FORBIDDEN_SAVE.name.equalsIgnoreCase(name)) {
			return FORBIDDEN_SAVE;
		} else if (FORBIDDEN_DELETE.name.equalsIgnoreCase(name)) {
			return FORBIDDEN_DELETE;
		} else if (ROLL_DATA_STRATEGY.name.equalsIgnoreCase(name)) {
			return ROLL_DATA_STRATEGY;
		} else if (TABLE_MODE.name.equalsIgnoreCase(name)) {
			return TABLE_MODE;
		} else if (HIDDEN.name.equalsIgnoreCase(name)) {
			return HIDDEN;
		} else if (UNIQUE_PRIMARY.name.equalsIgnoreCase(name)) {
			return UNIQUE_PRIMARY;
		} else if (LAZY_LOAD.name.equalsIgnoreCase(name)) {
			return LAZY_LOAD;
		} else if (USE_CURSOR.name.equalsIgnoreCase(name)) {
			return USE_CURSOR;
		} else if (REFRESH_FILTER.name.equalsIgnoreCase(name)) {
			return REFRESH_FILTER;
		} else if (LOAD_IN_MID_USE.name.equalsIgnoreCase(name)) {
			return LOAD_IN_MID_USE;
		} else if (CASE.name.equalsIgnoreCase(name)) {
			return CASE;
		} else if (TRIM.name.equalsIgnoreCase(name)) {
			return TRIM;
		} else if (HOLD_FOCUS.name.equalsIgnoreCase(name)) {
			return HOLD_FOCUS;
		} else if (SELECT_ON_FOCUS.name.equalsIgnoreCase(name)) {
			return SELECT_ON_FOCUS;
		} else if (MAX_LENGTH.name.equalsIgnoreCase(name)) {
			return MAX_LENGTH;
		} else if (EMBED_TEXT_SIZE.name.equalsIgnoreCase(name)) {
			return EMBED_TEXT_SIZE;
		} else if (SINGLE_LINE.name.equalsIgnoreCase(name)) {
			return SINGLE_LINE;
		} else if (LINE_BREAK_MODE.name.equalsIgnoreCase(name)) {
			return LINE_BREAK_MODE;
		} else if (MAX_LINES.name.equalsIgnoreCase(name)) {
			return MAX_LINES;
		} else if (ICON_LOCATION.name.equalsIgnoreCase(name)) {
			return ICON_LOCATION;
		} else if (ONLY_ICON.name.equalsIgnoreCase(name)) {
			return ONLY_ICON;
		} else if (NEED_ACCESS_LOG.name.equalsIgnoreCase(name)) {
			return NEED_ACCESS_LOG;
		} else if (MAX_SIZE.name.equalsIgnoreCase(name)) {
			return MAX_SIZE;
		} else if (PREVIEW.name.equalsIgnoreCase(name)) {
			return PREVIEW;
		} else if (COLUMN_COUNT.name.equalsIgnoreCase(name)) {
			return COLUMN_COUNT;
		} else if (INTEGER_VALUE.name.equalsIgnoreCase(name)) {
			return INTEGER_VALUE;
		} else if (IS_DYNAMIC.name.equalsIgnoreCase(name)) {
			return IS_DYNAMIC;
		} else if (IS_COMP_DICT.name.equalsIgnoreCase(name)) {
			return IS_COMP_DICT;
		} else if (ALLOW_MULTI_SELECTION.name.equalsIgnoreCase(name)) {
			return ALLOW_MULTI_SELECTION;
		} else if (INDEPENDENT.name.equalsIgnoreCase(name)) {
			return INDEPENDENT;
		} else if (IGNORE_RIGHTS.name.equalsIgnoreCase(name)) {
			return IGNORE_RIGHTS;
		} else if (PROMPT_DATA.name.equalsIgnoreCase(name)) {
			return PROMPT_DATA;
		} else if (STATE_MASK.name.equalsIgnoreCase(name)) {
			return STATE_MASK;
		}  else if (StateMaskFormula.name.equalsIgnoreCase(name)) {
			return StateMaskFormula;
		} else if (ITEM_KEY_SOURCE_TYPE.name.equalsIgnoreCase(name)) {
			return ITEM_KEY_SOURCE_TYPE;
		} else if (LOAD_TYPE.name.equalsIgnoreCase(name)) {
			return LOAD_TYPE;
		} else if (STRETCH.name.equalsIgnoreCase(name)) {
			return STRETCH;
		} else if (IMAGE_CUT.name.equalsIgnoreCase(name)) {
			return IMAGE_CUT;
		} else if (IMAGE_SCALE_TYPE.name.equalsIgnoreCase(name)) {
			return IMAGE_SCALE_TYPE;
		} else if (RADIUS.name.equalsIgnoreCase(name)) {
			return RADIUS;
		} else if (VIEW_MODE.name.equalsIgnoreCase(name)) {
			return VIEW_MODE;
		} else if (VIEW_OPT.name.equalsIgnoreCase(name)) {
			return VIEW_OPT;
		} else if (SHOW_THUMBNAIL.name.equalsIgnoreCase(name)) {
			return SHOW_THUMBNAIL;
		} else if (UPLOAD_PROGRESS.name.equalsIgnoreCase(name)) {
			return UPLOAD_PROGRESS;
		} else if (USE_GROUPING_SEPARATOR.name.equalsIgnoreCase(name)) {
			return USE_GROUPING_SEPARATOR;
		} else if (ROUNDING_MODE.name.equalsIgnoreCase(name)) {
			return ROUNDING_MODE;
		} else if (SHOW_ZERO.name.equalsIgnoreCase(name)) {
			return SHOW_ZERO;
		} else if (STRIP_TRAILING_ZEROS.name.equalsIgnoreCase(name)) {
			return STRIP_TRAILING_ZEROS;
		} else if (ORIENTATION.name.equalsIgnoreCase(name)) {
			return ORIENTATION;
		} else if (TAB_POSITION.name.equalsIgnoreCase(name)) {
			return TAB_POSITION;
		} else if (TAB_MODE.name.equalsIgnoreCase(name)) {
			return TAB_MODE;
		} else if (BACK_IMAGE_POSITION.name.equalsIgnoreCase(name)) {
			return BACK_IMAGE_POSITION;
		} else if (BACK_IMAGE_REPEAT_X.name.equalsIgnoreCase(name)) {
			return BACK_IMAGE_REPEAT_X;
		} else if (BACK_IMAGE_REPEAT_Y.name.equalsIgnoreCase(name)) {
			return BACK_IMAGE_REPEAT_Y;
		} else if (FORCE_LAYOUT.name.equalsIgnoreCase(name)) {
			return FORCE_LAYOUT;
		} else if (INCLUDE_DATA_TABLE.name.equalsIgnoreCase(name)) {
			return INCLUDE_DATA_TABLE;
		} else if (SAFE_INPUT.name.equalsIgnoreCase(name)) {
			return SAFE_INPUT;
		} else if (SHOW_SWITCH_ICON.name.equalsIgnoreCase(name)) {
			return SHOW_SWITCH_ICON;
		} else if (NEW_EMPTY_ROW.name.equalsIgnoreCase(name)) {
			return NEW_EMPTY_ROW;
		} else if (DEFAULT_FIT_WIDTH.name.equalsIgnoreCase(name)) {
			return DEFAULT_FIT_WIDTH;
		} else if (SHOW_ROW_HEAD.name.equalsIgnoreCase(name)) {
			return SHOW_ROW_HEAD;
		} else if (HIDE_GROUP_4_EDITING.name.equalsIgnoreCase(name)) {
			return HIDE_GROUP_4_EDITING;
		} else if (PAGE_LOAD_TYPE.name.equalsIgnoreCase(name)) {
			return PAGE_LOAD_TYPE;
		} else if (CAN_INSERT.name.equalsIgnoreCase(name)) {
			return CAN_INSERT;
		} else if (CAN_DELETE.name.equalsIgnoreCase(name)) {
			return CAN_DELETE;
		} else if (CAN_SHIFT.name.equalsIgnoreCase(name)) {
			return CAN_SHIFT;
		} else if (FROZEN_ROW.name.equalsIgnoreCase(name)) {
			return FROZEN_ROW;
		} else if (FROZEN_COLUMN.name.equalsIgnoreCase(name)) {
			return FROZEN_COLUMN;
		} else if (BEST_WIDTH.name.equalsIgnoreCase(name)) {
			return BEST_WIDTH;
		} else if (SELECTION_MODE.name.equalsIgnoreCase(name)) {
			return SELECTION_MODE;
		} else if (SERIAL_SEQ.name.equalsIgnoreCase(name)) {
			return SERIAL_SEQ;
		} else if (SERIAL_ROW_NUM.name.equalsIgnoreCase(name)) {
			return SERIAL_ROW_NUM;
		} else if (END_EDIT_BY_NAV.name.equalsIgnoreCase(name)) {
			return END_EDIT_BY_NAV;
		} else if (IS_DEFAULT.name.equalsIgnoreCase(name)) {
			return IS_DEFAULT;
		} else if (MERGE_OPERATION.name.equalsIgnoreCase(name)) {
			return MERGE_OPERATION;
		} else if (MANAGED.name.equalsIgnoreCase(name)) {
			return MANAGED;
		} else if (SELF_DISABLE.name.equalsIgnoreCase(name)) {
			return SELF_DISABLE;
		} else if (LENGTH.name.equalsIgnoreCase(name)) {
			return LENGTH;
		} else if (NEED_RIGHTS.name.equalsIgnoreCase(name)) {
			return NEED_RIGHTS;
		} else if (IS_PRIMARY.name.equalsIgnoreCase(name)) {
			return IS_PRIMARY;
		} else if (EXPAND.name.equalsIgnoreCase(name)) {
			return EXPAND;
		} else if (ACCESS_CONTROL.name.equalsIgnoreCase(name)) {
			return ACCESS_CONTROL;
		} else if (SORT_TYPE.name.equalsIgnoreCase(name)) {
			return SORT_TYPE;
		} else if (IGNORE_SAVE.name.equalsIgnoreCase(name)) {
			return IGNORE_SAVE;
		} else if (SUPPORT_I_18_N.name.equalsIgnoreCase(name)) {
			return SUPPORT_I_18_N;
		} else if (Expand_SourceType.name.equalsIgnoreCase(name)) {
			return Expand_SourceType;
		} else if (Expand_Type.name.equalsIgnoreCase(name)) {
			return Expand_Type;
		} else if (V_ALIGN.name.equalsIgnoreCase(name)) {
			return V_ALIGN;
		} else if (ONLY_DATE.name.equalsIgnoreCase(name)) {
			return ONLY_DATE;
		} else if (ExpandType.name.equalsIgnoreCase(name)) {
			return ExpandType;
		} else if (H_Align.name.equalsIgnoreCase(name)) {
			return H_Align;
		} else if (Height.name.equalsIgnoreCase(name)) {
			return Height;
		} else if (Cache.name.equalsIgnoreCase(name)) {
			return Cache;
		} else if (IS_GROUP_HEAD.name.equalsIgnoreCase(name)) {
			return IS_GROUP_HEAD;
		} else if (SOURCE_TYPE.name.equalsIgnoreCase(name)) {
			return SOURCE_TYPE;
		} else if (WIDTH.name.equalsIgnoreCase(name)) {
			return WIDTH;
		} else if (TYPE.name.equalsIgnoreCase(name)) {
			return TYPE;
		} else if(Standalone.name.equals(name)) {
			return Standalone;
		} else if(CHART_TYPE.name.equals(name)) {
			return Standalone;
		}else if(IsTransfer.name.equals(name)) {
			return IsTransfer;
		}else if(ShowTotalRowCount.name.equals(name)) {
			return ShowTotalRowCount;
		}else{
			return null;
		}

	}

	@Override
	public String toString() {
		return name;
	}
}
