package com.bokesoft.yes.design.utils;

import com.bokesoft.erp.metaobjectchange.MetaObjectChange;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.context.DesignerContext;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.erp.dev.MetaTableCache;
import com.bokesoft.yes.erp.scope.MetaFormAllFormulScopeCache;
import com.bokesoft.yes.erpdatamap.ERPMetaMap;
import com.bokesoft.yes.erpdatamap.dom.ERPMetaMapConstants;
import com.bokesoft.yes.erpdatamap.dom.ERPMetaMapLoad;
import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.datamigration.MetaDataMigrationLoad;
import com.bokesoft.yes.mid.migration.period.MigrationStruct;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.def.DataObjectPrimaryType;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataelement.MetaDataElement;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationProfile;
import com.bokesoft.yigo.meta.dataobject.*;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.intf.IMetaSolution;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.meta.solution.MetaProjectCollection;
import com.bokesoft.yigo.meta.solution.MetaProjectProfile;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import com.bokesoft.yigo.meta.util.MetaAnnotationUtil;
import com.bokesoft.yigo.meta.util.MetaUtil;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * 重新加载配置，通过将配置清空掉
 */
public class ReloadForm {
    public static boolean delayedProcessScope = false;

    public static void setDelayedProcessScope(boolean delayedProcessScope) {
        ReloadForm.delayedProcessScope = delayedProcessScope;
    }

    /**
     * 重新加载表单
     *
     * @param metaFactory
     * @param formKey
     * @param resource    新的资源路径，相对于project目录的路径
     * @return 原先的资源路径
     * @throws Throwable
     */
    public static String reloadFormKey(IMetaFactory metaFactory, String formKey, String resource) throws Throwable {
        return reloadFormKey(metaFactory, formKey, resource, true);
    }

    public static String reloadFormKey(IMetaFactory metaFactory, String formKey, String resource, boolean reloadObjectFlag) throws Throwable {
        MetaFormProfile metaFormProfile = metaFactory.getMetaFormList().get(formKey);
        if(metaFormProfile == null) {
            metaFormProfile = metaFactory.getExtFormList().get(formKey);
        }
        // String key = metaFormProfile.getProject().getKey();
        // if (LoadFileTree.isJarProjectKey(key)) {
        //     throw new Throwable("Jar包中的表单无法修改 ("+ReloadForm.class.getSimpleName()+")");
        // }
        if (metaFormProfile != null) {
            String oldResource = metaFormProfile.getResource();
            if (resource != null) {
                if (metaFormProfile.getProject().getKey().equalsIgnoreCase("webconfig")) {
                    metaFormProfile.setResource(".." + File.separatorChar + ".." + File.separatorChar + ".." + File.separatorChar + ".." + File.separatorChar + resource);
                } else {
                    metaFormProfile.setResource(resource);
                }

            }
			MetaForm metaForm = metaFormProfile.getForm();
			if (reloadObjectFlag) {
				if (metaForm != null && metaForm.getDataSource() != null) {
                    MetaDataObject dataObject = metaForm.getDataSource().getDataObject();
                    if (dataObject != null && !DesignerContext.isChangedDataObject(dataObject)) {
                        if (delayedProcessScope) {//不清理MetaTableCache
                            MetaObjectChange.fireChangeDesignMetaDataObject(dataObject,"DBCache,TableCache,MetaCache");
                        } else {
                            MetaObjectChange.fireChangeDesignMetaDataObject(dataObject);
                        }
                    }
                }
			}

            if (metaForm != null) {
                if (delayedProcessScope) {//不清理scope
                    MetaObjectChange.fireChangeDesignMetaForm(metaForm,"DBCache","TableCache","MetaCache","TableCacheAll");
                } else {
                    MetaObjectChange.fireChangeDesignMetaForm(metaForm);
                }
            }
            metaFactory.reloadDesignMetaForm(formKey);
            synchronized (metaFormProfile) {
                metaForm = metaFactory.getMetaForm(formKey);
                MetaFormProfile finalMetaFormProfile = metaFormProfile;
                metaForm.doPostProcess(0, (param) -> {
                    if (param instanceof MetaDictProperties) {
                        ((MetaDictProperties) param).calItemKey(finalMetaFormProfile.getProject().getKey());
                    } else if (param instanceof MetaTable) {
                        ((MetaTable) param).initI18nColumn(MetaFactory.getGlobalInstance());
                    }
                    return true;
                });
                metaFormProfile.setRunType(AppRunType.Dev);
                // 合并至原单的马甲需要替换原单
                if (metaFormProfile.getMergeToSource() && !metaFormProfile.getExtend().isEmpty()) {
                    metaFactory.replaceMetaForm4VestDiff(metaFormProfile.getExtend(), metaForm);
                    MetaForm metaForm1 = metaFactory.getMetaForm(metaFormProfile.getExtend());
                    metaFactory.getMetaFormList().get(metaFormProfile.getExtend()).setRunType(AppRunType.Dev);
                    MetaFormAllFormulScopeCache.instance.changeMetaForm(metaForm);
                    MetaFormAllFormulScopeCache.instance.changeMetaForm(metaForm1);
                }
            }
            processTemplateDataElement(metaFactory, metaForm);
            return oldResource;
        }
        return null;
    }

    /**
     * 重新加载数据对象
     *
     * @param metaFactory
     * @param dataObjectKey
     * @param resource      新的资源路径，相对于project目录的路径
     * @return 原先的资源路径
     * @throws Throwable
     */
    public static String reloadDataObjectKey(IMetaFactory metaFactory, String dataObjectKey, String resource) throws Throwable {
        return reloadDataObjectKey(metaFactory, dataObjectKey, resource, null);
    }

    public static String reloadDataObjectKey(IMetaFactory metaFactory, String dataObjectKey, String resource, String projectKey) throws Throwable {
        MetaDataObjectProfile metaDataObjectProfile = metaFactory.getDataObjectList().get(dataObjectKey);
        String projectKey1 = metaDataObjectProfile.getProject().getKey();
        String resource1 = LoadFileTree.getResource(resource, projectKey1);
        if (Objects.isNull(metaDataObjectProfile)) {
            metaDataObjectProfile = new MetaDataObjectProfile();
            metaDataObjectProfile.setKey(dataObjectKey);
            XmlTreeWithPath parse1 = XmlTreeWithPath.parseFilePathNotLoadTmp(resource);
            String caption = parse1.xmlTree.getRoot().getAttributes().get("Caption");
            metaDataObjectProfile.setCaption(caption);
            if (StringUtils.isBlank(projectKey)) {
                projectKey = projectKey1;
            }
            MetaProject metaProject = metaFactory.getMetaProject(projectKey);
            metaDataObjectProfile.setProject(metaProject);
            metaDataObjectProfile.setResource(resource1);
            metaFactory.getDataObjectList().add(metaDataObjectProfile);
        }
        String oldResource = metaDataObjectProfile.getResource();
        if (resource != null) {
            metaDataObjectProfile.setResource(resource1);
        }
        MetaObjectChange.fireChangeDesignMetaDataObject(metaDataObjectProfile.getDataObject());
        try {
            metaFactory.reloadDataObject(dataObjectKey);
        } catch (Exception e) {
            LogSvr.getInstance().error("\n", e);
        }
        MetaDataObject dataObject = metaFactory.getDataObject(dataObjectKey);
        processTemplateDataElement(metaFactory, dataObject);
        return oldResource;
    }

    /**
     * 重新加载数据迁移
     *
     * @param metaFactory
     * @param daMigrationKey
     * @param resource       新的资源路径，相对于project目录的路径
     * @return 原先的资源路径
     * @throws Throwable
     */
    public static String reloadDataMigrationKey(IMetaFactory metaFactory, String daMigrationKey, String resource) throws Throwable {
        MetaDataMigrationProfile metaDataMigrationProfile = metaFactory.getDataMigrationList().get(daMigrationKey);
        if (metaDataMigrationProfile != null) {
            String oldResource = metaDataMigrationProfile.getResource();
            if (resource != null) {
                metaDataMigrationProfile.setResource(resource);
            }
            try {
                metaFactory.reloadDataMigration(metaDataMigrationProfile.getExtend());
                metaFactory.reloadDataMigration(daMigrationKey);
                MetaDataMigration dataMigration = metaFactory.getDataMigration(daMigrationKey);
                MigrationStruct.remove(dataMigration.getTgtDataObjectKey());
            } catch (Exception e) {
            }
            return oldResource;
        }
        return null;
    }

    /**
     * 重新加载数据映射
     *
     * @param projectKey
     * @throws Throwable
     */
    public static void reloadCustom(String projectKey, String key) throws Throwable {
        IMetaFactory iMetaFactory = MetaFactory.getGlobalInstance();
        MetaSolution solution = iMetaFactory.getSolution();
        MetaProjectCollection projectCollection = solution.getProjectCollection();
        MetaProject project = projectCollection.get(projectKey).getProject();
        //清空当前项目的erpmap
         reloadERPMap(key, iMetaFactory, project);
    }

    private static ERPMetaMap reloadERPMap(String key, IMetaFactory iMetaFactory, MetaProject project1) throws Exception {
        List<KeyPairMetaObject> customList = iMetaFactory.getCustomList();
        //删除当前erpmap
        MetaProject project = project1;
        Iterator<KeyPairMetaObject> iterator = customList.iterator();
        while (iterator.hasNext()) {
            KeyPairMetaObject next = iterator.next();
            if (next instanceof ERPMetaMap && key.equalsIgnoreCase(next.getKey())) {
                project = (MetaProject) ((ERPMetaMap) next).getProject();
                iterator.remove();
            }
        }
        String dataMapPathByKey = LoadFileTree.getDataMapPathByKey(key);
        File file  = new File(dataMapPathByKey);
        InputStream in = Files.newInputStream(file.toPath());
        Document doc = DomHelper.createDocument(in);
        Element rootEl = doc.getDocumentElement();
        String extend = DomHelper.readAttr(rootEl, ERPMetaMapConstants.MAP_Extend, "");
        boolean parentMap = StringUtils.isNotEmpty(extend);
        ERPMetaMap srcMetaERPMap = null;
        if (parentMap){
            srcMetaERPMap = reloadERPMap(extend, iMetaFactory, project);
        }
        ERPMetaMapLoad load = new ERPMetaMapLoad(AppRunType.App, parentMap);
        load.load(doc);
        ERPMetaMap dataMap = (ERPMetaMap) load.getRootMetaObject();
        dataMap.setProject(project);
        customList.add(dataMap);
        if (parentMap) {
            dataMap.setProject(srcMetaERPMap.getProject());
            ERPMetaMap keyPairMetaObject = iMetaFactory.getMetaCustomObject(ERPMetaMap.class, key);
            doMergeERPMap(iMetaFactory, keyPairMetaObject,srcMetaERPMap);
        }
        return dataMap;
    }

    public static void processTemplateDataElement(IMetaFactory metaFactory, MetaDataObject dataObject) throws Throwable {
        if (Objects.isNull(dataObject)) {
            return;
        }
        if (!Objects.equals(dataObject.getPrimaryType(), DataObjectPrimaryType.TEMPLATE)) {
            return;
        }
        MetaTableCollection tableCollection = dataObject.getTableCollection();
        for (MetaTable metaTable : tableCollection) {
            for (MetaColumn metaColumn : metaTable) {
                String dataElementKey = metaColumn.getDataElementKey();
                if (StringUtils.isBlank(dataElementKey) || (Objects.nonNull(metaColumn.getDataType()) && metaColumn.getDataType() >= 0)) {
                    continue;
                }

                MetaDataElement dataElement = metaFactory.getDataElementDef().getDataElement(dataElementKey);
                if (dataElement == null) {
                    throw new MetaException(MetaException.NO_DATAELEMENT_DEFINED,
                            SimpleStringFormat.format(StringTable.getString(null, "", StringTable.NoDataElementDefined), dataElementKey));
                }
                MetaAnnotationUtil.mergeProperty(metaColumn, dataElement);
                metaColumn.setDataElement(dataElement);
            }
        }
    }

    public static void processTemplateDataElement(IMetaFactory metaFactory, MetaForm metaForm) throws Throwable {
        if (Objects.isNull(metaForm)) {
            return;
        }

        if (!Objects.equals(metaForm.getFormType(), FormType.Template)) {
            return;
        }

        MetaDataSource dataSource = metaForm.getDataSource();
        if (Objects.isNull(dataSource)) {
            return;
        }
        MetaDataObject dataObject = dataSource.getDataObject();
        processTemplateDataElement(metaFactory, dataObject);
    }

    private static void doMergeERPMap(IMetaFactory iMetaFactory, ERPMetaMap metaCustomObject, ERPMetaMap srcMetaERPMap) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> aClass = Class.forName("com.bokesoft.yes.erpdatamap.vest.ERPMapVestDiffProcessor");
        Method method = aClass.getMethod("doMergeERPMap", ERPMetaMap.class, ERPMetaMap.class, IMetaFactory.class);
        method.invoke(aClass, metaCustomObject, srcMetaERPMap, iMetaFactory);
    }

}
