package com.bokesoft.yes.design.utils;

import com.bokesoft.yes.meta.persist.dom.MetaActionMap;
import com.bokesoft.yes.meta.persist.dom.dataobject.MetaDataObjectActionMap;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaAction;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;

import java.util.Objects;

public class MetaDataObjectActionMapEx extends MetaActionMap {
	private static MetaDataObjectActionMapEx instance = null;

	private final MetaDataObjectActionMap dataObjectActionMap;

	private MetaDataObjectActionMapEx() {
		dataObjectActionMap = MetaDataObjectActionMap.getInstance();
	}

	/**
	 * 取得表单事件映射实例
	 * 
	 * @return 表单事件映射实例
	 */
	public static MetaDataObjectActionMapEx getInstance() {
		if (Objects.isNull(instance)) {
			instance = new MetaDataObjectActionMapEx();
		}
		return instance;
	}

	@Override
	protected Object[][] getActionLookupTable() {
		return new Object[][] { { MetaColumn.TAG_NAME, new MetaColumnActionEx() } };
	}

	@Override
	protected Object[][] getHostActionLookupTable() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public IMetaAction<AbstractMetaObject> getAction(String parentTag, String tag) {
		return dataObjectActionMap.getAction(parentTag, tag);
	}

	@Override
	public IMetaAction<AbstractMetaObject> getAction(String tag) {
		if (MetaColumn.TAG_NAME.equals(tag)) {
			return super.getAction(tag);
		}
		return dataObjectActionMap.getAction(tag);
	}
}
