package com.bokesoft.yes.design.search.text;

/**
 * 文件匹配
 */
public class FileMatch extends Match {
	/** 匹配到的行 */
	private LineElement fLineElement;

	public FileMatch(FileMatchResource element) {
		super(element, -1, -1);
		fLineElement = null;
	}

	public FileMatch(FileMatchResource element, int offset, int length, LineElement lineEntry) {
		super(element, offset, length);
		fLineElement = lineEntry;
	}

	public LineElement getLineElement() {
		return fLineElement;
	}

	public FileMatchResource getFile() {
		return (FileMatchResource) getElement();
	}

	public boolean isFileSearch() {
		return fLineElement == null;
	}
}
