package com.bokesoft.yes.design.resolver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

import org.json.JSONObject;
import org.xml.sax.Attributes;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomSAXReader;
import com.bokesoft.yigo.common.dom.IDomSAXReaderListener;
import com.bokesoft.yigo.meta.base.IMetaResolver;

public class DesignProjectMetaResolver implements IMetaResolver {
	private String projectPath = null;
	public DesignProjectMetaResolver(String projectPath) {
		this.projectPath = projectPath;
	}
	
	@Override
	public InputStream read(String resource, int type) throws Exception {
		if (resource.indexOf(File.separatorChar) == -1) {
			resource = projectPath + File.separatorChar + resource;
		}
		File f = new File(resource);
		if ( !f.exists() || f.isDirectory() ) {
			return null;
		}
		return new FileInputStream(f);
	}

	@Override
	public boolean write(String resource, byte[] data) throws Exception {
		if (resource.indexOf(File.separatorChar) == -1) {
			resource = projectPath + File.separatorChar + resource;
		}
		File f = new File(resource);
		if(!f.exists()){
			f.createNewFile();
		}
		FileOutputStream out = new FileOutputStream(f);
		out.write(data);
		out.close();
		return true;
	}

	@Override
	public int listResource(String resource, String flag, List<String> resources, List<String> names, List<Boolean> flags) throws Exception {
		File f = new File(projectPath + File.separatorChar + resource);
		File[] files = f.listFiles();
		if ( files != null ) {
			int length = files.length;
			File childFile = null;
			List<String> tempResources = new ArrayList<String>();
			List<String> tempNames = new ArrayList<String>();
			List<Boolean> tempFlags = new ArrayList<Boolean>();
			
			for ( int i = 0; i<length; ++i ) {
				childFile = files[i];
				if ( childFile.isDirectory() ) {
					String fileName = childFile.getName().toLowerCase();
					if ( !fileName.equalsIgnoreCase(".svn") ) {
						resources.add(childFile.getAbsolutePath());
						names.add(childFile.getName());
						flags.add(true);
					}
				} else {
					String fileName = childFile.getName().toLowerCase();
					if ( fileName.endsWith(flag) ) {
						tempResources.add(childFile.getAbsolutePath());
						tempNames.add(childFile.getName());
						tempFlags.add(false);
					}
				}
			}
			resources.addAll(tempResources);
			names.addAll(tempNames);
			flags.addAll(tempFlags);
		}
		
		return resources.size();
	}

	@Override
	public boolean isListAbsolutePath() {
		return true;
	}

	@Override
	public String getPath(String resource) {
		return projectPath + File.separatorChar + resource;
	}

	@Override
	public URI getURI(String resource, int type) throws Exception {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public char getSeparator() {
		return File.separatorChar;
	}
	
	@Override
	public JSONObject readProfile(String resource, int type) throws Exception {
		JSONObject profileInfo = new JSONObject();
		DomSAXReader reader = new DomSAXReader(null, new IDomSAXReaderListener() {

			@Override
			public void startElement(Object parent, String resource, String uri, String localName, String qName,
					Attributes attributes) {
				
				profileInfo.put(MetaConstants.COMMON_TAG_NAME, qName);
				for (int i = 0; i < attributes.getLength(); i++) {
					profileInfo.put(attributes.getQName(i), attributes.getValue(i));
				}
			}

			@Override
			public void endElement(String uri, String localName, String qName) {
			}

			@Override
			public boolean stopParse(boolean startElement, String tagName) {
				return true;
			}

		});
		InputStream in = read(resource, 0);
		try {
			reader.start(in, resource);
		} catch (Exception e) {
//			throw new Exception(String.format("xml文件:%s解析失败", resource), e);
			
//			Platform.runLater(new Runnable() {
//				
//				@Override
//				public void run() {
//					DialogUtil.showPromptDialog(String.format("xml文件:%s解析失败", resource));
//					
//				}
//			});
		} finally {
			if (in != null) {
				in.close();
			}
		}
		return profileInfo;
	
	}
}
