package com.bokesoft.yes.design.io;

import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.erp.webdesigner.language.common.Constants;
import com.bokesoft.erp.webdesigner.language.common.JsonMapper;
import com.bokesoft.erp.webdesigner.language.infrastructure.debugger.*;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.IndexFacade;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.KeyIndexEnum;
import com.bokesoft.erp.webdesigner.service.datamap.DataMapUtil;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.design.MetaObjectType;
import com.bokesoft.yes.design.Property;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.NewFormCmd;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.constant.ProPertyConstant;
import com.bokesoft.yes.design.io.loader.IODataObjectLoader;
import com.bokesoft.yes.design.mergesingle.util.FormToolOperUtil;
import com.bokesoft.yes.design.process.MetaItemFilterProcess;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.design.utils.WebDesignerDataTableUtil;
import com.bokesoft.yes.design.utils.XmlNodeDefaultValue;
import com.bokesoft.yes.design.vo.Entry;
import com.bokesoft.yes.design.vo.EntryItem;
import com.bokesoft.yes.design.vo.RecycleForm;
import com.bokesoft.yes.design.xml.XmlParser;
import com.bokesoft.yes.design.xml.node.*;
import com.bokesoft.yes.erp.config.MetaFormNODBProcess;
import com.bokesoft.yes.erp.dev.MetaTableCache;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.helper.MetaFormHelper;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaCommonDefCollectionLoad;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaCommonDefLoad;
import com.bokesoft.yes.meta.persist.dom.enhance.MetaEnhanceLoad;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.iosetting.MetaIOSettingLoad;
import com.bokesoft.yes.meta.persist.dom.rights.MetaRightsDefinitionLoad;
import com.bokesoft.yes.meta.persist.dom.setting.MetaSettingLoad;
import com.bokesoft.yes.meta.persist.dom.solution.MetaSolutionLoad;
import com.bokesoft.yes.struct.abstractdatatable.RowState;
import com.bokesoft.yigo.common.def.*;
import com.bokesoft.yigo.common.util.FileUtil;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.KeyPairCompositeObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.*;
import com.bokesoft.yigo.meta.commondef.*;
import com.bokesoft.yigo.meta.commondef.extend.MetaCommonDefCollection;
import com.bokesoft.yigo.meta.dataelement.MetaDataElement;
import com.bokesoft.yigo.meta.datamap.MetaMap;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.dataobject.*;
import com.bokesoft.yigo.meta.domain.MetaDomain;
import com.bokesoft.yigo.meta.domain.MetaItemKeyCollection;
import com.bokesoft.yigo.meta.enhance.*;
import com.bokesoft.yigo.meta.exceltemplate.ExcelFormatDataType;
import com.bokesoft.yigo.meta.factory.DefaultMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.*;
import com.bokesoft.yigo.meta.form.component.*;
import com.bokesoft.yigo.meta.form.component.bar.MetaToolBar;
import com.bokesoft.yigo.meta.form.component.chart.MetaChart;
import com.bokesoft.yigo.meta.form.component.chart.MetaChartDataSource;
import com.bokesoft.yigo.meta.form.component.container.MetaContainer;
import com.bokesoft.yigo.meta.form.component.container.MetaSubDetail;
import com.bokesoft.yigo.meta.form.component.control.*;
import com.bokesoft.yigo.meta.form.component.control.dictview.MetaDictView;
import com.bokesoft.yigo.meta.form.component.control.dictview.MetaDictViewColumnCollection;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewItem;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewItemCollection;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewRow;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumn;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumnCollection;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaRowAction;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaRowActionCollection;
import com.bokesoft.yigo.meta.form.component.control.properties.*;
import com.bokesoft.yigo.meta.form.component.control.refresh.MetaRefreshControl;
import com.bokesoft.yigo.meta.form.component.control.refresh.MetaRefreshFooter;
import com.bokesoft.yigo.meta.form.component.control.refresh.MetaRefreshHeader;
import com.bokesoft.yigo.meta.form.component.control.refresh.MetaRefreshState;
import com.bokesoft.yigo.meta.form.component.control.refresh.MetaRefreshStateCollection;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableRow;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableRowCollection;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableView;
import com.bokesoft.yigo.meta.form.component.grid.*;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaSplitPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaSplitSizeCollapaseTypeEnum;
import com.bokesoft.yigo.meta.form.component.panel.MetaSplitSizeCollection;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaColumnDefCollection;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGridLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaRowDefCollection;
import com.bokesoft.yigo.meta.form.component.view.MetaComponentView;
import com.bokesoft.yigo.meta.form.component.view.MetaView;
import com.bokesoft.yigo.meta.form.component.view.MetaViewCollection;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaComponentLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaGridLayout;
import com.bokesoft.yigo.meta.iosetting.MetaIOObject;
import com.bokesoft.yigo.meta.iosetting.MetaIOSetting;
import com.bokesoft.yigo.meta.iosetting.MetaPersist;
import com.bokesoft.yigo.meta.parameter.MetaParameterID;
import com.bokesoft.yigo.meta.report.*;
import com.bokesoft.yigo.meta.rights.*;
import com.bokesoft.yigo.meta.schema.MetaIndex;
import com.bokesoft.yigo.meta.schema.MetaIndexCollection;
import com.bokesoft.yigo.meta.setting.*;
import com.bokesoft.yigo.meta.solution.MetaLang;
import com.bokesoft.yigo.meta.solution.MetaLangConfig;
import com.bokesoft.yigo.meta.solution.MetaPreLoadItem;
import com.bokesoft.yigo.meta.solution.MetaPreLoadItemCollection;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.meta.solution.MetaProjectCollection;
import com.bokesoft.yigo.meta.solution.MetaProjectProfile;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import com.bokesoft.yigo.meta.solution.MetaStartItem;
import com.bokesoft.yigo.meta.solution.MetaStartItemCollection;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.document.io.DocumentIO;
import com.bokesoft.yigo.parser.IEvalContext;
import com.bokesoft.yigo.struct.condition.ConditionParas;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.FilterMap;
import com.bokesoft.yigo.struct.document.SaveFilterMap;
import com.bokesoft.yigo.tools.document.DataTableUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.dom4j.*;
import org.dom4j.io.SAXReader;
import org.json.JSONObject;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.*;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class IOMetaObject implements DocumentIO {

	public static String currentFormKey = "";
	private static LinkedHashMap<String, Object> returnEntryMap;
	private static MetaTable metaTable;
	private static MetaTable metaTableTwo;
	public static String gridTableKey;
	public  DefaultContext context1;
	public static final Map<String, String> gridMap = new HashMap<>();
	public static final Map<String, String> listViewMap = new HashMap<>(); // 存放ListView下字段的key和parentKey
	public static final Map<String, String> panelMap = new HashMap<>(); // 放gridLayoutPanel下字段的key和parentKey
	@Override
	public Document load(DefaultContext context, Document document, MetaDataObject designMetaDataObject, FilterMap filterMap, ConditionParas conditionParas) throws Throwable {
		// 判断是报表的加载
		context1 = context;
		String reportKey = (String) context.getPara("ReportKey");
		if (StringUtils.isNotBlank(reportKey)) {
			loadReport(context, document, designMetaDataObject);
			setSequence(document);
			return document;
		}


		String excelDoc = (String) context.getPara("ExcelKey");
		if (StringUtils.isNotBlank(excelDoc)) {
			loadExcel(document, context, designMetaDataObject);
			setSequence(document);
			return document;
		}

		if("D_NewDataElement".equalsIgnoreCase(context.getFormKey())){
			loadNewDataElement(context, document, designMetaDataObject);
			setSequence(document);
			return document;
		}

		MetaTableCollection tableCollection = designMetaDataObject.getTableCollection();
		String ownerFormKey = (String) context.getPara("OwnerFormKey");
		//判断表单是数据对象表单还是实体表单
		String Type = (String) context.getPara(ConstantUtil.TYPE);
		//获取数据独对像的表单数据
		String path = FilePathHelper.toBackFilePath((String) context.getPara("path"));
		String paraValue = (String) context.getPara("ParaValue");
		String containerKey = (String) context.getPara("ContainerKey");

		String isFirst = (String) context.getPara("IsFirst");
		String tableName = (String) context.getPara("TableName");
		if (StringUtils.isNotBlank(tableName) && StringUtils.isNotBlank(isFirst)) {
			loadDataMigration(context, document, designMetaDataObject);
			setSequence(document);
			return document;
		}

		// 数据映射
		// 数据映射的数据类型 source 原表数据 target 目标表数据 feedback 反填数据
		String dataMapDataType = (String) context.getPara("DataMapDataType");
		if (StringUtils.isNotBlank(dataMapDataType)) {
			loadByDataMap(context, document, designMetaDataObject);
			setSequence(document);
			return document;
		}

		MetaForm containerForm = null;
		if (containerKey != null && !containerKey.isEmpty()) {
			containerForm = MetaFactory.getGlobalInstance().getMetaForm(containerKey);
		}
		MetaForm ownerMetaForm = null;
		DataTable dataChase = null;
		MetaCommonDef metaCommonDef = null;
		String solutionPath = StringUtils.substringBeforeLast(path, File.separator);
		MetaSetting metaSetting = null;
		MetaRightsDefinition metaRightsDefinition = null;
		MetaEnhance solutionEnhance = null;
		MetaIOSetting IOSetting = null;
		MetaSolution metaSolution = null;
		//满足条件就是数据对象，就不能使用getMetaForm去取数据信息

		if ("CommonDef".equals(Type)) {
			String parentPath = StringUtils.substringBeforeLast(path, File.separator);
			TreeNode parentNode = LoadFileTree.tree.getNode(parentPath);
			if (StringUtils.equals(parentNode.type, TreeNode.TYPE_SOLUTION)) {
				metaCommonDef = MetaFactory.getGlobalInstance().getCommonDefBySolution(parentNode.name);
			} else {
				metaCommonDef = MetaFactory.getGlobalInstance().getCommonDef(parentNode.name);
			}
		}else if ("Setting".equals(Type)){
			// 读取setting.xml
			if (solutionPath.endsWith("erp-solution-core")){
				metaSetting = MetaFactory.getGlobalInstance().getSetting();
			}else {
				IMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(solutionPath);
				IMetaResolver iMetaResolver = metaResolverFactory.newMetaResolver("");
				MetaSettingLoad settingLoad = new MetaSettingLoad(AppRunType.App);
				settingLoad.load(iMetaResolver, DomMetaConstants.SETTING_FILE);
				metaSetting = (MetaSetting) settingLoad.getRootMetaObject();
			}
		}else if ("NoRights".equals(Type)){
//			if (solutionPath.endsWith("erp-solution-core")){
//				metaRightsDefinition = context.getVE().getMetaFactory().getRightsDefinition();
//			}else {
			IMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(solutionPath);
			IMetaResolver solutionResourceResolver = metaResolverFactory.newMetaResolver("");
			MetaRightsDefinitionLoad rightsDefinitionLoad = new MetaRightsDefinitionLoad(AppRunType.App);
			rightsDefinitionLoad.load(solutionResourceResolver, DomMetaConstants.RIGHTS_FILE);
			metaRightsDefinition = (MetaRightsDefinition) rightsDefinitionLoad.getRootMetaObject();
//			}
		}else if ("Enhance".equals(Type)){
			IMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(solutionPath);
			IMetaResolver solutionResourceResolver = metaResolverFactory.newMetaResolver("");
			MetaEnhanceLoad enhanceLoad = new MetaEnhanceLoad(AppRunType.App);
			enhanceLoad.load(solutionResourceResolver, DomMetaConstants.ENHANCE_FILE);
			solutionEnhance = (MetaEnhance) enhanceLoad.getRootMetaObject();
			if (solutionEnhance != null) {
				solutionEnhance.doPostProcess(0, null);
			}
		}else if ("IOSetting".equals(Type)){
			IMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(solutionPath);
			IMetaResolver solutionResourceResolver = metaResolverFactory.newMetaResolver("");
			MetaIOSettingLoad IOSettingLoad = new MetaIOSettingLoad(AppRunType.App);
			IOSettingLoad.load(solutionResourceResolver, DomMetaConstants.IOSETTING_FILE);
			IOSetting = (MetaIOSetting) IOSettingLoad.getRootMetaObject();
		}else if ("DomainDef".equals(Type)||"DataElementDef".equals(Type)||"ParaTable".equals(Type)||"SearchHelpDef".equals(Type)||"Parameter".equals(Type)){

		}else if("Solution".equals(Type)){
			IMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(solutionPath);
			IMetaResolver solutionResourceResolver = metaResolverFactory.newMetaResolver("");
			MetaSolutionLoad solutionLoad = new MetaSolutionLoad(AppRunType.App);
			solutionLoad.load(solutionResourceResolver, DomMetaConstants.SOLUTION_FILE);
			metaSolution = (MetaSolution) solutionLoad.getRootMetaObject();
			if (metaSolution == null) {
				throw new MetaException(MetaException.INVALID_SOLUTION_PATH,
						SimpleStringFormat.format(StringTable.getString(null, "", StringTable.InvalidSolutionPath),
								metaResolverFactory.getSolutionPath()));
			}
		} else if ("CommonDefVestCollection".equals(Type)) {
			String parentPath = StringUtils.substringBeforeLast(path, File.separator);
			TreeNode parentNode = LoadFileTree.tree.getNode(parentPath);
			if (StringUtils.equals(parentNode.type, TreeNode.TYPE_SOLUTION)) {
				IMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(parentPath);
				IMetaResolver iMetaResolver = metaResolverFactory.newMetaResolver("");
				MetaCommonDefCollectionLoad metaCommonDefCollectionLoad = new MetaCommonDefCollectionLoad(AppRunType.App);
				metaCommonDefCollectionLoad.load(iMetaResolver, "CommonDef_Vest.xml");
				MetaCommonDefCollection metaCommonDefCollection = (MetaCommonDefCollection) metaCommonDefCollectionLoad.getRootMetaObject();
				DataTable edOperationToolbarDetail = WebDesignerDataTableUtil.generateDataTable(designMetaDataObject.getTable("ED_OperationToolbarDetail"));
				document.add(edOperationToolbarDetail.getKey(),edOperationToolbarDetail);
				DataTable ED_MacroFormula = WebDesignerDataTableUtil.generateDataTable(designMetaDataObject.getTable("ED_MacroFormula"));
				document.add(ED_MacroFormula.getKey(),ED_MacroFormula);
				MetaTable edCommonDefVestCollection = designMetaDataObject.getTable("ED_CommonDefVestCollection");
				DataTable dataTable = WebDesignerDataTableUtil.generateDataTable(edCommonDefVestCollection);
				document.add(dataTable.getKey(),dataTable);

				DataTable ED_StatusList = WebDesignerDataTableUtil.generateDataTable(designMetaDataObject.getTable("ED_StatusList"));
				document.add(ED_StatusList.getKey(),ED_StatusList);

				DataTable ED_Operations = WebDesignerDataTableUtil.generateDataTable(designMetaDataObject.getTable("ED_Operations"));
				document.add(ED_Operations.getKey(), ED_Operations);


				for (MetaCommonDef commonDef : metaCommonDefCollection) {

					int append = dataTable.append();
					dataTable.setObject(append,"Scope",commonDef.getScope());
					Long POID = context.applyNewOID();
					dataTable.setObject(append,"OID", POID);


					MetaOperationCollection operationCollection = commonDef.getOperationCollection();
					if (operationCollection.size() > 0) {
						HashMap<String, KeyPairCompositeObject> operationCollectionMap = new HashMap<>();
						FormToolOperUtil.getOperation(commonDef.getOperationCollection(), operationCollectionMap);
						loadTableOperationCollection(context, ED_Operations, null,edOperationToolbarDetail  ,operationCollection, operationCollectionMap,POID);

					}

					MetaStatusCollection statusCollection = commonDef.getStatusCollection();
					if (statusCollection!=null&&!statusCollection.isEmpty()) {

						loadStatusList(context,ED_StatusList,commonDef,POID);
					}
					MetaMacroCollection macroCollection = commonDef.getMacroCollection();
					if (macroCollection!=null&&!macroCollection.isEmpty()) {
						loadMacroList(null, null, ED_MacroFormula,commonDef,POID);
					}
				}
				return document;

			}
		}else {
			if (!ConstantUtil.DATA_OBJECT.equals(Type)) {
				ownerMetaForm = StringUtils.isEmpty(ownerFormKey) ? null
						: MetaFactory.getGlobalInstance().getMetaForm(ownerFormKey);
			}
		}

		// 测试新处理方式
		if ("D_ComboBoxQueryDef".equals(designMetaDataObject.getKey())) {
			// 这里通过动态的方式获取到加载的对象 根据数据对象key来进行转发 加载器注册在IODataObjectLoader中
			IODataObjectLoader ioDataObjectLoader = new IODataObjectLoader();
			Document load = ioDataObjectLoader.load(document, designMetaDataObject, context);
			setSequence(load);
			return load;
		}

		// D_Setting.xml处理
		if ("D_Setting".equals(designMetaDataObject.getKey())){
			Document document1 = loadSetting(context, document, tableCollection, metaSetting);
			setSequence(document1);
			return document1;
		}

		// D_RightsDefinition.xml处理
		if ("D_NoRights".equals(designMetaDataObject.getKey())){
			Document document1 = loadNoRights(document, tableCollection, metaRightsDefinition);
			setSequence(document1);
			return document1;
		}

		if ("D_Enhance".equals(designMetaDataObject.getKey())){
			Document document1 = loadEnhance(document, tableCollection, solutionEnhance);
			setSequence(document1);
			return document1;
		}

		if ("D_IOSetting".equals(designMetaDataObject.getKey())){
			Document document1 = loadIOSetting(document, tableCollection, IOSetting);
			setSequence(document1);
			return document1;
		}

		if ("D_Solution".equals(designMetaDataObject.getKey())){
			Document document1 = loadSolutionProfile(document, tableCollection, metaSolution);
			setSequence(document1);
			return document1;
		}

		if ("D_IndicatorSetting".equals(designMetaDataObject.getKey())){
			String fieldKey = (String) context.getPara(ConstantUtil.COMP_KEY);
			ownerMetaForm = isThisForm(ownerMetaForm, containerForm, fieldKey);
			Document document1 = loadIndicatorSetting(ownerMetaForm, document, designMetaDataObject, fieldKey);
			setSequence(document1);
			return document1;
		}

		if ("D_ComboBoxSourceSetting".equals(designMetaDataObject.getKey())){
			String fieldKey = (String) context.getPara(ConstantUtil.COMP_KEY);
			ownerMetaForm = isThisForm(ownerMetaForm, containerForm, fieldKey);
			loadComboBoxSourceSetting(ownerMetaForm, document, designMetaDataObject, fieldKey);
		}

		if ("D_DebugTab".equals(designMetaDataObject.getKey())){
			tableCollection = designMetaDataObject.getTableCollection();
			for (MetaTable metaTable : tableCollection) {
				DataTable dataTable = WebDesignerDataTableUtil.generateDataTable(metaTable);
				document.add(metaTable.getKey(), dataTable);

				this.paddingToolbar(dataTable);
				this.paddingBreakpoint(dataTable);
				paddingVariant(dataTable, null);
				paddingSyntaxTree(dataTable, null);
				this.paddingStack(dataTable);
			}
			setSequence(document);
			return document;
		}

		for (MetaTable metaTable : tableCollection) {
			String tableKey = metaTable.getKey();
			DataTable dataTable = document.get(tableKey);
			if(dataTable != null) continue;
			dataTable = WebDesignerDataTableUtil.generateDataTable(metaTable);
			if (ConstantUtil.TBL_FORM_HEAD.equalsIgnoreCase(tableKey)) {//MetaForm
				currentFormKey = ownerMetaForm.getKey();
				loadFormProperty(dataTable, ownerMetaForm);
			} else if (ConstantUtil.TBL_FORM_BODY.equalsIgnoreCase(tableKey)) {//MetaBody
				loadMetaBody(dataTable, ownerMetaForm);
			} else if (ConstantUtil.TBL_WEB_HEAD.equalsIgnoreCase(tableKey)) {//工作流
				String filePath = FilePathHelper.toBackFilePath((String) context.getPara("WEBBPMPATH"));
				loadXml(dataTable, FilePathHelper.toBackFilePath(filePath));
			} else if (ConstantUtil.TBL_MOBILE_FORM_D_HEAD.equalsIgnoreCase(tableKey)) {//移动APP设计界面
				String filePath = FilePathHelper.toBackFilePath((String) context.getPara("MobileFormPath"));
				loadXml(dataTable, FilePathHelper.toBackFilePath(filePath));
			}  else if (ConstantUtil.TBL_FORM_DESIGN_HEAD.equalsIgnoreCase(tableKey)) {//表单设计界面
				String filePath = FilePathHelper.toBackFilePath((String) context.getPara("FormPath"));
				loadXml(dataTable, FilePathHelper.toBackFilePath(filePath));
			} else if (ConstantUtil.TBL_COMPONENT.equalsIgnoreCase(tableKey)) {//Component
				String panelKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, panelKey);
				loadComponent(ownerMetaForm, panelKey, dataTable);
			} else if (ConstantUtil.TBL_PROPERTIES.equalsIgnoreCase(tableKey)) {//Properties
				String panelKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, panelKey);
				loadProperties(ownerMetaForm, panelKey, dataTable);
			} else if (ConstantUtil.TBL_PANEL.equalsIgnoreCase(tableKey)) {//Panel
				String panelKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, panelKey);
				loadPanel(ownerMetaForm, dataTable, panelKey);
			} else if (ConstantUtil.TBL_GRID_HEAD_COLUMN.equalsIgnoreCase(tableKey)) {//MetaGridColumn
				String panelKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				panelKey = panelKey.substring(7);
				String parentKey = (String) context.getPara("parentKey");
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, panelKey);
				loadGridColumn(ownerMetaForm, dataTable, panelKey, parentKey);
			} else if (ConstantUtil.TBL_THIS.equalsIgnoreCase(tableKey)) {//This
				String panelKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, panelKey);
				String compType = (String) context.getPara("compType");
				String parentFormKey = (String) context.getPara("OwnerParentFormKey");
				if (StringUtils.equals(compType, "ContainerKey") && StringUtils.isNotBlank(parentFormKey)) {
					ownerMetaForm = MetaFactory.getGlobalInstance().getMetaForm(parentFormKey);
				}
				loadThisProperties(ownerMetaForm, dataTable, panelKey);
			} else if (ConstantUtil.TBL_FORMAT.equalsIgnoreCase(tableKey)) {//MetaFormat
				String panelKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, panelKey);
				loadFormat(ownerMetaForm, dataTable, panelKey);
			} else if (ConstantUtil.TBL_DATA_BINDING.equalsIgnoreCase(tableKey)) {//DataBinding
				String panelKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, panelKey);
				loadDataBinding(ownerMetaForm, dataTable, panelKey);
			} else if (ConstantUtil.TBL_FONT.equalsIgnoreCase(tableKey)) {//MetaFont
				String panelKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, panelKey);
				loadFont(ownerMetaForm, dataTable, panelKey);
			} else if (ConstantUtil.TBL_GIRD_CELL_FORMAT.equalsIgnoreCase(tableKey)) {
				String panelKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, panelKey);
				loadGridCellFormat(ownerMetaForm, dataTable, panelKey);
			} else if (ConstantUtil.TBL_GRID_CELL.equalsIgnoreCase(tableKey)) {//MetaGridCell
				String panelKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				String parentKey = (String) context.getPara("parentKey");
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, panelKey);
				loadGridCell(ownerMetaForm, dataTable, panelKey, parentKey);
			} else if (ConstantUtil.TBL_LIST_VIEW_COLUMN.equalsIgnoreCase(tableKey)) {//MetaListViewColumn
				String panelKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, panelKey);
				loadListViewColumn(ownerMetaForm, dataTable, panelKey);
			} else if (ConstantUtil.TBL_GRID_ROW.equalsIgnoreCase(tableKey)) {//MetaGridRow
				String panelKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				String parentKey = (String) context.getPara("parentKey");
				String rowIndex = (String) context.getPara("d_rowIndex");
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, panelKey);
				loadGridRow(ownerMetaForm, dataTable, parentKey, rowIndex);
			} else if (ConstantUtil.TBL_META_DICT_VIEW.equalsIgnoreCase(tableKey)) {//MetaDictView
				String key = (String) context.getPara(ConstantUtil.COMP_KEY);
				loadDictViewProperty(ownerMetaForm, dataTable, key);
			} else if (ConstantUtil.TBL_DROPDOWN_BUTTON.equalsIgnoreCase(tableKey)) {
				String dropButtonKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				MetaComponent metaComponent = getComponentByKey(ownerMetaForm, dropButtonKey);
				loadDropdownItem(dataTable, metaComponent);
			} else if (ConstantUtil.TBL_ROW_EXPAND.equalsIgnoreCase(tableKey)) {//RowExpand
				String panelKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				String parentKey = (String) context.getPara("parentKey");
				String rowIndex = (String) context.getPara("d_rowIndex");
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, panelKey);
				loadRowExpand(ownerMetaForm, dataTable, parentKey, rowIndex);
			} else if (ConstantUtil.TBL_TOOL_BAR.equalsIgnoreCase(tableKey)) {
				String key = (String) context.getPara(ConstantUtil.COMP_KEY);
				MetaToolBar metaComponent = (MetaToolBar) ownerMetaForm.componentByKey(key);
				loadOperationsProperty(dataTable, metaComponent);
			} else if (ConstantUtil.TBL_RECYCLE_LIST.equalsIgnoreCase(tableKey)) {
				loadRecycleListProperty(dataTable);
			}else if (ConstantUtil.SNAPSHOT_LIST.equalsIgnoreCase(tableKey)) {
				loadSnapshotListProperty(dataTable, ownerFormKey);
			} else if (ConstantUtil.TBL_EMBED_VAR.equalsIgnoreCase(tableKey)) {
				String compKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				loadEmbedVarProperty(dataTable, ownerMetaForm, compKey);
			} else if (ConstantUtil.TBL_EMBED.equalsIgnoreCase(tableKey)) {
				String compKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				loadEmbedProperty(dataTable, ownerMetaForm, compKey);
			} else if (ConstantUtil.D_CONTAINER.equalsIgnoreCase(tableKey)) {
				String key = (String) context.getPara(ConstantUtil.COMP_KEY);
				MetaContainer metaComponent = (MetaContainer) ownerMetaForm.componentByKey(key);
				loadContainerProperty(dataTable, metaComponent);
			} else if (ConstantUtil.ECHO_VALUE_FORM.equalsIgnoreCase(tableKey)) {
				fieldEchoValue(paraValue, dataTable);
			} else if (ConstantUtil.TBL_OPERATION_COLLECTION.equalsIgnoreCase(tableKey)) {
				String compKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, compKey);
				loadOperationCollection(dataTable, ownerMetaForm, compKey);
			} else if (ConstantUtil.TBL_OPERATION.equalsIgnoreCase(tableKey)) {
				String erpCompKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				MetaOperationCollection erpMetaOperationCollection = ownerMetaForm.getOperationCollection();
				if (Objects.isNull(erpMetaOperationCollection)) {
					ownerMetaForm = containerForm;
					erpMetaOperationCollection = ownerMetaForm.getOperationCollection();
				}
				loadOperation(ownerMetaForm, erpMetaOperationCollection, erpCompKey, dataTable);
			} else if (ConstantUtil.TBL_SEPARATE.equalsIgnoreCase(tableKey)) {// 分隔尺寸load
				String panelKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, panelKey);
				MetaSplitPanel panel = (MetaSplitPanel) getComponentByKey(ownerMetaForm, panelKey);
				loadSeparate(dataTable, panel);
			} else if (ConstantUtil.ED_ROW_HEAD.equalsIgnoreCase(tableKey) || ConstantUtil.ED_ROW_DETAIL.equalsIgnoreCase(tableKey)) {
				String panelKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, panelKey);

				MetaComponent comp = getComponentByKey(ownerMetaForm, panelKey);
				if (comp.getControlType() == ControlType.EDITVIEW) {
					MetaViewCollection metaViewCollection = ownerMetaForm.getMetaBody().getViewCollection();
					MetaComponentView metaCompView = null;
					for (int i = 0; i < metaViewCollection.size(); i++) {
						MetaView metaView = metaViewCollection.get(i);
						metaCompView = metaView.get(comp.getKey());
						if (metaCompView != null) break;
					}
					if (metaCompView != null) {
						String childLayoutKey = (String) context.getPara("ChildLayoutKey");
						MetaComponentLayout<?> compLayout = metaCompView.get(childLayoutKey);
						if (compLayout.getLayoutType() == LayoutType.LAYOUT_GRID) {
							loadLayoutRow(dataTable, (MetaGridLayout) compLayout, ownerMetaForm);
						}
					}
				} else {
					loadLayoutRow(dataTable, (MetaGridLayoutPanel) comp, ownerMetaForm);
				}
			} else if (ConstantUtil.ED_COLUMN_HEAD.equalsIgnoreCase(tableKey) || ConstantUtil.ED_COLUMN_DETAIL.equalsIgnoreCase(tableKey)) {
				String panelKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, panelKey);

				MetaComponent comp = getComponentByKey(ownerMetaForm, panelKey);
				if (comp.getControlType() == ControlType.EDITVIEW) {
					MetaViewCollection metaViewCollection = ownerMetaForm.getMetaBody().getViewCollection();
					MetaComponentView metaCompView = null;
					for (int i = 0; i < metaViewCollection.size(); i++) {
						MetaView metaView = metaViewCollection.get(i);
						metaCompView = metaView.get(comp.getKey());
						if (metaCompView != null) break;
					}
					if (metaCompView != null) {
						String childLayoutKey = (String) context.getPara("ChildLayoutKey");
						MetaComponentLayout<?> compLayout = metaCompView.get(childLayoutKey);
						if (compLayout.getLayoutType() == LayoutType.LAYOUT_GRID) {
							loadLayoutColumn(dataTable, (MetaGridLayout) compLayout, ownerMetaForm);
						}
					}
				} else{
					loadLayoutColumn(dataTable, (MetaGridLayoutPanel) comp, ownerMetaForm);
				}

			} else if (ConstantUtil.ED_DICT_FILTER.equalsIgnoreCase(tableKey)) {
				String itemKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				String dictType = (String) context.getPara(ConstantUtil.TYPE);
				MetaItemFilterProcess.loadDictFilteringHead(context, document, dataTable, ownerMetaForm, itemKey, dictType, containerForm, tableCollection);
			} else if (ConstantUtil.ED_DICT_FILTER_VALUE.equalsIgnoreCase(tableKey)) {
				continue;
			} else if (ConstantUtil.ED_DICTITEM.equalsIgnoreCase(tableKey)) {
				continue;
			} else if (ConstantUtil.TBL_GRID_FILTER_HEAD.equalsIgnoreCase(tableKey)) {
				String fieldKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				MetaGrid metaGrid = (MetaGrid) getComponentByKey(ownerMetaForm, fieldKey);

				if (Objects.isNull(metaGrid) && containerForm != null) {
					ownerMetaForm = containerForm;
					metaGrid = (MetaGrid) getComponentByKey(ownerMetaForm, fieldKey);
				}
				loadGridFilter(dataTable, metaGrid);
			} else if (ConstantUtil.TBL_GRID_FILTER_DETAIL.equalsIgnoreCase(tableKey)) {
				String fieldKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				MetaGrid metaGrid = (MetaGrid) getComponentByKey(ownerMetaForm, fieldKey);
				if (Objects.isNull(metaGrid) && containerForm != null) {
					ownerMetaForm = containerForm;
					metaGrid = (MetaGrid) getComponentByKey(ownerMetaForm, fieldKey);
				}
				loadGridFilterRow(dataTable, metaGrid,ownerMetaForm);
			} else if (ConstantUtil.TBL_MACRO.equalsIgnoreCase(tableKey)) {
				String fieldKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, fieldKey);
				MetaMacro metaMacro = ownerMetaForm.getMacroCollection().get(fieldKey);
				loadMacroProperty(dataTable, metaMacro);
			} else if (ConstantUtil.ED_CONDITION_HEAD.equalsIgnoreCase(tableKey)) {
				String compKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, compKey);
				MetaComponent metaField = (MetaComponent) DesignIOMetaUtil.getMetaComponent(ownerMetaForm, compKey);
				loadCondiditonHead(dataTable, metaField);
			} else if (ConstantUtil.TBL_COLUMN_EXPAND.equalsIgnoreCase(tableKey)) {
				String compKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, compKey);
				compKey = compKey.substring(7);
				String parentKey = (String) context.getPara("parentKey");
				MetaGridColumn metaColumn = null;
				MetaGrid metaGrid;
				metaGrid = (MetaGrid) getComponentByKey(ownerMetaForm, parentKey);
				MetaGridColumnCollection columnCollection = metaGrid.getColumnCollection();
				metaColumn = getMetaGridColumn(compKey, metaColumn, columnCollection);
				loadColumnExpand(dataTable, metaColumn, metaGrid);
			} else if (ConstantUtil.TBL_CONDITION_COLLECTION.equalsIgnoreCase(tableKey)) {
				String compKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, compKey);
				MetaComponent metaField = (MetaComponent) DesignIOMetaUtil.getMetaComponent(ownerMetaForm, compKey);
				MetaTable customConditionPara = tableCollection.get(ConstantUtil.TBL_CUSTOM_CONDITION_PARA);
				loadConditionCollection(dataTable, metaField, context, customConditionPara, document);
			} else if (ConstantUtil.TBL_CONDITION_TARGET_COLLECTION.equalsIgnoreCase(tableKey)) {
				String compKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, compKey);
				MetaComponent metaField = (MetaComponent) DesignIOMetaUtil.getMetaComponent(ownerMetaForm, compKey);
				loadConditionTargetCollection(dataTable, metaField);
			} else if (ConstantUtil.ED_DATA_OBJECT_HEAD.equalsIgnoreCase(tableKey)) {
				if(ownerMetaForm == null && ConstantUtil.DATA_OBJECT.equals(Type)){
					loadE_DataObjectFormHead(dataTable, ownerFormKey);
				}else{
					loadDataSourceHead(ownerMetaForm, containerForm, dataTable);
				}
				dataChase = dataTable;
			}else if (ConstantUtil.TBL_CUSTOM_CONDITION_PARA.equalsIgnoreCase(tableKey)) {
				continue;
			} else if ("ED_ImportSolution".equalsIgnoreCase(tableKey)) {
				loadImportSolution(dataTable);
			} else if ("ED_ParameterCollection".equalsIgnoreCase(tableKey)) {
				continue;
			} else if (ConstantUtil.ED_TABLE_COLLECTION.equalsIgnoreCase(tableKey)) {
				MetaTable ed_parameterCollection = tableCollection.get("ED_ParameterCollection");
				MetaTable ed_indexCollection = tableCollection.get("ED_IndexCollection");
				String mainTableKey = dataChase.getString("MainTable");
				if(ownerMetaForm == null && ConstantUtil.DATA_OBJECT.equals(Type)){
					MetaDataObject erpDataObject = MetaFactory.getGlobalInstance().getDataObject(ownerFormKey);
					if (Objects.isNull(erpDataObject)) {
						continue;
					}
					String xmlFilePath = LoadFileTree.getPathByDataObject(ownerFormKey);
					String extendKey = erpDataObject.getExtend();
					String mergeToSourceMapKey = erpDataObject.getMergeToSourceMapKey();
					String otherKey = StringUtils.isNotBlank(extendKey) ? extendKey : mergeToSourceMapKey;
					XmlTree otherXmlTree = null;
					if (StringUtils.isNotBlank(otherKey)) {
						String otherFilePath = LoadFileTree.getPathByDataObject(otherKey);
						String tempOtherFilePath = XmlFileProcessor.instance.getTmpFile(otherFilePath);
						String realOtherFilePath = StringUtils.isNotBlank(tempOtherFilePath) ? tempOtherFilePath : otherFilePath;
						otherXmlTree = Xml4jUtil.parseTree(realOtherFilePath);
					}

					List<String> embedTableKeyList = new ArrayList<>();
					XmlTree xmlTree = filterTable(context, document, xmlFilePath, erpDataObject, mainTableKey, ed_parameterCollection, ed_indexCollection, dataTable, embedTableKeyList);
					for (int i = dataTable.size() - 1; i >= 0; i--) {
						String tableMark = dataTable.getString(i, "TableMark");
						if (Objects.nonNull(xmlTree) && xmlTree.containKey(ConstantUtil.TABLE + "@" + tableMark)) {
							continue;
						}
						if (Objects.nonNull(otherXmlTree) && otherXmlTree.containKey(ConstantUtil.TABLE + "@" + tableMark)) {
							continue;
						}
						if (embedTableKeyList.contains(tableMark)) {
							continue;
						}
						dataTable.delete(i);
					}
				}else{
					loadTableCollection(context, document, ownerMetaForm, containerForm, mainTableKey, ed_parameterCollection, ed_indexCollection, dataTable);
				}
			} else if (ConstantUtil.TBL_GRID_TREE_PROPERTIES.equalsIgnoreCase(tableKey)) {
				String fieldKey = (String) context.getPara("parentKey");
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, fieldKey);
				MetaGrid metaGrid = (MetaGrid) ownerMetaForm.componentByKey(fieldKey);
				for (MetaGridRow metaGridRow : metaGrid.getRowCollection()) {
					String key = (String) context.getPara(ConstantUtil.COMP_KEY);
					if (metaGridRow.getKey().equalsIgnoreCase(key)){
						loadGridTree(dataTable, ownerMetaForm, metaGridRow);
						break;
					}
				}
			} else if (ConstantUtil.TBL_UI_CHECK_RULE_COLLECTION.equalsIgnoreCase(tableKey)) {
				String rowKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				String fieldKey = (String) context.getPara("parentKey");
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, fieldKey);
				MetaGrid metaGrid = (MetaGrid) ownerMetaForm.componentByKey(fieldKey);
				for (MetaGridRow metaGridRow : metaGrid.getRowCollection()) {
					if (metaGridRow.getKey().equalsIgnoreCase(rowKey)) {
						loadUICheckRule(dataTable, ownerMetaForm, metaGridRow);
					}
				}
			} else if (ConstantUtil.TBL_TRACE_COLLECTION.equalsIgnoreCase(tableKey)) { // TraceCollection数据来源
				String fieldKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, fieldKey);
				AbstractMetaObject traceCollectionProperty = IOMetaObject.getComponentByKey(ownerMetaForm, fieldKey);
				loadTraceCollectionDetail(dataTable, (MetaGrid) traceCollectionProperty);
			} else if (ConstantUtil.TBL_EXT_OPT_COLLECTION.equalsIgnoreCase(tableKey)) { // 额外的操作集合
				String fieldKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, fieldKey);
				AbstractMetaObject extOptCollectionProperty = IOMetaObject.getComponentByKey(ownerMetaForm, fieldKey);
				loadExtOptCollection(dataTable, (MetaGrid) extOptCollectionProperty);
			} else if (ConstantUtil.ED_COMBO_BOX_DETAIL.equalsIgnoreCase(tableKey)) {// 下拉框来源
				String fieldKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, fieldKey);
				loadComboBoxDetail(ownerMetaForm, fieldKey, dataTable);
			} else if (ConstantUtil.TBL_DICT_VIEW_COLUMN.equalsIgnoreCase(tableKey)) {
				String fieldKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, fieldKey);
				AbstractMetaObject comboBoxProperty = DesignIOMetaUtil.getMetaComponent(ownerMetaForm, fieldKey);
				loadDictViewDetail(dataTable, comboBoxProperty);
			} else if (ConstantUtil.ED_NEW_MACRO_DETAIL.equalsIgnoreCase(tableKey) || ConstantUtil.TBL_MACRO_FORMULA.equalsIgnoreCase(tableKey)) {
				String erpXmlFilePath = LoadFileTree.getPathByFormKey(ownerFormKey);
				if (StringUtils.isBlank(erpXmlFilePath) && Objects.nonNull(metaCommonDef)) {
					erpXmlFilePath = ownerFormKey;
				}
				if (StringUtils.isNotBlank(erpXmlFilePath)) {
					loadMacroList(ownerMetaForm, FilePathHelper.toBackFilePath(erpXmlFilePath), dataTable,metaCommonDef,0L);
				}
			} else if (ConstantUtil.TBL_SCRIPT_LIST.equalsIgnoreCase(tableKey)) {
				String path1 = LoadFileTree.getPathByFormKey(ownerFormKey);
				if (StringUtils.isEmpty(path1) && metaCommonDef != null) {
					path1 = ownerFormKey;
				}
				if (StringUtils.isNotBlank(path1)) {
					loadScriptList(ownerMetaForm, FilePathHelper.toBackFilePath(path1), dataTable);
				}
			} else if (ConstantUtil.TBL_STATUS_LIST.equalsIgnoreCase(tableKey)) {
				String path1 = LoadFileTree.getPathByFormKey(ownerFormKey);
				if (StringUtils.isEmpty(path1) && metaCommonDef != null) {
					loadStatusList(context,dataTable,metaCommonDef,0L);
				}
				if (StringUtils.isNotBlank(path1)) {

				}
			} else if (ConstantUtil.TBL_FORM_NODE_TREE.equalsIgnoreCase(tableKey)) {
				if (ownerMetaForm != null) {
					loadFormTree(dataTable, ownerMetaForm, false);
					if (containerForm != null) {
						boolean isContainer = false;
						List<MetaComponent> allComponents = ownerMetaForm.getAllComponents();
						for (MetaComponent allComponent : allComponents) {
							int controlType = allComponent.getControlType();
							if (controlType == ControlType.CONTAINER) {
								isContainer = true;
								break;
							}
						}
						if (ownerMetaForm != containerForm && containerForm != null && isContainer) {//含有Container的时候才可以
							loadFormTree(dataTable, containerForm, true);
						}
					}
				}
			} else if (ConstantUtil.TBL_ENTRY.equalsIgnoreCase(tableKey)) {
				String filePath = FilePathHelper.toBackFilePath(path);
				loadEntrysTree2(dataTable, filePath);
			} else if (ConstantUtil.TBL_FILE_TREE.equalsIgnoreCase(tableKey)) {
				LoadFileTree.loadFileTree(context, dataTable, null);
			}
			// 数据源数据对象合并测试完成后删除
			/*else if (ConstantUtil.E_DATA_OBJECT_FORM_HEAD.equals(tableKey)) {
				//加载表头数据
				loadE_DataObjectFormHead(dataTable, ownerFormKey);
				dataChase = dataTable;
			}*/
			// 数据源数据对象合并测试完成后删除
			/*else if (ConstantUtil.E_DATA_OBJECT_COLLECTION.equals(tableKey)) {
				MetaDataObject erpDataObject = MetaFactory.getGlobalInstance().getDataObject(ownerFormKey);
				if (Objects.isNull(erpDataObject)) {
					continue;
				}

				MetaTable ed_parameterCollection = tableCollection.get("ED_ParameterCollection");
				MetaTable ed_indexCollection = tableCollection.get("ED_IndexCollection");
				String mainTableKey = dataChase.getString("MainTable");
				String xmlFilePath = LoadFileTree.getPathByDataObject(ownerFormKey);

				String extendKey = erpDataObject.getExtend();
				String mergeToSourceMapKey = erpDataObject.getMergeToSourceMapKey();
				String otherKey = StringUtils.isNotBlank(extendKey) ? extendKey : mergeToSourceMapKey;
				XmlTree otherXmlTree = null;
				if (StringUtils.isNotBlank(otherKey)) {
					String otherFilePath = LoadFileTree.getPathByDataObject(otherKey);
					String tempOtherFilePath = XmlFileProcessor.instance.getTmpFile(otherFilePath);
					String realOtherFilePath = StringUtils.isNotBlank(tempOtherFilePath) ? tempOtherFilePath : otherFilePath;
					otherXmlTree = Xml4jUtil.parseTree(realOtherFilePath);
				}

				List<String> embedTableKeyList = new ArrayList<>();
				XmlTree xmlTree = filterTable(context, document, xmlFilePath, erpDataObject, mainTableKey, ed_parameterCollection, ed_indexCollection, dataTable, embedTableKeyList);
				for (int i = dataTable.size() - 1; i >= 0; i--) {
					String tableMark = dataTable.getString(i, "TableMark");
					if (Objects.nonNull(xmlTree) && xmlTree.containKey(ConstantUtil.TABLE + "@" + tableMark)) {
						continue;
					}
					if (Objects.nonNull(otherXmlTree) && otherXmlTree.containKey(ConstantUtil.TABLE + "@" + tableMark)) {
						continue;
					}
					if (embedTableKeyList.contains(tableMark)) {
						continue;
					}
					dataTable.delete(i);
				}
			}*/
			else if (
					ConstantUtil.TBL_OPERATIONS.equalsIgnoreCase(tableKey)||
							ConstantUtil.TBL_QueryStatement.equalsIgnoreCase(tableKey)||
							ConstantUtil.ED_PARA_ITEM.equalsIgnoreCase(tableKey)||
							ConstantUtil.TBL_DefaultItem.equalsIgnoreCase(tableKey)||
							ConstantUtil.TBL_DATA_OBJECT_FIELD.equalsIgnoreCase(tableKey)||
							ConstantUtil.TBL_FieldLabelCollection.equalsIgnoreCase(tableKey)||
							ConstantUtil.ED_TABLE_FIELDS.equalsIgnoreCase(tableKey)||
							ConstantUtil.ED_SearchHelpForm.equalsIgnoreCase(tableKey)

			) {
				setMetaTable(metaTable);
				continue;
			} else if (ConstantUtil.TBL_QUERY_PARAMETER_COLLECTION.equalsIgnoreCase(tableKey)) {
				setMetaTableTwo(metaTable);
				continue;
			} else if ("ED_MacroFormula_Head".equalsIgnoreCase(tableKey)) {
				continue;
			} else if (ConstantUtil.TBL_QUERY_COLLECTION.equalsIgnoreCase(tableKey)) {
				String erpXmlFilePath = LoadFileTree.getPathByFormKey(ownerFormKey);
				if (StringUtils.isBlank(erpXmlFilePath) && Objects.nonNull(metaCommonDef)) {
					erpXmlFilePath = ownerFormKey;
				}

				if (StringUtils.isNotBlank(erpXmlFilePath)) {
					loadQueryCollection(ownerMetaForm,  FilePathHelper.toBackFilePath(erpXmlFilePath),dataTable ,document, context);
				}
			} else if (ConstantUtil.TBL_DataElementDef.equalsIgnoreCase(tableKey)) {
				loadDataElementDef(document,path,dataTable,context);
			} else if (ConstantUtil.TBL_DOMINDEF.equalsIgnoreCase(tableKey)) {
				loadDomainDef(document,path,dataTable,context);
			} else if (ConstantUtil.TBL_PARA_TABLE.equalsIgnoreCase(tableKey)) {
				loadParaList(dataTable, FilePathHelper.toBackFilePath(ownerFormKey), document, context);
			} else if (ConstantUtil.TBL_PRE_LOAD_PROCESS.equalsIgnoreCase(tableKey) ||
					ConstantUtil.TBL_POST_LOAD_PROCESS.equalsIgnoreCase(tableKey) ||
					ConstantUtil.TBL_PRE_SAVE_PROCESS.equalsIgnoreCase(tableKey) ||
					ConstantUtil.TBL_POST_SAVE_PROCESS.equalsIgnoreCase(tableKey) ||
					ConstantUtil.TBL_PRE_DELETE_PROCESS.equalsIgnoreCase(tableKey) ||
					ConstantUtil.TBL_POST_DELETE_PROCESS.equalsIgnoreCase(tableKey) ||
					ConstantUtil.TBL_STATUS_COLLECTION.equals(tableKey) ||
					ConstantUtil.TBL_STATUS_TRIGGER_COLLECTION.equals(tableKey) ||
					ConstantUtil.TBL_EXTEND_COLLECTION.equals(tableKey) ||
					ConstantUtil.TBL_CHECK_RULE_COLLECTION.equals(tableKey) ||
					ConstantUtil.TBL_MACRO_COLLECTION.equals(tableKey)
			) {
				loadDataObjectEvent(context, document, ownerMetaForm, ownerFormKey, null, dataTable);
			} else if (ConstantUtil.TBL_OID_FILTER.equals(tableKey)) {
				MetaTable parameterCollection = tableCollection.get(ConstantUtil.TBL_OID_FILTER_PARAMETER_COLLECTION);
				DataTable designParameterDataTable = WebDesignerDataTableUtil.generateDataTable(parameterCollection);
				document.add(designParameterDataTable.getKey(), designParameterDataTable);
				loadDataObjectEvent(context, document, ownerMetaForm, ownerFormKey, designParameterDataTable, dataTable);
			} else if (ConstantUtil.TBL_EMBED_TABLE_COLLECTION.equals(tableKey)) {
				loadEmbedTables(dataTable, ownerMetaForm, ownerFormKey);
			} else if (ConstantUtil.TBL_OPERATION_TOOLBAR_DETAIL.equalsIgnoreCase(tableKey)) {
				MetaOperationCollection operationCollection;
				HashMap<String,KeyPairCompositeObject> operationCollectionSrcMap = new HashMap<>();

				if (Objects.nonNull(metaCommonDef)) {
					operationCollection = metaCommonDef.getOperationCollection();
					FormToolOperUtil.getOperation(operationCollection,operationCollectionSrcMap);
					DataTable erpOperationDataTable = WebDesignerDataTableUtil.generateDataTable(getMetaTable());
					document.add(erpOperationDataTable.getKey(), erpOperationDataTable);

					loadTableOperationCollection(context,erpOperationDataTable, null,  dataTable,operationCollection,operationCollectionSrcMap,0L);
				}else {
					MetaForm metaForm = NewFormCmd.loadMetaForm(ownerMetaForm.getKey());
					operationCollection = metaForm.getOperationCollection();
					FormToolOperUtil.getOperation(operationCollection,operationCollectionSrcMap);
					DataTable erpOperationDataTable = WebDesignerDataTableUtil.generateDataTable(getMetaTable());
					document.add(erpOperationDataTable.getKey(), erpOperationDataTable);
					loadTableOperationCollection(context, erpOperationDataTable, ownerMetaForm,  dataTable,ownerMetaForm.getOperationCollection(),operationCollectionSrcMap,0L);
				}

			} else if (ConstantUtil.TBL_OID_FILTER_PARAMETER_COLLECTION.equals(tableKey) || ConstantUtil.ED_INDEX_COLLECTION.equals(tableKey)) {
				continue;
			} else if (ConstantUtil.ED_CHARTDATASOURCE.equalsIgnoreCase(tableKey)) {
				loadChartDataSource(context, ownerMetaForm, null, dataTable);
			} else if (ConstantUtil.ED_SERIESDTL.equalsIgnoreCase(tableKey)) {
				loadSeriesDtl(context, ownerMetaForm, null, dataTable);
			} else if (ConstantUtil.ED_CAROUSEL_PROP.equals(tableKey)) {
				String panelKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, panelKey);
				loadCarouselProperties(ownerMetaForm, panelKey, dataTable);
			} else if (ConstantUtil.ED_REFRESH_FOOTER_PROP.equals(tableKey)) {
				String panelKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, panelKey);
				loadRefreshFooterProperties(ownerMetaForm, panelKey, dataTable);
			} else if (ConstantUtil.ED_REFRESH_HEADER_PROP.equals(tableKey)) {
				String panelKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, panelKey);
				loadRefreshHeaderProperties(ownerMetaForm, panelKey, dataTable);
			} else if (ConstantUtil.ED_CAROUSEL_DETAIL.equals(tableKey)) {
				String fieldKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, fieldKey);
				loadCarouselDetail(ownerMetaForm, fieldKey, dataTable);
			} else if (ConstantUtil.ED_REFRESH_HEADER_DETAIL.equals(tableKey)) {
				String fieldKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, fieldKey);
				loadRefreshHeaderDetail(ownerMetaForm, fieldKey, dataTable);
			} else if (ConstantUtil.ED_PRICELABELITEM_DETAIL.equals(tableKey)) {
				String fieldKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, fieldKey);
				loadPriceLabelItemDetail(ownerMetaForm, fieldKey, dataTable);
			} else if (ConstantUtil.ED_ROW_ACTIONS.equals(tableKey)) {
				String fieldKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				String rowKey = (String) context.getPara("rowKey");

				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, fieldKey);
				loadRowActionsDetail(ownerMetaForm, fieldKey, dataTable, rowKey);
			} else if (ConstantUtil.ED_EDITVIEW_ITEMS_PROP.equals(tableKey)) {
				String compKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, compKey);
				loadEditViewItemsProperties(ownerMetaForm, compKey, dataTable);
			} else if (ConstantUtil.ED_EDITVIEW_ITEMS_DETAIL.equals(tableKey)) {
				String compKey = (String) context.getPara(ConstantUtil.COMP_KEY);
				ownerMetaForm = isThisForm(ownerMetaForm, containerForm, compKey);
				loadEditViewItemsDetail(ownerMetaForm, compKey, dataTable);
			} else if("Parameter".equals(Type)){
				loadParameterList(dataTable, FilePathHelper.toBackFilePath(ownerFormKey), document, context);
			}
			document.add(tableKey, dataTable);
		}
		setSequence(document);
		return document;
	}


	@Override
	public void setKey(String arg0) {
		throw new NotImplementedException("Code is not implemented");
	}

	@Override
	public Document save(DefaultContext context, SaveFilterMap arg1, Document arg2) {
		throw new NotImplementedException("Code is not implemented");
	}

	@Override
	public void delete(DefaultContext context, Document doc) {
		throw new NotImplementedException("Code is not implemented");
	}

	@Override
	public Document load(DefaultContext context, MetaDataObject metaDataObject, Long oid) {
		throw new NotImplementedException("Code is not implemented");
	}

	@Override
	public void setDataSource(MetaDataSource arg0) {
		throw new NotImplementedException("Code is not implemented");
	}

	private void loadBindingColumns(DataTable dataTable, MetaForm metaForm, String tableKey, IDLookup idLookup) throws Throwable {
		String refObjectKey = metaForm.getDataSource().getRefObjectKey();
		MetaDataObject dataObject;
		MetaTable table;
		if (StringUtils.isNotBlank(refObjectKey)) {
			dataObject = MetaFactory.getGlobalInstance().getDataObject(refObjectKey);
		} else {
			dataObject = metaForm.getDataSource().getDataObject();
		}
		if (StringUtils.isNotBlank(tableKey)) {
			table = dataObject.getTable(tableKey);
			Collection<MetaColumn> items = table.items();
			for (MetaColumn item : items) {
				int i = dataTable.append();
				dataTable.setObject(i, "ColumnKey", item.getKey());
				dataTable.setObject(i, "Caption", item.getCaption());
				loadCellFormat(dataTable, metaForm, tableKey, idLookup, item, i);
			}
		} else {
			MetaTable mainTable = dataObject.getMainTable();
			if (mainTable != null) {
				Collection<MetaColumn> items = mainTable.items();
				for (MetaColumn item : items) {
					int i = dataTable.append();
					dataTable.setObject(i, "ColumnKey", mainTable.getKey() + "|" + item.getKey());
					dataTable.setObject(i, "Caption", item.getCaption());
					loadCellFormat(dataTable, metaForm, mainTable.getKey(), idLookup, item, i);
				}
			}
		}
	}

	public static void loadCellFormat(DataTable dataTable, MetaForm metaForm, String tableKey, IDLookup idLookup,
									  MetaColumn item
			, int i) throws Throwable {
		List<String> list = idLookup.getFieldListKeyByTableColumnKey(tableKey, item.getKey());
		dataTable.setObject(i, "IsInste_Key", "1");
		dataTable.setObject(i, "IsInste_Caption", "1");
		dataTable.setObject(i, "Inste_H", "H");
		dataTable.setObject(i, "IsDetail", "false");
		String gridKey = idLookup.getGridKeyByTableKey(tableKey);
		if (StringUtils.isNotBlank(gridKey)) {
			dataTable.setObject(i, "Inste_H", "Z");
			dataTable.setObject(i, "IsDetail", "true");
		}
		if (list != null && list.size() > 0) {
			String key = list.get(0);
			AbstractMetaObject metaObject = metaForm.getAllUIComponents().get(key);
			if (Objects.isNull(metaObject)) {
				dataTable.setObject(i, "DataType", "Text");
				return;
			}

			if (metaObject instanceof MetaGridCell) {

				MetaGridCell gridCell = ((MetaGridCell) metaObject);
				int cellType = gridCell.getCellType();
				if (cellType == ControlType.DICT) {
					MetaDictProperties properties = (MetaDictProperties) gridCell.getProperties();
					dataTable.setObject(i, "DataType", ControlType.toString(cellType));
					dataTable.setObject(i, "ItemKey", properties.getItemKey());
					dataTable.setObject(i, "FieldKeys", "Name");
				} else if (cellType == ControlType.COMBOBOX) {//下拉框
					MetaComboBoxProperties gridCell1 = (MetaComboBoxProperties) gridCell.getProperties();
					dataTable.setObject(i, "DataType", "List");
					if (gridCell1.getSourceType() == ComboBoxSourceType.ITEMS) {
						StrBuilder strBuilder = new StrBuilder();
						for (MetaDefaultItem gridCell1Item : gridCell1.getItems()) {
							strBuilder.append(gridCell1Item.getValue()).append(":").append(gridCell1Item.getCaption()).append(";");
						}
						dataTable.setObject(i, "List", strBuilder.toString());
					}
				} else if (cellType == ControlType.CHECKLISTBOX) {//多选下拉框
					MetaCheckListBoxProperties gridCell1 = (MetaCheckListBoxProperties) gridCell.getProperties();
					dataTable.setObject(i, "DataType", "MultiList");
					if (gridCell1.getSourceType() == ComboBoxSourceType.ITEMS) {
						StrBuilder strBuilder = new StrBuilder();
						for (MetaDefaultItem gridCell1Item : gridCell1.getItems()) {
							strBuilder.append(gridCell1Item.getValue()).append(":").append(gridCell1Item.getCaption()).append(";");
						}
						dataTable.setObject(i, "List", strBuilder.toString());
					}
				} else if (cellType == ControlType.DATEPICKER) {//日期
					MetaDatePickerProperties gridCell1 = (MetaDatePickerProperties) gridCell.getProperties();
					String dateFormat = gridCell1.getDateFormat();
					dataTable.setObject(i, "DataType", "Date");
					dataTable.setObject(i, "D_Format", StringUtils.isNotBlank(dateFormat) ? dateFormat : "yyyy-MM-dd HH:mm:ss");
				} else if (cellType == ControlType.UTCDATEPICKER) {//日期
					MetaUTCDatePickerProperties gridCell1 = (MetaUTCDatePickerProperties) gridCell.getProperties();
					String dateFormat = gridCell1.getDateFormat();
					dataTable.setObject(i, "DataType", "Date");
					dataTable.setObject(i, "D_Format", dateFormat);
				} else if (cellType == ControlType.NUMBEREDITOR) {//数值
					MetaNumberEditorProperties gridCell1 = (MetaNumberEditorProperties) gridCell.getProperties();
					int formatStyle = gridCell1.getFormatStyle();
					if (formatStyle != -1) {
						if (formatStyle == FormatStyle.RMBSTYLE) {
							dataTable.setObject(i, "DataType", "Money");
							dataTable.setObject(i, "M_Format", "￥##,###.##");
						} else if (formatStyle == FormatStyle.DOLLARSTYLE) {
							dataTable.setObject(i, "DataType", "Money");
							dataTable.setObject(i, "M_Format", "$##,###.##");
						} else if (formatStyle == FormatStyle.PERCENTSTYLE) {
							dataTable.setObject(i, "DataType", "Number");
							dataTable.setObject(i, "Format", "###.##%");
						}
					} else {
						if (item.getDataType() == DataType.NUMERIC || item.getDataType() == DataType.INT) {
							dataTable.setObject(i, "DataType", "Number");
							dataTable.setObject(i, "Format", "###,##");
						} else {
							dataTable.setObject(i, "DataType", "Money");
							dataTable.setObject(i, "M_Format", "$##,###.##");
						}
					}
				} else {
					dataTable.setObject(i, "DataType", "Text");
				}
			} else if (metaObject instanceof MetaComponent) {
				MetaComponent gridCell = ((MetaComponent) metaObject);
				int controlType = gridCell.getControlType();
				if (controlType == ControlType.DICT) {
					MetaDictProperties properties = (MetaDictProperties) gridCell.getProperties();
					dataTable.setObject(i, "DataType", ControlType.toString(gridCell.getControlType()));
					dataTable.setObject(i, "ItemKey", properties.getItemKey());
					dataTable.setObject(i, "FieldKeys", "Name");
				} else if (controlType == ControlType.COMBOBOX) {//下拉框
					MetaComboBoxProperties gridCell1 = (MetaComboBoxProperties) gridCell.getProperties();
					dataTable.setObject(i, "DataType", "List");
					if (gridCell1.getSourceType() == ComboBoxSourceType.ITEMS) {
						StrBuilder strBuilder = new StrBuilder();
						for (MetaDefaultItem gridCell1Item : gridCell1.getItems()) {
							strBuilder.append(gridCell1Item.getValue()).append(":").append(gridCell1Item.getCaption()).append(";");
						}
						dataTable.setObject(i, "List", strBuilder.toString());
					} else if (gridCell1.getSourceType() == ComboBoxSourceType.STATUS) {
						StrBuilder strBuilder = new StrBuilder();
						MetaProject project = (MetaProject) metaForm.getProject();
						if (project.getCommonDef() != null && project.getCommonDef().getStatusCollection() != null) {
							MetaStatusCollection statusCollection = project.getCommonDef().getStatusCollection();
							if (statusCollection.size() > 0) {
								for (MetaStatus metaStatus : statusCollection) {
									strBuilder.append(metaStatus.getValue()).append(":").append(metaStatus.getCaption()).append(";");
								}
							}
						} else {
							MetaCommonDef commondDef = MetaFactory.getGlobalInstance().getCommonDef("");
							if (commondDef != null && commondDef.getStatusCollection() != null) {
								MetaStatusCollection statusCollection = commondDef.getStatusCollection();
								for (MetaStatus metaStatus : statusCollection) {
									strBuilder.append(metaStatus.getValue()).append(":").append(metaStatus.getCaption()).append(";");
								}
							}
						}
						dataTable.setObject(i, "List", strBuilder.toString());
					}
				} else if (controlType == ControlType.CHECKLISTBOX) {//多选下拉框
					MetaCheckListBoxProperties gridCell1 = (MetaCheckListBoxProperties) gridCell.getProperties();
					dataTable.setObject(i, "DataType", "MultiList");
					if (gridCell1.getSourceType() == ComboBoxSourceType.ITEMS) {
						StrBuilder strBuilder = new StrBuilder();
						for (MetaDefaultItem gridCell1Item : gridCell1.getItems()) {
							strBuilder.append(gridCell1Item.getValue()).append(":").append(gridCell1Item.getCaption()).append(";");
						}
						dataTable.setObject(i, "List", strBuilder.toString());
					}
				} else if (controlType == ControlType.DATEPICKER) {//日期
					MetaDatePickerProperties gridCell1 = (MetaDatePickerProperties) gridCell.getProperties();
					String dateFormat = gridCell1.getDateFormat();
					dataTable.setObject(i, "DataType", "Date");
					dataTable.setObject(i, "D_Format", StringUtils.isNotBlank(dateFormat) ? dateFormat : "yyyy-MM-dd HH:mm:ss");
				} else if (controlType == ControlType.UTCDATEPICKER) {//日期
					MetaUTCDatePickerProperties gridCell1 = (MetaUTCDatePickerProperties) gridCell.getProperties();
					String dateFormat = gridCell1.getDateFormat();
					dataTable.setObject(i, "DataType", "Date");
					dataTable.setObject(i, "D_Format", dateFormat);
				} else if (controlType == ControlType.NUMBEREDITOR) {//数值
					MetaNumberEditorProperties gridCell1 = (MetaNumberEditorProperties) gridCell.getProperties();
					int formatStyle = gridCell1.getFormatStyle();
					if (formatStyle != -1) {
						if (formatStyle == FormatStyle.RMBSTYLE) {
							dataTable.setObject(i, "DataType", "Money");
							dataTable.setObject(i, "M_Format", "￥##,###.##");
						} else if (formatStyle == FormatStyle.DOLLARSTYLE) {
							dataTable.setObject(i, "DataType", "Money");
							dataTable.setObject(i, "M_Format", "$##,###.##");
						} else if (formatStyle == FormatStyle.PERCENTSTYLE) {
							dataTable.setObject(i, "DataType", "Number");
							dataTable.setObject(i, "Format", "###.##%");
						}
					} else {
						if (item.getDataType() == DataType.NUMERIC || item.getDataType() == DataType.INT || item.getDataType() == DataType.LONG) {
							dataTable.setObject(i, "DataType", "Number");
							dataTable.setObject(i, "Format", "###,##");
						} else {
							dataTable.setObject(i, "DataType", "Money");
							dataTable.setObject(i, "M_Format", "$##,###.##");
						}
					}
				} else {
					dataTable.setObject(i, "DataType", "Text");
				}
			}
		} else {
			dataTable.setObject(i, "DataType", "Text");
		}
	}

	public static String ifEmptyGetDefault(String value, String defaultValue) {
		return StringUtils.isEmpty(value) ? defaultValue : value;
	}

	/**
	 * 处理报表页面设置
	 */
	public void dealReportPageOpt(DataTable dataTable, Element root) {
		dataTable.append();
		String pageID = root.attributeValue("PageID");
		String isVirtualPage = ifEmptyGetDefault(root.attributeValue("VirtualPage"), "false");
		String pageHeight = ifEmptyGetDefault(root.attributeValue("PageHeight"), "0");
		String pageWidth = ifEmptyGetDefault(root.attributeValue("PageWidth"), "0");
		dataTable.setObject("IsVirtualPage", TypeConvertor.toInteger(isVirtualPage));
		if (StringUtils.isBlank(pageID)) {
			pageID = "A4";
			pageHeight = "842";
			pageWidth = "595";
		}
		if (pageID.equals("Custom")) { // 加载页面设置
			dataTable.setString("Type", "Custom");
			dataTable.setString("PageHeight", pageHeight);
			dataTable.setString("PageWidth", pageWidth);
		} else {
			dataTable.setString("Type", "Predefine");
			dataTable.setString("PagePredefined", pageID + ";" + pageWidth + ";" + pageHeight);
		}
		// 加载纸张设置
		if (Boolean.parseBoolean(isVirtualPage)) {
			String paperHeight = ifEmptyGetDefault(root.attributeValue("PaperHeight"), "0");
			String paperWidth = ifEmptyGetDefault(root.attributeValue("PaperWidth"), "0");
			String paperId = root.attributeValue("PaperID");
			if (StringUtils.isBlank(paperId)) {
				paperId = "A4";
				paperHeight = "842";
				paperWidth = "595";
			}
			if (paperId.equals("Custom")) {
				dataTable.setString("PaperType", paperId);
				dataTable.setString("PaperHeight", paperHeight);
				dataTable.setString("PaperWidth", paperWidth);
			} else {
				dataTable.setString("PaperType", "Predefine");
				dataTable.setString("PaperPredefined", paperId + ";" + paperWidth + ";" + paperHeight);
			}
		}

		dataTable.setString("TopMargin", ifEmptyGetDefault(root.attributeValue("TopMargin"), "0"));
		dataTable.setString("RightMargin", ifEmptyGetDefault(root.attributeValue("RightMargin"), "0"));
		dataTable.setString("BottomMargin", ifEmptyGetDefault(root.attributeValue("BottomMargin"), "0"));
		dataTable.setString("LeftMargin", ifEmptyGetDefault(root.attributeValue("LeftMargin"), "0"));
		dataTable.setString("Orientation", ifEmptyGetDefault(root.attributeValue("PageOrientation"), "Portrait"));
		dataTable.setString("PaperOrientation", ifEmptyGetDefault(root.attributeValue("PaperOrientation"), "Portrait"));
	}

	public void dealExcelColumnExpand(DataTable dataTable, Element root, DefaultContext context) {
		int rowIndex = Integer.parseInt(String.valueOf(context.getPara("RowIndex")));
		int columnIndex = Integer.parseInt(String.valueOf(context.getPara("ColumnIndex")));
		Element cellNode = (Element) root.selectSingleNode("Rows/Row[@RowIndex='" + rowIndex + "']/Cell[@CellIndex='" + columnIndex + "']");
		dataTable.clear();
		dataTable.append();
		Element columnExpand = Objects.isNull(cellNode) ? null : (Element) cellNode.selectSingleNode("ColumnExpand");
		String isColumnExpand = Objects.isNull(cellNode) ? "false" : cellNode.attributeValue("ColumnExpand");
		dataTable.setString("IsColumnExpand", isColumnExpand);
		if (columnExpand != null) {
			dataTable.setString("ColumnSourceType", columnExpand.attributeValue("ExpandSourceType"));
			dataTable.setString("ExpandType", columnExpand.attributeValue("ExpandType"));
			dataTable.setString("ColumnContent", columnExpand.getTextTrim());
		}

	}

	public void dealExcelSize(DataTable dataTable, Element root, DefaultContext context) {
		int rowIndex = Integer.parseInt(String.valueOf(context.getPara("RowIndex")));
		int columnIndex = Integer.parseInt(String.valueOf(context.getPara("ColumnIndex")));
		Element row = (Element) root.selectSingleNode("Rows/Row[@RowIndex='" + rowIndex + "']");
		Element column = (Element) root.selectSingleNode("Columns/Column[@ColumnIndex='" + columnIndex + "']");
		dataTable.clear();
		dataTable.append();
		if (row != null && column != null) {
			dataTable.setString("Height", ifEmptyGetDefault(row.attributeValue("Height"), "40"));
			dataTable.setString("Width", ifEmptyGetDefault(column.attributeValue("Width"), "80"));
		} else if (row != null) {
			dataTable.setString("Height", ifEmptyGetDefault(row.attributeValue("Height"), "40"));
			dataTable.setString("Width", "80");
		} else if (column != null) {
			dataTable.setString("Height", "40");
			dataTable.setString("Width", ifEmptyGetDefault(column.attributeValue("Width"), "80"));
		} else {
			dataTable.setString("Height", "40");
			dataTable.setString("Width", "80");
		}

	}

	public void dealExcelProp(DataTable dataTable, Element root) {
		dataTable.clear();
		if (root != null) {
			dataTable.append();
			String isNeedLoadData = ifEmptyGetDefault(root.attributeValue("NeedLoadData"), "false");
			dataTable.setString("FormKey", root.attributeValue("FormKey"));
			dataTable.setString("Key", root.attributeValue("Key"));
			dataTable.setString("Caption", root.attributeValue("Caption"));
			dataTable.setString("IsNeedLoadData", isNeedLoadData);
		}
	}

	public void dealExcelCellFormat(DataTable dataTable, Element root, DefaultContext context) {
		int rowIndex = Integer.parseInt(String.valueOf(context.getPara("RowIndex")));
		int columnIndex = Integer.parseInt(String.valueOf(context.getPara("ColumnIndex")));
		Element format = (Element) root.selectSingleNode("Rows/Row[@RowIndex='" + rowIndex + "']/Cell[@CellIndex='" + columnIndex + "']/Display/Format");
		dataTable.clear();
		if (format != null) {
			String dataType = ifEmptyGetDefault(format.attributeValue("DataType"), ExcelFormatDataType.STR_Text);
			if (ConstantUtil.TBL_EXCEL_CELL_FORMAT.equals(dataTable.getKey())) {
				dataTable.append();
				dataTable.setString("DataType", dataType);
				if (ExcelFormatDataType.STR_Dict.equals(dataType)) {
					dataTable.setString("ItemKey", format.attributeValue("ItemKey"));
					dataTable.setString("FieldKeys", format.attributeValue("FieldKeys"));
				} else if (ExcelFormatDataType.STR_Number.equals(dataType)) {
					dataTable.setString("FormatString", format.attributeValue("Format"));
				} else if (ExcelFormatDataType.STR_Money.equals(dataType)) {
					dataTable.setString("MoneyFormat", format.attributeValue("Format"));
				} else if (ExcelFormatDataType.STR_Date.equals(dataType)) {
					dataTable.setString("DateFormat", format.attributeValue("Format"));
				} else if ("MultiDict".equals(dataType)) {
					dataTable.setString("MultiDictItemKey", format.attributeValue("ItemKey"));
					dataTable.setString("MultiDictFieldKeys", format.attributeValue("FieldKeys"));
				}
			} else if (ConstantUtil.TBL_EXCEL_FORMAT_LIST.equals(dataTable.getKey()) && ExcelFormatDataType.STR_List.equals(dataType)) {
				List<Node> listItems = format.selectNodes("ListItem");
				if (CollectionUtils.isNotEmpty(listItems)) {
					for (Node node : listItems) {
						Element element = (Element) node;
						dataTable.append();
						dataTable.setString("ListValue", element.attributeValue("Value"));
						dataTable.setString("ListText", element.attributeValue("Text"));
					}
				}
			} else if (ConstantUtil.TBL_EXCEL_FORMAT_MULTI_LIST.equals(dataTable.getKey()) && ReportFormatDataType.STR_MultiList.equals(dataType)) {
				List<Node> listItems = format.selectNodes("ListItem");
				if (CollectionUtils.isNotEmpty(listItems)) {
					for (Node node : listItems) {
						Element element = (Element) node;
						dataTable.append();
						dataTable.setString("MultiValue", element.attributeValue("Value"));
						dataTable.setString("MultiText", element.attributeValue("Text"));
					}
				}
			}
		} else if (ConstantUtil.TBL_EXCEL_CELL_FORMAT.equals(dataTable.getKey())) {
			dataTable.append();
			dataTable.setString("DataType", ExcelFormatDataType.STR_Text);
		}
	}

	public void dealRowData(DataTable dataTable, Element row) {
		dataTable.clear();
		dataTable.append();
		// <Row Height="30" BackColor="0x4d001aff" DtlCountEveryPage="2" GroupLevel="1" LineBreak="true" TableKey="ERP_FormulaDefine" Type="TableTitleHead">
		String rowHeight = ifEmptyGetDefault(row.attributeValue("Height"), "0");
		String lineBreak = ifEmptyGetDefault(row.attributeValue("LineBreak"), "false");
		String isPageBreak = ifEmptyGetDefault(row.attributeValue("PageBreak"), "false");
		String groupLevel = ifEmptyGetDefault(row.attributeValue("GroupLevel"), "-1");
		String dtlCountEveryPage = ifEmptyGetDefault(row.attributeValue("DtlCountEveryPage"), "0");

		dataTable.setString("Height", rowHeight);
		dataTable.setString("RowType", row.attributeValue("Type"));
		dataTable.setString("BackColor", row.attributeValue("BackColor"));
		dataTable.setString("TableKey", row.attributeValue("TableKey"));
		dataTable.setString("IsLineBreak", lineBreak);
		dataTable.setString("IsPageBreak", isPageBreak);
		dataTable.setString("GroupKey", row.attributeValue("GroupKey"));
		dataTable.setString("GroupLevel", groupLevel);
		dataTable.setString("CountEveryPage", dtlCountEveryPage);
	}

	/**
	 * 处理section
	 */
	public void dealSectionData(DataTable dataTable, Element root) {
		// <Section Key="body_basic" Type="Paragraph" Caption="body_basic" MinFillRowCount="1" PageBreakPolicy="GroupHead">
		dataTable.clear();
		dataTable.append();
		String pageBreakPolicy = ifEmptyGetDefault(root.attributeValue("PageBreakPolicy"), ReportTablePageBreakPolicy.STR_None);
		String minFillRowCount = ifEmptyGetDefault(root.attributeValue("MinFillRowCount"), "0");
		String isSplitRow = ifEmptyGetDefault(root.attributeValue("SplitRow"), "false");
		dataTable.setString("Type", root.attributeValue("Type"));
		dataTable.setString("Key", root.attributeValue("Key"));
		dataTable.setString("Caption", root.attributeValue("Caption"));
		dataTable.setString("PageBreakPolicy", pageBreakPolicy);
		dataTable.setInt("MinFillRowCount", Integer.valueOf(minFillRowCount));
		dataTable.setString("IsSplitRow", isSplitRow);
		dataTable.setState(RowState.NORMAL);
	}

	/**
	 * 处理单元格样式
	 */
	public void dealCellStyle(DataTable dataTable, Element cell) {
		dataTable.clear();
		dataTable.append();
		// 一些默认值的处理
		String fillEmptyContent = ifEmptyGetDefault(cell.attributeValue("FillEmptyContent"), "false");
		String overflow = ifEmptyGetDefault(cell.attributeValue("Overflow"),
				String.valueOf(ContentOverflowType.None));
		dataTable.setObject("IsFillEmptyContent",Boolean.valueOf(fillEmptyContent)?1:0 );
		dataTable.setString("Overflow", overflow);
		Element display = (Element) cell.selectSingleNode("Display");
		String hAlign = HAlignment.STR_CENTER;
		String vAlign = VAlignment.STR_CENTER;
		String margin = "0";
		String showType = "TEXT";
		if (display != null) {
			hAlign = ifEmptyGetDefault(display.attributeValue("HAlign"), HAlignment.STR_CENTER);
			vAlign = ifEmptyGetDefault(display.attributeValue("VAlign"), VAlignment.STR_CENTER);
			String encodingType = ifEmptyGetDefault(display.attributeValue("EncodingType"), "");
			String errorCorrectionLevel = ifEmptyGetDefault(display.attributeValue("ErrorCorrectionLevel"), "");
			String enableZeroShow = ifEmptyGetDefault(display.attributeValue("EnableZeroShow"), "false");
			margin = ifEmptyGetDefault(display.attributeValue("Margin"), "0");
			showType = ifEmptyGetDefault(display.attributeValue("ShowType"), "TEXT");
			String[] padding = ifEmptyGetDefault(cell.attributeValue("Padding"), "0,0,0,0").split(",");
			dataTable.setString("LeftMargin", padding[0]);
			dataTable.setString("TopMargin", padding[1]);
			dataTable.setString("RightMargin", padding[2]);
			dataTable.setString("BottomMargin", padding[3]);

			dataTable.setString("BackColor", display.attributeValue("BackColor"));
			dataTable.setString("EncodingType", encodingType);
			dataTable.setString("ErrorCorrectionLevel", errorCorrectionLevel);

			dataTable.setObject("IsEnableZeroShow",Boolean.valueOf(enableZeroShow)?1:0 );
			dataTable.setString("ZeroShowString", display.attributeValue("ZeroShowString"));
			dataTable.setString("ForeColor", display.attributeValue("ForeColor"));
			Element font = (Element) display.selectSingleNode("Font");
			if (font != null) {
				String size = ifEmptyGetDefault(font.attributeValue("Size"), "-1");
				String bold = ifEmptyGetDefault(font.attributeValue("Bold"), "false");
				String italic = ifEmptyGetDefault(font.attributeValue("Italic"), "false");
				String fontName = ifEmptyGetDefault(font.attributeValue("Name"), "");
				dataTable.setString("Font", fontName);
				dataTable.setString("FontSize", size);
				dataTable.setInt("IsBold", Boolean.valueOf(bold)?1:0);
				dataTable.setInt("IsItalic", Boolean.valueOf(italic)?1:0);
			}
			Element imageStyle = (Element) display.selectSingleNode("ImageStyle");
			if (imageStyle != null) {
				dataTable.setString("ImageScaleType", ifEmptyGetDefault(imageStyle.attributeValue("ImageScaleType"), "Fit_XY"));
			}
		}
		dataTable.setString("HAlign", hAlign);
		dataTable.setString("VAlign", vAlign);
		dataTable.setString("ShowType", showType);
		dataTable.setString("Margin", margin);
	}

	/**
	 * 处理单元格数据
	 */
	public void dealCellInfoData(DataTable dataTable, Element cell) {
		dataTable.clear();
		dataTable.append();
		int isSummary = ifEmptyGetDefault(cell.attributeValue("IsSummary"), "false").equals(Boolean.TRUE.toString()) ? 1: 0;
		String contentType = ifEmptyGetDefault(cell.attributeValue("Type"), ReportCellContentType.STR_Text);
		String isPrimary = ifEmptyGetDefault(cell.attributeValue("IsPrimary"), "false");
		String sourceType = ifEmptyGetDefault(cell.attributeValue("SourceType"), "");
		String imageSourceType = ifEmptyGetDefault(cell.attributeValue("ImageSourceType"), ImageSourceType.STR_DATA);
		dataTable.setString("Key", cell.attributeValue("Key"));
		dataTable.setInt("IsSummary", isSummary);
		dataTable.setString("Caption", cell.attributeValue("Caption"));
		dataTable.setString("Type", contentType);
		dataTable.setString("IsPrimary", isPrimary);
		dataTable.setString("SourceType", sourceType);
		if (ReportCellContentType.STR_Image.equals(contentType)) {
			dataTable.setString("ImageSourceType", imageSourceType);
			dataTable.setString("Path", cell.attributeValue("Path"));
		}
		switch (sourceType) {
			case ReportContentSourceType.STR_Field:
				dataTable.setString("TableKey", cell.attributeValue("TableKey"));
				dataTable.setString("FieldKey", cell.attributeValue("FieldKey"));
				break;
			case ReportContentSourceType.STR_Formula:
				dataTable.setString("Formula", cell.attributeValue("Formula"));
				break;
			case ReportContentSourceType.STR_Interface:
				dataTable.setString("Impl", cell.attributeValue("Impl"));
				break;
			case ReportContentSourceType.STR_PageNo:
				dataTable.setString("PageNo", cell.attributeValue("PageNo"));
				break;
			case ReportContentSourceType.STR_System:
				dataTable.setString("SystemContent", cell.attributeValue("SystemContent"));
				break;
		}
		String groupType = ifEmptyGetDefault(cell.attributeValue("GroupType"), ReportCellGroupType.STR_None);
		String sortType = ifEmptyGetDefault(cell.attributeValue("SortType"), ReportCellSortType.STR_None);
		int mergeDetail = ifEmptyGetDefault(cell.attributeValue("MergeDetail"), "false").equals("true") ? 1: 0;
		int mergeTopGroup = ifEmptyGetDefault(cell.attributeValue("MergeTopGroup"), "false").equals("true") ? 1: 0;
		int mergeBottomGroup = ifEmptyGetDefault(cell.attributeValue("MergeBottomGroup"), "false").equals("true") ? 1: 0;
		String hasColumnExpand = ifEmptyGetDefault(cell.attributeValue("ColumnExpand"), "false");
		dataTable.setString("GroupType", groupType);
		dataTable.setString("SortType", sortType);
		dataTable.setInt("IsMergeDetail", mergeDetail);
		dataTable.setInt("IsMergeTopGroup", mergeTopGroup);
		dataTable.setInt("IsMergeBottomGroup", mergeBottomGroup);
		dataTable.setString("hasColumnExpand", hasColumnExpand);
		Element rowExpand = (Element) cell.selectSingleNode("RowGroup");
		if (rowExpand != null) {
			dataTable.setString("RowTag", rowExpand.attributeValue("Tag"));
			dataTable.setString("RowItemKey", rowExpand.attributeValue("ItemKey"));
			dataTable.setString("RowContent", rowExpand.getTextTrim());
		}
		Element columnExpand = (Element) cell.selectSingleNode("ColumnExpand");
		if (columnExpand != null) {
			String expandType = ifEmptyGetDefault(columnExpand.attributeValue("ExpandType"), "");
			String columnSourceType = ifEmptyGetDefault(columnExpand.attributeValue("SourceType"), "");
			dataTable.setString("ExpandType", expandType);
			dataTable.setString("ColumnSourceType", columnSourceType);
			dataTable.setString("ColumnKey", columnExpand.attributeValue("ColumnKey"));
			dataTable.setString("ColumnContent", columnExpand.getTextTrim());// CDATA
		}
	}

	/**
	 * 处理列属性
	 */
	public void dealColumnData(Element sectionNode, DataTable dataTable, int columnIndex) {
		Element column = (Element) sectionNode.selectNodes("Columns/Column").get(columnIndex);
		dataTable.clear();
		dataTable.append();
		String type = ifEmptyGetDefault(column.attributeValue("Type"), ReportColumnType.STR_Fix);
		String width = ifEmptyGetDefault(column.attributeValue("Width"), "0");
		String isLock = ifEmptyGetDefault(column.attributeValue("Lock"), "false");
		dataTable.setString("ColumnType", type);
		dataTable.setString("Width", width);
		dataTable.setString("Visible", column.attributeValue("Visible"));
		dataTable.setString("ExtendKey", column.attributeValue("ExpandKey"));
		dataTable.setString("IsLock", isLock);
	}

	/**
	 * 加载报表数据源
	 */
	private void loadReportTableCollection(DataTable dataTable, DefaultContext context, Document doc,
										   Element root, XmlTree xmlTree, MetaTable reportFieldsTable) throws Throwable {
		List<Node> nodes = root.selectNodes("//Table/@Key");
		DataTable fieldsTable = DataTableUtil.newEmptyDataTable(reportFieldsTable);
		String key1 = fieldsTable.getKey();
		for (Node node : nodes) {
			TagNode tagNode = xmlTree.getTagNode(ConstantUtil.TABLE + "@" + node.getStringValue());
			Map<String, String> attributes = tagNode.getAttributes();
			int row = dataTable.append();
			Long oid = context.applyNewOID();
			dataTable.setLong(row, ConstantUtil.OID, oid);
			dataTable.setString(row, "TableMark", attributes.get("Key"));
			dataTable.setString(row, "TableName", ifEmptyGetDefault(attributes.get("Caption"), ""));
			dataTable.setString(row, "TableKey", attributes.get("DBTableKey"));
			dataTable.setString(row, "Description", attributes.get("Description"));
			dataTable.setString(row, "SourceType", ifEmptyGetDefault(attributes.get("SourceType"), ""));
			dataTable.setString(row, "Statement", attributes.get("Statement"));
			dataTable.setString(row, "Filter", attributes.get("Filter"));
			dataTable.setState(RowState.NORMAL);

			List<AbstractNode> fieldNodes = tagNode.getChildren();
			if (fieldNodes != null) {
				for (AbstractNode fieldNode : fieldNodes) {
					if (fieldNode instanceof TagNode && "Field".equalsIgnoreCase(((TagNode) fieldNode).getTagName())) {
						Map<String, String> fieldAttributes = ((TagNode) fieldNode).getAttributes();
						int append = fieldsTable.append();
						fieldsTable.setLong(append, ConstantUtil.POID, oid);
						fieldsTable.setString(append, "ColumnKey", fieldAttributes.get("Key"));
						fieldsTable.setString(append, "ColumnName", fieldAttributes.get("Caption"));
						fieldsTable.setString(append, "FieldKey", fieldAttributes.get("DBFieldKey"));
						fieldsTable.setString(append, "Description", fieldAttributes.get("Description"));
						fieldsTable.setState(RowState.NORMAL);
					}
				}
			}
		}
		fieldsTable.batchUpdate();
		doc.add(key1, fieldsTable);
	}

	/**
	 * 加载报表数据格式
	 */
	private void loadReportFormat(Element format, DataTable dataTable) {
		dataTable.clear();
		if (format != null) {
			String dataType = format.attributeValue("DataType");
			if (ConstantUtil.TBL_REPORT_FORMAT.equals(dataTable.getKey())) {
				dataTable.append();
				dataTable.setString("Transformer", format.attributeValue("Transformer"));
				dataTable.setString("DataType", dataType);
				if (ReportFormatDataType.STR_Dict.equals(dataType)) {
					dataTable.setString("ItemKey", format.attributeValue("ItemKey"));
					dataTable.setString("FieldKeys", format.attributeValue("FieldKeys"));
				} else if (ReportFormatDataType.STR_MultiDict.equals(dataType)) {
					dataTable.setString("MultiDictItemKey", format.attributeValue("ItemKey"));
					dataTable.setString("MultiDictFieldKeys", format.attributeValue("FieldKeys"));
				} else if (ReportFormatDataType.STR_Number.equals(dataType)) {
					dataTable.setString("FormatString", format.attributeValue("FormatString"));
				} else if (ReportFormatDataType.STR_Money.equals(dataType)) {
					dataTable.setString("MoneyFormat", format.attributeValue("FormatString"));
				} else if (ReportFormatDataType.STR_Date.equals(dataType)) {
					dataTable.setString("DateFormat", format.attributeValue("FormatString"));
				}
			} else if ("ED_ReportFormatList".equals(dataTable.getKey()) && ReportFormatDataType.STR_List.equals(dataType)) {
				List<Node> listItems = format.selectNodes("ListItem");
				if (Objects.nonNull(listItems)) {
					for (Node node : listItems) {
						Element element = (Element) node;
						dataTable.append();
						dataTable.setString("ListValue", element.attributeValue("Value"));
						dataTable.setString("ListText", element.attributeValue("Text"));
					}
				}
			} else if (ConstantUtil.TBL_REPORT_FORMAT_MULTI_LIST.equals(dataTable.getKey()) && ReportFormatDataType.STR_MultiList.equals(dataType)) {
				List<Node> listItems = format.selectNodes("ListItem");
				if (CollectionUtils.isNotEmpty(listItems)) {
					for (Node node : listItems) {
						Element element = (Element) node;
						dataTable.append();
						dataTable.setString("MultiValue", element.attributeValue("Value"));
						dataTable.setString("MultiText", element.attributeValue("Text"));
					}
				}
			}
		}
	}

	/**
	 * 获取单元格
	 */
	public Element getCell(int rowIndex, int columnIndex, Element sectionNode) {
		int columnCount = sectionNode.selectNodes("Columns/Column").size();
		int index = rowIndex * columnCount + columnIndex;
		Element cellNode = (Element) sectionNode.selectNodes("Rows/Row/Cell").get(index);
		if ("true".equals(cellNode.attributeValue("IsMerged")) && !"true".equals(cellNode.attributeValue("IsMergedHead"))) {
			int mergedColumnSpan = Integer.parseInt(ifEmptyGetDefault(cellNode.attributeValue("MergedColumnSpan"), "0"));
			int mergedRowSpan = Integer.parseInt(ifEmptyGetDefault(cellNode.attributeValue("MergedRowSpan"), "0"));
			index = (rowIndex - mergedRowSpan) * columnCount + (columnIndex - mergedColumnSpan);
			cellNode = (Element) sectionNode.selectNodes("Rows/Row/Cell").get(index);
		}
		return cellNode;
	}

	private void loadDropdownItem(DataTable dataTable, MetaComponent metaComponent) {
		MetaDropdownItemCollection items = ((MetaDropdownButton) metaComponent).getItemCollection();
		for (MetaDropdownItem metaDropdownItem : items) {
			int row = dataTable.append();
			String key = metaDropdownItem.getKey();
			String textContent = metaDropdownItem.getText();
			MetaBaseScript onClick = items.get(row).getOnClick();

			dataTable.setString(row, "Key", key);
			dataTable.setObject(row, "Separator", metaDropdownItem.getSeparator());
			dataTable.setString(row, "TextContent", textContent);
			if (onClick != null) {
				dataTable.setString(row, "OnClick", onClick.getContent());
			}
			dataTable.setState(RowState.NORMAL);
		}
	}

	private void getMetaGridColumnResurt(MetaGridColumnCollection columnCollection, LinkedHashMap<Integer, HashMap<String, MetaGridColumn>> resurt) {
		if (Objects.isNull(columnCollection)) {
			return;
		}

		for (int i = 0; i < columnCollection.size(); i++) {
			MetaGridColumn metaGridColumn = columnCollection.get(i);
			String key = metaGridColumn.getMetaKey();
			HashMap<String, MetaGridColumn> map = new HashMap<>();
			map.put(key, metaGridColumn);
			if (metaGridColumn.getColumnCollection() != null) {
				getColum(metaGridColumn.getColumnCollection(), map);
			}
			resurt.put(i, map);
		}


	}

	private void getColum(MetaGridColumnCollection columnCollection, HashMap<String, MetaGridColumn> map) {
		for (int i = 0; i < columnCollection.size(); i++) {
			MetaGridColumn metaGridColumn = columnCollection.get(i);
			String key = metaGridColumn.getMetaKey();
			map.put(key, metaGridColumn);
			if (metaGridColumn.getColumnCollection() != null) {
				getColum(metaGridColumn.getColumnCollection(), map);
			}

		}
	}

	private void loadGridColumn(MetaForm ownerMetaForm, DataTable dataTable, String panelKey, String parentKey) throws Throwable {
		String extend = ownerMetaForm.getExtend();
		DataTableMetaData dataTableMetaData = dataTable.getMetaData();
		int row = dataTable.append();
		for (int i = 0, len = dataTableMetaData.getColumnCount(); i < len; i++) {
			ColumnInfo columnInfo = dataTableMetaData.getColumnInfo(i);
			String columnKey = columnInfo.getColumnKey();
			if (StringUtils.equalsAnyIgnoreCase(columnKey, "GetWSizeType", "NewExtFieldFlag")) {
				continue;
			}
			try {
				MetaGridColumn gridMetaColumn = IDLookup.reloadIDLookup(ownerMetaForm).getGridMetaColumnByKey(panelKey);
				MetaGrid metaGrid;
				metaGrid = (MetaGrid) getComponentByKey(ownerMetaForm, parentKey);
				MetaGridColumnCollection columnCollection = metaGrid.getColumnCollection();
				gridMetaColumn = getMetaGridColumn(panelKey, gridMetaColumn, columnCollection);

				boolean newExtField = false;
				if (StringUtils.isBlank(extend)) {
					MetaGridCell gridCell = ownerMetaForm.metaGridCellByKey(gridMetaColumn.getKey());
					if (Objects.nonNull(gridCell)) {
						newExtField = gridCell.isNewExtField();
					} else {
						newExtField = Objects.isNull(IDLookup.reloadIDLookup(ownerMetaForm).getGridMetaColumnByKey(panelKey));
					}
				}
				dataTable.setInt(row, "NewExtFieldFlag", newExtField ? 1 : 0);

				Class<MetaGridColumn> instance = MetaGridColumn.class;
				Object invoke = getPropertiesValue(instance, columnKey, gridMetaColumn);
				if (invoke instanceof DefSize) {
					int size1 = ((DefSize) invoke).getSize();
					if ("GetWidth".equalsIgnoreCase(columnKey)) {
						dataTable.setObject(row, columnKey, size1);
						dataTable.setObject(row, "GetWSizeType", "px");
					}
				} else if ("GetColumnExpand".equalsIgnoreCase(columnKey)) {
					if (invoke != null) {
						dataTable.setObject(row, columnKey, "已设置");
					} else {
						dataTable.setObject(row, columnKey, "请点击设置");
					}
				} else if ("GetColumnType".equalsIgnoreCase(columnKey)) {
					dataTable.setObject(row, columnKey, ColumnType.toString((Integer) invoke));
				} else if (StringUtils.equalsIgnoreCase(columnKey, "GetSortable")) {
					dataTable.setObject(row, columnKey, Objects.equals(invoke, Boolean.TRUE));
				} else if (invoke instanceof MetaBaseScript){
					String script = ((MetaBaseScript) invoke).getContent();
					dataTable.setObject(row, columnKey, script);
				} else {
					if (Objects.isNull(invoke)) {
						invoke = this.getDefaultValue(columnKey);
					}
					dataTable.setObject(row, columnKey, invoke);
				}
			} catch (Exception e) {
				dataTable.setObject(row, columnKey, ConstantUtil.NODESIGNFIELD);
			}
		}
		dataTable.setState(RowState.NORMAL);
	}

	private void loadListViewColumn(MetaForm ownerMetaForm, DataTable dataTable, String panelKey) throws Throwable {
		DataTableMetaData dataTableMetaData = dataTable.getMetaData();
		int row = dataTable.append();
		for (int i = 0, len = dataTableMetaData.getColumnCount(); i < len; i++) {
			ColumnInfo columnInfo = dataTableMetaData.getColumnInfo(i);
			String columnKey = columnInfo.getColumnKey();
			if ("GetWSizeType".equalsIgnoreCase(columnKey)) {
				continue;
			}
			try {
				IDLookup idLookup = IDLookup.reloadIDLookup(ownerMetaForm);
				MetaListViewColumn listViewColumn = idLookup.getListViewColumnByKey(panelKey);
				Class<MetaListViewColumn> instance = MetaListViewColumn.class;
				String methodName = columnKey;
				if (StringUtils.equals(columnKey, "GetDataTableKey")) {
					methodName = "GetTableKey";
				}
				Object invoke = getPropertiesValue(instance, methodName, listViewColumn);
				if (invoke instanceof DefSize) {
					int size1 = ((DefSize) invoke).getSize();
					if ("GetWidth".equalsIgnoreCase(columnKey)) {
						dataTable.setObject(row, columnKey, size1);
						dataTable.setObject(row, "GetWSizeType", "px");
					}
				} else if (invoke instanceof MetaBaseScript) {
					dataTable.setObject(row, columnKey, ((MetaBaseScript) invoke).getContent());
				} else if ("GetDataColumnKey".equalsIgnoreCase(columnKey)) {
					if (String.valueOf(invoke).endsWith(MetaFormNODBProcess.STR_NODBTable_Profix) || StringUtils.isEmpty(String.valueOf(invoke))) {
						dataTable.setString(row, i, "无字段");
					} else {
						if (StringUtils.isBlank((String) invoke)) {
							dataTable.setString(row, i, "无字段");
						} else {
							dataTable.setString(row, i, (String) invoke);
						}
					}
				} else if ("GetDataTableKey".equalsIgnoreCase(columnKey)) {
					if (String.valueOf(invoke).endsWith(MetaFormNODBProcess.STR_NODBTable_Profix) || StringUtils.isEmpty(String.valueOf(invoke))) {
						dataTable.setString(row, i, "无数据表");
					} else {
						if (StringUtils.isBlank((String) invoke)) {
							dataTable.setString(row, i, "无数据表");
						} else {
							dataTable.setString(row, i, (String) invoke);
						}
					}
				} else if ("GetColumnType".equalsIgnoreCase(columnKey)) {
					dataTable.setString(row, i, ControlType.toString((Integer) invoke));
				} else {
					if (Objects.isNull(invoke)) {
						invoke = this.getDefaultValue(columnKey);
					}
					dataTable.setObject(row, columnKey, invoke);
				}
			} catch (Exception e) {
				dataTable.setObject(row, columnKey, ConstantUtil.NODESIGNFIELD);
			}
		}
		dataTable.setState(RowState.NORMAL);
	}

	private void loadRowExpand(MetaForm ownerMetaForm, DataTable dataTable, String parentKey, String rowIndex) throws Throwable {
		DataTableMetaData dataTableMetaData = dataTable.getMetaData();
		int row = dataTable.append();
		for (int i = 0, len = dataTableMetaData.getColumnCount(); i < len; i++) {
			ColumnInfo columnInfo = dataTableMetaData.getColumnInfo(i);
			String columnKey = columnInfo.getColumnKey();
			try {
				MetaGrid metaGrid = (MetaGrid) getComponentByKey(ownerMetaForm, parentKey);
				MetaGridRow metaRow = metaGrid.getMetaRow(Integer.parseInt(rowIndex));
				MetaRowExpand rowExpand = metaRow.getRowExpand();
				if (Objects.isNull(rowExpand)) {
					rowExpand = new MetaRowExpand();
				}
				if ("GetExpand".equalsIgnoreCase(columnKey)) {
					dataTable.setObject(row, columnKey, (rowExpand.getContent()));
					continue;
				}
				Class<MetaRowExpand> instance = MetaRowExpand.class;
				Object invoke = getPropertiesValue(instance, columnKey, rowExpand);
				if (invoke instanceof MetaBaseScript) {
					dataTable.setObject(row, columnKey, ((MetaBaseScript) invoke).getContent());
				} else if ("GetExpandType".equalsIgnoreCase(columnKey)) {
					dataTable.setObject(row, columnKey, RowExpandType.toString((Integer) invoke));
				} else {
					if (Objects.isNull(invoke)) {
						invoke = this.getDefaultValue(columnKey);
					}
					dataTable.setObject(row, columnKey, invoke);
				}
			} catch (Exception e) {
				dataTable.setObject(row, columnKey, ConstantUtil.NODESIGNFIELD);
			}
		}
		dataTable.setState(RowState.NORMAL);
	}

	private void loadGridRow(MetaForm ownerMetaForm, DataTable dataTable, String parentKey, String rowIndex) throws Throwable {
		DataTableMetaData dataTableMetaData = dataTable.getMetaData();
		int row = dataTable.append();
		for (int i = 0, len = dataTableMetaData.getColumnCount(); i < len; i++) {
			ColumnInfo columnInfo = dataTableMetaData.getColumnInfo(i);
			String columnKey = columnInfo.getColumnKey();
			if ("ExtFieldFlag".equalsIgnoreCase(columnKey)) {
				dataTable.setObject(row, "ExtFieldFlag",StringUtils.isNotEmpty(ownerMetaForm.getExtend()) );
				continue;
			}
			try {

				MetaGrid metaGrid = (MetaGrid) getComponentByKey(ownerMetaForm, parentKey);
				MetaGridRow metaRow = metaGrid.getMetaRow(Integer.parseInt(rowIndex));
				Class<MetaGridRow> instance = MetaGridRow.class;
				Object invoke = getPropertiesValue(instance, columnKey, metaRow);
				if (invoke instanceof MetaBaseScript) {
					dataTable.setObject(row, columnKey, ((MetaBaseScript) invoke).getContent());
				} else if ("GetRowType".equalsIgnoreCase(columnKey)) {
					dataTable.setObject(row, columnKey, RowType.toString((Integer) invoke));
				} else if ("GetCheckRuleCollection".equalsIgnoreCase(columnKey)) {
					dataTable.setString(row, i, Objects.isNull(invoke) ? "" : "UICheckRuleCollection");
				} else if ("GetTableKey".equalsIgnoreCase(columnKey)) {
					if (String.valueOf(invoke).endsWith(MetaFormNODBProcess.STR_NODBTable_Profix) || StringUtils.isEmpty(String.valueOf(invoke))) {
						dataTable.setString(row, i, "无数据表");
					} else {
						if (StringUtils.isBlank((String) invoke)) {
							dataTable.setString(row, i, "无数据表");
						} else {
							dataTable.setString(row, i, (String) invoke);
						}
					}
				} else if ("GetLinkType".equalsIgnoreCase(columnKey)) {
					dataTable.setObject(row, columnKey, SubDetailLinkType.toString((Integer) invoke));
				} else {
					if (Objects.isNull(invoke)) {
						invoke = this.getDefaultValue(columnKey);
					}
					dataTable.setObject(row, columnKey, invoke);
				}
			} catch (Exception e) {
				dataTable.setObject(row, columnKey, ConstantUtil.NODESIGNFIELD);
			}
		}
		dataTable.setState(RowState.NORMAL);
	}

	private void loadGridCell(MetaForm ownerMetaForm, DataTable dataTable, String panelKey, String parentKey) throws Throwable {
		String extend = ownerMetaForm.getExtend();
		DataTableMetaData dataTableMetaData = dataTable.getMetaData();
		int row = dataTable.append();
		MetaForm newMetaForm = ownerMetaForm;
		MetaForm oldMetaForm = ownerMetaForm;
		for (int i = 0, len = dataTableMetaData.getColumnCount(); i < len; i++) {
			ColumnInfo columnInfo = dataTableMetaData.getColumnInfo(i);
			String columnKey = columnInfo.getColumnKey();
			if (StringUtils.equalsAnyIgnoreCase(columnKey, "NewExtFieldFlag")) {
				continue;
			}
			if (columnKey.endsWith("Dependency") || "IsVestDeleted".equals(columnKey)|| "IsNewExtField".equals(columnKey)) {
				ownerMetaForm = newMetaForm;
			} else {
				ownerMetaForm = oldMetaForm;
			}
			IDLookup idLookup = IDLookup.reloadIDLookup(ownerMetaForm);
			MetaGridCell gridCellByKey = idLookup.getGridCellByKey(panelKey);
			try {
				if ("IsVestDeleted".equalsIgnoreCase(columnKey) || "IsNewExtField".equalsIgnoreCase(columnKey) ) {
					if (Objects.nonNull(gridCellByKey)) {//找到了
						if (StringUtils.isBlank(extend)){//原单
							dataTable.setObject(row, "IsNewExtField", false);
							dataTable.setObject(row, "IsVestDeleted", false);
							dataTable.setInt(row, "NewExtFieldFlag", 0);
						} else {//马甲中找到
							MetaForm newMetaFormSrc = NewFormCmd.loadMetaForm(ownerMetaForm.getExtend());
							IDLookup idLookupSrc = IDLookup.reloadIDLookup(newMetaFormSrc);
							MetaGridCell gridCellByKeySrc = idLookupSrc.getGridCellByKey(panelKey);
							if (gridCellByKeySrc != null) {//原单也找到了
								dataTable.setObject(row, "IsNewExtField", false);
								dataTable.setObject(row, "IsVestDeleted", false);
								dataTable.setInt(row, "NewExtFieldFlag", 0);
							} else {
								dataTable.setObject(row, "IsNewExtField", true);
								dataTable.setObject(row, "IsVestDeleted", false);
								dataTable.setInt(row, "NewExtFieldFlag", 0);
							}
						}
					} else {//没找到
						if (StringUtils.isBlank(extend)){//原单
							dataTable.setObject(row, "IsNewExtField", false);
							dataTable.setObject(row, "IsVestDeleted", true);
							dataTable.setInt(row, "NewExtFieldFlag", 0);
						} else {//马甲
							MetaForm newMetaFormSrc = NewFormCmd.loadMetaForm(ownerMetaForm.getExtend());
							IDLookup idLookupSrc = IDLookup.reloadIDLookup(newMetaFormSrc);
							MetaGridCell gridCellByKeySrc = idLookupSrc.getGridCellByKey(panelKey);
							if (gridCellByKeySrc != null) {//原单找到了，马甲没有
								dataTable.setObject(row, "IsNewExtField", false);
								dataTable.setObject(row, "IsVestDeleted", true);
								dataTable.setInt(row, "NewExtFieldFlag", 0);
							} else {//原单没有，马甲没有
								dataTable.setObject(row, "IsNewExtField", false);
								dataTable.setObject(row, "IsVestDeleted", false);
								dataTable.setInt(row, "NewExtFieldFlag", 0);
							}
						}
					}
				} else {
					Class<MetaGridCell> instance = MetaGridCell.class;
					Object invoke = getPropertiesValue(instance, columnKey, gridCellByKey);
					if (invoke instanceof MetaBaseScript) {
						dataTable.setObject(row, columnKey, ((MetaBaseScript) invoke).getContent());
					} else if ("GetCellType".equalsIgnoreCase(columnKey)) {
						dataTable.setObject(row, columnKey, ControlType.toString((Integer) invoke));
					} else if ("GetCellSortType".equalsIgnoreCase(columnKey)) {
						dataTable.setObject(row, columnKey, SortType.toString((Integer) invoke));
					} else if ("GetCellGroupType".equalsIgnoreCase(columnKey)) {
						dataTable.setObject(row, columnKey, GroupType.toString((Integer) invoke));
					} else if ("IsSelect".equalsIgnoreCase(columnKey)) {
						dataTable.setObject(row, columnKey, (Boolean)invoke? 1 : 0);
					} else {
						if (Objects.isNull(invoke)) {
							invoke = this.getDefaultValue(columnKey);
						}
						dataTable.setObject(row, columnKey, invoke);
					}
				}
			} catch (Exception e) {
				dataTable.setObject(row, columnKey, ConstantUtil.NODESIGNFIELD);
			}
			if (Objects.nonNull(gridCellByKey)) {
				String gridKeyByFieldKey = idLookup.getGridKeyByFieldKey(panelKey);
				MetaGrid metaGrid = (MetaGrid) ownerMetaForm.componentByKey(gridKeyByFieldKey);
				if ("GetTableKey".equalsIgnoreCase(columnKey) || "GetRowType".equalsIgnoreCase(columnKey)) {
					for (MetaGridRow metaGridRow : metaGrid.getRowCollection()) {
						if (metaGridRow.getKey().equalsIgnoreCase(parentKey))
							if ("GetRowType".equalsIgnoreCase(columnKey)) {
								dataTable.setObject(row, columnKey, RowType.toString(metaGridRow.getRowType()));
								break;
							} else if ("GetTableKey".equalsIgnoreCase(columnKey)) {
								dataTable.setObject(row, columnKey, metaGridRow.getTableKey());
								break;
							}
					}
				}
			}
		}
		dataTable.setState(RowState.NORMAL);
	}

	private void loadGridCellFormat(MetaForm ownerMetaForm, DataTable dataTable, String panelKey) throws Throwable {
		DataTableMetaData dataTableMetaData = dataTable.getMetaData();
		int row = dataTable.append();
		for (int i = 0, len = dataTableMetaData.getColumnCount(); i < len; i++) {
			ColumnInfo columnInfo = dataTableMetaData.getColumnInfo(i);
			String columnKey = columnInfo.getColumnKey();
			try {
				MetaGridCell gridCellByKey = IDLookup.reloadIDLookup(ownerMetaForm).getGridCellByKey(panelKey);
				MetaGridCellFormat format1 = gridCellByKey.getFormat();
				if (Objects.isNull(format1)) {
					format1 = new MetaGridCellFormat();
				}
				Class<MetaGridCellFormat> instance = MetaGridCellFormat.class;
				Object invoke = getPropertiesValue(instance, columnKey, format1);
				if (invoke instanceof MetaBaseScript) {
					dataTable.setObject(row, columnKey, ((MetaBaseScript) invoke).getContent());
				} else if ("GetVAlign".equalsIgnoreCase(columnKey)) {
					dataTable.setObject(row, columnKey, VAlignment.toString((Integer) invoke));
				} else {
					if (Objects.isNull(invoke)) {
						invoke = this.getDefaultValue(columnKey);
					}
					dataTable.setObject(row, columnKey, HAlignment.toString((Integer) invoke));
				}
			} catch (Exception e) {
				dataTable.setObject(row, columnKey, ConstantUtil.NODESIGNFIELD);
			}
		}
		dataTable.setState(RowState.NORMAL);
	}

	private void loadFont(MetaForm ownerMetaForm, DataTable dataTable, String panelKey) throws Throwable {
		DataTableMetaData dataTableMetaData = dataTable.getMetaData();
		int row = dataTable.append();
		for (int i = 0, len = dataTableMetaData.getColumnCount(); i < len; i++) {
			ColumnInfo columnInfo = dataTableMetaData.getColumnInfo(i);
			String columnKey = columnInfo.getColumnKey();
			try {
				MetaComponent componentByKey = getComponentByKey(ownerMetaForm, panelKey);
				MetaFont font = componentByKey.ensureFormat().getFont();
				if (Objects.isNull(font)) {
					font = new MetaFont();
				}
				Class<? extends MetaFont> instance = font.getClass();
				Object invoke = getPropertiesValue(instance, columnKey, font);
				if (invoke instanceof MetaBaseScript) {
					dataTable.setObject(row, columnKey, ((MetaBaseScript) invoke).getContent());
				} else {
					if (Objects.isNull(invoke)) {
						invoke = this.getDefaultValue(columnKey);
					}
					dataTable.setObject(row, columnKey, invoke);
				}
			} catch (Exception e) {
				dataTable.setObject(row, columnKey, ConstantUtil.NODESIGNFIELD);
			}
		}
		dataTable.setState(RowState.NORMAL);
	}

	private void loadFormat(MetaForm ownerMetaForm, DataTable dataTable, String panelKey) throws Throwable {
		DataTableMetaData dataTableMetaData = dataTable.getMetaData();
		int row = dataTable.append();
		for (int i = 0, len = dataTableMetaData.getColumnCount(); i < len; i++) {
			ColumnInfo columnInfo = dataTableMetaData.getColumnInfo(i);
			String columnKey = columnInfo.getColumnKey();
			try {
				MetaFormat format;
				MetaComponent componentByKey = getComponentByKey(ownerMetaForm, panelKey);
				if (Objects.isNull(componentByKey)) {
					MetaListViewColumn listViewColumn = IDLookup.reloadIDLookup(ownerMetaForm).getListViewColumnByKey(panelKey);
					format = listViewColumn.ensureFormat();
				} else {
					format = componentByKey.ensureFormat();
				}
				Class<? extends MetaFormat> instance = format.getClass();
				Object invoke = getPropertiesValue(instance, columnKey, format);
				if (invoke instanceof MetaBaseScript) {
					dataTable.setObject(row, columnKey, ((MetaBaseScript) invoke).getContent());
				} else if ("GetHAlign".equalsIgnoreCase(columnKey)) {
					Integer invoke1 = (Integer) invoke;
					if (invoke1 == -1) {
						dataTable.setObject(row, columnKey, invoke1);
					} else {
						dataTable.setObject(row, columnKey, HAlignment.toString(invoke1));
					}
				} else if ("GetVAlign".equalsIgnoreCase(columnKey)) {
					dataTable.setObject(row, columnKey, VAlignment.toString((Integer) invoke));
				} else {
					if (Objects.isNull(invoke)) {
						invoke = this.getDefaultValue(columnKey);
					}
					dataTable.setObject(row, columnKey, invoke);
				}
			} catch (Exception e) {
				dataTable.setObject(row, columnKey, ConstantUtil.NODESIGNFIELD);
			}
		}
		dataTable.setState(RowState.NORMAL);
	}

	private void loadThisProperties(MetaForm ownerMetaForm, DataTable dataTable, String panelKey) throws Throwable {
		DataTableMetaData dataTableMetaData = dataTable.getMetaData();
		int row = dataTable.append();
		for (int i = 0, len = dataTableMetaData.getColumnCount(); i < len; i++) {
			ColumnInfo columnInfo = dataTableMetaData.getColumnInfo(i);
			String columnKey = columnInfo.getColumnKey();
			Object result ;
			if ("Layout".equalsIgnoreCase(columnKey) || "GetSplitSize".equalsIgnoreCase(columnKey)) {
				result = "请点击设置";
			} else {
				Object invoke;
				AbstractMetaObject componentByKey = getComponentByKey(ownerMetaForm, panelKey);
				if (Objects.isNull(componentByKey)) {
					componentByKey = ownerMetaForm.metaGridCellByKey(panelKey);
				}
				if (Objects.isNull(componentByKey)) {
					componentByKey = getComponent(ownerMetaForm, panelKey);
				}

				try {
					Class<? extends AbstractMetaObject> instance = componentByKey.getClass();
					if ("GetFilter".equalsIgnoreCase(columnKey) || "GetExtOpts".equalsIgnoreCase(columnKey) || "GetTraceCollection".equalsIgnoreCase(columnKey) || "GetMetaExtraLayout".equalsIgnoreCase(columnKey)) {
						invoke = getPropertiesValue(instance, columnKey, componentByKey);
						if (invoke != null){
							invoke = "已设置";
						}else {
							invoke = "请点击设置";
						}
					} else {
						invoke = getPropertiesValue(instance, columnKey, componentByKey);
					}


				} catch (Exception e) {
					invoke = ConstantUtil.NODESIGNFIELD;
				}
				if (Objects.equals(invoke, ConstantUtil.NODESIGNFIELD) && componentByKey instanceof MetaGridCell) {
					try {
						AbstractMetaObject properties = ((MetaGridCell) componentByKey).getProperties();
						invoke = getPropertiesValue(properties.getClass(), columnKey, properties);
					} catch (Exception e) {
						dataTable.setObject(row, columnKey, ConstantUtil.NODESIGNFIELD);
						continue;
					}
				}
				if (Objects.equals(invoke, ConstantUtil.NODESIGNFIELD)) {
					dataTable.setObject(row, columnKey, invoke);
					continue;
				}
				if ("GetTabMode".equalsIgnoreCase(columnKey)) {
					result = TabMode.toString((Integer) invoke);
				} else if ("GetSelectMode".equalsIgnoreCase(columnKey)) {
					result = SelectionMode.toString((Integer) invoke);
				} else if ("GetPageLoadType".equalsIgnoreCase(columnKey)) {
					result = PageLoadType.toString((Integer) invoke);
				} else if ("GetTableKey".equalsIgnoreCase(columnKey)) {
					if (String.valueOf(invoke).endsWith(MetaFormNODBProcess.STR_NODBTable_Profix) || StringUtils.isEmpty(String.valueOf(invoke))) {
						result = "无数据表";
					} else {
						if (StringUtils.isBlank((String) invoke)) {
							result = "无数据表";
						} else {
							result =  invoke;
						}
					}
				} else if ("GetTabPosition".equalsIgnoreCase(columnKey)) {
					result = DirectionType.toString((Integer) invoke);
				} else if ("GetStyle".equalsIgnoreCase(columnKey)) {
					result = ContainerStyle.toString((Integer) invoke);
				} else if (invoke instanceof MetaBaseScript) {
					result = ((MetaBaseScript) invoke).getContent();
				} else if ("GetIconLocation".equalsIgnoreCase(columnKey)) {
					result = IconLocationType.toString((Integer) invoke);
				} else if ("GetOrientation".equalsIgnoreCase(columnKey)) {
					result = OrientationType.toString((Integer) invoke);
				} else if ("GetOption".equalsIgnoreCase(columnKey)) {
					invoke = Objects.isNull(invoke) ? "insert,delete,shift,bestWidth,frozenColumn,zoom,variantSet,filter,search" : invoke;
					result =  invoke;
				} else {
					if (Objects.isNull(invoke)) {
						invoke = this.getDefaultValue(columnKey);
					}
					result =  invoke;
				}
			}
			dataTable.setObject(row, i, result);
		}
		dataTable.setState(RowState.NORMAL);
	}

	private void loadPanel(MetaForm ownerMetaForm, DataTable dataTable, String panelKey) throws Throwable {
		DataTableMetaData dataTableMetaData = dataTable.getMetaData();
		int row = dataTable.append();
		for (int i = 0, len = dataTableMetaData.getColumnCount(); i < len; i++) {
			ColumnInfo columnInfo = dataTableMetaData.getColumnInfo(i);
			String columnKey = columnInfo.getColumnKey();
			try {
				MetaComponent componentByKey = getComponentByKey(ownerMetaForm, panelKey);
				if ("OrderInfo".equalsIgnoreCase(columnKey)) {
					String orderInfo = DesignIOMetaUtil.getChildrenOrderInfo((MetaPanel) componentByKey);
					dataTable.setString(row, i, orderInfo);
				} else {
					Object invoke = getPropertiesValue(MetaPanel.class, columnKey, componentByKey);
					if ("GetOverflowX".equalsIgnoreCase(columnKey) || "GetOverflowY".equalsIgnoreCase(columnKey)) {
						dataTable.setObject(row, columnKey, ScrollType.toString((Integer) invoke));
					} else if ("GetBackImagePosition".equalsIgnoreCase(columnKey)) {
						dataTable.setObject(row, columnKey, DirectionType.toString((Integer) invoke));
					} else {
						if (invoke instanceof MetaBaseScript) {
							dataTable.setObject(row, columnKey, ((MetaBaseScript) invoke).getContent());
						} else {
							if (Objects.isNull(invoke)) {
								invoke = this.getDefaultValue(columnKey);
							}
							dataTable.setObject(row, columnKey, invoke);
						}
					}
				}
			} catch (Exception e) {
				dataTable.setObject(row, columnKey, ConstantUtil.NODESIGNFIELD);
			}
		}
		dataTable.setState(RowState.NORMAL);
	}

	private void loadCarouselProperties(MetaForm erpMetaForm, String erpCompKey, DataTable designDataTable) throws Throwable {
		int rowIndex = designDataTable.append();

		DataTableMetaData designMetaData = designDataTable.getMetaData();
		MetaComponent metaComponent = getComponentByKey(erpMetaForm, erpCompKey);

		if (metaComponent != null && metaComponent.getControlType() == ControlType.CAROUSEL) {
			MetaCarousel metaCarousel = (MetaCarousel) metaComponent;
			for (int i = 0; i < designMetaData.getColumnCount(); i++) {
				ColumnInfo columnInfo = designMetaData.getColumnInfo(i);
				String columnKey = columnInfo.getColumnKey();

				if ("GetSourceType".equalsIgnoreCase(columnKey)) {
					designDataTable.setObject(rowIndex, columnKey, CarouselSourceType.format(metaCarousel.getSourceType()));
				} else if ("GetFormulaItems".equalsIgnoreCase(columnKey)){
					MetaBaseScript metaBaseScript = metaCarousel.getFormulaItems();
					if (metaBaseScript != null) {
						designDataTable.setObject(rowIndex, columnKey, metaBaseScript.getContent());
					}
				}
			}
		}
	}

	private void loadRefreshFooterProperties(MetaForm erpMetaForm, String erpCompKey, DataTable designDataTable) throws Throwable {
		int rowIndex = designDataTable.append();

		MetaComponent metaComponent = getComponentByKey(erpMetaForm, erpCompKey);

		if (metaComponent != null && metaComponent.getControlType() == ControlType.REFRESHCONTROL) {
			MetaRefreshControl metaRefresh = (MetaRefreshControl) metaComponent;
			MetaRefreshFooter metaFooter = metaRefresh.getFooter();

			if (metaFooter != null) {
				designDataTable.setObject(rowIndex, "FormulaContent", metaFooter.getContent());

				MetaFormat metaFormat = metaFooter.getFormat();
				if (metaFormat != null) {
					designDataTable.setObject(rowIndex, "HAlign", HAlignment.toString(metaFormat.getHAlign()));
					designDataTable.setObject(rowIndex, "VAlign", VAlignment.toString(metaFormat.getVAlign()));
					designDataTable.setObject(rowIndex, "ForeColor", metaFormat.getForeColor());
					designDataTable.setObject(rowIndex, "BackColor", metaFormat.getBackColor());
					designDataTable.setObject(rowIndex, "HighlightBackColor", metaFormat.getHighlightBackColor());

					MetaFont metaFont = metaFormat.getFont();
					if (metaFont != null) {
						designDataTable.setObject(rowIndex, "Name", metaFont.getName());
						designDataTable.setObject(rowIndex, "Size", metaFont.getSize());
						designDataTable.setObject(rowIndex, "Bold", metaFont.getBold());
						designDataTable.setObject(rowIndex, "Italic", metaFont.getItalic());
					}
				}
			}
		}
	}

	private void loadRefreshHeaderProperties(MetaForm erpMetaForm, String erpCompKey, DataTable designDataTable) throws Throwable {
		int rowIndex = designDataTable.append();

		MetaComponent metaComponent = getComponentByKey(erpMetaForm, erpCompKey);

		if (metaComponent != null && metaComponent.getControlType() == ControlType.REFRESHCONTROL) {
			MetaRefreshControl metaRefresh = (MetaRefreshControl) metaComponent;
			MetaRefreshHeader metaHeader = metaRefresh.getHeader();

			if (metaHeader != null) {
				designDataTable.setObject(rowIndex, "FormulaContent", metaHeader.getContent());

				if (metaHeader.getText() != null) {
					designDataTable.setObject(rowIndex, "Text", metaHeader.getText());
				}

				if (metaHeader.getIcon() != null) {
					designDataTable.setObject(rowIndex, "Icon", metaHeader.getIcon());
				}

				designDataTable.setObject(rowIndex, "IconLocation", IconLocationType.toString(metaHeader.getIconLocation()));

				MetaFormat metaFormat = metaHeader.getFormat();
				if (metaFormat != null) {
					designDataTable.setObject(rowIndex, "HAlign", HAlignment.toString(metaFormat.getHAlign()));
					designDataTable.setObject(rowIndex, "VAlign", VAlignment.toString(metaFormat.getVAlign()));
					designDataTable.setObject(rowIndex, "ForeColor", metaFormat.getForeColor());
					designDataTable.setObject(rowIndex, "BackColor", metaFormat.getBackColor());
					designDataTable.setObject(rowIndex, "HighlightBackColor", metaFormat.getHighlightBackColor());

					MetaFont metaFont = metaFormat.getFont();
					if (metaFont != null) {
						designDataTable.setObject(rowIndex, "Name", metaFont.getName());
						designDataTable.setObject(rowIndex, "Size", metaFont.getSize());
						designDataTable.setObject(rowIndex, "Bold", metaFont.getBold());
						designDataTable.setObject(rowIndex, "Italic", metaFont.getItalic());
					}
				}
			}
		}
	}

	private void loadEditViewItemsProperties(MetaForm erpMetaForm, String erpCompKey, DataTable designDataTable) throws Throwable {
		int rowIndex = designDataTable.append();

		DataTableMetaData designMetaData = designDataTable.getMetaData();
		MetaComponent metaComponent = getComponentByKey(erpMetaForm, erpCompKey);

		if (metaComponent != null && metaComponent.getControlType() == ControlType.EDITVIEW) {
			MetaEditView metaEditView = (MetaEditView) metaComponent;
			MetaEditViewItemCollection items = metaEditView.getItemCollection();

			if (items != null) {
				for (int i = 0; i < designMetaData.getColumnCount(); i++) {
					ColumnInfo columnInfo = designMetaData.getColumnInfo(i);
					String columnKey = columnInfo.getColumnKey();
					if ("GetFormulaItems".equalsIgnoreCase(columnKey)){
						MetaBaseScript metaBaseScript = items.getFormulaItems();

						if (metaBaseScript != null) {
							designDataTable.setObject(rowIndex, columnKey, metaBaseScript.getContent());
						}
					}
				}
			}
		}
	}

	private void loadProperties(MetaForm erpMetaForm, String erpCompKey, DataTable designDataTable) throws Throwable {
		int rowIndex = designDataTable.append();

		String extend = erpMetaForm.getExtend();
		Boolean mergeToSource = erpMetaForm.getMergeToSource();
		if (StringUtils.isNotBlank(extend)) {
			designDataTable.setInt(rowIndex, "VestFlagInProperties", 1);
		} else {
			designDataTable.setInt(rowIndex, "VestFlagInProperties", 0);
		}
		if (Objects.equals(mergeToSource, Boolean.TRUE)) {
			designDataTable.setInt(rowIndex, "SpecVestFlagInProperties", 1);
		} else {
			designDataTable.setInt(rowIndex, "SpecVestFlagInProperties", 0);
		}

		DataTableMetaData designMetaData = designDataTable.getMetaData();
		for (int i = 0; i < designMetaData.getColumnCount(); i++) {
			ColumnInfo columnInfo = designMetaData.getColumnInfo(i);
			String columnKey = columnInfo.getColumnKey();
			if (StringUtils.equalsAnyIgnoreCase(columnKey, "VestFlagInProperties", "SpecVestFlagInProperties")) {
				continue;
			}

			try {
				Object value;
				AbstractMetaObject properties;
				MetaComponent metaComponent = getComponentByKey(erpMetaForm, erpCompKey);
				if (Objects.nonNull(metaComponent)) {
					properties = metaComponent.getProperties();
					Class<? extends AbstractMetaObject> aClass;
					if (properties == null && metaComponent instanceof MetaChart) {
						aClass = MetaChart.class;
						properties = metaComponent;
					} else if(properties == null && metaComponent instanceof MetaWebBrowser) {
						aClass = MetaWebBrowser.class;
						properties = metaComponent;
					}else{
						aClass = properties.getClass();
					}
					if (properties instanceof MetaTextAreaProperties && "GetMaxLength".equalsIgnoreCase(columnKey)) {
						aClass = MetaTextEditorProperties.class;
					}
					try {
						value = getPropertiesValue(aClass, columnKey, properties);
					} catch (NoSuchMethodException e) {
						Class<? extends MetaComponent> clazz = metaComponent.getClass();
						value = getPropertiesValue(clazz, columnKey, metaComponent);
					}
				} else {
					MetaGridCell gridCellByKey = IDLookup.reloadIDLookup(erpMetaForm).getGridCellByKey(erpCompKey);
					MetaListViewColumn listViewColumn = null;
					if (Objects.nonNull(gridCellByKey)) {
						properties = gridCellByKey.getProperties();
					} else {
						String parentKey = (String) context1.getPara(ConstantUtil.PARENT_KEY);
						erpMetaForm.componentByKey(parentKey);

						listViewColumn = IDLookup.reloadIDLookup(erpMetaForm).getListViewColumnByKey(erpCompKey);
						properties = listViewColumn.getProperties();
					}

					Class<? extends AbstractMetaObject> aClass = properties.getClass();
					if (properties instanceof MetaTextAreaProperties && "GetMaxLength".equalsIgnoreCase(columnKey)) {
						aClass = MetaTextEditorProperties.class;
					}
					try {
						value = getPropertiesValue(aClass, columnKey, properties);
					} catch (NoSuchMethodException e) {
						if (Objects.nonNull(gridCellByKey)) {
							Class<?> clazz = gridCellByKey.getClass();
							value = getPropertiesValue(clazz, columnKey, gridCellByKey);
						} else {
							Class<?> clazz = listViewColumn.getClass();
							value = getPropertiesValue(clazz, columnKey, listViewColumn);
						}
					}
				}

				if (value instanceof MetaBaseScript) {
					MetaBaseScript metaBaseScript = (MetaBaseScript) value;
					designDataTable.setObject(rowIndex, columnKey, metaBaseScript.getContent());
					continue;
				}
				if (StringUtils.equalsIgnoreCase(columnKey, "GetFilters")) {
					if (Objects.isNull(value)) {
						designDataTable.setObject(rowIndex, columnKey, "请点击设置");
						continue;
					}
					MetaItemFilterCollection filters = (MetaItemFilterCollection) value;
					if (CollectionUtils.isEmpty(filters.getList())) {
						designDataTable.setObject(rowIndex, columnKey, "请点击设置");
						continue;
					}
					designDataTable.setObject(rowIndex, columnKey, "已设置");
					continue;
				}
				if (StringUtils.equalsIgnoreCase(columnKey, "GetItems")) {
					if (value instanceof MetaListBoxItemCollection) {
						MetaListBoxItemCollection metaListBoxItemCollection = (MetaListBoxItemCollection) value;
						if (!metaListBoxItemCollection.isEmpty()) {
							designDataTable.setObject(rowIndex, columnKey, "已设置");
							continue;
						}
					}
					designDataTable.setObject(rowIndex, columnKey, "请点击设置");
					continue;
				}
				if (StringUtils.equalsIgnoreCase(columnKey, "GetItemCollection")) {
					designDataTable.setObject(rowIndex, columnKey, "请点击设置");
					continue;
				}
				if (StringUtils.equalsIgnoreCase(columnKey, "GetDataSource")) {
					if (Objects.isNull(value)) {
						designDataTable.setObject(rowIndex, columnKey, "请点击设置");
						continue;
					}
					MetaChartDataSource dataSource = (MetaChartDataSource) value;
					if (dataSource.getCategory() == null && dataSource.getSeriesArray() == null) {
						designDataTable.setObject(rowIndex, columnKey, "请点击设置");
						continue;
					}
					designDataTable.setObject(rowIndex, columnKey, "已设置");
					continue;
				}
				if (StringUtils.equalsIgnoreCase(columnKey, "GetSourceType")) {
					if (properties instanceof MetaImageProperties) {
						designDataTable.setObject(rowIndex, columnKey, ImageSourceType.toString((Integer) value));
					} else if (properties instanceof MetaChart) {
						designDataTable.setObject(rowIndex, columnKey, ChartSourceType.toString((Integer) value));
					} else if(properties instanceof MetaWebBrowser){
						designDataTable.setObject(rowIndex, columnKey, WebBrowserSourceType.format((Integer) value));
					} else {
						designDataTable.setObject(rowIndex, columnKey, ComboBoxSourceType.format((Integer) value));
					}
					continue;
				}
				if (StringUtils.equalsIgnoreCase(columnKey, "GetStateMask")) {
					String stateMask = DictStateMask.toString((Integer) value).replaceAll("\\|", ",");
					designDataTable.setObject(rowIndex, columnKey, stateMask);
					continue;
				}
				if (StringUtils.equalsIgnoreCase(columnKey, "GetItemKeySourceType")) {
					designDataTable.setObject(rowIndex, columnKey, DictItemKeySourceType.format((Integer) value));
					continue;
				}
				if (StringUtils.equalsIgnoreCase(columnKey, "GetEditType")) {
					designDataTable.setObject(rowIndex, columnKey, SelectEditType.format((Integer) value));
					continue;
				}
				if (StringUtils.equalsIgnoreCase(columnKey, "GetCaseType")) {
					designDataTable.setObject(rowIndex, columnKey, MetaTextEditor.getCaseTypeStr((Integer) value));
					continue;
				}
				if (StringUtils.equalsIgnoreCase(columnKey, "GetRoundingMode")) {
					designDataTable.setObject(rowIndex, columnKey, RoundingMode.toString((Integer) value));
					continue;
				}
				if (StringUtils.equalsIgnoreCase(columnKey, "GetIconLocation")) {
					designDataTable.setObject(rowIndex, columnKey, IconLocationType.toString((Integer) value));
					continue;
				}
				if (StringUtils.equalsIgnoreCase(columnKey, "GetTargetShowType")) {
					designDataTable.setObject(rowIndex, columnKey, MetaHyperLink.getTargetShowTypeStr((Integer) value));
					continue;
				}
				if (StringUtils.equalsIgnoreCase(columnKey, "IsIgnoreRights")) {
					designDataTable.setObject(rowIndex, columnKey, value.toString());
					continue;
				}
				if (StringUtils.equalsIgnoreCase(columnKey, "GetUseFormulaModel")) {
					designDataTable.setObject(rowIndex, columnKey, value.toString());
					continue;
				}
				if (StringUtils.equalsIgnoreCase(columnKey, ProPertyConstant.Type)) {
					designDataTable.setObject(rowIndex, columnKey, ButtonType.toString((Integer) value));
					continue;
				}
				if(StringUtils.equalsIgnoreCase(columnKey, ProPertyConstant.TextShowType)){
					designDataTable.setObject(rowIndex, columnKey, ComboBoxTextShowType.format(Integer.parseInt(value.toString())));
					continue;
				}
				if (StringUtils.equalsIgnoreCase(columnKey, ProPertyConstant.UploadType)) {
					designDataTable.setObject(rowIndex, columnKey, value);
					continue;
				}
				if (StringUtils.equalsIgnoreCase(columnKey, ProPertyConstant.ChartType)) {
					designDataTable.setObject(rowIndex, columnKey, ChartType.toString((Integer)value));
					continue;
				}
				if (Objects.isNull(value)) {
					value = this.getDefaultValue(columnKey);
				}
				designDataTable.setObject(rowIndex, columnKey, value);
			} catch (Exception e) {
				designDataTable.setObject(rowIndex, columnKey, ConstantUtil.NODESIGNFIELD);
			}
			designDataTable.setState(RowState.NORMAL);
		}
	}

	private void loadComponent(MetaForm erpMetaForm, String erpCompKey, DataTable designDataTable) throws Throwable {
		int rowIndex = designDataTable.append();

		String extend = erpMetaForm.getExtend();
		Boolean mergeToSource = erpMetaForm.getMergeToSource();
		if (StringUtils.isNotBlank(extend)) {
			designDataTable.setInt(rowIndex, "VestFlagInComponent", 1);
		} else {
			designDataTable.setInt(rowIndex, "VestFlagInComponent", 0);
		}
		if (Objects.equals(mergeToSource, Boolean.TRUE)) {
			designDataTable.setInt(rowIndex, "SpecVestFlagInComponent", 1);
		} else {
			designDataTable.setInt(rowIndex, "SpecVestFlagInComponent", 0);
		}

		MetaForm reloadMetaForm = null;
		DataTableMetaData designMetaData = designDataTable.getMetaData();
		for (int i = 0; i < designMetaData.getColumnCount(); i++) {
			ColumnInfo columnInfo = designMetaData.getColumnInfo(i);
			String columnKey = columnInfo.getColumnKey();
			if (StringUtils.equalsAnyIgnoreCase(columnKey, "VestFlagInComponent", "SpecVestFlagInComponent", "NewExtFieldFlag")) {
				continue;
			}
			if (StringUtils.equalsAnyIgnoreCase(columnKey, "GetMSizeType", "GetHSizeType", "GetWSizeType")) { // GetMSizeType-->无: 下拉框类型；GetHSizeType-->getHeight：高度；GetWSizeType-->getWidth：宽度
				continue;
			}

			boolean dependencyCompFlag = StringUtils.endsWith(columnKey, "Dependency");
			MetaComponent metaComponent = null;
			if (dependencyCompFlag) {
				if (Objects.isNull(reloadMetaForm)) { // 惰性加载
					reloadMetaForm = NewFormCmd.loadMetaForm(erpMetaForm.getKey());
				}
				AbstractMetaObject componentByKey = getComponentByKey(reloadMetaForm, erpCompKey, true);
				if (componentByKey instanceof MetaComponent) {
					metaComponent = (MetaComponent) componentByKey;
				}
			} else {
				AbstractMetaObject componentByKey = getComponentByKey(erpMetaForm, erpCompKey, false);
				if (componentByKey instanceof MetaComponent) {
					metaComponent = (MetaComponent) componentByKey;
				}
			}
			if (Objects.isNull(metaComponent)) {
				continue;
			}

			try {
				boolean newExtField = StringUtils.isBlank(extend) && metaComponent.isNewExtField();
				designDataTable.setInt(rowIndex, "NewExtFieldFlag", newExtField ? 1 : 0);

				Class<MetaComponent> clazz = MetaComponent.class;
				Object value = getPropertiesValue(clazz, columnKey, metaComponent);

				if (value instanceof DefSize) {
					String sizeType = DefSizeToString(((DefSize) value).getSizeType());
					int size = ((DefSize) value).getSize();

					if (StringUtils.equalsIgnoreCase(columnKey, "GetMinHeight")) {
						designDataTable.setObject(rowIndex, columnKey, size);
						designDataTable.setObject(rowIndex, "GetMSizeType", "px");
					}
					if (StringUtils.equalsIgnoreCase(columnKey, "GetHeight")) {
						designDataTable.setObject(rowIndex, columnKey, size);
						designDataTable.setObject(rowIndex, "GetHSizeType", sizeType);
					}
					if (StringUtils.equalsIgnoreCase(columnKey, "GetWidth")) {
						designDataTable.setObject(rowIndex, columnKey, size);
						designDataTable.setObject(rowIndex, "GetWSizeType", sizeType);
					}
					continue;
				}

				if (StringUtils.equalsIgnoreCase(columnKey, "GetControlType")) {
					String controlType = ControlType.toString((Integer) value);
					designDataTable.setObject(rowIndex, columnKey, controlType);
					continue;
				}

				if (StringUtils.equalsIgnoreCase(columnKey, "GetCondition")) {
					designDataTable.setObject(rowIndex, columnKey, "请点击设置");
					continue;
				}

				if (StringUtils.equalsAnyIgnoreCase(columnKey, "GetLeftPadding", "GetTopPadding", "GetRightPadding", "GetBottomPadding", "GetLeftMargin", "GetTopMargin", "GetRightMargin", "GetBottomMargin")) {
					if (StringUtils.isBlank((String) value)) {
						continue;
					}
					DefSize defSize = DefSize.parse((String) value);
					designDataTable.setObject(rowIndex, columnKey, defSize.getSize());
					continue;
				}

				if (value instanceof MetaBaseScript) {
					MetaBaseScript metaBaseScript = (MetaBaseScript) value;
					designDataTable.setObject(rowIndex, columnKey, metaBaseScript.getContent());
				} else {
					if (Objects.isNull(value)) {
						value = this.getDefaultValue(columnKey);
					}
					if (Objects.isNull(value)) {
						continue;
					}
					designDataTable.setObject(rowIndex, columnKey, value);
				}
			} catch (Exception e) {
				designDataTable.setObject(rowIndex, columnKey, ConstantUtil.NODESIGNFIELD);
			}
		}
		designDataTable.setState(RowState.NORMAL);
	}

	private void loadDataBinding(MetaForm ownerMetaForm, DataTable dataTable, String panelKey) throws Throwable {
		DataTableMetaData dataTableMetaData = dataTable.getMetaData();
		int row = dataTable.append();
		MetaForm oldMetaForm = ownerMetaForm;
		MetaForm newMetaForm = oldMetaForm;
		boolean isNew;
		for (int i = 0, len = dataTableMetaData.getColumnCount(); i < len; i++) {
			ColumnInfo columnInfo = dataTableMetaData.getColumnInfo(i);
			String columnKey = columnInfo.getColumnKey();
			if (columnKey.endsWith("Dependency")) {//|| StringUtils.equalsAny(columnKey, "GetColumnKey","GetTableKey")
				ownerMetaForm = newMetaForm;
				isNew = true;
			} else {
				ownerMetaForm = oldMetaForm;
				isNew = false;
			}
			try {
				AbstractMetaObject componentByKey = getComponentByKey(ownerMetaForm, panelKey, isNew);
				MetaDataBinding dataBinding = null;
				if (componentByKey != null) {
					if (componentByKey instanceof MetaComponent) {
						dataBinding = ((MetaComponent) componentByKey).ensureDataBinding();
					}
					if (componentByKey instanceof MetaGridCell) {
						dataBinding = ((MetaGridCell) componentByKey).ensureDataBinding();
					}
					if (componentByKey instanceof MetaListViewColumn) {
						dataBinding = ((MetaListViewColumn) componentByKey).ensureDataBinding();
					}
				}
				if (Objects.isNull(componentByKey) || Objects.isNull(dataBinding)) {
					componentByKey = IDLookup.reloadIDLookup(ownerMetaForm).getGridCellByKey(panelKey);
					if (componentByKey != null) {
						dataBinding = ((MetaGridCell) componentByKey).ensureDataBinding();
					} else {
						componentByKey = IDLookup.reloadIDLookup(ownerMetaForm).getListViewColumnByKey(panelKey);
						dataBinding = ((MetaListViewColumn) componentByKey).getDataBinding();
					}
				}
				Class<? extends MetaDataBinding> instance = dataBinding.getClass();
				Object invoke = getPropertiesValue(instance, columnKey, dataBinding);
				if (componentByKey instanceof MetaSeparator) {
					dataTable.setObject(row, columnKey, ConstantUtil.NODESIGNFIELD);
				} else if (invoke instanceof MetaBaseScript) {
					dataTable.setObject(row, columnKey, ((MetaBaseScript) invoke).getContent());
				} else if ("GetColumnKey".equalsIgnoreCase(columnKey)) {
					if (componentByKey instanceof MetaGridCell) {
						Object rowTableKey = ((MetaGridCell) componentByKey).getTableKey();
						if (String.valueOf(rowTableKey).endsWith(MetaFormNODBProcess.STR_NODBTable_Profix)
								|| String.valueOf(invoke).endsWith(MetaFormNODBProcess.STR_NODBTable_Profix) || ((MetaGridCell) componentByKey).isSelect()) {
							dataTable.setString(row, i, "无字段");
						} else {
							if (StringUtils.isBlank((String) invoke)) {
								dataTable.setString(row, i, "无字段");
							} else {
								dataTable.setString(row, i, (String) invoke);
							}
						}
					} else {
						Object getTableKey = getPropertiesValue(instance, "GetTableKey", dataBinding);
						if (String.valueOf(getTableKey).endsWith(MetaFormNODBProcess.STR_NODBTable_Profix)
								|| StringUtils.isEmpty(String.valueOf(getTableKey))
								|| String.valueOf(invoke).endsWith(MetaFormNODBProcess.STR_NODBTable_Profix)) {
							dataTable.setString(row, i, "无字段");
						} else {
							if (StringUtils.isBlank((String) invoke)) {
								dataTable.setString(row, i, "无字段");
							} else {
								dataTable.setString(row, i, (String) invoke);
							}
						}
					}
				} else if ("GetTableKey".equalsIgnoreCase(columnKey)) {
					if (String.valueOf(invoke).endsWith(MetaFormNODBProcess.STR_NODBTable_Profix) || StringUtils.isEmpty(String.valueOf(invoke))) {
						dataTable.setString(row, i, "无数据表");
					} else {
						if (StringUtils.endsWith(dataBinding.getColumnKey(), MetaFormNODBProcess.STR_NODBTable_Profix)) {
							dataTable.setString(row, i, "无数据表");
						} else {
							if (StringUtils.isBlank((String) invoke)) {
								dataTable.setString(row, i, "无数据表");
							} else {
								dataTable.setString(row, i, (String) invoke);
							}
						}
					}
				} else {
					if (Objects.isNull(invoke)) {
						invoke = this.getDefaultValue(columnKey);
					}
					dataTable.setObject(row, columnKey, invoke);
				}
			} catch (Exception e) {
				dataTable.setObject(row, columnKey, ConstantUtil.NODESIGNFIELD);
			}
		}
		dataTable.setState(RowState.NORMAL);
	}

	private void loadParaList(DataTable dataTable, String path1, Document doc, DefaultContext context) throws Throwable {
		XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(FilePathHelper.toBackFilePath(path1));
		TagNode node = xmlTreeWithPath.xmlTree.getRoot();
		List<AbstractNode> paraList = node.getChildren();
		DataTable curDataTable = WebDesignerDataTableUtil.generateDataTable(getMetaTable());

		for (AbstractNode tagNode : paraList) {
			if (tagNode instanceof TagNode && "ParaGroup".equalsIgnoreCase(((TagNode) tagNode).getTagName())) {
				String key = ((TagNode) tagNode).getAttributes().get(ConstantUtil.KEY);
				String caption = ((TagNode) tagNode).getAttributes().get("Caption");
				int row = dataTable.append();
				Long applyNewOID = context.applyNewOID();
				dataTable.setString(row, "GroupKey", key);
				if (StringUtils.isNotBlank(caption)) {
					dataTable.setString(row, "GroupCaption", caption);
				}
				dataTable.setLong(ConstantUtil.OID, applyNewOID);
				dataTable.setState(RowState.NORMAL);
				List<AbstractNode> statement = ((TagNode) tagNode).getChildrenByTagName("Item");
				for (AbstractNode abstractNode : statement) {
					if (abstractNode instanceof TagNode) {
						int subrow = curDataTable.append();
						String key1 = ((TagNode) abstractNode).getAttributes().get("Key");
						String caption1 = ((TagNode) abstractNode).getAttributes().get("Caption");
						String value = ((TagNode) abstractNode).getAttributes().get("Value");
						curDataTable.setString(subrow, "ItemKey", key1);
						curDataTable.setString(subrow, "ItemCaption", caption1);
						curDataTable.setString(subrow, "ItemValue", value);
						curDataTable.setLong(subrow, ConstantUtil.POID, applyNewOID);
						curDataTable.setLong(subrow, ConstantUtil.OID,  context.applyNewOID());
						curDataTable.setState(RowState.NORMAL);
					}
				}
			}
		}
		curDataTable.batchUpdate();
		doc.add(curDataTable.getKey(), curDataTable);
	}
	private void loadParameterList(DataTable dataTable, String path1, Document doc, DefaultContext context) throws Throwable {
		XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(FilePathHelper.toBackFilePath(path1));
		TagNode node = xmlTreeWithPath.xmlTree.getRoot();
		List<AbstractNode> paramerterList = node.getChildren();
		for (AbstractNode tagNode : paramerterList) {
			if (tagNode instanceof TagNode && MetaParameterID.TAG_NAME.equalsIgnoreCase(((TagNode) tagNode).getTagName())) {
				String key = ((TagNode) tagNode).getAttributes().get(ConstantUtil.KEY);
				String caption = ((TagNode) tagNode).getAttributes().get(ConstantUtil.DESCRIPTION);
				String refKey = ((TagNode) tagNode).getAttributes().get(ConstantUtil.REF_KEY);
				int row = dataTable.append();
				Long applyNewOID = context.applyNewOID();
				dataTable.setString(row, ConstantUtil.KEY, key);
				if (StringUtils.isNotBlank(caption)) {
					dataTable.setString(row, ConstantUtil.DESCRIPTION, caption);
				}
				if (StringUtils.isNotBlank(refKey)) {
					dataTable.setString(row, ConstantUtil.REF_KEY, refKey);
				}
				dataTable.setLong(ConstantUtil.OID, applyNewOID);
				dataTable.setState(RowState.NORMAL);

			}
		}
	}

	private void loadQueryCollection(MetaForm erpMetaForm, String erpXmlFilePath,DataTable designDataTable,  Document doc, DefaultContext context) throws Throwable {

		DataTable curDataTable = WebDesignerDataTableUtil.generateDataTable(getMetaTable());
		DataTable curDataTableTwo = WebDesignerDataTableUtil.generateDataTable(getMetaTableTwo());

		String tmpFilePath = XmlFileProcessor.instance.getTmpFile(erpXmlFilePath);
		String filePath = StringUtils.isNotBlank(tmpFilePath) ? tmpFilePath : erpXmlFilePath;
		XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(FilePathHelper.toBackFilePath(filePath));
		TagNode rootNode = xmlTreeWithPath.xmlTree.getRoot();
		TagNode queryCollectionNode = rootNode.getOrCreateChildByTagName(MetaQueryCollection.TAG_NAME);

		boolean beExtendedFlag = false;
		Map<String, TagNode> extendqueryNodeMap = new HashMap<>();
		TagNode extendqueryCollectionNode = null;

		if (Objects.nonNull(erpMetaForm)) {
			beExtendedFlag = MetaFormHelper.isBeExtended(erpMetaForm);
			boolean vestFlag = StringUtils.isNotBlank(erpMetaForm.getExtend());

			if (vestFlag) {
				String erpExtendXmlFilePath = LoadFileTree.getPathByFormKey(erpMetaForm.getExtend());
				String tmpExtendFilePath = XmlFileProcessor.instance.getTmpFile(erpExtendXmlFilePath);
				String extendFilePath = StringUtils.isNotBlank(tmpExtendFilePath) ? tmpExtendFilePath : erpExtendXmlFilePath;

				XmlTreeWithPath extendXmlTreeWithPath = XmlTreeWithPath.parseFilePath(FilePathHelper.toBackFilePath(extendFilePath));
				if (Objects.nonNull(extendXmlTreeWithPath)) {
					XmlTree extendXmlTree = extendXmlTreeWithPath.xmlTree;
					TagNode extendRootNode = extendXmlTree.getRoot();
					extendqueryCollectionNode = extendRootNode.getOrCreateChildByTagName(MetaQueryCollection.TAG_NAME);
					List<TagNode> extendMacroNodeList = extendqueryCollectionNode.findNodesByTagName("Query");
					Map<String, TagNode> tmpExtendqueryNodeMap = extendMacroNodeList.stream().collect(Collectors.toMap(item -> item.getAttributes().get(ConstantUtil.KEY), Function.identity()));
					extendqueryNodeMap.putAll(tmpExtendqueryNodeMap);
				}
			}
		}
		if (erpMetaForm != null && erpMetaForm.getMergeToSource()) {
			List<TagNode> macro = queryCollectionNode.findNodesByTagName("Query");
			Map<String, TagNode> tmpExtendqueryNodeMap = macro.stream().collect(Collectors.toMap(item -> item.getAttributes().get(ConstantUtil.KEY), Function.identity()));
			List<XmlTree> uiVestXmlTreeList = null;
			if (erpMetaForm.getQueryCollection()!=null){
				for (MetaQuery metaQuery : erpMetaForm.getQueryCollection()) {
					int row = designDataTable.append();
					designDataTable.setObject(row, ConstantUtil.DataSourceType, "meta");
					if (tmpExtendqueryNodeMap.containsKey(metaQuery.getKey()) ) {
						designDataTable.setObject(row, ConstantUtil.DataSourceType, "xml");
					}
					Long applyNewOID = context.applyNewOID();
					boolean extend = isExtend(extendqueryCollectionNode, metaQuery.getKey());
					designDataTable.setString(row, "Key", metaQuery.getKey());
					designDataTable.setString(row, "Query", metaQuery.getDescription());
					designDataTable.setLong(row, ConstantUtil.OID, applyNewOID);
					designDataTable.setString(row, "Args", metaQuery.getArgs());
					if (extend) {
						designDataTable.setInt(row, "ExtendFlag", 1);
						designDataTable.setInt(row, "BeExtendedFlagFormula", 0);
					} else {
						if (Objects.isNull(uiVestXmlTreeList)) {
							uiVestXmlTreeList = new ArrayList<>();

							Pair<List<MetaFormProfile>, MetaFormProfile> pair = MetaFormHelper.listVestMetaFormBySpecVest(erpMetaForm);
							final List<MetaFormProfile> uiVestList = pair.getLeft();
							for (MetaFormProfile uiVest : uiVestList) {
								String uiVestFilePath = LoadFileTree.getPathByFormKey(uiVest.getKey());
								String tmpUiVestFilePath = XmlFileProcessor.instance.getTmpFile(uiVestFilePath);
								uiVestFilePath = StringUtils.isNotBlank(tmpUiVestFilePath) ? tmpUiVestFilePath : uiVestFilePath;

								XmlTreeWithPath uiVestXmlTreeWithPath = XmlTreeWithPath.parseFilePath(FilePathHelper.toBackFilePath(uiVestFilePath));
								if (Objects.nonNull(uiVestXmlTreeWithPath)) {
									XmlTree uiVestXmlTree = uiVestXmlTreeWithPath.xmlTree;
									uiVestXmlTreeList.add(uiVestXmlTree);
								}
							}
						}
						int beExtendMacroFlag = 0;
						for (XmlTree uiVestXmlTree : uiVestXmlTreeList) {
							if (uiVestXmlTree.containKey("Query@" + metaQuery.getKey())) {
								beExtendMacroFlag = 1;
								break;
							}
						}
						designDataTable.setInt(row, "ExtendFlag", 0);
						designDataTable.setInt(row, "BeExtendedFlagFormula", beExtendMacroFlag);
					}
					designDataTable.setState(RowState.NORMAL);

					MetaStatementCollection statements = metaQuery.getStatements();
					if (statements!=null){
						for (MetaStatement statement : statements) {
							int subrow = curDataTable.append();
							String dbType = statement.getDBType();
							if (dbType.isEmpty()) {
								dbType = "  ";
							}
							curDataTable.setString(subrow, "DBType", dbType);
							curDataTable.setString(subrow, "Context", statement.getContent());
							curDataTable.setString(subrow, "QueryType",TableStatementType.toString(statement.getType()));
							curDataTable.setLong(subrow, ConstantUtil.POID, applyNewOID);
							curDataTable.setState(RowState.NORMAL);

						}
					}

					if (metaQuery.getParameters()!=null&&!metaQuery.getParameters().isEmpty()){
						for (MetaParameter parameter : metaQuery.getParameters()) {
							int subrow = curDataTableTwo.append();
							curDataTableTwo.setInt(subrow, "Parameter",parameter.getDataType() );
							curDataTableTwo.setLong(subrow, ConstantUtil.POID, applyNewOID);
							curDataTableTwo.setState(RowState.NORMAL);
						}
					}
				}
			}
		} else {
			if (erpMetaForm!=null && erpMetaForm.getQueryCollection()!=null){
				List<TagNode> query = queryCollectionNode.findNodesByTagName("Query");
				Map<String, TagNode> tmpExtendqueryNodeMap = query.stream().collect(Collectors.toMap(item -> item.getAttributes().get(ConstantUtil.KEY), Function.identity()));
				for (MetaQuery metaQuery : erpMetaForm.getQueryCollection()) {
					String key = metaQuery.getKey();
					boolean src = tmpExtendqueryNodeMap.containsKey(key);
					boolean extend = extendqueryNodeMap.containsKey(key);
					int row = designDataTable.append();
					designDataTable.setString(row, "Key", key);
					designDataTable.setString(row, "Query", metaQuery.getDescription());
					Long applyNewOID = context.applyNewOID();
					designDataTable.setLong(row, ConstantUtil.OID, applyNewOID);
					designDataTable.setString(row, "Args", metaQuery.getArgs());
					designDataTable.setInt(row, "BeExtendedFlagFormula", 0);
					if (extend){
						designDataTable.setInt(row, "ExtendFlag", 1);
					} else {
						designDataTable.setInt(row, "ExtendFlag", 0);
					}
					designDataTable.setState(RowState.NORMAL);
					if (src){//存在xml
						designDataTable.setObject(row, ConstantUtil.DataSourceType, "xml");
					} else {//不存在xml
						//可以重写
						designDataTable.setObject(row, ConstantUtil.DataSourceType, "meta");
					}



					MetaStatementCollection statements = metaQuery.getStatements();
					if (statements!=null){
						for (MetaStatement statement : statements) {
							int subrow = curDataTable.append();
							String dbType = statement.getDBType();
							if (dbType.isEmpty()) {
								dbType = "  ";
							}
							curDataTable.setString(subrow, "DBType", dbType);
							curDataTable.setString(subrow, "QueryType",TableStatementType.toString(statement.getType()));
							curDataTable.setString(subrow, "Context", statement.getContent());
							curDataTable.setLong(subrow, ConstantUtil.POID, applyNewOID);
							curDataTable.setState(RowState.NORMAL);
						}
					}
					if (metaQuery.getParameters()!=null&&!metaQuery.getParameters().isEmpty()){
						for (MetaParameter parameter : metaQuery.getParameters()) {
							int subrow = curDataTableTwo.append();
							curDataTableTwo.setInt(subrow, "Parameter",parameter.getDataType() );
							curDataTableTwo.setLong(subrow, ConstantUtil.POID, applyNewOID);
							curDataTableTwo.setState(RowState.NORMAL);
						}
					}




				}

			} else {

				String path1 = erpMetaForm != null ? LoadFileTree.getPathByFormKey(erpMetaForm.getKey()) : erpXmlFilePath;
				xmlTreeWithPath = XmlTreeWithPath.parseFilePath(FilePathHelper.toBackFilePath(path1));
				TagNode node = xmlTreeWithPath.xmlTree.getRoot().getOrCreateChildByTagName("QueryCollection");
				for (AbstractNode tagNode : node.getChildren()) {
					if (tagNode instanceof TagNode && "Query".equalsIgnoreCase(((TagNode) tagNode).getTagName())) {
						TagNode tagNode1 = (TagNode) tagNode;
						Map<String, String> attributes = tagNode1.getAttributes();
						String key = attributes.get(ConstantUtil.KEY);
						String description = attributes.get("Description");
						String argsDetail = attributes.get("Args");
						TagNode extendTagNode = extendqueryNodeMap.get(key);
						if (StringUtils.isBlank(argsDetail) && Objects.nonNull(extendTagNode)) {
							argsDetail = extendTagNode.getAttributes().get("Args");
						}
						if (StringUtils.isBlank(description) && Objects.nonNull(extendTagNode)) {
							description = extendTagNode.getAttributes().get("Description");
						}
						int row = designDataTable.append();
						Long applyNewOID = context.applyNewOID();
						designDataTable.setString(row, "Key", key);
						if (StringUtils.isNotBlank(description)) {
							designDataTable.setString(row, "Query", description);
						}
						if (StringUtils.isNotBlank(argsDetail)) {
							designDataTable.setString(row, "Args", argsDetail);
						}
						designDataTable.setLong(ConstantUtil.OID, applyNewOID);
						designDataTable.setState(RowState.NORMAL);
						if (beExtendedFlag) {
							designDataTable.setInt(row, "BeExtendedFlagFormula", 1);
						} else {
							designDataTable.setInt(row, "BeExtendedFlagFormula", 0);
						}
						if (Objects.nonNull(extendTagNode)) {
							designDataTable.setInt(row, "ExtendFlag", 1);
						} else {
							designDataTable.setInt(row, "ExtendFlag", 0);
						}
						designDataTable.setObject(row, ConstantUtil.DataSourceType, "xml");
						designDataTable.setState(RowState.NORMAL);
						List<AbstractNode> statement = tagNode1.getChildrenByTagName("Statement");
						for (AbstractNode abstractNode : statement) {
							if (abstractNode instanceof TagNode) {
								int subrow = curDataTable.append();
								String DBType = ((TagNode) abstractNode).getAttributes().get("DBType");
								String QueryType = ((TagNode) abstractNode).getAttributes().get("Type");
								String a1 = ((TagNode) abstractNode).getCDataValue();
								if (StringUtils.isEmpty(DBType)) {
									DBType = "  ";
								}
								curDataTable.setString(subrow, "DBType", DBType);
								curDataTable.setString(subrow, "QueryType",QueryType);
								curDataTable.setString(subrow, "Context", a1);
								curDataTable.setLong(subrow, ConstantUtil.POID, applyNewOID);
								curDataTable.setState(RowState.NORMAL);
							}
						}
						TagNode parameterCollection = tagNode1.getOrCreateChildByTagName(MetaParameterCollection.TAG_NAME);
						List<AbstractNode> parameter = parameterCollection.getChildrenByTagName("Parameter");
						for (AbstractNode abstractNode : parameter) {
							if (abstractNode instanceof TagNode) {
								int subrow = curDataTableTwo.append();
								curDataTableTwo.setInt(subrow, "Parameter", DataType.parse(((TagNode) abstractNode).getAttributes().get("DataType")));
								curDataTableTwo.setLong(subrow, ConstantUtil.POID, applyNewOID);
								curDataTableTwo.setState(RowState.NORMAL);
							}
						}
					}
				}
			}

		}
		curDataTable.batchUpdate();
		doc.add(curDataTable.getKey(), curDataTable);
		curDataTableTwo.batchUpdate();
		doc.add(curDataTableTwo.getKey(), curDataTableTwo);
	}


	private void loadScriptList(MetaForm erpMetaForm, String erpXmlFilePath,DataTable designDataTable) throws Throwable {
		String tmpFilePath = XmlFileProcessor.instance.getTmpFile(erpXmlFilePath);
		String filePath = StringUtils.isNotBlank(tmpFilePath) ? tmpFilePath : erpXmlFilePath;
		XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(FilePathHelper.toBackFilePath(filePath));
		TagNode rootNode = xmlTreeWithPath.xmlTree.getRoot();
		TagNode metaScriptCollection = rootNode.getOrCreateChildByTagName(MetaScriptCollection.TAG_NAME);

		boolean beExtendedFlag = false;
		Map<String, TagNode> extendMacroNodeMap = new HashMap<>();
		TagNode extendScriptCollectionNode = null;
		if (Objects.nonNull(erpMetaForm)) {
			beExtendedFlag = MetaFormHelper.isBeExtended(erpMetaForm);
			boolean vestFlag = StringUtils.isNotBlank(erpMetaForm.getExtend());

			if (vestFlag) {
				String erpExtendXmlFilePath = LoadFileTree.getPathByFormKey(erpMetaForm.getExtend());
				String tmpExtendFilePath = XmlFileProcessor.instance.getTmpFile(erpExtendXmlFilePath);
				String extendFilePath = StringUtils.isNotBlank(tmpExtendFilePath) ? tmpExtendFilePath : erpExtendXmlFilePath;

				XmlTreeWithPath extendXmlTreeWithPath = XmlTreeWithPath.parseFilePath(FilePathHelper.toBackFilePath(extendFilePath));
				if (Objects.nonNull(extendXmlTreeWithPath)) {
					XmlTree extendXmlTree = extendXmlTreeWithPath.xmlTree;
					TagNode extendRootNode = extendXmlTree.getRoot();
					extendScriptCollectionNode = extendRootNode.getOrCreateChildByTagName(MetaScriptCollection.TAG_NAME);
					List<TagNode> extendScriptNodeList = extendScriptCollectionNode.findNodesByTagName("Script");
					Map<String, TagNode> tmpExtendScriptNodeMap = extendScriptNodeList.stream().collect(Collectors.toMap(item -> item.getAttributes().get(ConstantUtil.KEY), Function.identity()));
					extendMacroNodeMap.putAll(tmpExtendScriptNodeMap);
				}
			}
		}

		List<AbstractNode> metaScriptCollectionChildren = metaScriptCollection.getChildren();

		if (erpMetaForm != null && erpMetaForm.getMergeToSource()) {
			List<TagNode> macro = metaScriptCollection.findNodesByTagName("Script");
			Map<String, TagNode> tmpExtendScriptNodeMap = macro.stream().collect(Collectors.toMap(item -> item.getAttributes().get(ConstantUtil.KEY), Function.identity()));

			List<XmlTree> uiVestXmlTreeList = null;
			MetaScriptCollection scriptCollection = erpMetaForm.getScriptCollection();
			if (scriptCollection == null){
				scriptCollection = new MetaScriptCollection();
			}
			for (MetaScript metaScript  : scriptCollection) {
				int row = designDataTable.append();
				designDataTable.setObject(row, ConstantUtil.DataSourceType, "meta");
				if (tmpExtendScriptNodeMap.containsKey(metaScript.getKey()) ) {
					designDataTable.setObject(row, ConstantUtil.DataSourceType, "xml");
				}
				boolean extend = isExtend(extendScriptCollectionNode, metaScript.getKey());
				designDataTable.setString(row, "Key", metaScript.getKey());
				designDataTable.setString(row, "Caption", metaScript.getCaption());
				designDataTable.setString(row, "Description", metaScript.getDescription());
				designDataTable.setString(row, "Range", ScriptRange.toString(metaScript.getRange()));
				designDataTable.setString(row, "Verb", FormVerb.toString(metaScript.getVerb()));
				designDataTable.setString(row, "ScriptDetail", metaScript.getContent());
				if (extend) {
					designDataTable.setInt(row, "ExtendFlag", 1);
					designDataTable.setInt(row, "BeExtendedFlagFormula", 0);
				} else {
					if (Objects.isNull(uiVestXmlTreeList)) {
						uiVestXmlTreeList = new ArrayList<>();

						Pair<List<MetaFormProfile>, MetaFormProfile> pair = MetaFormHelper.listVestMetaFormBySpecVest(erpMetaForm);
						final List<MetaFormProfile> uiVestList = pair.getLeft();
						for (MetaFormProfile uiVest : uiVestList) {
							String uiVestFilePath = LoadFileTree.getPathByFormKey(uiVest.getKey());
							String tmpUiVestFilePath = XmlFileProcessor.instance.getTmpFile(uiVestFilePath);
							uiVestFilePath = StringUtils.isNotBlank(tmpUiVestFilePath) ? tmpUiVestFilePath : uiVestFilePath;

							XmlTreeWithPath uiVestXmlTreeWithPath = XmlTreeWithPath.parseFilePath(FilePathHelper.toBackFilePath(uiVestFilePath));
							if (Objects.nonNull(uiVestXmlTreeWithPath)) {
								XmlTree uiVestXmlTree = uiVestXmlTreeWithPath.xmlTree;
								uiVestXmlTreeList.add(uiVestXmlTree);
							}
						}
					}
					int beExtendMacroFlag = 0;
					for (XmlTree uiVestXmlTree : uiVestXmlTreeList) {
						if (uiVestXmlTree.containKey("Script@" + metaScript.getKey())) {
							beExtendMacroFlag = 1;
							break;
						}
					}
					designDataTable.setInt(row, "ExtendFlag", 0);
					designDataTable.setInt(row, "BeExtendedFlagFormula", beExtendMacroFlag);
				}
				designDataTable.setState(RowState.NORMAL);
			}
		} else {
			if (erpMetaForm!=null && erpMetaForm.getScriptCollection()!=null){
				List<TagNode> macro = metaScriptCollection.findNodesByTagName("Script");
				Map<String, TagNode> tmpExtendMacroNodeMap = macro.stream().collect(Collectors.toMap(item -> item.getAttributes().get(ConstantUtil.KEY), Function.identity()));

				for (MetaScript metaScript : erpMetaForm.getScriptCollection()) {
					String key = metaScript.getKey();
					boolean src = tmpExtendMacroNodeMap.containsKey(key);
					boolean extend = extendMacroNodeMap.containsKey(key);
					int row = designDataTable.append();
					designDataTable.setString(row, "Key", metaScript.getKey());
					designDataTable.setString(row, "Caption", metaScript.getCaption());
					designDataTable.setString(row, "Description", metaScript.getDescription());
					designDataTable.setString(row, "Range", ScriptRange.toString(metaScript.getRange()));
					designDataTable.setString(row, "Verb", FormVerb.toString(metaScript.getVerb()));
					designDataTable.setString(row, "ScriptDetail", metaScript.getContent());
					designDataTable.setInt(row, "BeExtendedFlagFormula", 0);
					if (extend){
						designDataTable.setInt(row, "ExtendFlag", 1);
					} else {
						designDataTable.setInt(row, "ExtendFlag", 0);
					}
					designDataTable.setState(RowState.NORMAL);
					if (src){//存在xml
						designDataTable.setObject(row, ConstantUtil.DataSourceType, "xml");
					} else {//不存在xml
						//可以重写
						designDataTable.setObject(row, ConstantUtil.DataSourceType, "meta");
					}
				}

			} else {
				for (AbstractNode tagNode : metaScriptCollectionChildren) {
					if (tagNode instanceof TagNode && "Script".equalsIgnoreCase(((TagNode) tagNode).getTagName())) {
						String key = ((TagNode) tagNode).getAttributes().get(ConstantUtil.KEY);
						String scriptCaption = ((TagNode) tagNode).getAttributes().get("Caption");
						String range = ((TagNode) tagNode).getAttributes().get("Range");
						String verb = ((TagNode) tagNode).getAttributes().get("Verb");
						String scriptDescription = ((TagNode) tagNode).getAttributes().get("Description");
						int row = designDataTable.append();
						designDataTable.setString(row, "Key", key);
						designDataTable.setString(row, "Caption", scriptCaption);
						if (StringUtils.isNotBlank(range)) {
							designDataTable.setString(row, "Range", range);
						} else {
							designDataTable.setString(row, "Range", "All");
						}
						if (StringUtils.isNotBlank(verb)) {
							designDataTable.setString(row, "Verb", verb);
						} else {
							designDataTable.setString(row, "Verb", "Other");
						}

						designDataTable.setString(row, "Description", scriptDescription);
						String a1 = ((TagNode) tagNode).getCDataValue();
						designDataTable.setObject(row, ConstantUtil.DataSourceType, "xml");
						designDataTable.setString(row, "ScriptDetail", a1);
						designDataTable.setState(RowState.NORMAL);
					}
				}
			}

		}
	}

	private void loadStatusList(DefaultContext context,DataTable dataTable,MetaCommonDef metaCommonDef,Long POID) throws Throwable {
		if (metaCommonDef.getStatusCollection() != null && !metaCommonDef.getStatusCollection().isEmpty()){
			for (MetaStatus status : metaCommonDef.getStatusCollection()) {
				int row = dataTable.append();
				dataTable.setString(row, "Key", status.getKey());
				dataTable.setObject(row, "OID", context.applyNewOID());
				dataTable.setObject(row, "POID", POID);
				dataTable.setString(row, "Caption", status.getCaption());
				if (status.getValue()!=-1) {
					dataTable.setObject(row, "StatusValue", status.getValue());
				}else {
					dataTable.setObject(row, "StatusValue", -1);
				}
				if (status.isStandalone()) {
					if (status.isStandalone()) {
						dataTable.setObject(row, "IsStandalone", "1");
					} else {
						dataTable.setObject(row, "IsStandalone", "0");
					}
				}
				dataTable.setState(RowState.NORMAL);

			}
		}
	}

	private void loadGridFilterRow(DataTable dataTable, MetaComponent metaGrid,MetaForm ownerMetaForm) throws Throwable {
		MetaGridFilter metaFilterValuesSrc = null;
		if (StringUtils.isNotEmpty(ownerMetaForm.getExtend())){
			MetaForm ownerMetaFormSrc = NewFormCmd.loadMetaForm(ownerMetaForm.getExtend());
			MetaGrid metaGridSrc = (MetaGrid) getComponentByKey(ownerMetaFormSrc, metaGrid.getKey());
			metaFilterValuesSrc = metaGridSrc.getFilter();
		}

		MetaGridFilter metaFilterValues = ((MetaGrid) metaGrid).getFilter();
		if (metaFilterValues != null) {
			for (MetaFilterValue metaFilterValue : metaFilterValues) {
				int i = dataTable.append();
				dataTable.setObject(i, "Index", metaFilterValue.getKey());
				dataTable.setInt(i, "Type", metaFilterValue.getType());
				dataTable.setString(i, "FieldKey", metaFilterValue.getFieldKey());
				dataTable.setInt(i, "CondSign", metaFilterValue.getSign());
				dataTable.setString(i, "RefValue", metaFilterValue.getRefValueKey());
				dataTable.setInt(i, "DataType", metaFilterValue.getDataType());
				if (metaFilterValuesSrc!=null && metaFilterValuesSrc.containsKey(metaFilterValue.getKey())){
					dataTable.setInt(i, "ExtendFlag", 1);
				}
				dataTable.setState(RowState.NORMAL);
			}
		}

	}

	private void loadGridFilter(DataTable dataTable, MetaComponent metaGrid) throws Throwable {
		MetaGrid metaGrid1 = (MetaGrid) metaGrid;
		if (metaGrid1.getFilter() != null) {
			int i = dataTable.append();
			dataTable.setInt(i, "GridFilter", metaGrid1.getFilter().getOptSign());
			dataTable.setString(i, "FilterDependency", metaGrid1.getFilter().getFilterDependency());
			dataTable.setString(i, "GridKey", metaGrid1.getKey());
			dataTable.setState(RowState.NORMAL);
		}
	}


	private MetaGridColumn getMetaGridColumn(String fieldKey, MetaGridColumn metaColumn, MetaGridColumnCollection columnCollection) {
		for (int i = 0; i < columnCollection.size(); i++) {
			MetaGridColumn metaGridColumn = columnCollection.get(i);
			String oldKey = metaGridColumn.getMetaKey();
			if (!StringUtils.isNotBlank(oldKey)) {
				if (fieldKey.equals(metaGridColumn.getKey())) {
					metaColumn = metaGridColumn;
				}
			} else {
				if (fieldKey.equals(metaGridColumn.getMetaKey())) {
					metaColumn = metaGridColumn;
				}
			}

			MetaGridColumnCollection collection = metaGridColumn.getColumnCollection();
			if (collection != null && collection.size() > 0) {
				metaColumn = getMetaGridColumn(fieldKey, metaColumn, collection);
			}
		}
		return metaColumn;
	}

	private String getRoupTypeString(MetaColumn metaColumn) {
		String roupType;
		if (metaColumn.getGroupType() == 0) {
			roupType = "<直接量>";
		} else if (metaColumn.getGroupType() == 1) {
			roupType = "<期间分组>";
		} else {
			roupType = "<无分组>";
		}
		return roupType;
	}

	/**
	 * create time: 2020/12/8 14:32 Affect :表来源类型转换
	 */
	public static String sourceType(int sourceType) {
		String returnSourceType;
		switch (sourceType) {
			case TableSourceType.QUERY:
				returnSourceType = TableSourceType.STR_QUERY;
				break;
			case TableSourceType.CUSTOM:
				returnSourceType = TableSourceType.STR_CUSTOM;
				break;
			case TableSourceType.INTERFACE:
				returnSourceType = TableSourceType.STR_INTERFACE;
				break;
			case TableSourceType.UNKNOWN:
				returnSourceType = "";
				break;
			default:
				returnSourceType = TableSourceType.STR_DATA_OBJECT;
				break;
		}
		return returnSourceType;
	}

	/**
	 * 条件查询
	 */
	public static void fieldEchoValue(String paraValue, DataTable dataTable) {
		dataTable.append();
		dataTable.setString("FieldEchoValue", paraValue);
		dataTable.setState(RowState.NORMAL);
	}

	// 当存在多个form判断组件为哪一个form里的
	public static MetaForm isThisForm(MetaForm ownerMetaForm, MetaForm containerForm, String Key) {
		IDLookup idLookup = null;
		if (ownerMetaForm != null) {
			idLookup = IDLookup.reloadIDLookup(ownerMetaForm);
		}
		if (!(idLookup.containFieldKey(Key))) {
			if (containerForm != null) {
				ownerMetaForm = containerForm;
			}
		}
		return ownerMetaForm;
	}

	// 表单属性
	private void loadFormProperty(DataTable dataTable, MetaForm ownerMetaForm) throws Throwable {
		DataTableMetaData dataTableMetaData = dataTable.getMetaData();
		int row = dataTable.append();
		for (int i = 0, len = dataTableMetaData.getColumnCount(); i < len; i++) {
			ColumnInfo columnInfo = dataTableMetaData.getColumnInfo(i);
			String columnKey = columnInfo.getColumnKey();
			try {
				Class<MetaForm> instance = MetaForm.class;
				Object invoke = getPropertiesValue(instance, columnKey, ownerMetaForm);
				if ("GetFormType".equalsIgnoreCase(columnKey)) {
					dataTable.setObject(row, columnKey, FormType.toString((Integer) invoke));
				} else if ("GetInitState".equalsIgnoreCase(columnKey)) {
					dataTable.setObject(row, columnKey, OperationState.toString((Integer) invoke));
				} else if ("GetPlatform".equalsIgnoreCase(columnKey)) {
					dataTable.setObject(row, columnKey, PlatformType.toString((Integer) invoke));
				} else {
					if (Objects.isNull(invoke)) {
						invoke = this.getDefaultValue(columnKey);
					}
					if (Objects.nonNull(invoke)) {
						if (invoke instanceof MetaBaseScript) {
							dataTable.setObject(row, columnKey, ((MetaBaseScript) invoke).getContent());
						} else {
							dataTable.setObject(row, columnKey, invoke);
						}
					}
				}
			} catch (Exception e) {
				dataTable.setObject(row, columnKey, ConstantUtil.NODESIGNFIELD);
			}
		}
		dataTable.setState(RowState.NORMAL);
	}

	private void loadMetaBody(DataTable dataTable, MetaForm ownerMetaForm) throws Throwable {
		DataTableMetaData dataTableMetaData = dataTable.getMetaData();
		int row = dataTable.append();
		for (int i = 0, len = dataTableMetaData.getColumnCount(); i < len; i++) {
			ColumnInfo columnInfo = dataTableMetaData.getColumnInfo(i);
			String columnKey = columnInfo.getColumnKey();
			if ("GetHSizeType".equalsIgnoreCase(columnKey) ||
					"GetWSizeType".equalsIgnoreCase(columnKey)) {
				continue;
			}
			try {
				Class<MetaBody> instance = MetaBody.class;
				Object invoke = getPropertiesValue(instance, columnKey, ownerMetaForm.getMetaBody());
				if (invoke instanceof DefSize) {
					String size = DefSizeToString(((DefSize) invoke).getSizeType());
					int size1 = ((DefSize) invoke).getSize();
					if ("GetPopHeight".equalsIgnoreCase(columnKey)) {
						dataTable.setObject(row, columnKey, size1);
						dataTable.setObject(row, "GetHSizeType", size);
					} else if ("GetPopWidth".equalsIgnoreCase(columnKey)) {
						dataTable.setObject(row, columnKey, size1);
						dataTable.setObject(row, "GetWSizeType", size);
					} else {
						dataTable.setObject(row, columnKey, size1);
					}

				} else if ("GetOverflowY".equalsIgnoreCase(columnKey)) {
					dataTable.setObject(row, columnKey, ScrollType.toString((Integer) invoke));
				} else if ("GetOverflowX".equalsIgnoreCase(columnKey)) {
					dataTable.setObject(row, columnKey, ScrollType.toString((Integer) invoke));
				} else {
					if (Objects.isNull(invoke)) {
						invoke = this.getDefaultValue(columnKey);
					}
					if (Objects.nonNull(invoke)) {
						if (invoke instanceof MetaBaseScript) {
							dataTable.setObject(row, columnKey, ((MetaBaseScript) invoke).getContent());
						} else {
							dataTable.setObject(row, columnKey, invoke);
						}
					}
				}
			} catch (Exception e) {
				dataTable.setObject(row, columnKey, ConstantUtil.NODESIGNFIELD);
			}
		}
		dataTable.setState(RowState.NORMAL);
	}

	private void loadXml(DataTable dataTable, String path) throws Throwable {
		String value;
		int row = dataTable.append();
		if (StringUtils.isEmpty(path)) {
			value = "<?xml version='1.0' encoding='UTF-8' standalone='no'?>\" +\n" +
					"\t\t\t\t\"<Process>\" +\n" +
					"\t\t\t\t\"<Begin ID='1' Key='Begin' Caption='起始'>\" +\n" +
					"\t\t\t\t\"<NodeGraphic X='303' Y='131'/>\" +\n" +
					"\t\t\t\t\"<TransitionCollection>\" +\n" +
					"\t\t\t\t\"<SequenceFlow ID='3' Key='SequenceFlow' Caption='顺序流' TargetNodeKey='End'/>\" +\n" +
					"\t\t\t\t\"</TransitionCollection>\" +\n" +
					"\t\t\t\t\"</Begin>\" +\n" +
					"\t\t\t\t\"<End ID='2' Key='End' Caption='结束'>\" +\n" +
					"\t\t\t\t\"<NodeGraphic X='303' Y='597'/>\" +\n" +
					"\t\t\t\t\"</End>\" +\n" +
					"\t\t\t\t\"</Process>";
		} else {
			File file = new File(FilePathHelper.toBackFilePath(path));
			String name = file.getName();
			XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(FilePathHelper.toBackFilePath(path), false);
			String caption = xmlTreeWithPath.xmlTree.getRoot().getAttributes().get("Caption");
			value = xmlTreeWithPath.xmlTree.getOrgXml();
			dataTable.setObject(row, "FileName", name);
			dataTable.setObject(row, "FileCaption", caption);
		}

		dataTable.setObject(row, "Content", value);

		dataTable.setState(RowState.NORMAL);


	}

	// 操作集合属性
	private void loadOperationsProperty(DataTable dataTable, MetaToolBar value) {
		int row = dataTable.append();
		dataTable.setString(row, ConstantUtil.KEY, value.getKey());
		dataTable.setString(row, ConstantUtil.TYPE, ConstantUtil.TOOL_BAR);
		dataTable.setString(row, ConstantUtil.CAPTION, value.getCaption());
		dataTable.setString(row, "BackColor", value.getBackColor());
		dataTable.setState(RowState.NORMAL);
	}// 还原列表属性

	private void loadSnapshotListProperty(DataTable dataTable, String key) throws Throwable {
		String filePath = LoadFileTree.getPathByFormKey(key);
		String type = "Form";
		String caption = "";
		String projectKey = "";
		if(StringUtils.isNotEmpty(filePath)){
			MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(key);
			caption = metaForm.getCaption();
			projectKey = metaForm.getProjectKey();
		}
		if (StringUtils.isEmpty(filePath)) {
			filePath = LoadFileTree.getDataMigrationPathByKey(key);
			type = ConstantUtil.DATA_MIGRATION;
			if(StringUtils.isNotEmpty(filePath)){
				MetaDataMigration dataMigration = MetaFactory.getGlobalInstance().getDataMigration(filePath);
				caption = dataMigration.getCaption();
				projectKey = dataMigration.getProject().getKey();
			}
		}
		if (StringUtils.isEmpty(filePath)) {
			filePath = LoadFileTree.getBPMPathByKey(key);
			type = "BPM";
			if(StringUtils.isNotEmpty(filePath)){
				caption = MetaFactory.getGlobalInstance().getBPMProcess(filePath).getCaption();
				projectKey = "";
			}
		}
		if (StringUtils.isEmpty(filePath)) {
			filePath = LoadFileTree.getPathByDataObject(key);
			type = ConstantUtil.DATA_OBJECT;
			if(StringUtils.isNotEmpty(filePath)){
				MetaDataObject dataObject = MetaFactory.getGlobalInstance().getDataObject(key);
				caption = dataObject.getCaption();
				projectKey = dataObject.getProjectKey();
			}
		}
		if (StringUtils.isEmpty(filePath)) {
			filePath = LoadFileTree.getDataMapPathByKey(key);
			type = "DataMap";
			if(StringUtils.isNotEmpty(filePath)){
				MetaMap dataMap = MetaFactory.getGlobalInstance().getDataMap(key);
				caption = dataMap.getCaption();
				projectKey = dataMap.getProject().getKey();
			}
		}
		if (StringUtils.isEmpty(filePath)) {
			return;
		}

		if (XmlFileProcessor.filePathToSnapshotMap.containsKey(filePath)) {
			Stack<String> stack = XmlFileProcessor.filePathToSnapshotMap.get(filePath);
			Iterator<String> iterator = stack.iterator();
			while (iterator.hasNext()){
				int row = dataTable.append();
				String path = iterator.next();
				long time = Long.parseLong(path.substring(path.lastIndexOf(".") +1));
				dataTable.setString(row, ConstantUtil.KEY, key);
				dataTable.setString(row, ConstantUtil.CAPTION, caption);
				dataTable.setString(row, ConstantUtil.TYPE, type);
				dataTable.setString(row, ConstantUtil.PROJECT_KEY, projectKey);
				dataTable.setString(row, "FilePath", filePath);
				dataTable.setString(row, "TempFilePath", path);
				dataTable.setObject(row, "SaveTime", time);
				dataTable.setState(RowState.NORMAL);
			}

		}
	}

	private void loadRecycleListProperty(DataTable dataTable) {
		XmlFileProcessor.recycleToTmpFormAndFileMap.entrySet().stream()
				.sorted(Map.Entry.comparingByValue(Comparator.comparingLong(RecycleForm::getDeleteTime)))
				.collect(Collectors.toList()).forEach(item -> {
					String key = item.getKey();
					RecycleForm form = item.getValue();
					if (!key.startsWith("Entry@Entry")) {
						int row = dataTable.append();
						dataTable.setString(row, ConstantUtil.KEY, form.getKey());
						dataTable.setString(row, ConstantUtil.CAPTION, form.getCaption());
						dataTable.setString(row, ConstantUtil.TYPE, form.getType());
						dataTable.setString(row, ConstantUtil.PROJECT_KEY, form.getProjectKey());
						dataTable.setString(row, "FilePath", form.getFilePath());
						dataTable.setObject(row, "DeleteTime", new Date(form.getDeleteTime()));
						dataTable.setState(RowState.NORMAL);
					}
				});
	}

	// 嵌入组件属性
	private void loadEmbedProperty(DataTable dataTable, MetaForm ownerMetaForm, String compKey) {
		MetaEmbed embed = ownerMetaForm.embedByKey(compKey);
		if (embed.getKey().equals(compKey)) {
			int row = dataTable.append();
			dataTable.setString(row, ConstantUtil.KEY, embed.getKey());
			dataTable.setString(row, ConstantUtil.TYPE, "Embed");
			dataTable.setString(row, ConstantUtil.FORM_KEY, embed.getFormKey());
			dataTable.setString(row, ConstantUtil.CAPTION, embed.getCaption());
			dataTable.setString(row, "RootKey", embed.getRootKey());
			dataTable.setString(row, "IncludeDataTable", String.valueOf(embed.isIncludeDataTable()));
			MetaEmbedVarCollection vars = embed.getVars();
			StringBuilder stringBuilder = new StringBuilder(255);
			for (int i = 0; i < vars.size(); i++) {
				String key = vars.get(i).getKey();
				String value = vars.get(i).getValue();
				if (i == 0) {
					stringBuilder.append("{Key:").append(key).append(",").append("Value:").append(value).append("}");
				} else {
					stringBuilder.append(";{Key:").append(key).append(",").append("Value:").append(value).append("}");
				}

			}

			dataTable.setString(row, "Var", stringBuilder.toString());
			dataTable.setState(RowState.NORMAL);
		}
	}

	private void loadEmbedVarProperty(DataTable dataTable, MetaForm ownerMetaForm, String compKey) {
		List<MetaEmbed> embeds = ownerMetaForm.getEmbeds();
		for (MetaEmbed embed : embeds) {
			if (embed.getKey().equals(compKey)) {
				MetaEmbedVarCollection vars = embed.getVars();
				for (int i = 0; i < vars.size(); i++) {
					String key = vars.get(i).getKey();
					String value = vars.get(i).getValue();
					int row = dataTable.append();
					dataTable.setString(row, ConstantUtil.KEY, key);
					dataTable.setString(row, "Value", value);
					dataTable.setState(RowState.NORMAL);
				}
			}
		}
	}// Container属性

	private void loadContainerProperty(DataTable dataTable, MetaContainer value) {
		int row = dataTable.append();
		dataTable.setString(row, ConstantUtil.KEY, value.getKey());
		dataTable.setString(row, "ControlType", "Container");
		dataTable.setString(row, ConstantUtil.CAPTION, value.getCaption());
		dataTable.setString(row, ConstantUtil.VISIBLE, value.getVisible());
		dataTable.setState(RowState.NORMAL);


	}// DictView属性

	private void loadDictViewProperty(MetaForm ownerMetaForm, DataTable dataTable, String panelKey) throws Throwable {
		DataTableMetaData dataTableMetaData = dataTable.getMetaData();
		int row = dataTable.append();
		for (int i = 0, len = dataTableMetaData.getColumnCount(); i < len; i++) {
			ColumnInfo columnInfo = dataTableMetaData.getColumnInfo(i);
			String columnKey = columnInfo.getColumnKey();
			try {
				MetaDictView metaComponent = (MetaDictView) ownerMetaForm.componentByKey(panelKey);
				Class<MetaDictView> instance = MetaDictView.class;
				Object invoke = getPropertiesValue(instance, columnKey, metaComponent);
				if ("GetFilters".equalsIgnoreCase(columnKey)) {
					dataTable.setObject(row, columnKey, "请点击设置");
				} else if (invoke instanceof MetaBaseScript) {
					dataTable.setObject(row, columnKey, ((MetaBaseScript) invoke).getContent());
				} else if ("GetColumnCollection".equalsIgnoreCase(columnKey)) {
					if (invoke != null) {
						StringBuilder res = new StringBuilder();
						for (int j = 0; j < ((MetaDictViewColumnCollection) invoke).size(); j++) {
							res.append("{Key:").append(((MetaDictViewColumnCollection) invoke).get(j).getKey()).append(", ");
							res.append("Caption:").append(((MetaDictViewColumnCollection) invoke).get(j).getCaption()).append(", ");
							res.append("Width:").append(((MetaDictViewColumnCollection) invoke).get(j).getWidth()).append("},");
						}
						dataTable.setObject(row, columnKey, res.substring(0, res.length() - 1));

					} else {
						dataTable.setObject(row, columnKey, "");
					}
				} else {
					if (Objects.isNull(invoke)) {
						invoke = this.getDefaultValue(columnKey);
					}
					dataTable.setObject(row, columnKey, invoke);
				}
			} catch (Exception e) {
				dataTable.setObject(row, columnKey, ConstantUtil.NODESIGNFIELD);
			}
		}
		dataTable.setState(RowState.NORMAL);
	}

	// 操作集合属性
	private void loadOperationCollection(DataTable designDataTable, MetaForm erpMetaForm, String erpCompKey) throws Throwable {
		boolean beExtendedFlag = MetaFormHelper.isBeExtended(erpMetaForm);
		boolean vestFlag = StringUtils.isNotBlank(erpMetaForm.getExtend());
		boolean specVestFlag = Objects.equals(erpMetaForm.getMergeToSource(), Boolean.TRUE);
		Triple<Boolean, Boolean, Boolean> erpVestTriple = Triple.of(beExtendedFlag, vestFlag, specVestFlag);

		List<String> optionKeyList;
		if (StringUtils.isNotBlank(erpMetaForm.getExtend())) {
			String erpXmlFilePath = LoadFileTree.getPathByFormKey(erpMetaForm.getExtend());
			// XmlTree
			String tmpPath = XmlFileProcessor.instance.getTmpFile(erpXmlFilePath);
			String filePath = StringUtils.isNotBlank(tmpPath) ? tmpPath : erpXmlFilePath;
			XmlTree xmlTree = Xml4jUtil.parseTree(filePath);
			TagNode rootNode = xmlTree.getRoot();
			List<TagNode> tagNodeList = rootNode.findNodesByTagName2(ConstantUtil.OPERATION_COLLECTION);
			optionKeyList = tagNodeList.stream()
					.filter(tagNode -> StringUtils.isNotBlank(tagNode.getAttributes().get(ConstantUtil.KEY)))
					.map(tagNode -> tagNode.getAttributes().get(ConstantUtil.KEY))
					.collect(Collectors.toList());
		} else {
			optionKeyList = Collections.emptyList();
		}

		MetaOperationCollection operationCollection = (MetaOperationCollection) erpMetaForm.getOperationCollection().get(erpCompKey);
		int rowIndex = designDataTable.append();
		designDataTable.setString(rowIndex, ConstantUtil.KEY, operationCollection.getKey());
		designDataTable.setString(rowIndex, "ControlType", operationCollection.getTagName());
		designDataTable.setString(rowIndex, ConstantUtil.CAPTION, operationCollection.getCaption());
		designDataTable.setString(rowIndex, ConstantUtil.ENABLE, operationCollection.getEnable());
		designDataTable.setString(rowIndex, ConstantUtil.VISIBLE, operationCollection.getVisible());

		MetaBaseScript metaOperationAction = operationCollection.getAction();
		if (Objects.nonNull(metaOperationAction)) {
			designDataTable.setString(rowIndex, ConstantUtil.ACTION, metaOperationAction.getContent());
		} else {
			designDataTable.setString(rowIndex, ConstantUtil.ACTION, "");
		}

		if (erpVestTriple.getLeft()) {
			designDataTable.setInt(rowIndex, "BeExtendedFlag", 1);
		} else {
			designDataTable.setInt(rowIndex, "BeExtendedFlag", 0);
		}

		if (erpVestTriple.getMiddle()) {
			designDataTable.setInt(rowIndex, "VestFlag", 1);
		} else {
			designDataTable.setInt(rowIndex, "VestFlag", 0);
		}

		if (erpVestTriple.getRight()) {
			designDataTable.setInt(rowIndex, "SpecVestFlag", 1);
		} else {
			designDataTable.setInt(rowIndex, "SpecVestFlag", 0);
		}

		if (optionKeyList.contains(operationCollection.getKey())) {
			designDataTable.setInt(rowIndex, "ExtendFlag", 1);
		} else {
			designDataTable.setInt(rowIndex, "ExtendFlag", 0);
		}
		designDataTable.setState(RowState.NORMAL);
	}

	private void loadEmbedTables(DataTable dataTable,
								 MetaForm metaForm,
								 String ownerFormKey
	) throws Throwable {
		MetaDataObject erpMetaDataObject = this.getErpMetaDataObject(metaForm, ownerFormKey);
		if (Objects.isNull(erpMetaDataObject)) {
			return;
		}
		MetaEmbedTableCollection embedTables = erpMetaDataObject.getEmbedTables();
		if (Objects.isNull(embedTables) || embedTables.size() < 1) {
			return;
		}

		String path = this.getErpDataObjectFilePath(metaForm, erpMetaDataObject, ownerFormKey);
		String tmpPath = XmlFileProcessor.instance.getTmpFile(path);
		String filePath = StringUtils.isNotBlank(tmpPath) ? tmpPath : path;

		XmlTree xmlTree = Xml4jUtil.parseTree(filePath);
		if (Objects.isNull(xmlTree)) {
			String pathByDataObject = LoadFileTree.getPathByDataObject(path);
			xmlTree = Xml4jUtil.parseTree(pathByDataObject);
		}

		List<String> keyList = new ArrayList<>();
		TagNode rootNode = xmlTree.getRoot();
		List<TagNode> embedTableCollectionNodeList = rootNode.findNodesByTagName("EmbedTableCollection");
		if (CollectionUtils.isNotEmpty(embedTableCollectionNodeList)) {
			List<TagNode> embedTableNodeList = embedTableCollectionNodeList.get(0).findNodesByTagName("EmbedTable");
			if (CollectionUtils.isNotEmpty(embedTableNodeList)) {
				for (TagNode embedTableNode : embedTableNodeList) {
					Map<String, String> attributes = embedTableNode.getAttributes();
					String key = attributes.get("TableKeys");
					keyList.add(key);
				}
			}
		}

		for (MetaEmbedTable embedTable : embedTables) {
			int row = dataTable.append();
			String objectKey = embedTable.getObjectKey();
			String tableKeys = embedTable.getTableKeys();
			dataTable.setString(row, "ObjectKey", objectKey);
			dataTable.setString(row, "TableKey", tableKeys);

			if (keyList.contains(tableKeys)) {
				dataTable.setInt(row, "ExtendFlagInEmbedTable", 0);
			} else {
				dataTable.setInt(row, "ExtendFlagInEmbedTable", 1);
			}
			dataTable.setState(RowState.NORMAL);
		}
	}

	private void loadDataObjectEvent(DefaultContext context, Document document, MetaForm erpMetaForm, String erpXmlKey, DataTable designParameterDataTable, DataTable designEventDataTable) throws Throwable {
		String eventName = designEventDataTable.getKey();
		if(eventName.startsWith("ED_")){
			eventName = eventName.substring(3);
		}
		if (StringUtils.equals(eventName, MetaOIDFilter.TAG_NAME)) {
			if (Objects.isNull(erpMetaForm)) {
				return;
			}

			MetaDataSource metaDataSource = erpMetaForm.getDataSource();
			if(metaDataSource == null) return;
			MetaOIDFilter metaOIDFilter = metaDataSource.getOIDFilter();
			if (Objects.isNull(metaOIDFilter)) {
				return;
			}

			Long oid = context.applyNewOID();
			int rowIndex = designEventDataTable.append();
			designEventDataTable.setString(rowIndex, "Type", OIDFilterType.toString(metaOIDFilter.getType()));
			designEventDataTable.setLong(rowIndex, ConstantUtil.OID, oid);

			int filterType = metaOIDFilter.getType();
			if (filterType == OIDFilterType.Formula) {
				designEventDataTable.setString(rowIndex, "Formula", metaOIDFilter.getFormula());
				return;
			}

			if (filterType == OIDFilterType.Interface) {
				designEventDataTable.setString(rowIndex, "Interface", metaOIDFilter.getImpl());
				return;
			}

			if (filterType == OIDFilterType.Query) {
				MetaStatement metaStatement = metaOIDFilter.getStatement();
				if (Objects.isNull(metaStatement)) {
					return;
				}
				designEventDataTable.setString(rowIndex, "Sql", metaStatement.getContent());
				designEventDataTable.setState(RowState.NORMAL);

				MetaParameterCollection metaParameterCollection = metaOIDFilter.getParameterCollection();
				if (Objects.isNull(metaParameterCollection)) {
					return;
				}

				for (MetaParameter parameter : metaParameterCollection) {
					int rowNo = designParameterDataTable.append();
					designParameterDataTable.setLong(rowNo, ConstantUtil.POID, oid);
					designParameterDataTable.setString(rowNo, "Description", parameter.getDescription());
					designParameterDataTable.setString(rowNo, "DataType", DataType.toString(parameter.getDataType()));

					String sourceType = ParameterSourceType.format(parameter.getSourceType());
					if (StringUtils.isNotBlank(sourceType)) {
						designParameterDataTable.setString(rowNo, "SourceType", sourceType);
						designParameterDataTable.setString(rowNo, "Value", parameter.getValue());
					} else {
						designParameterDataTable.setString(rowNo, "SourceType", "Formula");
						designParameterDataTable.setString(rowNo, "Value", parameter.getFormula());
					}
					designParameterDataTable.setState(RowState.NORMAL);
				}
				return;
			}
			return;
		}

		if (StringUtils.equals(eventName, MetaStatusCollection.TAG_NAME)) {
			MetaDataObject erpMetaDataObject = this.getErpMetaDataObject(erpMetaForm, erpXmlKey);
			if (Objects.isNull(erpMetaDataObject)) {
				return;
			}

			MetaStatusCollection metaStatusCollection = erpMetaDataObject.getStatusCollection();
			if (Objects.isNull(metaStatusCollection)) {
				return;
			}

			for (MetaStatus metaStatus : metaStatusCollection) {
				int rowIndex = designEventDataTable.append();
				designEventDataTable.setString(rowIndex, "Key", metaStatus.getKey());
				designEventDataTable.setString(rowIndex, "Caption", metaStatus.getCaption());
				designEventDataTable.setObject(rowIndex, "StatusValue", metaStatus.getValue());
				if (metaStatus.isStandalone()) {
					designEventDataTable.setObject(rowIndex, "IsStandalone", "1");
				} else {
					designEventDataTable.setObject(rowIndex, "IsStandalone", "0");
				}
				designEventDataTable.setState(RowState.NORMAL);
			}
			return;
		}

		if (StringUtils.equals(eventName, MetaStatusTriggerCollection.TAG_NAME)) {
			MetaDataObject erpMetaDataObject = this.getErpMetaDataObject(erpMetaForm, erpXmlKey);
			if (Objects.isNull(erpMetaDataObject)) {
				return;
			}

			MetaStatusTriggerCollection metaStatusTriggerCollection = erpMetaDataObject.getStatusTriggerCollection();
			if (Objects.isNull(metaStatusTriggerCollection)) {
				return;
			}

			for (MetaStatusTrigger metaStatusTrigger : metaStatusTriggerCollection) {
				int rowIndex = designEventDataTable.append();
				designEventDataTable.setString(rowIndex, "Key", metaStatusTrigger.getStatusKey());
				designEventDataTable.setString(rowIndex, "Content", metaStatusTrigger.getContent());
				designEventDataTable.setState(RowState.NORMAL);
			}
			return;
		}

		if (StringUtils.equals(eventName, MetaExtendCollection.TAG_NAME)) {
			MetaDataObject erpMetaDataObject = this.getErpMetaDataObject(erpMetaForm, erpXmlKey);
			if (Objects.isNull(erpMetaDataObject)) {
				return;
			}

			MetaExtendCollection metaExtendCollection = erpMetaDataObject.getExtendCollection();
			if (Objects.isNull(metaExtendCollection)) {
				return;
			}

			for (MetaExtend extend : metaExtendCollection) {
				int rowIndex = designEventDataTable.append();
				designEventDataTable.setString(rowIndex, "Alias", extend.getAlias());
				designEventDataTable.setString(rowIndex, "ClassName", extend.getClassName());
				designEventDataTable.setState(RowState.NORMAL);
			}
			return;
		}

		// TODO 这里取值很奇怪，为什么从XML文件中取？
		if (StringUtils.equals(eventName, MetaCheckRuleCollection.TAG_NAME)) {
			MetaDataObject erpMetaDataObject = this.getErpMetaDataObject(erpMetaForm, erpXmlKey);
			if (Objects.isNull(erpMetaDataObject)) {
				return;
			}
			MetaCheckRuleCollection checkRuleCollection = erpMetaDataObject.getCheckRuleCollection();
			if (Objects.isNull(checkRuleCollection)) {
				return;
			}

			String path = this.getErpDataObjectFilePath(erpMetaForm, erpMetaDataObject, erpXmlKey);
			String tmpPath = XmlFileProcessor.instance.getTmpFile(path);
			String filePath = StringUtils.isNotBlank(tmpPath) ? tmpPath : path;

			XmlTree xmlTree = Xml4jUtil.parseTree(filePath);
			if (Objects.isNull(xmlTree)) {
				String pathByDataObject = LoadFileTree.getPathByDataObject(path);
				xmlTree = Xml4jUtil.parseTree(pathByDataObject);
			}

			List<String> keyList = new ArrayList<>();
			TagNode rootNode = xmlTree.getRoot();
			List<TagNode> checkRuleCollectionNodeList = rootNode.findNodesByTagName(MetaCheckRuleCollection.TAG_NAME);
			if (CollectionUtils.isNotEmpty(checkRuleCollectionNodeList)) {
				List<TagNode> checkRuleNodeList = checkRuleCollectionNodeList.get(0).findNodesByTagName("CheckRule");
				if (CollectionUtils.isNotEmpty(checkRuleNodeList)) {
					for (TagNode checkRuleNode : checkRuleNodeList) {
						Map<String, String> attributes = checkRuleNode.getAttributes();
						keyList.add(attributes.get("ErrorInfo"));
					}
				}
			}

			for (MetaCheckRule metaCheckRule : checkRuleCollection) {
				int rowIndex = designEventDataTable.append();
				designEventDataTable.setString(rowIndex, "ErrorInfo", metaCheckRule.getErrorInfo());
				designEventDataTable.setString(rowIndex, "CheckRuleScript", metaCheckRule.getContent());
				if (keyList.contains(metaCheckRule.getErrorInfo())) {
					designEventDataTable.setInt(rowIndex, "ExtendFlagInCheckRule", 0);
				} else {
					designEventDataTable.setInt(rowIndex, "ExtendFlagInCheckRule", 1);
				}
				designEventDataTable.setState(RowState.NORMAL);
			}
			return;
		}

		if (StringUtils.equals(MetaMacroCollection.TAG_NAME, eventName)) {
			MetaDataObject erpMetaDataObject = this.getErpMetaDataObject(erpMetaForm, erpXmlKey);
			if (Objects.isNull(erpMetaDataObject)) {
				return;
			}

			MetaMacroCollection metaMacroCollection = erpMetaDataObject.getMacroCollection();
			if (Objects.isNull(metaMacroCollection)) {
				return;
			}
			for (MetaMacro metaMacro : metaMacroCollection) {
				int rowIndex = designEventDataTable.append();
				// 之后可能修改成表单属性的宏公式列表类型
				designEventDataTable.setString(rowIndex, "Key", metaMacro.getKey());
				designEventDataTable.setString(rowIndex, "Args", metaMacro.getArgs());
				designEventDataTable.setString(rowIndex, "Content", metaMacro.getContent());
				designEventDataTable.setState(RowState.NORMAL);
			}
			return;
		}

		final BiConsumer<Function<MetaDataObject, GenericNoKeyCollection<MetaProcess>>, String> biConsumer = (function, prefix) -> {
			MetaDataObject erpMetaDataObject = this.getErpMetaDataObject(erpMetaForm, erpXmlKey);
			if (Objects.isNull(erpMetaDataObject)) {
				return;
			}

			GenericNoKeyCollection<MetaProcess> metaProcesses = function.apply(erpMetaDataObject);
			if (Objects.isNull(metaProcesses)) {
				return;
			}

			for (MetaProcess metaProcess : metaProcesses) {
				int rowIndex = designEventDataTable.append();
				designEventDataTable.setString(rowIndex, prefix + ConstantUtil.DESCRIPTION, metaProcess.getDescription());
				designEventDataTable.setString(rowIndex, prefix + ConstantUtil.SCRIPT, metaProcess.getContent());
				designEventDataTable.setState(RowState.NORMAL);
			}
		};

		if (StringUtils.equals(eventName, MetaPreLoadProcess.TAG_NAME)) {
			biConsumer.accept(MetaDataObject::getPreLoadProcess, "Load");
			return;
		}

		if (StringUtils.equals(eventName, MetaPostLoadProcess.TAG_NAME)) {
			biConsumer.accept(MetaDataObject::getPostLoadProcess, "Load");
			return;
		}

		if (StringUtils.equals(eventName, MetaPreSaveProcess.TAG_NAME)) {
			biConsumer.accept(MetaDataObject::getPreSaveProcess, "Save");
			return;
		}

		if (StringUtils.equals(eventName, MetaPostSaveProcess.TAG_NAME)) {
			biConsumer.accept(MetaDataObject::getPostSaveProcess, "Save");
			return;
		}

		if (StringUtils.equals(eventName, MetaPreDeleteProcess.TAG_NAME)) {
			biConsumer.accept(MetaDataObject::getPreDeleteProcess, "Delete");
			return;
		}

		if (StringUtils.equals(eventName, MetaPostDeleteProcess.TAG_NAME)) {
			biConsumer.accept(MetaDataObject::getPostDeleteProcess, "Delete");
			return;
		}
	}

	// 操作属性
	private void loadOperation(MetaForm erpMetaForm, MetaOperationCollection erpMetaOperationCollection, String erpCompKey, DataTable designDataTable) throws Throwable {
		boolean beExtendedFlag = MetaFormHelper.isBeExtended(erpMetaForm);
		boolean vestFlag = StringUtils.isNotBlank(erpMetaForm.getExtend());
		boolean specVestFlag = Objects.equals(erpMetaForm.getMergeToSource(), Boolean.TRUE);
		Triple<Boolean, Boolean, Boolean> erpVestTriple = Triple.of(beExtendedFlag, vestFlag, specVestFlag);

		List<String> optionKeyList;
		if (StringUtils.isNotBlank(erpMetaForm.getExtend())) {
			String erpXmlFilePath = LoadFileTree.getPathByFormKey(erpMetaForm.getExtend());
			// XmlTree
			String tmpPath = XmlFileProcessor.instance.getTmpFile(erpXmlFilePath);
			String filePath = StringUtils.isNotBlank(tmpPath) ? tmpPath : erpXmlFilePath;
			XmlTree xmlTree = Xml4jUtil.parseTree(filePath);
			TagNode rootNode = xmlTree.getRoot();
			List<TagNode> tagNodeList = rootNode.findNodesByTagName(ConstantUtil.OPERATION);
			optionKeyList = tagNodeList.stream().map(tagNode -> tagNode.getAttributes().get(ConstantUtil.KEY)).collect(Collectors.toList());
		} else {
			optionKeyList = Collections.emptyList();
		}
		recursiveLoadOperation(erpMetaOperationCollection, erpCompKey, erpVestTriple, optionKeyList, designDataTable);
	}

	private void recursiveLoadOperation(MetaOperationCollection erpMetaOperationCollection, String erpCompKey, Triple<Boolean, Boolean, Boolean> erpVestTriple, List<String> optionKeyList, DataTable designDataTable) {
		for (KeyPairCompositeObject keyPairCompositeObject : erpMetaOperationCollection) {
			if (keyPairCompositeObject instanceof MetaOperation) {
				MetaOperation metaOperation = (MetaOperation) keyPairCompositeObject;
				if (!StringUtils.equals(metaOperation.getKey(), erpCompKey)) {
					continue;
				}

				int rowIndex = designDataTable.append();
				designDataTable.setString(rowIndex, ConstantUtil.KEY, metaOperation.getKey());
				designDataTable.setString(rowIndex, "ControlType", metaOperation.getTagName());
				designDataTable.setString(rowIndex, ConstantUtil.CAPTION, metaOperation.getCaption());
				designDataTable.setString(rowIndex, ConstantUtil.ENABLE, metaOperation.getEnable());
				designDataTable.setString(rowIndex, ConstantUtil.VISIBLE, metaOperation.getVisible());
				designDataTable.setString(rowIndex, ConstantUtil.REF_KEY, metaOperation.getRefKey());
				designDataTable.setString(rowIndex, ConstantUtil.TAG, metaOperation.getTag());
				designDataTable.setString(rowIndex, "GetActivity", metaOperation.getActivity());
				designDataTable.setString(rowIndex, "GetTCode", metaOperation.getTCode());

				MetaBaseScript metaOperationAction = metaOperation.getAction();
				if (Objects.nonNull(metaOperationAction)) {
					designDataTable.setString(rowIndex, ConstantUtil.ACTION, metaOperationAction.getContent());
				} else {
					designDataTable.setString(rowIndex, ConstantUtil.ACTION, "");
				}

				if (erpVestTriple.getLeft()) {
					designDataTable.setInt(rowIndex, "BeExtendedFlag", 1);
				} else {
					designDataTable.setInt(rowIndex, "BeExtendedFlag", 0);
				}

				if (erpVestTriple.getMiddle()) {
					designDataTable.setInt(rowIndex, "VestFlag", 1);
				} else {
					designDataTable.setInt(rowIndex, "VestFlag", 0);
				}

				if (erpVestTriple.getRight()) {
					designDataTable.setInt(rowIndex, "SpecVestFlag", 1);
				} else {
					designDataTable.setInt(rowIndex, "SpecVestFlag", 0);
				}

				if (optionKeyList.contains(metaOperation.getKey())) {
					designDataTable.setInt(rowIndex, "ExtendFlag", 1);
				} else {
					designDataTable.setInt(rowIndex, "ExtendFlag", 0);
				}
				designDataTable.setState(RowState.NORMAL);
				return;
			}
			if (keyPairCompositeObject instanceof MetaOperationCollection) {
				recursiveLoadOperation((MetaOperationCollection) keyPairCompositeObject, erpCompKey, erpVestTriple, optionKeyList, designDataTable);
			}
		}
	}

	private void loadChartDataSource(DefaultContext context, MetaForm erpMetaForm, String erpXmlFilePath, DataTable dataTable) throws Throwable {
		String filePath = erpXmlFilePath;
		if (Objects.nonNull(erpMetaForm)) {
			filePath = LoadFileTree.getPathByFormKey(erpMetaForm.getKey());
		}
		String tmpFilePath = XmlFileProcessor.instance.getTmpFile(filePath);
		if (StringUtils.isNotBlank(tmpFilePath)) {
			filePath = tmpFilePath;
		}

		XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(FilePathHelper.toBackFilePath(filePath));
		if (Objects.isNull(xmlTreeWithPath)) {
			return;
		}

		XmlTree xmlTree = xmlTreeWithPath.xmlTree;
		String compKey = (String) context.getPara(ConstantUtil.COMP_KEY);
		String xmlTreeKey = "Chart@" + compKey;
		TagNode chartNode = xmlTree.getTagNode(xmlTreeKey);
		TagNode dataSourceNode = chartNode.getChildByTagName(ConstantUtil.CHART_DATASOURCE);
		if (dataSourceNode != null) {
			TagNode categoryNode = dataSourceNode.getOrCreateChildByTagName(ConstantUtil.CATEGORY);
			Map<String, String> dataSourceAttributes = dataSourceNode.getAttributes();
			Map<String, String> categoryAttributes = categoryNode.getAttributes();

			int rowIndex = dataTable.append();
			dataTable.setString(rowIndex, ProPertyConstant.BindingKey, dataSourceAttributes.get(ProPertyConstant.BindingKey));
			dataTable.setString(rowIndex, ProPertyConstant.CategoryDataKey, categoryAttributes.get(ProPertyConstant.DataKey));
			dataTable.setState(RowState.NORMAL);
		}
	}

	private void loadSeriesDtl(DefaultContext context, MetaForm erpMetaForm, String erpXmlFilePath, DataTable dataTable) throws Throwable {
		String filePath = erpXmlFilePath;
		if (Objects.nonNull(erpMetaForm)) {
			filePath = LoadFileTree.getPathByFormKey(erpMetaForm.getKey());
		}
		String tmpFilePath = XmlFileProcessor.instance.getTmpFile(filePath);
		if (StringUtils.isNotBlank(tmpFilePath)) {
			filePath = tmpFilePath;
		}

		XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(FilePathHelper.toBackFilePath(filePath));
		if (Objects.isNull(xmlTreeWithPath)) {
			return;
		}

		XmlTree xmlTree = xmlTreeWithPath.xmlTree;
		String compKey = (String) context.getPara(ConstantUtil.COMP_KEY);
		String xmlTreeKey = "Chart@" + compKey;
		TagNode chartNode = xmlTree.getTagNode(xmlTreeKey);
		TagNode dataSourceNode = chartNode.getChildByTagName(ConstantUtil.CHART_DATASOURCE);
		if (dataSourceNode != null) {
			List<AbstractNode> seriesNodes = dataSourceNode.getChildrenByTagName(ConstantUtil.SERIES);
			for (AbstractNode abstractNode : seriesNodes) {
				TagNode seriesNode = (TagNode)abstractNode;
				Map<String, String> seriesAttributes = seriesNode.getAttributes();
				int rowIndex = dataTable.append();
				dataTable.setString(rowIndex, ProPertyConstant.SeriesDataKey, seriesAttributes.get(ProPertyConstant.DataKey));
				dataTable.setString(rowIndex, ProPertyConstant.SplitDataKey, seriesAttributes.get(ProPertyConstant.SplitDataKey));
				dataTable.setString(rowIndex, ProPertyConstant.Title, seriesAttributes.get(ProPertyConstant.Title));
				dataTable.setState(RowState.NORMAL);
			}
		}
	}

	//表单操作集合
	private void loadTableOperationCollection(DefaultContext context, DataTable erpOperationDataTable, MetaForm erpMetaForm,DataTable erpOperationDetailDataTable,
											  MetaOperationCollection operationCollection, HashMap<String, KeyPairCompositeObject> operationCollectionSrcMap,Long POID) throws Throwable {

		int vestFlag = 0;
		int specVestFlag = 0;
		int beExtendedFlag = 0;
		HashMap<String, KeyPairCompositeObject> operationCollectionExtendSrcMap = new HashMap<>();
		if (erpMetaForm !=null && StringUtils.isNotEmpty(erpMetaForm.getExtend())){
			vestFlag = 1;
			if (erpMetaForm.getMergeToSource()){
				specVestFlag = 1;
			}
			MetaForm metaFormSrc = NewFormCmd.loadMetaForm(erpMetaForm.getExtend());
			FormToolOperUtil.getOperation(metaFormSrc.getOperationCollection(),operationCollectionExtendSrcMap);
		} else if (erpMetaForm !=null){
			for (MetaFormProfile metaFormProfile : MetaFactory.getGlobalInstance().getMetaFormList()) {
				if (erpMetaForm.getKey().equalsIgnoreCase(metaFormProfile.getExtend())){
					beExtendedFlag = 1 ;
					break;
				}
			}
		}
		if (operationCollection !=null){
			for (KeyPairCompositeObject keyPairCompositeObject : operationCollection.sortMetaOperationCollection((MetaOperationCollection) operationCollection.depthClone())) {
				Long oid = context.applyNewOID();
				String shortCuts = "";
				String tableRefKey = "";
				String tableTag = "";
				String getTCode = "";
				String getActivity = "";
				Boolean expand = null;
				String expandSource = "";
				String actionText = "";
				Boolean isTransfer = null;
				int tableType = 0;
				if (keyPairCompositeObject instanceof MetaOperationCollection) {
					MetaOperationCollection metaOperation = (MetaOperationCollection) keyPairCompositeObject;
					tableType = 1;
					MetaBaseScript action1 = metaOperation.getAction();
					if (action1 != null) {
						actionText = action1.getContent();
					}
					int rowIndex = erpOperationDetailDataTable.append();
					erpOperationDetailDataTable.setLong(rowIndex, ConstantUtil.OID, oid);
					erpOperationDetailDataTable.setLong(rowIndex, ConstantUtil.POID, POID);
					erpOperationDetailDataTable.setInt(rowIndex, "Sequence", rowIndex);
					erpOperationDetailDataTable.setInt(rowIndex, "Sequence", rowIndex);
					erpOperationDetailDataTable.setInt(rowIndex, "TableType", tableType);
					String key = keyPairCompositeObject.getKey();
					erpOperationDetailDataTable.setString(rowIndex, "TableMark", key);
					erpOperationDetailDataTable.setString(rowIndex, "TableCaption", metaOperation.getCaption());
					erpOperationDetailDataTable.setObject(rowIndex, "NeedAccessLog", false);
					erpOperationDetailDataTable.setString(rowIndex, "TableEnable", metaOperation.getEnable());
					erpOperationDetailDataTable.setString(rowIndex, "TableVisible", metaOperation.getVisible());
					erpOperationDetailDataTable.setString(rowIndex, "VisibleDependency", metaOperation.getVisibleDependency());
					erpOperationDetailDataTable.setString(rowIndex, "EnableDependency", metaOperation.getEnableDependency());
					erpOperationDetailDataTable.setObject("SelfDisable", metaOperation.isSelfDisable());
					erpOperationDetailDataTable.setString(rowIndex, "TableRefKey", tableRefKey);
					erpOperationDetailDataTable.setString(rowIndex, "TableTag", tableTag);
					erpOperationDetailDataTable.setString(rowIndex, "ShortCuts", shortCuts);
					erpOperationDetailDataTable.setString(rowIndex, "GetTCode", getTCode);
					erpOperationDetailDataTable.setString(rowIndex, "GetActivity", getActivity);
					erpOperationDetailDataTable.setObject(rowIndex, "Expand", expand);
					erpOperationDetailDataTable.setString(rowIndex, "ExpandSource", expandSource);
					erpOperationDetailDataTable.setString(rowIndex, "TableAction", actionText);
					erpOperationDetailDataTable.setInt(rowIndex, "VestFlag", vestFlag);
					erpOperationDetailDataTable.setInt(rowIndex, "SpecVestFlag", specVestFlag);
					erpOperationDetailDataTable.setInt(rowIndex, "BeExtendedFlag", beExtendedFlag);
					erpOperationDetailDataTable.setInt(rowIndex, "TC_IsFirst", metaOperation.getFirst()!=null&&metaOperation.getFirst()?1:0);
					erpOperationDetailDataTable.setInt(rowIndex, "TC_IsLast", metaOperation.getLast()!=null&&metaOperation.getLast()?1:0);
					erpOperationDetailDataTable.setObject(rowIndex, "IsTransfer", isTransfer);
					if (operationCollectionSrcMap.containsKey(key)){//本表单
						erpOperationDetailDataTable.setInt(rowIndex, "ExtendFlag", 0);
						if (vestFlag == 1){//马甲
							if (operationCollectionExtendSrcMap.containsKey(key)){
								erpOperationDetailDataTable.setInt(rowIndex, "ExtendFlag", 1);
							}
						}
						erpOperationDetailDataTable.setObject(rowIndex, ConstantUtil.DataSourceType, "xml");
					} else {
						erpOperationDetailDataTable.setInt(rowIndex, "ExtendFlag", 1);
						erpOperationDetailDataTable.setObject(rowIndex, ConstantUtil.DataSourceType, "meta");
					}
					erpOperationDetailDataTable.setState(RowState.NORMAL);
					for (KeyPairCompositeObject s1 : metaOperation.sortMetaOperationCollection((MetaOperationCollection) metaOperation.depthClone())) {
						if (s1 instanceof MetaOperation){
							MetaOperation operation = (MetaOperation) s1;
						Long soid = context.applyNewOID();
						MetaBaseScript action = operation.getAction();
						if (action != null) {
							actionText = action.getContent();
						}
						tableType = 0;
						int subRowIndex = erpOperationDataTable.append();
						erpOperationDataTable.setLong(subRowIndex, ConstantUtil.POID, oid);
						erpOperationDataTable.setLong(subRowIndex, ConstantUtil.OID, soid);
						erpOperationDataTable.setInt(subRowIndex, "Sequence", rowIndex);
						erpOperationDataTable.setInt(subRowIndex, "TableType", tableType);
							String key1 = operation.getKey();
						erpOperationDataTable.setString(subRowIndex, "TableMark", key1);
						erpOperationDataTable.setString(subRowIndex, "TableCaption", operation.getCaption());
						String refKey = operation.getRefKey();
						if (StringUtils.isEmpty(refKey)){
							if (operationCollectionSrcMap!=null){
								MetaOperation operationSrc = (MetaOperation) operationCollectionSrcMap.get(operation.getKey());
								if (operationSrc!=null){
									refKey = operationSrc.getRefKey();
								}
							}

						}
						erpOperationDataTable.setString(subRowIndex, "TableRefKey", refKey);
						erpOperationDataTable.setString(subRowIndex, "TableTag", operation.getTag());
						erpOperationDataTable.setString(subRowIndex, "ShortCuts", operation.getShortCuts());
						erpOperationDataTable.setObject(subRowIndex, "NeedAccessLog", operation.getNeedAccessLog());
						erpOperationDataTable.setString(subRowIndex, "GetTCode", operation.getTCode());
						erpOperationDataTable.setString(subRowIndex, "GetActivity", operation.getActivity());
						erpOperationDataTable.setObject(subRowIndex, "Expand", operation.isExpand());
						erpOperationDataTable.setString(subRowIndex, "ExpandSource", operation.getExpandSource());
						erpOperationDataTable.setString(subRowIndex, "TableEnable", operation.getEnable());
						erpOperationDataTable.setString(subRowIndex, "TableVisible", operation.getVisible());
						erpOperationDataTable.setString(subRowIndex, "VisibleDependency", operation.getVisibleDependency());
						erpOperationDataTable.setString(subRowIndex, "EnableDependency", operation.getEnableDependency());
						erpOperationDataTable.setString(subRowIndex, "TableAction", actionText);
						erpOperationDataTable.setInt(subRowIndex, "VestFlag", vestFlag);
						erpOperationDataTable.setInt(subRowIndex, "SpecVestFlag", specVestFlag);
						erpOperationDataTable.setInt(subRowIndex, "BeExtendedFlag", beExtendedFlag);
							erpOperationDataTable.setInt(subRowIndex, "TC_IsFirst", operation.getFirst()!=null&&operation.getFirst()?1:0);
							erpOperationDataTable.setInt(subRowIndex, "TC_IsLast", operation.getLast()!=null&&operation.getLast()?1:0);
						erpOperationDataTable.setObject(subRowIndex, "IsTransfer", operation.isTransfer());
						if (operationCollectionSrcMap.containsKey(key)){//本表单
							erpOperationDataTable.setObject(subRowIndex, ConstantUtil.DataSourceType, "xml");
							erpOperationDataTable.setInt(subRowIndex, "ExtendFlag", 0);
							if (vestFlag == 1){//马甲
								if (operationCollectionExtendSrcMap.containsKey(key)){
									erpOperationDataTable.setInt(subRowIndex, "ExtendFlag", 1);
								}
							}
						} else {
							erpOperationDataTable.setObject(subRowIndex, ConstantUtil.DataSourceType, "meta");
							erpOperationDataTable.setInt(subRowIndex, "ExtendFlag", 1);
						}
						erpOperationDataTable.setState(RowState.NORMAL);
					}

					}
				} else {
					MetaOperation metaOperation = (MetaOperation) keyPairCompositeObject;
					MetaBaseScript action = metaOperation.getAction();
					if (action != null) {
						actionText = action.getContent();
					}
					int rowIndex = erpOperationDetailDataTable.append();
					erpOperationDetailDataTable.setLong(rowIndex, ConstantUtil.OID, oid);
					erpOperationDetailDataTable.setLong(rowIndex, ConstantUtil.POID, POID);
					erpOperationDetailDataTable.setInt(rowIndex, "Sequence", rowIndex);
					erpOperationDetailDataTable.setInt(rowIndex, "TableType", tableType);
					String key = keyPairCompositeObject.getKey();
					erpOperationDetailDataTable.setString(rowIndex, "TableMark", key);
					erpOperationDetailDataTable.setString(rowIndex, "TableCaption", metaOperation.getCaption());
					String refKey = metaOperation.getRefKey();
					if (StringUtils.isEmpty(refKey)){
						if (operationCollectionSrcMap!=null){
							MetaOperation operationSrc = (MetaOperation) operationCollectionSrcMap.get(metaOperation.getKey());
							if (operationSrc!=null){
								refKey = operationSrc.getRefKey();
							}
						}

					}
					erpOperationDetailDataTable.setString(rowIndex, "TableRefKey",refKey );
					erpOperationDetailDataTable.setString(rowIndex, "TableTag", metaOperation.getTag());
					erpOperationDetailDataTable.setString(rowIndex, "ShortCuts", metaOperation.getShortCuts());
					erpOperationDetailDataTable.setObject(rowIndex, "NeedAccessLog", metaOperation.getNeedAccessLog());
					erpOperationDetailDataTable.setString(rowIndex, "GetTCode", metaOperation.getTCode());
					erpOperationDetailDataTable.setString(rowIndex, "GetActivity", metaOperation.getActivity());
					erpOperationDetailDataTable.setObject(rowIndex, "Expand", metaOperation.isExpand());
					erpOperationDetailDataTable.setString(rowIndex, "ExpandSource", metaOperation.getExpandSource());
					erpOperationDetailDataTable.setString(rowIndex, "TableEnable", metaOperation.getEnable());
					erpOperationDetailDataTable.setString(rowIndex, "TableVisible", metaOperation.getVisible());
					erpOperationDetailDataTable.setString(rowIndex, "VisibleDependency", metaOperation.getVisibleDependency());
					erpOperationDetailDataTable.setString(rowIndex, "EnableDependency", metaOperation.getEnableDependency());
					erpOperationDetailDataTable.setString(rowIndex, "TableAction", actionText);
					erpOperationDetailDataTable.setInt(rowIndex, "VestFlag", vestFlag);
					erpOperationDetailDataTable.setInt(rowIndex, "SpecVestFlag", specVestFlag);
					erpOperationDetailDataTable.setInt(rowIndex, "TC_IsFirst", metaOperation.getFirst()!=null&&metaOperation.getFirst()?1:0);
					erpOperationDetailDataTable.setInt(rowIndex, "TC_IsLast", metaOperation.getLast()!=null&&metaOperation.getLast()?1:0);
					erpOperationDetailDataTable.setInt(rowIndex, "BeExtendedFlag", beExtendedFlag);
					erpOperationDetailDataTable.setObject(rowIndex, "IsTransfer", metaOperation.isTransfer());
					if (operationCollectionSrcMap.containsKey(key)){//本表单
						erpOperationDetailDataTable.setObject(rowIndex, ConstantUtil.DataSourceType, "xml");
						erpOperationDetailDataTable.setInt(rowIndex, "ExtendFlag", 0);
						if (vestFlag == 1){//马甲
							if (operationCollectionExtendSrcMap.containsKey(key)){
								erpOperationDetailDataTable.setInt(rowIndex, "ExtendFlag", 1);
							}
						}
					} else {
						erpOperationDetailDataTable.setObject(rowIndex, ConstantUtil.DataSourceType, "meta");
						erpOperationDetailDataTable.setInt(rowIndex, "ExtendFlag", 1);
					}
					erpOperationDetailDataTable.setState(RowState.NORMAL);
				}
			}
		}
	}

	public static XmlTreeWithPath getXmlTree(MetaForm metaForm) throws Throwable {
		String filePath = LoadFileTree.getPathByFormKey(metaForm.getKey());
		return XmlTreeWithPath.parseFilePath(FilePathHelper.toBackFilePath(filePath));
	}

	// 获取当前表单数据对象的xmltree
	public static XmlTreeWithPath getDataObjectXmlTree(MetaDataObject metaDataObject) throws Throwable {
		String filePath = LoadFileTree.loadFilePathByDataObjectFieldKey(metaDataObject.getKey());
		return XmlTreeWithPath.parseFilePath(FilePathHelper.toBackFilePath(filePath));
	}

	// 表单
	private void loadFormTree(DataTable dataTable, MetaForm ownerMetaForm, boolean showOperation) throws Throwable {
		if (!dataTable.getMetaData().constains("ChildrenCount")) {
			dataTable.addColumn(new ColumnInfo("ChildrenCount", DataType.INT));
		}
		String caption = ownerMetaForm.getCaption();
		StringBuilder sb = new StringBuilder(256);
		int row = dataTable.append();
		dataTable.setLong(row, SystemField.OID_SYS_KEY, ((Integer) dataTable.size()).longValue());
		String formKey = ownerMetaForm.getKey();
		dataTable.setString(row, "PanelKey", formKey);
		dataTable.setString(row, ConstantUtil.PARENT_KEY, null);
		dataTable.setString(row, ConstantUtil.CAPTION, caption);
		dataTable.setObject(row, ConstantUtil.NAME, sb.append(formKey).append(" ").append(caption).toString());
		String propertyFormKey = "D_" + ownerMetaForm.getTagName();
		dataTable.setString(row, ConstantUtil.FOCUS_ROW_CHANGED_FORMULA,
				"ShowProperty('" + propertyFormKey + "', 'P2', '" + formKey + "', '" + MetaObjectType.form.name + "', " +
						"'" + "', '" + "', '" + ownerMetaForm.getKey() + "');");
		dataTable.setObject(row, "ChildrenCount", 0);// 展开
		MetaDataSource dataSource = ownerMetaForm.getDataSource();
		MetaOperationCollection operationCollection = ownerMetaForm.getOperationCollection();
		beforeLoadOperation(formKey, dataTable, ownerMetaForm);//表单集合属性
		//beforeLoadCollection(formKey, dataTable, macroCollection, ownerMetaForm.getKey());// 宏公式查询工具
		if (dataSource != null) {
			String refObjectKey = dataSource.getRefObjectKey();
			if (refObjectKey != null && refObjectKey.length() > 0) { // 来源数据对象
				MetaDataObject dataObject = MetaFactory.getGlobalInstance().getDataObject(refObjectKey);
				loadDataObject(dataObject, formKey, dataTable);
			} else { // 新增数据对象
				MetaDataObject dataObject = dataSource.getDataObject();
				MetaTableCollection tableCollection = dataObject.getTableCollection();
				if (tableCollection.size() > 0) { // 表集合中，有一个默认的NODB结尾的表
					loadDataObject(dataObject, formKey, dataTable);
				}
			}
		} else {
			loadDataObject(null, formKey, dataTable);
		}
		if (showOperation) {//显示
			loadOperations(formKey, dataTable, operationCollection, ownerMetaForm);
		}
		loadPanelTree(dataTable, formKey, ownerMetaForm, ownerMetaForm.getKey()); // root

		dataTable.setState(RowState.NORMAL);
	}

	private static void extracted(LinkedHashMap<String, Object> entries, Iterator<Element> it, LinkedHashMap<String,
			Object> entryRelationItems) {
		Entry entry;

		EntryItem entryItem;
		while (it.hasNext()) {
			Element e = it.next();
			if (Objects.isNull(e.attribute(ConstantUtil.KEY))) {
				continue;
			}
			if ("Entry".equals(e.getName())) {
				//获取id属性(attribute是属性的意思)
				entry = new Entry();
				LinkedHashMap<String, Object> entryItems = new LinkedHashMap<>();
				Attribute key = e.attribute(ConstantUtil.KEY);
				Attribute caption = e.attribute(ConstantUtil.CAPTION);
				entry.setKey(key.getStringValue());
				entry.setId(key.getStringValue());
				entry.setTitle(caption.getStringValue());
				entry.setCaption(caption.getStringValue());
				Attribute open = e.attribute("Open");
				if (null != open) {
					entry.setOpen(open.getStringValue());
				} else {
					entry.setOpen("");
				}
				Attribute visible = e.attribute("Visible");
				if (null != visible) {
					entry.setVisible(visible.getStringValue());
				} else {
					entry.setVisible("");
				}
				Attribute icon = e.attribute("Icon");
				if (null != icon) {
					entry.setIcon(icon.getStringValue());
				} else {
					entry.setIcon("");
				}
				Attribute onClick = e.attribute("OnClick");
				if (null != onClick) {
					entry.setOnClick(onClick.getStringValue().trim());
				} else {
					entry.setOnClick("");
				}
				entries.put(entry.getKey(), entry);
				entryRelationItems.put(entry.getKey(), entry);
				extracted(entryItems, e.elementIterator(), entryRelationItems);
				entry.setChildren(entryItems);
			} else if ("EntryItem".equals(e.getName())) {
				entryItem = new EntryItem();
				entryItem.setKey(e.attribute(ConstantUtil.KEY).getStringValue().trim());
				entryItem.setId(e.attribute(ConstantUtil.KEY).getStringValue().trim());
				entryItem.setCaption(e.attribute(ConstantUtil.CAPTION).getStringValue().trim());
				entryItem.setTitle(e.attribute(ConstantUtil.CAPTION).getStringValue().trim());
				Attribute enable = e.attribute("Enable");
				if (null != enable) {
					entryItem.setEnable(enable.getStringValue());
				} else {
					entryItem.setEnable("");
				}
				Attribute parameters = e.attribute("Parameters");
				if (null != parameters) {
					entryItem.setParameters(parameters.getStringValue().trim());
				} else {
					entryItem.setParameters("");
				}

				Attribute visible1 = e.attribute("Visible");
				if (null != visible1) {
					entryItem.setVisible(visible1.getStringValue().trim());
				} else {
					entryItem.setVisible("");
				}
				Attribute icon1 = e.attribute("Icon");
				if (null != icon1) {
					entryItem.setIcon(icon1.getStringValue().trim());
				} else {
					entryItem.setIcon("");
				}

				Attribute onClick1 = e.attribute("OnClick");
				if (null != onClick1) {
					entryItem.setOnClick(onClick1.getStringValue().trim());
				} else {
					entryItem.setOnClick("");
				}
				Attribute single = e.attribute("Single");
				if (null != single) {
					entryItem.setSingle(single.getStringValue().trim());
				} else {
					entryItem.setSingle("true");
				}
				Attribute target = e.attribute("Target");
				if (null != target) {
					entryItem.setTarget(target.getStringValue().trim());
				} else {
					entryItem.setTarget("new");
				}
				Attribute formKey = e.attribute("FormKey");
				if (null != formKey) {
					entryItem.setFormKey(formKey.getStringValue().trim());
				} else {
					entryItem.setFormKey("");
				}
				entries.put(entryItem.getKey(), entryItem);
				entryRelationItems.put(entryItem.getKey(), entryItem);
			}
		}
	}

	// 表单
	private static void loadEntrysTree2(DataTable dataTable, String filePath) throws Throwable {

		if (!dataTable.getMetaData().constains("ChildrenCount")) {
			dataTable.addColumn(new ColumnInfo("ChildrenCount", DataType.INT));
		}

		returnEntryMap = returnEntryMap(filePath);
		//noinspection unchecked
		LinkedHashMap<String, Object> allList = (LinkedHashMap<String, Object>) returnEntryMap.get("allList");
		allList.forEach((key, ob) -> {
			int row = dataTable.append();
			dataTable.setString(0, "filePath", filePath);
			dataTable.setLong(row, SystemField.OID_SYS_KEY, ((Integer) dataTable.size()).longValue());
			Entry entry = (Entry) ob;
			dataTable.setString(row, ConstantUtil.KEY, key);
			dataTable.setString(row, ConstantUtil.CAPTION, entry.getCaption());
			dataTable.setString(row, ConstantUtil.NAME, entry.getCaption() + "(" + entry.getChildren().size() + ")");
			dataTable.setString(row, "Open", StringUtils.isEmpty(entry.getOpen()) ? "false" : entry.getOpen());
			dataTable.setString(row, "Type", "Root");
			dataTable.setString(row, ConstantUtil.PARENT_KEY, null);
			dataTable.setObject(row, "ChildrenCount", 0);//展开

			LinkedHashMap<String, Object> children = entry.getChildren();
			String entryKey = entry.getKey();

			loadEntry(dataTable, children, entryKey);
			dataTable.setState(RowState.NORMAL);
		});
	}

	/**
	 * 通过反射使用
	 */
	@SuppressWarnings("unused")
	public static void loadEntrysTree(DataTable dataTable, String parentKey) {
		if (!dataTable.getMetaData().constains("ChildrenCount")) {
			dataTable.addColumn(new ColumnInfo("ChildrenCount", DataType.INT));
		}
		Object o = returnEntryMap.get(parentKey);
		if (o instanceof Entry) {
			loadEntry(dataTable, ((Entry) o).getChildren(), ((Entry) o).getKey());
		}
	}

	private static void loadEntry(DataTable dataTable, LinkedHashMap<String, Object> children, String entryKey) {
		children.forEach((subkey, subob) -> {
			if (subob instanceof EntryItem) {
				int subrow = dataTable.append();
				dataTable.setLong(subrow, SystemField.OID_SYS_KEY, ((Integer) dataTable.size()).longValue());
				EntryItem subEntryItem = (EntryItem) subob;
				dataTable.setString(subrow, ConstantUtil.KEY, subkey);
				dataTable.setString(subrow, ConstantUtil.CAPTION, subEntryItem.getCaption());
				dataTable.setString(subrow, ConstantUtil.NAME, subEntryItem.getCaption());
				dataTable.setString(subrow, ConstantUtil.PARENT_KEY, entryKey);
				dataTable.setString(subrow, ConstantUtil.VISIBLE, subEntryItem.getVisible());
				dataTable.setString(subrow, ConstantUtil.ENABLE, subEntryItem.getEnable());
				dataTable.setString(subrow, "Parameters", subEntryItem.getParameters());
				dataTable.setString(subrow, "Icon", subEntryItem.getIcon());
				dataTable.setString(subrow, "OnClick", subEntryItem.getOnClick());
				dataTable.setString(subrow, "Single", subEntryItem.getSingle());
				dataTable.setString(subrow, "Target", subEntryItem.getTarget());
				dataTable.setString(subrow, "FormKey", subEntryItem.getFormKey());
				dataTable.setString(subrow, "Type", "EntryItem");
				dataTable.setObject(subrow, "ChildrenCount", 0);//展开
			} else if (subob instanceof Entry) {
				int subrow = dataTable.append();
				dataTable.setLong(subrow, SystemField.OID_SYS_KEY, ((Integer) dataTable.size()).longValue());
				Entry subEntry = (Entry) subob;
				dataTable.setString(subrow, ConstantUtil.KEY, subkey);
				dataTable.setString(subrow, ConstantUtil.CAPTION, subEntry.getCaption());
				dataTable.setString(subrow, ConstantUtil.NAME, subEntry.getCaption() + "(" + subEntry.getChildren().size() + ")");
				dataTable.setString(subrow, "Open", StringUtils.isEmpty(subEntry.getOpen()) ? "false" : subEntry.getOpen());
				dataTable.setString(subrow, ConstantUtil.PARENT_KEY, entryKey);
				dataTable.setObject(subrow, "ChildrenCount", subEntry.getChildren().size());//不展开
				dataTable.setString(subrow, "Icon", subEntry.getIcon());
				dataTable.setString(subrow, "OnClick", subEntry.getOnClick());
				dataTable.setString(subrow, ConstantUtil.VISIBLE, subEntry.getVisible());
				dataTable.setString(subrow, "Type", "Entry");
			}
		});
	}

	private static LinkedHashMap<String, Object> returnEntryMap(String filePath) throws DocumentException {
		//1.创建SAXReader对象用于读取xml文件
		SAXReader reader = new SAXReader();
		//2.读取xml文件，获得Document对象
		org.dom4j.Document doc = reader.read(new File(filePath));
		LinkedHashMap<String, Object> entryItems = new LinkedHashMap<>();
		LinkedHashMap<String, Object> entryRelationItems = new LinkedHashMap<>();
		LinkedHashMap<String, Object> entries = new LinkedHashMap<>();

		//3.获取根元素
		Element root = doc.getRootElement();
		//4.获取根元素下的所有子元素（通过迭代器）
		Iterator<Element> it = root.elementIterator();
		extracted(entries, it, entryRelationItems);
		Entry root1 = new Entry();
		Attribute key = root.attribute(ConstantUtil.KEY);
		Attribute caption = root.attribute(ConstantUtil.CAPTION);
		root1.setKey(key.getStringValue());
		root1.setId(key.getStringValue());
		root1.setTitle(caption.getStringValue());
		root1.setCaption(caption.getStringValue());
		root1.setChildren(entries);
		entryItems.put(root1.getKey(), root1);
		entryRelationItems.put(root1.getKey(), root1);
		entryRelationItems.put("allList", entryItems);
		return entryRelationItems;
	}

	// 数据对象
	private void loadDataObject(MetaDataObject dataObject, String formKey, DataTable dataTable) {
		int row = dataTable.append();
		String caption = null;
		String dataObjectKey = null;
		String propertyFormKey = null;
		if (dataObject != null) {
			caption = dataObject.getCaption();
			dataObjectKey = dataObject.getKey();
			propertyFormKey = "D_" + dataObject.getTagName();
		}
		StringBuilder sb = new StringBuilder(256);
		dataTable.setLong(row, SystemField.OID_SYS_KEY, ((Integer) dataTable.size()).longValue());
		dataTable.setString(row, "PanelKey", "数据源   " + dataObjectKey);
		dataTable.setString(row, ConstantUtil.PARENT_KEY, formKey);
		dataTable.setString(row, ConstantUtil.CAPTION, caption);
		dataTable.setObject(row, ConstantUtil.NAME, sb.append("数据源   ").append(dataObjectKey).toString());
		dataTable.setString(row, ConstantUtil.FOCUS_ROW_CHANGED_FORMULA, "LoadDataObject('" + propertyFormKey + "', 'P2', '"
				+ dataObjectKey + "', '" + MetaObjectType.DataObject.name + "', " +
				"'" + "', '" + "', '" + formKey + "');");
		dataTable.setObject(row, "ChildrenCount", 0);
		dataTable.setState(RowState.NORMAL);
	}

	private void loadOperations(String parentKey, DataTable dataTable,
								MetaOperationCollection operationCollection, MetaForm ownerMetaForm) {
		StringBuilder sb = new StringBuilder(256);
		int row = dataTable.append();
		boolean existToolBar = false;
		HashMap<String, AbstractMetaObject> allUIComponents = ownerMetaForm.getAllUIComponents();
		for (HashMap.Entry<String, AbstractMetaObject> MetaObjectMap : allUIComponents.entrySet()) {
			if (MetaObjectMap.getValue() instanceof MetaToolBar) {
				existToolBar = true;
				break;
			}
		}
		if (!existToolBar) {
			dataTable.setLong(row, SystemField.OID_SYS_KEY, ((Integer) dataTable.size()).longValue());
			dataTable.setString(row, "PanelKey", "Operations");
			dataTable.setObject(row, "Name", sb.append("Operations").append(" ").append("操作集合").toString());
			dataTable.setString(row, "ParentKey", parentKey);
			dataTable.setString(row, "Caption", "操作集合");
			dataTable.setString(row, "BelongFormKey", ownerMetaForm.getKey());
			String propertyFormKey = "";
			dataTable.setString(row, "FocusRowChangedFormula", "ShowProperty('" + propertyFormKey + "', 'P2', '"
					+ "Operations" + "', '" + MetaObjectType.operationCollection.name + "');");
			dataTable.setObject(row, "ChildrenCount", operationCollection.size());
			dataTable.setObject(row, "PanelType", propertyFormKey);
		}
		dataTable.setState(RowState.NORMAL);
	}

	// 收起操作集合
	private void beforeLoadOperation(String parentKey, DataTable dataTable, MetaForm ownerMetaForm) {
		StringBuilder sb = new StringBuilder(256);
		int row = dataTable.append();
		boolean existToolBar = false;
		if (!existToolBar) {
			dataTable.setLong(row, SystemField.OID_SYS_KEY, ((Integer) dataTable.size()).longValue());
			dataTable.setString(row, "PanelKey", "表单集合属性");
			dataTable.setObject(row, ConstantUtil.NAME,
					sb.append("表单集合属性").append(" ").toString());
			dataTable.setString(row, ConstantUtil.PARENT_KEY, parentKey);
			dataTable.setString(row, ConstantUtil.CAPTION, "");
			String propertyFormKey = "";
			dataTable.setString(row, ConstantUtil.FOCUS_ROW_CHANGED_FORMULA, "ToolBar('" + propertyFormKey + "', 'P2', '"
					+ "Operations" + "', '" + MetaObjectType.operationCollection.name + "', " +
					"'" + "', '" + "', '" + ownerMetaForm.getKey() + "');");
			dataTable.setObject(row, "ChildrenCount", 0);

		}
		dataTable.setState(RowState.NORMAL);
	}

	// 操作集合
	private static void loadOperationCollection(MetaOperationCollection operationCollection, String parentKey,
												DataTable dataTable, String FormKey) {
		String key, caption, tagName;
		if (!dataTable.getMetaData().constains("ChildrenCount")) {
			dataTable.addColumn(new ColumnInfo("ChildrenCount", DataType.INT));
		}
		if (operationCollection == null){
			return;
		}
		for (KeyPairCompositeObject operat : operationCollection) {
			StringBuilder sb = new StringBuilder(256);
			JSONObject json = new JSONObject(operat);
			caption = json.getString("caption");
			key = json.getString("key");
			tagName = json.getString("tagName");
			int row = dataTable.append();
			dataTable.setLong(row, SystemField.OID_SYS_KEY, ((Integer) dataTable.size()).longValue());
			dataTable.setString(row, "PanelKey", key);
			dataTable.setObject(row, ConstantUtil.NAME, sb.append(key).append(" ").append(caption).toString());
			dataTable.setString(row, ConstantUtil.PARENT_KEY, parentKey);
			dataTable.setString(row, ConstantUtil.CAPTION, caption);
			dataTable.setString(row, "BelongFormKey", FormKey);
			String propertyFormKey = "D_" + tagName;
			dataTable.setString(row, ConstantUtil.FOCUS_ROW_CHANGED_FORMULA, "ShowProperty('" + propertyFormKey + "', 'P2', '" + key
					+ "', '" + (tagName.contains("Collection") ? MetaObjectType.operationCollection.name :
					MetaObjectType.operation.name) + "', " +
					"'" + "', '" + "', '" + FormKey + "');");
			if (operat instanceof MetaOperationCollection) {
				dataTable.setObject(row, "ChildrenCount",
						((MetaOperationCollection) operat).size());
			} else {
				dataTable.setObject(row, "ChildrenCount", 0);
			}
			dataTable.setObject(row, "PanelType", propertyFormKey);
			dataTable.setState(RowState.NORMAL);
		}
	}

	// 根面板
	private static void loadThePanel(MetaComponent metaPanel, String parentPanelKey, DataTable dataTable, String FormKey)  {
		StringBuilder sb = new StringBuilder(256);
		int row = dataTable.append();
		String caption = metaPanel.getCaption();
		dataTable.setLong(row, SystemField.OID_SYS_KEY, ((Integer) dataTable.size()).longValue());
		String panelKey = metaPanel.getKey();
		Boolean isDictEdit =  FormKey.equals("DictEdit");
		if(isDictEdit){
			MetaForm metaForm = null;
			try {
				metaForm = MetaFactory.getGlobalInstance().getMetaForm(FormKey);
			} catch (Throwable e) {
				throw new RuntimeException(e);
			}
			MetaComponent metaComponent = metaForm.componentByKey(panelKey);
			if(!panelKey.startsWith("dict_")){
				panelKey = "dict_"+panelKey;
				metaComponent.setKey(panelKey);
				panelKey = metaPanel.getKey();
				com.bokesoft.yes.mid.cmd.richdocument.strut.IDLookup.reloadIDLookup(metaForm);
			}
			dataTable.setObject(row, ConstantUtil.NAME, sb.append(panelKey).append(" ").append(caption).toString());
		} else {
			dataTable.setObject(row, ConstantUtil.NAME, sb.append(panelKey).append(" ").append(caption).toString());
		}
		if (panelKey.equals(parentPanelKey)) {
			dataTable.setString(row, "PanelKey", panelKey + "son");
		} else{
			dataTable.setString(row, "PanelKey", panelKey);
		}
		dataTable.setString(row, ConstantUtil.PARENT_KEY, parentPanelKey);
		dataTable.setString(row, ConstantUtil.CAPTION, caption);
		String propertyFormKey = "D_PanelProperty";
		dataTable.setString(row, ConstantUtil.FOCUS_ROW_CHANGED_FORMULA, "ShowProperty('" + propertyFormKey + "', 'P2', '" + panelKey
				+ "', '" + ControlType.toString(metaPanel.getControlType()) + "', " +
				"'" + "', '" + "', '" + FormKey + "');");
		dataTable.setObject(row, "BelongFormKey", FormKey);
		if (metaPanel instanceof MetaGrid) {
			dataTable.setObject(row, "ChildrenCount", 1);
		} else {
			dataTable.setObject(row, "ChildrenCount", metaPanel.getComponentCount());
		}
		dataTable.setObject(row, "PanelType", propertyFormKey);
		dataTable.setState(RowState.NORMAL);
	}

	public static MetaComponent getComponentByKey(MetaForm metaForm, String key) {
		MetaComponent metaComponent = metaForm.componentByKey(key);

		if (Objects.isNull(metaComponent)) {
			metaComponent = metaForm.embedByKey(key);
		}

		if (Objects.isNull(metaComponent)) {
			AbstractMetaObject abstractMetaObject = metaForm.getAllUIComponents().get(key);
			if (abstractMetaObject instanceof MetaComponent) {
				metaComponent = (MetaComponent) abstractMetaObject;
			}
		}
		return metaComponent;
	}

	public static AbstractMetaObject getComponentByKey(MetaForm metaForm, String key, boolean isNew) {
		AbstractMetaObject metaComponent = null;
		try {
			if (isNew) {
				metaComponent = metaForm.getAllUIComponents().get(key);
			} else {
				metaComponent = getComponentByKey(metaForm, key);
				if (metaComponent == null){
					metaComponent = metaForm.getAllUIComponents().get(key);
				}
			}
		} catch (Exception e) {
			LogSvr.getInstance().error("\n", e);
		}

		return metaComponent;
	}

	/**
	 * 通过反射使用
	 */
	@SuppressWarnings("unused")
	public static void loadPanels(DefaultContext context, DataTable dataTable, String parentKey, String FormKey,
								  String parentValue)
			throws Throwable {
		MetaForm metaForm;
		IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
		metaForm = globalInstance.getMetaForm(FormKey);
		MetaComponent metaComponent;
		if (parentKey.contains("@")) {
			metaComponent = getComponentByKey(metaForm, parentKey.split("@")[0]);
		} else if (parentKey.endsWith("son")) {
			metaComponent = getComponentByKey(metaForm, parentKey.substring(0, parentKey.length() - 3));
		} else {
			metaComponent = getComponentByKey(metaForm, parentKey);
		}
		boolean laodEmbedSon = false;
		String laodEmbedSonFormKey = "";
		if (metaComponent instanceof MetaEmbed) {
			laodEmbedSonFormKey = ((MetaEmbed) metaComponent).getFormKey();
			metaComponent = getComponentByKey(metaForm, parentKey.split("@")[1]);
			laodEmbedSon = true;
		}
		if (!dataTable.getMetaData().constains("ChildrenCount")) {
			dataTable.addColumn(new ColumnInfo("ChildrenCount", DataType.INT));
		}
		MetaOperationCollection operationCollection = metaForm.getOperationCollection();
		if (metaForm.getOperationCollection() != null && Objects.isNull(metaComponent)) { // 操作 宏公式
			if (((metaForm.getFormType() == FormType.Dict
					|| metaForm.getFormType() == FormType.CompDict
					|| metaForm.getFormType() == FormType.ChainDict) && !"Operations".equalsIgnoreCase(parentKey))
					|| metaForm.getFormType() == FormType.Entity || metaForm.getFormType() == FormType.Report
					|| metaForm.getFormType() == FormType.Normal) {
				operationCollection = (MetaOperationCollection) operationCollection.get(parentKey);
			}
			loadOperationCollection(operationCollection, parentKey, dataTable, FormKey);
		}

		if (metaComponent instanceof MetaPanel && (!(metaComponent instanceof MetaGridLayoutPanel) || laodEmbedSon)) {
			for (MetaComponent metaComp : ((MetaPanel) metaComponent).getComponentArray()) {
				if (metaComp.isExtend()){
//					continue;
				}
				List<MetaEmbed> embeds = metaForm.getEmbeds();
				if (embeds.size() > 1) {
					FormKey = parentValue;
				}
				boolean loadEmbed = false;
				if (!laodEmbedSon) {
					for (MetaEmbed embed : embeds) {
						if (embed.getRootKey().equals(metaComp.getKey())) {
							loadEmbed(embed, parentKey, dataTable, FormKey);
							loadEmbed = true;
							continue;
						}
						boolean embedKey;
						MetaForm metaForm1 = globalInstance.getMetaForm(embed.getFormKey());
						embedKey = metaForm1.getAllUIComponents().containsKey(metaComp.getKey());
						if (embedKey) {
							FormKey = embed.getFormKey();
							break;
						} else {
							FormKey = parentValue;
						}
					}
				} else {
					boolean containsKey = globalInstance.getMetaForm(laodEmbedSonFormKey).getAllUIComponents().containsKey(metaComp.getKey());
					if (!containsKey) {
						continue;
					} else {
						FormKey = laodEmbedSonFormKey;
					}
				}
				if (loadEmbed) {
					continue;
				}
				if (metaComp.isPanel()) {
					loadThePanel(metaComp, parentKey, dataTable, FormKey);
				} else if (metaComp instanceof MetaGrid) {
					loadGrid((MetaGrid) metaComp, parentKey, dataTable, FormKey);
				} else if (metaComp instanceof MetaSubDetail) {
					loadSubDetail((MetaSubDetail) metaComp, parentKey, dataTable, FormKey);
				} else if (metaComp instanceof MetaEmbed) {
					loadEmbed((MetaEmbed) metaComp, parentKey, dataTable, FormKey);
				} else if (metaComp instanceof MetaListView) {
					loadListView((MetaListView) metaComp, parentKey, dataTable, FormKey);
				} else if (metaComp instanceof MetaContainer) {
					String ForeignKey = (String) context.getPara("ContainerKey");
					if (ForeignKey != null) {
						loadMetaContainer((MetaContainer) metaComp, parentKey, dataTable, FormKey);
					}
				} else if (metaComp instanceof MetaDictView) {
					loadMetaDictView((MetaDictView) metaComp, parentKey, dataTable, FormKey);
				} else if (metaComp instanceof MetaToolBar) {
					loadMetaToolBar(dataTable, parentKey, metaComp, FormKey, operationCollection);
				} else {
					StringBuilder sb = new StringBuilder(256);
					String caption = metaComp.getCaption();
					int row = dataTable.append();
					dataTable.setLong(row, SystemField.OID_SYS_KEY, ((Integer) dataTable.size()).longValue());
					String componentKey = metaComp.getKey();
					dataTable.setString(row, "PanelKey", componentKey);
					dataTable.setString(row, ConstantUtil.PARENT_KEY, parentKey);
					dataTable.setString(row, ConstantUtil.CAPTION, caption);
					dataTable.setObject(row, ConstantUtil.NAME, sb.append(componentKey).append(" ").append(caption).toString());
					String propertyFormKey = "D_FieldProperty";
					dataTable.setString(row, ConstantUtil.FOCUS_ROW_CHANGED_FORMULA, "ShowProperty('" + propertyFormKey + "', 'P2', '"
							+ componentKey + "', '" + ControlType.toString(metaComp.getControlType()) + "', " +
							"'" + "', '" + "', '" + FormKey + "');");
					dataTable.setObject(row, "ChildrenCount", 0);
					panelMap.put(componentKey, parentKey);

					dataTable.setObject(row, "BelongFormKey", FormKey);
					dataTable.setObject(row, "PanelType", propertyFormKey);
					dataTable.setState(RowState.NORMAL);
				}
			}
		} else if (metaComponent instanceof MetaGrid) {
			loadGridChildren((MetaGrid) metaComponent, dataTable, parentKey, FormKey);
		} else if (metaComponent instanceof MetaSubDetail) {
			loadSubDetails((MetaSubDetail) metaComponent, dataTable, parentKey, FormKey);
		} else if (metaComponent instanceof MetaEmbed) {
			loadEmbed((MetaEmbed) metaComponent, parentKey, dataTable, FormKey);
		} else if (metaComponent instanceof MetaListView) {
			loadListViewFields((MetaListView) metaComponent, dataTable, parentKey, FormKey);
		} else if (metaComponent instanceof MetaGridLayoutPanel) {
			for (MetaComponent metaComp : ((MetaPanel) metaComponent).getComponentArray()) {
				List<MetaEmbed> embeds = metaForm.getEmbeds();
				if (embeds.size() > 1) {
					FormKey = parentValue;
				}
				boolean loadEmbed = false;
				for (MetaEmbed embed : embeds) {
					if (embed.getRootKey().equals(metaComp.getKey())) {
						loadEmbed(embed, parentKey, dataTable, FormKey);
						loadEmbed = true;
						continue;
					}
					boolean embedKey;
					MetaForm metaForm1 = globalInstance.getMetaForm(embed.getFormKey());
					embedKey = metaForm1.getAllUIComponents().containsKey(metaComp.getKey());
//						embedKey = idLoopup1.containFieldKey(metaComp.getKey())|| idLoopup1.containNoFieldKey(metaComp.getKey());
					if (embedKey) {
						FormKey = embed.getFormKey();
						break;
					} else {
						FormKey = parentValue;
					}
				}
				if (loadEmbed) {
					continue;
				}
				if (metaComp.isPanel()) {
					loadThePanel(metaComp, parentKey, dataTable, FormKey);
				} else if (metaComp instanceof MetaGrid) {
					loadGrid((MetaGrid) metaComp, parentKey, dataTable, FormKey);
				} else if (metaComp instanceof MetaSubDetail) {
					loadSubDetail((MetaSubDetail) metaComp, parentKey, dataTable, FormKey);
				} else if (metaComp instanceof MetaEmbed) {
					loadEmbed((MetaEmbed) metaComp, parentKey, dataTable, FormKey);
				} else if (metaComp instanceof MetaListView) {
					loadListView((MetaListView) metaComp, parentKey, dataTable, FormKey);
				} else if (metaComp instanceof MetaContainer) {
					String ForeignKey = (String) context.getPara("ContainerKey");
					if (ForeignKey != null) {
						loadMetaContainer((MetaContainer) metaComp, parentKey, dataTable, FormKey);
					}
				} else if (metaComp instanceof MetaDictView) {
					loadMetaDictView((MetaDictView) metaComp, parentKey, dataTable, FormKey);
				} else if (metaComp instanceof MetaToolBar) {
					loadMetaToolBar(dataTable, parentKey, metaComp, FormKey, operationCollection);
				} else {
					StringBuilder sb = new StringBuilder(256);
					String caption = metaComp.getCaption();
					int row = dataTable.append();
					dataTable.setLong(row, SystemField.OID_SYS_KEY, ((Integer) dataTable.size()).longValue());
					String componentKey = metaComp.getKey();
					dataTable.setString(row, "PanelKey", componentKey);
					dataTable.setString(row, ConstantUtil.PARENT_KEY, parentKey);
					dataTable.setString(row, ConstantUtil.CAPTION, caption);
					dataTable.setObject(row, ConstantUtil.NAME, sb.append(componentKey).append(" ").append(caption).toString());
					String propertyFormKey = "D_FieldProperty";
					dataTable.setString(row, ConstantUtil.FOCUS_ROW_CHANGED_FORMULA, "ShowProperty('" + propertyFormKey + "', 'P2', '"
							+ componentKey + "', '" + ControlType.toString(metaComp.getControlType()) + "', " +
							"'" + "', '" + "', '" + FormKey + "');");
					dataTable.setObject(row, "ChildrenCount", 0);
					panelMap.put(componentKey, parentKey);
					dataTable.setState(RowState.NORMAL);
				}
			}
		} else if (metaComponent instanceof MetaToolBar) { // 操作总节点
			operationCollection = metaForm.getOperationCollection();
			loadOperationCollection(operationCollection, metaComponent.getKey(), dataTable, FormKey);
		}
	}

	private static void loadMetaToolBar(DataTable dataTable, String parentKey, MetaComponent metaComp, String FormKey
			, MetaOperationCollection operationCollection) {
		StringBuilder sb = new StringBuilder(256);
		int row1 = dataTable.append();
		dataTable.setLong(row1, SystemField.OID_SYS_KEY, ((Integer) dataTable.size()).longValue());
		dataTable.setString(row1, "PanelKey", metaComp.getKey());
		dataTable.setObject(row1, ConstantUtil.NAME,
				sb.append(metaComp.getKey()).append(" ").append(metaComp.getCaption()).toString());
		dataTable.setString(row1, ConstantUtil.PARENT_KEY, parentKey);
		dataTable.setString(row1, ConstantUtil.CAPTION, metaComp.getCaption());
		String propertyKey = "D_ToolBar";
		dataTable.setString(row1, ConstantUtil.FOCUS_ROW_CHANGED_FORMULA,
				"ShowProperty('" + propertyKey + "', 'P2', '" + metaComp.getKey()
						+ "', '" + MetaObjectType.ToolBar.name + "', " +
						"'" + "', '" + "', '" + FormKey + "');");
		if (Objects.isNull(operationCollection)) {
			dataTable.setObject(row1, "ChildrenCount", 0);
		} else {
			dataTable.setObject(row1, "ChildrenCount", operationCollection.size());
		}

		dataTable.setObject(row1, "BelongFormKey", FormKey);
		dataTable.setObject(row1, "PanelType", parentKey);
		dataTable.setState(RowState.NORMAL);
	}

	// 表格
	private static void loadGrid(MetaGrid metaComponent, String ParentKey, DataTable dataTable, String FormKey) {
		StringBuilder sb = new StringBuilder(256);
		String caption = metaComponent.getCaption();
		int row = dataTable.append();
		dataTable.setLong(row, SystemField.OID_SYS_KEY, ((Integer) dataTable.size()).longValue());
		String nodeKey = metaComponent.getKey();
		dataTable.setString(row, "PanelKey", nodeKey);
		dataTable.setString(row, ConstantUtil.PARENT_KEY, ParentKey);
		dataTable.setString(row, ConstantUtil.CAPTION, caption);
		dataTable.setObject(row, ConstantUtil.NAME, sb.append(nodeKey).append(" ").append(caption).toString());
		String propertyFormKey = "D_Grid";
		dataTable.setString(row, ConstantUtil.FOCUS_ROW_CHANGED_FORMULA, "ShowProperty('" + propertyFormKey + "', 'P2', '" + nodeKey
				+ "', '" + MetaObjectType.grid.name + "', " +
				"'" + "', '" + "', '" + FormKey + "');");
		dataTable.setObject(row, "ChildrenCount",
				metaComponent.getRowCollection().get(0).size());

		dataTable.setObject(row, "BelongFormKey", FormKey);
		dataTable.setObject(row, "PanelType", propertyFormKey);
		dataTable.setState(RowState.NORMAL);
	}

	// 表格中行
	public static void loadGridRows( DataTable dataTable, String parentKey, String FormKey,MetaGridRow metaGridRow) {
		if (metaGridRow == null){
			return;
		}
		int i = 0;
		if (!dataTable.getMetaData().constains("ChildrenCount")) {
			dataTable.addColumn(new ColumnInfo("ChildrenCount", DataType.INT));
		}
		for (MetaGridCell metaGridCell : metaGridRow) {
			StringBuilder sb = new StringBuilder(256);
			String caption = metaGridCell.getCaption();
			int rows = dataTable.append();
			dataTable.setLong(rows, SystemField.OID_SYS_KEY, ((Integer) dataTable.size()).longValue());
			String cellKey = metaGridCell.getKey();
			dataTable.setString(rows, "PanelKey", cellKey);
			dataTable.setString(rows, ConstantUtil.PARENT_KEY, parentKey);
			dataTable.setString(rows, ConstantUtil.CAPTION, caption);
			dataTable.setObject(rows, ConstantUtil.NAME, sb.append(cellKey).append(" ").append(caption).toString());
			String propertyFormKeys = "D_GridFieldModule";
			dataTable.setString(rows, ConstantUtil.FOCUS_ROW_CHANGED_FORMULA, "ShowProperty('" + propertyFormKeys + "', 'P2', '"
					+ cellKey + "', '" + "cell" + "', '" + i + "','" + metaGridRow.getKey() + "', '" + FormKey +
					"')" +
					";");
			dataTable.setObject(rows, "ChildrenCount", 0);
			gridMap.put(cellKey, parentKey);

			dataTable.setObject(rows, "BelongFormKey", FormKey);
			dataTable.setObject(rows, "PanelType", propertyFormKeys);
			dataTable.setState(RowState.NORMAL);
			i++;
		}
	}
	// 表格中字段
	private static void loadGridChildren(MetaGrid metaComponent, DataTable dataTable, String parentKey, String FormKey) {
		MetaGridRowCollection rowCollection = metaComponent.getRowCollection();
		MetaGridColumnCollection columnCollection = metaComponent.getColumnCollection();
		loadGridHeadColums(metaComponent, dataTable, parentKey, columnCollection, FormKey);
		for (int i = 0; i < rowCollection.size(); i++) {
			MetaGridRow metaGridRow = rowCollection.get(i);
			String key = metaGridRow.getKey();
			Integer rowType = metaGridRow.getRowType();
			String caption1 = RowType.toString(rowType);
			int rows1 = dataTable.append();

			dataTable.setLong(rows1, SystemField.OID_SYS_KEY, ((Integer) dataTable.size()).longValue());
			dataTable.setString(rows1, "PanelKey", key);
			dataTable.setString(rows1, ConstantUtil.PARENT_KEY, parentKey);
			dataTable.setString(rows1, ConstantUtil.CAPTION, caption1);
			dataTable.setObject(rows1, ConstantUtil.NAME, key+" "+caption1);
			String propertyFormKeys1 = "D_GridRow";
			dataTable.setString(rows1, ConstantUtil.FOCUS_ROW_CHANGED_FORMULA, "ShowProperty('" + propertyFormKeys1 +
					"', 'P2', '"
					+ key + "', '" + MetaObjectType.GridRow.name + "', '" + i + "','" + metaComponent.getKey() + "', '" + FormKey + "');");
			dataTable.setObject(rows1, "ChildrenCount", 1);
			dataTable.setObject(rows1, "BelongFormKey", FormKey);
			dataTable.setObject(rows1, "PanelType", propertyFormKeys1);
			dataTable.setState(RowState.NORMAL);
		}
	}

	private static void loadGridHeadColums(MetaGrid metaComponent, DataTable dataTable, String parentKey,
										   MetaGridColumnCollection columnCollection, String FormKey) {
		for (int i = 0; i < columnCollection.size(); i++) {
			MetaGridColumn metaGridColumn = columnCollection.get(i);
			StringBuilder sb = new StringBuilder(256);
			String caption = metaGridColumn.getCaption();
			int rows = dataTable.append();
			dataTable.setLong(rows, SystemField.OID_SYS_KEY, ((Integer) dataTable.size()).longValue());
			String oldKey = metaGridColumn.getMetaKey();
			String columnKey = metaGridColumn.getKey();
			if (StringUtils.isNotBlank(oldKey)) {
				columnKey = oldKey;
			}

			dataTable.setString(rows, "PanelKey", columnKey);
			dataTable.setString(rows, ConstantUtil.PARENT_KEY, parentKey);
			dataTable.setString(rows, ConstantUtil.CAPTION, caption);
			dataTable.setObject(rows, ConstantUtil.NAME,
					sb.append("Column:").append(columnKey).append(" ").append(caption).toString());
			String propertyFormKeys = "D_GridHeadColumn";
			dataTable.setString(rows, ConstantUtil.FOCUS_ROW_CHANGED_FORMULA, "ShowProperty('" + propertyFormKeys + "', 'P2', '"
					+ "Column:" + columnKey + "', '" + MetaObjectType.GridField_columnheader.name + "', '" + i + "','" + metaComponent.getKey() + "', '" + FormKey + "');");
			dataTable.setObject(rows, "ChildrenCount", 0);
			gridMap.put(columnKey, parentKey);
			dataTable.setState(RowState.NORMAL);
			MetaGridColumnCollection columnCollec = metaGridColumn.getColumnCollection();
			if (columnCollec != null && columnCollec.size() > 0) {
				loadGridHeadColums(metaComponent, dataTable, parentKey, columnCollec, FormKey);
			}
		}
	}

	// 明细
	private static void loadSubDetail(MetaSubDetail metaComponent, String ParentKey, DataTable dataTable, String FormKey) {
		StringBuilder sb = new StringBuilder(256);
		String caption = metaComponent.getCaption();
		int row = dataTable.append();
		dataTable.setLong(row, SystemField.OID_SYS_KEY, ((Integer) dataTable.size()).longValue());
		String nodeKey = metaComponent.getKey();
		dataTable.setString(row, "PanelKey", nodeKey);
		dataTable.setString(row, ConstantUtil.PARENT_KEY, ParentKey);
		dataTable.setString(row, ConstantUtil.CAPTION, caption);
		dataTable.setObject(row, ConstantUtil.NAME, sb.append(nodeKey).append(" ").append(caption).toString());
		String propertyFormKey = "D_" + ControlType.toString(metaComponent.getControlType());
		dataTable.setString(row, ConstantUtil.FOCUS_ROW_CHANGED_FORMULA, "ShowProperty('" + propertyFormKey + "', 'P2', '" + nodeKey + "', '" + MetaObjectType.subDetail.name + "', " +
				"'" + "', '" + "', '" + FormKey + "');");

		dataTable.setObject(row, "BelongFormKey", FormKey);
		dataTable.setObject(row, "PanelType", propertyFormKey);
		dataTable.setObject(row, "ChildrenCount", metaComponent.getComponentCount());
	}

	// Container
	private static void loadMetaContainer(MetaContainer metaComponent, String parentKey, DataTable dataTable,
										  String FormKey) {
		StringBuilder sb = new StringBuilder(256);
		int row = dataTable.append();
		dataTable.setLong(row, SystemField.OID_SYS_KEY, ((Integer) dataTable.size()).longValue());
		String nodeKey = metaComponent.getKey();
		String caption = StringUtils.isNotBlank(metaComponent.getCaption()) ?
				metaComponent.getCaption() : "容器";
		dataTable.setString(row, "PanelKey", nodeKey);
		dataTable.setString(row, ConstantUtil.PARENT_KEY, parentKey);
		dataTable.setString(row, ConstantUtil.CAPTION, caption);
		dataTable.setObject(row, ConstantUtil.NAME, sb.append(nodeKey).append(" ").append(caption).toString());
		String propertyFormKey = "D_" + ControlType.toString(metaComponent.getControlType());
		dataTable.setString(row, ConstantUtil.FOCUS_ROW_CHANGED_FORMULA, "ShowProperty('" + propertyFormKey + "', 'P2', '" + nodeKey
				+ "', '" + MetaObjectType.ContainerKey.name + "', " +
				"'" + "', '" + "', '" + FormKey + "');");
		dataTable.setObject(row, "ChildrenCount", 0);

		dataTable.setObject(row, "BelongFormKey", FormKey);
		dataTable.setObject(row, "PanelType", propertyFormKey);
		dataTable.setState(RowState.NORMAL);
	}

	// 字典视图
	private static void loadMetaDictView(MetaDictView metaComponent, String parentKey, DataTable dataTable, String FormKey) {
		int row = dataTable.append();
		StringBuilder sb = new StringBuilder(256);
		dataTable.setLong(row, SystemField.OID_SYS_KEY, ((Integer) dataTable.size()).longValue());
		String nodeKey = metaComponent.getKey();
		String caption = StringUtils.isNotBlank(metaComponent.getCaption()) ?
				metaComponent.getCaption() : "字典视图";
		dataTable.setString(row, "PanelKey", nodeKey);
		dataTable.setString(row, ConstantUtil.PARENT_KEY, parentKey);
		dataTable.setString(row, ConstantUtil.CAPTION, caption);
		dataTable.setObject(row, ConstantUtil.NAME, sb.append(nodeKey).append(" ").append(caption).toString());
		String propertyFormKey = "D_" + ControlType.toString(metaComponent.getControlType());
		dataTable.setString(row, ConstantUtil.FOCUS_ROW_CHANGED_FORMULA, "ShowProperty('" + propertyFormKey + "', 'P2', '" + nodeKey
				+ "', '" + MetaObjectType.D_DictView.name + "', " +
				"'" + "', '" + "', '" + FormKey + "');");
		dataTable.setObject(row, "ChildrenCount", 0);

		dataTable.setObject(row, "BelongFormKey", FormKey);
		dataTable.setObject(row, "PanelType", propertyFormKey);
		dataTable.setState(RowState.NORMAL);
	}


	// 明细下的节点
	private static void loadSubDetails(MetaSubDetail metaComponent, DataTable dataTable, String ParentKey, String FormKey) {
		MetaComponent root = metaComponent.getRoot();
		if (root instanceof MetaPanel) {
			loadThePanel(root, ParentKey, dataTable, FormKey);
		} else if (root instanceof MetaGrid) {
			loadGrid((MetaGrid) root, ParentKey, dataTable, FormKey);
		}
	}

	// 嵌入
	private static void loadEmbed(MetaEmbed metaComponent, String parentKey, DataTable dataTable, String FormKey) {
		int row = dataTable.append();
		StringBuilder sb = new StringBuilder(256);
		dataTable.setLong(row, SystemField.OID_SYS_KEY, ((Integer) dataTable.size()).longValue());
		String nodeKey = metaComponent.getKey();
		dataTable.setString(row, "PanelKey", nodeKey + "@" + parentKey);
		dataTable.setString(row, ConstantUtil.PARENT_KEY, parentKey);
		dataTable.setString(row, ConstantUtil.CAPTION, metaComponent.getCaption());
		dataTable.setObject(row, ConstantUtil.NAME,
				sb.append(nodeKey).append(" ").append(metaComponent.getCaption()).toString());
		String propertyFormKey = "D_" + ControlType.toString(metaComponent.getControlType());
		dataTable.setString(row, ConstantUtil.FOCUS_ROW_CHANGED_FORMULA, "ShowProperty('" + propertyFormKey + "', 'P2', '" + nodeKey + "', '" + MetaObjectType.Embed.name + "', " + "'" + "', '" + "', '" + FormKey + "');");
		//嵌入表单，前端判断过不了，无法展开
		dataTable.setObject(row, "ChildrenCount",-1);
		dataTable.setObject(row, "BelongFormKey", FormKey);
		dataTable.setObject(row, "PanelType", propertyFormKey);
		dataTable.setState(RowState.NORMAL);
	}

	// 列表视图
	private static void loadListView(MetaListView metaComponent, String parentKey, DataTable dataTable, String FormKey) {
		String caption = metaComponent.getCaption();
		StringBuilder sb = new StringBuilder(256);
		int row = dataTable.append();
		dataTable.setLong(row, SystemField.OID_SYS_KEY, ((Integer) dataTable.size()).longValue());
		String nodeKey = metaComponent.getKey();
		dataTable.setString(row, "PanelKey", nodeKey);
		dataTable.setString(row, ConstantUtil.PARENT_KEY, parentKey);
		dataTable.setString(row, ConstantUtil.CAPTION, caption);
		dataTable.setObject(row, ConstantUtil.NAME, sb.append(nodeKey).append(" ").append(caption).toString());
		String propertyFormKey = "D_" + ControlType.toString(metaComponent.getControlType());
		dataTable.setString(row, ConstantUtil.FOCUS_ROW_CHANGED_FORMULA, "ShowProperty('" + propertyFormKey + "', 'P2', '" + nodeKey
				+ "', '" + MetaObjectType.listView.name + "', " +
				"'" + "', '" + "', '" + FormKey + "');");
		dataTable.setObject(row, "ChildrenCount", metaComponent.getColumnCollection().size());

		dataTable.setObject(row, "BelongFormKey", FormKey);
		dataTable.setObject(row, "PanelType", propertyFormKey);
		dataTable.setState(RowState.NORMAL);
	}

	// 列表视图中字段
	private static void loadListViewFields(MetaListView metaComponent, DataTable dataTable, String parentKey,
										   String FormKey) {
		MetaListViewColumnCollection columnCollection = metaComponent.getColumnCollection();
		for (MetaListViewColumn metaListViewColumn : columnCollection) {
			StringBuilder sb = new StringBuilder(256);
			String caption = metaListViewColumn.getCaption();
			int rows = dataTable.append();
			dataTable.setLong(rows, SystemField.OID_SYS_KEY, ((Integer) dataTable.size()).longValue());
			String columnKey = metaListViewColumn.getKey();
			dataTable.setString(rows, "PanelKey", columnKey);
			dataTable.setString(rows, ConstantUtil.PARENT_KEY, parentKey);
			dataTable.setString(rows, ConstantUtil.CAPTION, caption);
			dataTable.setObject(rows, ConstantUtil.NAME, sb.append(columnKey).append(" ").append(caption).toString());
			String propertyFormKeys = "D_ListViewColumn";
			// TODO:最后的类型估计不对 jzh
			dataTable.setString(rows, ConstantUtil.FOCUS_ROW_CHANGED_FORMULA, "ShowProperty('" + propertyFormKeys + "', 'P2', '"
					+ columnKey + "', '" + MetaObjectType.listview_columnheader + "', " +
					"'" + "', '" + "', '" + FormKey + "');");
			dataTable.setObject(rows, "ChildrenCount", 0);
			listViewMap.put(columnKey, parentKey);
			dataTable.setState(RowState.NORMAL);
		}
	}


	// 字段查询条件
	private void loadCondiditonHead(DataTable dataTable, MetaComponent metaField) {
		MetaCondition condition = metaField.getCondition();
		int row = dataTable.append();
		if (condition != null) {
			dataTable.setInt(row, "CondSign", condition.getSign() == -1 ? -1 : condition.getSign());
			dataTable.setString(row, "ColumnKey", condition.getColumnKey());
			dataTable.setString(row, "TableKey", condition.getTableKey());
			dataTable.setString(row, "SubTableKey", condition.getSubTableKey());
			dataTable.setString(row, "Group", condition.getGroup());
			dataTable.setObject(row, "GroupHead", condition.isGroupHead());
			dataTable.setObject(row, "GroupTail", condition.isGroupTail());
			dataTable.setObject(row, "LimitToSource", condition.isLimitToSource());
			dataTable.setObject(row, "UseAdvancedQuery", condition.isUseAdvancedQuery());
			dataTable.setString(row, "Target", condition.getTarget());
			dataTable.setString(row, ConstantUtil.TAG, condition.getTag());
			dataTable.setString(row, "Impl", condition.getImpl());
			dataTable.setObject(row, "NeedReset", condition.needReset());
			dataTable.setObject(row, "LoadHistoryInput", condition.isLoadHistoryInput());
			dataTable.setObject(row, "OnlyFilter", condition.isOnlyFilter());
		} else {
			dataTable.setInt(row, "CondSign", -11);
		}
		dataTable.setState(RowState.NORMAL);
	}

	private void loadConditionCollection(DataTable dataTable, MetaComponent metaField, DefaultContext context, MetaTable customConditionPara, Document doc) throws Throwable {
		MetaCondition condition = metaField.getCondition();
		DataTable curDataTable1 = WebDesignerDataTableUtil.generateDataTable(customConditionPara);

		if (condition != null) {
			MetaCustomConditionCollection customs = condition.getCustoms();

			for (MetaCustomCondition custom : customs) {
				int row = dataTable.append();
				Long applyNewOID = context.applyNewOID();

				dataTable.setObject(row, ConstantUtil.OID, applyNewOID);
				dataTable.setString(row, "Condition", custom.getCondition());
				dataTable.setString(row, "Filter", custom.getFilter());
				dataTable.setObject(row, "IsMultiPara", custom.getMultiPara()?1:0);
				dataTable.setObject(row, "Seperator", custom.getSeperator());
				dataTable.setState(RowState.NORMAL);
				if (custom.getList() != null && custom.getList().size() > 0) {
					loadConditionCollectionPara(curDataTable1, custom, applyNewOID);
				}
			}
		}
		curDataTable1.batchUpdate();
		doc.add(ConstantUtil.TBL_CUSTOM_CONDITION_PARA, curDataTable1);
	}

	private void loadConditionCollectionPara(DataTable dataTable, MetaCustomCondition custom, Long applyNewOID) {
		for (MetaCustomConditionPara metaCustomConditionPara : custom) {
			String key = metaCustomConditionPara.getKey();
			String formula = metaCustomConditionPara.getFormula();
			int row = dataTable.append();
			dataTable.setObject(row, ConstantUtil.POID, applyNewOID);
			dataTable.setString(row, "ParaKey", key);
			dataTable.setString(row, "ParaFormula", formula);
			dataTable.setState(RowState.NORMAL);
		}
	}

	private void loadConditionTargetCollection(DataTable dataTable, MetaComponent metaField) {
		if (metaField.getCondition() != null) {
			MetaConditionTargetCollection metaConditionTargets = metaField.getCondition().getTargets();
			for (MetaConditionTarget metaConditionTarget : metaConditionTargets) {
				int row = dataTable.append();
				dataTable.setString(row, ConstantUtil.TARGET_TABLE_KEY, metaConditionTarget.getTableKey());
				dataTable.setString(row, "TargetColumnKey", metaConditionTarget.getColumnKey());
				dataTable.setString(row, ConstantUtil.TARGET_FIELD, metaConditionTarget.getTarget());
				dataTable.setState(RowState.NORMAL);
			}
		}
	}

	private void loadImportSolution(DataTable designDataTable) throws Throwable {
		String filePath = WebDesignerConfiguration.getDesignerImportSolutionsPath();
		designDataTable.clear();
		SAXReader reader = new SAXReader();
		org.dom4j.Document doc = reader.read(new File(filePath));
		Element root = doc.getRootElement();
		List<Element> importSolution = root.elements("ImportSolution");
		for (Element element : importSolution) {
			int rowIndex = designDataTable.append();
			String solutionPath = element.attributeValue("SolutionPath");
			String key = element.attributeValue("Key");
			String caption = element.attributeValue("Caption");
			designDataTable.setString(rowIndex, "Key", key);
			designDataTable.setString(rowIndex, "Caption", caption);
			designDataTable.setString(rowIndex, "SolutionPath", solutionPath);
			designDataTable.setState(RowState.NORMAL);
		}




	}
	private void loadDataSourceHead(MetaForm erpMetaForm, MetaForm erpContainerMetaForm, DataTable designDataTable) throws Throwable {
		String xmlFileKey = erpMetaForm.getKey();
		final String extend = erpMetaForm.getExtend();
		boolean vestFlag = StringUtils.isNotBlank(extend);
		boolean specVestFlag = Objects.equals(erpMetaForm.getMergeToSource(), Boolean.TRUE);

		MetaDataSource dataSource = erpMetaForm.getDataSource();
		if (Objects.isNull(erpMetaForm.getDataSource()) && Objects.nonNull(erpContainerMetaForm)) {
			vestFlag = StringUtils.isNotBlank(erpContainerMetaForm.getExtend());
			specVestFlag = Objects.equals(erpContainerMetaForm.getMergeToSource(), Boolean.TRUE);

			dataSource = erpContainerMetaForm.getDataSource();
		}

		String erpXmlPath = LoadFileTree.getPathByFormKey(xmlFileKey);
		XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(FilePathHelper.toBackFilePath(erpXmlPath));
		TagNode rootNode = xmlTreeWithPath.xmlTree.getRoot();
		TagNode dataSourceNode = rootNode.findFirstTagNodeByTagName("DataSource");

		XmlTree extendXmlTree = null;
		if (StringUtils.isNotBlank(extend)) {
			final String extendPath = LoadFileTree.getPathByFormKey(extend);
			if (StringUtils.isNotBlank(extendPath)) {
				String tmpExtendPath = XmlFileProcessor.instance.getTmpFile(extendPath);
				String extendFilePath = StringUtils.isNotBlank(tmpExtendPath) ? tmpExtendPath : extendPath;
				extendXmlTree = Xml4jUtil.parseTree(extendFilePath);
			}
		}

		if (Objects.isNull(dataSourceNode) && !vestFlag) {
			int rowIndex = designDataTable.append();
			designDataTable.setString(rowIndex, "DataObjectSource", "2");
			designDataTable.setString(rowIndex, "SourceDataObject", null);
			designDataTable.setInt(rowIndex, "ExtendFlag", 0);
			designDataTable.setInt(rowIndex, "VestFlag", 0);
			designDataTable.setInt(rowIndex, "SpecVestFlag", 0);
			designDataTable.setState(RowState.NORMAL);
			return;
		}

		if (Objects.isNull(dataSource)) {
			return;
		}

		int rowIndex = designDataTable.append();
		String refObjectKey = dataSource.getRefObjectKey();
		if (StringUtils.isNotBlank(refObjectKey)) {
			designDataTable.setString(rowIndex, "DataObjectSource", "1");
			designDataTable.setString(rowIndex, "SourceDataObject", refObjectKey);
		} else {
			designDataTable.setString(rowIndex, "DataObjectSource", "0");
			designDataTable.setString(rowIndex, "SourceDataObject", "");
		}
		MetaDataObject dataObject = dataSource.getDataObject();
		designDataTable.setString(rowIndex, "Mark", dataObject.getKey());
		designDataTable.setString(rowIndex, ConstantUtil.CAPTION, dataObject.getCaption());
		designDataTable.setString(rowIndex, "MainType", DataObjectPrimaryType.toString(dataObject.getPrimaryType()));
		designDataTable.setString(rowIndex, "AuxiliaryType", DataObjectSecondaryType.toString(dataObject.getSecondaryType()));
		designDataTable.setString(rowIndex, "MainTable", dataObject.getMainTableKey());
		designDataTable.setString(rowIndex, "QueryFields", dataObject.getQueryColumnsStr());
		designDataTable.setString(rowIndex, "DisplayFields", dataObject.getDisplayColumnsStr());
		Boolean isCheckAfterLoad = null;
		String  loadRightType=DataObjectLoadRightsType.toString(dataObject.getLoadRightsType());
		TagNode dataObjectNode = rootNode.findFirstTagNodeByTagName(ConstantUtil.DATA_OBJECT);
		if (Objects.nonNull(dataObjectNode)){
			final String val = dataObjectNode.getAttributes().get(ConstantUtil.LOAD_RIGHTS_TYPE);
			if (StringUtils.isNotBlank(val) && !val.equalsIgnoreCase(loadRightType)) {
				loadRightType = val;
			}
		}
		designDataTable.setString(rowIndex, "LoadRightsType", loadRightType);
		if (Objects.nonNull(dataObjectNode)) {
			final String val = dataObjectNode.getAttributes().get(ConstantUtil.CHECK_AFTER_LOAD);
			if (StringUtils.isNotBlank(val)) {
				isCheckAfterLoad = StringUtils.equalsIgnoreCase(val, "true");
			}
		}
		if (Objects.isNull(isCheckAfterLoad) && Objects.nonNull(extendXmlTree)) {
			dataObjectNode = extendXmlTree.getTagNode(ConstantUtil.DATA_OBJECT + "@" + dataObject.getKey());
			if (Objects.nonNull(dataObjectNode)) {
				final String val = dataObjectNode.getAttributes().get(ConstantUtil.CHECK_AFTER_LOAD);
				if (StringUtils.isNotBlank(val)) {
					isCheckAfterLoad = StringUtils.equalsIgnoreCase(val, "true");
				}
			}
		}
		if (Objects.isNull(isCheckAfterLoad)) {
			isCheckAfterLoad = dataObject.isCheckAfterLoad();
		}
		designDataTable.setObject(rowIndex, "CheckAfterLoad", isCheckAfterLoad);
		designDataTable.setObject(rowIndex, "MaintainDict", dataObject.isMaintainDict());
		designDataTable.setInt(rowIndex, "ExtendFlag", 0);
		designDataTable.setInt(rowIndex, "VestFlag", vestFlag ? 1 : 0);
		designDataTable.setInt(rowIndex, "SpecVestFlag", specVestFlag ? 1 : 0);

		designDataTable.setState(RowState.NORMAL);
	}

	// 数据对象头表
	private void loadE_DataObjectFormHead(DataTable designDataTable, String erpXmlKey) throws Throwable {
		String erpXmlFilePath = LoadFileTree.getPathByDataObject(erpXmlKey);
		String tmpErpXmlFilePath = XmlFileProcessor.instance.getTmpFile(erpXmlFilePath);
		String realXmlFilePath = StringUtils.isNotBlank(tmpErpXmlFilePath) ? tmpErpXmlFilePath : erpXmlFilePath;
		XmlTree xmlTree = Xml4jUtil.parseTree(realXmlFilePath);
		if (Objects.isNull(xmlTree)) {
			String pathByDataObject = LoadFileTree.getPathByDataObject(erpXmlFilePath);
			xmlTree = Xml4jUtil.parseTree(pathByDataObject);
		}

		IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
		MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
		MetaDataObjectProfile metaDataObjectProfile = dataObjectList.get(erpXmlKey);
		MetaDataObject dataObject = metaDataObjectProfile.getDataObject(); // 这里之前取得是 MetaDataObjectProfile
		if (Objects.isNull(dataObject)) {
			return;
		}

		int rowIndex = designDataTable.append();
		designDataTable.setString(rowIndex, "Mark", dataObject.getKey());
		String caption = metaDataObjectProfile.getCaption();
		if (StringUtils.isNotBlank(dataObject.getExtend()) && !StringUtils.contains(caption, "马甲")) {
			caption = caption + "(马甲)";
		}
		designDataTable.setString(rowIndex, ConstantUtil.CAPTION, caption);
		designDataTable.setString(rowIndex, "MainType", DataObjectPrimaryType.toString(dataObject.getPrimaryType()));
		designDataTable.setString(rowIndex, "MainTable", dataObject.getMainTableKey());
		designDataTable.setString(rowIndex, "AuxiliaryType", DataObjectSecondaryType.toString(dataObject.getSecondaryType()));
		designDataTable.setString(rowIndex, "QueryFields", dataObject.getQueryColumnsStr());
		designDataTable.setString(rowIndex, "DisplayFields", dataObject.getDisplayColumnsStr());

		TagNode rootNode = xmlTree.getRoot();
		Map<String, String> attributes = rootNode.getAttributes();
		designDataTable.setString(rowIndex, "LoadRightsType", attributes.getOrDefault("LoadRightsType", DataObjectLoadRightsType.STR_FILTER));
		designDataTable.setString(rowIndex, "CheckAfterLoad", attributes.getOrDefault("CheckAfterLoad", "false"));

		designDataTable.setObject(rowIndex, "MaintainDict", dataObject.isMaintainDict());
		if (StringUtils.isNotBlank(dataObject.getExtend())) {
			designDataTable.setInt(rowIndex, "ExtendFlag", 1);
		} else {
			designDataTable.setInt(rowIndex, "ExtendFlag", 0);
		}
		designDataTable.setObject(rowIndex, "MigrationUpdateStrategy", MigrationUpdateStrategyType.toString(dataObject.getMigrationUpdateStrategy()));

		designDataTable.setState(RowState.NORMAL);

	}

	//表格明细行检查规则
	private void loadUICheckRule(DataTable dataTable, MetaForm ownerMetaForm, MetaGridRow metaGridCells) throws Throwable {
		try {
			getXmlTree(ownerMetaForm);
		} catch (Exception e) {
			LogSvr.getInstance().error("\n", e);
		}
		MetaUICheckRuleCollection checkRuleCollection = metaGridCells.getCheckRuleCollection();
		if (checkRuleCollection != null) {
			for (int i = 0; i < checkRuleCollection.size(); i++) {
				int row = dataTable.append();
				dataTable.setString(row, "Description", checkRuleCollection.get(i).getDescription());
				dataTable.setString(row, "ErrorInfo", checkRuleCollection.get(i).getErrorInfo());
				dataTable.setString(row, "UICheckRule", checkRuleCollection.get(i).getContent());
				dataTable.setState(RowState.NORMAL);
			}
		}
	}

	//表格明细行表格树设置
	private void loadGridTree(DataTable dataTable, MetaForm ownerMetaForm, MetaGridRow metaGridCells) {
		MetaRowTree metaRowTree = metaGridCells.getRowTree();
		if (metaRowTree != null) {
			int row = dataTable.insert();
			dataTable.setInt(row, "IsExpand", metaRowTree.isExpand() ? 1 : 0);
			dataTable.setInt(row, "ExpandLevel", metaRowTree.getExpandLevel());
			dataTable.setString(row, "CellKey", metaRowTree.getCellKey());
			dataTable.setInt(row, "TreeType", metaRowTree.getTreeType());
			dataTable.setString(row, "Foreign", metaRowTree.getForeign());
			dataTable.setString(row, "Parent", metaRowTree.getParent());
			dataTable.setString(row, "Type", metaRowTree.getType() == -1 ? "Formal" : "JavaScript");
			dataTable.setString(row, "Content", metaRowTree.getContent());
			dataTable.setState(RowState.NORMAL);
		}
	}

	/**
	 * 加载追溯集合表单内容
	 */
	private void loadTraceCollectionDetail(DataTable dataTable, MetaGrid traceCollectionProperty) {
		MetaTraceCollection items = traceCollectionProperty.getTraceCollection();
		if (items != null) {
			dataTable.clear();
			for (int i = 0; i < items.size(); i++) {
				int index = dataTable.insert(i);
				dataTable.setString(index, ConstantUtil.CAPTION, items.get(i).getCaption());
				dataTable.setString(index, ConstantUtil.CONDITION, items.get(i).getCondition());
				dataTable.setString(index, ConstantUtil.EXPRESSION, items.get(i).getContent());
				dataTable.setState(RowState.NORMAL);
			}
		}
	}

	/**
	 * 加载追溯集合表单内容
	 */
	private void loadExtOptCollection(DataTable dataTable, MetaGrid extOptCollectionProperty) {
		MetaExtOptCollection items = extOptCollectionProperty.getExtOpts();
		if (items != null) {
			dataTable.clear();
			for (int i = 0; i < items.size(); i++) {
				int index = dataTable.insert(i);
				dataTable.setString(index, ConstantUtil.CAPTION, items.get(i).getCaption());
				dataTable.setString(index, "Icon", items.get(i).getIcon());
				dataTable.setString(index, ConstantUtil.EXPRESSION, items.get(i).getContent());
				dataTable.setState(RowState.NORMAL);
			}
		}
	}

	private Document loadIndicatorSetting(MetaForm ownerMetaForm, Document document, MetaDataObject designDataObject, String erpCompKey) throws Throwable {
		MetaTable propertiesMetaTable = designDataObject.getMetaTable("ED_IndicatorSetting");
		DataTable propertiesDataTable = WebDesignerDataTableUtil.generateDataTable(propertiesMetaTable);
		AbstractMetaObject metaObject = DesignIOMetaUtil.getMetaComponent(ownerMetaForm, erpCompKey);
		if(metaObject == null || !metaObject.getTagName().equals("TableRow")) return document;
		MetaTableRow metaTableRow = (MetaTableRow) metaObject;
		int rowIndex = propertiesDataTable.append();
		propertiesDataTable.setObject(rowIndex, "Indicator", metaTableRow.isIndicator());
		propertiesDataTable.setObject(rowIndex, "IndicatorKey", metaTableRow.getIndicatorKey());
		propertiesDataTable.setState(RowState.NORMAL);
		document.add("ED_IndicatorSetting", propertiesDataTable);
		return document;
	}

	private void loadComboBoxSourceSetting(MetaForm ownerMetaForm, Document document, MetaDataObject designDataObject, String erpCompKey) throws Throwable {
		MetaTable propertiesMetaTable = designDataObject.getMetaTable("ED_FilterProperties");
		DataTable propertiesDataTable = WebDesignerDataTableUtil.generateDataTable(propertiesMetaTable);
		loadComboFilterProperties(ownerMetaForm, erpCompKey, propertiesDataTable);
		document.add("ED_FilterProperties", propertiesDataTable);

		MetaTable filterDetailMetaTable = designDataObject.getMetaTable("ED_ComboFilterDetail");
		DataTable filterDetailDataTable = WebDesignerDataTableUtil.generateDataTable(filterDetailMetaTable);
		loadComboFilterDetail(ownerMetaForm, erpCompKey, filterDetailDataTable);
		document.add("ED_ComboFilterDetail", filterDetailDataTable);

		MetaTable comboBoxQueryDefHead = designDataObject.getMetaTable("D_ComboBoxQueryDefHead");
		DataTable comboBoxQueryDefHeadTable = WebDesignerDataTableUtil.generateDataTable(comboBoxQueryDefHead);
		loadComboBoxQueryDefHead(ownerMetaForm, erpCompKey, comboBoxQueryDefHeadTable);
		document.add("D_ComboBoxQueryDefHead", comboBoxQueryDefHeadTable);

		MetaTable comboBoxFilterQueryDefHead = designDataObject.getMetaTable("D_Filter_ComboBoxQueryDefHead");
		DataTable comboBoxFilterQueryDefHeadTable = WebDesignerDataTableUtil.generateDataTable(comboBoxFilterQueryDefHead);
		loadComboBoxFilterQueryDefHead(ownerMetaForm, erpCompKey, comboBoxFilterQueryDefHeadTable);
		document.add("D_Filter_ComboBoxQueryDefHead", comboBoxFilterQueryDefHeadTable);

		MetaTable parameterMetaTable = designDataObject.getMetaTable("ED_ParameterCollection");
		DataTable parameterDataTable = WebDesignerDataTableUtil.generateDataTable(parameterMetaTable);
		loadComboParameterCollection(ownerMetaForm, erpCompKey, parameterDataTable);
		document.add("ED_ParameterCollection", parameterDataTable);

		MetaTable filterParameterMetaTable = designDataObject.getMetaTable("ED_Filter_ParameterCollection");
		DataTable filterParameterDataTable = WebDesignerDataTableUtil.generateDataTable(filterParameterMetaTable);
		loadComboFilterParameterCollection(ownerMetaForm, erpCompKey, filterParameterDataTable);
		document.add("ED_Filter_ParameterCollection", filterParameterDataTable);
	}

	private static MetaComboFilter getMetaComboFilter(AbstractMetaObject metaObject) {
		MetaComboFilter metaComboFilter = null;
		if (metaObject instanceof MetaComboBox) {
			metaComboFilter = ((MetaComboBox) metaObject).getProperties().getComboFilter();
		} else if (metaObject instanceof MetaCheckListBox) {
			metaComboFilter = ((MetaCheckListBox) metaObject).getProperties().getComboFilter();
		} else if (metaObject instanceof MetaGridCell) {
			AbstractMetaObject properties = ((MetaGridCell) metaObject).getProperties();
			if (((MetaGridCell) metaObject).getCellType() == ControlType.COMBOBOX) {
				metaComboFilter = ((MetaComboBoxProperties) properties).getComboFilter();
			} else if (((MetaGridCell) metaObject).getCellType() == ControlType.CHECKLISTBOX) {
				metaComboFilter = ((MetaCheckListBoxProperties) properties).getComboFilter();
			}
		} else if (metaObject instanceof MetaListViewColumn) {
			AbstractMetaObject properties = ((MetaListViewColumn) metaObject).getProperties();
			if (((MetaListViewColumn) metaObject).getColumnType() == ControlType.COMBOBOX) {
				metaComboFilter = ((MetaComboBoxProperties) properties).getComboFilter();
			} else if (((MetaListViewColumn) metaObject).getColumnType() == ControlType.CHECKLISTBOX) {
				metaComboFilter = ((MetaCheckListBoxProperties) properties).getComboFilter();
			}
		}
		return metaComboFilter;
	}

	private void loadComboBoxQueryDefHead(MetaForm ownerMetaForm, String erpCompKey, DataTable comboBoxQueryDefHeadTable) throws Throwable {
		AbstractMetaObject metaObject = DesignIOMetaUtil.getMetaComponent(ownerMetaForm, erpCompKey);
		MetaQueryDef metaQueryDef = null;
		String itemsDependency = "";
		if (metaObject instanceof MetaComboBox) {
			metaQueryDef = ((MetaComboBox) metaObject).getProperties().getQueryDef();
			itemsDependency = ((MetaComboBox) metaObject).getProperties().getItemsDependency();
		} else if (metaObject instanceof MetaCheckListBox) {
			metaQueryDef = ((MetaCheckListBox) metaObject).getProperties().getQueryDef();
			itemsDependency = ((MetaCheckListBox) metaObject).getProperties().getItemsDependency();
		} else if (metaObject instanceof MetaGridCell) {
			AbstractMetaObject properties = ((MetaGridCell) metaObject).getProperties();
			if (((MetaGridCell) metaObject).getCellType() == ControlType.COMBOBOX) {
				metaQueryDef = ((MetaComboBoxProperties) properties).getQueryDef();
				itemsDependency = ((MetaComboBoxProperties) properties).getItemsDependency();
			} else if (((MetaGridCell) metaObject).getCellType() == ControlType.CHECKLISTBOX) {
				metaQueryDef = ((MetaCheckListBoxProperties) properties).getQueryDef();
				itemsDependency = ((MetaCheckListBoxProperties) properties).getItemsDependency();
			}
		} else if (metaObject instanceof MetaListViewColumn) {
			AbstractMetaObject properties = ((MetaListViewColumn) metaObject).getProperties();
			if (((MetaListViewColumn) metaObject).getColumnType() == ControlType.COMBOBOX) {
				metaQueryDef = ((MetaComboBoxProperties) properties).getQueryDef();
				itemsDependency = ((MetaComboBoxProperties) properties).getItemsDependency();
			} else if (((MetaListViewColumn) metaObject).getColumnType() == ControlType.CHECKLISTBOX) {
				metaQueryDef = ((MetaCheckListBoxProperties) properties).getQueryDef();
				itemsDependency = ((MetaCheckListBoxProperties) properties).getItemsDependency();
			}
		}
		if (metaQueryDef != null && metaQueryDef.getStatement() != null) {
			comboBoxQueryDefHeadTable.append();
			comboBoxQueryDefHeadTable.setObject("Statement", metaQueryDef.getStatement().getContent());
			comboBoxQueryDefHeadTable.setObject("ItemsDependency", itemsDependency);
		}
	}

	private void loadComboBoxFilterQueryDefHead(MetaForm ownerMetaForm, String erpCompKey, DataTable comboBoxFilterQueryDefHeadTable) throws Throwable {
		AbstractMetaObject metaObject = DesignIOMetaUtil.getMetaComponent(ownerMetaForm, erpCompKey);
		MetaComboFilter metaComboFilter = getMetaComboFilter(metaObject);
		if(metaComboFilter != null && metaComboFilter.getQueryDef() != null && metaComboFilter.getQueryDef().getStatement() != null){
			comboBoxFilterQueryDefHeadTable.append();
			comboBoxFilterQueryDefHeadTable.setObject("Statement", metaComboFilter.getQueryDef().getStatement().getContent());
			comboBoxFilterQueryDefHeadTable.setObject("ItemsDependency", metaComboFilter.getItemsDependency());
		}
	}

	private void loadComboParameterCollection(MetaForm ownerMetaForm, String erpCompKey, DataTable parameterDataTable) throws Throwable {
		AbstractMetaObject metaObject = DesignIOMetaUtil.getMetaComponent(ownerMetaForm, erpCompKey);
		MetaQueryDef metaQueryDef = null;
		if (metaObject instanceof MetaComboBox) {
			metaQueryDef = ((MetaComboBox) metaObject).getProperties().getQueryDef();
		} else if (metaObject instanceof MetaCheckListBox) {
			metaQueryDef = ((MetaCheckListBox) metaObject).getProperties().getQueryDef();
		} else if (metaObject instanceof MetaGridCell) {
			AbstractMetaObject properties = ((MetaGridCell) metaObject).getProperties();
			if (((MetaGridCell) metaObject).getCellType() == ControlType.COMBOBOX) {
				metaQueryDef = ((MetaComboBoxProperties) properties).getQueryDef();
			} else if (((MetaGridCell) metaObject).getCellType() == ControlType.CHECKLISTBOX) {
				metaQueryDef = ((MetaCheckListBoxProperties) properties).getQueryDef();
			}
		} else if (metaObject instanceof MetaListViewColumn) {
			AbstractMetaObject properties = ((MetaListViewColumn) metaObject).getProperties();
			if (((MetaListViewColumn) metaObject).getColumnType() == ControlType.COMBOBOX) {
				metaQueryDef = ((MetaComboBoxProperties) properties).getQueryDef();
			} else if (((MetaListViewColumn) metaObject).getColumnType() == ControlType.CHECKLISTBOX) {
				metaQueryDef = ((MetaCheckListBoxProperties) properties).getQueryDef();
			}
		}
		if (metaQueryDef != null) {
			MetaParameterCollection metaParameters = metaQueryDef.getParameterCollection();
			if (metaParameters != null && !metaParameters.isEmpty()) {
				for (int i = 0; i < metaParameters.size(); i++) {
					MetaParameter metaParameter = metaParameters.get(i);
					int rowIndex = parameterDataTable.append();
					parameterDataTable.setObject(rowIndex, "SourceType", ParameterSourceType.format(metaParameter.getSourceType()));
					parameterDataTable.setObject(rowIndex, "Value", metaParameter.getValue());
					parameterDataTable.setObject(rowIndex, "DataType", DataType.toString(metaParameter.getDataType()));
					parameterDataTable.setObject(rowIndex, "Description", metaParameter.getDescription());
				}
			}
		}
	}

	private void loadComboFilterParameterCollection(MetaForm ownerMetaForm, String erpCompKey, DataTable filterParameterDataTable) throws Throwable {
		AbstractMetaObject metaObject = DesignIOMetaUtil.getMetaComponent(ownerMetaForm, erpCompKey);
		MetaComboFilter metaComboFilter = getMetaComboFilter(metaObject);
		if (metaComboFilter != null && metaComboFilter.getQueryDef() != null) {
			MetaParameterCollection metaParameters = metaComboFilter.getQueryDef().getParameterCollection();
			if (metaParameters != null && !metaParameters.isEmpty()) {
				for (int i = 0; i < metaParameters.size(); i++) {
					MetaParameter metaParameter = metaParameters.get(i);
					int rowIndex = filterParameterDataTable.append();
					filterParameterDataTable.setObject(rowIndex, "SourceType", ParameterSourceType.format(metaParameter.getSourceType()));
					filterParameterDataTable.setObject(rowIndex, "Value", metaParameter.getValue());
					filterParameterDataTable.setObject(rowIndex, "DataType", DataType.toString(metaParameter.getDataType()));
					filterParameterDataTable.setObject(rowIndex, "Description", metaParameter.getDescription());
				}
			}
		}
	}

	private void loadComboFilterProperties(MetaForm erpMetaForm, String erpCompKey, DataTable designDataTable) throws Throwable {
		AbstractMetaObject metaObject = DesignIOMetaUtil.getMetaComponent(erpMetaForm, erpCompKey);
		MetaComboFilter metaComboFilter = getMetaComboFilter(metaObject);
		int rowIndex = designDataTable.append();
		if (metaComboFilter != null) {
			designDataTable.setObject(rowIndex, "IsUseComboFilter", 1);
			designDataTable.setObject(rowIndex, "GetFilterType", ComboFilterType.toString(metaComboFilter.getType()));
			designDataTable.setObject(rowIndex, "GetFilterSourceType", ComboBoxSourceType.format(metaComboFilter.getSourceType()));
			designDataTable.setObject(rowIndex, "GetFilterFormulaItems", metaComboFilter.getFormulaItems() == null ? "" : metaComboFilter.getFormulaItems().getContent());
			designDataTable.setObject(rowIndex, "ItemsDependency", metaComboFilter.getItemsDependency());
		} else {
			designDataTable.setObject(rowIndex, "IsUseComboFilter", 0);
			designDataTable.setObject(rowIndex, "GetFilterType", ComboFilterType.STR_Filter);
			designDataTable.setObject(rowIndex, "GetFilterSourceType", ComboBoxSourceType.STR_ITEMS);
			designDataTable.setObject(rowIndex, "GetFilterFormulaItems", "");
			designDataTable.setObject(rowIndex, "ItemsDependency", "");
		}
	}

	// 下拉框过滤固定值数据查询
	private void loadComboFilterDetail(MetaForm erpMetaForm, String erpCompKey, DataTable designDataTable) throws Throwable {
		AbstractMetaObject metaObject = DesignIOMetaUtil.getMetaComponent(erpMetaForm, erpCompKey);
		List<TagNode> optionNodeList = new ArrayList<>();
		if (StringUtils.isNotBlank(erpMetaForm.getExtend())) {
			String erpXmlFilePath = LoadFileTree.getPathByFormKey(erpMetaForm.getExtend());
			// XmlTree
			String tmpPath = XmlFileProcessor.instance.getTmpFile(erpXmlFilePath);
			String filePath = StringUtils.isNotBlank(tmpPath) ? tmpPath : erpXmlFilePath;
			XmlTree xmlTree = Xml4jUtil.parseTree(filePath);
			TagNode rootNode = xmlTree.getRoot();
			List<TagNode> tagNodeList = rootNode.findNodesByTagName(metaObject.getTagName());
			for (TagNode tagNode : tagNodeList) {
				if (!StringUtils.equals(tagNode.getAttributes().get(ConstantUtil.KEY), erpCompKey)) {
					continue;
				}
				if(tagNode.findFirstTagNodeByTagName("ComboFiler") != null) {
					List<TagNode> itemNodeList = tagNode.findFirstTagNodeByTagName("ComboFiler").findNodesByTagName("Item");
					optionNodeList.addAll(itemNodeList);
				}
			}

			MetaFormList metaFormList = MetaFactory.getGlobalInstance().getMetaFormList();
			for (MetaFormProfile profile : metaFormList) {
				if (!StringUtils.equals(profile.getExtend(), erpMetaForm.getExtend()) || !Objects.equals(profile.getMergeToSource(), Boolean.TRUE)) {
					continue;
				}
				if (StringUtils.equals(erpMetaForm.getKey(), profile.getKey())) {
					continue;
				}
				String erpXmlFilePath2 = LoadFileTree.getPathByFormKey(profile.getKey());
				// XmlTree
				String tmpPath2 = XmlFileProcessor.instance.getTmpFile(erpXmlFilePath2);
				String filePath2 = StringUtils.isNotBlank(tmpPath2) ? tmpPath2 : erpXmlFilePath2;
				XmlTree xmlTree2 = Xml4jUtil.parseTree(filePath2);
				TagNode rootNode2 = xmlTree2.getRoot();
				List<TagNode> tagNodeList2 = rootNode2.findNodesByTagName(metaObject.getTagName());
				for (TagNode tagNode : tagNodeList2) {
					if (!StringUtils.equals(tagNode.getAttributes().get(ConstantUtil.KEY), erpCompKey)) {
						continue;
					}
					if(tagNode.findFirstTagNodeByTagName("ComboFiler") != null) {
						List<TagNode> itemNodeList = tagNode.findFirstTagNodeByTagName("ComboFilter").findNodesByTagName("Item");
						optionNodeList.addAll(itemNodeList);
					}
				}
			}
		} else {
			MetaFormList metaFormList = MetaFactory.getGlobalInstance().getMetaFormList();
			for (MetaFormProfile profile : metaFormList) {
				if (!StringUtils.equals(profile.getExtend(), erpMetaForm.getKey())) {
					continue;
				}
				String erpXmlFilePath = LoadFileTree.getPathByFormKey(profile.getKey());
				// XmlTree
				String tmpPath = XmlFileProcessor.instance.getTmpFile(erpXmlFilePath);
				String filePath = StringUtils.isNotBlank(tmpPath) ? tmpPath : erpXmlFilePath;
				XmlTree xmlTree = Xml4jUtil.parseTree(filePath);
				TagNode rootNode = xmlTree.getRoot();
				List<TagNode> tagNodeList = rootNode.findNodesByTagName(metaObject.getTagName());
				for (TagNode tagNode : tagNodeList) {
					if (!StringUtils.equals(tagNode.getAttributes().get(ConstantUtil.KEY), erpCompKey)) {
						continue;
					}
					if(tagNode.findFirstTagNodeByTagName("ComboFiler") != null) {
						List<TagNode> itemNodeList = tagNode.findFirstTagNodeByTagName("ComboFilter").findNodesByTagName("Item");
						optionNodeList.addAll(itemNodeList);
					}
				}
			}
		}

		List<String> optionKeyList = new ArrayList<>();
		for (TagNode optionNode : optionNodeList) {
			Map<String, String> attributes = optionNode.getAttributes();
			int rowIndex = designDataTable.append();
			designDataTable.setString(rowIndex, ConstantUtil.KEY, attributes.get(ConstantUtil.KEY));
			designDataTable.setString(rowIndex, ConstantUtil.CAPTION, attributes.get(ConstantUtil.CAPTION));
			designDataTable.setString(rowIndex, ConstantUtil.VALUE, attributes.get(ConstantUtil.VALUE));
			designDataTable.setInt(rowIndex, "ExtendFlag", 1);
			designDataTable.setState(RowState.NORMAL);

			optionKeyList.add(attributes.get(ConstantUtil.KEY));
		}

		BiConsumer<DataTable, List<MetaDefaultItem>> consumer = (dataTable, items) -> {
			for (int i = 0; i < items.size(); i++) {
				MetaDefaultItem item = items.get(i);
				if (optionKeyList.contains(item.getKey())) {
					continue;
				}
				int rowIndex = dataTable.append();

				dataTable.setString(rowIndex, ConstantUtil.KEY, item.getKey());
				dataTable.setString(rowIndex, ConstantUtil.CAPTION, item.getCaption());
				dataTable.setString(rowIndex, ConstantUtil.VALUE, item.getValue());
				dataTable.setInt(rowIndex, "ExtendFlag", 0);
				dataTable.setState(RowState.NORMAL);
			}
		};

		if (metaObject instanceof MetaGridCell) {
			MetaGridCell metaGridCell = (MetaGridCell) metaObject;
			AbstractMetaObject properties = metaGridCell.getProperties();
			if (properties instanceof MetaComboBoxProperties) {
				MetaComboFilter comboFilter = ((MetaComboBoxProperties) properties).getComboFilter();
				if(comboFilter != null) {
					List<MetaDefaultItem> items = comboFilter.getList();
					consumer.accept(designDataTable, items);
				}
				return;
			}
			if (properties instanceof MetaCheckListBoxProperties) {
				MetaComboFilter comboFilter = ((MetaCheckListBoxProperties) properties).getComboFilter();
				if(comboFilter != null) {
					List<MetaDefaultItem> items = comboFilter.getList();
					consumer.accept(designDataTable, items);
				}
				return;
			}
			return;
		}
		if (metaObject instanceof MetaComboBox) {
			MetaComboFilter comboFilter = ((MetaComboBox) metaObject).getProperties().getComboFilter();
			if(comboFilter != null) {
				List<MetaDefaultItem> items = comboFilter.getList();
				consumer.accept(designDataTable, items);
			}
			return;
		}
		if (metaObject instanceof MetaCheckListBox) {
			MetaComboFilter comboFilter = ((MetaCheckListBox) metaObject).getProperties().getComboFilter();
			if(comboFilter != null) {
				List<MetaDefaultItem> items = comboFilter.getList();
				consumer.accept(designDataTable, items);
			}
		}
	}

	private void loadCarouselDetail(MetaForm erpMetaForm, String erpCompKey, DataTable designDataTable) throws Throwable {
		MetaComponent metaComponent = getComponentByKey(erpMetaForm, erpCompKey);

		if (metaComponent != null && metaComponent.getControlType() == ControlType.CAROUSEL) {
			MetaCarousel metaCarousel = (MetaCarousel) metaComponent;
			MetaCarouselItemCollection items = metaCarousel.getItems();

			if (items != null) {
				for (int i = 0; i < items.size(); i ++) {
					MetaDefaultItem item = items.get(i);

					int rowIndex = designDataTable.append();
					designDataTable.setObject(rowIndex, "Key", item.getKey());
					designDataTable.setObject(rowIndex, "Value", item.getValue());
					designDataTable.setObject(rowIndex, "Caption", item.getCaption());
					designDataTable.setObject(rowIndex, "Icon", item.getIcon());
				}
			}
		}
	}

	private void loadRefreshHeaderDetail(MetaForm erpMetaForm, String erpCompKey, DataTable designDataTable) throws Throwable {
		MetaComponent metaComponent = getComponentByKey(erpMetaForm, erpCompKey);

		if (metaComponent != null && metaComponent.getControlType() == ControlType.REFRESHCONTROL) {
			MetaRefreshControl metaRefresh = (MetaRefreshControl) metaComponent;
			MetaRefreshHeader metaHeader = metaRefresh.getHeader();

			if (metaHeader != null) {
				MetaRefreshStateCollection stateCollection = metaHeader.getStateCollection();

				if (stateCollection != null) {
					for (int i = 0; i < stateCollection.size(); i ++) {
						MetaRefreshState state = stateCollection.get(i);
						int rowIndex = designDataTable.append();

						if (state.getText() != null) {
							designDataTable.setObject(rowIndex, "Text", state.getText());
						}

						if (state.getIcon() != null) {
							designDataTable.setObject(rowIndex, "Icon", state.getIcon());
						}

						designDataTable.setObject(rowIndex, "IconLocation", IconLocationType.toString(state.getIconLocation()));
						designDataTable.setObject(rowIndex, "Type", RefreshStateType.toString(state.getType()));

						MetaFormat metaFormat = state.getFormat();
						if (metaFormat != null) {
							designDataTable.setObject(rowIndex, "HAlign", HAlignment.toString(metaFormat.getHAlign()));
							designDataTable.setObject(rowIndex, "VAlign", VAlignment.toString(metaFormat.getVAlign()));
							designDataTable.setObject(rowIndex, "ForeColor", metaFormat.getForeColor());
							designDataTable.setObject(rowIndex, "BackColor", metaFormat.getBackColor());
							designDataTable.setObject(rowIndex, "HighlightBackColor", metaFormat.getHighlightBackColor());

							MetaFont metaFont = metaFormat.getFont();
							if (metaFont != null) {
								designDataTable.setObject(rowIndex, "Name", metaFont.getName());
								designDataTable.setObject(rowIndex, "Size", metaFont.getSize());
								designDataTable.setObject(rowIndex, "Bold", metaFont.getBold());
								designDataTable.setObject(rowIndex, "Italic", metaFont.getItalic());
							}
						}
					}
				}
			}
		}
	}

	private void loadPriceLabelItemDetail(MetaForm erpMetaForm, String erpCompKey, DataTable designDataTable) throws Throwable {
		MetaComponent metaComponent = getComponentByKey(erpMetaForm, erpCompKey);

		if (metaComponent != null && metaComponent.getControlType() == ControlType.PRICELABEL) {
			MetaPriceLabel metaPriceLabel = (MetaPriceLabel) metaComponent;
			MetaPriceLabelItemCollection items = metaPriceLabel.getItemCollection();

			if (items != null) {
				for (int i = 0; i < items.size(); i ++) {
					MetaPriceLabelItem item = items.get(i);

					int rowIndex = designDataTable.append();

					designDataTable.setObject(rowIndex, "Type", PriceLabelItemType.toString(item.getType()));

					MetaFormat metaFormat = item.getFormat();
					if (metaFormat != null) {
						designDataTable.setObject(rowIndex, "HAlign", HAlignment.toString(metaFormat.getHAlign()));
						designDataTable.setObject(rowIndex, "VAlign", VAlignment.toString(metaFormat.getVAlign()));
						designDataTable.setObject(rowIndex, "ForeColor", metaFormat.getForeColor());
						designDataTable.setObject(rowIndex, "BackColor", metaFormat.getBackColor());
						designDataTable.setObject(rowIndex, "HighlightBackColor", metaFormat.getHighlightBackColor());

						MetaFont metaFont = metaFormat.getFont();
						if (metaFont != null) {
							designDataTable.setObject(rowIndex, "Name", metaFont.getName());
							designDataTable.setObject(rowIndex, "Size", metaFont.getSize());
							designDataTable.setObject(rowIndex, "Bold", metaFont.getBold());
							designDataTable.setObject(rowIndex, "Italic", metaFont.getItalic());
						}
					}
				}
			}
		}
	}

	private void loadRowActionsDetail(MetaForm erpMetaForm, String erpCompKey, DataTable designDataTable, String rowKey) {
		MetaComponent metaComponent = getComponentByKey(erpMetaForm, erpCompKey);

		MetaRowActionCollection actions = null;
		if (metaComponent != null) {
			if (metaComponent.getControlType() == ControlType.EDITVIEW) {
				MetaEditView metaEditView = (MetaEditView) metaComponent;
				MetaEditViewRow metaEditViewRow = metaEditView.getRow();
				if (metaEditViewRow != null) {
					actions = metaEditViewRow.getActionCollection();
				}
			}

			if (metaComponent.getControlType() == ControlType.TABLEVIEW) {
				MetaTableView metaTableView = (MetaTableView) metaComponent;
				MetaTableRowCollection metaTableRows = metaTableView.getRows();
				if (metaTableRows != null) {
					for (MetaTableRow row: metaTableRows) {
						if (row.getKey() != null && row.getKey().equals(rowKey)) {
							actions = row.getActionCollection();
						}
					}
				}
			}
		}

		if (actions != null) {
			for (int i = 0; i < actions.size(); i ++) {
				MetaRowAction action = actions.get(i);

				int rowIndex = designDataTable.append();
				designDataTable.setObject(rowIndex, "Key", action.getKey());
				designDataTable.setObject(rowIndex, "Caption", action.getCaption());
				designDataTable.setObject(rowIndex, "Expression", action.getContent());
			}
		}
	}

	private void loadEditViewItemsDetail(MetaForm erpMetaForm, String erpCompKey, DataTable designDataTable) throws Throwable {
		MetaComponent metaComponent = getComponentByKey(erpMetaForm, erpCompKey);

		if (metaComponent != null && metaComponent.getControlType() == ControlType.EDITVIEW) {
			MetaEditView metaEditView = (MetaEditView) metaComponent;
			MetaEditViewItemCollection items = metaEditView.getItemCollection();

			if (items != null) {
				for (int i = 0; i < items.size(); i ++) {
					MetaEditViewItem item = items.get(i);

					int rowIndex = designDataTable.append();
					designDataTable.setObject(rowIndex, "Key", item.getKey());
					designDataTable.setObject(rowIndex, "Caption", item.getCaption());
					designDataTable.setObject(rowIndex, "Image", item.getImage());
					designDataTable.setObject(rowIndex, "ImageScaleType", ImageScaleType.toString(item.getImageScaleType()));
				}
			}
		}
	}

	// 下拉框固定值数据查询
	private void loadComboBoxDetail(MetaForm erpMetaForm, String erpCompKey, DataTable designDataTable) throws Throwable {
		AbstractMetaObject metaObject = DesignIOMetaUtil.getMetaComponent(erpMetaForm, erpCompKey);
		List<TagNode> optionNodeList = new ArrayList<>();
		if (StringUtils.isNotBlank(erpMetaForm.getExtend())) {
			String erpXmlFilePath = LoadFileTree.getPathByFormKey(erpMetaForm.getExtend());
			// XmlTree
			String tmpPath = XmlFileProcessor.instance.getTmpFile(erpXmlFilePath);
			String filePath = StringUtils.isNotBlank(tmpPath) ? tmpPath : erpXmlFilePath;
			XmlTree xmlTree = Xml4jUtil.parseTree(filePath);
			TagNode rootNode = xmlTree.getRoot();
			List<TagNode> tagNodeList = rootNode.findNodesByTagName(metaObject.getTagName());
			for (TagNode tagNode : tagNodeList) {
				if (!StringUtils.equals(tagNode.getAttributes().get(ConstantUtil.KEY), erpCompKey)) {
					continue;
				}
				List<TagNode> itemNodeList = tagNode.findNodesByTagName("Item");
				optionNodeList.addAll(itemNodeList);
			}

			MetaFormList metaFormList = MetaFactory.getGlobalInstance().getMetaFormList();
			for (MetaFormProfile profile : metaFormList) {
				if (!StringUtils.equals(profile.getExtend(), erpMetaForm.getExtend()) || !Objects.equals(profile.getMergeToSource(), Boolean.TRUE)) {
					continue;
				}
				if (StringUtils.equals(erpMetaForm.getKey(), profile.getKey())) {
					continue;
				}
				String erpXmlFilePath2 = LoadFileTree.getPathByFormKey(profile.getKey());
				// XmlTree
				String tmpPath2 = XmlFileProcessor.instance.getTmpFile(erpXmlFilePath2);
				String filePath2 = StringUtils.isNotBlank(tmpPath2) ? tmpPath2 : erpXmlFilePath2;
				XmlTree xmlTree2 = Xml4jUtil.parseTree(filePath2);
				TagNode rootNode2 = xmlTree2.getRoot();
				List<TagNode> tagNodeList2 = rootNode2.findNodesByTagName(metaObject.getTagName());
				for (TagNode tagNode : tagNodeList2) {
					if (!StringUtils.equals(tagNode.getAttributes().get(ConstantUtil.KEY), erpCompKey)) {
						continue;
					}
					List<TagNode> itemNodeList = tagNode.findNodesByTagName("Item");
					optionNodeList.addAll(itemNodeList);
				}
			}
		} else {
			MetaFormList metaFormList = MetaFactory.getGlobalInstance().getMetaFormList();
			for (MetaFormProfile profile : metaFormList) {
				if (!StringUtils.equals(profile.getExtend(), erpMetaForm.getKey())) {
					continue;
				}
				String erpXmlFilePath = LoadFileTree.getPathByFormKey(profile.getKey());
				// XmlTree
				String tmpPath = XmlFileProcessor.instance.getTmpFile(erpXmlFilePath);
				String filePath = StringUtils.isNotBlank(tmpPath) ? tmpPath : erpXmlFilePath;
				XmlTree xmlTree = Xml4jUtil.parseTree(filePath);
				TagNode rootNode = xmlTree.getRoot();
				List<TagNode> tagNodeList = rootNode.findNodesByTagName(metaObject.getTagName());
				for (TagNode tagNode : tagNodeList) {
					if (!StringUtils.equals(tagNode.getAttributes().get(ConstantUtil.KEY), erpCompKey)) {
						continue;
					}
					List<TagNode> itemNodeList = tagNode.findNodesByTagName("Item");
					optionNodeList.addAll(itemNodeList);
				}
			}
		}

		List<String> optionKeyList = new ArrayList<>();
		for (TagNode optionNode : optionNodeList) {
			Map<String, String> attributes = optionNode.getAttributes();
			int rowIndex = designDataTable.append();
			designDataTable.setString(rowIndex, ConstantUtil.KEY, attributes.get(ConstantUtil.KEY));
			designDataTable.setString(rowIndex, ConstantUtil.CAPTION, attributes.get(ConstantUtil.CAPTION));
			designDataTable.setString(rowIndex, ConstantUtil.VALUE, attributes.get(ConstantUtil.VALUE));
			designDataTable.setInt(rowIndex, "ExtendFlag", 1);
			designDataTable.setState(RowState.NORMAL);

			optionKeyList.add(attributes.get(ConstantUtil.KEY));
		}

		BiConsumer<DataTable, MetaListBoxItemCollection> consumer = (dataTable, items) -> {
			for (int i = 0; i < items.size(); i++) {
				MetaDefaultItem item = items.get(i);
				if (optionKeyList.contains(item.getKey())) {
					continue;
				}
				int rowIndex = dataTable.append();

				dataTable.setString(rowIndex, ConstantUtil.KEY, item.getKey());
				dataTable.setString(rowIndex, ConstantUtil.CAPTION, item.getCaption());
				dataTable.setString(rowIndex, ConstantUtil.VALUE, item.getValue());
				dataTable.setInt(rowIndex, "ExtendFlag", 0);
				dataTable.setState(RowState.NORMAL);
			}
		};

		if (metaObject instanceof MetaGridCell) {
			MetaGridCell metaGridCell = (MetaGridCell) metaObject;
			AbstractMetaObject properties = metaGridCell.getProperties();
			if (properties instanceof MetaComboBoxProperties) {
				MetaListBoxItemCollection items = ((MetaComboBoxProperties) properties).getItems();
				consumer.accept(designDataTable, items);
				return;
			}
			if (properties instanceof MetaCheckListBoxProperties) {
				MetaListBoxItemCollection items = ((MetaCheckListBoxProperties) properties).getItems();
				consumer.accept(designDataTable, items);
				return;
			}
			return;
		}
		if (metaObject instanceof MetaComboBox) {
			MetaListBoxItemCollection items = ((MetaComboBox) metaObject).getItems();
			consumer.accept(designDataTable, items);
			return;
		}
		if (metaObject instanceof MetaCheckListBox) {
			MetaListBoxItemCollection items = ((MetaCheckListBox) metaObject).getItems();
			consumer.accept(designDataTable, items);
		}
	}

	private void loadDictViewDetail(DataTable dataTable, AbstractMetaObject comboBoxProperty) {
		MetaDictViewColumnCollection metaDictViewColumns = ((MetaDictView) comboBoxProperty).getColumnCollection();
		dataTable.clear();
		if (metaDictViewColumns != null) {
			for (int i = 0; i < metaDictViewColumns.size(); i++) {
				int row = dataTable.insert(i);
				//dataTable.setString("Delete_NODB", ConstantUtil.X);
				dataTable.setString(row, ConstantUtil.KEY, metaDictViewColumns.get(i).getKey());
				dataTable.setString(row, ConstantUtil.CAPTION, metaDictViewColumns.get(i).getCaption());
				DefSize width = metaDictViewColumns.get(i).getWidth();
				dataTable.setInt(row, "Width", Objects.isNull(width) ? 0 : width.getSize());
				dataTable.setInt(row, "WidthUnit", Objects.isNull(width) ? 0 : width.getSizeType());
				dataTable.setState(RowState.NORMAL);
			}
		}
	}

	private void loadMacroList(MetaForm erpMetaForm, String erpXmlFilePath, DataTable designDataTable,MetaCommonDef metaCommonDef,Long POID) throws Throwable {

		boolean beExtendedFlag = false;
		Map<String, TagNode> extendMacroNodeMap = new HashMap<>();
		TagNode extendMacroCollectionNode = null;
		if (Objects.nonNull(erpMetaForm)) {
			beExtendedFlag = MetaFormHelper.isBeExtended(erpMetaForm);
			boolean vestFlag = StringUtils.isNotBlank(erpMetaForm.getExtend());

			if (vestFlag) {
				String erpExtendXmlFilePath = LoadFileTree.getPathByFormKey(erpMetaForm.getExtend());
				String tmpExtendFilePath = XmlFileProcessor.instance.getTmpFile(erpExtendXmlFilePath);
				String extendFilePath = StringUtils.isNotBlank(tmpExtendFilePath) ? tmpExtendFilePath : erpExtendXmlFilePath;

				XmlTreeWithPath extendXmlTreeWithPath = XmlTreeWithPath.parseFilePath(FilePathHelper.toBackFilePath(extendFilePath));
				if (Objects.nonNull(extendXmlTreeWithPath)) {
					XmlTree extendXmlTree = extendXmlTreeWithPath.xmlTree;
					TagNode extendRootNode = extendXmlTree.getRoot();
					extendMacroCollectionNode = extendRootNode.getOrCreateChildByTagName(MetaMacroCollection.TAG_NAME);
					List<TagNode> extendMacroNodeList = extendMacroCollectionNode.findNodesByTagName("Macro");
					Map<String, TagNode> tmpExtendMacroNodeMap = extendMacroNodeList.stream().collect(Collectors.toMap(item -> item.getAttributes().get(ConstantUtil.KEY), Function.identity()));
					extendMacroNodeMap.putAll(tmpExtendMacroNodeMap);
				}
			}
		}
		if (erpMetaForm != null && erpMetaForm.getMergeToSource()) {
			String tmpFilePath = XmlFileProcessor.instance.getTmpFile(erpXmlFilePath);
			String filePath = StringUtils.isNotBlank(tmpFilePath) ? tmpFilePath : erpXmlFilePath;
			XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(FilePathHelper.toBackFilePath(filePath));
			TagNode rootNode = xmlTreeWithPath.xmlTree.getRoot();
			TagNode macroCollectionNode = rootNode.getOrCreateChildByTagName(MetaMacroCollection.TAG_NAME);

			List<TagNode> macro = macroCollectionNode.findNodesByTagName("Macro");
			Map<String, TagNode> tmpExtendMacroNodeMap = macro.stream().collect(Collectors.toMap(item -> item.getAttributes().get(ConstantUtil.KEY), Function.identity()));

			List<XmlTree> uiVestXmlTreeList = null;
			if (erpMetaForm.getMacroCollection()!=null){
				for (MetaMacro metaMacro : erpMetaForm.getMacroCollection()) {
					int row = designDataTable.append();
					designDataTable.setObject(row, ConstantUtil.DataSourceType, "meta");
					if (tmpExtendMacroNodeMap.containsKey(metaMacro.getKey()) ) {
						designDataTable.setObject(row, ConstantUtil.DataSourceType, "xml");
					}
					boolean extend = isExtend(extendMacroCollectionNode, metaMacro.getKey());
					designDataTable.setString(row, "Key", metaMacro.getKey());
					designDataTable.setString(row, "Args", metaMacro.getArgs());
					designDataTable.setString(row, "Formula", metaMacro.getContent());
					if (extend) {
						designDataTable.setInt(row, "ExtendFlag", 1);
						designDataTable.setInt(row, "BeExtendedFlagFormula", 0);
					} else {
						if (Objects.isNull(uiVestXmlTreeList)) {
							uiVestXmlTreeList = new ArrayList<>();

							Pair<List<MetaFormProfile>, MetaFormProfile> pair = MetaFormHelper.listVestMetaFormBySpecVest(erpMetaForm);
							final List<MetaFormProfile> uiVestList = pair.getLeft();
							for (MetaFormProfile uiVest : uiVestList) {
								String uiVestFilePath = LoadFileTree.getPathByFormKey(uiVest.getKey());
								String tmpUiVestFilePath = XmlFileProcessor.instance.getTmpFile(uiVestFilePath);
								uiVestFilePath = StringUtils.isNotBlank(tmpUiVestFilePath) ? tmpUiVestFilePath : uiVestFilePath;

								XmlTreeWithPath uiVestXmlTreeWithPath = XmlTreeWithPath.parseFilePath(FilePathHelper.toBackFilePath(uiVestFilePath));
								if (Objects.nonNull(uiVestXmlTreeWithPath)) {
									XmlTree uiVestXmlTree = uiVestXmlTreeWithPath.xmlTree;
									uiVestXmlTreeList.add(uiVestXmlTree);
								}
							}
						}
						int beExtendMacroFlag = 0;
						for (XmlTree uiVestXmlTree : uiVestXmlTreeList) {
							if (uiVestXmlTree.containKey("Macro@" + metaMacro.getKey())) {
								beExtendMacroFlag = 1;
								break;
							}
						}
						designDataTable.setInt(row, "ExtendFlag", 0);
						designDataTable.setInt(row, "BeExtendedFlagFormula", beExtendMacroFlag);
					}
					designDataTable.setState(RowState.NORMAL);
				}
			}

		} else {
			if (erpMetaForm!=null && erpMetaForm.getMacroCollection()!=null){
				String tmpFilePath = XmlFileProcessor.instance.getTmpFile(erpXmlFilePath);
				String filePath = StringUtils.isNotBlank(tmpFilePath) ? tmpFilePath : erpXmlFilePath;
				XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(FilePathHelper.toBackFilePath(filePath));
				TagNode rootNode = xmlTreeWithPath.xmlTree.getRoot();
				TagNode macroCollectionNode = rootNode.getOrCreateChildByTagName(MetaMacroCollection.TAG_NAME);

				List<TagNode> macro = macroCollectionNode.findNodesByTagName("Macro");
				Map<String, TagNode> tmpExtendMacroNodeMap = macro.stream().collect(Collectors.toMap(item -> item.getAttributes().get(ConstantUtil.KEY), Function.identity()));

				for (MetaMacro metaMacro : erpMetaForm.getMacroCollection()) {
					String key = metaMacro.getKey();
					boolean src = tmpExtendMacroNodeMap.containsKey(key);
					boolean extend = extendMacroNodeMap.containsKey(key);
					int row = designDataTable.append();
					designDataTable.setString(row, "Key", key);
					designDataTable.setString(row, "Args", metaMacro.getArgs());
					designDataTable.setString(row, "Formula", metaMacro.getContent());
					designDataTable.setInt(row, "BeExtendedFlagFormula", 0);
					if (extend){
						designDataTable.setInt(row, "ExtendFlag", 1);
					} else {
						designDataTable.setInt(row, "ExtendFlag", 0);
					}
					designDataTable.setState(RowState.NORMAL);
					if (src){//存在xml
						designDataTable.setObject(row, ConstantUtil.DataSourceType, "xml");
					} else {//不存在xml
						//可以重写
						designDataTable.setObject(row, ConstantUtil.DataSourceType, "meta");
					}
				}

			} else {
				if (metaCommonDef !=null&&metaCommonDef.getMacroCollection()!=null){
					for (MetaMacro metaMacro : metaCommonDef.getMacroCollection()) {
						int row = designDataTable.append();
						designDataTable.setString(row, "Key", metaMacro.getKey());
						designDataTable.setObject(row, "POID", POID);

						designDataTable.setString(row, "Args", metaMacro.getArgs());

						designDataTable.setString(row, "Formula", metaMacro.getContent());

						if (beExtendedFlag) {
							designDataTable.setInt(row, "BeExtendedFlagFormula", 1);
						} else {
							designDataTable.setInt(row, "BeExtendedFlagFormula", 0);
						}
//					if (Objects.nonNull(extendTagNode)) {
//						designDataTable.setInt(row, "ExtendFlag", 1);
//					} else {
						designDataTable.setInt(row, "ExtendFlag", 0);
//					}
						designDataTable.setObject(row, ConstantUtil.DataSourceType, "xml");
						designDataTable.setState(RowState.NORMAL);
					}
				}

			}

		}
	}

	private boolean isExtend(TagNode macroCollection, String key) {
		if (macroCollection == null) {
			return false;
		}
		List<AbstractNode> children = macroCollection.getChildren();
		boolean isExtend = false;
		for (AbstractNode childNode : children) {
			if (!(childNode instanceof TagNode)) {
				continue;
			}

			TagNode tagNode = (TagNode) childNode;
			if (!StringUtils.equalsIgnoreCase(tagNode.getTagName(), "macro")) {
				continue;
			}

			Map<String, String> attributes = tagNode.getAttributes();
			if (!isExtend) {
				isExtend = key.equals(attributes.get(ConstantUtil.KEY));
			}
		}
		return isExtend;
	}

	private void loadTableCollection(DefaultContext context, Document document, MetaForm erpMetaForm, MetaForm erpContainerMetaForm, String erpMainTableKey, MetaTable designParameterMetaTable, MetaTable designIndexMetaTable, DataTable designTableDataTable) throws Throwable {
		erpMetaForm = Objects.nonNull(erpContainerMetaForm) ? erpContainerMetaForm : erpMetaForm;
		MetaDataSource metaDataSource = erpMetaForm.getDataSource();
		if (Objects.isNull(metaDataSource)) {
			MetaTable columnMetaTable = getMetaTable();
			DataTable columnDataTable = WebDesignerDataTableUtil.generateDataTable(columnMetaTable);
			document.add(columnDataTable.getKey(), columnDataTable);

			DataTable parameterDataTable = WebDesignerDataTableUtil.generateDataTable(designParameterMetaTable);
			document.add(parameterDataTable.getKey(), parameterDataTable);
			return;
		}

		String xmlFilePath = LoadFileTree.getPathByFormKey(erpMetaForm.getKey());
		String tempXmlFilePath = XmlFileProcessor.instance.getTmpFile(xmlFilePath);
		String filePath = StringUtils.isNotBlank(tempXmlFilePath) ? tempXmlFilePath : xmlFilePath;

		XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(FilePathHelper.toBackFilePath(filePath));
		TagNode rootNode = xmlTreeWithPath.xmlTree.getRoot();
		TagNode dataSourceNode = rootNode.getOrCreateChildByTagName(ConstantUtil.DATA_SOURCE);
		String refObjectKey = dataSourceNode.getAttributes().get("RefObjectKey");

		final List<String> embedTableKeyList = this.getEmbedTableKeyList(erpMetaForm);

		if (StringUtils.isBlank(refObjectKey)) {
			MetaDataObject metaDataObject = metaDataSource.getDataObject();
			filterTable(context, document, filePath, metaDataObject, erpMainTableKey, designParameterMetaTable, designIndexMetaTable, designTableDataTable, embedTableKeyList);
			return;
		}

		IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
		MetaDataObject metaDataObject = metaFactory.getDataObject(refObjectKey);
		String refObjectFilePath = LoadFileTree.getPathByDataObject(refObjectKey);
		if (Objects.isNull(metaDataObject)) { // TODO 这是什么逻辑？
			erpMetaForm.getDataSource().setRefObjectKey(refObjectKey);
			DataObjectHelper.reload(null,refObjectKey, refObjectFilePath, null);
			metaDataObject = metaFactory.getDataObject(refObjectKey);
		}
		String tempRefObjectFilePath = XmlFileProcessor.instance.getTmpFile(refObjectFilePath);
		String refFilePath = StringUtils.isNotBlank(tempRefObjectFilePath) ? tempRefObjectFilePath : refObjectFilePath;
		filterTable(context, document, refFilePath, metaDataObject, erpMainTableKey, designParameterMetaTable, designIndexMetaTable, designTableDataTable, embedTableKeyList);
	}

	/**
	 * 过滤 数据源 和 数据对象的tableKey
	 */
	private XmlTree filterTable(DefaultContext context, Document document,
								String erpXmlFilePath, MetaDataObject erpDataObject, String erpMainTableKey,
								MetaTable designParameterMetaTable, MetaTable designIndexMetaTable, DataTable designTableDataTable, List<String> embedTableKeyList) throws Throwable {

		MetaTableCollection erpMetaTableCollection = erpDataObject.getTableCollection();
		if (Objects.isNull(erpMetaTableCollection)) {
			return null;
		}

		MetaEmbedTableCollection embedTables = erpDataObject.getEmbedTables();
		if (Objects.nonNull(embedTables)) {
			for (MetaEmbedTable embedTable : embedTables) {
				embedTableKeyList.add(embedTable.getTableKeys());
			}
		}

		// XmlTree
		String tmpPath = XmlFileProcessor.instance.getTmpFile(erpXmlFilePath);
		String filePath = StringUtils.isNotBlank(tmpPath) ? tmpPath : erpXmlFilePath;
		XmlTree xmlTree = Xml4jUtil.parseTree(filePath);
		if (Objects.isNull(xmlTree)) {
			String pathByDataObject = LoadFileTree.getPathByDataObject(erpXmlFilePath);
			xmlTree = Xml4jUtil.parseTree(pathByDataObject);
		}
		TagNode rootNode = xmlTree.getRoot();
		Map<String, String> attributes = rootNode.getAttributes();
		String formKey = attributes.get(ConstantUtil.KEY);
		String extend = attributes.get(ConstantUtil.EXTEND);
		String mergeToSourceAttrValue = attributes.get("MergeToSource");
		boolean mergeToSource = StringUtils.equalsAnyIgnoreCase(mergeToSourceAttrValue, "1", "true");

		XmlTree extendXmlTree = null;
		if (StringUtils.isNotBlank(extend)) {
			final String extendPath = LoadFileTree.getPathByFormKey(extend);
			if (StringUtils.isNotBlank(extendPath)) {
				String tmpExtendPath = XmlFileProcessor.instance.getTmpFile(extendPath);
				String extendFilePath = StringUtils.isNotBlank(tmpExtendPath) ? tmpExtendPath : extendPath;
				extendXmlTree = Xml4jUtil.parseTree(extendFilePath);
			}
		}

		// 所有TableKey
		List<TagNode> tableNodeList = rootNode.findNodesByTagName("Table");
		List<String> tableKeyList = tableNodeList.stream()
				.filter(tableNode -> {
					List<TagNode> columnNodeList = tableNode.findNodesByTagName(ConstantUtil.COLUMN);
					if (CollectionUtils.isEmpty(columnNodeList)) {
						return false;
					}
					return columnNodeList.stream().anyMatch(columnNode -> StringUtils.equalsIgnoreCase(columnNode.getAttributes().get(ConstantUtil.KEY), ConstantUtil.OID));
				}).map(tableNode -> tableNode.getAttributes().get(ConstantUtil.KEY))
				.collect(Collectors.toList());

		// 所有表的字段
		MetaTable columnMetaTable = getMetaTable();
		DataTable columnDataTable = WebDesignerDataTableUtil.generateDataTable(columnMetaTable);
		document.add(columnDataTable.getKey(), columnDataTable);

		// 所有参数
		DataTable parameterDataTable = WebDesignerDataTableUtil.generateDataTable(designParameterMetaTable);
		document.add(parameterDataTable.getKey(), parameterDataTable);

		// 所有索引集合
		DataTable indexDataTable = null;
		if (Objects.nonNull(designIndexMetaTable)){
			indexDataTable = WebDesignerDataTableUtil.generateDataTable(designIndexMetaTable);
			document.add(indexDataTable.getKey(), indexDataTable);
		}
		for (MetaTable metaTable : erpMetaTableCollection) {
			String tableKey = metaTable.getKey();
			if (metaTable.isT()){//T表不显示
				continue;
			}
			if (tableKey.contains(MetaFormNODBProcess.STR_NODBTable_Profix)) {
				continue;
			}

			if (StringUtils.equals(rootNode.getTagName(), "Form")) {
				if (embedTableKeyList.contains(tableKey)) {
					continue;
				}
			}

			Long oid = context.applyNewOID();
			int row = designTableDataTable.append();
			designTableDataTable.setLong(row, ConstantUtil.OID, oid);
			designTableDataTable.setString(row, "TableMark", tableKey); // 表标识
			designTableDataTable.setString(row, "TableName", metaTable.getCaption());// 表名称

			String orderBy = metaTable.getOrderBy();
			TagNode tableNode = xmlTree.getTagNode("Table@" + tableKey);
			if (Objects.nonNull(tableNode)) {
				String orderBy1 = tableNode.getAttributes().get("OrderBy");
				if (StringUtils.isBlank(orderBy1) && Objects.nonNull(extendXmlTree)) {
					TagNode extendTableNode = extendXmlTree.getTagNode("Table@" + tableKey);
					if (Objects.nonNull(extendTableNode)) {
						orderBy1 = extendTableNode.getAttributes().get("OrderBy");
					}
				}
				if (StringUtils.isNotBlank(orderBy1)) {
					orderBy = orderBy1;
				}
			}
			designTableDataTable.setString(row, "OrderBy", orderBy);

			designTableDataTable.setString(row, "GroupBy", metaTable.getGroupBy());
			designTableDataTable.setString(row, "IndexPrefix", metaTable.getIndexPrefix());
			designTableDataTable.setString(row, "AssociationTable", metaTable.getDBTableName());// 关联数据表名
			if (StringUtils.equalsIgnoreCase(tableKey, erpMainTableKey)) {
				designTableDataTable.setInt(row, "IsPrimaryTable", 1);// 是否主表
			} else {
				designTableDataTable.setInt(row, "IsPrimaryTable", 0);// 是否主表
			}
			if (metaTable.isPersist()) {
				designTableDataTable.setInt(row, "Persist", 1);
			} else {
				designTableDataTable.setInt(row, "Persist", 0);
			}
			int tableMode = metaTable.getTableMode() == TableMode.HEAD ? TableMode.HEAD : TableMode.DETAIL;
			designTableDataTable.setInt(row, "TableMode", tableMode);// 数据表模式

			String parentKey = metaTable.getParentKey();
			if (StringUtils.isNotBlank(parentKey)) {
				designTableDataTable.setString(row, "ParentTableKey", parentKey);// 父表标识
			} else {
				designTableDataTable.setString(row, "ParentTableKey", "0");// 父表标识
			}
			designTableDataTable.setString(row, ConstantUtil.TYPE, sourceType(metaTable.getSourceType()));
			String sourceType = IOMetaObject.sourceType(metaTable.getSourceType());
			switch (sourceType) {
				case ConstantUtil.DATA_OBJECT:
					MetaTableFilter filter = metaTable.getFilter();
					if (filter != null) {
						designTableDataTable.setString(row, "TableFilter", filter.getFilter());
						designTableDataTable.setString(row, ConstantUtil.TableFilterType, TableFilterType.toString(filter.getType()));
					}
					break;
				case "Query":
					MetaTableFilter filter1 = metaTable.getFilter();
					if (filter1 != null) {
						designTableDataTable.setString(row, "TableFilter", filter1.getFilter());
						designTableDataTable.setString(row, ConstantUtil.TableFilterType, TableFilterType.toString(filter1.getType()));
					}
					MetaStatement statementQuery = metaTable.getStatement();
					if (statementQuery != null) {
						if (statementQuery.getType() == TableStatementType.SQL) {
							designTableDataTable.setString(row, "QueryType", "Sql");
						} else {
							designTableDataTable.setString(row, "QueryType", "Formula");
						}
					}
					MetaTableFilter filterQuery = metaTable.getFilter();
					if (statementQuery != null) {
						designTableDataTable.setString(row, "Statement", statementQuery.getContent());
					}
					if (filterQuery != null) {
						designTableDataTable.setString(row, "TableFilterTwo", filterQuery.getFilter());
					}
					break;
				case "Custom":
					String formula = metaTable.getFormula();
					if (formula != null && !"".equalsIgnoreCase(formula)) {
						designTableDataTable.setString(row, "Formula", formula);
					}
					break;
				case "Interface":
					String impl = metaTable.getImpl();
					if (impl != null && !"".equalsIgnoreCase(impl)) {
						designTableDataTable.setString(row, "Impl", impl);
					}
					break;
				default:
					break;
			}
			if (tableKeyList.contains(tableKey)) {
				designTableDataTable.setInt(row, "ExtendTableFlag", 0);
			} else {
				designTableDataTable.setInt(row, "ExtendTableFlag", 1);
			}
			if (embedTableKeyList.contains(tableKey) || embedTableKeyList.contains(StringUtils.substringBefore(tableKey, "_T"))) {
				designTableDataTable.setInt(row, "EmbedTableFlag", 1);
			} else {
				designTableDataTable.setInt(row, "EmbedTableFlag", 0);
			}
			designTableDataTable.setState(RowState.NORMAL);

			// 加载表字段
			loadTableFields(columnDataTable, metaTable, oid, xmlTree);

			// 加载索引集合
			MetaIndexCollection indexCollection = metaTable.getIndexCollection();
			if (Objects.nonNull(indexCollection) && Objects.nonNull(indexDataTable)){
				loadIndexCollections(indexDataTable , oid, indexCollection);
			} else if (Objects.nonNull(extendXmlTree) && Objects.nonNull(indexDataTable)){
				TagNode node = extendXmlTree.getTagNode("Table@" + tableKey);
				List<TagNode> index = node == null ? new ArrayList<>() : node.findNodesByTagName("Index");
				loadIndexCollections(indexDataTable , oid, index);
			}
			// 加载表参数
			if (Objects.isNull(metaTable.getParameterCollection())) {
				continue;
			}
			MetaParameterCollection parameterCollection = metaTable.getParameterCollection();
			loadParameterCollections(parameterDataTable, oid, parameterCollection);
		}
		return xmlTree;
	}

	// 数据源参数集合
	private void loadParameterCollections(DataTable curDataTable, Long applyNewOID, MetaParameterCollection parameter) {
		for (int i = 0; i < parameter.size(); i++) {
			MetaParameter attributes = parameter.get(i);
			String sourceType = ParameterSourceType.format(attributes.getSourceType());
			String value = attributes.getValue();
			String description = attributes.getDescription();
			String dataType = DataType.toString(attributes.getDataType());
			String formula = attributes.getFormula();
			int rowNo = curDataTable.append();
			curDataTable.setLong(rowNo, ConstantUtil.POID, applyNewOID);
			curDataTable.setString(rowNo, "SourceType", StringUtils.isBlank(sourceType) ? "Formula" : sourceType);
			if (StringUtils.isBlank(sourceType) || StringUtils.equals(sourceType, "Formula")) {
				curDataTable.setString(rowNo, "Value", formula);
			} else {
				curDataTable.setString(rowNo, "Value", value);
			}
			curDataTable.setString(rowNo, "Description", description);
			curDataTable.setString(rowNo, "DataType", dataType);
			curDataTable.setState(RowState.NORMAL);
		}
	}


	// 数据源索引集合
	private void loadIndexCollections(DataTable curDataTable, Long applyNewOID, MetaIndexCollection index){
		String key;
		String columns;
		Boolean isUnique;
		int rowNo;
		for (MetaIndex metaIndex : index) {
			key = metaIndex.getKey();
			columns = metaIndex.getColumns();
			isUnique = metaIndex.isUnique();
			rowNo = curDataTable.append();
			curDataTable.setLong(rowNo, ConstantUtil.POID, applyNewOID);
			curDataTable.setString(rowNo,"IndexKey", key);
			curDataTable.setString(rowNo,"Columns", columns);
			curDataTable.setLong(rowNo, "IsUnique", isUnique? 1L:0);
		}
	}
	private void loadIndexCollections(DataTable curDataTable, Long applyNewOID, List<TagNode> index){
		String key;
		String columns;
		Boolean isUnique;
		int rowNo;

		for (TagNode tagNode : index) {
			Map<String, String> attributes = tagNode.getAttributes();
			key = attributes.get("Key");
			columns = attributes.get("Columns");
			isUnique = Boolean.parseBoolean(attributes.get("IsUnique"));
			rowNo = curDataTable.append();
			curDataTable.setLong(rowNo, ConstantUtil.POID, applyNewOID);
			curDataTable.setString(rowNo,"IndexKey", key);
			curDataTable.setString(rowNo,"Columns", columns);
			curDataTable.setLong(rowNo, "IsUnique", isUnique? 1L:0);
		}
	}

	private void loadTableFields(DataTable columnDataTable, MetaTable metaTable, Long applyNewOID, XmlTree xmlTree) throws Throwable {
		final Function<MetaColumn, String> groupTypeFunc = metaColumn -> {
			String groupType;
			if (metaColumn.getGroupType() == 0) {
				groupType = "Discrete";
			} else if (metaColumn.getGroupType() == 1) {
				groupType = "Period";
			} else {
				groupType = "-1";
			}
			return groupType;
		};

		// TODO 判断是什么的配置文件，表单？数据对象？
		TagNode xmlRootNode = xmlTree.getRoot();
		// Map<String, String> attributes = xmlRootNode.getAttributes();
		// String formKey = attributes.get(ConstantUtil.KEY);
		// String extend = attributes.get(ConstantUtil.EXTEND);
		// String mergeToSource = attributes.get("MergeToSource");

		// 配置文件中的表字段
		Map<String, List<String>> tableColumnKeyMap = new HashMap<>();
		for (TagNode tableNode : xmlRootNode.findNodesByTagName("Table")) {
			String tableKey = tableNode.getAttributes().get(ConstantUtil.KEY);

			List<String> columnKeyList = new ArrayList<>();
			for (TagNode columnNode : tableNode.findNodesByTagName("Column")) {
				columnKeyList.add(columnNode.getAttributes().get(ConstantUtil.KEY));
			}
			tableColumnKeyMap.put(tableKey, columnKeyList);
		}

		List<String> xmlColumnKeyList = tableColumnKeyMap.getOrDefault(metaTable.getKey(), Collections.emptyList());
		Collection<MetaColumn> metaColumnList = metaTable.items();
		TagNode tagNode = xmlTree.getTagNode("Table@" + metaTable.getKey());
		for (MetaColumn metaColumn : metaColumnList) {
			String columnKey = metaColumn.getKey();
			if (StringUtils.equalsAny(columnKey, "MapCount", "SelectField", "LastModified") || StringUtils.endsWithAny(columnKey, "_CF", "_begin", "_end")) {
				continue;
			}
			if (tagNode != null){
				TagNode createDate = tagNode.getChildByKey("CreateDate");
				if (createDate == null && StringUtils.equalsAny(columnKey, "CreateDate") && StringUtils.isEmpty(metaColumn.getCaption())&&StringUtils.isEmpty(metaColumn.getDataElementKey())) {
					continue;
				}
			}
			if (metaColumn.isHidden()) {
				continue;
			}

			int rowNo = columnDataTable.append();
			columnDataTable.setLong(rowNo, ConstantUtil.POID, applyNewOID);
			columnDataTable.setString(rowNo, ConstantUtil.COLUMN_KEY, columnKey);
			columnDataTable.setString(rowNo, "ColumnName", metaColumn.getCaption());
			columnDataTable.setString(rowNo, "DBColumnName", metaColumn.getDBColumnName());
			columnDataTable.setString(rowNo, "DefaultValue", metaColumn.getDefaultValue());
			columnDataTable.setString(rowNo, ConstantUtil.DESCRIPTION, metaColumn.getDescription());
			columnDataTable.setInt(rowNo, "Sequence", rowNo);
			if (metaColumn.isPersist()) {
				columnDataTable.setInt(rowNo, "Persist", 1);
			} else {
				columnDataTable.setInt(rowNo, "Persist", 0);
			}
			if (metaColumn.getIsPrimary()) {
				columnDataTable.setInt(rowNo, "IsPrimary", 1);
			} else {
				columnDataTable.setInt(rowNo, "IsPrimary", 0);
			}
			if (metaColumn.isExpand()) {
				columnDataTable.setInt(rowNo, "Expand", 1);
			} else {
				columnDataTable.setInt(rowNo, "Expand", 0);
			}
			if (metaColumn.isAccessControl()) {
				columnDataTable.setInt(rowNo, "AccessControl", 1);
			} else {
				columnDataTable.setInt(rowNo, "AccessControl", 0);
			}
			if (metaColumn.isIgnoreQuery()) {
				columnDataTable.setInt(rowNo, "IgnoreQuery", 1);
			} else {
				columnDataTable.setInt(rowNo, "IgnoreQuery", 0);
			}
			if (metaColumn.getCache()) {
				columnDataTable.setInt(rowNo, "Cache", 1);
			} else {
				columnDataTable.setInt(rowNo, "Cache", 0);
			}
			if (metaColumn.isHidden()) {
				columnDataTable.setInt(rowNo, "Hidden", 1);
			} else {
				columnDataTable.setInt(rowNo, "Hidden", 0);
			}
			if (metaColumn.isIgnoreSave()) {
				columnDataTable.setInt(rowNo, "IgnoreSave", 1);
			} else {
				columnDataTable.setInt(rowNo, "IgnoreSave", 0);
			}
			if (xmlColumnKeyList.contains(columnKey)) {
				columnDataTable.setInt(rowNo, "ExtendColumnFlag", 0);
			} else {
				columnDataTable.setInt(rowNo, "ExtendColumnFlag", 1);
			}
			columnDataTable.setInt(rowNo, "SortType", metaColumn.getSort());
			columnDataTable.setInt(rowNo, "PeriodGranularity", metaColumn.getPeriodGranularity());
			columnDataTable.setInt(rowNo, "NeedRights", metaColumn.getNeedRights());
			columnDataTable.setObject(rowNo, "SupportI18n", metaColumn.isSupportI18n());
			columnDataTable.setString(rowNo, "ItemKey", metaColumn.getItemKey());
			columnDataTable.setInt(rowNo, "SplitType", metaColumn.getSplitType());
			columnDataTable.setString(rowNo, "GroupType", groupTypeFunc.apply(metaColumn));
			columnDataTable.setString(rowNo, "RefItemKeyCol", metaColumn.getRefItemKeyCol());
			columnDataTable.setBoolean(rowNo, "IsPrimaryKey", metaColumn.isPrimaryKey());
			String dataElementKey = metaColumn.getDataElementKey();
			MetaDataElement dataElement = MetaUtil.getDataElement(MetaFactory.getGlobalInstance(), dataElementKey);
			if (StringUtils.isEmpty(dataElementKey) || dataElement == null){
				columnDataTable.setString(rowNo, "Length", String.valueOf(metaColumn.getLength() == null?0:metaColumn.getLength()));
				columnDataTable.setString(rowNo, "Precision", String.valueOf(metaColumn.getPrecision() ==null?0:metaColumn.getPrecision()));
				columnDataTable.setString(rowNo, "Scale", String.valueOf(metaColumn.getScale() == null?0:metaColumn.getScale()));
				columnDataTable.setInt(rowNo, "ColumnType", metaColumn.getDataType());
			} else {
				columnDataTable.setString(rowNo, "Length", String.valueOf(dataElement.getLength() == null?0:dataElement.getLength()));
				columnDataTable.setString(rowNo, "Precision", String.valueOf(dataElement.getPrecision() == null?0:dataElement.getPrecision()));
				columnDataTable.setString(rowNo, "Scale", String.valueOf(dataElement.getScale() == null?0:dataElement.getScale()));
				columnDataTable.setInt(rowNo, "ColumnType", dataElement.getDataType());
			}
			columnDataTable.setString(rowNo, "DataElementKey", dataElementKey);
			columnDataTable.setString(rowNo, "RefCol", metaColumn.getRefCol());
			columnDataTable.setString(rowNo, ConstantUtil.CODE_COLUMN_KEY, metaColumn.getCodeColumnKey());
			columnDataTable.setState(RowState.NORMAL);
		}
	}

	// 面板布局设置”行“相关属性load
	private void loadLayoutRow(DataTable dataTable, MetaGridLayoutPanel metaPanel, MetaForm metaForm) throws Throwable {
		MetaRowDefCollection rowDefCollection = metaPanel.getMetaRowDefCollection();
		String dataTableKey = dataTable.getKey();

		XmlTree xmlTree = getXmlTreeByFormKey(metaForm.getKey());
		if (ConstantUtil.ED_ROW_HEAD.equalsIgnoreCase(dataTableKey)) {
			int row = dataTable.append();
			dataTable.setString(row, "RowGap",  rowDefCollection.getRowGap()+"");
			dataTable.setString(row, "RowDefHeight", rowDefCollection.getRowHeight() + "");

			dataTable.setString(row, "RowNum", rowDefCollection.size() + "");
			dataTable.setState(RowState.NORMAL);
		} else {
			for (int i = 0; i < rowDefCollection.size(); i++) {
				int row = dataTable.append();
				DefSize RHeight = rowDefCollection.get(i).getHeight();
				if (Objects.isNull(RHeight)) {// 当为空说明为新添加的面板，默认值为type=0，hength=30
					dataTable.setString(row, "Type", "0");
					dataTable.setString(row, "RowDefHeight", "30");
					dataTable.setInt(row, "RowNum", 1);
				} else {
					int sizeType = rowDefCollection.get(i).getHeight().getSizeType();
					int size = rowDefCollection.get(i).getHeight().getSize();
					if (sizeType == -1) {// 新建并未修改布局属性就保存的默认值为type=0，hength=30
						sizeType = 0;
						size = 32;
					}
					dataTable.setString(row, "Type", sizeType + "");
					dataTable.setString(row, "RowDefHeight", size + "");
					dataTable.setInt(row, "RowNum", 1);
				}
				dataTable.setState(RowState.NORMAL);
			}
		}
	}

	private void loadLayoutColumn(DataTable dataTable, MetaGridLayout metaLayout, MetaForm metaForm) throws Throwable {
		MetaColumnDefCollection columnDefCollection = metaLayout.getColumnDefCollection();
		String dataTableKey = dataTable.getKey();

		XmlTree xmlTree = getXmlTreeByFormKey(metaForm.getKey());
		TagNode columnDefColTagNode = xmlTree.getTagNode(metaLayout.getTagName() + "@" + metaLayout.getKey()).getChildByTagName("ColumnDefCollection");
		List<TagNode> columnDefList = columnDefColTagNode.findNodesByTagName("ColumnDef");
		if (ConstantUtil.ED_COLUMN_HEAD.equalsIgnoreCase(dataTableKey)) {
			int row = dataTable.append();

			Map<String, String> attributes = columnDefColTagNode.getAttributes();
			String columnGap = attributes.getOrDefault("ColumnGap", columnDefCollection.getColumnGap() + "");
			dataTable.setString(row, "ColumnGap", columnGap);

			dataTable.setString(row, "ColumnNum", columnDefList.size() + "");
			dataTable.setState(RowState.NORMAL);
		} else {
			for (int i = 0; i < columnDefList.size(); i++) {
				int row = dataTable.append();
				DefSize minWidth = columnDefCollection.get(i).getMinWidth();
				if (minWidth != null) {
					dataTable.setString(row, "MinType", minWidth.getSizeType() + "");
					dataTable.setString(row, "MinWidth", minWidth.getSize() + "");
				}
				dataTable.setString(row, "Type", columnDefCollection.get(i).getWidth().getSizeType() + "");
				dataTable.setString(row, "Width", columnDefCollection.get(i).getWidth().getSize() + "");
				dataTable.setInt(row, "RowNum", 1);
				dataTable.setState(RowState.NORMAL);
			}
		}
	}

	private void loadLayoutRow(DataTable dataTable, MetaGridLayout metaLayout, MetaForm metaForm) throws Throwable {
		MetaRowDefCollection rowDefCollection = metaLayout.getRowDefCollection();
		String dataTableKey = dataTable.getKey();

		XmlTree xmlTree = getXmlTreeByFormKey(metaForm.getKey());
		TagNode rowDefColTagNode = xmlTree.getTagNode(metaLayout.getTagName() + "@" + metaLayout.getKey()).getChildByTagName("RowDefCollection");
		List<TagNode> rowDefList = rowDefColTagNode.findNodesByTagName("RowDef");

		if (ConstantUtil.ED_ROW_HEAD.equalsIgnoreCase(dataTableKey)) {
			int row = dataTable.append();
			Map<String, String> attributes = rowDefColTagNode.getAttributes();
			String rowGap = attributes.getOrDefault("RowGap", rowDefCollection.getRowGap() + "");
			dataTable.setString(row, "RowGap",  rowGap);

			String rowHeight = attributes.getOrDefault("RowHeight", rowDefCollection.getRowHeight() + "");
			dataTable.setString(row, "RowDefHeight", rowHeight);

			dataTable.setString(row, "RowNum", rowDefList.size() + "");
			dataTable.setState(RowState.NORMAL);
		} else {
			for (int i = 0; i < rowDefList.size(); i++) {
				int row = dataTable.append();
				DefSize RHeight = rowDefCollection.get(i).getHeight();
				if (Objects.isNull(RHeight)) {// 当为空说明为新添加的面板，默认值为type=0，hength=30
					dataTable.setString(row, "Type", "0");
					dataTable.setString(row, "RowDefHeight", "30");
					dataTable.setInt(row, "RowNum", 1);
				} else {
					int sizeType = rowDefCollection.get(i).getHeight().getSizeType();
					int size = rowDefCollection.get(i).getHeight().getSize();
					if (sizeType == -1) {// 新建并未修改布局属性就保存的默认值为type=0，hength=30
						sizeType = 0;
						size = 32;
					}
					dataTable.setString(row, "Type", sizeType + "");
					dataTable.setString(row, "RowDefHeight", size + "");
					dataTable.setInt(row, "RowNum", 1);
				}
				dataTable.setState(RowState.NORMAL);
			}
		}
	}

	// 面板布局设置”列“相关属性load
	private void loadLayoutColumn(DataTable dataTable, MetaGridLayoutPanel metaPanel, MetaForm metaForm) throws Throwable {
		MetaColumnDefCollection columnDefCollection = metaPanel.getMetaColumnDefCollection();
		String dataTableKey = dataTable.getKey();

		if (ConstantUtil.ED_COLUMN_HEAD.equalsIgnoreCase(dataTableKey)) {
			int row = dataTable.append();

			dataTable.setString(row, "ColumnGap", columnDefCollection.getColumnGap() + "");

			dataTable.setString(row, "ColumnNum", columnDefCollection.size() + "");
			dataTable.setState(RowState.NORMAL);
		} else {
			for (int i = 0; i < columnDefCollection.size(); i++) {
				int row = dataTable.append();
				DefSize minWidth = columnDefCollection.get(i).getMinWidth();
				if (minWidth != null) {
					dataTable.setString(row, "MinType", minWidth.getSizeType() + "");
					dataTable.setString(row, "MinWidth", minWidth.getSize() + "");
				}
				dataTable.setString(row, "Type", columnDefCollection.get(i).getWidth().getSizeType() + "");
				dataTable.setString(row, "Width", columnDefCollection.get(i).getWidth().getSize() + "");
				dataTable.setInt(row, "RowNum", 1);
				dataTable.setState(RowState.NORMAL);
			}
		}
	}

	// 分隔尺寸load方法
	private void loadSeparate(DataTable dataTable, MetaSplitPanel metaPanel) {
		MetaSplitSizeCollection metaSplitSizeCollection = metaPanel.getSplitSize();
		if (metaSplitSizeCollection != null) {
			if (metaSplitSizeCollection.size() > 0 && metaSplitSizeCollection.get(0).getSize() != null) {
				for (int a = 0; a < metaSplitSizeCollection.size(); a++) {
					int row = dataTable.append();
					dataTable.setString(row, "Size", metaSplitSizeCollection.get(a).getSize().getSize() + "");
					dataTable.setString(row, ConstantUtil.TYPE, metaSplitSizeCollection.get(a).getSize().getSizeType() + "");
					dataTable.setString(row, MetaConstants.SPLITPANEL_FORWARD_COLLAPASED, metaSplitSizeCollection.get(a).getForwardCollapased().toString());
					dataTable.setString(row, MetaConstants.SPLITPANEL_REVERSE_COLLAPASED, metaSplitSizeCollection.get(a).getReverseCollapased().toString());
					dataTable.setString(row, "CollapaseType", MetaSplitSizeCollapaseTypeEnum.getNameByType(metaSplitSizeCollection.get(a).getType()));
					dataTable.setState(RowState.NORMAL);
				}
			}
		}
	}

	/**
	 * create time: 2020/10/28 17:00 Affect 这个方法用于区分镜像字段
	 */
	public static String FindSubDetail(MetaForm metaForm, MetaComponent metaComponent) {
		String parentGridKeyLU = "";
		// 快速查找subdetail和MetaGridLayoutPanel类型的数据
		List<MetaComponent> allComponents = metaForm.getAllComponents().stream()
				.filter(metaSubDetail -> metaSubDetail instanceof MetaSubDetail).collect(Collectors.toList()).stream()
				.filter(metaGridLayoutPanel -> ((MetaSubDetail) metaGridLayoutPanel)
						.getRoot() instanceof MetaGridLayoutPanel)
				.collect(Collectors.toList());
		// 判断当前点击组件是否在subdetail里面
		for (MetaComponent all : allComponents) {
			// 用于判断subdetail中是否有当前字段，有就将Flag改为true，这时就可以使用关联单元格标识
			MetaComponent root = ((MetaSubDetail) all).getRoot();
			MetaComponent component = ((MetaGridLayoutPanel) root).getComponent(metaComponent.getKey());
			if (null != component) {
				// 供外部类使用，作用是区分不同的ParentGridKey去获取关联数据
				parentGridKeyLU = ((MetaSubDetail) all).getBindingGridKey();
			}
		}
		return parentGridKeyLU;
	}

	private void loadColumnExpand(DataTable dataTable, MetaGridColumn metaColumn, MetaGrid metaGrid) {
		int row = dataTable.append();
		MetaColumnExpand columnExpand = metaColumn.getColumnExpand();
		DataTableMetaData dataTableMetaData = dataTable.getMetaData();
		for (int i = 0, len = dataTableMetaData.getColumnCount(); i < len; i++) {
			ColumnInfo columnInfo = dataTableMetaData.getColumnInfo(i);
			String columnKey = columnInfo.getColumnKey();
			if (Property.ExpandType.name.equalsIgnoreCase(columnKey)) {
				if (columnExpand != null) {
					dataTable.setInt(row, i, columnExpand.getExpandType());
				} else {
					dataTable.setInt(row, i, -1);
				}

			} else if (Property.ExpandDependency.name.equalsIgnoreCase(columnKey)) {
				if (columnExpand != null) {
					dataTable.setString(row, i, columnExpand.getExpandDependency());
				} else {
					dataTable.setString(row, i, "");
				}

			} else if (Property.ExpandSourceType.name.equalsIgnoreCase(columnKey)) {
				if (columnExpand != null) {
					dataTable.setInt(row, i, columnExpand.getExpandSourceType());
				} else {
					dataTable.setInt(row, i, 0);
				}

			} else if (Property.ColumnExpand.name.equalsIgnoreCase(columnKey)) {
				if (columnExpand != null) {
					dataTable.setString(row, i, columnExpand.getContent());
				} else {
					dataTable.setString(row, i, "");
				}

			} else if (Property.tableKey.name.equalsIgnoreCase(columnKey)) {
				MetaGridRow detailMetaRow = metaGrid.getDetailMetaRow();
				if (detailMetaRow != null) {
					setGridTableKey(detailMetaRow.getTableKey());
				}
				if (columnExpand != null) {
					dataTable.setString(row, i, columnExpand.getTableKey());
				} else {
					dataTable.setString(row, i, "无数据表");
				}

			} else if (Property.columnKey.name.equalsIgnoreCase(columnKey)) {
				if (columnExpand != null) {
					dataTable.setString(row, i, columnExpand.getColumnKey());
				} else {
					dataTable.setString(row, i, "无字段");
				}

			} else if (Property.itemKey.name.equalsIgnoreCase(columnKey)) {
				if (columnExpand != null) {
					dataTable.setString(row, i, columnExpand.getItemKey());
				}
			}
		}
		dataTable.setState(RowState.NORMAL);
	}

	// 宏公式属性
	private void loadMacroProperty(DataTable dataTable, MetaMacro metaMacro) {
		int row = dataTable.append();
		dataTable.setString(row, ConstantUtil.KEY, metaMacro.getKey());
		dataTable.setString(row, "Formula", metaMacro.getContent());
		dataTable.setState(RowState.NORMAL);
	}

	private void loadPanelTree(DataTable dataTable, String formKey, MetaForm ownerMetaForm, String FormKey) {
		MetaBlock ownerMetaBlock = (MetaBlock) ownerMetaForm.getMetaBody().get(0);
		MetaComponent ownerMetaPanel = ownerMetaBlock.getRoot();
		if (ownerMetaPanel != null) {
			loadThePanel(ownerMetaPanel, formKey, dataTable, FormKey);
		}
	}

	private Object getPropertiesValue(Class<?> instance, String columnKey, Object object) throws Throwable {
		try {
			String lowerCase = columnKey.substring(0, 1).toLowerCase();

			Method init = instance.getMethod(lowerCase+columnKey.substring(1));
			init.setAccessible(true);
			final Object invokeResult = init.invoke(object);
			if (Objects.isNull(invokeResult) && Objects.equals(init.getReturnType(), Boolean.class)) {
				return false;
			}
			return invokeResult;
		} catch (NoSuchMethodException e) {
			try {
				columnKey = StringUtils.uncapitalize(columnKey);
				Field field = instance.getDeclaredField(columnKey);
				field.setAccessible(true);
				return field.get(object);
			} catch (NoSuchFieldException | SecurityException e1) {
				throw e;
			}
		}
	}

	private String getDefaultValue(String columnKey) {
		String attrKey = StringUtils.removeStart(columnKey, "get");
		if (StringUtils.equals(attrKey, columnKey)) {
			attrKey = StringUtils.removeStart(columnKey, "is");
		}
		XmlNodeDefaultValue defaultValue = XmlNodeDefaultValue.getDefaultValue(attrKey);
		if (Objects.nonNull(defaultValue) && StringUtils.isNotBlank(defaultValue.defaultNodeValue)) {
			return defaultValue.defaultNodeValue;
		}
		return null;
	}

	public static String DefSizeToString(Integer sizeType) {
		String s = "";
		switch (sizeType) {
			case DefSize.Pref:
				s = DefSize.STR_Pref;
				break;
			case DefSize.Inherit:
				s = DefSize.STR_Inherit;
				break;
			case DefSize.Fix:
				s = DefSize.STR_Fix;
				break;
			case DefSize.Unit:
				s = DefSize.STR_Unit;
				break;
			case DefSize.Ratio:
				s = DefSize.STR_Ratio;
				break;
			case DefSize.Dp:
				s = DefSize.STR_Dp;
				break;
			case DefSize.Auto:
				s = DefSize.STR_Auto;
				break;
		}
		return s;
	}
	private void loadReport(DefaultContext context, Document doc, MetaDataObject metaDataObject) throws Throwable {
		final String xml = (String) context.getPara("XML");
		org.dom4j.Document document = DocumentHelper.parseText(xml);
		Element root = document.getRootElement();

		MetaTableCollection tableCollection = metaDataObject.getTableCollection();
		for (MetaTable metaTable : tableCollection) {
			DataTable dataTable = DataTableUtil.newEmptyDataTable(metaTable);
			String tableKey = metaTable.getKey();
			if (ConstantUtil.TBL_REPORT_FORMAT.equalsIgnoreCase(tableKey) ||
					"ED_ReportFormatList".equalsIgnoreCase(tableKey) ||
					ConstantUtil.TBL_REPORT_FORMAT_MULTI_LIST.equalsIgnoreCase(tableKey)) { // 数据格式
				int rowIndex = Integer.parseInt(String.valueOf(context.getPara("RowIndex")));
				int columnIndex = Integer.parseInt(String.valueOf(context.getPara("ColumnIndex")));
				Element cell = getCell(rowIndex, columnIndex, root);
				Element format = (Element) cell.selectSingleNode("Display/Format");
				loadReportFormat(format, dataTable);
			} else if (ConstantUtil.TBL_REPORT_TABLE_COLLECTION.equals(tableKey)) { // 数据源
				MetaTable reportFieldsTable = tableCollection.get(ConstantUtil.TBL_REPORT_TABLE_FIELD);
				XmlTree xmlTree = XmlParser.parse(xml);
				loadReportTableCollection(dataTable, context, doc, root, xmlTree, reportFieldsTable);
			} else if (ConstantUtil.TBL_REPORT_TABLE_FIELD.equals(tableKey)) {
				continue;
			} else if (ConstantUtil.TBL_REPORT_COLUMN_HEAD.equals(tableKey)) { // 列属性
				int columnIndex = Integer.parseInt(String.valueOf(context.getPara("ColumnIndex")));
				dealColumnData(root, dataTable, columnIndex);
			} else if (ConstantUtil.TBL_REPORT_CELL_INFO.equals(tableKey)) { // 单元格数据
				int rowIndex = Integer.parseInt(String.valueOf(context.getPara("RowIndex")));
				int columnIndex = Integer.parseInt(String.valueOf(context.getPara("ColumnIndex")));
				Element cell = getCell(rowIndex, columnIndex, root);
				dealCellInfoData(dataTable, cell);
			} else if (ConstantUtil.TBL_REPORT_CELL_DISPLAY.equals(tableKey)) { // 单元格样式
				int rowIndex = Integer.parseInt(String.valueOf(context.getPara("RowIndex")));
				int columnIndex = Integer.parseInt(String.valueOf(context.getPara("ColumnIndex")));
				Element cell = getCell(rowIndex, columnIndex, root);
				dealCellStyle(dataTable, cell);
			} else if (ConstantUtil.TBL_REPORT_SECTION.equals(tableKey)) { // 段属性
				dealSectionData(dataTable, root);
			} else if (ConstantUtil.TBL_REPORT_ROW.equals(tableKey)) { // 行
				int rowIndex = Integer.parseInt(String.valueOf(context.getPara("RowIndex")));
				Element row = (Element) root.selectNodes("Rows/Row").get(rowIndex);
				dealRowData(dataTable, row);
			} else if (ConstantUtil.TBL_REPORT_SETTING.equals(tableKey)) { // 页面设置
				dealReportPageOpt(dataTable, root);
			}
			dataTable.batchUpdate();
			doc.add(tableKey, dataTable);
		}
	}

	private Document loadSetting(DefaultContext context, Document document, MetaTableCollection tableCollection, MetaSetting metaSetting) throws Throwable{
		int row;
		Long oid;
		for (MetaTable metaTable : tableCollection) {
			DataTable dataTable = WebDesignerDataTableUtil.generateDataTable(metaTable);
			String tableKey = metaTable.getKey();
			if ("ED_Setting".equals(tableKey)){
				dataTable.append();
				dataTable.setLong(0, "IsDbCluster", metaSetting.isDbCluster() ? 1L:0);
				MetaSession session = metaSetting.getSession();
				if (Objects.nonNull(session)){
					dataTable.setInt(0, "Timeout", session.getTimeout());
					dataTable.setInt(0, "MobileTimeout", session.getMobileTimeout());
					dataTable.setInt(0, "MaxLoginCount", session.getMaxLoginCount());
					dataTable.setString(0, "AuthenticateProvider", session.getAuthenticateProvider());
					dataTable.setString(0, "GuestAuthenticateProvider", session.getGuestAuthenticateProvider());
					dataTable.setLong(0,"IsEnableLock", session.isEnableLock() ? 1L:0);
					dataTable.setLong(0,"IsSessionParaAsCluster", session.isSessionParaAsCluster() ? 1L:0);
					dataTable.setString(0, "SessionParaKey", session.getSessionParaKey());
					dataTable.setString(0, "SessionParaItemsProvider", session.getSessionParaItemsProvider());
					dataTable.setString(0, "SessionParaProcess", session.getSessionParaProcess());
				}
				MetaEntrySetting entry = metaSetting.getEntry();
				if (Objects.nonNull(entry)){
					dataTable.setString(0, "EntryStyle", ""+ entry.getStyle());
				}
				MetaCluster cluster = metaSetting.getCluster();
				if (Objects.nonNull(cluster)){
					if (cluster.getType() != -1){
						dataTable.setString(0, "ClusterType", ""+ cluster.getType());
					}
					dataTable.setString(0, "ClusterImpl", cluster.getImpl());
					dataTable.setString(0, "RefItemKey", cluster.getRefItemKey());
				}
				MetaLoginSetting login = metaSetting.getLogin();
				if (Objects.nonNull(login)){
					dataTable.setLong(0,"IsSessionPara", login.isSessionPara() ? 1L:0);
					dataTable.setLong(0,"IsMultiLang", login.isMultiLang() ? 1L:0);
					dataTable.setString(0, "LoginProcess", login.getLoginProcess());
					dataTable.setString(0, "LogoutProcess", login.getLogoutProcess());
					dataTable.setString(0, "SSOProvider", login.getSSOProvider());
				}
				MetaFormSetting formSetting = metaSetting.getFormSetting();
				if (Objects.nonNull(formSetting)){
					dataTable.setLong(0,"IsInitFocus", formSetting.initFocus() ? 1L:0);
					dataTable.setString(0,"RightsProvider", formSetting.getRightsProvider());
					dataTable.setString(0,"DimValueProvider", formSetting.getDimValueProvider());
				}
				MetaMigrationSetting migrationSetting = metaSetting.getMigrationSetting();
				if (Objects.nonNull(migrationSetting)){
					dataTable.setLong(0,"IsUseOptimization", migrationSetting.isUseOptimization() ? 1L:0);
				}
				MetaBPMSetting bpmSetting = metaSetting.getBPMSetting();
				if (Objects.nonNull(bpmSetting)){
					dataTable.setLong(0,"IsQueryRetreatWorkItem", bpmSetting.getQueryRetreatWorkitem() ? 1L:0);
					dataTable.setLong(0,"IsQueryActiveWorkItem", bpmSetting.getQueryActiveWorkitem() ? 1L:0);
					dataTable.setLong(0,"IsQueryActiveStateWorkItem", bpmSetting.getQueryActiveStateWorkitem() ? 1L:0);
					dataTable.setLong(0,"IsRecordFormRights", bpmSetting.getRecordFormRights() ? 1L:0);
					dataTable.setLong(0,"IsIgnoreFormState", bpmSetting.getIgnoreFormState() ? 1L:0);
					dataTable.setLong(0,"IsQueryTransitTo", bpmSetting.getQueryTransitTo() ? 1L:0);
					dataTable.setLong(0,"IsCreateLog4EndNode", bpmSetting.getCreateLog4EndNode() ? 1L:0);
					dataTable.setLong(0,"IsCreateLog4BeginNode", bpmSetting.getCreateLog4BeginNode() ? 1L:0);
					dataTable.setLong(0,"IsRecalculateActiveWorkItem", bpmSetting.isRecalculateActiveWorkitem() ? 1L:0);
					dataTable.setString(0, "DefaultBatchStateAction", bpmSetting.getDefaultBatchStateAction().getContent());
					dataTable.setString(0, "DefaultStateAction", bpmSetting.getDefaultStateAction().getContent());
					dataTable.setString(0, "DefaultAuditAction", bpmSetting.getDefaultAuditAction().getContent());
					dataTable.setString(0, "DefaultTaskAction", bpmSetting.getDefaultTaskAction().getContent());
					dataTable.setString(0, "DefaultCountersignAction", bpmSetting.getDefaultCountersignAction().getContent());
					dataTable.setString(0, "BPMNodeAction", bpmSetting.getBPMNodeAction());
					dataTable.setString(0, "WorkFlowHookPath", bpmSetting.getWorkFlowHookPath());
					dataTable.setString(0, "BPMGraphInfoPath", bpmSetting.getBPMGraphInfoPath());
					dataTable.setString(0, "BPMRightsProvider", bpmSetting.getRightsProvider());
					dataTable.setString(0, "RetreatCaption", bpmSetting.getRetreatCaption());
					dataTable.setString(0, "TemplateKey", bpmSetting.getTemplateKey());
					dataTable.setString(0, "DelegateCheck", bpmSetting.getDelegateCheck());
				}
				MetaAttachmentService attachmentService = metaSetting.getAttachmentService();
				if (Objects.nonNull(attachmentService)){
					dataTable.setString(0, "AttachmentDefaultProvider", attachmentService.getDefaultProvider());
				}
				MetaDTS dts = metaSetting.getDts();
				if (Objects.nonNull(dts)){
					dataTable.setString(0, "DTSDefaultProvider", dts.getDefaultProvider());
				}
				dataTable.setState(RowState.NORMAL);
			}else if ("ED_AttachmentService".equals(tableKey)){
				MetaAttachmentService attachmentService = metaSetting.getAttachmentService();
				if (Objects.nonNull(attachmentService)){
					for (MetaAttachmentProvider provider : attachmentService) {
						row = dataTable.append();
						dataTable.setString(row, "AttachmentProviderKey", provider.getKey());
						dataTable.setString(row, "AttProviderDriver", provider.getDriver());
						dataTable.setString(row, "AttExternalConfig", provider.getExternalConfig());
						dataTable.setState(RowState.NORMAL);
					}
				}
			}else if ("ED_DTS".equals(tableKey)){
				MetaDTS dts = metaSetting.getDts();
				if (Objects.nonNull(dts)){
					for (MetaDTSProvider provider : dts) {
						row = dataTable.append();
						dataTable.setString(row, "DTSKey", provider.getKey());
						dataTable.setString(row, "DTSDriver", provider.getDriver());
						dataTable.setString(row, "DTSExternalConfig", provider.getExternalConfig());
						dataTable.setState(RowState.NORMAL);
					}
				}
			}else if ("ED_IOService".equals(tableKey)){
				MetaTable hbeaParasMetaTable = tableCollection.get("ED_hbea_paras");
				DataTable hbeaParasDataTable = WebDesignerDataTableUtil.generateDataTable(hbeaParasMetaTable);
				if (metaSetting.getIOService() != null){
					for (MetaIOProvider metaIOProvider : metaSetting.getIOService()) {
						row = dataTable.append();
						oid = context.applyNewOID();
						dataTable.setLong(row, ConstantUtil.OID, oid);
						dataTable.setString(row, "IOServiceKey", metaIOProvider.getKey());
						dataTable.setString(row, "IOServiceDriver", metaIOProvider.getDriver());
						dataTable.setState(RowState.NORMAL);
						MetaParas paras = metaIOProvider.getParas();
						if (Objects.isNull(paras)){
							continue;
						}
						for (MetaPara para : paras) {
							row = hbeaParasDataTable.append();
							hbeaParasDataTable.setLong(row, ConstantUtil.POID, oid);
							hbeaParasDataTable.setString(row, "ParaKey", para.getKey());
							hbeaParasDataTable.setString(row, "ParaValue", para.getValue());
							hbeaParasDataTable.setState(RowState.NORMAL);
						}
					}
				}
				document.add("ED_hbea_paras", hbeaParasDataTable);
			}else if ("ED_hbea_paras".equals(tableKey)){
				continue;
			}else if ("ED_RightsProxy".equals(tableKey)){
				MetaRightsProxyCollection rightsProxyCollection = metaSetting.getRightsProxyCollection();
				if (Objects.nonNull(rightsProxyCollection)){
					for (MetaRightsProxy rightsProxy : rightsProxyCollection) {
						row = dataTable.append();
						dataTable.setString(row, "RightsProxyKey", rightsProxy.getKey());
						dataTable.setString(row, "RightsProxyDriver", rightsProxy.getDriver());
						dataTable.setState(RowState.NORMAL);
					}
				}
			}else if ("ED_SessionPara".equals(tableKey)){
				MetaSession session = metaSetting.getSession();
				if (Objects.nonNull(session)){
					for (MetaSessionPara metaSessionPara : session) {
						row = dataTable.append();
						dataTable.setString(row, "SessionParaKey", metaSessionPara.getParaKey());
						dataTable.setString(row, "SessionParaItemsProvider", metaSessionPara.getProvider());
						dataTable.setLong(row, "IsAsCluster", metaSessionPara.isAsCluster() ? 1L:0);
						dataTable.setState(RowState.NORMAL);
					}
				}
			}else if ("ED_TagName".equals(tableKey)){
				Set<Map.Entry<String, MetaSimpleSetting>> entries = metaSetting.getSimpleSettings().entrySet();
				MetaTable tagParaMetaTable = tableCollection.get("ED_TagPara");
				DataTable tagParaDataTable = WebDesignerDataTableUtil.generateDataTable(tagParaMetaTable);
				for (Map.Entry<String, MetaSimpleSetting> entry : entries) {
					row = dataTable.append();
					oid = context.applyNewOID();
					dataTable.setLong(row, ConstantUtil.OID, oid);
					dataTable.setString(row, "TagName", entry.getKey());
					dataTable.setState(RowState.NORMAL);
					if (Objects.isNull(entry.getValue()) || Objects.isNull(entry.getValue().getProperties())){
						continue;
					}
					for (Map.Entry<String, String> para : entry.getValue().getProperties().entrySet()) {
						row = tagParaDataTable.append();
						tagParaDataTable.setLong(row, ConstantUtil.POID, oid);
						tagParaDataTable.setString(row, "TagParaKey", para.getKey());
						tagParaDataTable.setString(row, "TagParaValue", para.getValue());
						tagParaDataTable.setState(RowState.NORMAL);
					}
				}
				document.add("ED_TagPara", tagParaDataTable);
			}else if ("ED_TagPara".equals(tableKey)){
				continue;
			}else if ("ED_BPMMGrid".equals(tableKey)){
				if (metaSetting.getBPMSetting() != null && metaSetting.getBPMSetting().getBPMMTable().size() > 0){
					MetaBPMMTable bpmmTable = metaSetting.getBPMSetting().getBPMMTable();
					for (MetaBPMMColumn metaBPMMColumn : bpmmTable) {
						row = dataTable.append();
						dataTable.setState(RowState.NORMAL);
						dataTable.setString(row, "ColumnKey", metaBPMMColumn.getKey());
						dataTable.setString(row, "ColumnCaption", metaBPMMColumn.getCaption());
						dataTable.setString(row, "DataType", DataType.toString(metaBPMMColumn.getDataType()));
						dataTable.setString(row, "DbColumnName", metaBPMMColumn.getDBColumnName());
						dataTable.setString(row, "DefaultValue", metaBPMMColumn.getDefaultValue());
						dataTable.setInt(row, "Length", metaBPMMColumn.getLength());
						dataTable.setInt(row, "ColumnPrecision", metaBPMMColumn.getPrecision());
						dataTable.setInt(row, "ColumnScale", metaBPMMColumn.getScale());
					}
				}
			}
			document.add(tableKey, dataTable);
		}
		return document;
	}

	private Document loadNoRights(Document document, MetaTableCollection tableCollection, MetaRightsDefinition metaRightsDefinition){
		int row;
		for (MetaTable metaTable : tableCollection) {
			DataTable dataTable = WebDesignerDataTableUtil.generateDataTable(metaTable);
			String tableKey = metaTable.getKey();
			if ("ED_FormRights".equals(tableKey)){
				MetaFormRightsCollection formRightsCollection = metaRightsDefinition.getFormRightsCollection();
				if (Objects.isNull(formRightsCollection)){
					document.add(tableKey, dataTable);
					continue;
				}
				for (MetaFormDefinition metaFormDefinition : formRightsCollection) {
					row = dataTable.append();
					String formKey = metaFormDefinition.getFormKey();
					dataTable.setString(row, "FormKey", formKey);
					dataTable.setState(RowState.NORMAL);
				}
			}else if ("ED_DictRights".equals(tableKey)){
				MetaDictRightsCollection dictRightsCollection = metaRightsDefinition.getDictRightsCollection();
				if (Objects.isNull(dictRightsCollection)){
					document.add(tableKey, dataTable);
					continue;
				}
				for (MetaDictDefinition metaDictDefinition : dictRightsCollection) {
					row = dataTable.append();
					String dictKey = metaDictDefinition.getItemKey();
					dataTable.setString(row, "DictKey", dictKey);
					dataTable.setState(RowState.NORMAL);
				}
			}
			document.add(tableKey, dataTable);
		}
		return document;
	}

	private Document loadEnhance(Document document, MetaTableCollection tableCollection, MetaEnhance solutionEnhance){
		for (MetaTable metaTable : tableCollection) {
			DataTable dataTable = WebDesignerDataTableUtil.generateDataTable(metaTable);
			String tableKey = metaTable.getKey();
			if ("ED_EnhanceService".equals(tableKey)){
				MetaExtService metaExtService = solutionEnhance.getMetaExtService();
				for (MetaService service : metaExtService) {
					setEnhanceServiceDataTable(dataTable, service.getName(), service.getImpl(), service.getDescription(), MetaExtService.TAG_NAME);
				}
				MetaExtSysService metaExtSysSvr = solutionEnhance.getMetaExtSysSvr();
				for (MetaService service : metaExtSysSvr) {
					setEnhanceServiceDataTable(dataTable, service.getName(), service.getImpl(), service.getDescription(), MetaExtSysService.TAG_NAME);
				}
				MetaExtImportService extImportService = solutionEnhance.getExtImportService();
				for (MetaImportService service : extImportService) {
					setEnhanceServiceDataTable(dataTable, service.getName(), service.getImpl(), service.getDescription(), MetaExtImportService.TAG_NAME);
				}
				MetaExtExportService extExportService = solutionEnhance.getExtExportService();
				for (MetaExportService service : extExportService) {
					setEnhanceServiceDataTable(dataTable, service.getName(), service.getImpl(), service.getDescription(), MetaExtExportService.TAG_NAME);
				}
				MetaExtPostExportService postExportServices = solutionEnhance.getPostExportService();
				for (MetaPostExportService service : postExportServices) {
					setEnhanceServiceDataTable(dataTable, service.getName(), service.getImpl(), service.getDescription(), MetaExtPostExportService.TAG_NAME);
				}
				MetaExtDataProcess metaExtDataProcess = solutionEnhance.getMetaExtDataProcess();
				for (MetaDataProcess process : metaExtDataProcess) {
					setEnhanceServiceDataTable(dataTable, process.getName(), process.getImpl(), process.getDescription(), MetaExtDataProcess.TAG_NAME);
				}
				MetaExtAttachmentProcess extAttachmentProcess = solutionEnhance.getExtAttachmentProcess();
				for (MetaAttachmentProcess process : extAttachmentProcess) {
					setEnhanceServiceDataTable(dataTable, process.getName(), process.getImpl(), process.getDescription(), MetaExtAttachmentProcess.TAG_NAME);
				}
				MetaExtDocumentService documentService = solutionEnhance.getExtDocumentService();
				for (MetaDocumentService service : documentService) {
					setEnhanceServiceDataTable(dataTable, service.getName(), service.getImpl(), "", MetaExtDocumentService.TAG_NAME);
				}
			}else if ("ED_EnhanceFunction".equals(tableKey)){
				MetaExtReportFunction extReportFunction = solutionEnhance.getExtReportFunction();
				for (MetaFunction function : extReportFunction) {
					setEnhanceFunctionDataTable(dataTable, function.getDescription(), function.getProvider(), MetaExtReportFunction.TAG_NAME);
				}
				MetaExtUIFunction metaExtUIFunction = solutionEnhance.getMetaExtUIFunction();
				for (MetaUIFunction function : metaExtUIFunction) {
					setEnhanceFunctionDataTable(dataTable, function.getDescription(), function.getProvider(), MetaExtUIFunction.TAG_NAME);
				}
				MetaExtMidFunction metaMidFunctions = solutionEnhance.getMetaExtMidFunction();
				for (MetaMidFunction function : metaMidFunctions) {
					setEnhanceFunctionDataTable(dataTable, function.getDescription(), function.getProvider(), MetaExtMidFunction.TAG_NAME);
				}
				MetaExtStartListener startListener = solutionEnhance.getStartListener();
				for (MetaStartListener listener : startListener) {
					setEnhanceFunctionDataTable(dataTable, listener.getDescription(), listener.getImpl(), MetaExtStartListener.TAG_NAME);
				}
				MetaExtUpdateListener updateListener = solutionEnhance.getUpdateListener();
				for (MetaUpdateListener listener : updateListener) {
					setEnhanceFunctionDataTable(dataTable, listener.getDescription(), listener.getImpl(), MetaExtUpdateListener.TAG_NAME);
				}
			}
			document.add(tableKey, dataTable);
		}
		return document;
	}

	private void setEnhanceServiceDataTable(DataTable dataTable, String name, String impl, String desc, String type){
		int row = dataTable.append();
		dataTable.setString(row, "Name", name);
		dataTable.setString(row, "ServiceImpl", impl);
		dataTable.setString(row, "Description", desc);
		dataTable.setString(row, "ServiceType", type);
		dataTable.setState(RowState.NORMAL);
	}
	private void setEnhanceFunctionDataTable(DataTable dataTable, String desc, String provider, String type){
		int row = dataTable.append();
		dataTable.setString(row, "FunctionDescription", desc);
		dataTable.setString(row, "FunctionProvider", provider);
		dataTable.setString(row, "FunctionType", type);
		dataTable.setState(RowState.NORMAL);
	}

	private Document loadIOSetting(Document document, MetaTableCollection tableCollection, MetaIOSetting IOSetting){
		for (MetaTable metaTable : tableCollection) {
			DataTable dataTable = WebDesignerDataTableUtil.generateDataTable(metaTable);
			String tableKey = metaTable.getKey();
			MetaPersist persist = IOSetting.getPersist();
			if (persist == null){
				document.add(tableKey, dataTable);
				continue;
			}
			if ("ED_IOSettingHead".equals(tableKey)){
				dataTable.append();
				String defaultProvider = Optional.ofNullable(persist.getDefaultProvider()).orElse("");
				dataTable.setString(0, "DefaultProvider", defaultProvider);
				dataTable.setState(RowState.NORMAL);
			}else if ("ED_IOSettingDetail".equals(tableKey)){
				int row;
				String IOProvider;
				String providerKey;
				for (MetaIOObject metaIOObject : persist) {
					row = dataTable.append();
					IOProvider = metaIOObject.getProviderKey();
					providerKey = metaIOObject.getKey();
					dataTable.setString(row, "IOProvider", IOProvider);
					dataTable.setString(row, "ProviderKey", providerKey);
					dataTable.setState(RowState.NORMAL);
				}
			}
			document.add(tableKey, dataTable);
		}
		return document;
	}


	private Document loadSolutionProfile(Document document, MetaTableCollection tableCollection, MetaSolution metaSolution){
		for (MetaTable metaTable : tableCollection) {
			DataTable dataTable = WebDesignerDataTableUtil.generateDataTable(metaTable);
			String tableKey = metaTable.getKey();
			int row;
			if ("ED_SolutionHead".equals(tableKey)){
				dataTable.append();
				dataTable.setString(0, "AppKey", Optional.ofNullable(metaSolution.getKey()).orElse(""));
				dataTable.setString(0, "Caption", Optional.ofNullable(metaSolution.getCaption()).orElse(""));
				dataTable.setString(0, "DataPath", Optional.ofNullable(metaSolution.getDataPath()).orElse(""));
				dataTable.setString(0, "StartForm", Optional.ofNullable(metaSolution.getStartForm()).orElse(""));
				dataTable.setInt(0, "SecurityLevel", metaSolution.getSecurityLevel());
				dataTable.setInt(0, "IsEnableMultiLang", metaSolution.isEnableMultiLang() ? 1:0);
				dataTable.setString(0, "DefaultLang", Optional.ofNullable(metaSolution.getDefaultLang()).orElse(""));
				dataTable.setString(0, "TestLang", Optional.ofNullable(metaSolution.getTestLang()).orElse(""));
				dataTable.setString(0, "DesignEditorFactory", Optional.ofNullable(metaSolution.getDesignEditorFactory()).orElse(""));
				dataTable.setInt(0, "IsEnableDiff", metaSolution.isEnableDiff() ? 1:0);
				dataTable.setState(RowState.NORMAL);
			}else if ("ED_Project".equals(tableKey)){
				MetaProjectCollection projectCollection = metaSolution.getProjectCollection();
				for (MetaProjectProfile projectProfile : projectCollection) {
					row = dataTable.append();
					dataTable.setString(row, "ProjectKey", Optional.ofNullable(projectProfile.getKey()).orElse(""));
					dataTable.setString(row, "ProjectCaption", Optional.ofNullable(projectProfile.getCaption()).orElse(""));
					dataTable.setString(row, "RefPath", Optional.ofNullable(projectProfile.getRefPath()).orElse(""));
					dataTable.setState(RowState.NORMAL);
				}
			}else if ("ED_InplaceToolbar".equals(tableKey)){
				MetaInplaceToolbarCollection toolBarCollection = Optional.ofNullable(metaSolution.getInplaceToolBarCollection()).orElse(new MetaInplaceToolbarCollection());
				for (MetaInplaceToolbar metaInplaceToolbar : toolBarCollection) {
					row = dataTable.append();
					dataTable.setString(row, "Tag", Optional.ofNullable(metaInplaceToolbar.getTag()).orElse(""));
					dataTable.setString(row, "Handler", Optional.ofNullable(metaInplaceToolbar.getHandler()).orElse(""));
					dataTable.setString(row, "Description", Optional.ofNullable(metaInplaceToolbar.getDescription()).orElse(""));
					dataTable.setState(RowState.NORMAL);
				}
			}else if ("ED_StartItem".equals(tableKey)){
				MetaStartItemCollection startItemCollection = Optional.ofNullable(metaSolution.getStartItemCollection()).orElse(new MetaStartItemCollection());
				for (MetaStartItem metaStartItem : startItemCollection) {
					row = dataTable.append();
					dataTable.setString(row, "PlatformKey", Optional.ofNullable(metaStartItem.getPlatform()).orElse(""));
					dataTable.setString(row, "StartFormKey", Optional.ofNullable(metaStartItem.getStartForm()).orElse(""));
					dataTable.setString(row, "LoginFormKey", Optional.ofNullable(metaStartItem.getLoginForm()).orElse(""));
					dataTable.setString(row, "ApplicationKey", Optional.ofNullable(metaStartItem.getAppKey()).orElse(""));
					dataTable.setState(RowState.NORMAL);
				}
			}else if ("ED_PreLoadItem".equals(tableKey)){
				MetaPreLoadItemCollection preLoadItemCollection = Optional.ofNullable(metaSolution.getPreLoadItemCollection()).orElse(new MetaPreLoadItemCollection());
				for (MetaPreLoadItem metaPreLoadItem : preLoadItemCollection) {
					row = dataTable.append();
					dataTable.setString(row, "EntryPath", Optional.ofNullable(metaPreLoadItem.getEntryPath()).orElse(""));
					dataTable.setString(row, "PreLoadItemKey", Optional.ofNullable(metaPreLoadItem.getKey()).orElse(""));
					dataTable.setString(row, "Condition", Optional.ofNullable(metaPreLoadItem.getCondition()).orElse(""));
					dataTable.setInt(row, "IsClose", metaPreLoadItem.isClose() ? 1:0);
					dataTable.setString(row, "Target", FormTarget.toString(Optional.ofNullable(metaPreLoadItem.getTarget()).orElse(FormTarget.NEWTAB)));
					dataTable.setState(RowState.NORMAL);
				}
			}else if ("ED_LangConfig".equals(tableKey)){
				MetaLangConfig langConfig = Optional.ofNullable(metaSolution.getLangConfig()).orElse(new MetaLangConfig());
				for (MetaLang metaLang : langConfig) {
					row = dataTable.append();
					dataTable.setString(row, "LangKey", Optional.ofNullable(metaLang.getKey()).orElse(""));
					dataTable.setString(row, "LangDescription", Optional.ofNullable(metaLang.getDescription()).orElse(""));
					dataTable.setString(row, "WidthMultiple",  Optional.ofNullable(metaLang.getWidthMultiple()).orElse(""));
					dataTable.setString(row, "LangSuffix", Optional.ofNullable(metaLang.getSuffix()).orElse(""));
					dataTable.setState(RowState.NORMAL);
				}
			}
			document.add(tableKey, dataTable);
		}
		return document;
	}


	private void loadDataElementDef(Document doc, String erpXmlFilePath, DataTable designDataTable, DefaultContext context) throws Throwable {
		XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(FilePathHelper.toBackFilePath(erpXmlFilePath));
		TagNode node = xmlTreeWithPath.xmlTree.getRoot().getOrCreateChildByTagName("DataElementCollection");
		List<AbstractNode> macroCollection = node.getChildren();
		DataTable curDataTable = WebDesignerDataTableUtil.generateDataTable(getMetaTable());
		for (AbstractNode tagNode : macroCollection) {
			if (tagNode instanceof TagNode && "DataElement".equalsIgnoreCase(((TagNode) tagNode).getTagName())) {
				String key = ((TagNode) tagNode).getAttributes().get(ConstantUtil.KEY);
				String caption = ((TagNode) tagNode).getAttributes().get("Caption");
				String domainKey = ((TagNode) tagNode).getAttributes().get("DomainKey");
				Object dataType = ((TagNode) tagNode).getAttributes().get("DataType");
				Object precision = ((TagNode) tagNode).getAttributes().get("Precision");
				Object scale = ((TagNode) tagNode).getAttributes().get("Scale");
				Object length = ((TagNode) tagNode).getAttributes().get("Length");
				String paramID = ((TagNode) tagNode).getAttributes().get("ParamID");
				String defaultCaption = ((TagNode) tagNode).getAttributes().get("DefaultCaption");
				String dataDiffLog = ((TagNode) tagNode).getAttributes().get("DataDiffLog");
				String noHistory = ((TagNode) tagNode).getAttributes().get("NoHistory");
				int row = designDataTable.append();
				designDataTable.setString(row, "Key", key);
				Long newOID = context.applyNewOID();
				designDataTable.setLong(row, SystemField.OID_SYS_KEY, newOID);
				designDataTable.setString(row, "Caption", caption);
				designDataTable.setString(row, "DomainKey", domainKey);
				IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
				if (StringUtils.isNotBlank(domainKey)) {
					MetaDomain domain = MetaUtil.getDomain(globalInstance, domainKey);
					precision = domain.getPrecision();
					dataType = domain.getDataType();
					scale = domain.getScale();
					length = domain.getLength();
				}else{
					dataType = DataType.parse(String.valueOf(dataType));
				}
				designDataTable.setObject(row, "DataType", DataType.toString((Integer) dataType));
				designDataTable.setObject(row, "Precision", precision);
				designDataTable.setObject(row, "Scale", scale);
				designDataTable.setObject(row, "Length", length);
				designDataTable.setString(row, "ParamID", paramID);
				designDataTable.setString(row, "DefaultCaption", defaultCaption);
				boolean isReferenced = IndexFacade.isReferenced(KeyIndexEnum.DATA_ELEMENT, key);
				designDataTable.setObject(row, "CanDelete", !isReferenced);
				if (StringUtils.isNotBlank(dataDiffLog)) {
					designDataTable.setString(row, "DataDiffLog", dataDiffLog);
				} else {
					designDataTable.setString(row, "DataDiffLog", "false");
				}
				if (StringUtils.isNotBlank(noHistory)) {
					designDataTable.setString(row, "NoHistory", noHistory);
				} else {
					designDataTable.setString(row, "NoHistory", "false");
				}
				designDataTable.setState(RowState.NORMAL);
				TagNode orCreateChildByTagName = ((TagNode) tagNode).getOrCreateChildByTagName(MetaFieldLabelCollection.TAG_NAME);
				List<AbstractNode> children = orCreateChildByTagName.getChildrenByTagName(MetaFieldLabel.TAG_NAME);
				for (AbstractNode child : children) {
					if (child instanceof TagNode && "FieldLabel".equalsIgnoreCase(((TagNode) child).getTagName())) {
						int append = curDataTable.append();
						curDataTable.setLong(append, SystemField.POID_SYS_KEY, newOID);
						String key1 = ((TagNode) child).getAttributes().get(ConstantUtil.KEY);
						String length1 = ((TagNode) child).getAttributes().get("Length");
						String text = ((TagNode) child).getAttributes().get("Text");
						curDataTable.setString(append, "Key", key1);
						if (StringUtils.isNotBlank(length1)) {
							curDataTable.setString(append, "Length", length1);
						} else {
							curDataTable.setString(append, "Length", "0");
						}
						curDataTable.setString(append, "Text", text);
						curDataTable.setState(RowState.NORMAL);
					}

				}
			}
		}
		curDataTable.batchUpdate();
		doc.add(curDataTable.getKey(), curDataTable);
	}

	private void loadDomainDef(Document doc,String erpXmlFilePath, DataTable designDataTable,
							   DefaultContext context) throws Throwable {
		XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(FilePathHelper.toBackFilePath(erpXmlFilePath));
		TagNode node = xmlTreeWithPath.xmlTree.getRoot().getOrCreateChildByTagName("DomainCollection");
		DataTable curDataTable = WebDesignerDataTableUtil.generateDataTable(getMetaTable());
		List<AbstractNode> macroCollection = node.getChildren();
		for (AbstractNode tagNode : macroCollection) {
			if (tagNode instanceof TagNode && "Domain".equalsIgnoreCase(((TagNode) tagNode).getTagName())) {
				String key = ((TagNode) tagNode).getAttributes().get(ConstantUtil.KEY);
				String caption = ((TagNode) tagNode).getAttributes().get("Caption");
				String controlType = ((TagNode) tagNode).getAttributes().get("RefControlType");
				String dataType = ((TagNode) tagNode).getAttributes().get("DataType");
				String precision = ((TagNode) tagNode).getAttributes().get("Precision");
				String scale = ((TagNode) tagNode).getAttributes().get("Scale");
				String length = ((TagNode) tagNode).getAttributes().get("Length");
				String useGroupingSeparator = ((TagNode) tagNode).getAttributes().get("UseGroupingSeparator");
				String Case = ((TagNode) tagNode).getAttributes().get("Case");
				String sourceType = ((TagNode) tagNode).getAttributes().get("SourceType");
				String groupKey = ((TagNode) tagNode).getAttributes().get("GroupKey");
				String itemKey = ((TagNode) tagNode).getAttributes().get("ItemKey");
				String allowMultiSelection = ((TagNode) tagNode).getAttributes().get("AllowMultiSelection");
				int row = designDataTable.append();
				boolean isReferenced = IndexFacade.isReferenced(KeyIndexEnum.DOMAIN, key);
				designDataTable.setObject(row, "CanDelete", !isReferenced);
				designDataTable.setString(row, "Key", key);
				Long newOID = context.applyNewOID();
				designDataTable.setLong(row, SystemField.OID_SYS_KEY, newOID);
				designDataTable.setString(row, "Caption", caption);
				designDataTable.setString(row, "ControlType", controlType);
				designDataTable.setString(row, "DataType", dataType);
				if (StringUtils.isNotBlank(precision)) {
					designDataTable.setString(row, "Precision", precision);
				} else {
					designDataTable.setString(row, "Precision", "0");
				}
				if (StringUtils.isNotBlank(scale)) {
					designDataTable.setString(row, "Scale", scale);
				} else {
					designDataTable.setString(row, "Scale", "0");
				}
				if (StringUtils.isNotBlank(length)) {
					designDataTable.setString(row, "Length", length);
				} else {
					designDataTable.setString(row, "Length", "0");
				}
				designDataTable.setString(row, "UseGroupingSeparator", useGroupingSeparator);
				if (StringUtils.isNotBlank(Case)) {
					designDataTable.setString(row, "Case", Case);
				} else {
					designDataTable.setString(row, "Case", "0");
				}
				if (StringUtils.isNotBlank(sourceType)) {
					designDataTable.setString(row, "SourceType", sourceType);
				} else {
					designDataTable.setString(row, "SourceType", "");
				}
				designDataTable.setString(row, "GroupKey", groupKey);
				designDataTable.setString(row, "ItemKey", itemKey);
				designDataTable.setString(row, "AllowMultiSelection", allowMultiSelection);
				designDataTable.setState(RowState.NORMAL);

				if(controlType.equalsIgnoreCase("DynamicDict")){
					TagNode first = ((TagNode) tagNode).getFirst(MetaItemKeyCollection.TAG_NAME);
					TagNode formulaItems = ((TagNode) tagNode).getFirst("FormulaItems");
					if (formulaItems!=null){
						designDataTable.setString(row, "GetFormulaItemKeys", formulaItems.getCDataValue());
					}
					if (first !=null){
						List<AbstractNode> children = first.getChildrenByTagName(MetaDefaultItem.TAG_NAME);
						for (AbstractNode child : children) {
							if(child instanceof TagNode && MetaDefaultItem.TAG_NAME.equalsIgnoreCase(((TagNode) child).getTagName())){
								int append = curDataTable.append();
								curDataTable.setLong(append, SystemField.POID_SYS_KEY, newOID);
								String key1 = ((TagNode) child).getAttributes().get(ConstantUtil.KEY);
								String caption1 = ((TagNode) child).getAttributes().get(ConstantUtil.CAPTION);
								String value = ((TagNode) child).getAttributes().get(ConstantUtil.VALUE);
								curDataTable.setString(append, "Key", key1);
								curDataTable.setString(append, "Caption", caption1);
								curDataTable.setString(append, "Value", value);
								curDataTable.setState(RowState.NORMAL);
							}
						}
					}

				}else {
					List<AbstractNode> children = ((TagNode) tagNode).getChildrenByTagName(MetaDefaultItem.TAG_NAME);
					for (AbstractNode child : children) {
						if(child instanceof TagNode && MetaDefaultItem.TAG_NAME.equalsIgnoreCase(((TagNode) child).getTagName())){
							int append = curDataTable.append();
							curDataTable.setLong(append, SystemField.POID_SYS_KEY, newOID);
							String key1 = ((TagNode) child).getAttributes().get(ConstantUtil.KEY);
							String caption1 = ((TagNode) child).getAttributes().get(ConstantUtil.CAPTION);
							String value = ((TagNode) child).getAttributes().get(ConstantUtil.VALUE);
							String icon = ((TagNode) child).getAttributes().get("Icon");
							curDataTable.setString(append, "Key", key1);
							curDataTable.setString(append, "Caption", caption1);
							curDataTable.setString(append, "Value", value);
							curDataTable.setString(append, "Icon", icon);
							curDataTable.setState(RowState.NORMAL);
						}
					}
				}


			}
		}
		curDataTable.batchUpdate();
		doc.add(curDataTable.getKey(), curDataTable);
	}

	private void loadExcel(Document doc, DefaultContext context, MetaDataObject metaDataObject) throws Throwable {
		String formKey = (String) context.getPara("FormKey");
		MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(formKey);
		IDLookup idLookup = IDLookup.reloadIDLookup(metaForm);
		String xml = (String) context.getPara("XML");
		Element root = null;
		if (StringUtils.isNotBlank(xml)) {
			org.dom4j.Document document = DocumentHelper.parseText(xml);
			root = document.getRootElement();
		}

		MetaTableCollection tableCollection = metaDataObject.getTableCollection();
		for (MetaTable metaTable : tableCollection) {
			DataTable dataTable = DataTableUtil.newEmptyDataTable(metaTable);
			String tableKey = metaTable.getKey();
			if (ConstantUtil.TBL_Detail_Column.equalsIgnoreCase(tableKey)) {
				String contextTableKey = (String) context.getPara("TableKey");
				loadBindingColumns(dataTable, metaForm, contextTableKey, idLookup);
			} else if (ConstantUtil.TBL_EXCEL_PROP.equalsIgnoreCase(tableKey)) {
				dealExcelProp(dataTable, root); // root 就是Workbook
			} else if (ConstantUtil.TBL_EXCEL_CELL_FORMAT.equalsIgnoreCase(tableKey) ||
					ConstantUtil.TBL_EXCEL_FORMAT_LIST.equalsIgnoreCase(tableKey) ||
					ConstantUtil.TBL_EXCEL_FORMAT_MULTI_LIST.equalsIgnoreCase(tableKey)) { // Excel单元格属性
				dealExcelCellFormat(dataTable, root, context);
			} else if (ConstantUtil.TBL_EXCEL_CELL_SIZE.equalsIgnoreCase(tableKey)) {
				dealExcelSize(dataTable, root, context);
			} else if (ConstantUtil.TBL_EXCEL_COLUMN_EXPAND.equalsIgnoreCase(tableKey)) {
				dealExcelColumnExpand(dataTable, root, context);
			}
			dataTable.batchUpdate();
			doc.add(tableKey, dataTable);
		}
	}

	private void loadDataMigration(DefaultContext context, Document doc, MetaDataObject metaDataObject) throws Throwable {
		String isFirst = (String) context.getPara("IsFirst");
		boolean first = Boolean.parseBoolean(isFirst);
		if (first) {
			String tableName = (String) context.getPara("TableName");
			MetaDataObject dataObject = MetaFactory.getGlobalInstance().getDataObject(tableName);
			if (dataObject != null) {
				MetaTableCollection tables = dataObject.getTableCollection();
				MetaTableCollection tableCollection = metaDataObject.getTableCollection();
				DataTable dataTable = DataTableUtil.newEmptyDataTable(tableCollection.first());

				String xml = (String) context.getPara("XML");
				org.dom4j.Document document = DocumentHelper.parseText(xml);
				Element root = document.getRootElement();

				String isSource = (String) context.getPara("IsSource");
				boolean source = Boolean.parseBoolean(isSource);

				String extend = root.attributeValue(ConstantUtil.EXTEND);

				int i = 1;
				for (MetaTable metaTable : tables) {
					List<String> keyList = new ArrayList<>();
					Element format;
					if (source) {
						format = (Element) root.selectSingleNode("SourceTableCollection/SourceTable[@Key='" + metaTable.getKey() + "']");
					} else {
						format = (Element) root.selectSingleNode("TargetTableCollection/TargetTable[@TableKey='" + metaTable.getKey() + "']");
					}
					if (format != null) {
						List<Node> list;
						if (source) {
							list = format.selectNodes("SourceField");
						} else {
							list = format.selectNodes("TargetField");
						}
						for (Node node : list) {
							Element fieldNode = (Element) node;
							String definition;
							if (source) {
								definition = fieldNode.attributeValue(ConstantUtil.KEY);
							} else {
								definition = fieldNode.attributeValue("FieldKey");
							}
							keyList.add(definition);
						}
					}

					if (extend != null) {
						keyList.addAll(getExtendFieldList(extend, source, metaTable));
					}

					for (MetaColumn metaColumn : metaTable) {
						int append = dataTable.append();
						if (keyList.contains(metaColumn.getKey())) {
							dataTable.setString(append, "IsAdd", "0");
						}
						dataTable.setString(append, "TableIndex", "表(" + i + ")");
						dataTable.setString(append, "FieldKey", metaColumn.getKey());
						if (source) {
							dataTable.setString(append, "FieldCaption", metaColumn.getCaption());
						} else {
							dataTable.setString(append, "FieldCaption", metaColumn.getCaption() + getRoupTypeString(metaColumn));
						}
						dataTable.setString(append, "TableKey", metaTable.getKey());
					}
					i++;
				}
				dataTable.batchUpdate();
				doc.add(ConstantUtil.TBL_DATA_MIGRATION_FIELD, dataTable);
			}
		} else {
			String tableName = (String) context.getPara("TableName");
			String[] split = tableName.split("\\|");
			MetaDataObject dataObject = MetaFactory.getGlobalInstance().getDataObject(split[0]);
			MetaTable table = dataObject.getTable(split[1]);
			MetaTableCollection tableCollection = metaDataObject.getTableCollection();
			DataTable dataTable = DataTableUtil.newEmptyDataTable(tableCollection.first());

			String xml = (String) context.getPara("XML");
			org.dom4j.Document document = DocumentHelper.parseText(xml);
			Element root = document.getRootElement();
			String extend = root.attributeValue(ConstantUtil.EXTEND);
			String isSource = (String) context.getPara("IsSource");
			boolean source = Boolean.parseBoolean(isSource);
			List<String> keyList = new ArrayList<>();
			Element format;
			if (source) {
				format = (Element) root.selectSingleNode("SourceTableCollection/SourceTable[@Key='" + table.getKey() + "']");
			} else {
				format = (Element) root.selectSingleNode("TargetTableCollection/TargetTable[@TableKey='" + table.getKey() + "']");
			}
			if (format != null) {
				List<Node> list;
				if (source) {
					list = format.selectNodes("SourceField");
				} else {
					list = format.selectNodes("TargetField");
				}
				for (Node node : list) {
					Element fieldNode = (Element) node;
					String definition;
					if (source) {
						definition = fieldNode.attributeValue(ConstantUtil.KEY);
					} else {
						definition = fieldNode.attributeValue("FieldKey");

					}
					keyList.add(definition);
				}
			}

			if (extend != null) {
				keyList.addAll(getExtendFieldList(extend, source, table));
			}

			for (MetaColumn metaColumn : table) {
				int append = dataTable.append();
				if (keyList.contains(metaColumn.getKey())) {
					dataTable.setString(append, "IsAdd", "0");
				}
				dataTable.setString(append, "FieldKey", metaColumn.getKey());
				if (source) {
					dataTable.setString(append, "FieldCaption", metaColumn.getCaption());
				} else {
					dataTable.setString(append, "FieldCaption", metaColumn.getCaption() + getRoupTypeString(metaColumn));
				}
				dataTable.setString(append, "TableKey", table.getKey());
			}
			dataTable.batchUpdate();
			doc.add(ConstantUtil.TBL_DATA_MIGRATION_FIELD, dataTable);
		}
	}

	private void loadByDataMap(DefaultContext context, Document document, MetaDataObject metaDataObject) throws Throwable {
		String isTitle = (String) context.getPara("IsTitle");

		DataTable dataTable;
		if (Boolean.parseBoolean(isTitle)) {
			dataTable = dataMapLoadFormAllField(context, metaDataObject);
		} else {
			dataTable = datamapLoadTableFields(context, metaDataObject);
		}
		document.add(ConstantUtil.TBL_DATA_MAP_FIELD, dataTable);
	}

	private DataTable dataMapLoadFormAllField(DefaultContext context, MetaDataObject metaDataObject) throws Throwable {

		String xml = (String) context.getPara("XML");
		Element root = DocumentHelper.parseText(xml).getRootElement();
		String dataMapDataType = (String) context.getPara("DataMapDataType");
		String formKey = (String) context.getPara("FormKey");
		MetaTableCollection tableCollection = DataMapUtil.getTableCollection(formKey);
		MetaForm metaForm1 = MetaFactory.getGlobalInstance().getMetaForm(formKey);
		IDLookup idLookup = IDLookup.getIDLookup(metaForm1);
		// 创建当前弹出框的datatable
		MetaTableCollection currentTableCollection = metaDataObject.getTableCollection();
		DataTable dataTable = DataTableUtil.newEmptyDataTable(currentTableCollection.first());

		for (MetaTable metaTable : tableCollection) {
			if (metaTable.getKey().contains(MetaFormNODBProcess.STR_NODBTable_Profix)) {
				continue;
			}
			// 存在的key列表
			List<String> keyList = new ArrayList<>();
			if ("source".equals(dataMapDataType)) {
				Element format = (Element) root.selectSingleNode("SourceTableCollection/SourceTable[@Key='" + metaTable.getKey() + "']");
				if (format != null) {
					List<Node> list = format.selectNodes(ConstantUtil.SOURCE_FIELD);
					for (Node node : list) {
						Element fieldNode = (Element) node;
						String definition = fieldNode.attributeValue(ConstantUtil.KEY);
						keyList.add(definition);
					}
				}
			} else if ("target".equals(dataMapDataType)) {
				Element format = (Element) root.selectSingleNode("TargetTableCollection/TargetTable[@Key='" + metaTable.getKey() + "']");
				if (format != null) {
					List<Node> list = format.selectNodes(ConstantUtil.TARGET_FIELD);
					for (Node node : list) {
						Element fieldNode = (Element) node;
						String definition = fieldNode.attributeValue(ConstantUtil.DEFINITION);
						keyList.add(definition);
					}
				}
			} else if ("feedback".equals(dataMapDataType)) {
				Element format = (Element) root.selectSingleNode("FeedbackCollection/FeedbackObject[@FormKey='" + formKey + "']/FeedbackTable[@TableKey='" + metaTable.getKey() + "']");
				if (format != null) {
					List<Node> list = format.selectNodes("FeedbackField");
					for (Node node : list) {
						Element fieldNode = (Element) node;
						String definition = fieldNode.attributeValue(ConstantUtil.FIELD_KEY);
						keyList.add(definition);
					}
				}
			}
			Map<String, List<String>> columKeysAndFieldKeys = idLookup.getColumKeysAndFieldListKeys(metaTable.getKey());
			if (MapUtils.isEmpty(columKeysAndFieldKeys)) {
				continue;
			}
			for (MetaColumn metaColumn : metaTable) {
				List<String> fieldKeys = columKeysAndFieldKeys.get(metaColumn.getKey());
				if (CollectionUtils.isEmpty(fieldKeys)) {
					continue;
				}
				String fieldKey = null;
				if (fieldKeys.size() > 0) {
					fieldKey = fieldKeys.get(0);
				}
				fieldKey = StringUtils.isBlank(fieldKey) ? metaColumn.getKey() : fieldKey;

				int append = dataTable.append();
				if (keyList.contains(fieldKey)) {
					dataTable.setString(append, "IsAdd", "0");
				}
				dataTable.setString(append, "IsNODBField", "1");
				if (metaColumn.getKey().contains(MetaFormNODBProcess.STR_NODBTable_Profix)) {
					dataTable.setString(append, "IsNODBField", "0");
				}
				int index = tableCollection.indexOf(metaTable) + 1;
				dataTable.setString(append, "TableIndex", "表(" + index + ")");
				dataTable.setString(append, "FieldKey", fieldKey);
				dataTable.setString(append, "FieldCaption", metaColumn.getCaption());
				dataTable.setString(append, "TableKey", metaTable.getKey());
			}
			if ("target".equals(dataMapDataType) && DataMapUtil.getNodbFields(tableCollection).containsKey(metaTable.getKey())) {
				HashMap<String, HashMap<String, Object>> hashNODBFields = DataMapUtil.getNodbFields(tableCollection);
				HashMap<String, Object> hashFields = hashNODBFields.get(metaTable.getKey());
				HashMap<String, Object> designFormKeys = hashNODBFields.get("DesignFormKeys");
				columKeysAndFieldKeys = idLookup.getColumKeysAndFieldListKeys((String) designFormKeys.get(metaTable.getKey()));
				for (Map.Entry<String, Object> field : hashFields.entrySet()) {
					MetaColumn metaColumn = (MetaColumn) field.getValue();
					List<String> fieldKeys = columKeysAndFieldKeys.get(field.getKey());
					if (CollectionUtils.isEmpty(fieldKeys)) {
						continue;
					}
					String fieldKey = null;
					if (fieldKeys.size() > 0) {
						fieldKey = fieldKeys.get(0);
					}
					fieldKey = StringUtils.isBlank(fieldKey) ? metaColumn.getKey() : fieldKey;
					int append = dataTable.append();
					if (keyList.contains(fieldKey)) {
						dataTable.setString(append, "IsAdd", "0");
					}
					dataTable.setString(append, "IsNODBField", "0");
					int index = tableCollection.indexOf(metaTable) + 1;
					dataTable.setString(append, "TableIndex", "表(" + index + ")");
					dataTable.setString(append, "FieldKey", fieldKey);
					String cap = metaColumn.getCaption();
					cap = DataMapUtil.getCap(idLookup,metaColumn,fieldKey);
					dataTable.setString(append, "FieldCaption", cap);
					dataTable.setString(append, "TableKey", metaTable.getKey());
				}
			}
		}
		return dataTable;
	}

	private DataTable datamapLoadTableFields(DefaultContext context, MetaDataObject metaDataObject) throws Throwable {
		String formKey = (String) context.getPara("FormKey");
		String tableKey = (String) context.getPara("TableKey");

		String xml = (String) context.getPara("XML");
		Element root = DocumentHelper.parseText(xml).getRootElement();
		String dataMapDataType = (String) context.getPara("DataMapDataType");

		MetaTableCollection tableCollection = DataMapUtil.getTableCollection(formKey);
		MetaForm metaForm1 = MetaFactory.getGlobalInstance().getMetaForm(formKey);
		IDLookup idLookup = IDLookup.getIDLookup(metaForm1);
		MetaTable table = tableCollection.get(tableKey);
		if (table == null){
			table = MetaTableCache.getFullMetaTable(tableKey);
		}
		// 存在的key列表
		List<String> keyList = new ArrayList<>();
		if ("source".equals(dataMapDataType)) {
			Element format = (Element) root.selectSingleNode("SourceTableCollection/SourceTable[@Key='" + table.getKey() + "']");
			if (format != null) {
				List<Node> list = format.selectNodes(ConstantUtil.SOURCE_FIELD);
				for (Node node : list) {
					Element fieldNode = (Element) node;
					String definition = fieldNode.attributeValue(ConstantUtil.KEY);
					keyList.add(definition);
				}
			}
		} else if ("target".equals(dataMapDataType)) {
			Element format = (Element) root.selectSingleNode("TargetTableCollection/TargetTable[@Key='" + table.getKey() + "']");
			if (format != null) {
				List<Node> list = format.selectNodes(ConstantUtil.TARGET_FIELD);
				for (Node node : list) {
					Element fieldNode = (Element) node;
					String definition = fieldNode.attributeValue(ConstantUtil.DEFINITION);
					keyList.add(definition);
				}
			}
		} else if ("feedback".equals(dataMapDataType)) {
			Element format = (Element) root.selectSingleNode("FeedbackCollection/FeedbackObject[@FormKey='" + formKey + "']/FeedbackTable[@TableKey='" + table.getKey() + "']");
			if (format != null) {
				List<Node> list = format.selectNodes("FeedbackField");
				for (Node node : list) {
					Element fieldNode = (Element) node;
					String definition = fieldNode.attributeValue(ConstantUtil.FIELD_KEY);
					keyList.add(definition);
				}
			}
		}

		Map<String, List<String>> columKeysAndFieldKeys = idLookup.getColumKeysAndFieldListKeys(table.getKey());
		MetaTableCollection currentTableCollection = metaDataObject.getTableCollection();
		DataTable dataTable = DataTableUtil.newEmptyDataTable(currentTableCollection.first());
		for (MetaColumn metaColumn : table) {
			List<String> fieldKeys = new ArrayList<>();
			if (columKeysAndFieldKeys != null){
				fieldKeys = columKeysAndFieldKeys.get(metaColumn.getKey());
				if (CollectionUtils.isEmpty(fieldKeys)) {
					continue;
				}
			}
			String fieldKey = null;
			if (fieldKeys.size() > 0) {
				fieldKey = fieldKeys.get(0);
			}
			fieldKey = StringUtils.isBlank(fieldKey) ? metaColumn.getKey() : fieldKey;
			int append = dataTable.append();
			dataTable.setString(append, "IsNODBField", "1");
			if (metaColumn.getKey().contains(MetaFormNODBProcess.STR_NODBTable_Profix)) {
				dataTable.setString(append, "IsNODBField", "0");
			}
			if (keyList.contains(fieldKey)) {
				dataTable.setString(append, "IsAdd", "0");
			}
			dataTable.setString(append, "FieldKey", fieldKey);
			dataTable.setString(append, "FieldCaption", metaColumn.getCaption());
			dataTable.setString(append, "TableKey", table.getKey());
		}
		if ("target".equals(dataMapDataType) && DataMapUtil.getNodbFields(tableCollection).containsKey(table.getKey())) {
			HashMap<String, HashMap<String, Object>> hashNODBFields = DataMapUtil.getNodbFields(tableCollection);
			HashMap<String, Object> hashFields = hashNODBFields.get(table.getKey());
			HashMap<String, Object> designFormKeys = hashNODBFields.get("DesignFormKeys");
			columKeysAndFieldKeys = idLookup.getColumKeysAndFieldListKeys((String) designFormKeys.get(table.getKey()));
			for (Map.Entry<String, Object> field : hashFields.entrySet()) {
				MetaColumn metaColumn = (MetaColumn) field.getValue();
				List<String> fieldKeys = columKeysAndFieldKeys.get(field.getKey());
				if (CollectionUtils.isEmpty(fieldKeys)) {
					continue;
				}
				String fieldKey = null;
				if (fieldKeys.size() > 0) {
					fieldKey = fieldKeys.get(0);
				}
				fieldKey = StringUtils.isBlank(fieldKey) ? metaColumn.getKey() : fieldKey;
				int append = dataTable.append();
				if (keyList.contains(fieldKey)) {
					dataTable.setString(append, "IsAdd", "0");
				}
				dataTable.setString(append, "IsNODBField", "0");
				int index = tableCollection.indexOf(table) + 1;
				dataTable.setString(append, "TableIndex", "表(" + index + ")");
				dataTable.setString(append, "FieldKey", fieldKey);
				String cap = metaColumn.getCaption();
				cap = DataMapUtil.getCap(idLookup,metaColumn,fieldKey);
				dataTable.setString(append, "FieldCaption", cap);
				dataTable.setString(append, "TableKey", table.getKey());
			}
		}
		return dataTable;
	}

	public List<String> getExtendFieldList(String extend, boolean source, MetaTable metaTable) throws Throwable {
		List<String> fieldList = new ArrayList<>();
		String dataMigrationPath = LoadFileTree.getDataMigrationPathByKey(extend);
		if (StringUtils.isNotEmpty(dataMigrationPath)) {
			String extendXml = FileUtil.File2String(dataMigrationPath);
			Element extendRoot = DocumentHelper.parseText(extendXml).getRootElement();
			Element table;
			List<Node> list = new ArrayList<>();
			if (!source) {
				table = (Element) extendRoot.selectSingleNode("TargetTableCollection/TargetTable[@TableKey='" + metaTable.getKey() + "']");
				if (Objects.isNull(table)) {
					return fieldList;
				}
				list = table.selectNodes("TargetField");
			}
			for (Node node : list) {
				Element fieldNode = (Element) node;
				String definition = fieldNode.attributeValue(ConstantUtil.FIELD_KEY);
				fieldList.add(definition);
			}

		}
		return fieldList;
	}

	public static MetaTable getMetaTable() {
		return metaTable;
	}

	public static void setMetaTable(MetaTable metaTable) {
		IOMetaObject.metaTable = metaTable;
	}

	public static MetaTable getMetaTableTwo() {
		return metaTableTwo;
	}

	public static void setMetaTableTwo(MetaTable metaTableTwo) {
		IOMetaObject.metaTableTwo = metaTableTwo;
	}

	public static String getGridTableKey() {
		return gridTableKey;
	}

	public static void setGridTableKey(String gridTableKey) {
		IOMetaObject.gridTableKey = gridTableKey;
	}

	private static AbstractMetaObject getComponent(MetaForm metaForm, String compKey) throws Throwable {
		BiFunction<String, MetaForm, AbstractMetaObject> func = (key, form) -> {
			AbstractMetaObject metaComponent = form.componentByKey(key);
			if (Objects.isNull(metaComponent)) {
				metaComponent = form.metaGridCellByKey(key);
			}
			if (Objects.isNull(metaComponent)) {
				metaComponent = form.embedByKey(key);
			}
			if (Objects.isNull(metaComponent)) {
				metaComponent = form.getAllUIComponents().get(key);
			}
			IDLookup idLookup = IDLookup.reloadIDLookup(form);
			if (Objects.isNull(metaComponent)) {
				metaComponent = idLookup.getGridCellByKey(key);
			}
			if (Objects.isNull(metaComponent)) {
				metaComponent = idLookup.getListViewColumnByKey(key);
			}
			return metaComponent;
		};

		// 不重新加载直接取
		AbstractMetaObject metaComponent = func.apply(compKey, metaForm);
		if (Objects.nonNull(metaComponent)) {
			return metaComponent;
		}

		// 重新加载再取
		metaForm = NewFormCmd.loadMetaForm(metaForm.getKey());
		metaComponent = func.apply(compKey, metaForm);
		if (Objects.nonNull(metaComponent)) {
			return metaComponent;
		}

		// 从马甲中再取
		if (StringUtils.isNotBlank(metaForm.getExtend())) {
			metaForm = NewFormCmd.loadMetaForm(metaForm.getExtend());
			return func.apply(compKey, metaForm);
		}

		// 再重新加载再取
		metaForm = NewFormCmd.loadMetaForm(metaForm.getKey());
		return func.apply(compKey, metaForm);
	}

	private MetaDataObject getErpMetaDataObject(MetaForm erpMetaForm, String erpXmlKey) {
		if (Objects.nonNull(erpMetaForm)) {
			MetaDataSource metaDataSource = erpMetaForm.getDataSource();
			if (Objects.isNull(metaDataSource)) {
				return null;
			}
			return metaDataSource.getDataObject(); // TODO 这里是否存在 metaDataSource.getRefObjectKey()的情况
		}

		try {
			IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
			MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
			MetaDataObjectProfile metaDataObjectProfile = dataObjectList.get(erpXmlKey);
			if (Objects.isNull(metaDataObjectProfile)) {
				return null;
			}
			return metaDataObjectProfile.getDataObject();
		} catch (Throwable e) {
			throw new RuntimeException(e);
		}
	}

	/*private String getErpDataObjectFilePath(MetaForm erpMetaForm, MetaDataObject erpMetaDataObject, String erpXmlKey) throws Throwable {
        if (Objects.isNull(erpMetaForm)) {
            String extend = erpMetaDataObject.getExtend();
            String dataObjectKey = StringUtils.isNotBlank(extend) ? extend : erpMetaDataObject.getKey();
            return LoadFileTree.getPathByDataObject(dataObjectKey);
        }

        MetaForm activeMetaForm = erpMetaForm;
        String extend = erpMetaForm.getExtend();
        if (StringUtils.isNotBlank(extend)) {
            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            MetaFormList metaFormList = metaFactory.getMetaFormList();
            MetaFormProfile metaFormProfile = metaFormList.get(extend);
            activeMetaForm = metaFormProfile.getForm();
        }

        String refObjectKey = activeMetaForm.getDataSource().getRefObjectKey();
        if (StringUtils.isNotBlank(refObjectKey)) {
            return LoadFileTree.getPathByDataObject(refObjectKey);
        }
        return LoadFileTree.getPathByFormKey(erpXmlKey);
    }*/
	private String getErpDataObjectFilePath(MetaForm erpMetaForm, MetaDataObject erpMetaDataObject, String erpXmlKey) throws Throwable {
		if (Objects.isNull(erpMetaForm)) {
			return LoadFileTree.getPathByDataObject(erpMetaDataObject.getKey());
		}
		String refObjectKey = erpMetaForm.getDataSource().getRefObjectKey();
		if (StringUtils.isNotBlank(refObjectKey)) {
			return LoadFileTree.getPathByDataObject(refObjectKey);
		}
		return LoadFileTree.getPathByFormKey(erpXmlKey);
	}

	//如果值从xml中取请调用此方法，
	protected String convertSpecialChars(String str) {
		str = StringUtil.replaceAll(str, "&amp;", "&");
		str = StringUtil.replaceAll(str, "&lt;", "<");
		str = StringUtil.replaceAll(str, "&gt;", ">");
		//str = StringUtil.replaceAll(str, "'", "&apos;");
		str = StringUtil.replaceAll(str, "&quot;", "\"");
		return str;
	}

	private String getCDataNodeText(TagNode actionNode) {
		return Optional.ofNullable(actionNode)
				.map(node -> {
					for (AbstractNode child : node.getChildren()) {
						if (!(child instanceof CDataNode)) {
							continue;
						}
						return child.getText();
					}
					return null;
				}).orElse(null);
	}

	private XmlTree getXmlTreeByFormKey(String formKey) throws Throwable {
		if (StringUtils.isBlank(formKey)) {
			return null;
		}
		String filePath = LoadFileTree.getPathByFormKey(formKey);
		String tempFilePath = XmlFileProcessor.instance.getTmpFile(filePath);
		String realFilePath = StringUtils.isNotBlank(tempFilePath) ? tempFilePath : filePath;
		return Xml4jUtil.parseTree(realFilePath);
	}

	private List<String> getEmbedTableKeyList(MetaForm metaForm) throws Throwable {
		if (Objects.isNull(metaForm)) {
			return new ArrayList<>();
		}
		final List<MetaEmbed> embeds = metaForm.getEmbeds();
		if (CollectionUtils.isEmpty(embeds)) {
			return new ArrayList<>();
		}

		List<String> embedTableKeyList = new ArrayList<>();
		for (MetaEmbed embed : embeds) {
			IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
			final MetaForm embedMetaForm = metaFactory.getMetaForm(embed.getFormKey());
			if (Objects.isNull(embedMetaForm)) {
				continue;
			}

			final MetaDataSource embedDataSource = embedMetaForm.getDataSource();
			if (Objects.isNull(embedDataSource)) {
				continue;
			}

			final MetaDataObject embedDataObject = embedDataSource.getDataObject();
			if (Objects.isNull(embedDataObject)) {
				continue;
			}

			final MetaTableCollection embedTableCollection = embedDataObject.getTableCollection();
			if (Objects.isNull(embedTableCollection)) {
				continue;
			}
			for (MetaTable embedTable : embedTableCollection) {
				if (Objects.isNull(embedTable)) {
					continue;
				}
				embedTableKeyList.add(embedTable.getKey());
			}
		}
		return embedTableKeyList;
	}

	private void loadNewDataElement(DefaultContext context, Document doc, MetaDataObject metaDataObject) throws Throwable{
		MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(context.getFormKey());
		MetaTableCollection tableCollection = metaDataObject.getTableCollection();
		String dataElementKey = (String)context.getPara("DataElementKey");
		setDataElementInfo(doc, tableCollection, dataElementKey);
		setDomainInfo(doc, tableCollection, dataElementKey);
	}

	private void setDomainInfo(Document doc, MetaTableCollection tableCollection, String dataElementKey) throws Throwable{
		DataTable ed_NewDomain = DataTableUtil.newEmptyDataTable(tableCollection.get("ED_NewDomain"));
		DataTable ed_DefaultItem = DataTableUtil.newEmptyDataTable(tableCollection.get("ED_DefaultItem"));
		doc.add("ED_NewDomain", ed_NewDomain);
		doc.add("ED_DefaultItem", ed_DefaultItem);
		if(StringUtils.isEmpty(dataElementKey))
			return;
		MetaDataElement dataElement = MetaUtil.getDataElement(MetaFactory.getGlobalInstance(), dataElementKey);
		if(dataElement == null)
			return;
		MetaDomain domain = dataElement.getDomain();
		if(domain == null)
			return;
		ed_NewDomain.append();
		ed_NewDomain.setObject("DataType", DataType.toString(domain.getDataType()));
		ed_NewDomain.setObject("Precision", domain.getPrecision() == null ? 0 : domain.getPrecision());
		ed_NewDomain.setObject("Scale", domain.getScale() == null ? 0 : domain.getScale());
		ed_NewDomain.setObject("Length", domain.getLength() == null ? 0 : domain.getLength());
		ed_NewDomain.setObject("DomainCaption", domain.getCaption() == null ? "" : domain.getCaption());
		ed_NewDomain.setObject("DomainNewKey", domain.getKey() == null ? "" : domain.getKey());
		ed_NewDomain.setObject("AllowMultiSelection", domain.isAllowMultiSelection() == null ? "" : domain.isAllowMultiSelection());
		ed_NewDomain.setObject("Case", domain.getCase() == null ? "" : domain.getCase());
		ed_NewDomain.setObject("ItemKey", domain.getItemKey() == null ? "" : domain.getItemKey());
		ed_NewDomain.setObject("GroupKey", domain.getGroupKey() == null ? "" : domain.getGroupKey());
		ed_NewDomain.setObject("SourceType",ComboBoxSourceType.format(domain.getSourceType() == null ? -1 : domain.getSourceType()) );
		Integer refControlType = domain.getRefControlType();
		if (refControlType == null) {
			refControlType = ControlType.TEXTEDITOR;
		}
		ed_NewDomain.setObject("ControlType", ControlType.toString(refControlType));
		MetaListBoxItemCollection items = domain.getItems();
		if (items != null) {
			for (MetaDefaultItem item : items) {
				String value = item.getValue();
				String caption = item.getCaption();
				String icon = item.getIcon();
				int append = ed_DefaultItem.append();
				ed_DefaultItem.setObject(append, "Key", item.getKey());
				ed_DefaultItem.setObject(append, "Value", value);
				ed_DefaultItem.setObject(append, "Caption", caption);
				ed_DefaultItem.setObject(append, "Icon", icon);
			}
		}
		ed_NewDomain.batchUpdate();
		ed_DefaultItem.batchUpdate();
	}

	private void setDataElementInfo(Document doc, MetaTableCollection tableCollection, String dataElementKey) throws Throwable{
		DataTable ed_NewDataElement = DataTableUtil.newEmptyDataTable(tableCollection.get("ED_NewDataElement"));
		DataTable ed_FieldLabelCollection = DataTableUtil.newEmptyDataTable(tableCollection.get("ED_FieldLabelCollection"));
		doc.add("ED_NewDataElement", ed_NewDataElement);
		doc.add("ED_FieldLabelCollection", ed_FieldLabelCollection);
		if(StringUtils.isEmpty(dataElementKey))
			return;
		MetaDataElement dataElement = MetaUtil.getDataElement(MetaFactory.getGlobalInstance(), dataElementKey);
		if(dataElement == null)
			return;
		ed_NewDataElement.append();
		ed_NewDataElement.setObject("DataElementKey", StringUtils.isEmpty(dataElement.getKey()) ? "" : dataElement.getKey());
		ed_NewDataElement.setObject("DataElementCaption", StringUtils.isEmpty(dataElement.getCaption()) ? "" : dataElement.getCaption());
		ed_NewDataElement.setObject("ParamID", StringUtils.isEmpty(dataElement.getParamID()) ? "" : dataElement.getParamID());
		ed_NewDataElement.setObject("DefaultCaption", StringUtils.isEmpty(dataElement.getDefaultCaption()) ? "" : dataElement.getDefaultCaption());
		ed_NewDataElement.setObject("DataDiffLog", dataElement.getDataDiffLog() == null ? false : true);
		ed_NewDataElement.setObject("NoHistory", dataElement.getNoHistory() == null ? false : true);
		MetaFieldLabelCollection fieldLabelCollection = dataElement.getFieldLabelCollection();
		if (fieldLabelCollection != null) {
			for (MetaFieldLabel label : fieldLabelCollection) {
				int append = ed_FieldLabelCollection.append();
				ed_FieldLabelCollection.setObject(append, "Key", label.getKey());
				ed_FieldLabelCollection.setObject(append, "Length", label.getLength());
				ed_FieldLabelCollection.setObject(append, "Text", StringUtils.isEmpty(label.getText()) ? "" : label.getText());
			}
		}
		ed_NewDataElement.batchUpdate();
		ed_FieldLabelCollection.batchUpdate();

	}

	private <EC extends IEvalContext> void paddingToolbar(DataTable dataTable) {
		boolean isMatched = StringUtils.equals(dataTable.getKey(), Constants.TBL_TOOLBAR);
		if (!isMatched) {
			return;
		}
		int rowIndex = dataTable.append();
		DebuggerContext<EC> debuggerContext = DebuggerContext.getInstance();
		if (Objects.isNull(debuggerContext)) {
			dataTable.setInt(rowIndex, "ResumeEnable", 0);
			dataTable.setInt(rowIndex, "StepOverEnable", 0);
			dataTable.setInt(rowIndex, "StepIntoEnable", 0);
			dataTable.setInt(rowIndex, "StepOutEnable", 0);
		} else {
			SyntaxTreeWrapper<EC> runningSyntaxTreeWrapper = debuggerContext.getRunningSyntaxTreeWrapper();
			boolean completed = runningSyntaxTreeWrapper.isCompleted();
			SyntaxTreeWrapper<EC> parentSyntaxTreeWrapper = runningSyntaxTreeWrapper.getParentSyntaxTreeWrapper();
			boolean runningMacroItem = runningSyntaxTreeWrapper.isRunningMacroItem();
			dataTable.setInt(rowIndex, "ResumeEnable", 1);
			dataTable.setInt(rowIndex, "StepOverEnable", 1);
			dataTable.setInt(rowIndex, "StepIntoEnable", (!completed && runningMacroItem) ? 1 : 0);
			dataTable.setInt(rowIndex, "StepOutEnable", Objects.nonNull(parentSyntaxTreeWrapper) ? 1 : 0);
		}
		dataTable.setInt(rowIndex, "ToggleEnableVisible", DesignerDebuggerImpl.getEnable() ? 0 : 1);
	}

	private <EC extends IEvalContext> void paddingBreakpoint(DataTable dataTable) {
		boolean isMatched = StringUtils.equals(dataTable.getKey(), Constants.TBL_BREAKPOINT_LIST);
		if (!isMatched) {
			return;
		}
		Breakpoint runningBreakpoint = null;
		DebuggerContext<EC> debuggerContext = DebuggerContext.getInstance();
		if (Objects.nonNull(debuggerContext)) {
			runningBreakpoint = debuggerContext.getRunningBreakpoint();
		}
		List<Breakpoint> breakpoints = BreakpointManager.getList();
		for (Breakpoint breakpoint : breakpoints) {
			int rowIndex = dataTable.append();
			dataTable.setLong(rowIndex, "OID", breakpoint.getOid());
			dataTable.setInt(rowIndex, "Running", breakpoint == runningBreakpoint ? 1 : 0);
			dataTable.setString(rowIndex, "Type", String.valueOf(breakpoint.getType()));
			dataTable.setString(rowIndex, "ScriptText", breakpoint.getText());
			dataTable.setString(rowIndex, "Condition", breakpoint.getCondition());
			dataTable.setBoolean(rowIndex, "IsEnable", breakpoint.getEnable());
			dataTable.setString(rowIndex, "EditButton", "编辑");
			dataTable.setString(rowIndex, "DeleteButton", "删除");
		}
	}

	public static <EC extends IEvalContext> void paddingVariant(DataTable dataTable, SyntaxTreeWrapper<EC> syntaxTreeWrapper) {

		boolean isMatched = StringUtils.equals(dataTable.getKey(), Constants.TBL_VARIANT_LIST);
		if (!isMatched) {
			return;
		}
		if (Objects.isNull(syntaxTreeWrapper)) {
			DebuggerContext<EC> debuggerContext = DebuggerContext.getInstance();
			if (Objects.isNull(debuggerContext)) {
				return;
			}
			syntaxTreeWrapper = debuggerContext.getRunningSyntaxTreeWrapper();
		}
		int rowIndex = dataTable.append();
		dataTable.setString(rowIndex, "VariantName", "context");
		try {
			dataTable.setObject(rowIndex, "VariantValue", JsonMapper.writeValueAsString(syntaxTreeWrapper.getContext()));
		} catch (Exception e) {
			e.printStackTrace();
		}
		List<ItemWrapper> variantWrapperList = syntaxTreeWrapper.getVariantWrapperList();
		for (ItemWrapper variantWrapper : variantWrapperList) {
			int i = dataTable.append();
			dataTable.setString(i, "VariantName", variantWrapper.getFormatText());
			try {
				dataTable.setObject(i, "VariantValue", JsonMapper.writeValueAsString(variantWrapper.getEvalResult()));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	public static <EC extends IEvalContext> void paddingSyntaxTree(DataTable dataTable, SyntaxTreeWrapper<EC> syntaxTreeWrapper) {
		boolean isMatched = StringUtils.equals(dataTable.getKey(), Constants.TBL_SYNTAX_TREE);
		if (!isMatched) {
			return;
		}
		if (Objects.isNull(syntaxTreeWrapper)) {
			DebuggerContext<EC> debuggerContext = DebuggerContext.getInstance();
			if (Objects.isNull(debuggerContext)) {
				return;
			}
			syntaxTreeWrapper = debuggerContext.getRunningSyntaxTreeWrapper();
		}
		ItemWrapper runningItemWrapper = syntaxTreeWrapper.getRunningItemWrapper();
		ItemWrapper rootItemWrapper = syntaxTreeWrapper.getRootItemWrapper();
		paddingSyntaxTree(dataTable, rootItemWrapper, null, runningItemWrapper);
	}

	private static boolean paddingSyntaxTree(DataTable dataTable, ItemWrapper itemWrapper, ItemWrapper parentItemWrapper, ItemWrapper runningItemWrapper) {
		boolean valuing = itemWrapper == runningItemWrapper;
		List<ItemWrapper> children = itemWrapper.getChildren();
		boolean noneMatch = children.stream().noneMatch(ItemWrapper::isNeedDisplay);
		if (!noneMatch) {
			for (ItemWrapper child : children) {
				boolean childValuing = paddingSyntaxTree(dataTable, child, itemWrapper, runningItemWrapper);
				valuing = valuing || childValuing;
			}
		}

		int rowIndex = dataTable.append();
		dataTable.setInt(rowIndex, "Running", (itemWrapper == runningItemWrapper) ? 1 : 0);
		dataTable.setInt(rowIndex, "ExprItem", itemWrapper.hashCode());
		if (Objects.nonNull(parentItemWrapper)) {
			dataTable.setInt(rowIndex, "ParentExprItem", parentItemWrapper.hashCode());
		}
		dataTable.setString(rowIndex, "ScriptText", itemWrapper.getFormatText());
		Object evalResult = itemWrapper.getEvalResult();
		if (Objects.nonNull(evalResult)) {
			evalResult = JsonMapper.writeValueAsString(evalResult);
		} else {
			if (!itemWrapper.isCompleted()) {
				evalResult = valuing ? "执行中" : "未执行";
			} else {
				evalResult = "已执行";
			}
		}
		try {
			dataTable.setObject(rowIndex, "EvalResult", evalResult);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return valuing;
	}
	private static void setSequence(Document document) {
		for (int i = 0; i < document.size(); i++) {
			WebDesignerDataTableUtil.setSequence(document.get(i));
		}
	}
	private <EC extends IEvalContext> void paddingStack(DataTable dataTable) {
		boolean isMatched = StringUtils.equals(dataTable.getKey(), Constants.TBL_STACK_LIST);
		if (!isMatched) {
			return;
		}
		DebuggerContext<EC> debuggerContext = DebuggerContext.getInstance();
		if (Objects.isNull(debuggerContext)) {
			return;
		}

		Map<Integer, SyntaxTreeWrapper<EC>> syntaxTreeWrapperMap = debuggerContext.getSyntaxTreeWrapperMap();
		List<Map.Entry<Integer, SyntaxTreeWrapper<EC>>> entryList = new ArrayList<>(syntaxTreeWrapperMap.entrySet());
		ListIterator<Map.Entry<Integer, SyntaxTreeWrapper<EC>>> listIterator = entryList.listIterator(syntaxTreeWrapperMap.size());
		while (listIterator.hasPrevious()) {
			Map.Entry<Integer, SyntaxTreeWrapper<EC>> entry = listIterator.previous();
			SyntaxTreeWrapper<EC> syntaxTreeWrapper = entry.getValue();
			boolean running = Objects.equals(syntaxTreeWrapper, debuggerContext.getRunningSyntaxTreeWrapper());
			if (syntaxTreeWrapper.isCompleted() && !running) {
				continue;
			}

			ItemWrapper rootItemWrapper = syntaxTreeWrapper.getRootItemWrapper();
			int rowIndex = dataTable.append();
			dataTable.setInt(rowIndex, "OID", entry.getKey());
			dataTable.setInt(rowIndex, "Running", running ? 1 : 0);
			SyntaxTreeWrapper<EC> parentSyntaxTreeWrapper = syntaxTreeWrapper.getParentSyntaxTreeWrapper();
			if (Objects.isNull(parentSyntaxTreeWrapper)) {
				dataTable.setObject(rowIndex, "StackDesc", rootItemWrapper.getFormatText());
			} else {
				ItemWrapper runningItemWrapper = parentSyntaxTreeWrapper.getRunningItemWrapper();
				// dataTable.setObject(rowIndex, "StackDesc", runningItemWrapper.getFormatText());
				dataTable.setObject(rowIndex, "StackDesc", runningItemWrapper.getFormatText() + " -> " + rootItemWrapper.getFormatText());
			}
		}
	}
}
