package com.bokesoft.yes.design.function;

import com.bokesoft.erp.entity.util.EntityDesigerContextAction;
import com.bokesoft.yes.common.util.DateUtil;
import com.bokesoft.yes.design.bpm.util.GetDataUtil;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil;
import com.bokesoft.yes.design.utils.XMLWriter;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocument;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yigo.common.def.DataObjectSecondaryType;
import com.bokesoft.yigo.meta.bpm.total.ProcessMapType;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectList;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.tools.document.DataTableUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import java.io.*;
import java.util.List;


public class WebDesignBPMUtil extends EntityDesigerContextAction {
    private final static String ProcessKey = "ProcessKey";
    private final static String IsDynamic = "IsDynamic";
    private final static String StartAction = "StartAction";
    private final static String StartCaption = "StartCaption";
    private final static String Perm = "Perm";
    private final static String ProcessKeyFormula = "ProcessKeyFormula";
    private final static String ProcessMapCollection = "ProcessMapCollection";
    private final static String ProcessMap = "ProcessMap";

    public WebDesignBPMUtil(RichDocumentContext _context) {
        super(_context);
    }

    public String getFormList() throws Throwable {
        StringBuilder sb = new StringBuilder(256);
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        // 表单列表
        MetaFormList metaFormList = metaFactory.getMetaFormList();
        if (null != metaFormList && !metaFormList.isEmpty()) {
            for (int i = 0; i < metaFormList.size(); i++) {
                MetaFormProfile metaFormProfile = metaFormList.get(i);
                if (null == metaFormProfile) {
                    continue;
                }
                // 不是当前项目就跳过
					/*if (null == metaFormProfile.getProject() ||
							!projectKey.equals(metaFormProfile.getProject().getKey())) {
						continue;
					}*/
                String formKey = metaFormProfile.getKey();
                String formCaption = metaFormProfile.getCaption();
                // 有主表就放入列表，否则跳过
                if (GetDataUtil.instance.hasMainTable(formKey, ProcessMapType.Form)) {
                    sb.append(";");
                    sb.append(formKey).append(",").append(" ").append(formCaption.replaceAll(",", " "));
                }
            }

        }
        return sb.toString();
    }

    public String getDataObjectList() throws Throwable {
        StringBuilder sb = new StringBuilder(256);
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
        if (null != dataObjectList && !dataObjectList.isEmpty()) {
            for (int i = 0; i < dataObjectList.size(); i++) {
                MetaDataObjectProfile metaDataObjectProfile = dataObjectList.get(i);
                if (null == metaDataObjectProfile) {
                    continue;
                }
                // 不是当前项目就跳过
               /* if (null == metaDataObjectProfile.getProject() ||
                        !projectKey.equals(metaDataObjectProfile.getProject().getKey())) {
                    continue;
                }*/
                String dataObjeectKey = metaDataObjectProfile.getKey();
                String dataObjeectCaption = metaDataObjectProfile.getCaption();
                int secondType = metaDataObjectProfile.getSecondaryType();
                // 有主表就放入列表，否则跳过
                if (GetDataUtil.instance.hasMainTable(dataObjeectKey, ProcessMapType.DataObject)
                        && secondType == DataObjectSecondaryType.NORMAL) {
                    sb.append(";");
                    sb.append(dataObjeectKey).append(",").append(" ").append(dataObjeectCaption.replaceAll(",", " "));
                }
            }
        }
        return sb.toString();
    }

    public String getProcessKeyList(String filePath) throws Throwable{
        filePath = FilePathHelper.toBackFilePath(filePath);
        StringBuilder sb = new StringBuilder(256);
        if(StringUtils.isEmpty(filePath)){
            return sb.toString();
        }

        SAXReader reader = new SAXReader();
        // 加载文档
        Document document = reader.read(new File(filePath));
        // 获取根节点
        Element root =  document.getRootElement();

        List<Element> elements = root.elements();
        if (CollectionUtils.isEmpty(elements) || null == root.element("DeployInfoCollection")
                || null == root.element("DeployInfoCollection").elements("DeployInfo")) {
            return sb.toString();
        }

        List<Element> deployInfoList = root.element("DeployInfoCollection").elements("DeployInfo");
        for (Element ele : deployInfoList) {
            if (null != ele.attributeValue(ConstantUtil.KEY)) {
                sb.append(";");
                sb.append(ele.attributeValue(ConstantUtil.KEY));
            }
        }
        return sb.toString();
    }

    public DataTable getWorkflowData(String filePath) throws Throwable{
        RichDocumentContext context = this.getMidContext();
        filePath = FilePathHelper.toBackFilePath(filePath);
        MetaForm metaFormKeyDialog = context.getMetaFactory().getMetaForm("BPM_Setting");
        MetaTable gridMetaTable = metaFormKeyDialog.getDataSource().getDataObject().getMetaTable("EBPM_Setting");
        DataTable dataTable = DataTableUtil.newEmptyDataTable(gridMetaTable);
        if(StringUtils.isEmpty(filePath)){
            return dataTable;
        }
        SAXReader reader = new SAXReader();

        // 加载文档
        Document document = reader.read(new File(filePath));
        // 获取根节点
        Element root =  document.getRootElement();
        if (!CollectionUtils.isEmpty(root.element(ProcessMapCollection).elements(ProcessMap))) {
            final List<Element> elements = root.element(ProcessMapCollection).elements(ProcessMap);
            for (int i = 0; i < elements.size(); i++) {
                Element ele = elements.get(i);
                dataTable.append();
                if (StringUtils.isNotEmpty(ele.attributeValue(ConstantUtil.TYPE))) {
                    dataTable.setString(ConstantUtil.TYPE, "2");
                } else {
                    dataTable.setString(ConstantUtil.TYPE, "1");
                }
                dataTable.setString(ConstantUtil.KEY, ele.attributeValue(ConstantUtil.KEY));
                dataTable.setBoolean(IsDynamic, StringUtils.isNotEmpty(ele.attributeValue(IsDynamic)));
                if (StringUtils.isNotEmpty(ele.attributeValue(ProcessKey))) {
                    dataTable.setString(ProcessKey, ele.attributeValue(ProcessKey));
                }
                if (StringUtils.isNotEmpty(ele.attributeValue(ProcessKeyFormula))) {
                    dataTable.setString(ProcessKey, ele.attributeValue(ProcessKeyFormula));
                }
                dataTable.setString(StartAction, ele.attributeValue(StartAction));
                dataTable.setString(StartCaption, ele.attributeValue(StartCaption));
                Element perm = ele.element(Perm);
                if(perm != null){
                    String permXml = perm.asXML();
                    dataTable.setString(Perm, permXml);
                }
            }
        }
        return dataTable;
    }

    public void workflowAndBillsConfig(String filePath) throws Throwable{
        if(StringUtils.isEmpty(filePath)){
            return;
        }
        filePath = FilePathHelper.toBackFilePath(filePath);
        RichDocumentContext context = this.getMidContext();
        RichDocument richDocument = context.getRichDocument();
        DataTable ebpm_setting = richDocument.getDataTable("EBPM_Setting");

        SAXReader reader = new SAXReader();
        // 加载文档
        Document document = reader.read(new File(filePath));
        // 获取根节点
        Element root = document.getRootElement();
        if (null != root.element(ProcessMapCollection)) {
            root.remove(root.element(ProcessMapCollection));
        }
        root.addElement(ProcessMapCollection);
        Element processMapEle;
        for (int i = 0; i < ebpm_setting.size(); i++) {
            if(StringUtils.isEmpty(ebpm_setting.getString(i,ConstantUtil.KEY))){
                continue;
            }
            processMapEle = root.element(ProcessMapCollection).addElement(ProcessMap);
            String type =  ebpm_setting.getString(i, ConstantUtil.TYPE);
            String processKey = ebpm_setting.getString(i, ProcessKey);
            if("1".equals(type)){
                processMapEle.addAttribute(ProcessKey, processKey);
            }else{
                processMapEle.addAttribute(ConstantUtil.TYPE, type);
                processMapEle.addAttribute(ProcessKeyFormula, processKey);
            }
            Boolean isDynamic = ebpm_setting.getBoolean(i,IsDynamic);
            if (isDynamic) {
                processMapEle.addAttribute(IsDynamic, isDynamic.toString());
                processKey = ebpm_setting.getString(i, ProcessKey);
                processMapEle.addAttribute(ProcessKey, processKey);
                processMapEle.addAttribute(ProcessKeyFormula, processKey);
            }
            processMapEle.addAttribute("InitDate",
                    DateUtil.getDateFormatText(null, "yyyy-MM-dd HH:mm:ss") + " CST")
                    .addAttribute(ConstantUtil.KEY, ebpm_setting.getString(i, ConstantUtil.KEY))
                    .addAttribute(StartAction, ebpm_setting.getString(i, StartAction))
                    .addAttribute(StartCaption, ebpm_setting.getString(i, StartCaption));

            String perm = ebpm_setting.getString(i, Perm);
            if(StringUtils.isEmpty(perm)){
                continue;
            }
            Document document1 = DocumentHelper.parseText(perm);
            processMapEle.add(document1.getRootElement());
        }
        writeStringToFile(filePath, document);
        IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
        globalInstance.reloadMetaBPM();
    }

    private void writeStringToFile(String filePath, Document document){
        OutputFormat format = DataMapOperXmlUtil.getOutputFormat();
        FileOutputStream fileOutputStream = null;
        XMLWriter writer = null;
        try {
            fileOutputStream = new FileOutputStream(filePath);
            writer = new XMLWriter(fileOutputStream, format);
            writer.write(document);
            DataMapOperXmlUtil.closeFileStream(fileOutputStream, writer);
        } catch (Exception e) {
            e.printStackTrace();
        }finally {
            DataMapOperXmlUtil.closeFileStream(fileOutputStream, writer);
        }

    }
}
