package com.bokesoft.yes.design.datamap.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.utils.TwoTuple;
import com.bokesoft.yes.design.utils.XMLWriter;
import com.bokesoft.yes.design.utils.publicMethodUtil;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.erp.config.MetaFormNODBProcess;
import com.bokesoft.yes.erpdatamap.ERPMetaMap;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;

import java.io.File;
import java.io.FileOutputStream;
import java.util.*;

import static com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil.getOutputFormat;

public class DataMapOperJsonUtil {
    public static final DataMapOperJsonUtil instance = new DataMapOperJsonUtil();
    /***xml扩展名*/
    private static final String XML_EXTENSION = ".xml";
    //用于记录临时文件Content，为回撤提供基础
    private static final List<String> undoSet = new ArrayList<>();

    /**
     * 新增数据映射创建XMl文件和tree
     *
     * @param projectKey    选择的工程名
     * @param sourceFormKey 源FormKey
     * @param targetFormKey 目标表单
     * @param key           映射标识
     * @param caption       映射名称
     * @param version       版本号
     * @return
     */
    public Map<String, String> createDataMapXml(String projectKey,
                                                String sourceFormKey,
                                                String targetFormKey,
                                                String key,
                                                String caption,
                                                String version,
                                                String extend) {
        Map<String, String> result = new HashMap<>(10);
        String dataMapPathByKey = LoadFileTree.getDataMapPathByKey(key);
        if (StringUtils.isNotEmpty(dataMapPathByKey)) {
            result.put("result", "false");
            return result;
        }
        String filePath = "";
        try {
            int verionNo = Integer.parseInt(version) + 1;
            String newFileName = key + XML_EXTENSION;
            //创建一个新的路径
            filePath = LoadFileTree.newDataMap(projectKey, newFileName, key, caption);
            IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
            String fileContent;
            TwoTuple<MetaForm, MetaDataObject> metaFormOrMetaDataObject = publicMethodUtil.MetaFormOrMetaDataObject(sourceFormKey);
            String extendFormKey = null, srcDataObjectKey = "", targetDataObjectKey = "";
            if (metaFormOrMetaDataObject.metaForm != null) {
                extendFormKey = globalInstance.getMetaForm(sourceFormKey).getExtend();
                if (StringUtils.isNotEmpty(extendFormKey)) {//马甲
                    MetaForm metaForm = globalInstance.getMetaForm(extendFormKey);
                    srcDataObjectKey = metaForm.getDataSource().getDataObject().getKey();
                } else {
                    srcDataObjectKey = globalInstance.getMetaForm(sourceFormKey).getDataSource().getDataObject().getKey();
                }
            } else if (metaFormOrMetaDataObject.metaDataObject != null) {
                srcDataObjectKey = metaFormOrMetaDataObject.metaDataObject.getKey();
            }
            metaFormOrMetaDataObject = publicMethodUtil.MetaFormOrMetaDataObject(targetFormKey);
            String extendTargetForm = null;
            if (metaFormOrMetaDataObject.metaForm != null) {
                extendTargetForm = globalInstance.getMetaForm(targetFormKey).getExtend();
                if (StringUtils.isNotEmpty(extendTargetForm)) {//马甲
                    MetaForm metaForm = globalInstance.getMetaForm(extendTargetForm);
                    targetDataObjectKey = metaForm.getDataSource().getDataObject().getKey();
                } else {
                    targetDataObjectKey = globalInstance.getMetaForm(targetFormKey).getDataSource().getDataObject().getKey();
                }
            } else if (metaFormOrMetaDataObject.metaDataObject != null) {
                targetDataObjectKey = metaFormOrMetaDataObject.metaDataObject.getKey();
            }
            if (StringUtils.isNotEmpty(extend)) {
                fileContent = createDataMapVestXml(caption, key, extend,  srcDataObjectKey, sourceFormKey, targetDataObjectKey, targetFormKey);

            } else {
                fileContent = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n" +
                        "<Map Caption=\"" + caption + "\" Key=\"" + key + "\" SrcDataObjectKey=\"" + srcDataObjectKey + "\"" +
                        " SrcFormKey=\"" + sourceFormKey + "\" TgtDataObjectKey=\"" + targetDataObjectKey + "\" TgtFormKey=\"" + targetFormKey + "\">\n" +
                        "    <SourceTableCollection Height=\"60\" Width=\"296\" X=\"30\" Y=\"80\"/>\n" +
                        "    <TargetTableCollection Height=\"60\" Width=\"296\" X=\"457\" Y=\"80\"/>\n" +
                        "</Map>\n";
            }
            //生成一个临时文件
            XmlFileProcessor.instance.saveTempFile(filePath, fileContent,projectKey);
            //创建的时候直接生成文件夹
            FileUtils.writeStringToFile(new File(filePath), fileContent, "UTF-8");
            result.put("result", "true");
            result.put("filePath", filePath);
            result.put("version", String.valueOf(verionNo));
            result.put("fileName", newFileName.replaceAll(".xml", ""));
        } catch (Exception e) {
            result.put("result", "false");
            LogSvr.getInstance().error(e.getMessage(), e);
        } catch (Throwable throwable) {
            LogSvr.getInstance().error(throwable.getMessage(), throwable);
        }
        return result;
    }

    /***
     * 转换xml文件为json文件
     * @param filePaths xml文件路径
     *
     */
    public JSONObject convertXmlToJson(String filePaths) throws Throwable {
        JSONObject workFlowJson = new JSONObject(new LinkedHashMap<>());
        //在点击打开数据映射创建一个临时文件用于保存前操作
        String temFilePath = XmlFileProcessor.instance.getTmpFile(filePaths);
        if (StringUtils.isBlank(temFilePath)) {
            temFilePath = filePaths;
        }
        // 创建SAX读取器
        SAXReader reader = new SAXReader();
        // 加载文档
        Document document = reader.read(new File(temFilePath));
        // 获取根节点
        Element root = document.getRootElement();
        String caption = root.attributeValue(ConstantUtil.CAPTION);
        String extend = root.attributeValue("Extend");
        try {
            //源表单显示
            //JSONObject source = setSourceFormJson(root);
            OutputFormat format = getOutputFormat();
            FileOutputStream fileOutputStream = new FileOutputStream(temFilePath);
            XMLWriter writer = null;

            writer = new XMLWriter(fileOutputStream, format);
            writer.write(document);
            //目标表单显示
            //JSONObject target = setTargetFormJson(root);
            // 连线列表json设置
            JSONObject paths = setPaths(root);
            // 设置数据映射基本属性
            JSONObject workFlowDesc = setWorkFlowAttributes(root);
            //反填表单数据获取
            //JSONObject feedbackJson = setFeedback(root);
            // 数据映射描述
            workFlowJson.put("paths", paths);
            workFlowJson.put(ConstantUtil.DATA_MAPPROPS, workFlowDesc);
            //workFlowJson.put("source", source);
            //workFlowJson.put("target", target);
            //workFlowJson.put("feedbackJson", feedbackJson);
            workFlowJson.put(ConstantUtil.CAPTION, caption);
            workFlowJson.put("extend", extend);
            DataMapOperXmlUtil.closeFileStream(fileOutputStream, writer);
        } catch (Throwable e) {
            throw new Throwable(e);
        }
        return workFlowJson;
    }

    /**
     * @param filePath
     * @throws DocumentException
     * @return返回节点
     */
    public static Element getElement(String filePath) throws DocumentException {
        // 创建SAX读取器
        SAXReader reader = new SAXReader();
        // 加载文档
        Document document = reader.read(new File(filePath));
        // 获取根节点
        return document.getRootElement();
    }


    public static List<String> getFeedBackFormKeys(String filePath) throws DocumentException {
        SAXReader reader = new SAXReader();
        org.dom4j.Document doc = reader.read(new File(filePath));
        Element root = doc.getRootElement();
        List<String> feedBackKeyList = new ArrayList<String>();
        Node feedbackCollection = root.selectSingleNode("FeedbackCollection");
        if (Objects.isNull(feedbackCollection)) {
            return feedBackKeyList;
        }
        List<Node> feedbackObjectList = feedbackCollection.selectNodes("FeedbackObject");
        for (int i = 0; i < feedbackObjectList.size(); i++) {
            Element element = (Element) feedbackObjectList.get(i);
            String formKey = element.attributeValue("FormKey");
            feedBackKeyList.add(formKey);
        }
        return feedBackKeyList;
    }

    /***
     * 设置数据映射基础属性
     * @param root 根元素
     * @return 设置后的JSON对象
     */
    public JSONObject setWorkFlowAttributes(Element root) throws Throwable {
        List<String> keyList = Arrays.asList(ConstantUtil.KEY, ConstantUtil.CAPTION, ConstantUtil.DESCRIPTION, ConstantUtil.SRC_DATA_OBJECT_KEY, ConstantUtil.TGT_DATA_OBJECT_KEY,
                ConstantUtil.SRC_FORM_KEY, ConstantUtil.TGT_FORM_KEY, "MapRelationValue",
                "AllowRemainderPush", "MarkMapCount", "PullDataOnly", "RemainderPushValue",
                "MinPushValue", "MapCondition", "PostProcess", "FeedbackForm", "Extend", "StatusFieldKey_Feed",
                "Condition_Feed", "StatusValue_Feed");
        JSONObject workFlowDescSub = new JSONObject(new LinkedHashMap<>());
        JSONObject temp;
        String value;
        boolean isEmpty;
        for (String key : keyList) {
            value = root.attributeValue(key);
            isEmpty = null == value || StringUtils.isEmpty(value);
            switch (key) {
                case "PullDataOnly":
                    if (isEmpty) {
                        value = "false";
                    }
                    break;
                case "MapRelationValue":
                case "AllowRemainderPush":
                case "MarkMapCount":
                    if (isEmpty) {
                        value = "true";
                    }
                    break;
                case "FeedbackForm":
                    Element feedbackCollection = root.element(ConstantUtil.FEEDBACK_COLLECTION);
                    List<Element> elements = null;
                    if (feedbackCollection != null) {
                        elements = feedbackCollection.elements(ConstantUtil.FEEDBACK_OBJECT);
                    }
                    JSONObject FeedbackForm = new JSONObject();
                    if (elements != null && elements.size() != 0) {
                        for (Element ele : elements) {
                            JSONObject json = new JSONObject(new LinkedHashMap<>());
                            json.put("FeedbackForm", ele.attributeValue(ConstantUtil.FORM_KEY));
                            String formKey = ele.attributeValue(ConstantUtil.FORM_KEY);
                            if (StringUtils.isEmpty(formKey)) {
                                throw new Throwable("请在数据映射源代码中的FeedbackObject节点中新增FormKey属性例如:<FeedbackObject " +
                                        "Height=\"60\" ObjectKey=\"Material\" FormKey=\"V_Material\" Width=\"256\" X=\"723\" Y=\"106\">");
                            }
                            TwoTuple<MetaForm, MetaDataObject> formOrMetaDataObject = publicMethodUtil
                                    .MetaFormOrMetaDataObject(ele.attributeValue(ConstantUtil.FORM_KEY));
                            String FeedbackCaption = "";
                            if (formOrMetaDataObject.metaForm != null) {
                                FeedbackCaption = formOrMetaDataObject.metaForm.getCaption();
                            } else if (formOrMetaDataObject.metaDataObject != null) {
                                FeedbackCaption = formOrMetaDataObject.metaDataObject.getCaption();
                            }
                            json.put("FeedbackCaption", FeedbackCaption);
                            json.put("Width", ele.attributeValue("Width"));
                            json.put(ConstantUtil.X, ele.attributeValue(ConstantUtil.X));
                            json.put(ConstantUtil.Y, ele.attributeValue(ConstantUtil.Y));
                            FeedbackForm.put(ele.attributeValue(ConstantUtil.FORM_KEY), json);
                        }
                        JSONObject FeedbackFormvalue = new JSONObject(new LinkedHashMap<>());
                        FeedbackFormvalue.put("value", FeedbackForm);
                        workFlowDescSub.put("FeedbackForm", FeedbackFormvalue);
                    }
                    break;
                case "Condition_Feed":
                case "StatusFieldKey_Feed":
                case "StatusValue_Feed":
                    Element feedbackCollection1 = root.element(ConstantUtil.FEEDBACK_COLLECTION);
                    value = Objects.isNull(feedbackCollection1) ? "" : feedbackCollection1.attributeValue(key);
                    break;
                default:
                    break;
            }
            if (!"FeedbackForm".equalsIgnoreCase(key)) {
                temp = new JSONObject(new LinkedHashMap<>());
                temp.put("value", value);
                workFlowDescSub.put(key, temp);
            }
        }
        JSONObject workFlowDesc = new JSONObject(new LinkedHashMap<>());
        workFlowDesc.put(ConstantUtil.DATA_MAPPROPS, workFlowDescSub);
        return workFlowDesc;
    }

    /**
     * 根据XML总数据转换成Json返回给前端，用于前端动态添加表格
     *
     * @param root 节点
     * @return
     */
    public JSONObject setSourceFormJson(Element root) {
      /*  int[] keyList = new int[0];
        boolean mergeToSource = StringUtils.isNotEmpty(root.attributeValue("MergeToSource"));
        boolean extend = StringUtils.isNotEmpty(root.attributeValue("Extend"));*/
        //判断源表单和目标表单是否相同
        boolean isIdentical = root.attributeValue(ConstantUtil.SRC_FORM_KEY).equalsIgnoreCase(root.attributeValue(ConstantUtil.TGT_FORM_KEY));
        String srcFormKey1 = root.attributeValue(ConstantUtil.SRC_FORM_KEY);
        if (isIdentical) {//如果来源表单和目标表单相同就增加特定标识
            srcFormKey1 = root.attributeValue(ConstantUtil.SRC_FORM_KEY) + "__S";
        }
        JSONObject setSourceFormJson = null;
        JSONObject setSourceTableJson = null;
        MetaDataObject dataObject = null;
        MetaForm metaForm = null;
        IDLookup idLookup = null;
        try {
            String key = ConstantUtil.DEFINITION;
            //这个集合的主要作用是防止数据相同字段重复添加
            HashMap<Object, Object> hashMap = new HashMap<>();
            setSourceFormJson = new JSONObject(new LinkedHashMap<>());
            setSourceTableJson = new JSONObject(new LinkedHashMap<>());
            JSONObject temp;
            Element sourceTableCollection = root.element(ConstantUtil.SOURCE_TABLE_COLLECTION);
            String srcFormKey = root.attributeValue(ConstantUtil.SRC_FORM_KEY);
            List<Element> sourceTable = sourceTableCollection.elements(ConstantUtil.SOURCE_TABLE);
            if (sourceTable.size() != 0) {
                for (Element tableNode : sourceTable) {
                    if ("Table".equalsIgnoreCase(tableNode.attributeValue(ConstantUtil.TYPE)) || "SERVICE".equalsIgnoreCase(tableNode.attributeValue(ConstantUtil.TYPE))) {
                        List<Element> SourceField = tableNode.elements(ConstantUtil.SOURCE_FIELD);
                        String tableKey = tableNode.attributeValue(ConstantUtil.KEY);
                        //keyList = new int[SourceField.size()];
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("Type", tableNode.attributeValue(ConstantUtil.TYPE));
                        setSourceTableJson.put(tableKey, jsonObject);
                        for (int i = 0; i < SourceField.size(); i++) {
                            MetaForm metaForm1 = MetaFactory.getGlobalInstance().getMetaForm(srcFormKey);
                            idLookup = IDLookup.getIDLookup(metaForm1);
                            TwoTuple<MetaForm, MetaDataObject> metaFormOrMetaDataObject = publicMethodUtil.MetaFormOrMetaDataObject(srcFormKey);
                            metaForm = metaFormOrMetaDataObject.metaForm;
                            dataObject = metaFormOrMetaDataObject.metaDataObject;
                            Element sourceField = SourceField.get(i);
                           /* String key1 = sourceField.attributeValue("Key");
                            if (mergeToSource) {
                                if (key1.startsWith("merge_")) {
                                    key1 = key1.split("merge_")[1];
                                }
                            } else if (extend) {
                                if (key1.startsWith("field_")) {
                                    key1 = key1.split("field_")[1];
                                }
                            }
                            keyList[i] = (Integer.valueOf(key1));*/
                            temp = new JSONObject(new LinkedHashMap<>());
                            //防止添加重复数据
                            if (!hashMap.containsKey(sourceField.attributeValue(ConstantUtil.DEFINITION) + tableKey)) {
                                getSourceField(setSourceFormJson, temp, key, sourceField, srcFormKey1, metaForm,
                                        dataObject, tableKey, idLookup);
                            }
                            //每次添加完一条就在数据中加一条
                            hashMap.put(sourceField.attributeValue(ConstantUtil.DEFINITION) + tableKey, sourceField.attributeValue(ConstantUtil.DEFINITION));
                        }
                    }
                    //synchronizeMaxKey(keyList, tableNode);
                }
            }
        } catch (Throwable throwable) {
            LogSvr.getInstance().error(throwable.getMessage(), throwable);
        }
        JSONObject sourceJson = new JSONObject(new LinkedHashMap<>());
        sourceJson.put("source", setSourceFormJson);
        sourceJson.put("table", setSourceTableJson);
        return sourceJson;
    }

    /**
     * 重新计算MaxKey,取最大值
     */
    public void synchronizeMaxKey(int[] keyList, Element tableEle) {
        int last = Arrays.stream(keyList).max().getAsInt();
        tableEle.addAttribute("MaxKey", String.valueOf(last));
    }


    /**
     * @param setSourceFormJson
     * @param temp
     * @param key
     * @param sourceField
     * @param
     * @param metaForm
     * @param tableKey
     * @return 获取源单中的字段
     */
    public void getSourceField(JSONObject setSourceFormJson,
                               JSONObject temp,
                               String key,
                               Element sourceField,
                               String srcFormKey,
                               MetaForm metaForm,
                               MetaDataObject metaDataObject,
                               String tableKey,
                               IDLookup idLookup) {
        MetaTable metaTable = null;
        MetaTableCollection metaTableCollection = null;
        if (metaForm != null) {//表单
            metaTable = metaForm.getDataSource().getDataObject().getTable(tableKey);
            metaTableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
        } else if (metaDataObject != null) {//数据对象表单
            metaTable = metaDataObject.getTable(tableKey);
            metaTableCollection = metaDataObject.getTableCollection();
        }
        String definitionKey = sourceField.attributeValue(ConstantUtil.DEFINITION);
        MetaColumn metaColumn = null;
        metaColumn = DataMapOperXmlUtil.getMetaColumn(definitionKey, tableKey, metaTable, idLookup);
        if (metaTable != null && !tableKey.contains(MetaFormNODBProcess.STR_NODBTable_Profix) && metaTableCollection != null) {
            //获取当前tableKey的位置
            int indexOf = metaTableCollection.indexOf(metaTable);
            String fieldCaption = null;
            if (metaColumn != null) {
                fieldCaption = metaColumn.getCaption();
            }
            //添加类型为公式的Field
            if (StringUtils.isNotEmpty(sourceField.attributeValue(ConstantUtil.TYPE))) {
                if (StringUtils.isBlank(definitionKey)) {
                    definitionKey = "  ";
                }
                StringBuffer fieldValue = new StringBuffer().append((indexOf + 1)).append("_@_")
                        .append(definitionKey).append("_@_").append("  ").append("_@_").append(tableKey).append("_@_").append(srcFormKey);
                temp.put(ConstantUtil.DEFINITION, fieldValue);
            } else {
                //非公式字段数据处理
                StringBuffer fieldValue = new StringBuffer().append((indexOf + 1)).append("_@_")
                        .append(definitionKey).append("_@_").append(StringUtils.isEmpty(fieldCaption) ? "SpecialField" : fieldCaption)
                        .append("_@_").append(tableKey).append("_@_").append(srcFormKey);
                temp.put(ConstantUtil.DEFINITION, fieldValue);
            }
            setSourceFormJson.put(key + (setSourceFormJson.size() + 1), temp);
        } else if (Objects.isNull(metaTable)) {
            definitionKey = sourceField.attributeValue(ConstantUtil.DEFINITION);
            //添加类型为公式的Field
            if (StringUtils.isNotEmpty(sourceField.attributeValue(ConstantUtil.TYPE))) {
                if (StringUtils.isBlank(definitionKey)) {
                    definitionKey = "  ";
                }
                StringBuffer fieldValue = new StringBuffer().append((-1)).append("_@_")
                        .append(definitionKey).append("_@_").append("  ").append("_@_").append(tableKey).append("_@_").append(srcFormKey);
                temp.put(ConstantUtil.DEFINITION, fieldValue);
            } else {
                //非公式字段数据处理
                StringBuffer fieldValue = new StringBuffer().append((-1)).append("_@_")
                        .append(definitionKey).append("_@_").append(" ")
                        .append("_@_").append(tableKey).append("_@_").append(srcFormKey);
                temp.put(ConstantUtil.DEFINITION, fieldValue);
            }
            setSourceFormJson.put(key + (setSourceFormJson.size() + 1), temp);
        }

    }

    public JSONObject setTargetFormJson(Element root) {
        boolean isIdentical = root.attributeValue(ConstantUtil.SRC_FORM_KEY).equalsIgnoreCase(root.attributeValue(ConstantUtil.TGT_FORM_KEY));
        JSONObject settargetFormJson = null;
        MetaForm metaForm = null;
        MetaDataObject dataObject = null;
        IDLookup idLookup = null;
        MetaTable metaTable = null;
        MetaTableCollection metaTableCollection = null;

        try {
            String key = ConstantUtil.DEFINITION;
            //这个集合的主要作用是防止数据相同字段重复添加
            HashMap<Object, Object> hashMap = new HashMap<>();
            settargetFormJson = new JSONObject(new LinkedHashMap<>());
            JSONObject temp;
            Element targetTableCollection = root.element(ConstantUtil.TARGET_TABLE_COLLECTION);
            if(Objects.isNull(targetTableCollection)){
                JSONObject sourceJson = new JSONObject(new LinkedHashMap<>());
                sourceJson.put("target", null);
                return sourceJson;
            }
            String tgtFormKey = root.attributeValue(ConstantUtil.TGT_FORM_KEY);
            List<Element> targetTable = targetTableCollection.elements(ConstantUtil.TARGET_TABLE);
            String tgtFormKey1 = root.attributeValue(ConstantUtil.TGT_FORM_KEY);
            //判断源表单和目标表单是否相同
            if (isIdentical) {
                tgtFormKey1 = root.attributeValue(ConstantUtil.TGT_FORM_KEY) + "__T";
            }
            if (targetTable.size() != 0) {
                MetaForm metaForm1 = MetaFactory.getGlobalInstance().getMetaForm(tgtFormKey);
                idLookup = IDLookup.getIDLookup(metaForm1);
                TwoTuple<MetaForm, MetaDataObject> metaFormOrMetaDataObject = publicMethodUtil.MetaFormOrMetaDataObject(tgtFormKey);
                metaForm = metaFormOrMetaDataObject.metaForm;
                dataObject = metaFormOrMetaDataObject.metaDataObject;
                if (Objects.isNull(dataObject)) {
                    dataObject = metaForm.getDataSource().getDataObject();
                }

                for (Element Definition : targetTable) {
                    List<Element> TargetField = Definition.elements(ConstantUtil.TARGET_FIELD);
                    String tableKey = Definition.attributeValue(ConstantUtil.KEY);
                    if (metaForm != null) {
                        metaTable = metaForm.getMetaTable(tableKey);
                        metaTableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
                    } else if (dataObject != null) {
                        metaTable = dataObject.getMetaTable(tableKey);
                        metaTableCollection = dataObject.getTableCollection();
                    }
                    for (int i = 0; i < TargetField.size(); i++) {
                        Element targetField = TargetField.get(i);
                        temp = new JSONObject(new LinkedHashMap<>());
                        if (!tableKey.contains(MetaFormNODBProcess.STR_NODBTable_Profix) && Objects.isNull(hashMap.get(targetField.attributeValue(ConstantUtil.DEFINITION) + tableKey))) {
                            //获取当前tableKey的位置
                            int indexOf = metaTableCollection.indexOf(metaTable);
                            String definitionKey = targetField.attributeValue(ConstantUtil.DEFINITION);
                            String fieldCaption = null;
                            MetaColumn metaColumn = DataMapOperXmlUtil.getMetaColumn(definitionKey, tableKey, metaTable, idLookup);
                            if (Objects.isNull(metaColumn)) {
                                MetaTable mainTable = dataObject.getMainTable();
                                if (mainTable != null) {
                                    metaColumn = DataMapOperXmlUtil.getMetaColumn(definitionKey, mainTable.getKey(), mainTable, idLookup);
                                }
                            }
                            if (metaColumn != null) {
                                fieldCaption = metaColumn.getCaption();
                            }
                            //添加类型为公式的Field
                            if ("Formula".equalsIgnoreCase(targetField.attributeValue(ConstantUtil.TYPE)) || "Const".equalsIgnoreCase(targetField.attributeValue(ConstantUtil.TYPE))) {
                                StringBuffer fieldValue = new StringBuffer().append((indexOf + 1)).append("_@_")
                                        .append(definitionKey).append("_@_").append("  ").append("_@_").append(tableKey).append("_@_").append(tgtFormKey1);
                                temp.put(ConstantUtil.DEFINITION, fieldValue);
                                settargetFormJson.put(key + (settargetFormJson.size() + 1), temp);
                            } else {
                                //非公式字段数据处理
                                StringBuffer fieldValue = new StringBuffer().append((indexOf + 1)).append("_@_")
                                        .append(definitionKey).append("_@_").append(StringUtils.isEmpty(fieldCaption) ? "SpecialField" : fieldCaption)
                                        .append("_@_").append(tableKey).append("_@_").append(tgtFormKey1);
                                temp.put(ConstantUtil.DEFINITION, fieldValue);
                                settargetFormJson.put(key + (settargetFormJson.size() + 1), temp);
                            }
                        }
                        //每次添加完一条就在数据中加一条
                        hashMap.put(targetField.attributeValue(ConstantUtil.DEFINITION) + tableKey, targetField.attributeValue(ConstantUtil.DEFINITION));
                    }
                }
            }
        } catch (Throwable throwable) {
            LogSvr.getInstance().error(throwable.getMessage(), throwable);
        }
        JSONObject sourceJson = new JSONObject(new LinkedHashMap<>());
        sourceJson.put("target", settargetFormJson);
        return sourceJson;
    }

    /**
     * 用于前端自动添加路径
     */
    public JSONObject setPaths(Element root) throws DocumentException {
        JSONObject pathJson = new JSONObject(new LinkedHashMap<>());
        JSONObject temp;
        //用于防止ID冲突
        int i = 1;
        //源单和目标表单的Formkey
        String srcFormKey = root.attributeValue(ConstantUtil.SRC_FORM_KEY);
        String tgtFormKey = root.attributeValue(ConstantUtil.TGT_FORM_KEY);
        //判断源单formKey和目标是否相同
        boolean isIdentical = srcFormKey.equalsIgnoreCase(tgtFormKey);
        if (isIdentical) {
            srcFormKey = srcFormKey + "__S";
            tgtFormKey = tgtFormKey + "__T";
        }
        List<Element> elements = root.element(ConstantUtil.SOURCE_TABLE_COLLECTION).elements(ConstantUtil.SOURCE_TABLE);
        String extend = root.attributeValue("Extend");
        boolean isLinkDataMapKey = StringUtils.isNotEmpty(extend);
        //保存公式字段或者常量字段
        HashMap<String, Integer> listHashMap = new HashMap<>();
        int listHashMapi = -1;
        for (Element ele : elements) {
            List<Element> sourceField = ele.elements(ConstantUtil.SOURCE_FIELD);
            for (Element elefield : sourceField) {
                // 先将公式和常量字段过滤出来
                //不为空就是公式字段或者常量字段 或者是名称相同的字段
                if (elefield.attributeValue(ConstantUtil.TYPE) != null && !listHashMap.containsKey(elefield.attributeValue(ConstantUtil.DEFINITION))) {
                    String definition = elefield.attributeValue(ConstantUtil.DEFINITION);
                    listHashMap.put(definition, ++listHashMapi);
                }
                //判断 是否有目标字段,判断是不是普通字段而非公式或者常量字段
                if (elefield.attributeValue(ConstantUtil.TARGET_FIELD_KEY) != null && !listHashMap.containsKey(elefield.attributeValue(ConstantUtil.DEFINITION))) {
                    temp = new JSONObject(new LinkedHashMap<>());
                    String tableKey = DataMapOperXmlUtil.getTableKey(ele);
                    //模仿前端源单字段ID
                    StringBuffer sourceID = new StringBuffer().append("F_").append(srcFormKey)
                            .append(elefield.attributeValue(ConstantUtil.DEFINITION))
                            .append(tableKey);
                    //处理目标字段
                    isConstOrFormula(root, temp, tgtFormKey, ele, elefield);
                    temp.put("sourceEndpoint", sourceID);
                    //判断当前path是不是关注字段
                    if ("Focus".equalsIgnoreCase(elefield.attributeValue("EdgeType"))) {
                        temp.put("EdgeType", "Focus");
                    }
                    if (isLinkDataMapKey) {
                        String key = elefield.attributeValue("Key");
                        String dataMapPathByKey = LoadFileTree.getDataMapPathByKey(extend);
                        Element sourceRoot = getElement(dataMapPathByKey);
                        Element elements11 = (Element) sourceRoot.selectSingleNode("/Map/SourceTableCollection/SourceTable[@Key='" + tableKey + "']/SourceField[@Key='" + key + "']");
                        if (elements11 != null) {
                            temp.put("Key", elefield.attributeValue("Key"));
                        }
                    }
                    //必须成对出现，不允许单条数据传到前端
                    if (temp.size() > 1) {
                        pathJson.put("path" + i, temp);
                    }
                    i++;
                    //处理公式字段和常量字段
                } else if (elefield.attributeValue(ConstantUtil.TARGET_FIELD_KEY) != null &&
                        listHashMap.containsKey(elefield.attributeValue(ConstantUtil.DEFINITION))) {
                    temp = new JSONObject(new LinkedHashMap<>());
                    //模仿前端公式和常量字段ID
                    StringBuffer sourceConstAndFormula = null;
                    //相同字段所用的sourceNumber应该相同
                    String tableKey = DataMapOperXmlUtil.getTableKey(ele);
                    int index = listHashMap.get(elefield.attributeValue(ConstantUtil.DEFINITION));
                    sourceConstAndFormula = new StringBuffer().append("F_")
                            .append(tableKey).append(srcFormKey).append(index + 1);
                    //处理目标字段
                    isConstOrFormula(root, temp, tgtFormKey, ele, elefield);
                    temp.put("sourceEndpoint", sourceConstAndFormula);
                    if ("Focus".equalsIgnoreCase(elefield.attributeValue("EdgeType"))) {
                        temp.put("EdgeType", "Focus");
                    }
                    if (temp.size() > 1) {
                        pathJson.put("path" + i, temp);
                    }
                    i++;
                }
            }
            listHashMap.clear();
        }
        //目标字段到反填字段
        if (root.element(ConstantUtil.FEEDBACK_COLLECTION) != null) {
            targetToFeedback(root, pathJson, i);
        }
        JSONObject setpathJson = new JSONObject(new LinkedHashMap<>());
        setpathJson.put("path", pathJson);
        return setpathJson;
    }

    /**
     * @param root
     * @param pathJson
     * @param i        目标字段到反填字段
     */
    public void targetToFeedback(Element root, JSONObject pathJson, int i) {
        JSONObject temp;
        int numberID = 0;
        //目标表单到反填表单的连线信息
        Element targetTableCollection = root.element(ConstantUtil.TARGET_TABLE_COLLECTION);
        if (targetTableCollection != null) {
            List<Element> targetTable = targetTableCollection.elements(ConstantUtil.TARGET_TABLE);
            for (Element ele : targetTable) {
                List<Element> targetField = ele.elements(ConstantUtil.TARGET_FIELD);
                for (Element targetfield : targetField) {
                    //formKey
                    if ("Formula".equalsIgnoreCase(targetfield.attributeValue(ConstantUtil.TYPE)) || "Const".equalsIgnoreCase(targetfield.attributeValue(ConstantUtil.TYPE))) {
                        numberID++;
                    }
                    List<Element> feedback = targetfield.elements("Feedback");
                    //不为零的话就说明是和反填表单有关联的，然后去拼接目标字段的信息
                    if (feedback.size() != 0) {
                        String tgtDataformKey = root.attributeValue(ConstantUtil.TGT_FORM_KEY);
                        if (tgtDataformKey.equalsIgnoreCase(root.attributeValue(ConstantUtil.SRC_FORM_KEY))) {
                            tgtDataformKey = tgtDataformKey + "__T";
                        }
                        //普通字段和公式字段常量字段不同 要做一个区分
                        //tableKey
                        String tableKey = ele.attributeValue(ConstantUtil.KEY);
                        StringBuffer targetBuffer = null;
                        if (StringUtils.isBlank(targetfield.attributeValue(ConstantUtil.TYPE))) {
                            targetBuffer = new StringBuffer()
                                    .append("F_" + tgtDataformKey)
                                    .append(targetfield.attributeValue(ConstantUtil.DEFINITION))
                                    .append(tableKey);
                        } else if ("Formula".equalsIgnoreCase(targetfield.attributeValue(ConstantUtil.TYPE)) || "Const".equalsIgnoreCase(targetfield.attributeValue(ConstantUtil.TYPE))) {
                            targetBuffer = new StringBuffer()
                                    .append("F_")
                                    .append(tableKey)
                                    .append(tgtDataformKey)
                                    .append(numberID);
                        }
                        //处理反填表单中的字段,反填表单中的字段只有普通字段 不用特殊区分
                        for (Element feed : feedback) {
                            temp = new JSONObject();
                            String feedFormKey = feed.attributeValue(ConstantUtil.FEED_FORM_KEY);
                            if (feedFormKey.equalsIgnoreCase(root.attributeValue(ConstantUtil.SRC_FORM_KEY)) || feedFormKey.equalsIgnoreCase(root.attributeValue(ConstantUtil.TGT_FORM_KEY))) {
                                feedFormKey = feedFormKey + "__Feed";
                            }
                            StringBuffer feedstr = new StringBuffer()
                                    .append("F_" + feedFormKey)
                                    .append(feed.attributeValue(ConstantUtil.FIELD_KEY))
                                    .append(feed.attributeValue(ConstantUtil.TABLE_KEY));
                            temp.put("FeedEndpoint", feedstr);
                            temp.put("TgEndpoint", targetBuffer);
                            //必须成对出现，不允许单条数据传到前端
                            if (temp.size() > 1) {
                                pathJson.put("path" + i, temp);
                            }
                            i++;
                        }
                    }
                }
            }
        }
    }

    /**
     * 判断目标字段是不是普通字段
     *
     * @param root             节点
     * @param temp             jsonObject
     * @param tgtDataObjectKey 目标表单标识
     * @param ele              表节点
     * @param elefield         字段节点
     * @return
     */
    public void isConstOrFormula(Element root, JSONObject temp, String tgtDataObjectKey, Element ele, Element elefield) {
        //去判断目标字段是不是普通字段
        List<Element> elementList = root.element(ConstantUtil.TARGET_TABLE_COLLECTION).elements(ConstantUtil.TARGET_TABLE);
        ArrayList<String> list = new ArrayList<>();
        HashMap<String, Integer> listHashMap = new HashMap<>();
        int listHashMapi = -1;
        String targetTableKey = elefield.attributeValue(ConstantUtil.TARGET_TABLE_KEY);
        for (Element targetele : elementList) {
            //当为空的时候说明目标字段是源表绑定的目标表标识里面的字段
            if (StringUtils.isBlank(targetTableKey)) {
                targetTableKey = ele.attributeValue(ConstantUtil.TARGET_TABLE_KEY);
            }
            String tableKey = DataMapOperXmlUtil.getTableKey(targetele);
            if (tableKey.equalsIgnoreCase(targetTableKey)) {
                List<Element> targetField = targetele.elements(ConstantUtil.TARGET_FIELD);
                for (Element targetfield : targetField) {
                    if (targetfield.attributeValue(ConstantUtil.TYPE) != null) {
                        String fieldValue = DataMapOperXmlUtil.getFieldValue(targetfield);
                        listHashMap.put(fieldValue, ++listHashMapi);
                        list.add(fieldValue);
                    }
                    //获取字段值
                    String fieldValue = DataMapOperXmlUtil.getFieldValue(targetfield);
                    if (fieldValue.equalsIgnoreCase(elefield.attributeValue(ConstantUtil.TARGET_FIELD_KEY))) {
                        if (("Const".equalsIgnoreCase(targetfield.attributeValue(ConstantUtil.TYPE))
                                || "Formula".equalsIgnoreCase(targetfield.attributeValue(ConstantUtil.TYPE)))) {
                            int index = listHashMap.get(fieldValue);
                            StringBuffer targetID = new StringBuffer().append("F_")
                                    .append(targetTableKey).append(tgtDataObjectKey).append(index + 1);
                            temp.put("targetEndpoint", targetID);
                        } else if (StringUtils.isBlank(targetfield.attributeValue(ConstantUtil.TYPE))) {
                            //模仿非公式和常量字段前端目标字段ID
                            StringBuffer targetID = new StringBuffer().append("F_").append(tgtDataObjectKey)
                                    .append(elefield.attributeValue(ConstantUtil.TARGET_FIELD_KEY))
                                    .append(targetTableKey);
                            temp.put("targetEndpoint", targetID);
                        }
                    }
                }
            } else {
                List<Element> targetField = targetele.elements(ConstantUtil.TARGET_FIELD);
                for (Element targetfield : targetField) {
                    if (targetfield.attributeValue(ConstantUtil.TYPE) != null) {
                        String fieldValue = DataMapOperXmlUtil.getFieldValue(targetfield);
                        listHashMap.put(fieldValue, ++listHashMapi);
                        list.add(fieldValue);
                    }
                }
            }
        }
    }

    /**
     * 反填表单数据获取
     */
    public JSONObject setFeedback(Element root) throws Throwable {
        JSONObject feedbackJson = new JSONObject(new LinkedHashMap<>());
        JSONObject temp;
        int b = 1;
        Element feedbackCollection = root.element(ConstantUtil.FEEDBACK_COLLECTION);
        if (feedbackCollection != null) {
            List<Element> feedbackObject = feedbackCollection.elements(ConstantUtil.FEEDBACK_OBJECT);
            for (Element ele : feedbackObject) {
                List<Element> feedbackTable = ele.elements(ConstantUtil.FEEDBACK_TABLE);
                if (feedbackTable.size() != 0) {
                    for (Element feedback : feedbackTable) {
                        List<Element> feedbackField = feedback.elements("FeedbackField");
                        for (Element feedbackfield : feedbackField) {
                            //获取Caption
                            String feedFormKey = ele.attributeValue(ConstantUtil.FORM_KEY);
                            if (StringUtils.isEmpty(feedFormKey)) {
                                throw new Throwable("请在数据映射源代码中的FeedbackObject节点中新增FormKey属性例如:<FeedbackObject " +
                                        "Height=\"60\" ObjectKey=\"Material\" FormKey=\"V_Material\" Width=\"256\" X=\"723\" Y=\"106\">");
                            }
                            String tableKey = feedback.attributeValue(ConstantUtil.TABLE_KEY);
                            MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(feedFormKey);
                            IDLookup idLookup = IDLookup.getIDLookup(metaForm);
                            MetaTable metaTable = metaForm.getMetaTable(tableKey);
                            int indexOf = metaForm.getDataSource().getDataObject().getTableCollection().indexOf(metaTable);
                            MetaColumn metaColumn = DataMapOperXmlUtil.getMetaColumn(feedbackfield.attributeValue(ConstantUtil.FIELD_KEY), tableKey, metaTable, idLookup);
                            if (feedFormKey.equalsIgnoreCase(root.attributeValue(ConstantUtil.SRC_FORM_KEY))
                                    || feedFormKey.equalsIgnoreCase(root.attributeValue(ConstantUtil.TGT_FORM_KEY))) {
                                feedFormKey = feedFormKey + "__Feed";
                            }
                            StringBuffer str = new StringBuffer().append(indexOf + 1).append("_@_")
                                    .append(feedbackfield.attributeValue(ConstantUtil.FIELD_KEY)).append("_@_")
                                    .append(Objects.isNull(metaColumn) ? "SpecialField" : metaColumn.getCaption()).append("_@_")
                                    .append(feedback.attributeValue(ConstantUtil.TABLE_KEY)).append("_@_").append(feedFormKey);
                            temp = new JSONObject();
                            temp.put("FeedBack", str);
                            feedbackJson.put("FeedBack" + b, temp);
                            b++;

                        }
                    }
                } else {
                    //获取Caption
                    String feedformKey = ele.attributeValue(ConstantUtil.FORM_KEY);
                    StringBuffer str = new StringBuffer().append(feedformKey);
                    temp = new JSONObject();
                    temp.put("FeedBack", str);
                    feedbackJson.put("FeedBack" + b, temp);
                    b++;
                }
            }
        }
        JSONObject setFeedbackJson = new JSONObject(new LinkedHashMap<>());
        setFeedbackJson.put("feedBack", feedbackJson);
        return setFeedbackJson;
    }

    public List<String> resultSet() {
        return undoSet;
    }

    public boolean existDataMapVest(String extend, IMetaFactory globalInstance) throws Throwable{
        List<ERPMetaMap> metaDataMapList = globalInstance.getMetaCustomObjects(ERPMetaMap.class);
        for (ERPMetaMap erpMetaMap : metaDataMapList) {
            //extend字段为空，说明为普通数据映射
            if (StringUtils.isEmpty(extend)) {
                break;
            }
            if (StringUtils.isEmpty(erpMetaMap.getExtend())) {
                continue;
            }
            if (erpMetaMap.getExtend().equals(extend.split(" ")[0])) {
                return true;
            }
        }
        return false;
    }

    public String createDataMapVestXml(String caption, String key, String extend, String srcDataObjectKey,
                                       String sourceFormKey, String targetDataObjectKey, String targetFormKey) throws Throwable{

        StringBuilder sb = new StringBuilder();
        String filePath = LoadFileTree.getDataMapPathByKey(extend.split(" ")[0]);
        SAXReader reader = new SAXReader();
        // 加载文档
        Document document = reader.read(new File(filePath));
        // 获取根节点
//        Element root = document.getRootElement();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n");
        sb.append("<Map Caption=\"" + caption + "\" Key=\"" + key + "\"" );
        sb.append(" Extend=\"" + extend.split(" ")[0] + "\"" );
        sb.append(" SrcFormKey=\"" + sourceFormKey  + "\" TgtFormKey=\"" + targetFormKey + "\" " );
        /* " "\" SrcDataObjectKey=\"" + srcDataObjectKey + "\" " );
        sb.append(" SrcFormKey=\"" + sourceFormKey + "\" TgtDataObjectKey=\"" + targetDataObjectKey + "\" TgtFormKey=\"" + targetFormKey + "\" " );
        if(StringUtils.isNotEmpty(root.attributeValue(ERPMetaMapConstants.ALLOW_SURPLUS))){
            sb.append(" " + ERPMetaMapConstants.ALLOW_SURPLUS + "=\"" +  root.attributeValue(ERPMetaMapConstants.ALLOW_SURPLUS) + "\" ");
        }
        if(StringUtils.isNotEmpty(root.attributeValue(ERPMetaMapConstants.REMAINDER_PUSH_VALUE))){
            sb.append(" " + ERPMetaMapConstants.REMAINDER_PUSH_VALUE + "=\"" +  root.attributeValue(ERPMetaMapConstants.REMAINDER_PUSH_VALUE) + "\" ");
        }
        if(StringUtils.isNotEmpty(root.attributeValue(ERPMetaMapConstants.ALLOW_REMAINDER_PUSH))){
            sb.append(" " + ERPMetaMapConstants.ALLOW_REMAINDER_PUSH + "=\"" +  root.attributeValue(ERPMetaMapConstants.ALLOW_REMAINDER_PUSH) + "\" ");
        }*/
        sb.append(">\n");
        sb.append("    <SourceTableCollection Height=\"60\" Width=\"296\" X=\"30\" Y=\"80\"/>\n" );
        sb.append("    <TargetTableCollection Height=\"60\" Width=\"296\" X=\"457\" Y=\"80\"/>\n" );
       /* if(root.element(ERPMetaMapConstants.MAP_POSTPROCESS) != null){
            sb.append("    <" + ERPMetaMapConstants.MAP_POSTPROCESS + ">\n");
            List<Node> content = root.element(ERPMetaMapConstants.MAP_POSTPROCESS).content();
            String text = getCDATA(content);
            sb.append("        <![CDATA[").append(text).append("]]>\n");
            sb.append("    </" + ERPMetaMapConstants.MAP_POSTPROCESS + ">\n");
        }*/
        sb.append("</Map>");
        return sb.toString();
    }
}
