package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.*;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.constant.ProPertyConstant;
import com.bokesoft.yes.design.io.IOMetaObject;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.mergesingle.util.QuoteGridFiledOperUtil;
import com.bokesoft.yes.design.metaobjecttype.MetaObjectTypeDefine;
import com.bokesoft.yes.design.process.MetaItemFilterProcess;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.design.xml.XmlParser;
import com.bokesoft.yes.design.xml.node.*;
import com.bokesoft.yes.design.xml.parse.Element;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.helper.MetaFormHelper;
import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.MetaFormLoad;
import com.bokesoft.yes.struct.abstractdatatable.RowState;
import com.bokesoft.yigo.common.def.*;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.KeyPairCompositeObject;
import com.bokesoft.yigo.meta.common.*;
import com.bokesoft.yigo.meta.commondef.MetaOperation;
import com.bokesoft.yigo.meta.commondef.MetaOperationCollection;
import com.bokesoft.yigo.meta.commondef.MetaStatus;
import com.bokesoft.yigo.meta.commondef.MetaStatusCollection;
import com.bokesoft.yigo.meta.dataelement.MetaDataElement;
import com.bokesoft.yigo.meta.datamigration.DMPeriodGranularityType;
import com.bokesoft.yigo.meta.dataobject.*;
import com.bokesoft.yigo.meta.domain.MetaDomain;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaEmbed;
import com.bokesoft.yigo.meta.form.component.bar.MetaToolBar;
import com.bokesoft.yigo.meta.form.component.container.MetaSubDetail;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import com.bokesoft.yigo.meta.form.component.control.MetaDefaultItem;
import com.bokesoft.yigo.meta.form.component.control.MetaRadioButton;
import com.bokesoft.yigo.meta.form.component.control.MetaTabGroup;
import com.bokesoft.yigo.meta.form.component.control.MetaTabItemCollection;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaItemFilter;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaListBoxItemCollection;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaQueryDef;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableView;
import com.bokesoft.yigo.meta.form.component.grid.*;
import com.bokesoft.yigo.meta.form.component.panel.*;
import com.bokesoft.yigo.meta.form.component.panel.flexgridpanel.MetaFlexGridLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.*;
import com.bokesoft.yigo.meta.form.component.view.MetaView;
import com.bokesoft.yigo.meta.form.component.view.MetaViewCollection;
import com.bokesoft.yigo.meta.report.ReportCellGroupType;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

import javax.validation.constraints.NotNull;
import java.io.File;
import java.util.*;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;


/**
 * 差异的XML文件处理
 */
public class XmlDiffProcessor {
    public static final XmlDiffProcessor instance = new XmlDiffProcessor();
    //用于获取在添加subdetail的时候用户选择的默认绑定组件MetaFormDiffProcessor类会用到
    public static String subDetailBind = "";
    private static final List<Map<String, String>> DICT_HEAD_TABLE_COLUMN_LIST = new ArrayList<>();
    public static final List<Map<String, String>> PRIMARY_TABLE_COLUMN_LIST = new ArrayList<>();

    static {
        initDictHeadTableColumnList();
        initPrimaryTableColumnList();
    }

    private static void initDictHeadTableColumnList() {
        Map<String, String> codeColumnMap = new HashMap<>();
        DICT_HEAD_TABLE_COLUMN_LIST.add(codeColumnMap);
        codeColumnMap.put(ConstantUtil.KEY, "Code");
        codeColumnMap.put(ConstantUtil.CAPTION, "代码");
        codeColumnMap.put(ConstantUtil.DATA_TYPE, "Varchar");
        codeColumnMap.put(ConstantUtil.LENGTH, "50");

        Map<String, String> nameColumnMap = new HashMap<>();
        DICT_HEAD_TABLE_COLUMN_LIST.add(nameColumnMap);
        nameColumnMap.put(ConstantUtil.KEY, ConstantUtil.NAME);
        nameColumnMap.put(ConstantUtil.CAPTION, "名称");
        nameColumnMap.put(ConstantUtil.DATA_TYPE, "Varchar");
        nameColumnMap.put(ConstantUtil.LENGTH, "100");

        Map<String, String> enableColumnMap = new HashMap<>();
        DICT_HEAD_TABLE_COLUMN_LIST.add(enableColumnMap);
        enableColumnMap.put(ConstantUtil.KEY, ConstantUtil.ENABLE);
        enableColumnMap.put(ConstantUtil.CAPTION, "启用标记");
        enableColumnMap.put(ConstantUtil.DATA_TYPE, "Integer");

        Map<String, String> parentIDColumnMap = new HashMap<>();
        DICT_HEAD_TABLE_COLUMN_LIST.add(parentIDColumnMap);
        parentIDColumnMap.put(ConstantUtil.KEY, "ParentID");
        parentIDColumnMap.put(ConstantUtil.CAPTION, "父节点");
        parentIDColumnMap.put(ConstantUtil.DATA_TYPE, "Long");

        Map<String, String> nodeTypeColumnMap = new HashMap<>();
        DICT_HEAD_TABLE_COLUMN_LIST.add(nodeTypeColumnMap);
        nodeTypeColumnMap.put(ConstantUtil.KEY, "NodeType");
        nodeTypeColumnMap.put(ConstantUtil.CAPTION, "节点类型");
        nodeTypeColumnMap.put(ConstantUtil.DATA_TYPE, "Integer");

        Map<String, String> tLeftColumnMap = new HashMap<>();
        DICT_HEAD_TABLE_COLUMN_LIST.add(tLeftColumnMap);
        tLeftColumnMap.put(ConstantUtil.KEY, "TLeft");
        tLeftColumnMap.put(ConstantUtil.CAPTION, "TLeft");
        tLeftColumnMap.put(ConstantUtil.DATA_TYPE, "Integer");

        Map<String, String> tRightColumnMap = new HashMap<>();
        DICT_HEAD_TABLE_COLUMN_LIST.add(tRightColumnMap);
        tRightColumnMap.put(ConstantUtil.KEY, "TRight");
        tRightColumnMap.put(ConstantUtil.CAPTION, "TRight");
        tRightColumnMap.put(ConstantUtil.DATA_TYPE, "Integer");
    }

    private static void initPrimaryTableColumnList() {
        Map<String, String> documentNumberColumnMap = new HashMap<>();
        PRIMARY_TABLE_COLUMN_LIST.add(documentNumberColumnMap);
        documentNumberColumnMap.put(ConstantUtil.KEY, ConstantUtil.DOCUMENT_NUMBER);
        documentNumberColumnMap.put(ConstantUtil.CAPTION, ConstantUtil.STR_DOCUMENT_NUMBER);
        documentNumberColumnMap.put(ConstantUtil.DataElementKey, ConstantUtil.DOCUMENT_NUMBER);

        Map<String, String> statusColumnMap = new HashMap<>();
        PRIMARY_TABLE_COLUMN_LIST.add(statusColumnMap);
        statusColumnMap.put(ConstantUtil.KEY, ConstantUtil.STATUS);
        statusColumnMap.put(ConstantUtil.CAPTION, ConstantUtil.STR_STATUS);
        statusColumnMap.put(ConstantUtil.DataElementKey, ConstantUtil.STATUS);
        statusColumnMap.put(ConstantUtil.DefaultValue, "-1");

        Map<String, String> documentDateColumnMap = new HashMap<>();
        PRIMARY_TABLE_COLUMN_LIST.add(documentDateColumnMap);
        documentDateColumnMap.put(ConstantUtil.KEY, ConstantUtil.DOCUMENT_DATE);
        documentDateColumnMap.put(ConstantUtil.CAPTION, ConstantUtil.STR_BILL_DATE);
        documentDateColumnMap.put(ConstantUtil.DataElementKey, ConstantUtil.DOCUMENT_DATE);

        Map<String, String> creatorColumnMap = new HashMap<>();
        PRIMARY_TABLE_COLUMN_LIST.add(creatorColumnMap);
        creatorColumnMap.put(ConstantUtil.KEY, ConstantUtil.CREATOR);
        creatorColumnMap.put(ConstantUtil.CAPTION, ConstantUtil.STR_CREATOR);
        creatorColumnMap.put(ConstantUtil.DataElementKey, ConstantUtil.CREATOR);

        Map<String, String> createTimeColumnMap = new HashMap<>();
        PRIMARY_TABLE_COLUMN_LIST.add(createTimeColumnMap);
        createTimeColumnMap.put(ConstantUtil.KEY, ConstantUtil.CREATE_TIME);
        createTimeColumnMap.put(ConstantUtil.CAPTION, ConstantUtil.STR_CREATE_TIME);
        createTimeColumnMap.put(ConstantUtil.DataElementKey, ConstantUtil.CREATE_TIME);

        Map<String, String> modifierColumnMap = new HashMap<>();
        PRIMARY_TABLE_COLUMN_LIST.add(modifierColumnMap);
        modifierColumnMap.put(ConstantUtil.KEY, ConstantUtil.MODIFIER);
        modifierColumnMap.put(ConstantUtil.CAPTION, ConstantUtil.STR_MODIFIER);
        modifierColumnMap.put(ConstantUtil.DataElementKey, ConstantUtil.MODIFIER);

        Map<String, String> modifyTimeColumnMap = new HashMap<>();
        PRIMARY_TABLE_COLUMN_LIST.add(modifyTimeColumnMap);
        modifyTimeColumnMap.put(ConstantUtil.KEY, ConstantUtil.MODIFY_TIME);
        modifyTimeColumnMap.put(ConstantUtil.CAPTION, ConstantUtil.STR_MODIFY_TIME);
        modifyTimeColumnMap.put(ConstantUtil.DataElementKey, ConstantUtil.MODIFY_TIME);

        Map<String, String> foreignNameColumnMap = new HashMap<>();
        PRIMARY_TABLE_COLUMN_LIST.add(foreignNameColumnMap);
        foreignNameColumnMap.put(ConstantUtil.KEY, ConstantUtil.CLIENT_ID);
        foreignNameColumnMap.put(ConstantUtil.CAPTION, ConstantUtil.STR_CLIENT_ID);
        foreignNameColumnMap.put(ConstantUtil.DataElementKey, ConstantUtil.CLIENT_ID);

        Map<String, String> notesColumnMap = new HashMap<>();
        PRIMARY_TABLE_COLUMN_LIST.add(notesColumnMap);
        notesColumnMap.put(ConstantUtil.KEY, ConstantUtil.NOTES);
        notesColumnMap.put(ConstantUtil.CAPTION, ConstantUtil.STR_NOTES);
        notesColumnMap.put(ConstantUtil.DataElementKey, ConstantUtil.NOTES);
    }

    /**
     * 将配置属性差异转化为XML差异
     */
    public int processDiff(List<Diff> diffs, Document document) throws Throwable {
        int anInt = 1;
        Diff preDiff = null;
        for (Diff diff : diffs) {
            if (!diff.isPropertyDiff()) {
                continue;
            }
            if(diff.isMultyMove){
                if(preDiff != null){
                    String midFilePath=XmlFileProcessor.mergePreDiff(preDiff,diff);
                    XmlTreeWithPath xmlTreeWithPath =new XmlTreeWithPath(diff.getXmlTree().orgFilePath, diff.getXmlTree().tmpFilePath, XmlTreeWithPath.parseFilePath(midFilePath).xmlTree);
                    diff.setXmlTree(xmlTreeWithPath);
                }
                if(diff.isGridColumnDrag()){
                    mergeColumnDragDiff(diff);
                }else{
                    mergeDiff(diff.getMetaForm(), diff, document);
                }
                preDiff = diff;
                continue;
            }
            if (diff.isGridColumnDrag()) { // 列拖拽
                mergeColumnDragDiff(diff);
                continue;
            }
            if(diff.isMultyDelete){
                if(preDiff != null){
                    String midFilePath=XmlFileProcessor.mergePreDiff(preDiff,diff);
                    XmlTreeWithPath xmlTreeWithPath =new XmlTreeWithPath(diff.getXmlTree().orgFilePath, diff.getXmlTree().tmpFilePath, XmlTreeWithPath.parseFilePath(midFilePath).xmlTree);
                    diff.setXmlTree(xmlTreeWithPath);
                }
                mergeDeleteDiff(diff);
                preDiff = diff;
                continue;
            }
            if (diff.isDelete) { //删除
                mergeDeleteDiff(diff);
                continue;
            }
            if (StringUtils.isNotBlank(diff.caption) || diff.isButtonQuote) {
                final MetaForm metaForm = diff.getMetaForm();
                AbstractMetaObject parentComponent = metaForm.getAllUIComponents().get(diff.parentKey);
                if (diff.getControlType() == ControlType.PANEL || StringUtils.equalsIgnoreCase(diff.getMetaObjectType().name, "GridFieldRow")) {
                    if (parentComponent instanceof MetaGrid) {
                        String parentXmlTreeKey = "Grid@" + diff.parentKey;
                        TagNode parentNode = diff.getXmlTree().xmlTree.getTagNode(parentXmlTreeKey);
                        mergeGridRowNewDiff((MetaGrid) parentComponent, parentNode, diff);
                        continue;
                    }
                    anInt = mergeNewDiff(null, null, document, diff, diffs.indexOf(diff));
                    continue;
                }
                if (Objects.isNull(parentComponent)) {
                    for(MetaComponent metaComponent : metaForm.getAllComponents()){
                        if(metaComponent.getKey().equals(diff.parentKey)){
                            parentComponent = metaComponent;
                            break;
                        }
                    }
                }

                if (Objects.isNull(parentComponent)) {
                    if (StringUtils.equalsIgnoreCase(diff.getReserveOne(), "AddSonRow")) {
                        String parentXmlTreeKey = "GridColumn@" + diff.parentKey;
                        TagNode parentNode = diff.getXmlTree().xmlTree.getTagNode(parentXmlTreeKey);
                        mergeSonGridNewDiff(parentNode, diff);
                        continue;
                    }
                    continue;
                }

                if (parentComponent instanceof MetaComponent) {
                    MetaComponent parentComp = (MetaComponent) parentComponent;
                    String parentXmlTreeKey = ControlType.toString(parentComp.getControlType()) + "@" + diff.parentKey;
                    if(preDiff != null){
                        String midFilePath=XmlFileProcessor.mergePreDiff(preDiff,diff);
                        XmlTreeWithPath xmlTreeWithPath =new XmlTreeWithPath(diff.getXmlTree().orgFilePath, diff.getXmlTree().tmpFilePath, XmlTreeWithPath.parseFilePath(midFilePath).xmlTree);
                        diff.setXmlTree(xmlTreeWithPath);
                    }
                    TagNode parentNode = diff.getXmlTree().xmlTree.getTagNode(parentXmlTreeKey);
                    anInt = mergeNewDiff(parentComp, parentNode, document, diff, diffs.indexOf(diff));
                    preDiff = diff;
                    continue;
                }
                if (parentComponent instanceof MetaGridCell) {
                    String parentXmlTreeKey = "GridColumn@" + diff.parentKey;
                    TagNode parentNode = diff.getXmlTree().xmlTree.getTagNode(parentXmlTreeKey);
                    mergeSonGridNewDiff(parentNode, diff);
                    continue;
                }
                continue;
            }

            mergeDiff(diff.getMetaForm(), diff, document);
        }
        return anInt;
    }

    private static void mergeDeleteDiff(Diff diff) throws Throwable {
        MetaForm metaForm = diff.getMetaForm();
        MetaObjectType objectType = diff.getMetaObjectType();
        String key = diff.getKey();
        TagNode parentNode = null;
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        IDLookup idLookup1 = IDLookup.getIDLookup(metaForm);
        if (objectType != MetaObjectType.operationCollection && objectType != MetaObjectType.operation) {
            try {
                parentNode = examinationTagNode(metaForm, diff, key, xmlTree.xmlTree, idLookup1).getParent();
            } catch (Exception e) {
                String parentTagName = IDLookup.getIDLookup(metaForm).getTagNameByKey(diff.parentKey);
                String parentXmlTreeKey = parentTagName + "@" + diff.parentKey;
                parentNode = diff.getXmlTree().xmlTree.getTagNode(parentXmlTreeKey);
            }
        }
        if (objectType == MetaObjectType.gridField || objectType == MetaObjectType.field || objectType == MetaObjectType.panel || objectType == MetaObjectType.grid) {
            IDLookup idLookup = IDLookup.getIDLookup(metaForm);
            String parentTagName;

            if (metaForm.getFormType() != FormType.Template) {
                parentTagName = idLookup.getTagNameByKey(diff.parentKey);
                String parentXmlTreeKey = parentTagName + "@" + diff.parentKey;
                parentNode = diff.getXmlTree().xmlTree.getTagNode(parentXmlTreeKey);

                if(parentTagName != null && parentTagName.equals("TableRow")){
                    throw new Throwable("表格视图行根组件不允许删除");
                }
            }

            List<TagNode> subDetail = diff.getXmlTree().xmlTree.getRoot().findNodesByTagName("SubDetail");
            //在删除表格之前进行判断是否绑定了子明细
            if (objectType == MetaObjectType.grid) {
                for (TagNode tagNode : subDetail) {
                    String bindingGridKey = tagNode.getAttributes().get("BindingGridKey");
                    String subDetailCom = tagNode.getAttributes().get(ConstantUtil.KEY);
                    if (key.equals(bindingGridKey)) {
                        throw new Throwable("该表格被" + subDetailCom + "绑定了请先解除绑定才能删除");
                    }
                }
            }
            List<AbstractNode> children = parentNode.getChildren();
            TagNode curNode;
            try {
                curNode = examinationTagNode(metaForm, diff, key, xmlTree.xmlTree, idLookup);
            } catch (Exception e) {
                curNode = diff.getXmlTree().xmlTree.getTagNode(ConstantUtil.GRID_COLUMN + "@" + key);
            }
            if (Objects.isNull(curNode)) {
                if (StringUtils.equals(parentNode.getTagName(), "Grid")) {
                    for (AbstractNode child : children) {
                        if (child instanceof TagNode) {
                            if ("ListView".equalsIgnoreCase(((TagNode) child).getTagName())) {
                                curNode = (TagNode) child;
                            } else if ("DictView".equalsIgnoreCase(((TagNode) child).getTagName())) {
                                curNode = (TagNode) child;
                            }
                        }
                    }
                } else {
                    throw new Throwable("原表单控件不支持删除!");
                }
            }
            if (ConstantUtil.SPLIT_PANEL.equalsIgnoreCase(parentNode.getTagName())) {//SplitPanel组件中的子组件删除的时候同时要删除对应的SplitSize节点
                List<AbstractNode> c = parentNode.getChildren();
                int number = 0;
                int deletenumber = 0;
                for (AbstractNode abstractNode : c) {
                    if (abstractNode instanceof TagNode) {
                        if (!"SplitSize".equalsIgnoreCase(((TagNode) abstractNode).getTagName())) {
                            if (key.equalsIgnoreCase(((TagNode) abstractNode).getAttributes().get(ConstantUtil.KEY))) {
                                break;//得到要删除组件在SplitPanel下的顺序位置
                            } else {
                                List<AbstractNode> nodes = ((TagNode) abstractNode).getChildren();
                                if (nodes.size() > 1 && key.equalsIgnoreCase(((TagNode) (nodes.get(1))).getAttributes().get(ConstantUtil.KEY))) {
                                    //因为删除子明细时上面的条件无法满足
                                    break;
                                }
                                number += 1;
                            }
                        }
                    }
                }
                for (int i = 0; i < c.size(); i++) {
                    if ((c.get(i)) instanceof TagNode) {
                        if ("SplitSize".equalsIgnoreCase(((TagNode) (c.get(i))).getTagName())) {
                            if (number == deletenumber) {
                                c.remove(i);//删除对应序列位置的SplitSize节点
                            }
                            deletenumber += 1;
                        }
                    }
                }
            }

            if (Objects.isNull(curNode)) {
                throw new Throwable("当前选中字段在xml中不存在,操作无效");
            }

            boolean isMoreThanOne = true;
            //判断当前删除的表格列是否是最后一个
            if (objectType == MetaObjectType.gridField) {

            }
            if (objectType == MetaObjectType.gridField) {
                String coluTreeKey = ConstantUtil.GRID_COLUMN + "@" + key;
                TagNode coluNode = xmlTree.xmlTree.getTagNode(coluTreeKey);//获取GridColumn
                if (Objects.isNull(coluNode)) {
                    MetaGridColumn gridMetaColumnByKey = IDLookup.reloadIDLookup(metaForm).getGridMetaColumnByKey(diff.getKey());
                    String oldKey = Objects.isNull(gridMetaColumnByKey) ? diff.getKey() : gridMetaColumnByKey.getMetaKey();
                    String s = ConstantUtil.GRID_COLUMN + "@" + oldKey;
                    coluNode = xmlTree.xmlTree.getTagNode(s);
                }
                if (!ConstantUtil.GRID.equalsIgnoreCase(parentNode.getTagName())) {
                    parentNode = xmlTree.xmlTree.getTagNode(ConstantUtil.GRID + "@" + diff.parentKey);
                    children = parentNode.getChildren();
                }
                String cellTreeKey = ConstantUtil.GRID_CELL + "@" + key;
                TagNode cellNode = xmlTree.xmlTree.getTagNode(cellTreeKey);
                if (Objects.isNull(cellNode)) {//有可能GridCellKey和GridColumnKey不一样
                    StringHashMap<MetaGridColumn> columnInfo_oldKey = idLookup.getAllFieldKey2MetaGridColumnInfo_oldKey();
                    MetaGridColumn metaGridColumn = columnInfo_oldKey.get(key);
                    if (metaGridColumn != null) {
                        String cellKey = metaGridColumn.getKey();
                        cellTreeKey = ConstantUtil.GRID_CELL + "@" + cellKey;
                        cellNode = xmlTree.xmlTree.getTagNode(cellTreeKey);
                    }
                }

                if (Objects.isNull(cellNode)) {
                    String extend = diff.getMetaForm().getExtend();
                    if (StringUtils.isNotEmpty(extend)) {
                        throw new Throwable("马甲中的扩展字段不允许删除");
                    }
                }
                MetaGrid metaGrid = (MetaGrid) metaForm.componentByKey(diff.parentKey);
                if (diff.getVestXmlTree()!=null){
                    Map<String, Integer> leafIndexMap = metaGrid.getLeafIndexMap();
                    deleteGridCell(leafIndexMap, key, coluNode, metaGrid, parentNode);
                } else {
                    if (metaGrid.getKey().equals(diff.parentKey)) {
                        if (StringUtils.isEmpty(metaForm.getExtend())) {
                            isMoreThanOne = metaGrid.getColumnCollection().size() > 1;
                        } else {// 马甲表单
                            int count = 0; // 马甲grid中没被删除的column
                            for (MetaGridColumn metaGridColumn : metaGrid.getColumnCollection()) {
                                if (!metaGridColumn.isVestDeleted()) {
                                    count++;
                                }
                            }
                            isMoreThanOne = count > 1;
                        }
                    }
                    if (isMoreThanOne) {

                         coluTreeKey = ConstantUtil.GRID_COLUMN + "@" + key;
                        TagNode columnNode = xmlTree.xmlTree.getTagNode(ConstantUtil.COLUMN + "@" + key);
                        //排除没有column的组件

                        if (!ConstantUtil.GRID.equalsIgnoreCase(parentNode.getTagName())) {
                            parentNode = xmlTree.xmlTree.getTagNode(ConstantUtil.GRID + "@" + diff.parentKey);
                            children = parentNode.getChildren();
                        }
                        boolean isOnly = false;
                        boolean hasSon = false;
                        boolean hasConfigure;
                        int startIndex = 0;
                        int endIndex = 0;
                        int index = 0;
                        TagNode columnCollection = parentNode.findFirstTagNodeByTagName(ConstantUtil.GRID_COLUMN_COLLECTION);
                        TagNode nodeByTagName = coluNode.findFirstTagNodeByTagName(ConstantUtil.GRID_COLUMN_COLLECTION);
                        if (nodeByTagName != null) {
                            endIndex = statisticsRowIndex(columnCollection, diff.getKey(), coluNode) - 1;  //需要删除的最后一个GridRow的位置
                            startIndex = endIndex - statisticsLength(nodeByTagName) + 1;
                            hasSon = true;
                        } else {
                            index = statisticsRowIndex(columnCollection, diff.getKey(), coluNode) - 1;
                        }
                        for (AbstractNode abstractNode : children) {
                            if (abstractNode instanceof TagNode) {
                                String tagName = ((TagNode) abstractNode).getTagName();
                                if (ConstantUtil.GRID_COLUMN_COLLECTION.equals(tagName)) {
                                    hasConfigure = checkPublicConfigure(diff, coluTreeKey);
                                    if (!hasConfigure) {
                                        throw new Exception("表格列" + coluTreeKey + "被其他配置引用，请先清除配置在进行删除");
                                    }
                                    List<AbstractNode> columns = coluNode.getParent().getChildren();
                                    if (coluNode.getParent().getChildrenByTagName(ConstantUtil.GRID_COLUMN).size() == 1) {
                                        if (StringUtils.isNotEmpty(metaForm.getExtend())) {
                                            columnCollection.getChildren().remove(coluNode.getParent().getParent());
                                        } else {
                                            coluNode.getParent().getParent().deleteChildByTagName(ConstantUtil.GRID_COLUMN_COLLECTION);
                                            isOnly = true;
                                        }
                                    } else {
                                        columns.remove(coluNode);
                                    }
                                } else if (ConstantUtil.GRID_ROW_COLLECTION.equals(tagName)) {
                                    List<TagNode> gridRows = ((TagNode) abstractNode).findNodesByTagName(ConstantUtil.GRID_ROW);
                                    for (TagNode gridRow : gridRows) {
                                        if (gridRow != null) {
                                            List<AbstractNode> rows = gridRow.getChildren();
                                            List<AbstractNode> nodeList = new ArrayList<>();
                                            if (!isOnly) {
                                                if (hasSon) {
                                                    for (int i = startIndex; i <= endIndex; i++) {
                                                        AbstractNode node = rows.get(i * 2 + 1);
                                                        nodeList.add(node);
                                                    }
                                                    for (AbstractNode node : nodeList) {
                                                        hasConfigure = checkPublicConfigure(diff, ((TagNode) node).getAttributes().get(ConstantUtil.KEY));
                                                        if (!hasConfigure) {
                                                            throw new Exception("单元格" + ((TagNode) node).getAttributes().get(ConstantUtil.KEY) + "被其他配置引用，请先清除配置在进行删除");
                                                        }
                                                        rows.remove(node);
                                                    }
                                                } else {
                                                    TagNode node = (TagNode) rows.get(index * 2 + 1);
                                                    hasConfigure = checkPublicConfigure(diff, node.getAttributes().get(ConstantUtil.KEY));
                                                    if (!hasConfigure) {
                                                        throw new Exception("单元格" + node.getAttributes().get(ConstantUtil.KEY) + "被其他配置引用，请先清除配置在进行删除");
                                                    }
                                                    rows.remove(node);
                                                }
                                            }
                                        }
                                    }
                                }

                            }
                        }
                        if (cellNode != null) {
                            String tableKey = cellNode.getParent().getAttributes().get(ConstantUtil.TABLE_KEY);
                            if (columnNode != null && !StringUtils.isNotEmpty(metaForm.getDataSource().getRefObjectKey())) {
                                TagNode parent = columnNode.getParent();
                                //判断是否有共用，无的话使用次数就是1
                                int haveRelyOn = isHaveRelyOn(key, xmlTree.xmlTree, tableKey);
                                if (haveRelyOn == 1 && !isOnly) {
                                    parent.getChildren().remove(columnNode);
                                    genXmlDiff(xmlTree, parent, diff, false);
                                }
                            }
                        }
                    } else {
                        throw new Throwable("表格列最后一列不允许删除");
                    }
                }

            } else if (objectType == MetaObjectType.field) {
                if (curNode.getTagName().equalsIgnoreCase("RadioButton") && "True".equalsIgnoreCase(curNode.getAttributes().get("IsGroupHead"))) {
                    String groupKey = curNode.getAttributes().get("GroupKey");
                    String isGroupHead = curNode.getAttributes().get("IsGroupHead");
                    List<MetaComponent> allComponent = idLookup.getAllComponent();
                    if ("true".equalsIgnoreCase(isGroupHead)) {
                        for (MetaComponent component : allComponent) {
                            if (component instanceof MetaRadioButton) {
                                if (((MetaRadioButton) component).getGroupKey().equalsIgnoreCase(groupKey) && !((MetaRadioButton) component).isGroupHead()) {
                                    throw new Throwable("组头控件所属组有其他单选按钮使用，不能删除！");
                                }
                            }
                        }
                    }
                }
                children.remove(curNode);

                // 移除EditView的布局
                if ("EditView".equalsIgnoreCase(curNode.getTagName())) {
                    String compViewKey = "ComponentView@" + diff.getKey();
                    TagNode compViewNode = xmlTree.xmlTree.getTagNode(compViewKey);
                    if (compViewNode != null) {
                        TagNode bodyNode = xmlTree.xmlTree.getRoot().getChildByTagName("Body");
                        TagNode parentViewNode = compViewNode.getParent();
                        if(parentViewNode != null){
                            parentViewNode.getChildren().remove(compViewNode);
                        }
                        genXmlDiff(xmlTree, bodyNode, diff, true);
                        return;
                    }
                }


                String columnValue = curNode.getOrCreateChildByTagName(MetaDataBinding.TAG_NAME).getAttributes().get(ConstantUtil.COLUMN_KEY);
                String tableKey = curNode.getOrCreateChildByTagName(MetaDataBinding.TAG_NAME).getAttributes().get(ConstantUtil.TABLE_KEY);
                if (StringUtils.isBlank(diff.getMetaForm().getExtend()) && columnValue != null) {
                    //判断是否为共用字段
                    int haveRelyOn = isHaveRelyOn(columnValue, xmlTree.xmlTree,
                            tableKey);
                    if (haveRelyOn == 0 && !StringUtils.isNotEmpty(metaForm.getDataSource().getRefObjectKey())) {
                        TagNode columnNode = xmlTree.xmlTree.getTagNode(ConstantUtil.COLUMN + "@" + columnValue);
                        if (Objects.isNull(columnNode)) {
                            columnNode = diff.getDataObjectXmlTree().xmlTree.getTagNode(ConstantUtil.COLUMN + "@" + columnValue);
                            if (columnNode != null) {
                                TagNode parent = columnNode.getParent();
                                parent.getChildren().remove(columnNode);
                                genXmlDiff(diff.getDataObjectXmlTree(), parent, diff, false);
                            }
                        } else {
                            //排除没有column的组件
                            TagNode parent = columnNode.getParent();
                            // Dict组件同步删除Code和Name
                            if ("Dict".equalsIgnoreCase(curNode.getTagName()) || "DynamicDict".equalsIgnoreCase(curNode.getTagName())) {
                                TagNode codeNode = xmlTree.xmlTree.getTagNode(ConstantUtil.COLUMN + "@" + columnValue + "Code");
                                if (codeNode != null) {
                                    parent.getChildren().remove(codeNode);
                                }
                                TagNode nameNode = xmlTree.xmlTree.getTagNode(ConstantUtil.COLUMN + "@" + columnValue + "Name");
                                if (nameNode != null) {
                                    parent.getChildren().remove(nameNode);
                                }
                            }
                            parent.getChildren().remove(columnNode);
                            genXmlDiff(xmlTree, parent, diff, false);
                        }
                    }
                } else {//马甲字段数据源删除
                    //判断是否为共用字段
                    int haveRelyOn = isHaveRelyOn(columnValue, xmlTree.xmlTree, tableKey);
                    if (haveRelyOn == 0) {
                        TagNode columnNode = xmlTree.xmlTree.getTagNode(ConstantUtil.COLUMN + "@" + columnValue);
                        if (Objects.nonNull(columnNode)) {
                            //排除没有column的组件
                            TagNode parent = columnNode.getParent();
                            parent.getChildren().remove(columnNode);
                            genXmlDiff(xmlTree, parent, diff, false);
                        }
                    }
                }
            } else if (objectType == MetaObjectType.panel) {
                String tagName = parentNode.getTagName();

                if ("Block".equalsIgnoreCase(tagName)) {
                    throw new Throwable("根面板不允许删除");
                }
                //判断是否在subdetail中
                isInSubdetail(children, curNode, parentNode);
            } else if (objectType == MetaObjectType.grid) {
                //判断是否在subdetail中
                isInSubdetail(children, curNode, parentNode);
            }
        } else if (objectType == MetaObjectType.EditViewChildLayout) {
            String editViewKey = "EditView@" + diff.parentKey;
            TagNode colsNode = (TagNode) xmlTree.xmlTree.getTagNode(editViewKey).getChildrenByTagName("EditViewColumnCollection").get(0);

            String compViewKey = "ComponentView@" + diff.parentKey;
            TagNode compViewNode = xmlTree.xmlTree.getTagNode(compViewKey);

            dealEditViewChildLayout(compViewNode, colsNode, diff.getKey());

            TagNode bodyNode = xmlTree.xmlTree.getRoot().getChildByTagName("Body");

            genXmlDiff(xmlTree, bodyNode, diff, true);

            return;
        } else if (objectType == MetaObjectType.EditViewColumn) {
            String editViewKey = "EditView@" + diff.parentKey;
            parentNode = (TagNode) xmlTree.xmlTree.getTagNode(editViewKey).getChildrenByTagName("EditViewColumnCollection").get(0);

            TagNode curNode = parentNode.getChildByKey(key);

            if (curNode != null) {
                List<AbstractNode> children = parentNode.getChildren();
                children.remove(curNode);

                // 处理布局
                String compViewKey = "ComponentView@" + diff.parentKey;
                TagNode compViewNode = xmlTree.xmlTree.getTagNode(compViewKey);
                if (compViewNode != null) {
                    List<AbstractNode> childLayoutNodes = compViewNode.getChildren();
                    TagNode bodyNode = xmlTree.xmlTree.getRoot().getChildByTagName("Body");

                    for (int j = 0; j < childLayoutNodes.size(); j ++) {
                        AbstractNode child = childLayoutNodes.get(j);
                        if (child instanceof TagNode) {
                            TagNode spanChildNode = ((TagNode) child).getChildByKey(key);
                            if (spanChildNode != null) {
                                ((TagNode) child).getChildren().remove(spanChildNode);
                                break;
                            }
                        }
                    }

                    genXmlDiff(xmlTree, bodyNode, diff, true);

                    return;
                }

                genXmlDiff(xmlTree, parentNode, diff, true);
            }
            return;
        } else if (objectType == MetaObjectType.TabItem) {
            String tabGrupKey = "TabGroup@" + diff.parentKey;
            parentNode = xmlTree.xmlTree.getTagNode(tabGrupKey);
            TagNode curNode = parentNode.getChildByKey(key);

            if (curNode != null) {

                List<AbstractNode> children = parentNode.getChildren();
                children.remove(curNode);
                genXmlDiff(xmlTree, parentNode, diff, true);
            }
            return;
        } else if (objectType == MetaObjectType.operationCollection || objectType == MetaObjectType.operation) { //非页面组件
            parentNode = diff.getXmlTree().xmlTree.getRoot().findFirstTagNodeByTagName(ConstantUtil.OPERATION_COLLECTION);
            List<AbstractNode> children = parentNode.getChildren();
            String operatTreeKey = ConstantUtil.OPERATION + "@" + key;
            TagNode curNode = xmlTree.xmlTree.getTagNode(operatTreeKey);
            String operatTreeKey1 = ConstantUtil.OPERATION_COLLECTION + "@" + key;
            if (Objects.isNull(curNode)) {
                curNode = xmlTree.xmlTree.getTagNode(operatTreeKey1);
            }
            children.remove(curNode);
        } else if (objectType == MetaObjectType.toolbar || objectType == MetaObjectType.ToolBar) {//支持删除
            parentNode = diff.getXmlTree().xmlTree.getRoot().findFirstTagNodeByTagName(ConstantUtil.TOOL_BAR).getParent();
            List<AbstractNode> children = parentNode.getChildren();
            String operatTreeKey = ConstantUtil.TOOL_BAR + "@" + key;
            TagNode curNode = xmlTree.xmlTree.getTagNode(operatTreeKey);
            children.remove(curNode);
        } else if (objectType == MetaObjectType.Embed) {//支持删除
            String operatTreeKey = "Embed" + "@" + key;
            TagNode curNode = xmlTree.xmlTree.getTagNode(operatTreeKey);
            if (curNode != null) {
                parentNode = curNode.getParent();
                List<AbstractNode> children = parentNode.getChildren();
                children.remove(curNode);
                genXmlDiff(xmlTree, parentNode, diff, true);
            }
            return;
        } else if (objectType == MetaObjectType.DeleteTableViewRow) {//支持删除
            MetaComponent metaComp = IOMetaObject.getComponentByKey(metaForm, diff.parentKey);
            String rowTagName = metaComp.getControlType() == ControlType.COLLECTIONVIEW ? "CollectionViewRow" : "TableRow";
            String tableViewRowKey = rowTagName + "@" + key;
            TagNode curNode = xmlTree.xmlTree.getTagNode(tableViewRowKey);
            if (curNode != null) {
                parentNode = curNode.getParent();
                if(parentNode.findNodesByTagName(rowTagName).size() == 1){
                    throw new Throwable("该行视图为表格视图组件唯一行视图，不能删除！");
                } else if(curNode.getAttributes().get("RowType") != null && curNode.getAttributes().get("RowType").equals("Detail")){
                    int index = parentNode.getChildren().indexOf(curNode);
                    if (index > 1) {
                        TagNode preNode = (TagNode) parentNode.getChildren().get(index - 2);//中间间隔了一个TextNode
                        if (preNode != null && preNode.getAttributes().get("RowType") != null
                                && preNode.getAttributes().get("RowType").equals("Group")) {
                            parentNode.getChildren().remove(preNode);
                        }
                    }
                    index = parentNode.getChildren().indexOf(curNode);
                    if (index >= 0 && index < parentNode.getChildren().size() - 1) {
                        TagNode nextNode = (TagNode) parentNode.getChildren().get(index + 2);//中间间隔了一个TextNode
                        if (nextNode != null && nextNode.getAttributes().get("RowType") != null &&
                                nextNode.getAttributes().get("RowType").equals("GroupTail")) {
                            parentNode.getChildren().remove(nextNode);
                        }
                    }
                } else if(curNode.getAttributes().get("RowType") != null && curNode.getAttributes().get("RowType").equals("Group")){
                    List<TagNode> tableRowNodes = parentNode.findNodesByTagName(rowTagName);
                    for (TagNode tableRowNode : tableRowNodes) {
                        if(tableRowNode.getAttributes().containsKey("RowType") && tableRowNode.getAttributes().get("RowType").equals("GroupTail")){
                            parentNode.getChildren().remove(tableRowNode);
                        }
                    }
                }
                parentNode.getChildren().remove(curNode);
                genXmlDiff(xmlTree, parentNode, diff, true);
            }
            return;
        }  else if (objectType == MetaObjectType.GridFieldRow) {
            IDLookup idLookup = IDLookup.getIDLookup(metaForm);
            if (!StringUtils.isNotEmpty(diff.parentKey)) {
                TagNode rows = xmlTree.xmlTree.getTagNode("GridRow@" + key);
                List<TagNode> cells = rows.findMyselfNodesByTagName(ConstantUtil.GRID_CELL);
                key = cells.get(0).getAttributes().get(ConstantUtil.KEY);
                diff.parentKey = rows.getParent().getParent().getAttributes().get(ConstantUtil.KEY);
            }
            String parentTagName = idLookup.getTagNameByKey(diff.parentKey);
            String parentXmlTreeKey = parentTagName + "@" + diff.parentKey;
            parentNode = diff.getXmlTree().xmlTree.getTagNode(parentXmlTreeKey);
            String XmlTreeKey = "GridRow@" + key;
            TagNode rowNode = null;
            TagNode curNode = xmlTree.xmlTree.getTagNode(XmlTreeKey);
            if (Objects.isNull(curNode)) {  //马甲删除字段
                MetaGridRowCollection rowCollection = idLookup.getMetaGridByGridKey(diff.parentKey).getRowCollection();
                for (MetaGridRow metaGridRow : rowCollection) {
                    if (metaGridRow.findCellByKey(key) != null) {
                        rowNode = xmlTree.xmlTree.getTagNode("GridRow@" + metaGridRow.getKey());
                        break;
                    }
                }
            } else {
                rowNode = curNode;
            }
            if (rowNode == null){
                throw new Throwable("当前选中字段在xml中不存在,操作无效");
            }
            String rowKey = rowNode.getAttributes().get(ConstantUtil.KEY);
            MetaGridRowCollection metaGridRows = idLookup.getMetaGridByGridKey(diff.parentKey).getRowCollection();
            String groupKey = null;
            MetaGridCell metaGridCell;
            for (MetaGridRow metaGridRow : metaGridRows) {
                if (metaGridRow.getRowType() == 1) {
                    groupKey = metaGridRow.getGroupKey();
                }
            }
            for (MetaGridRow row : metaGridRows) {
                if (row.getKey().equalsIgnoreCase(rowKey)) {
                    metaGridCell = row.findCellByKey(groupKey);
                    if (metaGridCell != null) {
                        throw new Throwable("该行在其他行中有依赖关系不允许删除");
                    }
                }
            }
            TagNode rowColls = rowNode.getParent();
            List<AbstractNode> rowList = rowColls.getChildren();
            String rowType = rowColls.getChildByKey(rowKey).getAttributes().get(ConstantUtil.ROW_TYPE);
            if (rowColls.getChildrenByTagName(ConstantUtil.GRID_ROW).size() == 1) {
                throw new Throwable("表格最后一行不允许删除!");
            } else if (ConstantUtil.DETAIL.equalsIgnoreCase(rowType)) {
                throw new Throwable("明细行不允许删除!");
            } else if (StringUtils.isEmpty(rowType)) {
                MetaForm extendMetaForm = MetaFormHelper.getExtendMetaForm(metaForm);
                if (extendMetaForm == metaForm) {
                    throw new Throwable("明细行不允许删除!");
                }
                String pathByFormKey = LoadFileTree.getPathByFormKey(extendMetaForm.getKey());
                XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(pathByFormKey);
                TagNode extendCurNode = xmlTreeWithPath.xmlTree.getTagNode(XmlTreeKey);
                if (Objects.nonNull(extendCurNode)) {
                    TagNode extendParentNode = extendCurNode.getParent();
                    String extendRowType = extendParentNode.getAttributes().get(ConstantUtil.ROW_TYPE);
                    if (StringUtils.equalsIgnoreCase(ConstantUtil.DETAIL, extendRowType)) {
                        throw new Throwable("明细行不允许删除!");
                    }
                }
            }
            rowList.remove(rowNode);
        } else if (objectType == MetaObjectType.ListViewColumn) {
            String parentXmlTreeKey =
                    "ListView" + "@" + diff.parentKey;
            parentNode = diff.getXmlTree().xmlTree.getTagNode(parentXmlTreeKey);
            TagNode columnNode = xmlTree.xmlTree.getTagNode(ConstantUtil.COLUMN + "@" + key);
//			String tableKey = parentNode.getAttributes().get(ConstantUtil.TABLE_KEY);
            if (columnNode != null) {
                TagNode parent = columnNode.getParent();
                parent.getChildren().remove(columnNode);
                genXmlDiff(xmlTree, parent, diff, false);
            }
            List<AbstractNode> children = parentNode.getChildren();
            for (AbstractNode abstractNode : children) {
                if (abstractNode instanceof TagNode && "ListViewColumnCollection".equalsIgnoreCase(
                        ((TagNode) abstractNode).getTagName())) {
                    ((TagNode) abstractNode).deleteChildByTagKey(diff.getKey());
                    break;
                }
            }
        } else if (objectType == MetaObjectType.subDetail) {
            if (StringUtils.equals(parentNode.getTagName(), ConstantUtil.SPLIT_PANEL)) {
                List<AbstractNode> children = parentNode.getChildren();
                int curIdx = 0;
                TagNode curNode = null;

                for (AbstractNode child : children) {
                    boolean flag = child instanceof TagNode;
                    if (!flag) {
                        continue;
                    }
                    TagNode tagNode = (TagNode) child;
                    if (Objects.equals(tagNode.getTagName(), "SplitSize")) {
                        continue;
                    }
                    Map<String, String> attributes = tagNode.getAttributes();
                    if (Objects.nonNull(attributes) && Objects.equals(attributes.get(ConstantUtil.KEY), diff.getKey())) {
                        curNode = tagNode;
                        break;
                    }
                    curIdx = curIdx + 1;
                }

                int curSplitIdx = 0;
                TagNode curSplitNode = null;
                for (int i = 0; i < children.size() && Objects.nonNull(curNode); i++) {
                    AbstractNode child = children.get(i);
                    boolean flag = child instanceof TagNode;
                    if (!flag) {
                        continue;
                    }
                    TagNode tagNode = (TagNode) child;
                    if (!Objects.equals(tagNode.getTagName(), "SplitSize")) {
                        continue;
                    }
                    if (curSplitIdx == curIdx) {
                        curSplitNode = tagNode;
                        break;
                    }
                    curSplitIdx = curSplitIdx + 1;
                }
                if (Objects.nonNull(curNode) && Objects.nonNull(curSplitNode)) {
                    children.remove(curNode);
                    children.remove(curSplitNode);
                }
            } else {
                List<AbstractNode> children = parentNode.getChildren();
                Predicate<AbstractNode> predicate = absNode -> {
                    boolean flag = absNode instanceof TagNode;
                    if (!flag) {
                        return false;
                    }
                    TagNode tagNode = (TagNode) absNode;
                    Map<String, String> attributes = tagNode.getAttributes();
                    return Objects.nonNull(attributes) && Objects.equals(attributes.get(ConstantUtil.KEY), diff.getKey());
                };
                Optional<AbstractNode> optional = children.stream().filter(predicate).findFirst();
                optional.ifPresent(children::remove);
            }

        } else if(objectType == MetaObjectType.Block){
            TagNode formNode = diff.getXmlTree().xmlTree.getTagNode("Form@" + diff.getMetaForm().getKey());
            parentNode = formNode.getChildByTagName("Body");
            for(TagNode node : parentNode.findNodesByTagName("Block")){
                String blockKey = node.getAttributes().get("Key");
                if(blockKey != null && blockKey.equals(diff.getKey())){
                    parentNode.getChildren().remove(node);
                    break;
                }
            }
        }

        genXmlDiff(xmlTree, parentNode, diff, true);
    }

    private static void deleteGridCell(Map<String, Integer> leafIndexMap, String key, TagNode coluNode, MetaGrid grid, TagNode parentNode) {
        if (leafIndexMap.containsKey(key)){
            //叶子节点
            Integer i = leafIndexMap.get(key);
            coluNode.getParent().deleteChildByTagKey(key);
            for (MetaGridRow metaGridRow : grid.getRowCollection()) {
                MetaGridCell gridCell = metaGridRow.get(i);
                if (parentNode.getChildByTagName(ConstantUtil.GRID_ROW_COLLECTION)!=null && parentNode.getChildByTagName(ConstantUtil.GRID_ROW_COLLECTION).getChildByKey(metaGridRow.getKey())!=null){
                    parentNode.getChildByTagName(ConstantUtil.GRID_ROW_COLLECTION).getChildByKey(metaGridRow.getKey()).deleteChildByTagKey(gridCell.getKey());
                }
            }
        } else {
            //根据头节点找到叶子节点，list 删除叶子节点对应的cell
            MetaGridColumn gridColumn = grid.findColumnByKey(key);
            for (MetaGridColumn metaGridColumn : gridColumn.getColumnCollection()) {
                deleteGridCell(leafIndexMap,metaGridColumn.getKey(),coluNode,grid,parentNode);
            }
        }
    }

    public static TagNode examinationTagNode(MetaForm metaForm, Diff diff, String key, XmlTree xmlTree, IDLookup idLookup) throws Throwable {
        //判断是否为源表单中字段
        String nodeTagName;
        String trueName = "";
        boolean flag = false;
        String XmlTreeKey;
        if (metaForm.getFormType() == FormType.Template) {
            nodeTagName = idLookup.getTagNameByKey(key);
            if (StringUtils.isBlank(nodeTagName) && diff.getMetaObjectType() == MetaObjectType.Embed) {
                nodeTagName = MetaObjectType.Embed.name;
            }
        } else if (MetaObjectType.operation.toString().equalsIgnoreCase(diff.getMetaObjectType().name)) {
            nodeTagName = metaForm.getOperationCollection().get(key).getTagName();
        } else if (MetaObjectType.ListViewColumn.toString().equalsIgnoreCase(diff.getMetaObjectType().name)) {
            nodeTagName = metaForm.getListViewColumnMap().get(key).getTagName();
        } else if (MetaObjectType.DeleteTableViewRow.toString().equalsIgnoreCase(diff.getMetaObjectType().name)) {
            nodeTagName = "TableRow";
            MetaComponent metaComp = IOMetaObject.getComponentByKey(metaForm, diff.parentKey);
            if(metaComp.getControlType() == ControlType.COLLECTIONVIEW){
                nodeTagName = "CollectionViewRow";
            }
        } else if (MetaObjectType.GridFieldRow.toString().equalsIgnoreCase(diff.getMetaObjectType().name)) {
            if (Objects.isNull(metaForm.metaGridCellByKey(key))) {
                TagNode column = xmlTree.getTagNode("GridRow@" + key);
                List<TagNode> cells = column.findMyselfNodesByTagName(ConstantUtil.GRID_CELL);
                trueName = cells.get(0).getAttributes().get(ConstantUtil.KEY);
                nodeTagName = metaForm.metaGridCellByKey(trueName).getTagName();
                flag = true;
            } else {
                nodeTagName = metaForm.metaGridCellByKey(key).getTagName();
            }
        } else if (MetaObjectType.gridField.toString().equalsIgnoreCase(diff.getMetaObjectType().name)) {
            IDLookup.reloadIDLookup(metaForm);//.getGridMetaColumnByKey(key);
            if (metaForm.getAllUIComponents().get(key) != null) {
                nodeTagName = metaForm.getAllUIComponents().get(key).getTagName();
            } else {
                TagNode column = xmlTree.getTagNode("GridColumn@" + key);
                trueName = column.getParent().getParent().getAttributes().get(ConstantUtil.KEY);
                nodeTagName = metaForm.getAllUIComponents().get(trueName).getTagName();
                flag = true;
            }
        } else if (MetaObjectType.TabItem.toString().equalsIgnoreCase(diff.getMetaObjectType().name)) {
            String tabGrupKey = "TabGroup@" + diff.parentKey;
            TagNode parentNode = xmlTree.getTagNode(tabGrupKey);

            return parentNode.getChildByKey(key);
        } else {
            AbstractMetaObject abstractMetaObject = metaForm.getAllUIComponents().get(key);
            if(abstractMetaObject == null) {
                for (MetaComponent metaComponent : metaForm.getAllComponents()) {
                    if (metaComponent.getKey().equals(key)) {
                        abstractMetaObject = metaComponent;
                        break;
                    }
                }
            }
            if (abstractMetaObject != null) {
                nodeTagName = abstractMetaObject.getTagName();

            } else {
                MetaEmbed metaEmbed = metaForm.embedByKey(key);
                nodeTagName = metaEmbed.getTagName();
            }
        }
        if (flag) {
            XmlTreeKey = nodeTagName + "@" + trueName;
        } else {
            XmlTreeKey = nodeTagName + "@" + key;
        }
        TagNode curNode = xmlTree.getTagNode(XmlTreeKey);
        MetaFormProfile metaFormProfile = MetaFactory.getGlobalInstance().getMetaFormList().get(metaForm.getKey());
        if(metaFormProfile == null) metaFormProfile = MetaFactory.getGlobalInstance().getExtFormList().get(metaForm.getKey());
        Boolean mergeToSource = metaFormProfile.getMergeToSource();
        if (mergeToSource) {
            if (MetaObjectType.GridFieldRow.toString().equalsIgnoreCase(diff.getMetaObjectType().name)) {
                if (curNode != null) {
                    TagNode tagNode = diff.getVestXmlTree().xmlTree.getTagNode("GridRow@" + curNode.getParent().getAttributes().get(ConstantUtil.KEY));
                    if (tagNode != null) {
                        throw new Throwable("原表单控件不支持删除!");
                    }
                } else {
                    throw new Throwable("该组件为马甲删除组件仅在设计界面上显示与原表单作对比，并不支持其他操作!");
                }
            }
        }
        return curNode;
    }

    private static void isInSubdetail(List<AbstractNode> children, TagNode curNode, TagNode parentNode) {
        //当删除的表格列时是最后一个时默认删除整个表格，不然程序就会崩溃
        if (ConstantUtil.TOOL_BAR.equalsIgnoreCase(parentNode.getTagName())) {
            children.remove(curNode);
        } else {
            //直接删除整个表格
            TagNode curNodeParent = curNode;
            do {
                curNodeParent = curNodeParent.getParent();
                if (Objects.isNull(curNodeParent)) {
                    break;
                }
            } while (!"SubDetail".equals(curNodeParent.getTagName()));
            //在直接删除表格的时候如果在Subdetail中就删除整个SubDetail
            if (curNodeParent != null && "SubDetail".equals(curNodeParent.getTagName())) {
                if (!children.contains(curNodeParent)) {
                    children.remove(curNode);
                } else {
                    children.remove(curNodeParent);
                }
            } else {
                children.remove(curNode);
            }
        }
    }

    private static Integer compIndex(List<AbstractNode> absNodes, String sideKey) {
        for (AbstractNode col : absNodes) {
            if (col instanceof TagNode) {
                if (((TagNode) col).getAttributes() != null && sideKey.equals(((TagNode) col).getAttributes().get(ConstantUtil.KEY))) {
                    return absNodes.indexOf(col);
                }
            }
        }
        return 0;
    }

    private static void addSubCompToSubDetail(TagNode subDetailNode, Diff diff) throws Throwable {
        String sourceFormKey = diff.getParamsformKey();
        MetaForm metaSourceForm = MetaFactory.getGlobalInstance().getMetaForm(sourceFormKey);
        MetaSubDetail metaSourceSubDetail = null;
        for (MetaComponent metaSubDetail : metaSourceForm.getSubDetails()) {
            if (metaSubDetail.getKey().equals(diff.getKey())) {
                metaSourceSubDetail = (MetaSubDetail) metaSubDetail;
                break;
            }
        }
        if (metaSourceSubDetail != null) {
            MetaComponent metaRootComp = metaSourceSubDetail.getRoot();
            if(metaRootComp.getTagName().endsWith("Panel")){
                TagNode rootPanelNode = new TagNode("TabPanel", null);
                rootPanelNode.setAttribute("Key", diff.getKey() + "_RootPanel");
                rootPanelNode.setAttribute("Caption", "根面板");
                addFieldsToSubDetailRootPanel(rootPanelNode, metaRootComp);
                TagNode baseInfoPanelNode = rootPanelNode.findFirstTagNodeByTagName("FlexFlowLayoutPanel");
                if(baseInfoPanelNode != null ) {
                    if(baseInfoPanelNode.getChildren().isEmpty()){
                        rootPanelNode.getChildren().remove(baseInfoPanelNode);
                    }
                }
                subDetailNode.addNode(rootPanelNode);
            }else if (metaRootComp.getTagName().equals("Grid")){
                TagNode tableViewNode = getTableViewNodeByGrid((MetaGrid)metaRootComp);
                subDetailNode.addNode(tableViewNode);
            }
            subDetailNode.setAttribute("BindingGridKey", metaSourceSubDetail.getBindingGridKey());
        }
    }

    private static void addFieldsToSubDetailRootPanel(TagNode rootTabPanelNode, MetaComponent metaRootComp) {
        TagNode baseInfoPanelNode = rootTabPanelNode.findFirstTagNodeByTagName("FlexFlowLayoutPanel");
        if(baseInfoPanelNode == null) {
            baseInfoPanelNode = new TagNode("FlexFlowLayoutPanel", null);
            baseInfoPanelNode.setAttribute("Key", "BaseInfoPanel");
            baseInfoPanelNode.setAttribute("Caption", "基本信息");
            baseInfoPanelNode.setAttribute("Padding", "10px");
            rootTabPanelNode.addNode(baseInfoPanelNode);
        }
        for (int i = 0; i < metaRootComp.getComponentCount(); i++) {
            MetaComponent metaSubComp = metaRootComp.getComponent(i);
            if (metaSubComp.getTagName().equals("Grid")) {
                TagNode tableViewNode = getTableViewNodeByGrid((MetaGrid)metaSubComp);
                rootTabPanelNode.addNode(tableViewNode);
            } else if (!metaSubComp.getTagName().endsWith("Panel") && metaSubComp.isRequired()) {
                TagNode subCompNode = new TagNode(ControlType.toString(metaSubComp.getControlType()), null);
                subCompNode.setAttribute("Key", metaSubComp.getKey());
                subCompNode.setAttribute("Height", "32px");
                subCompNode.setAttribute("TopMargin", "5px");
                baseInfoPanelNode.addNode(subCompNode);
            }
            if(metaSubComp.getComponentCount() > 0){
                addFieldsToSubDetailRootPanel(rootTabPanelNode, metaSubComp);
            }
        }
    }

    private static TagNode getTableViewNodeByGrid(MetaGrid metaGrid){
        TagNode tableViewNode = new TagNode("TableView", null);
        tableViewNode.setAttribute("Key", metaGrid.getKey()+"_TableView");
        tableViewNode.setAttribute("Caption", metaGrid.getCaption());
        TagNode tableRowCollectionNode = new TagNode("TableRowCollection", null);
        tableViewNode.addNode(tableRowCollectionNode);
        TagNode tableRowNode = new TagNode("TableRow", null);
        tableRowNode.setAttribute("Key", metaGrid.getKey());
        tableViewNode.setAttribute("Caption", metaGrid.getCaption());
        TagNode rootPanelNode = getTableRowDefaultPanelNode("GridLayoutPanel", metaGrid.getKey());
        tableRowNode.addNode(rootPanelNode);
        tableRowCollectionNode.addNode(tableRowNode);
        int cellCount = 0;
        for (int j = 0; j < metaGrid.getDetailMetaRow().size(); j++) {
            MetaGridCell metaGridCell = metaGrid.getDetailMetaRow().get(j);
            if(metaGridCell.isRequired()){
                TagNode subCompNode = new TagNode(ControlType.toString(metaGridCell.getCellType()), null);
                subCompNode.setAttribute("Key", metaGridCell.getKey());
                subCompNode.setAttribute("Caption", metaGridCell.getCaption());
                subCompNode.setAttribute("X", "1");
                subCompNode.setAttribute("XSpan", "2");
                subCompNode.setAttribute("Y", ""+cellCount);
                subCompNode.setAttribute("Class", "innerLabel-show");
                if(cellCount > 1){
                    TagNode rowDefCollectionNode = rootPanelNode.findFirstTagNodeByTagName("RowDefCollection");
                    TagNode rowDefNode = new TagNode("RowDef", null);
                    rowDefCollectionNode.addNode(rowDefNode);
                }
                rootPanelNode.addNode(subCompNode);
                cellCount ++;
            }
        }
        return tableViewNode;
    }

    //所有SplitPanel下新增的组件都要加一个splitsize与之对应，这里默认size为150px
    private static void addSplitSize(TagNode parentNode) {
        if (ConstantUtil.SPLIT_PANEL.equals(parentNode.getTagName())) {
            TagNode splitSizeNode = new TagNode("SplitSize", null);
            splitSizeNode.setAttribute("Size", "150px");
            parentNode.addNode(splitSizeNode);
        }
    }

    //SplitPanel 下添加组件
    private static void addNodeToSplitPanel(TagNode parentNode, TagNode childNode) {
        if (childNode.getParent() != null && childNode.getParent().getChildren().contains(childNode)) {
            int index = childNode.getParent().getChildren().indexOf(childNode);
            parentNode.addNode(childNode, index);
        } else {
            List<AbstractNode> children = parentNode.getChildren();
            if (ConstantUtil.SPLIT_PANEL.equals(parentNode.getTagName())) {
                int indexOfSizeNode = children.indexOf(firstSplitSize(children));
                if (indexOfSizeNode ==-1){
                    parentNode.addNode(childNode);
                }else {
                    children.add(indexOfSizeNode, childNode);
                }

            } else {
                parentNode.addNode(childNode);
            }
        }
    }

    //SplitPanel 下第一个SplitSize
    private static TagNode firstSplitSize(List<AbstractNode> children) {
        for (AbstractNode abstractNode : children) {
            if (abstractNode instanceof TagNode) {
                String tagName = ((TagNode) abstractNode).getTagName();
                if ("SplitSize".equals(tagName)) {
                    return (TagNode) abstractNode;
                }
            }
        }
        return null;
    }

    public static void codeAndNameWithDictComponent(Diff diff, String key, String tableKey, TagNode newColumn) throws Throwable {
        TagNode tableNode = null;
        if (StringUtils.isNotEmpty(diff.getMetaForm().getDataSource().getRefObjectKey())) {
            tableNode = diff.getDataObjectXmlTree().xmlTree.getTagNode(ConstantUtil.TABLE + "@" + tableKey);
        } else {
            tableNode = diff.getTagNode(ConstantUtil.TABLE + "@" + tableKey);
        }
        // Dict类型 数据源 加上Code 和 Name 列
        if (key.toLowerCase().endsWith("id")) { // 以id结尾 删除id添加code和name
            key = key.substring(0, key.length() - 2);
        }
        String codeColumnKey = key + "Code";
        TagNode code = new TagNode(ConstantUtil.COLUMN, null);
        code.setAttribute(ConstantUtil.KEY, codeColumnKey);
        code.setAttribute(ConstantUtil.CAPTION, diff.caption);
        code.setAttribute(ConstantUtil.DATA_TYPE, DataType.STR_STRING);

        int length = 30;
        if (diff.getItemKey() != null) {
            MetaDataObject metaDataObject = MetaFactory.getGlobalInstance().getDataObject(diff.getItemKey());
            if (metaDataObject != null) {
                MetaTableCollection metaTables = metaDataObject.getTableCollection();
                if (metaTables != null) {
                    for (MetaTable metaTable : metaTables) {
                        if (metaTable.get(SystemField.CODE_DICT_KEY) != null) {
                            length = metaTable.get(SystemField.CODE_DICT_KEY).getLength();
                            break;
                        }
                    }
                }
            }
        }
        code.setAttribute(ConstantUtil.LENGTH, String.valueOf(length));

        tableNode.deleteChildByTagKey(codeColumnKey);
        tableNode.addNode(code);
        newColumn.setAttribute(ConstantUtil.CODE_COLUMN_KEY, codeColumnKey);
    }

    private static int mergeNewDiff(MetaComponent selectComp, TagNode selectNode, Document document, Diff diff, int diffSize) throws Throwable {
        final MetaForm metaForm = diff.getMetaForm();
        String controlType = ControlType.toString(diff.getControlType());
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaFormList metaFormList = metaFactory.getMetaFormList();

        int anInt = 1;
        if (diff.getMetaObjectType() == MetaObjectType.EmbedPanel) {//外嵌面板
            MetaFormProfile metaFormProfile = metaFormList.get(metaForm.getKey());
            if(metaFormProfile == null) metaFormProfile = metaFactory.getExtFormList().get(metaForm.getKey());
            if (metaFormProfile.getMergeToSource()) {
                MetaForm originalMetaForm = metaFactory.getMetaForm(metaForm.getExtend());
                AbstractMetaObject abstractMetaObject = originalMetaForm.getAllUIComponents().get(diff.parentKey);
                if (abstractMetaObject != null) {
                    throw new Throwable("原单控件不支持外嵌组件");
                }
            }

            TagNode oldParentNode = selectNode.getParent();
            TagNode newWrapNode;
            final Map<String, String> attributes = selectNode.getAttributes();
            if (StringUtils.isBlank(attributes.get(ConstantUtil.CAPTION))) {
                selectNode.setAttribute(ConstantUtil.CAPTION, attributes.get(ConstantUtil.KEY));
            }

            switch (controlType) {
                case ControlType.STR_TABPANEL:
                    newWrapNode = new TagNode(controlType, null);
                    newWrapNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                    newWrapNode.setAttribute(ConstantUtil.CAPTION, diff.caption);
                    newWrapNode.addNode(selectNode);
                    break;
                case ControlType.STR_GRIDLAYOUTPANEL:
                    IDLookup idLookup = IDLookup.getIDLookup(metaForm);
                    while (idLookup.containFieldKey("tempGridLayoutPanel" + anInt)) {
                        anInt++;
                    }
                    newWrapNode = SetGridLayoutPanel(diff, metaForm, anInt);
                    newWrapNode.setAttribute(ConstantUtil.HEIGHT, "100%");
                    newWrapNode.setAttribute(ConstantUtil.WIDTH, "100%");
                    newWrapNode.getAttributes().remove(ConstantUtil.PADDING);

                    selectNode.setAttribute(ConstantUtil.X, "0");
                    selectNode.setAttribute(ConstantUtil.Y, "0");
                    selectNode.setAttribute("XSpan", "1");
                    selectNode.setAttribute("YSpan", "1");
                    selectNode.setAttribute(ConstantUtil.HEIGHT, "100%");
                    selectNode.setAttribute(ConstantUtil.WIDTH, "100%");

                    newWrapNode.addNode(selectNode);
                    break;
                case ControlType.STR_SPLITPANEL:
                    newWrapNode = new TagNode(controlType, null);
                    newWrapNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                    newWrapNode.setAttribute(ConstantUtil.CAPTION, diff.caption);
                    newWrapNode.setAttribute("Orientation", "Vertical");
                    TagNode size = new TagNode("SplitSize", null);
                    size.setAttribute("Size", "100px");
                    //TagNode endSplit = new TagNode(ConstantUtil.SPLIT_PANEL, null);
                    newWrapNode.addNode(selectNode, 0);
                    newWrapNode.getChildren().add(size);
                    //splitNode.addNode(endSplit);
                    break;
                case ControlType.STR_FLEXFLOWLAYOUTPANEL:
                case ControlType.STR_FLOWLAYOUTPANEL:
                case ControlType.STR_LINEARLAYOUTPANEL:
                    newWrapNode = new TagNode(controlType, null);
                    newWrapNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                    newWrapNode.setAttribute(ConstantUtil.CAPTION, diff.caption);
                    newWrapNode.setAttribute(ConstantUtil.HEIGHT, "100%");
                    newWrapNode.setAttribute(ConstantUtil.WIDTH, "pref");
                    newWrapNode.addNode(selectNode);
                    break;
                case ControlType.STR_COLUMNLAYOUTPANEL:
                    newWrapNode = new TagNode(controlType, null);
                    newWrapNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                    newWrapNode.setAttribute(ConstantUtil.CAPTION, diff.caption);
                    newWrapNode.setAttribute(ConstantUtil.HEIGHT, "100%");
                    newWrapNode.setAttribute(ConstantUtil.WIDTH, "pref");
                    selectNode.setAttribute(ConstantUtil.X, "0");
                    selectNode.setAttribute(ConstantUtil.Y, "0");
                    selectNode.setAttribute("XSpan", "1");
                    selectNode.setAttribute("YSpan", "1");
                    selectNode.setAttribute(ConstantUtil.HEIGHT, "100%");
                    selectNode.setAttribute(ConstantUtil.WIDTH, "100%");
                    newWrapNode.addNode(selectNode);
                default:
                    if (diff.getReserveOne().equalsIgnoreCase(attributes.get(ConstantUtil.KEY))) {
                        throw new Throwable("子明细关联表标识不能关联自己");
                    }
                    newWrapNode = new TagNode(controlType, null);
                    newWrapNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                    newWrapNode.setAttribute(ConstantUtil.CAPTION, diff.caption);
                    newWrapNode.setAttribute("BindingGridKey", diff.getReserveOne());
                    newWrapNode.addNode(selectNode);
                    break;
            }


            if (StringUtils.equalsIgnoreCase(oldParentNode.getTagName(), ControlType.STR_GRIDLAYOUTPANEL)) {
                newWrapNode.setAttribute(ConstantUtil.X, attributes.get(ConstantUtil.X));
                newWrapNode.setAttribute(ConstantUtil.Y, attributes.get(ConstantUtil.Y));
            }

            int location = location(diff, oldParentNode);//获得原始位置
            oldParentNode.deleteChildByTagKey(diff.parentKey);
            oldParentNode.addNode(newWrapNode, location);

            // 因新节点的插入位置难以计算，所以将整个父节点替换掉
            XmlTreeWithPath xmlTree = diff.getXmlTree();
            int startLine = xmlTree.xmlTree.getLineByIndex(oldParentNode.getElement().getBgIndex());
            String orgXmlFragment = xmlTree.xmlTree.getNodeString(startLine);
            String newXmlFragment = DesignIOMetaUtil.getXml(oldParentNode);
            if (diff.getOrgXmlFragment() != null && diff.getNewXmlFragment() != null) {
                diff.setXmlDiff2(xmlTree, startLine, orgXmlFragment, newXmlFragment);
            } else {
                diff.setXmlDiff(xmlTree, startLine, orgXmlFragment, newXmlFragment);
            }
            return anInt;
        }

        if (diff.getMetaObjectType() == MetaObjectType.operation) {
            final List<TagNode> operationCollectionNodeList = diff.getXmlTree().xmlTree.getRoot().findNodesByTagName(ConstantUtil.OPERATION_COLLECTION);
            if (operationCollectionNodeList.size() <= 0) {//没有找到
                TagNode operation = new TagNode(ConstantUtil.OPERATION, null);
                operation.setAttribute(ConstantUtil.KEY, diff.getKey());
                operation.setAttribute(ConstantUtil.CAPTION, diff.caption);

                TagNode operationCollection = new TagNode(ConstantUtil.OPERATION_COLLECTION, null);
                operationCollection.addNode(operation);

                XmlTreeWithPath xmlTree = diff.getXmlTree();
                TagNode root = xmlTree.xmlTree.getRoot();
                root.deleteChildByTagName(ConstantUtil.TOOL_BAR);
                root.addNode(operationCollection);

                genXmlDiff(xmlTree, root, diff, true);
                diff.setMetaObjectType(MetaObjectType.ToolBar);
                return 1;
            }

            TagNode operat = new TagNode(ConstantUtil.OPERATION, null);
            TagNode opecolls = operationCollectionNodeList.get(0);
            if (StringUtils.equals(diff.getReserveOne(), "NewCollection")) {
                operat.setAttribute(ConstantUtil.KEY, diff.getKey());
                operat.setAttribute(ConstantUtil.CAPTION, diff.caption);

                String action = diff.getReserveTwo();
                if (StringUtils.isNotBlank(action)) {//操作动作不是空的
                    TagNode actionTagNode = new TagNode(ConstantUtil.ACTION, null);
                    actionTagNode.setCDataValue(action);
                    operat.addNode(actionTagNode);
                }
            } else {
                List<TagNode> operation = opecolls.findNodesByTagName(ConstantUtil.OPERATION);
                final long count = operation.stream().filter(tagNode -> StringUtils.contains(tagNode.getAttributes().get(ConstantUtil.KEY), "HeadOperation")).count();
                anInt = (int) count + 1;
                operat.setAttribute(ConstantUtil.KEY, "HeadOperation" + anInt);
                operat.setAttribute(ConstantUtil.CAPTION, "HeadOperation" + anInt);
            }

            String parentXmlTreeKey = "Form" + "@" + metaForm.getKey();
            TagNode formNode = diff.getXmlTree().xmlTree.getTagNode(parentXmlTreeKey);
            if (StringUtils.isNotBlank(diff.sideKey)) {
                if (StringUtils.containsIgnoreCase(diff.sideKey, ConstantUtil.TOOL_BAR)) {
                    List<AbstractNode> children = opecolls.getChildren();
                    if (children.size() > 0) {
                        children.add(children.size() - 1, operat);
                    } else {
                        children.add(operat);
                    }
                    selectNode = opecolls;
                } else {
                    if (Objects.isNull(metaForm.getOperationCollection())) {
                        TagNode opecoll = new TagNode(ConstantUtil.OPERATION_COLLECTION, null);
                        TagNode endOpeColl = new TagNode(ConstantUtil.OPERATION_COLLECTION, null);
                        opecoll.addNode(operat);
                        opecoll.addNode(endOpeColl);
                        formNode.addNode(opecoll);
                        selectNode = formNode;
                    } else {
                        TagNode opecoll = operationCollectionNodeList.get(0);
                        List<AbstractNode> operationCollection1 = opecoll.getChildrenByTagName(ConstantUtil.OPERATION_COLLECTION);
                        for (AbstractNode abstractNode : operationCollection1) {
                            if (abstractNode instanceof TagNode) {
                                final TagNode tagNode = (TagNode) abstractNode;
                                final Map<String, String> tagNodeAttributes = tagNode.getAttributes();
                                if (StringUtils.equals(tagNodeAttributes.get(ConstantUtil.KEY), diff.sideKey)) {
                                    tagNode.addNode(operat);
                                    selectNode = opecoll;
                                }
                            }
                        }
                        if (Objects.isNull(selectNode)) {
                            selectNode = diff.getXmlTree().xmlTree.getTagNode("Operation@" + diff.sideKey).getParent();
                        }
                    }
                }
            }
        }

        if (diff.getMetaObjectType() == MetaObjectType.operationCollection) {
            final List<TagNode> operationCollectionNodeList = diff.getXmlTree().xmlTree.getRoot().findNodesByTagName(ConstantUtil.OPERATION_COLLECTION);
            if (operationCollectionNodeList.size() <= 0) {//没有找到
                TagNode operation = new TagNode(ConstantUtil.OPERATION_COLLECTION, null);
                operation.setAttribute(ConstantUtil.KEY, diff.getKey());
                operation.setAttribute(ConstantUtil.CAPTION, diff.caption);

                TagNode operationCollection = new TagNode(ConstantUtil.OPERATION_COLLECTION, null);
                operationCollection.addNode(operation);

                XmlTreeWithPath xmlTree = diff.getXmlTree();
                TagNode root = xmlTree.xmlTree.getRoot();
                root.deleteChildByTagName(ConstantUtil.TOOL_BAR);
                root.addNode(operationCollection);

                genXmlDiff(xmlTree, root, diff, true);
                diff.setMetaObjectType(MetaObjectType.ToolBar);
                return anInt;
            }

            TagNode operat = new TagNode(ConstantUtil.OPERATION_COLLECTION, null);
            TagNode opecolls = operationCollectionNodeList.get(0);
            if (StringUtils.equals(diff.getReserveOne(), "NewCollection")) {
                operat.setAttribute(ConstantUtil.KEY, diff.getKey());
                operat.setAttribute(ConstantUtil.CAPTION, diff.caption);

                String action = diff.getReserveTwo();
                if (StringUtils.isNotBlank(action)) {//操作动作不是空的
                    TagNode actionTagNode = new TagNode(ConstantUtil.ACTION, null);
                    actionTagNode.setCDataValue(action);
                    operat.addNode(actionTagNode);
                }
            } else {
                List<TagNode> operation = opecolls.findNodesByTagName(ConstantUtil.OPERATION_COLLECTION);
                final long count = operation.stream()
                        .flatMap(opt -> {
                            final List<AbstractNode> children = opt.getChildren();
                            return children.stream()
                                    .filter(child -> {
                                        boolean b = (child instanceof TagNode);
                                        if (!b) {
                                            return false;
                                        }
                                        final Map<String, String> attributes = ((TagNode) child).getAttributes();
                                        return StringUtils.contains(attributes.get(ConstantUtil.KEY), "HeadOperationCollection");
                                    });
                        }).count();
                anInt = (int) count + 1;
                operat.setAttribute(ConstantUtil.KEY, "HeadOperationCollection" + anInt);
                operat.setAttribute(ConstantUtil.CAPTION, "HeadOperationCollection" + anInt);
            }

            String parentXmlTreeKey = "Form" + "@" + metaForm.getKey();
            TagNode formNode = diff.getXmlTree().xmlTree.getTagNode(parentXmlTreeKey);
            if (StringUtils.isNotBlank(diff.sideKey)) {
                List<AbstractNode> children = opecolls.getChildren();
                if (children.size() > 0) {
                    children.add(children.size() - 1, operat);
                } else {
                    children.add(0, operat);
                }
                selectNode = opecolls;
            } else {
                if (Objects.isNull(metaForm.getOperationCollection())) {
                    TagNode opecoll = new TagNode(ConstantUtil.OPERATION_COLLECTION, null);
                    TagNode endOpeColl = new TagNode(ConstantUtil.OPERATION_COLLECTION, null);
                    opecoll.addNode(operat);
                    opecoll.addNode(endOpeColl);
                    formNode.addNode(opecoll);
                    selectNode = formNode;
                } else {
                    TagNode opecoll = operationCollectionNodeList.get(0);
                    opecoll.addNode(operat);
                    selectNode = opecoll;
                }
            }
        }

        if (diff.getMetaObjectType() == MetaObjectType.field) {
            if (selectComp instanceof MetaGridLayoutPanel) {
                List<AbstractNode> children = selectNode.getChildren();
                if (diff.isButtonQuote && !StringUtils.equals(diff.getReserveOne(), "extension")) {
                    if (StringUtils.equals(controlType, ControlType.STR_LABEL)) {
                        TagNode labelNode = diff.getVestXmlTree().xmlTree.getTagNode(controlType + "@" + diff.getKey());
                        Map<String, String> newAttributes = new HashMap<>();
                        newAttributes.put(ConstantUtil.KEY, diff.getKey());
                        newAttributes.put(ConstantUtil.X, diff.x.toString());
                        newAttributes.put(ConstantUtil.Y, diff.y.toString());
                        labelNode.setAttributes(newAttributes);
                        children.add(children.size() - 6, labelNode);
                    } else {
                        TagNode node = diff.getVestXmlTree().xmlTree.getTagNode(controlType + "@" + diff.getKey());
                        if (Objects.isNull(node)) {
                            for (MetaFormProfile metaFormProfile : metaFormList) {
                                if (metaFormProfile != null) {
                                    Boolean mergeToSource = metaFormProfile.getMergeToSource();
                                    if (mergeToSource && metaForm.getExtend().equals(metaFormProfile.getExtend())) {
                                        MetaForm form = metaFormProfile.getForm();
                                        String filePath = LoadFileTree.getPathByFormKey(form.getKey());
                                        XmlTreeWithPath xmlTree = XmlTreeWithPath.parseFilePath(filePath);
                                        diff.setVestXmlTree(xmlTree);
                                        node = xmlTree.xmlTree.getTagNode(controlType + "@" + diff.getKey());
                                    }
                                }
                            }

                        }
                        Map<String, String> newAttributes = new HashMap<>();
                        newAttributes.put(ConstantUtil.KEY, diff.getKey());
                        newAttributes.put(ConstantUtil.X, diff.x.toString());
                        newAttributes.put(ConstantUtil.Y, diff.y.toString());
                        node.setAttributes(newAttributes);
                        node.getChildren().clear();
                        children.add(children.size() - 6, node);
                    }
                } else {
                    TagNode node = new TagNode(controlType, null);
                    if ("Button".equalsIgnoreCase(controlType)) {
                        setBasicProperty(node, diff);
                        children.add(children.size() - 6, node);
                    } else if ("Separator".equalsIgnoreCase(controlType)) {
                        setBasicProperty(node, diff);
                        children.add(children.size() - 6, node);
                    } else if ("Chart".equalsIgnoreCase(controlType)) {
                        setBasicProperty(node, diff);
                        children.add(children.size() - 6, node);
                    } else if ("TabGroup".equalsIgnoreCase(controlType)) {
                        TagNode tabItemNode = new TagNode("TabItem", null);
                        tabItemNode.setAttribute("Key", diff.getKey()+"_TabItem1");
                        tabItemNode.setAttribute("Text", "菜单1");
                        tabItemNode.setAttribute("Icon", "App/Default/TabGroup/Icon1.png");
                        tabItemNode.setAttribute("SelectedIcon", "App/Default/TabGroup/Select1.png");
                        node.addNode(tabItemNode);
                        setBasicProperty(node, diff);
                        children.add(children.size() - 6, node);
                    } else if ("Carousel".equals(controlType)) {
                        TagNode itemNode1 = new TagNode("Item", null);
                        itemNode1.setAttribute("Key", "Item1");
                        itemNode1.setAttribute("Caption", "Item1");
                        itemNode1.setAttribute("Value", "App/Default/Rotator/rotator1.jpg");
                        TagNode itemNode2 = new TagNode("Item", null);
                        itemNode2.setAttribute("Key", "Item2");
                        itemNode2.setAttribute("Caption", "Item2");
                        itemNode2.setAttribute("Value", "App/Default/Rotator/rotator2.jpg");
                        node.addNode(itemNode1);
                        node.addNode(itemNode2);
                        setBasicProperty(node, diff);
                        children.add(children.size() - 6, node);
                    } else {
                        if (Objects.isNull(diff.x)) {
                            diff.x = 0;
                        }
                        if (Objects.isNull(diff.y)) {
                            diff.y = 0;
                        }
                        setBasicProperty(node, diff);

                        //当添加的组件类型为字典时添加默认字典标识作为提示
                        boolean isMultiDict = false; // 多选字典
                        if ("Dict".equalsIgnoreCase(controlType)) {
                            if (StringUtils.isNotEmpty(diff.getItemKey())) {
                                node.setAttribute(ConstantUtil.ITEM_KEY, diff.getItemKey());
                                if (diff.getItemKey().endsWith("__Dic")) {
                                    node.setAttribute(Property.StateMask.name,"Enable|Disable|Discard");
                                }
                            } else {
                                if(metaForm.getFormType() != FormType.Extension)
                                    throw new Throwable("ItemKey为空，请检查配置");
                            }
                            if (diff.properties.size() > 0) { // 字典控件多选的处理
                                if (Property.AllowMultiSelection.name.equals(diff.properties.get(0).property.name)) {
                                    node.setAttribute(Property.AllowMultiSelection.name, diff.properties.get(0).newValue);
                                    isMultiDict = true;
                                }
                            }
                        } else if ("DynamicDict".equalsIgnoreCase(controlType)) {
                            node.setAttribute(ConstantUtil.REF_KEY, diff.getReserveOne());
                        } else if (ControlType.STR_COMBOBOX.equalsIgnoreCase(controlType) || ControlType.STR_CHECKLISTBOX.equalsIgnoreCase(controlType)) {
                            node.setAttribute(ConstantUtil.CACHE, "false");
                        } else if ("RadioButton".equalsIgnoreCase(controlType)) {
                            node.setAttribute("IsGroupHead", "true");
                        }

                        addDomainPropertyToNode(node,controlType,diff.getDataElementKey());

                        List<TagNode> dataObject = diff.getXmlTree().xmlTree.getRoot().findNodesByTagName(MetaObjectType.DataObject.name);
                        //新增组件的时候同时在数据源中添加一条数据
                        List<TagNode> column = diff.getXmlTree().xmlTree.getRoot().findNodesByTagName(ConstantUtil.COLUMN);
//						Boolean mergeToSource1 = metaFormList.get(metaForm.getKey()).getMergeToSource();
                        if (diff.getMetaForm().getDataSource() != null && !"".equals(diff.getMetaForm().getDataSource().getRefObjectKey())) {
                            //引入数据对象表单
                            dataObject = diff.getDataObjectXmlTree().xmlTree.getRoot().findNodesByTagName(MetaObjectType.DataObject.name);
                            TagNode tagNode = diff.getDataObjectXmlTree().xmlTree.getTagNode(ConstantUtil.TABLE + "@" + diff.getReserveTwo());
                            if (Objects.nonNull(tagNode)) {
                                column.addAll(tagNode.findNodesByTagName(ConstantUtil.COLUMN));
                            }
                            if (Objects.nonNull(diff.getOtherDataObjectOrgTree())) {
                                TagNode tagNode2 = diff.getOtherDataObjectOrgTree().xmlTree.getTagNode(ConstantUtil.TABLE + "@" + diff.getReserveTwo());
                                if (Objects.nonNull(tagNode2)) {
                                    column.addAll(tagNode2.findNodesByTagName(ConstantUtil.COLUMN));
                                }
                            }
                        }
                        boolean exist = false;
                        if (dataObject.size() != 0 && "".equalsIgnoreCase(selectComp.getParentGridKey())) {
                            int controlTypeE = diff.getControlType();
                            String objectKey = metaForm.getDataSource().getDataObject().getKey();
                            String extendKey = metaForm.getExtend();
                            MetaFormProfile metaFormProfile = metaFormList.get(metaForm.getKey());
                            if(metaFormProfile == null) metaFormProfile = metaFactory.getExtFormList().get(metaForm.getKey());
                            Boolean mergeToSource = metaFormProfile.getMergeToSource();
                            if (!StringUtils.equals(objectKey, extendKey)) {
                                if ("true".equalsIgnoreCase(diff.getReserveFour())) {//添加数据源
                                    for (TagNode tagNode : column) {
                                        if (diff.getReserveThree().equalsIgnoreCase(tagNode.getAttributes().get(ConstantUtil.KEY))) {
                                            exist = true;
                                        }
                                    }
                                    if (!exist) {//不存在数据源
                                        String key = diff.getReserveThree();
                                        if (!"无字段".equals(key) && StringUtils.isNotEmpty(key)) {
                                            key = diff.getReserveThree().substring(0, 1).toUpperCase() + diff.getReserveThree().substring(1);//首字母转大写
                                            TagNode newDataBindingnode = new TagNode(MetaDataBinding.TAG_NAME, null);//新增头表组件就给他默认设置表为主表
                                            newDataBindingnode.setAttribute(ConstantUtil.TABLE_KEY, diff.getReserveTwo());
                                            TagNode newColumn = new TagNode(ConstantUtil.COLUMN, null);//新增头表组件就给他默认设置一个新的column节点
                                            newColumn.setAttribute(ConstantUtil.KEY, key);
                                            newColumn.setAttribute(ConstantUtil.CAPTION, diff.caption);
                                            //newColumn.setAttribute(ConstantUtil.DATA_TYPE, getDatatypeContainerMultiDict(controlTypeE, isMultiDict));
                                            if(StringUtils.isEmpty(diff.getDataElementKey())){
                                                newColumn.setAttribute(ConstantUtil.DATA_TYPE, getDatatypeContainerMultiDict(controlTypeE, isMultiDict));
                                            }else{
                                                newColumn.setAttribute(ConstantUtil.DataElementKey, diff.getDataElementKey());
                                            }
                                            if ("Dict".equalsIgnoreCase(controlType) || "DynamicDict".equalsIgnoreCase(controlType)) {
                                                codeAndNameWithDictComponent(diff, key, diff.getReserveTwo(), newColumn);
                                            }
                                            //newColumn.setAttribute(ConstantUtil.DB_COLUMN_NAME, key);
                                            if ("Varchar".equalsIgnoreCase(getDatatypeContainerMultiDict(controlTypeE, isMultiDict))) {
                                                newColumn.setAttribute(ConstantUtil.LENGTH, "255");
                                            }
                                            if (StringUtils.isNotEmpty(diff.getMetaForm().getDataSource().getRefObjectKey())) {
                                                TagNode tableNode = diff.getDataObjectXmlTree().xmlTree.getTagNode(ConstantUtil.TABLE + "@" + diff.getReserveTwo());
                                                tableNode.addNode(newColumn);
                                                genXmlDiff(diff.getDataObjectXmlTree(), tableNode, diff, false);
                                            } else {
                                                TagNode tableNode = diff.getXmlTree().xmlTree.getTagNode(ConstantUtil.TABLE + "@" + diff.getReserveTwo());
                                                tableNode.addNode(newColumn);
                                                genXmlDiff(diff.getXmlTree(), tableNode, diff, false);
                                            }
                                            newDataBindingnode.setAttribute(ConstantUtil.COLUMN_KEY, key);
                                            node.addNode(newDataBindingnode);
                                        }
                                    } else {//存在数据源
                                        TagNode newDataBindingnode = new TagNode(MetaDataBinding.TAG_NAME, null);//新增头表组件就给他默认设置表为主表
                                        newDataBindingnode.setAttribute(ConstantUtil.TABLE_KEY, diff.getReserveTwo());
                                        newDataBindingnode.setAttribute(ConstantUtil.COLUMN_KEY, diff.getReserveThree());
                                        node.addNode(newDataBindingnode);
                                    }
                                }
                            } else {
                                if (mergeToSource) {
                                    //首字母转大写
                                    if ("true".equalsIgnoreCase(diff.getReserveFour())) {//添加数据源
                                        for (TagNode tagNode : column) {
                                            if (StringUtils.equalsIgnoreCase(tagNode.getAttributes().get(ConstantUtil.KEY), diff.getReserveThree())) {
                                                exist = true;
                                            }
                                        }
                                        TagNode newDataBindingNode = new TagNode(MetaDataBinding.TAG_NAME, null);//新增头表组件就给他默认设置表为主表
                                        newDataBindingNode.setAttribute(ConstantUtil.TABLE_KEY, diff.getReserveTwo());
                                        String key = diff.getReserveThree();
                                        if (StringUtils.isNotEmpty(diff.getReserveThree())) {
                                            key = diff.getReserveThree().substring(0, 1).toUpperCase() + diff.getReserveThree().substring(1);
                                        }
                                        if (!exist) {
                                            TagNode newColumn = new TagNode(ConstantUtil.COLUMN, null);//新增头表组件就给他默认设置一个新的column节点
                                            newColumn.setAttribute(ConstantUtil.KEY, key);
                                            newColumn.setAttribute(ConstantUtil.CAPTION, diff.caption);
                                            if(StringUtils.isEmpty(diff.getDataElementKey())){
                                                newColumn.setAttribute(ConstantUtil.DATA_TYPE, getDatatypeContainerMultiDict(controlTypeE, isMultiDict));
                                            }else{
                                                newColumn.setAttribute(ConstantUtil.DataElementKey, diff.getDataElementKey());
                                            }

                                            //newColumn.setAttribute(ConstantUtil.DB_COLUMN_NAME, key);
                                            if ("Dict".equalsIgnoreCase(controlType) || "DynamicDict".equalsIgnoreCase(controlType)) {
                                                codeAndNameWithDictComponent(diff, key, diff.getReserveTwo(), newColumn);
                                            }
                                            if ("Varchar".equalsIgnoreCase(getDatatypeContainerMultiDict(controlTypeE, isMultiDict))) {
                                                newColumn.setAttribute(ConstantUtil.LENGTH, "255");
                                            }
                                            TagNode tableNode = diff.getTagNode(ConstantUtil.TABLE + "@" + diff.getReserveTwo());
                                            tableNode.addNode(newColumn);
                                            genXmlDiff(diff.getXmlTree(), tableNode, diff, false);
                                        }
                                        if (!"无字段".equals(key) && StringUtils.isNotEmpty(key)) {
                                            newDataBindingNode.setAttribute(ConstantUtil.COLUMN_KEY, key);
                                            node.addNode(newDataBindingNode);
                                        }
                                    }
                                }
                            }
                        } else {
                            TagNode newDataBindingnode = new TagNode(MetaDataBinding.TAG_NAME, null);
                            node.addNode(newDataBindingnode);
                        }
                        if ("NumberEditor".equalsIgnoreCase(controlType)) {
                            TagNode formatNode = new TagNode(ConstantUtil.FORMAT, null);
                            formatNode.setAttribute("HAlign", "Right");
                            node.addNode(formatNode);

                            MetaTable metaTable = metaForm.getMetaTable(diff.getReserveTwo());
                            if (metaTable != null) {
                                for (MetaColumn metaColumn : metaTable) {
                                    if (metaColumn.getKey().equals(diff.getReserveThree())) {
                                        if (metaColumn.getDataType() == DataType.INT) { //数值控件绑定数据源为整型时，默认数值精度为9
                                            node.setAttribute(MetaConstants.NUMBEREDITOR_PRECISION, "9");
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                        if (controlType.equals(ControlType.STR_LABEL)) {
                            children.add(children.size() - 3, node);
                        } else {
                            if(selectNode.getParent().getTagName().equals("TableRow")){
                                node.setAttribute("Class", "innerLabel-show");
                            }
                            children.add(children.size() - 6, node);
                        }
                    }
                }
            }
            else if (selectComp instanceof MetaFlexGridLayoutPanel) {
                if (diff.isButtonQuote) {
                    List<AbstractNode> children = selectNode.getChildren();
                    if (StringUtils.equals(controlType, ControlType.STR_LABEL)) {
                        TagNode labelNode = diff.getVestXmlTree().xmlTree.getTagNode(controlType + "@" + diff.getKey());
                        Map<String, String> newAttributes = new HashMap<>();
                        newAttributes.put(ConstantUtil.KEY, diff.getKey());
                        newAttributes.put(ConstantUtil.X, diff.x.toString());
                        newAttributes.put(ConstantUtil.Y, diff.y.toString());
                        labelNode.setAttributes(newAttributes);
                        children.add(children.size() - 6, labelNode);
                    } else {
                        TagNode node = diff.getVestXmlTree().xmlTree.getTagNode(controlType + "@" + diff.getKey());
                        if (Objects.isNull(node)) {
                            for (MetaFormProfile metaFormProfile : metaFormList) {
                                if (metaFormProfile != null) {
                                    Boolean mergeToSource = metaFormProfile.getMergeToSource();
                                    if (mergeToSource && metaForm.getExtend().equals(metaFormProfile.getExtend())) {
                                        MetaForm form = metaFormProfile.getForm();
                                        String filePath = LoadFileTree.getPathByFormKey(form.getKey());
                                        XmlTreeWithPath xmlTree = XmlTreeWithPath.parseFilePath(filePath);
                                        diff.setVestXmlTree(xmlTree);
                                        node = xmlTree.xmlTree.getTagNode(controlType + "@" + diff.getKey());
                                    }
                                }
                            }

                        }
                        Map<String, String> newAttributes = new HashMap<>();
                        newAttributes.put(ConstantUtil.KEY, diff.getKey());
                        newAttributes.put(ConstantUtil.X, diff.x.toString());
                        newAttributes.put(ConstantUtil.Y, diff.y.toString());
                        node.setAttributes(newAttributes);
                        node.getChildren().clear();
                        children.add(children.size() - 6, node);
                    }
                } else {
                    TagNode node = new TagNode(controlType, null);

                    if (Objects.isNull(diff.x)) {
                        diff.x = 0;
                    }
                    if (Objects.isNull(diff.y)) {
                        diff.y = 0;
                    }
                    setBasicProperty(node, diff);

                    List<AbstractNode> children = selectNode.getChildren();
                    if (StringUtils.isNotBlank(diff.sideKey)) {
                        final AbstractNode sideNode = children.stream()
                                .filter(item -> {
                                    boolean b = (item instanceof TagNode);
                                    if (!b) {
                                        return false;
                                    }
                                    TagNode tagNode = (TagNode) item;
                                    final String tagNodeKey = tagNode.getAttributes().get(ConstantUtil.KEY);
                                    return StringUtils.equalsIgnoreCase(tagNodeKey, diff.sideKey);
                                }).findFirst().orElse(null);
                        if (Objects.isNull(sideNode)) {
                            children.add(node);
                        } else {
                            final int i = children.indexOf(sideNode);
                            if (diff.insertAfter) {
                                children.add(i + 1, node);
                            } else {
                                children.add(i, node);
                            }
                        }
                    } else {
                        if (CollectionUtils.isNotEmpty(children)) {
                            children.add(children.size() - 1, node);
                        } else {
                            children.add(node);
                        }
                    }

                    if (!StringUtils.equalsAnyIgnoreCase(controlType, "Button", "Separator")) {
                        //当添加的组件类型为字典时添加默认字典标识作为提示
                        boolean isMultiDict = false; // 多选字典
                        if ("Dict".equalsIgnoreCase(controlType)) {
                            if (StringUtils.isNotEmpty(diff.getItemKey())) {
                                node.setAttribute(ConstantUtil.ITEM_KEY, diff.getItemKey());
                            } else {
                                throw new Throwable("ItemKey为空，请检查配置");
                            }
                            if (diff.properties.size() > 0) { // 字典控件多选的处理
                                if (Property.AllowMultiSelection.name.equals(diff.properties.get(0).property.name)) {
                                    node.setAttribute(Property.AllowMultiSelection.name, diff.properties.get(0).newValue);
                                    isMultiDict = true;
                                }
                            }
                        }
                        else if ("DynamicDict".equalsIgnoreCase(controlType)) {
                            node.setAttribute(ConstantUtil.REF_KEY, diff.getReserveOne());
                        } else if (ControlType.STR_COMBOBOX.equalsIgnoreCase(controlType) || ControlType.STR_CHECKLISTBOX.equalsIgnoreCase(controlType)) {
                            node.setAttribute(ConstantUtil.CACHE, "false");
                        }
                        else if ("RadioButton".equalsIgnoreCase(controlType)) {
                            node.setAttribute("IsGroupHead", "true");
                        }
                        List<TagNode> dataObject = diff.getXmlTree().xmlTree.getRoot().findNodesByTagName(MetaObjectType.DataObject.name);
                        //新增组件的时候同时在数据源中添加一条数据
                        List<TagNode> column = diff.getXmlTree().xmlTree.getRoot().findNodesByTagName(ConstantUtil.COLUMN);
//						Boolean mergeToSource1 = metaFormList.get(metaForm.getKey()).getMergeToSource();
                        if (diff.getMetaForm().getDataSource() != null && !"".equals(diff.getMetaForm().getDataSource().getRefObjectKey())) {
                            //引入数据对象表单
                            dataObject = diff.getDataObjectXmlTree().xmlTree.getRoot().findNodesByTagName(MetaObjectType.DataObject.name);
                            TagNode tagNode = diff.getDataObjectXmlTree().xmlTree.getTagNode(ConstantUtil.TABLE + "@" + diff.getReserveTwo());
                            if (Objects.nonNull(tagNode)) {
                                column.addAll(tagNode.findNodesByTagName(ConstantUtil.COLUMN));
                            }
                            if (Objects.nonNull(diff.getOtherDataObjectOrgTree())) {
                                TagNode tagNode2 = diff.getOtherDataObjectOrgTree().xmlTree.getTagNode(ConstantUtil.TABLE + "@" + diff.getReserveTwo());
                                if (Objects.nonNull(tagNode2)) {
                                    column.addAll(tagNode2.findNodesByTagName(ConstantUtil.COLUMN));
                                }
                            }
                        }
                        boolean exist = false;
                        if (dataObject.size() < 1 || StringUtils.isNotBlank(selectComp.getParentGridKey())) {
                            TagNode newDataBindingnode = new TagNode(MetaDataBinding.TAG_NAME, null);
                            node.addNode(newDataBindingnode);
                        } else {
                            int controlTypeE = diff.getControlType();
                            String objectKey = metaForm.getDataSource().getDataObject().getKey();
                            String extendKey = metaForm.getExtend();
                            MetaFormProfile metaFormProfile = metaFormList.get(metaForm.getKey());
                            if(metaFormProfile == null) metaFormProfile = metaFactory.getExtFormList().get(metaForm.getKey());
                            Boolean mergeToSource = metaFormProfile.getMergeToSource();
                            if (!StringUtils.equals(objectKey, extendKey)) {
                                if ("true".equalsIgnoreCase(diff.getReserveFour())) {//添加数据源
                                    for (TagNode tagNode : column) {
                                        if (diff.getReserveThree().equalsIgnoreCase(tagNode.getAttributes().get(ConstantUtil.KEY))) {
                                            exist = true;
                                        }
                                    }
                                    if (!exist) {//不存在数据源
                                        String key = diff.getReserveThree();
                                        if (!"无字段".equals(key) && StringUtils.isNotEmpty(key)) {
                                            key = diff.getReserveThree().substring(0, 1).toUpperCase() + diff.getReserveThree().substring(1);//首字母转大写
                                            TagNode newDataBindingnode = new TagNode(MetaDataBinding.TAG_NAME, null);//新增头表组件就给他默认设置表为主表
                                            newDataBindingnode.setAttribute(ConstantUtil.TABLE_KEY, diff.getReserveTwo());
                                            TagNode newColumn = new TagNode(ConstantUtil.COLUMN, null);//新增头表组件就给他默认设置一个新的column节点
                                            newColumn.setAttribute(ConstantUtil.KEY, key);
                                            newColumn.setAttribute(ConstantUtil.CAPTION, diff.caption);
                                            newColumn.setAttribute(ConstantUtil.DATA_TYPE, getDatatypeContainerMultiDict(controlTypeE, isMultiDict));
                                            if ("Dict".equalsIgnoreCase(controlType) || "DynamicDict".equalsIgnoreCase(controlType)) {
                                                codeAndNameWithDictComponent(diff, key, diff.getReserveTwo(), newColumn);
                                            }
                                            //newColumn.setAttribute(ConstantUtil.DB_COLUMN_NAME, key);
                                            if ("Varchar".equalsIgnoreCase(getDatatypeContainerMultiDict(controlTypeE, isMultiDict))) {
                                                newColumn.setAttribute(ConstantUtil.LENGTH, "255");
                                            }
                                            if (StringUtils.isNotEmpty(diff.getMetaForm().getDataSource().getRefObjectKey())) {
                                                TagNode tableNode = diff.getDataObjectXmlTree().xmlTree.getTagNode(ConstantUtil.TABLE + "@" + diff.getReserveTwo());
                                                tableNode.addNode(newColumn);
                                                genXmlDiff(diff.getDataObjectXmlTree(), tableNode, diff, false);
                                            } else {
                                                TagNode tableNode = diff.getXmlTree().xmlTree.getTagNode(ConstantUtil.TABLE + "@" + diff.getReserveTwo());
                                                tableNode.addNode(newColumn);
                                                genXmlDiff(diff.getXmlTree(), tableNode, diff, false);
                                            }
                                            newDataBindingnode.setAttribute(ConstantUtil.COLUMN_KEY, key);
                                            node.addNode(newDataBindingnode);
                                        }
                                    } else {//存在数据源
                                        TagNode newDataBindingnode = new TagNode(MetaDataBinding.TAG_NAME, null);//新增头表组件就给他默认设置表为主表
                                        newDataBindingnode.setAttribute(ConstantUtil.TABLE_KEY, diff.getReserveTwo());
                                        newDataBindingnode.setAttribute(ConstantUtil.COLUMN_KEY, diff.getReserveThree());
                                        node.addNode(newDataBindingnode);
                                    }
                                }
                            }
                            else {
                                if (mergeToSource) {
                                    //首字母转大写
                                    if ("true".equalsIgnoreCase(diff.getReserveFour())) {//添加数据源
                                        for (TagNode tagNode : column) {
                                            if (StringUtils.equalsIgnoreCase(tagNode.getAttributes().get(ConstantUtil.KEY), diff.getReserveThree())) {
                                                exist = true;
                                            }
                                        }
                                        TagNode newDataBindingNode = new TagNode(MetaDataBinding.TAG_NAME, null);//新增头表组件就给他默认设置表为主表
                                        newDataBindingNode.setAttribute(ConstantUtil.TABLE_KEY, diff.getReserveTwo());
                                        String key = diff.getReserveThree();
                                        if (StringUtils.isNotEmpty(diff.getReserveThree())) {
                                            key = diff.getReserveThree().substring(0, 1).toUpperCase() + diff.getReserveThree().substring(1);
                                        }
                                        if (!exist) {
                                            TagNode newColumn = new TagNode(ConstantUtil.COLUMN, null);//新增头表组件就给他默认设置一个新的column节点
                                            newColumn.setAttribute(ConstantUtil.KEY, key);
                                            newColumn.setAttribute(ConstantUtil.CAPTION, diff.caption);
                                            newColumn.setAttribute(ConstantUtil.DATA_TYPE, getDatatypeContainerMultiDict(controlTypeE, isMultiDict));
                                            //newColumn.setAttribute(ConstantUtil.DB_COLUMN_NAME, key);
                                            if ("Dict".equalsIgnoreCase(controlType) || "DynamicDict".equalsIgnoreCase(controlType)) {
                                                codeAndNameWithDictComponent(diff, key, diff.getReserveTwo(), newColumn);
                                            }
                                            if ("Varchar".equalsIgnoreCase(getDatatypeContainerMultiDict(controlTypeE, isMultiDict))) {
                                                newColumn.setAttribute(ConstantUtil.LENGTH, "255");
                                            }
                                            TagNode tableNode = diff.getXmlTree().xmlTree.getTagNode(ConstantUtil.TABLE + "@" + diff.getReserveTwo());
                                            tableNode.addNode(newColumn);
                                            genXmlDiff(diff.getXmlTree(), tableNode, diff, false);
                                        }
                                        if (!"无字段".equals(key) && StringUtils.isNotEmpty(key)) {
                                            newDataBindingNode.setAttribute(ConstantUtil.COLUMN_KEY, key);
                                            node.addNode(newDataBindingNode);
                                        }
                                    }
                                }
                            }
                        }
                        if ("NumberEditor".equalsIgnoreCase(controlType)) {
                            TagNode formatNode = new TagNode(ConstantUtil.FORMAT, null);
                            formatNode.setAttribute("HAlign", "Right");
                            node.addNode(formatNode);

                            MetaTable metaTable = metaForm.getMetaTable(diff.getReserveTwo());
                            if (metaTable != null) {
                                for (MetaColumn metaColumn : metaTable) {
                                    if (metaColumn.getKey().equals(diff.getReserveThree())) {
                                        if (metaColumn.getDataType() == DataType.INT) { //数值控件绑定数据源为整型时，默认数值精度为9
                                            node.setAttribute(MetaConstants.NUMBEREDITOR_PRECISION, "9");
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            else if (selectComp instanceof MetaTabPanel
                    || selectComp instanceof MetaFlexFlowLayoutPanel || selectComp instanceof MetaLinearLayoutPanel) {
                List<AbstractNode> children = selectNode.getChildren();
                TagNode node = new TagNode(controlType, null);
                node.setAttribute(ConstantUtil.KEY, diff.getKey());
                node.setAttribute(ConstantUtil.CAPTION, diff.caption);
                if(selectNode.getParent().getTagName().equals("TableRow")){
                    node.setAttribute("Class", "innerLabel-show");
                }
                if (controlType.equals(ControlType.STR_LABEL)) { // 只新增标签
                    if(children.size() >= 2) {
                        children.add(children.size() - 2, node);
                    }else{
                        children.add(node);
                    }
                } else if (StringUtils.equalsIgnoreCase(controlType, "RadioButton")) {
                    node.setAttribute("IsGroupHead", "true");
                    if(children.size() >= 6) {
                        children.add(children.size() - 6, node);
                    }else{
                        children.add(node);
                    }
                } else if (StringUtils.equalsIgnoreCase(controlType, "TabGroup")) {
                    TagNode tabItemNode = new TagNode("TabItem", null);
                    tabItemNode.setAttribute("Key", diff.getKey()+"_TabItem1");
                    tabItemNode.setAttribute("Text", "菜单1");
                    tabItemNode.setAttribute("Icon", "App/Default/TabGroup/Icon1.png");
                    tabItemNode.setAttribute("SelectedIcon", "App/Default/TabGroup/Select1.png");
                    node.addNode(tabItemNode);
                    if(children.size() >= 2){
                        children.add(children.size() - 2, node);
                    } else {
                        children.add(node);
                    }
                } else if (StringUtils.equalsIgnoreCase(controlType, "Carousel")) {
                    TagNode itemNode1 = new TagNode("Item", null);
                    itemNode1.setAttribute("Key", "Item1");
                    itemNode1.setAttribute("Caption", "Item1");
                    itemNode1.setAttribute("Value", "App/Default/Rotator/rotator1.jpg");
                    TagNode itemNode2 = new TagNode("Item", null);
                    itemNode2.setAttribute("Key", "Item2");
                    itemNode2.setAttribute("Caption", "Item2");
                    itemNode2.setAttribute("Value", "App/Default/Rotator/rotator2.jpg");
                    node.addNode(itemNode1);
                    node.addNode(itemNode2);
                    if(children.size() >= 2){
                        children.add(children.size() - 2, node);
                    } else {
                        children.add(node);
                    }

                } else if (StringUtils.equalsIgnoreCase(controlType, "RefreshControl")) {
                    TagNode rootCompNode = new TagNode("FlexFlowLayoutPanel", null);
                    rootCompNode.setAttribute("Key", diff.getKey() + "MainComp");
                    rootCompNode.setAttribute("Caption", diff.getKey() + "MainComp");
                    rootCompNode.setAttribute("OverflowY", "Scroll");

                    node.addNode(rootCompNode);
                    children.add(node);
                } else if (StringUtils.equalsIgnoreCase(controlType, "EditView")) {
                    node.setAttribute("RowHeight", "130");
                    node.setAttribute("Width", "100%");
                    TagNode rowNode = new TagNode("EditViewRow", null);
                    rowNode.setAttribute("TopMargin", "10px");

                    TagNode bodyNode = diff.getXmlTree().xmlTree.getRoot().getChildByTagName("Body");

                    TagNode viewCollectionNode = bodyNode.getOrCreateChildByTagName("ViewCollection");
                    TagNode viewNode = viewCollectionNode.getChildByKey("Android");

                    if (viewNode == null) {
                        viewNode = new TagNode("View", null);
                        viewNode.setAttribute("Caption", "Caption");
                        viewNode.setAttribute("Key", "Android");
                        viewNode.setAttribute("Media", "WEB|PC|IOS|ANDROID|");

                        viewCollectionNode.addNode(viewNode);
                    }

                    viewNode.addNode(getDefaultComponentView(diff.getKey()));

                    if(children.size() >= 2){
                        children.add(children.size() - 2, node);
                    } else {
                        children.add(node);
                    }

                    genXmlDiff(diff.getXmlTree(), bodyNode, diff, true);

                    return anInt;

                } else if (StringUtils.equalsAnyIgnoreCase(controlType, "Button", "Separator", "Chart", "Container", "Switch", "HoverButton")) {
                    if(children.size() >= 2){
                        children.add(children.size() - 2, node);
                    } else {
                        children.add(node);
                    }
                } else {
                    if (!Objects.equals(diff.getIsButtonQuote(), Boolean.TRUE)) {//他是引入组件
                        //当添加的组件类型为字典时添加默认字典标识作为提示
                        if (ControlType.STR_DICT.equalsIgnoreCase(controlType)) {
                            if (!diff.getIsButtonQuote()) {//不是引入组件
                                node.setAttribute(ConstantUtil.ITEM_KEY, diff.getItemKey());
                            }
                        } else if (StringUtils.equalsAnyIgnoreCase(controlType, ControlType.STR_COMBOBOX, ControlType.STR_CHECKLISTBOX)) {
                            node.setAttribute(ConstantUtil.CACHE, "false");
                        } else if (ControlType.STR_DYNAMICDICT.equalsIgnoreCase(controlType)) {
                            node.setAttribute("DynamicItemKey", "root");
                        }
                    }

                    List<TagNode> dataObject = diff.getXmlTree().xmlTree.getRoot().findNodesByTagName(MetaObjectType.DataObject.name);
                    //新增组件的时候同时在数据源中添加一条数据
                    List<TagNode> column = diff.getXmlTree().xmlTree.getRoot().findNodesByTagName(ConstantUtil.COLUMN);
                    MetaFormProfile metaFormProfile = metaFormList.get(metaForm.getKey());
                    if(metaFormProfile == null) metaFormProfile = metaFactory.getExtFormList().get(metaForm.getKey());
                    Boolean mergeToSource1 = metaFormProfile.getMergeToSource();
                    if (diff.getMetaForm().getDataSource() != null && !"".equals(diff.getMetaForm().getDataSource().getRefObjectKey()) && !mergeToSource1) {
                        //引入数据对象表单
                        dataObject = diff.getDataObjectXmlTree().xmlTree.getRoot().findNodesByTagName(MetaObjectType.DataObject.name);
                        column = diff.getDataObjectXmlTree().xmlTree.getRoot().findNodesByTagName(ConstantUtil.COLUMN);
                    }
                    boolean exist = false;
                    String kkey = "";
                    for (TagNode tagNode : column) {
                        if (diff.getKey().equalsIgnoreCase(tagNode.getAttributes().get(ConstantUtil.KEY))) {
                            kkey = tagNode.getAttributes().get(ConstantUtil.KEY);
                            exist = true;
                        }
                    }
                    if (dataObject.size() != 0 && "".equalsIgnoreCase(selectComp.getParentGridKey())) {
                        String mainTableKey = metaForm.getDataSource().getDataObject().getMainTableKey();
                        if (mainTableKey != null && mainTableKey.length() > 0 && !mainTableKey.equalsIgnoreCase(null)) {
                            int controlTypeE = diff.getControlType();
                            String objectKey = metaForm.getDataSource().getDataObject().getKey();
                            String extendKey = metaForm.getExtend();
                            Boolean mergeToSource = metaFormProfile.getMergeToSource();
                            if (objectKey.equals(extendKey) && !mergeToSource) {//因为现在界面马甲无法修改数据源所以界面马甲不做处理
                                TagNode newDataBindingnode = new TagNode(MetaDataBinding.TAG_NAME, null);//新增头表组件就给他默认设置表为主表
                                if (!Objects.equals(diff.getIsButtonQuote(), Boolean.TRUE)) {//不是引入组件
                                    node.addNode(newDataBindingnode);
                                }
                            } else if (objectKey.equals(extendKey) && mergeToSource) {//mergeToSource == true
                                if (!Objects.equals(diff.getIsButtonQuote(), Boolean.TRUE)) {//不是引入组件
                                    String key = diff.getKey().substring(0, 1).toUpperCase() + diff.getKey().substring(1);//首字母转大写
                                    TagNode newDataBindingnode = new TagNode(MetaDataBinding.TAG_NAME, null);//新增头表组件就给他默认设置表为主表
                                    newDataBindingnode.setAttribute(ConstantUtil.TABLE_KEY, mainTableKey);
                                    TagNode newColumn = new TagNode(ConstantUtil.COLUMN, null);//新增头表组件就给他默认设置一个新的column节点
                                    newColumn.setAttribute(ConstantUtil.KEY, key);
                                    newColumn.setAttribute(ConstantUtil.CAPTION, diff.caption);
                                    newColumn.setAttribute(ConstantUtil.DATA_TYPE, getDatatype(controlTypeE));
                                    //newColumn.setAttribute(ConstantUtil.DB_COLUMN_NAME, key);
                                    if ("Varchar".equalsIgnoreCase(getDatatype(controlTypeE))) {
                                        newColumn.setAttribute(ConstantUtil.LENGTH, "255");
                                    }
                                    TagNode tableNode = diff.getXmlTree().xmlTree.getTagNode(ConstantUtil.TABLE + "@" + mainTableKey);
                                    tableNode.addNode(newColumn);
                                    genXmlDiff(diff.getXmlTree(), tableNode, diff, false);
                                    newDataBindingnode.setAttribute(ConstantUtil.COLUMN_KEY, key);
                                    node.addNode(newDataBindingnode);
                                }
                            } else {
                                if (!exist) {//不存在数据源
                                    String key = diff.getKey().substring(0, 1).toUpperCase() + diff.getKey().substring(1);//首字母转大写
                                    TagNode newDataBindingnode = new TagNode(MetaDataBinding.TAG_NAME, null);//新增头表组件就给他默认设置表为主表
                                    newDataBindingnode.setAttribute(ConstantUtil.TABLE_KEY, mainTableKey);
                                    TagNode newColumn = new TagNode(ConstantUtil.COLUMN, null);//新增头表组件就给他默认设置一个新的column节点
                                    newColumn.setAttribute(ConstantUtil.KEY, key);
                                    newColumn.setAttribute(ConstantUtil.CAPTION, diff.caption);
                                    newColumn.setAttribute(ConstantUtil.DATA_TYPE, getDatatype(controlTypeE));
                                    //newColumn.setAttribute(ConstantUtil.DB_COLUMN_NAME, key);
                                    if ("Varchar".equalsIgnoreCase(getDatatype(controlTypeE))) {
                                        newColumn.setAttribute(ConstantUtil.LENGTH, "255");
                                    }
                                    if (!"".equals(diff.getMetaForm().getDataSource().getRefObjectKey()) && diff.getMetaForm().getDataSource().getRefObjectKey() != null) {
                                        TagNode tableNode = diff.getDataObjectXmlTree().xmlTree.getTagNode(ConstantUtil.TABLE + "@" + mainTableKey);
                                        tableNode.addNode(newColumn);
                                        genXmlDiff(diff.getDataObjectXmlTree(), tableNode, diff, false);
                                    } else {
                                        TagNode tableNode = diff.getXmlTree().xmlTree.getTagNode(ConstantUtil.TABLE + "@" + mainTableKey);
                                        tableNode.addNode(newColumn);
                                        genXmlDiff(diff.getXmlTree(), tableNode, diff, false);
                                    }
                                    newDataBindingnode.setAttribute(ConstantUtil.COLUMN_KEY, key);
                                    node.addNode(newDataBindingnode);
                                } else {//存在数据源
                                    TagNode newDataBindingnode = new TagNode(MetaDataBinding.TAG_NAME, null);//新增头表组件就给他默认设置表为主表
                                    newDataBindingnode.setAttribute(ConstantUtil.TABLE_KEY, mainTableKey);
                                    newDataBindingnode.setAttribute(ConstantUtil.COLUMN_KEY, kkey);
                                    node.addNode(newDataBindingnode);
                                }
                            }
                        }
                    } else {
                        TagNode newDataBindingnode = new TagNode(MetaDataBinding.TAG_NAME, null);
                        node.addNode(newDataBindingnode);
                    }
                    if (children.size() < 2){
                        // selectComp的子节点数量为空的时候（无闭节点时）
                        children.add(node);
                    }else {
                        // 有闭节点时，再闭节点前添加node
                        children.add(children.size() - 2, node);
                    }
                }
            } else if(selectComp instanceof MetaSplitPanel){
                TagNode tagbPanelNode = new TagNode(controlType, null);
                tagbPanelNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                tagbPanelNode.setAttribute(ConstantUtil.CAPTION, diff.caption);
                addSplitSize(selectNode);
                addNodeToSplitPanel(selectNode, tagbPanelNode);
            }
        } else if (diff.getMetaObjectType() == MetaObjectType.gridField) {
            List<AbstractNode> children = selectNode.getChildren();
            boolean exist = false;
            String kkey = "";
            Integer index;
            int rowIndex = 0;
            int rowDataIndex = -1;
            String sideKey = diff.sideKey;
            for (AbstractNode abstractNode : children) {
                if (abstractNode instanceof TagNode) {
                    String tagName = ((TagNode) abstractNode).getTagName();
                    if (ConstantUtil.GRID_COLUMN_COLLECTION.equals(tagName)) {
                        if (!diff.isButtonQuote) {
                            List<AbstractNode> columns = ((TagNode) abstractNode).getChildren();
                            TagNode node = new TagNode(ConstantUtil.GRID_COLUMN, null);
                            node.setAttribute(ConstantUtil.KEY, diff.getKey());
                            node.setAttribute(ConstantUtil.CAPTION, diff.caption);
                            node.setAttribute(ConstantUtil.WIDTH, "80px");
                            node.setParent(((TagNode) abstractNode));
                            String tableKey = selectComp.getTableKey();
                            TagNode tableNode = diff.getXmlTree().xmlTree.getTagNode(ConstantUtil.TABLE + "@" + tableKey);
                            boolean isRefObjectKey = false;

                            if (metaForm.getDataSource() != null && StringUtils.isNotEmpty(metaForm.getDataSource().getRefObjectKey())) {
                                tableNode = diff.getDataObjectXmlTree().xmlTree.getTagNode(ConstantUtil.TABLE + "@" + tableKey);
                                isRefObjectKey = true;
                            }
                            // 如果 tableNode 还是为null 并且有嵌入数据源 在嵌入数据源中查找
                            if (Objects.isNull(tableNode) && metaForm.getDataSource() != null && metaForm.getDataSource().getDataObject().getEmbedTables() != null) {
                                Optional<MetaEmbedTable> optional = metaForm.getDataSource().getDataObject().getEmbedTables().getList().
                                        stream().filter(metaEmbedTable -> metaEmbedTable.getTableKeys().equals(tableKey)).findFirst();
                                MetaEmbedTable collect = optional.orElse(null);
                                if (collect != null) {
                                    String dataObjectfilePath = LoadFileTree.loadFilePathByDataObjectFieldKey(collect.getObjectKey());
                                    XmlTreeWithPath dataObjectorgTree = XmlTreeWithPath.parseFilePath(dataObjectfilePath);
                                    isRefObjectKey = true;
                                    diff.setDataObjectfilePath(dataObjectfilePath);
                                    diff.setDataObjectXmlTree(dataObjectorgTree);
                                    tableNode = diff.getDataObjectXmlTree().xmlTree.getTagNode(ConstantUtil.TABLE + "@" + tableKey);
                                }
                            }
                            if (tableKey != null && !"".equals(tableKey)) {
                                for (MetaColumn metaColumn : metaForm.getDataSource().getDataObject().getTable(tableKey)) {
                                    if (metaColumn.getKey().equalsIgnoreCase(diff.getKey()) && !tableKey.contains(ConstantUtil.NODB)) {
                                        kkey = metaColumn.getKey();
                                        exist = true;
                                    }
                                }
                            }
                            if (tableKey != null && tableKey.length() != 0 && !tableKey.contains(ConstantUtil.NODB)
                                    && tableNode != null && !"Button".equals(controlType) && "true".equalsIgnoreCase(diff.getReserveTwo())) {
                                if (!exist) {
                                    TagNode newColumnNode = new TagNode(ConstantUtil.COLUMN, null);
                                    newColumnNode.setAttribute(ConstantUtil.KEY, diff.getReserveOne());
                                    newColumnNode.setAttribute(ConstantUtil.CAPTION, diff.caption);
                                    String datatype = getDatatype(diff.getControlType());
                                    if (diff.properties.size() > 0) {
                                        if (Property.AllowMultiSelection.name.equals(diff.properties.get(0).property.name)) {
                                            datatype = getDatatypeContainerMultiDict(diff.getControlType(), true);
                                        }
                                    }
                                    if(StringUtils.isEmpty(diff.getDataElementKey())){
                                        newColumnNode.setAttribute(ConstantUtil.DATA_TYPE, datatype);
                                    }else{
                                        newColumnNode.setAttribute(ConstantUtil.DataElementKey, diff.getDataElementKey());
                                    }
                                    if ("Varchar".equalsIgnoreCase(datatype)) {
                                        newColumnNode.setAttribute(ConstantUtil.LENGTH, "255");
                                    }
                                    if ("Dict".equalsIgnoreCase(controlType) || "DynamicDict".equalsIgnoreCase(controlType)) {
                                        codeAndNameWithDictComponent(diff, diff.getReserveOne(), tableKey, newColumnNode);
                                    }
                                    tableNode.addNode(newColumnNode);
                                    if (isRefObjectKey) {
                                        genXmlDiff(diff.getDataObjectXmlTree(), tableNode, diff, false);
                                    } else {
                                        genXmlDiff(diff.getXmlTree(), tableNode, diff, false);
                                    }
                                }
                            }
                            if ("".equals(sideKey)) {
                                columns.add(columns.size() - 1, node);
                            } else {
                                index = Objects.isNull(compIndex(columns, sideKey)) ? (columns.size()) / 2 : compIndex(columns, sideKey);
                                TagNode columnCollection = selectNode.findFirstTagNodeByTagName(ConstantUtil.GRID_COLUMN_COLLECTION);
                                TagNode treeTagNode = diff.getXmlTree().xmlTree.getTagNode("GridColumn@" + sideKey);
                                if (Objects.isNull(treeTagNode)) {
                                    sideKey = StringUtils.substringBeforeLast(sideKey, "_");
                                    treeTagNode = diff.getXmlTree().xmlTree.getTagNode("GridColumn@" + sideKey);
                                }
                                rowIndex = statisticsRowIndex(columnCollection, sideKey, treeTagNode);
                                if (!diff.insertAfter) {
                                    TagNode childByTagName = treeTagNode.getChildByTagName(ConstantUtil.GRID_COLUMN_COLLECTION);
                                    if (childByTagName != null) {
                                        rowIndex = rowIndex - (statisticsLength(childByTagName) - 1);
                                    }
                                }
                                //统计包含多个子列表格的序号
                                if (!(selectNode.getOrCreateChildByTagName(ConstantUtil.GRID_COLUMN_COLLECTION).getChildren().size() == selectNode.getOrCreateChildByTagName(ConstantUtil.GRID_ROW_COLLECTION).getOrCreateChildByTagName(ConstantUtil.GRID_ROW).getChildren().size()) ||
                                        ConstantUtil.GRID_COLUMN.equalsIgnoreCase(diff.getXmlTree().xmlTree.getTagNode(ConstantUtil.GRID_COLUMN + "@" + sideKey).getParent().getParent().getTagName())) {
                                    TagNode trueNode = diff.getXmlTree().xmlTree.getTagNode(ConstantUtil.GRID_COLUMN + "@" + sideKey).getOrCreateChildByTagName(ConstantUtil.GRID_COLUMN_COLLECTION);
                                    if (trueNode.getChildren().size() == 0) {
                                        trueNode.getParent().deleteChildByTagName(ConstantUtil.GRID_COLUMN_COLLECTION);
                                        columns = trueNode.getParent().getParent().getChildren();
                                        index = Objects.isNull(compIndex(columns, sideKey)) ? (columns.size()) / 2 : compIndex(columns, sideKey);
                                        if (Objects.isNull(diff.getXmlTree().xmlTree.getTagNode("GridCell@" + sideKey))) {
                                            sideKey = diff.getXmlTree().xmlTree.getTagNode(ConstantUtil.GRID_COLUMN + "@" + sideKey).getParent().getParent().getAttributes().get(ConstantUtil.KEY);
                                        }
                                    } else if (diff.getXmlTree().xmlTree.getTagNode(ConstantUtil.GRID_COLUMN + "@" + sideKey).getChildren().size() > 1) {
                                        if (trueNode.getChildren().size() > 3) {
                                            columns = trueNode.getParent().getParent().getChildren();
                                            index = Objects.isNull(compIndex(columns, sideKey)) ? (columns.size()) / 2 : compIndex(columns, sideKey);
                                        }
                                    } else {
                                        diff.getXmlTree().xmlTree.getTagNode(ConstantUtil.GRID_COLUMN + "@" + sideKey).deleteChildByTagName(ConstantUtil.GRID_COLUMN_COLLECTION);
                                    }
                                }
                                if (diff.insertAfter) {
                                    columns.add(index + 2 * diffSize + 1, node);
                                } else {
                                    columns.add(index - 1, node);
                                }
                            }
                        } else {//马甲引入，由于可能出现从子列引入父列同级的组件或从父列引入子列的组件等情况，判断情况较多，等待后期删改
                            List<AbstractNode> columns = ((TagNode) abstractNode).getChildren();
                            TagNode node = null;
                            MetaGridColumn gridMetaColumnByKey = IDLookup.reloadIDLookup(metaForm).getGridMetaColumnByKey(diff.getKey());
                            String oldKey = Objects.isNull(gridMetaColumnByKey) ? diff.getKey() : gridMetaColumnByKey.getMetaKey();
                            List<TagNode> gridColumn = diff.getVestXmlTree().xmlTree.getRoot().findNodesByTagName(ConstantUtil.GRID_COLUMN);
                            for (TagNode tagNode : gridColumn) {
                                String s = tagNode.getAttributes().get(ConstantUtil.KEY);
                                if (s.equalsIgnoreCase(oldKey)) {
                                    node = tagNode;
                                }
                            }
                            TagNode parent = abstractNode.getParent();
                            TagNode gridNode = diff.getVestXmlTree().xmlTree.getTagNode(selectNode.getTagName() + "@" + selectNode.getAttributes().get(ConstantUtil.KEY));
                            TagNode xmlTreeTagNode = diff.getVestXmlTree().xmlTree.getTagNode(parent.getTagName() + "@" + parent.getAttributes().get(ConstantUtil.KEY));
                            List<AbstractNode> vestcolumns = xmlTreeTagNode.findFirstTagNodeByTagName(ConstantUtil.GRID_COLUMN_COLLECTION).getChildren();
                            TagNode columnCollection = gridNode.findFirstTagNodeByTagName(ConstantUtil.GRID_COLUMN_COLLECTION);//原表单
                            TagNode treeTagNode = diff.getXmlTree().xmlTree.getTagNode("GridColumn@" + sideKey);//在马甲表单中查询sideKey
                            if (treeTagNode != null) {
                                String s = treeTagNode.getParent().getParent().getAttributes().get(ConstantUtil.KEY);
                                String tagName1 = treeTagNode.getParent().getParent().getParent().getTagName();
                                if (ConstantUtil.GRID_COLUMN.equalsIgnoreCase(tagName1)) {
                                    sideKey = s;
                                    treeTagNode = treeTagNode.getParent().getParent();
                                }
                                rowIndex = statisticsRowIndex((TagNode) abstractNode, sideKey, treeTagNode);//统计包含多个子列表格的序号
                            }
                            if (Objects.isNull(node)) {//引入子列
                                TagNode orgNode = diff.getVestXmlTree().xmlTree.getTagNode(ConstantUtil.GRID_COLUMN + "@" + oldKey);
                                node = orgNode.getParent().getParent();
                                String parentColumnKey = orgNode.getParent().getParent().getAttributes().get(ConstantUtil.KEY);//添加到对应层级下
                                TagNode currcolumnNode = diff.getXmlTree().xmlTree.getTagNode(ConstantUtil.GRID_COLUMN + "@" + parentColumnKey);
                                TagNode sonNode = null;
                                List<TagNode> nodesByTagName = node.findFirstTagNodeByTagName(ConstantUtil.GRID_COLUMN_COLLECTION).findNodesByTagName(ConstantUtil.GRID_COLUMN);
                                for (TagNode tagNode : nodesByTagName) {
                                    String s = tagNode.getAttributes().get(ConstantUtil.KEY);
                                    if (s.equalsIgnoreCase(oldKey)) {
                                        tagNode.getAttributes().clear();
                                        tagNode.setAttribute(ConstantUtil.KEY, s);
                                        sonNode = tagNode;
                                        break;
                                    }
                                }
                                List<AbstractNode> gridColumnCollection = null;
                                if (Objects.isNull(currcolumnNode)) {//引入删除的一个子列,引入被全部删除的子列目前只考虑单层子列
                                    TagNode tagNode = diff.getVestXmlTree().xmlTree.getTagNode(ConstantUtil.GRID_COLUMN + "@" + parentColumnKey);
                                    TagNode collList = tagNode.findFirstTagNodeByTagName(ConstantUtil.GRID_COLUMN_COLLECTION);
                                    collList.getChildren().clear();
                                    collList.addNode(sonNode);
                                    index = compIndex(columns, sideKey) == 0 ? compIndex(vestcolumns, tagNode.getAttributes().get(ConstantUtil.KEY)) : compIndex(columns, sideKey);
                                    if (!tagNode.getParent().getParent().getTagName().equalsIgnoreCase(ConstantUtil.GRID)) {
                                        columns = currcolumnNode.getParent().findFirstTagNodeByTagName(ConstantUtil.GRID_COLUMN_COLLECTION).getChildren();
                                    }
                                    if (diff.insertAfter) {
                                        if (index >= columns.size() - 1) {
                                            columns.add(columns.size() - 2, node);
                                        } else {
                                            columns.add(index + 1, node);
                                        }
                                    } else {
                                        if (index >= columns.size()) {
                                            columns.add(index == 0 ? 0 : columns.size() - 2, node);
                                        } else {
                                            columns.add(index == 0 ? 0 : index - 1, node);
                                        }
                                    }
                                } else {
                                    TagNode firstTagNodeByTagName = currcolumnNode.findFirstTagNodeByTagName(ConstantUtil.GRID_COLUMN_COLLECTION);
//									List<TagNode> colList = null;
                                    if (firstTagNodeByTagName != null) {
                                        gridColumnCollection = firstTagNodeByTagName.getChildren();
                                    }
                                    gridColumnCollection.add(gridColumnCollection.size() - 1, sonNode);
                                    rowIndex = statisticsRowIndex((TagNode) abstractNode, parentColumnKey, currcolumnNode) - 1;//统计包含多个子列表格的序号
                                    rowDataIndex = statisticsRowIndex(columnCollection, oldKey, sonNode);
                                }
                            } else {
                                index = compIndex(columns, sideKey) == 0 ? compIndex(vestcolumns, diff.getKey()) : compIndex(columns, sideKey);
                                if (diff.insertAfter) {
                                    if (index >= columns.size() - 1) {
                                        columns.add(columns.size() - 2, node);
                                    } else {
                                        columns.add(index + 1, node);
                                    }
                                } else {
                                    if (index >= columns.size()) {
                                        columns.add(index == 0 ? 0 : columns.size() - 2, node);
                                    } else {
                                        columns.add(index == 0 ? 0 : index - 1, node);
                                    }
                                }
                                rowIndex = statisticsRowIndex((TagNode) abstractNode, diff.getKey(), node) - 1;//统计包含多个子列表格的序号
                                TagNode vestNode = diff.getVestXmlTree().xmlTree.getTagNode("GridColumn@" + oldKey);
                                String key = vestNode.getAttributes().get(ConstantUtil.KEY);
                                vestNode.getAttributes().clear();
                                vestNode.setAttribute(ConstantUtil.KEY, key);
                                if (rowIndex < 0) { //
                                    rowIndex = statisticsRowIndex((TagNode) abstractNode, oldKey, node) - 1;
                                }
                                rowDataIndex = statisticsRowIndex(columnCollection, diff.getKey(), vestNode);
                            }
                        }
                    } else if (ConstantUtil.GRID_ROW_COLLECTION.equals(tagName)) {
                        List<AbstractNode> gridRows = ((TagNode) abstractNode).getChildren();
                        if (gridRows.size() / 3 < 2) {//不成立则是存在多GridRow
                            for (AbstractNode gridRow : gridRows) {
                                if (gridRow instanceof TagNode) {
                                    String name = ((TagNode) gridRow).getTagName();
                                    if (ConstantUtil.GRID_ROW.equals(name)) {
                                        List<AbstractNode> rows = ((TagNode) gridRow).getChildren();
                                        List<TagNode> cellList = ((TagNode) gridRow).findMyselfNodesByTagName(ConstantUtil.GRID_CELL);
                                        TagNode node = new TagNode(ConstantUtil.GRID_CELL, null);
                                        node.setAttribute(ConstantUtil.KEY, diff.getKey());
                                        node.setAttribute(ConstantUtil.CELL_TYPE, controlType);
                                        node.setAttribute(ConstantUtil.CAPTION, diff.caption);
                                        if ("Dict".equals(controlType)) {
                                            if (StringUtils.isNotEmpty(diff.getItemKey())) {
                                                node.setAttribute(ConstantUtil.ITEM_KEY, diff.getItemKey());
                                                if (diff.getItemKey().endsWith("__Dic")) {
                                                    node.setAttribute(Property.StateMask.name,"Enable|Disable|Discard");
                                                }
                                            } else {
                                                if (!Objects.equals(diff.getIsButtonQuote(), Boolean.TRUE)) {
                                                    throw new Throwable("ItemKey为空，请检查配置");
                                                }
                                            }
                                            if (diff.properties.size() > 0) {
                                                if (Property.AllowMultiSelection.name.equals(diff.properties.get(0).property.name)) {
                                                    node.setAttribute(Property.AllowMultiSelection.name, diff.properties.get(0).newValue);
                                                }
                                            }
                                        }
                                        if ("DynamicDict".equals(controlType)) {
                                            if (StringUtils.isNotEmpty(diff.getReserveThree())) {
                                                node.setAttribute(ConstantUtil.REF_KEY, diff.getReserveThree());
                                            } else {
                                                node.setAttribute(ConstantUtil.REF_KEY, "true");
                                            }
                                        }
                                        String tableKey = ((TagNode) gridRow).getAttributes().get(ConstantUtil.TABLE_KEY);
                                        MetaFormProfile metaFormProfile = metaFormList.get(metaForm.getKey());
                                        if(metaFormProfile == null) metaFormProfile = metaFactory.getExtFormList().get(metaForm.getKey());
                                        Boolean mergeToSource = metaFormProfile.getMergeToSource();
                                        if (((tableKey != null && tableKey.length() != 0 && !tableKey.contains(ConstantUtil.NODB) && !"Button".equals(controlType)) || mergeToSource) && "true".equalsIgnoreCase(diff.getReserveTwo())) {
                                            String key = metaForm.getDataSource().getDataObject().getKey();
                                            String extendKey = metaForm.getExtend();
                                            if (key.equals(extendKey)) {
                                                if (mergeToSource) {
                                                    if (StringUtils.isBlank(tableKey)) {
                                                        String tagNodeKey = ((TagNode) gridRow).getTagName() + "@" + ((TagNode) gridRow).getAttributes().get(ConstantUtil.KEY);
                                                        TagNode tagNode = diff.getVestXmlTree().xmlTree.getTagNode(tagNodeKey);
                                                        tableKey = tagNode.getAttributes().get(ConstantUtil.TABLE_KEY);
                                                    }
                                                    TagNode NewdtbNode = new TagNode(MetaDataBinding.TAG_NAME, null);
                                                    if (!exist && StringUtils.isNotEmpty(tableKey)) {
                                                        NewdtbNode.setAttribute(ConstantUtil.COLUMN_KEY, diff.getReserveOne());
                                                    }
                                                    node.addNode(NewdtbNode);
                                                }
                                            } else {
                                                TagNode NewdtbNode = new TagNode(MetaDataBinding.TAG_NAME, null);
                                                if (!exist) {
                                                    NewdtbNode.setAttribute(ConstantUtil.COLUMN_KEY, diff.getReserveOne());
                                                } else {
                                                    NewdtbNode.setAttribute(ConstantUtil.COLUMN_KEY, kkey);
                                                }
                                                node.addNode(NewdtbNode);
                                            }
                                        }
                                        if ("NumberEditor".equals(controlType)) {
                                            TagNode formatNode = new TagNode("CellFormat", null);
                                            formatNode.setAttribute("HAlign", "Right");
                                            node.addNode(formatNode);
                                        }
                                        node.setParent(((TagNode) gridRow));
                                        if (diff.isButtonQuote) {
                                            List<TagNode> gridColumn =
                                                    diff.getVestXmlTree().xmlTree.getRoot().findNodesByTagName(ConstantUtil.GRID_CELL);
                                            for (TagNode tagNode : gridColumn) {
                                                String s = tagNode.getAttributes().get(ConstantUtil.KEY);
                                                String cellType = tagNode.getAttributes().get(ConstantUtil.CELL_TYPE);
                                                if (s.equalsIgnoreCase(diff.getKey())) {
                                                    tagNode.getAttributes().clear();
                                                    tagNode.getChildren().clear();
                                                    tagNode.setAttribute(ConstantUtil.KEY, s);
                                                    tagNode.setAttribute(ConstantUtil.CELL_TYPE, cellType);
                                                    node = tagNode;
                                                }
                                            }
                                        }
                                        if (diff.isButtonQuote) {
                                            if ("".equals(sideKey)) {
                                                rows.add(rows.size() - 1, node);
                                            } else {
                                                if (rowIndex > cellList.size()) {
                                                    rows.add(rows.size() - 2, node);
                                                } else {
                                                    if (rowIndex > cellList.size()) {
                                                        rows.add((rowIndex) * 2 - 1, node);
                                                    } else {
                                                        rows.add((rowIndex) * 2, node);
                                                    }
                                                }
                                            }
                                        } else {
                                            if ("".equals(sideKey)) {
                                                rows.add(rows.size() - 1, node);
                                            } else {
                                                if (diff.insertAfter) {
                                                    rows.add(rowIndex * 2, node);
                                                } else {
                                                    rows.add(rowIndex * 2 == 0 ? 0 : rowIndex * 2 - 1, node);
                                                }
                                            }
                                        }
                                        addDomainPropertyToNode(node, controlType, diff.getDataElementKey());
                                    }
                                }
                            }
                        } else {
                            int addSize = 0;
                            for (AbstractNode gridRow : gridRows) {
                                if (gridRow instanceof TagNode) {
                                    String name = ((TagNode) gridRow).getTagName();
                                    if (ConstantUtil.GRID_ROW.equals(name)) {
                                        addSize += 1;
                                        TagNode node = new TagNode(ConstantUtil.GRID_CELL, null);
                                        if (addSize == 1) {
                                            List<AbstractNode> rows = ((TagNode) gridRow).getChildren();
                                            node.setAttribute(ConstantUtil.KEY, diff.getKey());
                                            node.setAttribute(ConstantUtil.CELL_TYPE, controlType);
                                            node.setAttribute(ConstantUtil.CAPTION, diff.caption);
                                            if ("Dict".equals(controlType)) {
                                                if (StringUtils.isNotEmpty(diff.getItemKey())) {
                                                    node.setAttribute(ConstantUtil.ITEM_KEY, diff.getItemKey());
                                                } else {
                                                    throw new Throwable("ItemKey为空，请检查配置");
                                                }
                                            }
                                            if ("DynamicDict".equals(controlType)) {
                                                if (StringUtils.isNotEmpty(diff.getReserveThree())) {
                                                    node.setAttribute(ConstantUtil.REF_KEY, diff.getReserveThree());
                                                } else {
                                                    node.setAttribute(ConstantUtil.REF_KEY, "true");
                                                }
                                            }
                                            String tableKey = ((TagNode) gridRow).getAttributes().get(ConstantUtil.TABLE_KEY);
                                            MetaFormProfile metaFormProfile = metaFormList.get(metaForm.getKey());
                                            if(metaFormProfile == null) metaFormProfile = metaFactory.getExtFormList().get(metaForm.getKey());
                                            Boolean mergeToSource = metaFormProfile.getMergeToSource();
                                            if (((tableKey != null && tableKey.length() != 0 && !tableKey.contains(ConstantUtil.NODB) && !"Button".equals(controlType)) || mergeToSource) && "true".equalsIgnoreCase(diff.getReserveTwo())) {
                                                String key = metaForm.getDataSource().getDataObject().getKey();
                                                String extendKey = metaForm.getExtend();
                                                if (key.equals(extendKey)) {// //因为现在马甲无法修改数据源所以普通
                                                    if (key.equals(extendKey) && mergeToSource) {
                                                        TagNode NewdtbNode = new TagNode(MetaDataBinding.TAG_NAME, null);
                                                        if (!exist) {
                                                            NewdtbNode.setAttribute(ConstantUtil.COLUMN_KEY, diff.getKey());
                                                        } else {
                                                            NewdtbNode.setAttribute(ConstantUtil.COLUMN_KEY, kkey);
                                                        }
                                                        node.addNode(NewdtbNode);
                                                    }
                                                } else {
                                                    TagNode NewdtbNode = new TagNode(MetaDataBinding.TAG_NAME, null);
                                                    if (!exist && StringUtils.isNotEmpty(tableKey)) {
                                                        NewdtbNode.setAttribute(ConstantUtil.COLUMN_KEY, diff.getKey());
                                                    }
                                                    node.addNode(NewdtbNode);
                                                }

                                            }
                                            node.setParent(((TagNode) gridRow));
                                            if (diff.isButtonQuote) {
                                                if ("".equals(sideKey)) {
                                                    rows.add(rows.size() - 1, node);
                                                } else {
                                                    if ((rowIndex - 1) * 2 > rows.size()) {
                                                        rows.add(rows.size() - 2, node);
                                                    } else {
                                                        rows.add(rowIndex * 2, node);
                                                    }
                                                }
                                            } else {
                                                if ("".equals(sideKey)) {
                                                    rows.add(rows.size() - 1, node);
                                                } else {
                                                    if (diff.insertAfter) {
                                                        rows.add(rowIndex * 2, node);
                                                    } else {
                                                        rows.add(rowIndex * 2 == 0 ? 0 : rowIndex * 2 - 1, node);
                                                    }
                                                }
                                            }

                                        } else {
                                            List<AbstractNode> rows = ((TagNode) gridRow).getChildren();
                                            if (diff.isButtonQuote) {
                                                XmlTreeWithPath vestXmlTree = diff.getVestXmlTree();
                                                TagNode vestRow = vestXmlTree.xmlTree.getTagNode(ConstantUtil.GRID_ROW + "@" + ((TagNode) gridRow).getAttributes().get("Key"));
                                                List<TagNode> nodesByTagName = vestRow.findNodesByTagName(ConstantUtil.GRID_CELL);
                                                TagNode tagNode;
                                                if (rowDataIndex == -1) {
                                                    tagNode = nodesByTagName.get(rowIndex);
                                                } else {
                                                    tagNode = nodesByTagName.get(rowDataIndex - 1);//子列
                                                }
                                                node.setAttribute(ConstantUtil.KEY, tagNode.getAttributes().get(ConstantUtil.KEY));
                                            } else {
                                                node.setAttribute(ConstantUtil.KEY, diff.getKey() + addSize);
                                                node.setAttribute(ConstantUtil.CAPTION, diff.caption + addSize);
                                                if ("Dict".equals(controlType)) {
                                                    if (StringUtils.isNotEmpty(diff.getItemKey())) {
                                                        node.setAttribute(ConstantUtil.ITEM_KEY, diff.getItemKey());
                                                    } else {
                                                        throw new Throwable("ItemKey为空，请检查配置");
                                                    }
                                                }
                                            }
                                            node.setParent(((TagNode) gridRow));
                                            if (diff.isButtonQuote) {
                                                if ("".equals(sideKey)) {
                                                    rows.add(rows.size() - 1, node);
                                                } else {
                                                    if ((rowIndex - 1) * 2 > rows.size()) {
                                                        rows.add(rows.size() - 2, node);
                                                    } else {
                                                        rows.add(rowIndex * 2, node);
                                                    }
                                                }
                                            } else {
                                                if ("".equals(sideKey)) {
                                                    rows.add(rows.size() - 1, node);
                                                } else {
                                                    if (diff.insertAfter) {
                                                        rows.add(rowIndex * 2, node);
                                                    } else {
                                                        rows.add(rowIndex * 2 == 0 ? 0 : rowIndex * 2 - 1, node);
                                                    }
                                                }
                                            }

                                        }
                                        addDomainPropertyToNode(node,controlType, diff.getDataElementKey());
                                    }
                                }
                            }
                            diff.setMetaObjectType(MetaObjectType.getMetaObjectType("GridFieldMultiRowTable"));
                        }
                    }
                }
            }
        } else if (diff.getMetaObjectType() == MetaObjectType.ListViewColumn) {
            List<AbstractNode> childrens = selectNode.getChildren();
            boolean exist = false;
            Integer index;
            String tableKey = selectComp.getTableKey();
            TagNode tableNode = diff.getXmlTree().xmlTree.getTagNode(ConstantUtil.TABLE + "@" + tableKey);
            boolean isRefObjectKey = false;
            if (!"".equals(metaForm.getDataSource().getRefObjectKey()) && metaForm.getDataSource().getRefObjectKey() != null) {
                tableNode = diff.getDataObjectXmlTree().xmlTree.getTagNode(ConstantUtil.TABLE + "@" + tableKey);
                isRefObjectKey = true;
            }
            if (tableKey != null && !"".equals(tableKey)) {
                for (MetaColumn metaColumn : metaForm.getDataSource().getDataObject().getTable(tableKey)) {
                    if (metaColumn.getKey().equalsIgnoreCase(diff.getKey()) && !tableKey.contains(ConstantUtil.NODB)) {
//						kkey = metaColumn.getKey();
                        exist = true;
                    }
                }
            }
            if (tableKey != null && tableKey.length() != 0 && !tableKey.contains(ConstantUtil.NODB)
                    && tableNode != null && !"Button".equals(controlType) && "true".equalsIgnoreCase(diff.getReserveTwo())) {
                if (!exist) {
                    TagNode newColumnNode = new TagNode(ConstantUtil.COLUMN, null);
                    newColumnNode.setAttribute(ConstantUtil.KEY, diff.getReserveOne());
                    newColumnNode.setAttribute(ConstantUtil.CAPTION, diff.caption);
                    newColumnNode.setAttribute(ConstantUtil.DATA_TYPE, getDatatype(diff.getControlType()));
                    if ("Varchar".equalsIgnoreCase(getDatatype(diff.getControlType()))) {
                        newColumnNode.setAttribute(ConstantUtil.LENGTH, "255");
                    }
                    tableNode.addNode(newColumnNode);
                    if (isRefObjectKey) {
                        genXmlDiff(diff.getDataObjectXmlTree(), tableNode, diff, false);
                    } else {
                        genXmlDiff(diff.getXmlTree(), tableNode, diff, false);
                    }
                }
            }
            for (AbstractNode abstractNode : childrens) {
                if (abstractNode instanceof TagNode && "ListViewColumnCollection".equalsIgnoreCase(((TagNode) abstractNode).getTagName())) {
                    TagNode node = new TagNode(ConstantUtil.LIST_VIEW_COLUMN, null);
                    node.setAttribute(ConstantUtil.KEY, diff.getKey());
                    node.setAttribute(ConstantUtil.COLUMN_TYPE, controlType);
                    node.setAttribute(ConstantUtil.CAPTION, diff.caption);
                    node.setAttribute(ConstantUtil.TABLE_KEY, tableKey);
                    // 确认添加数据源 则新增
                    if (exist || "true".equalsIgnoreCase(diff.getReserveTwo())) {
                        node.setAttribute(ConstantUtil.DATA_COLUMN_KEY, diff.getReserveOne());
                    }
                    node.setParent(((TagNode) abstractNode));
                    List<AbstractNode> rows = ((TagNode) abstractNode).getChildren();
                    if ("".equals(diff.sideKey)) {
                        rows.add(rows.size() - 1, node);
                    } else {
                        index = compIndex(rows, diff.sideKey);
                        if (diff.insertAfter) {
                            rows.add(index + 1, node);
                        } else {
                            rows.add(index - 1, node);
                        }
                    }
                }
            }
        } else if (diff.getMetaObjectType() == MetaObjectType.grid) {
            if (!diff.isButtonQuote) {
                //添加Grid节点
                TagNode tabNode = setGrid(metaForm, selectNode, diff);
                if (ConstantUtil.GRID_LAYOUT_PANEL.equals(selectNode.getTagName())) {
                    List<AbstractNode> children = selectNode.getChildren();
                    Integer rowDefIndex = getRowDefIndex(children);
                    children.add(rowDefIndex - 1, tabNode);
                } else {
                    addSplitSize(selectNode);
                    addNodeToSplitPanel(selectNode, tabNode);
                }
            } else {
                //添加Grid节点
                TagNode tabNode_Vest = diff.getVestXmlTree().xmlTree.getTagNode(diff.getMetaObjectType() + "@" + diff.getKey());
                String key = tabNode_Vest.getAttributes().get("Key");
                TagNode  tabNode = new TagNode(diff.getMetaObjectType().name, null);
                tabNode.setAttribute("Key",key);
                String parentTagName = selectNode.getTagName();
                if (ConstantUtil.GRID_LAYOUT_PANEL.equals(parentTagName)) { //当父类为面板
                    if (diff.getMetaObjectType() != MetaObjectType.subDetail) {

                        if (diff.x != null && diff.y != null) {
                            tabNode.setAttribute(ConstantUtil.X, diff.x.toString());
                            tabNode.setAttribute(ConstantUtil.Y, diff.y.toString());
                        } else {
                            tabNode.setAttribute(ConstantUtil.X, "0");
                            tabNode.setAttribute(ConstantUtil.Y, "0");
                        }
                    }
                }
                if (diff.getMetaObjectType() == MetaObjectType.grid) {
                    tabNode.setAttribute(ConstantUtil.KEY, diff.getKey());
//                    if (StringUtils.isNotEmpty(diff.caption)) {
//                        tabNode.setAttribute(ConstantUtil.CAPTION, diff.caption);
//                    }
                } else if (diff.getMetaObjectType() == MetaObjectType.subDetail) {
                    anInt = 1;
                    IDLookup idLookup = IDLookup.getIDLookup(metaForm);
                    while (idLookup.containFieldKey("SubGrid" + anInt)) {
                        anInt++;
                    }
                    tabNode.setAttribute(ConstantUtil.KEY, "SubGrid" + anInt);
//                    tabNode.setAttribute(ConstantUtil.CAPTION, "SubGrid" + anInt);
                }

                if (ConstantUtil.GRID_LAYOUT_PANEL.equals(selectNode.getTagName())) {
                    List<AbstractNode> children = selectNode.getChildren();
                    Integer rowDefIndex = getRowDefIndex(children);
                    children.add(rowDefIndex - 1, tabNode);
                } else {
                    if (!tabNode_Vest.getParent().getAttributes().get("Key").equalsIgnoreCase(selectNode.getAttributes().get("Key"))){
                        addSplitSize(selectNode);
                    }
                    addNodeToSplitPanel(selectNode, tabNode);
                }
            }
        } else if (diff.getMetaObjectType() == MetaObjectType.listView) {
            if (!diff.isButtonQuote) {
                IDLookup idLookup = IDLookup.getIDLookup(metaForm);
                while (idLookup.getListViewColumnByKey("column" + anInt) != null) {
                    anInt++;
                }
                TagNode tabNode = setListView(metaForm, selectNode, diff, anInt);
                if (ConstantUtil.GRID_LAYOUT_PANEL.equals(selectNode.getTagName())) {
                    List<AbstractNode> children = selectNode.getChildren();
                    Integer rowDefIndex = getRowDefIndex(children);
                    children.add(rowDefIndex - 1, tabNode);
                } else {
                    addSplitSize(selectNode);
                    addNodeToSplitPanel(selectNode, tabNode);
                }
            }
        } else if (diff.getMetaObjectType() == MetaObjectType.EditView) {
            if (!diff.isButtonQuote) {
                TagNode tabNode = setEditView(metaForm, selectNode, diff);

                if (ConstantUtil.GRID_LAYOUT_PANEL.equals(selectNode.getTagName())) {
                    List<AbstractNode> children = selectNode.getChildren();
                    Integer rowDefIndex = getRowDefIndex(children);
                    children.add(rowDefIndex - 1, tabNode);
                } else {
                    addSplitSize(selectNode);
                    addNodeToSplitPanel(selectNode, tabNode);
                }
                TagNode bodyNode = diff.getXmlTree().xmlTree.getRoot().getChildByTagName("Body");
                genXmlDiff(diff.getXmlTree(), bodyNode, diff, true);
                return anInt;
            }
        } else if(diff.getMetaObjectType() == MetaObjectType.TableView){
            if (!diff.isButtonQuote) {
                TagNode tabNode = setTableView(metaForm, selectNode, diff, 1);
                if (ConstantUtil.GRID_LAYOUT_PANEL.equals(selectNode.getTagName())) {
                    List<AbstractNode> children = selectNode.getChildren();
                    Integer rowDefIndex = getRowDefIndex(children);
                    children.add(rowDefIndex - 1, tabNode);
                } else {
                    addSplitSize(selectNode);
                    addNodeToSplitPanel(selectNode, tabNode);
                }
            }
        } else if(diff.getMetaObjectType() == MetaObjectType.CollectionView){
            if (!diff.isButtonQuote) {
                TagNode tabNode = setCollectionView(metaForm, selectNode, diff, 1);
                if (ConstantUtil.GRID_LAYOUT_PANEL.equals(selectNode.getTagName())) {
                    List<AbstractNode> children = selectNode.getChildren();
                    Integer rowDefIndex = getRowDefIndex(children);
                    children.add(rowDefIndex - 1, tabNode);
                } else {
                    addSplitSize(selectNode);
                    addNodeToSplitPanel(selectNode, tabNode);
                }
            }
        } else if (diff.getMetaObjectType() == MetaObjectType.panel) { // panel
            if (!diff.isButtonQuote) {
                if (controlType.equals(ControlType.STR_TABPANEL)) { // tabpanel
                    TagNode tagbPanelNode = new TagNode(controlType, null);
                    tagbPanelNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                    tagbPanelNode.setAttribute(ConstantUtil.CAPTION, diff.caption);
                    addSplitSize(selectNode);
                    addNodeToSplitPanel(selectNode, tagbPanelNode);
                }
                else if (controlType.equals(ControlType.STR_GRIDLAYOUTPANEL)) { // gridlayoutpanel
                    if ("EditView".equalsIgnoreCase(selectNode.getTagName())) {
                        String compViewKey = "ComponentView@" + diff.parentKey;
                        TagNode compViewNode = diff.getXmlTree().xmlTree.getTagNode(compViewKey);

                        if (compViewNode != null) {
                            String childLayout = diff.getReserveOne();
                            if (childLayout != null && childLayout.length() > 0) {
                                TagNode childLayoutNode = compViewNode.getChildByKey(childLayout);

                                if (childLayoutNode != null) {
                                    String type = childLayoutNode.getTagName();
                                    if (type.equalsIgnoreCase("GridLayout")) {
                                        TagNode layoutSpanNode = new TagNode("LayoutSpan", null);
                                        layoutSpanNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                                        layoutSpanNode.setAttribute("X", diff.x.toString());
                                        layoutSpanNode.setAttribute("Y", diff.y.toString());

                                        childLayoutNode.addNode(layoutSpanNode);
                                    } else if (type.equalsIgnoreCase("LinearLayout")) {
                                        TagNode layoutItemNode = new TagNode("LinearItem", null);
                                        layoutItemNode.setAttribute(ConstantUtil.KEY, diff.getKey());

                                        childLayoutNode.addNode(layoutItemNode);
                                    } else if (type.equalsIgnoreCase("FlexFlowLayout")) {
                                        TagNode layoutItemNode = new TagNode("LayoutFlowIndex", null);
                                        layoutItemNode.setAttribute(ConstantUtil.KEY, diff.getKey());

                                        childLayoutNode.addNode(layoutItemNode);
                                    } else if (type.equalsIgnoreCase("ColumnLayout")) {
                                        TagNode layoutSpanNode = new TagNode("LayoutSpan", null);
                                        layoutSpanNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                                        layoutSpanNode.setAttribute("X", diff.x.toString());
                                        layoutSpanNode.setAttribute("Y", diff.y.toString());

                                        childLayoutNode.addNode(layoutSpanNode);
                                    } else if (type.equalsIgnoreCase("SplitLayout")) {
                                        TagNode layoutItemNode = new TagNode("LayoutSplitItem", null);
                                        layoutItemNode.setAttribute(ConstantUtil.KEY, diff.getKey());

                                        childLayoutNode.addNode(layoutItemNode);
                                    } else if (type.equalsIgnoreCase("TabLayout")) {
                                        TagNode layoutItemNode = new TagNode("LayoutTabItem", null);
                                        layoutItemNode.setAttribute(ConstantUtil.KEY, diff.getKey());

                                        childLayoutNode.addNode(layoutItemNode);
                                    } else if (type.equalsIgnoreCase("FlowLayout")) {
                                        TagNode layoutItemNode = new TagNode("LayoutFlowIndex", null);
                                        layoutItemNode.setAttribute(ConstantUtil.KEY, diff.getKey());

                                        childLayoutNode.addNode(layoutItemNode);
                                    } else if (type.equalsIgnoreCase("FlexGridLayout")) {
                                        TagNode layoutItemNode = new TagNode("LayoutRowIndex", null);
                                        layoutItemNode.setAttribute(ConstantUtil.KEY, diff.getKey());

                                        childLayoutNode.addNode(layoutItemNode);
                                    }

                                    TagNode gridLayoutNode = getDefaultGridLayout(diff.getKey());
                                    compViewNode.addNode(gridLayoutNode);

                                    genXmlDiff(diff.getXmlTree(), compViewNode, diff, true);

                                    return anInt;
                                }
                            }
                        }
                    } else {
                        IDLookup idLookup = IDLookup.getIDLookup(metaForm);
                        anInt = 1;
                        while (idLookup.containFieldKey("tempGridLayoutPanel" + anInt)) {
                            anInt++;
                        }
                        TagNode gridLayoutNode = SetGridLayoutPanel(diff, metaForm, anInt);
                        addSplitSize(selectNode);
                        addNodeToSplitPanel(selectNode, gridLayoutNode);
                    }
                }
                else if (controlType.equals(ControlType.STR_SPLITPANEL)) { // splitpanel 只加splitpanel会报错，这里在splitpanel下加了个tabpanel
                    anInt = 1;
                    IDLookup idLookup = IDLookup.getIDLookup(metaForm);
                    while (idLookup.containFieldKey("TempTabPanel" + anInt)) {
                        anInt++;
                    }
                    TagNode splitNode = new TagNode(controlType, null);
                    splitNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                    splitNode.setAttribute(ConstantUtil.CAPTION, diff.caption);
                    splitNode.setAttribute("Orientation", "Vertical");
                    TagNode tabNode = new TagNode(ConstantUtil.TAB_PANEL, null);
                    tabNode.setAttribute(ConstantUtil.KEY, "TempTabPanel" + anInt);
                    tabNode.setAttribute(ConstantUtil.CAPTION, "TempTabPanel" + anInt);
                    TagNode size = new TagNode("SplitSize", null);
                    size.setAttribute("Size", "100px");
                    TagNode endSplit = new TagNode(ConstantUtil.SPLIT_PANEL, null);
                    splitNode.addNode(tabNode);
                    splitNode.addNode(size);
                    splitNode.addNode(endSplit);
                    addNodeToSplitPanel(selectNode, splitNode);
                }
                else if (controlType.equals(ControlType.STR_FLEXFLOWLAYOUTPANEL)) { // flexflowlayoutpanel
                    if ("EditView".equalsIgnoreCase(selectNode.getTagName())) {
                        String compViewKey = "ComponentView@" + diff.parentKey;
                        TagNode compViewNode = diff.getXmlTree().xmlTree.getTagNode(compViewKey);

                        if (compViewNode != null) {
                            String childLayout = diff.getReserveOne();
                            if (childLayout != null && childLayout.length() > 0) {
                                TagNode childLayoutNode = compViewNode.getChildByKey(childLayout);

                                if (childLayoutNode != null) {
                                    String type = childLayoutNode.getTagName();
                                    if (type.equalsIgnoreCase("GridLayout")) {
                                        TagNode layoutSpanNode = new TagNode("LayoutSpan", null);
                                        layoutSpanNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                                        layoutSpanNode.setAttribute("X", diff.x.toString());
                                        layoutSpanNode.setAttribute("Y", diff.y.toString());

                                        childLayoutNode.addNode(layoutSpanNode);
                                    } else if (type.equalsIgnoreCase("LinearLayout")) {
                                        TagNode layoutItemNode = new TagNode("LinearItem", null);
                                        layoutItemNode.setAttribute(ConstantUtil.KEY, diff.getKey());

                                        childLayoutNode.addNode(layoutItemNode);
                                    } else if (type.equalsIgnoreCase("FlexFlowLayout")) {
                                        TagNode layoutItemNode = new TagNode("LayoutFlowIndex", null);
                                        layoutItemNode.setAttribute(ConstantUtil.KEY, diff.getKey());

                                        childLayoutNode.addNode(layoutItemNode);
                                    } else if (type.equalsIgnoreCase("ColumnLayout")) {
                                        TagNode layoutSpanNode = new TagNode("LayoutSpan", null);
                                        layoutSpanNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                                        layoutSpanNode.setAttribute("X", diff.x.toString());
                                        layoutSpanNode.setAttribute("Y", diff.y.toString());

                                        childLayoutNode.addNode(layoutSpanNode);
                                    } else if (type.equalsIgnoreCase("SplitLayout")) {
                                        TagNode layoutItemNode = new TagNode("LayoutSplitItem", null);
                                        layoutItemNode.setAttribute(ConstantUtil.KEY, diff.getKey());

                                        childLayoutNode.addNode(layoutItemNode);
                                    } else if (type.equalsIgnoreCase("TabLayout")) {
                                        TagNode layoutItemNode = new TagNode("LayoutTabItem", null);
                                        layoutItemNode.setAttribute(ConstantUtil.KEY, diff.getKey());

                                        childLayoutNode.addNode(layoutItemNode);
                                    } else if (type.equalsIgnoreCase("FlowLayout")) {
                                        TagNode layoutItemNode = new TagNode("LayoutFlowIndex", null);
                                        layoutItemNode.setAttribute(ConstantUtil.KEY, diff.getKey());

                                        childLayoutNode.addNode(layoutItemNode);
                                    } else if (type.equalsIgnoreCase("FlexGridLayout")) {
                                        TagNode layoutItemNode = new TagNode("LayoutRowIndex", null);
                                        layoutItemNode.setAttribute(ConstantUtil.KEY, diff.getKey());

                                        childLayoutNode.addNode(layoutItemNode);
                                    }

                                    TagNode flexFlowLayoutNode = new TagNode("FlexFlowLayout", null);
                                    flexFlowLayoutNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                                    compViewNode.addNode(flexFlowLayoutNode);

                                    genXmlDiff(diff.getXmlTree(), compViewNode, diff, true);

                                    return anInt;
                                }
                            }
                        }

                    } else {
                        TagNode flexNode = new TagNode(controlType, null);
                        flexNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                        flexNode.setAttribute(ConstantUtil.CAPTION, diff.caption);
                        if (diff.x != null && diff.y != null) {//如果不为空
                            flexNode.setAttribute(ConstantUtil.X, diff.x.toString());
                            flexNode.setAttribute(ConstantUtil.Y, diff.y.toString());
                        }
                        addSplitSize(selectNode);
                        addNodeToSplitPanel(selectNode, flexNode);
                    }
                }
                else if (controlType.equalsIgnoreCase(ControlType.STR_FLOWLAYOUTPANEL)) {
                    TagNode flexNode = new TagNode(controlType, null);
                    flexNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                    flexNode.setAttribute(ConstantUtil.CAPTION, diff.caption);
                    addSplitSize(selectNode);
                    addNodeToSplitPanel(selectNode, flexNode);
                }
                else if (controlType.equalsIgnoreCase(ControlType.STR_COLUMNLAYOUTPANEL)) {
                    TagNode flexNode = new TagNode(controlType, null);
                    flexNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                    flexNode.setAttribute(ConstantUtil.CAPTION, diff.caption);
                    addSplitSize(selectNode);
                    addNodeToSplitPanel(selectNode, flexNode);
                }
                else if (controlType.equalsIgnoreCase(ControlType.STR_SLIDINGLAYOUTPANEL)) {
                    TagNode slidingNode = new TagNode(controlType, null);
                    slidingNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                    slidingNode.setAttribute(ConstantUtil.CAPTION, diff.caption);

                    TagNode mainPanelNode = new TagNode("FlexFlowLayoutPanel", null);
                    mainPanelNode.setAttribute("Key", diff.getKey() + "Main");
                    mainPanelNode.setAttribute("Caption", "主显示");
                    mainPanelNode.setAttribute("Padding", "5px");

                    TagNode firstPanelNode = new TagNode("FlexFlowLayoutPanel", null);
                    firstPanelNode.setAttribute("Key", diff.getKey() + "Fist");
                    firstPanelNode.setAttribute("Caption", "主侧滑");

                    TagNode secondPanelNode = new TagNode("FlexFlowLayoutPanel", null);
                    secondPanelNode.setAttribute("Key", diff.getKey() + "Second");
                    secondPanelNode.setAttribute("Caption", "次侧滑");

                    slidingNode.addNode(mainPanelNode);
                    slidingNode.addNode(firstPanelNode);
                    slidingNode.addNode(secondPanelNode);

                    addSplitSize(selectNode);
                    addNodeToSplitPanel(selectNode, slidingNode);
                }
                else if (controlType.equalsIgnoreCase(ControlType.STR_COLLAPSEPANEL)) {
                    TagNode collapseNode = new TagNode(controlType, null);
                    collapseNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                    collapseNode.setAttribute(ConstantUtil.CAPTION, diff.caption);

                    TagNode collapseItemNode = new TagNode("CollapseItem", null);
                    collapseItemNode.setAttribute(ConstantUtil.KEY, "CollapseItem1");
                    collapseItemNode.setAttribute(ConstantUtil.CAPTION, "CollapseItem1");
                    collapseItemNode.setAttribute("IsExpand", "true");
                    collapseItemNode.setAttribute("TextOff", "折叠");
                    collapseItemNode.setAttribute("TextOn", "展开");

                    TagNode linearLayoutNode = new TagNode("LinearLayoutPanel", null);
                    linearLayoutNode.setAttribute(ConstantUtil.KEY, diff.getKey() + "LinearPanel");
                    linearLayoutNode.setAttribute(ConstantUtil.CAPTION, diff.getKey() + "LinearPanel");

                    collapseItemNode.addNode(linearLayoutNode);

                    collapseNode.addNode(collapseItemNode);

                    addSplitSize(selectNode);
                    addNodeToSplitPanel(selectNode, collapseNode);
                }
                else if (controlType.equalsIgnoreCase(ControlType.STR_FLEXGRIDLAYOUTPANEL)) {
                    TagNode flexNode = new TagNode(controlType, null);
                    final Map<String, String> attributes = flexNode.getAttributes();
                    attributes.put(ConstantUtil.KEY, diff.getKey());
                    attributes.put(ConstantUtil.CAPTION, diff.caption);
                    attributes.put("ColumnCount", "6");
                    attributes.put(ConstantUtil.ROW_GAP, "24");
                    attributes.put(ConstantUtil.COLUMN_GAP, "16");
                    attributes.put(ConstantUtil.ROW_HEIGHT, "32");
                    attributes.put(ConstantUtil.HEIGHT, "pref");
                    addSplitSize(selectNode);
                    addNodeToSplitPanel(selectNode, flexNode);
                } else if (controlType.equalsIgnoreCase(ControlType.STR_LINEARLAYOUTPANEL)){
                    if ("EditView".equalsIgnoreCase(selectNode.getTagName())) {
                        String compViewKey = "ComponentView@" + diff.parentKey;
                        TagNode compViewNode = diff.getXmlTree().xmlTree.getTagNode(compViewKey);

                        if (compViewNode != null) {
                            String childLayout = diff.getReserveOne();
                            if (childLayout != null && childLayout.length() > 0) {
                                TagNode childLayoutNode = compViewNode.getChildByKey(childLayout);

                                if (childLayoutNode != null) {
                                    String type = childLayoutNode.getTagName();
                                    if (type.equalsIgnoreCase("GridLayout")) {
                                        TagNode layoutSpanNode = new TagNode("LayoutSpan", null);
                                        layoutSpanNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                                        layoutSpanNode.setAttribute("X", diff.x.toString());
                                        layoutSpanNode.setAttribute("Y", diff.y.toString());

                                        childLayoutNode.addNode(layoutSpanNode);
                                    } else if (type.equalsIgnoreCase("LinearLayout")) {
                                        TagNode layoutItemNode = new TagNode("LinearItem", null);
                                        layoutItemNode.setAttribute(ConstantUtil.KEY, diff.getKey());

                                        childLayoutNode.addNode(layoutItemNode);
                                    }

                                    TagNode linearLayoutNode = new TagNode("LinearLayout", null);
                                    linearLayoutNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                                    compViewNode.addNode(linearLayoutNode);

                                    genXmlDiff(diff.getXmlTree(), compViewNode, diff, true);

                                    return anInt;
                                }
                            }
                        }

                    } else {
                        TagNode flexNode = new TagNode(controlType, null);
                        flexNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                        flexNode.setAttribute(ConstantUtil.CAPTION, diff.caption);
                        addSplitSize(selectNode);
                        addNodeToSplitPanel(selectNode, flexNode);
                    }
                }
                else if (controlType.equalsIgnoreCase(ControlType.STR_EMBED)) {
                    TagNode flexFlowLayoutPanel = new TagNode("FlexFlowLayoutPanel", null);
                    String parentTagName = selectNode.getTagName();
                    if (ConstantUtil.GRID_LAYOUT_PANEL.equals(parentTagName) || "columnlayoutpanel".equals(parentTagName)) { //当父类为面板
                        if (diff.x != null && diff.y != null) {
                            flexFlowLayoutPanel.setAttribute(ConstantUtil.X, diff.x.toString());
                            flexFlowLayoutPanel.setAttribute(ConstantUtil.Y, diff.y.toString());
                        } else {
                            flexFlowLayoutPanel.setAttribute(ConstantUtil.X, "0");
                            flexFlowLayoutPanel.setAttribute(ConstantUtil.Y, "0");
                        }
                    }
                    flexFlowLayoutPanel.setAttribute(ConstantUtil.KEY, diff.getKey() + "Embed");
                    flexFlowLayoutPanel.setAttribute(ConstantUtil.CAPTION, diff.getKey() + "Embed");
                    flexFlowLayoutPanel.setAttribute(ConstantUtil.VISIBLE, "true");
                    TagNode flexNode = new TagNode(controlType, null);
                    flexNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                    flexNode.setAttribute(ConstantUtil.CAPTION, diff.caption);
                    flexNode.setAttribute(ConstantUtil.HEIGHT, "100%");
                    TagNode var = new TagNode("Var", null);
                    var.setAttribute(ConstantUtil.KEY, ConstantUtil.PARENT_KEY);
                    var.setAttribute(ConstantUtil.VALUE, diff.getReserveOne());
                    flexNode.addNode(var);
                    flexNode.setAttribute(ConstantUtil.FORM_KEY, diff.getReserveTwo());
                    flexNode.setAttribute(ConstantUtil.ROOT_KEY, diff.getReserveThree());
                    flexFlowLayoutPanel.addNode(flexNode);
                    addSplitSize(selectNode);
                    addNodeToSplitPanel(selectNode, flexFlowLayoutPanel);
                }
            }
            else {
                //创建Panel节点
                TagNode gridLayoutNode = diff.getVestXmlTree().xmlTree.getTagNode(controlType + "@" + diff.getKey());
                addSplitSize(selectNode);
                addNodeToSplitPanel(selectNode, gridLayoutNode);
            }
        } else if (diff.getMetaObjectType() == MetaObjectType.subDetail) {
            if (!diff.isButtonQuote) {
                //获取用户默认绑定的是面板还是表格
                DataTable dataTable = document.get(ConstantUtil.TBL_NEW_PANEL);
                if (dataTable != null) {
                    subDetailBind = dataTable.getString("SubDetailBind");
                } else {
                    try {
                        subDetailBind = document.get("D_NewSubDetailHead").getString("SubDetailBind");
                    } catch (Exception e) {
                        subDetailBind = document.get(ConstantUtil.TBL_NEW_COMPONENT).getString("SubDetailBind");
                    }

                }
                //添加subdetail节点
                TagNode subDetailNode = new TagNode("SubDetail", null);
                TagNode endSubDetail = new TagNode("SubDetail", null);
                subDetailNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                subDetailNode.setAttribute(ConstantUtil.CAPTION, diff.caption);
                subDetailNode.setAttribute("BindingGridKey", diff.bindingGridKey);//暂时设置空，以后改进
                if (diff.y != null && diff.x != null) {
                    subDetailNode.setAttribute(ConstantUtil.X, diff.x.toString());
                    subDetailNode.setAttribute(ConstantUtil.Y, diff.y.toString());
                }
                if (ConstantUtil.GRID.equalsIgnoreCase(subDetailBind)) {
                    //添加Grid节点
                    TagNode tabNode = setGrid(metaForm, selectNode, diff);
                    subDetailNode.addNode(tabNode);
                } else if (ConstantUtil.GRID_LAYOUT_PANEL.equalsIgnoreCase(subDetailBind)) {
                    IDLookup idLookup = IDLookup.getIDLookup(metaForm);
                    anInt = 1;
                    while (idLookup.containFieldKey("tempGridLayoutPanel" + anInt)) {
                        anInt++;
                    }
                    TagNode gridLayoutNode = SetGridLayoutPanel(diff, metaForm, anInt);
                    subDetailNode.addNode(gridLayoutNode);
                }
                subDetailNode.addNode(endSubDetail);
                addSplitSize(selectNode);
                addNodeToSplitPanel(selectNode, subDetailNode);
            } else {
                if(StringUtils.equals(diff.getReserveOne(), "extension")){ //如果是扩展表单
                    TagNode subDetailNode = new TagNode("SubDetail", null);
                    subDetailNode.setAttribute("Key", diff.getKey()+"_ext");
                    subDetailNode.setAttribute("Caption", diff.caption);
                    addSubCompToSubDetail(subDetailNode, diff);
                    selectNode.addNode(subDetailNode);
                } else {
                    //创建节点
                    TagNode gridLayoutNode = diff.getVestXmlTree().xmlTree.getTagNode(controlType + "@" + diff.getKey());
                    addSplitSize(selectNode);
                    addNodeToSplitPanel(selectNode, gridLayoutNode);
                }
            }

        } else if (diff.getMetaObjectType() == MetaObjectType.toolbar || diff.getMetaObjectType() == MetaObjectType.ToolBar) {
            TagNode flexNode = new TagNode(controlType, null);
            flexNode.setAttribute(ConstantUtil.KEY, diff.getKey());
            flexNode.setAttribute(ConstantUtil.CAPTION, diff.caption);
            if (diff.x != null && diff.y != null) {//如果不为空
                flexNode.setAttribute(ConstantUtil.X, diff.x.toString());
                flexNode.setAttribute(ConstantUtil.Y, diff.y.toString());
            }
            addSplitSize(selectNode);
            selectNode.addNode(flexNode, 0);
        } else if (diff.getMetaObjectType() == MetaObjectType.Chart) {
            TagNode flexNode = new TagNode(controlType, null);
            flexNode.setAttribute(ConstantUtil.KEY, diff.getKey());
            flexNode.setAttribute(ConstantUtil.CAPTION, diff.caption);
            if (diff.x != null && diff.y != null) {//如果不为空
                flexNode.setAttribute(ConstantUtil.X, diff.x.toString());
                flexNode.setAttribute(ConstantUtil.Y, diff.y.toString());
            }
            addSplitSize(selectNode);
            addNodeToSplitPanel(selectNode, flexNode);
        } else if (diff.getMetaObjectType() == MetaObjectType.WebBrowser) {
            TagNode flexNode = new TagNode(controlType, null);
            flexNode.setAttribute(ConstantUtil.KEY, diff.getKey());
            flexNode.setAttribute(ConstantUtil.CAPTION, diff.caption);
            if (diff.x != null && diff.y != null) {//如果不为空
                flexNode.setAttribute(ConstantUtil.X, diff.x.toString());
                flexNode.setAttribute(ConstantUtil.Y, diff.y.toString());
            }
            addSplitSize(selectNode);
            addNodeToSplitPanel(selectNode, flexNode);
        } else if (diff.getMetaObjectType() == MetaObjectType.EditViewColumn) {
            TagNode colCollectionNode = selectNode.getOrCreateChildByTagName("EditViewColumnCollection");

            if (!diff.isButtonQuote) {
                TagNode colNode = new TagNode("EditViewColumn", null);
                colNode.setAttribute("Key", diff.getKey());
                colNode.setAttribute("Caption", diff.caption);
                colNode.setAttribute("ColumnType", controlType);
                colCollectionNode.addNode(colNode);

                // 添加layoutSpan
                String compViewKey = "ComponentView@" + diff.parentKey;
                TagNode compViewNode = diff.getXmlTree().xmlTree.getTagNode(compViewKey);
                if (compViewNode != null) {
                    TagNode rootLayout = compViewNode.getChildByKey(diff.getReserveOne()); // 后面处理为具体的layout，当前为根布局
                    if (rootLayout != null) {
                        String tagName = rootLayout.getTagName();
                        if (tagName.equalsIgnoreCase("GridLayout")) {
                            TagNode spanNode = new TagNode("LayoutSpan", null);
                            spanNode.setAttribute("Key", diff.getKey());
                            spanNode.setAttribute("X", diff.x.toString());
                            spanNode.setAttribute("Y", diff.y.toString());
                            rootLayout.addNode(spanNode);
                        } else if (tagName.equalsIgnoreCase("LinearLayout")) {
                            TagNode linearItemNode = new TagNode("LinearItem", null);
                            linearItemNode.setAttribute("Key", diff.getKey());
                            linearItemNode.setAttribute("Height", "pref");
                            linearItemNode.setAttribute("Width", "100%");
                            rootLayout.addNode(linearItemNode);
                        } else if (tagName.equalsIgnoreCase("FlexFlowLayout")) {
                            TagNode layoutItemNode = new TagNode("LayoutFlowIndex", null);
                            layoutItemNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                            rootLayout.addNode(layoutItemNode);
                        } else if (tagName.equalsIgnoreCase("ColumnLayout")) {
                            TagNode layoutSpanNode = new TagNode("LayoutSpan", null);
                            layoutSpanNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                            layoutSpanNode.setAttribute("X", diff.x.toString());
                            layoutSpanNode.setAttribute("Y", diff.y.toString());
                            rootLayout.addNode(layoutSpanNode);
                        } else if (tagName.equalsIgnoreCase("SplitLayout")) {
                            TagNode layoutItemNode = new TagNode("LayoutSplitItem", null);
                            layoutItemNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                            rootLayout.addNode(layoutItemNode);
                        } else if (tagName.equalsIgnoreCase("TabLayout")) {
                            TagNode layoutItemNode = new TagNode("LayoutTabItem", null);
                            layoutItemNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                            rootLayout.addNode(layoutItemNode);
                        } else if (tagName.equalsIgnoreCase("FlowLayout")) {
                            TagNode layoutItemNode = new TagNode("LayoutFlowIndex", null);
                            layoutItemNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                            rootLayout.addNode(layoutItemNode);
                        } else if (tagName.equalsIgnoreCase("FlexGridLayout")) {
                            TagNode layoutItemNode = new TagNode("LayoutRowIndex", null);
                            layoutItemNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                            rootLayout.addNode(layoutItemNode);
                        }
                    }
                }
                if ("true".equalsIgnoreCase(diff.getReserveFour())) {//添加数据源
                    List<TagNode> dataObject = diff.getXmlTree().xmlTree.getRoot().findNodesByTagName(MetaObjectType.DataObject.name);
                    //新增组件的时候同时在数据源中添加一条数据
                    List<TagNode> column = diff.getXmlTree().xmlTree.getRoot().findNodesByTagName(ConstantUtil.COLUMN);
                    MetaFormProfile metaFormProfile = metaFormList.get(metaForm.getKey());
                    if (metaFormProfile == null) metaFormProfile = metaFactory.getExtFormList().get(metaForm.getKey());
                    Boolean mergeToSource1 = metaFormProfile.getMergeToSource();
                    if (diff.getMetaForm().getDataSource() != null && !"".equals(diff.getMetaForm().getDataSource().getRefObjectKey()) && !mergeToSource1) {
                        //引入数据对象表单
                        dataObject = diff.getDataObjectXmlTree().xmlTree.getRoot().findNodesByTagName(MetaObjectType.DataObject.name);
                        column = diff.getDataObjectXmlTree().xmlTree.getRoot().findNodesByTagName(ConstantUtil.COLUMN);
                    }
                    boolean exist = false;
                    String kkey = "";
                    for (TagNode tagNode : column) {
                        if (diff.getKey().equalsIgnoreCase(tagNode.getAttributes().get(ConstantUtil.KEY))) {
                            kkey = tagNode.getAttributes().get(ConstantUtil.KEY);
                            exist = true;
                        }
                    }
                    if (!dataObject.isEmpty() && "".equalsIgnoreCase(selectComp.getParentGridKey())) {
                        String tableKey = diff.getReserveTwo();
                        if (tableKey == null || tableKey.isEmpty()) {
                            tableKey = metaForm.getDataSource().getDataObject().getMainTableKey();
                        }
                        if (tableKey != null && tableKey.length() > 0 && !tableKey.equalsIgnoreCase(null)) {
                            int controlTypeE = diff.getControlType();
                            String objectKey = metaForm.getDataSource().getDataObject().getKey();
                            String extendKey = metaForm.getExtend();
                            Boolean mergeToSource = metaFormProfile.getMergeToSource();
                            if (objectKey.equals(extendKey) && !mergeToSource) {//因为现在界面马甲无法修改数据源所以界面马甲不做处理
                                TagNode newDataBindingnode = new TagNode(MetaDataBinding.TAG_NAME, null);//新增头表组件就给他默认设置表为主表
                                if (!Objects.equals(diff.getIsButtonQuote(), Boolean.TRUE)) {//不是引入组件
                                    colNode.addNode(newDataBindingnode);
                                }
                            } else if (objectKey.equals(extendKey) && mergeToSource) {//mergeToSource == true
                                if (!Objects.equals(diff.getIsButtonQuote(), Boolean.TRUE)) {//不是引入组件
                                    String key = diff.getReserveThree();
                                    if (key == null || key.isEmpty()) {
                                        key = diff.getKey().substring(0, 1).toUpperCase() + diff.getKey().substring(1);//首字母转大写
                                    }
                                    TagNode newDataBindingnode = new TagNode(MetaDataBinding.TAG_NAME, null);//新增头表组件就给他默认设置表为主表
                                    newDataBindingnode.setAttribute(ConstantUtil.TABLE_KEY, tableKey);
                                    TagNode newColumn = new TagNode(ConstantUtil.COLUMN, null);//新增头表组件就给他默认设置一个新的column节点
                                    newColumn.setAttribute(ConstantUtil.KEY, key);
                                    newColumn.setAttribute(ConstantUtil.CAPTION, diff.caption);
                                    newColumn.setAttribute(ConstantUtil.DATA_TYPE, getDatatype(controlTypeE));
                                    //newColumn.setAttribute(ConstantUtil.DB_COLUMN_NAME, key);
                                    if ("Varchar".equalsIgnoreCase(getDatatype(controlTypeE))) {
                                        newColumn.setAttribute(ConstantUtil.LENGTH, "255");
                                    }
                                    TagNode tableNode = diff.getXmlTree().xmlTree.getTagNode(ConstantUtil.TABLE + "@" + tableKey);
                                    tableNode.addNode(newColumn);
                                    genXmlDiff(diff.getXmlTree(), tableNode, diff, false);
                                    newDataBindingnode.setAttribute(ConstantUtil.COLUMN_KEY, key);
                                    colNode.addNode(newDataBindingnode);
                                }
                            } else {
                                if (!exist) {//不存在数据源
                                    String key = diff.getReserveThree();
                                    if (key == null || key.isEmpty()) {
                                        key = diff.getKey().substring(0, 1).toUpperCase() + diff.getKey().substring(1);//首字母转大写
                                    }
                                    TagNode newDataBindingnode = new TagNode(MetaDataBinding.TAG_NAME, null);//新增头表组件就给他默认设置表为主表
                                    newDataBindingnode.setAttribute(ConstantUtil.TABLE_KEY, tableKey);
                                    TagNode newColumn = new TagNode(ConstantUtil.COLUMN, null);//新增头表组件就给他默认设置一个新的column节点
                                    newColumn.setAttribute(ConstantUtil.KEY, key);
                                    newColumn.setAttribute(ConstantUtil.CAPTION, diff.caption);
                                    newColumn.setAttribute(ConstantUtil.DATA_TYPE, getDatatype(controlTypeE));
                                    //newColumn.setAttribute(ConstantUtil.DB_COLUMN_NAME, key);
                                    if ("Varchar".equalsIgnoreCase(getDatatype(controlTypeE))) {
                                        newColumn.setAttribute(ConstantUtil.LENGTH, "255");
                                    }
                                    if (!"".equals(diff.getMetaForm().getDataSource().getRefObjectKey()) && diff.getMetaForm().getDataSource().getRefObjectKey() != null) {
                                        TagNode tableNode = diff.getDataObjectXmlTree().xmlTree.getTagNode(ConstantUtil.TABLE + "@" + tableKey);
                                        tableNode.addNode(newColumn);
                                    } else {
                                        TagNode tableNode = diff.getXmlTree().xmlTree.getTagNode(ConstantUtil.TABLE + "@" + tableKey);
                                        tableNode.addNode(newColumn);
                                    }
                                    newDataBindingnode.setAttribute(ConstantUtil.COLUMN_KEY, key);
                                    colNode.addNode(newDataBindingnode);
                                } else {//存在数据源
                                    TagNode newDataBindingnode = new TagNode(MetaDataBinding.TAG_NAME, null);//新增头表组件就给他默认设置表为主表
                                    newDataBindingnode.setAttribute(ConstantUtil.TABLE_KEY, tableKey);
                                    newDataBindingnode.setAttribute(ConstantUtil.COLUMN_KEY, kkey);
                                    colNode.addNode(newDataBindingnode);
                                }
                            }
                        }
                    } else {
                        TagNode newDataBindingnode = new TagNode(MetaDataBinding.TAG_NAME, null);
                        colNode.addNode(newDataBindingnode);
                    }
                }
                selectNode = diff.getXmlTree().xmlTree.getRoot();
            }
        }


        // 因新节点的插入位置难以计算，所以将整个父节点替换掉
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        int startLine = xmlTree.xmlTree.getLineByIndex(selectNode.getElement().getBgIndex());
        String orgXmlFragment = xmlTree.xmlTree.getNodeString(startLine);
        String newXmlFragment ="";
        if (diff.x != null && diff.y != null){
            newXmlFragment = DesignIOMetaUtil.orderAndgetXml(diff.getKey(),selectNode);
        } else {
            newXmlFragment = DesignIOMetaUtil.getXml(selectNode);
        }
        if (diff.getOrgXmlFragment() != null && diff.getNewXmlFragment() != null) {
            diff.setXmlDiff2(xmlTree, startLine, orgXmlFragment, newXmlFragment);
        } else {
            diff.setXmlDiff(xmlTree, startLine, orgXmlFragment, newXmlFragment);
        }
        return anInt;
    }

    private static TagNode getDefaultGridLayout(String layoutkey) {
        TagNode gridLayoutNode = new TagNode("GridLayout", null);
        gridLayoutNode.setAttribute("Key", layoutkey);

        TagNode rowDefs = new TagNode("RowDefCollection", null);
        rowDefs.setAttribute("RowGap", "5");
        TagNode rowDef1 = new TagNode("RowDef", null);
        rowDef1.setAttribute("Height", "40px");
        rowDefs.addNode(rowDef1);
        TagNode rowDef2 = new TagNode("RowDef", null);
        rowDef2.setAttribute("Height", "40px");
        rowDefs.addNode(rowDef2);
        TagNode rowDef3 = new TagNode("RowDef", null);
        rowDef3.setAttribute("Height", "40px");
        rowDefs.addNode(rowDef3);

        TagNode colDefs = new TagNode("ColumnDefCollection", null);
        colDefs.setAttribute("ColumnGap", "5");
        TagNode colDef1 = new TagNode("ColumnDef", null);
        colDef1.setAttribute("Width", "50%");
        colDefs.addNode(colDef1);
        TagNode colDef2 = new TagNode("ColumnDef", null);
        colDef2.setAttribute("Width", "50%");
        colDefs.addNode(colDef2);

        gridLayoutNode.addNode(rowDefs);
        gridLayoutNode.addNode(colDefs);

        return gridLayoutNode;
    }

    private static TagNode getDefaultComponentView(String componentKey) {
        TagNode compViewNode = new TagNode("ComponentView", null);
        compViewNode.setAttribute("Key", componentKey);
        TagNode gridLayoutNode = new TagNode("GridLayout", null);
        gridLayoutNode.setAttribute("Key", componentKey);

        TagNode rowDefs = new TagNode("RowDefCollection", null);
        rowDefs.setAttribute("RowGap", "5");
        TagNode rowDef1 = new TagNode("RowDef", null);
        rowDef1.setAttribute("Height", "30px");
        rowDefs.addNode(rowDef1);
        TagNode rowDef2 = new TagNode("RowDef", null);
        rowDef2.setAttribute("Height", "30px");
        rowDefs.addNode(rowDef2);

        TagNode colDefs = new TagNode("ColumnDefCollection", null);
        colDefs.setAttribute("ColumnGap", "5");
        TagNode colDef1 = new TagNode("ColumnDef", null);
        colDef1.setAttribute("Width", "100px");
        colDefs.addNode(colDef1);
        TagNode colDef2 = new TagNode("ColumnDef", null);
        colDef2.setAttribute("Width", "100%");
        colDefs.addNode(colDef2);

        gridLayoutNode.addNode(rowDefs);
        gridLayoutNode.addNode(colDefs);

        compViewNode.addNode(gridLayoutNode);


        return compViewNode;
    }

    private static TagNode setEditView(MetaForm metaForm, TagNode parentNode, Diff diff) throws Throwable {
        TagNode editViewNode = new TagNode("EditView", null);
        String parentTagName = parentNode.getTagName();
        if (ConstantUtil.GRID_LAYOUT_PANEL.equals(parentTagName)) {
            if (diff.x != null && diff.y != null) {
                editViewNode.setAttribute(ConstantUtil.X, diff.x.toString());
                editViewNode.setAttribute(ConstantUtil.Y, diff.y.toString());
            } else {
                editViewNode.setAttribute(ConstantUtil.X, "0");
                editViewNode.setAttribute(ConstantUtil.Y, "0");
            }
        }
        editViewNode.setAttribute(ConstantUtil.KEY, diff.getKey());
        editViewNode.setAttribute(ConstantUtil.CAPTION, diff.caption);
        editViewNode.setAttribute("RowHeight", "140");
        editViewNode.setAttribute("Width", "100%");
        editViewNode.setAttribute("Height", "240px");
        editViewNode.setAttribute("Padding", "10px");
        TagNode formatNode = new TagNode("Format", null);
        formatNode.setAttribute("BackColor", "#e5e4e480");
        editViewNode.addNode(formatNode);
        TagNode rowNode = new TagNode("EditViewRow", null);
        rowNode.setAttribute("TopMargin", "5px");
        editViewNode.addNode(rowNode);
        // 添加默认布局
        editViewNode.setAttribute("TableKey", diff.associatedTable);
        TagNode bodyNode = diff.getXmlTree().xmlTree.getRoot().getChildByTagName("Body");
        TagNode viewCollectionNode = bodyNode.getOrCreateChildByTagName("ViewCollection");
        TagNode viewNode = null;
        for (int i = 0; i < viewCollectionNode.getChildren().size(); i++) {
            AbstractNode subViewNode = viewCollectionNode.getChildren().get(i);
            if (!(subViewNode instanceof TagNode)) continue;
            int mediaValue = Media.valueOf(((TagNode) subViewNode).getAttributes().get("Media").toString());
            if (Media.isSupportMedia(Media.ANDROID, mediaValue) || Media.isSupportMedia(Media.IOS, mediaValue)) {
                viewNode = (TagNode) subViewNode;
                break;
            }
        }
        if (viewNode == null) {
            viewNode = new TagNode("View", null);
            viewNode.setAttribute("Key", "MobileView");
            viewNode.setAttribute("Media", "IOS|ANDROID");
            viewCollectionNode.addNode(viewNode);
        }

        TagNode componentViewNode = getDefaultComponentView(diff.getKey());
        if(viewNode.getChildByKey(diff.getKey()) != null){
            viewNode.getChildren().remove(viewNode.getChildByKey(diff.getKey()));
        }
        viewNode.addNode(componentViewNode);
        return editViewNode;
    }

    private static TagNode setTableView(MetaForm metaForm, TagNode parentNode, Diff diff, int anInt){
        TagNode tabNode = new TagNode(MetaObjectType.TableView.name, null);
        String parentTagName = parentNode.getTagName();
        if (ConstantUtil.GRID_LAYOUT_PANEL.equals(parentTagName)) { //当父类为面板
            if (diff.getMetaObjectType() != MetaObjectType.subDetail) {
                if (diff.x != null && diff.y != null) {
                    tabNode.setAttribute(ConstantUtil.X, diff.x.toString());
                    tabNode.setAttribute(ConstantUtil.Y, diff.y.toString());
                } else {
                    tabNode.setAttribute(ConstantUtil.X, "0");
                    tabNode.setAttribute(ConstantUtil.Y, "0");
                }
            }
        }
        tabNode.setAttribute(ConstantUtil.KEY, diff.getKey());
        tabNode.setAttribute(ConstantUtil.CAPTION, diff.caption);
        tabNode.setAttribute("Padding", "10px");

        TagNode formatNode = new TagNode("Format", null);
        formatNode.setAttribute("BackColor", "#efefef");
        tabNode.addNode(formatNode);

        TagNode rowCollectionNode = new TagNode("TableRowCollection", null);
        TagNode rowNode = new TagNode("TableRow", null);
        rowNode.setAttribute("Key", diff.getKey() +"Row" + anInt);
        rowNode.setAttribute("Caption", diff.getKey() +"Row" + anInt);
        TagNode defaultPanelNode = new TagNode("LinearLayoutPanel", null);
        defaultPanelNode.setAttribute("Key", diff.getKey() +"DefaultPanel" + anInt);
        defaultPanelNode.setAttribute("Caption", diff.getKey() +"DefaultPanel" + anInt);
        defaultPanelNode.setAttribute("Height", "45px");
        rowNode.addNode(defaultPanelNode);
        rowCollectionNode.addNode(rowNode);

        tabNode.addNode(rowCollectionNode);
        return tabNode;
    }

    private static TagNode setCollectionView(MetaForm metaForm, TagNode parentNode, Diff diff, int anInt){
        TagNode tabNode = new TagNode(MetaObjectType.CollectionView.name, null);
        String parentTagName = parentNode.getTagName();
        if (ConstantUtil.GRID_LAYOUT_PANEL.equals(parentTagName)) { //当父类为面板
            if (diff.getMetaObjectType() != MetaObjectType.subDetail) {
                if (diff.x != null && diff.y != null) {
                    tabNode.setAttribute(ConstantUtil.X, diff.x.toString());
                    tabNode.setAttribute(ConstantUtil.Y, diff.y.toString());
                } else {
                    tabNode.setAttribute(ConstantUtil.X, "0");
                    tabNode.setAttribute(ConstantUtil.Y, "0");
                }
            }
        }
        tabNode.setAttribute(ConstantUtil.KEY, diff.getKey());
        tabNode.setAttribute(ConstantUtil.CAPTION, diff.caption);
        tabNode.setAttribute("Padding", "10px");

        TagNode formatNode = new TagNode("Format", null);
        formatNode.setAttribute("BackColor", "#efefef");
        tabNode.addNode(formatNode);


        TagNode rowCollectionNode = new TagNode("CollectionViewRowCollection", null);
        TagNode rowNode = new TagNode("CollectionViewRow", null);
        rowNode.setAttribute("Key", diff.getKey() +"Row" + anInt);
        rowNode.setAttribute("Caption", diff.getKey() +"Row" + anInt);
        TagNode defaultPanelNode = new TagNode("LinearLayoutPanel", null);
        defaultPanelNode.setAttribute("Key", diff.getKey() +"DefaultPanel" + anInt);
        defaultPanelNode.setAttribute("Caption", diff.getKey() +"DefaultPanel" + anInt);
        defaultPanelNode.setAttribute("Height", "45px");
        rowNode.addNode(defaultPanelNode);
        rowCollectionNode.addNode(rowNode);

        tabNode.addNode(rowCollectionNode);
        return tabNode;
    }

    private static TagNode setListView(MetaForm metaForm, TagNode parentNode, Diff diff, int anInt) {
        //添加节点
        TagNode tabNode = new TagNode(MetaObjectType.listView.name, null);
        String parentTagName = parentNode.getTagName();
        if (ConstantUtil.GRID_LAYOUT_PANEL.equals(parentTagName)) { //当父类为面板
            if (diff.getMetaObjectType() != MetaObjectType.subDetail) {

                if (diff.x != null && diff.y != null) {
                    tabNode.setAttribute(ConstantUtil.X, diff.x.toString());
                    tabNode.setAttribute(ConstantUtil.Y, diff.y.toString());
                } else {
                    tabNode.setAttribute(ConstantUtil.X, "0");
                    tabNode.setAttribute(ConstantUtil.Y, "0");
                }
            }
        }

        tabNode.setAttribute(ConstantUtil.KEY, diff.getKey());
        tabNode.setAttribute(ConstantUtil.CAPTION, diff.caption);
        String associatedTable = diff.associatedTable;
        if (StringUtils.isNotBlank(associatedTable)) {
            tabNode.setAttribute(ConstantUtil.TABLE_KEY, associatedTable);
        }
        TagNode collNode = new TagNode("ListViewColumnCollection", null);
        TagNode listnode = new TagNode(ConstantUtil.LIST_VIEW_COLUMN, null);
        listnode.setAttribute(ConstantUtil.KEY, "column" + anInt);
        listnode.setAttribute(ConstantUtil.CAPTION, "column" + anInt);
        TagNode endcols = new TagNode("ListViewColumnCollection", null);
        TagNode endListView = new TagNode("ListView", null);
        tabNode.addNode(collNode);
        tabNode.addNode(endListView);
        collNode.addNode(listnode);

        if (diff.getCreate() != null && "1".equals(diff.getCreate())) {//根据数据源创建列表视图
            MetaTable metaTable = metaForm.getMetaTable(associatedTable);
            for (MetaColumn metaColumn : metaTable) {
                String key = metaColumn.getKey();
                String caption = metaColumn.getCaption();
                if (ConstantUtil.OID.equals(key) ||
                        ConstantUtil.POID.equals(key) ||
                        ConstantUtil.SOID.equals(key) ||
                        ConstantUtil.VERID.equals(key) ||
                        ConstantUtil.DVERID.equals(key) ||
                        ConstantUtil.MAP_COUNT.equals(key) ||
                        ConstantUtil.SELECT_FIELD.equals(key) ||
                        key.contains(ConstantUtil.NODB) ||
                        ConstantUtil.SEQUENCE.equals(key)) {
                    continue;
                }
                String resource;
                try {
                    resource = LoadFileTree.getPathByFormKey(metaForm.getKey());
                    XmlTreeWithPath parse = XmlTreeWithPath.parseFilePath(resource);
                    int haveRelyOn = isHaveRelyOn(key, parse.xmlTree, associatedTable);
                    if (haveRelyOn != 0) {
                        continue;
                    }
                } catch (Throwable e) {
                    LogSvr.getInstance().error("", e);
                }
                TagNode colDeleteNode1 = new TagNode(ConstantUtil.LIST_VIEW_COLUMN, null);
                colDeleteNode1.setAttribute(ConstantUtil.KEY, key);
                if (Objects.equals(caption, "")) {
                    colDeleteNode1.setAttribute(ConstantUtil.CAPTION, key);
                } else {
                    colDeleteNode1.setAttribute(ConstantUtil.CAPTION, caption);
                }
                int dataType = metaColumn.getDataType();
                String cellType = DataType.toString(dataType);
                String type = getGridCellType(cellType, key);
                colDeleteNode1.setAttribute(ConstantUtil.COLUMN_TYPE, type);
                colDeleteNode1.setAttribute(ConstantUtil.WIDTH, "80px");
                colDeleteNode1.setAttribute(ConstantUtil.DATA_COLUMN_KEY, key);
                collNode.addNode(colDeleteNode1);//GridColumn
            }
        }
        collNode.addNode(endcols);
        return tabNode;
    }

    private static int location(Diff diff, TagNode parent) {
        List<AbstractNode> children = parent.getChildren();
        int index = 0;
        for (int i = 0; i < children.size(); i++) {
            AbstractNode abstractNode = children.get(i);
            if (abstractNode instanceof TagNode && diff.parentKey.equals(((TagNode) abstractNode).getAttributes().get(ConstantUtil.KEY))) {
                index = i;
            }
        }
        return index;
    }


    private static void mergeGridRowNewDiff(MetaGrid parentGrid, TagNode parentNode, Diff diff) {
        final MetaForm metaForm = diff.getMetaForm();
        String rowType = RowType.toString(diff.getControlType());
        if ("Group".equalsIgnoreCase(rowType)) {
            if (StringUtils.isBlank(diff.getReserveOne())) {
                throw new RuntimeException("warning: 请选择分组行对应的分组标识");
            }
            if (ReportCellGroupType.None == IDLookup.getIDLookup(metaForm).getGridCellByKey(diff.getReserveOne()).getCellGroupType() ||
                    ReportCellGroupType.RowTreeGroup == IDLookup.getIDLookup(metaForm).getGridCellByKey(diff.getReserveOne()).getCellGroupType()) {
                throw new RuntimeException("warning: 请将分组标识对应的GridCell字段设置为行分组类型");
            }
        } else if (RowType.STR_Detail.equalsIgnoreCase(rowType)) {
            MetaGridRowCollection rowCollection = parentGrid.getRowCollection();
            for (MetaGridRow metaGridRow : rowCollection) {
                int rowType1 = metaGridRow.getRowType();
                if (RowType.Detail == rowType1) {
                    throw new RuntimeException("warning: 表格中只能存在一行明细行");
                }
            }
        }
        IDLookup idLookup = IDLookup.getIDLookup(metaForm);
        MetaGridColumnCollection metaGridColumns = idLookup.getMetaGridByGridKey(diff.parentKey).getColumnCollection();
        for (MetaGridColumn metaGridColumn : metaGridColumns) {
            if (metaGridColumn.isVestDeleted()) {
                throw new RuntimeException("warning: 该表格存在马甲删除字段，暂不支持添加行");
            }
        }
        List<AbstractNode> parentChildren = parentNode.getChildren();
        for (AbstractNode parentChild : parentChildren) {
            if (parentChild instanceof TagNode) {
                TagNode collerction = (TagNode) parentChild;
                String tagName = ((TagNode) parentChild).getTagName();
                if (ConstantUtil.GRID_ROW_COLLECTION.equalsIgnoreCase(tagName)) {
                    TagNode collNode = new TagNode(ConstantUtil.GRID_ROW, null);
                    if ("Group".equalsIgnoreCase(rowType)) {
                        collNode.setAttribute(ConstantUtil.GROUP_KEY, diff.getReserveOne());
                    }
                    collNode.setAttribute(ConstantUtil.KEY, diff.getKey());
                    if (!ConstantUtil.DETAIL.equalsIgnoreCase(rowType)) {
                        collNode.setAttribute(ConstantUtil.ROW_TYPE, rowType);
                    }
                    List<AbstractNode> gridRows = collerction.getChildren();
                    int i = 0;
                    for (AbstractNode gridRow : gridRows) {
                        if (gridRow instanceof TagNode) {
                            List<AbstractNode> tagNodes = ((TagNode) gridRow).getChildren();
                            for (AbstractNode tagNode : tagNodes) {
                                if (tagNode instanceof TagNode) {
                                    String name = ((TagNode) tagNode).getPrimaryKey();
                                    if (name != null) {
                                        TagNode child = new TagNode(ConstantUtil.GRID_CELL, null);
                                        child.setAttribute(ConstantUtil.KEY, diff.getKey() + i);
                                        i++;
                                        collNode.addNode(child);
                                    }

                                }
                            }
                            break;
                        }
                    }
                    XmlTreeWithPath xmlTree = diff.getXmlTree();
                    String sideRowKey;
                    TagNode tagNode = xmlTree.xmlTree.getTagNode("GridCell@" + diff.sideKey);
                    if (tagNode != null) {
                        sideRowKey = tagNode.getParent().getPrimaryKey().substring(tagNode.getParent().getPrimaryKey().indexOf("@") + 1);
                    } else {
                        tagNode = xmlTree.xmlTree.getTagNode("GridRow@" + diff.sideKey);
                        sideRowKey = tagNode.getPrimaryKey().substring(tagNode.getPrimaryKey().indexOf("@") + 1);
                    }
                    int index = compIndex(gridRows, sideRowKey);
                    if (diff.insertAfter) {
                        if (index == 0) {
                            gridRows.add(index, collNode);
                        } else {
                            gridRows.add(index + 1, collNode);
                        }
                    } else {
                        gridRows.add(index - 1, collNode);
                    }
                }
            }
        }
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        int startLine = xmlTree.xmlTree.getLineByIndex(parentNode.getElement().getBgIndex());
        String orgXmlFragment = xmlTree.xmlTree.getNodeString(startLine);
        String newXmlFragment = DesignIOMetaUtil.getXml(parentNode);
        if (diff.getOrgXmlFragment() != null && diff.getNewXmlFragment() != null) {
            diff.setXmlDiff2(xmlTree, startLine, orgXmlFragment, newXmlFragment);
        } else {
            diff.setXmlDiff(xmlTree, startLine, orgXmlFragment, newXmlFragment);
        }
    }

    private static void mergeSonGridNewDiff(TagNode parentNode, Diff diff) throws Throwable {
        final MetaForm metaForm = diff.getMetaForm();
        String sideKey = diff.sideKey;
        String controlType = ControlType.toString(diff.getControlType());
        TagNode parent = parentNode.getParent();
        TagNode per = parent.getParent();
        List<AbstractNode> parentChildren = per.getChildren();
        TagNode gridNode;
        TagNode tempNode = parentNode;
        int statisticsRowIndex = 0;
        TagNode tableNode = null;
        String rowSideKey = "";
        boolean flag = false;

        boolean isNew = false;
        int order = 0;
        while (!ConstantUtil.GRID.equalsIgnoreCase(tempNode.getParent().getTagName())) {
            tempNode = tempNode.getParent();//获取最外层表格节点
        }
        gridNode = tempNode.getParent();
        List<AbstractNode> nodeList = gridNode.getChildren();
        TagNode childByTagName = gridNode.getOrCreateChildByTagName(ConstantUtil.GRID_COLUMN_COLLECTION);
        TagNode rowNode = null;
        if (diff.getMetaObjectType() == MetaObjectType.gridField) {
            List<AbstractNode> children = parentNode.getChildren();//添加的子列父节点
            TagNode collNode = null;
            if (children.size() == 0) {
                collNode = new TagNode(ConstantUtil.GRID_COLUMN_COLLECTION, null);//如果时第一次新加子节点，创建一个新的GridColumnCollection加入父节点中
                children.add(collNode);
                isNew = true;
            }
            for (AbstractNode abstractNode : parentChildren) {
                if (abstractNode instanceof TagNode) {
                    String tagName = ((TagNode) abstractNode).getTagName();
                    if (ConstantUtil.GRID_COLUMN_COLLECTION.equals(tagName)) {
                        List<AbstractNode> columns;
                        if (collNode != null) {
                            columns = collNode.getChildren();//新增节点
                        } else {
                            collNode = parentNode;//已经存在集合节点
                            columns = (parentNode.getOrCreateChildByTagName(ConstantUtil.GRID_COLUMN_COLLECTION)).getChildren();
                        }
                        TagNode node = new TagNode(ConstantUtil.GRID_COLUMN, null);
                        node.setAttribute(ConstantUtil.KEY, diff.getKey());//子列属性设置
                        node.setAttribute(ConstantUtil.CAPTION, diff.caption);
                        node.setAttribute(ConstantUtil.WIDTH, "80px");
                        node.setParent(collNode);
                        String tableKey = gridNode.getOrCreateChildByTagName(ConstantUtil.GRID_ROW_COLLECTION).getOrCreateChildByTagName(ConstantUtil.GRID_ROW).getAttributes().get(ConstantUtil.TABLE_KEY);

                        if (diff.getDataObjectXmlTree() != null) {
                            tableNode = diff.getDataObjectXmlTree().xmlTree.getTagNode(ConstantUtil.TABLE + "@" + tableKey);
                        } else {
                            tableNode = diff.getXmlTree().xmlTree.getTagNode(ConstantUtil.TABLE + "@" + tableKey);
                        }
                        if (tableKey != null && tableKey.length() != 0 && !tableKey.contains(ConstantUtil.NODB)
                                && tableNode != null && !ControlType.STR_BUTTON.equals(controlType) && "true".equalsIgnoreCase(diff.getReserveTwo())) {
                            TagNode newColumnNode = new TagNode(ConstantUtil.COLUMN, null);
                            newColumnNode.setAttribute(ConstantUtil.KEY, diff.getReserveThree());
                            newColumnNode.setAttribute(ConstantUtil.CAPTION, diff.caption);
                            if (StringUtils.isEmpty(diff.getDataElementKey())) {
                                newColumnNode.setAttribute(ConstantUtil.DATA_TYPE, getDatatype(diff.getControlType()));
                            } else {
                                newColumnNode.setAttribute(ConstantUtil.DataElementKey, diff.getDataElementKey());
                            }
                            if (DataType.STR_STRING.equalsIgnoreCase(getDatatype(diff.getControlType()))) {
                                newColumnNode.setAttribute(ConstantUtil.LENGTH, "255");
                            }
                            String key = metaForm.getDataSource().getDataObject().getKey();
                            String extendKey = metaForm.getExtend();
                            MetaFormProfile metaFormProfile = MetaFactory.getGlobalInstance().getMetaFormList().get(metaForm.getKey());
                            if(metaFormProfile == null) metaFormProfile = MetaFactory.getGlobalInstance().getExtFormList().get(metaForm.getKey());
                            Boolean mergeToSource = metaFormProfile.getMergeToSource();
                            if (!key.equals(extendKey) || mergeToSource) {
                                tableNode.addNode(newColumnNode);
                            }
                            if (diff.getDataObjectXmlTree() != null) {
                                genXmlDiff(diff.getDataObjectXmlTree(), tableNode, diff, false);
                            } else {
                                genXmlDiff(diff.getXmlTree(), tableNode, diff, false);
                            }

                        }
                        if (!isNew) {//确定添加GridCell位置
                            statisticsRowIndex = statisticsRowIndex(childByTagName, sideKey, parentNode);
                        }
                        if (isNew) {
                            columns.add(node);//新建的直接添加到后面
                        } else {
                            if (StringUtils.isEmpty(sideKey)) {
                                columns.add(columns.size() - 1, node);
                            } else {
                                columns.add(columns.size() - 2, node);
                            }
                        }

                    }
                }
            }

            for (AbstractNode node : nodeList) {
                if (node instanceof TagNode) {
                    if (ConstantUtil.GRID_ROW_COLLECTION.equalsIgnoreCase(((TagNode) node).getTagName())) {
                        rowNode = (TagNode) node;
                        break;
                    }
                }
            }
            List<AbstractNode> gridRows = rowNode.getChildren();
            int index = 0;
            for (AbstractNode gridRow : gridRows) {
                if (gridRow instanceof TagNode) {
                    String name = ((TagNode) gridRow).getTagName();
                    if (ConstantUtil.GRID_ROW.equals(name)) {
                        if (collNode.getChildren().size() > 1) {//节点下已有子列，需要添加GridCell
                            if (!flag) {
                                String tableKey = ((TagNode) gridRow).getAttributes().get(ConstantUtil.TABLE_KEY);
                                List<AbstractNode> rows = ((TagNode) gridRow).getChildren();
                                TagNode node = new TagNode(ConstantUtil.GRID_CELL, null);
                                node.setAttribute(ConstantUtil.KEY, diff.getKey());
                                node.setAttribute(ConstantUtil.CAPTION, diff.caption);
                                node.setAttribute(ConstantUtil.CELL_TYPE, controlType);
                                //当添加的组件类型为字典时添加默认字典标识作为提示
                                if (ControlType.STR_DICT.equalsIgnoreCase(controlType) || ControlType.STR_DYNAMICDICT.equals(controlType)) {
                                    if (StringUtils.isNotEmpty(diff.getItemKey())) {
                                        node.setAttribute(ConstantUtil.ITEM_KEY, diff.getItemKey());
                                    } else {
                                        throw new Throwable("ItemKey为空，请检查配置");
                                    }
                                    codeAndNameWithDictComponent(diff, diff.getReserveThree(), tableKey, node);
                                    if (diff.getDataObjectXmlTree() != null) {
                                        genXmlDiff(diff.getDataObjectXmlTree(), tableNode, diff, false);
                                    } else {
                                        genXmlDiff(diff.getXmlTree(), tableNode, diff, false);
                                    }
                                } else if (ControlType.STR_COMBOBOX.equalsIgnoreCase(controlType)) {
                                    node.setAttribute(ConstantUtil.CACHE, "false");
                                }
                                if (tableKey != null && tableKey.length() != 0 && !tableKey.contains(ConstantUtil.NODB) && !ControlType.STR_BUTTON.equals(controlType) && "true".equalsIgnoreCase(diff.getReserveTwo())) {
                                    String key = metaForm.getDataSource().getDataObject().getKey();
                                    String extendKey = metaForm.getExtend();
                                    MetaFormProfile metaFormProfile = MetaFactory.getGlobalInstance().getMetaFormList().get(metaForm.getKey());
                                    if(metaFormProfile == null) metaFormProfile = MetaFactory.getGlobalInstance().getExtFormList().get(metaForm.getKey());
                                    Boolean mergeToSource = metaFormProfile.getMergeToSource();
                                    if (!key.equals(extendKey) || mergeToSource) {// //因为现在马甲无法修改数据源所以普通// 马甲不做处理
                                        TagNode NewdtbNode = new TagNode(MetaDataBinding.TAG_NAME, null);
                                        NewdtbNode.setAttribute(ConstantUtil.COLUMN_KEY, diff.getReserveThree());
                                        node.addNode(NewdtbNode);
                                    }
                                }
                                node.setParent(((TagNode) gridRow));
                                index = compIndex(rows, rowSideKey);
                                if (isNew) {
                                    rows.add(node);
                                } else {
                                    if (diff.insertAfter) {
                                        if (index == 0) {
                                            rows.add(statisticsRowIndex * 2, node);
                                        } else {
                                            rows.add((statisticsRowIndex + 1) * 2, node);
                                        }
                                    } else {
                                        rows.add((statisticsRowIndex - 1) * 2, node);
                                    }
                                }
                                flag = true;
                            } else {
                                List<AbstractNode> rows = ((TagNode) gridRow).getChildren();
                                String nameId = ((TagNode) gridRow).getAttributes().get(ConstantUtil.ROW_TYPE);
                                if (!StringUtils.isNotEmpty(nameId)) {
                                    nameId = ConstantUtil.DETAIL;
                                }
                                TagNode node = new TagNode(ConstantUtil.GRID_CELL, null);
                                node.setAttribute(ConstantUtil.KEY, nameId + diff.getKey() + order);
                                //当添加的组件类型为字典时添加默认字典标识作为提示
                                node.setParent(((TagNode) gridRow));
                                if (isNew) {
                                    rows.add(node);
                                } else {
                                    if (diff.insertAfter) {
                                        if (index == 0) {
                                            rows.add(statisticsRowIndex * 2, node);
                                        } else {
                                            rows.add((statisticsRowIndex + 1) * 2, node);
                                        }
                                    } else {
                                        rows.add((statisticsRowIndex - 1) * 2, node);
                                    }
                                }
                                order++;
                            }

                        }else{
                            String tableKey = ((TagNode) gridRow).getAttributes().get(ConstantUtil.TABLE_KEY);
                            List<AbstractNode> rows = ((TagNode) gridRow).getChildren();
                            for (int i = 0; i < rows.size(); i++) {

                                if(rows.get(i) instanceof TagNode && ((TagNode)rows.get(i)).getAttributes().get(ConstantUtil.KEY).equals(diff.parentKey)){
                                    TagNode node = (TagNode)rows.get(i);
                                    node.setAttribute(ConstantUtil.KEY, diff.getKey());
                                    node.setAttribute(ConstantUtil.CAPTION, diff.caption);
                                    node.setAttribute(ConstantUtil.CELL_TYPE, controlType);
                                    if(node.hasChildren()){
                                        node.getChildren().clear();
                                    }
                                    //当添加的组件类型为字典时添加默认字典标识作为提示
                                    if (ControlType.STR_DICT.equalsIgnoreCase(controlType) || ControlType.STR_DYNAMICDICT.equals(controlType)) {
                                        if (StringUtils.isNotEmpty(diff.getItemKey())) {
                                            node.setAttribute(ConstantUtil.ITEM_KEY, diff.getItemKey());
                                        } else {
                                            throw new Throwable("ItemKey为空，请检查配置");
                                        }
                                        codeAndNameWithDictComponent(diff, diff.getReserveThree(), tableKey, node);
                                        if (diff.getDataObjectXmlTree() != null) {
                                            genXmlDiff(diff.getDataObjectXmlTree(), tableNode, diff, false);
                                        } else {
                                            genXmlDiff(diff.getXmlTree(), tableNode, diff, false);
                                        }
                                    } else if (ControlType.STR_COMBOBOX.equalsIgnoreCase(controlType)) {
                                        node.setAttribute(ConstantUtil.CACHE, "false");
                                    }
                                    if (tableKey != null && tableKey.length() != 0 && !tableKey.contains(ConstantUtil.NODB) && !ControlType.STR_BUTTON.equals(controlType) && "true".equalsIgnoreCase(diff.getReserveTwo())) {
                                        String key = metaForm.getDataSource().getDataObject().getKey();
                                        String extendKey = metaForm.getExtend();
                                        MetaFormProfile metaFormProfile = MetaFactory.getGlobalInstance().getMetaFormList().get(metaForm.getKey());
                                        if(metaFormProfile == null) metaFormProfile = MetaFactory.getGlobalInstance().getExtFormList().get(metaForm.getKey());
                                        Boolean mergeToSource = metaFormProfile.getMergeToSource();
                                        if (!key.equals(extendKey) || mergeToSource) {// //因为现在马甲无法修改数据源所以普通// 马甲不做处理
                                            TagNode NewdtbNode = new TagNode(MetaDataBinding.TAG_NAME, null);
                                            NewdtbNode.setAttribute(ConstantUtil.COLUMN_KEY, diff.getReserveThree());
                                            node.addNode(NewdtbNode);
                                        }
                                    }
                                    break;
                                }
                            }
                        }
                    }
                }
            }
        }
        // 因新节点的插入位置难以计算，所以将整个父节点替换掉
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        int startLine = xmlTree.xmlTree.getLineByIndex(gridNode.getElement().getBgIndex());
        String orgXmlFragment = xmlTree.xmlTree.getNodeString(startLine);
        String newXmlFragment = DesignIOMetaUtil.getXml(gridNode);
        if (diff.getOrgXmlFragment() != null && diff.getNewXmlFragment() != null) {
            diff.setXmlDiff2(xmlTree, startLine, orgXmlFragment, newXmlFragment);
        } else {
            diff.setXmlDiff(xmlTree, startLine, orgXmlFragment, newXmlFragment);
        }
    }

    /**
     * 设置表头组件的几个基本属性
     */
    private static void setBasicProperty(TagNode node, Diff diff) {
        node.setAttribute(ConstantUtil.KEY, diff.getKey());
        node.setAttribute(ConstantUtil.CAPTION, diff.caption);
        node.setAttribute(ConstantUtil.X, diff.x != null ? diff.x.toString() : "0");
        node.setAttribute(ConstantUtil.Y, diff.y != null ? diff.y.toString() : "0");
    }

    /**
     * RowDefCollection标签的索引
     */
    private static Integer getRowDefIndex(List<AbstractNode> children) {
        for (AbstractNode abstractNode : children) {
            if (abstractNode instanceof TagNode) {
                String tagName = ((TagNode) abstractNode).getTagName();
                if (ConstantUtil.ROW_DEF_COLLECTION.equals(tagName)) {
                    return children.indexOf(abstractNode);
                }
            }
        }
        return null;
    }

    public static TagNode SetGridLayoutPanel(Diff diff, MetaForm metaForm, int anInt) throws Throwable{
        TagNode gridLayoutNode = new TagNode(ConstantUtil.GRID_LAYOUT_PANEL, null);
        if (diff.getMetaObjectType() == MetaObjectType.panel || diff.getMetaObjectType() == MetaObjectType.EmbedPanel) {
            gridLayoutNode.setAttribute(ConstantUtil.KEY, diff.getKey());
            gridLayoutNode.setAttribute(ConstantUtil.CAPTION, diff.caption);
        } else if (diff.getMetaObjectType() == MetaObjectType.subDetail) {
            gridLayoutNode.setAttribute(ConstantUtil.KEY, "tempGridLayoutPanel" + anInt);
            gridLayoutNode.setAttribute(ConstantUtil.CAPTION, "tempGridLayoutPanel" + anInt);
        }
        if (diff.x != null && diff.y != null) {//如果不为空
            gridLayoutNode.setAttribute(ConstantUtil.X, diff.x.toString());
            gridLayoutNode.setAttribute(ConstantUtil.Y, diff.y.toString());
        }
        gridLayoutNode.setAttribute(ConstantUtil.PADDING, "16px");
        TagNode rows = new TagNode(ConstantUtil.ROW_DEF_COLLECTION, null);
        rows.setAttribute(ConstantUtil.ROW_GAP, "24");
        rows.setAttribute(ConstantUtil.ROW_HEIGHT, "30");

        String cellList = diff.getCellList();
        JSONArray cellArrays = null;
        if(StringUtils.isNotEmpty(cellList)){
            cellArrays = new JSONArray(cellList);
        }
        if (cellArrays != null) {
            int rowCount = (int)Math.ceil((double)cellArrays.length() / (double)3);
            if (rowCount < 4) {
                rowCount = 3;
            }
            for (int i = 0; i < rowCount; i++) {
                TagNode rowDef = new TagNode(ConstantUtil.ROW_DEF, null);
                rows.addNode(rowDef);
            }

        } else {
            // 默认添加三行
            for (int i = 0; i < 3; i++) {
                TagNode rowDef = new TagNode(ConstantUtil.ROW_DEF, null);
                rows.addNode(rowDef);
            }
        }

        TagNode cols = new TagNode(ConstantUtil.COLUMN_DEF_COLLECTION, null);
        cols.setAttribute(ConstantUtil.COLUMN_GAP, "16");
        // 默认每行添加三个网格
        for (int i = 1; i < 4; i++) {
            TagNode col = new TagNode(ConstantUtil.COLUMN_DEF, null);
            if (i == 3) {
                col.setAttribute(ConstantUtil.WIDTH, "34%");
            } else {
                col.setAttribute(ConstantUtil.WIDTH, "33%");
            }
            cols.addNode(col);
        }
        // 结束节点
        TagNode endCols = new TagNode(ConstantUtil.COLUMN_DEF_COLLECTION, null);
        TagNode endRows = new TagNode(ConstantUtil.ROW_DEF_COLLECTION, null);
        //TagNode endPanel = new TagNode(ConstantUtil.GRID_LAYOUT_PANEL, null);
        rows.addNode(endRows);
        cols.addNode(endCols);
        if (StringUtils.isNotEmpty(cellList)) {

            int rowIndex = 0;
            for (int i = 1; i <= cellArrays.length(); i++) {
                JSONObject cell = cellArrays.getJSONObject(i-1);
                String columnKey = cell.getString(ConstantUtil.COLUMN_KEY);
                String fieldKey = cell.getString(ConstantUtil.KEY);
                String caption = cell.getString("ColumnName");
                String controlType =  cell.getString(ConstantUtil.CONTROLTYPE);
                String dataElementKey = cell.getString("DataElementKey");
                TagNode control = new TagNode(controlType, null);
                control.setAttribute(ConstantUtil.KEY, fieldKey);
                control.setAttribute(ConstantUtil.CAPTION, caption);
                control.setAttribute(ConstantUtil.Y, String.valueOf(rowIndex));
                control.setAttribute(ConstantUtil.X, String.valueOf(((i - 1) % 3)));
                if(StringUtils.isNotEmpty(dataElementKey)){
                    addDomainPropertyToNode(control, controlType, dataElementKey);
                }
                if (i % 3 == 0) {
                    rowIndex++;
                }
                TagNode dataBinding = new TagNode(MetaDataBinding.TAG_NAME, null);
                dataBinding.setAttribute(ConstantUtil.TABLE_KEY, diff.associatedTable);
                dataBinding.setAttribute(ConstantUtil.COLUMN_KEY, columnKey);
                control.addNode(dataBinding);
                if (ControlType.STR_NUMBEREDITOR.equalsIgnoreCase(controlType)) {
                    TagNode format = new TagNode(ConstantUtil.FORMAT, null);
                    format.setAttribute(ConstantUtil.HALIGN, HAlignment.STR_RIGHT);
                    control.addNode(format);
                }
                gridLayoutNode.addNode(control);
            }
        }
        gridLayoutNode.addNode(rows);
        gridLayoutNode.addNode(cols);
        //gridLayoutNode.addNode(endPanel);
        return gridLayoutNode;
    }

    private static TagNode setGrid(MetaForm metaForm, TagNode parentNode, Diff diff) throws Throwable{
        int anInt = 1;
        IDLookup idLookup = IDLookup.reloadIDLookup(metaForm);
        StringHashMap<MetaGridColumn> allGridColumn = idLookup.getAllFieldKey2MetaGridColumnInfo();
        while (allGridColumn.containsKey(ConstantUtil.IS_SELECT + anInt)) {
            anInt++;
        }
        //添加Grid节点
        TagNode tabNode = new TagNode(MetaObjectType.grid.name, null);
        String parentTagName = parentNode.getTagName();
        if (ConstantUtil.GRID_LAYOUT_PANEL.equals(parentTagName)) { //当父类为面板
            if (diff.getMetaObjectType() != MetaObjectType.subDetail) {

                if (diff.x != null && diff.y != null) {
                    tabNode.setAttribute(ConstantUtil.X, diff.x.toString());
                    tabNode.setAttribute(ConstantUtil.Y, diff.y.toString());
                } else {
                    tabNode.setAttribute(ConstantUtil.X, "0");
                    tabNode.setAttribute(ConstantUtil.Y, "0");
                }
            }
        }
        if (diff.getMetaObjectType() == MetaObjectType.grid) {
            tabNode.setAttribute(ConstantUtil.KEY, diff.getKey());
            tabNode.setAttribute(ConstantUtil.CAPTION, diff.caption);
        } else if (diff.getMetaObjectType() == MetaObjectType.subDetail) {
            tabNode.setAttribute(ConstantUtil.KEY, "SubGrid" + anInt);
            tabNode.setAttribute(ConstantUtil.CAPTION, "SubGrid" + anInt);
        }
        String associatedTable = diff.associatedTable;
        tabNode.setAttribute(ConstantUtil.SHOW_ROW_HEAD, "true");
        tabNode.setAttribute(ConstantUtil.SERIAL_SEQ, "true");
        tabNode.setAttribute(MetaConstants.GRID_OPTION, "insert,delete,shift,bestWidth");

        TagNode colsNode = new TagNode(ConstantUtil.GRID_COLUMN_COLLECTION, null);
        TagNode colSelectNode = new TagNode(ConstantUtil.GRID_COLUMN, null);
        colSelectNode.setAttribute(ConstantUtil.KEY, ConstantUtil.IS_SELECT + anInt);
        colSelectNode.setAttribute(ConstantUtil.CAPTION, "选择");
        colSelectNode.setAttribute(ConstantUtil.WIDTH, "80px");
        TagNode rowsNode = new TagNode(ConstantUtil.GRID_ROW_COLLECTION, null);
        TagNode gridRowNode = new TagNode(ConstantUtil.GRID_ROW, null);
        gridRowNode.setAttribute(ConstantUtil.KEY, "row" + anInt);
        if (associatedTable != null) {
            if (!associatedTable.isEmpty()) {
                gridRowNode.setAttribute(ConstantUtil.TABLE_KEY, associatedTable);
            }
        } else {
            if (!StringUtils.isBlank(diff.subAssociatedTable)) {
                gridRowNode.setAttribute(ConstantUtil.TABLE_KEY, diff.subAssociatedTable);
            }
        }
        TagNode selectGridCellNode = new TagNode(ConstantUtil.GRID_CELL, null);
        selectGridCellNode.setAttribute(ConstantUtil.KEY, ConstantUtil.IS_SELECT + anInt);
        selectGridCellNode.setAttribute(ConstantUtil.CAPTION, "选择");
        selectGridCellNode.setAttribute(ConstantUtil.CELL_TYPE, "CheckBox");
        selectGridCellNode.setAttribute(ConstantUtil.IS_SELECT, "true");
        TagNode endGridRow = new TagNode(ConstantUtil.GRID_ROW, null);
        TagNode endRows = new TagNode(ConstantUtil.GRID_ROW_COLLECTION, null);
        TagNode endcols = new TagNode(ConstantUtil.GRID_COLUMN_COLLECTION, null);
        TagNode endGrid = new TagNode(ConstantUtil.GRID, null);
        colsNode.addNode(colSelectNode);//GridColumn
        if (diff.getCreate() != null && "1".equals(diff.getCreate())) {//根据数据源创建表格列
            if (StringUtils.isNotEmpty(diff.getCellList())) {
                JSONArray cellArrays = new JSONArray(diff.getCellList());
                for (int i = 0; i < cellArrays.length(); i++) {
                    JSONObject column = cellArrays.getJSONObject(i);
                    String fieldKey = column.getString(ConstantUtil.KEY);
                    if (ConstantUtil.OID.equals(fieldKey) || ConstantUtil.POID.equals(fieldKey) || ConstantUtil.SOID.equals(fieldKey)
                            || ConstantUtil.VERID.equals(fieldKey) || ConstantUtil.DVERID.equals(fieldKey)
                            || ConstantUtil.MAP_COUNT.equals(fieldKey) || ConstantUtil.SELECT_FIELD.equals(fieldKey)
                            || fieldKey.contains(ConstantUtil.NODB) || ConstantUtil.SEQUENCE.equals(fieldKey) || "EOID".equals(fieldKey)
                            || "ESOID".equals(fieldKey) || "EPOID".equals(fieldKey)) {
                        continue;
                    }
                    String caption = column.getString("ColumnName");
                    MetaComponent componentByKey = null;
                    MetaGridCell metaGridCell = null;
                    AbstractMetaObject metaObjectColumnByKey = idLookup.getMetaObjectColumnByKey(fieldKey);
                    if (metaObjectColumnByKey instanceof MetaComponent) {
                        componentByKey = (MetaComponent)metaObjectColumnByKey;
                    }
                    if (Objects.isNull(componentByKey)) {
                        metaGridCell = idLookup.getGridCellByKey(fieldKey);
                    }
                    if (componentByKey != null || metaGridCell != null) {
                        continue;
                    }
                    String resource;
                    try {
                        resource = LoadFileTree.getPathByFormKey(metaForm.getKey());
                        XmlTreeWithPath parse = XmlTreeWithPath.parseFilePath(resource);
                        int haveRelyOn;
                        if (associatedTable != null) {
                            haveRelyOn = isHaveRelyOn(fieldKey, parse.xmlTree, associatedTable);
                        } else {
                            haveRelyOn = isHaveRelyOn(fieldKey, parse.xmlTree, diff.subAssociatedTable);
                        }
                        if (haveRelyOn != 0) {
                            continue;
                        }
                    } catch (Throwable e) {
                        LogSvr.getInstance().error("", e);
                    }

                    TagNode colDeleteNode1 = new TagNode(ConstantUtil.GRID_COLUMN, null);
                    colDeleteNode1.setAttribute(ConstantUtil.KEY, fieldKey);
                    if (StringUtils.isNotEmpty(caption)) {
                        colDeleteNode1.setAttribute(ConstantUtil.CAPTION, caption);
                    } else {
                        colDeleteNode1.setAttribute(ConstantUtil.CAPTION, fieldKey);
                    }
                    colDeleteNode1.setAttribute(ConstantUtil.WIDTH, "80px");
                    colsNode.addNode(colDeleteNode1);// GridColumn
                }
            }
        }
        colsNode.addNode(endcols);
        gridRowNode.addNode(selectGridCellNode);//GridCell
        if (diff.getCreate() != null && "1".equals(diff.getCreate())) {//根据数据源创建表格列
            if (StringUtils.isNotEmpty(diff.getCellList())) {
                JSONArray cellArrays = new JSONArray(diff.getCellList());
                for (int i = 0; i < cellArrays.length(); i++) {
                    JSONObject column = cellArrays.getJSONObject(i);
                    String columnKey = column.getString(ConstantUtil.KEY);
                    String fieldKey = column.getString(ConstantUtil.KEY);
                    if (ConstantUtil.OID.equals(fieldKey) || ConstantUtil.POID.equals(fieldKey) || ConstantUtil.SOID.equals(fieldKey)
                            || ConstantUtil.VERID.equals(fieldKey) || ConstantUtil.DVERID.equals(fieldKey)
                            || ConstantUtil.MAP_COUNT.equals(fieldKey) || ConstantUtil.SELECT_FIELD.equals(fieldKey)
                            || fieldKey.contains(ConstantUtil.NODB) || ConstantUtil.SEQUENCE.equals(fieldKey) || "EOID".equals(fieldKey)
                            || "ESOID".equals(fieldKey) || "EPOID".equals(fieldKey)) {
                        continue;
                    }
                    MetaComponent componentByKey = null;
                    MetaGridCell metaGridCell = null;

                    AbstractMetaObject metaObjectColumnByKey = idLookup.getMetaObjectColumnByKey(fieldKey);
                    if (metaObjectColumnByKey instanceof MetaComponent) {
                        componentByKey = (MetaComponent)metaObjectColumnByKey;
                    }
                    if (Objects.isNull(componentByKey)) {
                        metaGridCell = idLookup.getGridCellByKey(fieldKey);
                    }
                    if (componentByKey != null || metaGridCell != null) {
                        continue;
                    }
                    String caption = column.getString("ColumnName");
                    String resource;
                    try {
                        resource = LoadFileTree.getPathByFormKey(metaForm.getKey());
                        XmlTreeWithPath parse = XmlTreeWithPath.parseFilePath(resource);
                        int haveRelyOn;
                        if (associatedTable != null) {
                            haveRelyOn = isHaveRelyOn(fieldKey, parse.xmlTree, associatedTable);
                        } else {
                            haveRelyOn = isHaveRelyOn(fieldKey, parse.xmlTree, diff.subAssociatedTable);
                        }
                        if (haveRelyOn != 0) {
                            continue;
                        }
                    } catch (Throwable e) {
                        LogSvr.getInstance().error("", e);
                    }

                    TagNode deleteGridCellNode1 = new TagNode(ConstantUtil.GRID_CELL, null);
                    deleteGridCellNode1.setAttribute(ConstantUtil.KEY, fieldKey);
                    if (StringUtils.isNotEmpty(caption)) {
                        deleteGridCellNode1.setAttribute(ConstantUtil.CAPTION, caption);
                    } else {
                        deleteGridCellNode1.setAttribute(ConstantUtil.CAPTION, fieldKey);
                    }

                    String type =  column.getString(ConstantUtil.CONTROLTYPE);
                    String dataElementKey = column.getString("DataElementKey");
                    deleteGridCellNode1.setAttribute(ConstantUtil.CELL_TYPE, type);
                    if(StringUtils.isNotEmpty(dataElementKey)){
                        deleteGridCellNode1 = addDomainPropertyToNode(deleteGridCellNode1, type, dataElementKey);
                    }
                    TagNode dataBindNode1 = new TagNode(MetaDataBinding.TAG_NAME, null);
                    dataBindNode1.setAttribute(ConstantUtil.COLUMN_KEY, columnKey);
                    deleteGridCellNode1.addNode(dataBindNode1);
                    gridRowNode.addNode(deleteGridCellNode1);// GridCell
                }
            }
        }

        gridRowNode.addNode(endGridRow);
        rowsNode.addNode(gridRowNode);
        rowsNode.addNode(endRows);
        tabNode.addNode(colsNode);
        tabNode.addNode(rowsNode);
        tabNode.addNode(endGrid);
        return tabNode;
    }

    private static void mergeDiff(MetaForm metaForm, Diff diff, Document document) throws Throwable {
        XmlTreeWithPath xmlTree = diff.getXmlTree();
//		String formKey = diff.formKey;
        MetaObjectType metaObjectType = diff.getMetaObjectType();
        MetaFormProfile metaFormProfile = MetaFactory.getGlobalInstance().getMetaFormList().get(metaForm.getKey());
        if (metaFormProfile == null) metaFormProfile = MetaFactory.getGlobalInstance().getExtFormList().get(metaForm.getKey());
        if (metaObjectType == MetaObjectType.dataSource) { //数据源
            if (StringUtils.isNotEmpty(diff.tableKey) || StringUtils.isNotEmpty(diff.subTableKey)) {
                String key = metaForm.getDataSource().getDataObject().getKey();
                String extendKey = metaForm.getExtend();
                Boolean mergeToSource = metaFormProfile.getMergeToSource();
                if (key.equals(extendKey) && !mergeToSource) {// //因为现在马甲无法修改数据源所以界面马甲不做处理
                    throw new RuntimeException("warning: 当前表单为马甲不支持创建新的表!");
                } else if (key.equals(extendKey) && mergeToSource) {
                    TagNode tagNode;
                    if (diff.tableKey != null && !"".equals(diff.tableKey)) {
                        tagNode = modifyDataSource(diff, diff.tableKey, diff.tableName);
                    } else {
                        tagNode = modifyDataSource(diff, diff.subTableKey, diff.subTableName);
                    }
                    genXmlDiff(xmlTree, tagNode, diff, true);
                } else {
                    TagNode tagNode;
                    if (diff.tableKey != null && !"".equals(diff.tableKey)) {
                        tagNode = modifyDataSource(diff, diff.tableKey, diff.tableName);
                    } else {
                        tagNode = modifyDataSource(diff, diff.subTableKey, diff.subTableName);
                    }
                    genXmlDiff(xmlTree, tagNode, diff, true);
                }
            } else {
                DataTable headTable = document.get("ED_DataObjectHead");
                DataTable collecTable = document.get("ED_TableCollection");
                DataTable fieldTable = document.get("ED_TableFields");
                DataTable ed_parameterCollection = document.get("ED_ParameterCollection");
                DataTable ed_indexCollection = document.get("ED_IndexCollection");
                dealHeadTable(xmlTree, headTable, collecTable, fieldTable, ed_parameterCollection, ed_indexCollection, diff);
                dealEmbedTable(xmlTree, document, diff);
                dealEventTable(xmlTree, document, diff);

            }
        } else if (metaObjectType == MetaObjectType.DataObject) {
            DataTable headTable = document.get(ConstantUtil.TBL_DATA_OBJECT_FORM_HEAD);
            DataTable collecTable = document.get(ConstantUtil.TBL_DATA_OBJECT_COLLECTION);
            DataTable fieldTable = document.get(ConstantUtil.TBL_DATA_OBJECT_FIELD);
            DataTable ed_parameterCollection = document.get("ED_ParameterCollection");
            DataTable ed_indexCollection = document.get("ED_IndexCollection");
            dealHeadTable(xmlTree, headTable, collecTable, fieldTable, ed_parameterCollection, ed_indexCollection, diff);
        } else if (metaObjectType == MetaObjectType.fieldCondition) { //字段属性查询
            DataTable headTable = document.get("ED_ConditionHead");
            DataTable cuscollTable = document.get(ConstantUtil.TBL_CONDITION_COLLECTION);
            DataTable tarCollTable = document.get(ConstantUtil.TBL_CONDITION_TARGET_COLLECTION);
            DataTable customConditionPara = document.get(ConstantUtil.TBL_CUSTOM_CONDITION_PARA);
            String xmlTreeKey = ControlType.toString(diff.getControlType()) + "@" + diff.getKey();
            TagNode fieldNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
            dealHeadCondition(xmlTree, headTable, cuscollTable, tarCollTable, fieldNode, diff, fieldNode, customConditionPara);
        } else if (metaObjectType == MetaObjectType.ItemFilter) {
            // 保存字典过滤
            String controlerType = null;
            String primaryKey = null;
            DataTable headTable = document.get(ConstantUtil.ED_DICT_FILTER);
            DataTable detailTable = document.get(ConstantUtil.ED_DICT_FILTER_VALUE);
            DataTable dictItem = document.get(ConstantUtil.ED_DICTITEM);
            MetaItemFilterProcess.dealDictField(xmlTree, controlerType, primaryKey, headTable, detailTable, dictItem, diff);
        } else if (metaObjectType == MetaObjectType.ColumnExpand) {
            TagNode tagNode = xmlTree.xmlTree.getTagNode("GridColumn@" + diff.getKey().substring(7));
            if (Objects.isNull(tagNode)) {
                tagNode = xmlTree.xmlTree.getTagNode("GridColumn@" + diff.properties.get(0).orgValue.substring(7));
            }
            DataTable headTable = document.get(ConstantUtil.TBL_COLUMN_EXPAND);
            dealColumnExpand(headTable, xmlTree, diff, tagNode);
        } else if (metaObjectType == MetaObjectType.DropdownButton) {
            DataTable detailTable = document.get(ConstantUtil.TBL_DROPDOWN_BUTTON);
            String xmlTreeKey = "DropdownButton@" + diff.getKey();
            TagNode fieldNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
            dealDropdownButton(xmlTree, fieldNode, detailTable, diff);
        } else if (metaObjectType == MetaObjectType.TraceCollection) {
            DataTable table = document.get(ConstantUtil.TBL_TRACE_COLLECTION);
            dealTraceCollection(xmlTree, diff, table, metaForm);
        } else if (metaObjectType == MetaObjectTypeDefine.QueryDef) {
            // todo 使用这种方式 将来可以支持直接通过metaObjectType进行对应的处理
            // 缺点：抽象 不够直观的了解到处理的是哪个流程
            metaObjectType.mergeDiff(metaForm, diff, document);
        } else if (metaObjectType == MetaObjectTypeDefine.IndicatorSetting) {
            TagNode tableRowNode = xmlTree.xmlTree.getTagNode("TableRow@" + diff.getKey());
            if(tableRowNode != null){
                DataTable propertyTable = document.get("ED_IndicatorSetting");
                if(propertyTable != null && propertyTable.first()){
                    String indicator = propertyTable.getString("Indicator");
                    String indicatorKey = propertyTable.getString("IndicatorKey");
                    tableRowNode.setAttribute("Indicator", indicator);
                    tableRowNode.setAttribute("IndicatorKey", indicatorKey);
                }
            }
            // 直接替换整个父节点
            genXmlDiff(xmlTree, tableRowNode, diff, true);
        } else if (metaObjectType == MetaObjectTypeDefine.ComBoBoxSourceSetting) {
            dealComboBoxSourceSetting(xmlTree, diff, document, metaForm);
        } else if (metaObjectType == MetaObjectTypeDefine.CarouselSourceSetting) {
            dealCarouselSourceSetting(xmlTree, diff, document, metaForm);
        } else if (metaObjectType == MetaObjectTypeDefine.RefreshFooterSetting) {
            dealRefreshFooterSetting(xmlTree, diff, document, metaForm);
        } else if (metaObjectType == MetaObjectTypeDefine.RefreshHeaderSetting) {
            dealRefreshHeaderSetting(xmlTree, diff, document, metaForm);
        } else if (metaObjectType == MetaObjectTypeDefine.PriceLabelItemSetting ) {
            dealPriceLabelItemSetting(xmlTree, diff, document, metaForm);
        } else if (metaObjectType == MetaObjectType.ExtOptCollection) {
            DataTable table = document.get(ConstantUtil.TBL_EXT_OPT_COLLECTION);
            dealExtOptCollection(xmlTree, diff, table, metaForm);
        } else if (metaObjectType == MetaObjectType.RowActionCollection) {
            DataTable table = document.get(ConstantUtil.ED_ROW_ACTIONS);
            dealRowActionCollection(xmlTree, diff, table, metaForm);
        } else if (metaObjectType == MetaObjectType.EditViewItemCollection) {
            dealEditViewItemCollectionSetting(xmlTree, diff, document, metaForm);
        } else if (metaObjectType == MetaObjectType.Fieldinformation) {
            handleFieldinformation(diff, xmlTree);
        } else if (metaObjectType == MetaObjectType.Separate) {//分隔尺寸节点修改
            DataTable Table = document.get(ConstantUtil.TBL_SEPARATE);
            dealSeparate(xmlTree, Table, diff);
        } else if (metaObjectType == MetaObjectType.form) {
            dealForm(diff, xmlTree);
        } else if (metaObjectType == MetaObjectType.comboBoxType) {
            DataTable comboBoxDetail = document.get("ED_ComboBoxDetail");
            dealComboBox(xmlTree, comboBoxDetail, diff);
        } else if (metaObjectType == MetaObjectType.GridRowTree) {
            DataTable gridRowTree = document.get(ConstantUtil.TBL_GRID_TREE_PROPERTIES);
            dealGridRowTree(xmlTree, gridRowTree, diff);
        } else if (metaObjectType == MetaObjectType.UICheckRule) {
            DataTable checkRuleCollection = document.get(ConstantUtil.TBL_UI_CHECK_RULE_COLLECTION);
            dealCheckRuleCollection(xmlTree, checkRuleCollection, diff);
        } else if (metaObjectType == MetaObjectType.DictViewColumn) {
            DataTable dictDetail = document.get(ConstantUtil.TBL_DICT_VIEW_COLUMN);
            dealDictColumn(xmlTree, dictDetail, diff);
        } else if (metaObjectType == MetaObjectType.Macro) {//宏公式
            DataTable MacroDetail = document.get(ConstantUtil.TBL_MACRO_FORMULA);
            dealMacro(xmlTree, MacroDetail, diff);
        } else if (metaObjectType == MetaObjectType.Formula) {//宏公式
            TagNode tagNode = xmlTree.xmlTree.getTagNode("Macro@" + diff.getKey());
            CDataNode cDataNode = (CDataNode) tagNode.getChildren().get(1);
            cDataNode.setText(diff.properties.get(0).newValue);
            genXmlDiff(xmlTree, tagNode, diff, true);
        }else if (metaObjectType == MetaObjectType.ChartDataSource) {//图表数据源
            DataTable ChartDataSource = document.get("ED_ChartDataSource");
            DataTable CategoryDtl = document.get("ED_SeriesDtl");
            dealChartDataSource(xmlTree, ChartDataSource, CategoryDtl, diff);
        }else if (metaObjectType == MetaObjectType.Block) {
            TagNode formNode = xmlTree.xmlTree.getTagNode("Form@"+diff.getMetaForm().getKey());
            TagNode bodyNode = formNode.findFirstTagNodeByTagName("Body");
            if (diff.getReserveOne().equals("AddNewBlock")) {
                TagNode newBlockNode = new TagNode("Block", null);
                newBlockNode.setAttribute("Key", diff.getKey());
                newBlockNode.setAttribute("IsRoot", diff.getReserveTwo());
                bodyNode.addNode(newBlockNode);
                String rootPanelType = diff.getReserveThree();
                String popViewRootPanelType = diff.getReserveFour();

                TagNode panelNode = null;
                // 非主block添加popView
                if ("false".equalsIgnoreCase(diff.getReserveTwo()) && "PopView".equalsIgnoreCase(rootPanelType)) {
                    TagNode popViewNode = new TagNode("PopView", null);
                    popViewNode.setAttribute("Key", diff.getKey() + "_PopView");
                    newBlockNode.addNode(popViewNode);

                    panelNode = new TagNode(popViewRootPanelType, null);
                    rootPanelType = popViewRootPanelType;
                    popViewNode.addNode(panelNode);
                } else {
                    panelNode = new TagNode(rootPanelType, null);
                    newBlockNode.addNode(panelNode);
                }

                panelNode.setAttribute("Key", diff.getKey()+"_RootPanel");
                panelNode.setAttribute("Caption", "主面板");
                panelNode.setAttribute("Width", "100%");
                panelNode.setAttribute("Height", "100%");
                if(rootPanelType.equals("HoverButton")){
                    panelNode.setAttribute("Key", diff.getKey()+"_hoverbutton");
                    panelNode.setAttribute("Caption", "按钮");
                    panelNode.setAttribute("Width", "40px");
                    panelNode.setAttribute("Height", "40px");
                    panelNode.setAttribute("BorderRadius", "20");
                }

                switch (rootPanelType) {
                    case "TabPanel":
                        TagNode subPanel = new TagNode("FlexFlowLayoutPanel", null);
                        subPanel.setAttribute("Key", panelNode.getAttributes().get("Key") + "_SubPanel");
                        subPanel.setAttribute("Caption", "页签");
                        subPanel.setAttribute("Width", "100%");
                        subPanel.setAttribute("Height", "100%");
                        panelNode.addNode(subPanel);
                        break;
                    case "GridLayoutPanel":
                        TagNode rowDefNodes = new TagNode("RowDefCollection", null);
                        rowDefNodes.setAttribute("RowGap", "5");
                        TagNode rowDef1 = new TagNode("RowDef", null);
                        rowDef1.setAttribute("Height", "30px");
                        rowDefNodes.getChildren().add(rowDef1);
                        TagNode rowDef2 = new TagNode("RowDef", null);
                        rowDef2.setAttribute("Height", "30px");
                        rowDefNodes.getChildren().add(rowDef2);
                        TagNode colDefNodes = new TagNode("ColumnDefCollection", null);
                        colDefNodes.setAttribute("ColumnGap", "5");
                        TagNode colDef1 = new TagNode("ColumnDef", null);
                        colDef1.setAttribute("Width", "10px");
                        colDefNodes.getChildren().add(colDef1);
                        TagNode colDef2 = new TagNode("ColumnDef", null);
                        colDef2.setAttribute("Width", "80px");
                        colDefNodes.getChildren().add(colDef2);
                        TagNode colDef3 = new TagNode("ColumnDef", null);
                        colDef3.setAttribute("Width", "100%");
                        colDefNodes.getChildren().add(colDef3);
                        TagNode colDef4 = new TagNode("ColumnDef", null);
                        colDef4.setAttribute("Width", "10px");
                        colDefNodes.getChildren().add(colDef4);
                        panelNode.addNode(rowDefNodes);
                        panelNode.addNode(colDefNodes);
                        break;
                    case "SlidingLayoutPanel":
                        TagNode mainPanelNode = new TagNode("FlexFlowLayoutPanel", null);
                        mainPanelNode.setAttribute("Key", diff.getKey() + "Main");
                        mainPanelNode.setAttribute("Caption", "主显示");
                        mainPanelNode.setAttribute("Padding", "5px");

                        TagNode firstPanelNode = new TagNode("FlexFlowLayoutPanel", null);
                        firstPanelNode.setAttribute("Key", diff.getKey() + "Fist");
                        firstPanelNode.setAttribute("Caption", "主侧滑");

                        TagNode secondPanelNode = new TagNode("FlexFlowLayoutPanel", null);
                        secondPanelNode.setAttribute("Key", diff.getKey() + "Second");
                        secondPanelNode.setAttribute("Caption", "次侧滑");

                        panelNode.addNode(mainPanelNode);
                        panelNode.addNode(firstPanelNode);
                        panelNode.addNode(secondPanelNode);
                        break;
                }
            } else {
                TagNode blockNode = null;
                for(TagNode tagNode : bodyNode.findNodesByTagName("Block")){
                    String key = tagNode.getAttributes().get("Key");
                    if(key != null && key.equals(diff.getKey())){
                        blockNode = tagNode;
                        break;
                    } else if (key == null && diff.getKey().equals("RootBlock")){
                        blockNode = tagNode;
                        break;
                    }
                }
                if(blockNode != null) {
                    for (DiffProperty property : diff.properties) {
                        String newValue = property.getNewValue();
                        String propertyName = property.property.name;
                        setSonNodeProperties(diff, blockNode, propertyName, newValue);
                    }
                }
            }
            genXmlDiff(xmlTree, bodyNode, diff, true);
        } else if (metaObjectType == MetaObjectType.field
                || metaObjectType == MetaObjectType.gridField
                || metaObjectType == MetaObjectType.GridCellType
                || metaObjectType == MetaObjectType.panel
                || metaObjectType == MetaObjectType.D_DictView
                || metaObjectType == MetaObjectType.subDetail
                || metaObjectType == MetaObjectType.GridHeadColumn
                || metaObjectType == MetaObjectType.grid
                || metaObjectType == MetaObjectType.listViewField
                || metaObjectType == MetaObjectType.listView
                || metaObjectType == MetaObjectType.GridRow
                || metaObjectType == MetaObjectType.toolbar
                || metaObjectType == MetaObjectType.EditViewColumn
                || metaObjectType == MetaObjectType.EditViewRootGridLayout
                || metaObjectType == MetaObjectType.EditViewRootLinearLayout
                || metaObjectType == MetaObjectType.EditViewChildGridLayout
                || metaObjectType == MetaObjectType.EditViewChildLinearLayout
                || metaObjectType == MetaObjectType.EditViewChildFlexFlowLayout
                || metaObjectType == MetaObjectType.EditViewChildColumnLayout
                || metaObjectType == MetaObjectType.EditViewChildSplitLayout
                || metaObjectType == MetaObjectType.EditViewChildTabLayout
                || metaObjectType == MetaObjectType.EditViewChildFlowLayout
                || metaObjectType == MetaObjectType.EditViewChildFlexGridLayout) {
            String xmlTreeKey = getXmlTreeKey(diff, null, null);
            if (xmlTreeKey.contains(",")) {// 单元格和列都要设置 针对表格
                String fPrimary = xmlTreeKey.substring(0, xmlTreeKey.indexOf(","));
                String sPrimary = xmlTreeKey.replace(fPrimary + ",", "");
                TagNode coluNode = diff.getTagNode(sPrimary);
                TagNode cellNode = diff.getTagNode(fPrimary);
                for (DiffProperty property : diff.properties) {
                    String orgValue = property.getOrgValue();
                    String newValue = property.getNewValue();
                    String propertyName = property.property.name;
                    Boolean mergeToSource = metaFormProfile.getMergeToSource();
                    String extend = metaFormProfile.getExtend();
                    if (!Property.caption.name.equalsIgnoreCase(propertyName) && !mergeToSource && !extend.isEmpty()) {//暂时只控制caption属性可以修改
                        throw new Throwable("组件的该属性不允许修改");
                    }
                    if (StringUtils.isBlank(orgValue) && StringUtils.isBlank(newValue)) { // 前端 目前没有认真比较
                        continue;
                    }
                    // 由于pc的buddykey与mobile冲突这里特殊处理
                    if (metaFormProfile.getPlatform() == 6 && ConstantUtil.BUDDY_KEY.equalsIgnoreCase(propertyName)) {
                        coluNode.setAttribute(ConstantUtil.BUDDY_KEY, newValue);
                        genXmlDiff(xmlTree, coluNode, diff, true);
                        return;
                    }


                    if (ConstantUtil.GRID_CELL.equalsIgnoreCase(cellNode.getTagName())) {
                        setSonNodeProperties(diff, cellNode, propertyName, newValue);
                        // setSonNodeProperties(diff, coluNode, ConstantUtil.BUDDY_KEY, newValue);
                    } else {

                        setSonNodeProperties(diff, cellNode, propertyName, "Inner_" + newValue);
                        setSonNodeProperties(diff, coluNode, ConstantUtil.BUDDY_KEY, "Inner_" + newValue);
                    }
                    setSonNodeProperties(diff, coluNode, propertyName, newValue);
                    if (metaObjectType == MetaObjectType.grid && ConstantUtil.KEY.equalsIgnoreCase(propertyName)) {
                        TagNode tagNode = setNodeKey(newValue, diff);
                        genXmlDiff(diff.getXmlTree(), tagNode, diff, true);
                        return;
                    }
                }
                TagNode node1 = cellNode != null ? cellNode : coluNode;
                genXmlDiff(xmlTree, node1, diff, true);
                if (coluNode != null && cellNode != null&&!(coluNode.getElement() == null ||cellNode.getElement() == null) ) {
                    genXmlDiff(xmlTree, coluNode, diff, false);
                }
            } else {
                TagNode buddyNode = null;
                TagNode node = diff.getTagNode(xmlTreeKey);

                if (Objects.isNull(node)) {
                    if (xmlTreeKey.contains(ConstantUtil.GRID_COLUMN)) {
                        xmlTreeKey = xmlTreeKey.replaceAll(ConstantUtil.GRID_COLUMN, ConstantUtil.GRID_CELL);
                        node = xmlTree.xmlTree.getTagNode(xmlTreeKey);
                        if (ConstantUtil.VISIBLE.equals(diff.properties.get(0).property.toString())) {
                            int index = node.getParent().getChildren().indexOf(node);
                            node = (TagNode) node.getParent().getParent().getParent().getOrCreateChildByTagName(ConstantUtil.GRID_COLUMN_COLLECTION).getChildren().get(index);
                        }
                    }
                    if (Objects.isNull(node)) {
                        throw new Throwable("warning: 当前表单的Xml中未找到当前节点,不能修改!!!");
                    }
                }
                TagNode tagNode = node.getParent();
                TagNode GridCellNode = null;
                if (xmlTreeKey.contains(ConstantUtil.GRID_COLUMN)) {
                    xmlTreeKey = xmlTreeKey.replaceAll(ConstantUtil.GRID_COLUMN, ConstantUtil.GRID_CELL);
                    GridCellNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
                }
                for (DiffProperty property : diff.properties) {
                    String orgValue = property.getOrgValue();
                    String newValue = property.getNewValue();
                    if (StringUtils.isBlank(orgValue) && StringUtils.isBlank(newValue)) { // 前端 目前没有认真比较
                        continue;
                    }
                    if (property.property == Property.ownerPanelKey) {
                        continue;
                    }
                    String propertyName = property.property.name;
                    if (Property.key.name.equalsIgnoreCase(propertyName)) {
                        setSonNodeProperties(diff, node, propertyName, newValue);
                        setSonNodeProperties(diff, GridCellNode, propertyName, newValue);
                    } else if (Property.columnKey.name.equalsIgnoreCase(propertyName)) {// tableKey也要设置
                        newValue = StringUtils.substringBefore(newValue, " ");
                        Boolean mergeToSource = metaFormProfile.getMergeToSource();
                        //noinspection StatementWithEmptyBody
                        if (diff.getVestXmlTree() != null && diff.getVestXmlTree().xmlTree.getTagNode(xmlTreeKey) != null && xmlTree.xmlTree.getTagNode(xmlTreeKey) != null && !mergeToSource) {

                        } else if (metaObjectType == MetaObjectType.gridField || metaObjectType == MetaObjectType.field || metaObjectType == MetaObjectType.EditViewColumn) {
                            setColumnKey(metaForm, diff, newValue, propertyName, xmlTree, node, orgValue);
                        } else if (metaObjectType == MetaObjectType.listViewField) {// ListView实现
                            setListViewNodeProperty(diff, node, propertyName, newValue);
                        }
                    } else if ("EditViewRowTopMargin".equalsIgnoreCase(propertyName)) {
                        setSonNodeProperties(diff, node, "TopMargin", newValue);
                    } else if ("EditViewRowBackColor".equalsIgnoreCase(propertyName)) {
                        setSonNodeProperties(diff, node, "BackColor", newValue);
                    } else if ("EditViewRowHighlightColor".equalsIgnoreCase(propertyName)) {
                        setSonNodeProperties(diff, node, "HighlightColor", newValue);
                    } else if (Property.LayoutType.name.equalsIgnoreCase(propertyName)) {
                        // 根据布局类型修改
                        TagNode editViewNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
                        if (editViewNode != null) {
                            String compViewKey = "ComponentView@" + diff.getKey();
                            TagNode compViewNode = xmlTree.xmlTree.getTagNode(compViewKey);
                            if (compViewNode != null) {
                                TagNode rootLayout = compViewNode.getChildByKey(diff.getKey());
                                if (rootLayout != null) {
                                    String tagName = rootLayout.getTagName();
                                    if (newValue.equalsIgnoreCase("GridLayout")) {
                                        if (tagName.equalsIgnoreCase("LinearLayout")) {
                                            TagNode gridLayoutNode = new TagNode("GridLayout", null);
                                            gridLayoutNode.setAttribute("Key", diff.getKey());
                                            TagNode rowDefNodes = new TagNode("RowDefCollection", null);
                                            rowDefNodes.setAttribute("RowGap", "5");
                                            TagNode rowDef1 = new TagNode("RowDef", null);
                                            rowDef1.setAttribute("Height", "30px");
                                            TagNode rowDef2 = new TagNode("RowDef", null);
                                            rowDef2.setAttribute("Height", "30px");
                                            rowDefNodes.getChildren().add(rowDef1);
                                            TagNode colDefNodes = new TagNode("ColumnDefCollection", null);
                                            colDefNodes.setAttribute("ColumnGap", "5");
                                            TagNode colDef1 = new TagNode("ColumnDef", null);
                                            colDef1.setAttribute("Width", "100px");
                                            TagNode colDef2 = new TagNode("ColumnDef", null);
                                            colDef2.setAttribute("Width", "100%");
                                            colDefNodes.getChildren().add(colDef1);
                                            colDefNodes.getChildren().add(colDef2);
                                            List<AbstractNode> itemNodes = rootLayout.getChildrenByTagName("LinearItem");
                                            for (int i = 0; i < itemNodes.size(); i ++) {
                                                int x = i % 2;
                                                int y = i / 2;
                                                if (x == 0) {
                                                    TagNode rowDef3 = new TagNode("RowDef", null);
                                                    rowDef3.setAttribute("Height", "30px");
                                                    rowDefNodes.getChildren().add(rowDef3);
                                                }
                                                TagNode itemNode = (TagNode) itemNodes.get(i);
                                                String itemKey = itemNode.getAttributes().get("Key");
                                                TagNode spanNode = new TagNode("LayoutSpan", null);
                                                spanNode.setAttribute("Key", itemKey);
                                                spanNode.setAttribute("X", "" + x);
                                                spanNode.setAttribute("Y", "" + y);
                                                gridLayoutNode.getChildren().add(spanNode);
                                            }
                                            rowDefNodes.getChildren().add(rowDef2);
                                            gridLayoutNode.getChildren().add(rowDefNodes);
                                            gridLayoutNode.getChildren().add(colDefNodes);
                                            List<AbstractNode> layouts = compViewNode.getChildren();
                                            int index = layouts.indexOf(rootLayout);
                                            layouts.set(index, gridLayoutNode);
                                            genXmlDiff(xmlTree, compViewNode, diff, false);
                                        }

                                    } else if (newValue.equalsIgnoreCase("LinearLayout")) {
                                        if (tagName.equalsIgnoreCase("GridLayout")) {
                                            TagNode linearLayoutNode = new TagNode("LinearLayout", null);
                                            linearLayoutNode.setAttribute("Key", diff.getKey());
                                            linearLayoutNode.setAttribute("Orientation", "Vertical");

                                            List<AbstractNode> spanNodes = rootLayout.getChildrenByTagName("LayoutSpan");
                                            for (int i = 0; i < spanNodes.size(); i ++) {
                                                TagNode layoutSpanNode = (TagNode) spanNodes.get(i);
                                                TagNode linearItemNode = new TagNode("LinearItem", null);

                                                String key = layoutSpanNode.getAttributes().get("Key");
                                                linearItemNode.setAttribute("Height", "30px");
                                                linearItemNode.setAttribute("Key", key);
                                                linearLayoutNode.addNode(linearItemNode);
                                            }

                                            List<AbstractNode> layouts = compViewNode.getChildren();
                                            int index = layouts.indexOf(rootLayout);
                                            layouts.set(index, linearLayoutNode);

                                            genXmlDiff(xmlTree, compViewNode, diff, false);
                                        }
                                    }
                                }

                            }
                        }

                    } else if (Property.XSpan.name.equalsIgnoreCase(propertyName)) {

                        if (metaObjectType == MetaObjectType.EditViewColumn
                                || metaObjectType == MetaObjectType.EditViewChildGridLayout
                                || metaObjectType == MetaObjectType.EditViewChildLinearLayout
                                || metaObjectType == MetaObjectType.EditViewChildFlexFlowLayout
                                || metaObjectType == MetaObjectType.EditViewChildColumnLayout
                                || metaObjectType == MetaObjectType.EditViewChildSplitLayout
                                || metaObjectType == MetaObjectType.EditViewChildTabLayout
                                || metaObjectType == MetaObjectType.EditViewChildFlowLayout
                                || metaObjectType == MetaObjectType.EditViewChildFlexGridLayout) {
                            setEditViewColumnGridLayoutSpanProperty(xmlTree, diff, propertyName, newValue);
                        } else {
                            setSonNodeProperties(diff, node, propertyName, newValue);
                        }

                    } else if (Property.YSpan.name.equalsIgnoreCase(propertyName)) {

                        if (metaObjectType == MetaObjectType.EditViewColumn
                                || metaObjectType == MetaObjectType.EditViewChildGridLayout
                                || metaObjectType == MetaObjectType.EditViewChildLinearLayout
                                || metaObjectType == MetaObjectType.EditViewChildFlexFlowLayout
                                || metaObjectType == MetaObjectType.EditViewChildColumnLayout
                                || metaObjectType == MetaObjectType.EditViewChildSplitLayout
                                || metaObjectType == MetaObjectType.EditViewChildTabLayout
                                || metaObjectType == MetaObjectType.EditViewChildFlowLayout
                                || metaObjectType == MetaObjectType.EditViewChildFlexGridLayout) {
                            setEditViewColumnGridLayoutSpanProperty(xmlTree, diff, propertyName, newValue);
                        } else {
                            setSonNodeProperties(diff, node, propertyName, newValue);
                        }

                    } else if (Property.x.name.equalsIgnoreCase(propertyName)) {

                        if (metaObjectType == MetaObjectType.EditViewColumn
                                || metaObjectType == MetaObjectType.EditViewChildGridLayout
                                || metaObjectType == MetaObjectType.EditViewChildLinearLayout
                                || metaObjectType == MetaObjectType.EditViewChildFlexFlowLayout
                                || metaObjectType == MetaObjectType.EditViewChildColumnLayout
                                || metaObjectType == MetaObjectType.EditViewChildSplitLayout
                                || metaObjectType == MetaObjectType.EditViewChildTabLayout
                                || metaObjectType == MetaObjectType.EditViewChildFlowLayout
                                || metaObjectType == MetaObjectType.EditViewChildFlexGridLayout) {
                            setEditViewColumnGridLayoutSpanProperty(xmlTree, diff, propertyName, newValue);

                        } else {
                            setSonNodeProperties(diff, node, Property.x.name, newValue);
                        }

                        if (!ConstantUtil.LABEL.equals(node.getTagName())) {
                            String buddyKey = node.getAttributes().get(ConstantUtil.BUDDY_KEY);
                            if (StringUtils.isBlank(buddyKey)) {
                                XmlTreeWithPath vestXmlTree = diff.getVestXmlTree();
                                if (Objects.nonNull(vestXmlTree)) {
                                    TagNode tagNode1 = vestXmlTree.xmlTree.getTagNode(xmlTreeKey);
                                    if (Objects.nonNull(tagNode1)) {
                                        buddyKey = tagNode1.getAttributes().get(ConstantUtil.BUDDY_KEY);
                                        String buddyPrimary = "Label@" + buddyKey;
                                        buddyNode = xmlTree.xmlTree.getTagNode(buddyPrimary);
                                    }
                                }
                            } else {
                                String buddyPrimary = "Label@" + buddyKey;
                                buddyNode = xmlTree.xmlTree.getTagNode(buddyPrimary);
                            }
                            if (buddyNode != null) {
                                setSonNodeProperties(diff, buddyNode, Property.x.name, String.valueOf(Integer.parseInt(newValue) - 1));
                            }
                        }

                    } else if (Property.y.name.equalsIgnoreCase(propertyName)) {

                        if (metaObjectType == MetaObjectType.EditViewColumn
                                || metaObjectType == MetaObjectType.EditViewChildGridLayout
                                || metaObjectType == MetaObjectType.EditViewChildLinearLayout
                                || metaObjectType == MetaObjectType.EditViewChildFlexFlowLayout
                                || metaObjectType == MetaObjectType.EditViewChildColumnLayout
                                || metaObjectType == MetaObjectType.EditViewChildSplitLayout
                                || metaObjectType == MetaObjectType.EditViewChildTabLayout
                                || metaObjectType == MetaObjectType.EditViewChildFlowLayout
                                || metaObjectType == MetaObjectType.EditViewChildFlexGridLayout) {
                            setEditViewColumnGridLayoutSpanProperty(xmlTree, diff, propertyName, newValue);

                        } else {
                            setSonNodeProperties(diff, node, Property.y.name, newValue);
                        }

                        if (!ConstantUtil.LABEL.equals(node.getTagName())) {
                            String buddyKey = node.getAttributes().get(ConstantUtil.BUDDY_KEY);
                            if (StringUtils.isBlank(buddyKey)) {
                                XmlTreeWithPath vestXmlTree = diff.getVestXmlTree();
                                if (Objects.nonNull(vestXmlTree)) {
                                    TagNode tagNode1 = vestXmlTree.xmlTree.getTagNode(xmlTreeKey);
                                    if (Objects.nonNull(tagNode1)) {
                                        buddyKey = tagNode1.getAttributes().get(ConstantUtil.BUDDY_KEY);
                                        String buddyPrimary = "Label@" + buddyKey;
                                        buddyNode = xmlTree.xmlTree.getTagNode(buddyPrimary);
                                    }
                                }
                            } else {
                                String buddyPrimary = "Label@" + buddyKey;
                                buddyNode = xmlTree.xmlTree.getTagNode(buddyPrimary);
                            }
                            if (buddyNode != null) {
                                setSonNodeProperties(diff, buddyNode, Property.y.name, String.valueOf(Integer.valueOf(newValue)));
                            }
                        }
                    } else if (Property.CellType.name.equalsIgnoreCase(propertyName)) {
                        Map<String, String> map = node.getAttributes();
                        map.entrySet().removeIf(entry -> !ConstantUtil.KEY.equals(entry.getKey()));
                        setSonNodeProperties(diff, node, Property.CellType.name, newValue);
                    } else if (Property.CellGroupType.name.equalsIgnoreCase(propertyName)) {
                        switch (newValue) {
                            case "None":
                            case "RowTreeGroup":
                                for (AbstractNode tagNodeChild : tagNode.getParent().getChildren()) {
                                    if (tagNodeChild instanceof TagNode) {
                                        if (node.getAttributes().get(ConstantUtil.KEY).equalsIgnoreCase(((TagNode) tagNodeChild).getAttributes().get(ConstantUtil.GROUP_KEY))) {
                                            throw new Throwable("此字段行类型被其他行依赖，不支持修改分组类型");
                                        }
                                    }
                                }
                                setSonNodeProperties(diff, node, Property.CellGroupType.name, newValue);
                                break;
                            case "RowGroup":
                                setSonNodeProperties(diff, node, Property.CellGroupType.name, newValue);
                                break;

                        }
                    } else if (Property.RowKey.name.equalsIgnoreCase(propertyName)
                            || Property.RowVisible.name.equalsIgnoreCase(propertyName)
                            || Property.RowGroupKey.name.equalsIgnoreCase(propertyName)
                            || Property.RowDefaultLayer.name.equalsIgnoreCase(propertyName)
                            || Property.RowDetailKey.name.equalsIgnoreCase(propertyName)
                            || Property.RowBackColor.name.equalsIgnoreCase(propertyName)
                            || Property.RowRefKey.name.equalsIgnoreCase(propertyName)) {
                        setSonNodeProperties(diff, node, propertyName.substring(3), newValue);
                    } else if (Property.LinkType.name.equalsIgnoreCase(propertyName)) {
                        setSonNodeProperties(diff, tagNode, propertyName, newValue);
                    } else if (Property.RowHeight.name.equalsIgnoreCase(propertyName)) {
                        setSonNodeProperties(diff, node, propertyName, newValue);
                    } else if (Property.ExpandType.name.equalsIgnoreCase(propertyName)) {
                        TagNode rowExpand = node.getOrCreateChildByTagName(MetaRowExpand.TAG_NAME);
                        rowExpand.setAttribute(propertyName, newValue);
                        if (rowExpand.getAttributes().size() == 1 && "Dict".equalsIgnoreCase(newValue)) {
                            node.deleteChildByTagName(MetaRowExpand.TAG_NAME);
                        }
                    } else if (Property.CellKey.name.equalsIgnoreCase(propertyName)) {
                        TagNode rowExpand = tagNode.getOrCreateChildByTagName(MetaRowExpand.TAG_NAME);
                        rowExpand.setAttribute(propertyName, newValue);
                        if (rowExpand.getAttributes().size() == 0) {
                            tagNode.deleteChildByTagName(MetaRowExpand.TAG_NAME);
                        }
                    } else if (Property.RowExpand.name.equalsIgnoreCase(propertyName)) {
                        setSonNodeProperties(diff, tagNode, propertyName, newValue);
                    } else if (Property.FormulaItems.name.equalsIgnoreCase(propertyName)) {
                        setSonNodeProperties(diff, node, propertyName, newValue);
                    } else if (Property.RowKeywords.name.equalsIgnoreCase(propertyName)) {
                        String tagName = node.getTagName();
                        String tableKey = null;
                        if (ConstantUtil.GRID_ROW.equalsIgnoreCase(tagName)) {
                            tableKey = node.getAttributes().get(ConstantUtil.TABLE_KEY);
                        } else {
                            TagNode dataBinding = tagNode.findFirstTagNodeByTagName(MetaDataBinding.TAG_NAME);
                            if (dataBinding != null) {
                                tableKey = dataBinding.getAttributes().get(ConstantUtil.TABLE_KEY);
                            }
                        }
                        if (StringUtils.isNotEmpty(tableKey)) {
                            MetaTable metaTable = metaForm.getMetaTable(tableKey);
                            String[] values = newValue.split(";");
                            String str;
                            String[] arr;
                            int dataType;
//							Object value = null;
                            for (String value : values) {
                                str = value.trim();
                                if (str != null && !str.isEmpty()) {
                                    arr = str.split("=");
                                    if (arr.length != 2) {
                                        throw new Exception("关键字设置格式不正确，请以关联表中的字段+“=”+对应字段数据类型的值作为关键字，类似于A=10000");
                                    }
                                    MetaColumn metaColumn = metaTable.get(arr[0]);
                                    if (Objects.isNull(metaColumn)) {
                                        throw new Exception("关联表中没有此字段，请重新设置");
                                    }
                                    dataType = metaColumn.getDataType();
                                    try {
                                        TypeConvertor.toDataType(dataType, arr[1]);
                                    } catch (NumberFormatException exception) {
                                        throw new Exception("关键字设置值与字段数据类型不匹配，请按数据源中对应字段数据类型填写");
                                    }
                                    node.setAttribute("Keywords", newValue);
                                }
                            }
                        } else {
                            throw new Exception("当前选中组件未绑定关联表，无法设置关键字");
                        }
                    } else if (Property.RowType.name.equalsIgnoreCase(propertyName)) {
                        String parentKey = node.getAttributes().get(ConstantUtil.KEY);
                        if ("Group".equalsIgnoreCase(newValue)) {
                            boolean flag = false;
                            List<MetaGridCell> metaGridCells = metaForm.getAllGridCells();
                            for (MetaGridCell metaGridCell : metaGridCells) {
                                if (!"删除".equals(metaGridCell.getCaption()) && !"选择".equals(metaGridCell.getCaption())) {
                                    TagNode cellNode = xmlTree.xmlTree.getTagNode("GridCell@" + metaGridCell.getKey());
                                    if (Objects.isNull(cellNode)) {
                                        continue;
                                    }
                                    if (!cellNode.getParent().getAttributes().get(ConstantUtil.KEY).equalsIgnoreCase(parentKey)) {
                                        TagNode tableNode = xmlTree.xmlTree.getTagNode("Table@" + cellNode.getParent().getAttributes().get(ConstantUtil.TABLE_KEY));
                                        if (tableNode != null) {
                                            for (AbstractNode child : tableNode.getChildrenByTagName(ConstantUtil.COLUMN)) {
                                                if (child instanceof TagNode) {
                                                    if (((TagNode) child).getAttributes().get(ConstantUtil.KEY).equalsIgnoreCase(metaGridCell.getDataBinding().getColumnKey())) {
                                                        ((TagNode) child).setAttribute(ConstantUtil.IS_PRIMARY, "true");
                                                        flag = true;
                                                        genXmlDiff(xmlTree, tableNode, diff, false);
                                                    }
                                                }
                                            }
                                            node.setAttribute(ConstantUtil.GROUP_KEY, metaGridCell.getKey());
                                            cellNode.setAttribute(ConstantUtil.CELL_GROUP_TYPE, "RowGroup");
                                            node.setAttribute(propertyName, newValue);
                                            if (flag) {
                                                break;
                                            }
                                        }
                                    }
                                }
                            }
                            if (!flag) {
                                throw new Throwable("表格未添加明细行，或所属分组标识数据列未添加业务关键字");
                            }
                            tagNode = xmlTree.xmlTree.getTagNode("Grid@" + diff.parentKey);
                            break;
                        } else if (!StringUtils.isNotEmpty(tagNode.getAttributes().get(ConstantUtil.ROW_TYPE))) {
                            List<AbstractNode> children = tagNode.getParent().getChildren();
                            String groupKey = "";
                            for (AbstractNode child : children) {
                                if (child instanceof TagNode && "Group".equalsIgnoreCase(((TagNode) child).getAttributes().get(ConstantUtil.ROW_TYPE))) {
                                    groupKey = ((TagNode) child).getAttributes().get(ConstantUtil.GROUP_KEY);
                                    break;
                                }
                            }
                            if (StringUtils.isNotEmpty(groupKey)) {
                                for (AbstractNode tagNodeChild : tagNode.getChildren()) {
                                    if (tagNodeChild instanceof TagNode) {
                                        if (groupKey.equalsIgnoreCase(((TagNode) tagNodeChild).getAttributes().get(ConstantUtil.KEY))) {
                                            throw new Throwable("此明细行被其他行依赖，不支持修改行类型");
                                        }
                                    }
                                }
                            }
                            node.setAttribute(propertyName, newValue);
                        } else {
                            node.setAttribute(propertyName, newValue);
                        }
                    } else if (Property.RowTableKey.name.equalsIgnoreCase(propertyName)) {
                        if ("无数据表".equalsIgnoreCase(newValue)) {
                            node.getAttributes().remove(ConstantUtil.TABLE_KEY);
                        } else {
                            node.setAttribute(propertyName.substring(3), newValue);
                        }
                        List<AbstractNode> nodeList = node.getChildren();
                        for (AbstractNode abstractNode : nodeList) {
                            if (abstractNode instanceof TagNode && ConstantUtil.GRID_CELL.equalsIgnoreCase(((TagNode) abstractNode).getTagName())) {
                                if (((TagNode) abstractNode).getOrCreateChildByTagName(MetaDataBinding.TAG_NAME) != null) {
                                    ((TagNode) abstractNode).getOrCreateChildByTagName(MetaDataBinding.TAG_NAME).getAttributes().remove(ConstantUtil.COLUMN_KEY);
                                }
                            }
                        }
                        List<TagNode> nodesByTagName = tagNode.findNodesByTagName(ConstantUtil.GRID_ROW);
                        for (TagNode node1 : nodesByTagName) {
                            node1.deleteAttribute("Keywords");
                        }
                    } else if (Property.caption.name.equalsIgnoreCase(propertyName)) {
                        if (StringUtils.isNotEmpty(node.getAttributes().get(ConstantUtil.BUDDY_KEY))) {
                            if (!ConstantUtil.LABEL.equals(node.getTagName())) {
                                String buddyKey = ConstantUtil.LABEL + "@" + node.getAttributes().get(ConstantUtil.BUDDY_KEY);
                                buddyNode = xmlTree.xmlTree.getTagNode(buddyKey);
                                if (buddyNode != null) {
                                    buddyNode.setAttribute(propertyName, newValue);
                                }
                            }
                        }
                        if (GridCellNode != null) {
                            GridCellNode.setAttribute(propertyName, newValue);
                        }
                        node.setAttribute(propertyName, newValue);
                        if (diff.getMetaObjectType() == MetaObjectType.field) {
                            node.setAttribute(Property.FormulaCaption.name, "");
                            node.setAttribute("CaptionDependency", "");
                        }
                    } else if (Property.IsGroupHead.name.equalsIgnoreCase(propertyName)) {
                        int count = 0;
                        String groupKey = node.getAttributes().get("GroupKey");
                        String isGroupHead = node.getAttributes().get("IsGroupHead");
                        IDLookup idLookup = IDLookup.getIDLookup(metaForm);
                        List<MetaComponent> allComponent = idLookup.getAllComponent();
                        if ("true".equalsIgnoreCase(isGroupHead)) {
                            for (MetaComponent component : allComponent) {
                                if (component instanceof MetaRadioButton) {
                                    count++;
                                    if (((MetaRadioButton) component).getGroupKey().equalsIgnoreCase(groupKey) && !((MetaRadioButton) component).isGroupHead()) {
                                        throw new Throwable("请先将其余所属组为" + groupKey + "的单选按钮的所属组修改为其他组或将其他单选按钮设置为组头控件");
                                    }
                                }
                            }
                        }
                        if (count <= 1 && "false".equalsIgnoreCase(newValue)) {
                            throw new Throwable("该组件为唯一单选按钮，请添加其他单选按钮并设置为组头控件后在修改此组件组头属性");
                        }
                        node.setAttribute(propertyName, newValue);
                    } else if (Property.GroupKey.name.equalsIgnoreCase(propertyName)) {
                        if (!StringUtils.isNotEmpty(newValue)) {
                            throw new Throwable("所属组无法设置为空");
                        }
                        String groupKey = node.getAttributes().get("GroupKey");
                        String isGroupHead = node.getAttributes().get("IsGroupHead");
                        IDLookup idLookup = IDLookup.getIDLookup(metaForm);
                        List<MetaComponent> allComponent = idLookup.getAllComponent();
                        if ("true".equalsIgnoreCase(isGroupHead)) {
                            for (MetaComponent component : allComponent) {
                                if (component instanceof MetaRadioButton) {
                                    if (((MetaRadioButton) component).getGroupKey().equalsIgnoreCase(groupKey) && !((MetaRadioButton) component).isGroupHead()) {
                                        throw new Throwable("请先将其余所属组为" + groupKey + "的单选按钮的所属组修改为其他组或将其他单选按钮设置为组头控件");
                                    }
                                }
                            }
                        }
                        node.setAttribute(propertyName, newValue);
                    } else if (Property.StateMask.name.equalsIgnoreCase(propertyName)) {
                        // StateMask使用|进行分割解析 此处进行替换
                        newValue = newValue.replaceAll(",", "\\|");
                        setSonNodeProperties(diff, node, propertyName, newValue);
                    }  else if (Property.StateMaskFormula.name.equalsIgnoreCase(propertyName)) {
                        setSonNodeProperties(diff, node, propertyName, newValue);
                    } else if (metaObjectType == MetaObjectType.listViewField) {
                        setListViewNodeProperty(diff, node, propertyName, newValue);
                    } else if (Property.IgnoreRights.name.equalsIgnoreCase(propertyName)) {
                        // 当前修改值是true 判断column是否有needRights = true
                        TagNode dataBindingNode = (TagNode) xmlTree.xmlTree.getTagNode(ControlType.toString(diff.getControlType()) + "@" + diff.getKey())
                                .getChildrenByTagName(MetaDataBinding.TAG_NAME).get(0);
                        TagNode columnNode = xmlTree.xmlTree.getTagNode(ConstantUtil.COLUMN + "@" + dataBindingNode.getAttributes().get(ConstantUtil.COLUMN_KEY));
                        String needRights = columnNode.getAttributes().get(ConstantUtil.NEED_RIGHTS);
                        if ("true".equals(newValue) && "True".equalsIgnoreCase(needRights)) {
                            throw new Throwable("该数据源权限类型为检查权限，不允许设置为忽略权限！已撤销！");
                        }
                        setSonNodeProperties(diff, node, propertyName, newValue);
                    } else if (Property.AllowMultiSelection.name.equals(propertyName)) {
                        TagNode dataBindingNode = null;
                        if (metaObjectType == MetaObjectType.field) {
                            TagNode thisNode = xmlTree.xmlTree.getTagNode(ControlType.toString(diff.getControlType()) + "@" + diff.getKey());
                            if (thisNode.hasChildrenByTagName(MetaDataBinding.TAG_NAME)) {
                                dataBindingNode = (TagNode) thisNode.getChildrenByTagName(MetaDataBinding.TAG_NAME).get(0);
                            }
                        } else if (metaObjectType == MetaObjectType.gridField) {
                            TagNode thisNode = xmlTree.xmlTree.getTagNode("GridCell@" + diff.getKey());
                            if (thisNode.hasChildrenByTagName(MetaDataBinding.TAG_NAME)) {
                                dataBindingNode = (TagNode) thisNode.getChildrenByTagName(MetaDataBinding.TAG_NAME).get(0);
                            }
                        }
                        if (dataBindingNode != null && dataBindingNode.hasAttribute(ConstantUtil.COLUMN_KEY)) {
                            TagNode columnNode = xmlTree.xmlTree.getTagNode(ConstantUtil.COLUMN + "@" + dataBindingNode.getAttributes().get(ConstantUtil.COLUMN_KEY));
                            String dataType = columnNode.getAttributes().get(ConstantUtil.DATA_TYPE);
                            if (Boolean.parseBoolean(newValue)) { // 使用多选时 字典的数据源Column类型修改为Varchar
                                if (DataType.STR_LONG.equals(dataType)) {
                                    columnNode.setAttribute(ConstantUtil.DATA_TYPE, DataType.STR_STRING);
                                }
                            } else {
                                columnNode.setAttribute(ConstantUtil.DATA_TYPE, DataType.STR_LONG);
                            }
                            genXmlDiff(xmlTree, columnNode, diff, false);
                        }
                        setSonNodeProperties(diff, node, propertyName, newValue);
                    } else if (Property.SourceType.name.equals(propertyName)) { // 更改下拉框数据来源时修改
                        if (ControlType.COMBOBOX == diff.getControlType() || diff.getControlType() == ControlType.CHECKLISTBOX) {
                            if (ComboBoxSourceType.STR_ITEMS.equals(orgValue)) { //切换出固定值时删除item
                                node.deleteChildByTagName("Item");
                            }
                            if (ComboBoxSourceType.STR_FORMULA.equals(orgValue)) { //切换出公式时删除formulaItems
                                node.deleteChildByTagName(ConstantUtil.FORMULA_ITEMS);
                            }
                            if (ComboBoxSourceType.STR_PARAGROUP.equals(orgValue)) {
                                node.deleteAttribute(ConstantUtil.GROUP_KEY);
                            }
                            if (ComboBoxSourceType.STR_QUERY.equals(orgValue)) {
                                node.deleteAttribute("ItemsDependency");
                                node.deleteChildByTagName(MetaQueryDef.TAG_NAME);
                            }
                            if (ComboBoxSourceType.STR_FORMULA.equals(newValue) && !node.hasChildrenByTagName(ConstantUtil.FORMULA_ITEMS)) {
                                TagNode formulaItems = new TagNode(ConstantUtil.FORMULA_ITEMS, null);
                                node.addNode(formulaItems);
                            }
                        }
                        setSonNodeProperties(diff, node, propertyName, newValue);
                    }else if(Property.TextShowType.name.equals(propertyName)){
                        node.setAttribute(Property.TextShowType.name,newValue);
                    } else if(Property.Type.name.equals(propertyName)){
                        node.setAttribute(Property.Type.name,newValue);
                    } else if(Property.UploadType.name.equals(propertyName)){
                        node.setAttribute(Property.UploadType.name,newValue);
                    } else if (Property.DateFormat.name.equals(propertyName)) {
                        // #75059 表格中组件类型为日期，组件属性中的日期显示格式修改点击保存之后，源代码无误，在点击界面修改输入框大小，显示和未修改之前一样
                        // MetaDatePickerPropertiesAction 中读取的属性值为 MetaConstants.DATEPICKER_FORMAT = "Format"; 导致问题
                        setSonNodeProperties(diff, node, Property.Format.name, newValue);
                    } else if(Property.CaseType.name.equals(propertyName)){
                        node.setAttribute(MetaConstants.TEXT_CASE,newValue);
                    }
                    else if (Property.PageLoadType.name.equals(propertyName)) {
                        if (ControlType.EDITVIEW != diff.getControlType()) {
                            // 如果表格绑定的数据源表来源数据类型为定制公式，不可修改成数据分页
                            String finalNewValue = newValue;
                            node.findFirstTagNodeByTagName(ConstantUtil.GRID_ROW_COLLECTION).findNodesByTagName(ConstantUtil.GRID_ROW).stream().
                                    filter(row -> row.hasAttribute(ConstantUtil.TABLE_KEY)).map(row -> row.getAttributes().get(ConstantUtil.TABLE_KEY)).findFirst().ifPresent(tableKey -> {
                                MetaDataObject dataObject = metaForm.getDataSource().getDataObject();
                                if (Objects.equals(dataObject.getTable(tableKey).getSourceType(), TableSourceType.CUSTOM)
                                        && StringUtils.equals(finalNewValue, PageLoadType.STR_DB)) {
                                    throw new RuntimeException("表格绑定的数据源表来源数据类型为定制公式，不可修改成数据分页");
                                }
                            });
                        }

                        setSonNodeProperties(diff, node, propertyName, newValue);
                    } else if (Property.IsMergedHead.name.equals(propertyName)) {
                        node.setAttribute("IsMerged", newValue);
                        node.setAttribute(Property.IsMergedHead.name, newValue);
                        if (StringUtils.equals(newValue, "false")) {
                            if (node.hasAttribute(Property.MergedRowSpan.name))
                                node.deleteAttribute(Property.MergedRowSpan.name);
                            if (node.hasAttribute(Property.MergedColumnSpan.name))
                                node.deleteAttribute(Property.MergedColumnSpan.name);
                        }
                    } else if (Property.MergedRowSpan.name.equals(propertyName)) {
                        int mergedRowSpan = Integer.parseInt(newValue);
                        node.getAttributes().get(Property.MergedColumnSpan.name);
                        int mergedColumnSpan = node.getAttributes().get(Property.MergedColumnSpan.name) != null? Integer.parseInt(node.getAttributes().get(Property.MergedColumnSpan.name)):1;
                        dealMergedSpan(xmlTree, mergedRowSpan, mergedColumnSpan, diff);
                    } else if (Property.MergedColumnSpan.name.equals(propertyName)) {
                        int mergedColumnSpan = Integer.parseInt(newValue);
                        int mergedRowSpan = node.getAttributes().get(Property.MergedRowSpan.name) != null? Integer.parseInt(node.getAttributes().get(Property.MergedRowSpan.name)):1;
                        dealMergedSpan(xmlTree, mergedRowSpan, mergedColumnSpan, diff);
                    } else if (Property.IsSelect.name.equals(propertyName)) {
                        setSonNodeProperties(diff, node, propertyName, TypeConvertor.toBoolean(newValue).toString());
                    } else {
                        if (metaObjectType == MetaObjectType.EditViewColumn
                                || metaObjectType == MetaObjectType.EditViewChildGridLayout
                                || metaObjectType == MetaObjectType.EditViewChildLinearLayout
                                || metaObjectType == MetaObjectType.EditViewChildFlexFlowLayout
                                || metaObjectType == MetaObjectType.EditViewChildColumnLayout
                                || metaObjectType == MetaObjectType.EditViewChildSplitLayout
                                || metaObjectType == MetaObjectType.EditViewChildTabLayout
                                || metaObjectType == MetaObjectType.EditViewChildFlowLayout
                                || metaObjectType == MetaObjectType.EditViewChildFlexGridLayout) {
                            if (Property.Width.name.equals(propertyName) || Property.Height.name.equals(propertyName)
                                    || Property.MinHeight.name.equals(propertyName) || Property.Weight.name.equals(propertyName)) {
                                setEditViewColumnSizeInComponentView(xmlTree, diff, propertyName, newValue);
                            } else {
                                setSonNodeProperties(diff, node, propertyName, newValue);
                            }
                        } else {
                            setSonNodeProperties(diff, node, propertyName, newValue);
                        }
                    }
                    dealExtendNode(diff, node);
                }

                boolean ownerPanelKeyChanged = false;
                for (DiffProperty property : diff.properties) {
                    if (property.property != Property.ownerPanelKey) {
                        continue;
                    }
                    TagNode newParentNode = xmlTree.xmlTree.getTagNode(tagNode.getTagName() + "@" + property.getNewValue());
                    List<AbstractNode> newChildren = newParentNode.getChildren();

                    ownerPanelKeyChanged = true;
                    if (Objects.nonNull(buddyNode)) {
                        tagNode.deleteChildByTagKey(buddyNode.getAttributes().get(ConstantUtil.KEY));
                        newChildren.add(newChildren.size() - 6, buddyNode);
                    }

                    tagNode.deleteChildByTagKey(node.getAttributes().get(ConstantUtil.KEY));
                    if (newChildren.isEmpty()){
                        newChildren.add(node);
                    }else {
                        newChildren.add(newChildren.size() - 6>=0?newChildren.size() - 6:newChildren.size()-1, node);
                    }
                }

                if (diff.properties.get(0).property.name.startsWith("Row")) {
                    genXmlDiff(xmlTree, tagNode, diff, true);
                } else {
                    if (metaObjectType == MetaObjectType.GridHeadColumn) {
                        genXmlDiff(xmlTree, tagNode.getParent(), diff, true);
                    } else if (StringUtils.isNotEmpty(diff.properties.get(0).propertyParent)) {
                        genXmlDiff(xmlTree, tagNode, diff, true);
                    } else {
                        if (ownerPanelKeyChanged) {
                            genXmlDiff(xmlTree, tagNode.getParent(), diff, true);
                        } else {
                            genXmlDiff(xmlTree, node, diff, true);
                        }
                    }
                    if (!ConstantUtil.LABEL.equals(node.getTagName()) && !ownerPanelKeyChanged) {
                        if (Objects.nonNull(buddyNode)) {
                            genXmlDiff(xmlTree, buddyNode, diff, false);
                        }
                    }
                }
            }
        } else if (metaObjectType == MetaObjectType.DataObjectCheckRule) {
            String columnKey = diff.properties.get(0).getOrgValue();
            XmlTreeWithPath xmlTree1 = diff.getXmlTree();
            if (Objects.isNull(diff.getXmlTree())) {
                xmlTree1 = diff.getDataObjectXmlTree();
            }
            int haveRelyOn = 0;
            if (MetaObjectType.DataObject.name.equals(diff.getReserveTwo())) {
                ArrayList<XmlTree> xmlTreeArrayList = new ArrayList<>();
                MetaFormList metaFormList = MetaFactory.getGlobalInstance().getMetaFormList();
                for (MetaFormProfile metaFormProfile1 : metaFormList) {
                    try {
                        String refObjectKey = metaFormProfile1.getForm().getDataSource().getRefObjectKey();
                        if (refObjectKey.equals(diff.getReserveThree())) {
                            String key = metaFormProfile1.getForm().getKey();
                            String resource = LoadFileTree.getPathByFormKey(key);
                            XmlTreeWithPath parse = XmlTreeWithPath.parseFilePath(resource);
                            if (parse != null) {
                                xmlTreeArrayList.add(parse.xmlTree);
                            }
                        }
                    } catch (Exception e) {
                        LogSvr.getInstance().error("", e);
                    }
                }
                for (XmlTree tree : xmlTreeArrayList) {
                    haveRelyOn = isHaveRelyOn(diff.properties.get(0).getOrgValue(), tree, diff.getReserveThree());
                    if (haveRelyOn != 0) {
                        break;
                    }
                }
            } else {
                haveRelyOn = isHaveRelyOn(diff.properties.get(0).getOrgValue(), xmlTree1.xmlTree, diff.getReserveTwo());
            }
            if (haveRelyOn != 0) {
                String tip = "标识" + columnKey + " 已被某组件绑定或引用，请先解除依赖关系再删除";
                if (ConstantUtil.OID.equals(columnKey)
                        || ConstantUtil.SOID.equals(columnKey)
                        || ConstantUtil.POID.equals(columnKey)
                        || ConstantUtil.VERID.equals(columnKey)
                        || ConstantUtil.DVERID.equals(columnKey)) {
                    tip = "标识" + columnKey + "标识" + columnKey + " 为系统字段不允许删除";
                }
                diff.properties.get(0).setNewValue(tip);

            }
        } else if (metaObjectType == MetaObjectType.operation
                || metaObjectType == MetaObjectType.operationCollection) {

            String xmlTreeKey = getXmlTreeKey(diff, null, diff.properties.get(0).orgValue);
            if (xmlTreeKey.contains(",")) {// 单元格和列都要设置 针对表格
                String fPrimary = xmlTreeKey.substring(0, xmlTreeKey.indexOf(","));
                String sPrimary = xmlTreeKey.replace(fPrimary + ",", "");
                TagNode cellNode = xmlTree.xmlTree.getTagNode(fPrimary);
                TagNode coluNode = xmlTree.xmlTree.getTagNode(sPrimary);
                for (DiffProperty property : diff.properties) {
                    String orgValue = property.getOrgValue();
                    String newValue = property.getNewValue();
                    if (StringUtils.isBlank(orgValue) && StringUtils.isBlank(newValue)) { // 前端 目前没有认真比较
                        continue;
                    }
                    String propertyName = property.property.name;
                    if (cellNode != null && coluNode != null) {// 表格 、标题
                        if (ConstantUtil.LABEL.equals(cellNode.getTagName()) && Property.key.name.equals(propertyName)) {// 非表格中字段
                            setSonNodeProperties(diff, cellNode, propertyName, "Inner_" + newValue);
                            setSonNodeProperties(diff, coluNode, propertyName, newValue);
                            setSonNodeProperties(diff, coluNode, ConstantUtil.BUDDY_KEY, "Inner_" + newValue);
                        } else {
                            setSonNodeProperties(diff, cellNode, propertyName, newValue);
                            setSonNodeProperties(diff, coluNode, propertyName, newValue);
                        }
                    } else if (Objects.isNull(cellNode)) {// 操作，前台没有判断，在后台判断
                        setSonNodeProperties(diff, coluNode, propertyName, newValue);
                    } else {
                        setSonNodeProperties(diff, cellNode, propertyName, newValue);
                    }
                }
                TagNode node1 = cellNode != null ? cellNode : coluNode;
                genXmlDiff(xmlTree, node1, diff, true);
                if (coluNode != null && cellNode != null) {
                    genXmlDiff(xmlTree, coluNode, diff, false);
                }
            }

        } else if (metaObjectType == MetaObjectType.ToolBar) {//
            boolean exist = false;
//			String toolBarKey = "";
            for (MetaComponent allComponent : metaForm.getAllComponents()) {//判断表单中是否含有ToorBar
                if (allComponent instanceof MetaToolBar) {
                    exist = true;
//					toolBarKey = allComponent.getKey();
                    break;
                }
            }
            if (exist) {//存在
                TagNode root = xmlTree.xmlTree.getRoot();
                TagNode operationCollection = new TagNode(ConstantUtil.OPERATION_COLLECTION, null);
                root.deleteChildByTagName(ConstantUtil.TOOL_BAR);
                TagNode operation = new TagNode(ConstantUtil.OPERATION, null);
                operation.setAttribute(ConstantUtil.KEY, "BillNew");
                operation.setAttribute(ConstantUtil.CAPTION, "新增");
                operation.setAttribute(ConstantUtil.REF_KEY, "BillNew");
                operationCollection.addNode(operation);
                root.addNode(operationCollection, 2);
                genXmlDiff(xmlTree, root, diff, true);
            } else {//不存在
                TagNode root1 = xmlTree.xmlTree.getRoot();
                TagNode tagNode = (TagNode) root1.getOrCreateChildByTagName("Body").getOrCreateChildByTagName("Block").getChildren().get(1);
                TagNode toolBar = new TagNode(ConstantUtil.TOOL_BAR, null);
                toolBar.setAttribute(ConstantUtil.KEY, "ToolBar1");
                toolBar.setAttribute(ConstantUtil.CAPTION, "ToolBar1");
                toolBar.setAttribute(ConstantUtil.HEIGHT, "pref");
                TagNode toolBarItemCollection = new TagNode(ConstantUtil.TOOL_BAR_ITEM_COLLECTION, null);
                toolBar.addNode(toolBarItemCollection);
                tagNode.addNode(toolBar, 0);
                //判断是否有操作集合
                if (diff.getXmlTree().xmlTree.getRoot().findNodesByTagName(ConstantUtil.OPERATION_COLLECTION).size() <= 0) {
                    TagNode operationCollection = new TagNode(ConstantUtil.OPERATION_COLLECTION, null);
                    TagNode operation = new TagNode(ConstantUtil.OPERATION, null);
                    operation.setAttribute(ConstantUtil.KEY, "BillNew");
                    operation.setAttribute(ConstantUtil.CAPTION, "新增");
                    operation.setAttribute(ConstantUtil.REF_KEY, "BillNew");
                    operationCollection.addNode(operation);
                    root1.addNode(operationCollection, 2);
                    root1.deleteChildByTagName(ConstantUtil.TOOL_BAR);
                    genXmlDiff(xmlTree, root1, diff, true);
                } else {
                    genXmlDiff(xmlTree, tagNode, diff, true);
                }
            }
        } else if (metaObjectType.equals(MetaObjectType.buttonReplace)) {//替换父面板
            try {
                String xmlTreeKey = ControlType.toString(diff.getControlType()) + "@" + diff.getKey();
                TagNode node = diff.getXmlTree().xmlTree.getTagNode(xmlTreeKey);
                TagNode parent = node.getParent();

                if ("Block".equalsIgnoreCase(parent.getTagName())) {
                    throw new Throwable("根节点不允许替换");
                }
                String parentkey = parent.getAttributes().get(ConstantUtil.KEY);
                TagNode parentparent = parent.getParent();
                diff.parentKey = parentkey;
                int location = location(diff, parentparent);
                parentparent.deleteChildByTagKey(parentkey);
                parentparent.addNode(node, location);
                genXmlDiff(xmlTree, parentparent, diff, true);
            } catch (Exception e) {
                LogSvr.getInstance().error(e.getMessage(), e);
            }
        } else if (metaObjectType.equals(MetaObjectType.EmbedVar)) {
            DataTable embedVarDetail = document.get(ConstantUtil.TBL_EMBED_VAR);
            dealEmbedVar(xmlTree, embedVarDetail, diff);
        } else if (MetaObjectType.AddRowPanel.equals(metaObjectType)) {
            dealAddRowPanel(xmlTree, diff);
        } else if (MetaObjectType.AddRowLayout.equals(metaObjectType)) {
            dealAddRowLayout(xmlTree, diff);
        } else if (MetaObjectType.Container.equals(metaObjectType)) {
            TagNode containerNode = xmlTree.xmlTree.getTagNode("Container@" + diff.getKey());
            for (DiffProperty property : diff.properties) {
                String orgValue = property.getOrgValue();
                String newValue = property.getNewValue();
                if (StringUtils.isBlank(orgValue) && StringUtils.isBlank(newValue)) { // 前端 目前没有认真比较
                    continue;
                }
                String propertyName = property.property.name;
                if(propertyName.equals("HasTabGroup")){
                    containerNode.deleteChildByTagName("TabGroup");
                    if(newValue.equals("Contain")){
                        TagNode tabGroupNode = new TagNode("TabGroup", null);
                        tabGroupNode.setAttribute("Key", diff.getKey() + "_TabGroup");
                        tabGroupNode.setAttribute("Caption", "页签组");
                        TagNode tabItemNode = new TagNode("TabItem", null);
                        tabItemNode.setAttribute("Key", diff.getKey()+"_TabGroup_TabItem1");
                        tabItemNode.setAttribute("Text", "菜单1");
                        tabItemNode.setAttribute("Icon", "App/Default/TabGroup/Icon1.png");
                        tabItemNode.setAttribute("SelectedIcon", "App/Default/TabGroup/Select1.png");
                        tabGroupNode.addNode(tabItemNode);
                        containerNode.addNode(tabGroupNode);
                    }
                }else {
                    setSonNodeProperties(diff, containerNode, propertyName, newValue);
                }
                genXmlDiff(xmlTree, containerNode, diff, true);
            }
        } else if (MetaObjectType.CollectionViewRow.equals(metaObjectType)) {
            TagNode tableViewRowNode = xmlTree.xmlTree.getTagNode("CollectionViewRow@" + diff.getKey());
            for (DiffProperty property : diff.properties) {
                String orgValue = property.getOrgValue();
                String newValue = property.getNewValue();
                if (StringUtils.isBlank(orgValue) && StringUtils.isBlank(newValue)) { // 前端 目前没有认真比较
                    continue;
                }
                String propertyName = property.property.name;
                setSonNodeProperties(diff, tableViewRowNode, propertyName, newValue);
                genXmlDiff(xmlTree, tableViewRowNode, diff, true);
            }
        } else if (MetaObjectType.TableViewRow.equals(metaObjectType)) {
            TagNode tableViewRowNode = xmlTree.xmlTree.getTagNode("TableRow@" + diff.getKey());
            for (DiffProperty property : diff.properties) {
                String orgValue = property.getOrgValue();
                String newValue = property.getNewValue();
                if (StringUtils.isBlank(orgValue) && StringUtils.isBlank(newValue)) { // 前端 目前没有认真比较
                    continue;
                }
                String propertyName = property.property.name;
                if (propertyName.equals(Property.HasGroupHead.name)) {
                    if (property.newValue.equals("None")) {
                        int index = tableViewRowNode.getParent().getChildren().indexOf(tableViewRowNode);
                        if (index > 0) {
                            TagNode preNode = (TagNode) tableViewRowNode.getParent().getChildren().get(index - 2);//中间间隔了一个TextNode
                            if (preNode != null && preNode.getAttributes().get("RowType") != null
                                    && preNode.getAttributes().get("RowType").equals("Group")) {
                                tableViewRowNode.getParent().getChildren().remove(preNode);
                            }
                        }
                        index = tableViewRowNode.getParent().getChildren().indexOf(tableViewRowNode);
                        if (index >= 0 && index < tableViewRowNode.getParent().getChildren().size() - 1) {
                            TagNode nextNode = (TagNode) tableViewRowNode.getParent().getChildren().get(index + 2);//中间间隔了一个TextNode
                            if (nextNode != null && nextNode.getAttributes().get("RowType") != null &&
                                    nextNode.getAttributes().get("RowType").equals("GroupTail")) {
                                tableViewRowNode.getParent().getChildren().remove(nextNode);
                            }
                        }
                    } else if (property.newValue.equals("Contain")) {
                        int index = tableViewRowNode.getParent().getChildren().indexOf(tableViewRowNode);
                        TagNode groupHeadNode = new TagNode("TableRow", null);
                        String groupHeadKey = tableViewRowNode.getAttributes().get("Key") + "_Group";
                        groupHeadNode.setAttribute("RowType", "Group");
                        groupHeadNode.setAttribute("Key", groupHeadKey);
                        groupHeadNode.setAttribute("GroupColumnKeys", "OID");
                        groupHeadNode.addNode(getTableRowDefaultPanelNode("LinearLayoutPanel", groupHeadKey));
                        tableViewRowNode.getParent().addNode(groupHeadNode, index);
                    }
                    genXmlDiff(xmlTree, tableViewRowNode.getParent(), diff, true);
                } else if (propertyName.equals(Property.HasGroupTail.name)) {
                    if (property.newValue.equals("None")) {
                        int index = tableViewRowNode.getParent().getChildren().indexOf(tableViewRowNode);
                        if (index >= 0 && index < tableViewRowNode.getParent().getChildren().size() - 1) {
                            TagNode nextNode = (TagNode) tableViewRowNode.getParent().getChildren().get(index + 2);//中间间隔了一个TextNode
                            if (nextNode != null && nextNode.getAttributes().get("RowType") != null
                                    && nextNode.getAttributes().get("RowType").equals("GroupTail")) {
                                tableViewRowNode.getParent().getChildren().remove(nextNode);
                            }
                        }
                    } else if (property.newValue.equals("Contain")) {
                        int index = tableViewRowNode.getParent().getChildren().indexOf(tableViewRowNode);
                        TagNode groupTailNode = new TagNode("TableRow", null);
                        String groupTailKey = tableViewRowNode.getAttributes().get("Key") + "_GroupTail";
                        groupTailNode.setAttribute("RowType", "GroupTail");
                        groupTailNode.setAttribute("Key", groupTailKey);
                        groupTailNode.addNode(getTableRowDefaultPanelNode("LinearLayoutPanel", groupTailKey));
                        if (index == tableViewRowNode.getParent().getChildren().size() - 1) {
                            tableViewRowNode.getParent().addNode(groupTailNode);
                        } else {
                            tableViewRowNode.getParent().addNode(groupTailNode, index + 1);
                        }
                    }
                    genXmlDiff(xmlTree, tableViewRowNode.getParent(), diff, true);
                } else {
                    setSonNodeProperties(diff, tableViewRowNode, propertyName, newValue);
                    genXmlDiff(xmlTree, tableViewRowNode, diff, true);
                }
            }
        } else if (MetaObjectType.AddTableViewRow.equals(metaObjectType)) {
            MetaComponent metaComp = IOMetaObject.getComponentByKey(metaForm, diff.parentKey);
            String controlType = metaComp instanceof MetaTableView ? "TableView" : "CollectionView";
            String tableViewKey = metaComp.getKey();
            TagNode tableViewNode = xmlTree.xmlTree.getTagNode(controlType + "@" + metaComp.getKey());
            TagNode tableRowCollectionNode = tableViewNode.findFirstTagNodeByTagName(controlType.equals("TableView") ? "TableRowCollection" : "CollectionViewRowCollection");
            DataTable rowInfoTable = document.get("ED_AddTableViewRow");
            List<TagNode> rowNodeList = tableRowCollectionNode.findNodesByTagName(controlType.equals("TableView") ? "TableRow" : "CollectionViewRow");
            String newRowKey = tableViewKey + "Row1";
            List<String> keySet = new ArrayList<>();
            for (int i = 1; i <= rowNodeList.size(); i++) {
                TagNode rowNode = rowNodeList.get(i - 1);
                keySet.add(rowNode.getAttributes().get("Key"));
            }
            int antI = 1;
            while (keySet.contains(newRowKey)) {
                antI++;
                newRowKey = tableViewKey + "Row" + antI;
            }
            if (rowInfoTable != null && rowInfoTable.first()) {
                String rowType = rowInfoTable.getString("RowType");
                String layoutType = rowInfoTable.getString("layoutType");
                String dataTableKey = rowInfoTable.getString("DataTableKey");
                TagNode rowNode = new TagNode(controlType.equals("TableView") ? "TableRow" : "CollectionViewRow", null);
                diff.setKey(newRowKey);
                rowNode.setAttribute("Key", newRowKey);
                rowNode.setAttribute("Caption", newRowKey);
                rowNode.setAttribute("RowType", rowType);
                rowNode.setAttribute("TableKey", dataTableKey);
                rowNode.addNode(getTableRowDefaultPanelNode(layoutType, newRowKey));
                tableRowCollectionNode.addNode(rowNode);
            }
            genXmlDiff(xmlTree, tableViewNode, diff, true);
        } else if (MetaObjectType.DeleteRowPanel.equals(metaObjectType)) {
            dealDeleteRowPanel(xmlTree, diff);
        } else if (MetaObjectType.DeleteRowLayout.equals(metaObjectType)) {
            dealDeleteRowLayout(xmlTree, diff);
        } else if (metaObjectType.equals(MetaObjectType.D_Embed)) {
            String paramsformKey = diff.getParamsformKey();
            if (!paramsformKey.equals(diff.formKey)) {
                String pathByFormKey = LoadFileTree.getPathByFormKey(paramsformKey);
                XmlTreeWithPath tree = XmlTreeWithPath.parseFilePath(pathByFormKey);
                diff.setXmlTree(tree);
            }
            TagNode tagNode = diff.getXmlTree().xmlTree.getTagNode("Embed@" + diff.getKey());
            List<DiffProperty> properties = diff.properties;
            for (DiffProperty property : properties) {
                String propertyName = property.property.name;
                if (ConstantUtil.KEY.equals(propertyName)) {
                    tagNode = diff.getXmlTree().xmlTree.getTagNode("Embed@" + property.getOrgValue());
                }
                if (ConstantUtil.FORM_KEY.equals(propertyName)) {//FormKey的属性修改
                    String key = "";
                    MetaForm embedMetaForm = MetaFactory.getGlobalInstance().getMetaForm(property.newValue);
                    String filePath = LoadFileTree.getPathByFormKey(embedMetaForm.getKey());
                    XmlTreeWithPath embedXmlTree = XmlTreeWithPath.parseFilePath(filePath);
                    List<AbstractNode> children = embedXmlTree.xmlTree.getRoot().getOrCreateChildByTagName("Body").getOrCreateChildByTagName("Block").getChildren();
                    for (AbstractNode child : children) {
                        if (child instanceof TagNode) {
                            key = ((TagNode) child).getAttributes().get(ConstantUtil.KEY);
                            break;
                        }
                    }
                    tagNode.setAttribute(ConstantUtil.ROOT_KEY, key);
                }
                if (Property.ForeColor.name.equals(propertyName) || Property.BackColor.name.equals(propertyName) ||
                        Property.HighlightColor.name.equals(propertyName) || Property.Font.name.equals(propertyName) ||
                        Property.Size.name.equals(propertyName) || Property.Bold.name.equals(propertyName) ||
                        Property.Italic.name.equals(propertyName) || Property.VAlign.name.equals(propertyName) ||
                        Property.HAlign.name.equals(propertyName)) { // 如果是界面显示等的修改
                    setSonNodeProperties(diff, tagNode, propertyName, property.newValue);
                } else {
                    tagNode.setAttribute(propertyName, property.newValue);
                }
            }
            genXmlDiff(diff.getXmlTree(), tagNode, diff, true);
        } else if (MetaObjectType.TabItem.equals(metaObjectType)) {
            // 新增tabItem
            if (diff.insertItemAfter) {
                MetaTabGroup tabGrop = (MetaTabGroup) IOMetaObject.getComponentByKey(metaForm, diff.parentKey);
                MetaTabItemCollection items = tabGrop.getItemCollection();
                int max = 0;
                String preKey = diff.parentKey + "_TabItem";
                for (int i = 0; i < items.size(); i ++) {
                    String key = items.get(i).getKey();
                    if (key.startsWith(preKey)) {
                        String endStr = key.substring(preKey.length());
                        int value = 0;
                        if (endStr.matches("\\d+")) {
                            value = Integer.parseInt(endStr);
                            if (max < value) {
                                max = value;
                            }
                        }
                    }
                }
                String key = preKey + (max + 1);
                String caption = "菜单" + (max + 1);
                String tabGrupKey = "TabGroup@" + diff.parentKey;
                TagNode parentNode = xmlTree.xmlTree.getTagNode(tabGrupKey);
                TagNode curNode = parentNode.getChildByKey(diff.getKey());
                if (curNode != null) {
                    List<AbstractNode> children = parentNode.getChildren();
                    TagNode itemNode = new TagNode("TabItem", null);
                    itemNode.setAttribute(ConstantUtil.KEY, key);
                    itemNode.setAttribute("Text", caption);
                    itemNode.setAttribute("Icon", "App/Default/TabGroup/Icon1.png");
                    itemNode.setAttribute("SelectedIcon", "App/Default/TabGroup/Select1.png");
                    int i = children.indexOf(curNode);
                    parentNode.addNode(itemNode);
                    genXmlDiff(xmlTree, parentNode, diff, true);
                }
            } else if (diff.moveItemAfter) {
                // 向后
                String tabGrupKey = "TabGroup@" + diff.parentKey;
                TagNode parentNode = xmlTree.xmlTree.getTagNode(tabGrupKey);
                TagNode curNode = parentNode.getChildByKey(diff.getKey());
                if (curNode != null) {
                    List<AbstractNode> tabItems = parentNode.getChildrenByTagName("TabItem");
                    if (tabItems.size() > 1) {
                        int afterIndex = tabItems.indexOf(curNode) + 1;
                        if (afterIndex < tabItems.size()) {
                            TagNode afterNode = (TagNode) tabItems.get(afterIndex);
                            List<AbstractNode> childs = parentNode.getChildren();
                            int index1 = childs.indexOf(curNode);
                            int index2 = childs.indexOf(afterNode);
                            childs.set(index1, afterNode);
                            childs.set(index2, curNode);
                        }
                    }
                    genXmlDiff(xmlTree, parentNode, diff, true);
                }
            } else if (diff.moveItemFront) {
                // 向前
                String tabGrupKey = "TabGroup@" + diff.parentKey;
                TagNode parentNode = xmlTree.xmlTree.getTagNode(tabGrupKey);
                TagNode curNode = parentNode.getChildByKey(diff.getKey());
                if (curNode != null) {
                    List<AbstractNode> tabItems = parentNode.getChildrenByTagName("TabItem");
                    if (tabItems.size() > 1) {
                        int frontIndex = tabItems.indexOf(curNode) - 1;
                        if (frontIndex >= 0) {
                            TagNode frontNode = (TagNode) tabItems.get(frontIndex);
                            List<AbstractNode> childs = parentNode.getChildren();
                            int index1 = childs.indexOf(curNode);
                            int index2 = childs.indexOf(frontNode);
                            childs.set(index1, frontNode);
                            childs.set(index2, curNode);
                        }
                    }
                    genXmlDiff(xmlTree, parentNode, diff, true);
                }
            } else {
                // 直接修改属性值
                String tabGrupKey = "TabGroup@" + diff.parentKey;
                TagNode parentNode = xmlTree.xmlTree.getTagNode(tabGrupKey);
                TagNode curNode = parentNode.getChildByKey(diff.getKey());
                for (DiffProperty property : diff.properties) {
                    if (Property.Text.name.equals(property.property.name)
                            || Property.Icon.name.equals(property.property.name)
                            || Property.FormKey.name.equals(property.property.name)
                            || Property.SelectedIcon.name.equals(property.property.name)
                            || Property.ClickAnim.name.equals(property.property.name)
                            || Property.key.name.equals(property.property.name)
                            || Property.visible.name.equals(property.property.name)
                            || Property.VisibleDependency.name.equals(property.property.name)) {
                        String orgValue = property.getOrgValue();
                        String newValue = property.getNewValue();
                        if (StringUtils.isBlank(orgValue) && StringUtils.isBlank(newValue)) { // 前端 目前没有认真比较
                            continue;
                        }
                        String propertyName = property.property.name;
                        curNode.setAttribute(propertyName, newValue);
                    } else {
                        setSonNodeProperties(diff, curNode, property.property.name, property.getNewValue());
                    }
                }
                genXmlDiff(xmlTree, parentNode, diff, true);
            }
        }
    }

    private static TagNode getTableRowDefaultPanelNode(String layoutType, String newRowKey){
        TagNode defaultPanelNode = null;
        if (layoutType.equals("LinearLayoutPanel")) {
            defaultPanelNode = new TagNode("LinearLayoutPanel", null);
            defaultPanelNode.setAttribute("Key", newRowKey + "DefaultPanel");
            defaultPanelNode.setAttribute("Caption", newRowKey + "DefaultPanel");
            defaultPanelNode.setAttribute("Height", "45px");
        } else if (layoutType.equals("GridLayoutPanel")) {
            defaultPanelNode = new TagNode("GridLayoutPanel", null);
            defaultPanelNode.setAttribute("Key", newRowKey + "DefaultPanel");
            defaultPanelNode.setAttribute("Caption", newRowKey + "DefaultPanel");
            defaultPanelNode.setAttribute("Height", "75px");
            TagNode gridRowDefCollNode = new TagNode("RowDefCollection", null);
            gridRowDefCollNode.setAttribute("RowGap", "5");
            gridRowDefCollNode.setAttribute("RowHeight", "30");
            TagNode rowDefNode1 = new TagNode("RowDef", null);
            gridRowDefCollNode.addNode(rowDefNode1);
            TagNode rowDefNode2 = new TagNode("RowDef", null);
            gridRowDefCollNode.addNode(rowDefNode2);
            TagNode gridColumnDefCollNode = new TagNode("ColumnDefCollection", null);
            gridColumnDefCollNode.setAttribute("ColumnGap", "5");
            TagNode columnDefNode1 = new TagNode("ColumnDef", null);
            columnDefNode1.setAttribute("Width", "10px");
            gridColumnDefCollNode.addNode(columnDefNode1);
            TagNode columnDefNode2 = new TagNode("ColumnDef", null);
            columnDefNode2.setAttribute("Width", "80px");
            gridColumnDefCollNode.addNode(columnDefNode2);
            TagNode columnDefNode3 = new TagNode("ColumnDef", null);
            columnDefNode3.setAttribute("Width", "100%");
            gridColumnDefCollNode.addNode(columnDefNode3);
            TagNode columnDefNode4 = new TagNode("ColumnDef", null);
            columnDefNode4.setAttribute("Width", "10px");
            gridColumnDefCollNode.addNode(columnDefNode4);
            defaultPanelNode.addNode(gridRowDefCollNode);
            defaultPanelNode.addNode(gridColumnDefCollNode);
        }
        return defaultPanelNode;
    }

    public static void dealEditViewChildLayout(TagNode compViewNode, TagNode colsNode, String childLayoutKey) throws Throwable {
        if (childLayoutKey == null) {
            return;
        }

        if (compViewNode == null) {
            return;
        }

        TagNode childLayoutNode = compViewNode.getChildByKey(childLayoutKey);
        List<AbstractNode> childLayoutNodes = compViewNode.getChildren();

        if (childLayoutNode != null) {
            List<AbstractNode> childrens = childLayoutNode.getChildren();
            for (int i = 0; i < childrens.size(); i ++) {
                AbstractNode child = childrens.get(i);

                if (child instanceof TagNode) {
                    TagNode itemNode = (TagNode) child;
                    Map<String, String> attrs = itemNode.getAttributes();
                    if (attrs != null && attrs.containsKey("Key")) {
                        String itemKey = attrs.get("Key");

                        if (colsNode != null) {
                            TagNode colNode = colsNode.getChildByKey(itemKey);
                            colsNode.getChildren().remove(colNode);
                        }

                        dealEditViewChildLayout(compViewNode, colsNode, itemKey);
                    }
                }
            }

            for (int j = 0; j < childLayoutNodes.size(); j ++) {
                AbstractNode child = childLayoutNodes.get(j);
                if (child instanceof TagNode) {
                    TagNode spanChildNode = ((TagNode) child).getChildByKey(childLayoutKey);
                    if (spanChildNode != null) {
                        ((TagNode) child).getChildren().remove(spanChildNode);
                        break;
                    }
                    //((TagNode) child).deleteChildByTagKey(childLayoutKey);
                }
            }

            compViewNode.getChildren().remove(childLayoutNode);
        }
    }

    public static void dealEmbedTable(XmlTreeWithPath xmlTree, Document document, Diff diff) throws Throwable {
        DataTable embedDataTable = document.get(ConstantUtil.TBL_EMBED_TABLE_COLLECTION);
        TagNode embedTableCollection = xmlTree.xmlTree.getRoot().findFirstTagNodeByTagName("EmbedTableCollection");
        TagNode dataSource = xmlTree.xmlTree.getRoot().findFirstTagNodeByTagName(ConstantUtil.DATA_SOURCE);
        TagNode dataObject = xmlTree.xmlTree.getRoot().findFirstTagNodeByTagName(ConstantUtil.DATA_OBJECT);
        if (Objects.isNull(dataSource) && Objects.isNull(dataObject)) { // 无数据对象
            return;
        }
        if (Objects.isNull(embedTableCollection) && embedDataTable.size() > 0) {
            embedTableCollection = dataObject.getOrCreateChildByTagName("EmbedTableCollection");
        }
        if (embedTableCollection != null) {
            embedTableCollection.deleteChildByTagName("EmbedTable");
        }

        String extend = null;
        String dataObjectKey = diff.formKey;
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
        MetaDataObjectProfile metaDataObjectProfile = dataObjectList.get(dataObjectKey);
        if (Objects.nonNull(metaDataObjectProfile)) {
            extend = metaDataObjectProfile.getExtend();
            if (StringUtils.isBlank(extend)) {
                extend = metaDataObjectProfile.getDataObject().getMergeToSourceMapKey();
            }
        }
        List<String> existKeyList = new ArrayList<>();
        if (StringUtils.isNotBlank(extend)) {
            String xmlFilePath = LoadFileTree.getPathByDataObject(extend);
            String tempXmlFilePath = XmlFileProcessor.instance.getTmpFile(xmlFilePath);
            String filePath = StringUtils.isNotBlank(tempXmlFilePath) ? tempXmlFilePath : xmlFilePath;

            XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(filePath);
            if (Objects.nonNull(xmlTreeWithPath)) {
                TagNode rootNode = xmlTreeWithPath.xmlTree.getRoot();
                TagNode checkRuleCollectionNode = rootNode.getChildByTagName("EmbedTableCollection");
                if (Objects.nonNull(checkRuleCollectionNode)) {
                    List<TagNode> checkRuleNodeList = checkRuleCollectionNode.findNodesByTagName("EmbedTable");
                    for (TagNode tagNode : checkRuleNodeList) {
                        Map<String, String> attributes = tagNode.getAttributes();
                        String tableKey = attributes.get("TableKeys");
                        existKeyList.add(tableKey);
                    }
                }
            }
        }

        // 直接删除节点重新添加
        List<TagNode> embedTableNodeList = new ArrayList<>();
        if (embedDataTable.size() > 0) {
            List<String> keyList = new ArrayList<>();
            for (int i = 0; i < embedDataTable.size(); i++) {
                String objectKey = embedDataTable.getString(i, "ObjectKey");
                String tableKeys = embedDataTable.getString(i, "TableKey");

                if (embedDataTable.getState(i) == RowState.NEW && existKeyList.contains(tableKeys)) {
                    throw new RuntimeException("warning: 嵌入数据源重复!");
                }
                if (existKeyList.contains(tableKeys)) {
                    keyList.add(tableKeys);
                    continue;
                }
                if (keyList.contains(tableKeys)) {
                    throw new RuntimeException("warning: 嵌入数据源重复!");
                }
                keyList.add(tableKeys);
                TagNode newEmbed = new TagNode("EmbedTable", null);
                embedTableNodeList.add(newEmbed);
                newEmbed.setAttribute(ConstantUtil.OBJECT_KEY, objectKey);
                newEmbed.setAttribute(ConstantUtil.TABLE_KEYS, tableKeys);
            }
        }
        if (CollectionUtils.isNotEmpty(embedTableNodeList)) {
            for (TagNode embedTableNode : embedTableNodeList) {
                embedTableCollection.addNode(embedTableNode);
            }
        } else {
            dataObject.deleteChildByTagName("EmbedTableCollection");
        }
    }

    private static void dealColumnExpand(DataTable headTable, XmlTreeWithPath xmlTree, Diff diff, TagNode tagNode) throws Throwable {
        String type = ColumnExpandType.toString(Integer.parseInt(headTable.getString(0, ConstantUtil.EXPAND_TYPE)));
        if (tagNode.getChildren().size() == 0 && "Title".equalsIgnoreCase(type)) {
            throw new Throwable("该表格头未添加子列不允许设置为标题拓展");
        }
        TagNode columnExpand = tagNode.findFirstTagNodeByTagName(ConstantUtil.COLUMN_EXPAND);
        if (columnExpand != null) {
            tagNode.deleteChildByTagName(ConstantUtil.COLUMN_EXPAND);
        }

        TagNode parentNode = tagNode.getParent().getParent();
        if (StringUtils.isNotEmpty(type)) {
            if (StringUtils.equalsIgnoreCase(parentNode.getTagName(), ConstantUtil.GRID_COLUMN)) {
                TagNode parentColumnExpandNode = parentNode.findFirstTagNodeByTagName(ConstantUtil.COLUMN_EXPAND);
                if (Objects.isNull(parentColumnExpandNode)) {
                    parentColumnExpandNode = new TagNode(ConstantUtil.COLUMN_EXPAND, null);
                    parentColumnExpandNode.setAttribute(ConstantUtil.EXPAND_TYPE, ColumnExpandType.STR_TITLE);
                    parentNode.addNode(parentColumnExpandNode);
                }
            }

            TagNode expandNode = new TagNode(ConstantUtil.COLUMN_EXPAND, null);
            expandNode.setAttribute(ConstantUtil.EXPAND_TYPE, type);
            String expandDependency = headTable.getString(0, ConstantUtil.EXPAND_DEPENDENCY);
            if (StringUtils.isNotEmpty(expandDependency)) {
                expandNode.setAttribute(ConstantUtil.EXPAND_DEPENDENCY, expandDependency);
            }
            String expandSourceType = ExpandSourceType.toString(Integer.parseInt(headTable.getString(0, ConstantUtil.EXPAND_SOURCE_TYPE)));
            if (StringUtils.isNotEmpty(expandSourceType) && "Data".equalsIgnoreCase(type)) {
                expandNode.setAttribute(ConstantUtil.EXPAND_SOURCE_TYPE, expandSourceType);
            }
            String itemKey = headTable.getString(0, ConstantUtil.ITEM_KEY);
            if (StringUtils.isNotEmpty(itemKey)) {
                expandNode.setAttribute(ConstantUtil.ITEM_KEY, itemKey);
            }
            String columnKey = headTable.getString(0, ConstantUtil.COLUMN_KEY);
            if (StringUtils.isNotEmpty(columnKey) && !"无字段".equalsIgnoreCase(columnKey)) {
                expandNode.setAttribute(ConstantUtil.COLUMN_KEY, columnKey);
            }
            String tableKey = headTable.getString(0, ConstantUtil.TABLE_KEY);
            if (StringUtils.isNotEmpty(tableKey) && !"无数据表".equalsIgnoreCase(tableKey)) {
                expandNode.setAttribute(ConstantUtil.TABLE_KEY, tableKey);
            }
            String columnExpandContext = headTable.getString(0, ConstantUtil.COLUMN_EXPAND);
            CDataNode cDataNode = new CDataNode(columnExpandContext, null);
            expandNode.addNode(cDataNode);
            tagNode.addNode(expandNode);
        }
        genXmlDiff(xmlTree, parentNode, diff, true);
    }

    /**
     * 自动过滤掉马甲表单中组件属性与原表单相同的字段
     */
    private static void dealExtendNode(Diff diff, TagNode node) throws Throwable {
        if (StringUtils.isNotEmpty(diff.getMetaForm().getExtend())) {
            MetaForm extendForm = MetaFactory.getGlobalInstance().getMetaForm(diff.getMetaForm().getExtend());
            String filePath = LoadFileTree.getPathByFormKey(extendForm.getKey());
            XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(filePath);
            String xmlTreeKey = getXmlTreeKey(diff, null, null);
            TagNode extendNode = xmlTreeWithPath.xmlTree.getTagNode(xmlTreeKey);
            if (Objects.isNull(extendNode)) {
                return;
            }
            String sourceValue = extendNode.getAttributes().get(diff.properties.get(0).property.name);
            if (StringUtils.isNotEmpty(sourceValue)) {
                if (sourceValue.equalsIgnoreCase(node.getAttributes().get(diff.properties.get(0).property.name))) {
                    node.getAttributes().remove(diff.properties.get(0).property.name);
                } else {
                    if (StringUtils.isNotEmpty(diff.properties.get(0).newValue)) {
                        node.getAttributes().put(diff.properties.get(0).property.name, diff.properties.get(0).newValue);
                    }
                }
            }
            if (!StringUtils.isNotEmpty(sourceValue) && !StringUtils.isNotEmpty(diff.properties.get(0).newValue)) {
                node.getAttributes().remove(diff.properties.get(0).property.name);
            }
        }
    }

    private static TagNode setNodeKey(String newValue, Diff diff) {
        TagNode gridNode = diff.getXmlTree().xmlTree.getTagNode("Grid@" + diff.properties.get(0).orgValue);
        gridNode.setAttribute(ConstantUtil.KEY, newValue);
        List<TagNode> bodyTagNodes = diff.getXmlTree().xmlTree.getRoot().findNodesByTagName("Body");
        TagNode bodyTagNode = bodyTagNodes.get(0);
        List<TagNode> blockTagNodes = bodyTagNode.findNodesByTagName("Block");
        TagNode tagNode = blockTagNodes.get(0);
        if (tagNode != null) {
            setNodeAppoint(newValue, tagNode, diff);
        }
        return bodyTagNode;
    }

    private static void setNodeAppoint(String newValue, TagNode tagNode, Diff diff) {
        List<AbstractNode> nodes = tagNode.getChildren();
        for (AbstractNode node : nodes) {
            if (node instanceof TagNode) {
                if (!((TagNode) node).getTagName().equalsIgnoreCase(tagNode.getTagName())) {
                    List<TagNode> nodesByTagName = ((TagNode) node).findNodesByTagName(MetaObjectType.subDetail.name);
                    if (nodesByTagName.size() != 0) {
                        for (TagNode node1 : nodesByTagName) {
                            if (node1 != null) {
                                if (node1.getAttributes().get("BindingGridKey").equalsIgnoreCase(diff.properties.get(0).orgValue)) {
                                    node1.setAttribute("BindingGridKey", newValue);
                                }
                            }
                        }
                    } else {
                        setNodeAppoint(newValue, ((TagNode) node), diff);
                    }
                }
            }
        }
    }

    private static void dealAddRowLayout(XmlTreeWithPath xmlTree, Diff diff) {
        String addDir = diff.getAddDirection();
        int x = diff.x;
        int y = diff.y;
        MetaForm metaForm = diff.getMetaForm();

        MetaViewCollection viewCollection = metaForm.getMetaBody().getViewCollection();
        if (viewCollection != null) {
            MetaView metaView = viewCollection.get("Android");
            if (metaView != null) {
                TagNode viewNode = xmlTree.xmlTree.getTagNode("View@Android");
                if (viewNode == null) {
                    return;
                }

                TagNode compView = viewNode.getChildByKey(diff.parentKey);
                TagNode layoutView = compView.getChildByKey(diff.getKey());

                List<AbstractNode> nodeList = layoutView.getChildren();
                TagNode rowNode = null;
                TagNode colNode = null;
                for (AbstractNode node : nodeList) {
                    if (node instanceof TagNode) {
                        if (ConstantUtil.ROW_DEF_COLLECTION.equalsIgnoreCase(((TagNode) node).getTagName())) {
                            rowNode = (TagNode) node;
                        } else if (ConstantUtil.COLUMN_DEF_COLLECTION.equalsIgnoreCase(((TagNode) node).getTagName())) {
                            colNode = (TagNode) node;
                        }
                    }
                }
                for (AbstractNode node : nodeList) {
                    if (node instanceof TagNode) {
                        String nodeX = ((TagNode) node).getAttributes().get(ConstantUtil.X);
                        String nodeY = ((TagNode) node).getAttributes().get(ConstantUtil.Y);
                        String key = ((TagNode) node).getAttributes().get(ConstantUtil.KEY);
//                        if (StringUtils.isNotEmpty(metaForm.getExtend()) && StringUtils.isNotEmpty(key)) {//如果是马甲节点中的xy坐标可能不存在
//                            MetaComponent metaComponent = IOMetaObject.getComponentByKey(metaForm, key);
//                            nodeX = String.valueOf(metaComponent.getX());
//                            nodeY = String.valueOf(metaComponent.getY());
//                        }
                        if (nodeX != null && nodeY != null) {
                            switch (addDir) {
                                case "AddRowFront":
                                    if (Integer.parseInt(nodeY) >= y) {
                                        ((TagNode) node).setAttribute(ConstantUtil.Y, String.valueOf(Integer.parseInt(nodeY) + 1));
                                    }
                                    break;
                                case "AddRowBehind":
                                    if (Integer.parseInt(nodeY) >= y + 1) {
                                        ((TagNode) node).setAttribute(ConstantUtil.Y, String.valueOf(Integer.parseInt(nodeY) + 1));
                                    }
                                    break;
                                case "AddColumnBehind":
                                    if (Integer.parseInt(nodeX) >= x + 1) {
                                        ((TagNode) node).setAttribute(ConstantUtil.X, String.valueOf(Integer.parseInt(nodeX) + 1));
                                    }
                                    break;
                                case "AddColumnFront":
                                    if (Integer.parseInt(nodeX) >= x) {
                                        ((TagNode) node).setAttribute(ConstantUtil.X, String.valueOf(Integer.parseInt(nodeX) + 1));
                                    }
                                    break;
                            }
                        }
                    }
                }
                if ("AddRowFront".equalsIgnoreCase(addDir)) {
                    TagNode node = new TagNode(ConstantUtil.ROW_DEF, null);
                    node.setAttribute(ConstantUtil.HEIGHT, "32px");
                    if (y == 0) {
                        rowNode.addNode(node, y);
                    } else {
                        rowNode.addNode(node, 2 * y);
                    }
                    genXmlDiff(xmlTree, layoutView, diff, true);
                } else if ("AddRowBehind".equalsIgnoreCase(addDir)) {
                    TagNode node = new TagNode(ConstantUtil.ROW_DEF, null);
                    node.setAttribute(ConstantUtil.HEIGHT, "32px");
                    rowNode.addNode(node, 2 * (y + 1));
                    genXmlDiff(xmlTree, layoutView, diff, true);
                } else if ("AddColumnFront".equalsIgnoreCase(addDir)) {
                    TagNode node = new TagNode(ConstantUtil.COLUMN_DEF, null);
                    node.setAttribute(ConstantUtil.WIDTH, "70px");
                    if (x == 0) {
                        colNode.addNode(node, x);
                    } else {
                        colNode.addNode(node, 2 * x);
                    }
                    genXmlDiff(xmlTree, layoutView, diff, true);
                } else if ("AddColumnBehind".equalsIgnoreCase(addDir)) {
                    TagNode node = new TagNode(ConstantUtil.COLUMN_DEF, null);
                    node.setAttribute(ConstantUtil.WIDTH, "70px");
                    colNode.addNode(node, 2 * (x + 1));
                    genXmlDiff(xmlTree, layoutView, diff, true);
                }



            }
        }

    }

    private static void dealAddRowPanel(XmlTreeWithPath xmlTree, Diff diff) {
        String addDir = diff.getAddDirection();
        int x = diff.x;
        int y = diff.y;
        MetaForm metaForm = diff.getMetaForm();
        MetaGridLayoutPanel panel = (MetaGridLayoutPanel) IOMetaObject.getComponentByKey(metaForm, diff.parentKey);
        String gridkey = panel.getKey();
        TagNode gridNode = xmlTree.xmlTree.getTagNode("GridLayoutPanel@" + gridkey);
        List<AbstractNode> nodeList = gridNode.getChildren();
        TagNode rowNode = null;
        TagNode colNode = null;
        for (AbstractNode node : nodeList) {
            if (node instanceof TagNode) {
                if (ConstantUtil.ROW_DEF_COLLECTION.equalsIgnoreCase(((TagNode) node).getTagName())) {
                    rowNode = (TagNode) node;
                } else if (ConstantUtil.COLUMN_DEF_COLLECTION.equalsIgnoreCase(((TagNode) node).getTagName())) {
                    colNode = (TagNode) node;
                }
            }
        }
        for (AbstractNode node : nodeList) {
            if (node instanceof TagNode) {
                String nodeX = ((TagNode) node).getAttributes().get(ConstantUtil.X);
                String nodeY = ((TagNode) node).getAttributes().get(ConstantUtil.Y);
                String key = ((TagNode) node).getAttributes().get(ConstantUtil.KEY);
                if (StringUtils.isNotEmpty(metaForm.getExtend()) && StringUtils.isNotEmpty(key)) {//如果是马甲节点中的xy坐标可能不存在
                    MetaComponent metaComponent = IOMetaObject.getComponentByKey(metaForm, key);
                    nodeX = String.valueOf(metaComponent.getX());
                    nodeY = String.valueOf(metaComponent.getY());
                }
                if (nodeX != null && nodeY != null) {
                    switch (addDir) {
                        case "AddRowFront":
                            if (Integer.parseInt(nodeY) >= y) {
                                ((TagNode) node).setAttribute(ConstantUtil.Y, String.valueOf(Integer.parseInt(nodeY) + 1));
                            }
                            break;
                        case "AddRowBehind":
                            if (Integer.parseInt(nodeY) >= y + 1) {
                                ((TagNode) node).setAttribute(ConstantUtil.Y, String.valueOf(Integer.parseInt(nodeY) + 1));
                            }
                            break;
                        case "AddColumnBehind":
                            if (Integer.parseInt(nodeX) >= x + 1) {
                                ((TagNode) node).setAttribute(ConstantUtil.X, String.valueOf(Integer.parseInt(nodeX) + 1));
                            }
                            break;
                        case "AddColumnFront":
                            if (Integer.parseInt(nodeX) >= x) {
                                ((TagNode) node).setAttribute(ConstantUtil.X, String.valueOf(Integer.parseInt(nodeX) + 1));
                            }
                            break;
                    }
                }
            }
        }
        if ("AddRowFront".equalsIgnoreCase(addDir)) {
            TagNode node = new TagNode(ConstantUtil.ROW_DEF, null);
            node.setAttribute(ConstantUtil.HEIGHT, "32px");
            if (y == 0) {
                rowNode.addNode(node, y);
            } else {
                rowNode.addNode(node, 2 * y - 1);
            }
            handleExtraLayout(gridNode, y, true);
            genXmlDiff(xmlTree, gridNode, diff, true);
        } else if ("AddRowBehind".equalsIgnoreCase(addDir)) {
            TagNode node = new TagNode(ConstantUtil.ROW_DEF, null);
            node.setAttribute(ConstantUtil.HEIGHT, "32px");
            if (y == 0) {
                rowNode.addNode(node, y);
            } else {
                rowNode.addNode(node, 2 * (y + 1) - 1);
            }
            handleExtraLayout(gridNode, y, true);
            genXmlDiff(xmlTree, gridNode, diff, true);
        } else if ("AddColumnFront".equalsIgnoreCase(addDir)) {
            TagNode node = new TagNode(ConstantUtil.COLUMN_DEF, null);
            node.setAttribute(ConstantUtil.WIDTH, "70px");
            if (x == 0) {
                colNode.addNode(node, x);
            } else {
                colNode.addNode(node, 2 * x - 1);
            }
            genXmlDiff(xmlTree, gridNode, diff, true);
        } else if ("AddColumnBehind".equalsIgnoreCase(addDir)) {
            TagNode node = new TagNode(ConstantUtil.COLUMN_DEF, null);
            node.setAttribute(ConstantUtil.WIDTH, "70px");
            if (x == 0) {
                colNode.addNode(node, x);
            } else {
                colNode.addNode(node, 2 * (x + 1) - 1);
            }
            genXmlDiff(xmlTree, gridNode, diff, true);
        }

    }

    public static void dealDeleteRowLayout(XmlTreeWithPath xmlTree, Diff diff) throws Throwable {
        String delDir = diff.getDeleteDirection();
        int x = diff.x;
        int y = diff.y;
        MetaForm metaForm = diff.getMetaForm();

        MetaViewCollection viewCollection = metaForm.getMetaBody().getViewCollection();
        if (viewCollection != null) {
            MetaView metaView = viewCollection.get("Android");
            if (metaView != null) {
                TagNode viewNode = xmlTree.xmlTree.getTagNode("View@Android");
                if (viewNode == null) {
                    return;
                }

                TagNode compView = viewNode.getChildByKey(diff.parentKey);
                TagNode layoutView = compView.getChildByKey(diff.getKey());

                List<AbstractNode> childrenNode = layoutView.getChildren();
                for (AbstractNode node : childrenNode) {
                    if (node instanceof TagNode) {
                        String nodeX = ((TagNode) node).getAttributes().get(ConstantUtil.X);
                        String nodeY = ((TagNode) node).getAttributes().get(ConstantUtil.Y);
                        String key = ((TagNode) node).getAttributes().get(ConstantUtil.KEY);
                        if (StringUtils.isNotEmpty(metaForm.getExtend()) && StringUtils.isNotEmpty(key)) {//如果是马甲节点中的xy坐标可能不存在
                            MetaComponent metaComponent = IOMetaObject.getComponentByKey(metaForm, key);
                            nodeX = String.valueOf(metaComponent.getX());
                            nodeY = String.valueOf(metaComponent.getY());

                        }
                        if (nodeX != null && nodeY != null) {
                            switch (delDir) {
                                case "DeleteColumn":
                                    if (Integer.parseInt(nodeX) >= x && Integer.parseInt(nodeX) != 0) {
                                        ((TagNode) node).setAttribute(ConstantUtil.X, String.valueOf(Integer.parseInt(nodeX) - 1));
                                    } else if (Integer.parseInt(nodeX) == x && x == 0) {
                                        ((TagNode) node).setAttribute(ConstantUtil.X, "0");
                                    }
                                    break;
                                case "DeleteRow":
                                    if (Integer.parseInt(nodeY) >= y && Integer.parseInt(nodeY) != 0) {
                                        ((TagNode) node).setAttribute(ConstantUtil.Y, String.valueOf(Integer.parseInt(nodeY) - 1));
                                    } else if (Integer.parseInt(nodeY) == y && y == 0) {
                                        ((TagNode) node).setAttribute(ConstantUtil.Y, "0");
                                    }
                                    break;
                            }
                        }
                    }
                }
                if ("DeleteRow".equalsIgnoreCase(delDir)) {
                    TagNode node = layoutView.getOrCreateChildByTagName(ConstantUtil.ROW_DEF_COLLECTION);

                    node.deleteChildX(node, 2 * y + 1);

                    genXmlDiff(xmlTree, layoutView, diff, true);
                } else if ("DeleteColumn".equalsIgnoreCase(delDir)) {
                    TagNode node = layoutView.getOrCreateChildByTagName(ConstantUtil.COLUMN_DEF_COLLECTION);
                    node.deleteChidY(node, 2 * x + 1);
                    genXmlDiff(xmlTree, layoutView, diff, true);
                }

            }
        }
    }

    public static void dealDeleteRowPanel(XmlTreeWithPath xmlTree, Diff diff) throws Throwable {
        String delDir = diff.getDeleteDirection();
        int x = diff.x;
        int y = diff.y;
        MetaForm metaForm = diff.getMetaForm();
        MetaGridLayoutPanel metaGridLayoutPanel = (MetaGridLayoutPanel) IOMetaObject.getComponentByKey(metaForm, diff.parentKey);
        String gridkey = metaGridLayoutPanel.getKey();
        TagNode gridNode = xmlTree.xmlTree.getTagNode("GridLayoutPanel@" + gridkey);
        List<AbstractNode> childrenNode = gridNode.getChildren();
        for (AbstractNode node : childrenNode) {
            if (node instanceof TagNode) {
                String nodeX = ((TagNode) node).getAttributes().get(ConstantUtil.X);
                String nodeY = ((TagNode) node).getAttributes().get(ConstantUtil.Y);
                String key = ((TagNode) node).getAttributes().get(ConstantUtil.KEY);
                if (StringUtils.isNotEmpty(metaForm.getExtend()) && StringUtils.isNotEmpty(key)) {//如果是马甲节点中的xy坐标可能不存在
                    MetaComponent metaComponent = IOMetaObject.getComponentByKey(metaForm, key);
                    nodeX = String.valueOf(metaComponent.getX());
                    nodeY = String.valueOf(metaComponent.getY());

                }
                if (nodeX != null && nodeY != null) {
                    switch (delDir) {
                        case "DeleteColumn":
                            if (Integer.parseInt(nodeX) >= x && Integer.parseInt(nodeX) != 0) {
                                ((TagNode) node).setAttribute(ConstantUtil.X, String.valueOf(Integer.parseInt(nodeX) - 1));
                            } else if (Integer.parseInt(nodeX) == x && x == 0) {
                                ((TagNode) node).setAttribute(ConstantUtil.X, "0");
                            }
                            break;
                        case "DeleteRow":
                            if (Integer.parseInt(nodeY) >= y && Integer.parseInt(nodeY) != 0) {
                                ((TagNode) node).setAttribute(ConstantUtil.Y, String.valueOf(Integer.parseInt(nodeY) - 1));
                            } else if (Integer.parseInt(nodeY) == y && y == 0) {
                                ((TagNode) node).setAttribute(ConstantUtil.Y, "0");
                            }
                            break;
                    }
                }
            }
        }
        if ("DeleteRow".equalsIgnoreCase(delDir)) {
            TagNode node = gridNode.getOrCreateChildByTagName(ConstantUtil.ROW_DEF_COLLECTION);

            node.deleteChildX(node, 2 * y + 1);
            handleExtraLayout(gridNode, y, false);
            genXmlDiff(xmlTree, gridNode, diff, true);
        } else if ("DeleteColumn".equalsIgnoreCase(delDir)) {
            TagNode node = gridNode.getOrCreateChildByTagName(ConstantUtil.COLUMN_DEF_COLLECTION);
            node.deleteChidY(node, 2 * x + 1);
            genXmlDiff(xmlTree, gridNode, diff, true);
        }
    }

    /**
     * 字段没有依赖
     *
     * @return boolean
     */
    public static boolean fieldHastRely(String key, String dataObjectKey, String tableKey) {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        try {
            for (MetaFormProfile metaFormProfile : metaFactory.getMetaFormList()) {
                if (metaFormProfile.getForm() != null && metaFormProfile.getForm().getDataSource() != null &&
                        metaFormProfile.getForm().getDataSource().getDataObject() != null &&
                        dataObjectKey.equals(metaFormProfile.getForm().getDataSource().getDataObject().getKey())) {
                    IDLookup idLookup = IDLookup.getIDLookup(metaFormProfile.getForm());
                    if (Objects.nonNull(idLookup.getColumKeysAndFieldListKeys(tableKey)) && idLookup.getColumKeysAndFieldListKeys(tableKey).containsKey(key)) {
                        return false;
                    }
                }
            }
        } catch (Throwable throwable) {
            LogSvr.getInstance().error(throwable.getMessage(), throwable);
        }
        return true;
    }

    public static void handleFieldinformation(Diff diff, XmlTreeWithPath xmlTree) {
        for (DiffProperty property : diff.properties) {
            String orgValue = property.getOrgValue();
            String newValue = property.getNewValue();
            if (StringUtils.isBlank(orgValue) && StringUtils.isBlank(newValue)) { // 前端 目前没有认真比较
                continue;
            }
            //拿到当前操作的TableKey
            String reserTwo = diff.getReserveTwo();
            //拿到当前操作的table节点
            String table_Key = ConstantUtil.TABLE + "@" + reserTwo;
            TagNode table_node = diff.getXmlTree().xmlTree.getTagNode(table_Key);
            //拿到当前操作的Column节点
            String column_Key = ConstantUtil.COLUMN + "@" + diff.getReserveThree();
            TagNode column_node = diff.getXmlTree().xmlTree.getTagNode(column_Key);
            if (column_node != null && table_node != null) {
                TagNode node = fieldinFormation(diff, newValue, column_node, table_node);
                genXmlDiff(xmlTree, node, diff, true);
            }
        }
    }

    /**
     * 字段属性操作
     */
    public static TagNode fieldinFormation(Diff diff, String newValue, TagNode node, TagNode parentNode) {
        TagNode childByTagNode = parentNode.findChildByTagNode(node);
        //拿到当前操作的属性名
        String reserveOne = diff.getReserveOne();
        //一些特殊属性另作处理
        if (ConstantUtil.DATA_TYPE.equalsIgnoreCase(reserveOne)) {
            childByTagNode.setAttribute(reserveOne, DataType.toString(Integer.parseInt(newValue)));
        } else if (ConstantUtil.SORT_TYPE.equalsIgnoreCase(reserveOne)) {
            childByTagNode.setAttribute(reserveOne, SortType.toString(Integer.parseInt(newValue)));
        } else if (ConstantUtil.PERIOD_GRANULARITY.equalsIgnoreCase(reserveOne)) {
            childByTagNode.setAttribute(reserveOne, DMPeriodGranularityType.toString(Integer.parseInt(newValue)));
        } else if (ConstantUtil.SPLIT_TYPE.equalsIgnoreCase(reserveOne)) {
            childByTagNode.setAttribute(reserveOne, DataSplitType.toString(Integer.parseInt(newValue)));
        } else if (ConstantUtil.GROUP_TYPE.equalsIgnoreCase(reserveOne)) {
            childByTagNode.setAttribute(reserveOne, DataGroupGranularity.toString(Integer.parseInt(newValue)));
        } else if (ConstantUtil.NEED_RIGHTS.equalsIgnoreCase(reserveOne)) {
            childByTagNode.setAttribute(reserveOne, ColumnRightsType.toString(Integer.parseInt(newValue)));
        } else {
            //类似于单选框，值为false就进行属性删除
            if (diff.getTrueOrfalse()) {
                childByTagNode.setAttribute(reserveOne, newValue);
            } else {
                childByTagNode.getAttributes().remove(reserveOne);
            }
        }
        return parentNode;
    }


    private static TagNode modifyDataSource(Diff diff, String key, String name) {
        if ((diff.tableKey != null && !"".equals(diff.tableKey)) || (diff.subTableKey != null && !"".equals(diff.subTableKey))) {
            TagNode tableCollection = diff.getXmlTree().xmlTree.getRoot().findFirstTagNodeByTagName(ConstantUtil.TABLE_COLLECTION);
            TagNode table = new TagNode(ConstantUtil.TABLE, null);
            table.setAttribute(ConstantUtil.KEY, key);
            table.setAttribute(ConstantUtil.CAPTION, name);
            table.setAttribute(ConstantUtil.DB_TABLE_NAME, key);
            //table.setAttribute(ConstantUtil.INDEX_PREFIX, key);
            table.setAttribute(ConstantUtil.PARENT_KEY, "");
            table.setAttribute(ConstantUtil.TABLE_MODE, ConstantUtil.DETAIL);
            if (diff.getMetaForm().getFormType() == FormType.Report) {//报表类型
                table.setAttribute(ConstantUtil.PERSIST, "false");
            }
            TagNode column = new TagNode(ConstantUtil.COLUMN, null);
            column.setAttribute(ConstantUtil.KEY, ConstantUtil.OID);
            column.setAttribute(ConstantUtil.CAPTION, "对象标识");
            column.setAttribute(ConstantUtil.DATA_TYPE, "Long");
            TagNode column1 = new TagNode(ConstantUtil.COLUMN, null);
            column1.setAttribute(ConstantUtil.KEY, ConstantUtil.SOID);
            column1.setAttribute(ConstantUtil.CAPTION, "主对象标识");
            column1.setAttribute(ConstantUtil.DATA_TYPE, "Long");
            TagNode column2 = new TagNode(ConstantUtil.COLUMN, null);
            column2.setAttribute(ConstantUtil.KEY, ConstantUtil.POID);
            column2.setAttribute(ConstantUtil.CAPTION, "父对象标识");
            column2.setAttribute(ConstantUtil.DATA_TYPE, "Long");
            TagNode column3 = new TagNode(ConstantUtil.COLUMN, null);
            column3.setAttribute(ConstantUtil.KEY, ConstantUtil.VERID);
            column3.setAttribute(ConstantUtil.CAPTION, "对象版本");
            column3.setAttribute(ConstantUtil.DATA_TYPE, "Integer");
            TagNode column4 = new TagNode(ConstantUtil.COLUMN, null);
            column4.setAttribute(ConstantUtil.KEY, ConstantUtil.DVERID);
            column4.setAttribute(ConstantUtil.CAPTION, "对象明细版本");
            column4.setAttribute(ConstantUtil.DATA_TYPE, "Integer");
            table.addNode(column);
            table.addNode(column1);
            table.addNode(column2);
            table.addNode(column3);
            table.addNode(column4);
            tableCollection.addNode(table);
            return tableCollection;
        }
        return null;
    }

    //form相关属性修改
    private static void dealForm(Diff diff, XmlTreeWithPath xmlTree) throws Throwable {
        TagNode formNode = xmlTree.xmlTree.getRoot();
        for (DiffProperty property : diff.properties) {
//			String orgValue = property.getOrgValue();
            String newValue = property.getNewValue();
            String propertyName = property.property.name;
            setSonNodeProperties(diff, formNode, propertyName, newValue);
        }
        genXmlDiff(xmlTree, formNode, diff, true);
    }

    public static void genXmlDiff(XmlTreeWithPath xmlTree, TagNode node, Diff diff, boolean isFirst) {
        while (node.getElement() == null){
            node = node.getParent();
        }

        int startLine = xmlTree.xmlTree.getLineByIndex(node.getElement().getBgIndex());
        String orgXmlFragment;
        orgXmlFragment = xmlTree.xmlTree.getNodeString(startLine);
        String newXmlFragment = DesignIOMetaUtil.getXml(node);
        if (isFirst) {
            diff.setXmlDiff(xmlTree, startLine, orgXmlFragment, newXmlFragment);
        } else {
            diff.setXmlDiff2(xmlTree, startLine, orgXmlFragment, newXmlFragment);
        }
    }
    public static void genSingleXmlDiff(XmlTreeWithPath xmlTree, TagNode node, Diff diff) {
        genXmlDiff(xmlTree,node,diff,true);
    }

    private static void setColumnKey(MetaForm metaForm, Diff diff, String newValue,
                                     String propertyName, XmlTreeWithPath xmlTree, TagNode node, String orgValue) throws Throwable {
        // 判断是否是取消数据库列标识
        boolean isNoField = "无字段".equals(newValue);
        //这一步是进行输入值校验
        newValue = checking(newValue);
        //定位数据源Column和表格内的GridColumn
        TagNode newTagNode = null;
        TagNode newTagNode2 = null;
        String refObjectKey = metaForm.getDataSource().getRefObjectKey();
        String tableKey = diff.getReserveTwo();
        TagNode tableTagNode;
        TagNode tableTagNode2 = null;
        MetaFormProfile metaFormProfile = MetaFactory.getGlobalInstance().getMetaFormList().get(metaForm.getKey());
        if(metaFormProfile == null) MetaFactory.getGlobalInstance().getExtFormList().get(metaForm.getKey());
        Boolean mergeToSource1 = metaFormProfile.getMergeToSource();
        if (StringUtils.isBlank(metaForm.getExtend()) || mergeToSource1) {
            if (StringUtils.isNotEmpty(refObjectKey)) {//表示为引入的扩展表单
                tableTagNode = diff.getDataObjectXmlTree().xmlTree.getTagNode("Table@" + tableKey);
                if (Objects.nonNull(diff.getOtherDataObjectOrgTree())) {
                    tableTagNode2 = diff.getOtherDataObjectOrgTree().xmlTree.getTagNode("Table@" + tableKey);
                }
            } else {
                tableTagNode = diff.getXmlTree().xmlTree.getTagNode("Table@" + tableKey);
            }
            if (tableTagNode != null) {
                for (AbstractNode child : tableTagNode.getChildren()) {
                    if (child instanceof TagNode) {
                        Map<String, String> attributes = ((TagNode) child).getAttributes();
                        if (attributes != null && attributes.get(ConstantUtil.KEY) != null && attributes.get(ConstantUtil.KEY).equalsIgnoreCase(newValue)) {
                            newTagNode = (TagNode) child;
                            break;
                        }
                    }
                }
            }
            if (tableTagNode2 != null) {
                for (AbstractNode child : tableTagNode2.getChildren()) {
                    if (child instanceof TagNode) {
                        Map<String, String> attributes = ((TagNode) child).getAttributes();
                        if (attributes != null && attributes.get(ConstantUtil.KEY) != null && attributes.get(ConstantUtil.KEY).equalsIgnoreCase(newValue)) {
                            newTagNode2 = (TagNode) child;
                            break;
                        }
                    }
                }
            }
            int controlType = diff.getControlType();
            String datatype = getDatatype(controlType);
            if (Objects.isNull(newTagNode) && Objects.isNull(newTagNode2)) {//手输
                //判断当前操作的Column是否被其他地方调用,
                int haveRelyOn = isHaveRelyOn(orgValue, xmlTree.xmlTree, tableKey);
                boolean orgValueIsSystemField = ConstantUtil.OID.equals(orgValue)
                        || ConstantUtil.SOID.equals(orgValue)
                        || ConstantUtil.POID.equals(orgValue)
                        || ConstantUtil.VERID.equals(orgValue)
                        || ConstantUtil.SEQUENCE.equals(orgValue)
                        || ConstantUtil.DVERID.equals(orgValue);

                boolean isReplace = haveRelyOn == 1 && !orgValueIsSystemField;
                if (isReplace && StringUtils.isNotEmpty(orgValue) && !isNoField) {//替换节点
                    // 删除旧值的Column
                    tableTagNode.deleteChildByTagKey(orgValue);
                    // 添加新值的Column
                    TagNode column = new TagNode(ConstantUtil.COLUMN, null);
                    column.setAttribute(ConstantUtil.KEY, newValue);
                    column.setAttribute(ConstantUtil.CAPTION, newValue);
                    column.setAttribute(ConstantUtil.DATA_TYPE, datatype);
                    if ("Varchar".equalsIgnoreCase(datatype)) {
                        column.setAttribute(ConstantUtil.LENGTH, "255");
                    }
                    if (controlType == ControlType.DICT) {
                        String orgKey = orgValue;
                        String newKey = newValue;
                        if (orgValue.toLowerCase().endsWith("id")) {
                            orgKey = orgValue.substring(0, orgValue.length() - 2);
                        }
                        if (newValue.toLowerCase().endsWith("id")) {
                            newKey = newValue.substring(0, newValue.length() - 2);
                        }
                        tableTagNode.deleteChildByTagKey(orgKey + "Code");
                        tableTagNode.deleteChildByTagKey(orgKey + "Name");
                        TagNode code = new TagNode(ConstantUtil.COLUMN, null);
                        code.setAttribute(ConstantUtil.KEY, newKey + "Code");
                        code.setAttribute(ConstantUtil.CAPTION, newValue);
                        code.setAttribute(ConstantUtil.DATA_TYPE, DataType.STR_STRING);
                        code.setAttribute(ConstantUtil.LENGTH, "30");
                        tableTagNode.addNode(code);
                        column.setAttribute(ConstantUtil.CODE_COLUMN_KEY, newKey + "Code");
                    }
                    tableTagNode.addNode(column);
                    if (StringUtils.isNotEmpty(refObjectKey)) {//表示为引入的扩展表单
                        genXmlDiff(diff.getDataObjectXmlTree(), tableTagNode, diff, false);
                    } else {
                        genXmlDiff(xmlTree, tableTagNode, diff, false);
                    }
                } else if (StringUtils.isNotEmpty(newValue)) {
                    TagNode column = new TagNode(ConstantUtil.COLUMN, null);
                    column.setAttribute(ConstantUtil.KEY, newValue);
                    column.setAttribute(ConstantUtil.CAPTION, newValue);
                    column.setAttribute(ConstantUtil.DATA_TYPE, datatype);
                    if ("Varchar".equalsIgnoreCase(datatype)) {
                        column.setAttribute(ConstantUtil.LENGTH, "255");
                    }
                    tableTagNode.addNode(column);
                    if (StringUtils.isNotEmpty(refObjectKey)) {//表示为引入的扩展表单
                        genXmlDiff(diff.getDataObjectXmlTree(), tableTagNode, diff, false);
                    } else {
                        genXmlDiff(xmlTree, tableTagNode, diff, false);
                    }
                }

            }
        }
        if (isNoField) {
            TagNode childByTagName = node.getChildByTagName(MetaDataBinding.TAG_NAME);
            if (Objects.nonNull(childByTagName)) {
                childByTagName.deleteAttribute(ConstantUtil.TABLE_KEY);
            }
        }

        setSonNodeProperties(diff, node, propertyName, newValue);
        if (!"GridCell".equalsIgnoreCase(node.getTagName()) && !isNoField) {
            setSonNodeProperties(diff, node, ConstantUtil.TABLE_KEY, tableKey);
        }
    }

    public static int isHaveRelyOn(String columnValue, XmlTree xmlTree, String tableKey) {
        String s = xmlTree.getRoot().getAttributes().get("MergeToSource");
        if ("true".equals(s)) {
            String extendKey = xmlTree.getRoot().getAttributes().get(ConstantUtil.EXTEND);
            MetaForm metaForm = null;
            try {
                metaForm = MetaFactory.getGlobalInstance().getMetaForm(extendKey);
            } catch (Throwable e) {
                LogSvr.getInstance().error(e.getMessage(), e);
            }
            //判断是否再原表单中
            IDLookup idLookup = IDLookup.getIDLookup(metaForm);
            Collection<String> fieldKeys = idLookup.getFieldKeys();
            for (String fieldKey : fieldKeys) {
                MetaComponent componentByKey = null;
                try {
                    componentByKey = idLookup.getComponentByKey(fieldKey);
                } catch (Exception e) {
                    LogSvr.getInstance().error(e.getMessage(), e);
                }
                if (componentByKey != null && componentByKey.getDataBinding() != null) {
                    String columnKey = componentByKey.getDataBinding().getColumnKey();
                    if (!columnKey.isEmpty() && columnKey.equalsIgnoreCase(columnValue)) {
                        return 1;
                    }
                }
                MetaGridCell gridCellByKey = idLookup.getGridCellByKey(fieldKey);
                if (gridCellByKey != null && gridCellByKey.getDataBinding() != null) {
                    String columnKey = gridCellByKey.getDataBinding().getColumnKey();
                    if (!columnKey.isEmpty() && columnKey.equalsIgnoreCase(columnValue)) {
                        return 1;
                    }
                }

            }
        }
        if (StringUtils.isEmpty(columnValue) || "null".equals(columnValue)) {
            return 0;
        }
        if (StringUtils.isBlank(tableKey)) {
            return 1;
        }
        int anInt = 0;
        int anInt1 = 0;
        int anInt2 = 0;
        int anInt3 = 0;
        if (ConstantUtil.OID.equals(columnValue) || ConstantUtil.SOID.equals(columnValue) || ConstantUtil.POID.equals(columnValue)
                || ConstantUtil.VERID.equals(columnValue) || ConstantUtil.DVERID.equals(columnValue)) {
            anInt3 = 1;
        }
        List<TagNode> dataBinding = xmlTree.getRoot().findNodesByTagName(MetaDataBinding.TAG_NAME);
        List<TagNode> gridRow = xmlTree.getRoot().findNodesByTagName(ConstantUtil.GRID_ROW);
        List<TagNode> dataSource = xmlTree.getRoot().findNodesByTagName(ConstantUtil.DATA_SOURCE);
        if (dataSource.size() > 0 && columnValue.equals(dataSource.get(0).getAttributes().get("RefObjectKey"))) {//引入数据对象表单
            return 1;
        }
        try {
            MetaFormList metaFormList = MetaFactory.getGlobalInstance().getMetaFormList();
            for (MetaFormProfile metaFormProfile : metaFormList) {//判断是否有表引用
                if (metaFormProfile.getForm() != null && metaFormProfile.getForm().getDataSource() != null
                        && columnValue.equals(metaFormProfile.getForm().getDataSource().getRefObjectKey())) {
                    return 1;
                }
            }
        } catch (Throwable throwable) {
            LogSvr.getInstance().error(throwable.getMessage(), throwable);
        }
        //判断使用次数
        for (TagNode col : dataBinding) {
            String columnKey = col.getAttributes().get(ConstantUtil.COLUMN_KEY);
            String tableKey1 = col.getAttributes().get(ConstantUtil.TABLE_KEY);

            if (null != columnKey) {
                if (StringUtils.isEmpty(tableKey1) && columnKey.equals(columnValue)) {
                    anInt++;
                }
                if (tableKey.equals(tableKey1) && columnKey.equals(columnValue)) {
                    anInt++;
                }
                if (tableKey.equals(tableKey1) && tableKey.equals(columnValue)) {
                    anInt++;
                }
            }

        }  //判断使用次数
        for (TagNode col : gridRow) {
            String columnKey1 = col.getAttributes().get(ConstantUtil.TABLE_KEY);
            if (null != columnKey1) {
                if (columnKey1.equals(columnValue)) {
                    anInt2++;
                }
            }
        }
        return anInt + anInt1 + anInt2 + anInt3;
    }

    private static Pattern p = Pattern.compile("[a-zA-Z\\d_.,\\-/;\\[\\]‘\\\\${}^|~\\n\\r\\t ]{1,35}");
    private static String checking(String newValue) {
        //这一步是防止前端优化效果后再次触发添加事件（如：c 变成 c  c 后再次触发方法），外加去空格，防止输入空格造成数据崩溃
        newValue = newValue.split(" {2}")[0].replaceAll("\\s*", "");
        Matcher m = p.matcher(newValue);
        //特殊字符校验
        //String regEx = "[ _`~!@#$%^&*()……+=|{}':;',\\[\\].<>/?~！@#￥%……&*（）——+|{}【】‘；：”“’。，、？]|\n|\r|\t";
        // Pattern p = Pattern.compile(regEx);
        // Matcher m = p.matcher(newValue);
        //中文校验
        if (!m.matches()) {
            newValue = "";
        }
        return newValue;
    }

    /**
     * 父节点的儿子节点的属性_CData修改
     */
    private static void setSonNodeCData(TagNode node, String propertyName, String newValue) {
        if (StringUtils.isEmpty(newValue)) {
            node.deleteChildByTagName(propertyName);
        } else {
            TagNode valueChangedNode = node.getOrCreateChildByTagName(propertyName);
            valueChangedNode.setCDataValue(newValue);
        }
    }

    /**
     * 父节点的的属性_CData修改
     */
    private static void setThisNodeCData(TagNode node, String newValue) {
        if (StringUtils.isEmpty(newValue)) {
            node.deleteCDataValue();
        } else {
            node.setCDataValue(newValue);
        }
    }

    /**
     * 父节点的儿子节点的属性_Properties修改
     */
    private static void setSonNodeProperties(Diff diff, TagNode node, String propertyName, String newValue) throws Throwable {
        MetaFormProfile metaFormProfile = MetaFactory.getGlobalInstance().getMetaFormList().get(diff.getMetaForm().getKey());
        if(metaFormProfile == null) metaFormProfile = MetaFactory.getGlobalInstance().getExtFormList().get(diff.getMetaForm().getKey());
        Boolean mergeToSource1 = metaFormProfile.getMergeToSource();
        if (Objects.isNull(node)) {
            return;
        }
        boolean isNull = StringUtils.isEmpty(newValue)
                || "无数据表".equalsIgnoreCase(newValue)
                || "无字段".equalsIgnoreCase(newValue);
        if (mergeToSource1) {
            isNull = false;
        }
        if ("无数据表".equalsIgnoreCase(newValue)) {
            newValue = "";
        }
        DiffProperty diffProperty = diff.properties.get(0);
        if (StringUtils.isEmpty(diffProperty.propertyValueByLocation)) {//自身
            if (diffProperty.propertyIsCData) {//cdata类型
                setThisNodeCData(node, newValue);
            } else {
                if (isNull) {
                    if (StringUtils.isNotEmpty(diffProperty.propertyParent)) {
                        TagNode propertyParentNode = node.getOrCreateChildByTagName(diffProperty.propertyParent);
                        propertyParentNode.deleteAttribute(propertyName);
                        if (propertyParentNode.getAttributes().size() == 0) {
                            propertyParentNode.getParent().getChildren().remove(propertyParentNode);
                        }
                    } else if (StringUtils.isNotEmpty(metaFormProfile.getForm().getExtend())) {
                        node.setAttributeNotRemove(propertyName, newValue);
                    } else {
                        node.deleteAttribute(propertyName);
                    }
                } else {
                    if (StringUtils.isNotEmpty(diffProperty.propertyParent)) {
                        TagNode propertyParentNode = node.getOrCreateChildByTagName(diffProperty.propertyParent);
                        propertyParentNode.setAttributeNotRemove(propertyName, newValue);

                    } else if (mergeToSource1) {
                        node.setAttributeNotRemove(propertyName, newValue);
                    } else {
                        node.setAttribute(propertyName, newValue);
                        if (StringUtils.equals(propertyName, ConstantUtil.ITEM_KEY) && StringUtils.isNotBlank(newValue)) {
                            node.deleteAttribute(Property.ItemKeySourceType.name);
                            node.deleteAttribute(Property.ItemKeySource.name);
                            if(newValue.endsWith("__Dic")){
                                node.setAttribute(Property.StateMask.name,"Enable|Disable|Discard");
                            }
                        }
                        if (StringUtils.equals(propertyName, Property.ItemKeySourceType.name) && StringUtils.isNotBlank(newValue)) {
                            node.deleteAttribute(ConstantUtil.ITEM_KEY);
                            node.deleteChildByTagName(MetaItemFilter.TAG_NAME);
                        }

                        if (diff.getControlType() == ControlType.EDITVIEW) {
                            if (propertyName.equalsIgnoreCase("Orientation")) {
                                node.setAttributeNotRemove(propertyName, newValue);
                            }
                            if (propertyName.equalsIgnoreCase("Key")) {
                                // 修改editview的key，需要修改对应layout的key
                                String compViewKey = "ComponentView@" + diff.getKey();
                                TagNode compViewNode = diff.getXmlTree().xmlTree.getTagNode(compViewKey);

                                if (compViewNode != null) {
                                    compViewNode.setAttribute("Key", newValue);
                                    TagNode rootLayout = compViewNode.getChildByKey(diff.getKey());

                                    if (rootLayout != null) {
                                        rootLayout.setAttribute("Key", newValue);
                                    }

                                    genXmlDiff(diff.getXmlTree(), compViewNode, diff, false);
                                }
                            }
                        }
                        if(diff.getControlType() == ControlType.FLEXGRIDLAYOUTPANEL){
                            if(propertyName.equalsIgnoreCase("ColumnCount")){
                                node.setAttributeNotRemove(propertyName, newValue);
                            }
                        }
                        if (propertyName.equalsIgnoreCase("Visible") || propertyName.equalsIgnoreCase("Enable")) {
                            node.setAttribute(propertyName + "Dependency", diff.getReserveTwo());
                        }
                        if (StringUtils.equals(propertyName, Property.FormulaCaption.name)) {
                            node.setAttribute("CaptionDependency", diff.getReserveTwo());
                            if (diff.getMetaObjectType() == MetaObjectType.field) {
                                node.setAttribute(Property.caption.name, "");
                            }
                        }
                        if (StringUtils.equals(propertyName, Property.CellType.name) && StringUtils.equals(newValue, ControlType.toString(ControlType.HYPERLINK))) {
                            node.setAttribute("Caption", diff.getKey());
                        }
                        if (StringUtils.equals(propertyName, Property.SourceType.name) && diff.getControlType() == ControlType.CHART) {
                            if (node.getChildByTagName(ConstantUtil.CHART_DATASOURCE) != null) {
                                node.deleteChildByTagName(ConstantUtil.CHART_DATASOURCE);
                            }
                        }
                        if (StringUtils.equals(propertyName, Property.SourceType.name) && diff.getControlType() == ControlType.WEBBROWSER) {
                            if (node.getAttributes().get(propertyName) != WebBrowserSourceType.STR_URL) {
                                node.deleteAttribute("URLPrefix");
                            }
                        }
                    }
                }
            }

        } else {//子节点
            String sonNodeName = diffProperty.propertyValueByLocation;
            String parentNodeName = diffProperty.propertyParent;
            if (!"".equalsIgnoreCase(parentNodeName)) { // 有父节点 不属于当前node的下级
                node = node.getOrCreateChildByTagName(parentNodeName);
                if ("Font".equalsIgnoreCase(propertyName)) {
                    propertyName = "Name";
                }
            }
            TagNode childByTagName = node.getChildByTagName(sonNodeName);

            if (diffProperty.propertyIsCData) {//cdata类型
                if (Objects.isNull(childByTagName)) {//说明是马甲
                    if (!isNull) {
                        if (StringUtils.equalsAnyIgnoreCase(propertyName, "ValueChanged", "CheckRule", "DefaultFormulaValue", "ValueChangeAction")) {
                            childByTagName = new TagNode(sonNodeName, null);
                            setSonNodeCData(childByTagName, propertyName, newValue);
                            node.addNode(childByTagName);
                        } else {
                            setSonNodeCData(node, sonNodeName, newValue);
                        }
                    }
                } else {
                    if (StringUtils.equalsAnyIgnoreCase(propertyName, "ValueChanged", "CheckRule", "DefaultFormulaValue", "ValueChangeAction")) {
                        if (propertyName.equalsIgnoreCase("DefaultFormulaValue")) {
                            childByTagName.setAttribute("ValueDependency", diff.getReserveTwo());
                            childByTagName.setAttribute("DefaultValue", "");
                        }
                        if (propertyName.equalsIgnoreCase("CheckRule")) {
                            childByTagName.setAttribute("CheckDependency", diff.getReserveTwo());
                        }
                        childByTagName.deleteAttribute(propertyName);
                        setSonNodeCData(childByTagName, propertyName, newValue);
                    } else {
                        setSonNodeCData(node, sonNodeName, newValue);
                    }
                }
            } else {
                if (Objects.isNull(childByTagName)) {//说明是马甲
                    if (!isNull) {
                        TagNode valueChangedNode = node.getOrCreateChildByTagName(sonNodeName);
                        TagNode dataBinding = node.getChildByTagName("DataBinding");
                        TagNode format = node.getChildByTagName("Format");
                        if(dataBinding != null && format != null) {
                            List<AbstractNode> children = node.getChildren();
                            int i = -1, j = -1;
                            for (int k = 0; k < children.size(); k++) {
                                AbstractNode abs = children.get(k);
                                if (abs instanceof TagNode) {
                                    String tagName = ((TagNode) abs).getTagName();
                                    if (StringUtils.equals(tagName, "DataBinding")) {
                                        i = k;
                                    }
                                    if (StringUtils.equals(tagName, "Format")) {
                                        j = k;
                                    }
                                }
                            }
                            if (i > j) {
                                Collections.swap(children, i, j);
                            }
                        }
                        valueChangedNode.setAttributeNotRemove(propertyName, newValue);
                    }
                } else {
                    if (isNull) {
                        if (childByTagName.getAttributes().size() <= 1 && childByTagName.getChildren().size() <= 2) {
                            node.deleteChildByTagName(sonNodeName);
                            if (StringUtils.equalsAnyIgnoreCase(propertyName, "ValueChanged", "CheckRule", "DefaultFormulaValue")) {
                                childByTagName.deleteAttribute(propertyName);
                            }
                        } else {
                            childByTagName.deleteAttribute(propertyName);
                            if (StringUtils.equalsAnyIgnoreCase(propertyName, "ValueChanged", "CheckRule", "DefaultFormulaValue")) {
                                childByTagName.deleteChildByTagName(propertyName);
                            }
                        }
                        if ("DataBinding".equals(sonNodeName) && propertyName.equalsIgnoreCase("TableKey")) {
                            childByTagName.deleteAttribute("ColumnKey");
                        }
                        if (propertyName.equalsIgnoreCase("DefaultFormulaValue")) {
                            childByTagName.deleteAttribute("ValueDependency");
                        }
                        if (propertyName.equalsIgnoreCase("CheckRule")) {
                            childByTagName.deleteAttribute("CheckDependency");
                        }
                    } else {
                        if (childByTagName.hasAttribute(ConstantUtil.COLUMN_KEY) && propertyName.equalsIgnoreCase(ConstantUtil.TABLE_KEY)) {
                            childByTagName.setAttribute(propertyName, newValue);
                        } else if (metaFormProfile.getPlatform() != 6 && propertyName.equalsIgnoreCase(ConstantUtil.TABLE_KEY) && !childByTagName.hasAttribute(ConstantUtil.COLUMN_KEY)) {
                            setSonNodeProperties(diff, node, ConstantUtil.TABLE_KEY, ConstantUtil.TABLE_KEY_DEFAULT);
                        } else {
                            childByTagName.setAttribute(propertyName, newValue);
                        }
                        if ("DefaultValue".equalsIgnoreCase(propertyName)) {
                            childByTagName.setAttribute("DefaultFormulaValue", "");
                            node.deleteChildByTagName("DefaultFormulaValue");
                            childByTagName.setAttribute("ValueDependency", diff.getReserveTwo());
                        }
                        if ("DefaultFormulaValue".equalsIgnoreCase(propertyName)) {
                            childByTagName.setAttribute("DefaultValue", "");
                        }
                        if (StringUtils.equalsAnyIgnoreCase(propertyName, "ValueChanged", "CheckRule", "DefaultFormulaValue")) {
                            childByTagName.deleteChildByTagName(propertyName);
                        }
                        if (propertyName.equalsIgnoreCase("DefaultFormulaValue")) {
                            childByTagName.setAttribute("ValueDependency", diff.getReserveTwo());
                        }
                        if (propertyName.equalsIgnoreCase("CheckRule")) {
                            childByTagName.setAttribute("CheckDependency", diff.getReserveTwo());
                        }
                    }

                }
            }

        }
    }


    private static void setEditViewColumnGridLayoutSpanProperty(XmlTreeWithPath xmlTree, Diff diff, String propertyName, String newValue) {
        String compViewKey = "ComponentView@" + diff.parentKey;
        TagNode compViewNode = xmlTree.xmlTree.getTagNode(compViewKey);
        if (compViewNode != null) {
            List<AbstractNode> childLayouts= compViewNode.getChildren();
            for (AbstractNode childNode : childLayouts) {
                if (childNode instanceof TagNode) {
                    TagNode layout = (TagNode) childNode;
                    if ("GridLayout".equalsIgnoreCase(layout.getTagName())) {
                        TagNode span = layout.getChildByKey(diff.getKey());
                        if (span != null) {
                            span.setAttribute(propertyName, newValue);
                            genXmlDiff(xmlTree, span, diff, false);
                            return;
                        }
                    }
                }
            }
        }
    }

    private static void setEditViewColumnSizeInComponentView(TagNode parentNode, String columnKey, String propertyName, String newValue) {
        String key = parentNode.getAttributes().get("Key");
        if (key != null && key.equals(columnKey)) {
            parentNode.setAttribute(propertyName, newValue);
        } else if (!parentNode.getChildren().isEmpty()) {
            for (int i = 0; i < parentNode.getChildren().size(); i++) {
                AbstractNode subNode = parentNode.getChildren().get(i);
                if (subNode instanceof TagNode) {
                    setEditViewColumnSizeInComponentView((TagNode) subNode, columnKey, propertyName, newValue);
                }
            }
        }
    }
    private static void setEditViewColumnSizeInComponentView(XmlTreeWithPath xmlTree, Diff diff, String propertyName, String newValue) {
        String compViewKey = "ComponentView@" + diff.parentKey;
        TagNode compViewNode = xmlTree.xmlTree.getTagNode(compViewKey);
        if (compViewNode != null) {
            List<AbstractNode> childLayouts = compViewNode.getChildren();
            for (AbstractNode childNode : childLayouts) {
                if (childNode instanceof TagNode) {
                    setEditViewColumnSizeInComponentView((TagNode) childNode, diff.getKey(), propertyName, newValue);
                }
            }
            genXmlDiff(xmlTree, compViewNode, diff, false);
        }
    }

    // 非本节点的属性设置（例：databinding属性） 和 本节点属性设置
    private static void setListViewNodeProperty(Diff diff, TagNode node, String propertyName, String newValue) throws Throwable {
        if (Property.ColumnType.name.equalsIgnoreCase(propertyName)) {

            node.setAttribute(propertyName, newValue);
        } else if (ConstantUtil.COLUMN_KEY.equals(propertyName)) {
            node.setAttribute("Data" + propertyName, newValue);
            node.setAttribute(propertyName, newValue);
        } else {
            setSonNodeProperties(diff, node, propertyName, newValue);
        }

    }

    //分隔尺寸节点修改方法
    private static void dealSeparate(XmlTreeWithPath xmlTree, DataTable Table,
                                     Diff diff) throws Throwable {
        String ownerFormKey = diff.formKey;
        MetaForm ownerMetaForm = StringUtils.isBlank(ownerFormKey) ? null : MetaFactory.getGlobalInstance().getMetaForm(ownerFormKey);
        String Key = diff.getKey();
        MetaSplitPanel metaSplitPanel = (MetaSplitPanel) IOMetaObject.getComponentByKey(ownerMetaForm, Key);
        if (Objects.isNull(metaSplitPanel) && diff.getContainerKey() != null) {
            ownerMetaForm = StringUtils.isBlank(ownerFormKey) ? null : MetaFactory.getGlobalInstance().getMetaForm(diff.getContainerKey());
            metaSplitPanel = (MetaSplitPanel) IOMetaObject.getComponentByKey(ownerMetaForm, Key);
        }
        MetaSplitSizeCollection metaSplitSizeCollection = metaSplitPanel.getSplitSize();
        int number = 0;
        if (metaSplitSizeCollection != null) {
            String TagName = metaSplitPanel.getTagName();
            TagNode BigtagNode = xmlTree.xmlTree.getTagNode(TagName + "@" + Key);
            List<AbstractNode> sonNode = BigtagNode.getChildren();
            for (AbstractNode abstractNode : sonNode) {
                if (abstractNode instanceof TagNode) {
                    if ("SplitSize".equalsIgnoreCase(((TagNode) abstractNode).getTagName())) {
                        TagNode smallNode = (TagNode) abstractNode;
                        if ("1".equals(Table.getString(number, ConstantUtil.TYPE))) {
                            smallNode.setAttribute("Size", Table.getInt(number, "Size") + "%");
                        } else {
                            smallNode.setAttribute("Size", Table.getInt(number, "Size") + "px");
                        }
                        smallNode.setAttribute(MetaConstants.SPLITPANEL_FORWARD_COLLAPASED, Table.getString(number, MetaConstants.SPLITPANEL_FORWARD_COLLAPASED));
                        smallNode.setAttribute(MetaConstants.SPLITPANEL_REVERSE_COLLAPASED, Table.getString(number, MetaConstants.SPLITPANEL_REVERSE_COLLAPASED));
                        smallNode.setAttribute(MetaConstants.SPLITPANEL_TYPE, Table.getString(number, "CollapaseType"));
                        number++;
                    }
                }
            }
            genXmlDiff(xmlTree, BigtagNode, diff, true);
        }
    }

    private static void dealComboBoxSourceSetting(XmlTreeWithPath xmlTree, Diff diff, Document document, MetaForm metaForm) throws Throwable {
        String componentKey = diff.getKey();
        MetaComponent metaComponent = IOMetaObject.getComponentByKey(metaForm, diff.getKey());
        String xmlTreeKey = null;
        if(metaComponent != null) {
            xmlTreeKey = getXmlTreeKey(diff, metaComponent.getTagName(), componentKey);
        } else {
            AbstractMetaObject abstractMetaObject = metaForm.getAllUIComponents().get(diff.getKey());
            if (abstractMetaObject == null) return;
            xmlTreeKey = abstractMetaObject.getTagName() + "@" + diff.getKey();
        }
        // 父节点
        TagNode parentNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
        // 将父节点中的节点直接删除再重新添加
        parentNode.deleteChildByTagName("Item");
        parentNode.deleteChildByTagName("FormulaItems");
        parentNode.deleteChildByTagName("QueryDef");
        parentNode.deleteChildByTagName("ComboFilter");
        parentNode.setAttribute("GroupKey", "");
        parentNode.setAttribute("ItemsDependency", "");

        DataTable propertyTable = document.get(ConstantUtil.TBL_PROPERTIES);
        if(propertyTable != null && propertyTable.first()) {
            String sourceType = propertyTable.getString("GetSourceType");
            switch (sourceType) {
                case "Items":
                    DataTable itemTable = document.get("ED_ComboBoxDetail");
                    if (itemTable != null && !itemTable.isEmpty()) {
                        itemTable.beforeFirst();
                        while (itemTable.next()) {
                            Boolean extendFlag = itemTable.getBoolean("ExtendFlag");
                            if (extendFlag) {
                                continue;
                            }
                            TagNode itemNode = new TagNode("Item", null);
                            itemNode.setAttribute("Key", itemTable.getString("Key"));
                            itemNode.setAttribute("Value", itemTable.getString("Value"));
                            itemNode.setAttribute("Caption", itemTable.getString("Caption"));
                            parentNode.addNode(itemNode);
                        }
                    }
                    break;
                case "Formula":
                    TagNode formulaNode = new TagNode("FormulaItems", null);
                    String formulaContent = propertyTable.getString("GetFormulaItems");
                    formulaNode.setCDataValue(formulaContent);
                    parentNode.addNode(formulaNode);
                    parentNode.setAttribute("ItemsDependency", propertyTable.getString("ItemsDependency"));
                    break;
                case "Query":
                    DataTable quereDefHeadTable = document.get("D_ComboBoxQueryDefHead");
                    TagNode queryDefNode = new TagNode("QueryDef", null);
                    TagNode statement = new TagNode("Statement", null);
                    String statementContent = quereDefHeadTable.getString("Statement");
                    statement.setCDataValue(statementContent);
                    queryDefNode.addNode(statement);
                    // 参数列表设置
                    DataTable paraTable = document.get("ED_ParameterCollection");
                    TagNode parameterCollection = new TagNode(MetaParameterCollection.TAG_NAME, null);
                    for (int i = 0; i < paraTable.size(); i++) {
                        String dataType = paraTable.getString(i, ConstantUtil.DATA_TYPE);
                        String p_sourceType = paraTable.getString(i, ConstantUtil.SOURCE_TYPE);
                        String description = paraTable.getString(i, ConstantUtil.DESCRIPTION);
                        String value = paraTable.getString(i, ConstantUtil.VALUE);
                        TagNode parameter = new TagNode(MetaParameter.TAG_NAME, null);
                        parameter.setAttribute(ConstantUtil.DATA_TYPE, dataType);
                        if (!"Formula".equals(p_sourceType)) {
                            parameter.setAttribute(ConstantUtil.SOURCE_TYPE, p_sourceType);
                        }
                        parameter.setAttribute(ConstantUtil.DESCRIPTION, description);
                        parameter.setAttribute(ConstantUtil.VALUE, value);
                        parameterCollection.addNode(parameter);
                    }
                    queryDefNode.addNode(parameterCollection);
                    parentNode.addNode(queryDefNode);
                    parentNode.setAttribute("ItemsDependency", quereDefHeadTable.getString("ItemsDependency"));
                    break;
                case "ParaGroup":
                    String groupKey = propertyTable.getString("GetGroupKey");
                    parentNode.setAttribute("GroupKey", groupKey);
                    break;
            }
            parentNode.setAttribute("SourceType", sourceType);
        }

        DataTable filterPropertyTable = document.get("ED_FilterProperties");
        if(filterPropertyTable != null && filterPropertyTable.first()) {
            int useComboFilter = filterPropertyTable.getInt("IsUseComboFilter");
            if (useComboFilter == 1) {
                TagNode comboFilterNode = new TagNode("ComboFilter", null);
                String filterSourceType = filterPropertyTable.getString("GetFilterSourceType");
                comboFilterNode.setAttribute("Type", filterPropertyTable.getString("GetFilterType"));
                comboFilterNode.setAttribute("SourceType", filterSourceType);
                comboFilterNode.setAttribute("ItemsDependency", "");
                switch (filterSourceType) {
                    case "Items":
                        DataTable itemTable = document.get("ED_ComboFilterDetail");
                        if (itemTable != null && !itemTable.isEmpty()) {
                            itemTable.beforeFirst();
                            while (itemTable.next()) {
                                Boolean extendFlag = itemTable.getBoolean("ExtendFlag");
                                if (extendFlag) {
                                    continue;
                                }
                                TagNode itemNode = new TagNode("Item", null);
                                itemNode.setAttribute("Key", itemTable.getString("Key"));
                                itemNode.setAttribute("Value", itemTable.getString("Value"));
                                itemNode.setAttribute("Caption", itemTable.getString("Caption"));
                                comboFilterNode.addNode(itemNode);
                            }
                        }
                        break;
                    case "Formula":
                        TagNode formulaNode = new TagNode("FormulaItems", null);
                        String formulaContent = filterPropertyTable.getString("GetFilterFormulaItems");
                        formulaNode.setCDataValue(formulaContent);
                        comboFilterNode.addNode(formulaNode);
                        comboFilterNode.setAttribute("ItemsDependency", filterPropertyTable.getString("ItemsDependency"));
                        break;
                    case "Query":
                        DataTable quereDefHeadTable = document.get("D_Filter_ComboBoxQueryDefHead");
                        TagNode queryDefNode = new TagNode("QueryDef", null);
                        TagNode statement = new TagNode("Statement", null);
                        String statementContent = quereDefHeadTable.getString("Statement");
                        statement.setCDataValue(statementContent);
                        queryDefNode.addNode(statement);
                        // 参数列表设置
                        DataTable paraTable = document.get("ED_Filter_ParameterCollection");
                        TagNode parameterCollection = new TagNode(MetaParameterCollection.TAG_NAME, null);
                        for (int i = 0; i < paraTable.size(); i++) {
                            String dataType = paraTable.getString(i, ConstantUtil.DATA_TYPE);
                            String p_sourceType = paraTable.getString(i, ConstantUtil.SOURCE_TYPE);
                            String description = paraTable.getString(i, ConstantUtil.DESCRIPTION);
                            String value = paraTable.getString(i, ConstantUtil.VALUE);
                            TagNode parameter = new TagNode(MetaParameter.TAG_NAME, null);
                            parameter.setAttribute(ConstantUtil.DATA_TYPE, dataType);
                            if (!"Formula".equals(p_sourceType)){
                                parameter.setAttribute(ConstantUtil.SOURCE_TYPE, p_sourceType);
                            }
                            parameter.setAttribute(ConstantUtil.DESCRIPTION, description);
                            parameter.setAttribute(ConstantUtil.VALUE, value);
                            parameterCollection.addNode(parameter);
                        }
                        queryDefNode.addNode(parameterCollection);
                        comboFilterNode.addNode(queryDefNode);
                        comboFilterNode.setAttribute("ItemsDependency", quereDefHeadTable.getString("ItemsDependency"));
                        break;
                }
                parentNode.addNode(comboFilterNode);
            }
        }
        // 直接替换整个父节点
        genXmlDiff(xmlTree, parentNode, diff, true);
    }

    private static void dealCarouselSourceSetting(XmlTreeWithPath xmlTree, Diff diff, Document document, MetaForm metaForm) throws Throwable {
        MetaComponent metaComponent = IOMetaObject.getComponentByKey(metaForm, diff.getKey());

        if (metaComponent != null) {
            String xmlTreeKey = "Carousel@" + diff.getKey();

            TagNode carouselNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
            carouselNode.deleteChildByTagName("Item");
            carouselNode.deleteChildByTagName("FormulaItems");

            DataTable propertyTable = document.get(ConstantUtil.ED_CAROUSEL_PROP);
            if(propertyTable != null && propertyTable.first()) {
                String sourceType = propertyTable.getString("GetSourceType");
                switch (sourceType) {
                    case "Items":
                        DataTable itemTable = document.get(ConstantUtil.ED_CAROUSEL_DETAIL);
                        if (itemTable != null && !itemTable.isEmpty()) {
                            itemTable.beforeFirst();
                            while (itemTable.next()) {
                                TagNode itemNode = new TagNode("Item", null);
                                itemNode.setAttribute("Key", itemTable.getString("Key"));
                                itemNode.setAttribute("Value", itemTable.getString("Value"));
                                itemNode.setAttribute("Caption", itemTable.getString("Caption"));
                                itemNode.setAttribute("Icon", itemTable.getString("Icon"));
                                carouselNode.addNode(itemNode);
                            }
                        }
                        break;
                    case "Formula":
                        TagNode formulaNode = new TagNode("FormulaItems", null);
                        String formulaContent = propertyTable.getString("GetFormulaItems");
                        formulaNode.setCDataValue(formulaContent);
                        carouselNode.addNode(formulaNode);
                        break;
                }

                carouselNode.setAttribute("SourceType", sourceType);
            }

            genXmlDiff(xmlTree, carouselNode, diff, true);
        }
    }

    private static void dealRefreshHeaderSetting(XmlTreeWithPath xmlTree, Diff diff, Document document, MetaForm metaForm) throws Throwable {
        MetaComponent metaComponent = IOMetaObject.getComponentByKey(metaForm, diff.getKey());

        if (metaComponent != null) {
            String xmlTreeKey = "RefreshControl@" + diff.getKey();

            TagNode refreshControlNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
            refreshControlNode.deleteChildByTagName("RefreshHeader");

            DataTable propertyTable = document.get(ConstantUtil.ED_REFRESH_HEADER_PROP);

            if(propertyTable != null && propertyTable.first()) {
                TagNode headerNode = new TagNode("RefreshHeader", null);

                TagNode formatNode = new TagNode("Format", null);
                if (!propertyTable.getString("HAlign").isEmpty()) {
                    formatNode.setAttribute("HAlign", propertyTable.getString("HAlign"));
                }
                if (!propertyTable.getString("VAlign").isEmpty()) {
                    formatNode.setAttribute("VAlign", propertyTable.getString("VAlign"));
                }
                if (!propertyTable.getString("BackColor").isEmpty()) {
                    formatNode.setAttribute("BackColor", propertyTable.getString("BackColor"));
                }
                if (!propertyTable.getString("ForeColor").isEmpty()) {
                    formatNode.setAttribute("ForeColor", propertyTable.getString("ForeColor"));
                }
                if (!propertyTable.getString("HighlightBackColor").isEmpty()) {
                    formatNode.setAttribute("HighlightColor", propertyTable.getString("HighlightBackColor"));
                }

                TagNode fontNode = new TagNode("Font", null);
                if (!propertyTable.getString("Name").isEmpty()) {
                    fontNode.setAttribute("Name", propertyTable.getString("Name"));
                }
                if (!propertyTable.getNumeric("Size").toString().equals("-1")) {
                    fontNode.setAttribute("Size", propertyTable.getNumeric("Size").toString());
                }
                if (!propertyTable.getString("Bold").isEmpty()) {
                    fontNode.setAttribute("Bold", propertyTable.getString("Bold"));
                }
                if (!propertyTable.getString("Italic").isEmpty()) {
                    fontNode.setAttribute("Italic", propertyTable.getString("Italic"));
                }

                if (fontNode.getAttributes().size() > 0) {
                    formatNode.addNode(fontNode);
                    headerNode.addNode(formatNode);
                } else {
                    if (formatNode.getAttributes().size() > 0) {
                        headerNode.addNode(formatNode);
                    }
                }

                String formulaContent = propertyTable.getString("FormulaContent");
                if (formulaContent != null && !formulaContent.isEmpty()) {
                    headerNode.setCDataValue(formulaContent);
                }

                headerNode.setAttribute("Text", propertyTable.getString("Text"));
                headerNode.setAttribute("Icon", propertyTable.getString("Icon"));
                headerNode.setAttribute("IconLocation", propertyTable.getString("IconLocation"));

                DataTable itemTable = document.get(ConstantUtil.ED_REFRESH_HEADER_DETAIL);
                if (itemTable != null && !itemTable.isEmpty()) {
                    itemTable.beforeFirst();
                    while (itemTable.next()) {
                        TagNode stateNode = new TagNode("State", null);
                        stateNode.setAttribute("Text", itemTable.getString("Text"));
                        stateNode.setAttribute("Icon", itemTable.getString("Icon"));
                        stateNode.setAttribute("IconLocation", itemTable.getString("IconLocation"));
                        stateNode.setAttribute("Type", itemTable.getString("Type"));

                        TagNode formatNode2 = new TagNode("Format", null);
                        if (!propertyTable.getString("HAlign").isEmpty()) {
                            formatNode2.setAttribute("HAlign", propertyTable.getString("HAlign"));
                        }
                        if (!propertyTable.getString("VAlign").isEmpty()) {
                            formatNode2.setAttribute("VAlign", propertyTable.getString("VAlign"));
                        }
                        if (!propertyTable.getString("BackColor").isEmpty()) {
                            formatNode2.setAttribute("BackColor", propertyTable.getString("BackColor"));
                        }
                        if (!propertyTable.getString("ForeColor").isEmpty()) {
                            formatNode2.setAttribute("ForeColor", propertyTable.getString("ForeColor"));
                        }
                        if (!propertyTable.getString("HighlightBackColor").isEmpty()) {
                            formatNode2.setAttribute("HighlightColor", propertyTable.getString("HighlightBackColor"));
                        }

                        TagNode fontNode2 = new TagNode("Font", null);
                        if (!propertyTable.getString("Name").isEmpty()) {
                            fontNode2.setAttribute("Name", propertyTable.getString("Name"));
                        }
                        if (!propertyTable.getNumeric("Size").toString().equals("-1")) {
                            fontNode2.setAttribute("Size", propertyTable.getNumeric("Size").toString());
                        }
                        if (!propertyTable.getString("Bold").isEmpty()) {
                            fontNode2.setAttribute("Bold", propertyTable.getString("Bold"));
                        }
                        if (!propertyTable.getString("Italic").isEmpty()) {
                            fontNode2.setAttribute("Italic", propertyTable.getString("Italic"));
                        }

                        if (fontNode.getAttributes().size() > 0) {
                            formatNode2.addNode(fontNode2);
                            stateNode.addNode(formatNode2);
                        } else {
                            if (formatNode2.getAttributes().size() > 0) {
                                stateNode.addNode(formatNode2);
                            }
                        }

                        headerNode.addNode(stateNode);
                    }
                }

                refreshControlNode.addNode(headerNode);
            }

            genXmlDiff(xmlTree, refreshControlNode, diff, true);
        }
    }

    private static void dealRefreshFooterSetting(XmlTreeWithPath xmlTree, Diff diff, Document document, MetaForm metaForm) throws Throwable {
        MetaComponent metaComponent = IOMetaObject.getComponentByKey(metaForm, diff.getKey());

        if (metaComponent != null) {
            String xmlTreeKey = "RefreshControl@" + diff.getKey();

            TagNode refreshControlNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
            refreshControlNode.deleteChildByTagName("RefreshFooter");

            DataTable propertyTable = document.get(ConstantUtil.ED_REFRESH_FOOTER_PROP);

            if(propertyTable != null && propertyTable.first()) {
                TagNode footerNode = new TagNode("RefreshFooter", null);

                TagNode formatNode = new TagNode("Format", null);
                if (!propertyTable.getString("HAlign").isEmpty()) {
                    formatNode.setAttribute("HAlign", propertyTable.getString("HAlign"));
                }
                if (!propertyTable.getString("VAlign").isEmpty()) {
                    formatNode.setAttribute("VAlign", propertyTable.getString("VAlign"));
                }
                if (!propertyTable.getString("BackColor").isEmpty()) {
                    formatNode.setAttribute("BackColor", propertyTable.getString("BackColor"));
                }
                if (!propertyTable.getString("ForeColor").isEmpty()) {
                    formatNode.setAttribute("ForeColor", propertyTable.getString("ForeColor"));
                }
                if (!propertyTable.getString("HighlightBackColor").isEmpty()) {
                    formatNode.setAttribute("HighlightColor", propertyTable.getString("HighlightBackColor"));
                }

                TagNode fontNode = new TagNode("Font", null);
                if (!propertyTable.getString("Name").isEmpty()) {
                    fontNode.setAttribute("Name", propertyTable.getString("Name"));
                }
                if (!propertyTable.getNumeric("Size").toString().equals("-1")) {
                    fontNode.setAttribute("Size", propertyTable.getNumeric("Size").toString());
                }
                if (!propertyTable.getString("Bold").isEmpty()) {
                    fontNode.setAttribute("Bold", propertyTable.getString("Bold"));
                }
                if (!propertyTable.getString("Italic").isEmpty()) {
                    fontNode.setAttribute("Italic", propertyTable.getString("Italic"));
                }

                if (fontNode.getAttributes().size() > 0) {
                    formatNode.addNode(fontNode);
                    footerNode.addNode(formatNode);
                } else {
                    if (formatNode.getAttributes().size() > 0) {
                        footerNode.addNode(formatNode);
                    }
                }

                String formulaContent = propertyTable.getString("FormulaContent");
                if (formulaContent != null && !formulaContent.isEmpty()) {
                    footerNode.setCDataValue(formulaContent);
                }

                refreshControlNode.addNode(footerNode);
            }

            genXmlDiff(xmlTree, refreshControlNode, diff, true);
        }
    }

    private static void dealPriceLabelItemSetting(XmlTreeWithPath xmlTree, Diff diff, Document document, MetaForm metaForm) throws Throwable {
        MetaComponent metaComponent = IOMetaObject.getComponentByKey(metaForm, diff.getKey());

        if (metaComponent != null) {
            String xmlTreeKey = "PriceLabel@" + diff.getKey();

            TagNode priceLabelNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
            priceLabelNode.deleteChildByTagName("PriceItem");

            DataTable detailTable = document.get(ConstantUtil.ED_PRICELABELITEM_DETAIL);
            if(detailTable != null && detailTable.first()) {
                detailTable.beforeFirst();
                while (detailTable.next()) {
                    TagNode itemNode = new TagNode("PriceItem", null);
                    if (!detailTable.getString("Type").isEmpty()) {
                        itemNode.setAttribute("Type", detailTable.getString("Type"));
                    }

                    TagNode formatNode = new TagNode("Format", null);
                    if (!detailTable.getString("HAlign").isEmpty()) {
                        formatNode.setAttribute("HAlign", detailTable.getString("HAlign"));
                    }
                    if (!detailTable.getString("VAlign").isEmpty()) {
                        formatNode.setAttribute("VAlign", detailTable.getString("VAlign"));
                    }
                    if (!detailTable.getString("BackColor").isEmpty()) {
                        formatNode.setAttribute("BackColor", detailTable.getString("BackColor"));
                    }
                    if (!detailTable.getString("ForeColor").isEmpty()) {
                        formatNode.setAttribute("ForeColor", detailTable.getString("ForeColor"));
                    }
                    if (!detailTable.getString("HighlightBackColor").isEmpty()) {
                        formatNode.setAttribute("HighlightColor", detailTable.getString("HighlightBackColor"));
                    }

                    TagNode fontNode = new TagNode("Font", null);
                    if (!detailTable.getString("Name").isEmpty()) {
                        fontNode.setAttribute("Name", detailTable.getString("Name"));
                    }
                    if (!detailTable.getNumeric("Size").toString().equals("-1")) {
                        fontNode.setAttribute("Size", detailTable.getNumeric("Size").toString());
                    }
                    if (!detailTable.getString("Bold").isEmpty()) {
                        fontNode.setAttribute("Bold", detailTable.getString("Bold"));
                    }
                    if (!detailTable.getString("Italic").isEmpty()) {
                        fontNode.setAttribute("Italic", detailTable.getString("Italic"));
                    }

                    if (fontNode.getAttributes().size() > 0) {
                        formatNode.addNode(fontNode);
                        itemNode.addNode(formatNode);
                    } else {
                        if (formatNode.getAttributes().size() > 0) {
                            itemNode.addNode(formatNode);
                        }
                    }

                    priceLabelNode.addNode(itemNode);
                }
            }

            genXmlDiff(xmlTree, priceLabelNode, diff, true);
        }
    }


    private static void dealRowActionCollection(XmlTreeWithPath xmlTree, Diff diff, DataTable table, MetaForm metaForm) throws Throwable {
        MetaComponent metaComponent = null;
        TagNode rowNode = null;

        if (diff.getControlType() == ControlType.TABLEVIEW) {
            String xmlTreeKey = "TableRow@" + diff.getKey();
            rowNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
        } else {
            metaComponent = IOMetaObject.getComponentByKey(metaForm, diff.getKey());
            if (metaComponent != null) {
                if (metaComponent.getControlType() == ControlType.EDITVIEW) {
                    String xmlTreeKey = "EditView@" + diff.getKey();
                    TagNode editViewNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
                    rowNode = editViewNode.getOrCreateChildByTagName("EditViewRow");
                }
            }
        }

        if (rowNode != null) {
            rowNode.deleteChildByTagName("RowActionCollection");
            if (!table.isEmpty()) {
                TagNode actionsNode = new TagNode("RowActionCollection", null);
                for (int i = 0; i < table.size(); i++) {
                    String key = table.getString(i, "Key");
                    String caption = table.getString(i, ConstantUtil.CAPTION);
                    String expression = table.getString(i, ConstantUtil.EXPRESSION);
                    TagNode trace = new TagNode("RowAction", null);
                    trace.setAttribute(ConstantUtil.CAPTION, caption);
                    trace.setAttribute("Key", key);
                    trace.setCDataValue(expression);
                    actionsNode.addNode(trace);
                }
                rowNode.addNode(actionsNode);
            }
            genXmlDiff(xmlTree, rowNode.getParent(), diff, true);
        }

    }

    private static void dealEditViewItemCollectionSetting(XmlTreeWithPath xmlTree, Diff diff, Document document, MetaForm metaForm) throws Throwable {
        MetaComponent metaComponent = IOMetaObject.getComponentByKey(metaForm, diff.getKey());

        if (metaComponent != null) {
            String xmlTreeKey = "EditView@" + diff.getKey();

            TagNode editViewNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
            editViewNode.deleteChildByTagName("EditViewItem");
            editViewNode.deleteChildByTagName("FormulaItems");

            DataTable propertyTable = document.get(ConstantUtil.ED_EDITVIEW_ITEMS_PROP);
            if(propertyTable != null && propertyTable.first()) {
                TagNode formulaNode = new TagNode("FormulaItems", null);
                String formulaContent = propertyTable.getString("GetFormulaItems");
                formulaNode.setCDataValue(formulaContent);
                editViewNode.addNode(formulaNode);
            }

            DataTable itemTable = document.get(ConstantUtil.ED_EDITVIEW_ITEMS_DETAIL);
            if (itemTable != null && !itemTable.isEmpty()) {
                itemTable.beforeFirst();
                while (itemTable.next()) {
                    TagNode itemNode = new TagNode("EditViewItem", null);
                    itemNode.setAttribute("Key", itemTable.getString("Key"));
                    itemNode.setAttribute("Caption", itemTable.getString("Caption"));
                    itemNode.setAttribute("Image", itemTable.getString("Image"));
                    itemNode.setAttribute("ImageScaleType", itemTable.getString("ImageScaleType"));
                    editViewNode.addNode(itemNode);
                }
            }

            genXmlDiff(xmlTree, editViewNode, diff, true);
        }
    }


    private static void dealExtOptCollection(XmlTreeWithPath xmlTree, Diff diff, DataTable table, MetaForm metaForm) throws Throwable {
        String componentKey = diff.getKey();
        MetaGrid metaComponent = (MetaGrid) IOMetaObject.getComponentByKey(metaForm, diff.getKey());
        String tagName = metaComponent.getTagName();
        String xmlTreeKey = getXmlTreeKey(diff, tagName, componentKey);
        // 父节点
        TagNode parentNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
        // 将父节点中的节点直接删除再重新添加
        parentNode.deleteChildByTagName("ExtOptCollection");

        if (table.size() > 0) {
            TagNode operationSet = new TagNode("ExtOptCollection", null);
            for (int i = 0; i < table.size(); i++) {
                String icon = table.getString(i, "Icon");
                String caption = table.getString(i, ConstantUtil.CAPTION);
                String expression = table.getString(i, ConstantUtil.EXPRESSION);
                TagNode trace = new TagNode("ExtOpt", null);
                trace.setAttribute(ConstantUtil.CAPTION, caption);
                trace.setAttribute("Icon", icon);
                trace.setCDataValue(expression);
                operationSet.addNode(trace);
            }
            parentNode.addNode(operationSet);
        }
        // 直接替换整个父节点
        genXmlDiff(xmlTree, parentNode, diff, true);
    }

    private static void dealTraceCollection(XmlTreeWithPath xmlTree, Diff diff, DataTable table, MetaForm metaForm) throws Throwable {
        String componentKey = diff.getKey();
        MetaGrid metaComponent = (MetaGrid) IOMetaObject.getComponentByKey(metaForm, diff.getKey());
        String tagName = metaComponent.getTagName();
        String xmlTreeKey = getXmlTreeKey(diff, tagName, componentKey);
        // 父节点
        TagNode parentNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
        // 将父节点中的TraceCollection节点直接删除再重新添加
        parentNode.deleteChildByTagName("TraceCollection");

        if (table.size() > 0) {
            TagNode traceCollection = new TagNode("TraceCollection", null);
            for (int i = 0; i < table.size(); i++) {
                String condition = table.getString(i, ConstantUtil.CONDITION);
                String caption = table.getString(i, ConstantUtil.CAPTION);
                String expression = table.getString(i, ConstantUtil.EXPRESSION);
                TagNode trace = new TagNode("Trace", null);
                trace.setAttribute(ConstantUtil.CAPTION, caption);
                trace.setAttribute(ConstantUtil.CONDITION, condition);
                trace.setCDataValue(expression);
                traceCollection.addNode(trace);
            }
            parentNode.addNode(traceCollection);
        }
        // 直接替换整个父节点
        genXmlDiff(xmlTree, parentNode, diff, true);
    }


    private static void dealHeadCondition(XmlTreeWithPath xmlTree, DataTable headCondition, DataTable cuscollTable, DataTable tarCollTable, TagNode fieldNode, Diff diff, TagNode parentNode, DataTable cuscollTableSon) throws Throwable {
        if (headCondition.size() == 0) {
            return;
        }
        int state = headCondition.getState();

        TagNode condNode = fieldNode.getOrCreateChildByTagName("Condition");
        Integer condSign = headCondition.getInt(ConstantUtil.COND_SIGN);
        if (condSign == -11) {
            // 将整个父节点替换掉
            fieldNode.deleteChildByTagName("Condition");
            genXmlDiff(xmlTree, parentNode, diff, true);
            return;
        }
        String condTableKey = headCondition.getString("TableKey");
        String condColumnKey = headCondition.getString("ColumnKey");
        String group = headCondition.getString("Group");
        String groupHead = headCondition.getString("GroupHead");
        String groupTail = headCondition.getString("GroupTail");
        String limitToSource = headCondition.getString("LimitToSource");
        String target = headCondition.getString("Target");
        String tag = headCondition.getString(ConstantUtil.TAG);
        String impl = headCondition.getString("Impl");
        String needReset = headCondition.getString("NeedReset");
        String loadHistoryInput = headCondition.getString("LoadHistoryInput");
        String onlyFilter = headCondition.getString("OnlyFilter");
        if (RowState.MODIFIED == state) {
            if (Objects.isNull(condNode.getElement())) {  //新增
                condNode.setAttribute(ConstantUtil.COND_SIGN, CondSign.toString(condSign));
                condNode.setAttribute(ConstantUtil.TABLE_KEY, StringUtils.isNotEmpty(condTableKey) ? condTableKey : "");
                condNode.setAttribute(ConstantUtil.COLUMN_KEY, StringUtils.isNotEmpty(condColumnKey) ? condColumnKey : "");
                condNode.setAttribute("Group", StringUtils.isNotEmpty(group) ? group : "");
                condNode.setAttribute("GroupHead", StringUtils.isNotEmpty(groupHead) ? groupHead : "");
                condNode.setAttribute("GroupTail", StringUtils.isNotEmpty(groupTail) ? groupTail : "");
                condNode.setAttribute("LimitToSource", StringUtils.isNotEmpty(limitToSource) ? limitToSource : "");
                final String useAdvancedQuery = headCondition.getString("UseAdvancedQuery");
                condNode.setAttribute("UseAdvancedQuery", StringUtils.isNotEmpty(useAdvancedQuery) ? useAdvancedQuery : "false");
                condNode.setAttribute("Target", StringUtils.isNotEmpty(target) ? target : "");
                condNode.setAttribute(ConstantUtil.TAG, StringUtils.isNotEmpty(tag) ? tag : "");
                condNode.setAttribute("Impl", StringUtils.isNotEmpty(impl) ? impl : "");
                condNode.setAttribute("NeedReset", StringUtils.isNotEmpty(needReset) ? needReset : "");
                condNode.setAttribute("LoadHistoryInput", StringUtils.isNotEmpty(loadHistoryInput) ? loadHistoryInput : "");
                condNode.setAttribute("OnlyFilter", StringUtils.isNotEmpty(onlyFilter) ? onlyFilter : "");
            } else {
                condNode.setAttribute(ConstantUtil.COND_SIGN, CondSign.toString(condSign));
                condNode.setAttribute(ConstantUtil.TABLE_KEY, condTableKey);
                condNode.setAttribute(ConstantUtil.COLUMN_KEY, condColumnKey);
                condNode.setAttribute("Group", group);
                condNode.setAttribute("GroupHead", groupHead);
                condNode.setAttribute("GroupTail", groupTail);
                condNode.setAttribute("LimitToSource", limitToSource);
                final String useAdvancedQuery = headCondition.getString("UseAdvancedQuery");
                condNode.setAttribute("UseAdvancedQuery", StringUtils.isNotEmpty(useAdvancedQuery) ? useAdvancedQuery : "false");
                condNode.setAttribute("Target", target);
                condNode.setAttribute(ConstantUtil.TAG, tag);
                condNode.setAttribute("Impl", impl);
                condNode.setAttribute("NeedReset", needReset);
                if ("true".equalsIgnoreCase(condNode.getAttributes().get("NeedReset"))) {
                    condNode.getAttributes().remove("NeedReset");
                }
                condNode.setAttribute("LoadHistoryInput", loadHistoryInput);
                condNode.setAttribute("OnlyFilter", onlyFilter);
            }
        }
        // 将整个父节点替换掉
        dealSonTable(fieldNode, cuscollTable, tarCollTable, condSign, cuscollTableSon);
        genXmlDiff(xmlTree, parentNode, diff, true);
    }

    private static void dealSonTable(TagNode fieldNode,
                                     DataTable cuscollTable, DataTable tarCollTable, int condSign, DataTable cuscollTableSon) throws Throwable {
        cuscollTable.setShowDeleted(false);
        TagNode condNode = fieldNode.getOrCreateChildByTagName("Condition");
        condNode.deleteChildByTagName("CustomCondition");
        condNode.deleteChildByTagName("ConditionTarget");
        condNode.deleteChildByTagName(MetaCustomConditionPara.TAG_NAME);
        if (condSign == 8) {
            for (int i = 0; i < cuscollTable.size(); i++) {
                TagNode customNode = new TagNode("CustomCondition", null);
                customNode.setAttribute("Condition", cuscollTable.getString(i, "Condition"));
                customNode.setAttribute("Filter", cuscollTable.getString(i, "Filter"));
                customNode.setAttribute("MultiPara", String.valueOf(cuscollTable.getInt(i, "IsMultiPara")));
                customNode.setAttribute("Seperator", cuscollTable.getString(i, "Seperator"));
                String oid1 = String.valueOf(cuscollTable.getLong(i, "OID"));
                for (int j = 0; j < cuscollTableSon.size(); j++) {
                    String poid = String.valueOf(cuscollTableSon.getLong(j, "POID"));
                    if (!oid1.equalsIgnoreCase(poid)) {
                        continue;
                    }
                    TagNode customConditionPara = new TagNode(MetaCustomConditionPara.TAG_NAME, null);
                    customConditionPara.setAttribute(ConstantUtil.KEY, cuscollTableSon.getString(j, "ParaKey"));
                    if (cuscollTableSon.getString(j, "ParaFormula") != null && !cuscollTableSon.getString(j, "ParaFormula").isEmpty()) {
                        customConditionPara.setAttribute("Formula", cuscollTableSon.getString(j, "ParaFormula"));
                    }
                    customNode.addNode(customConditionPara);
                }
                condNode.addNode(customNode);
            }
        }
        for (int i = 0; i < tarCollTable.size(); i++) {
            TagNode targetNode = new TagNode("ConditionTarget", null);
            targetNode.setAttribute(ConstantUtil.TABLE_KEY, tarCollTable.getString(i, ConstantUtil.TARGET_TABLE_KEY));
            targetNode.setAttribute(ConstantUtil.COLUMN_KEY, tarCollTable.getString(i, "TargetColumnKey"));
            targetNode.setAttribute("Target", tarCollTable.getString(i, ConstantUtil.TARGET_FIELD));
            condNode.addNode(targetNode);
        }
    }

    public static void dealEventTable(XmlTreeWithPath xmlTree, Document document, Diff diff) throws Throwable {
        // 从document中获取事件表单
        DataTable preLoadTable = document.get(ConstantUtil.TBL_PRE_LOAD_PROCESS);
        DataTable postLoadTable = document.get(ConstantUtil.TBL_POST_LOAD_PROCESS);
        DataTable preSaveTable = document.get(ConstantUtil.TBL_PRE_SAVE_PROCESS);
        DataTable postSaveTable = document.get(ConstantUtil.TBL_POST_SAVE_PROCESS);
        DataTable preDeleteTable = document.get(ConstantUtil.TBL_PRE_DELETE_PROCESS);
        DataTable postDeleteTable = document.get(ConstantUtil.TBL_POST_DELETE_PROCESS);
        DataTable statusCollectionTable = document.get(ConstantUtil.TBL_STATUS_COLLECTION);
        DataTable statusTriggerCollectionTable = document.get(ConstantUtil.TBL_STATUS_TRIGGER_COLLECTION);
        DataTable extendCollectionTable = document.get(ConstantUtil.TBL_EXTEND_COLLECTION);
        DataTable checkRuleCollectionTable = document.get(ConstantUtil.TBL_CHECK_RULE_COLLECTION);
        DataTable macroCollectionTable = document.get(ConstantUtil.TBL_MACRO_COLLECTION);

        List<TagNode> dataSource = xmlTree.xmlTree.getRoot().findNodesByTagName(ConstantUtil.DATA_SOURCE);
        List<TagNode> dataObject = xmlTree.xmlTree.getRoot().findNodesByTagName(ConstantUtil.DATA_OBJECT);

        if (dataSource.size() == 0 && dataObject.size() == 0) { // 无数据对象
            return;
        }
        if (dataSource.size() < 1 || !(dataSource.get(0).hasAttribute("RefObjectKey"))) {
            String dataObjectKey = diff.formKey;
            String reserveOne = diff.getReserveOne();
            TagNode parentNode = dataObject.get(0);

            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
            MetaDataObjectProfile metaDataObjectProfile = dataObjectList.get(dataObjectKey);
            String extend = Objects.nonNull(metaDataObjectProfile) ? metaDataObjectProfile.getExtend() : "";
            if (!(StringUtils.equals(reserveOne, "DataObject") && StringUtils.isNotBlank(extend))) {
                dealEventNode(preLoadTable, MetaPreLoadProcess.TAG_NAME, parentNode, Collections.emptyList(), "Load");
                dealEventNode(postLoadTable, MetaPostLoadProcess.TAG_NAME, parentNode, Collections.emptyList(), "Load");
                dealEventNode(preSaveTable, MetaPreSaveProcess.TAG_NAME, parentNode, Collections.emptyList(), "Save");
                dealEventNode(postSaveTable, MetaPostSaveProcess.TAG_NAME, parentNode, Collections.emptyList(), "Save");
                dealEventNode(preDeleteTable, MetaPreDeleteProcess.TAG_NAME, parentNode, Collections.emptyList(), "Delete");
                dealEventNode(postDeleteTable, MetaPostDeleteProcess.TAG_NAME, parentNode, Collections.emptyList(), "Delete");
                dealEventNode(statusCollectionTable, MetaStatusCollection.TAG_NAME, parentNode, Collections.emptyList(), "");
                dealEventNode(statusTriggerCollectionTable, MetaStatusTriggerCollection.TAG_NAME, parentNode, Collections.emptyList(), "");
                dealEventNode(extendCollectionTable, MetaExtendCollection.TAG_NAME, parentNode, Collections.emptyList(), "");
                dealEventNode(macroCollectionTable, MetaMacroCollection.TAG_NAME, parentNode, Collections.emptyList(), "");
            }

            if (StringUtils.isBlank(extend) && Objects.nonNull(metaDataObjectProfile)) {
                extend = metaDataObjectProfile.getDataObject().getMergeToSourceMapKey();
            }
            List<String> extendCheckRuleKeyList = new ArrayList<>();
            if (StringUtils.isNotBlank(extend)) {
                String xmlFilePath = LoadFileTree.getPathByDataObject(extend);
                String tempXmlFilePath = XmlFileProcessor.instance.getTmpFile(xmlFilePath);
                String filePath = StringUtils.isNotBlank(tempXmlFilePath) ? tempXmlFilePath : xmlFilePath;

                XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(filePath);
                if (Objects.nonNull(xmlTreeWithPath)) {
                    TagNode rootNode = xmlTreeWithPath.xmlTree.getRoot();
                    TagNode checkRuleCollectionNode = rootNode.getChildByTagName(MetaCheckRuleCollection.TAG_NAME);
                    if (Objects.nonNull(checkRuleCollectionNode)) {
                        List<TagNode> checkRuleNodeList = checkRuleCollectionNode.findNodesByTagName(ConstantUtil.CHECK_RULE);
                        for (TagNode tagNode : checkRuleNodeList) {
                            String errorInfo = tagNode.getAttributes().get("ErrorInfo");
                            extendCheckRuleKeyList.add(errorInfo);
                        }
                    }
                }
            }
            dealEventNode(checkRuleCollectionTable, MetaCheckRuleCollection.TAG_NAME, parentNode, extendCheckRuleKeyList, "");
        }
        dealOIDFilterNode(document, xmlTree);// 引用数据对象对当前表单处理OIDFilter
        genXmlDiff(xmlTree, xmlTree.xmlTree.getRoot(), diff, true);

    }

    private static void dealEventNode(DataTable dataTable, String nodeName, TagNode parentNode, List<String> existKeyList, String prefix) {
        parentNode.deleteChildByTagName(nodeName);
        // 直接删除节点重新添加
        if (dataTable.size() > 0) {
            if (nodeName.contains(MetaProcess.TAG_NAME)) { // Process的通用处理
                TagNode eventSet = new TagNode(nodeName, null);
                for (int i = 0; i < dataTable.size(); i++) {
                    String description = dataTable.getString(i, prefix + ConstantUtil.DESCRIPTION);
                    String content = dataTable.getString(i, prefix + ConstantUtil.SCRIPT);
                    TagNode event = new TagNode(MetaProcess.TAG_NAME, null);
                    event.setAttribute(ConstantUtil.DESCRIPTION, description);
                    event.setCDataValue(content);
                    eventSet.addNode(event);
                }
                parentNode.addNode(eventSet);
            } else if (MetaStatusCollection.TAG_NAME.equals(nodeName)) { // 状态集合
                TagNode eventSet = new TagNode(nodeName, null);
                for (int i = 0; i < dataTable.size(); i++) {
                    String key = dataTable.getString(i, "Key");
                    String caption = dataTable.getString(i, "Caption");
                    Integer value = dataTable.getInt(i, "StatusValue");
                    Boolean isStandalone = dataTable.getBoolean(i, "IsStandalone");
                    TagNode event = new TagNode(MetaStatus.TAG_NAME, null);
                    event.setAttribute(ConstantUtil.KEY, key);
                    event.setAttribute(ConstantUtil.CAPTION, caption);
                    if (value != -1){
                        event.setAttribute(ConstantUtil.VALUE, value.toString());
                    }

                    event.setAttribute(ConstantUtil.STANDALONE, String.valueOf(isStandalone));
                    eventSet.addNode(event);
                }
                parentNode.addNode(eventSet);
            } else if (MetaStatusTriggerCollection.TAG_NAME.equals(nodeName)) { // 状态触发器
                TagNode eventSet = new TagNode(nodeName, null);
                for (int i = 0; i < dataTable.size(); i++) {
                    String key = dataTable.getString(i, "Key");
                    String content = dataTable.getString(i, "Content");
                    TagNode event = new TagNode(MetaStatusTrigger.TAG_NAME, null);
                    event.setAttribute("StatusKey", key);
                    event.setCDataValue(content);
                    eventSet.addNode(event);
                }
                parentNode.addNode(eventSet);
            } else if (MetaExtendCollection.TAG_NAME.equals(nodeName)) { // 扩展类集合
                TagNode eventSet = new TagNode(nodeName, null);
                for (int i = 0; i < dataTable.size(); i++) {
                    String className = dataTable.getString(i, "ClassName");
                    String alias = dataTable.getString(i, "Alias");
                    TagNode event = new TagNode(MetaExtend.TAG_NAME, null);
                    event.setAttribute("Alias", alias);
                    event.setAttribute("Class", className);
                    eventSet.addNode(event);
                }
                parentNode.addNode(eventSet);
            } else if (MetaCheckRuleCollection.TAG_NAME.equals(nodeName)) { // 检查规则
                TagNode eventSet = new TagNode(nodeName, null);
                List<TagNode> eventNodeList = new ArrayList<>();
                List<String> keyList = new ArrayList<>();
                for (int i = 0; i < dataTable.size(); i++) {
                    String errorInfo = dataTable.getString(i, "ErrorInfo");
                    if (dataTable.getState(i) == RowState.NEW && existKeyList.contains(errorInfo)) {
                        throw new RuntimeException("warning: 检查规则重复定义!");
                    }
                    if (existKeyList.contains(errorInfo)) {
                        keyList.add(errorInfo);
                        continue;
                    }
                    if (keyList.contains(errorInfo)) {
                        throw new RuntimeException("warning: 检查规则重复定义!");
                    }
                    keyList.add(errorInfo);
                    String script = dataTable.getString(i, "CheckRuleScript");
                    TagNode event = new TagNode(MetaCheckRule.TAG_NAME, null);
                    eventNodeList.add(event);
                    event.setAttribute("ErrorInfo", errorInfo);
                    event.setCDataValue(script);
                }
                if (CollectionUtils.isNotEmpty(eventNodeList)) {
                    for (TagNode tagNode : eventNodeList) {
                        eventSet.addNode(tagNode);
                    }
                    parentNode.addNode(eventSet);
                }
            } else if (MetaMacroCollection.TAG_NAME.equals(nodeName)) { // 宏公式列表
                TagNode eventSet = new TagNode(nodeName, null);
                for (int i = 0; i < dataTable.size(); i++) {
                    String key = dataTable.getString(i, "Key");
                    String args = dataTable.getString(i, "Args");
                    String content = dataTable.getString(i, "Content");
                    TagNode event = new TagNode(MetaMacro.TAG_NAME, null);
                    event.setAttribute(ConstantUtil.KEY, key);
                    event.setAttribute(ConstantUtil.ARGS, args);
                    event.setCDataValue(content);
                    eventSet.addNode(event);
                }
                parentNode.addNode(eventSet);
            }
        }
    }

    private static void dealOIDFilterNode(Document document, XmlTreeWithPath xmlTree) {
        if (xmlTree.xmlTree.getRoot().findNodesByTagName(ConstantUtil.DATA_SOURCE).size() == 0) {
            return; // 数据对象源代码中没有DataSource
        }
        TagNode dataSource = xmlTree.xmlTree.getRoot().findNodesByTagName(ConstantUtil.DATA_SOURCE).get(0);
        dataSource.deleteChildByTagName(MetaOIDFilter.TAG_NAME);
        DataTable oidFilter = document.get(ConstantUtil.TBL_OID_FILTER);
        if (oidFilter.size() > 0) {
            String filterType = oidFilter.getString(0, "Type");
            TagNode eventSet = new TagNode(MetaOIDFilter.TAG_NAME, null);
            eventSet.setAttribute(ConstantUtil.TYPE, filterType);
            switch (filterType) {
                case "Formula":
                    String filterFormula = oidFilter.getString(0, "Formula");
                    eventSet.setAttribute("Formula", filterFormula);
                    break;
                case "Interface":
                    String filterInterface = oidFilter.getString(0, "Interface");
                    eventSet.setAttribute("Impl", filterInterface);
                    break;
                case "Query":
                    DataTable parameterCollection = document.get("ED_ParameterCollection");
                    TagNode statement = new TagNode(ConstantUtil.STATEMENT, null);
                    String sql = oidFilter.getString(0, "Sql");
                    sql = StringUtils.isBlank(sql) ? "" : sql;
                    statement.setCDataValue(sql);
                    eventSet.addNode(statement);
                    TagNode parameterCollectionNode = new TagNode(MetaParameterCollection.TAG_NAME, null);
                    for (int i = 0; i < parameterCollection.size(); i++) {
                        String ofDataType = parameterCollection.getString(i, "DataType");
                        String ofSourceType = parameterCollection.getString(i, "SourceType");
                        String ofValue = parameterCollection.getString(i, "Value");
                        String ofDescription = parameterCollection.getString(i, "Description");
                        TagNode parameterNode = new TagNode(MetaParameter.TAG_NAME, null);
                        parameterNode.setAttribute(ConstantUtil.DATA_TYPE, ofDataType);
                        parameterNode.setAttribute("SourceType", ofSourceType);
                        parameterNode.setAttribute(ConstantUtil.VALUE, ofValue);
                        parameterNode.setAttribute(ConstantUtil.DESCRIPTION, ofDescription);
                        parameterCollectionNode.addNode(parameterNode);
                    }
                    eventSet.addNode(parameterCollectionNode);
                    break;
            }
            dataSource.addNode(eventSet);
        }
    }

    public static void dealHeadTable(XmlTreeWithPath xmlTree, DataTable headTable, DataTable collecTable, DataTable fieldTable, DataTable ed_parameterCollection, DataTable ed_indexCollection, Diff diff) throws Throwable {
        TagNode rootNode = xmlTree.xmlTree.getRoot();
        List<TagNode> dataSourceNodeList = rootNode.findNodesByTagName(ConstantUtil.DATA_SOURCE);
        List<TagNode> dataObjectNodeList = rootNode.findNodesByTagName(ConstantUtil.DATA_OBJECT);

        if (CollectionUtils.isEmpty(dataSourceNodeList) && CollectionUtils.isEmpty(dataObjectNodeList)) {
            // 将整个父节点替换掉
            XmlDiffProcessor.genXmlDiff(xmlTree, rootNode, diff, true);
            return;
        }

        TagNode dataObjectNode;
        if (CollectionUtils.isNotEmpty(dataObjectNodeList)) {
            dataObjectNode = dataObjectNodeList.get(0);
        } else {
            String refObjectKey = dataSourceNodeList.get(0).getAttributes().get("RefObjectKey");
            String filePath = LoadFileTree.loadFilePathByDataObjectFieldKey(refObjectKey);
            XmlTreeWithPath dataObjectXmlTree = XmlTreeWithPath.parseFilePath(filePath);
            dataObjectNode = dataObjectXmlTree.xmlTree.getRoot().findNodesByTagName(MetaObjectType.DataObject.name).get(0);
        }

        MetaDataObject curDataObject = Objects.nonNull(diff.getDataObject()) ? DataObjectHelper.loadByKey(diff.getDataObject().getKey()) : null;
        String mainTableKey = XmlDiffProcessor.getMainTableKey(collecTable);

        //	if (RowState.MODIFIED == state) {
        for (int i = 0; i < headTable.size(); i++) {
            String auxiliaryType = headTable.getString("AuxiliaryType");
            if (auxiliaryType.equalsIgnoreCase(DataObjectSecondaryType.STR_MIGRATION) && StringUtils.isBlank(mainTableKey)) {
                throw new Throwable("迁移表必须存在主表");
            }

            String mainTable = headTable.getString(i, "MainTable");
            if (StringUtils.isBlank(mainTableKey)) {
                mainTable = "";
            }

            dataObjectNode.setAttribute(ConstantUtil.KEY, headTable.getString(i, "Mark"));
            dataObjectNode.setAttribute(ConstantUtil.PRIMARY_TABLE_KEY, mainTable); // 没有主表不设置mainTable
            String reserveOne = diff.getReserveOne();
            String extend = rootNode.getAttributes().get(ConstantUtil.EXTEND);
            if (!StringUtils.equals(reserveOne, "DataObject") || StringUtils.isBlank(extend)) {
                String mainType = headTable.getString(i, "MainType");
                if ("Virtual".equals(mainType)) {
                    dataObjectNode.setAttribute("PrimaryType", null);
                    dataObjectNode.setAttribute("SecondaryType", null);
                    dataObjectNode.setAttribute("QueryFields", null);
                    dataObjectNode.setAttribute("DisplayFields", null);
                } else {
                    dataObjectNode.setAttribute("PrimaryType", mainType);
                }

                dataObjectNode.setAttribute(ConstantUtil.CAPTION, headTable.getString(i, ConstantUtil.CAPTION));
                dataObjectNode.setAttribute("LoadRightsType", headTable.getString(i, "LoadRightsType"));
                dataObjectNode.setAttribute("CheckAfterLoad", headTable.getString(i, "CheckAfterLoad"));
                dataObjectNode.setAttribute("MaintainDict", headTable.getString(i, "MaintainDict"));
                dataObjectNode.setAttribute("SecondaryType", auxiliaryType);
                if (auxiliaryType.equalsIgnoreCase(DataObjectSecondaryType.STR_MIGRATION)) {
                    String migrationUpdateStrategy = headTable.getString(i, "MigrationUpdateStrategy");
                    if (StringUtils.isBlank(migrationUpdateStrategy)) {
                        migrationUpdateStrategy = "InsertFast";
                    }
                    dataObjectNode.setAttribute("MigrationUpdateStrategy", migrationUpdateStrategy);
                }
                if ("Dict".equalsIgnoreCase(auxiliaryType) || "ChainDict".equalsIgnoreCase(auxiliaryType)) {
                    dataObjectNode.setAttribute("DisplayFields", headTable.getString(i, "DisplayFields"));
                    dataObjectNode.setAttribute("QueryFields", headTable.getString(i, "QueryFields"));
                } else {
                    dataObjectNode.setAttribute("DisplayFields", null);
                    dataObjectNode.setAttribute("QueryFields", null);
                }
            } else {
                dataObjectNode.setAttribute("LoadRightsType", headTable.getString(i, "LoadRightsType"));
                dataObjectNode.setAttribute("CheckAfterLoad", headTable.getString(i, "CheckAfterLoad"));
            }

            if (StringUtils.equals(reserveOne, "DataObject") && StringUtils.isNotBlank(extend)) {
                if ("Dict".equalsIgnoreCase(auxiliaryType) || "ChainDict".equalsIgnoreCase(auxiliaryType)) {
                    String extendPath = LoadFileTree.getPathByDataObject(extend);
                    String extendTmpPath = XmlFileProcessor.instance.getTmpFile(extendPath);
                    String realExtendPath = StringUtils.isNotBlank(extendTmpPath) ? extendTmpPath : extendPath;
                    XmlTree extendXmlTree = Xml4jUtil.parseTree(realExtendPath);
                    TagNode extendNode = extendXmlTree.getTagNode(ConstantUtil.DATA_OBJECT + "@" + extend);
                    Map<String, String> extendAttributes = extendNode.getAttributes();

                    String extendDisplayFields = extendAttributes.getOrDefault("DisplayFields", "");
                    String extendDisplayFields2 = RegExUtils.replaceAll(extendDisplayFields, "\\s*", "");
                    extendDisplayFields2 = RegExUtils.replaceAll(extendDisplayFields2, ";", "");

                    String displayFields = headTable.getString(i, "DisplayFields");
                    displayFields = Objects.isNull(displayFields) ? "" : displayFields;
                    String displayFields2 = RegExUtils.replaceAll(displayFields, "\\s*", "");
                    displayFields2 = RegExUtils.replaceAll(displayFields2, ";", "");

                    if (!StringUtils.equals(displayFields2, extendDisplayFields2) && !(StringUtils.isBlank(extendDisplayFields) && StringUtils.equals(displayFields2, "CodeName"))) {
                        Map<String, String> attributes = dataObjectNode.getAttributes();
                        attributes.put("DisplayFields", displayFields);
                    } else {
                        dataObjectNode.setAttribute("DisplayFields", null);
                    }

                    String extendQueryFields = extendAttributes.getOrDefault("QueryFields", "");
                    String extendQueryFields2 = RegExUtils.replaceAll(extendQueryFields, "\\s*", "");
                    extendQueryFields2 = RegExUtils.replaceAll(extendQueryFields2, ";", "");

                    String queryFields = headTable.getString(i, "QueryFields");
                    queryFields = Objects.isNull(queryFields) ? "" : queryFields;
                    String queryFields2 = RegExUtils.replaceAll(queryFields, "\\s*", "");
                    queryFields2 = RegExUtils.replaceAll(queryFields2, ";", "");

                    if (!StringUtils.equals(queryFields2, extendQueryFields2) && !StringUtils.equals(queryFields2, extendDisplayFields2)) {
                        Map<String, String> attributes = dataObjectNode.getAttributes();
                        attributes.put("QueryFields", queryFields);
                    } else {
                        dataObjectNode.setAttribute("QueryFields", null);
                    }
                } else {
                    dataObjectNode.setAttribute("DisplayFields", null);
                    dataObjectNode.setAttribute("QueryFields", null);
                }
            }

            XmlDiffProcessor.dealCollecTable(xmlTree, collecTable, fieldTable, diff, ed_parameterCollection, ed_indexCollection, curDataObject);
            if (StringUtils.equalsAnyIgnoreCase(auxiliaryType, DataObjectSecondaryType.STR_NORMAL, DataObjectSecondaryType.STR_MIGRATION)) {
                TagNode tagNode = xmlTree.xmlTree.getTagNode("Table@" + mainTable);
                if (Objects.isNull(tagNode)) {
                    XmlDiffProcessor.genXmlDiff(xmlTree, dataObjectNode, diff, true);
                    return;
                }
            } else if (StringUtils.equalsAnyIgnoreCase(auxiliaryType, DataObjectSecondaryType.STR_CHAINDICT, DataObjectSecondaryType.STR_DICT)) {
                TagNode tagNode = xmlTree.xmlTree.getTagNode("Table@" + mainTable);
                if (Objects.isNull(tagNode)) {
                    XmlDiffProcessor.genXmlDiff(xmlTree, dataObjectNode, diff, true);
                    return;
                }
                if (!StringUtils.equals(reserveOne, "DataObject") || StringUtils.isBlank(extend)) {
                    if (Objects.nonNull(diff.getMetaForm()) && StringUtils.isNotBlank(extend)) {
                        if (StringUtils.isNotBlank(diff.getMetaForm().getDataSource().getRefObjectKey())) {
                            DICT_HEAD_TABLE_COLUMN_LIST.forEach(columnMap -> addColumnNode(tagNode, columnMap));
                        }
                    } else {
                        DICT_HEAD_TABLE_COLUMN_LIST.forEach(columnMap -> addColumnNode(tagNode, columnMap));
                    }
                }
            }

            //非字典表单删除字典相关数据源字段
            if (!StringUtils.equalsAnyIgnoreCase(auxiliaryType, DataObjectSecondaryType.STR_CHAINDICT, DataObjectSecondaryType.STR_DICT)) {
                TagNode tagNode = xmlTree.xmlTree.getTagNode("Table@" + mainTable);
                if (Objects.isNull(tagNode)) {
                    XmlDiffProcessor.genXmlDiff(xmlTree, dataObjectNode, diff, true);
                    return;
                }
                if (!StringUtils.equals(reserveOne, "DataObject") || StringUtils.isBlank(extend)) {
                    if (Objects.nonNull(diff.getMetaForm()) && StringUtils.isNotBlank(extend)) {
                        if (StringUtils.isNotBlank(diff.getMetaForm().getDataSource().getRefObjectKey())) {
                            DICT_HEAD_TABLE_COLUMN_LIST.forEach(columnMap -> removeColumnNode(tagNode, columnMap.get(ConstantUtil.KEY), diff.getMetaForm().getDataSource().getRefObjectKey()));
                        }
                    } else {
                        String dataObjectKey = null;
                        if (diff.getMetaForm() != null) {
                            dataObjectKey = diff.getMetaForm().getDataSource().getDataObject().getKey();
                        } else if (diff.getDataObject() != null) {
                            dataObjectKey = diff.getDataObject().getKey();
                        }
                        if (StringUtils.isNotBlank(dataObjectKey)) {
                            String finalDataObjectKey = dataObjectKey;
                            DICT_HEAD_TABLE_COLUMN_LIST.forEach(columnMap -> removeColumnNode(tagNode, columnMap.get(ConstantUtil.KEY), finalDataObjectKey));
                        }
                    }
                }
            }
        }
        // 因为数据源改动可能引起字段列标识表标识改动,将整个父节点替换掉
        XmlDiffProcessor.genXmlDiff(xmlTree, diff.getXmlTree().xmlTree.getRoot(), diff, true);
    }

    //下拉框来源表单数据处理
    private static void dealComboBox(XmlTreeWithPath xmlTree, DataTable ComboBoxDetail, Diff diff) throws Throwable {
        String owerFormKey = diff.formKey;
        MetaForm metaForm = StringUtils.isBlank(owerFormKey) ? null : MetaFactory.getGlobalInstance().getMetaForm(owerFormKey);
        String componentkey = diff.getKey();
        AbstractMetaObject metaComponent1 = DesignIOMetaUtil.getMetaComponent(metaForm, componentkey);
        if (Objects.isNull(metaComponent1) && diff.getContainerKey() != null) {
            metaForm = MetaFactory.getGlobalInstance().getMetaForm(diff.getContainerKey());
            metaComponent1 = DesignIOMetaUtil.getMetaComponent(metaForm, componentkey);
        }
        String tagName2 = metaComponent1.getTagName();
        String xmlTreekey = getXmlTreeKey(diff, tagName2, componentkey);
        TagNode parentNode = xmlTree.xmlTree.getTagNode(xmlTreekey);
        /*ComboBoxDetail.setShowDeleted(true);*/
        parentNode.deleteChildByTagName("Item");
        for (int i = 0; i < ComboBoxDetail.size(); i++) {
            Boolean extendFlag = ComboBoxDetail.getBoolean(i, "ExtendFlag");
            if (extendFlag) {
                continue;
            }
            String Key = ComboBoxDetail.getString(i, ConstantUtil.KEY);
            String caption = ComboBoxDetail.getString(i, ConstantUtil.CAPTION);
            String value = ComboBoxDetail.getString(i, ConstantUtil.VALUE);
            TagNode itemNode = new TagNode("Item", null);
            itemNode.setAttribute(ConstantUtil.CAPTION, caption);
            itemNode.setAttribute(ConstantUtil.KEY, Key);
            itemNode.setAttribute(ConstantUtil.VALUE, value);
            parentNode.addNode(itemNode);
        }
        // 将整个父节点替换掉
        genXmlDiff(xmlTree, parentNode, diff, true);
    }//下拉框来源表单数据处理

    private static void dealCheckRuleCollection(XmlTreeWithPath xmlTree, DataTable ruleCollection, Diff diff) {
        TagNode gridRow = xmlTree.xmlTree.getTagNode("GridRow@" + diff.getKey());
        gridRow.deleteChildByTagName("UICheckRuleCollection");//删除节点重新添加
        if (ruleCollection.size() != 0) {
            TagNode node = new TagNode("UICheckRuleCollection", null);
            gridRow.addNode(node);
            for (int i = 0; i < ruleCollection.size(); i++) {
                TagNode checkRule = new TagNode("UICheckRule", null);
                checkRule.setAttribute(ConstantUtil.DESCRIPTION, ruleCollection.getString(i, ConstantUtil.DESCRIPTION));
                checkRule.setAttribute("ErrorInfo", ruleCollection.getString(i, "ErrorInfo"));
                CDataNode cNode = new CDataNode("", null);
                cNode.setText(ruleCollection.getString(i, "UICheckRule"));
                checkRule.addNode(cNode);
                node.addNode(checkRule);
            }
        }
        genXmlDiff(xmlTree, gridRow, diff, true);
    }

    private static void dealGridRowTree(XmlTreeWithPath xmlTree, DataTable ComboBoxDetail, Diff diff) {
//		String owerFormKey = diff.formKey;
        TagNode gridRow = xmlTree.xmlTree.getTagNode("GridRow@" + diff.getKey());
        TagNode rowTree = gridRow.getOrCreateChildByTagName("RowTree");
        if (rowTree.getChildren().size() == 0) {
            CDataNode cNode = new CDataNode("", null);
            rowTree.addNode(cNode);
            String expand = ComboBoxDetail.getInt(0, "IsExpand") == 1 ? "true" : "false";
            String expandLevel = ComboBoxDetail.getInt(0, "ExpandLevel").toString();
            String treeType = GridTreeType.toString(ComboBoxDetail.getInt(0, "TreeType"));
            String type = ComboBoxDetail.getString(0, ConstantUtil.TYPE);
            String cellKey = ComboBoxDetail.getString(0, "CellKey");
            String foreign = ComboBoxDetail.getString(0, "Foreign");
            String parent = ComboBoxDetail.getString(0, "Parent");
            String content = ComboBoxDetail.getString(0, "Content");
            if (!"false".equalsIgnoreCase(expand)) {
                rowTree.setAttribute("Expand", expand);
            } else {
                rowTree.getAttributes().remove("Expand");
            }
            if (!"-1".equalsIgnoreCase(expandLevel)) {
                rowTree.setAttribute("ExpandLevel", expandLevel);
            } else {
                rowTree.getAttributes().remove("ExpandLevel");
            }
            if ("None".equalsIgnoreCase(treeType)) {
                rowTree.getAttributes().remove("TreeType");
            } else {
                rowTree.setAttribute("TreeType", treeType);
            }
            if ("Formal".equalsIgnoreCase(type)) {
                rowTree.getAttributes().remove(ConstantUtil.TYPE);
            } else {
                rowTree.setAttribute(ConstantUtil.TYPE, type);
            }
            if (!StringUtils.isNotEmpty(cellKey)) {
                rowTree.getAttributes().remove("CellKey");
            } else {
                rowTree.setAttribute("CellKey", cellKey);
            }
            if (!StringUtils.isNotEmpty(parent)) {
                rowTree.getAttributes().remove("Parent");
            } else {
                rowTree.setAttribute("Parent", parent);
            }
            if (!StringUtils.isNotEmpty(foreign)) {
                rowTree.getAttributes().remove("Foreign");
            } else {
                rowTree.setAttribute("Foreign", foreign);
            }
            if (content != null) {
                rowTree.setCDataValue(content);
            }
        } else {
            String expand = ComboBoxDetail.getInt(0, "IsExpand") == 1 ? "true" : "false";
            String expandLevel = ComboBoxDetail.getInt(0, "ExpandLevel").toString();
            String treeType = GridTreeType.toString(ComboBoxDetail.getInt(0, "TreeType"));
            String type = ComboBoxDetail.getString(0, ConstantUtil.TYPE);
            String foreign = ComboBoxDetail.getString(0, "Foreign");
            String parent = ComboBoxDetail.getString(0, "Parent");
            String cellKey = ComboBoxDetail.getString(0, "CellKey");
            String content = ComboBoxDetail.getString(0, "Content");
            if (!"false".equalsIgnoreCase(expand)) {
                rowTree.setAttribute("Expand", expand);
            } else {
                rowTree.getAttributes().remove("Expand");
            }
            if (!"-1".equalsIgnoreCase(expandLevel)) {
                rowTree.setAttribute("ExpandLevel", expandLevel);
            } else {
                rowTree.getAttributes().remove("ExpandLevel");
            }
            if ("None".equalsIgnoreCase(treeType)) {
                rowTree.getAttributes().remove("TreeType");
            } else {
                rowTree.setAttribute("TreeType", treeType);
            }
            if ("Formal".equalsIgnoreCase(type)) {
                rowTree.getAttributes().remove(ConstantUtil.TYPE);
            } else {
                rowTree.setAttribute(ConstantUtil.TYPE, type);
            }
            if (!StringUtils.isNotEmpty(cellKey)) {
                rowTree.getAttributes().remove("CellKey");
            } else {
                rowTree.setAttribute("CellKey", cellKey);
            }
            if (!StringUtils.isNotEmpty(parent)) {
                rowTree.getAttributes().remove("Parent");
            } else {
                rowTree.setAttribute("Parent", parent);
            }
            if (!StringUtils.isNotEmpty(foreign)) {
                rowTree.getAttributes().remove("Foreign");
            } else {
                rowTree.setAttribute("Foreign", foreign);
            }
            if (content != null) {
                rowTree.setCDataValue(content);
            }
        }
        if (rowTree.getAttributes().size() == 0) {
            rowTree.getParent().deleteChildByTagName("RowTree");
        }
        // 将整个父节点替换掉
        genXmlDiff(xmlTree, gridRow, diff, true);
    }

    private static void dealDictColumn(XmlTreeWithPath xmlTree, DataTable dictDetail, Diff diff) throws Throwable {
        String owerFormKey = diff.formKey;
        MetaForm metaForm = StringUtils.isBlank(owerFormKey) ? null : MetaFactory.getGlobalInstance().getMetaForm(owerFormKey);
        String componentkey = diff.getKey();
        AbstractMetaObject metaComponent1 = DesignIOMetaUtil.getMetaComponent(metaForm, componentkey);
        if (Objects.isNull(metaComponent1) && diff.getContainerKey() != null) {
            metaForm = MetaFactory.getGlobalInstance().getMetaForm(diff.getContainerKey());
            metaComponent1 = DesignIOMetaUtil.getMetaComponent(metaForm, componentkey);
        }
        String tagName2 = metaComponent1.getTagName();
        String xmlTreekey = getXmlTreeKey(diff, tagName2, componentkey);
        TagNode parentNode = xmlTree.xmlTree.getTagNode(xmlTreekey);
        /*ComboBoxDetail.setShowDeleted(true);*/
        TagNode columnNode = new TagNode("DictViewColumnCollection", null);
        parentNode.deleteChildByTagName("DictViewColumnCollection");
        for (int i = 0; i < dictDetail.size(); i++) {
            String Key = dictDetail.getString(i, ConstantUtil.KEY);
            String caption = dictDetail.getString(i, ConstantUtil.CAPTION);
            int width = dictDetail.getInt(i, ConstantUtil.WIDTH);
            String widthType = dictDetail.getString(i, "WidthUnit");
            TagNode itemNode = new TagNode("DictViewColumn", null);
            itemNode.setAttribute(ConstantUtil.CAPTION, caption);
            itemNode.setAttribute(ConstantUtil.KEY, Key);
            itemNode.setAttribute(ConstantUtil.WIDTH, width + "" + defSizeToString(Integer.parseInt(widthType)));
            columnNode.addNode(itemNode);
        }
        parentNode.addNode(columnNode);
        // 将整个父节点替换掉
        genXmlDiff(xmlTree, parentNode, diff, true);
    }

    public static String defSizeToString(int sizeType) {
        String s;
        switch (sizeType) {
            case DefSize.Pref:
                s = DefSize.STR_Pref;
                break;
            case DefSize.Inherit:
                s = DefSize.STR_Inherit;
                break;
            case DefSize.Unit:
                s = DefSize.STR_Unit;
                break;
            case DefSize.Ratio:
                s = DefSize.STR_Ratio;
                break;
            case DefSize.Dp:
                s = DefSize.STR_Dp;
                break;
            case DefSize.Auto:
                s = DefSize.STR_Auto;
                break;
            case DefSize.Fix:
            default:
                s = DefSize.STR_Fix;
                break;
        }
        return s;
    }

    //数据处理
    private static void dealEmbedVar(XmlTreeWithPath xmlTree, DataTable embedVarDetail, Diff diff) {
        String componentkey = diff.getKey();
        String xmlTreekey = "Embed@" + componentkey;
        TagNode parentNode = xmlTree.xmlTree.getTagNode(xmlTreekey);
        parentNode.deleteChildByTagName("Var");
        for (int i = 0; i < embedVarDetail.size(); i++) {
            String Key = embedVarDetail.getString(i, ConstantUtil.KEY);
            String value = embedVarDetail.getString(i, ConstantUtil.VALUE);
            TagNode itemNode = new TagNode("Var", null);
            itemNode.setAttribute(ConstantUtil.KEY, Key);
            itemNode.setAttribute(ConstantUtil.VALUE, value);
            parentNode.addNode(itemNode);
        }
        // 将整个父节点替换掉
        genXmlDiff(xmlTree, parentNode, diff, true);
    }

    private static void dealMacro(XmlTreeWithPath xmlTree, DataTable MacroDetail, Diff diff) throws Throwable {
        TagNode parentNode = xmlTree.xmlTree.getRoot();
        TagNode macroCollection = xmlTree.xmlTree.getRoot().findFirstTagNodeByTagName(MetaMacroCollection.TAG_NAME);
        MacroDetail.setShowDeleted(true);
        //当macroCollection不存在先创建一个macroCollection
        if (Objects.isNull(macroCollection)) {
            TagNode macroCollection1 = new TagNode(MetaMacroCollection.TAG_NAME, null);
            parentNode.addNode(macroCollection1);
        }
        List<AbstractNode> children = parentNode.getChildren();
        for (int i = 0; i < MacroDetail.size(); i++) {
            String orgKeyDetail = (String) MacroDetail.getOriginalObject(i, "Key");
            String orgArgsDetail = (String) MacroDetail.getOriginalObject(i, "Args");
            String orgFormulaDetail = (String) MacroDetail.getOriginalObject(i, "Formula");
            String keyDetail = MacroDetail.getString(i, "Key");
            String argsDetail = MacroDetail.getString(i, "Args");
            String formulaDetail = MacroDetail.getString(i, "Formula");
            if (StringUtils.isBlank(orgKeyDetail)) {
                orgKeyDetail = keyDetail;
            }
            if (StringUtils.isBlank(orgFormulaDetail)) {
                orgFormulaDetail = argsDetail;
            }
            if (StringUtils.isBlank(orgArgsDetail)) {
                orgArgsDetail = formulaDetail;
            }
            int state = MacroDetail.getState(i);
            if (state == RowState.NEW) {
                for (AbstractNode ch : children) {
                    if (ch instanceof TagNode) {
                        String tagName = ((TagNode) ch).getTagName();
                        if (MetaMacroCollection.TAG_NAME.equalsIgnoreCase(tagName)) {
                            TagNode macro = new TagNode(ConstantUtil.MACRO, null);
                            macro.setAttribute(ConstantUtil.KEY, keyDetail);
                            if (StringUtils.isNotEmpty(argsDetail)) {
                                macro.setAttribute(ConstantUtil.ARGS, argsDetail);
                            }
                            if (StringUtils.isNotEmpty(formulaDetail)) {
                                CDataNode cNode = new CDataNode(formulaDetail, null);
                                macro.addNode(cNode);
                            }
                            ((TagNode) ch).addNode(macro);
                        }
                    }
                }
            } else if (state == RowState.MODIFIED) {
                List<AbstractNode> children1 = macroCollection.getChildren();
                for (AbstractNode macro : children1) {
                    if (macro instanceof TagNode) {
                        if (ConstantUtil.MACRO.equalsIgnoreCase(((TagNode) macro).getTagName())) {
                            //给Args添加默认值
                            //通过节点和旧值进行判断修改,只有Key符合才会进行下一步操作
                            if (((TagNode) macro).getAttributes().get(ConstantUtil.KEY).equalsIgnoreCase(orgKeyDetail)) {
                                if (null != keyDetail && keyDetail.equalsIgnoreCase(orgKeyDetail)
                                        && ((TagNode) macro).getAttributes().get(ConstantUtil.KEY).equalsIgnoreCase(orgKeyDetail)
                                        || !"".equals(argsDetail) && !argsDetail.equalsIgnoreCase(orgArgsDetail)
                                        && ((TagNode) macro).getAttributes().get(ConstantUtil.ARGS).equalsIgnoreCase(orgArgsDetail)
                                        || null != formulaDetail && !formulaDetail.equalsIgnoreCase(orgFormulaDetail)
                                        && ((TagNode) macro).getChildren().get(1).getText().equalsIgnoreCase(orgFormulaDetail)) {
                                    ((TagNode) macro).setAttribute(ConstantUtil.KEY, keyDetail);
                                    if (StringUtils.isNotEmpty(argsDetail)) {
                                        ((TagNode) macro).setAttribute(ConstantUtil.ARGS, argsDetail);
                                    } else {
                                        ((TagNode) macro).getAttributes().remove(ConstantUtil.ARGS);
                                    }
                                    if (!StringUtils.isNotEmpty(formulaDetail)) {
                                        if (((TagNode) macro).getChildren().size() > 1) {
                                            ((TagNode) macro).getChildren().remove(1);
                                        }
                                    } else {
                                        ((TagNode) macro).setCDataValue(formulaDetail);
                                    }
                                }
                            }
                        }
                    }
                }
            } else if (state == RowState.DELETED) {
                List<AbstractNode> childrenDelete = macroCollection.getChildren();
                for (Iterator<AbstractNode> iterator = childrenDelete.iterator(); iterator.hasNext(); ) {
                    AbstractNode dren = iterator.next();
                    if (dren instanceof TagNode) {
                        String chridrenName = ((TagNode) dren).getTagName();
                        if (ConstantUtil.MACRO.equalsIgnoreCase(chridrenName)
                                && ((TagNode) dren).getAttributes().get(ConstantUtil.KEY).equalsIgnoreCase(keyDetail)) {
                            iterator.remove();
                        }
                    }
                }
            }
        }
        // 将整个父节点替换掉
        genXmlDiff(xmlTree, parentNode, diff, true);
    }

    private static void dealDropdownButton(XmlTreeWithPath xmlTree, TagNode node, DataTable detailTable, Diff diff) {
        node.deleteChildByTagName("DropdownItem");
        for (int i = 0; i < detailTable.size(); i++) {
            TagNode dropdownItem = new TagNode("DropdownItem", null);
            dropdownItem.setAttribute("Key", detailTable.getString(i, "Key"));
            dropdownItem.setAttribute("Text", detailTable.getString(i, "TextContent"));
            dropdownItem.setAttribute("Separator", detailTable.getString(i, "Separator"));

            if (StringUtils.isNotEmpty(detailTable.getString(i, "OnClick"))) {
                TagNode action = new TagNode(ConstantUtil.OnClick, null);
                CDataNode cDataNode = new CDataNode(detailTable.getString(i, "OnClick"), null);
                action.addNode(cDataNode);
                dropdownItem.addNode(action);
            }
            node.addNode(dropdownItem);
        }
        genXmlDiff(xmlTree, node, diff, true);
    }

    private static void dealCollecTable(XmlTreeWithPath xmlTree, DataTable collecTable, DataTable fieldTable, Diff diff, DataTable ed_parameterCollection, DataTable ed_indexCollection, MetaDataObject curDataObject) throws Throwable {
        collecTable.setShowDeleted(true);
        if (collecTable.size() < 1) {
            return;
        }

        TagNode tableCollectionNode = getTableCollectionNode(xmlTree);
        TagNode dataObjectNode = tableCollectionNode.getParent();
        for (int i = 0; i < collecTable.size(); i++) {
            boolean embedTableFlag = collecTable.getBoolean(i, "EmbedTableFlag");
            if (embedTableFlag) {
                continue;
            }

            String tableMark = collecTable.getString(i, "TableMark");
            String orgTableKey = (String) collecTable.getOriginalObject(i, "TableMark");
            if (StringUtils.isBlank(orgTableKey)) {
                orgTableKey = tableMark;
            }

            // 新增表
            int rowState = collecTable.getState(i);
            if (RowState.NEW == rowState) {
                List<TagNode> tableNodeList = tableCollectionNode.findNodesByTagName(ConstantUtil.TABLE);
                boolean existFlag = tableNodeList.stream().anyMatch(tagNode -> StringUtils.equals(tagNode.getAttributes().get(ConstantUtil.KEY), tableMark));
                if (existFlag) {
                    continue;
                }

                TagNode tableNode = new TagNode(ConstantUtil.TABLE, null);
                tableNode.setAttribute(ConstantUtil.KEY, tableMark);
                tableNode.setAttribute(ConstantUtil.CAPTION, collecTable.getString(i, "TableName"));
                tableNode.setAttribute(ConstantUtil.DB_TABLE_NAME, collecTable.getString(i, "AssociationTable"));

                String parentTableKey = collecTable.getString(i, "ParentTableKey");
                if (StringUtils.isBlank(parentTableKey) || StringUtils.equalsAny(parentTableKey, "0", "无数据表")) {
                    tableNode.getAttributes().remove(ConstantUtil.PARENT_KEY);
                } else {
                    tableNode.setAttribute(ConstantUtil.PARENT_KEY, parentTableKey);
                }

                Integer mode = collecTable.getInt(i, "TableMode");
                String tableMode = Objects.nonNull(mode) ? TableMode.toString(mode) : "";
                tableNode.setAttribute(ConstantUtil.TABLE_MODE, tableMode);

                Integer persist = collecTable.getInt(i, "Persist");
                if (Objects.isNull(persist) || persist == 1) {
                    tableNode.getAttributes().remove("Persist");
                } else {
                    tableNode.setAttribute("Persist", "false");
                }

                String groupBy = collecTable.getString(i, "GroupBy");
                if (StringUtils.isNotBlank(groupBy)) {
                    tableNode.setAttribute("GroupBy", groupBy);
                } else {
                    tableNode.getAttributes().remove("GroupBy");
                }

                String formula = collecTable.getString(i, "Formula");
                if (StringUtils.isNotBlank(formula)) {
                    tableNode.setAttribute("Formula", formula);
                } else {
                    tableNode.getAttributes().remove("Formula");
                }

                String impl = collecTable.getString(i, "Impl");
                if (StringUtils.isNotBlank(impl)) {
                    tableNode.setAttribute("Impl", impl);
                } else {
                    tableNode.getAttributes().remove("Impl");
                }

                String orderBy = collecTable.getString(i, "OrderBy");
                if (StringUtils.isNotBlank(orderBy)) {
                    tableNode.setAttribute("OrderBy", orderBy);
                } else {
                    tableNode.getAttributes().remove("OrderBy");
                }

                String indexPrefix = collecTable.getString(i, ConstantUtil.INDEX_PREFIX);
                if (StringUtils.isNotBlank(indexPrefix)) {
                    tableNode.setAttribute(ConstantUtil.INDEX_PREFIX, indexPrefix);
                } else {
                    tableNode.getAttributes().remove(ConstantUtil.INDEX_PREFIX);
                }

                String statement = collecTable.getString(i, ConstantUtil.STATEMENT);
                if (StringUtils.isNotBlank(statement)) {
                    TagNode statementNode = tableNode.getOrCreateChildByTagName(ConstantUtil.STATEMENT);
                    statementNode.setCDataValue(statement);
                } else {
                    tableNode.deleteChildByTagName(ConstantUtil.STATEMENT);
                }

                String queryType = collecTable.getString(i, "QueryType");
                if (StringUtils.isNotBlank(queryType)) {
                    TagNode statementNode = tableNode.getOrCreateChildByTagName(ConstantUtil.STATEMENT);
                    statementNode.setAttribute(ConstantUtil.TYPE, queryType);
                } else {
                    TagNode statementNode = tableNode.getChildByTagName(ConstantUtil.STATEMENT);
                    if (Objects.nonNull(statementNode)) {
                        statementNode.getAttributes().remove(ConstantUtil.TYPE);
                    }
                }

                // TODO 这里和RowState.MODIFIED与RowState.NORMAL不一样
                String type = collecTable.getString(i, ConstantUtil.TYPE);
                if (StringUtils.equalsIgnoreCase(type, ConstantUtil.DATA_OBJECT)) {
                    tableNode.getAttributes().remove("SourceType");
                } else {
                    if (StringUtils.isNotBlank(type)) {
                        tableNode.setAttribute("SourceType", type);
                    }
                    if (!StringUtils.equals(type, "Query")) {
                        tableNode.deleteChildByTagName(ConstantUtil.STATEMENT);
                    }
                }

                tableCollectionNode.addNode(tableNode);
                xmlTree.xmlTree.updateMap(true);


                String dataType = dataObjectNode.getAttributes().get("SecondaryType");
                if (StringUtils.isBlank(dataType)) {
                    dataType = "Normal";
                }

                Long parentOID = collecTable.getLong(i, ConstantUtil.OID);
                dealFieldTable(fieldTable, diff, tableNode, parentOID, curDataObject);

                String primary = String.valueOf(collecTable.getInt(i, "IsPrimaryTable"));
                dealPrimaryTable(primary, diff, tableNode, dataType);

                String tableFilterType = collecTable.getString(i, "TableFilterType");
                if (StringUtils.isNotBlank(tableFilterType)) {
                    TagNode tableFilterNode = tableNode.getOrCreateChildByTagName("TableFilter");
                    tableFilterNode.setAttribute(ConstantUtil.TYPE, tableFilterType);
                }
                String tableFilter = collecTable.getString(i, "TableFilter");
                if (StringUtils.isNotEmpty(tableFilter) && !StringUtils.equals(type, "Query")) {
                    TagNode tableFilterNode = tableNode.getOrCreateChildByTagName("TableFilter");
                    tableFilterNode.setAttribute(ConstantUtil.TYPE, tableFilterType);
                    tableFilterNode.setCDataValue(tableFilter);
                }
                String tableFilterTwo = collecTable.getString(i, "TableFilterTwo");
                if (StringUtils.isNotEmpty(tableFilterTwo)) {
                    TagNode tableFilterNode = tableNode.getOrCreateChildByTagName("TableFilter");
                    tableFilterNode.setAttribute(ConstantUtil.TYPE, tableFilterType);
                    tableFilterNode.setCDataValue(tableFilterTwo);
                }
                if (StringUtils.isBlank(tableFilter) && StringUtils.isBlank(tableFilterTwo)) {
                    tableNode.deleteChildByTagName("TableFilter");
                }
                boolean extendTableFlag = collecTable.getBoolean(i, "ExtendTableFlag");
                if (!extendTableFlag) {
                    dealParameterCollection(ed_parameterCollection, tableNode, parentOID);
                }
            }

            TagNode rootNode = xmlTree.xmlTree.getRoot();
            String extend = rootNode.getAttributes().get(ConstantUtil.EXTEND);
            if (StringUtils.isBlank(extend)) {
                boolean extendTableFlag = collecTable.getBoolean(i, "ExtendTableFlag");
                if (extendTableFlag) {
                    continue;
                }
            }

            String xmlTreeKey = getXmlTreeKey(diff, ConstantUtil.TABLE, orgTableKey); //用原来的key来定位，（万一key修改了）也能定位
            TagNode tableNode = xmlTree.xmlTree.getTagNode(xmlTreeKey); //当前表单的xmlTree，遇到嵌入式表单的，就报null
            if (Objects.isNull(tableNode)) { //新增节点, TODO 这是什么逻辑？新增的时候不是重新New了吗？
                xmlTreeKey = getXmlTreeKey(diff, ConstantUtil.TABLE, tableMark);
                tableNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
            }
            if (Objects.isNull(tableNode)) {
                tableNode = new TagNode("Table", null);
                tableNode.setAttribute(ConstantUtil.KEY, tableMark);
                tableCollectionNode.addNode(tableNode);
            }

            // 删除表
            if (RowState.DELETED == rowState) {
                List<AbstractNode> children = tableCollectionNode.getChildren();
                children.remove(tableNode);
                continue;
            }
            // 修改表
            if (RowState.MODIFIED == rowState || RowState.NORMAL == rowState) {
                String dataType = dataObjectNode.getAttributes().get("SecondaryType");
                if (StringUtils.isBlank(dataType)) {
                    dataType = "Normal";
                }

                // 处理表字段
                Long parentOID = collecTable.getLong(i, ConstantUtil.OID);
                dealFieldTable(fieldTable, diff, tableNode, parentOID, curDataObject);

                // 处理系统字段
                Integer primary = collecTable.getInt(i, "IsPrimaryTable");
                dealPrimaryTable(primary.toString(), diff, tableNode, dataType);

                Map<String, String> attributes = tableNode.getAttributes();
                String keyAttrValue = attributes.get(ConstantUtil.KEY);

                // 修改TableKey
                if (!StringUtils.equalsIgnoreCase(keyAttrValue, tableMark) && !StringUtils.equalsIgnoreCase(diff.getReserveOne(), ConstantUtil.DATA_OBJECT)) {
                    TagNode bodyNode = xmlTree.xmlTree.getRoot().getChildByTagName("Body");
                    List<TagNode> nodeList = bodyNode.findNodesByTagName(MetaDataBinding.TAG_NAME);
                    for (TagNode tagNode : nodeList) {
                        if (StringUtils.equalsIgnoreCase(tagNode.getAttributes().get(ConstantUtil.TABLE_KEY), keyAttrValue)) {
                            tagNode.setAttribute(ConstantUtil.TABLE_KEY, tableMark);
                        }
                    }
                    List<TagNode> rowNodeList = bodyNode.findNodesByTagName(ConstantUtil.GRID_ROW);
                    for (TagNode tagNode : rowNodeList) {
                        if (StringUtils.equalsIgnoreCase(tagNode.getAttributes().get(ConstantUtil.TABLE_KEY), keyAttrValue)) {
                            tagNode.setAttribute(ConstantUtil.TABLE_KEY, tableMark);
                        }
                    }
                }

                // 修改DataObject节点上的主表Key TODO 这里可以使用 dataObjectNode
                if (StringUtils.equalsIgnoreCase(tableNode.getParent().getParent().getAttributes().get(ConstantUtil.PRIMARY_TABLE_KEY), keyAttrValue)) {
                    tableNode.getParent().getParent().setAttribute(ConstantUtil.PRIMARY_TABLE_KEY, tableMark);
                }
                tableNode.setAttribute(ConstantUtil.KEY, tableMark);

                String reserveOne = diff.getReserveOne();
                if (!StringUtils.equals(reserveOne, "DataObject") || StringUtils.isBlank(extend)) {
                    tableNode.setAttribute(ConstantUtil.CAPTION, collecTable.getString(i, "TableName"));

                    String associationTable = collecTable.getString(i, "AssociationTable");
                    if (StringUtils.isNotEmpty(associationTable)) {
                        tableNode.setAttribute(ConstantUtil.DB_TABLE_NAME, associationTable);
                    }

                    String parentTableKey = collecTable.getString(i, "ParentTableKey");
                    if (StringUtils.isBlank(parentTableKey) || StringUtils.equalsAny(parentTableKey, "0", "无数据表")) {
                        attributes.remove(ConstantUtil.PARENT_KEY);
                    } else {
                        tableNode.setAttribute(ConstantUtil.PARENT_KEY, parentTableKey);
                    }

                    Integer mode = collecTable.getInt(i, "TableMode");
                    String tableMode = Objects.nonNull(mode) ? TableMode.toString(mode) : "";
                    tableNode.setAttribute(ConstantUtil.TABLE_MODE, tableMode);

                    Integer persist = collecTable.getInt(i, "Persist");
                    if (Objects.isNull(persist) || persist == 1) {
                        attributes.remove("Persist");
                    } else {
                        tableNode.setAttribute("Persist", "false");
                    }

                    String groupBy = collecTable.getString(i, "GroupBy");
                    if (StringUtils.isNotBlank(groupBy)) {
                        tableNode.setAttribute("GroupBy", groupBy);
                    } else {
                        attributes.remove("GroupBy");
                    }

                    String formula = collecTable.getString(i, "Formula");
                    if (StringUtils.isNotBlank(formula)) {
                        tableNode.setAttribute("Formula", formula);
                    } else {
                        attributes.remove("Formula");
                    }

                    String indexPrefix = collecTable.getString(i, ConstantUtil.INDEX_PREFIX);
                    if (StringUtils.isNotBlank(indexPrefix)) {
                        tableNode.setAttribute(ConstantUtil.INDEX_PREFIX, indexPrefix);
                    } else {
                        attributes.remove(ConstantUtil.INDEX_PREFIX);
                    }

                    String impl = collecTable.getString(i, "Impl");
                    if (StringUtils.isNotBlank(impl)) {
                        tableNode.setAttribute("Impl", impl);
                    } else {
                        attributes.remove("Impl");
                    }

                    String orderBy = collecTable.getString(i, "OrderBy");
                    if (StringUtils.isNotBlank(orderBy)) {
                        tableNode.setAttribute("OrderBy", orderBy);
                    } else {
                        attributes.remove("OrderBy");
                    }

                    String statement = collecTable.getString(i, ConstantUtil.STATEMENT);
                    if (StringUtils.isNotBlank(statement)) {
                        TagNode statementNode = tableNode.getOrCreateChildByTagName(ConstantUtil.STATEMENT);
                        statementNode.setCDataValue(statement);
                    } else {
                        tableNode.deleteChildByTagName(ConstantUtil.STATEMENT);
                    }

                    String queryType = collecTable.getString(i, "QueryType");
                    if (StringUtils.isNotBlank(queryType)) {
                        TagNode statementNode = tableNode.getOrCreateChildByTagName(ConstantUtil.STATEMENT);
                        statementNode.setAttribute(ConstantUtil.TYPE, queryType);
                    } else {
                        TagNode statementNode = tableNode.getChildByTagName(ConstantUtil.STATEMENT);
                        if (Objects.nonNull(statementNode)) {
                            statementNode.getAttributes().remove(ConstantUtil.TYPE);
                        }
                    }

                    String type = collecTable.getString(i, ConstantUtil.TYPE);
                    if (StringUtils.equalsIgnoreCase(type, ConstantUtil.DATA_OBJECT)) {
                        attributes.remove("SourceType");
                        tableNode.deleteChildByTagName(ConstantUtil.STATEMENT);
                    } else {
                        tableNode.setAttribute("SourceType", type);
                        if (!StringUtils.equals(type, "Query")) {
                            tableNode.deleteChildByTagName(ConstantUtil.STATEMENT);
                        }
                    }

                    String tableFilter = collecTable.getString(i, "TableFilter");
                    String tableFilterType = collecTable.getString(i, "TableFilterType");
                    if (StringUtils.isNotBlank(tableFilter) && !StringUtils.equals(type, "Query")) {
                        TagNode tableFilterNode = tableNode.getOrCreateChildByTagName("TableFilter");
                        tableFilterNode.setCDataValue(tableFilter);
                        tableFilterNode.setAttribute(ConstantUtil.TYPE, tableFilterType);
                        tableFilterNode.setAttribute(MetaConstants.TABLEFILTER_TYPE, tableFilterType);
                    } else {
                        String tableFilterTwo = collecTable.getString(i, "TableFilterTwo");
                        if (StringUtils.isNotBlank(tableFilterTwo)) {
                            TagNode tableFilterNode = tableNode.getOrCreateChildByTagName("TableFilter");
                            tableFilterNode.setAttribute(ConstantUtil.TYPE, tableFilterType);
                            tableFilterNode.setCDataValue(tableFilterTwo);
                        } else {
                            TagNode tableFilterNode = tableNode.getChildByTagName("TableFilter");
                            if (Objects.nonNull(tableFilterNode)) {
                                tableNode.getChildren().remove(tableFilterNode);
                            }
                        }
                    }

                    // TableKey 有修改
                    if (!StringUtils.equalsIgnoreCase(tableMark, orgTableKey)) {
                        replaceTableKey(diff, orgTableKey, tableMark);
                    }
                    boolean extendTableFlag = collecTable.getBoolean(i, "ExtendTableFlag");
                    if (!extendTableFlag) {
                        dealParameterCollection(ed_parameterCollection, tableNode, parentOID);
                    }
                } else {
                    String orderBy = collecTable.getString(i, "OrderBy");
                    if (StringUtils.isNotBlank(orderBy)) {
                        tableNode.setAttribute("OrderBy", orderBy);
                    } else {
                        attributes.remove("OrderBy");
                    }
                }
            }
            // 索引集合
            if (Objects.nonNull(ed_indexCollection)){
                Long parentOID = collecTable.getLong(i, ConstantUtil.OID);
                String indexKey;
                String columns;
                Long isUnique;
                Long POID;
                TagNode index;
                boolean hasProcess = false;
                for (int row = 0; row < ed_indexCollection.size(); row++) {
                    POID = ed_indexCollection.getLong(row, ConstantUtil.POID);
                    if (parentOID.equals(POID)){
                        hasProcess = true;
                        break;
                    }
                }

                if (hasProcess){
                    tableNode.deleteChildByTagName("IndexCollection");
                    TagNode indexCollectionNode = new TagNode("IndexCollection", null);
                    tableNode.addNode(indexCollectionNode);
                    for (int row = 0; row < ed_indexCollection.size(); row++) {
                        POID = ed_indexCollection.getLong(row, ConstantUtil.POID);
                        if (!parentOID.equals(POID)) {
                            continue;
                        }
                        indexKey = ed_indexCollection.getString(row,"IndexKey");
                        columns = ed_indexCollection.getString(row,"Columns");
                        isUnique = ed_indexCollection.getLong(row,"IsUnique");
                        index = new TagNode("Index", null);
                        index.setAttribute("Key", indexKey);
                        index.setAttribute("Columns", columns);
                        index.setAttribute("IsUnique", isUnique == 1 ? "true":"false");
                        indexCollectionNode.addNode(index);
                    }
                }
            }
        }
    }

    /**
     * 处理图表数据源
     */
    private static void dealChartDataSource(XmlTreeWithPath xmlTree, DataTable chartDataSource, DataTable seriesDtl, Diff diff) throws Throwable {
        String xmlTreeKey = "Chart@" + diff.getKey();
        TagNode chartNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
        chartNode.deleteChildByTagName(ConstantUtil.CHART_DATASOURCE);

        TagNode chartDataSourceNode = new TagNode(ConstantUtil.CHART_DATASOURCE, null);
        String bindingKey = chartDataSource.getString(ProPertyConstant.BindingKey);
        chartDataSourceNode.setAttribute(ProPertyConstant.BindingKey, bindingKey);

        String categoryDataKey = chartDataSource.getString(ProPertyConstant.CategoryDataKey);
        TagNode categoryNode = new TagNode(ConstantUtil.CATEGORY, null);
        categoryNode.setAttribute(ProPertyConstant.DataKey, categoryDataKey);
        chartDataSourceNode.addNode(categoryNode);

        for (int i = 0; i < seriesDtl.size(); i++) {
            String seriesDataKey = seriesDtl.getString(i, ProPertyConstant.SeriesDataKey);
            String SplitDataKey = seriesDtl.getString(i, ProPertyConstant.SplitDataKey);
            String Title = seriesDtl.getString(i, ProPertyConstant.Title);
            TagNode seriesNode = new TagNode(ConstantUtil.SERIES, null);
            seriesNode.setAttribute(ProPertyConstant.DataKey, seriesDataKey);
            seriesNode.setAttribute(ProPertyConstant.SplitDataKey, SplitDataKey);
            seriesNode.setAttribute(ProPertyConstant.Title, Title);
            chartDataSourceNode.addNode(seriesNode);
        }
        chartNode.addNode(chartDataSourceNode);
        genXmlDiff(xmlTree, xmlTree.xmlTree.getRoot(), diff, true);
    }

    private static void dealMergedSpan(XmlTreeWithPath xmlTree, int mergedRowSpan, int mergedColumnSpan, Diff diff) throws Throwable {
        TagNode cellNode = xmlTree.xmlTree.getTagNode("GridCell@" + diff.getKey());
        TagNode rowNode = cellNode.getParent();

        cellNode.setAttribute(Property.MergedRowSpan.name, String.valueOf(mergedRowSpan));
        cellNode.setAttribute(Property.MergedColumnSpan.name, String.valueOf(mergedColumnSpan));

        List rows = rowNode.getParent().getChildrenByTagName(ConstantUtil.GRID_ROW);
        int rowIndex = rows.indexOf(rowNode);
        int cellIndex = rowNode.getChildrenByTagName(ConstantUtil.GRID_CELL).indexOf(cellNode);
        if (rowIndex + mergedRowSpan > rows.size()) {
            throw new Exception("操作失败，此单元格后剩余合并行数不足");
        }
        for (int i = rowIndex; i < rowIndex + mergedRowSpan; i++) {
            TagNode row = (TagNode) rows.get(i);
            List cells = row.getChildrenByTagName(ConstantUtil.GRID_CELL);
            if (cellIndex + mergedColumnSpan > cells.size()) {
                throw new Exception("操作失败，此单元格后剩余合并列数不足");
            }
            for (int j = cellIndex; j < cellIndex + mergedColumnSpan; j++) {
                TagNode cell = (TagNode) cells.get(j);
                if (i == rowIndex && j == cellIndex) {
                    cell.setAttribute("IsMerged", "true");
                    cell.setAttribute(Property.MergedRowSpan.name, String.valueOf(mergedRowSpan));
                    cell.setAttribute(Property.MergedColumnSpan.name, String.valueOf(mergedColumnSpan));
                } else {
                    cell.setAttribute("IsMerged", "true");
                    cell.setAttribute(Property.MergedRowSpan.name, String.valueOf(i - rowIndex));
                    cell.setAttribute(Property.MergedColumnSpan.name, String.valueOf(j - cellIndex));
                }
            }
        }
        genXmlDiff(xmlTree, xmlTree.xmlTree.getRoot(), diff, true);
    }


    /**
     * 检查配置中是否有引用此字段的配置,后续继续添加
     */
    public static boolean checkPublicConfigure(Diff diff, String fieldKey) {
        XmlTree xmlTree = diff.getXmlTree().xmlTree;
        TagNode bodyNode = xmlTree.getRoot().getOrCreateChildByTagName("Body");

        List<TagNode> nodeList = bodyNode.findNodesByTagName(ConstantUtil.GRID_ROW);
        for (TagNode tagNode : nodeList) {
            String groupKey = tagNode.getAttributes().get(ConstantUtil.GROUP_KEY);
            if (StringUtils.isNotEmpty(groupKey) && groupKey.equalsIgnoreCase(fieldKey)) {
                return false;
            }
        }
        return true;
    }

    //统计GridCOlumn的长度
    private static int statisticsLength(TagNode columnCollection) {
        int length = 0;
        List<TagNode> nodesByTagName = columnCollection.findNodesByTagName(ConstantUtil.GRID_COLUMN);
        for (TagNode node : nodesByTagName) {
            TagNode firstTagNodeByTagName = node.findFirstTagNodeByTagName(ConstantUtil.GRID_COLUMN_COLLECTION);
            if (firstTagNodeByTagName != null) {
                int statisticsLength = statisticsLength(firstTagNodeByTagName);
                length = length + statisticsLength;
            } else {
                length++;
            }
        }
        return length;
    }

    /**
     * 统计包含多个子列表格的序号
     */
    private static int statisticsRowIndex(TagNode columnCollection, String sideKey, TagNode sourceNode) {
        while (sourceNode.findFirstTagNodeByTagName(ConstantUtil.GRID_COLUMN_COLLECTION) != null) {
            List<TagNode> nodesByTagName = sourceNode.findFirstTagNodeByTagName(ConstantUtil.GRID_COLUMN_COLLECTION).findNodesByTagName(ConstantUtil.GRID_COLUMN);
            sourceNode = nodesByTagName.get(nodesByTagName.size() - 1);
            sideKey = sourceNode.getAttributes().get(ConstantUtil.KEY);
        }
        List<TagNode> column = columnCollection.findNodesByTagName(ConstantUtil.GRID_COLUMN);
        int totalIndex = 0;
        boolean flag;
        for (TagNode tagNode : column) {
            if (tagNode.getAttributes().get(ConstantUtil.KEY).equalsIgnoreCase(sideKey)) {
                return ++totalIndex;
            } else {
                TagNode gridColumnCollection = tagNode.findFirstTagNodeByTagName(ConstantUtil.GRID_COLUMN_COLLECTION);
                if (gridColumnCollection != null) {
                    totalIndex = (int) sonColumn(gridColumnCollection, sideKey).get(0) + totalIndex;
                    flag = (boolean) sonColumn(gridColumnCollection, sideKey).get(1);
                    if (flag) {
                        return totalIndex;
                    }
                } else {
                    totalIndex++;
                }
            }
        }
        return 0;
    }

    private static List<Object> sonColumn(TagNode column, String sideKey) {
        List<TagNode> children = column.findNodesByTagName(ConstantUtil.GRID_COLUMN);
        List<Object> res = new ArrayList<>();
        int index = 0;
        for (TagNode child : children) {
            TagNode gridColumnCollection = child.findFirstTagNodeByTagName(ConstantUtil.GRID_COLUMN_COLLECTION);
            if (child.getAttributes().get(ConstantUtil.KEY).equalsIgnoreCase(sideKey)) {
                index++;
                res.add(0, index);
                res.add(1, true);
                return res;
            } else if (gridColumnCollection != null) {
                List<Object> list = sonColumn(gridColumnCollection, sideKey);
                index = (int) list.get(0) + index;
                boolean flag = (boolean) list.get(1);
                if (flag) {
                    res.add(0, index);
                    res.add(1, true);
                    return res;
                }
            } else {
                index++;
            }
        }
        res.add(0, index);
        res.add(1, false);
        return res;
    }

    public static String getDatatypeContainerMultiDict(int controlType, boolean isMultiDict) {
        if (ControlType.COMBOBOX == controlType || ControlType.LABEL == controlType
                || ControlType.TEXTAREA == controlType || ControlType.CHECKLISTBOX == controlType
                || ControlType.TEXTEDITOR == controlType || ControlType.TEXTBUTTON == controlType || ControlType.IMAGELIST == controlType
                || ControlType.PASSWORDEDITOR == controlType || ControlType.IMAGE == controlType || ControlType.RADIOBUTTON == controlType
                || ControlType.HYPERLINK == controlType || ControlType.DROPDOWNBUTTON == controlType || (ControlType.DICT == controlType && isMultiDict)
                || ControlType.TIMEPICKER == controlType || ControlType.BARCODER == controlType || ControlType.VIDEOPLAYER == controlType
                || ControlType.GIFIMAGE == controlType || ControlType.NOTICEBAR == controlType
                || ControlType.ICON == controlType || ControlType.NUMBERINFOEDITOR == controlType || ControlType.COUNTUP == controlType
        ) {
            return DataType.STR_STRING;
        } else if (ControlType.UTCDATEPICKER == controlType || ControlType.DYNAMICDICT == controlType || ControlType.DICT == controlType) {
            return DataType.STR_LONG;
        } else if (ControlType.NUMBEREDITOR == controlType || ControlType.SCOREBAR == controlType
                || ControlType.PRICELABEL == controlType || ControlType.SLIDER == controlType
                || ControlType.COUNTDOWNVIEW == controlType) {
            return DataType.STR_NUMERIC;
        } else if (ControlType.DATEPICKER == controlType || ControlType.RELATIVETIME == controlType) {
            return DataType.STR_DATETIME;
        } else if (ControlType.CHECKBOX == controlType || ControlType.MONTHPICKER == controlType || ControlType.SWITCH == controlType) {
            return DataType.STR_INT;
        } else if (ControlType.RICHEDITOR == controlType) {
            return DataType.STR_TEXT;
        }
        return null;
    }

    private static String getDatatype(int controlType) {
        if (ControlType.COMBOBOX == controlType || ControlType.LABEL == controlType
                || ControlType.TEXTAREA == controlType || ControlType.CHECKLISTBOX == controlType
                || ControlType.TEXTEDITOR == controlType || ControlType.TEXTBUTTON == controlType || ControlType.IMAGELIST == controlType
                || ControlType.PASSWORDEDITOR == controlType || ControlType.IMAGE == controlType || ControlType.RADIOBUTTON == controlType
                || ControlType.HYPERLINK == controlType || ControlType.DROPDOWNBUTTON == controlType
                || ControlType.TIMEPICKER == controlType || ControlType.BARCODER == controlType || ControlType.VIDEOPLAYER == controlType
                || ControlType.GIFIMAGE == controlType || ControlType.NOTICEBAR == controlType
                || ControlType.ICON == controlType || ControlType.NUMBERINFOEDITOR == controlType || ControlType.COUNTUP == controlType
        ) {
            return DataType.STR_STRING;
        } else if (ControlType.UTCDATEPICKER == controlType || ControlType.DYNAMICDICT == controlType || ControlType.DICT == controlType) {
            return DataType.STR_LONG;
        } else if (ControlType.NUMBEREDITOR == controlType || ControlType.SCOREBAR == controlType
                || ControlType.PRICELABEL == controlType || ControlType.SLIDER == controlType
                || ControlType.COUNTDOWNVIEW == controlType) {
            return DataType.STR_NUMERIC;
        } else if (ControlType.DATEPICKER == controlType || ControlType.RELATIVETIME == controlType) {
            return DataType.STR_DATETIME;
        } else if (ControlType.CHECKBOX == controlType || ControlType.MONTHPICKER == controlType || ControlType.SWITCH == controlType) {
            return DataType.STR_INT;
        } else if (ControlType.RICHEDITOR == controlType) {
            return DataType.STR_TEXT;
        }
        return null;
    }
    private static LinkedList<String> sortMetaGridColumns(MetaGridColumnCollection columnCollection) {
        // 将有序集合转换为LinkedList
        LinkedList<String> linkedList = new LinkedList<>();
        for (MetaGridColumn gridColumn : columnCollection) {
            if (gridColumn.getSideKey().isEmpty()) {//认为是原单的
                linkedList.add(gridColumn.getMetaKey());
            }
        }
        for (MetaGridColumn gridColumn : columnCollection) {
            if (!gridColumn.getSideKey().isEmpty()) {//认为是新的
                if (gridColumn.getInsertAfter()){
                    linkedList.add(linkedList.indexOf(gridColumn.getSideKey())+1, gridColumn.getMetaKey());
                } else {
                    linkedList.add(linkedList.indexOf(gridColumn.getSideKey()), gridColumn.getMetaKey());
                }
            }
        }
        return linkedList;
    }
    private static LinkedList<String> sortMetaGridRow(MetaGridRow meta) {
        // 将有序集合转换为LinkedList
        LinkedList<String> linkedList = new LinkedList<>();
        for (MetaGridCell gridCell : meta) {
            if (gridCell.getSideKey().isEmpty()) {//认为是原单的
                linkedList.add(gridCell.getKey());
            }
        }
        for (MetaGridCell gridCell : meta) {
            if (!gridCell.getSideKey().isEmpty()) {//认为是原单的
                if (gridCell.getInsertAfter()){
                    linkedList.add(linkedList.indexOf(gridCell.getSideKey())+1, gridCell.getKey());
                } else {
                    linkedList.add(linkedList.indexOf(gridCell.getSideKey()), gridCell.getKey());
                }
            }
        }
        return linkedList;
    }
    private static void mergeColumnDragDiff(Diff diff) throws Throwable {
        String columnKey = diff.getKey();
        int newColumnIndex = diff.getNewColumnIndex();
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        String orgXml = xmlTree.xmlTree.getOrgXml();
        MetaForm metaForm = diff.getMetaForm();
        if(diff.isMultyMove){
            metaForm = MetaFactory.getGlobalInstance().getMetaForm(diff.formKey);
        }
        IDLookup idLookup = IDLookup.getIDLookup(metaForm);
        MetaGrid metaGrid = idLookup.getMetaGridByGridKey(idLookup.getGridKeyByFieldKey(columnKey));
        LinkedList<String> strings1 = sortMetaGridColumns(metaGrid.getColumnCollection());
        int oldColumnIndex = strings1.indexOf(columnKey);
        if (newColumnIndex == oldColumnIndex) {
            return; // 表示单元格没有拖动过
        }
        String startColumnKey = metaGrid.getColumnCollection().get(Math.min(oldColumnIndex, newColumnIndex)).getKey();
        String endColumnKey = metaGrid.getColumnCollection().get(Math.max(oldColumnIndex, newColumnIndex)).getKey();
        TagNode startNode = xmlTree.xmlTree.getTagNode("GridColumn@" + startColumnKey);
        TagNode endNode = xmlTree.xmlTree.getTagNode("GridColumn@" + endColumnKey);


        if (!diff.getMetaForm().getExtend().isEmpty()){
            String xmlTreeKey = "Grid@" + metaGrid.getKey();
            XmlTreeWithPath vestXmlTree = diff.getVestXmlTree();
            TagNode tagNode3 = vestXmlTree.xmlTree.getTagNode("GridColumn@" + columnKey);
            List<String> strings = new ArrayList<>();
            strings.add(tagNode3.getPrimaryKey());
            TagNode fieldNode = xmlTree.xmlTree.getTagNode(xmlTreeKey);
            TagNode fieldNode1 = xmlTree.xmlTree.getTagNode(xmlTreeKey);
            QuoteGridFiledOperUtil.getParent(tagNode3, fieldNode1,strings);
            for (int i = strings.size()-2; i >= 0; i--) {
                if (strings.get(i).contains("@")){
                    fieldNode1 = fieldNode1.getOrCreateChildByKey(strings.get(i).split("@")[0], strings.get(i).split("@")[1]);
                } else {
                    fieldNode1 = fieldNode1.getOrCreateChildByKey(strings.get(i), "");
                }
            }
            fieldNode1.setAttribute("InsertAfter",String.valueOf(newColumnIndex > oldColumnIndex));
            startColumnKey = strings1.get(newColumnIndex);
            fieldNode1.setAttribute("SideKey", startColumnKey);
            //获取SideKey
            TagNode tagNode4 = xmlTree.xmlTree.getTagNode("GridColumn@" + startColumnKey);
            if (tagNode4!=null){
                boolean sideKey = tagNode4.getAttributes().remove("SideKey", columnKey);
                if (sideKey){
                    tagNode4.getAttributes().remove("InsertAfter");
                }
            }


            TagNode tagNode1 = vestXmlTree.xmlTree.getTagNode(xmlTreeKey).getOrCreateChildByTagName(ConstantUtil.GRID_COLUMN_COLLECTION).getChildByTagNameAndKey(ConstantUtil.GRID_COLUMN, columnKey);
		int i = -1;
		if (tagNode1 != null) {
			i = vestXmlTree.xmlTree.getTagNode(xmlTreeKey).getOrCreateChildByTagName(ConstantUtil.GRID_COLUMN_COLLECTION).getTagNodeChildrenByTagName(ConstantUtil.GRID_COLUMN).indexOf(tagNode1);
		}
		TagNode gridRowCollectionTagNode = fieldNode.getOrCreateChildByTagName(ConstantUtil.GRID_ROW_COLLECTION);
		//判断原单有几行

		List<TagNode> tagNodeChildrenByTagName = vestXmlTree.xmlTree.getTagNode(xmlTreeKey).getOrCreateChildByTagName(ConstantUtil.GRID_ROW_COLLECTION).getTagNodeChildrenByTagName(ConstantUtil.GRID_ROW);
		for (TagNode tagNode : tagNodeChildrenByTagName) {
            String rowKey = tagNode.getAttributes().get(ConstantUtil.KEY);
            TagNode rowNode = gridRowCollectionTagNode.getOrCreateChildByKey(tagNode.getTagName(), rowKey);
			if (i > 0) {
				TagNode tagNode2 = tagNode.getTagNodeChildrenByTagName(ConstantUtil.GRID_CELL).get(i);
                String cellKey = tagNode2.getAttributes().get(ConstantUtil.KEY);
                TagNode orCreateChildByKey = rowNode.getOrCreateChildByKey(tagNode2.getTagName(), cellKey);
                orCreateChildByKey.setAttribute("InsertAfter",String.valueOf(newColumnIndex > oldColumnIndex));
//                MetaGridCell gridCell = metaGrid.findRowByKey(rowKey).get(newColumnIndex);

                LinkedList<String> strings2 = sortMetaGridRow(metaGrid.findRowByKey(rowKey));
                String cellNewKey = strings2.get(newColumnIndex);
                orCreateChildByKey.setAttribute("SideKey", cellNewKey);
                //获取SideKey
                TagNode tagNode5 = xmlTree.xmlTree.getTagNode(ConstantUtil.GRID_CELL+"@" + cellNewKey);
                if (tagNode5!=null){
                    boolean sideKey = tagNode5.getAttributes().remove("SideKey", cellKey);
                    if (sideKey){
                        tagNode5.getAttributes().remove("InsertAfter");
                    }
                }


            }
		}
            genXmlDiff(xmlTree, fieldNode, diff, true);
            return;
        }

        if (Objects.isNull(endNode) && Objects.isNull(startNode)) {
            throw new Exception("嵌入表格中列拖动请到设计器页面进行操作");
        }
        Element element = startNode.getElement();
        int startLine = xmlTree.xmlTree.getLineByIndex(element.getBgIndex());
        String oldXmlFragment = orgXml.substring(xmlTree.xmlTree.getLineStartPos(startLine), endNode.getLast().getElement().getEndIndex() + 1);
        oldXmlFragment = oldXmlFragment.replaceAll("\r\n","\n").replaceAll("\n","\r\n");
        String newXmlFragment;
        if (newColumnIndex < oldColumnIndex) { // 将最后的节点移到前面
            String lastNode = orgXml.substring(
                    xmlTree.xmlTree.getLineStartPos(xmlTree.xmlTree.getLineByIndex(endNode.getElement().getBgIndex())),
                    endNode.getLast().getElement().getEndIndex() + 1);
            newXmlFragment = lastNode + "\r\n" +
                    oldXmlFragment.substring(0, oldXmlFragment.length() - lastNode.length() - 2);
        } else { // 将前面的节点移到最后
            String firstNode = orgXml.substring(
                    xmlTree.xmlTree.getLineStartPos(xmlTree.xmlTree.getLineByIndex(element.getBgIndex())),
                    element.getEndIndex() + 1);
            newXmlFragment = oldXmlFragment.substring(firstNode.length() + 2) +
                    "\r\n" + firstNode;
        }
        diff.setXmlDiff(xmlTree, startLine, oldXmlFragment, newXmlFragment);
        TagNode gridNode = xmlTree.xmlTree.getTagNode("Grid@" + metaGrid.getKey());
        TagNode rowColl = gridNode.getOrCreateChildByTagName(ConstantUtil.GRID_ROW_COLLECTION);
        List<AbstractNode> rowcollection = rowColl.getChildren();
        String oldXmlFragment2 = orgXml.substring(rowColl.getElement().getBgIndex(), rowColl.getLast().getElement().getEndIndex() + 1);
        int startLine2 = xmlTree.xmlTree.getLineByIndex(rowColl.getElement().getBgIndex());
        String newXmlFragment2 = oldXmlFragment2;
        for (AbstractNode node : rowcollection) {
            if (node instanceof TagNode) {
                if (ConstantUtil.GRID_ROW.equalsIgnoreCase(((TagNode) node).getTagName())) {
                    String newXmlFragmentTMP;
                    TagNode startNode1 = (TagNode) (((TagNode) node).getChildren().get(oldColumnIndex * 2 + 1));
                    TagNode endNode1 = (TagNode) (((TagNode) node).getChildren().get(newColumnIndex * 2 + 1));
                    String oldxml;
                    if (newColumnIndex < oldColumnIndex) {
                        oldxml = orgXml.substring(xmlTree.xmlTree.getLineStartPos(xmlTree.xmlTree.getLineByIndex(endNode1.getElement().getBgIndex())),
                                startNode1.getLast().getElement().getEndIndex() + 1);
                    } else {
                        oldxml = orgXml.substring(xmlTree.xmlTree.getLineStartPos(xmlTree.xmlTree.getLineByIndex(startNode1.getElement().getBgIndex())),
                                endNode1.getLast().getElement().getEndIndex() + 1);
                    }
                    if (newColumnIndex < oldColumnIndex) { // 将最后的节点移到前面
                        String lastNode = orgXml.substring(
                                xmlTree.xmlTree.getLineStartPos(xmlTree.xmlTree.getLineByIndex(startNode1.getElement().getBgIndex())),
                                startNode1.getLast().getElement().getEndIndex() + 1);
                        newXmlFragmentTMP = lastNode + "\r\n" +
                                oldxml.substring(0, oldxml.length() - lastNode.length());
                    } else { // 将前面的节点移到最后
                        String firstNode = orgXml.substring(
                                xmlTree.xmlTree.getLineStartPos(xmlTree.xmlTree.getLineByIndex(startNode1.getElement().getBgIndex())),
                                startNode1.getLast().getElement().getEndIndex() + 1);
                        newXmlFragmentTMP = oldxml.substring(firstNode.length() + 2) +
                                "\r\n" + firstNode;
                    }
                    newXmlFragment2 = newXmlFragment2.replace(oldxml, newXmlFragmentTMP);
                    newXmlFragment2 = newXmlFragment2.replaceAll("((\r\n)|\n)[\\s\t ]*(\\1)+", "$1");
                }
            }
        }
        diff.setXmlDiff2(xmlTree, startLine2, oldXmlFragment2, newXmlFragment2);
    }

    private static String getMainTableKey(DataTable dataTable) {
        for (int j = 0; j < dataTable.size(); j++) {
            Object isPrimaryTable = dataTable.getObject(j, "IsPrimaryTable");
            if (TypeConvertor.toBoolean(isPrimaryTable) || Objects.equals(isPrimaryTable, "1")) {
                return dataTable.getString(j, "TableMark");
            }
        }
        return "";
    }

    public static String getXmlTreeKey(Diff diff, String controlType, String primaryKey) throws Throwable {
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        MetaObjectType metaObjectType = diff.getMetaObjectType();

        // 面板字段
        if (metaObjectType == MetaObjectType.field || metaObjectType == MetaObjectType.panel || metaObjectType == MetaObjectType.subDetail
                || metaObjectType == MetaObjectType.grid || metaObjectType == MetaObjectType.D_DictView || metaObjectType == MetaObjectType.listView) {
            // label
            if (diff.getControlType() == ControlType.LABEL) {
                if (StringUtils.equalsIgnoreCase(diff.properties.get(0).property.name, ConstantUtil.KEY)) {
                    String orgVal = diff.properties.get(0).orgValue;
                    return ControlType.STR_LABEL + "@" + orgVal;
                }
                return ControlType.toString(diff.getControlType()) + "@" + diff.getKey();
            }

            // key
            String propertyName = diff.properties.get(0).property.name;
//			String controlType2 = ControlType.toString(diff.getControlType());
            if (StringUtils.equalsIgnoreCase(propertyName, ConstantUtil.KEY)) {
                String orgVal = diff.properties.get(0).orgValue;
                String propertyKey = ControlType.toString(diff.getControlType()) + "@" + orgVal;
                TagNode componentNode = xmlTree.xmlTree.getTagNode(propertyKey);
                if (Objects.isNull(componentNode)) {
                    throw new Throwable("warning: 不能修改!");
                }

                String buddyKey = componentNode.getAttributes().get(ConstantUtil.BUDDY_KEY);
                if (StringUtils.isBlank(buddyKey)) {
                    return propertyKey;
                }

                return ConstantUtil.LABEL + "@" + buddyKey + "," + propertyKey;
            }

            // BuddyKey, BuddyCaption, BuddyX, BuddyY
            if (StringUtils.equalsAnyIgnoreCase(propertyName, ConstantUtil.BUDDY_KEY, "BuddyCaption", "BuddyX", "BuddyY")) {
                String propertyKey = ControlType.toString(diff.getControlType()) + "@" + diff.getKey();
                TagNode componentNode = xmlTree.xmlTree.getTagNode(propertyKey);
                if (Objects.isNull(componentNode)) {
                    throw new Throwable("warning: 不能修改!");
                }
                String buddyKey = componentNode.getAttributes().get(ConstantUtil.BUDDY_KEY);
                if (!StringUtils.equalsAnyIgnoreCase(propertyName, ConstantUtil.BUDDY_KEY)) {
                    return ConstantUtil.LABEL + "@" + buddyKey;
                }
                return ConstantUtil.LABEL + "@" + buddyKey + "," + propertyKey;
            }
            return ControlType.toString(diff.getControlType()) + "@" + diff.getKey();
        }

        // 表格字段
        if ((metaObjectType == MetaObjectType.gridField && CollectionUtils.isNotEmpty(diff.properties)) || metaObjectType == MetaObjectType.GridCellType) {
            String propertyName = diff.properties.get(0).property.name;
            if (StringUtils.equalsIgnoreCase(propertyName, ConstantUtil.KEY)) {
                String orgVal = diff.properties.get(0).orgValue;
                return ConstantUtil.GRID_CELL + "@" + orgVal + "," + ConstantUtil.GRID_COLUMN + "@" + orgVal;
            }

            if (StringUtils.equalsIgnoreCase(propertyName, ConstantUtil.VISIBLE)) {
                return ConstantUtil.GRID_COLUMN + "@" + diff.getKey();
            }

            if (StringUtils.equalsIgnoreCase(propertyName, ConstantUtil.CAPTION)) {
                return ConstantUtil.GRID_CELL + "@" + diff.getKey() + "," + ConstantUtil.GRID_COLUMN + "@" + diff.getKey();
            }

            return ConstantUtil.GRID_CELL + "@" + diff.getKey();
        }

        // ListView字段
        if (metaObjectType == MetaObjectType.listViewField) {
            String propertyName = diff.properties.get(0).property.name;
            if (StringUtils.equalsIgnoreCase(propertyName, ConstantUtil.KEY)) {
                String orgVal = diff.properties.get(0).orgValue;
                return ConstantUtil.LIST_VIEW_COLUMN + "@" + orgVal;
            }
            return ConstantUtil.LIST_VIEW_COLUMN + "@" + diff.getKey();
        }

        if (metaObjectType == MetaObjectType.EditViewColumn) {
            String propertyName = diff.properties.get(0).property.name;
            if (StringUtils.equalsIgnoreCase(propertyName, ConstantUtil.KEY)) {
                String orgVal = diff.properties.get(0).orgValue;
                return "EditViewColumn@" + orgVal;
            }

            return "EditViewColumn@" + diff.getKey();
        }

        if (metaObjectType == MetaObjectType.EditViewChildGridLayout || metaObjectType == MetaObjectType.EditViewRootGridLayout) {
            return "GridLayout@" + diff.getKey();
        }

        if (metaObjectType == MetaObjectType.EditViewChildLinearLayout || metaObjectType == MetaObjectType.EditViewRootLinearLayout) {
            return "LinearLayout@" + diff.getKey();
        }

        if (metaObjectType == MetaObjectType.EditViewChildFlexFlowLayout) {
            return "FlexFlowLayout@" + diff.getKey();
        }

        if (metaObjectType == MetaObjectType.EditViewChildColumnLayout) {
            return "ColumnLayout@" + diff.getKey();
        }

        if (metaObjectType == MetaObjectType.EditViewChildSplitLayout) {
            return "SplitLayout@" + diff.getKey();
        }

        if (metaObjectType == MetaObjectType.EditViewChildTabLayout) {
            return "TabLayout@" + diff.getKey();
        }

        if (metaObjectType == MetaObjectType.EditViewChildFlowLayout) {
            return "FlowLayout@" + diff.getKey();
        }

        if (metaObjectType == MetaObjectType.EditViewChildFlexGridLayout) {
            return "FlexGridLayout@" + diff.getKey();
        }

        if (metaObjectType == MetaObjectType.operationCollection || metaObjectType == MetaObjectType.operation) {
            String propertyName = diff.properties.get(0).property.name;
            if (StringUtils.equals(propertyName, ConstantUtil.KEY)) {
                return ConstantUtil.OPERATION + "@" + primaryKey + "," + ConstantUtil.OPERATION_COLLECTION + "@" + primaryKey;
            }
            return ConstantUtil.OPERATION + "@" + diff.getKey() + "," + ConstantUtil.OPERATION_COLLECTION + "@" + diff.getKey();
        }

        // toolbar
        if (metaObjectType == MetaObjectType.toolbar) {
            String propertyName = diff.properties.get(0).property.name;
            if (StringUtils.equals(propertyName, ConstantUtil.CAPTION)) {
                return ConstantUtil.TOOL_BAR + "@" + diff.getKey();
            }
            String orgVal = diff.properties.get(0).orgValue;
            return ConstantUtil.TOOL_BAR + "@" + orgVal;
        }

        // newToolbar
        if (metaObjectType == MetaObjectType.ToolBar) {
            return ConstantUtil.TOOL_BAR + "@";
        }

        if (MetaObjectType.GridHeadColumn.equals(metaObjectType)) {
            String propertyName = diff.properties.get(0).property.name;
            if (StringUtils.equals(propertyName, ConstantUtil.KEY)) {
                return "GridColumn@" + diff.properties.get(0).orgValue;
            }
            return "GridColumn@" + diff.getKey();
        }
        if (MetaObjectType.GridRow.equals(metaObjectType)) {
            String propertyName = diff.properties.get(0).property.name;
            if (StringUtils.equalsIgnoreCase(propertyName, ConstantUtil.KEY)) {
                String orgVal = diff.properties.get(0).orgValue;
                return MetaObjectType.GridRow + "@" + orgVal;
            }
            return MetaObjectType.GridRow+"@" + diff.getKey();
        }

        return controlType + "@" + primaryKey;
    }

    private static void dealFieldTable(DataTable fieldTable, Diff diff, TagNode parentNode, long parentOID, MetaDataObject curDataObject) throws Throwable {
        Collection<AbstractNode> nodeList = diff.getXmlTree().xmlTree.getMapNodes().values();
        String tableKey = parentNode.getAttributes().get(ConstantUtil.KEY);
        Set<String> columnKeySet = new HashSet<>();
        String sourceType = parentNode.getAttributes().get(ConstantUtil.SOURCE_TYPE);
        parentNode.deleteChildByTagName(ConstantUtil.COLUMN);
        List<AbstractNode> children = parentNode.getChildren();
        children.clear();

        fieldTable.setShowDeleted(true);

        //迁移表配置迁移策略，移除三个系统字段
        boolean isReMigraiton = false;
        TagNode root = diff.getXmlTree().xmlTree.getRoot();
        if (diff.getDataObject() != null && StringUtils.isBlank(diff.getDataObject().getExtend())) {//不是马甲
            if (StringUtils.equals(root.getAttributes().get(ConstantUtil.SECONDARY_TYPE), "Migration") && StringUtils.equals(root.getAttributes().get("MigrationUpdateStrategy"), "KeysTableFocusChange")) {
                isReMigraiton = true;
            }
        }

        List<String> notMigraitonSysFields = new ArrayList<>();
        for (int i = 0; i < fieldTable.size(); i++) {
            if (!Objects.equals(parentOID, fieldTable.getLong(i, ConstantUtil.POID))) {
                continue;
            }

            int extendColumnFlag = fieldTable.getInt(i, "ExtendColumnFlag");
            if (extendColumnFlag > 0) {
                continue;
            }

            if (fieldTable.getState(i) == RowState.DELETED) {
                continue;
            }

            //迁移表移除三个系统字段
            String key = fieldTable.getString(i, ConstantUtil.COLUMN_KEY);
            if (StringUtils.equalsAny(key,ConstantUtil.POID, ConstantUtil.SOID, ConstantUtil.DVERID, ConstantUtil.MODIFY_TIME, ConstantUtil.CREATE_TIME)) {
                notMigraitonSysFields.add(key);
                if (isReMigraiton) {
                    continue;
                }
            }

            String orgColKey = (String) fieldTable.getOriginalObject(i, ConstantUtil.COLUMN_KEY);
            String columnKey = fieldTable.getString(i, ConstantUtil.COLUMN_KEY).trim();
            if (columnKeySet.contains(columnKey)) {
                continue;
            }

            boolean isDictCol = false;
            if (!StringUtils.equalsIgnoreCase(orgColKey, columnKey)) {
                if (!StringUtils.equalsIgnoreCase(diff.getReserveOne(), ConstantUtil.DATA_OBJECT)) {
                    replaceColumnKey(diff, orgColKey, columnKey); //如果列标识修改，替换表单中所有引用此数据列的列标识
                }
                String columnName = fieldTable.getString(i, "ColumnName").replaceAll("\r", "");
                isDictCol = changeDictBinding(diff, fieldTable, orgColKey, columnKey, columnName);
            }

            TagNode columnNode = new TagNode(ConstantUtil.COLUMN, null);
            children.add(columnNode);
            columnKeySet.add(columnKey);

            String needRightsType = fieldTable.getString(i, ConstantUtil.NEED_RIGHTS);
            if (StringUtils.isNotBlank(needRightsType)) {
                int needRights = Integer.parseInt(needRightsType);
                columnNode.setAttribute(ConstantUtil.NEED_RIGHTS, ColumnRightsType.toString(needRights));
                if (ColumnRightsType.TRUE == needRights || "Custom".equals(sourceType)) {
                    boolean ignoreRightsFlag = nodeList.stream()
                            .anyMatch(abstractNode -> {
                                if (!(abstractNode instanceof TagNode)) {
                                    return false;
                                }

                                TagNode tagNode = (TagNode) abstractNode;
                                TagNode dataBindingNode = tagNode.getChildByTagName(MetaDataBinding.TAG_NAME);
                                if (Objects.isNull(dataBindingNode)) {
                                    return false;
                                }

                                Map<String, String> attributes = dataBindingNode.getAttributes();
                                if (!StringUtils.equalsIgnoreCase(attributes.get(ConstantUtil.COLUMN_KEY), columnKey)) {
                                    return false;
                                }
                                String ignoreRights = attributes.get(Property.IgnoreRights.name);
                                return StringUtils.equalsIgnoreCase(ignoreRights, "true");
                            });
                    if (ignoreRightsFlag) {
                        throw new Throwable("已在控件中设置忽略权限，不允许设置为检查权限！已撤销");
                    }
                    columnNode.setAttribute(ConstantUtil.ITEM_KEY, fieldTable.getString(i, ConstantUtil.ITEM_KEY));
                }
            }

            if (isDictCol) {
                String dictKey = columnKey.substring(0, columnKey.length() - 2);
                columnNode.setAttribute(ConstantUtil.CODE_COLUMN_KEY, dictKey + "Code");
            } else {
                String codeColumnKey = fieldTable.getString(i, ConstantUtil.CODE_COLUMN_KEY);
                if (StringUtils.isBlank(codeColumnKey)) {
                    columnNode.setAttribute(ConstantUtil.CODE_COLUMN_KEY, "");
                } else {
                    columnNode.setAttribute(ConstantUtil.CODE_COLUMN_KEY, codeColumnKey);
                }
            }

            columnNode.setAttribute(ConstantUtil.KEY, columnKey);
            columnNode.setAttribute(ConstantUtil.CAPTION, fieldTable.getString(i, "ColumnName").replaceAll("\r", ""));
            columnNode.setAttribute(ConstantUtil.DB_COLUMN_NAME, fieldTable.getString(i, ConstantUtil.DB_COLUMN_NAME));
            columnNode.setAttribute("RefItemKeyCol", fieldTable.getString(i, "RefItemKeyCol"));
            columnNode.setAttribute("PrimaryKey", fieldTable.getBoolean(i, "IsPrimaryKey").toString(),"false");
            columnNode.setAttribute("RefCol", fieldTable.getString(i, "RefCol"));
            String dataElementKey = fieldTable.getString(i, "DataElementKey");

            if (StringUtils.isEmpty(dataElementKey)){
                columnNode.setAttribute(ConstantUtil.DATA_TYPE, DataType.toString(fieldTable.getInt(i, ConstantUtil.COLUMN_TYPE)));
                String precision = fieldTable.getString(i, "Precision");
                if (StringUtils.isNotBlank(precision) && !StringUtils.equals(precision, "0")) {
                    columnNode.setAttribute("Precision", precision);
                }

                String scale = fieldTable.getString(i, "Scale");
                if (StringUtils.isNotBlank(scale) && !StringUtils.equals(scale, "0")) {
                    columnNode.setAttribute("Scale", scale);
                }

                String length = fieldTable.getString(i, ConstantUtil.LENGTH);
                if (StringUtils.isNotBlank(length) && !StringUtils.equals(length, "0")) {
                    columnNode.setAttribute(ConstantUtil.LENGTH, length);
                }

            }
            columnNode.setAttribute("DataElementKey", dataElementKey);
            String description = fieldTable.getString(i, ConstantUtil.DESCRIPTION);
            if (StringUtils.isNotBlank(description)) {
                columnNode.setAttribute(ConstantUtil.DESCRIPTION, description);
            }

            columnNode.setAttribute("IgnoreQuery", fieldTable.getInt(i, "IgnoreQuery") == 0 ? "false" : "true");
            if ("false".equalsIgnoreCase(columnNode.getAttributes().get("IgnoreQuery")) || !StringUtils.isNotEmpty(columnNode.getAttributes().get("IgnoreQuery"))) {
                columnNode.getAttributes().remove("IgnoreQuery");
            }

            columnNode.setAttribute(ConstantUtil.CACHE, fieldTable.getInt(i, ConstantUtil.CACHE) == 0 ? "false" : "true");
            if ("false".equalsIgnoreCase(columnNode.getAttributes().get(ConstantUtil.CACHE)) || !StringUtils.isNotEmpty(columnNode.getAttributes().get(ConstantUtil.CACHE))) {
                columnNode.getAttributes().remove(ConstantUtil.CACHE);
            }
            if (RowState.NEW != fieldTable.getState(i)) {
                columnNode.setAttribute("Persist", fieldTable.getInt(i, "Persist") == 0 ? "false" : "true");
            }
            columnNode.setAttribute(ConstantUtil.IS_PRIMARY, fieldTable.getInt(i, ConstantUtil.IS_PRIMARY) == 0 ? "false" : "true");
            columnNode.setAttribute("Expand", fieldTable.getInt(i, "Expand") == 0 ? "false" : "true");
            columnNode.setAttribute("AccessControl", fieldTable.getInt(i, "AccessControl") == 0 ? "false" : "true");
            columnNode.setAttribute("IgnoreSave", fieldTable.getInt(i, "IgnoreSave") == 0 ? "false" : "true");
            columnNode.setAttribute("Hidden", fieldTable.getInt(i, "Hidden") == 0 ? "false" : "true");


            String sortType = fieldTable.getString(i, ConstantUtil.SORT_TYPE);
            if (StringUtils.isBlank(sortType)) {
                columnNode.setAttribute(ConstantUtil.SORT_TYPE, "");
            } else {
                columnNode.setAttribute(ConstantUtil.SORT_TYPE, SortType.toString(Integer.parseInt(sortType)));
            }

            String periodGranularity = fieldTable.getString(i, ConstantUtil.PERIOD_GRANULARITY);
            if (StringUtils.isBlank(periodGranularity)) {
                columnNode.setAttribute(ConstantUtil.PERIOD_GRANULARITY, "");
            } else {
                columnNode.setAttribute(ConstantUtil.PERIOD_GRANULARITY, DMPeriodGranularityType.toString(Integer.parseInt(periodGranularity)));
            }

            String supportI18n = fieldTable.getString(i, ConstantUtil.SUPPORT_I18N);
            supportI18n = StringUtils.isBlank(supportI18n) ? "false" : supportI18n;
            columnNode.setAttribute(ConstantUtil.SUPPORT_I18N, supportI18n);


            String splitType = fieldTable.getString(i, ConstantUtil.SPLIT_TYPE);
            if (StringUtils.isBlank(splitType)) {
                columnNode.setAttribute(ConstantUtil.SPLIT_TYPE, "");
            } else {
                columnNode.setAttribute(ConstantUtil.SPLIT_TYPE, DataSplitType.toString(Integer.parseInt(splitType)));
            }

            String groupType = fieldTable.getString(i, ConstantUtil.GROUP_TYPE);
            if (StringUtils.isBlank(groupType)) {
                columnNode.setAttribute(ConstantUtil.GROUP_TYPE, "");
            } else {
                if (!StringUtils.equals(groupType, "-1")) {
                    columnNode.setAttribute(ConstantUtil.GROUP_TYPE, groupType);
                }
            }

            // TODO 下面不知道为什么要怎么写？
            MetaForm metaForm = diff.getMetaForm();
            MetaTable table;
            if (Objects.isNull(metaForm)) {
                table = curDataObject.getTable(tableKey);
            } else {
                table = metaForm.getDataSource().getDataObject().getTable(tableKey);
            }
            if (table != null) {
                MetaColumn metaColumn = table.get(orgColKey);
                String defaultValue = null;
                if (metaColumn != null) {
                    defaultValue = metaColumn.getDefaultValue();
                }
                if (StringUtils.isBlank(defaultValue)) {
                    columnNode.setAttribute("DefaultValue", fieldTable.getString(i, "DefaultValue"));
                } else {
                    columnNode.setAttributeNotRemove("DefaultValue", fieldTable.getString(i, "DefaultValue"));
                }
            } else {
                columnNode.setAttribute("DefaultValue", fieldTable.getString(i, "DefaultValue"));
            }
        }

        if (!isReMigraiton && diff.getDataObject() != null && StringUtils.isBlank(diff.getDataObject().getExtend())) {
            String  notMigraitonSysField = notMigraitonSysFields.toString();
            if (!StringUtils.contains(notMigraitonSysField, ConstantUtil.POID)) {
                TagNode column = new TagNode(ConstantUtil.COLUMN, null);
                column.setAttribute(ConstantUtil.KEY, ConstantUtil.POID);
                column.setAttribute(ConstantUtil.CAPTION, "父对象标识");
                column.setAttribute(ConstantUtil.DATA_TYPE, "Long");
                children.add(column);
            }
            if (!StringUtils.contains(notMigraitonSysField, ConstantUtil.SOID)) {
                TagNode column = new TagNode(ConstantUtil.COLUMN, null);
                column.setAttribute(ConstantUtil.KEY, ConstantUtil.SOID);
                column.setAttribute(ConstantUtil.CAPTION, "主对象标识");
                column.setAttribute(ConstantUtil.DATA_TYPE, "Long");
                children.add(column);
            }
            if (!StringUtils.contains(notMigraitonSysField, ConstantUtil.DVERID)) {
                TagNode column = new TagNode(ConstantUtil.COLUMN, null);
                column.setAttribute(ConstantUtil.KEY, ConstantUtil.DVERID);
                column.setAttribute(ConstantUtil.CAPTION, "对象明细版本");
                column.setAttribute(ConstantUtil.DATA_TYPE, "Integer");
                children.add(column);
            }
            if (StringUtils.equals(root.getAttributes().get(ConstantUtil.SECONDARY_TYPE), "Migration") && !StringUtils.contains(notMigraitonSysField, ConstantUtil.CREATE_TIME)) {
                TagNode column = new TagNode(ConstantUtil.COLUMN, null);
                column.setAttribute(ConstantUtil.KEY, ConstantUtil.CREATE_TIME);
                column.setAttribute(ConstantUtil.CAPTION, "制单日期");
                column.setAttribute(ConstantUtil.DATA_TYPE, "DateTime");
                children.add(column);
            }
            if (StringUtils.equals(root.getAttributes().get(ConstantUtil.SECONDARY_TYPE), "Migration") && !StringUtils.contains(notMigraitonSysField, ConstantUtil.MODIFY_TIME)) {
                TagNode column = new TagNode(ConstantUtil.COLUMN, null);
                column.setAttribute(ConstantUtil.KEY, ConstantUtil.MODIFY_TIME);
                column.setAttribute(ConstantUtil.CAPTION, "修改时间");
                column.setAttribute(ConstantUtil.DATA_TYPE, "DateTime");
                children.add(column);
            }
        }
    }

    private static void dealPrimaryTable(String isPrimary, Diff diff, TagNode curNode, String dataType) {
        TagNode rootNode = diff.getXmlTree().xmlTree.getRoot();
        String tagName = rootNode.getTagName();
        String extend = rootNode.getAttributes().get(ConstantUtil.EXTEND);
        String formType = rootNode.getAttributes().get("FormType");
        Boolean isMigraiton =  StringUtils.equals(rootNode.getAttributes().get(ConstantUtil.SECONDARY_TYPE), "Migration");
        if (StringUtils.equals(tagName, ConstantUtil.DATA_OBJECT) && StringUtils.isNotBlank(extend)) {
            return;
        }
        if (StringUtils.equals(tagName, "Form") && Objects.isNull(diff.getDataObjectXmlTree()) && StringUtils.isNotBlank(extend)) {
            return;
        }

        if (StringUtils.equalsAnyIgnoreCase(isPrimary, "1", "true") ) {
            if (StringUtils.equalsAnyIgnoreCase(dataType, DataObjectSecondaryType.STR_CHAINDICT, DataObjectSecondaryType.STR_DICT)) {
                DICT_HEAD_TABLE_COLUMN_LIST.forEach(columnMap -> addColumnNode(curNode, columnMap));
                curNode.getParent().getParent().getAttributes().put(ConstantUtil.PRIMARY_TABLE_KEY, curNode.getAttributes().get(ConstantUtil.KEY));
                return;
            }

            List<TagNode> columnNodeList = curNode.findNodesByTagName(ConstantUtil.COLUMN);
            List<String> existColumnKeyList = columnNodeList.stream().filter(tagNode -> {
                String columnKey = tagNode.getAttributes().get(ConstantUtil.KEY);
                return ConstantUtil.PRIMARY_TABLE_FIELDS.contains(columnKey) || StringUtils.equalsIgnoreCase(columnKey, ConstantUtil.OID);
            }).map(tagNode -> tagNode.getAttributes().get(ConstantUtil.KEY)).collect(Collectors.toList());

            if (!existColumnKeyList.contains(ConstantUtil.OID)) { // TODO OID没有，基本上是功能马甲
                return;
            }

            /* if (!isMigraiton && !"Report".equals(formType)) {
                List<TagNode> primaryColumnNodeList = PRIMARY_TABLE_COLUMN_LIST.stream()
                        .filter(itemMap -> {
                            String key = itemMap.get(ConstantUtil.KEY);
                            return !existColumnKeyList.contains(key);
                        }).map(itemMap -> {
                            TagNode node = new TagNode(ConstantUtil.COLUMN, null);
                            node.setAttribute(ConstantUtil.KEY, itemMap.get(ConstantUtil.KEY));
                            node.setAttribute(ConstantUtil.CAPTION, itemMap.get(ConstantUtil.CAPTION));
                            node.setAttribute(ConstantUtil.DataElementKey, itemMap.get(ConstantUtil.DataElementKey));
                            node.setAttribute(ConstantUtil.DefaultValue, itemMap.get(ConstantUtil.DefaultValue));
                            return node;
                        }).collect(Collectors.toList());
                curNode.getChildren().addAll(primaryColumnNodeList);
            } */
            curNode.getParent().getParent().getAttributes().put(ConstantUtil.PRIMARY_TABLE_KEY, curNode.getAttributes().get(ConstantUtil.KEY));
            return;
        }

        if (StringUtils.equalsAnyIgnoreCase(dataType, DataObjectSecondaryType.STR_CHAINDICT, DataObjectSecondaryType.STR_DICT)) {
            return;
        }

        if (Objects.isNull(curNode)) {
            return;
        }

        String dataObjectKey;
        if (StringUtils.equalsIgnoreCase(diff.getReserveOne(), ConstantUtil.DATA_OBJECT)) {
            MetaDataObject dataObject = diff.getDataObject();
            dataObjectKey = dataObject.getKey();
        } else {
            MetaDataObject dataObject = diff.getMetaForm().getDataSource().getDataObject();
            dataObjectKey = dataObject.getKey();
        }

      /*  for (String primaryColumnKey : ConstantUtil.PRIMARY_TABLE_FIELDS) {
            removeColumnNode(curNode, primaryColumnKey, dataObjectKey);
        }*/
    }

    private static void replaceTableKey(Diff diff, String orgTableKey, String tableKey) {
        TagNode dataObjectNode;
        if (StringUtils.equalsIgnoreCase(diff.getMetaObjectType().name, ConstantUtil.DATA_OBJECT)) {
            dataObjectNode = diff.getXmlTree().xmlTree.getRoot();
        } else {
            TagNode dataNode = diff.getXmlTree().xmlTree.getRoot().getChildByTagName("DataSource");
            dataObjectNode = dataNode.findFirstTagNodeByTagName(ConstantUtil.DATA_OBJECT);
        }

        String primaryTableKey = dataObjectNode.getAttributes().get(ConstantUtil.PRIMARY_TABLE_KEY);
        if (StringUtils.equalsIgnoreCase(primaryTableKey, orgTableKey)) {
            dataObjectNode.setAttribute(ConstantUtil.PRIMARY_TABLE_KEY, tableKey);
        }

        List<TagNode> tableNodeList = dataObjectNode.findNodesByTagName(ConstantUtil.TABLE);
        for (TagNode tagNode : tableNodeList) {
            String parentTableKey = tagNode.getAttributes().get(ConstantUtil.PARENT_KEY);
            if (StringUtils.equalsIgnoreCase(parentTableKey, orgTableKey)) {
                tagNode.setAttribute(ConstantUtil.PARENT_KEY, tableKey);
            }

            String indexPrefix = tagNode.getAttributes().get(ConstantUtil.INDEX_PREFIX);
            if (StringUtils.equalsIgnoreCase(indexPrefix, orgTableKey)) {
                tagNode.setAttribute(ConstantUtil.INDEX_PREFIX, tableKey);
            }
        }

        if (Objects.isNull(diff.getMetaForm())) {
            return;
        }

        TagNode rootNode = diff.getXmlTree().xmlTree.getRoot();
        TagNode bodyNode = rootNode.getChildByTagName("Body");
        if (Objects.isNull(bodyNode)) {
            return;
        }

        List<AbstractNode> bodyChildNodeList = bodyNode.getChildren();
        if (CollectionUtils.isEmpty(bodyChildNodeList)) {
            return;
        }

        for (AbstractNode bodyChildNode : bodyChildNodeList) {
            if (!(bodyChildNode instanceof TagNode)) {
                continue;
            }

            TagNode tagNode = (TagNode) bodyChildNode;
            String tagName = tagNode.getTagName();
            if (!StringUtils.equalsAnyIgnoreCase(tagName, MetaDataBinding.TAG_NAME, ConstantUtil.CONDITION, ConstantUtil.CONDITION_TARGET,
                    ConstantUtil.GRID_ROW, ConstantUtil.LIST_VIEW, ConstantUtil.COLUMN_EXPAND)) {
                continue;
            }

            Map<String, String> attributes = tagNode.getAttributes();
            String tableAttrValue = attributes.get(ConstantUtil.TABLE_KEY);
            if (!StringUtils.equalsIgnoreCase(tableAttrValue, orgTableKey)) {
                continue;
            }

            tagNode.setAttribute(ConstantUtil.TABLE_KEY, tableKey);
        }
    }

    private static void dealParameterCollection(DataTable ed_parameterCollection, TagNode parentNode, Long parentOID) throws Throwable {
        if (Objects.isNull(parentNode) || Objects.isNull(parentOID)) {
            return;
        }

        List<TagNode> parameterCollection = parentNode.findNodesByTagName(MetaParameterCollection.TAG_NAME);
        TagNode parameterCollectionNode = CollectionUtils.isNotEmpty(parameterCollection) ? parameterCollection.get(0) : null;

        ed_parameterCollection.setShowDeleted(true);
        for (int i = 0; i < ed_parameterCollection.size(); i++) {
            Long poid = ed_parameterCollection.getLong(i, ConstantUtil.POID);
            if (!Objects.equals(poid, parentOID)) {
                continue;
            }
            if (Objects.isNull(parameterCollectionNode)) {
                parameterCollectionNode = new TagNode(MetaParameterCollection.TAG_NAME, null);
                parentNode.addNode(parameterCollectionNode);
                continue;
            }
            parameterCollectionNode.getChildren().clear();
        }

        for (int i = 0; i < ed_parameterCollection.size(); i++) {
            Long rowPOID = ed_parameterCollection.getLong(i, ConstantUtil.POID);
            if (!Objects.equals(rowPOID, parentOID)) {
                continue;
            }

            if (RowState.DELETED == ed_parameterCollection.getState(i)) {
                continue;
            }

            TagNode parameterNode = new TagNode(ConstantUtil.PARAMETER, null);
            parameterCollectionNode.addNode(parameterNode);

            parameterNode.setAttribute(ConstantUtil.DATA_TYPE, ed_parameterCollection.getString(i, ConstantUtil.DATA_TYPE));
            parameterNode.setAttribute(ConstantUtil.DESCRIPTION, ed_parameterCollection.getString(i, "Description"));

            String sourceType = ed_parameterCollection.getString(i, "SourceType");
            String value = ed_parameterCollection.getString(i, ConstantUtil.VALUE);
            if ("Const".equalsIgnoreCase(sourceType)) {
                parameterNode.setAttribute("SourceType", sourceType);
                parameterNode.setAttribute(ConstantUtil.VALUE, value);
            } else {
                parameterNode.setAttribute("Formula", value);
            }
        }
    }

    /**
     * 替换表单中所有引用此数据列的列标识
     */
    private static void replaceColumnKey(Diff diff, String orgColKey, String columnKey) {
        if (Objects.isNull(diff.getMetaForm())) {
            return;
        }
        //在表单中修改数据源
        XmlTree xmlTree = diff.getXmlTree().xmlTree;
        TagNode rootNode = xmlTree.getRoot();

        TagNode bodyNode = rootNode.getChildByTagName("Body");
        if (Objects.isNull(bodyNode)) {
            return;
        }

        List<AbstractNode> bodyChildNodeList = bodyNode.getChildren();
        if (CollectionUtils.isEmpty(bodyChildNodeList)) {
            return;
        }

        for (AbstractNode bodyChildNode : bodyChildNodeList) {
            if (!(bodyChildNode instanceof TagNode)) {
                continue;
            }

            TagNode tagNode = (TagNode) bodyChildNode;
            String tagName = tagNode.getTagName();
            if (!StringUtils.equalsAnyIgnoreCase(tagName, MetaDataBinding.TAG_NAME, ConstantUtil.CONDITION, ConstantUtil.CONDITION_TARGET,
                    ConstantUtil.GRID_CELL, ConstantUtil.LIST_VIEW_COLUMN, ConstantUtil.COLUMN_EXPAND)) {
                continue;
            }

            Map<String, String> attributes = tagNode.getAttributes();
            String columnAttrValue = attributes.get(ConstantUtil.COLUMN_KEY);
            if (!StringUtils.equalsIgnoreCase(columnAttrValue, orgColKey)) {
                continue;
            }

            tagNode.setAttribute(ConstantUtil.COLUMN_KEY, columnKey);
        }
    }

    private static Boolean changeDictBinding(Diff diff, DataTable fieldTable, String orgDictColKey, String dictColKey, String columnName) {
        BiFunction<List<TagNode>, String, TagNode> biFunction = (columnNodeList, expectedColumnKey) -> {
            Predicate<TagNode> predicate = columnNode -> {
                String columnKey = columnNode.getAttributes().get(ConstantUtil.KEY);
                return StringUtils.equalsIgnoreCase(columnKey, expectedColumnKey);
            };
            return columnNodeList.stream().filter(predicate).findFirst().orElse(null);
        };

        TagNode rootNode = diff.getXmlTree().xmlTree.getRoot();
        List<TagNode> columnNodeList = rootNode.findNodesByTagName("Column");

        String orgDictKey = getDictKey(orgDictColKey);
        String orgDictCodeKey = orgDictKey + "Code";
        String dictKey = getDictKey(dictColKey);
        String dictCodeKey = dictKey + "Code";

        TagNode dictCodeNode = biFunction.apply(columnNodeList, orgDictCodeKey);
        if (Objects.nonNull(dictCodeNode)) {
            dictCodeNode.setAttribute(ConstantUtil.KEY, dictCodeKey);
            dictCodeNode.setAttribute(ConstantUtil.CAPTION, columnName);
        }

        TagNode dictNode = biFunction.apply(columnNodeList, dictColKey);
        if (Objects.nonNull(dictCodeNode) && Objects.nonNull(dictNode)) {
            dictNode.setAttribute(ConstantUtil.CODE_COLUMN_KEY, dictCodeKey);
        }

        if (Objects.nonNull(dictCodeNode)) {
            return true;
        }

        boolean hasCodeColumn = false;
        for (int i = 0; i < fieldTable.size(); i++) {
            String columnKey = fieldTable.getString(i, ConstantUtil.COLUMN_KEY).trim();
            if (StringUtils.equalsIgnoreCase(columnKey, orgDictCodeKey)) {
                fieldTable.setString(i, ConstantUtil.COLUMN_KEY, dictCodeKey);
                hasCodeColumn = true;
            }
        }
        return hasCodeColumn;
    }

    private static String getDictKey(String key) {
        if (!StringUtils.endsWithIgnoreCase(key, "id")) {
            return key;
        }
        return StringUtils.substring(key, 0, key.length() - 2);
    }

    private static void addColumnNode(TagNode tableNode, Map<String, String> columnMap) {
        String columnKey = columnMap.get(ConstantUtil.KEY);
        String primaryKey = ConstantUtil.COLUMN + "@" + columnKey;

        Predicate<AbstractNode> predicate = childNode -> {
            if (!(childNode instanceof TagNode)) {
                return false;
            }
            TagNode childTagNode = (TagNode) childNode;
            return StringUtils.equals(childTagNode.getPrimaryKey(), primaryKey);
        };
        boolean flag = tableNode.getChildren().stream().anyMatch(predicate);
        if (flag) {
            return;
        }

        TagNode columnNode = new TagNode(ConstantUtil.COLUMN, null);
        columnNode.setAttribute(ConstantUtil.KEY, columnKey);
        columnNode.setAttribute(ConstantUtil.CAPTION, columnMap.get(ConstantUtil.CAPTION));
        columnNode.setAttribute(ConstantUtil.DATA_TYPE, columnMap.get(ConstantUtil.DATA_TYPE));
        columnNode.setAttribute(ConstantUtil.LENGTH, columnMap.get(ConstantUtil.LENGTH));
        tableNode.addNode(columnNode);
    }

    private static void removeColumnNode(TagNode tableNode, String columnKey, String dataObjectKey) {
        String tableKey = tableNode.getAttributes().get(ConstantUtil.KEY);
        boolean flag = XmlDiffProcessor.fieldHastRely(columnKey, dataObjectKey, tableKey);
        if (flag) {
            tableNode.deleteChildByTagKey(columnKey);
        }
    }

    private static TagNode getTableCollectionNode(XmlTreeWithPath xmlTree) throws Throwable {
        TagNode rootNode = xmlTree.xmlTree.getRoot();
        if (rootNode.getTagName().equalsIgnoreCase(ConstantUtil.DATA_OBJECT)){
            return rootNode.getOrCreateChildByKey(ConstantUtil.TABLE_COLLECTION,"");
        }else {
            TagNode dataSourceNode = rootNode.getChildByTagName(ConstantUtil.DATA_SOURCE);
            String refObjectKey = dataSourceNode.getAttributes().get("RefObjectKey");
            if (StringUtils.isNotEmpty(refObjectKey)){
                MetaDataObject metaDataObject = MetaFactory.getGlobalInstance().getDataObject(refObjectKey);
                String filePath = LoadFileTree.loadFilePathByDataObjectFieldKey(metaDataObject.getKey());
                XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(filePath);
                return xmlTreeWithPath.xmlTree.getRoot().getChildByTagName(ConstantUtil.TABLE_COLLECTION);
            }else {
                return   rootNode.getOrCreateChildByKey(ConstantUtil.DATA_SOURCE,"").getOrCreateChildByKey(ConstantUtil.DATA_OBJECT,"").getOrCreateChildByKey(ConstantUtil.TABLE_COLLECTION,"");
            }
        }



    }

    public static String getGridCellType(String cellDataType, String columnKey) {
        String type = "";
        switch (cellDataType) {
            case DataType.STR_STRING:
                if (StringUtils.isNotEmpty(columnKey) && columnKey.endsWith("Time")) {
                    type = ControlType.STR_TIMEPICKER;// 日期
                }
                break;
            case DataType.STR_INT:
                if (StringUtils.isNotEmpty(columnKey)) {
                    if (columnKey.startsWith("Is")) {
                        type = ControlType.STR_CHECKBOX;
                    }
                } else {
                    type = ControlType.STR_CHECKBOX;// 下拉框
                }
                break;
            case DataType.STR_LONG:
                if (StringUtils.isNotEmpty(columnKey)) {
                    if (columnKey.endsWith("ID")) {
                        type = ControlType.STR_DICT;// 字典
                    } else if (columnKey.endsWith("Date")) {
                        type = ControlType.STR_UTCDATEPICKER;// 日期
                    } else {
                        type = ControlType.STR_DYNAMICDICT;// 动态字典
                    }
                } else {
                    type = ControlType.STR_UTCDATEPICKER;// 日期
                }
                break;
            case DataType.STR_DATE:
            case DataType.STR_DATETIME:
                if (StringUtils.isNotEmpty(columnKey) && columnKey.endsWith("Time")) {
                    type = ControlType.STR_DATEPICKER;
                }
                break;
            case DataType.STR_NUMERIC:
                type = ControlType.STR_NUMBEREDITOR;
                break;
            case DataType.STR_TEXT:// 文本域
                type = ControlType.STR_TEXTAREA;
                break;
            case DataType.STR_BINARY:
            default:
                type = ControlType.STR_OTHER;
                break;
        }
        return type;
    }

    public static TagNode addDomainPropertyToNode(TagNode node, String controlType, String dataElementKey) throws Throwable{
        MetaDataElement dataElement = MetaUtil.getDataElement(MetaFactory.getGlobalInstance(), dataElementKey);
        if(dataElement == null) return node;
        MetaDomain domain = dataElement.getDomain();
        if(controlType.equals(ControlType.STR_DICT)){
            String itemKey = domain.getItemKey();
            Boolean allowMultiSelection = domain.isAllowMultiSelection();
            node.setAttribute(Property.itemKey.name, itemKey);
            if(allowMultiSelection != null){
                node.setAttribute(Property.AllowMultiSelection.name, String.valueOf(allowMultiSelection));
            }
        }else if(controlType.equals(ControlType.STR_NUMBEREDITOR)){
            Integer precision = domain.getPrecision();
            Integer scale = domain.getScale();
            if(precision != null){
                node.setAttribute(Property.Precision.name, String.valueOf(precision));
            }
            if(scale != null){
                node.setAttribute(Property.Scale.name, String.valueOf(scale));
            }
        }else if(controlType.equals(ControlType.STR_COMBOBOX)){
            Integer sourceType = domain.getSourceType();
            if(sourceType != null){
                node.setAttribute(Property.SourceType.name, ComboBoxSourceType.format(sourceType));
                if(sourceType == ComboBoxSourceType.ITEMS){
                    MetaListBoxItemCollection items = domain.getItems();
                    Iterator<MetaDefaultItem> iterator = items.iterator();
                    while (iterator.hasNext()){
                        MetaDefaultItem item = iterator.next();
                        TagNode itemNode = new TagNode(item.getTagName(), null);
                        itemNode.setAttribute(Property.caption.name, item.getCaption());
                        itemNode.setAttribute(Property.key.name, item.getKey());
                        itemNode.setAttribute(Property.Value.name, item.getValue());
                        node.addNode(itemNode);
                    }
                }else if(sourceType == ComboBoxSourceType.PARAGROUP){
                    node.setAttribute(Property.GroupKey.name, String.valueOf(domain.getGroupKey()));
                }
            }
        }
        if(domain.getLength() != null){
            node.setAttribute(Property.maxLength.name, String.valueOf(domain.getLength()));
        }
        if(domain.getCase() != null){
            node.setAttribute(Property.CaseType.name, String.valueOf(domain.getCase()));
        }
        return node;
    }

    private static void handleExtraLayout(TagNode panelNode, int selectedRow, boolean addFlag) {
        TagNode groupCollectionNode = panelNode.findFirstTagNodeByTagName(MetaGroupCollection.TAG_NAME);
        if (Objects.isNull(groupCollectionNode)) {
            return;
        }

        List<TagNode> groupNodeList = groupCollectionNode.findNodesByTagName(MetaGroup.TAG_NAME);
        if (CollectionUtils.isEmpty(groupNodeList)) {
            return;
        }

        for (TagNode groupNode : groupNodeList) {
            Map<String, String> attributes = groupNode.getAttributes();
            String startRow = attributes.get(MetaConstants.GROUP_START_ROW);
            String endRow = attributes.get(MetaConstants.GROUP_END_ROW);
            int startRowIndex = Integer.parseInt(startRow);
            int endRowIndex = Integer.parseInt(endRow);
            if (startRowIndex <= selectedRow && endRowIndex >= selectedRow) {
                if (addFlag) {
                    attributes.put(MetaConstants.GROUP_END_ROW, String.valueOf((endRowIndex + 1)));
                } else {
                    attributes.put(MetaConstants.GROUP_END_ROW, String.valueOf((endRowIndex - 1)));
                }
            }
            if (startRowIndex > selectedRow && endRowIndex > selectedRow) {
                if (addFlag) {
                    attributes.put(MetaConstants.GROUP_START_ROW, String.valueOf((startRowIndex + 1)));
                    attributes.put(MetaConstants.GROUP_END_ROW, String.valueOf((endRowIndex + 1)));
                } else {
                    attributes.put(MetaConstants.GROUP_START_ROW, String.valueOf((startRowIndex - 1)));
                    attributes.put(MetaConstants.GROUP_END_ROW, String.valueOf((endRowIndex - 1)));
                }


                TagNode handleNode = groupNode.findFirstTagNodeByTagName(MetaHandle.TAG_NAME);
                Map<String, String> handleAttrs = handleNode.getAttributes();
                String handleLabelRow = handleAttrs.get(ConstantUtil.Y);
                int handleLabelRowIndex = Integer.parseInt(handleLabelRow);
                if (addFlag) {
                    handleAttrs.put(ConstantUtil.Y, String.valueOf((handleLabelRowIndex + 1)));
                } else {
                    handleAttrs.put(ConstantUtil.Y, String.valueOf((handleLabelRowIndex - 1)));
                }
            }
        }
    }
}
