package com.bokesoft.yes.design.cmd;

import com.bokesoft.erp.webdesigner.language.infrastructure.index.IndexFacade;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.IndexFileWrapper;
import com.bokesoft.yes.helper.FilePathHelper;
import org.json.JSONArray;
import org.json.JSONObject;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UICommand {
	/**
	 * 命令标志
	 */
	public final String key;
	/**
	 * 命令内容
	 */
	public final Object content;

	public UICommand(String key, Object content) {
		this.key = key;
		this.content = content;
	}

	/**
	 * 重新设置依赖
	 */
	public static UICommand reloadDependency(JSONObject dependency) {
		return new UICommand("ReloadDependency", dependency);
	}

	/**
	 * 重新渲染控件
	 */
	public static UICommand renderControl(String fieldKey) {
		return new UICommand("RenderControl", fieldKey);
	}

	/**
	 * 重新定位
	 */
	public static UICommand locate(String fieldKey) {
		return new UICommand("locate", fieldKey);
	}
	/**
	 * 刷新菜单树
	 */
	public static UICommand refreshMenuTree(String fieldKey) {
		return new UICommand("refreshMenuTree", fieldKey);
	}

	/**
	 * 重新渲染面板
	 */
	public static UICommand renderPanelLayout(String panelKey) {
		return new UICommand("RenderPanelLayout", panelKey);
	}

	/**
	 * 重新渲染表单
	 */
	public static UICommand renderForm() {
		return new UICommand("RenderForm", null);
	}

	/**
	 * 收起文件树
	 */
	public static UICommand freshFileTree() {
		return new UICommand("freshFileTree", null);
	}
	/**
	 * 重新计算控件的Enable和Visible
	 */
	public static UICommand resetUIStatus() {
		return new UICommand("ResetUIStatus", null);
	}

	/**
	 * 重新加载某个表单
	 *
	 * @param formKey
	 * @return
	 */
	public static UICommand reloadFormKey(String formKey) {
		return new UICommand("ReloadFormKey", formKey);
	}

	/**
	 * 替换XML的内容，这个代码不支持数据源，数据源采用模态窗口处理，其XML源代码整体替换
	 */
	public static UICommand updateXMLSource(String xmlPath, String objectType, String key, String newNodeText) {
		JSONObject tmp = new JSONObject();
		tmp.put("xmlPath", xmlPath);
		tmp.put("objectType", objectType);
		tmp.put("key", key);
		tmp.put("newNodeText", newNodeText);
		return new UICommand("UpdateXMLSource", tmp);
	}

	/**
	 * 适用于数据映射自动建立表格
	 * @param jsonArray
	 * @return
	 */
	public static UICommand rebuildTable(List<com.alibaba.fastjson.JSONObject> jsonArray) {
		return new UICommand("rebuildTable", jsonArray);
	}/**
	 * 适用于Web表单
	 * @param jsonArray
	 * @return
	 */
	public static UICommand uadataWebJson(Object jsonArray) {
		return new UICommand("uadataWebJson", jsonArray);
	}

	/**
	 * 更新diff的FilePath属性
	 */
	public static UICommand updateDiffFilePath(Map<String, String> diffSequenceToFilePath) {
		JSONObject tmp = new JSONObject();
		for (Map.Entry<String, String> entry : diffSequenceToFilePath.entrySet()) {
			tmp.put(entry.getKey(), entry.getValue());
		}
		return new UICommand("UpdateDiffFilePath", tmp);
	}

	/**
	 * 重新加载文件树，并定位到特定的文件
	 *
	 * @param filePath
	 * @return
	 */
	public static UICommand reloadFileTree(String filePath) {
		UICommand.reloadIndex(filePath);
		JSONObject tmp = new JSONObject();
		tmp.put("filePath", FilePathHelper.toFrontFilePath(filePath));
		tmp.put("parentFilePath", FilePathHelper.toFrontFilePath(new File(filePath).getParent()));
        return new UICommand("ReloadFileTree", tmp);
	}

	private static String getParentFilePath(String filePath, String projectKey) {
			String parent1 = new File(filePath).getParent();
			if (parent1 != null) {
				if (parent1.endsWith(projectKey)) {
					return parent1;
				} else {
					parent1 = getParentFilePath(parent1, projectKey);
				}
			}
		return parent1;
	}

	public static UICommand reloadFileTreeAndParentFilePath(String filePath,String projectKey) {
		UICommand.reloadIndex(filePath);
		JSONObject tmp = new JSONObject();
		tmp.put("filePath", FilePathHelper.toFrontFilePath(filePath));
		String temp = getParentFilePath(filePath, projectKey);
		tmp.put("parentFilePath", FilePathHelper.toFrontFilePath(temp));
		return new UICommand("ReloadFileTree", tmp);
	}

	/**
	 * 重新加载Xml源文件
	 *
	 * @param filePath
	 * @return
	 */
	public static UICommand reloadXmlSource(String filePath) {
		UICommand.reloadIndex(filePath);
		return new UICommand("ReloadXmlSource", FilePathHelper.toFrontFilePath(filePath));
	}
	/**
	 * 清楚ScopeCache
	 *
	 * @param key
	 * @return
	 */
	public static UICommand removeScopeCache(String key) {
		return new UICommand("RemoveScopeCache", key);
	}

	/**
	 * 运行某个界面
	 *
	 * @param formKey
	 * @return
	 */
	public static UICommand runFormKey(String formKey) {
		return new UICommand("RunFormKey", formKey);
	}

	/**
	 * 关闭某个界面
	 *
	 * @param formKey
	 * @return
	 */
	public static UICommand closeFormKey(String formKey) {
		return new UICommand("CloseFormKey", formKey);
	}

	/**
	 * 关闭源代码文件
	 *
	 * @param filePath
	 * @return
	 */
	public static UICommand closeFilePath(String filePath) {
		return new UICommand("CloseFilePath", FilePathHelper.toFrontFilePath(filePath));
	}

	/**
	 * 显示错误
	 *
	 * @param xmlError
	 * @return
	 */
	public static UICommand showError(String xmlError) {
		return new UICommand("ShowError", xmlError);
	}
	/**
	 * 显示信息
	 *
	 * @param
	 * @return
	 */
	public static UICommand showTip(String tip) {
		return new UICommand("showTip", tip);
	}
	public static UICommand showTipByList(List showTipByList) {
		return new UICommand("showTipByList", showTipByList);
	}

	/**
	 * 重新加载菜单树
	 *
	 * @return
	 */
	public static UICommand reloadMenuTree() {
		return new UICommand("ReloadMenuTree", null);
	}
	/**
	 * 重新加载子节点数据
	 *
	 * @param filePath
	 * @return
	 */
	public static UICommand refreshFileTreeChildren(String filePath) {
		UICommand.reloadIndex(filePath);
		String frontFilePath = FilePathHelper.toFrontFilePath(new File(filePath).getParent());
		return new UICommand("RefreshFileTreeChildren", frontFilePath);
	}

	/**
	 * 重新加载Xml源文件(通过指定临时文件)
	 *
	 * @param filePath
	 * @return
	 */
	public static UICommand reloadXmlSourceByTemp(String filePath, String temPath) {
		JSONObject tmp = new JSONObject();
		tmp.put("filePath", FilePathHelper.toFrontFilePath(filePath));
		tmp.put("temPath", FilePathHelper.toFrontFilePath(temPath));
		return new UICommand("ReloadXmlSourceByTemp", tmp);
	}

	/**
	 * 回传document差异
	 *
	 * @param formKey
	 * @param documentDirty
	 * @return
	 */
	public static UICommand processDocumentDirty(String formKey, JSONObject documentDirty) {
		JSONObject content = new JSONObject();
		content.put("formKey", formKey);
		content.put("documentDirty", documentDirty);
		return new UICommand("ProcessDocumentDirty", content);
	}

    private static void reloadIndex(String filePath) {
        String tempFilePath = XmlFileProcessor.instance.getTmpFile(filePath);
        IndexFileWrapper file = IndexFileWrapper.newInstance(filePath, tempFilePath);
        IndexFacade.reload(file);
    }

	public JSONObject toJson() {
		JSONObject result = new JSONObject();
		result.put("key", key);
		result.put("content", content);
		return result;
	}

	public static JSONArray toJson(List<UICommand> uiCommands) {
		JSONArray result = new JSONArray();
		for (UICommand uiCommand : uiCommands) {
			result.put(uiCommand.toJson());
		}
		return result;
	}

	@Override
	public String toString() {
		return toJson().toString();
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) {
            return true;
        }
		if (!(o instanceof UICommand)) {
            return false;
        }
		UICommand uiCommand = (UICommand) o;
		return Objects.equals(key, uiCommand.key) && Objects.equals(content, uiCommand.content);
	}

	@Override
	public int hashCode() {
		return Objects.hash(key, content);
	}
}
