package com.bokesoft.yes.design.cmd;

import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.helper.FilePathHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.DefaultContext;

/**
 * 取文件内容
 */
public class SearchFilePathCmd extends DesignerServiceCmd {

	public static final String CMD = "SearchFilePath";

	private String search;
	/**
	 * 搜索的最大个数
	 */
	private int maxCount;

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		search = (String) arguments.get("search");
		maxCount = TypeConvertor.toInteger(arguments.get("maxCount"));
	}

	@Override
	public Object innerDoCmd(DefaultContext context) throws Throwable {
		if (StringUtils.isBlank(search)) {
            return Collections.emptyList();
        }
		List<String[]> result = LoadFileTree.searchNodes(context, search, maxCount);
		if (CollectionUtils.isEmpty(result)) {
            return Collections.emptyList();
        }
		JSONArray jsonArray = new JSONArray();
		JSONArray jsonArray1 = getJsonArray(result, jsonArray);
		return jsonArray1;
	}

	private static synchronized JSONArray getJsonArray(List<String[]> result, JSONArray jsonArray) {
		//将result进行排序
		result.stream().filter(array -> !StringUtils.containsIgnoreCase(array[1], File.separatorChar + "initializeData" + File.separatorChar))
				.map(array -> {
					array[0] = FilePathHelper.toFrontFilePath(array[0]);
					array[1] = FilePathHelper.toFrontFilePath(array[1]);
					return array;
				}).sorted(Comparator.comparing(array -> array[0]))
				.forEachOrdered(array -> {
					String path = array[1];
					if (StringUtils.isNotBlank(path) && FileUtils.getFile(FilePathHelper.toBackFilePath(path)).isFile()) {
						JSONObject jsonObject = new JSONObject();
						jsonObject.put("text", array[0]);
						jsonObject.put("path", path);
						jsonArray.put(jsonObject);
					}
				});
		return jsonArray;
	}

	@Override
	public String getCmd() {
		return CMD;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new SearchFilePathCmd();
	}
}
