package com.bokesoft.yes.design.cmd;

import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.utils.RebuildTableUtil;
import com.bokesoft.yes.erp.dev.MetaTableCache;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.mysqls.group.meta.DataObjects;
import com.bokesoft.yes.util.FileUtil;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

/**
 * 退出设计器是保存全部xml
 */
public class SaveFilesCmd extends DesignerServiceCmd {

	public static final String CMD = "SaveFilesCmd";

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
	}

	@Override
	public Object innerDoCmd(DefaultContext context) throws Throwable {
		Map<String, Stack<String>> filePathToTmpFileMap = XmlFileProcessor.filePathToTmpFileMap;
		IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
		List<UICommand> result = new ArrayList<>();
		for (Map.Entry<String, Stack<String>> stringStackEntry : filePathToTmpFileMap.entrySet()) {
			Stack<String> value = stringStackEntry.getValue();
			if (value.size() == 0) {
				continue;
			}
			String tmpFilePath = value.peek();
			String filePath = stringStackEntry.getKey();
			Object[] actions = {"SaveFileContent: ", tmpFilePath};
			Performance.endActive(Performance.startAction(actions), actions);
			String tmpContent = FileUtil.File2String(tmpFilePath, "UTF-8");
			String tmpSecondLine = DesignIOMetaUtil.getSecondLine(tmpContent);
			String objectType = DesignIOMetaUtil.getSubString(tmpSecondLine, "<([A-Za-z_]\\w*)\\s");
			String key = DesignIOMetaUtil.getSubString(tmpSecondLine, "Key=\"([A-Za-z_]\\w*)\"");
			MetaFormProfile metaFormProfile = metaFactory.getMetaFormList().get(key);

			String newContent = FileUtils.readFileToString(new File(tmpFilePath), "UTF-8");
			boolean isNew = !(new File(filePath).exists());
			if (!isNew && tmpSecondLine.contains(ConstantUtil.VERSION)) {//不包含Version属性代码时马甲  略过
				int version = SaveFileContentCmd.checkFileVersion(filePath, newContent);
				newContent = SaveFileContentCmd.versionAddOne(newContent, version);
			}
			FileUtils.writeStringToFile(new File(filePath), newContent, "UTF-8");

			if(metaFormProfile == null) metaFormProfile = metaFactory.getExtFormList().get(key);

			if (MetaForm.TAG_NAME.equalsIgnoreCase(objectType)) {
				if(metaFormProfile != null && StringUtils.isEmpty(metaFormProfile.getExtend())){
					SaveFilesByFormKeyCmd.formatXml(metaFactory, filePath, key, MetaForm.TAG_NAME, result);
				}
				//保存后将当前form运行模式设置为程序运行
				metaFormProfile.setRunType(AppRunType.App);
			} else if (MetaDataObject.TAG_NAME.equalsIgnoreCase(objectType)){

			}
			if (!MetaDataObject.TAG_NAME.equalsIgnoreCase(objectType) &&
					metaFormProfile != null &&
					metaFactory.getMetaForm(key).getDataSource() != null) {
				DataObjects.getInstance().init(metaFactory, true);
				RebuildTableUtil.rebuildTable(context, filePath);
			}

			result.add(UICommand.reloadXmlSource(filePath));
		}
		XmlFileProcessor.filePathToTmpFileMap.clear();
		XmlFileProcessor.reFilePathToTmpFileMap.clear();
		MetaTableCache.init(MetaFactory.getGlobalInstance(),null,MetaTableCache.getMetaTables());
		return UICommand.toJson(result);

	}

	@Override
	public String getCmd() {
		return CMD;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new SaveFilesCmd();
	}
}
