package com.bokesoft.yes.design.cmd;


import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;


/**
 *
 */
public class RefreshDataObjectCmd extends DesignerServiceCmd {
	public static final String CMD = "RefreshDataObject";
	/**
	 * 路径
	 */
	private String formkey;

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		formkey = (String) arguments.get("formKeys");
	}

	@Override
	public Object innerDoCmd(DefaultContext defaultContext) throws Throwable {
		String sourcePath = LoadFileTree.loadFilePathByDataObjectFieldKey(formkey);
		JSONObject resJson = new JSONObject();
		try {
			List<MetaFormProfile> metaFormProfiles = DataObjectHelper.reload(null,formkey, sourcePath, null);
			List<String> formKeyList = metaFormProfiles.stream().map(item -> item.getKey()).collect(Collectors.toList());
			resJson.put("resultMsg","修改成功");
			resJson.put("formKeyList",formKeyList);
		} catch (Exception e) {
			LogSvr.getInstance().error("\n", e);
			resJson.put("formKeyList", Collections.emptyList());
			resJson.put("resultMsg","辅类型为字典、链式字典的需要保存后生效");
		}
		return resJson;
	}

	@Override
	public String getCmd() {
		return CMD;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new RefreshDataObjectCmd();
	}

}
