package com.bokesoft.yes.design.cmd;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import com.bokesoft.yes.meta.persist.dom.dataobject.MetaDataObjectLoad;
import com.bokesoft.yigo.common.def.*;
import com.bokesoft.yigo.meta.common.MetaVar;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.form.component.MetaEmbed;
import com.bokesoft.yigo.meta.form.component.control.properties.*;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.w3c.dom.Document;

import com.bokesoft.erp.metaobjectchange.MetaObjectChange;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.sql.CalcColumnItemKey;
import com.bokesoft.yes.design.sql.TransmitConditions;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.design.utils.ReloadForm;
import com.bokesoft.yes.erp.config.MetaFormNODBProcess;
import com.bokesoft.yes.helper.MetaObjectHelper;
import com.bokesoft.yes.meta.persist.dom.form.MetaFormLoad;
import com.bokesoft.yes.meta.persist.dom.form.MetaFormSave;
import com.bokesoft.yes.meta.persist.dom.xml.XmlCreator;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.mysqls.sql.SelectSqlInfo;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfos;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.common.MetaCondition;
import com.bokesoft.yigo.meta.common.MetaStatement;
import com.bokesoft.yigo.meta.commondef.MetaOperation;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import com.bokesoft.yigo.meta.form.component.control.MetaDict;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumn;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumnCollection;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRowCollection;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaColumnDef;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaColumnDefCollection;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGridLayoutPanel;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaRowDef;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaRowDefCollection;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.mid.base.DefaultContext;

import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.statement.select.FromItem;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.SelectExpressionItem;
import net.boke.jsqlparser.statement.select.SubSelect;

/**
 * 新增表单
 */
public class NewFormCmd extends DesignerServiceCmd {

    public static final String CMD = "NewForm";

    /**
     * 项目的名
     */
    public static String projectKey;
    /**
     * 表单类型
     */
    private int formType;
    /**
     * 新增的表单Key
     */
    private String formKey;
    /**
     * 新增的表单名称
     */
    private String formCaption;
    /**
     * 指定的目录
     */
    private String directory;
    /**
     * 是否指定的目录
     */
    private String isdirectory;
    /**
     * 是否引入数据对象
     */
    private String InDataObject;
    /**
     * 是否使用模板
     */
    private String IsTemplate;
    /**
     * 使用的模板类型
     */
    private String ModuleSelect;
    /**
     * 视图查询条件
     */
    private String QueryConditions;
    /**
     * 视图查询条件
     */
    private String AssociationForm;

    /**
     * Entry目录
     */
    private String Source;
    /**
     * 是否根据SQL生成报表
     */
    private String newReportFormBySQL;
    /**
     * 根据Sql创建报表
     */
    private String IsBySql;
    /**
     * 表前缀
     */
    private String tablePrefix;
    /**
     * 支持平台
     */
    private String platform;


    @Override
    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        projectKey = TypeConvertor.toString(arguments.get("projectKey")).trim();
        formType = TypeConvertor.toInteger(arguments.get("formType"));
        if (formType == 9) {
            formType = FormType.Normal;
        }
        platform = TypeConvertor.toString(arguments.get("Platform")).trim();
        formKey = TypeConvertor.toString(arguments.get("newFormKey")).trim(); // formKey有特殊的含义
        formCaption = TypeConvertor.toString(arguments.get("formCaption")).trim();
        directory = TypeConvertor.toString(arguments.get("directory")).trim();
        isdirectory = TypeConvertor.toString(arguments.get("IsDirectory")).trim();
        InDataObject = TypeConvertor.toString(arguments.get("InDataObject")).trim();
        IsTemplate = TypeConvertor.toString(arguments.get("IsTemplate")).trim();
        ModuleSelect = TypeConvertor.toString(arguments.get("ModuleSelect")).trim();
        QueryConditions = TypeConvertor.toString(arguments.get("QueryConditions")).trim();
        AssociationForm = TypeConvertor.toString(arguments.get("AssociationForm")).trim();
        Source = TypeConvertor.toString(arguments.get("Source")).trim();
        newReportFormBySQL = TypeConvertor.toString(arguments.get("newReportFormBySQL")).trim();
        IsBySql = TypeConvertor.toString(arguments.get("IsBySql")).trim();
        tablePrefix = TypeConvertor.toString(arguments.get("TablePrefix")).trim();
        if (StringUtils.isEmpty(tablePrefix)) {
            tablePrefix = "E";
        }
    }

    /**
     * 新增表单文件
     */
    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        // if ("1".equals(IsTemplate)){//使用模板
        IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
        if (globalInstance.getDataObject(formKey) != null && "新建数据对象".equals(InDataObject)) {
            throw new Exception("创建表单存在同名数据对象，请引用同名数据对象作为来源数据对象再创建表单");
        }
        if (StringUtils.isEmpty(InDataObject)) {
            InDataObject = "新建数据对象";
        }
        if (Objects.isNull(globalInstance.getMetaFormList().get(formKey))) {
            String fileName = formKey + ".xml";
            String content;
            if (formType == FormType.Report && "1".equals(IsBySql)) {
                final String strip = StringUtils.strip(newReportFormBySQL, "'");
                SelectSqlInfo sqlInfo = (SelectSqlInfo) SqlInfos.instance.getSqlInfo(strip);
                //处理报表表单
                MetaForm module = getModule(formType);
                MetaFormList metaFormList = globalInstance.getMetaFormList();
                MetaFormProfile element = MetaObjectHelper.deptClone(metaFormList.get(module.getKey()));
                element.setKey(formKey);
                element.setCaption(formCaption);
                MetaProject metaProject = globalInstance.getMetaProject(projectKey);
                element.setProject(metaProject);
                element.getForm().setProject(metaProject);
                metaFormList.add(element);
                content = testGetTablenameByAlias1(newReportFormBySQL, formKey, formCaption, sqlInfo);
            } else {
                content = getNewFormContent(formType, formKey, formCaption);
            }
            String filePath = LoadFileTree.newFile(projectKey, formType, fileName,
                    formKey,
                    formCaption, directory, isdirectory);
            String tmpFilePath = XmlFileProcessor.instance.saveTempFile(filePath, content, projectKey);
            File file = new File(filePath);
            //写入文件夹
            FileUtils.writeStringToFile(file, content, "UTF-8");
            String resource = LoadFileTree.getResource(tmpFilePath, projectKey);
            globalInstance.getMetaFormList().get(formKey).setResource(resource);
            EntryProcessor.instance.newForm(projectKey, formType, formKey, formCaption, Source, true);
//			if (formType == FormType.View || formType == FormType.Report) {
            ReloadForm.reloadFormKey(globalInstance, formKey, resource);
            globalInstance.getMetaForm(formKey);
//			}
            List<UICommand> result = new ArrayList<UICommand>();
            result.add(UICommand.reloadFileTree(filePath));
            result.add(UICommand.runFormKey(formKey));
            result.add(UICommand.reloadMenuTree());
            return UICommand.toJson(result);
        }
        // }else{//没有使用模板
        //  }
        return null;
    }

    @Override
    public String getCmd() {
        return CMD;
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new NewFormCmd();
    }

    /**
     * 生成新表单配置的源文件，并更新配置对象
     *
     * @param formType
     * @param key
     * @param caption
     * @return
     * @throws Throwable
     */
    private String getNewFormContent(int formType, String key, String caption) throws Throwable {
        MetaForm module = getModule(formType);
        int platformV = PlatformType.parse(platform);
        module.setPlatform(platformV);
        IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
        MetaProject metaProject = globalInstance.getMetaProject(projectKey);
        module.setProject(metaProject);
        MetaForm newMetaForm;
        if (!"新建数据对象".equals(InDataObject)) {//引入数据对象
            MetaDataObject metaDataObject = globalInstance.getDataObject(InDataObject);
            newMetaForm = setKeyAndCaptionInObject(module, key, caption, metaDataObject);
        } else {
            if (module.getFormType() != FormType.View && module.getFormType() != FormType.Report) {
                for (MetaTable metaTable : module.getDataSource().getDataObject().getTableCollection()) {
                    metaTable.setPersist(true);
                }
            }
            newMetaForm = setKeyAndCaption(module, key, caption);
        }
        newMetaForm.setPlatform(platformV);
        String xml = saveMetaForm(newMetaForm, formType);
        MetaFormList metaFormList = globalInstance.getMetaFormList();
        MetaFormProfile newFormProfile = MetaObjectHelper.deptClone(metaFormList.get(module.getKey()));
        newMetaForm.setProject(metaProject);
        newFormProfile.setProject(metaProject);
        newFormProfile.setKey(key);
        newFormProfile.setCaption(caption);
        newFormProfile.setResource("");
        newFormProfile.setPlatform(newMetaForm.getPlatform());
        newFormProfile.setForm(newMetaForm);
        metaFormList.add(newFormProfile);
        MetaObjectChange.fireChangeDesignMetaForm(newMetaForm,"ScopeCache","DBCache","TableCache","MetaCache","TableCacheAll");
        MetaForm erpNewMetaForm = globalInstance.getMetaForm(key); // 这里进行ERPMetaFactory中的相关处理
        globalInstance.replaceMetaForm(key, erpNewMetaForm);
        return xml;
    }

    private synchronized MetaForm getModule(int formType) throws Throwable {

        if (!"新建数据对象".equals(InDataObject)) {//引入数据对象
            MetaForm result;
            if ("1".equals(IsTemplate)) {//使用模板
                if (formType == FormType.Entity) {
                    result = loadMetaForm("D_BillModuleTemRef");
                } else if (formType == FormType.Dict) {
                    result = loadMetaForm("D_DictModuleTemRef");
                } else if (formType == FormType.ChainDict) {
                    result = loadMetaForm("D_ChainDictModuleTem");
                } else if (formType == FormType.View) {
                    result = loadMetaForm("D_ViewModuleUnrelated");
                } else {
                    result = loadMetaForm("D_NormalModule");
                }
                MetaForm clone = MetaObjectHelper.deptClone(result);
                clone.setFormType(formType);
                return clone;
            } else {//不使用模板
                if (formType == FormType.Entity) {
                    result = loadMetaForm("D_BillModuleNotTemRef");
                } else if (formType == FormType.Dict) {
                    result = loadMetaForm("D_DictModuleNotTemRef");
                } else if (formType == FormType.ChainDict) {
                    result = loadMetaForm("D_ChainDictModuleNotTem");
                } else {
                    result = loadMetaForm("D_NormalModule");
                }
                MetaForm clone = MetaObjectHelper.deptClone(result);
                clone.setFormType(formType);
                return clone;
            }
        } else {//新建数据对象
            MetaForm result;
            if ("1".equals(IsTemplate)) {//使用模板
                if (formType == FormType.Entity) {
                    if (PlatformType.STR_Mobile.equalsIgnoreCase(platform)) {
                        switch (ModuleSelect) {
                            case "mobileEmpty":
                                result = loadMetaForm("D_MobileEmptyTem");
                                break;
                            case "mobileLinearLayout":
                                result = loadMetaForm("D_MobileLinearLayoutTem");
                                break;
                            case "mobileTabContainer":
                                result = loadMetaForm("D_MobileTabContainerTem");
                                break;
                            case "mobileTableView":
                                result = loadMetaForm("D_MobileTableViewTem");
                                break;
                            default:
                                result = loadMetaForm("D_BillModuleNotTem");
                        }
                    } else {
                        switch (ModuleSelect) {
                            case "normalBill":
                                result = loadMetaForm("D_BillModuleTem");
                                break;
                            case "queryBill":
                                result = loadMetaForm("D_QueryModuleTem");
                                break;
                            case "queryResultBill":
                                result = loadMetaForm(ConstantUtil.MDL_QUERY_RESULT_TEM);
                                break;
                            default:
                                result = loadMetaForm("D_BillModuleNotTem");
                        }
                    }

                } else if (formType == FormType.Dict) {
                    result = loadMetaForm(ConstantUtil.MDL_DICT_TEM);
                } else if (formType == FormType.Detail) {
                    result = loadMetaForm("D_DetailModuleNotTem");
                } else if (formType == FormType.View) {
                    if (PlatformType.STR_Mobile.equalsIgnoreCase(platform)) {
                        switch (ModuleSelect) {
                            case "mobileEmptyView":
                                result = loadMetaForm("D_MobileEmptyViewTem");
                                break;
                            case "mobileLinearLayoutView":
                                result = loadMetaForm("D_MobileLinearLayoutViewTem");
                                break;
                            case "mobileTabContainerView":
                                result = loadMetaForm("D_MobileTabContainerViewTem");
                                break;
                            case "mobileTableViewView":
                                result = loadMetaForm("D_MobileTableViewViewTem");
                                break;
                            default:
                                if (AssociationForm.isEmpty()) {//无关联表单
                                    result = loadMetaForm("D_ViewModuleUnrelated");
                                } else {
                                    result = loadMetaForm("D_ViewModule");
                                }
                        }
                    } else {
                        if (AssociationForm.isEmpty()) {//无关联表单
                            result = loadMetaForm("D_ViewModuleUnrelated");
                        } else {
                            result = loadMetaForm("D_ViewModule");
                        }
                    }
                } else if (formType == FormType.Report) {
                    switch (ModuleSelect) {
                        case "normalReport":
                            result = loadMetaForm("D_ReportModuleTem_Rpt");
                            break;
                        case "variableReport":
                            result = loadMetaForm("D_VariableReportModuleTem_Rpt");
                            break;
                        default:
                            result = loadMetaForm("D_ReportModuleNotTem_Rpt");
                    }
                } else if (formType == FormType.ChainDict) {
                    result = loadMetaForm("D_ChainDictModuleTem");
                } else if (formType == FormType.CompDict) {
                    result = loadMetaForm(ConstantUtil.MDL_DICT_TEM);
                } else if (formType == FormType.Template) {
                    result = loadMetaForm("D_TemplateModule");
                } else {
                    if (PlatformType.STR_Mobile.equalsIgnoreCase(platform)) {
                        switch (ModuleSelect) {
                            case "mobileEmpty":
                                result = loadMetaForm("D_MobileNormalEmptyTem");
                                break;
                            case "mobileLinearLayout":
                                result = loadMetaForm("D_MobileNormalLinearLayoutTem");
                                break;
                            case "mobileTabContainer":
                                result = loadMetaForm("D_MobileNormalTabContainerTem");
                                break;
                            case "mobileTableView":
                                result = loadMetaForm("D_MobileNormalTableViewTem");
                                break;
                            default:
                                result = loadMetaForm("D_NormalModule");
                        }
                    } else {
                        result = loadMetaForm("D_NormalModule");
                    }
                }
                return MetaObjectHelper.deptClone(result);
            } else {//不使用模板
                if (formType == FormType.Entity) {
                    result = loadMetaForm("D_BillModuleNotTem");//不使用模板表单
                } else if (formType == FormType.Dict) {
                    result = loadMetaForm(ConstantUtil.MDL_DICT_NOT_TEM);
                } else if (formType == FormType.Detail) {
                    result = loadMetaForm("D_DetailModuleNotTem");
                } else if (formType == FormType.View) {
                    if (AssociationForm.isEmpty()) {//无关联表单
                        result = loadMetaForm("D_ViewModuleUnrelated");
                    } else {
                        result = loadMetaForm("D_ViewModule");
                    }
                } else if (formType == FormType.Report) {
                    result = loadMetaForm("D_ReportModuleNotTem_Rpt");
                } else if (formType == FormType.ChainDict) {
                    result = loadMetaForm("D_ChainDictModuleNotTem");
                } else if (formType == FormType.CompDict) {
                    result = loadMetaForm(ConstantUtil.MDL_DICT_NOT_TEM);
                } else if (formType == FormType.Template) {
                    result = loadMetaForm("D_TemplateModule");
                } else {
                    result = loadMetaForm("D_NormalModule");
                }
                return MetaObjectHelper.deptClone(result);
            }

        }

    }

    public static MetaForm loadMetaForm(String formKey) throws Throwable {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaFormProfile formProfile = metaFactory.getMetaFormList().get(formKey);
        if (formProfile == null) {
            formProfile = metaFactory.getExtFormList().get(formKey);
        }
        String resource = formProfile.getResource();
        String path = LoadFileTree.getPathByFormKey(formKey);
        String projectKey = LoadFileTree.getProjectKey(path);
        IMetaResolver resolver = metaFactory.getProjectResolver(projectKey);
        MetaFormLoad formLoad = new MetaFormLoad(AppRunType.Dev);
        formLoad.load(resolver, resource);
        MetaForm newMetaForm = (MetaForm) formLoad.getRootMetaObject();
        newMetaForm.setProject(metaFactory.getMetaProject(projectKey));
        newMetaForm.setResource(resource);
        return newMetaForm;
    }

    public static MetaForm loadMetaForm(String formKey, String resource) throws Throwable {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        String path = LoadFileTree.getPathByFormKey(formKey);
        String projectKey = LoadFileTree.getProjectKey(path);
        IMetaResolver resolver = metaFactory.getProjectResolver(projectKey);
        MetaFormLoad formLoad = new MetaFormLoad(AppRunType.Dev);
        formLoad.load(resolver, resource);
        MetaForm newMetaForm = (MetaForm) formLoad.getRootMetaObject();
        newMetaForm.setProject(metaFactory.getMetaProject(projectKey));
        newMetaForm.setResource(resource);
        return newMetaForm;
    }

    public static MetaForm loadMetaFormByPath(String resource, String projectKey) throws Throwable {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaFormLoad formLoad = new MetaFormLoad(AppRunType.Dev);
        formLoad.load(FileUtils.openInputStream(new File(resource)));
        MetaForm newMetaForm = (MetaForm) formLoad.getRootMetaObject();
        newMetaForm.setProject(metaFactory.getMetaProject(projectKey));
        newMetaForm.setResource(resource);
        return newMetaForm;
    }

    public static MetaDataObject loadMetaDataObject(String formKey) throws Throwable {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaDataObjectProfile metaDataObjectProfile = metaFactory.getDataObjectList().get(formKey);
        String resource = metaDataObjectProfile.getResource();
        String path = LoadFileTree.getPathByDataObject(formKey);
        String projectKey = LoadFileTree.getProjectKey(path);
        IMetaResolver resolver = metaFactory.getProjectResolver(projectKey);
        MetaDataObjectLoad metaDataObjectLoad = new MetaDataObjectLoad(AppRunType.Dev);
        metaDataObjectLoad.load(resolver, resource);
        MetaDataObject dataObject = (MetaDataObject) metaDataObjectLoad.getRootMetaObject();
        dataObject.setProject(metaFactory.getMetaProject(projectKey));
        return dataObject;
    }

    /**
     * 设置新的Key和Caption，同时修改表名等Key
     *
     * @param module
     * @param key
     * @param caption
     * @return
     */
    private MetaForm setKeyAndCaption(MetaForm module, String key, String caption) throws Throwable {
        if (formType == 2 && ConstantUtil.MDL_DICT_TEM.equals(module.getKey())) {
            for (AbstractMetaObject metaObject : module.getAllUIComponents().values()) {
                if (metaObject instanceof MetaComponent && ((MetaComponent) metaObject).getKey().equals(ConstantUtil.PARENTID)) {
                    MetaComponent metaComponent = (MetaComponent) metaObject;
                    if (metaComponent instanceof MetaDict && StringUtil.isBlankOrNull(((MetaDict) metaComponent).getItemKey())) {
                        ((MetaDict) metaComponent).setItemKey(key);
                    }
                }
            }
        }
        MetaForm newMetaForm = MetaObjectHelper.deptClone(module);
        String oldKey = module.getKey();
        String oldCaption = module.getCaption();
        newMetaForm.setKey(key);
        newMetaForm.setCaption(caption);
        if (newMetaForm.getDataSource() != null && (formType != 3 || AssociationForm.isEmpty())) {
            MetaDataObject metaDataObject = newMetaForm.getDataSource().getDataObject();
            metaDataObject.setKey(metaDataObject.getKey().replace(oldKey, key));
            metaDataObject.setCaption(metaDataObject.getCaption().replace(oldCaption, caption));
            Map<String, String> replacedTableKeys = new HashMap<String, String>();
            MetaTableCollection metaTables = metaDataObject.getTableCollection();
            if (metaTables != null) {

                List<MetaTable> metaTableArray = new ArrayList<MetaTable>();
                for (MetaTable metaTable : metaTables) {
                    String tableOldKey = metaTable.getKey();

                    String newTablePrefix;
                    if (tablePrefix.equals("E")) {//前缀默认为E时不拼下划线
                        newTablePrefix = tablePrefix;
                    } else {
                        newTablePrefix = tablePrefix + "_";
                    }
                    String tableNewKey = newTablePrefix + StringUtils.substring(tableOldKey, 1).replace(oldKey, key);
                    if (!tableOldKey.equals(tableNewKey)) {
                        replacedTableKeys.put(tableOldKey, tableNewKey);
                        metaTable.setKey(tableNewKey);
                    }
                    metaTable.setCaption(metaTable.getCaption().replace(oldCaption, caption));
                    // metaTable.setIndexPrefix(newTablePrefix + StringUtils.substring(metaTable.getIndexPrefix(), 1).replace(oldKey, key));

                    if (formType == 2 && "新建数据对象".equals(InDataObject) && metaTable.get(SystemField.CODE_DICT_KEY) != null) {
                        metaTable.get(SystemField.CODE_DICT_KEY).setLength(30);
                    }

                    metaTableArray.add(metaTable);
                }
                metaTables.clear();
                for (MetaTable metaTable : metaTableArray) {
                    metaTables.add(metaTable);
                }
                String oldMainTableKey = metaDataObject.getMainTableKey();
                metaDataObject.setMainTableKey(replaceTableKey(oldMainTableKey, replacedTableKeys));
                for (AbstractMetaObject metaObject : newMetaForm.getAllUIComponents().values()) {
                    if (metaObject instanceof MetaEmbed) {
                        MetaEmbed metaEmbed = (MetaEmbed) metaObject;
                        MetaVar systemInfoTableKey = metaEmbed.getVars().get("SystemInfoTableKey");
                        if(systemInfoTableKey != null){
                            systemInfoTableKey.setValue(replaceTableKey(oldMainTableKey, replacedTableKeys));
                        }
                    } else if (metaObject instanceof MetaComponent) {
                        MetaComponent metaComponent = (MetaComponent) metaObject;
                        MetaDataBinding metaDataBinding = metaComponent.getDataBinding();
                        if (metaDataBinding != null) {
                            metaDataBinding.setTableKey(replaceTableKey(metaDataBinding.getTableKey(), replacedTableKeys));
                            String oldDefaultFormulaValue = metaDataBinding.getDefaultFormulaValue();
                            if (StringUtils.isNotBlank(oldDefaultFormulaValue)) {
                                String newDefaultFormulaValue = StringUtils.replace(oldDefaultFormulaValue, oldMainTableKey, replaceTableKey(oldMainTableKey, replacedTableKeys));
                                metaDataBinding.setDefaultFormulaValue(newDefaultFormulaValue);
                            }
                        }

                        if (metaComponent instanceof MetaGrid) {
                            MetaGrid metaGrid = (MetaGrid) metaComponent;
                            for (MetaGridRow metaGridRow : metaGrid.getRowCollection()) {
                                metaGridRow.setTableKey(replaceTableKey(metaGridRow.getTableKey(), replacedTableKeys));
                            }
                        }
                    }
                }
            }
        } else {//视图处理
            IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
            MetaForm metaForm = globalInstance.getMetaForm(AssociationForm);
            IDLookup idLookup = IDLookup.reloadIDLookup(metaForm);
            MetaDataObject dataObject = MetaObjectHelper.deptClone(metaForm.getDataSource().getDataObject());
            String mainTableKey = metaForm.getDataSource().getDataObject().getMainTableKey();
            newMetaForm.setFormType(FormType.View);
            newMetaForm.setAbbrCaption(caption);
            dataObject.setKey(AssociationForm);
            dataObject.setCaption(caption);
            dataObject.setMainTableKey(mainTableKey);
            MetaTable mainTable = dataObject.getMainTable();
            if (Objects.nonNull(mainTable)) {
                mainTable.setKey(mainTableKey);
                mainTable.setCaption(caption);
            }
            dataObject.setRelateObjectKey(AssociationForm);
            dataObject.setPrimaryType(DataObjectPrimaryType.VIRTUAL);
            dataObject.setSecondaryType(DataObjectSecondaryType.NORMAL);
            MetaTableCollection tableCollection = dataObject.getTableCollection();
            MetaTable metaTable = MetaObjectHelper.deptClone(tableCollection.get(0));
            tableCollection.clear();
            tableCollection.add(metaTable);
            List<String> metaColumnList = new ArrayList<>();
            for (MetaColumn metaColumn : metaTable) {//记录出初始字段外的metaColumn
                String key1 = metaColumn.getKey();
                if (key1.equalsIgnoreCase(ConstantUtil.OID)
                        || key1.equalsIgnoreCase(ConstantUtil.SOID)
                        || key1.equalsIgnoreCase(ConstantUtil.POID)
                        || key1.equalsIgnoreCase(ConstantUtil.VERID)
                        || key1.equalsIgnoreCase(ConstantUtil.DVERID)) {
                    continue;
                }
                metaColumnList.add(key1);

            }
            for (String metaColumn : metaColumnList) {//移除metaColumn
                metaTable.remove(metaColumn);
            }
            metaTable.setTableMode(TableMode.DETAIL);
            metaTable.setPersist(false);
            metaTable.setSourceType(TableSourceType.QUERY);
            MetaStatement statement = new MetaStatement();
            statement.setContent("SELECT * FROM " + metaTable.getBindingDBTableName());
            metaTable.setStatement(statement);
            newMetaForm.getDataSource().setDataObject(dataObject);
            MetaGrid list = (MetaGrid) newMetaForm.getAllUIComponents().get("list");

            // 移动端的模板没有list
            if (list != null) {
                MetaGridRowCollection rowCollection = list.getRowCollection();
                for (MetaGridRow metaGridRow : rowCollection) {
                    metaGridRow.setTableKey(mainTableKey);
                }
                MetaBaseScript rowDblClick = list.getRowDblClick();
                rowDblClick.setContent("Open('" + AssociationForm + "',OID)");
                MetaOperation aNew = (MetaOperation) newMetaForm.getOperationCollection().get("New");
                aNew.getAction().setContent("New('" + AssociationForm + "')");
                if (StringUtils.isNotEmpty(QueryConditions)) {
                    boolean addRow = false;
                    boolean addCol = false;
                    String[] queryConditionsSplit = QueryConditions.split(",");
                    MetaTable mainTable1 = metaForm.getDataSource().getDataObject().getMainTable();
                    MetaTable metaTable1 = newMetaForm.getDataSource().getDataObject().getTableCollection().get(0);
                    MetaGridLayoutPanel query = (MetaGridLayoutPanel) newMetaForm.getAllUIComponents().get("query");
                    MetaColumnDefCollection metaColumnDefCollection = query.getMetaColumnDefCollection();
                    MetaRowDefCollection metaRowDefCollection = query.getMetaRowDefCollection();
                    for (String queryCondition : queryConditionsSplit) {
                        String columnKey = idLookup.getColumnKeyByFieldKey(queryCondition);
                        MetaColumn metaColumn = mainTable1.get(columnKey);
                        String key1 = metaColumn.getKey();
                        String caption1 = metaColumn.getCaption();
                        metaTable1.add(metaColumn);

                        MetaComponent abstractMetaObject = (MetaComponent) MetaObjectHelper.deptClone(metaForm.getAllUIComponents().get(queryCondition));
                        int controlType = abstractMetaObject.getControlType();
                        abstractMetaObject.setDataBinding(null);
                        MetaCondition metaCondition = new MetaCondition();
                        metaCondition.setColumnKey(queryCondition);
                        metaCondition.setTableKey(mainTableKey);
                        if (controlType == ControlType.UTCDATEPICKER || controlType == ControlType.DATEPICKER ||
                                controlType == ControlType.NUMBEREDITOR) {//metaCondition处理
                            metaCondition.setSign(CondSign.BETWEEN);
                            metaCondition.setGroup(queryCondition);
                            metaCondition.setGroupHead(true);
                        } else if (controlType == ControlType.DICT || controlType == ControlType.CHECKLISTBOX) {
                            metaCondition.setSign(CondSign.IN);

                        } else if (controlType == ControlType.COMBOBOX) {
                            metaCondition.setSign(CondSign.EQ);
                        } else {
                            metaCondition.setSign(CondSign.LIKE);
                        }
                        abstractMetaObject.setEnable("");
                        abstractMetaObject.setCondition(metaCondition);
                        if (abstractMetaObject.getX() > metaColumnDefCollection.size() - 1) {
                            addCol = true;
                        }
                        if (abstractMetaObject.getY() > metaRowDefCollection.size() - 1) {
                            addRow = true;
                        }
                        query.addComponent(abstractMetaObject);//组件
                        if (controlType == ControlType.UTCDATEPICKER || controlType == ControlType.DATEPICKER ||
                                controlType == ControlType.NUMBEREDITOR) {
                            abstractMetaObject.setCaption(abstractMetaObject.getCaption() + "(开始)");
                            MetaComponent toAbstractMetaObject = MetaObjectHelper.deptClone(abstractMetaObject);
                            toAbstractMetaObject.setKey(queryCondition + "_Comp2");
                            toAbstractMetaObject.setCaption(abstractMetaObject.getCaption() + "(结束)");
                            MetaCondition metaCondition_Comp2 = new MetaCondition();
                            metaCondition_Comp2.setColumnKey(queryCondition);
                            metaCondition_Comp2.setTableKey(mainTableKey);
                            metaCondition_Comp2.setSign(CondSign.BETWEEN);
                            metaCondition_Comp2.setGroup(queryCondition);
                            metaCondition_Comp2.setGroupTail(true);
                            toAbstractMetaObject.setCondition(metaCondition_Comp2);
                            query.addComponent(toAbstractMetaObject);//组件
                        }
                        list.setProperties(abstractMetaObject.getProperties());
                        MetaGridColumnCollection columnCollection = list.getColumnCollection();
                        MetaGridColumn metaGridColumn = new MetaGridColumn();
                        metaGridColumn.setKey(queryCondition + "_LV");
                        metaGridColumn.setCaption(caption1);
                        columnCollection.add(metaGridColumn);
                        MetaGridCell metaGridCell = new MetaGridCell();
                        metaGridCell.setProperties(abstractMetaObject.getProperties());
                        metaGridCell.setKey(queryCondition + "_LV");
                        metaGridCell.setCaption(caption1);
                        metaGridCell.setCellType(controlType);
                        MetaDataBinding dataBinding = new MetaDataBinding();
                        dataBinding.setColumnKey(key1);
                        metaGridCell.setDataBinding(dataBinding);
                        MetaGridRow metaGridRow = rowCollection.get(0);
                        metaGridRow.add(metaGridCell);
                        metaGridRow.setTableKey(mainTableKey);
                    }
                    if (addRow) {
                        MetaRowDef metaRowDef = metaRowDefCollection.get(0);
                        metaRowDefCollection.add(MetaObjectHelper.deptClone(metaRowDef));
                    }
                    if (addCol) {
                        MetaColumnDef metaColumnDef = metaColumnDefCollection.get(0);
                        metaColumnDefCollection.add(MetaObjectHelper.deptClone(metaColumnDef));
                    }

                }
            }
        }
        newMetaForm.doPostProcess(0, null);

        for (MetaComponent component : newMetaForm.getAllComponents()) { // 移除dict的filter #70381
            if (component instanceof MetaDict) {
                ((MetaDict) component).getProperties().setFilters(null);
            }
        }
        return newMetaForm;
    }

    private MetaForm setKeyAndCaptionInObject(MetaForm module, String key, String caption,
                                              MetaDataObject metaDataObject) throws Throwable {//数据对象表单
        MetaForm newMetaForm = MetaObjectHelper.deptClone(module);
        MetaDataSource oldDataSource = module.getDataSource();
        String oldRefObjectKey = oldDataSource.getRefObjectKey();
        MetaDataObject oldDataObject;
        if (StringUtils.isNotBlank(oldRefObjectKey)) {
            oldDataObject = MetaFactory.getGlobalInstance().getDataObject(oldRefObjectKey);
        } else {
            oldDataObject = oldDataSource.getDataObject();
        }
        String oldMainTableKey = oldDataObject.getMainTableKey();
        MetaDataSource metaDataSource = (MetaDataSource) oldDataSource.depthClone();
        newMetaForm.setKey(key);
        newMetaForm.setCaption(caption);
        metaDataSource.setDataObject(metaDataObject);
        String detailTableKey = "";
        String headTableKey = "";
        MetaTable headTable = null;
        MetaTable detailTable = null;
        for (MetaTable metaTable : metaDataObject.getTableCollection()) {
            if (metaTable.getKey().endsWith(MetaFormNODBProcess.STR_NODBTable_Profix)) {
                continue;
            }
            int tableMode = metaTable.getTableMode();
            if (tableMode == TableMode.DETAIL) {
                detailTable = metaTable;
                detailTableKey = metaTable.getKey();
                break;
            } else if (tableMode == TableMode.HEAD) {
                headTable = metaTable;
                headTableKey = metaTable.getKey();
                break;
            }
        }
        if (newMetaForm.getDataSource() != null) {
            newMetaForm.setDataSource(metaDataSource);
            newMetaForm.getDataSource().setRefObjectKey(metaDataObject.getKey());
            for (AbstractMetaObject metaObject : newMetaForm.getAllUIComponents().values()) {
                if (metaObject instanceof MetaEmbed) {
                    MetaEmbed metaEmbed = (MetaEmbed) metaObject;
                    metaEmbed.getVars().get("SystemInfoTableKey").setValue(headTableKey);
                } else if (metaObject instanceof MetaComponent) {
                    if (metaObject instanceof MetaGrid) {
                        if (StringUtils.isNotEmpty(detailTableKey)) {
                            MetaGrid metaGrid = (MetaGrid) metaObject;
                            for (MetaGridRow metaGridCells : metaGrid.getRowCollection()) {
                                for (MetaGridCell metaGridCell : metaGridCells) {
                                    String columnKey = metaGridCell.getColumnKey();
                                    MetaColumn metaColumn = detailTable.get(columnKey);
                                    if (Objects.isNull(metaColumn) && metaGridCell.getDataBinding() != null) {
                                        metaGridCell.getDataBinding().setColumnKey("");
                                    }
                                }
                                metaGridCells.setTableKey(detailTableKey);
                            }
                        } else {
                            MetaGrid metaGrid = (MetaGrid) metaObject;
                            for (MetaGridRow metaGridCells : metaGrid.getRowCollection()) {
                                metaGridCells.setTableKey("");
                                for (MetaGridCell metaGridCell : metaGridCells) {
                                    MetaDataBinding dataBinding = metaGridCell.getDataBinding();
                                    if (dataBinding != null) {
                                        dataBinding.setColumnKey("");
                                    }
                                }
                            }
                        }
                    } else {
                        MetaComponent metaComponent = (MetaComponent) metaObject;
                        MetaDataBinding metaDataBinding = metaComponent.getDataBinding();
                        if (metaDataBinding != null) {
                            if (StringUtils.isNotEmpty(headTableKey)) {
                                String columnKey = metaDataBinding.getColumnKey();
                                MetaColumn metaColumn = headTable.get(columnKey);
                                if (Objects.isNull(metaColumn)) {
                                    metaDataBinding.setColumnKey("");
                                }
                                if (StringUtils.isNotBlank(metaDataBinding.getTableKey())) {
                                    metaDataBinding.setTableKey(headTableKey);
                                }
                                String oldDefaultFormulaValue = metaDataBinding.getDefaultFormulaValue();
                                if (StringUtils.isNotBlank(oldDefaultFormulaValue)) {
                                    String newDefaultFormulaValue = StringUtils.replace(oldDefaultFormulaValue, oldMainTableKey, headTableKey);
                                    metaDataBinding.setDefaultFormulaValue(newDefaultFormulaValue);
                                }
                            } else {
                                metaDataBinding.setTableKey("");
                                metaDataBinding.setColumnKey("");
                            }
                        }
                    }
                }
            }
            newMetaForm.doPostProcess(0, null);
        }
        return newMetaForm;
    }

    private String replaceTableKey(String tableName, Map<String, String> replacedTableKeys) {
        if (replacedTableKeys.containsKey(tableName)) {
            return replacedTableKeys.get(tableName);
        }
        return tableName;
    }

    private static void getSubSelect(PlainSelect selectBody, List<Pair<String, String>> list1) {
        FromItem fromItem = selectBody.getFromItem();
        if (fromItem instanceof SubSelect) {
            PlainSelect selectBody1 = (PlainSelect) ((SubSelect) fromItem).getSelectBody();
            List selectItems1 = selectBody1.getSelectItems();
            setSelectItems(selectItems1, list1);
            getSubSelect(selectBody1, list1);
        }
    }

    private static void setSelectItems(List selectItems, List<Pair<String, String>> list1) {
        for (Object selectItem : selectItems) {
            if (selectItem instanceof SelectExpressionItem) {
                SelectExpressionItem selectExpressionItem = (SelectExpressionItem) selectItem;
                String fieldKey = selectExpressionItem.getAlias();//界面显示fieldKey
                String columnName = "";
                Expression expression = selectExpressionItem.getExpression();
                if (expression instanceof Column) {
                    Column column = (Column) expression;
                    columnName = column.getColumnName();
                }
                if (StringUtils.isEmpty(fieldKey)) {
                    fieldKey = columnName;
                }
                list1.add(Pair.of(fieldKey, columnName));
            }
        }
    }

    public String testGetTablenameByAlias1(String sql, String formKey, String formCaption, SelectSqlInfo sqlInfo) throws Throwable {
        IMetaFactory iMetaFactory = MetaFactory.getGlobalInstance();
        List<String> allTableNames = sqlInfo.getAllTableNames();
        PlainSelect selectBody = (PlainSelect) sqlInfo.getSelect().getSelectBody();
        List selectItems = selectBody.getSelectItems();
        List<Pair<String, String>> list1 = new ArrayList<>();//存放解析出来的字段
        setSelectItems(selectItems, list1);
        getSubSelect(selectBody, list1);
        HashMap<MetaForm, String> metaFormByTableKey = new HashMap<>();
        List<String> metaGridCellKeys = new ArrayList<>();
        List<String> metaGridColumnKeys = new ArrayList<>();


        HashMap<String, TransmitConditions> metaComponentByfileKey1 = new HashMap<>();


        for (String allTableName : allTableNames) {
            HashMap<MetaForm, String> metaFormByTableKey1 = CalcColumnItemKey.getMetaFormByTableKey(iMetaFactory, allTableName);
            metaFormByTableKey.putAll(metaFormByTableKey1);
        }
        metaFormByTableKey.forEach((metaForm, metaTableKey) -> {
            try {
                CalcColumnItemKey.getMetaComponentByfileKey(metaForm, metaTableKey, list1, metaComponentByfileKey1);

            } catch (Throwable e) {
                throw new RuntimeException(e);
            }
        });
        try {
            MetaForm d_reportModuleNotTem = MetaObjectHelper.deptClone(loadMetaForm("D_ReportModuleBySQL_Rpt"));
            d_reportModuleNotTem.setInitState(OperationState.Default);
            d_reportModuleNotTem.setCaption(formCaption);
            d_reportModuleNotTem.setVersion(1);
            d_reportModuleNotTem.setKey(formKey);
            MetaDataObject dataObject = d_reportModuleNotTem.getDataSource().getDataObject();
            dataObject.setKey(formKey);
            dataObject.setCaption(formCaption);
            MetaGrid grid0 = (MetaGrid) d_reportModuleNotTem.getAllUIComponents().get("detail");
            MetaGridColumnCollection columnCollection = grid0.getColumnCollection();
            MetaGridRowCollection rowCollection = grid0.getRowCollection();
            MetaGridRow metaGridCells = rowCollection.get(0);
            String tableKey = metaGridCells.getTableKey();
            MetaTable table = dataObject.getTable(tableKey);
            metaGridCells.setTableKey(formKey + "Detail");
            table.setKey(formKey + "Detail");
            table.setCaption(formKey + "Detail");
            MetaStatement metaStatement = new MetaStatement();
            metaStatement.setContent(sql);
            metaStatement.setType(TableStatementType.FORMULA);
            table.setStatement(metaStatement);
            table.setSourceType(TableSourceType.QUERY);
            list1.forEach((pairs) -> {
                String key = (String) pairs.getKey();
                TransmitConditions value = metaComponentByfileKey1.get(key);
                int cellType = value.getCellType();
                String columnKey = value.getColumnKey();
                String filedKey = value.getFiledKey();
                String componentFieldCaption = value.getComponentFieldCaption();
                String itemColumnKey = value.getItemColumnKey();
                MetaColumn metaColumn = value.getMetaColumn();
                int sourceType = value.getSourceType();
                String itemsDependency = value.getItemsDependency();
                List<String> dependentFields = value.getDependentFields();
                MetaBaseScript formulaItems = value.getFormulaItems();
                MetaQueryDef metaQueryDef = value.getMetaQueryDef();


                MetaGridCell metaGridCell = new MetaGridCell();
                MetaGridColumn metaGridColumn = new MetaGridColumn();
                metaGridColumn.setKey(filedKey);
                metaGridColumn.setWidth(new DefSize(DefSize.Fix, 80));
                if (!Objects.isNull(metaColumn) && !StringUtils.isEmpty(metaColumn.getCaption())) {
                    metaGridCell.setCaption(metaColumn.getCaption());
                    metaGridColumn.setCaption(metaColumn.getCaption());
                } else if (StringUtils.isEmpty(componentFieldCaption)) {
                    metaGridCell.setCaption(filedKey);
                    metaGridColumn.setCaption(filedKey);
                } else {
                    metaGridCell.setCaption(componentFieldCaption);
                    metaGridColumn.setCaption(componentFieldCaption);
                }
                if (cellType == ControlType.DICT) {
                    MetaDictProperties properties1 = new MetaDictProperties();
                    properties1.setItemKey(itemColumnKey);
                    metaGridCell.setProperties(properties1);
                } else if (cellType == ControlType.CHECKLISTBOX) {
                    MetaCheckListBoxProperties metaCheckListBoxProperties = new MetaCheckListBoxProperties();
                    MetaCheckListBoxProperties properties1 = metaCheckListBoxProperties;
                    properties1.setSourceType(sourceType);
                    if (sourceType == ComboBoxSourceType.FORMULA) {
                        properties1.setFormulaItems(formulaItems);
                    } else if (sourceType == ComboBoxSourceType.QUERY) {
                        if (dependentFields.size() == 0) {
                            properties1.setItemsDependency(itemsDependency);
                        } else {
                            properties1.setDependentFields(dependentFields);
                        }
                        properties1.setQueryDef(metaQueryDef);
                    }
                    metaGridCell.setProperties(properties1);
                } else if (cellType == ControlType.COMBOBOX) {
                    MetaComboBoxProperties properties1 = new MetaComboBoxProperties();
                    properties1.setSourceType(sourceType);
                    if (sourceType == ComboBoxSourceType.FORMULA) {
                        properties1.setFormulaItems(formulaItems);
                    } else if (sourceType == ComboBoxSourceType.QUERY) {
                        if (dependentFields.size() == 0) {
                            properties1.setItemsDependency(itemsDependency);
                        } else {
                            properties1.setDependentFields(dependentFields);
                        }
                        properties1.setQueryDef(metaQueryDef);
                    }
                    metaGridCell.setProperties(properties1);
                }
                metaGridCell.setKey(filedKey);
                metaGridCell.setCellType(cellType);
                MetaDataBinding metaDataBinding = new MetaDataBinding();
                metaGridCell.setDataBinding(metaDataBinding);
                if ("SOID".equalsIgnoreCase(columnKey)
                        || "OID".equalsIgnoreCase(columnKey)
                        || "POID".equalsIgnoreCase(columnKey)
                        || "VERID".equalsIgnoreCase(columnKey)
                        || "DVERID".equalsIgnoreCase(columnKey)) {
                    return;
                }
                if (StringUtils.isNotEmpty(columnKey)) {
                    if (Objects.isNull(metaColumn)) {
                        metaColumn = new MetaColumn();
                        metaColumn.setCaption(columnKey);
                        metaColumn.setKey(columnKey);
                        metaColumn.setDataType(DataType.STRING);
                    }
                    MetaColumn metaColumn1 = table.get(metaColumn.getKey());
                    if (Objects.isNull(metaColumn1)) {
                        table.add(metaColumn);
                    }
                    metaDataBinding.setColumnKey(metaColumn.getKey());
                } else {
                    if (Objects.isNull(metaColumn)) {
                        metaColumn = new MetaColumn();
                        metaColumn.setCaption(filedKey);
                        metaColumn.setKey(filedKey);
                        metaColumn.setDataType(DataType.STRING);
                    }
                    MetaColumn metaColumn1 = table.get(metaColumn.getKey());
                    if (Objects.isNull(metaColumn1)) {
                        table.add(metaColumn);
                    }
                    metaDataBinding.setColumnKey(metaColumn.getKey());
                }
                if (!metaGridCellKeys.contains(metaGridCell.getKey())) {
                    metaGridCells.add(metaGridCell);
                    metaGridCellKeys.add(metaGridCell.getKey());
                }
                if (!metaGridColumnKeys.contains(metaGridColumn.getKey())) {
                    columnCollection.add(metaGridColumn);
                    metaGridColumnKeys.add(metaGridColumn.getKey());
                }


            });
            return NewFormCmd.saveMetaForm(d_reportModuleNotTem);
        } catch (Throwable e) {
            throw new RuntimeException(e);
        }

    }


    private static String saveMetaForm(MetaForm metaForm) throws Throwable {
        MetaFormSave save = new MetaFormSave(metaForm);
        Document newDocument = save.getDocument();
        XmlCreator creator = new XmlCreator(newDocument, null);
        String xml = creator.createXml();
        return xml;

    }

    private String saveMetaForm(MetaForm metaForm, int formType) throws Throwable {
        MetaFormSave save = new MetaFormSave(metaForm);
        Document newDocument = save.getDocument();
        XmlCreator creator = new XmlCreator(newDocument, null);
        if (!"新建数据对象".equals(InDataObject)) {
            MetaForm clone = MetaObjectHelper.deptClone(metaForm);
            MetaDataSource metaDataSource = new MetaDataSource();
            metaDataSource.setRefObjectKey(metaForm.getDataSource().getRefObjectKey());
            clone.setDataSource(metaDataSource);
            MetaFormSave save1 = new MetaFormSave(clone);
            Document newDocument1 = save1.getDocument();
            XmlCreator creator1 = new XmlCreator(newDocument1, null);
            String xml1 = creator1.createXml();
            return xml1;
        } else {
            String xml = creator.createXml();
            return xml;
        }
    }
}
