package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.utils.DesignReloadMetaObject;
import com.bokesoft.yes.design.utils.WebDesignerDataTableUtil;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.mid.cmd.richdocument.strut.DocumentRecordDirty;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataobject.*;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 配置对象的差异处理
 */
public class MetaFormDiffProcessor {
	public static final MetaFormDiffProcessor instance = new MetaFormDiffProcessor();

	public String processDiff(DefaultContext context,List<Diff> diffs, boolean genPropertyDiffSuccess, DocumentRecordDirty formDocument, Map<String, String> tmpFiles) throws Throwable {
		String tmp = processDiffReloadForm(context,tmpFiles);
		IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
		for (Diff diff : diffs) {
			diff.setMetaForm(metaFactory.getMetaForm(diff.getMetaForm().getKey()));
			if (genPropertyDiffSuccess) {
				// 同步前端Document
				synchronizedDocumentDataSource(formDocument);
			}
		}

		return tmp.toString();
	}

	/**
	 * 修改配置对象。若配置对象不能直接修改时，通过重新加载的方式加载配置对象，若有错误回滚，并返回错误
	 *
	 * @return
	 * @throws Throwable
	 */
	public String processDiffReloadForm(DefaultContext context, Map<String, String> tmpFiles) throws Throwable {
		StringBuilder errors = new StringBuilder(256);
		if (tmpFiles != null) {
			for (Map.Entry<String, String> entry : tmpFiles.entrySet()) {
				String tmpFilePath = entry.getKey();
				String newContent = entry.getValue();
				String secondLine = DesignIOMetaUtil.getSecondLine(newContent);
				String objectType = DesignIOMetaUtil.getSubString(secondLine, "<([A-Za-z_]\\w*)\\s");
				String key = DesignIOMetaUtil.getSubString(secondLine, "Key=\"([A-Za-z_]\\w*)\"");
				try {
					if (MetaDataObject.TAG_NAME.equals(objectType)) {
						DataObjectHelper.reload(context,key, tmpFilePath, null);
					} else if (MetaForm.TAG_NAME.equals(objectType)) {
						DesignReloadMetaObject.reloadMetaFormRollbackError(context,key);
					}
				} catch (MetaException e) {
					String error = getExceptionString(e);
					errors.append(errors.length() > 0 ? "\n" : "").append(error);
				}
			}
		}
		return errors.length() == 0 ? "操作成功" : errors.toString();
	}

	private static String getExceptionString(Exception e) {
		String result = e.getMessage();
		if (!StringUtils.isNotEmpty(result)) {
			result = e.getClass().toString();
		}
		return result;
	}

	/**
	 * 表单的document数据源同步
	 *
	 * @param formDocument
	 * @throws Throwable
	 */

	public void synchronizedDocumentDataSource(DocumentRecordDirty formDocument) throws Throwable {
		if (Objects.isNull(formDocument)) {
			return;
		}
		String formKey = formDocument.getMetaForm().getKey();
		MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(formKey);
		formDocument.setMetaForm(metaForm);
		MetaDataSource dataSource = metaForm.getDataSource();
		MetaDataObject dataObject;
		if (dataSource != null && (dataObject = dataSource.getDataObject()) != null) {
			formDocument.setMetaDataObject(dataObject);
			DataTable newDataTable = null;
			MetaTableCollection tableCollection = dataObject.getTableCollection();
			for (MetaTable metaTable : tableCollection) {
				String metaTableKey = metaTable.getKey();
				formDocument.addDirtyTableFlag(metaTableKey);
				DataTable oldDataTable = formDocument.get(metaTableKey);
				newDataTable = WebDesignerDataTableUtil.generateDataTable(metaTable);
				if (oldDataTable != null) {
					if (!isAddDataTable2Document(oldDataTable, newDataTable)) {
						continue;
					}
					WebDesignerDataTableUtil.appendAll(oldDataTable, newDataTable);
					formDocument.remove(metaTableKey);
				}
				formDocument.add(metaTableKey, newDataTable);

			}
		}
	}

	/**
	 * 判断是否添加dataTable到document
	 *
	 * @param oldDataTable
	 * @param newDataTable
	 * @return
	 */
	private boolean isAddDataTable2Document(DataTable oldDataTable, DataTable newDataTable) {
		DataTableMetaData oldMetaData = oldDataTable.getMetaData();
		DataTableMetaData newMetaData = newDataTable.getMetaData();
		// 如果字段不一致则把新的dataTable加入到document
		int columnCount = oldMetaData.getColumnCount();
		if (columnCount != newMetaData.getColumnCount()) {
			return true;
		}

		for (int i = 0; i < columnCount; i++) {
			ColumnInfo oldColumnInfo = oldMetaData.getColumnInfo(i);
			ColumnInfo newColumnInfo = newMetaData.getColumnInfo(i);

			String oldColumnKey = oldColumnInfo.getColumnKey();
			String newColumnKey = newColumnInfo.getColumnKey();
			if (!oldColumnKey.equals(newColumnKey)) {
				return true;
			}

			int oldDataType = oldColumnInfo.getDataType();
			int newDataType = newColumnInfo.getDataType();
			if (oldDataType != newDataType) {
				return true;
			}
		}
		return false;
	}
}
