package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.erp.scope.MetaFormAllFormulScopeCache;
import com.bokesoft.yes.erp.scope.MetaFormAllFormulaScope;
import com.bokesoft.yes.erp.scope.ScopeTree;
import com.bokesoft.yes.erp.scope.ScopeTreeBuilder;
import com.bokesoft.yes.meta.json.MetaFormJsonSerializer;
import com.bokesoft.yes.mid.base.MidVEHost;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.web.ui.WebJSONUIBuilder;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.web.util.ExtensionUtil;
import com.bokesoft.yigo.mid.web.util.IExtensionProvider;
import org.json.JSONObject;

public class GetMetaDesignerFormCmd extends DesignerServiceCmd {
    public static final String CMD = "GetMetaDesignerForm";

    public static String formKey = "";
    public static boolean calculateScope = false;
    @Override
    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        formKey = (String) arguments.get("formKey");
        calculateScope = Boolean.parseBoolean(arguments.get("calculateScope") + "");
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        IMetaFactory globalInstance = context.getVE().getMetaFactory();
        MetaForm form = globalInstance.getMetaForm(formKey);
        JSONObject object = new JSONObject();
        MidVEHost veHost = new MidVEHost(context);
        veHost.setVE(context.getVE());
        //优先处理原单触发scope计算
        WebJSONUIBuilder builder = new WebJSONUIBuilder();
        builder.setVEHost(veHost);
        builder.setMetaForm(form);
        JSONObject empty;
        try {
            empty = builder.build();
        }catch (Exception e){
            object.put("message",e.getMessage());
            MetaFormJsonSerializer serializer = new MetaFormJsonSerializer(form,veHost);
            empty = serializer.serialize();
        }


        //处理扩展表单的合并信息
        IExtensionProvider provider = ExtensionUtil.newProvider();
        if(provider != null){
            MetaForm extForm = provider.getExtMetaForm(context, form);
            if(extForm != null){
                WebJSONUIBuilder extFormBuilder = new WebJSONUIBuilder();
                extFormBuilder.setVEHost(veHost);
                extFormBuilder.setMetaForm(extForm);
                JSONObject extFormJson = extFormBuilder.build();
                JSONObject mergeInfo = new JSONObject();
                JSONHelper.writeToJSON(mergeInfo, JSONConstants.FORM_FORMINFO, extFormJson);
                JSONHelper.writeToJSON(empty, JSONConstants.FORM_DELAYMERGEINFO, mergeInfo);
            }
        }

        object.put("meta", empty);
        if (calculateScope) {
            try {
                //MetaFormAllFormulaScope metaFormInfo = new MetaFormAllFormulaScope(form);
                MetaFormAllFormulaScope metaFormInfo = MetaFormAllFormulScopeCache.instance.processAllFormula(globalInstance, form);
//            metaFormInfo.processAllFormula(globalInstance,form);
                ScopeTree scopeTree = ScopeTreeBuilder.builder(context, form,metaFormInfo);
                JSONObject scopeTreeJson = scopeTree.getJSON();
                object.put("formulaScope", scopeTreeJson);
            } catch (Exception e){
                object.put("message",e.getMessage());
            }

        }
        return object;
    }
    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new GetMetaDesignerFormCmd();
    }

    @Override
    public String getCmd() {
        return GetMetaDesignerFormCmd.CMD;
    }
}
