package com.bokesoft.yes.design.cmd;

import static com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil.getOutputFormat;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;

import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.function.DesignActionUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.ProjectMetaResolverUtils;
import com.bokesoft.yes.design.utils.XMLWriter;
import com.bokesoft.yes.design.vo.RecycleForm;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.entry.MetaEntryLoad;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.entry.MetaEntry;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.solution.MetaProjectProfile;

/**
 * 处理Entry.xml
 */
public class EntryProcessor {
	public static final EntryProcessor instance = new EntryProcessor();

//	private static final String STR_ParentEntry = "    <Entry Caption=\"新增表单\" Key=\"NewForm\">";
	/**
	 * Entry.xml默认存在的项目，平台默认做法是将所有项目下的Entry.xml合并起来，大猫的菜单树存在多项目交叉的情况，
	 * 所以将Entry.xml存在在basisconfig下
	 */
	public static final String STR_DefaultProjectKey = "config_basis";

	private File getEntryPath(String projectKey) throws Throwable {
		IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
		String caption = metaFactory.getMetaProject(projectKey).getCaption();
		String entryPath = metaFactory.getProjectResolver(projectKey).getPath("Entry.xml");
		File file = new File(entryPath);
		if (!file.exists()) {
			String newContent = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n" +
					"<Entry Caption=\"根\" Key=\"root\">\n" +
					"    <Entry Caption=\"" + caption + "自定义表单\" Icon=\"Bill.png\" Key=\"" + projectKey + "CustomBill" +
					"\">\n" +
					"    </Entry>\n" +
					"</Entry>";
			FileUtils.writeStringToFile(new File(entryPath), newContent, "UTF-8");
		}
		return new File(entryPath);
	}

	/**
	 * 重新加载Entry.xml
	 *
	 * @throws Throwable
	 */
	public void reloadEntry(String projectKey) throws Throwable {
		IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
		MetaEntry metaEntry = getMetaEntry(projectKey, metaFactory);
		MetaProjectProfile metaProjectProfile = metaFactory.getSolution().getProjectCollection().get(projectKey);
		metaProjectProfile.setEntry(metaEntry);
		//主
//		MetaEntry entry = getMetaEntry(STR_DefaultProjectKey, metaFactory);
//		MetaProjectProfile metaProjectProfile = metaFactory.getSolution().getProjectCollection().get(STR_DefaultProjectKey);
		//合并
		//	entry.merge(metaEntry);
//		metaProjectProfile.setEntry(entry);
	}

	private MetaEntry getMetaEntry(String projectKey, IMetaFactory metaFactory) throws Exception {
		IMetaResolver projectMetaResolver = metaFactory.getProjectResolver(projectKey);
		MetaEntryLoad entryLoad = new MetaEntryLoad(AppRunType.App);
		entryLoad.load(projectMetaResolver, DomMetaConstants.ENTRY_FILE);
		MetaEntry metaEntry = (MetaEntry) entryLoad.getRootMetaObject();
		return metaEntry;
	}

	/**
	 * 添加自定义的entry节点
	 *
	 * @param source
	 * @param document
	 * @param formType
	 * @param key
	 * @param caption
	 * @throws Throwable
	 */
	private void addCustomEntry(String source, Document document, int formType, String key, String caption) throws Throwable{
		Element node = null;
		int endIndex = source.lastIndexOf("/");
		String[] split = source.split("/");
		String sourceCaption = source.substring(endIndex + 1);
		int in = split.length - 1;
		if (in == -1 || in == 1) {
			// 直接写文件
			node = document.getRootElement();
		}

		if (Objects.isNull(node)) {
			return;
		}

		if (formType == FormType.Dict || formType == FormType.ChainDict || formType == FormType.CompDict) {
			String path = LoadFileTree.getPathByFormKey(key);
			XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(path);
			TagNode dictView = xmlTreeWithPath.xmlTree.getRoot().findFirstTagNodeByTagName("DictView");
			if (Objects.isNull(dictView)) {
				node.addElement("Entry").addAttribute(ConstantUtil.CAPTION, sourceCaption)
						.addAttribute(ConstantUtil.KEY, "entry_" + key)
						.addElement("EntryItem").addAttribute(ConstantUtil.CAPTION, caption)
						.addAttribute(ConstantUtil.KEY, "sub_" + key)
						.addAttribute(ConstantUtil.TYPE, "Form")
						.addAttribute(ConstantUtil.FORM_KEY, "DictEdit")
						.addAttribute("Parameters", "FormKey=" + key + ";");
			} else {
				node.addElement("Entry").addAttribute(ConstantUtil.CAPTION, sourceCaption)
						.addAttribute(ConstantUtil.KEY, "entry_" + key)
						.addElement("EntryItem").addAttribute(ConstantUtil.CAPTION, caption)
						.addAttribute(ConstantUtil.KEY, "sub_" + key)
						.addAttribute(ConstantUtil.TYPE, "Form")
						.addAttribute(ConstantUtil.FORM_KEY, key);
			}
		} else {
			node.addElement("Entry").addAttribute(ConstantUtil.CAPTION, sourceCaption)
					.addAttribute(ConstantUtil.KEY, "entry_" + key)
					.addElement("EntryItem").addAttribute(ConstantUtil.CAPTION, caption)
					.addAttribute(ConstantUtil.KEY, "sub_" + key)
					.addAttribute(ConstantUtil.TYPE, "Form")
					.addAttribute(ConstantUtil.FORM_KEY, key);
		}
	}

	/**
	 * 增加节点
	 *
	 * @param formType
	 * @param key
	 * @param caption
	 * @throws Throwable
	 */
	public void newForm(String projectKey, int formType, String key, String caption, String source, boolean isNew) throws Throwable {
		SAXReader reader = new SAXReader();

		File entryPath = null;

		if (StringUtils.isNotEmpty(source)) {//无节点
			if (formType == -1 || formType == FormType.Template) {
				return;
			}

			// entry.xml对应的project
			String entryProject = null;

			Boolean flag = true;
			IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
			Document document = null;
			for (String pKey: metaFactory.getProjectKeys()) {
				String entryXml = ProjectMetaResolverUtils.readProjectFile(pKey, "Entry.xml");

				if ( StringUtils.isNotBlank(entryXml) && StringUtils.isNotEmpty(source)) {
					document = reader.read(new StringReader(entryXml));

					Element node = (Element) document.getRootElement().selectSingleNode(source.substring(1));
					if (node != null) {
						if (formType == FormType.Dict || formType == FormType.ChainDict || formType == FormType.CompDict) {
							String path = LoadFileTree.getPathByFormKey(key);
							XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(path);
							TagNode dictView = xmlTreeWithPath.xmlTree.getRoot().findFirstTagNodeByTagName("DictView");
							if (Objects.isNull(dictView)) {
								node.addElement("EntryItem").addAttribute(ConstantUtil.CAPTION, caption)
										.addAttribute(ConstantUtil.KEY, "sub_" + key)
										.addAttribute(ConstantUtil.TYPE, "Form")
										.addAttribute(ConstantUtil.FORM_KEY, "DictEdit")
										.addAttribute("Parameters", "FormKey=" + key + ";");
							} else {
								node.addElement("EntryItem").addAttribute(ConstantUtil.CAPTION, caption)
										.addAttribute(ConstantUtil.KEY, "sub_" + key)
										.addAttribute(ConstantUtil.TYPE, "Form")
										.addAttribute(ConstantUtil.FORM_KEY, key);
							}
						} else {
							node.addElement("EntryItem").addAttribute(ConstantUtil.CAPTION, caption)
									.addAttribute(ConstantUtil.KEY, "sub_" + key)
									.addAttribute(ConstantUtil.TYPE, "Form")
									.addAttribute(ConstantUtil.FORM_KEY, key);
						}

						entryProject = pKey;
						flag = false;
						break;
					} else {//手输
						if (!StringUtils.contains(source, "/")) {
							source = "/" + source;
						}
						int endIndex = source.lastIndexOf("/");
						String[] split = source.split("/");
						String sourceCaption = source.substring(endIndex + 1);
						int in = split.length - 1;
						if (in == -1 || in == 1) {
							// 直接写文件
							// node = document.getRootElement();
						} else {
							String entry = source.substring(0, endIndex);
							AtomicReference<String> single = new AtomicReference<>("");
							LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<>();
							MetaEntry metaEntry = MetaFactory.getGlobalInstance().getMetaEntry(pKey);
							String pEntryKey = "";
							String pEntryCaption = "";
							if (metaEntry != null) {
								DesignActionUtil.getEntryItems(linkedHashMap, metaEntry, pEntryKey, pEntryCaption);
							}
							linkedHashMap.forEach((key1, entrys) -> {
								if (entry.equalsIgnoreCase(entrys)) {
									single.set(key1);
									return;
								}
							});
							// 处理上级相同的情况
							String cs = single.get();
							if (StringUtils.isNotEmpty(cs)) {
								node =
										(Element) document.getRootElement().selectSingleNode(cs.replaceAll("\\+", "=").substring(1));
							} else {
								continue;
							}

						}
						if (Objects.isNull(node)) {
							continue;
						}
						if (formType == FormType.Dict || formType == FormType.ChainDict || formType == FormType.CompDict) {
							String path = LoadFileTree.getPathByFormKey(key);
							XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(path);
							TagNode dictView = xmlTreeWithPath.xmlTree.getRoot().findFirstTagNodeByTagName("DictView");
							if (Objects.isNull(dictView)) {
								node.addElement("Entry").addAttribute(ConstantUtil.CAPTION, sourceCaption)
										.addAttribute(ConstantUtil.KEY, "entry_" + key)
										.addElement("EntryItem").addAttribute(ConstantUtil.CAPTION, caption)
										.addAttribute(ConstantUtil.KEY, "sub_" + key)
										.addAttribute(ConstantUtil.TYPE, "Form")
										.addAttribute(ConstantUtil.FORM_KEY, "DictEdit")
										.addAttribute("Parameters", "FormKey=" + key + ";");
							} else {
								node.addElement("Entry").addAttribute(ConstantUtil.CAPTION, sourceCaption)
										.addAttribute(ConstantUtil.KEY, "entry_" + key)
										.addElement("EntryItem").addAttribute(ConstantUtil.CAPTION, caption)
										.addAttribute(ConstantUtil.KEY, "sub_" + key)
										.addAttribute(ConstantUtil.TYPE, "Form")
										.addAttribute(ConstantUtil.FORM_KEY, key);
							}
						} else {
							node.addElement("Entry").addAttribute(ConstantUtil.CAPTION, sourceCaption)
									.addAttribute(ConstantUtil.KEY, "entry_" + key)
									.addElement("EntryItem").addAttribute(ConstantUtil.CAPTION, caption)
									.addAttribute(ConstantUtil.KEY, "sub_" + key)
									.addAttribute(ConstantUtil.TYPE, "Form")
									.addAttribute(ConstantUtil.FORM_KEY, key);
						}

						entryProject = pKey;

						flag = false;
						break;
					}
				}
			}

			if (flag) {
				String entryXml = ProjectMetaResolverUtils.readProjectFile(projectKey, "Entry.xml");
				if ( StringUtils.isNotBlank(entryXml) ) {
					document = reader.read(new StringReader(entryXml));
					this.addCustomEntry(source, document, formType, key, caption);
					entryProject = projectKey;
				} else {
					entryXml = ProjectMetaResolverUtils.readProjectFile(STR_DefaultProjectKey, "Entry.xml");
					document = reader.read(new StringReader(entryXml));
					this.addCustomEntry(source, document, formType, key, caption);
					entryProject = STR_DefaultProjectKey;
				}
			}

			if (null!=entryProject){
				OutputFormat format = getOutputFormat();
				try(Writer entryWriter = new StringWriter()){
					XMLWriter writer = new XMLWriter(entryWriter, format);
					writer.write(document);
					String entryXml = entryWriter.toString();
					ProjectMetaResolverUtils.writeProjectFile(entryProject, "Entry.xml", entryXml);
				}

				reloadEntry(entryProject);

				String tmpEntryPath = ProjectMetaResolverUtils.tryGetProjectFilePath(entryProject, "Entry.xml");
				if (null!=tmpEntryPath){
					entryPath = new File(tmpEntryPath);
				}
			}
		}

		if (isNew && entryPath != null && entryPath.exists()) {//新增表单调用的
			RecycleForm recycleForm = new RecycleForm();
			recycleForm.setFilePath(entryPath.getPath());
			String content = FileUtils.readFileToString(entryPath, "UTF-8");
			recycleForm.setContent(content);
			if (!XmlFileProcessor.recycleToTmpFormAndFileMap.containsKey("Entry@Entry"+key)) {
				XmlFileProcessor.instance.saveTempRecycleFile("Entry@Entry"+key, recycleForm);
			}
		}
	}

	public void NewProject(String key, String caption, String SolutionKey) throws Throwable {
//		 配置solution.xml
		writeSolution(key, caption, SolutionKey);

		// TODO 暂时默认写死，新建的工程在basis中的entry.xml中新增菜单。 后面把新增菜单功能拆分出来。
		getEntryPath(key);

		reloadEntry(key);
	}

	public static void writeSolution(String key, String caption, String SolutionKey) throws IOException, DocumentException {
		String entryPath = Paths.get(SolutionKey, "", "Solution.xml").toString();
		// 创建SAX读取器
		SAXReader reader = new SAXReader();
		// 加载文档
		Document document = reader.read(new File(entryPath));
		Element node = (Element) document.getRootElement().selectSingleNode("/Solution/ProjectCollection");
		node.addElement("Project").addAttribute(ConstantUtil.CAPTION, caption).addAttribute(ConstantUtil.KEY, key);


		OutputFormat format = getOutputFormat();
		FileOutputStream fileOutputStream = new FileOutputStream(entryPath);
		XMLWriter writer = new XMLWriter(fileOutputStream, format);
		writer.write(document);

	}
	public static void deleteSolutionByProjectKey(String key,  String SolutionKey) throws IOException, DocumentException {
		String entryPath = Paths.get(SolutionKey, "", "Solution.xml").toString();
		entryPath = entryPath.replace("\\\\", File.separator).replace('\\', File.separatorChar).replace('/', File.separatorChar);
		// 创建SAX读取器
		SAXReader reader = new SAXReader();
		// 加载文档
		Document document = reader.read(new File(entryPath));
		Element node = (Element) document.getRootElement().selectSingleNode("/Solution/ProjectCollection");
		Element nodes = (Element) document.getRootElement().selectSingleNode("/Solution/ProjectCollection/Project[@Key='" + key + "']");
		node.remove(nodes);
		OutputFormat format = getOutputFormat();
		FileOutputStream fileOutputStream = new FileOutputStream(entryPath);
		XMLWriter writer = new XMLWriter(fileOutputStream, format);
		writer.write(document);

	}
}

