package com.bokesoft.yes.design.cmd;

import com.bokesoft.erp.webdesigner.language.infrastructure.index.IndexFacade;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.IndexFileWrapper;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.DiffProperty;
import com.bokesoft.yes.design.MetaObjectType;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.dto.CommitDiffDto;
import com.bokesoft.yes.design.function.DesignActionUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.helper.DocumentHelper;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.helper.MetaFormHelper;
import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.cmd.richdocument.strut.DocumentRecordDirty;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumn;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumnCollection;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.web.util.ExtensionUtil;
import com.bokesoft.yigo.mid.web.util.IExtensionProvider;
import com.bokesoft.yigo.struct.document.Document;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.json.JSONArray;
import org.json.JSONObject;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.*;

/**
 * 前端向后端提交差异
 */
public class CommitDiffCmd extends DesignerServiceCmd {
    public static final String CMD = "CommitDiff";
    public static final CommitDiffCmd instance = new CommitDiffCmd();
    private String formKey;
    private String entryParas;
    private final List<Diff> diffs = new ArrayList<>();
    private DocumentRecordDirty formDocument;
    private Document designerDocument;

    private String controlType;
    private String notNewTableFlagStr = "1";

    private Set<String> openFormKeys = new HashSet<>();
    private boolean beExtendedFlag = false;
    private boolean vestFlag = false;
    private boolean specVestFlag = false;
    private Pair<List<MetaFormProfile>, MetaFormProfile> metaFormPair = Pair.of(Collections.emptyList(), null);
    private Map<String, XmlTreeWithPath> xmlTreeMap = new HashMap<>();
    private boolean withoutUICommands = false;

    @Override
    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        beExtendedFlag = false;
        vestFlag = false;
        specVestFlag = false;
        metaFormPair = Pair.of(Collections.emptyList(), null);
        xmlTreeMap = new HashMap<>();

        String key = (String) arguments.get("openFormKeys");
        if (StringUtils.isNotBlank(key)) {
            openFormKeys.addAll(Arrays.asList(key.split(",")));
        }
        context.setPara("openFormKeys", openFormKeys);
        formKey = (String) arguments.get("formKey");
        entryParas = (String) arguments.get("entryParas");
        if (arguments.containsKey("designerDocument")) {
            String docStr = (String) arguments.get("designerDocument");
            designerDocument = DocumentHelper.parseDocumentFormJSON(docStr);
        }
        if (arguments.containsKey("formDocument")) {
            String docStr = (String) arguments.get("formDocument");
            String documentFormKey = (String) arguments.get("documentFormKey");
            MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(documentFormKey);
            formDocument = new DocumentRecordDirty(metaForm, false);
            try {
                formDocument.fromJSON(new JSONObject(docStr));
            } catch (Exception e) {
                LogSvr.getInstance().error(e.getMessage(), e);
            }
        }
        String diffJsonString = (String) arguments.get("diffs");
        JSONArray array = new JSONArray(diffJsonString);
        for (int i = 0; i < array.length(); i++) {
            JSONObject jsonObject = array.getJSONObject(i);
            diffs.add(Diff.fromJson(jsonObject));
            controlType = jsonObject.optString("controlType");
            notNewTableFlagStr = jsonObject.optString("associatedTable", "1");
        }
        this.validateArguments(array);
        this.validateExtension(array, context);//校验移动扩展表单
    }

    @Override
    public synchronized Object innerDoCmd(DefaultContext context) throws Throwable {
        final IMetaFactory metaFactory = MetaFactory.getGlobalInstance();

        MetaFormProfile tmpProfile = metaFactory.getMetaFormList().get(formKey);
        if(tmpProfile == null) {
            tmpProfile = metaFactory.getExtFormList().get(formKey);
        }
        String prjKey = tmpProfile.getProject().getKey();

        if (LoadFileTree.isJarProjectKey(prjKey)) {
            CommitDiffDto commitDiffDto = new CommitDiffDto();
            commitDiffDto.setResult("fail");
            commitDiffDto.setMessage("Jar包中的表单无法修改 ("+CommitDiffCmd.class.getSimpleName()+")");
            return commitDiffDto.toJson();
        }
        CommitDiffDto commitDiffDto = commitDiffWithoutUiCommand(context, formKey, entryParas, diffs, designerDocument, formDocument);
        List<String> formKeyList = new ArrayList<>();
        formKeyList.add(formKey);
        MetaForm metaForm = metaFactory.getMetaForm(formKey);
        if (StringUtils.isNotBlank(metaForm.getExtend())) {
            formKeyList.add(metaForm.getExtend());
        } else {
            final MetaFormList metaFormList = metaFactory.getMetaFormList();
            for (MetaFormProfile metaFormProfile : metaFormList) {
                final String extend = metaFormProfile.getExtend();
                if (StringUtils.equals(extend, formKey)) {
                    formKeyList.add(metaFormProfile.getKey());
                }
            }
        }
        String paramsFormKey = diffs.get(0).getParamsformKey();
        if (!StringUtils.equals(diffs.get(0).formKey, paramsFormKey)) {
            formKeyList.add(paramsFormKey);

            String paramsFormPath = LoadFileTree.getPathByFormKey(paramsFormKey);
            commitDiffDto.getFilePathList().add(paramsFormPath);
        }
        commitDiffDto.setFormKeyList(formKeyList);
        boolean hasPreOpt = StringUtils.equals(controlType, "ListView") && StringUtils.equals(notNewTableFlagStr, "0");
        if (!hasPreOpt) {
            return commitDiffDto.toJson();
        }
        String filePath = LoadFileTree.getPathByFormKey(formKey);
        if (XmlFileProcessor.filePathToTmpFileMap.containsKey(filePath)) {
            Stack<String> stack = XmlFileProcessor.filePathToTmpFileMap.get(filePath);
            String curTmpFile = stack.pop();
            stack.pop(); // 弹出创建新建表的临时文件
            stack.push(curTmpFile);
        }
        return commitDiffDto.toJson();
    }

    private static CommitDiffDto commitDiffWithoutUiCommand(DefaultContext context, String formKey, String entryParas, List<Diff> diffs, Document designerDocument, DocumentRecordDirty formDocument) throws Throwable {
        loadXmlTrees(diffs, entryParas, null);
        // 1.从属性差异转化为XML节点差异
        final int anInt = XmlDiffProcessor.instance.processDiff(diffs, designerDocument);
        // 2.从XML节点差异转化属性差异（可能转化无效）
        boolean genPropertyDiffSuccess = XmlDiffToPropertyDiff.instance.processDiff(diffs);
        // 3.通过XML节点差异，修改XML临时文件
        Map<String, String> tmpFiles = XmlFileProcessor.instance.processDiff(diffs, false);
        // 4.通过XML节点差异，配置对象读取差异
        String XmlError = MetaFormDiffProcessor.instance.processDiff(context,diffs, genPropertyDiffSuccess, formDocument, tmpFiles);

        // 处理返回对象
        CommitDiffDto commitDiffDto = new CommitDiffDto();
        if ("操作成功".equals(XmlError)){
            commitDiffDto.setResult("Success");
        }else {
            commitDiffDto.setResult("fail");
        }
        List<String> filePathList = new ArrayList<>();
        String filePath;
        String dataObjectFilePath;
        String otherDataObjectFilePath;
        for (Diff diff : diffs) {
            if (diff.isPropertyDiff()) {
                filePath = FilePathHelper.toFrontFilePath(diff.getFilePath());
                dataObjectFilePath = FilePathHelper.toFrontFilePath(diff.getDataObjectfilePath());
                otherDataObjectFilePath = FilePathHelper.toFrontFilePath(diff.getOtherDataObjectFilePath());
                filePathList.add(filePath);
                if (StringUtils.isNotEmpty(dataObjectFilePath)){
                    filePathList.add(dataObjectFilePath);
                }
                if (StringUtils.isNotEmpty(otherDataObjectFilePath)){
                    filePathList.add(otherDataObjectFilePath);
                }
            }
        }
        // 更新索引
        for (String path : filePathList) {
            String tempFilePath = XmlFileProcessor.instance.getTmpFile(path);
            IndexFileWrapper file = IndexFileWrapper.newInstance(path, tempFilePath);
            IndexFacade.reload(file);
        }
        commitDiffDto.setFilePathList(filePathList);
        processDocumentDirty(diffs, formKey, null,commitDiffDto, formDocument, context);
        commitDiffDto.setMessage(XmlError);
        return commitDiffDto;
    }

    private static void setLocateIdList(List<String> locateIdList, TagNode node){
        TagNode parent = node.getParent();
        
        if (parent == null) {
        	return;
        }
        
        if (parent.getParent() == null || parent.getTagName().equalsIgnoreCase("Block")){
            return;
        }
        String key = parent.getAttributes().get("Key");
        if (StringUtils.isNotEmpty(key)){
            locateIdList.add(key);
        }
        setLocateIdList(locateIdList, parent);
    }

    private static void processDocumentDirty(List<Diff> diffs, String Key,List<UICommand> uiCommands ,CommitDiffDto commitDiffDto, DocumentRecordDirty formDocument, DefaultContext context) throws Throwable {
        // TODO: 判断是否有脏数据
        if (Objects.isNull(formDocument)) {
            return;
        }
        if (DesignActionUtil.getPreferencesInfo("IsShowData").equals("false")) {
            return;
        }

        String formKey = formDocument.getMetaForm().getKey();
        if (!StringUtils.equals(diffs.get(0).getParamsformKey(), formKey)) {
            return;
        }

        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaFormProfile metaFormProfile = metaFactory.getMetaFormList().get(Key);
        String extend = metaFormProfile.getExtend();
        //是马甲或者视图不做处理
        if (StringUtils.isNotBlank(extend) && !metaFormProfile.getMergeToSource()) {
            return;
        }
        if (metaFormProfile.getForm().getFormType() == FormType.View) {
            return;
        }

        RichDocumentContext richDocumentContext = processParentContext(context, formDocument);
        formDocument.setContext(richDocumentContext);
        //以json的形式返回脏数据
        try {//当嵌入模板时这个会报错就不进行
            formDocument.setMetaForm(metaFormProfile.getForm());
            JSONObject documentDirty = formDocument.getDirtyJSON(richDocumentContext);
            if (uiCommands != null){
                uiCommands.add(UICommand.processDocumentDirty(formKey, documentDirty));
            }
            if (commitDiffDto != null){
                commitDiffDto.setDocumentDirty(documentDirty);
            }
        } catch (Throwable e) {//不处理
            LogSvr.getInstance().error("", e);
        }
    }

    /**
     * create time: 2020/11/23 14:28
     * Affect :处理上下文，转换成需要的数据格式
     *
     * @return
     * @Param: null
     */
    private static RichDocumentContext processParentContext(DefaultContext context, DocumentRecordDirty formDocument) throws Throwable {
        context.setFormKey(formDocument.getMetaForm().getKey());
        context.setDocument(formDocument);
        RichDocumentContext parentContext = (RichDocumentContext) context.getParentContext();
        if (Objects.isNull(parentContext)) {
            parentContext = new RichDocumentContext(context);
            parentContext.setDocument(formDocument);
            context.setParentContext(parentContext);
        }
        return parentContext;
    }
    public static void loadXmlTrees(List<Diff> diffs, String entryParas, String type) throws Throwable {
        Map<String, XmlTreeWithPath> xmlTrees = new HashMap<>();
        for (Diff diff : diffs) {
            if (StringUtils.isBlank(type) && Objects.nonNull(diff.getMetaObjectType())) {
                type = diff.getMetaObjectType().name;
            }

            String filePath = diff.getFilePath();
            String realFormKey = diff.formKey; // 组件所在表单对象，字典可能不是ERP_DictEdit，而是内嵌的表单
            if (StringUtils.isNotBlank(filePath)) {
                if (StringUtils.equals(realFormKey, "ERP_DictEdit")) {
                    realFormKey = FilenameUtils.getBaseName(filePath);
                }
            } else {
                if (StringUtils.equals(type, ConstantUtil.DATA_OBJECT)) {
                    if (Objects.equals(diff.getMetaObjectType(), MetaObjectType.DataObject)) {
                        filePath = LoadFileTree.loadFilePathByDataObjectFieldKey(realFormKey);
                    }
                } else {
                    filePath = LoadFileTree.getPathByFormKey(realFormKey);
                }
                if (StringUtils.isBlank(filePath)) {
                    realFormKey = entryParas;
                    if (StringUtils.isBlank(realFormKey)) {
                        String otherKey = entryParas;
                        realFormKey = otherKey;
                        diff.setContainerKey(otherKey);
                    }
                    filePath = LoadFileTree.loadFilePathByFormFieldKey(realFormKey, diff.getOrgKey(), diff.parentKey, entryParas, type);
                }
                if (StringUtils.isNotBlank(entryParas)) {
                    realFormKey = entryParas;
                    diff.setContainerKey(entryParas);
                }
                diff.setFilePath(filePath);
            }

            if (StringUtils.isBlank(realFormKey)) {
                realFormKey = diff.formKey;
            }

            if (StringUtils.equals(type, ConstantUtil.DATA_OBJECT)) {
                diff.setMetaDataObejct(MetaFactory.getGlobalInstance().getDataObject(realFormKey));
            } else {
                if (!StringUtils.equalsIgnoreCase(type, "CommonDef")) {
                    diff.setMetaForm(MetaFactory.getGlobalInstance().getMetaForm(realFormKey));
                }
            }

            String filePathVest = ""; //马甲路径
            String dataObjectFilePath = "";//数据对象源文件地址
            if (!StringUtils.equalsAny(type, ConstantUtil.DATA_OBJECT, "CommonDef")) {
                filePathVest = LoadFileTree.loadFilePathByVestFormFieldKey(true, diff.getMetaForm().getExtend(), diff.getOrgKey(), diff.parentKey, entryParas);
                MetaDataSource dataSource = diff.getMetaForm().getDataSource();

                if (Objects.nonNull(dataSource)) {
                    String refObjectKey = dataSource.getRefObjectKey();
                    if (StringUtils.isNotBlank(refObjectKey)) {
                        dataObjectFilePath = LoadFileTree.loadFilePathByDataObjectFieldKey(refObjectKey);
                    }
                }
            }

            XmlTreeWithPath orgTree = xmlTrees.get(filePath);
            XmlTreeWithPath defaultOrgTree = null;
            XmlTreeWithPath vestOrgTree = null;
            XmlTreeWithPath dataObjectOrgTree = null;
            XmlTreeWithPath otherDataObjectOrgTree = null;

            if (Objects.isNull(orgTree) || Objects.isNull(diff.getXmlTree())) {
                if (StringUtils.isNotBlank(dataObjectFilePath)) {
                    diff.setDataObjectfilePath(dataObjectFilePath);
                }
                orgTree = XmlTreeWithPath.parseFilePath(filePath); //修改时
                defaultOrgTree = XmlTreeWithPath.parseFilePathNotLoadTmp(filePath);//默认时
                vestOrgTree = XmlTreeWithPath.parseFilePath(filePathVest);
                dataObjectOrgTree = XmlTreeWithPath.parseFilePath(dataObjectFilePath);

                if (Objects.nonNull(dataObjectOrgTree)) {
                    List<DiffProperty> properties = diff.properties;
                    boolean dataBindFlag = CollectionUtils.isNotEmpty(properties) && StringUtils.equals(properties.get(0).propertyValueByLocation, MetaDataBinding.TAG_NAME);
                    if (StringUtils.equalsIgnoreCase(diff.getReserveFour(), "true") || dataBindFlag) {
                        String refObjectKey = diff.getMetaForm().getDataSource().getRefObjectKey();
                        MetaDataObject dataObject = MetaFactory.getGlobalInstance().getDataObject(refObjectKey);
                        String mergeToSourceMapKey = dataObject.getMergeToSourceMapKey();
                        if (StringUtils.isNotBlank(mergeToSourceMapKey)) {
                            String mergePath = LoadFileTree.loadFilePathByDataObjectFieldKey(mergeToSourceMapKey);
                            // String tmpMergePath = XmlFileProcessor.instance.getTmpFile(mergePath);
                            // String mergeFilePath = StringUtils.isNotBlank(tmpMergePath) ? tmpMergePath : mergePath;
                            diff.setOtherDataObjectFilePath(diff.getDataObjectfilePath());
                            diff.setDataObjectfilePath(mergePath);
                            otherDataObjectOrgTree = XmlTreeWithPath.parseFilePath(mergePath);
                        }

                        TagNode tagNode = dataObjectOrgTree.xmlTree.getTagNode(ConstantUtil.TABLE + "@" + diff.getReserveTwo());
                        if (Objects.isNull(tagNode)) {
                            XmlTreeWithPath tmp = dataObjectOrgTree;
                            dataObjectOrgTree = otherDataObjectOrgTree;
                            otherDataObjectOrgTree = tmp;
                        }

                        String extendObjectKey = dataObject.getExtend();
                        if (Objects.isNull(otherDataObjectOrgTree) && StringUtils.isNotBlank(extendObjectKey)) {
                            String mergePath = LoadFileTree.loadFilePathByDataObjectFieldKey(extendObjectKey);
                            // String tmpMergePath = XmlFileProcessor.instance.getTmpFile(mergePath);
                            // String mergeFilePath = StringUtils.isNotBlank(tmpMergePath) ? tmpMergePath : mergePath;
                            diff.setOtherDataObjectFilePath(diff.getDataObjectfilePath());
                            diff.setDataObjectfilePath(mergePath);
                            otherDataObjectOrgTree = XmlTreeWithPath.parseFilePath(mergePath);
                        }
                    }
                }

                if (Objects.nonNull(orgTree)) {
                    xmlTrees.put(orgTree.orgFilePath, orgTree);
                }
                if (Objects.nonNull(defaultOrgTree)) {
                    xmlTrees.put(defaultOrgTree.orgFilePath, defaultOrgTree);
                }
                if (Objects.nonNull(vestOrgTree)) {
                    xmlTrees.put(vestOrgTree.orgFilePath, vestOrgTree);
                }
                if (Objects.nonNull(dataObjectOrgTree)) {
                    xmlTrees.put(dataObjectOrgTree.orgFilePath, dataObjectOrgTree);
                }
            }
            if (Objects.isNull(orgTree)) {
                String path = diff.getFilePath();
                orgTree = XmlTreeWithPath.parseFilePath(path);
            }
            diff.setXmlTree(orgTree);
            diff.setDefaultxmlTree(defaultOrgTree);
            diff.setVestXmlTree(vestOrgTree);
            diff.setDataObjectXmlTree(dataObjectOrgTree);
            diff.setOtherDataObjectOrgTree(otherDataObjectOrgTree);

            if (Objects.equals(diff.getMetaObjectType(), MetaObjectType.gridField) && StringUtils.isNotBlank(diff.sideKey)) {
                String sideKey = ConstantUtil.GRID_COLUMN + "@" + diff.sideKey;
                if (!orgTree.xmlTree.containKey(sideKey) && !StringUtils.contains(sideKey, "_")) {
                    MetaForm metaForm = diff.getMetaForm();
                    MetaGrid metaGrid = (MetaGrid) metaForm.componentByKey(diff.parentKey);
                    if (Objects.nonNull(metaGrid)) {
                        MetaGridColumnCollection columnCollection = metaGrid.getColumnCollection();
                        for (int idx = columnCollection.size() - 1; idx >= 0; idx--) {
                            MetaGridColumn metaGridColumn = columnCollection.get(idx);
                            String key = metaGridColumn.getKey();
                            sideKey = ConstantUtil.GRID_COLUMN + "@" + key;
                            if (orgTree.xmlTree.containKey(sideKey)) {
                                diff.sideKey = key;
                                break;
                            }
                        }
                    }
                }
            }
        }
        xmlTrees.clear();
    }

    @Override
    public String getCmd() {
        return CMD;
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new CommitDiffCmd();
    }

    private void validateArguments(JSONArray array) throws Throwable {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaForm metaForm = metaFactory.getMetaForm(formKey);

        this.beExtendedFlag = MetaFormHelper.isBeExtended(metaForm);
        this.vestFlag = StringUtils.isNotBlank(metaForm.getExtend());
        this.specVestFlag = Objects.equals(metaForm.getMergeToSource(), Boolean.TRUE);

        // 既没被继承，也不是马甲
        if (!this.beExtendedFlag && !this.vestFlag) {
            return;
        }

        // 界面马甲
        if (this.vestFlag && !this.specVestFlag) {
            return;
        }

        if (!this.specVestFlag) {
            metaFormPair = MetaFormHelper.listVestMetaFormByOriginal(metaForm);
        } else {
            metaFormPair = MetaFormHelper.listVestMetaFormBySpecVest(metaForm);
        }

        List<MetaFormProfile> vestMetaFormList = metaFormPair.getLeft();
        for (MetaFormProfile vestMetaForm : vestMetaFormList) {
            String vestFilePath = LoadFileTree.getPathByFormKey(vestMetaForm.getKey());
            String tmpVestFilePath = XmlFileProcessor.instance.getTmpFile(vestFilePath);
            String realVestFilePath = StringUtils.isNotBlank(tmpVestFilePath) ? tmpVestFilePath : vestFilePath;
            XmlTreeWithPath vestMetaXmlTree = XmlTreeWithPath.parseFilePath(realVestFilePath);
            xmlTreeMap.put(vestMetaForm.getKey(), vestMetaXmlTree);
        }

        MetaFormProfile funMetaForm = metaFormPair.getRight();
        if (Objects.nonNull(funMetaForm)) {
            String funFilePath = LoadFileTree.getPathByFormKey(funMetaForm.getKey());
            String tmpFunFilePath = XmlFileProcessor.instance.getTmpFile(funFilePath);
            String realFunFilePath = StringUtils.isNotBlank(tmpFunFilePath) ? tmpFunFilePath : funFilePath;
            XmlTreeWithPath funMetaXmlTree = XmlTreeWithPath.parseFilePath(realFunFilePath);
            xmlTreeMap.put(funMetaForm.getKey(), funMetaXmlTree);
        }

        for (int i = 0; i < array.length(); i++) {
            JSONObject jsonObject = array.getJSONObject(i);
            String compKey = jsonObject.optString("key");
            if (StringUtils.isBlank(compKey)) {
                continue;
            }
            String metaObjectType = jsonObject.optString("metaObjectType");

            boolean isButtonQuote = jsonObject.optBoolean("ISButtonQuote", false);
            final String caption = jsonObject.optString("caption", "");
            if (StringUtils.isNotBlank(caption) && !isButtonQuote) {
                this.validateArgumentsByAdd(compKey, metaObjectType);
            }

            final boolean isDelete = jsonObject.optBoolean("isDelete", false);
            if (isDelete) {
                this.validateArgumentsByDelete(compKey, metaObjectType);
            }
        }
    }

    private void validateArgumentsByAdd(String compKey, String metaObjectType) throws IllegalAccessException {
        MetaFormProfile funMetaForm = metaFormPair.getRight();
        if (Objects.isNull(funMetaForm)) {
            return;
        }

        String typeName = this.specVestFlag ? "原单" : "马甲";
        XmlTreeWithPath xmlTreeWithPath = xmlTreeMap.get(funMetaForm.getKey());
        // TODO 补充其它的组件
        if (StringUtils.equals(metaObjectType, "GridField")) {
            boolean existFlag = xmlTreeWithPath.xmlTree.containKey("GridColumn@" + compKey);
            if (existFlag) {
                throw new RuntimeException("warning: " + typeName + "[key=" + funMetaForm.getKey() + "]已存在相同组件Key！");
            }
            existFlag = xmlTreeWithPath.xmlTree.containKey("GridCell@" + compKey);
            if (existFlag) {
                throw new RuntimeException("warning: " + typeName + "[key=" + funMetaForm.getKey() + "]已存在相同组件Key！");
            }
        }
        boolean existFlag = xmlTreeWithPath.xmlTree.containKey(metaObjectType + "@" + compKey);
        if (existFlag) {

            throw new RuntimeException("warning: " + typeName + "[key=" + funMetaForm.getKey() + "]已存在相同组件Key！");
        }
        final Field[] fs = ControlType.class.getFields();
        for (Field f : fs) {
            int modifiers = f.getModifiers();
            if (!Modifier.isPublic(modifiers)) {
                continue;
            }
            if (!Modifier.isStatic(modifiers)) {
                continue;
            }
            if (!Modifier.isFinal(modifiers)) {
                continue;
            }
            if (!StringUtils.startsWithIgnoreCase(f.getName(), "STR_")) {
                continue;
            }
            existFlag = xmlTreeWithPath.xmlTree.containKey(f.get(null) + "@" + compKey);
            if (existFlag) {
                throw new RuntimeException("warning: " + typeName + "[key=" + funMetaForm.getKey() + "]已存在相同组件Key！");
            }
        }
    }

    private void validateArgumentsByDelete(String compKey, String metaObjectType) throws IllegalAccessException {
        List<MetaFormProfile> vestMetaForm = new ArrayList<>(metaFormPair.getLeft());
        if (this.beExtendedFlag && Objects.nonNull(metaFormPair.getRight())) {
            vestMetaForm.add(metaFormPair.getRight());
        }

        for (MetaFormProfile metaForm : vestMetaForm) {
            XmlTreeWithPath xmlTreeWithPath = xmlTreeMap.get(metaForm.getKey());
            // TODO 补充其它的组件
            if (StringUtils.equals(metaObjectType, "GridField")) {
                boolean existFlag = xmlTreeWithPath.xmlTree.containKey("GridColumn@" + compKey);
                if (existFlag) {
                    throw new RuntimeException("warning: 马甲[key=" + metaForm.getKey() + "]已使用该组件！");
                }
                existFlag = xmlTreeWithPath.xmlTree.containKey("GridCell@" + compKey);
                if (existFlag) {
                    throw new RuntimeException("warning: 马甲[key=" + metaForm.getKey() + "]已使用该组件！");
                }
            }
            boolean existFlag = xmlTreeWithPath.xmlTree.containKey(metaObjectType + "@" + compKey);
            if (existFlag) {
                throw new RuntimeException("warning: 马甲[key=" + metaForm.getKey() + "]已使用该组件！");
            }

            final Field[] fs = ControlType.class.getFields();
            for (Field f : fs) {
                int modifiers = f.getModifiers();
                if (!Modifier.isPublic(modifiers)) {
                    continue;
                }
                if (!Modifier.isStatic(modifiers)) {
                    continue;
                }
                if (!Modifier.isFinal(modifiers)) {
                    continue;
                }
                if (!StringUtils.startsWithIgnoreCase(f.getName(), "STR_")) {
                    continue;
                }
                existFlag = xmlTreeWithPath.xmlTree.containKey(f.get(null) + "@" + compKey);
                if (existFlag) {
                    throw new RuntimeException("warning: 马甲[key=" + metaForm.getKey() + "]已使用该组件！");
                }
            }
        }
    }

    private void validateExtension(JSONArray array, DefaultContext context) throws Throwable {
        IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
        MetaForm metaForm = metaFactory.getMetaForm(formKey);
        IExtensionProvider provider = ExtensionUtil.newDefaultProvider();
        MetaForm extensionForm = provider.getExtMetaForm(context, metaForm);
        if (extensionForm == null) return;
        for (int i = 0; i < array.length(); i++) {
            JSONObject jsonObject = array.getJSONObject(i);
            String compKey = jsonObject.optString("key");
            if (StringUtils.isBlank(compKey)) {
                continue;
            }
            String metaObjectType = jsonObject.optString("metaObjectType");
            final boolean isDelete = jsonObject.optBoolean("isDelete", false);
            if (isDelete) {
                String vestFilePath = LoadFileTree.getPathByFormKey(extensionForm.getKey());
                String tmpVestFilePath = XmlFileProcessor.instance.getTmpFile(vestFilePath);
                String realVestFilePath = StringUtils.isNotBlank(tmpVestFilePath) ? tmpVestFilePath : vestFilePath;
                XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(realVestFilePath);
                boolean existFlag = xmlTreeWithPath.xmlTree.containKey(metaObjectType + "@" + compKey);
                if (existFlag) {
                    throw new RuntimeException("warning: 移动扩展表单[key=" + extensionForm.getKey() + "]中已使用该组件，请先移除！");
                }
                final Field[] fs = ControlType.class.getFields();
                for (Field f : fs) {
                    int modifiers = f.getModifiers();
                    if (!Modifier.isPublic(modifiers)) {
                        continue;
                    }
                    if (!Modifier.isStatic(modifiers)) {
                        continue;
                    }
                    if (!Modifier.isFinal(modifiers)) {
                        continue;
                    }
                    if (!StringUtils.startsWithIgnoreCase(f.getName(), "STR_")) {
                        continue;
                    }
                    existFlag = xmlTreeWithPath.xmlTree.containKey(f.get(null) + "@" + compKey);
                    if (existFlag) {
                        throw new RuntimeException("warning: 移动扩展表单[key=" + extensionForm.getKey() + "]中已使用该组件，请先移除！");
                    }
                }
            }
        }
    }
}
