package com.bokesoft.yes.design;

import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.context.DesignerContext;
import com.bokesoft.yes.design.function.DesignActionUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.mergesingle.util.QuoteGridFiledOperUtil;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 记录网页版设计器的差异，目前只考虑了Form的差异
 * 未来需要考虑DataObject、DataMigration等配置，也许通过新的对象实现
 */
public class Diff {
	/**
	 * 序列号，对一个客户端来说是唯一的
	 */
	public final String sequence;
	/**
	 * 表单Key
	 */
	public final String formKey;
	/**
	 * 父组件key,新增用
	 */
	public String parentKey;
	/**
	 * 暂时代表表格当前列的key
	 */
	public String sideKey;
	public boolean insertAfter; //表格列，默认向后插入
	public boolean isDelete;
	public boolean isMultyDelete;
	public boolean isMultyMove;
	public String bindingGridKey; //关联表格标识
	
	/** 新增tabItem */
	public boolean insertItemAfter;
	public boolean moveItemAfter;
	public boolean moveItemFront;
	
	/**
	 * 针对表格列，表示拖拽或新增（新增目前是使用上面两个属性）的新列位置
	 */
	private int newColumnIndex = -1;
	/**
	 * 坐标，用于新增头表组件
	 */
	public Integer x;
	public Integer y;
	/**
	 * 关联表  用于新增表格
	 */
	public String associatedTable;
	/**
	 * 关联表  用于新增表格后的新建数据源表标识
	 */
	public String tableKey;
	/**
	 * 关联表  用于新增表格后的新建数据源表名称
	 */
	public String tableName;
	/**
	 * 关联表  用于新增子明细+表格后的新建数据源表标识
	 */
	public String subTableKey;
	/**
	 * 关联表  用于新增子明细+表格后的新建数据源表名称
	 */
	public String subTableName;
	/**
	 * 关联表  用于新增子明细+表格
	 */
	public String subAssociatedTable;
	/**
	 * 当是Column时，key = key@表名，其他目前就是Key
	 */
	private String key;
	private String dictType;//字典类型（表格，非表格）
	private String containerKey;//用于处理带有container组件的表单
	/**
	 * 预留字段，传输一些特殊属性
	 */
	private String reserveOne;
	private String reserveTwo;
	private String reserveThree;
	private String reserveFour;
	private String dataElementKey;


	private String itemKey;

	//根据数据源创建表格列
	private String create;
	/**
	 * 定义一个boolean类型
	 */
	private Boolean trueOrfalse;
	/**
	 * 修改的属性位置
	 * 四种情况
	 * 1.current  当前节点属性
	 * 2.current_cdata  当前节点内容
	 * 3.son  子节点属性
	 * 3.son_cdata  子节点内容
	 */


	private MetaObjectType metaObjectType;

	/**
	 * 对应于类型com.bokesoft.yigo.common.def.ControlType，在未来的实现中可能会调整这个属性和metaObjectType之间的关系
	 */
	public int controlType;


	public String caption;

	public List<DiffProperty> properties = new ArrayList<>();

	//public List<DiffNewProperty> newProperties = new ArrayList<DiffNewProperty>();

	/**
	 * 是否是属性差异，即通过“设计”界面新增导致的差异
	 */
	private final boolean isPropertyDiff;
	/**
	 * 差异所指向的文件路径
	 */
	public String filePath;

	/**
	 * 差异数据对象所指向的文件路径
	 */
	private String dataObjectfilePath;
	private String otherDataObjectFilePath;
	/** 源代码界面修改xml后的结果 */
	private String newXml;
	/**
	 * 无效行
	 */
	public static final int INT_InvalidLine = -1;
	/**
	 * XML文件差异的开始行号
	 */
	private int startLine = INT_InvalidLine;
	/**
	 * xml修改的原内容片断
	 */
	private String orgXmlFragment;
	/**
	 * xml修改后新内容片断
	 */
	private String newXmlFragment;
	/**
	 * XML文件差异2的文件
	 */
	private XmlTreeWithPath xmlTree2;
	/**
	 * XML文件差异2（为了应对Column和GridCell之间的关系）的开始行号
	 */
	private int startLine2 = INT_InvalidLine;
	/**
	 * xml修改2（为了应对Column和GridCell之间的关系）的原内容片断
	 */
	private String orgXmlFragment2;
	/**
	 * xml修改后新内容片断2（为了应对Column和GridCell之间的关系）
	 */
	private String newXmlFragment2;
	/**
	 * 对应的XML节点树，对应第一个差异
	 */
	private XmlTreeWithPath xmlTree;

	private String cellList;

	public String getParamsformKey() {
		return paramsformKey;
	}

	public void setParamsformKey(String paramsformKey) {
		this.paramsformKey = paramsformKey;
	}

	/**
	 * 父表单formKey
	 */
	private String paramsformKey;
	/**
	 * 对应的XML默认节点树
	 */
	private XmlTreeWithPath defaultxmlTree;
	/**
	 * 对应的VestXML节点树
	 */
	private XmlTreeWithPath vestXmlTree;
	/**
	 * 对应的数据对象XML节点树
	 */
	private XmlTreeWithPath dataObjectXmlTree;

	private XmlTreeWithPath otherDataObjectOrgTree;
	/**
	 * 是否是引入组件
	 */
	public Boolean isButtonQuote;
	/**
	 * 是否是嵌入组件
	 */
	public Boolean isEmbed;

	public String addDirection;

	public String deleteDirection;


	public String getDataElementKey() {
		return dataElementKey;
	}

	public void setDataElementKey(String dataElementKey) {
		this.dataElementKey = dataElementKey;
	}

	public String getItemKey() {
		return itemKey;
	}

	public void setItemKey(String itemKey) {
		this.itemKey = itemKey;
	}

	public XmlTreeWithPath getDefaultxmlTree() {
		return defaultxmlTree;
	}

	public void setDefaultxmlTree(XmlTreeWithPath defaultxmlTree) {
		this.defaultxmlTree = defaultxmlTree;
	}

	public XmlTreeWithPath getDataObjectXmlTree() {
		return dataObjectXmlTree;
	}

	public void setDataObjectXmlTree(XmlTreeWithPath dataObjectXmlTree) {
		this.dataObjectXmlTree = dataObjectXmlTree;
	}

	public XmlTreeWithPath getOtherDataObjectOrgTree() {
		return otherDataObjectOrgTree;
	}

	public void setOtherDataObjectOrgTree(XmlTreeWithPath otherDataObjectOrgTree) {
		this.otherDataObjectOrgTree = otherDataObjectOrgTree;
	}

	public Boolean getEmbed() {
		return isEmbed;
	}

	public void setEmbed(Boolean embed) {
		isEmbed = embed;
	}

	public XmlTreeWithPath getVestXmlTree() {
		return vestXmlTree;
	}

	public void setVestXmlTree(XmlTreeWithPath vestXmlTree) {
		this.vestXmlTree = vestXmlTree;
	}

	public Diff(String sequence, String formKey, boolean isPropertyDiff) {
		this.sequence = sequence;
		this.formKey = formKey;
		this.isPropertyDiff = isPropertyDiff;
	}


	public TagNode getTagNode(String key) {
		try {
			if (vestXmlTree == null) {
				return xmlTree.xmlTree.getTagNode(key);
			} else {
				if (xmlTree.xmlTree.getTagNode(key) == null) {
					TagNode tagNode3 = vestXmlTree.xmlTree.getTagNode(key);
					List<String> strings = new ArrayList<>();
					strings.add(tagNode3.getPrimaryKey());
					TagNode tagNode = tagNode3;
					String primaryKey = tagNode.getPrimaryKey();
					while (tagNode.getPrimaryKey()==null || xmlTree.xmlTree.getTagNode(tagNode.getPrimaryKey()) == null) {
						tagNode = tagNode.getParent();
						primaryKey = tagNode.getPrimaryKey();
					}
					TagNode fieldNode1 = xmlTree.xmlTree.getTagNode(primaryKey);
					QuoteGridFiledOperUtil.getParent(tagNode3, fieldNode1, strings);
					for (int i = strings.size() - 2; i >= 0; i--) {
						if (strings.get(i).contains("@")) {
							fieldNode1 = fieldNode1.getOrCreateChildByKey(strings.get(i).split("@")[0], strings.get(i).split("@")[1]);
						} else {
							fieldNode1 = fieldNode1.getOrCreateChildByKey(strings.get(i), "");
						}
					}
					return fieldNode1;
				} else {

					return xmlTree.xmlTree.getTagNode(key);
				}


			}
		}catch (Exception e) {

			throw new RuntimeException("当前表单的Xml中未找到当前节点,不能修改!!!");

		}



	}

	/*
	public Diff(String formKey, String key, MetaObjectType metaObjectType, String caption) {
		this.formKey = formKey;
		this.key = key;
		this.metaObjectType = metaObjectType;
		this.caption = caption;
	}
	public Diff(String formKey, String key, MetaObjectType metaObjectType) {
		this.formKey = formKey;
		this.key = key;
		this.metaObjectType = metaObjectType;
	}
	public Diff FieldDiff(String formKey, String fieldKey) {
		return new Diff(formKey, fieldKey, MetaObjectType.field, caption);
	}*/
	public String getAddDirection() {
		return addDirection;
	}

	public String getDeleteDirection() {
		return deleteDirection;
	}

	public void setDeleteDirection(String deleteDirection) {
		this.deleteDirection = deleteDirection;
	}

	public String getKey() {
		return key;
	}

	public String getCreate() {
		return create;
	}

	public void setCreate(String create) {
		this.create = create;
	}

	public String getDataObjectfilePath() {
		return dataObjectfilePath;
	}

	public void setDataObjectfilePath(String dataObjectfilePath) {
		this.dataObjectfilePath = dataObjectfilePath;
	}

	public String getOtherDataObjectFilePath() {
		return otherDataObjectFilePath;
	}

	public void setOtherDataObjectFilePath(String otherDataObjectFilePath) {
		this.otherDataObjectFilePath = otherDataObjectFilePath;
	}

	public String getCellList() {
		return cellList;
	}

	public void setCellList(String cellList) {
		this.cellList = cellList;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getDictType() {
		return dictType;
	}

	public void setDictType(String DictType) {
		this.dictType = DictType;
	}

	public String getContainerKey() {
		return containerKey;
	}

	public void setContainerKey(String ContainerKey) {
		this.containerKey = ContainerKey;
	}

	public String getReserveTwo() {
		return reserveTwo;
	}

	public void setReserveTwo(String reserveTwo) {
		this.reserveTwo = reserveTwo;
	}

	public Boolean getTrueOrfalse() {
		return trueOrfalse;
	}

	public void setTrueOrfalse(Boolean trueOrfalse) {
		this.trueOrfalse = trueOrfalse;
	}

	public String getReserveOne() {
		return reserveOne;
	}

	public String getReserveThree() {
		return reserveThree;
	}

	public void setReserveThree(String reserveThree) {
		this.reserveThree = reserveThree;
	}

	public String getReserveFour() {
		return reserveFour;
	}

	public void setReserveFour(String reserveFour) {
		this.reserveFour = reserveFour;
	}

	public void setReserveOne(String reserveOne) {
		this.reserveOne = reserveOne;
	}

	public MetaObjectType getMetaObjectType() {
		return metaObjectType;
	}

	public void setMetaObjectType(MetaObjectType metaObjectType) {
		this.metaObjectType = metaObjectType;
	}

	public int getControlType() {
		return controlType;
	}

	public void setControlType(int controlType) {
		this.controlType = controlType;
	}

	public int getNewColumnIndex() {
		return newColumnIndex;
	}

	/**
	 * 判断是否是列拖拽的差异
	 *
	 * @return
	 */
	public boolean isGridColumnDrag() {
		return StringUtils.isBlank(this.caption) && newColumnIndex >= 0;
	}

	/**
	 * 判断是否存在列拖拽的差异
	 *
	 * @param diffs
	 * @return
	 */
	public static boolean hasGridColumnDrag(List<Diff> diffs) {
		for (Diff diff : diffs) {
			if (diff.isGridColumnDrag()) {
				return true;
			}
		}
		return false;
	}

	/**
	 * 差异所指向的界面上引用的MetaForm对象（注：界面不会引用模板等的MetaForm对象），如果是字典，可能是嵌入的那个MetaForm对象
	 */
	private MetaForm metaForm;
	/**
	 * 数据对象表单
	 */
	private MetaDataObject dataObject;

	public void setMetaForm(MetaForm metaForm) {
		this.metaForm = metaForm;
	}

	/**
	 * 数据对象表单
	 */
	public void setMetaDataObejct(MetaDataObject dataObject) {
		this.dataObject = dataObject;
	}

	public MetaForm getMetaForm() {
		return metaForm;
	}

	public MetaDataObject getDataObject() {
		return dataObject;
	}

	/**
	 * 取差异中所有的MetaForm对象
	 *
	 * @param diffs
	 * @return
	 */
	public static List getMetaForms(List<Diff> diffs) {
		List<MetaForm> metaForms = new ArrayList<MetaForm>();
		for (Diff diff : diffs) {
			MetaForm metaForm = diff.getMetaForm();
			if (metaForm != null && !metaForms.contains(metaForm)) {
				metaForms.add(metaForm);
			}
		}
		return metaForms;
	}

	public boolean isPropertyDiff() {
		return isPropertyDiff;
	}

	public String getFilePath() {
		return filePath;
	}

	public void setFilePath(String filePath) {
		this.filePath = filePath;
	}

	public String getNewXml() {
		return newXml;
	}

	public void setXmlDiff(XmlTreeWithPath xmlTree, int startLine, String orgXmlFragment, String newXmlFragment) {
		if (this.xmlTree != null && this.xmlTree != xmlTree) {
			throw new RuntimeException("Web设计器处理差异的文件出错，请联系开发人员。");
		}
		this.xmlTree = xmlTree;
		this.startLine = startLine;
		this.orgXmlFragment = orgXmlFragment;
		this.newXmlFragment = newXmlFragment;
		if (orgXmlFragment.length() == 0 && newXmlFragment.length() == 0) {
			this.xmlTree = null; // 表示没有变化
		}
	}

	public void setXmlTree(XmlTreeWithPath xmlTree) {
		this.xmlTree = xmlTree;
	}

	public int getStartLine() {
		return startLine;
	}

	public String getOrgXmlFragment() {
		return orgXmlFragment;
	}

	public String getNewXmlFragment() {
		return newXmlFragment;
	}

	public void setXmlDiff2(XmlTreeWithPath xmlTree, int startLine, String orgXmlFragment, String newXmlFragment) {
		this.xmlTree2 = xmlTree;
		this.startLine2 = startLine;
		this.orgXmlFragment2 = orgXmlFragment;
		this.newXmlFragment2 = newXmlFragment;
	}

	public XmlTreeWithPath getXmlTree2() {
		return xmlTree2;
	}

	public int getStartLine2() {
		return startLine2;
	}

	public String getOrgXmlFragment2() {
		return orgXmlFragment2;
	}

	public String getNewXmlFragment2() {
		return newXmlFragment2;
	}

	public XmlTreeWithPath getXmlTree() {
		return xmlTree;
	}

	/**
	 * 取差异原始的Key，考虑Key被修改的情况
	 *
	 * @return
	 */
	public String getOrgKey() {
		String result = key;
		for (DiffProperty diffProperty : properties) {
			if (diffProperty.property == Property.key) {
				result = diffProperty.getOrgValue();
				break;
			}
		}
		return result;
	}

	public JSONObject toJson() {
		JSONObject json = new JSONObject();
		json.put("formKey", formKey);
		json.put("metaObjectType", metaObjectType.name);
		json.put("controlType", ControlType.toString(controlType));
		if (properties.size() > 0) {
			JSONArray ps = new JSONArray();
			for (DiffProperty property : properties) {
				ps.put(property.toJson());
			}
			json.put("properties", ps);
		}
		return json;
	}

	public void setIsButtonQuote(Boolean ISButtonQuote) {
		this.isButtonQuote = ISButtonQuote;
	}

	public Boolean getIsButtonQuote() {
		return isButtonQuote;
	}

	public static Diff fromJson(JSONObject json) throws Throwable {
		Diff result = new Diff(json.getString("sequence").trim(), json.getString("formKey").trim(), json.getBoolean("isPropertyDiff"));
		String sObjectType = !json.isNull("metaObjectType") ? json.getString("metaObjectType").trim() : null;
		String paramsformKey = !json.isNull("paramsformKey") ? json.getString("paramsformKey").trim() : null;
		String key = json.isNull("key") ? null : json.getString("key").trim();
		String dictType = json.isNull("DictType") ? null : json.getString("DictType").trim();
		String containerKey = json.isNull("ContainerKey") ? null : json.getString("ContainerKey").trim();
		String reserveOne = json.isNull("reserveOne") ? null : json.getString("reserveOne").trim();
		String reserveTwo = json.isNull("reserveTwo") ? null : json.getString("reserveTwo").trim();
		String reserveThree = json.isNull("reserveThree") ? null : json.getString("reserveThree").trim();
		String reserveFour = json.isNull("reserveFour") ? null : json.getString("reserveFour").trim();
		String create = json.isNull("create") ? null : json.getString("create").trim();
		Boolean trueOrfalse = json.isNull("trueOrfalse") ? null : json.getBoolean("trueOrfalse");
		Boolean isD_ButtonQuote = json.isNull("ISButtonQuote") ? null : json.getBoolean("ISButtonQuote");
		Boolean isEmbed = json.isNull("IsEmbed") ? null : json.getBoolean("IsEmbed");
		String Itemkey = json.isNull("itemkey") ? null : json.getString("itemkey").trim();
		String dataElementKey = json.isNull("dataElementKey") ? null : json.getString("dataElementKey").trim();
		result.setIsButtonQuote(isD_ButtonQuote);
		result.setCreate(create);
		result.setEmbed(isEmbed);
		result.setKey(key);
		result.setDictType(dictType);
		result.setContainerKey(containerKey);
		result.setContainerKey(null);
		result.setReserveOne(reserveOne);
		result.setReserveTwo(reserveTwo);
		result.setTrueOrfalse(trueOrfalse);
		result.setReserveThree(reserveThree);
		result.setReserveFour(reserveFour);
		result.setDataElementKey(dataElementKey);
		result.setItemKey(Itemkey);
		result.setParamsformKey(paramsformKey);
		try {
			result.parentKey = json.getString("parentKey").trim();
		} catch (Exception e) {

		}

		if ((MetaObjectType.TabItem.name).equals(sObjectType)) {
			if (!json.isNull("insertItemAfter")) {
				result.insertItemAfter = json.getBoolean("insertItemAfter");
			}
			if (!json.isNull("moveItemAfter")) {
				result.moveItemAfter = json.getBoolean("moveItemAfter");
			}
			if (!json.isNull("moveItemFront")) {
				result.moveItemFront = json.getBoolean("moveItemFront");
			}
		}
		
		result.setMetaObjectType(StringUtils.isBlank(sObjectType) ? null : MetaObjectType.getMetaObjectType(sObjectType));
		String sCaption = !json.isNull("caption") ? json.getString("caption").trim() : null;
		boolean isNewComponent = StringUtils.isNotEmpty(sCaption); //新增控件
		if (isNewComponent) { //新增
			result.caption = sCaption;
			result.parentKey = json.optString("parentKey").trim();
			result.sideKey = json.optString("sideKey").trim();
			if (!json.isNull(ConstantUtil.x) && !json.isNull(ConstantUtil.y)) { //网格里的组件新增
				result.x = json.getInt(ConstantUtil.x);
				result.y = json.getInt(ConstantUtil.y);
			}

			if (sObjectType.equals(MetaObjectType.gridField.name) || sObjectType.equals(MetaObjectType.GridFieldRow.name) || sObjectType.equalsIgnoreCase(MetaObjectType.ListViewColumn.name)) {//表格列
				result.insertAfter = json.getBoolean("insertAfter");
			} else {
				result.insertAfter = json.optBoolean("insertAfter", false);
			}
			if (!json.isNull("bindingGridKey")) { //新增子明细  关联表格标识
					result.bindingGridKey = json.get("bindingGridKey").toString().trim();
			}
			if (!json.isNull("associatedTable")) { //新增表格 关联表
				Map<Integer, String> associatedTableMap = DesignActionUtil.associatedTableMap;
				if (associatedTableMap.size() > 0) {
					result.associatedTable = associatedTableMap.get(Integer.valueOf(json.get("associatedTable").toString().trim()));
				}
				if(!json.isNull("cellList")){ //新增表格 表格列
					result.cellList = json.isNull("cellList") ? null : json.getString("cellList");
				}
			}
			if (!json.isNull("subAssociatedTable")) { //新增subdetail+表格    关联表
				Map<Integer, String> associatedTableMap = DesignActionUtil.associatedTableMap;
				if (associatedTableMap.size() > 0) {
					result.subAssociatedTable = associatedTableMap.get(Integer.valueOf(json.get("subAssociatedTable").toString().trim()));
				}
			}
		}
		if (!json.isNull("newColumnIndex")) {
			result.newColumnIndex = json.getInt("newColumnIndex");
		}
		if (!json.isNull("isDelete") && json.getBoolean("isDelete")) { //（删除）
			result.isDelete = json.getBoolean("isDelete");
			if (!json.isNull("parentKey")) {
				result.parentKey = json.getString("parentKey").trim();
			}
		}
		if (!json.isNull("isMultyDelete") && json.getBoolean("isMultyDelete")){ //多选删除
			result.isMultyDelete = json.getBoolean("isMultyDelete");
			if (!json.isNull("parentKey")) {
				result.parentKey = json.getString("parentKey").trim();
			}
		}
		if (!json.isNull("isMultyMove") && json.getBoolean("isMultyMove")){ //多选移动
			result.isMultyMove = json.getBoolean("isMultyMove");
			if (!json.isNull("parentKey")) {
				result.parentKey = json.getString("parentKey").trim();
			}
		}
		if (!json.isNull("controlType")) {
			result.controlType = ControlType.parse(json.getString("controlType"));
			if (result.controlType == -1 && json.getString("metaObjectType").equals(MetaObjectType.GridFieldRow.name) && StringUtils.isNotEmpty(json.getString("controlType"))) {
				result.controlType = Integer.parseInt(json.getString("controlType"));
			}
		}
		if (!json.isNull("properties")) {//目前只有修改用到了properties属性
			JSONArray ps = json.getJSONArray("properties");
			for (int i = 0, len = ps.length(); i < len; i++) {
				DiffProperty property = DiffProperty.fromJson(ps.getJSONObject(i));
				result.properties.add(property);
				DesignerContext.addProperty(property);
			}
		}
		if (!json.isNull("filePath")) {
			String filePath = json.getString("filePath").trim();
			filePath = FilePathHelper.toBackFilePath(filePath);
			result.setFilePath(filePath);
		}
		if (!json.isNull("tableName")) {
			result.tableName = json.isNull("tableName") ? null : json.getString("tableName").trim();
		}
		if (!json.isNull("tableKey")) {
			result.tableKey = json.isNull("tableKey") ? null : json.getString("tableKey").trim();
			if (!"".equals(result.tableKey) && result.tableKey != null) {
				result.associatedTable = result.tableKey;
			}
		}
		if (!json.isNull("addDirection")) {
			result.addDirection = json.isNull("addDirection") ? null : json.getString("addDirection").trim();
		}
		if (!json.isNull("deleteDirection")) {
			result.deleteDirection = json.isNull("deleteDirection") ? null : json.getString("deleteDirection").trim();
		}

		if (!json.isNull(ConstantUtil.x) && !json.isNull(ConstantUtil.y)) { //网格里的组件新增
			result.x = json.getInt(ConstantUtil.x);
			result.y = json.getInt(ConstantUtil.y);
		}
		if (!json.isNull("subTableKey")) {
			result.subTableKey = json.isNull("subTableKey") ? null : json.getString("subTableKey").trim();
			if (!"".equals(result.subTableKey) && result.subTableKey != null) {
				result.subAssociatedTable = result.subTableKey;
			}
		}
		if (!json.isNull("subTableName")) {
			result.subTableName = json.isNull("subTableName") ? null : json.getString("subTableName").trim();
		}
		if (!result.isPropertyDiff) {
			result.newXml = json.optString("newXml");
		}
		return result;
	}

	@Override
	public String toString() {
		StringBuilder result = new StringBuilder().append("formKey:").append(formKey).append(" metaObjectType:").append(metaObjectType).append(" controlType:")
				.append(ControlType.toString(controlType)).append("[");
		for (int i = 0, len = properties.size(); i < len; i++) {
			if (i != 0) {
				result.append(", ");
			}
			result.append(properties.get(i));
		}
		return result.append("]").toString();
	}

	public static void loadXmlTree(Diff diff) throws Throwable {
		String filePath = diff.getFilePath();
		String realFormKey = diff.formKey;
		if (StringUtils.isEmpty(filePath)) {
			filePath = LoadFileTree.getPathByFormKey(realFormKey);
			diff.setFilePath(filePath);
		}
		MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(realFormKey);
		diff.setMetaForm(metaForm);
		XmlTreeWithPath orgTree = XmlTreeWithPath.parseFilePath(filePath);
		diff.setXmlTree(orgTree);
		String filePathVest = ""; //马甲路径
		if (StringUtils.isNotEmpty(metaForm.getExtend())) {
			filePathVest = LoadFileTree.getPathByFormKey(diff.getMetaForm().getExtend());
			XmlTreeWithPath vestOrgTree = XmlTreeWithPath.parseFilePath(filePathVest);
			diff.setVestXmlTree(vestOrgTree);
		}
		String dataObjectFilePath = null;//数据对象源文件地址
		MetaDataSource dataSource = metaForm.getDataSource();
		if (Objects.nonNull(dataSource)) {
			String refObjectKey = dataSource.getRefObjectKey();
			if (StringUtils.isNotBlank(refObjectKey)) {
				dataObjectFilePath = LoadFileTree.getPathByDataObject(refObjectKey);
				diff.setDataObjectfilePath(dataObjectFilePath);
				XmlTreeWithPath dataObjectOrgTree = XmlTreeWithPath.parseFilePath(dataObjectFilePath);
				diff.setDataObjectXmlTree(dataObjectOrgTree);
				MetaDataObject dataObject = MetaFactory.getGlobalInstance().getDataObject(refObjectKey);
				String mergeToSourceMapKey = dataObject.getMergeToSourceMapKey();
				if (StringUtils.isNotEmpty(mergeToSourceMapKey)) {
					XmlTreeWithPath otherDataObjectOrgTree = XmlTreeWithPath.parseFilePath(LoadFileTree.getPathByDataObject(mergeToSourceMapKey));
					diff.setOtherDataObjectOrgTree(otherDataObjectOrgTree);
				}
			}
		}
		XmlTreeWithPath defaultOrgTree = XmlTreeWithPath.parseFilePathNotLoadTmp(filePath);//默认时
		diff.setDefaultxmlTree(defaultOrgTree);
	}
	public String getSequence() {
		return sequence;
	}
}
