package com.bokesoft.erp.webdesigner.service.datamap;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bokesoft.erp.entity.util.EntityDesigerContextAction;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.datamap.util.DataMapOperJsonUtil;
import com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.utils.IDLookup;
import com.bokesoft.yes.design.utils.TwoTuple;
import com.bokesoft.yes.design.utils.publicMethodUtil;
import com.bokesoft.yes.erp.config.MetaFormNODBProcess;
import com.bokesoft.yes.erpdatamap.ERPMetaMap;
import com.bokesoft.yes.mid.cmd.richdocument.strut.ComboxStringBuilder;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.*;
import org.dom4j.io.SAXReader;

import java.io.File;
import java.util.*;

public class DataMapFunction extends EntityDesigerContextAction {
    public DataMapFunction(RichDocumentContext _context) {
        super(_context);
    }

    /**
     * 数据映射获取所有字段
     *
     * @return
     * @throws DocumentException
     */
    public String dataMapGetAllFields() throws Throwable {

        final String xml = (String) this._context.getPara("XML");
        Element element = DocumentHelper.parseText(xml).getRootElement();
        JSONObject resJson = new JSONObject();
        String extend = element.attributeValue(ConstantUtil.EXTEND);
        String srcFormKey = "";
        String tgtFormKey = "";
        String srcDataObjectKey = "";
        String tgtDataObjectKey = "";
        if(StringUtils.isEmpty(extend)){
            srcFormKey = element.attributeValue(ConstantUtil.SRC_FORM_KEY);
            tgtFormKey = element.attributeValue(ConstantUtil.TGT_FORM_KEY);
            srcDataObjectKey = element.attributeValue(ConstantUtil.SRC_DATA_OBJECT_KEY);
            tgtDataObjectKey = element.attributeValue(ConstantUtil.TGT_DATA_OBJECT_KEY);
        }else {
           /* String filePath = LoadFileTree.getDataMapPathByKey(extend);
            SAXReader reader = new SAXReader();
            // 加载文档
            Document document = reader.read(new File(filePath));
            // 获取根节点
            Element root = document.getRootElement();
            srcFormKey = root.attributeValue(ConstantUtil.SRC_FORM_KEY);
            tgtFormKey = root.attributeValue(ConstantUtil.TGT_FORM_KEY);
            srcDataObjectKey = root.attributeValue(ConstantUtil.SRC_DATA_OBJECT_KEY);
            tgtDataObjectKey = root.attributeValue(ConstantUtil.TGT_DATA_OBJECT_KEY);*/

            List<KeyPairMetaObject> customList = MetaFactory.getGlobalInstance().getCustomList();
            for (KeyPairMetaObject erpMetaMap : customList) {
                if (erpMetaMap instanceof ERPMetaMap) {
                    if (StringUtils.equals(erpMetaMap.getKey(), extend)) {
                        srcFormKey = ((ERPMetaMap) erpMetaMap).getSrcFormKey();
                        tgtFormKey = ((ERPMetaMap) erpMetaMap).getTgtFormKey();
                        srcDataObjectKey = ((ERPMetaMap) erpMetaMap).getSrcDataObjectKey();
                        tgtDataObjectKey = ((ERPMetaMap) erpMetaMap).getTgtDataObjectKey();
                        break;
                    }
                }
            }
        }
        String mergeToSource = element.attributeValue("MergeToSource");
        boolean isFilter = StringUtils.isNotEmpty(extend) && StringUtils.isNotEmpty(mergeToSource);

        JSONObject srcTableJS = dealDataSourceFiled(srcFormKey,isFilter,extend);
        resJson.put("srcitems", srcTableJS);
        JSONObject targetTableJS = dealDataSourceFiled(tgtFormKey,isFilter,extend);
        resJson.put("taritems", targetTableJS);


        List<String> feedBackList = getFeedBackFormKeys(element);
        JSONArray array = new JSONArray();
        for (int i = 0; i < feedBackList.size(); i++) {
            JSONObject feedBackJson = dealDataSourceFiled(feedBackList.get(i),isFilter,extend);
            array.add(feedBackJson);
        }
        resJson.put("feedbackItems", array);
        resJson.put(ConstantUtil.SRC_FORM_KEY, srcFormKey);
        resJson.put(ConstantUtil.TGT_FORM_KEY, tgtFormKey);
        resJson.put(ConstantUtil.SRC_DATA_OBJECT_KEY, srcDataObjectKey);
        resJson.put(ConstantUtil.TGT_DATA_OBJECT_KEY, tgtDataObjectKey);
        return resJson.toString();
    }

    private List<String> getFeedBackFormKeys(Element root) {
        List<String> feedBackKeyList = new ArrayList<>();
        Node feedbackCollection = root.selectSingleNode("FeedbackCollection");
        if (Objects.isNull(feedbackCollection)) {
            return feedBackKeyList;
        }
        List<Node> feedbackObjectList = feedbackCollection.selectNodes("FeedbackObject");
        for (int i = 0; i < feedbackObjectList.size(); i++) {
            Element element = (Element) feedbackObjectList.get(i);
            String formKey = element.attributeValue(ConstantUtil.FORM_KEY);
            if(StringUtils.isBlank(formKey)){
                continue;
            }
            feedBackKeyList.add(formKey);
        }
        return feedBackKeyList;
    }

    /**
     * @param formKey
     */
    public JSONObject dealDataSourceFiled(String formKey,Boolean isFilter,String extend) throws Throwable {
        String key = "";
        String caption = "";
        JSONObject tableJS = new JSONObject();
        TwoTuple<MetaForm, MetaDataObject> metaFormOrMetaDataObject = publicMethodUtil.MetaFormOrMetaDataObject(formKey);
        MetaForm metaForm = metaFormOrMetaDataObject.metaForm;
        MetaDataObject metaDataObject = metaFormOrMetaDataObject.metaDataObject;
        MetaForm metaForm1 = MetaFactory.getGlobalInstance().getMetaForm(formKey);
        IDLookup idLookup = IDLookup.getIDLookup(metaForm1);
        MetaTableCollection tableCollection = DataMapUtil.getTableCollection(formKey);

        if (metaForm != null) {//表单
            tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
            key = metaForm.getKey();
            caption = metaForm.getCaption();
        } else if (metaDataObject != null) {//数据对象表单
            tableCollection = metaDataObject.getTableCollection();
            key = metaForm.getKey();
            caption = metaForm.getCaption();
        }

        // 添加数据对象信息
        JSONObject dataObjectJS = new JSONObject();
        dataObjectJS.put("Key", key);
        dataObjectJS.put("Caption", caption);
        tableJS.put(key, dataObjectJS);
        if (Objects.isNull(tableCollection)) {
            return tableJS;
        }

        for (MetaTable metaTable : tableCollection) {
            String finalTable = metaTable.getKey();
            Map<String, List<String>> columKeysAndFieldKeys = idLookup.getColumKeysAndFieldListKeys(finalTable);
            for (MetaColumn metaColumn : metaTable) {
                // 添加字段信息
                List<String> fieldKeys = new ArrayList<>();
                if(columKeysAndFieldKeys != null) {
                    fieldKeys = columKeysAndFieldKeys.get(metaColumn.getKey());
                }
                if (CollectionUtils.isEmpty(fieldKeys)){
                    continue;
                }
                String fieldKey = null;
                if (fieldKeys != null && fieldKeys.size() > 0) {
                    fieldKey = fieldKeys.get(0);
                }
                fieldKey = StringUtils.isBlank(fieldKey) ? metaColumn.getKey() : fieldKey;
                if(isFilter){
                    Map<String, String> map =
                            DataMapOperXmlUtil.filterFiledMap(extend, metaForm1);
                    if (!map.containsValue(fieldKey)) {
                        setArray(tableCollection.indexOf(metaTable) + 1, tableJS, fieldKey, metaColumn,metaForm);
                    }
                }else {
                    setArray(tableCollection.indexOf(metaTable) + 1, tableJS, fieldKey, metaColumn,metaForm);
                }
            }
            // 添加表信息
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("Key", metaTable.getKey());
            jsonObject.put("Caption", metaTable.getCaption());
            jsonObject.put("index", String.valueOf(tableCollection.indexOf(metaTable) + 1));
            tableJS.put(metaTable.getKey(), jsonObject);
        }
        return tableJS;
    }


    public void setArray(int index, JSONObject nodesJsonArray, String fieldKey, MetaColumn metaColumn,MetaForm metaForm) throws Throwable {
        IDLookup idLookup = IDLookup.reloadIDLookup(metaForm);
        String caption = metaColumn.getCaption();
        if (caption.isEmpty()){
            MetaGridCell gridCellByKey = idLookup.getGridCellByKey(fieldKey);
            if (gridCellByKey == null) {
                try {
                    caption = idLookup.getComponentByKey(fieldKey).getCaption();
                } catch (Exception e){
                }
            } else {
                caption = gridCellByKey.getCaption();
            }
        }
        JSONObject nodeJsonObj = new JSONObject();
        nodeJsonObj.put(ConstantUtil.KEY, fieldKey);
        nodeJsonObj.put(ConstantUtil.CAPTION, caption);
        nodeJsonObj.put("DataType", metaColumn.getDataType());
        nodeJsonObj.put("index", index);
        nodesJsonArray.put((String) nodeJsonObj.get(ConstantUtil.KEY), nodeJsonObj);
    }

    /**
     * 获得某个数据源的ColumnKey和组件的key (maybe,根据结果)
     *
     * @param idLookup
     * @param tableKey
     * @param columnKey
     * @return
     */
    public static String getComponentKey(IDLookup idLookup, String tableKey, String columnKey) {

        Map<String, List<String>> columKeysAndFieldKeys = idLookup.getColumKeysAndFieldListKeys(tableKey);
        List<String> fieldKeys = columKeysAndFieldKeys.get(columnKey);
        String key = null;
        if (fieldKeys != null && fieldKeys.size() > 0) {
            key = fieldKeys.get(0);
        }
        return StringUtils.isBlank(key) ? columnKey : key;
    }

    /**
     * 返回表单内所有数据对象中的column
     *
     * @param formKey
     * @return
     */
    public String getFormAllField(String formKey, String type,String condition) throws Throwable {
        ComboxStringBuilder csb = ComboxStringBuilder.newInstance();
        if (StringUtils.isBlank(formKey)) {
            return csb.toString();
        }
        MetaForm metaForm1 = MetaFactory.getGlobalInstance().getMetaForm(formKey);
        IDLookup idLookup = IDLookup.getIDLookup(metaForm1);
        MetaTableCollection tableCollection = DataMapUtil.getTableCollection(formKey);
        if (Objects.isNull(tableCollection)) {
            return "";
        }
        for (MetaTable metaTable : tableCollection) {
            if (metaTable.getKey().contains(MetaFormNODBProcess.STR_NODBTable_Profix)) {
                continue;
            }
            DataMapUtil.getComboxValues(metaTable, tableCollection, idLookup, condition, csb,type);
        }
        return csb.toString();
    }


    /**
     * @param formKey
     * @param tableKey
     * @return
     * @throws Throwable
     */
    public String getTableFields(String formKey, String tableKey, String type, String condition) throws Throwable {
        ComboxStringBuilder csb = ComboxStringBuilder.newInstance();
        if (StringUtils.isBlank(formKey)) {
            return csb.toString();
        }
        MetaForm metaForm1 = MetaFactory.getGlobalInstance().getMetaForm(formKey);
        MetaTableCollection tableCollection = DataMapUtil.getTableCollection(formKey);
        IDLookup idLookup = IDLookup.getIDLookup(metaForm1);
        if (Objects.isNull(tableCollection)) {
            return "";
        }
        for (MetaTable metaTable : tableCollection) {
            if (metaTable.getKey().contains(MetaFormNODBProcess.STR_NODBTable_Profix) || !tableKey.equals(metaTable.getKey())) {
                continue;
            }
            DataMapUtil.getComboxValues(metaTable, tableCollection, idLookup, condition, csb,type);
        }
        return csb.toString();
    }

    /**
     * @param formKey
     * @param tableKey
     * @return
     * @throws Throwable
     */
    public String getRefField(String formKey, String tableKey) throws Throwable {
        ComboxStringBuilder csb = ComboxStringBuilder.newInstance();
        if (StringUtils.isBlank(formKey)) {
            return csb.toString();
        }
        MetaForm metaForm1 = MetaFactory.getGlobalInstance().getMetaForm(formKey);
        MetaTableCollection tableCollection = DataMapUtil.getTableCollection(formKey);
        IDLookup idLookup = IDLookup.getIDLookup(metaForm1);
        if (Objects.isNull(tableCollection)) {
            return "";
        }
        for (MetaTable metaTable : tableCollection) {
            if (metaTable.getKey().contains(MetaFormNODBProcess.STR_NODBTable_Profix) || !tableKey.equals(metaTable.getKey())) {
                continue;
            }
            String finalTable = metaTable.getKey();
            Map<String, List<String>> columKeysAndFieldKeys = idLookup.getColumKeysAndFieldListKeys(finalTable);
            for (MetaColumn metaColumn : metaTable) {
                if (metaColumn.getKey().contains(MetaFormNODBProcess.STR_NODBTable_Profix)) {
                    continue;
                }
                int index = tableCollection.indexOf(metaTable) + 1;
                // 添加字段信息
                List<String> fieldKeys = columKeysAndFieldKeys.get(metaColumn.getKey());
                if (CollectionUtils.isEmpty(fieldKeys)) {
                    continue;
                }
                String fieldKey = null;
                if (fieldKeys != null && fieldKeys.size() > 0) {
                    fieldKey = fieldKeys.get(0);
                }
                fieldKey = StringUtils.isBlank(fieldKey) ? metaColumn.getKey() : fieldKey;
                String value = fieldKey;
                String caption = "表(" + index + ")" + fieldKey + " " + metaColumn.getCaption();
                csb.addItem(value, caption);
            }
        }
        return csb.toString();
    }

    /**
     * @param formKey
     * @param tableKey
     * @return
     * @throws Throwable
     */
    public String getTableCaption(String formKey, String tableKey) throws Throwable {
        IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
        MetaForm metaForm = globalInstance.getMetaForm(formKey);
        MetaDataObject dataObject = metaForm.getDataSource().getDataObject();
        MetaTable table = dataObject.getTable(tableKey);
        if (Objects.isNull(table)) {
            return metaForm.getCaption();
        }
        return table.getCaption();
    }

    public MetaColumn getMetaColumn(String formKey, String tableKey, String fieldKey) throws Throwable {
        MetaForm metaForm1 = MetaFactory.getGlobalInstance().getMetaForm(formKey);
        MetaTableCollection tableCollection = DataMapUtil.getTableCollection(formKey);
        IDLookup idLookup = IDLookup.getIDLookup(metaForm1);
        for (MetaTable metaTable : tableCollection) {
            if(!metaTable.getKey().equals(tableKey) &&!metaTable.getKey().equals(tableKey+MetaFormNODBProcess.STR_NODBTable_Profix)) {
                continue;
            }
            Map<String, List<String>> columKeysAndFieldKeys = idLookup.getColumKeysAndFieldListKeys(metaTable.getKey());
            for (MetaColumn metaColumn : metaTable) {
                List<String> fieldKeys = columKeysAndFieldKeys.get(metaColumn.getKey());
                if (CollectionUtils.isEmpty(fieldKeys)) {
                    continue;
                }
                String findFieldKey = null;
                if (fieldKeys != null && fieldKeys.size() > 0) {
                    findFieldKey = fieldKeys.get(0);
                }
                findFieldKey = StringUtils.isBlank(findFieldKey) ? metaColumn.getKey() : findFieldKey;
                if(fieldKey.equals(findFieldKey)){
                    return metaColumn;
                }
            }

        }
        return null;
    }

    public String getDataType(String formKey, String tableKey, String fieldKey) throws Throwable {
        MetaColumn metaColumn = getMetaColumn(formKey, tableKey, fieldKey);
        String value = Objects.isNull(metaColumn) ? "未定义" : DataType.toString(metaColumn.getDataType());
        return value;
    }


    public String getCaption(String formKey, String tableKey, String fieldKey) throws Throwable {
        MetaColumn metaColumn = getMetaColumn(formKey, tableKey, fieldKey);
        if (Objects.isNull(metaColumn)){
            return "未定义";
        }
        if (metaColumn.getCaption().isEmpty()){
            IDLookup idLookup = IDLookup.reloadIDLookup(MetaFactory.getGlobalInstance().getMetaForm(formKey));
            String cap = DataMapUtil.getCap(idLookup, metaColumn, fieldKey);
            return  cap;
        }
        return metaColumn.getCaption();
    }

    public static String getFormInfo(String formKey) throws Throwable {
        JSONObject form = new JSONObject();
        MetaForm metaForm = MetaFactory.getGlobalInstance().getMetaForm(formKey);
        form.put(ConstantUtil.KEY, formKey);
        form.put(ConstantUtil.CAPTION, metaForm.getCaption());
        // dataObject
        JSONObject dataObject = new JSONObject();
        dataObject.put(ConstantUtil.KEY, metaForm.getDataSource().getDataObject().getKey());
        form.put(ConstantUtil.DATA_OBJECT, dataObject);
        return form.toJSONString();
    }

    public static String getCaptionByDataObjectKey(String formKey,String dataObjectKey) throws Throwable{
        IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
        MetaForm metaForm = globalInstance.getMetaForm(formKey);
        MetaDataObject dataObject = metaForm.getDataSource().getDataObject();
        if(dataObjectKey.equals(dataObject.getKey())){
            return dataObject.getCaption();
        }
        return "";
    }

    public String getSourceTypeValue(String tableKey) throws Throwable {
        ComboxStringBuilder csb = ComboxStringBuilder.newInstance();
        csb.addItem("default", "默认");
        /**
         * //创建SAX读取器
         * SAXReader reader = new SAXReader();
         * // 加载文档
         * Document document = reader.read(new File(filePath));
         * document.getRootElement()
         */
        final String xml = (String) this._context.getPara("XML");
        Element curRoot = DocumentHelper.parseText(xml).getRootElement();
        String extend = curRoot.attributeValue("Extend");
        if (StringUtils.isNotEmpty(extend)) {//只开启含有mergeToSource属性的
            String linkDataMapPath = LoadFileTree.getDataMapPathByKey(extend);
            Element root = DataMapOperJsonUtil.getElement(linkDataMapPath);
            List<Node> elements = root.selectNodes("/Map/SourceTableCollection/SourceTable[@Key='" + tableKey + "']/SourceField");
            for (Node ele1 : elements) {
                Element ele = (Element) ele1;
                String caption = "";
                String value = "";
                if(StringUtils.isBlank(ele.attributeValue(ConstantUtil.DEFINITION))){
                    caption = ele.attributeValue(ConstantUtil.KEY) + "->" + ele.attributeValue("TargetFieldKey") + "_" + ele.attributeValue(ConstantUtil.KEY);
                    value = ele.attributeValue(ConstantUtil.KEY) + "@" + ele.attributeValue("TargetFieldKey") + "@" + ele.attributeValue(ConstantUtil.KEY);
                }else {
                    caption = ele.attributeValue(ConstantUtil.DEFINITION) + "->" + ele.attributeValue("TargetFieldKey") + "_" + ele.attributeValue(ConstantUtil.KEY);
                    value = ele.attributeValue(ConstantUtil.DEFINITION) + "@" + ele.attributeValue("TargetFieldKey") + "@" + ele.attributeValue(ConstantUtil.KEY);
                }
                csb.addItem(value, caption);
            }
        }
        return csb.toString();
    }

    public String getSourceTypeDefaultValue(String sectionXml) throws Throwable {
        final String xml = (String) this._context.getPara("XML");
        Element curRoot = DocumentHelper.parseText(xml).getRootElement();
        String extend = curRoot.attributeValue("Extend");

        Element ligature  = DocumentHelper.parseText(sectionXml).getRootElement();
        String tableKey = ligature.attributeValue(ConstantUtil.TABLE_KEY);
        Element node = (Element)ligature.selectSingleNode("SourceField");
        String key = node.attributeValue(ConstantUtil.KEY);

        if (StringUtils.isNotEmpty(extend)) {//只开启含有mergeToSource属性的
            String linkDataMapPath = LoadFileTree.getDataMapPathByKey(extend);
            Element root = DataMapOperJsonUtil.getElement(linkDataMapPath);
            Element ele = (Element) root.selectSingleNode("/Map/SourceTableCollection/SourceTable[@Key='" + tableKey + "']/SourceField[@Key='"+ key +"']");
            if (Objects.isNull(ele)) {
                return "default";
            }
            if(StringUtils.isBlank(ele.attributeValue(ConstantUtil.DEFINITION))){
                return ele.attributeValue(ConstantUtil.KEY) + "@" + ele.attributeValue("TargetFieldKey") + "@" + ele.attributeValue(ConstantUtil.KEY);
            }else {
                return ele.attributeValue(ConstantUtil.DEFINITION) + "@" + ele.attributeValue("TargetFieldKey") + "@" + ele.attributeValue(ConstantUtil.KEY);
            }
        }
        return "default";
    }

    public Map<String, ArrayList> getExtendDataMapLinks(String extend) throws Throwable{
        String path = LoadFileTree.getDataMapPathByKey(extend);
        Map<String, ArrayList> links = new HashMap<String, ArrayList>();
        SAXReader reader = new SAXReader();
        // 加载文档
        Document document = reader.read(new File(path));
        // 获取根节点
        Element root = document.getRootElement();
        links.put("sourceToTarget",getSourceToTargetLinks(root));
        //返回Type为SERVICE的sourceTable
        links.put("serviceSourceTable", getServiceSourceTable(root));
        Element feedbackTables = root.element(ConstantUtil.FEEDBACK_COLLECTION);
        if(Objects.isNull(feedbackTables)) {
            return links;
        }
        links.put("targetToFeedback",getTargetToFeedbackLinks(root));
        return links;
    }

    public ArrayList<String> getTargetToFeedbackLinks(Element root) throws Throwable{
        Element targetTables = root.element(ConstantUtil.TARGET_TABLE_COLLECTION);
        List<Element> targetTableElements = targetTables.elements(ConstantUtil.TARGET_TABLE);
        ArrayList<String> targetToFeedbackList = new ArrayList<>();
        for (Element tableElement: targetTableElements){
            String targetTableKey = tableElement.attributeValue(ConstantUtil.KEY);
            List<Element> fieldElements = tableElement.elements(ConstantUtil.TARGET_FIELD);
            for (Element fieldElement: fieldElements){
                List<Element> elements = fieldElement.elements(ConstantUtil.FEEDBACK);
                String fieldKey = fieldElement.attributeValue(ConstantUtil.DEFINITION);
                for (Element element: elements){
                    String feedDataObjectKey = element.attributeValue(ConstantUtil.Feed_DATA_OBJECT_KEY);
                    String feedTableKey = element.attributeValue(ConstantUtil.TABLE_KEY);
                    String feedFieldKey = element.attributeValue(ConstantUtil.FIELD_KEY);
                    String link = targetTableKey + "*" + fieldKey + "--" + feedDataObjectKey + "*" + feedTableKey + "*" + feedFieldKey;
                    targetToFeedbackList.add(link);
                }
            }
        }
        return targetToFeedbackList;
    }

    public ArrayList<String> getServiceSourceTable(Element root) throws Throwable{
        Element sourceTables = root.element(ConstantUtil.SOURCE_TABLE_COLLECTION);
        List<Element> tableElements = sourceTables.elements(ConstantUtil.SOURCE_TABLE);
        ArrayList<String> serviceSourceTableList = new ArrayList<>();
        for (Element tableElement: tableElements){
            if(StringUtils.equals(tableElement.attributeValue(ConstantUtil.TYPE), ConstantUtil.SERVICE)){
                String sourceTableKey = tableElement.attributeValue(ConstantUtil.KEY);
                serviceSourceTableList.add(sourceTableKey);
            }
        }
        return serviceSourceTableList;
    }

    public ArrayList<String> getSourceToTargetLinks(Element root) throws Throwable{
        Element sourceTables = root.element(ConstantUtil.SOURCE_TABLE_COLLECTION);
        List<Element> tableElements = sourceTables.elements(ConstantUtil.SOURCE_TABLE);
        ArrayList<String> sourceToTargetList = new ArrayList<>();
        for (Element tableElement: tableElements){
            String sourceTableKey = tableElement.attributeValue(ConstantUtil.KEY);
            List<Element> fieldElements = tableElement.elements(ConstantUtil.SOURCE_FIELD);
            for (Element fieldElement: fieldElements){
                if(StringUtils.isEmpty(fieldElement.attributeValue(ConstantUtil.TARGET_FIELD_KEY))) {
                    continue;
                }
                String fieldKey = "";
                if(StringUtils.isEmpty(fieldElement.attributeValue(ConstantUtil.DEFINITION))){
                    fieldKey = fieldElement.attributeValue(ConstantUtil.KEY);
                }else{
                    fieldKey = fieldElement.attributeValue(ConstantUtil.DEFINITION);
                }
                String targetTableKey = fieldElement.attributeValue(ConstantUtil.TARGET_TABLE_KEY);
                String targetFieldKey = fieldElement.attributeValue(ConstantUtil.TARGET_FIELD_KEY);
                String link = sourceTableKey + "*" + fieldKey + "--" + targetTableKey + "*" + targetFieldKey;
                sourceToTargetList.add(link);
            }
        }
        return sourceToTargetList;
    }

    public ArrayList<String> getExtendDataMigrationLinks(String extend) throws Throwable{
        String path = LoadFileTree.getDataMigrationPathByKey(extend);
        SAXReader reader = new SAXReader();
        // 加载文档
        Document document = reader.read(new File(path));
        // 获取根节点
        Element root = document.getRootElement();
        Element sourceTables = root.element(ConstantUtil.SOURCE_TABLE_COLLECTION);
        List<Element> tableElements = sourceTables.elements(ConstantUtil.SOURCE_TABLE);
        ArrayList<String> sourceToTargetList = new ArrayList<>();
        for (Element tableElement: tableElements){
            String sourceTableKey = tableElement.attributeValue(ConstantUtil.KEY);
            List<Element> fieldElements = tableElement.elements(ConstantUtil.SOURCE_FIELD);
            for (Element fieldElement: fieldElements){
                if(StringUtils.isEmpty(fieldElement.attributeValue(ConstantUtil.TARGET_FIELD_KEY))) {
                    continue;
                }
                String fieldKey = "";
                if(StringUtils.isEmpty(fieldElement.attributeValue(ConstantUtil.DEFINITION))){
                    fieldKey = fieldElement.attributeValue(ConstantUtil.KEY);
                }else{
                    fieldKey = fieldElement.attributeValue(ConstantUtil.DEFINITION);
                }
                String targetTableKey = fieldElement.attributeValue(ConstantUtil.TARGET_TABLE_KEY);
                String targetFieldKey = fieldElement.attributeValue(ConstantUtil.TARGET_FIELD_KEY);
                String link = sourceTableKey + "*" + fieldKey + "--" + targetTableKey + "*" + targetFieldKey;
                sourceToTargetList.add(link);
            }
        }
        return sourceToTargetList;
    }

    public boolean getTargetTableKeyEnable(String xml){
        return false;
    }

    public String getTargetTableKey(String xml, String tableKey) throws Throwable{
        Element root = DocumentHelper.parseText(xml).getRootElement();
        String extend = root.attributeValue(ConstantUtil.EXTEND);
        if(StringUtils.isEmpty(extend)){
            Element ele = (Element) root.selectSingleNode("/Map/SourceTableCollection/SourceTable[@Key='" + tableKey + "']");
            return ele.attributeValue(ConstantUtil.TARGET_TABLE_KEY,"");
        }else{
            String filePath = LoadFileTree.getDataMapPathByKey(extend);
            SAXReader reader = new SAXReader();
            // 加载文档
            Document document = reader.read(new File(filePath));
            // 获取根节点
            Element extendRoot = document.getRootElement();
            Element tableEle = (Element) extendRoot.selectSingleNode("/Map/SourceTableCollection/SourceTable[@Key='" + tableKey + "']");
            return tableEle.attributeValue(ConstantUtil.TARGET_TABLE_KEY,"");
        }
    }

    public boolean testMapConditionFalse(){
        return false;
    }

    public boolean testMapConditionTrue(){
        return true;
    }


}
